require "Wherigo"
ZonePoint = Wherigo.ZonePoint
Distance = Wherigo.Distance
Player = Wherigo.Player

-- String decode --
function _O7OD(str)
	local res = ""
    local dtable = "\113\044\008\027\039\041\107\030\125\102\115\120\106\022\003\000\067\080\034\062\074\020\061\088\043\103\071\097\081\017\004\009\040\090\117\037\126\051\024\042\104\082\123\038\007\112\084\011\098\116\028\035\050\014\118\045\049\032\108\048\086\073\052\036\075\055\063\023\010\089\047\002\077\031\072\065\046\056\119\124\111\083\058\076\101\053\025\013\057\021\094\100\114\001\005\096\078\105\070\066\033\093\109\012\016\092\110\095\026\018\019\068\029\091\069\064\006\085\079\087\099\060\121\015\059\122\054"
	for i=1, #str do
        local b = str:byte(i)
        if b > 0 and b <= 0x7F then
	        res = res .. string.char(dtable:byte(b))
        else
            res = res .. string.char(b)
        end
	end
	return res
end

-- Internal functions --
require "table"
require "math"

math.randomseed(os.time())
math.random()
math.random()
math.random()

_Urwigo = {}

_Urwigo.InlineRequireLoaded = {}
_Urwigo.InlineRequireRes = {}
_Urwigo.InlineRequire = function(moduleName)
  local res
  if _Urwigo.InlineRequireLoaded[moduleName] == nil then
    res = _Urwigo.InlineModuleFunc[moduleName]()
    _Urwigo.InlineRequireLoaded[moduleName] = 1
    _Urwigo.InlineRequireRes[moduleName] = res
  else
    res = _Urwigo.InlineRequireRes[moduleName]
  end
  return res
end

_Urwigo.Round = function(num, idp)
  local mult = 10^(idp or 0)
  return math.floor(num * mult + 0.5) / mult
end

_Urwigo.Ceil = function(num, idp)
  local mult = 10^(idp or 0)
  return math.ceil(num * mult) / mult
end

_Urwigo.Floor = function(num, idp)
  local mult = 10^(idp or 0)
  return math.floor(num * mult) / mult
end

_Urwigo.DialogQueue = {}
_Urwigo.RunDialogs = function(callback)
	local dialogs = _Urwigo.DialogQueue
	local lastCallback = nil
	_Urwigo.DialogQueue = {}
	local msgcb = {}
	msgcb = function(action)
		if action ~= nil then
			if lastCallback ~= nil then
				lastCallback(action)
			end
			local entry = table.remove(dialogs, 1)
			if entry ~= nil then
				lastCallback = entry.Callback;
				if entry.Text ~= nil then
					Wherigo.MessageBox({Text = entry.Text, Media=entry.Media, Buttons=entry.Buttons, Callback=msgcb})
				else
					msgcb(action)
				end
			else
				if callback ~= nil then
					callback()
				end
			end
		end
	end
	msgcb(true) -- any non-null argument
end

_Urwigo.MessageBox = function(tbl)
    _Urwigo.RunDialogs(function() Wherigo.MessageBox(tbl) end)
end

_Urwigo.OldDialog = function(tbl)
    _Urwigo.RunDialogs(function() Wherigo.Dialog(tbl) end)
end

_Urwigo.Dialog = function(buffered, tbl, callback)
	for k,v in ipairs(tbl) do
		table.insert(_Urwigo.DialogQueue, v)
	end
	if callback ~= nil then
		table.insert(_Urwigo.DialogQueue, {Callback=callback})
	end
	if not buffered then
		_Urwigo.RunDialogs(nil)
	end
end

_Urwigo.Hash = function(str)
   local b = 378551;
   local a = 63689;
   local hash = 0;
   for i = 1, #str, 1 do
      hash = hash*a+string.byte(str,i);
      hash = math.fmod(hash, 65535)
      a = a*b;
      a = math.fmod(a, 65535)
   end
   return hash;
end

_Urwigo.DaysInMonth = {
	31,
	28,
	31,
	30,
	31,
	30,
	31,
	31,
	30,
	31,
	30,
	31,
}

_Urwigo_Date_IsLeapYear = function(year)
	if year % 400 == 0 then
		return true
	elseif year% 100 == 0 then
		return false
	elseif year % 4 == 0 then
		return true
	else
		return false
	end
end

_Urwigo.Date_DaysInMonth = function(year, month)
	if month ~= 2 then
		return _Urwigo.DaysInMonth[month];
	else
		if _Urwigo_Date_IsLeapYear(year) then
			return 29
		else
			return 28
		end
	end
end

_Urwigo.Date_DayInYear = function(t)
	local res = t.day
	for month = 1, t.month - 1 do
		res = res + _Urwigo.Date_DaysInMonth(t.year, month)
	end
	return res
end

_Urwigo.Date_HourInWeek = function(t)
	return t.hour + (t.wday-1) * 24
end

_Urwigo.Date_HourInMonth = function(t)
	return t.hour + t.day * 24
end

_Urwigo.Date_HourInYear = function(t)
	return t.hour + (_Urwigo.Date_DayInYear(t) - 1) * 24
end

_Urwigo.Date_MinuteInDay = function(t)
	return t.min + t.hour * 60
end

_Urwigo.Date_MinuteInWeek = function(t)
	return t.min + t.hour * 60 + (t.wday-1) * 1440;
end

_Urwigo.Date_MinuteInMonth = function(t)
	return t.min + t.hour * 60 + (t.day-1) * 1440;
end

_Urwigo.Date_MinuteInYear = function(t)
	return t.min + t.hour * 60 + (_Urwigo.Date_DayInYear(t) - 1) * 1440;
end

_Urwigo.Date_SecondInHour = function(t)
	return t.sec + t.min * 60
end

_Urwigo.Date_SecondInDay = function(t)
	return t.sec + t.min * 60 + t.hour * 3600
end

_Urwigo.Date_SecondInWeek = function(t)
	return t.sec + t.min * 60 + t.hour * 3600 + (t.wday-1) * 86400
end

_Urwigo.Date_SecondInMonth = function(t)
	return t.sec + t.min * 60 + t.hour * 3600 + (t.day-1) * 86400
end

_Urwigo.Date_SecondInYear = function(t)
	return t.sec + t.min * 60 + t.hour * 3600 + (_Urwigo.Date_DayInYear(t)-1) * 86400
end


-- Inlined modules --
_Urwigo.InlineModuleFunc = {}

_VNI = Wherigo.ZCartridge()

-- Media --
_qw0 = Wherigo.ZMedia(_VNI)
_qw0.Id = "34b9ecf4-3f69-48e8-837d-8574b123d621"
_qw0.Name = _O7OD("\073\081\107\011\050\085\093\108\018\041\028\011\085\108\027\035\107")
_qw0.Description = ""
_qw0.AltText = ""
_qw0.Resources = {
	{
		Type = "jpg", 
		Filename = "Monster_Phase_Gun.jpg", 
		Directives = {}
	}
}
_9lOe7 = Wherigo.ZMedia(_VNI)
_9lOe7.Id = "1bf8c7c1-6283-47c1-b5fb-1fafae168b98"
_9lOe7.Name = _O7OD("\046\007\085\108\103\085\050\085\093")
_9lOe7.Description = ""
_9lOe7.AltText = ""
_9lOe7.Resources = {
	{
		Type = "jpg", 
		Filename = "pke_meter.jpg", 
		Directives = {}
	}
}
_vby = Wherigo.ZMedia(_VNI)
_vby.Id = "ad95dc09-ac7e-4d03-9e18-c168af4619cf"
_vby.Name = _O7OD("\055\028\107\108\041\085\059\011\098\107\026")
_vby.Description = ""
_vby.AltText = ""
_vby.Resources = {
	{
		Type = "jpg", 
		Filename = "van_helsing.jpg", 
		Directives = {}
	}
}
_WOgEJ = Wherigo.ZMedia(_VNI)
_WOgEJ.Id = "0fd653af-8f4f-4d16-a871-a6c0a80709fd"
_WOgEJ.Name = _O7OD("\011\059\098\103\085\093")
_WOgEJ.Description = ""
_WOgEJ.AltText = ""
_WOgEJ.Resources = {
	{
		Type = "jpg", 
		Filename = "slimerghost.jpg", 
		Directives = {}
	}
}
_clL = Wherigo.ZMedia(_VNI)
_clL.Id = "d2433042-d860-4f1c-977c-051c06404c4f"
_clL.Name = _O7OD("\103\081\107\011\050\085\093\108\028\103\103\081")
_clL.Description = ""
_clL.AltText = ""
_clL.Resources = {
	{
		Type = "jpg", 
		Filename = "ammo.jpg", 
		Directives = {}
	}
}
_GHR = Wherigo.ZMedia(_VNI)
_GHR.Id = "42f03372-251b-4073-ab69-fd627d654295"
_GHR.Name = _O7OD("\050\028\011\007")
_GHR.Description = ""
_GHR.AltText = ""
_GHR.Resources = {
	{
		Type = "jpg", 
		Filename = "task.jpg", 
		Directives = {}
	}
}
_f0Ga9 = Wherigo.ZMedia(_VNI)
_f0Ga9.Id = "0f34a61a-63a2-4ddb-a24b-014737846492"
_f0Ga9.Name = _O7OD("\011\050\028\007\085")
_f0Ga9.Description = ""
_f0Ga9.AltText = ""
_f0Ga9.Resources = {
	{
		Type = "jpg", 
		Filename = "stake.jpg", 
		Directives = {}
	}
}
_QLMH = Wherigo.ZMedia(_VNI)
_QLMH.Id = "e03de712-8c19-4ad1-9210-57a1d5affaa7"
_QLMH.Name = _O7OD("\010\098\093\085")
_QLMH.Description = ""
_QLMH.AltText = ""
_QLMH.Resources = {
	{
		Type = "jpg", 
		Filename = "fire_bottle.jpg", 
		Directives = {}
	}
}
_yxn = Wherigo.ZMedia(_VNI)
_yxn.Id = "6221521a-5992-4583-9f5b-14c1959e6f8e"
_yxn.Name = _O7OD("\011\098\059\055\085\093\108\049\035\059\059\085\050")
_yxn.Description = ""
_yxn.AltText = ""
_yxn.Resources = {
	{
		Type = "jpg", 
		Filename = "Silver_Bullet.jpg", 
		Directives = {}
	}
}
_bcOqi = Wherigo.ZMedia(_VNI)
_bcOqi.Id = "683cc28a-c481-4ee1-8bdc-52463cb3752b"
_bcOqi.Name = _O7OD("\041\081\059\123\108\011\123\103\049\081\059")
_bcOqi.Description = ""
_bcOqi.AltText = ""
_bcOqi.Resources = {
	{
		Type = "jpg", 
		Filename = "holy_symbol.jpg", 
		Directives = {}
	}
}
_Z6qdw = Wherigo.ZMedia(_VNI)
_Z6qdw.Id = "30c471bc-818e-4e58-89e2-6cc22e6028b9"
_Z6qdw.Name = _O7OD("\026\028\093\059\098\121")
_Z6qdw.Description = ""
_Z6qdw.AltText = ""
_Z6qdw.Resources = {
	{
		Type = "jpg", 
		Filename = "garlic.jpg", 
		Directives = {}
	}
}
_eWX = Wherigo.ZMedia(_VNI)
_eWX.Id = "32b0031f-667d-4985-bab5-909f58a51c8b"
_eWX.Name = _O7OD("\026\035\107\108\011\041\081\050")
_eWX.Description = ""
_eWX.AltText = ""
_eWX.Resources = {
	{
		Type = "jpg", 
		Filename = "gun_blast.jpg", 
		Directives = {}
	}
}
_BEZ = Wherigo.ZMedia(_VNI)
_BEZ.Id = "a7d34d77-0e79-45bb-b005-34f6b7a94665"
_BEZ.Name = _O7OD("\026\085\081\121\028\121\041\085")
_BEZ.Description = ""
_BEZ.AltText = ""
_BEZ.Resources = {
	{
		Type = "jpg", 
		Filename = "geocache.jpg", 
		Directives = {}
	}
}
_8Huec = Wherigo.ZMedia(_VNI)
_8Huec.Id = "195ba2dd-4641-47ab-bb9f-1444d1f38d92"
_8Huec.Name = _O7OD("\055\028\107\108\041\085\059\011\098\107\026\108\098\121\081\107")
_8Huec.Description = ""
_8Huec.AltText = ""
_8Huec.Resources = {
	{
		Type = "jpg", 
		Filename = "van_helsing_icon.jpg", 
		Directives = {}
	}
}
_lbK = Wherigo.ZMedia(_VNI)
_lbK.Id = "a20b8942-1df4-4172-94d4-1297f447e49d"
_lbK.Name = _O7OD("\046\007\085\108\103\085\050\085\093\108\098\121\081\107")
_lbK.Description = ""
_lbK.AltText = ""
_lbK.Resources = {
	{
		Type = "jpg", 
		Filename = "pke_meter_icon.jpg", 
		Directives = {}
	}
}
_kZ1 = Wherigo.ZMedia(_VNI)
_kZ1.Id = "a72284bd-d6a5-4379-bc68-deb369052a88"
_kZ1.Name = _O7OD("\011\059\098\103\085\093\108\098\121\081\107")
_kZ1.Description = ""
_kZ1.AltText = ""
_kZ1.Resources = {
	{
		Type = "jpg", 
		Filename = "slimer_icon.jpg", 
		Directives = {}
	}
}
_Jj3 = Wherigo.ZMedia(_VNI)
_Jj3.Id = "9c022bce-ad9d-41b6-adf9-1453a73e340e"
_Jj3.Name = _O7OD("\103\081\107\011\050\085\093\108\046\041\028\011\085\108\026\035\107\108\098\121\081\107")
_Jj3.Description = ""
_Jj3.AltText = ""
_Jj3.Resources = {
	{
		Type = "jpg", 
		Filename = "Monster_Phase_Gun_icon.jpg", 
		Directives = {}
	}
}
_J9q = Wherigo.ZMedia(_VNI)
_J9q.Id = "be06e176-cbf2-41c8-a668-671842a2046e"
_J9q.Name = _O7OD("\028\103\103\081\108\098\121\081\107")
_J9q.Description = ""
_J9q.AltText = ""
_J9q.Resources = {
	{
		Type = "jpg", 
		Filename = "ammo_icon.jpg", 
		Directives = {}
	}
}
_q9L = Wherigo.ZMedia(_VNI)
_q9L.Id = "c8fd8203-1a36-43f1-b330-2e510405e6df"
_q9L.Name = _O7OD("\026\085\081\121\028\121\041\085\108\098\121\081\107")
_q9L.Description = ""
_q9L.AltText = ""
_q9L.Resources = {
	{
		Type = "jpg", 
		Filename = "geocache_icon.jpg", 
		Directives = {}
	}
}
_MZ1 = Wherigo.ZMedia(_VNI)
_MZ1.Id = "6ed9f206-b77f-4d0d-b028-09b047a92806"
_MZ1.Name = _O7OD("\079\041\085\093\098\026\081\108\098\121\081\107")
_MZ1.Description = ""
_MZ1.AltText = ""
_MZ1.Resources = {
	{
		Type = "jpg", 
		Filename = "wherigo_icon.jpg", 
		Directives = {}
	}
}
_W6J = Wherigo.ZMedia(_VNI)
_W6J.Id = "ffc5968d-e932-4989-a841-1506472cabd4"
_W6J.Name = _O7OD("\092\093\028\121\035\059\028\108\103\085\011\011\028\026\085")
_W6J.Description = ""
_W6J.AltText = ""
_W6J.Resources = {
	{
		Type = "jpg", 
		Filename = "dracula_message.jpg", 
		Directives = {}
	}
}
_6FS = Wherigo.ZMedia(_VNI)
_6FS.Id = "6496d4da-c19b-46b1-946b-a136956fc300"
_6FS.Name = _O7OD("\010\093\028\107\007\085\107\011\050\085\098\107\108\103\085\011\011\028\026\085")
_6FS.Description = ""
_6FS.AltText = ""
_6FS.Resources = {
	{
		Type = "jpg", 
		Filename = "frankenstein_message.jpg", 
		Directives = {}
	}
}
_ocRY = Wherigo.ZMedia(_VNI)
_ocRY.Id = "7777d6a1-894b-4ec5-b621-9c0c11165d98"
_ocRY.Name = _O7OD("\079\081\059\010\103\028\107\108\103\085\011\011\028\026\085")
_ocRY.Description = ""
_ocRY.AltText = ""
_ocRY.Resources = {
	{
		Type = "jpg", 
		Filename = "wolfman_message.jpg", 
		Directives = {}
	}
}
_04IA = Wherigo.ZMedia(_VNI)
_04IA.Id = "e2d5c1ba-4974-412a-a724-75ddc0843172"
_04IA.Name = _O7OD("\079\081\081\092\011\108\049\123\108\050\041\085\108\059\028\007\085")
_04IA.Description = ""
_04IA.AltText = ""
_04IA.Resources = {
	{
		Type = "jpg", 
		Filename = "woods_by_the_lake.jpg", 
		Directives = {}
	}
}
_mOwl7 = Wherigo.ZMedia(_VNI)
_mOwl7.Id = "c2bebaee-8c9a-49e9-993f-2af3e5811b53"
_mOwl7.Name = _O7OD("\079\028\050\085\093\108\050\081\079\085\093")
_mOwl7.Description = ""
_mOwl7.AltText = ""
_mOwl7.Resources = {
	{
		Type = "jpg", 
		Filename = "water_tower.jpg", 
		Directives = {}
	}
}
_S3rxD = Wherigo.ZMedia(_VNI)
_S3rxD.Id = "bf816d84-9c30-4451-8b68-fd269c2a7fe9"
_S3rxD.Name = _O7OD("\092\028\093\007\108\079\081\081\092\011")
_S3rxD.Description = ""
_S3rxD.AltText = ""
_S3rxD.Resources = {
	{
		Type = "jpg", 
		Filename = "dark_woods.jpg", 
		Directives = {}
	}
}
_FwmqF = Wherigo.ZMedia(_VNI)
_FwmqF.Id = "508ccf01-d808-4b72-98e4-3706d869b0a1"
_FwmqF.Name = _O7OD("\050\041\085\028\050\093\085")
_FwmqF.Description = ""
_FwmqF.AltText = ""
_FwmqF.Resources = {
	{
		Type = "jpg", 
		Filename = "theatre.jpg", 
		Directives = {}
	}
}
_pLA = Wherigo.ZMedia(_VNI)
_pLA.Id = "116a6688-4a7f-4873-9d5b-6f7aa632de37"
_pLA.Name = _O7OD("\121\081\107\011\085\011\011\098\081\107\108\011\050\028\107\092")
_pLA.Description = ""
_pLA.AltText = ""
_pLA.Resources = {
	{
		Type = "jpg", 
		Filename = "consecion_stand.jpg", 
		Directives = {}
	}
}
_Bsb = Wherigo.ZMedia(_VNI)
_Bsb.Id = "e1005aa6-433c-48fb-b771-9b845076d901"
_Bsb.Name = _O7OD("\011\050\028\093\050\098\107\026\108\028\093\085\028")
_Bsb.Description = ""
_Bsb.AltText = ""
_Bsb.Resources = {
	{
		Type = "jpg", 
		Filename = "starting_area.jpg", 
		Directives = {}
	}
}
_qDUr = Wherigo.ZMedia(_VNI)
_qDUr.Id = "cb921fff-44be-431d-91f8-b1c65b2d4612"
_qDUr.Name = _O7OD("\079\081\081\092\011\108\049\123\108\050\041\085\108\059\028\007\085\108\098\121\081\107")
_qDUr.Description = ""
_qDUr.AltText = ""
_qDUr.Resources = {
	{
		Type = "jpg", 
		Filename = "woods_by_the_lake_icon.jpg", 
		Directives = {}
	}
}
_dQ3 = Wherigo.ZMedia(_VNI)
_dQ3.Id = "8c545756-4901-4376-b2f1-7e950a62ca80"
_dQ3.Name = _O7OD("\079\028\050\085\093\108\050\081\079\085\093\108\098\121\081\107")
_dQ3.Description = ""
_dQ3.AltText = ""
_dQ3.Resources = {
	{
		Type = "jpg", 
		Filename = "water_tower_icon.jpg", 
		Directives = {}
	}
}
_l9L_ = Wherigo.ZMedia(_VNI)
_l9L_.Id = "4441860a-4671-4c3a-98fb-19efb58b23fe"
_l9L_.Name = _O7OD("\121\081\107\011\085\121\098\081\107\108\011\050\028\107\092\108\098\121\081\107")
_l9L_.Description = ""
_l9L_.AltText = ""
_l9L_.Resources = {
	{
		Type = "jpg", 
		Filename = "consecion_stand_icon.jpg", 
		Directives = {}
	}
}
_Hcovg = Wherigo.ZMedia(_VNI)
_Hcovg.Id = "5bbd3ea6-4384-4d76-a7bf-e488e983ed41"
_Hcovg.Name = _O7OD("\011\050\028\093\050\098\107\026\108\028\093\085\028\108\098\121\081\107")
_Hcovg.Description = ""
_Hcovg.AltText = ""
_Hcovg.Resources = {
	{
		Type = "jpg", 
		Filename = "starting_area_icon.jpg", 
		Directives = {}
	}
}
_HvL = Wherigo.ZMedia(_VNI)
_HvL.Id = "a20d9530-e1e3-40c9-afda-7e3158f399e8"
_HvL.Name = _O7OD("\092\028\093\007\108\079\081\081\092\011\108\098\121\081\107")
_HvL.Description = ""
_HvL.AltText = ""
_HvL.Resources = {
	{
		Type = "jpg", 
		Filename = "dark_woods_icon.jpg", 
		Directives = {}
	}
}
_DNt = Wherigo.ZMedia(_VNI)
_DNt.Id = "d994524e-46ea-40ef-b6f7-3f71648f5801"
_DNt.Name = _O7OD("\050\041\085\028\050\093\085\108\098\121\081\107")
_DNt.Description = ""
_DNt.AltText = ""
_DNt.Resources = {
	{
		Type = "jpg", 
		Filename = "theatre_icon.jpg", 
		Directives = {}
	}
}
_vimdj = Wherigo.ZMedia(_VNI)
_vimdj.Id = "c7a6cabb-9b0d-46c8-9c76-9b15101f825f"
_vimdj.Name = _O7OD("\103\035\103\103\123\108\098\121\081\107")
_vimdj.Description = ""
_vimdj.AltText = ""
_vimdj.Resources = {
	{
		Type = "jpg", 
		Filename = "mummy_icon.jpg", 
		Directives = {}
	}
}
_Loia = Wherigo.ZMedia(_VNI)
_Loia.Id = "d24c745c-8e85-4487-8423-be0bee429dad"
_Loia.Name = _O7OD("\010\093\028\107\007\085\107\011\050\085\098\107\108\098\121\081\107")
_Loia.Description = ""
_Loia.AltText = ""
_Loia.Resources = {
	{
		Type = "jpg", 
		Filename = "frankenstein_icon.jpg", 
		Directives = {}
	}
}
_ApO = Wherigo.ZMedia(_VNI)
_ApO.Id = "4d668c4f-403f-4da7-ba34-5958b4444fe9"
_ApO.Name = _O7OD("\079\081\059\010\103\028\107\108\098\121\081\107")
_ApO.Description = ""
_ApO.AltText = ""
_ApO.Resources = {
	{
		Type = "jpg", 
		Filename = "wolfman_icon.jpg", 
		Directives = {}
	}
}
_at6rH = Wherigo.ZMedia(_VNI)
_at6rH.Id = "34b11ef7-1ee9-45cf-b447-40e254daa1d3"
_at6rH.Name = _O7OD("\092\093\028\121\035\059\028\108\098\121\081\107")
_at6rH.Description = ""
_at6rH.AltText = ""
_at6rH.Resources = {
	{
		Type = "jpg", 
		Filename = "dracula_icon.jpg", 
		Directives = {}
	}
}
_x1g = Wherigo.ZMedia(_VNI)
_x1g.Id = "fc1bc5b2-c242-4bd6-91dc-c95b313f8d10"
_x1g.Name = _O7OD("\046\035\103\046\007\098\107")
_x1g.Description = ""
_x1g.AltText = ""
_x1g.Resources = {
	{
		Type = "jpg", 
		Filename = "pumpkin.jpg", 
		Directives = {}
	}
}
_T07 = Wherigo.ZMedia(_VNI)
_T07.Id = "2d2d373c-804f-400d-9fe5-d33a5b9113df"
_T07.Name = _O7OD("\079\081\059\010\103\028\107\108\028\050\050\028\121\007\011")
_T07.Description = ""
_T07.AltText = ""
_T07.Resources = {
	{
		Type = "jpg", 
		Filename = "wolfman_attacks.jpg", 
		Directives = {}
	}
}
_PYCU3 = Wherigo.ZMedia(_VNI)
_PYCU3.Id = "10210764-cdcc-4623-8d37-350ce34b7601"
_PYCU3.Name = _O7OD("\103\035\103\103\123\108\028\050\050\028\121\007\011")
_PYCU3.Description = ""
_PYCU3.AltText = ""
_PYCU3.Resources = {
	{
		Type = "jpg", 
		Filename = "mummy_attacks.jpg", 
		Directives = {}
	}
}
_E_5B = Wherigo.ZMedia(_VNI)
_E_5B.Id = "0a7a8cfc-65b5-4c41-86c4-d1d38a7796d2"
_E_5B.Name = _O7OD("\112\093\028\121\035\059\028\108\028\050\050\028\121\007\011")
_E_5B.Description = ""
_E_5B.AltText = ""
_E_5B.Resources = {
	{
		Type = "jpg", 
		Filename = "dracula_attacks.jpg", 
		Directives = {}
	}
}
_hs5o = Wherigo.ZMedia(_VNI)
_hs5o.Id = "4a45c4fc-bc18-48b9-87a2-f1c8dcf3b8e0"
_hs5o.Name = _O7OD("\010\093\028\107\007\085\107\011\050\085\098\107\108\028\050\050\028\121\007\011")
_hs5o.Description = ""
_hs5o.AltText = ""
_hs5o.Resources = {
	{
		Type = "jpg", 
		Filename = "frankenstein_attacks.jpg", 
		Directives = {}
	}
}
_Qd5 = Wherigo.ZMedia(_VNI)
_Qd5.Id = "fb78cfce-9f23-4d5a-bb1d-bc7313f56488"
_Qd5.Name = _O7OD("\092\093\028\121\035\059\028\108\011\081\035\107\092\057")
_Qd5.Description = ""
_Qd5.AltText = ""
_Qd5.Resources = {
	{
		Type = "mp3", 
		Filename = "I_Am_Dracula.mp3", 
		Directives = {}
	}
}
_KWJv = Wherigo.ZMedia(_VNI)
_KWJv.Id = "2e61cc39-f8ee-4097-878e-80107108ea37"
_KWJv.Name = _O7OD("\092\093\028\121\035\059\028\108\011\081\035\107\092\053")
_KWJv.Description = ""
_KWJv.AltText = ""
_KWJv.Resources = {
	{
		Type = "mp3", 
		Filename = "dracula_sound.mp3", 
		Directives = {}
	}
}
_V9sf2 = Wherigo.ZMedia(_VNI)
_V9sf2.Id = "0d1f33bd-032b-461d-9c6c-43393e760765"
_V9sf2.Name = _O7OD("\103\081\107\011\050\085\093\108\092\085\011\050\093\035\121\050\098\081\107\053")
_V9sf2.Description = ""
_V9sf2.AltText = ""
_V9sf2.Resources = {
	{
		Type = "jpg", 
		Filename = "monster_desctruction2.jpg", 
		Directives = {}
	}
}
_AQwE = Wherigo.ZMedia(_VNI)
_AQwE.Id = "a7c48b67-a37b-4cd4-b51b-3ba706589310"
_AQwE.Name = _O7OD("\103\081\107\011\050\085\093\108\092\085\011\050\093\035\121\050\098\081\107\057")
_AQwE.Description = ""
_AQwE.AltText = ""
_AQwE.Resources = {
	{
		Type = "jpg", 
		Filename = "monster_destruction.jpg", 
		Directives = {}
	}
}
_3Qy = Wherigo.ZMedia(_VNI)
_3Qy.Id = "a94a9656-441c-4d86-8022-0c7e94a48e2b"
_3Qy.Name = _O7OD("\103\098\011\011\085\092\108\011\041\081\050")
_3Qy.Description = ""
_3Qy.AltText = ""
_3Qy.Resources = {
	{
		Type = "jpg", 
		Filename = "missed_shot.jpg", 
		Directives = {}
	}
}
_pbz = Wherigo.ZMedia(_VNI)
_pbz.Id = "ced4fda7-5815-45e1-b78c-cd813cb90a76"
_pbz.Name = _O7OD("\079\081\059\010\103\028\107\108\011\081\035\107\092")
_pbz.Description = ""
_pbz.AltText = ""
_pbz.Resources = {
	{
		Type = "mp3", 
		Filename = "Werewolf_sound.mp3", 
		Directives = {}
	}
}
_SAWE = Wherigo.ZMedia(_VNI)
_SAWE.Id = "acdab9b9-432f-48eb-a8c1-16e6ea9b9e76"
_SAWE.Name = _O7OD("\103\035\103\103\123\108\011\081\035\107\092")
_SAWE.Description = ""
_SAWE.AltText = ""
_SAWE.Resources = {
	{
		Type = "mp3", 
		Filename = "mummy_sound.mp3", 
		Directives = {}
	}
}
_eHPe = Wherigo.ZMedia(_VNI)
_eHPe.Id = "3d7be845-8872-4447-be9d-5a4f024728b9"
_eHPe.Name = _O7OD("\103\081\107\011\050\085\093\108\046\041\028\011\085\108\026\035\107\108\011\081\035\107\092")
_eHPe.Description = ""
_eHPe.AltText = ""
_eHPe.Resources = {
	{
		Type = "mp3", 
		Filename = "monster_phase_gun_sound.mp3", 
		Directives = {}
	}
}
_s5o = Wherigo.ZMedia(_VNI)
_s5o.Id = "e4e15d01-114d-4a01-b468-3a12a4755758"
_s5o.Name = _O7OD("\028\103\103\081\108\059\081\028\092\108\011\081\035\107\092")
_s5o.Description = ""
_s5o.AltText = ""
_s5o.Resources = {
	{
		Type = "mp3", 
		Filename = "Ammo_load.mp3", 
		Directives = {}
	}
}
_0gJ = Wherigo.ZMedia(_VNI)
_0gJ.Id = "0a148d55-9a20-4505-994d-0ecec03cf2dd"
_0gJ.Name = _O7OD("\010\093\028\107\007\085\107\011\050\085\098\107\108\011\081\035\107\092")
_0gJ.Description = ""
_0gJ.AltText = ""
_0gJ.Resources = {
	{
		Type = "mp3", 
		Filename = "frankenstein_sound.mp3", 
		Directives = {}
	}
}
_5d_ = Wherigo.ZMedia(_VNI)
_5d_.Id = "5828c936-bb9f-4426-99ff-5288228706d0"
_5d_.Name = _O7OD("\055\028\107\108\041\085\059\011\098\107\026\108\011\081\035\107\092")
_5d_.Description = ""
_5d_.AltText = ""
_5d_.Resources = {
	{
		Type = "mp3", 
		Filename = "van_helsing_sound.mp3", 
		Directives = {}
	}
}
_C7A = Wherigo.ZMedia(_VNI)
_C7A.Id = "3c35d2c1-a578-488e-9b5c-a45535b78905"
_C7A.Name = _O7OD("\046\007\085\108\103\085\050\085\093\108\011\085\028\093\121\041\098\107\026")
_C7A.Description = ""
_C7A.AltText = ""
_C7A.Resources = {
	{
		Type = "mp3", 
		Filename = "pke_meter_sound.mp3", 
		Directives = {}
	}
}
_k_P = Wherigo.ZMedia(_VNI)
_k_P.Id = "a113ffd9-1570-408c-b44f-8d917f53c949"
_k_P.Name = _O7OD("\046\007\085\108\103\085\050\085\093\108\010\081\035\107\092\108\103\081\107\011\050\085\093\108\011\081\035\107\092")
_k_P.Description = ""
_k_P.AltText = ""
_k_P.Resources = {
	{
		Type = "mp3", 
		Filename = "monster_found_siren.mp3", 
		Directives = {}
	}
}
_wJweO = Wherigo.ZMedia(_VNI)
_wJweO.Id = "56f886be-9387-4fd3-b3c2-c3002cd27aca"
_wJweO.Name = _O7OD("\011\059\098\103\085\093\108\011\081\035\107\092")
_wJweO.Description = ""
_wJweO.AltText = ""
_wJweO.Resources = {
	{
		Type = "mp3", 
		Filename = "slimer.mp3", 
		Directives = {}
	}
}
_0EQa = Wherigo.ZMedia(_VNI)
_0EQa.Id = "d4ac5756-c160-4076-82d4-254687424695"
_0EQa.Name = _O7OD("\079\041\085\093\098\026\081\108\121\028\093\050\108\092\085\050\028\098\059")
_0EQa.Description = ""
_0EQa.AltText = ""
_0EQa.Resources = {
	{
		Type = "jpg", 
		Filename = "wherigo_cart_detail.jpg", 
		Directives = {}
	}
}
_Xvw = Wherigo.ZMedia(_VNI)
_Xvw.Id = "15c49de2-49b2-4bfc-9fda-8589608d6103"
_Xvw.Name = _O7OD("\046\059\028\123\085\093\108\121\081\103\046\059\085\050\098\081\107\108\121\081\092\085")
_Xvw.Description = ""
_Xvw.AltText = ""
_Xvw.Resources = {
	{
		Type = "jpeg", 
		Filename = "wherigo.jpeg", 
		Directives = {}
	}
}
_L0V = Wherigo.ZMedia(_VNI)
_L0V.Id = "80f57dc0-2aa4-40f9-8f4c-1e54c03e7d6c"
_L0V.Name = _O7OD("\085\012\046\059\081\011\098\081\107\108\011\081\035\107\092")
_L0V.Description = ""
_L0V.AltText = ""
_L0V.Resources = {
	{
		Type = "mp3", 
		Filename = "explosion.mp3", 
		Directives = {}
	}
}
_sIdhw = Wherigo.ZMedia(_VNI)
_sIdhw.Id = "569a4ec4-8e0e-4d20-bbff-cdcbb426fbb9"
_sIdhw.Name = _O7OD("\103\035\103\103\123\108\103\085\011\011\028\026\085")
_sIdhw.Description = ""
_sIdhw.AltText = ""
_sIdhw.Resources = {
	{
		Type = "jpg", 
		Filename = "mummy_message.jpg", 
		Directives = {}
	}
}
_H02d = Wherigo.ZMedia(_VNI)
_H02d.Id = "71f19c16-59a8-46ad-895c-adc6cd3158c5"
_H02d.Name = _O7OD("\046\081\093\050\028\059")
_H02d.Description = ""
_H02d.AltText = ""
_H02d.Resources = {
	{
		Type = "jpg", 
		Filename = "portal.jpg", 
		Directives = {}
	}
}
_6H_s = Wherigo.ZMedia(_VNI)
_6H_s.Id = "6d87c68a-a9f3-4733-a1ac-aeefc1936df8"
_6H_s.Name = _O7OD("\079\098\107\092\108\011\081\035\107\092")
_6H_s.Description = ""
_6H_s.AltText = ""
_6H_s.Resources = {
	{
		Type = "mp3", 
		Filename = "wind_sound.mp3", 
		Directives = {}
	}
}
_TIjDN = Wherigo.ZMedia(_VNI)
_TIjDN.Id = "9e727cac-2e32-4b15-82ad-08d57f0824be"
_TIjDN.Name = _O7OD("\103\081\107\011\050\085\093\108\121\081\103\046\085\107\092\098\035\103\108\098\121\081\107")
_TIjDN.Description = ""
_TIjDN.AltText = ""
_TIjDN.Resources = {
	{
		Type = "jpg", 
		Filename = "monster_compendium_icon.jpg", 
		Directives = {}
	}
}
_fF5 = Wherigo.ZMedia(_VNI)
_fF5.Id = "93560a0b-8459-40d4-8521-8e5a890aa122"
_fF5.Name = _O7OD("\103\081\107\011\050\085\093\108\121\081\103\046\085\107\092\098\035\103")
_fF5.Description = ""
_fF5.AltText = ""
_fF5.Resources = {
	{
		Type = "jpg", 
		Filename = "monster_compendium.jpg", 
		Directives = {}
	}
}
-- Cartridge Info --
_VNI.Id="2cbecf9a-ac57-4507-b48f-73d697eacc49"
_VNI.Name="Monsters"
_VNI.Description=[[]]
_VNI.Visible=true
_VNI.Activity="Fiction"
_VNI.StartingLocationDescription=[[]]
_VNI.StartingLocation = ZonePoint(38.5811400005998,-90.416929994231,0)
_VNI.Version=""
_VNI.Company=""
_VNI.Author="Forest-Ghost"
_VNI.BuilderVersion="URWIGO 1.21.5528.18461"
_VNI.CreateDate="08/05/2015 23:30:59"
_VNI.PublishDate="1/1/0001 12:00:00 AM"
_VNI.UpdateDate="10/17/2015 09:30:30"
_VNI.LastPlayedDate="1/1/0001 12:00:00 AM"
_VNI.TargetDevice="PocketPC"
_VNI.TargetDeviceVersion="0"
_VNI.StateId="1"
_VNI.CountryId="2"
_VNI.Complete=false
_VNI.UseLogging=true

_VNI.Media=_0EQa

_VNI.Icon=_MZ1


-- Zones --
_nZg2Z = Wherigo.Zone(_VNI)
_nZg2Z.Id = "54c9d98a-c7ec-441c-bc4e-d4f61174ec98"
_nZg2Z.Name = _O7OD("\082\050\028\093\050\058\076\093\085\028")
_nZg2Z.Description = ""
_nZg2Z.Visible = true
_nZg2Z.Media = _Bsb
_nZg2Z.Icon = _Hcovg
_nZg2Z.Commands = {}
_nZg2Z.DistanceRange = Distance(-1, "feet")
_nZg2Z.ShowObjects = "OnProximity"
_nZg2Z.ProximityRange = Distance(10, "meters")
_nZg2Z.AllowSetPositionTo = false
_nZg2Z.Active = false
_nZg2Z.Points = {
	ZonePoint(38.5814148495078, -90.4172691551543, 0), 
	ZonePoint(38.5813844610801, -90.4174227404989, 0), 
	ZonePoint(38.5812830237943, -90.4173845045812, 0), 
	ZonePoint(38.5813191926847, -90.4172349714287, 0)
}
_nZg2Z.OriginalPoint = ZonePoint(38.5813503817667, -90.4173278429158, 0)
_nZg2Z.DistanceRangeUOM = "Feet"
_nZg2Z.ProximityRangeUOM = "Meters"
_nZg2Z.OutOfRangeName = ""
_nZg2Z.InRangeName = ""
_Asx = Wherigo.Zone(_VNI)
_Asx.Id = "f475e9ab-88a1-418f-8ad4-37905c01d37c"
_Asx.Name = _O7OD("\017\081\107\121\085\011\011\098\081\107\058\082\050\028\107\092")
_Asx.Description = ""
_Asx.Visible = true
_Asx.Media = _pLA
_Asx.Icon = _l9L_
_Asx.Commands = {}
_Asx.DistanceRange = Distance(-1, "feet")
_Asx.ShowObjects = "OnProximity"
_Asx.ProximityRange = Distance(10, "meters")
_Asx.AllowSetPositionTo = false
_Asx.Active = false
_Asx.Points = {
	ZonePoint(38.5818596271223, -90.418916716481, 0), 
	ZonePoint(38.5819513590431, -90.4189079993016, 0), 
	ZonePoint(38.581945068858, -90.4187168919094, 0), 
	ZonePoint(38.5818522885635, -90.4187195741184, 0)
}
_Asx.OriginalPoint = ZonePoint(38.5819020858967, -90.4188152954526, 0)
_Asx.DistanceRangeUOM = "Feet"
_Asx.ProximityRangeUOM = "Meters"
_Asx.OutOfRangeName = ""
_Asx.InRangeName = ""
_tC_ = Wherigo.Zone(_VNI)
_tC_.Id = "5a965d9b-fdf2-4eb1-a9cb-e99c0c671d16"
_tC_.Name = _O7OD("\047\041\085\028\050\093\085")
_tC_.Description = ""
_tC_.Visible = true
_tC_.Media = _FwmqF
_tC_.Icon = _DNt
_tC_.Commands = {}
_tC_.DistanceRange = Distance(-1, "feet")
_tC_.ShowObjects = "OnProximity"
_tC_.ProximityRange = Distance(10, "meters")
_tC_.AllowSetPositionTo = false
_tC_.Active = false
_tC_.Points = {
	ZonePoint(38.5810848808548, -90.4199560724743, 0), 
	ZonePoint(38.5811236707855, -90.4198575012929, 0), 
	ZonePoint(38.5810361313177, -90.4197495423801, 0), 
	ZonePoint(38.5809863333691, -90.4198494546659, 0)
}
_tC_.OriginalPoint = ZonePoint(38.5810577540818, -90.4198531427033, 0)
_tC_.DistanceRangeUOM = "Feet"
_tC_.ProximityRangeUOM = "Meters"
_tC_.OutOfRangeName = ""
_tC_.InRangeName = ""
_gxiA = Wherigo.Zone(_VNI)
_gxiA.Id = "df06baa5-80aa-40d1-ba7d-40334ce18b02"
_gxiA.Name = _O7OD("\120\081\081\092\011\058\107\085\028\093\058\050\041\085\058\084\028\007\085")
_gxiA.Description = ""
_gxiA.Visible = true
_gxiA.Media = _04IA
_gxiA.Icon = _qDUr
_gxiA.Commands = {}
_gxiA.DistanceRange = Distance(-1, "feet")
_gxiA.ShowObjects = "OnProximity"
_gxiA.ProximityRange = Distance(10, "meters")
_gxiA.AllowSetPositionTo = false
_gxiA.Active = false
_gxiA.Points = {
	ZonePoint(38.5797817366856, -90.4195879392869, 0), 
	ZonePoint(38.579877140641, -90.4196047030933, 0), 
	ZonePoint(38.5798912939642, -90.4194424294479, 0), 
	ZonePoint(38.5797964142255, -90.4194236539848, 0)
}
_gxiA.OriginalPoint = ZonePoint(38.5798366463791, -90.4195146814532, 0)
_gxiA.DistanceRangeUOM = "Feet"
_gxiA.ProximityRangeUOM = "Meters"
_gxiA.OutOfRangeName = ""
_gxiA.InRangeName = ""
_gXX = Wherigo.Zone(_VNI)
_gXX.Id = "df6d1946-d649-440f-85bd-1054bcd454ec"
_gXX.Name = _O7OD("\112\028\093\007\058\120\081\081\092\011")
_gXX.Description = ""
_gXX.Visible = true
_gXX.Media = _S3rxD
_gXX.Icon = _HvL
_gXX.Commands = {}
_gXX.DistanceRange = Distance(-1, "feet")
_gXX.ShowObjects = "OnProximity"
_gXX.ProximityRange = Distance(10, "meters")
_gXX.AllowSetPositionTo = false
_gXX.Active = false
_gXX.Points = {
	ZonePoint(38.581603524855, -90.422174961712, 0), 
	ZonePoint(38.5816018170768, -90.4220188124543, 0), 
	ZonePoint(38.5814760658447, -90.422017298367, 0), 
	ZonePoint(38.5814790905533, -90.4221793629421, 0)
}
_gXX.OriginalPoint = ZonePoint(38.5815401245824, -90.4220976088689, 0)
_gXX.DistanceRangeUOM = "Feet"
_gXX.ProximityRangeUOM = "Meters"
_gXX.OutOfRangeName = ""
_gXX.InRangeName = ""
_ywd = Wherigo.Zone(_VNI)
_ywd.Id = "7e4c3884-ce1f-446d-819c-676971c36f34"
_ywd.Name = _O7OD("\120\028\050\085\093\058\047\081\079\085\093")
_ywd.Description = ""
_ywd.Visible = true
_ywd.Media = _mOwl7
_ywd.Icon = _dQ3
_ywd.Commands = {}
_ywd.DistanceRange = Distance(-1, "feet")
_ywd.ShowObjects = "OnProximity"
_ywd.ProximityRange = Distance(10, "meters")
_ywd.AllowSetPositionTo = false
_ywd.Active = false
_ywd.Points = {
	ZonePoint(38.5822434621266, -90.4209448283068, 0), 
	ZonePoint(38.5821590691071, -90.4209387933364, 0), 
	ZonePoint(38.5821674559954, -90.4207691436163, 0), 
	ZonePoint(38.5822502764656, -90.4207758491389, 0)
}
_ywd.OriginalPoint = ZonePoint(38.5822050659237, -90.4208571535996, 0)
_ywd.DistanceRangeUOM = "Feet"
_ywd.ProximityRangeUOM = "Meters"
_ywd.OutOfRangeName = ""
_ywd.InRangeName = ""
_sekDI = Wherigo.Zone(_VNI)
_sekDI.Id = "0378d811-1cca-4a50-9eb9-2fa2b7a8c1c6"
_sekDI.Name = _O7OD("\027\085\081\121\028\121\041\085")
_sekDI.Description = _O7OD("\047\041\085\058\027\085\081\121\028\121\041\085\058\098\011\058\059\081\121\028\050\085\092\083\058\097\058\038\078\058\038\063\077\127\078\060\058\044\107\049\011\046\125\120\058\089\060\058\053\063\077\089\063\066")
_sekDI.Visible = true
_sekDI.Media = _BEZ
_sekDI.Icon = _q9L
_sekDI.Commands = {}
_sekDI.DistanceRange = Distance(-1, "feet")
_sekDI.ShowObjects = "OnProximity"
_sekDI.ProximityRange = Distance(10, "meters")
_sekDI.AllowSetPositionTo = false
_sekDI.Active = false
_sekDI.Points = {
	ZonePoint(38.5780546778957, -90.4158577840615, 0), 
	ZonePoint(38.5779531995231, -90.415859106103, 0), 
	ZonePoint(38.5779558205794, -90.4157149373684, 0), 
	ZonePoint(38.5780575174861, -90.4157142668162, 0)
}
_sekDI.OriginalPoint = ZonePoint(38.5780053038711, -90.4157865235873, 0)
_sekDI.DistanceRangeUOM = "Feet"
_sekDI.ProximityRangeUOM = "Meters"
_sekDI.OutOfRangeName = ""
_sekDI.InRangeName = ""

-- Characters --
_OrT = Wherigo.ZCharacter{
	Cartridge = _VNI, 
	Container = _gXX
}
_OrT.Id = "0efb9523-5a63-4b6b-9e97-43e249845d19"
_OrT.Name = _O7OD("\120\081\059\010\103\028\107")
_OrT.Description = ""
_OrT.Visible = true
_OrT.Media = _ocRY
_OrT.Icon = _ApO
_OrT.Commands = {}
_OrT.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_OrT.Gender = "Male"
_OrT.Type = "NPC"
_apJFp = Wherigo.ZCharacter{
	Cartridge = _VNI, 
	Container = _ywd
}
_apJFp.Id = "b98cfbb5-18b7-4445-b407-d1dcfce00711"
_apJFp.Name = _O7OD("\099\093\028\107\007\085\107\011\050\085\098\107")
_apJFp.Description = ""
_apJFp.Visible = true
_apJFp.Media = _6FS
_apJFp.Icon = _Loia
_apJFp.Commands = {}
_apJFp.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_apJFp.Gender = "Male"
_apJFp.Type = "NPC"
_cPqI = Wherigo.ZCharacter{
	Cartridge = _VNI, 
	Container = _nZg2Z
}
_cPqI.Id = "0035052b-edb8-4d48-bc81-3d5c0cf60ff7"
_cPqI.Name = _O7OD("\061\028\107\058\075\085\059\011\098\107\026")
_cPqI.Description = ""
_cPqI.Visible = true
_cPqI.Media = _vby
_cPqI.Icon = _8Huec
_cPqI.Commands = {
	_wp_P = Wherigo.ZCommand{
		Text = _O7OD("\047\028\059\007"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _O7OD("\097\081\050\041\098\107\026\058\028\055\028\098\059\028\049\059\085")
	}, 
	_X7AW = Wherigo.ZCommand{
		Text = _O7OD("\047\028\059\007"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _O7OD("\097\081\050\041\098\107\026\058\028\055\028\098\059\028\049\059\085")
	}
}
_cPqI.Commands._wp_P.Custom = true
_cPqI.Commands._wp_P.Id = "a3275676-5ae7-4f43-8e8b-5d79f3e1aae0"
_cPqI.Commands._wp_P.WorksWithAll = true
_cPqI.Commands._X7AW.Custom = true
_cPqI.Commands._X7AW.Id = "c2b197ed-b53f-494f-b1fb-280b82d910ce"
_cPqI.Commands._X7AW.WorksWithAll = true
_cPqI.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_cPqI.Gender = "Male"
_cPqI.Type = "NPC"
_EWoin = Wherigo.ZCharacter{
	Cartridge = _VNI, 
	Container = _tC_
}
_EWoin.Id = "ca2dfe5f-94f4-4e41-a02a-b3f9c4f259a0"
_EWoin.Name = _O7OD("\112\093\028\121\035\059\028")
_EWoin.Description = ""
_EWoin.Visible = true
_EWoin.Media = _W6J
_EWoin.Icon = _at6rH
_EWoin.Commands = {}
_EWoin.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_EWoin.Gender = "Male"
_EWoin.Type = "NPC"
_XVo = Wherigo.ZCharacter{
	Cartridge = _VNI, 
	Container = _Asx
}
_XVo.Id = "86b19007-9cc5-4cfb-a8af-608b3b898375"
_XVo.Name = _O7OD("\082\059\098\103\085\093")
_XVo.Description = ""
_XVo.Visible = true
_XVo.Media = _WOgEJ
_XVo.Icon = _kZ1
_XVo.Commands = {
	_tyFh = Wherigo.ZCommand{
		Text = _O7OD("\047\028\059\007"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _O7OD("\097\081\050\041\098\107\026\058\028\055\028\098\059\028\049\059\085")
	}
}
_XVo.Commands._tyFh.Custom = true
_XVo.Commands._tyFh.Id = "1087541b-3510-42ef-ae3e-0ada37ce2dcf"
_XVo.Commands._tyFh.WorksWithAll = true
_XVo.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_XVo.Gender = "Male"
_XVo.Type = "NPC"
_HMI = Wherigo.ZCharacter{
	Cartridge = _VNI, 
	Container = _gxiA
}
_HMI.Id = "b73b577f-39d6-4908-90f9-e13e4cf09aaf"
_HMI.Name = _O7OD("\073\035\103\103\123")
_HMI.Description = ""
_HMI.Visible = true
_HMI.Media = _sIdhw
_HMI.Icon = _vimdj
_HMI.Commands = {}
_HMI.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_HMI.Gender = "Male"
_HMI.Type = "NPC"

-- Items --
_aUf = Wherigo.ZItem(_VNI)
_aUf.Id = "6155c2a1-b8e2-4206-92b4-d0f032fb2d23"
_aUf.Name = _O7OD("\073\081\107\011\050\085\093\058\018\041\028\011\085\058\027\035\107")
_aUf.Description = ""
_aUf.Visible = true
_aUf.Media = _qw0
_aUf.Icon = _Jj3
_aUf.Commands = {
	_p7Zl = Wherigo.ZCommand{
		Text = _O7OD("\099\098\093\085\058\027\035\107"), 
		CmdWith = true, 
		Enabled = true, 
		EmptyTargetListText = _O7OD("\070\081\035\058\010\098\093\085\058\081\010\010\058\028\058\011\041\081\050\058\049\035\050\058\107\081\050\041\098\107\026\058\041\028\046\046\085\107\011\077")
	}
}
_aUf.Commands._p7Zl.Custom = true
_aUf.Commands._p7Zl.Id = "6110a42e-d498-4289-8a80-62782e0742e3"
_aUf.Commands._p7Zl.WorksWithAll = false
_aUf.Commands._p7Zl.WorksWithListIds = {
	"0efb9523-5a63-4b6b-9e97-43e249845d19", 
	"b98cfbb5-18b7-4445-b407-d1dcfce00711", 
	"86b19007-9cc5-4cfb-a8af-608b3b898375", 
	"ca2dfe5f-94f4-4e41-a02a-b3f9c4f259a0", 
	"b73b577f-39d6-4908-90f9-e13e4cf09aaf"
}
_aUf.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_aUf.Locked = false
_aUf.Opened = false
_hBS39 = Wherigo.ZItem(_VNI)
_hBS39.Id = "399aa912-d8e7-4963-89f0-08d72b3527e2"
_hBS39.Name = _O7OD("\018\077\058\065\077\058\115\077\058\073\085\050\085\093")
_hBS39.Description = ""
_hBS39.Visible = true
_hBS39.Media = _9lOe7
_hBS39.Icon = _lbK
_hBS39.Commands = {
	_GDu = Wherigo.ZCommand{
		Text = _O7OD("\047\035\093\107\058\119\107"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _O7OD("\097\081\050\041\098\107\026\058\028\055\028\098\059\028\049\059\085")
	}
}
_hBS39.Commands._GDu.Custom = true
_hBS39.Commands._GDu.Id = "a87d9b81-8808-4648-ac1a-5e05049dc67a"
_hBS39.Commands._GDu.WorksWithAll = true
_hBS39.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_hBS39.Locked = false
_hBS39.Opened = false
_bAq5 = Wherigo.ZItem(_VNI)
_bAq5.Id = "af846a2f-a00d-45ee-adf4-8225ca2a5f0b"
_bAq5.Name = _O7OD("\076\103\103\035\107\098\050\098\081\107")
_bAq5.Description = ""
_bAq5.Visible = true
_bAq5.Media = _clL
_bAq5.Icon = _J9q
_bAq5.Commands = {
	_mr0 = Wherigo.ZCommand{
		Text = _O7OD("\084\081\028\092\058\076\103\103\035\107\098\050\098\081\107"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _O7OD("\097\081\050\041\098\107\026\058\028\055\028\098\059\028\049\059\085")
	}
}
_bAq5.Commands._mr0.Custom = true
_bAq5.Commands._mr0.Id = "7a9da894-572e-471e-b8f4-974385bd23f4"
_bAq5.Commands._mr0.WorksWithAll = true
_bAq5.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_bAq5.Locked = false
_bAq5.Opened = false
_3E5ly = Wherigo.ZItem(_VNI)
_3E5ly.Id = "1c0aa566-ba47-406f-9270-3a6d56f0c260"
_3E5ly.Name = _O7OD("\121\041\085\028\050")
_3E5ly.Description = ""
_3E5ly.Visible = true
_3E5ly.Commands = {
	_V9z = Wherigo.ZCommand{
		Text = _O7OD("\050\035\093\107\058\081\107"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _O7OD("\097\081\050\041\098\107\026\058\028\055\028\098\059\028\049\059\085")
	}
}
_3E5ly.Commands._V9z.Custom = true
_3E5ly.Commands._V9z.Id = "8706ad57-a9c5-46da-bfbf-193cf19f7c81"
_3E5ly.Commands._V9z.WorksWithAll = true
_3E5ly.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_3E5ly.Locked = false
_3E5ly.Opened = false
__mz = Wherigo.ZItem(_VNI)
__mz.Id = "53c8fbc7-852a-4deb-a6b1-967363bc7d21"
__mz.Name = _O7OD("\027\085\081\121\028\121\041\085")
__mz.Description = _O7OD("\047\041\085\058\026\085\081\121\028\121\041\085\058\098\011\058\059\081\121\028\050\085\092\058\028\050\058\097\058\038\078\058\038\063\077\127\078\060\058\044\107\049\011\046\125\120\058\089\060\058\053\063\077\089\063\066\077")
__mz.Visible = true
__mz.Media = _BEZ
__mz.Icon = _q9L
__mz.Commands = {
	_0OX = Wherigo.ZCommand{
		Text = _O7OD("\075\098\107\050"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _O7OD("\097\081\050\041\098\107\026\058\028\055\028\098\059\028\049\059\085")
	}
}
__mz.Commands._0OX.Custom = true
__mz.Commands._0OX.Id = "6a5ea5c3-2dce-4264-939a-640ba60ae6be"
__mz.Commands._0OX.WorksWithAll = true
__mz.ObjectLocation = Wherigo.INVALID_ZONEPOINT
__mz.Locked = false
__mz.Opened = false
_BBvM = Wherigo.ZItem(_VNI)
_BBvM.Id = "0b917be0-1c72-413c-a25d-1653f6964c3c"
_BBvM.Name = _O7OD("\018\059\028\123\085\093\058\017\081\103\046\059\085\050\098\081\107\058\017\081\092\085")
_BBvM.Description = ""
_BBvM.Visible = true
_BBvM.Media = _Xvw
_BBvM.Commands = {}
_BBvM.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_BBvM.Locked = false
_BBvM.Opened = false
_mpGUV = Wherigo.ZItem{
	Cartridge = _VNI, 
	Container = Player
}
_mpGUV.Id = "7a0e6bcb-1cd6-4a71-8f15-937c0b69007b"
_mpGUV.Name = _O7OD("\073\081\107\011\050\085\093\058\017\081\103\046\085\107\092\098\035\103")
_mpGUV.Description = _O7OD("\076\058\049\081\081\007\058\028\049\081\035\050\058\103\081\107\011\050\085\093\011\077")
_mpGUV.Visible = true
_mpGUV.Media = _fF5
_mpGUV.Icon = _TIjDN
_mpGUV.Commands = {
	_dt09e = Wherigo.ZCommand{
		Text = _O7OD("\115\012\028\103\098\107\085"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _O7OD("\097\081\050\041\098\107\026\058\028\055\028\098\059\028\049\059\085")
	}
}
_mpGUV.Commands._dt09e.Custom = true
_mpGUV.Commands._dt09e.Id = "642d649d-aacb-43fb-8447-59a40c74be80"
_mpGUV.Commands._dt09e.WorksWithAll = true
_mpGUV.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_mpGUV.Locked = false
_mpGUV.Opened = false

-- Tasks --
_uoq = Wherigo.ZTask(_VNI)
_uoq.Id = "249825c1-b742-42f1-ae9b-d29098ebae4f"
_uoq.Name = _O7OD("\099\098\107\092\058\050\041\085\058\073\081\107\011\050\085\093\011")
_uoq.Description = _O7OD("\047\035\093\107\058\081\107\058\123\081\035\093\058\018\077\065\077\115\058\103\085\050\085\093\058\081\107\058\033\059\081\121\028\050\085\092\058\098\107\058\123\081\035\093\058\098\107\055\085\107\050\081\093\123\006\058\028\107\092\058\010\081\059\059\081\079\058\050\041\085\058\046\028\050\041\058\050\081\058\050\041\085\058\097\119\042\047\075\120\115\082\047\058\050\081\058\010\098\107\092\058\050\041\085\058\103\081\107\011\050\085\093\011\077")
_uoq.Visible = true
_uoq.Media = _GHR
_uoq.Active = false
_uoq.Complete = false
_uoq.CorrectState = "None"
_Lnm = Wherigo.ZTask(_VNI)
_Lnm.Id = "c22ffd1d-0a9a-4e74-bf9b-2aa1c6a6445b"
_Lnm.Name = _O7OD("\082\046\085\028\007\058\050\081\058\061\028\107\058\075\085\059\011\098\107\026")
_Lnm.Description = _O7OD("\082\046\085\028\007\058\050\081\058\061\028\107\058\075\085\059\011\098\107\026\058\098\107\058\050\041\085\058\011\050\028\093\050\098\107\026\058\028\093\085\028\077\058")
_Lnm.Visible = true
_Lnm.Media = _GHR
_Lnm.Active = false
_Lnm.Complete = false
_Lnm.CorrectState = "None"
_muk = Wherigo.ZTask(_VNI)
_muk.Id = "cd435e44-144d-41ba-b5b5-8d89a6e279eb"
_muk.Name = _O7OD("\047\028\007\085\058\092\081\079\107\058\050\041\085\058\073\081\107\011\050\085\093\011")
_muk.Description = _O7OD("\099\093\028\107\007\085\107\011\050\085\098\107\002\058\120\081\059\010\103\028\107\002\058\028\107\092\058\050\041\085\058\073\035\103\103\123\058\028\093\085\058\107\085\028\093\049\123\077\058\118\011\085\058\050\041\085\058\121\081\093\093\085\121\050\058\028\103\103\035\107\098\050\098\081\107\058\050\081\058\050\028\007\085\058\050\041\085\103\058\081\035\050\077\058\075\098\107\050\083\058\085\028\121\041\058\103\081\107\011\050\085\093\058\079\098\059\059\058\081\107\059\123\058\049\085\058\085\010\010\085\121\050\085\092\058\049\123\058\028\058\121\085\093\050\028\098\107\058\050\123\046\085\058\081\010\058\028\103\103\035\107\098\050\098\081\107\077\058\073\028\007\085\058\011\035\093\085\058\123\081\035\058\059\081\028\092\058\050\041\085\058\121\081\093\093\085\121\050\058\028\103\103\081\058\098\107\050\081\058\123\081\035\093\058\103\081\107\011\050\085\093\058\046\041\028\011\085\058\026\035\107\077")
_muk.Visible = true
_muk.Media = _GHR
_muk.Active = false
_muk.Complete = false
_muk.CorrectState = "None"
_zrpp = Wherigo.ZTask(_VNI)
_zrpp.Id = "e2c7f8aa-8766-4db5-b4dd-c66848b840b4"
_zrpp.Name = _O7OD("\047\028\007\085\058\092\081\079\107\058\112\093\028\121\035\059\028")
_zrpp.Description = _O7OD("\112\093\028\121\035\059\028\058\041\028\011\058\028\046\046\085\028\093\085\092\077\058\047\028\007\085\058\041\098\103\058\092\081\079\107\077\058\075\098\107\050\083\058\112\093\028\121\035\059\028\058\103\028\123\058\050\028\007\085\058\103\081\093\085\058\050\041\028\107\058\081\107\085\058\011\041\081\050\058\050\081\058\049\085\058\092\085\011\050\093\081\123\085\092\077")
_zrpp.Visible = true
_zrpp.Media = _GHR
_zrpp.Active = false
_zrpp.Complete = false
_zrpp.CorrectState = "None"

-- Cartridge Variables --
_1Izq = 1
_R73H_ = 1
_v9b = 1
_uSP = ""
_Ht2o = 1
_FG3 = 1
_5uE = 1
_ZViz = 1
_dIHuD = 1
_nfW = 1
_t6s = 1
_N1Sp0 = 1
_rWq = 1
_29mGG = ""
_n41P = ""
_g5m2 = 1
_acTrJ = 1
_LO2 = false
_gFkfy = _O7OD("\108\107\034\026\053\034")
_sRE = _O7OD("\108\119\093\047")
_2SKp = _O7OD("\108\028\118\010")
_AfO = _O7OD("\108\035\081\001")
_G8F = _O7OD("\108\059\050\081\121")
_qRwJP = _O7OD("\092\035\103\103\123")
_VNI.ZVariables = {
	_1Izq = 1, 
	_R73H_ = 1, 
	_v9b = 1, 
	_uSP = "", 
	_Ht2o = 1, 
	_FG3 = 1, 
	_5uE = 1, 
	_ZViz = 1, 
	_dIHuD = 1, 
	_nfW = 1, 
	_t6s = 1, 
	_N1Sp0 = 1, 
	_rWq = 1, 
	_29mGG = "", 
	_n41P = "", 
	_g5m2 = 1, 
	_acTrJ = 1, 
	_LO2 = false, 
	_gFkfy = _O7OD("\108\107\034\026\053\034"), 
	_sRE = _O7OD("\108\119\093\047"), 
	_2SKp = _O7OD("\108\028\118\010"), 
	_AfO = _O7OD("\108\035\081\001"), 
	_G8F = _O7OD("\108\059\050\081\121"), 
	_qRwJP = _O7OD("\092\035\103\103\123")
}

-- Timers --

-- Inputs --
_ltoc = Wherigo.ZInput(_VNI)
_ltoc.Id = "d9773a31-7901-4079-a6ca-40e03c3ff064"
_ltoc.Name = _O7OD("\028\103\103\035\107\098\050\098\081\107")
_ltoc.Description = ""
_ltoc.Visible = true
_ltoc.Choices = {
	"Silver Bullet", 
	"Stake", 
	"Flame", 
	"Garlic", 
	"Holy Symbol", 
	"Nothing"
}
_ltoc.InputType = "MultipleChoice"
_ltoc.Text = _O7OD("\120\041\098\121\041\058\028\103\103\081\058\079\081\035\059\092\058\123\081\035\058\059\098\007\085\058\050\081\058\059\081\028\092\067")
_ASTUq = Wherigo.ZInput(_VNI)
_ASTUq.Id = "9623b8d1-8f46-4da0-819b-c8b51b7bc07a"
_ASTUq.Name = _O7OD("\011\059\098\103\085\093\108\050\028\059\007")
_ASTUq.Description = ""
_ASTUq.Visible = true
_ASTUq.Media = _WOgEJ
_ASTUq.Choices = {
	"How are you?", 
	"Nothing"
}
_ASTUq.InputType = "MultipleChoice"
_ASTUq.Text = _O7OD("\120\041\028\050\058\079\081\035\059\092\058\123\081\035\058\059\098\007\085\058\050\081\058\050\028\059\007\058\028\049\081\035\050\067")
_YmTv = Wherigo.ZInput(_VNI)
_YmTv.Id = "9e78f067-c204-4545-9a37-01a55cb96d81"
_YmTv.Name = _O7OD("\073\081\107\011\050\085\093\108\017\081\103\046\085\107\092\098\035\103")
_YmTv.Description = ""
_YmTv.Visible = true
_YmTv.Choices = {
	"Close Book", 
	"Chapter 1: Werewolves", 
	"Chapter 2: Vampires", 
	"Chapter 3: Frankenstein", 
	"Chapter 4: Mummies"
}
_YmTv.InputType = "MultipleChoice"
_YmTv.Text = _O7OD("\120\041\098\121\041\058\121\041\028\046\050\085\093\058\079\081\035\059\092\058\123\081\035\058\059\098\007\085\058\050\081\058\050\035\093\107\058\050\081\067")

-- WorksWithList for object commands --
_aUf.Commands._p7Zl.WorksWithList = {
	_OrT, 
	_apJFp, 
	_XVo, 
	_EWoin, 
	_HMI
}

-- functions --
function _VNI:OnStart()
	_cPqI.Commands._X7AW.Enabled = false
	_n41P = _O7OD("\028\107\058\085\103\046\123\058\093\081\035\107\092\058")
	_acTrJ = 1
	if true then
		_nZg2Z.Active = true
		_Urwigo.MessageBox{
			Text = _O7OD("\073\081\107\011\050\085\093\058\028\093\085\058\059\081\081\011\085\058\098\107\058\065\098\093\007\079\081\081\092\058\018\028\093\007\077\058\017\028\107\058\123\081\035\058\041\085\059\046\058\050\041\085\058\103\081\107\011\050\085\093\058\041\035\107\050\085\093\058\061\028\107\058\075\085\059\011\098\107\026\058\050\028\007\085\058\050\041\085\103\058\092\081\079\107\067\058\018\093\081\121\085\085\092\058\050\081\058\050\041\085\058\011\050\028\093\050\098\107\026\058\028\093\085\028\058\050\081\058\011\046\085\028\007\058\050\081\058\061\028\107\058\075\085\059\011\098\107\026\077"), 
			Media = _0EQa, 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.MessageBox{
						Text = _O7OD("\070\081\035\058\010\098\107\092\058\028\058\049\081\081\007\058\081\107\058\103\081\107\011\050\085\093\011\058\098\107\058\123\081\035\093\058\049\028\121\007\046\028\121\007\077\058\047\041\098\011\058\103\028\123\058\049\085\058\041\085\059\046\010\035\059\058\059\028\050\085\093\058\081\107\077"), 
						Media = _fF5, 
						Callback = function(action)
							if action ~= nil then
								_Urwigo.MessageBox{
									Text = _O7OD("\082\046\085\028\007\058\050\081\058\061\028\107\058\075\085\059\011\098\107\026\058\098\107\058\050\041\085\058\011\050\028\093\050\098\107\026\058\028\093\085\028\077\058"), 
									Media = _GHR, 
									Callback = function(action)
										if action ~= nil then
											_Lnm.Active = true
											Wherigo.ShowScreen(Wherigo.MAINSCREEN)
											_VNI:RequestSync()
										end
									end
								}
							end
						end
					}
				end
			end
		}
	else
		_Urwigo.MessageBox{
			Text = _O7OD("\047\041\098\011\058\098\011\058\028\058\107\098\026\041\050\058\050\098\103\085\058\079\041\085\093\098\026\081\058\081\107\059\123\077\058\070\081\035\058\079\098\059\059\058\107\085\085\092\058\050\081\058\121\081\103\085\058\049\028\121\007\058\049\085\050\079\085\085\107\058\050\041\085\058\041\081\035\093\011\058\081\010\058\066\083\038\060\058\028\107\092\058\057\057\083\060\060\058\046\103\077\058")
		}
		_nZg2Z.Active = false
	end
end
function _VNI:OnRestore()
end
function _nZg2Z:OnProximity()
	_gFkfy = _O7OD("\108\107\034\026\053\034")
	if _1Izq == 1 then
		_Urwigo.MessageBox{
			Text = _O7OD("\070\081\035\058\011\085\085\058\061\028\107\058\075\085\059\011\098\107\026\058\011\050\028\107\092\098\107\026\058\107\085\028\093\049\123\077\058\082\046\085\028\007\058\050\081\058\041\098\103\058\079\041\085\107\058\123\081\035\058\026\085\050\058\028\058\121\041\028\107\121\085\077"), 
			Media = _Bsb, 
			Callback = function(action)
				if action ~= nil then
					Wherigo.ShowScreen(Wherigo.MAINSCREEN)
				end
			end
		}
	elseif _1Izq == 2 then
	end
end
function _nZg2Z:OnSetActive()
	_gFkfy = _O7OD("\108\107\034\026\053\034")
	_Urwigo.GlobalZoneActiveChanged()
end
function _Asx:OnProximity()
	_gFkfy = _O7OD("\108\076\011\012")
	if _v9b == 1 then
		_Urwigo.MessageBox{
			Text = _O7OD("\076\011\058\123\081\035\058\085\107\050\085\093\058\050\041\085\058\028\093\085\028\002\058\123\081\035\058\011\085\085\058\028\058\059\028\093\026\085\058\026\093\085\085\107\058\011\059\098\103\123\058\121\093\085\028\050\035\093\085\058\011\079\028\059\059\081\079\098\107\026\058\026\081\049\011\058\081\010\058\121\028\107\092\123\058\010\093\081\103\058\050\041\085\058\121\081\107\121\085\011\011\098\081\107\058\011\050\028\107\092\077"), 
			Media = _pLA, 
			Callback = function(action)
				if action ~= nil then
					_v9b = 2
					Wherigo.PlayAudio(_wJweO)
					_Urwigo.MessageBox{
						Text = _O7OD("\062\050\005\011\058\082\059\098\103\085\093\058\010\093\081\103\058\050\041\085\058\027\041\081\011\050\049\035\011\050\085\093\011\101\101"), 
						Media = _WOgEJ, 
						Buttons = {
							_O7OD("\082\059\098\103\085\093\101")
						}, 
						Callback = function(action)
							if action ~= nil then
								_Urwigo.MessageBox{
									Text = _O7OD("\075\098\058\050\041\085\093\085\101\058\062\058\041\085\028\093\092\058\123\081\035\058\107\085\085\092\058\011\081\103\085\058\028\103\103\081\058\050\081\058\050\028\007\085\058\092\081\079\107\058\050\041\085\058\085\055\098\059\058\103\081\107\011\050\085\093\011\077"), 
									Media = _WOgEJ, 
									Callback = function(action)
										if action ~= nil then
											Wherigo.Command "StopSound"
											_Urwigo.MessageBox{
												Text = _O7OD("\073\081\107\011\050\085\093\011\058\028\093\085\058\010\098\107\098\121\007\123\058\028\107\092\058\121\028\107\058\081\107\059\123\058\049\085\058\092\028\103\028\026\085\092\058\079\098\050\041\058\028\058\121\085\093\050\028\098\107\058\007\098\107\092\058\081\010\058\028\103\103\081\077\058\099\081\093\058\085\012\028\103\046\059\085\002\058\098\010\058\123\081\035\058\079\028\107\050\058\050\081\058\050\028\007\085\058\092\081\079\107\058\028\058\079\098\050\121\041\058\123\081\035\058\041\028\055\085\058\050\081\058\050\041\093\081\079\058\079\028\050\085\093\058\081\107\058\041\085\093\077"), 
												Media = _WOgEJ, 
												Callback = function(action)
													if action ~= nil then
														_Urwigo.MessageBox{
															Text = _O7OD("\062\058\079\098\059\059\058\011\035\046\046\059\123\058\123\081\035\058\079\098\050\041\058\050\041\085\058\011\050\028\107\092\028\093\092\058\103\081\107\011\050\085\093\058\028\103\103\035\107\098\050\098\081\107\058\046\028\121\007\077\058\062\050\058\079\098\059\059\058\049\085\058\035\046\058\050\081\058\123\081\035\058\050\081\058\059\081\028\092\058\050\041\085\058\121\081\093\093\085\121\050\058\028\103\103\035\107\098\050\098\081\107\058\098\107\050\081\058\050\041\085\058\103\081\107\011\050\085\093\058\046\041\028\011\085\058\026\035\107\077"), 
															Media = _WOgEJ, 
															Callback = function(action)
																if action ~= nil then
																	Wherigo.PlayAudio(_s5o)
																	_Urwigo.MessageBox{
																		Text = "", 
																		Media = _clL, 
																		Buttons = {
																			_O7OD("\097\098\121\085\101")
																		}, 
																		Callback = function(action)
																			if action ~= nil then
																				_Urwigo.MessageBox{
																					Text = _O7OD("\099\093\028\107\007\085\107\011\050\085\098\107\002\058\120\081\059\010\103\028\107\002\058\028\107\092\058\050\041\085\058\073\035\103\103\123\058\028\093\085\058\107\085\028\093\049\123\077\058\120\085\058\107\085\085\092\058\050\081\058\050\028\007\085\058\050\041\085\103\058\081\035\050\077\058\075\098\107\050\083\058\085\028\121\041\058\103\081\107\011\050\085\093\058\079\098\059\059\058\081\107\059\123\058\049\085\058\085\010\010\085\121\050\085\092\058\049\123\058\028\058\121\085\093\050\028\098\107\058\050\123\046\085\058\081\010\058\028\103\103\035\107\098\050\098\081\107\077\058\073\028\007\085\058\011\035\093\085\058\123\081\035\058\059\081\028\092\058\050\041\085\058\121\081\093\093\085\121\050\058\028\103\103\081\058\098\107\050\081\058\123\081\035\093\058\103\081\107\011\050\085\093\058\046\041\028\011\085\058\026\035\107\077"), 
																					Media = _GHR, 
																					Callback = function(action)
																						if action ~= nil then
																							_bAq5:MoveTo(Player)
																							_gXX.Active = true
																							_gXX.Visible = true
																							_gxiA.Visible = true
																							_ywd.Active = true
																							_gxiA.Active = true
																							_ywd.Visible = true
																							_muk.Active = true
																							_sDDri()
																							_v9b = 3
																							Wherigo.ShowScreen(Wherigo.MAINSCREEN)
																							_VNI:RequestSync()
																						end
																					end
																				}
																			end
																		end
																	}
																end
															end
														}
													end
												end
											}
										end
									end
								}
							end
						end
					}
				end
			end
		}
	elseif _v9b == 2 then
	elseif _v9b == 3 then
		_Urwigo.MessageBox{
			Text = _O7OD("\076\011\058\123\081\035\058\085\107\050\085\093\058\050\041\085\058\028\093\085\028\002\058\123\081\035\058\011\085\085\058\028\058\059\028\093\026\085\058\026\093\085\085\107\058\011\059\098\103\123\058\121\093\085\028\050\035\093\085\058\011\079\028\059\059\081\079\098\107\026\058\026\081\049\011\058\081\010\058\121\028\107\092\123\058\010\093\081\103\058\050\041\085\058\121\081\107\121\085\011\011\098\081\107\058\011\050\028\107\092\077"), 
			Media = _pLA, 
			Callback = function(action)
				if action ~= nil then
					Wherigo.ShowScreen(Wherigo.MAINSCREEN)
				end
			end
		}
	end
end
function _Asx:OnSetActive()
	_gFkfy = _O7OD("\108\076\011\012")
	_Urwigo.GlobalZoneActiveChanged()
end
function _tC_:OnProximity()
	_gFkfy = _O7OD("\108\050\017\108")
	if _R73H_ == 1 then
		_9Mv()
	elseif _N1Sp0 == 2 then
		Wherigo.PlayAudio(_Qd5)
		_Urwigo.MessageBox{
			Text = _O7OD("\076\011\058\123\081\035\058\085\107\050\085\093\058\050\041\085\058\050\041\085\028\050\093\085\058\028\058\121\081\059\092\107\085\011\011\058\011\035\093\093\081\035\107\092\011\058\050\041\085\058\028\093\085\028\077\058\070\081\035\058\011\085\107\011\085\058\112\093\028\121\035\059\028\058\098\011\058\107\085\028\093\049\123\077"), 
			Media = _W6J, 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.MessageBox{
						Text = _O7OD("\112\093\028\121\035\059\028\058\103\081\055\085\011\058\050\081\058\028\050\050\028\121\007\058\123\081\035\101"), 
						Media = _E_5B, 
						Buttons = {
							_O7OD("\070\098\007\085\011\101")
						}, 
						Callback = function(action)
							if action ~= nil then
								_Urwigo.MessageBox{
									Text = _O7OD("\047\041\098\011\058\081\107\085\058\098\011\058\028\059\059\058\035\046\058\050\081\058\123\081\035\077\058\070\081\035\058\103\098\026\041\050\058\041\028\055\085\058\050\081\058\010\098\093\085\058\103\035\059\050\098\046\059\085\058\011\041\081\050\011\058\050\081\058\050\028\007\085\058\041\098\103\058\092\081\079\107\077\058\027\081\081\092\058\059\035\121\007\101"), 
									Media = _vby, 
									Callback = function(action)
										if action ~= nil then
											Wherigo.ShowScreen(Wherigo.MAINSCREEN)
											Wherigo.Command "StopSound"
											_VNI:RequestSync()
										end
									end
								}
							end
						end
					}
				end
			end
		}
	elseif _N1Sp0 == 3 then
	end
end
function _tC_:OnSetActive()
	_gFkfy = _O7OD("\108\050\017\108")
	_Urwigo.GlobalZoneActiveChanged()
end
function _gxiA:OnProximity()
	_gFkfy = _O7OD("\108\026\012\098\076")
	if _R73H_ == 1 then
		_9Mv()
	elseif _nfW == 2 then
		Wherigo.PlayAudio(_SAWE)
		_Urwigo.MessageBox{
			Text = _O7OD("\120\098\050\041\098\107\058\050\041\085\058\079\081\081\092\011\058\123\081\035\058\041\085\028\093\058\028\058\093\035\011\050\059\098\107\026\058\107\085\028\093\049\123\058\028\107\092\058\028\058\121\093\085\028\050\035\093\085\058\028\046\046\085\028\093\011\058\049\085\010\081\093\085\058\123\081\035\083\058\050\041\085\058\103\035\103\103\123\101"), 
			Media = _sIdhw, 
			Buttons = {
				_O7OD("\062\050\005\011\058\050\041\085\058\073\035\103\103\123\101\101\101")
			}, 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.MessageBox{
						Text = _O7OD("\047\041\085\058\103\035\103\103\123\058\103\081\055\085\011\058\050\081\079\028\093\092\011\058\123\081\035\058\050\081\058\028\050\050\028\121\007\101"), 
						Media = _PYCU3, 
						Callback = function(action)
							if action ~= nil then
								_Urwigo.MessageBox{
									Text = _O7OD("\070\081\035\058\107\085\085\092\058\050\081\058\050\028\007\085\058\092\081\079\107\058\050\041\085\058\073\035\103\103\123\101\058\119\107\059\123\058\028\058\121\085\093\050\028\098\107\058\050\123\046\085\058\081\010\058\028\103\103\081\058\079\098\059\059\058\028\010\010\085\121\050\058\041\098\103\077\058\073\028\007\085\058\011\035\093\085\058\123\081\035\058\059\081\028\092\058\050\041\085\058\121\081\093\093\085\121\050\058\028\103\103\081\058\098\107\050\081\058\123\081\035\093\058\103\081\107\011\050\085\093\058\046\041\028\011\085\058\026\035\107\058\049\085\010\081\093\085\058\010\098\093\098\107\026\058\028\050\058\041\098\103\101"), 
									Media = _vby, 
									Callback = function(action)
										if action ~= nil then
											Wherigo.Command "StopSound"
											Wherigo.ShowScreen(Wherigo.MAINSCREEN)
											_VNI:RequestSync()
										end
									end
								}
							end
						end
					}
				end
			end
		}
	elseif _nfW == 3 then
	end
end
function _gxiA:OnSetActive()
	_gFkfy = _O7OD("\108\026\012\098\076")
	_Urwigo.GlobalZoneActiveChanged()
end
function _gXX:OnProximity()
	_gFkfy = _O7OD("\108\026\024\024")
	if _R73H_ == 1 then
		_9Mv()
	elseif _rWq == 2 then
		Wherigo.PlayAudio(_pbz)
		_Urwigo.MessageBox{
			Text = _O7OD("\076\011\058\123\081\035\058\085\107\050\085\093\058\098\107\050\081\058\050\041\085\058\092\028\093\007\058\079\081\081\092\011\058\123\081\035\058\011\085\107\011\085\058\092\028\107\026\085\093\058\107\085\028\093\049\123\077\058\047\041\085\058\120\081\059\010\103\028\107\058\028\046\046\085\028\093\011\101"), 
			Media = _ocRY, 
			Buttons = {
				_O7OD("\119\041\058\097\081\101\101\101")
			}, 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.MessageBox{
						Text = _O7OD("\047\041\085\058\079\081\059\010\103\028\107\058\028\050\050\028\121\007\011\101\058\112\081\058\011\081\103\085\050\041\098\107\026\058\049\085\010\081\093\085\058\098\050\005\011\058\050\081\081\058\059\028\050\085\101"), 
						Media = _T07, 
						Callback = function(action)
							if action ~= nil then
								_Urwigo.MessageBox{
									Text = _O7OD("\070\081\035\058\107\085\085\092\058\050\081\058\050\028\007\085\058\041\098\103\058\092\081\079\107\101\058\119\107\059\123\058\028\058\121\085\093\050\028\098\107\058\050\123\046\085\058\081\010\058\028\103\103\081\058\079\098\059\059\058\028\010\010\085\121\050\058\120\081\059\010\103\028\107\077\058\073\028\007\085\058\011\035\093\085\058\123\081\035\058\059\081\028\092\058\050\041\085\058\121\081\093\093\085\121\050\058\028\103\103\081\058\098\107\050\081\058\123\081\035\093\058\026\035\107\058\049\085\010\081\093\085\058\010\098\093\098\107\026\058\028\050\058\041\098\103\101"), 
									Media = _vby, 
									Callback = function(action)
										if action ~= nil then
											Wherigo.Command "StopSound"
											Wherigo.ShowScreen(Wherigo.MAINSCREEN)
											_VNI:RequestSync()
										end
									end
								}
							end
						end
					}
				end
			end
		}
	elseif _rWq == 3 then
	end
end
function _gXX:OnSetActive()
	_gFkfy = _O7OD("\108\026\024\024")
	_Urwigo.GlobalZoneActiveChanged()
end
function _ywd:OnProximity()
	_gFkfy = _O7OD("\108\123\079\092")
	if _R73H_ == 1 then
		_9Mv()
	elseif _t6s == 2 then
		Wherigo.PlayAudio(_0gJ)
		_Urwigo.MessageBox{
			Text = _O7OD("\082\050\028\107\092\098\107\026\058\107\085\028\093\058\050\041\085\058\049\028\011\085\058\081\010\058\050\041\085\058\050\081\079\085\093\058\123\081\035\058\011\085\085\058\099\093\028\107\007\085\107\011\050\085\098\107\101"), 
			Media = _6FS, 
			Buttons = {
				_O7OD("\070\098\007\085\011\101")
			}, 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.MessageBox{
						Text = _O7OD("\099\093\028\107\007\085\107\011\050\085\098\107\058\103\081\055\085\011\058\050\081\058\028\050\050\028\121\007\058\123\081\035\101\101\101"), 
						Media = _hs5o, 
						Callback = function(action)
							if action ~= nil then
								_Urwigo.MessageBox{
									Text = _O7OD("\070\081\035\058\107\085\085\092\058\050\081\058\050\028\007\085\058\092\081\079\107\058\099\093\028\107\007\085\107\011\050\085\098\107\101\058\119\107\059\123\058\028\058\121\085\093\050\028\098\107\058\050\123\046\085\058\081\010\058\028\103\103\081\058\079\098\059\059\058\028\010\010\085\121\050\058\041\098\103\077\058\073\028\007\085\058\011\035\093\085\058\123\081\035\058\059\081\028\092\058\050\041\085\058\121\081\093\093\085\121\050\058\028\103\103\081\058\098\107\050\081\058\123\081\035\093\058\103\081\107\011\050\085\093\058\046\041\028\011\085\058\026\035\107\058\049\085\010\081\093\085\058\010\098\093\098\107\026\058\028\050\058\041\098\103\101"), 
									Media = _vby, 
									Callback = function(action)
										if action ~= nil then
											Wherigo.Command "StopSound"
											Wherigo.ShowScreen(Wherigo.MAINSCREEN)
											_VNI:RequestSync()
										end
									end
								}
							end
						end
					}
				end
			end
		}
	elseif _t6s == 3 then
	end
end
function _ywd:OnSetActive()
	_gFkfy = _O7OD("\108\123\079\092")
	_Urwigo.GlobalZoneActiveChanged()
end
function _sekDI:OnProximity()
	_gFkfy = _O7OD("\108\011\085\007\112\062")
	if _LO2 ~= true then
		_LO2 = true
		_VNI.Complete = true
		_Urwigo.MessageBox{
			Text = _O7OD("\082\085\028\093\121\041\058\010\081\093\058\028\058\041\081\107\085\123\011\035\121\007\059\085\058\050\093\085\085\058\098\107\058\050\041\085\058\026\093\081\055\085\077\058\047\041\085\058\121\028\121\041\085\058\098\011\058\028\107\058\085\012\050\093\028\056\059\028\093\026\085\058\049\098\011\081\107\058\050\035\049\085\058\059\081\121\028\050\085\092\058\028\050\083\058\097\058\038\078\058\038\063\077\127\078\060\058\044\107\049\011\046\125\120\058\089\060\058\053\063\077\089\063\066\077"), 
			Media = _BEZ, 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.MessageBox{
						Text = (_O7OD("\047\041\098\011\058\079\041\085\093\098\026\081\058\098\011\058\107\081\079\058\121\081\103\046\059\085\050\085\077\058\070\081\035\093\058\046\059\028\123\085\093\058\121\081\103\046\059\085\050\098\081\107\058\121\081\092\085\058\098\011\083\058")..string.sub(Player.CompletionCode, 1, 15)).._O7OD("\058\047\041\098\011\058\121\081\092\085\058\098\011\058\035\011\085\092\058\050\081\058\059\081\026\058\123\081\035\093\058\026\028\103\085\058\081\107\058\079\041\085\093\098\026\081\077\121\081\103\077\058\062\050\058\098\011\058\028\059\011\081\058\028\055\028\098\059\028\049\059\085\058\098\107\058\123\081\035\093\058\098\107\055\085\107\050\081\093\123\077\058"), 
						Media = _Xvw, 
						Callback = function(action)
							if action ~= nil then
								_Urwigo.MessageBox{
									Text = _O7OD("\047\041\098\011\058\120\041\085\093\098\026\081\058\079\028\011\058\121\093\085\028\050\085\092\058\049\123\058\099\081\093\085\011\050\056\027\041\081\011\050\058\010\081\093\058\050\041\085\058\027\093\085\028\050\058\075\028\059\059\081\079\085\085\107\058\100\028\011\041\058\062\062\062\077\058\047\041\028\107\007\011\058\010\081\093\058\046\059\028\123\098\107\026\058\083\056\112"), 
									Media = _x1g, 
									Callback = function(action)
										if action ~= nil then
											_BBvM:MoveTo(Player)
											_BBvM.Description = string.sub(Player.CompletionCode, 1, 15)
											Wherigo.ShowScreen(Wherigo.MAINSCREEN)
											_VNI:RequestSync()
										end
									end
								}
							end
						end
					}
				end
			end
		}
	end
end
function _sekDI:OnSetActive()
	_gFkfy = _O7OD("\108\011\085\007\112\062")
	_Urwigo.GlobalZoneActiveChanged()
end
function _ltoc:OnGetInput(input)
	if input == nil then
		input = ""
	end
	_uSP = input
	if Wherigo.NoCaseEquals(_uSP, _O7OD("\082\098\059\055\085\093\058\100\035\059\059\085\050")) then
		_n41P = _O7OD("\011\098\059\055\085\093\058\049\035\059\059\085\050")
		Wherigo.PlayAudio(_s5o)
		_FG3 = 2
		_5uE = 1
		_ZViz = 1
		_Ht2o = 1
		_dIHuD = 1
		_Urwigo.MessageBox{
			Text = _O7OD("\070\081\035\058\059\081\028\092\058\050\041\085\058\011\098\059\055\085\093\058\049\035\059\059\085\050\058\098\107\050\081\058\123\081\035\093\058\103\081\107\011\050\085\093\058\046\041\028\011\085\058\026\035\107\077"), 
			Media = _yxn, 
			Callback = function(action)
				if action ~= nil then
					Wherigo.ShowScreen(Wherigo.MAINSCREEN)
					Wherigo.Command "StopSound"
					_VNI:RequestSync()
				end
			end
		}
	elseif Wherigo.NoCaseEquals(_uSP, _O7OD("\082\050\028\007\085")) then
		_n41P = _O7OD("\011\050\028\007\085")
		Wherigo.PlayAudio(_s5o)
		_5uE = 2
		_ZViz = 1
		_FG3 = 1
		_Ht2o = 1
		_dIHuD = 1
		_Urwigo.MessageBox{
			Text = _O7OD("\070\081\035\058\059\081\028\092\058\050\041\085\058\011\050\028\007\085\058\098\107\050\081\058\123\081\035\093\058\103\081\107\011\050\085\093\058\046\041\028\011\085\058\026\035\107\077"), 
			Media = _f0Ga9, 
			Callback = function(action)
				if action ~= nil then
					Wherigo.ShowScreen(Wherigo.MAINSCREEN)
					Wherigo.Command "StopSound"
					_VNI:RequestSync()
				end
			end
		}
	elseif Wherigo.NoCaseEquals(_uSP, _O7OD("\099\059\028\103\085")) then
		_n41P = _O7OD("\010\059\028\103\085")
		Wherigo.PlayAudio(_s5o)
		_ZViz = 2
		_Ht2o = 1
		_FG3 = 1
		_5uE = 1
		_dIHuD = 1
		_Urwigo.MessageBox{
			Text = _O7OD("\070\081\035\058\059\081\028\092\058\050\041\085\058\010\059\028\103\085\058\098\107\050\081\058\123\081\035\093\058\103\081\107\011\050\085\093\058\046\041\028\011\085\058\026\035\107\077"), 
			Media = _QLMH, 
			Callback = function(action)
				if action ~= nil then
					Wherigo.ShowScreen(Wherigo.MAINSCREEN)
					Wherigo.Command "StopSound"
					_VNI:RequestSync()
				end
			end
		}
	elseif Wherigo.NoCaseEquals(_uSP, _O7OD("\027\028\093\059\098\121")) then
		_n41P = _O7OD("\026\028\093\059\098\121")
		Wherigo.PlayAudio(_s5o)
		_dIHuD = 2
		_Ht2o = 1
		_5uE = 1
		_Ht2o = 1
		_ZViz = 1
		_Urwigo.MessageBox{
			Text = _O7OD("\070\081\035\058\059\081\028\092\058\050\041\085\058\026\028\093\059\098\121\058\098\107\050\081\058\123\081\035\093\058\103\081\107\011\050\085\093\058\046\041\028\011\085\058\026\035\107\077"), 
			Media = _Z6qdw, 
			Callback = function(action)
				if action ~= nil then
					Wherigo.ShowScreen(Wherigo.MAINSCREEN)
					Wherigo.Command "StopSound"
					_VNI:RequestSync()
				end
			end
		}
	elseif Wherigo.NoCaseEquals(_uSP, _O7OD("\075\081\059\123\058\082\123\103\049\081\059")) then
		_n41P = _O7OD("\041\081\059\123\058\011\123\103\049\081\059")
		Wherigo.PlayAudio(_s5o)
		_Ht2o = 2
		_FG3 = 1
		_5uE = 1
		_ZViz = 1
		_dIHuD = 1
		_Urwigo.MessageBox{
			Text = _O7OD("\070\081\035\058\059\081\028\092\058\050\041\085\058\041\081\059\123\058\011\123\103\049\081\059\058\098\107\050\081\058\123\081\035\093\058\103\081\107\011\050\085\093\058\046\041\028\011\085\058\026\035\107\077"), 
			Media = _bcOqi, 
			Callback = function(action)
				if action ~= nil then
					Wherigo.ShowScreen(Wherigo.MAINSCREEN)
					Wherigo.Command "StopSound"
					_VNI:RequestSync()
				end
			end
		}
	else
		Wherigo.ShowScreen(Wherigo.MAINSCREEN)
	end
end
function _ASTUq:OnGetInput(input)
	if input == nil then
		input = ""
	end
	_29mGG = input
	if Wherigo.NoCaseEquals(_29mGG, _O7OD("\075\081\079\058\028\093\085\058\123\081\035\067")) then
		_Urwigo.MessageBox{
			Text = _O7OD("\070\081\035\058\079\028\107\050\058\050\081\058\007\107\081\079\058\041\081\079\058\062\058\028\103\058\092\081\098\107\026\067\067\067\058\075\103\103\002\058\107\081\058\081\107\085\058\041\028\011\058\028\011\007\085\092\058\103\085\058\050\041\028\050\058\049\085\010\081\093\085\077"), 
			Media = _WOgEJ, 
			Callback = function(action)
				if action ~= nil then
					Wherigo.Command "StopSound"
					_Urwigo.MessageBox{
						Text = _O7OD("\120\085\059\059\058\011\098\107\121\085\058\123\081\035\058\028\011\007\085\092\058\062\058\041\028\055\085\058\107\081\050\058\049\085\085\107\058\092\081\098\107\026\058\011\081\058\079\085\059\059\077\058\070\081\035\058\011\085\085\058\062\058\041\028\055\085\058\049\085\085\107\058\011\050\035\121\007\058\085\028\050\098\107\026\058\121\028\107\092\123\058\028\107\092\058\011\079\085\085\050\011\058\028\059\059\058\092\028\123\058\049\035\050\058\079\041\028\050\058\062\058\093\085\028\059\059\123\058\107\085\085\092\058\098\011\058\011\081\103\085\050\041\098\107\026\058\011\028\055\081\093\123\077\058\062\010\058\123\081\035\058\121\028\107\058\010\098\107\092\058\103\085\058\011\081\103\085\058\011\028\055\081\093\123\058\010\081\081\092\058\098\050\058\079\081\035\059\092\058\103\028\007\085\058\103\085\058\093\085\028\059\059\123\058\041\028\046\046\123\077"), 
						Media = _WOgEJ, 
						Callback = function(action)
							if action ~= nil then
								Wherigo.ShowScreen(Wherigo.MAINSCREEN)
								_VNI:RequestSync()
							end
						end
					}
				end
			end
		}
	else
		_Urwigo.MessageBox{
			Text = (_O7OD("\027\081\081\092\058\050\028\059\007\058")..Player.Name).._O7OD("\077\058\017\081\103\085\058\049\028\121\007\058\098\010\058\123\081\035\058\107\085\085\092\058\028\107\123\050\041\098\107\026\058\085\059\011\085\077"), 
			Media = _WOgEJ, 
			Callback = function(action)
				if action ~= nil then
					Wherigo.Command "StopSound"
					Wherigo.ShowScreen(Wherigo.MAINSCREEN)
					_VNI:RequestSync()
				end
			end
		}
	end
end
function _YmTv:OnGetInput(input)
	if input == nil then
		input = ""
	end
	if _Urwigo.Hash(string.lower(input)) == 50403 then
		_Urwigo.MessageBox{
			Text = _O7OD("\070\081\035\058\121\059\081\011\085\058\050\041\085\058\049\081\081\007\077"), 
			Media = _fF5, 
			Callback = function(action)
				if action ~= nil then
					Wherigo.ShowScreen(Wherigo.MAINSCREEN)
				end
			end
		}
	elseif _Urwigo.Hash(string.lower(input)) == 46520 then
		_Urwigo.MessageBox{
			Text = _O7OD("\115\055\085\107\058\028\058\103\028\107\058\079\041\081\058\098\011\058\046\035\093\085\058\098\107\058\041\085\028\093\050\058\028\107\092\058\011\028\123\011\058\041\098\011\058\046\093\028\123\085\093\011\058\049\123\058\107\098\026\041\050\002\058\103\028\123\058\049\085\121\081\103\085\058\028\058\079\081\059\010\058\079\041\085\107\058\050\041\085\058\079\081\059\010\058\049\028\107\085\058\049\059\081\081\103\011\058\028\107\092\058\050\041\085\058\028\035\050\035\103\107\058\103\081\081\107\058\098\011\058\049\093\098\026\041\050\077"), 
			Media = _T07, 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.MessageBox{
						Text = _O7OD("\062\050\058\098\011\058\011\028\098\092\058\050\041\028\050\058\028\058\079\085\093\085\079\081\059\010\058\121\028\107\058\081\107\059\123\058\049\085\058\007\098\059\059\085\092\058\049\123\058\028\058\011\098\059\055\085\093\058\079\085\028\046\081\107\058\081\093\058\049\123\058\011\081\103\085\081\107\085\058\079\041\081\058\050\093\035\059\123\058\059\081\055\085\011\058\050\041\085\103\077"), 
						Media = _T07, 
						Callback = function(action)
							if action ~= nil then
								_Urwigo.RunDialogs(function()
									Wherigo.GetInput(_YmTv)
								end)
							end
						end
					}
				end
			end
		}
	elseif _Urwigo.Hash(string.lower(input)) == 36791 then
		_Urwigo.MessageBox{
			Text = _O7OD("\061\028\103\046\098\093\085\011\058\046\081\011\085\011\058\011\035\046\085\093\058\041\035\103\028\107\058\011\050\093\085\107\026\050\041\058\028\107\092\058\028\093\085\058\121\035\093\011\085\092\058\050\081\058\079\028\059\007\058\050\041\085\058\085\028\093\050\041\058\010\081\093\058\028\059\059\058\085\050\085\093\107\098\050\123\077\058\076\107\123\081\107\085\058\049\098\050\050\085\107\058\049\123\058\028\058\055\028\103\046\098\093\085\058\079\098\059\059\058\028\059\011\081\058\050\035\093\107\058\035\107\056\092\085\028\092\077"), 
			Media = _E_5B, 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.MessageBox{
						Text = _O7OD("\061\028\103\046\098\093\085\011\058\028\093\085\058\028\059\103\081\011\050\058\098\107\055\098\107\121\098\049\059\085\002\058\049\035\050\058\050\041\085\093\085\058\028\093\085\058\028\058\010\085\079\058\079\028\123\011\058\050\081\058\092\028\103\028\026\085\058\050\041\085\103\083\058\026\028\093\059\098\121\002\058\041\081\059\123\058\011\123\103\049\081\059\011\002\058\011\035\107\059\098\026\041\050\002\058\028\107\092\058\028\058\011\050\028\007\085\058\050\041\093\081\035\026\041\058\050\041\085\058\041\085\028\093\050\077"), 
						Media = _E_5B, 
						Callback = function(action)
							if action ~= nil then
								_Urwigo.RunDialogs(function()
									Wherigo.GetInput(_YmTv)
								end)
							end
						end
					}
				end
			end
		}
	elseif _Urwigo.Hash(string.lower(input)) == 4006 then
		_Urwigo.MessageBox{
			Text = _O7OD("\099\093\028\107\007\085\107\011\050\085\098\107\058\098\011\058\081\107\085\058\081\010\058\050\041\085\058\103\081\011\050\058\046\081\079\085\093\010\035\059\058\103\081\107\011\050\085\093\011\058\081\010\058\028\059\059\077\058\075\098\011\058\049\081\092\123\058\098\011\058\103\028\092\085\058\081\035\050\058\081\010\058\046\028\093\050\011\058\011\050\081\059\085\107\058\010\093\081\103\058\050\041\085\058\026\093\028\055\085\123\028\093\092\002\058\011\085\079\107\058\050\081\026\085\050\041\085\093\058\028\107\092\058\010\098\107\028\059\059\123\058\049\093\081\035\026\041\050\058\049\028\121\007\058\050\081\058\059\098\010\085\058\049\123\058\085\059\085\121\050\093\098\121\098\050\123\077"), 
			Media = _hs5o, 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.MessageBox{
						Text = _O7OD("\099\093\028\107\007\085\107\011\050\085\098\107\058\098\011\058\085\012\050\093\085\103\085\059\123\058\092\028\107\026\085\093\081\035\011\077\058\073\081\107\011\050\085\093\058\085\012\046\085\093\050\011\058\121\059\028\098\103\058\050\041\028\050\058\081\107\059\123\058\010\059\028\103\085\011\058\121\028\107\058\121\081\103\046\059\085\050\085\059\123\058\092\085\011\050\093\081\123\098\107\026\058\041\098\011\058\049\081\092\123\077\058"), 
						Media = _hs5o, 
						Callback = function(action)
							if action ~= nil then
								_Urwigo.RunDialogs(function()
									Wherigo.GetInput(_YmTv)
								end)
							end
						end
					}
				end
			end
		}
	elseif _Urwigo.Hash(string.lower(input)) == 52543 then
		_Urwigo.MessageBox{
			Text = _O7OD("\073\035\103\103\098\085\011\058\028\093\085\058\050\041\085\058\093\085\056\028\107\098\103\028\050\085\092\058\121\081\093\046\011\085\011\058\081\010\058\028\107\121\098\085\107\050\058\115\026\123\046\050\098\028\107\058\046\093\098\085\011\050\011\077\058\076\058\103\035\103\103\123\058\079\098\059\059\058\028\093\098\011\085\058\079\041\085\107\058\041\098\011\058\028\107\121\098\085\107\050\058\093\085\011\050\098\107\026\058\046\059\028\121\085\058\041\028\011\058\049\085\085\107\058\092\098\011\050\035\093\049\085\092\077"), 
			Media = _PYCU3, 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.MessageBox{
						Text = _O7OD("\047\041\085\093\085\058\028\093\085\058\011\085\055\085\093\028\059\058\103\085\050\041\081\092\011\058\010\081\093\058\092\085\011\050\093\081\123\098\107\026\058\028\058\103\035\103\103\123\077\058\042\085\103\081\055\098\107\026\058\041\098\011\058\049\028\107\092\028\026\085\011\058\121\028\107\058\041\035\093\050\058\041\098\103\077\058\076\107\058\028\107\121\098\085\107\050\058\041\081\059\123\058\011\123\103\049\081\059\002\058\050\041\085\058\076\107\007\041\002\058\041\028\011\058\050\041\085\058\046\081\079\085\093\058\050\081\058\121\081\107\050\093\081\059\058\041\098\103\058\028\107\092\058\011\085\107\092\058\041\098\103\058\049\028\121\007\058\050\081\058\041\098\011\058\026\093\028\055\085\077"), 
						Media = _PYCU3, 
						Callback = function(action)
							if action ~= nil then
								_Urwigo.RunDialogs(function()
									Wherigo.GetInput(_YmTv)
								end)
							end
						end
					}
				end
			end
		}
	end
end
function _cPqI:On_wp_P(target)
	Wherigo.PlayAudio(_5d_)
	_1Izq = 2
	_Lnm.Complete = true
	_Urwigo.MessageBox{
		Text = (_O7OD("\075\085\059\059\081\058\050\041\085\093\085\058")..Player.Name).._O7OD("\002\058\062\058\028\103\058\061\028\107\058\075\085\059\011\098\107\026\002\058\059\085\026\085\107\092\028\093\123\058\103\081\107\011\050\085\093\058\041\035\107\050\085\093\077\058\076\058\050\085\093\093\098\049\059\085\058\092\098\011\028\011\050\085\093\058\041\028\011\058\081\121\121\035\093\093\085\092\077\077\077"), 
		Media = _vby, 
		Callback = function(action)
			if action ~= nil then
				Wherigo.Command "StopSound"
				Wherigo.PlayAudio(_6H_s)
				_Urwigo.MessageBox{
					Text = _O7OD("\073\081\107\011\050\085\093\011\058\041\028\055\085\058\085\011\121\028\046\085\092\058\050\041\085\058\035\107\092\085\093\079\081\093\059\092\058\050\041\093\081\035\026\041\058\028\058\046\081\093\050\028\059\058\028\107\092\058\028\093\085\058\059\081\081\011\085\058\098\107\058\065\098\093\007\079\081\081\092\058\018\028\093\007\101\101\101"), 
					Media = _H02d, 
					Buttons = {
						_O7OD("\070\098\007\085\011\101")
					}, 
					Callback = function(action)
						if action ~= nil then
							_Urwigo.MessageBox{
								Text = _O7OD("\112\093\028\121\035\059\028\002\058\099\093\028\107\007\085\107\011\050\085\098\107\002\058\120\081\059\010\103\028\107\002\058\028\107\092\058\050\041\085\058\073\035\103\103\123\058\041\028\055\085\058\028\059\059\058\085\011\121\028\046\085\092\077\058\120\085\058\107\085\085\092\058\050\081\058\092\081\058\011\081\103\085\050\041\098\107\026\058\049\085\010\081\093\085\058\011\081\103\085\081\107\085\058\026\085\050\011\058\041\035\093\050\101"), 
								Media = _0EQa, 
								Buttons = {
									_O7OD("\084\085\050\011\058\026\085\050\058\085\103\101"), 
									_O7OD("\097\081\050\058\073\085\101")
								}, 
								Callback = function(action)
									if action ~= nil then
										Wherigo.Command "StopSound"
										if action == "Button1" then
											_Urwigo.MessageBox{
												Text = _O7OD("\047\028\007\085\058\050\041\098\011\058\018\077\065\077\115\077\058\073\085\050\085\093\077\058\062\050\058\079\098\059\059\058\103\085\028\011\035\093\085\058\050\041\085\058\028\103\081\035\107\050\058\081\010\058\018\011\123\121\041\081\056\065\098\107\085\050\098\121\058\033\073\081\107\011\050\085\093\006\058\115\107\085\093\026\123\058\098\107\058\050\041\085\058\028\093\085\028\058\011\081\058\079\085\058\121\028\107\058\010\098\107\092\058\081\035\050\058\079\041\085\093\085\058\050\041\085\058\103\081\107\011\050\085\093\011\058\028\093\085\058\041\098\092\098\107\026\077"), 
												Media = _vby, 
												Callback = function(action)
													if action ~= nil then
														_Urwigo.MessageBox{
															Text = "", 
															Media = _9lOe7, 
															Buttons = {
																_O7OD("\047\041\028\107\007\058\123\081\035\101")
															}, 
															Callback = function(action)
																if action ~= nil then
																	_Urwigo.MessageBox{
																		Text = _O7OD("\047\041\085\058\018\077\065\077\115\077\058\103\085\050\085\093\058\098\011\058\055\085\093\123\058\011\085\107\011\098\050\098\055\085\058\011\081\058\098\010\058\050\041\085\093\085\058\028\093\085\058\028\107\123\058\103\081\107\011\050\085\093\011\058\107\085\028\093\049\123\058\098\050\058\011\041\081\035\059\092\058\046\098\121\007\058\050\041\085\103\058\035\046\077\058\047\041\085\058\103\085\050\085\093\058\098\011\058\107\081\079\058\059\081\121\028\050\085\092\058\098\107\058\123\081\035\093\058\098\050\085\103\011\058\050\028\049\077\058\073\028\007\085\058\011\035\093\085\058\050\081\058\050\035\093\107\058\098\050\058\081\107\058\049\085\010\081\093\085\058\123\081\035\058\011\050\028\093\050\077"), 
																		Media = _9lOe7, 
																		Callback = function(action)
																			if action ~= nil then
																				_Urwigo.MessageBox{
																					Text = _O7OD("\119\107\121\085\058\123\081\035\058\041\028\055\085\058\050\035\093\107\085\092\058\050\041\085\058\018\077\065\077\115\058\103\085\050\085\093\058\081\107\058\010\081\059\059\081\079\058\050\041\085\058\046\028\050\041\058\050\081\058\050\041\085\058\097\081\093\050\041\058\120\085\011\050\077\058\070\081\035\058\079\081\107\005\050\058\049\085\058\028\049\059\085\058\050\081\058\011\085\085\058\050\041\085\058\103\081\107\011\050\085\093\011\058\049\035\050\058\123\081\035\093\058\018\077\065\077\115\058\103\085\050\085\093\058\011\041\081\035\059\092\058\046\098\121\007\058\050\041\085\103\058\035\046\077"), 
																					Media = _9lOe7, 
																					Callback = function(action)
																						if action ~= nil then
																							_Urwigo.MessageBox{
																								Text = _O7OD("\047\035\093\107\058\081\107\058\123\081\035\093\058\018\077\065\077\115\058\103\085\050\085\093\058\081\107\058\033\059\081\121\028\050\085\092\058\098\107\058\123\081\035\093\058\098\107\055\085\107\050\081\093\123\006\058\028\107\092\058\010\081\059\059\081\079\058\050\041\085\058\046\028\050\041\058\050\081\058\050\041\085\058\107\081\093\050\041\058\079\085\011\050\058\050\081\058\010\098\107\092\058\050\041\085\058\103\081\107\011\050\085\093\011\077"), 
																								Media = _GHR, 
																								Callback = function(action)
																									if action ~= nil then
																										_hBS39:MoveTo(Player)
																										_1Izq = 1
																										_uoq.Active = true
																										_cPqI.Commands._wp_P.Enabled = false
																										_cPqI.Commands._X7AW.Enabled = true
																										Wherigo.ShowScreen(Wherigo.MAINSCREEN)
																									end
																								end
																							}
																							_VNI:RequestSync()
																						end
																					end
																				}
																			end
																		end
																	}
																end
															end
														}
													end
												end
											}
										elseif action == "Button2" then
											_Urwigo.MessageBox{
												Text = _O7OD("\062\010\058\123\081\035\058\121\041\028\107\026\085\058\123\081\035\093\058\103\098\107\092\058\123\081\035\058\007\107\081\079\058\079\041\085\093\085\058\050\081\058\010\098\107\092\058\103\085\077"), 
												Media = _vby, 
												Callback = function(action)
													if action ~= nil then
														_1Izq = 1
														Wherigo.ShowScreen(Wherigo.MAINSCREEN)
													end
												end
											}
										end
									end
								end
							}
						end
					end
				}
			end
		end
	}
end
function _cPqI:On_X7AW(target)
	Wherigo.PlayAudio(_5d_)
	_Urwigo.MessageBox{
		Text = (_O7OD("\075\098\058")..Player.Name).._O7OD("\058\123\081\035\058\028\093\085\058\092\081\098\107\026\058\026\081\081\092\077\058\119\107\121\085\058\123\081\035\058\041\028\055\085\058\050\035\093\107\085\092\058\050\041\085\058\018\077\065\077\115\077\058\073\085\050\085\093\058\081\107\058\010\081\059\059\081\079\058\050\041\085\058\046\028\050\041\058\050\081\058\050\041\085\058\097\081\093\050\041\120\085\011\050\002"), 
		Media = _vby, 
		Callback = function(action)
			if action ~= nil then
				_Urwigo.MessageBox{
					Text = _O7OD("\062\010\058\123\081\035\058\026\085\050\058\011\050\035\121\007\002\058\121\041\085\121\007\058\050\041\085\058\050\028\011\007\011\058\103\085\107\035\077\058\070\081\035\058\079\098\059\059\058\010\098\107\092\058\041\098\107\050\011\058\050\041\085\093\085\058\028\049\081\035\050\058\079\041\028\050\058\050\081\058\092\081\058\107\085\012\050\077"), 
					Media = _vby, 
					Callback = function(action)
						if action ~= nil then
							Wherigo.Command "StopSound"
							Wherigo.ShowScreen(Wherigo.MAINSCREEN)
						end
					end
				}
			end
		end
	}
end
function _XVo:On_tyFh(target)
	_Urwigo.RunDialogs(function()
		Wherigo.GetInput(_ASTUq)
	end)
end
function _aUf:On_p7Zl(target)
	if target == _OrT then
		Wherigo.PlayAudio(_eHPe)
		_Lh0Wk()
		_Urwigo.MessageBox{
			Text = (((_O7OD("\070\081\035\058\010\098\093\085\058\081\010\010\058\050\041\085\058").._n41P).._O7OD("\058\028\050\058")).._OrT.Name).._O7OD("\077"), 
			Media = _eWX, 
			Callback = function(action)
				if action ~= nil then
					if _FG3 == 2 then
						Wherigo.Command "StopSound"
						_Urwigo.MessageBox{
							Text = _O7OD("\070\081\035\058\041\098\050\058\079\081\059\010\103\028\107\101"), 
							Media = _ocRY, 
							Callback = function(action)
								if action ~= nil then
									_FG3 = 1
									_n41P = _O7OD("\085\103\046\050\123\058\093\081\035\107\092\058")
									Wherigo.PlayAudio(_L0V)
									_Urwigo.MessageBox{
										Text = _O7OD("\047\041\085\058\011\098\059\055\085\093\058\049\035\059\059\085\050\058\011\050\093\098\007\085\011\058\050\093\035\085\058\028\107\092\058\050\041\085\058\120\081\059\010\103\028\107\058\092\098\011\028\046\046\085\028\093\011\058\098\107\050\081\058\028\058\121\059\081\035\092\058\081\010\058\092\035\011\050\077"), 
										Media = _V9sf2, 
										Callback = function(action)
											if action ~= nil then
												Wherigo.Command "StopSound"
												_Urwigo.MessageBox{
													Text = _O7OD("\027\081\081\092\058\013\081\049\058\007\098\092\101\058\070\081\035\058\026\081\050\058\050\041\085\058\120\081\059\010\103\028\107\077\058\084\085\050\011\058\026\081\058\026\085\050\058\050\041\085\058\093\085\011\050\058\081\010\058\050\041\085\058\103\081\107\011\050\085\093\011\058\107\081\079\101"), 
													Media = _vby, 
													Callback = function(action)
														if action ~= nil then
															_g5m2 = _g5m2 + 1
															_gXX.Active = false
															Wherigo.ShowScreen(Wherigo.MAINSCREEN)
															_uBX()
														end
													end
												}
											end
										end
									}
								end
							end
						}
					else
						_Urwigo.MessageBox{
							Text = (_O7OD("\097\081\050\041\098\107\026\058\041\028\046\046\085\107\011\002\058\050\041\085\058").._n41P).._O7OD("\058\092\081\085\011\058\107\081\050\058\028\010\010\085\121\050\058\050\041\085\058\120\081\059\010\103\028\107\077\058"), 
							Media = _3Qy, 
							Callback = function(action)
								if action ~= nil then
									Wherigo.Command "StopSound"
									_n41P = _O7OD("\085\103\046\050\123\058\093\081\035\107\092\058")
									_sdZ()
									_uBX()
									Wherigo.ShowScreen(Wherigo.MAINSCREEN)
									_VNI:RequestSync()
								end
							end
						}
					end
				end
			end
		}
	elseif target == _apJFp then
		Wherigo.PlayAudio(_eHPe)
		_Lh0Wk()
		_Urwigo.MessageBox{
			Text = (((_O7OD("\070\081\035\058\010\098\093\085\058\081\010\010\058\050\041\085\058").._n41P).._O7OD("\058\028\050\058")).._apJFp.Name).._O7OD("\077"), 
			Media = _eWX, 
			Callback = function(action)
				if action ~= nil then
					if _ZViz == 2 then
						Wherigo.Command "StopSound"
						_Urwigo.MessageBox{
							Text = _O7OD("\070\081\035\058\041\098\050\058\099\093\028\107\007\085\107\011\050\085\098\107\101"), 
							Media = _6FS, 
							Callback = function(action)
								if action ~= nil then
									_ZViz = 1
									_n41P = _O7OD("\085\103\046\123\058\093\081\035\107\092\058")
									Wherigo.PlayAudio(_L0V)
									_Urwigo.MessageBox{
										Text = _O7OD("\076\058\049\035\093\011\050\058\081\010\058\010\059\028\103\085\058\011\041\081\081\050\011\058\035\046\058\098\107\058\050\041\085\058\028\098\093\058\028\107\092\058\123\081\035\058\011\085\085\058\099\093\028\107\007\085\107\011\050\085\098\107\058\092\098\011\028\046\046\085\028\093\058\049\028\121\007\058\098\107\050\081\058\050\041\085\058\035\107\092\085\093\079\081\093\059\092\077"), 
										Media = _AQwE, 
										Callback = function(action)
											if action ~= nil then
												Wherigo.Command "StopSound"
												_Urwigo.MessageBox{
													Text = _O7OD("\027\081\081\092\058\013\081\049\058\007\098\092\101\058\070\081\035\058\026\081\050\058\099\093\028\107\007\085\107\011\050\085\098\107\101\058\084\085\050\011\058\026\081\058\026\085\050\058\050\041\085\058\093\085\011\050\058\081\010\058\050\041\085\058\103\081\107\011\050\085\093\011\058\107\081\079\101"), 
													Media = _vby, 
													Callback = function(action)
														if action ~= nil then
															_ywd.Active = false
															_g5m2 = _g5m2 + 1
															Wherigo.ShowScreen(Wherigo.MAINSCREEN)
															_uBX()
														end
													end
												}
											end
										end
									}
								end
							end
						}
					else
						_Urwigo.MessageBox{
							Text = (_O7OD("\097\081\050\041\098\107\026\058\041\028\046\046\085\107\011\002\058\050\041\085\058").._n41P).._O7OD("\058\092\081\085\011\058\107\081\050\058\028\010\010\085\121\050\058\010\093\028\107\007\085\107\011\050\085\098\107\077\058"), 
							Media = _3Qy, 
							Callback = function(action)
								if action ~= nil then
									Wherigo.Command "StopSound"
									_n41P = _O7OD("\085\103\046\050\123\058\093\081\035\107\092\058")
									_sdZ()
									_uBX()
									Wherigo.ShowScreen(Wherigo.MAINSCREEN)
									_VNI:RequestSync()
								end
							end
						}
					end
				end
			end
		}
	elseif target == _EWoin then
		Wherigo.PlayAudio(_eHPe)
		_Lh0Wk()
		_Urwigo.MessageBox{
			Text = (((_O7OD("\070\081\035\058\010\098\093\085\058\081\010\010\058\050\041\085\058").._n41P).._O7OD("\058\028\050\058")).._EWoin.Name).._O7OD("\077"), 
			Media = _eWX, 
			Callback = function(action)
				if action ~= nil then
					Wherigo.Command "StopSound"
					if ((_5uE == 2) or (_dIHuD == 2)) or (_Ht2o == 2) then
						Wherigo.PlayAudio(_KWJv)
						_acTrJ = _acTrJ + 1
						_sdZ()
						_n41P = _O7OD("\085\103\046\123\058\093\081\035\107\092\058")
						_Urwigo.MessageBox{
							Text = _O7OD("\070\081\035\058\041\098\050\058\112\093\028\121\035\059\028\101\058\075\085\058\041\098\011\011\085\011\058\028\050\058\123\081\035\058\049\035\050\058\098\011\058\107\081\050\058\092\085\028\092\058\123\085\050\077"), 
							Media = _W6J, 
							Callback = function(action)
								if action ~= nil then
									_uBX()
									Wherigo.Command "StopSound"
									if _acTrJ == 4 then
										Wherigo.PlayAudio(_L0V)
										_Lh0Wk()
										_Urwigo.MessageBox{
											Text = _O7OD("\112\093\028\121\035\059\028\058\010\098\107\028\059\059\123\058\010\028\059\059\011\058\050\081\058\050\041\085\058\026\093\081\035\107\092\058\028\107\092\058\028\058\046\098\059\059\028\093\058\081\010\058\011\103\081\007\085\058\011\041\081\081\050\011\058\035\046\058\010\093\081\103\058\079\041\085\093\085\058\041\085\058\011\050\081\081\092\077\058\070\081\035\058\092\085\010\085\028\050\085\092\058\112\093\028\121\035\059\028\101\101\101"), 
											Media = _AQwE, 
											Callback = function(action)
												if action ~= nil then
													Wherigo.Command "StopSound"
													Wherigo.PlayAudio(_6H_s)
													_Urwigo.MessageBox{
														Text = _O7OD("\070\081\035\058\041\085\028\093\058\028\058\026\093\085\028\050\058\041\081\059\059\081\079\098\107\026\058\079\098\107\092\058\028\011\058\028\058\046\081\093\050\028\059\058\081\046\085\107\011\058\035\046\058\098\107\058\050\041\085\058\028\098\093\077\058\047\041\085\058\059\028\011\050\058\093\085\103\028\098\107\011\058\081\010\058\050\041\085\058\103\081\107\011\050\085\093\011\058\010\059\123\058\050\041\093\081\035\026\041\058\050\041\085\058\046\081\093\050\028\059\058\028\107\092\058\049\028\121\007\058\098\107\050\081\058\050\041\085\058\035\107\092\085\093\079\081\093\059\092\077"), 
														Media = _H02d, 
														Buttons = {
															_O7OD("\061\098\121\050\081\093\123\101")
														}, 
														Callback = function(action)
															if action ~= nil then
																_Urwigo.MessageBox{
																	Text = (_O7OD("\070\081\035\058\092\098\092\058\098\050\058")..Player.Name).._O7OD("\101\058\070\081\035\058\010\098\107\028\059\059\123\058\092\085\010\085\028\050\085\092\058\028\059\059\058\081\010\058\050\041\085\058\103\081\107\011\050\085\093\011\101\058\062\058\092\098\092\107\005\050\058\050\041\098\107\007\058\098\050\058\079\028\011\058\046\081\011\011\098\049\059\085\077\058\076\011\058\028\058\011\046\085\121\098\028\059\058\093\085\079\028\093\092\058\062\058\041\028\055\085\058\059\085\010\050\058\123\081\035\058\011\081\103\085\050\041\098\107\026\058\092\081\079\107\058\049\123\058\050\041\085\058\121\085\103\085\050\085\093\123\077\058\047\041\085\058\121\081\081\093\092\098\107\028\050\085\011\058\028\093\085\058\098\107\058\123\081\035\093\058\098\107\055\085\107\050\081\093\123\077\058\047\041\028\107\007\011\058\028\026\028\098\107\101"), 
																	Media = _vby, 
																	Buttons = {
																		_O7OD("\075\081\081\093\028\123\101\101\101")
																	}, 
																	Callback = function(action)
																		if action ~= nil then
																			_zrpp.Complete = true
																			_sekDI.Active = true
																			_tC_.Active = false
																			__mz:MoveTo(Player)
																			_sdZ()
																			Wherigo.ShowScreen(Wherigo.MAINSCREEN)
																			_VNI:RequestSync()
																			Wherigo.Command "StopSound"
																		end
																	end
																}
															end
														end
													}
												end
											end
										}
									end
								end
							end
						}
					else
						_Urwigo.MessageBox{
							Text = (_O7OD("\097\081\050\041\098\107\026\058\041\028\046\046\085\107\011\002\058\050\041\085\058").._n41P).._O7OD("\058\092\081\085\011\058\107\081\050\058\028\010\010\085\121\050\058\112\093\028\121\035\059\028\077\058"), 
							Media = _3Qy, 
							Callback = function(action)
								if action ~= nil then
									Wherigo.Command "StopSound"
									_n41P = _O7OD("\085\103\046\050\123\058\093\081\035\107\092\058")
									_sdZ()
									_uBX()
									Wherigo.ShowScreen(Wherigo.MAINSCREEN)
									_VNI:RequestSync()
								end
							end
						}
					end
				end
			end
		}
	elseif target == _HMI then
		Wherigo.PlayAudio(_eHPe)
		_Lh0Wk()
		_Urwigo.MessageBox{
			Text = (((_O7OD("\070\081\035\058\010\098\093\085\058\081\010\010\058\050\041\085\058").._n41P).._O7OD("\058\028\050\058\050\041\085\058")).._HMI.Name).._O7OD("\077"), 
			Media = _eWX, 
			Callback = function(action)
				if action ~= nil then
					Wherigo.Command "StopSound"
					if _Ht2o == 2 then
						_Urwigo.MessageBox{
							Text = _O7OD("\070\081\035\058\041\098\050\058\050\041\085\058\073\035\103\103\123\101"), 
							Media = _sIdhw, 
							Callback = function(action)
								if action ~= nil then
									_Ht2o = 1
									_n41P = _O7OD("\058\085\103\046\123\058\093\081\035\107\092\058")
									Wherigo.PlayAudio(_L0V)
									_Urwigo.MessageBox{
										Text = _O7OD("\047\041\085\058\073\035\103\103\123\058\098\011\058\046\028\093\028\059\123\126\085\092\058\049\123\058\050\041\085\058\041\081\059\123\058\011\123\103\049\081\059\058\028\107\092\058\041\085\058\011\041\081\081\050\011\058\035\046\058\098\107\058\028\058\121\059\081\035\092\058\081\010\058\092\035\011\050\077"), 
										Media = _V9sf2, 
										Callback = function(action)
											if action ~= nil then
												Wherigo.Command "StopSound"
												_Urwigo.MessageBox{
													Text = _O7OD("\027\081\081\092\058\013\081\049\058\007\098\092\101\058\070\081\035\058\026\081\050\058\050\041\085\058\073\035\103\103\123\101\058\084\085\050\011\058\026\081\058\026\085\050\058\050\041\085\058\093\085\011\050\058\081\010\058\050\041\085\058\103\081\107\011\050\085\093\011\058\107\081\079\101"), 
													Media = _vby, 
													Callback = function(action)
														if action ~= nil then
															_g5m2 = _g5m2 + 1
															_gxiA.Active = false
															Wherigo.ShowScreen(Wherigo.MAINSCREEN)
															_uBX()
														end
													end
												}
											end
										end
									}
								end
							end
						}
					else
						_Urwigo.MessageBox{
							Text = (_O7OD("\097\081\050\041\098\107\026\058\041\028\046\046\085\107\011\002\058\050\041\085\058").._n41P).._O7OD("\058\092\081\085\011\058\107\081\050\058\028\010\010\085\121\050\058\050\041\085\058\073\035\103\103\123\077\058"), 
							Media = _3Qy, 
							Callback = function(action)
								if action ~= nil then
									_n41P = _O7OD("\085\103\046\050\123\058\093\081\035\107\092\058")
									_sdZ()
									_uBX()
									Wherigo.ShowScreen(Wherigo.MAINSCREEN)
									_VNI:RequestSync()
									Wherigo.Command "StopSound"
								end
							end
						}
					end
				end
			end
		}
	elseif target == _XVo then
		if _dIHuD == 2 then
			Wherigo.PlayAudio(_eHPe)
			_Urwigo.MessageBox{
				Text = _O7OD("\027\028\093\059\098\121\101\058\070\081\035\058\049\093\081\035\026\041\050\058\103\085\058\026\028\093\059\098\121\077\058\062\058\007\107\085\079\058\123\081\035\058\121\081\035\059\092\058\092\081\058\098\050\077\058\047\041\098\011\058\098\011\058\013\035\011\050\058\079\041\028\050\058\062\058\079\028\107\050\085\092\077\058\033\082\059\098\103\085\093\058\112\028\107\121\098\107\026\006\058\075\028\046\046\123\058\041\028\046\046\123\101\058\013\081\123\058\013\081\123\101\058\075\028\046\046\123\058\041\028\046\046\123\101\058\013\081\123\058\013\081\123\101\058\062\050\005\011\058\103\123\058\041\028\046\046\123\058\092\028\107\121\085\077\058\062\050\011\058\103\123\058\041\028\046\046\123\058\092\028\107\121\085\077\058\044\107\049\011\046\125\083\056\112"), 
				Media = _WOgEJ, 
				Callback = function(action)
					if action ~= nil then
						_n41P = _O7OD("\085\103\046\123\058\093\081\035\107\092\058")
						_sdZ()
						_Asx.Active = false
						Wherigo.Command "StopSound"
						Wherigo.ShowScreen(Wherigo.MAINSCREEN)
						_VNI:RequestSync()
					end
				end
			}
		else
			Wherigo.PlayAudio(_wJweO)
			_Urwigo.MessageBox{
				Text = _O7OD("\119\035\121\041\101\058\112\081\107\005\050\058\011\041\081\081\050\058\103\085\077"), 
				Media = _WOgEJ, 
				Callback = function(action)
					if action ~= nil then
						Wherigo.Command "StopSound"
						Wherigo.ShowScreen(Wherigo.MAINSCREEN)
					end
				end
			}
		end
	end
end
function _hBS39:On_GDu(target)
	Wherigo.PlayAudio(_C7A)
	_Urwigo.MessageBox{
		Text = _O7OD("\047\041\085\058\018\077\065\077\115\058\103\085\050\085\093\058\049\085\026\098\107\011\058\050\081\058\026\059\081\079\077\058\062\050\058\098\011\058\107\081\079\058\050\035\093\107\085\092\058\081\107\058\028\107\092\058\093\085\028\092\123\058\050\081\058\010\081\093\058\035\011\085\077"), 
		Media = _9lOe7, 
		Buttons = {
			_O7OD("\017\081\081\059\101")
		}, 
		Callback = function(action)
			if action ~= nil then
				_hBS39.Description = _O7OD("\047\041\085\058\018\077\065\077\115\058\103\085\050\085\093\058\098\011\058\046\081\079\085\093\085\092\058\081\107\077")
				_hBS39.Commands._GDu.Enabled = false
				_gxiA.ProximityRange = Distance(178, "meters")
				_tC_.ProximityRange = Distance(178, "meters")
				_gXX.ProximityRange = Distance(178, "meters")
				_gXX.Active = true
				_tC_.Active = true
				_gxiA.Active = true
				_gxiA.Visible = false
				_tC_.Visible = false
				_gXX.Visible = false
				_EWoin.Visible = false
				_apJFp.Visible = false
				_HMI.Visible = false
				_OrT.Visible = false
				Wherigo.ShowScreen(Wherigo.MAINSCREEN)
				Wherigo.Command "StopSound"
				_VNI:RequestSync()
			end
		end
	}
end
function _bAq5:On_mr0(target)
	_Urwigo.RunDialogs(function()
		Wherigo.GetInput(_ltoc)
	end)
end
function _3E5ly:On_V9z(target)
	_gxiA.Visible = true
	_Asx.Active = true
	_gxiA.Active = true
	_gXX.Active = true
	_ywd.Active = true
	_bAq5:MoveTo(Player)
	__mz:MoveTo(Player)
	_BBvM:MoveTo(Player)
	_sekDI.Active = true
	_aUf:MoveTo(Player)
	_hBS39:MoveTo(Player)
	_ywd.Visible = true
	_tC_.Visible = true
	_gXX.Visible = true
end
function __mz:On_0OX(target)
	_Urwigo.MessageBox{
		Text = _O7OD("\047\041\085\058\026\085\081\121\028\121\041\085\058\098\011\058\059\081\121\028\050\085\092\058\028\050\058\097\058\038\078\058\038\063\077\127\078\060\058\120\058\089\060\058\053\063\077\089\063\066\077\058\082\085\028\093\121\041\058\050\041\085\058\041\081\107\085\123\011\035\121\007\059\085\058\050\093\085\085\058\098\107\058\050\041\085\058\026\093\081\055\085\077\058\070\081\035\058\028\093\085\058\059\081\081\007\098\107\026\058\010\081\093\058\028\107\058\085\012\050\093\028\056\059\028\093\026\085\058\049\098\011\081\107\058\050\035\049\085\058\028\050\058\050\041\085\058\049\028\011\085\058\081\010\058\050\041\085\058\050\041\093\085\085\058\050\093\035\107\007\058\050\093\085\085\077"), 
		Media = _BEZ, 
		Callback = function(action)
			if action ~= nil then
				Wherigo.ShowScreen(Wherigo.MAINSCREEN)
				_VNI:RequestSync()
			end
		end
	}
end
function _mpGUV:On_dt09e(target)
	_Urwigo.RunDialogs(function()
		Wherigo.GetInput(_YmTv)
	end)
end
function _Urwigo.GlobalZoneActiveChanged()
	if _g5m2 == 4 then
		_Urwigo.MessageBox{
			Text = _O7OD("\120\081\079\002\058\123\081\035\058\026\081\050\058\028\059\059\058\081\010\058\050\041\085\058\103\081\107\011\050\085\093\011\101\058\062\050\058\059\081\081\007\011\058\059\098\007\085\058\050\041\085\093\085\058\098\011\058\081\107\085\058\059\028\011\050\058\103\081\107\011\050\085\093\058\050\041\081\035\026\041\077\058\112\093\028\121\035\059\028\058\041\028\011\058\028\046\046\085\028\093\085\092\058\028\107\092\058\041\085\058\098\011\058\081\055\085\093\058\081\107\058\050\041\085\058\103\028\098\107\058\011\050\028\026\085\077\058"), 
			Media = _vby, 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.MessageBox{
						Text = _O7OD("\070\081\035\058\103\028\123\058\041\028\055\085\058\050\081\058\035\011\085\058\085\012\050\093\028\058\103\085\028\011\035\093\085\011\058\050\081\058\092\085\010\085\028\050\058\041\098\103\077\058\047\093\123\058\079\041\098\121\041\085\055\085\093\058\028\103\103\081\058\123\081\035\058\050\041\098\107\007\058\103\098\026\041\050\058\079\081\093\007\058\081\107\058\041\098\103\077"), 
						Media = _vby, 
						Callback = function(action)
							if action ~= nil then
								_tC_.Active = true
								Wherigo.ShowScreen(Wherigo.MAINSCREEN)
								_VNI:RequestSync()
							end
						end
					}
				end
			end
		}
	end
end

-- Urwigo functions --
function _sDDri()
	_EWoin.Visible = true
	_apJFp.Visible = true
	_HMI.Visible = true
	_OrT.Visible = true
end
function _sSvxO()
	if _g5m2 == 4 then
		_muk.Complete = true
		_Urwigo.MessageBox{
			Text = _O7OD("\120\081\079\002\058\123\081\035\058\026\081\050\058\028\059\059\058\081\010\058\050\041\085\058\103\081\107\011\050\085\093\011\101\058\076\058\107\085\079\058\103\081\107\011\050\085\093\058\041\028\011\058\028\046\046\085\028\093\085\092\058\050\041\081\035\026\041\077\058\112\093\028\121\035\059\028\058\098\011\058\081\055\085\093\058\098\107\058\050\041\085\058\050\041\085\028\050\093\085\101"), 
			Media = _vby, 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.MessageBox{
						Text = _O7OD("\120\028\050\121\041\081\035\050\002\058\123\081\035\058\103\028\123\058\041\028\055\085\058\050\081\058\035\011\085\058\085\012\050\093\028\058\103\085\028\011\035\093\085\011\058\050\081\058\092\085\010\085\028\050\058\041\098\103\077\058\047\093\123\058\079\041\098\121\041\085\055\085\093\058\028\103\103\081\058\123\081\035\058\050\041\098\107\007\058\103\098\026\041\050\058\079\081\093\007\058\081\107\058\041\098\103\077"), 
						Media = _vby, 
						Buttons = {
							_O7OD("\076\103\103\081\067\058\062\058\026\081\050\058\050\041\098\011")
						}, 
						Callback = function(action)
							if action ~= nil then
								_g5m2 = 0
								_ywd.Active = false
								_gxiA.Active = false
								_gXX.Active = false
								_tC_.Active = true
								_tC_.Visible = true
								_zrpp.Active = false
								Wherigo.ShowScreen(Wherigo.MAINSCREEN)
								_VNI:RequestSync()
							end
						end
					}
				end
			end
		}
	elseif (((_ywd.Active == false) and (_gXX.Active == false)) and (_gxiA.Active == false)) or (_g5m2 == 4) then
	end
end
function _9Mv()
	Wherigo.PlayAudio(_k_P)
	_Urwigo.MessageBox{
		Text = _O7OD("\070\081\035\093\058\018\077\065\077\115\058\103\085\050\085\093\058\011\050\028\093\050\011\058\050\081\058\079\041\098\093\059\058\059\098\007\085\058\121\093\028\126\123\077\058\047\041\085\093\085\058\028\093\085\058\103\081\107\011\050\085\093\011\058\107\085\028\093\049\123\101"), 
		Media = _9lOe7, 
		Callback = function(action)
			if action ~= nil then
				_uoq.Complete = true
				Wherigo.Command "StopSound"
				_Urwigo.MessageBox{
					Text = _O7OD("\061\085\093\123\058\107\098\121\085\101\058\070\081\035\058\041\028\055\085\058\010\081\035\107\092\058\050\041\085\058\103\081\107\011\050\085\093\011\077\058\062\050\058\059\081\081\007\011\058\059\098\007\085\058\099\093\028\107\007\085\107\011\050\085\098\107\002\058\120\081\059\010\103\028\107\058\028\107\092\058\050\041\085\058\073\035\103\103\123\058\028\093\085\058\028\059\059\058\107\085\028\093\049\123\077\058\070\081\035\058\079\098\059\059\058\107\085\085\092\058\028\058\079\085\028\046\081\107\058\050\081\058\010\098\026\041\050\058\050\041\085\103\077\058\047\028\007\085\058\050\041\098\011\058\103\081\107\011\050\085\093\058\046\041\028\011\085\058\026\035\107\077"), 
					Media = _vby, 
					Callback = function(action)
						if action ~= nil then
							Wherigo.PlayAudio(_s5o)
							_Urwigo.MessageBox{
								Text = "", 
								Media = _qw0, 
								Callback = function(action)
									if action ~= nil then
										_aUf:MoveTo(Player)
										_Urwigo.MessageBox{
											Text = _O7OD("\070\081\035\058\079\098\059\059\058\028\059\011\081\058\107\085\085\092\058\028\103\103\035\107\098\050\098\081\107\077\058\075\085\028\092\058\081\055\085\093\058\050\081\058\050\041\085\058\121\081\107\121\085\011\011\098\081\107\058\011\050\028\107\092\077\058\062\058\041\028\055\085\058\028\058\010\093\098\085\107\092\058\079\041\081\058\062\058\050\041\098\107\007\058\103\028\123\058\049\085\058\028\049\059\085\058\050\081\058\041\085\059\046\058\123\081\035\077"), 
											Media = _vby, 
											Callback = function(action)
												if action ~= nil then
													_gXX.ProximityRange = Distance(8, "meters")
													_gxiA.ProximityRange = Distance(8, "meters")
													_ywd.ProximityRange = Distance(8, "meters")
													_tC_.ProximityRange = Distance(8, "meters")
													_ywd.Active = false
													_gxiA.Active = false
													_gXX.Active = false
													_tC_.Active = false
													_nZg2Z.Active = false
													_Asx.Active = true
													_R73H_ = 2
													_nfW = 2
													_t6s = 2
													_N1Sp0 = 2
													_rWq = 2
													Wherigo.ShowScreen(Wherigo.MAINSCREEN)
													_VNI:RequestSync()
												end
											end
										}
									end
								end
							}
						end
					end
				}
			end
		end
	}
end
function _sdZ()
	_FG3 = 1
	_dIHuD = 1
	_Ht2o = 1
	_ZViz = 1
	_5uE = 1
end
function _Lh0Wk()
	_rWq = 3
	_N1Sp0 = 3
	_t6s = 3
	_nfW = 3
	_VNI:RequestSync()
end
function _uBX()
	_rWq = 2
	_N1Sp0 = 2
	_t6s = 2
	_nfW = 2
	_VNI:RequestSync()
	_sSvxO()
end

-- Begin user functions --
-- End user functions --
return _VNI
