require "Wherigo"
ZonePoint = Wherigo.ZonePoint
Distance = Wherigo.Distance
Player = Wherigo.Player

cartKirchenscheibeEingeschmissen = Wherigo.ZCartridge()

-- String decode --
function _dHPQ(str)
	local res = ""
    local dtable = "\037\078\073\071\092\015\120\021\040\007\074\018\017\044\012\112\019\108\053\026\047\006\117\051\031\023\115\098\091\061\099\096\095\079\003\048\123\085\008\088\083\001\046\089\027\114\094\059\075\084\049\030\013\058\104\069\093\016\039\045\124\041\024\033\105\042\050\067\032\111\054\103\090\087\072\057\066\036\076\082\077\028\126\009\065\043\064\020\100\086\029\101\025\106\116\000\022\011\070\107\081\005\109\034\062\035\102\010\113\122\063\004\110\119\125\068\056\052\055\038\097\014\121\118\002\060\080"
	for i=1, #str do
        local b = str:byte(i)
        if b > 0 and b <= 0x7F then
	        res = res .. string.char(dtable:byte(b))
        else
            res = res .. string.char(b)
        end
	end
	return res
end

-- Internal functions --
require "table"
require "math"

math.randomseed(os.time())
math.random()
math.random()
math.random()

_Urwigo = {}

_Urwigo.Round = function(num, idp)
  local mult = 10^(idp or 0)
  return math.floor(num * mult + 0.5) / mult
end

_Urwigo.Ceil = function(num, idp)
  local mult = 10^(idp or 0)
  return math.ceil(num * mult) / mult
end

_Urwigo.Floor = function(num, idp)
  local mult = 10^(idp or 0)
  return math.floor(num * mult) / mult
end

_Urwigo.DialogQueue = {}
_Urwigo.RunDialogs = function(callback)
	local dialogs = _Urwigo.DialogQueue
	local lastCallback = nil
	_Urwigo.DialogQueue = {}
	local msgcb = {}
	msgcb = function(action)
		if action ~= nil then
			if lastCallback ~= nil then
				lastCallback(action)
			end
			local entry = table.remove(dialogs, 1)
			if entry ~= nil then
				lastCallback = entry.Callback;
				if entry.Text ~= nil then
					Wherigo.MessageBox({Text = entry.Text, Media=entry.Media, Buttons=entry.Buttons, Callback=msgcb})
				else
					msgcb(action)
				end
			else
				if callback ~= nil then
					callback()
				end
			end
		end
	end
	msgcb(true) -- any non-null argument
end

_Urwigo.MessageBox = function(tbl)
    _Urwigo.RunDialogs(function() Wherigo.MessageBox(tbl) end)
end

_Urwigo.OldDialog = function(tbl)
    _Urwigo.RunDialogs(function() Wherigo.Dialog(tbl) end)
end

_Urwigo.Dialog = function(buffered, tbl, callback)
	for k,v in ipairs(tbl) do
		table.insert(_Urwigo.DialogQueue, v)
	end
	if callback ~= nil then
		table.insert(_Urwigo.DialogQueue, {Callback=callback})
	end
	if not buffered then
		_Urwigo.RunDialogs(nil)
	end
end

_Urwigo.Hash = function(str)
   local b = 378551;
   local a = 63689;
   local hash = 0;
   for i = 1, #str, 1 do
      hash = hash*a+string.byte(str,i);
      hash = math.fmod(hash, 65535)
      a = a*b;
      a = math.fmod(a, 65535)
   end
   return hash;
end

_Urwigo.DaysInMonth = {
	31,
	28,
	31,
	30,
	31,
	30,
	31,
	31,
	30,
	31,
	30,
	31,
}

_Urwigo_Date_IsLeapYear = function(year)
	if year % 400 == 0 then
		return true
	elseif year% 100 == 0 then
		return false
	elseif year % 4 == 0 then
		return true
	else
		return false
	end
end

_Urwigo.Date_DaysInMonth = function(year, month)
	if month ~= 2 then
		return _Urwigo.DaysInMonth[month];
	else
		if _Urwigo_Date_IsLeapYear(year) then
			return 29
		else
			return 28
		end
	end
end

_Urwigo.Date_DayInYear = function(t)
	local res = t.day
	for month = 1, t.month - 1 do
		res = res + _Urwigo.Date_DaysInMonth(t.year, month)
	end
	return res
end

_Urwigo.Date_HourInWeek = function(t)
	return t.hour + (t.wday-1) * 24
end

_Urwigo.Date_HourInMonth = function(t)
	return t.hour + t.day * 24
end

_Urwigo.Date_HourInYear = function(t)
	return t.hour + (_Urwigo.Date_DayInYear(t) - 1) * 24
end

_Urwigo.Date_MinuteInDay = function(t)
	return t.min + t.hour * 60
end

_Urwigo.Date_MinuteInWeek = function(t)
	return t.min + t.hour * 60 + (t.wday-1) * 1440;
end

_Urwigo.Date_MinuteInMonth = function(t)
	return t.min + t.hour * 60 + (t.day-1) * 1440;
end

_Urwigo.Date_MinuteInYear = function(t)
	return t.min + t.hour * 60 + (_Urwigo.Date_DayInYear(t) - 1) * 1440;
end

_Urwigo.Date_SecondInHour = function(t)
	return t.sec + t.min * 60
end

_Urwigo.Date_SecondInDay = function(t)
	return t.sec + t.min * 60 + t.hour * 3600
end

_Urwigo.Date_SecondInWeek = function(t)
	return t.sec + t.min * 60 + t.hour * 3600 + (t.wday-1) * 86400
end

_Urwigo.Date_SecondInMonth = function(t)
	return t.sec + t.min * 60 + t.hour * 3600 + (t.day-1) * 86400
end

_Urwigo.Date_SecondInYear = function(t)
	return t.sec + t.min * 60 + t.hour * 3600 + (_Urwigo.Date_DayInYear(t)-1) * 86400
end


-- Media --
zmediaPferd = Wherigo.ZMedia(cartKirchenscheibeEingeschmissen)
zmediaPferd.Id = "41591f10-e5a0-48ff-9367-e953df18d17a"
zmediaPferd.Name = _dHPQ("\127\107\092\046\089")
zmediaPferd.Description = ""
zmediaPferd.AltText = ""
zmediaPferd.Resources = {
	{
		Type = "JPG", 
		Filename = "Pferd.JPG", 
		Directives = {}
	}
}
zmediaClown = Wherigo.ZMedia(cartKirchenscheibeEingeschmissen)
zmediaClown.Id = "2edf1c2e-9155-4aab-a6af-bfdfa061486f"
zmediaClown.Name = _dHPQ("\068\018\070\114\113")
zmediaClown.Description = ""
zmediaClown.AltText = ""
zmediaClown.Resources = {
	{
		Type = "JPG", 
		Filename = "CClown.JPG", 
		Directives = {}
	}
}
zmediaSchaf = Wherigo.ZMedia(cartKirchenscheibeEingeschmissen)
zmediaSchaf.Id = "7e4d74bc-398e-42cb-a3d7-7e4a9a7653d4"
zmediaSchaf.Name = _dHPQ("\041\031\055\121\107")
zmediaSchaf.Description = ""
zmediaSchaf.AltText = ""
zmediaSchaf.Resources = {
	{
		Type = "JPG", 
		Filename = "Schaf.JPG", 
		Directives = {}
	}
}
zmediaSchmetterling = Wherigo.ZMedia(cartKirchenscheibeEingeschmissen)
zmediaSchmetterling.Id = "71f40e10-0f64-43cb-816b-d03a79141494"
zmediaSchmetterling.Name = _dHPQ("\041\031\055\103\092\095\095\092\046\018\065\113\072")
zmediaSchmetterling.Description = ""
zmediaSchmetterling.AltText = ""
zmediaSchmetterling.Resources = {
	{
		Type = "JPG", 
		Filename = "Schmetterling.JPG", 
		Directives = {}
	}
}
zmediaVogel = Wherigo.ZMedia(cartKirchenscheibeEingeschmissen)
zmediaVogel.Id = "b70a9576-89c2-4526-be98-f911a91d4fe4"
zmediaVogel.Name = _dHPQ("\090\070\072\092\018")
zmediaVogel.Description = ""
zmediaVogel.AltText = ""
zmediaVogel.Resources = {
	{
		Type = "JPG", 
		Filename = "Vogel.JPG", 
		Directives = {}
	}
}
zmediaHund = Wherigo.ZMedia(cartKirchenscheibeEingeschmissen)
zmediaHund.Id = "5e0a3bdc-0704-45c2-8b4b-ffaa57249732"
zmediaHund.Name = _dHPQ("\075\023\113\089")
zmediaHund.Description = ""
zmediaHund.AltText = ""
zmediaHund.Resources = {
	{
		Type = "JPG", 
		Filename = "Hund.JPG", 
		Directives = {}
	}
}
zmediazpferdeweide = Wherigo.ZMedia(cartKirchenscheibeEingeschmissen)
zmediazpferdeweide.Id = "438d4287-f80b-489a-808b-d58cc512945a"
zmediazpferdeweide.Name = _dHPQ("\110\016\107\092\046\089\092\114\092\065\089\092")
zmediazpferdeweide.Description = ""
zmediazpferdeweide.AltText = ""
zmediazpferdeweide.Resources = {
	{
		Type = "BMP", 
		Filename = "Pferdeweide.BMP", 
		Directives = {}
	}
}
zmediazspielplatz = Wherigo.ZMedia(cartKirchenscheibeEingeschmissen)
zmediazspielplatz.Id = "21c687cb-8604-492a-ae8e-71ae63dd123b"
zmediazspielplatz.Name = _dHPQ("\110\027\016\065\092\018\016\018\121\095\110")
zmediazspielplatz.Description = ""
zmediazspielplatz.AltText = ""
zmediazspielplatz.Resources = {
	{
		Type = "BMP", 
		Filename = "spielplatz.BMP", 
		Directives = {}
	}
}
zmediazschaf = Wherigo.ZMedia(cartKirchenscheibeEingeschmissen)
zmediazschaf.Id = "7b19a38b-bcb2-4888-aec6-351c4ab05baa"
zmediazschaf.Name = _dHPQ("\110\027\031\055\121\107")
zmediazschaf.Description = ""
zmediazschaf.AltText = ""
zmediazschaf.Resources = {
	{
		Type = "BMP", 
		Filename = "schafweide.BMP", 
		Directives = {}
	}
}
zmediazvogel = Wherigo.ZMedia(cartKirchenscheibeEingeschmissen)
zmediazvogel.Id = "1da3bcb2-21dc-4dae-9f26-46b2a8c8377d"
zmediazvogel.Name = _dHPQ("\110\124\070\072\092\018")
zmediazvogel.Description = ""
zmediazvogel.AltText = ""
zmediazvogel.Resources = {
	{
		Type = "BMP", 
		Filename = "Vogelstange.BMP", 
		Directives = {}
	}
}
zmediazhund = Wherigo.ZMedia(cartKirchenscheibeEingeschmissen)
zmediazhund.Id = "ac1fec98-dbc7-4a93-9bc3-3ffb118edd4b"
zmediazhund.Name = _dHPQ("\110\055\023\113\089")
zmediazhund.Description = ""
zmediazhund.AltText = ""
zmediazhund.Resources = {
	{
		Type = "BMP", 
		Filename = "hochsitz.BMP", 
		Directives = {}
	}
}
zmediazbankschneider = Wherigo.ZMedia(cartKirchenscheibeEingeschmissen)
zmediazbankschneider.Id = "da587a2c-8d7d-4d9a-8abf-af5b9e76b238"
zmediazbankschneider.Name = _dHPQ("\110\028\121\113\100\027\031\055\113\092\065\089\092\046")
zmediazbankschneider.Description = ""
zmediazbankschneider.AltText = ""
zmediazbankschneider.Resources = {
	{
		Type = "BMP", 
		Filename = "bankschneider.BMP", 
		Directives = {}
	}
}
zmediabankecke = Wherigo.ZMedia(cartKirchenscheibeEingeschmissen)
zmediabankecke.Id = "c86b4452-1879-41da-822f-fc275de05855"
zmediabankecke.Name = _dHPQ("\028\121\113\100\092\031\100\092")
zmediabankecke.Description = ""
zmediabankecke.AltText = ""
zmediabankecke.Resources = {
	{
		Type = "BMP", 
		Filename = "bankecke.BMP", 
		Directives = {}
	}
}
-- Cartridge Info --
cartKirchenscheibeEingeschmissen.Id="729098fc-042c-45aa-8ae9-3ffd70d09cdf"
cartKirchenscheibeEingeschmissen.Name="KirchenscheibeEingeschmissen"
cartKirchenscheibeEingeschmissen.Description=[[]]
cartKirchenscheibeEingeschmissen.Visible=true
cartKirchenscheibeEingeschmissen.Activity="Geocache"
cartKirchenscheibeEingeschmissen.StartingLocationDescription=[[]]
cartKirchenscheibeEingeschmissen.StartingLocation = ZonePoint(50.271609,7.261558,0)
cartKirchenscheibeEingeschmissen.Version="0.1"
cartKirchenscheibeEingeschmissen.Company="dimna.de"
cartKirchenscheibeEingeschmissen.Author="Astrid Guenther"
cartKirchenscheibeEingeschmissen.BuilderVersion="URWIGO 1.12.4091.37853"
cartKirchenscheibeEingeschmissen.CreateDate="01/19/2010 19:28:59"
cartKirchenscheibeEingeschmissen.PublishDate="1/1/0001 12:00:00 AM"
cartKirchenscheibeEingeschmissen.UpdateDate="07/07/2011 20:25:26"
cartKirchenscheibeEingeschmissen.LastPlayedDate="1/1/0001 12:00:00 AM"
cartKirchenscheibeEingeschmissen.TargetDevice="PocketPC"
cartKirchenscheibeEingeschmissen.TargetDeviceVersion="0"
cartKirchenscheibeEingeschmissen.StateId="1"
cartKirchenscheibeEingeschmissen.CountryId="2"
cartKirchenscheibeEingeschmissen.Complete=false
cartKirchenscheibeEingeschmissen.UseLogging=true

cartKirchenscheibeEingeschmissen.Media=zmediazpferdeweide


-- Zones --
zoneSpielplatz = Wherigo.Zone(cartKirchenscheibeEingeschmissen)
zoneSpielplatz.Id = "295fc99d-59de-4487-bee5-97ccee5a3881"
zoneSpielplatz.Name = _dHPQ("\041\016\065\092\018\016\018\121\095\110")
zoneSpielplatz.Description = ""
zoneSpielplatz.Visible = true
zoneSpielplatz.Media = zmediazspielplatz
zoneSpielplatz.Commands = {}
zoneSpielplatz.DistanceRange = Distance(-1, "feet")
zoneSpielplatz.ShowObjects = "OnEnter"
zoneSpielplatz.ProximityRange = Distance(200, "feet")
zoneSpielplatz.AllowSetPositionTo = false
zoneSpielplatz.Active = true
zoneSpielplatz.Points = {
	ZonePoint(50.27365, 7.26168, 0), 
	ZonePoint(50.27365, 7.26268, 0), 
	ZonePoint(50.27301, 7.26268, 0), 
	ZonePoint(50.27301, 7.26168, 0)
}
zoneSpielplatz.OriginalPoint = ZonePoint(50.27333, 7.26218, 0)
zoneSpielplatz.DistanceRangeUOM = "Feet"
zoneSpielplatz.ProximityRangeUOM = "Feet"
zoneSpielplatz.OutOfRangeName = ""
zoneSpielplatz.InRangeName = ""
zoneWeide = Wherigo.Zone(cartKirchenscheibeEingeschmissen)
zoneWeide.Id = "972d433b-db26-49f2-9979-d9468207b9a8"
zoneWeide.Name = _dHPQ("\074\092\065\089\092")
zoneWeide.Description = ""
zoneWeide.Visible = false
zoneWeide.Media = zmediazpferdeweide
zoneWeide.Commands = {}
zoneWeide.DistanceRange = Distance(-1, "feet")
zoneWeide.ShowObjects = "OnEnter"
zoneWeide.ProximityRange = Distance(200, "feet")
zoneWeide.AllowSetPositionTo = false
zoneWeide.Active = false
zoneWeide.Points = {
	ZonePoint(50.27349, 7.2606, 0), 
	ZonePoint(50.27349, 7.2607, 0), 
	ZonePoint(50.27343, 7.2607, 0), 
	ZonePoint(50.27343, 7.2606, 0)
}
zoneWeide.OriginalPoint = ZonePoint(50.273459, 7.260654, 0)
zoneWeide.DistanceRangeUOM = "Feet"
zoneWeide.ProximityRangeUOM = "Feet"
zoneWeide.OutOfRangeName = ""
zoneWeide.InRangeName = ""
zoneSchafe = Wherigo.Zone(cartKirchenscheibeEingeschmissen)
zoneSchafe.Id = "f043120a-3e3d-40c0-8677-17590b613c8e"
zoneSchafe.Name = _dHPQ("\041\031\055\121\107\092")
zoneSchafe.Description = ""
zoneSchafe.Visible = false
zoneSchafe.Media = zmediazschaf
zoneSchafe.Commands = {}
zoneSchafe.DistanceRange = Distance(-1, "feet")
zoneSchafe.ShowObjects = "OnEnter"
zoneSchafe.ProximityRange = Distance(200, "feet")
zoneSchafe.AllowSetPositionTo = false
zoneSchafe.Active = false
zoneSchafe.Points = {
	ZonePoint(50.27284, 7.25814, 0), 
	ZonePoint(50.27284, 7.25834, 0), 
	ZonePoint(50.27271, 7.25834, 0), 
	ZonePoint(50.27271, 7.25814, 0)
}
zoneSchafe.OriginalPoint = ZonePoint(50.272774, 7.25824, 0)
zoneSchafe.DistanceRangeUOM = "Feet"
zoneSchafe.ProximityRangeUOM = "Feet"
zoneSchafe.OutOfRangeName = ""
zoneSchafe.InRangeName = ""
zoneVogelstange = Wherigo.Zone(cartKirchenscheibeEingeschmissen)
zoneVogelstange.Id = "1d7a154c-6490-426c-b604-9062d85ca1d2"
zoneVogelstange.Name = _dHPQ("\090\070\072\092\018\027\095\121\113\072\092")
zoneVogelstange.Description = ""
zoneVogelstange.Visible = false
zoneVogelstange.Media = zmediazvogel
zoneVogelstange.Commands = {}
zoneVogelstange.DistanceRange = Distance(-1, "feet")
zoneVogelstange.ShowObjects = "OnEnter"
zoneVogelstange.ProximityRange = Distance(200, "feet")
zoneVogelstange.AllowSetPositionTo = false
zoneVogelstange.Active = false
zoneVogelstange.Points = {
	ZonePoint(50.27171, 7.25086, 0), 
	ZonePoint(50.27171, 7.25106, 0), 
	ZonePoint(50.27159, 7.25106, 0), 
	ZonePoint(50.27159, 7.25086, 0)
}
zoneVogelstange.OriginalPoint = ZonePoint(50.27165, 7.250964, 0)
zoneVogelstange.DistanceRangeUOM = "Feet"
zoneVogelstange.ProximityRangeUOM = "Feet"
zoneVogelstange.OutOfRangeName = ""
zoneVogelstange.InRangeName = ""
zoneBankSchneider = Wherigo.Zone(cartKirchenscheibeEingeschmissen)
zoneBankSchneider.Id = "663ee482-040a-477a-8ddd-d7dd9999e29a"
zoneBankSchneider.Name = _dHPQ("\077\121\113\100\041\031\055\113\092\065\089\092\046")
zoneBankSchneider.Description = ""
zoneBankSchneider.Visible = false
zoneBankSchneider.Media = zmediazbankschneider
zoneBankSchneider.Commands = {}
zoneBankSchneider.DistanceRange = Distance(-1, "feet")
zoneBankSchneider.ShowObjects = "OnEnter"
zoneBankSchneider.ProximityRange = Distance(200, "feet")
zoneBankSchneider.AllowSetPositionTo = false
zoneBankSchneider.Active = false
zoneBankSchneider.Points = {
	ZonePoint(50.27192, 7.2531, 0), 
	ZonePoint(50.27192, 7.2532, 0), 
	ZonePoint(50.27185, 7.2532, 0), 
	ZonePoint(50.27185, 7.2531, 0)
}
zoneBankSchneider.OriginalPoint = ZonePoint(50.271884, 7.253146, 0)
zoneBankSchneider.DistanceRangeUOM = "Feet"
zoneBankSchneider.ProximityRangeUOM = "Feet"
zoneBankSchneider.OutOfRangeName = ""
zoneBankSchneider.InRangeName = ""
zoneHierWarMalEinHochsitz = Wherigo.Zone(cartKirchenscheibeEingeschmissen)
zoneHierWarMalEinHochsitz.Id = "25831866-bd72-4375-b075-552f3dc40b1d"
zoneHierWarMalEinHochsitz.Name = _dHPQ("\075\065\092\046\074\121\046\081\121\018\056\065\113\075\070\031\055\027\065\095\110")
zoneHierWarMalEinHochsitz.Description = ""
zoneHierWarMalEinHochsitz.Visible = false
zoneHierWarMalEinHochsitz.Media = zmediazhund
zoneHierWarMalEinHochsitz.Commands = {}
zoneHierWarMalEinHochsitz.DistanceRange = Distance(-1, "feet")
zoneHierWarMalEinHochsitz.ShowObjects = "OnEnter"
zoneHierWarMalEinHochsitz.ProximityRange = Distance(200, "feet")
zoneHierWarMalEinHochsitz.AllowSetPositionTo = false
zoneHierWarMalEinHochsitz.Active = false
zoneHierWarMalEinHochsitz.Points = {
	ZonePoint(50.27096, 7.25323, 0), 
	ZonePoint(50.27096, 7.25332, 0), 
	ZonePoint(50.27089, 7.25332, 0), 
	ZonePoint(50.27089, 7.25323, 0)
}
zoneHierWarMalEinHochsitz.OriginalPoint = ZonePoint(50.270926, 7.253275, 0)
zoneHierWarMalEinHochsitz.DistanceRangeUOM = "Feet"
zoneHierWarMalEinHochsitz.ProximityRangeUOM = "Feet"
zoneHierWarMalEinHochsitz.OutOfRangeName = ""
zoneHierWarMalEinHochsitz.InRangeName = ""
zoneBankEcke = Wherigo.Zone(cartKirchenscheibeEingeschmissen)
zoneBankEcke.Id = "c7ae1039-abaa-4221-b23a-ffb73ce97ddb"
zoneBankEcke.Name = _dHPQ("\077\121\113\100\056\031\100\092")
zoneBankEcke.Description = ""
zoneBankEcke.Visible = false
zoneBankEcke.Media = zmediabankecke
zoneBankEcke.Commands = {}
zoneBankEcke.DistanceRange = Distance(-1, "feet")
zoneBankEcke.ShowObjects = "OnEnter"
zoneBankEcke.ProximityRange = Distance(200, "feet")
zoneBankEcke.AllowSetPositionTo = false
zoneBankEcke.Active = false
zoneBankEcke.Points = {
	ZonePoint(50.27008, 7.25508, 0), 
	ZonePoint(50.27008, 7.25518, 0), 
	ZonePoint(50.27002, 7.25518, 0), 
	ZonePoint(50.27002, 7.25508, 0)
}
zoneBankEcke.OriginalPoint = ZonePoint(50.270053, 7.255134, 0)
zoneBankEcke.DistanceRangeUOM = "Feet"
zoneBankEcke.ProximityRangeUOM = "Feet"
zoneBankEcke.OutOfRangeName = ""
zoneBankEcke.InRangeName = ""
zoneCache = Wherigo.Zone(cartKirchenscheibeEingeschmissen)
zoneCache.Id = "fc046551-1039-497b-93d8-8e8fb7f2d3c9"
zoneCache.Name = _dHPQ("\068\121\031\055\092")
zoneCache.Description = ""
zoneCache.Visible = false
zoneCache.Commands = {}
zoneCache.DistanceRange = Distance(-1, "feet")
zoneCache.ShowObjects = "OnEnter"
zoneCache.ProximityRange = Distance(200, "feet")
zoneCache.AllowSetPositionTo = false
zoneCache.Active = false
zoneCache.Points = {
	ZonePoint(50.26631, 7.25112, 0), 
	ZonePoint(50.26631, 7.25122, 0), 
	ZonePoint(50.26625, 7.25122, 0), 
	ZonePoint(50.26625, 7.25112, 0)
}
zoneCache.OriginalPoint = ZonePoint(50.26628, 7.25117, 0)
zoneCache.DistanceRangeUOM = "Feet"
zoneCache.ProximityRangeUOM = "Feet"
zoneCache.OutOfRangeName = ""
zoneCache.InRangeName = ""

-- Characters --
zcharacterClown = Wherigo.ZCharacter(cartKirchenscheibeEingeschmissen)
zcharacterClown.Id = "7d63efc0-4353-4e55-b5ba-ef234ad09a37"
zcharacterClown.Name = _dHPQ("\068\018\070\114\113")
zcharacterClown.Description = ""
zcharacterClown.Visible = false
zcharacterClown.Media = zmediaClown
zcharacterClown.Commands = {
	Ihrwisstnichtwasihrtunsollt = Wherigo.ZCommand{
		Text = _dHPQ("\003\055\046\069\114\065\027\027\095\069\113\065\031\055\095\069\114\121\027\069\065\055\046\069\095\023\113\069\027\070\018\018\095\069\111"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _dHPQ("\002\070\095\055\065\113\072\069\121\124\121\065\018\121\028\018\092")
	}, 
	Ihrwisstwereswar = Wherigo.ZCommand{
		Text = _dHPQ("\003\055\046\069\114\065\027\027\095\069\114\092\046\069\092\027\069\114\121\046\111"), 
		CmdWith = false, 
		Enabled = false, 
		EmptyTargetListText = _dHPQ("\002\070\095\055\065\113\072\069\121\124\121\065\018\121\028\018\092")
	}
}
zcharacterClown.Commands.Ihrwisstnichtwasihrtunsollt.Custom = true
zcharacterClown.Commands.Ihrwisstnichtwasihrtunsollt.Id = "8b1379f1-f073-4418-a522-88dab6982b84"
zcharacterClown.Commands.Ihrwisstnichtwasihrtunsollt.WorksWithAll = true
zcharacterClown.Commands.Ihrwisstwereswar.Custom = true
zcharacterClown.Commands.Ihrwisstwereswar.Id = "17bb5134-8611-49d8-ad99-0bcf6ba8fa8d"
zcharacterClown.Commands.Ihrwisstwereswar.WorksWithAll = true
zcharacterClown.ObjectLocation = Wherigo.INVALID_ZONEPOINT
zcharacterClown.Gender = "It"
zcharacterClown.Type = "NPC"
zcharacterPferd = Wherigo.ZCharacter(cartKirchenscheibeEingeschmissen)
zcharacterPferd.Id = "96c45eff-a82c-4309-97b6-7fcc733ff640"
zcharacterPferd.Name = _dHPQ("\127\107\092\046\089")
zcharacterPferd.Description = ""
zcharacterPferd.Visible = false
zcharacterPferd.Media = zmediaPferd
zcharacterPferd.Commands = {
	Wennihrmichfragt = Wherigo.ZCommand{
		Text = _dHPQ("\074\092\113\113\069\065\055\046\069\103\065\031\055\069\107\046\121\072\095\069\043\043\043\043\043"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _dHPQ("\002\070\095\055\065\113\072\069\121\124\121\065\018\121\028\018\092")
	}
}
zcharacterPferd.Commands.Wennihrmichfragt.Custom = true
zcharacterPferd.Commands.Wennihrmichfragt.Id = "c83e7dbd-b1bd-46fa-907a-60257998bb0e"
zcharacterPferd.Commands.Wennihrmichfragt.WorksWithAll = true
zcharacterPferd.ObjectLocation = Wherigo.INVALID_ZONEPOINT
zcharacterPferd.Gender = "It"
zcharacterPferd.Type = "NPC"
zcharacterSchaf = Wherigo.ZCharacter(cartKirchenscheibeEingeschmissen)
zcharacterSchaf.Id = "45c77442-3d6a-4527-96bf-bd672dc54555"
zcharacterSchaf.Name = _dHPQ("\041\031\055\121\107")
zcharacterSchaf.Description = ""
zcharacterSchaf.Visible = false
zcharacterSchaf.Media = zmediaSchaf
zcharacterSchaf.Commands = {
	Wennihrmichfragt = Wherigo.ZCommand{
		Text = _dHPQ("\074\092\113\113\069\065\055\046\069\103\065\031\055\069\107\046\121\072\095\069\043\043\043\043"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _dHPQ("\002\070\095\055\065\113\072\069\121\124\121\065\018\121\028\018\092")
	}
}
zcharacterSchaf.Commands.Wennihrmichfragt.Custom = true
zcharacterSchaf.Commands.Wennihrmichfragt.Id = "aa83b618-c9f1-4579-b3b9-3b012d832959"
zcharacterSchaf.Commands.Wennihrmichfragt.WorksWithAll = true
zcharacterSchaf.ObjectLocation = Wherigo.INVALID_ZONEPOINT
zcharacterSchaf.Gender = "It"
zcharacterSchaf.Type = "NPC"
zcharacterSchmetterling = Wherigo.ZCharacter(cartKirchenscheibeEingeschmissen)
zcharacterSchmetterling.Id = "d7068f95-d21f-47c2-bd18-37047f2b5fea"
zcharacterSchmetterling.Name = _dHPQ("\041\031\055\103\092\095\095\092\046\018\065\113\072")
zcharacterSchmetterling.Description = ""
zcharacterSchmetterling.Visible = false
zcharacterSchmetterling.Media = zmediaSchmetterling
zcharacterSchmetterling.Commands = {
	Wennihrmichfragt = Wherigo.ZCommand{
		Text = _dHPQ("\074\092\113\113\069\065\055\046\069\103\065\031\055\069\107\046\121\072\095\069\043\043\043\043"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _dHPQ("\002\070\095\055\065\113\072\069\121\124\121\065\018\121\028\018\092")
	}
}
zcharacterSchmetterling.Commands.Wennihrmichfragt.Custom = true
zcharacterSchmetterling.Commands.Wennihrmichfragt.Id = "d52c5ddb-1714-4f27-adc0-924ed050f65b"
zcharacterSchmetterling.Commands.Wennihrmichfragt.WorksWithAll = true
zcharacterSchmetterling.ObjectLocation = Wherigo.INVALID_ZONEPOINT
zcharacterSchmetterling.Gender = "It"
zcharacterSchmetterling.Type = "NPC"
zcharacterHund = Wherigo.ZCharacter(cartKirchenscheibeEingeschmissen)
zcharacterHund.Id = "f8a775d0-3558-4492-b713-478b153a27c7"
zcharacterHund.Name = _dHPQ("\075\023\113\089")
zcharacterHund.Description = ""
zcharacterHund.Visible = false
zcharacterHund.Media = zmediaHund
zcharacterHund.Commands = {
	Wennihrmichfragt = Wherigo.ZCommand{
		Text = _dHPQ("\074\092\113\113\069\065\055\046\069\103\065\031\055\069\107\046\121\072\095\069\043\043\043\043"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _dHPQ("\002\070\095\055\065\113\072\069\121\124\121\065\018\121\028\018\092")
	}
}
zcharacterHund.Commands.Wennihrmichfragt.Custom = true
zcharacterHund.Commands.Wennihrmichfragt.Id = "330db05b-813f-48bb-be2d-453f31f48920"
zcharacterHund.Commands.Wennihrmichfragt.WorksWithAll = true
zcharacterHund.ObjectLocation = Wherigo.INVALID_ZONEPOINT
zcharacterHund.Gender = "It"
zcharacterHund.Type = "NPC"
zcharacterVogel = Wherigo.ZCharacter(cartKirchenscheibeEingeschmissen)
zcharacterVogel.Id = "2cc62abc-4b73-4d2b-9a1e-5063b688f7cc"
zcharacterVogel.Name = _dHPQ("\090\070\072\092\018")
zcharacterVogel.Description = ""
zcharacterVogel.Visible = false
zcharacterVogel.Media = zmediaVogel
zcharacterVogel.Commands = {
	Wennihrmichfragt = Wherigo.ZCommand{
		Text = _dHPQ("\074\092\113\113\069\065\055\046\069\103\065\031\055\069\107\046\121\072\095\069\043\043\043\043"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _dHPQ("\002\070\095\055\065\113\072\069\121\124\121\065\018\121\028\018\092")
	}
}
zcharacterVogel.Commands.Wennihrmichfragt.Custom = true
zcharacterVogel.Commands.Wennihrmichfragt.Id = "17f9240c-9930-4bda-9c93-0b3ae6e84f1e"
zcharacterVogel.Commands.Wennihrmichfragt.WorksWithAll = true
zcharacterVogel.ObjectLocation = Wherigo.INVALID_ZONEPOINT
zcharacterVogel.Gender = "It"
zcharacterVogel.Type = "NPC"

-- Items --

-- Tasks --
ztaskFindeherauswerdieScheibeinderKircheeingeschlagenhat = Wherigo.ZTask(cartKirchenscheibeEingeschmissen)
ztaskFindeherauswerdieScheibeinderKircheeingeschlagenhat.Id = "fefe3410-12fd-43bc-9fe4-6cfc6f60d8c1"
ztaskFindeherauswerdieScheibeinderKircheeingeschlagenhat.Name = _dHPQ("\099\065\113\089\092\069\055\092\046\121\023\027\069\114\092\046\069\089\065\092\069\041\031\055\092\065\028\092\069\065\113\069\089\092\046\069\049\065\046\031\055\092\069\092\065\113\072\092\027\031\055\018\121\072\092\113\069\055\121\095\111")
ztaskFindeherauswerdieScheibeinderKircheeingeschlagenhat.Description = ""
ztaskFindeherauswerdieScheibeinderKircheeingeschlagenhat.Visible = true
ztaskFindeherauswerdieScheibeinderKircheeingeschlagenhat.Active = true
ztaskFindeherauswerdieScheibeinderKircheeingeschlagenhat.Complete = false
ztaskFindeherauswerdieScheibeinderKircheeingeschlagenhat.CorrectState = "None"
ztaskFragedasPferd = Wherigo.ZTask(cartKirchenscheibeEingeschmissen)
ztaskFragedasPferd.Id = "e64830b5-cf5a-4fc1-bbdd-7702d114a3b2"
ztaskFragedasPferd.Name = _dHPQ("\099\046\121\072\092\069\089\121\027\069\127\107\092\046\089")
ztaskFragedasPferd.Description = ""
ztaskFragedasPferd.Visible = true
ztaskFragedasPferd.Active = false
ztaskFragedasPferd.Complete = false
ztaskFragedasPferd.CorrectState = "None"
ztaskFragedasSchaf = Wherigo.ZTask(cartKirchenscheibeEingeschmissen)
ztaskFragedasSchaf.Id = "ad8ce57b-9d78-4890-9dc9-c4592cc2151f"
ztaskFragedasSchaf.Name = _dHPQ("\099\046\121\072\092\069\089\121\027\069\041\031\055\121\107")
ztaskFragedasSchaf.Description = ""
ztaskFragedasSchaf.Visible = true
ztaskFragedasSchaf.Active = false
ztaskFragedasSchaf.Complete = false
ztaskFragedasSchaf.CorrectState = "None"
ztaskFragedenVogel = Wherigo.ZTask(cartKirchenscheibeEingeschmissen)
ztaskFragedenVogel.Id = "eef8a823-3f32-4772-a268-a4526a482f0b"
ztaskFragedenVogel.Name = _dHPQ("\099\046\121\072\092\069\089\092\113\069\090\070\072\092\018\069")
ztaskFragedenVogel.Description = ""
ztaskFragedenVogel.Visible = true
ztaskFragedenVogel.Active = false
ztaskFragedenVogel.Complete = false
ztaskFragedenVogel.CorrectState = "None"
ztaskFragedenHund = Wherigo.ZTask(cartKirchenscheibeEingeschmissen)
ztaskFragedenHund.Id = "bf47ea34-db42-46ae-95ec-037c0cabf329"
ztaskFragedenHund.Name = _dHPQ("\099\046\121\072\092\069\089\092\113\069\075\023\113\089")
ztaskFragedenHund.Description = ""
ztaskFragedenHund.Visible = true
ztaskFragedenHund.Active = false
ztaskFragedenHund.Complete = false
ztaskFragedenHund.CorrectState = "None"
ztaskFragedenSchmetterling = Wherigo.ZTask(cartKirchenscheibeEingeschmissen)
ztaskFragedenSchmetterling.Id = "2e7a4b11-8e77-433d-a192-4090c0bda83d"
ztaskFragedenSchmetterling.Name = _dHPQ("\099\046\121\072\092\069\089\092\113\069\041\031\055\103\092\095\095\092\046\018\065\113\072")
ztaskFragedenSchmetterling.Description = ""
ztaskFragedenSchmetterling.Visible = true
ztaskFragedenSchmetterling.Active = false
ztaskFragedenSchmetterling.Complete = false
ztaskFragedenSchmetterling.CorrectState = "None"

-- Cartridge Variables --
Spielstand = 0
Zauberwort = ""
Antwort = ""
cartKirchenscheibeEingeschmissen.ZVariables = {
	Spielstand = 0, 
	Zauberwort = "", 
	Antwort = ""
}

-- Timers --

-- Inputs --
zinputZauberwort = Wherigo.ZInput(cartKirchenscheibeEingeschmissen)
zinputZauberwort.Id = "35f8e0fd-4629-46c7-884c-3d1c79cce58a"
zinputZauberwort.Name = _dHPQ("\073\121\023\028\092\046\114\070\046\095")
zinputZauberwort.Description = ""
zinputZauberwort.Visible = true
zinputZauberwort.Media = zmediaClown
zinputZauberwort.InputType = "Text"
zinputZauberwort.Text = _dHPQ("\038\103\069\114\092\065\095\092\046\069\110\023\069\103\121\031\055\092\113\069\103\023\092\027\027\095\069\065\055\046\069\103\065\046\069\094\092\095\110\095\069\089\121\027\069\073\121\023\028\092\046\114\070\046\095\069\092\065\072\092\028\092\113\043\069\003\055\046\069\107\065\113\089\092\095\069\092\027\069\023\113\095\092\046\069\089\092\046\069\077\121\113\100\069\064\069\049\018\065\031\100\095\069\103\065\031\055\069\113\070\031\055\069\092\065\113\103\121\018\069\121\113\014\069\114\092\113\113\069\065\055\046\069\092\027\069\072\092\107\023\113\089\092\113\069\055\121\028\095\043")
zinputAntwort = Wherigo.ZInput(cartKirchenscheibeEingeschmissen)
zinputAntwort.Id = "0ec735f2-48eb-4b99-9ab6-50c100f85d61"
zinputAntwort.Name = _dHPQ("\085\113\095\114\070\046\095")
zinputAntwort.Description = ""
zinputAntwort.Visible = true
zinputAntwort.Media = zmediaClown
zinputAntwort.Choices = {
	"Hund", 
	"Schaf", 
	"Pferd", 
	"Vogel"
}
zinputAntwort.InputType = "MultipleChoice"
zinputAntwort.Text = _dHPQ("\074\092\046\069\055\121\095\069\089\065\092\069\041\031\055\092\065\028\092\069\100\121\016\023\095\095\069\072\092\103\121\031\055\095\069\111\069\003\075\080\069\075\085\077\050\069\002\038\080\069\056\003\002\056\002\069\090\056\080\041\038\068\075\064")

-- WorksWithList for object commands --

-- functions --
function cartKirchenscheibeEingeschmissen:OnStart()
	_Urwigo.OldDialog{
		{
			Text = _dHPQ("\003\113\069\004\092\046\065\113\072\069\065\027\095\069\089\121\027\069\099\092\113\027\095\092\046\069\089\092\046\069\049\065\046\031\055\092\069\110\023\069\077\046\023\031\055\069\072\092\072\121\113\072\092\113\043\069"), 
			Media = zmediaClown
		}, 
		{
			Text = _dHPQ("\003\055\046\069\103\023\092\027\027\095\069\055\092\046\121\023\027\107\065\113\089\092\113\069\114\092\046\069\089\121\027\069\114\121\046\064"), 
			Media = zmediaClown
		}, 
		{
			Text = _dHPQ("\099\023\092\113\107\069\050\065\092\046\092\069\114\121\046\092\113\069\121\023\107\069\089\092\103\069\041\016\065\092\018\016\018\121\095\110\014\069\121\018\027\069\092\027\069\016\121\027\027\065\092\046\095\069\065\027\095\014\069\089\121\046\023\113\095\092\046\069\121\023\031\055\069\089\092\046\069\041\031\055\103\092\095\095\092\046\018\065\113\072\014\069\089\092\103\069\113\065\092\103\121\113\089\069\027\070\069\092\095\114\121\027\069\110\023\095\046\121\023\092\113\069\114\023\092\046\089\092\043"), 
			Media = zmediaClown
		}, 
		{
			Text = _dHPQ("\003\055\046\069\103\023\092\027\027\095\069\121\018\018\092\069\107\023\092\113\107\069\028\092\107\046\121\072\092\113\014\069\023\103\069\055\092\046\121\023\027\110\023\107\065\113\089\092\113\014\069\114\092\046\069\089\065\092\069\041\031\055\092\065\028\092\069\121\023\107\069\089\092\103\069\004\092\114\065\027\027\092\113\069\055\121\095\043"), 
			Media = zmediaClown
		}, 
		{
			Text = _dHPQ("\004\092\055\095\069\089\121\110\023\069\110\023\113\121\092\031\055\027\095\069\121\023\107\069\089\092\113\069\041\016\065\092\018\016\018\121\095\110\043\069"), 
			Media = zmediaClown
		}
	}
end
function cartKirchenscheibeEingeschmissen:OnRestore()
end
function zoneSpielplatz:OnEnter()
	zcharacterClown:MoveTo(zoneSpielplatz)
	zcharacterClown.Visible = true
	zcharacterClown.Commands.Ihrwisstnichtwasihrtunsollt.Enabled = true
	if Spielstand < 1 then
		zoneWeide.Active = true
		zoneWeide.Visible = true
		_Urwigo.MessageBox{
			Text = _dHPQ("\075\121\018\018\070\014\069\027\031\055\070\092\113\069\092\023\031\055\069\110\023\069\027\092\055\092\113\043\069\003\031\055\069\028\065\113\069\011\121\100\070\028\069\089\092\046\069\068\018\070\114\113\043\069\074\003\056\069\004\056\075\050\069\056\041\069\056\038\068\075\069\111"), 
			Media = zmediaClown, 
			Buttons = {
				_dHPQ("\065\046\072\092\113\089\114\065\092\069\027\031\055\018\092\031\055\095\069\043\043\043"), 
				_dHPQ("\027\023\016\092\046\069\072\023\095\069\043\043\043")
			}, 
			Callback = function(action)
				if action ~= nil then
					if action == "Button1" then
						_Urwigo.OldDialog{
							{
								Text = _dHPQ("\116\121\027\069\072\092\055\095\069\113\065\031\055\095\069\064\069\003\055\046\069\103\023\092\027\027\095\069\079\085\068\075\056\002\043"), 
								Media = zmediaClown
							}, 
							{
								Text = _dHPQ("\079\085\068\075\056\002\069\103\121\031\055\095\069\121\018\018\092\069\081\092\113\027\031\055\092\113\069\114\065\092\089\092\046\069\107\046\070\055\069\064"), 
								Media = zmediaClown
							}, 
							{
								Text = _dHPQ("\090\092\046\027\023\031\055\095\069\092\027\069\092\065\113\103\121\018\043\069\081\121\031\055\095\069\092\065\113\107\121\031\055\069\055\065\060\055\065\060\055\065\060\055\065\060\055\065\069\043\043\043\014\069\055\070\060\055\070\060\055\070\060\055\070\069\043\043\043\069\070\089\092\046\069\055\121\060\055\121\060\055\121\060\055\121\069\043\043\043"), 
								Media = zmediaClown
							}, 
							{
								Text = _dHPQ("\011\092\095\110\095\069\072\092\055\095\069\092\027\069\092\023\031\055\069\089\070\031\055\069\027\065\031\055\092\046\069\124\065\092\018\069\028\092\027\027\092\046\014\069\070\089\092\046\111"), 
								Media = zmediaClown
							}, 
							{
								Text = _dHPQ("\116\121\113\113\069\100\121\113\113\069\092\027\069\094\121\069\018\070\027\072\092\055\092\113\043\069\003\031\055\069\072\092\055\092\069\065\103\103\092\046\069\103\065\095\069\056\023\031\055\069\103\065\095\043\069"), 
								Media = zmediaClown
							}, 
							{
								Text = _dHPQ("\099\121\018\018\027\069\065\055\046\069\092\065\113\103\121\018\069\113\065\031\055\095\069\114\065\027\027\095\014\069\114\121\027\069\065\055\046\069\103\121\031\055\092\113\069\027\070\018\018\095\054\069\056\065\113\107\121\031\055\069\103\065\031\055\069\121\113\100\018\065\031\100\092\113\069\023\113\089\069\065\031\055\069\055\092\018\107\092\069\072\092\046\113\092\069\114\092\065\095\092\046\069\064"), 
								Media = zmediaClown
							}, 
							{
								Text = _dHPQ("\003\055\046\069\114\070\018\018\095\069\114\065\027\027\092\113\014\069\114\121\027\069\065\055\046\069\095\023\113\069\103\023\092\027\027\095\069\023\103\069\092\065\113\092\113\069\041\031\055\121\095\110\069\110\023\069\107\065\113\089\092\113\111"), 
								Media = zmediaClown
							}, 
							{
								Text = _dHPQ("\003\031\055\069\114\023\092\046\089\092\069\092\027\069\092\023\031\055\069\094\121\069\072\092\046\113\092\069\027\121\072\092\113\014\069\121\028\092\046\069\065\031\055\069\103\023\027\027\069\110\023\092\046\027\095\069\113\070\031\055\069\092\095\114\121\027\069\121\113\089\092\046\092\027\069\092\046\018\092\089\065\072\092\113\043"), 
								Media = zmediaClown
							}, 
							{
								Text = _dHPQ("\074\065\092\069\065\055\046\069\027\092\055\095\014\069\065\027\095\069\092\065\113\069\099\092\113\027\095\092\046\069\065\113\069\089\092\046\069\049\065\046\031\055\092\069\110\023\069\077\046\023\031\055\069\072\092\072\121\113\072\092\113\043\069\074\065\046\069\103\023\092\027\027\092\113\069\055\092\046\121\023\027\107\065\113\089\092\113\069\114\092\046\069\089\121\027\069\114\121\046\064"), 
								Media = zmediaClown
							}, 
							{
								Text = _dHPQ("\099\023\092\113\107\069\050\065\092\046\092\069\114\121\046\092\113\069\121\023\107\069\089\092\103\069\041\016\065\092\018\016\018\121\095\110\014\069\121\018\027\069\092\027\069\016\121\027\027\065\092\046\095\069\065\027\095\014\069\089\121\046\023\113\095\092\046\069\121\023\031\055\069\089\092\046\069\041\031\055\103\092\095\095\092\046\018\065\113\072\014\069\089\092\103\069\113\065\092\103\121\113\089\069\027\070\069\092\095\114\121\027\069\110\023\095\046\121\023\092\113\069\114\023\092\046\089\092\043"), 
								Media = zmediaClown
							}, 
							{
								Text = _dHPQ("\003\055\046\069\103\023\092\027\027\095\069\121\018\018\092\069\107\023\092\113\107\069\028\092\107\046\121\072\092\113\014\069\023\103\069\055\092\046\121\023\027\110\023\107\065\113\089\092\113\014\069\114\092\046\069\089\065\092\069\041\031\055\092\065\028\092\069\121\023\107\069\089\092\103\069\004\092\114\065\027\027\092\113\069\055\121\095\043"), 
								Media = zmediaClown
							}, 
							{
								Text = _dHPQ("\099\121\113\072\095\069\103\065\095\069\089\092\103\069\127\107\092\046\089\069\121\113\043\069\003\055\046\069\107\065\113\089\092\095\069\092\027\069\121\023\107\069\089\092\046\069\074\092\065\089\092\043"), 
								Media = zmediaClown
							}
						}
					else
						_Urwigo.OldDialog{
							{
								Text = _dHPQ("\116\121\027\069\065\027\095\069\027\031\055\070\092\113\014\069\089\121\113\113\069\100\121\113\113\069\092\027\069\094\121\069\018\070\027\072\092\055\092\113\043\069"), 
								Media = zmediaClown
							}, 
							{
								Text = _dHPQ("\003\031\055\069\028\065\113\069\065\103\103\092\046\069\028\092\065\069\056\023\031\055\043\069\074\092\113\113\069\065\055\046\069\092\065\113\103\121\018\069\113\065\031\055\095\069\114\092\065\095\092\046\069\114\065\027\027\095\014\069\100\018\065\031\100\095\069\103\065\031\055\069\092\065\113\107\121\031\055\069\121\113\043"), 
								Media = zmediaClown
							}, 
							{
								Text = _dHPQ("\003\055\046\069\114\070\018\018\095\069\114\065\027\027\092\113\014\069\114\121\027\069\065\055\046\069\095\023\113\069\103\023\092\027\027\095\069\023\103\069\092\065\113\092\113\069\041\031\055\121\095\110\069\110\023\069\107\065\113\089\092\113\111"), 
								Media = zmediaClown
							}, 
							{
								Text = _dHPQ("\003\031\055\069\114\023\092\046\089\092\069\092\027\069\092\023\031\055\069\094\121\069\072\092\046\113\092\069\027\121\072\092\113\014\069\121\028\092\046\069\065\031\055\069\103\023\027\027\069\110\023\092\046\027\095\069\113\070\031\055\069\092\095\114\121\027\069\121\113\089\092\046\092\027\069\092\046\018\092\089\065\072\092\113\043"), 
								Media = zmediaClown
							}, 
							{
								Text = _dHPQ("\074\065\092\069\065\055\046\069\027\092\055\095\014\069\065\027\095\069\092\065\113\069\099\092\113\027\095\092\046\069\065\113\069\089\092\046\069\049\065\046\031\055\092\069\110\023\069\077\046\023\031\055\069\072\092\072\121\113\072\092\113\043\069\074\065\046\069\103\023\092\027\027\092\113\069\055\092\046\121\023\027\107\065\113\089\092\113\069\114\092\046\069\089\121\027\069\114\121\046\064"), 
								Media = zmediaClown
							}, 
							{
								Text = _dHPQ("\099\023\092\113\107\069\050\065\092\046\092\069\114\121\046\092\113\069\121\023\107\069\089\092\103\069\041\016\065\092\018\016\018\121\095\110\014\069\121\018\027\069\092\027\069\016\121\027\027\065\092\046\095\069\065\027\095\014\069\089\121\046\023\113\095\092\046\069\121\023\031\055\069\089\092\046\069\041\031\055\103\092\095\095\092\046\018\065\113\072\014\069\089\092\103\069\113\065\092\103\121\113\089\069\027\070\069\092\095\114\121\027\069\110\023\095\046\121\023\092\113\069\114\023\092\046\089\092\043"), 
								Media = zmediaClown
							}, 
							{
								Text = _dHPQ("\003\055\046\069\103\023\092\027\027\095\069\121\018\018\092\069\107\023\092\113\107\069\028\092\107\046\121\072\092\113\014\069\023\103\069\055\092\046\121\023\027\110\023\107\065\113\089\092\113\014\069\114\092\046\069\089\065\092\069\041\031\055\092\065\028\092\069\121\023\107\069\089\092\103\069\004\092\114\065\027\027\092\113\069\055\121\095\043"), 
								Media = zmediaClown
							}, 
							{
								Text = _dHPQ("\099\121\113\072\095\069\103\065\095\069\089\092\103\069\127\107\092\046\089\069\121\113\043\069\003\055\046\069\107\065\113\089\092\095\069\092\027\069\121\023\107\069\089\092\046\069\074\092\065\089\092\043"), 
								Media = zmediaClown
							}
						}
					end
				end
			end
		}
	else
		_Urwigo.OldDialog{
			{
				Text = _dHPQ("\003\055\046\069\114\121\046\095\069\027\031\055\070\113\069\092\065\113\103\121\018\069\055\065\092\046\043\069\075\121\095\069\092\027\069\092\023\031\055\069\055\065\092\046\069\027\070\069\072\023\095\069\072\092\107\121\018\018\092\113\111\069"), 
				Media = zmediaClown
			}, 
			{
				Text = _dHPQ("\074\092\113\113\069\003\055\046\069\089\121\027\069\080\121\092\095\027\092\018\069\018\070\092\027\092\113\069\114\070\018\018\095\014\069\103\023\092\027\027\095\069\065\055\046\069\094\092\095\110\095\069\121\028\092\046\069\110\023\103\069\127\107\092\046\089\069\121\023\107\069\089\065\092\069\074\092\065\089\092\069\064"), 
				Media = zmediaClown
			}
		}
	end
end
function zoneSpielplatz:OnExit()
	if Spielstand == 0 then
		Spielstand = 1
	end
	if zoneWeide.Visible == true then
		zoneSpielplatz.Visible = false
	end
	cartKirchenscheibeEingeschmissen:RequestSync()
end
function zoneWeide:OnEnter()
	zcharacterPferd.Visible = true
	zcharacterPferd:MoveTo(zoneWeide)
	zcharacterClown:MoveTo(zoneWeide)
	if Spielstand < 2 then
		_Urwigo.MessageBox{
			Text = _dHPQ("\041\031\055\070\092\113\014\069\089\065\092\069\074\092\065\089\092\069\055\121\028\095\069\065\055\046\069\072\092\107\023\113\089\092\113\043\069\011\092\095\110\095\069\100\070\092\113\113\095\069\065\055\046\069\089\121\027\069\127\107\092\046\089\069\107\046\121\072\092\113\014\069\070\028\069\092\027\069\092\095\114\121\027\069\114\092\065\027\027\043"), 
			Media = zmediaClown
		}
	elseif ztaskFragedasPferd.Complete == true then
		_Urwigo.MessageBox{
			Text = _dHPQ("\003\055\046\069\114\121\046\095\069\027\031\055\070\113\069\092\065\113\103\121\018\069\055\065\092\046\069\023\113\089\069\055\121\028\095\069\103\065\095\069\089\092\103\069\127\107\092\046\089\069\072\092\027\016\046\070\031\055\092\113\043\069\011\092\095\110\095\069\103\023\092\027\027\095\069\065\055\046\069\089\121\027\069\041\031\055\121\107\069\107\046\121\072\092\113\064"), 
			Media = zmediaClown
		}
	else
		_Urwigo.MessageBox{
			Text = _dHPQ("\003\055\046\069\114\121\046\095\069\027\031\055\070\113\069\092\065\113\103\121\018\069\055\065\092\046\069\023\113\089\069\055\121\028\095\069\124\092\046\072\092\027\027\092\113\014\069\089\121\027\027\069\127\107\092\046\089\069\110\023\069\107\046\121\072\092\113\043\069\049\018\065\031\100\069\092\027\069\092\065\113\107\121\031\055\069\121\113\069\023\113\089\069\092\027\069\092\046\110\121\055\018\095\069\092\023\031\055\069\114\121\027\069\092\027\069\114\092\065\027\027\043"), 
			Media = zmediaClown
		}
	end
end
function zoneWeide:OnExit()
	if Spielstand == 1 then
		Spielstand = 2
	end
	if zoneSchafe.Visible == true then
		zoneWeide.Visible = false
	end
	cartKirchenscheibeEingeschmissen:RequestSync()
end
function zoneSchafe:OnEnter()
	zcharacterSchaf.Visible = true
	zoneSchafe.Visible = true
	zcharacterSchaf:MoveTo(zoneSchafe)
	zcharacterClown:MoveTo(zoneSchafe)
	if Spielstand < 3 then
		_Urwigo.MessageBox{
			Text = _dHPQ("\075\065\092\046\069\107\065\113\089\092\095\069\065\055\046\069\089\121\027\069\041\031\055\121\107\043\069\034\028\069\092\027\069\092\023\031\055\069\114\092\065\095\092\046\055\092\018\107\092\113\069\114\065\046\089\111"), 
			Media = zmediaClown
		}
	elseif ztaskFragedasSchaf.Complete == true then
		_Urwigo.MessageBox{
			Text = _dHPQ("\116\121\069\027\092\065\089\069\065\055\046\069\094\121\069\027\031\055\070\113\069\114\065\092\089\092\046\043\069\003\031\055\069\100\121\113\113\069\092\023\031\055\069\113\065\031\055\095\069\103\092\055\046\069\027\121\072\092\113\043\069\099\046\121\072\095\069\089\092\113\069\090\070\072\092\018\069\121\113\069\089\092\046\069\090\070\072\092\018\027\095\121\113\072\092\043"), 
			Media = zmediaSchaf
		}
	else
		_Urwigo.MessageBox{
			Text = _dHPQ("\003\055\046\069\114\121\046\095\069\027\031\055\070\113\069\092\065\113\103\121\018\069\055\065\092\046\014\069\055\121\028\095\069\089\121\027\069\041\031\055\121\107\069\121\028\092\046\069\113\070\031\055\069\113\065\031\055\095\069\072\092\107\046\121\072\095\043\069\003\055\046\069\103\023\092\027\027\095\069\092\027\069\027\031\055\070\113\069\121\113\100\018\065\031\100\092\113\014\069\027\070\113\027\095\069\027\121\072\095\069\092\027\069\092\023\031\055\069\113\065\031\055\095\027\043")
		}
	end
end
function zoneSchafe:OnExit()
	if Spielstand == 2 then
		Spielstand = 3
	end
	if ztaskFragedasSchaf.Complete == true then
		zoneSchafe.Visible = false
	end
	cartKirchenscheibeEingeschmissen:RequestSync()
end
function zoneVogelstange:OnEnter()
	zcharacterVogel.Visible = true
	zcharacterClown:MoveTo(zoneVogelstange)
	zcharacterVogel:MoveTo(zoneVogelstange)
	if Spielstand < 4 then
		_Urwigo.MessageBox{
			Text = _dHPQ("\075\065\092\046\069\114\070\055\113\095\069\089\092\046\069\090\070\072\092\018\043\069\099\046\121\072\095\069\065\055\113\069\023\113\089\069\092\046\069\114\065\046\089\069\092\023\031\055\069\092\095\114\121\027\069\092\046\110\121\092\055\018\092\113\043"), 
			Media = zmediaClown
		}
	elseif ztaskFragedenVogel.Complete == true then
		_Urwigo.MessageBox{
			Text = _dHPQ("\075\121\028\095\069\065\055\046\069\092\023\031\055\069\124\092\046\018\121\023\107\092\113\111\069\003\055\046\069\114\121\046\095\069\027\031\055\070\113\069\092\065\113\103\121\018\069\055\065\092\046\043\069\038\103\069\089\092\113\069\041\031\055\121\095\110\069\110\023\069\107\065\113\089\092\113\069\028\046\121\023\031\055\095\069\065\055\046\069\089\121\027\069\073\121\023\028\092\046\114\070\046\095\069\023\113\089\069\089\121\027\069\107\065\113\089\092\095\069\065\055\046\069\023\113\095\092\046\069\089\092\046\069\077\121\113\100\043")
		}
	else
		_Urwigo.MessageBox{
			Text = _dHPQ("\003\055\046\069\114\121\046\095\069\027\031\055\070\113\069\092\065\113\103\121\018\069\055\065\092\046\014\069\055\121\028\095\069\089\092\113\069\090\070\072\092\018\069\121\028\092\046\069\113\070\031\055\069\113\065\031\055\095\069\072\092\107\046\121\072\095\043\069\003\055\046\069\103\023\092\027\027\095\069\065\055\113\069\027\031\055\070\113\069\121\113\100\018\065\031\100\092\113\014\069\027\070\113\027\095\069\027\121\072\095\069\092\046\069\092\023\031\055\069\113\065\031\055\095\027\043")
		}
	end
end
function zoneVogelstange:OnExit()
	if Spielstand == 3 then
		Spielstand = 4
	end
	if ztaskFragedenVogel.Complete == true then
		zoneVogelstange.Visible = false
	end
	cartKirchenscheibeEingeschmissen:RequestSync()
end
function zoneBankSchneider:OnEnter()
	zcharacterClown:MoveTo(zoneBankSchneider)
	if (Spielstand < 5) and (not Wherigo.NoCaseEquals(Zauberwort, "Simsalabim")) then
		_Urwigo.RunDialogs(function()
			Wherigo.GetInput(zinputZauberwort)
		end)
	elseif Wherigo.NoCaseEquals(Zauberwort, _dHPQ("\041\065\103\027\121\018\121\028\065\103")) then
		_Urwigo.MessageBox{
			Text = _dHPQ("\116\121\027\069\073\121\023\028\092\046\114\070\046\095\069\055\121\028\095\069\065\055\046\069\072\092\107\023\113\089\092\113\043\069\074\092\113\113\069\065\055\046\069\089\092\113\069\041\031\055\121\095\110\069\107\065\113\089\092\113\069\114\070\018\018\095\069\103\023\092\027\027\095\069\065\055\046\069\121\018\027\069\113\121\092\031\055\027\095\092\027\069\110\023\103\069\075\023\113\089\043\069\116\092\113\069\107\065\113\089\092\095\069\065\055\046\069\121\103\069\075\070\031\055\027\065\095\110\043")
		}
	else
		_Urwigo.MessageBox{
			Text = _dHPQ("\003\055\046\069\055\121\028\095\069\089\121\027\069\073\121\023\028\092\046\114\070\046\095\069\113\070\031\055\069\113\065\031\055\095\069\046\065\031\055\095\065\072\069\092\065\113\072\092\072\092\028\092\113\043\069\004\023\031\100\095\069\089\070\031\055\069\092\065\113\103\121\018\069\023\113\095\092\046\069\089\065\092\069\077\121\113\100\043\069\074\092\113\113\069\065\055\046\069\092\027\069\072\092\107\023\113\089\092\113\069\055\121\028\095\069\100\018\065\031\100\095\069\103\065\031\055\069\113\070\031\055\069\092\065\113\103\121\018\069\121\113\043"), 
			Media = zmediaClown
		}
	end
end
function zoneBankSchneider:OnExit()
	if Spielstand == 4 then
		Spielstand = 5
	end
	if Wherigo.NoCaseEquals(Zauberwort, _dHPQ("\041\065\103\027\121\018\121\028\065\103")) then
		zoneBankSchneider.Visible = false
	end
	cartKirchenscheibeEingeschmissen:RequestSync()
end
function zoneHierWarMalEinHochsitz:OnEnter()
	zcharacterHund.Visible = true
	zcharacterHund:MoveTo(zoneHierWarMalEinHochsitz)
	zcharacterClown:MoveTo(zoneHierWarMalEinHochsitz)
	if Spielstand < 6 then
		_Urwigo.MessageBox{
			Text = _dHPQ("\003\055\046\069\027\092\065\089\069\107\121\027\095\069\107\092\046\095\065\072\043\069\075\065\092\046\069\107\065\113\089\092\095\069\065\055\046\069\089\092\113\069\075\023\113\089\043\069\116\092\046\069\114\065\046\089\069\092\023\031\055\069\027\121\072\092\113\014\069\114\121\027\069\092\046\069\114\092\065\027\027\043"), 
			Media = zmediaClown
		}
	elseif ztaskFragedenHund.Complete == true then
		_Urwigo.MessageBox{
			Text = _dHPQ("\003\055\046\069\114\121\046\095\069\027\031\055\070\113\069\092\065\113\103\121\018\069\055\065\092\046\069\023\113\089\069\055\121\028\095\069\089\092\113\069\075\023\113\089\069\072\092\107\046\121\072\095\043\069\004\092\055\095\069\094\092\095\110\095\069\114\092\065\095\092\046\069\110\023\103\069\041\031\055\103\092\095\095\092\046\018\065\113\072\043")
		}
	else
		_Urwigo.MessageBox{
			Text = _dHPQ("\003\055\046\069\114\121\046\095\069\027\031\055\070\113\069\092\065\113\103\121\018\069\055\065\092\046\014\069\055\121\028\095\069\089\092\113\069\075\023\113\089\069\121\028\092\046\069\113\070\031\055\069\113\065\031\055\095\069\072\092\107\046\121\072\095\043\069\003\055\046\069\103\023\092\027\027\095\069\065\055\113\069\027\031\055\070\113\069\121\113\100\018\065\031\100\092\113\014\069\027\070\113\027\095\069\027\121\072\095\069\092\046\069\092\023\031\055\069\113\065\031\055\095\027\043"), 
			Media = zmediaClown
		}
	end
end
function zoneHierWarMalEinHochsitz:OnExit()
	if Spielstand == 5 then
		Spielstand = 6
	end
	if ztaskFragedenHund.Complete == true then
		zoneHierWarMalEinHochsitz.Visible = false
	end
	cartKirchenscheibeEingeschmissen:RequestSync()
end
function zoneBankEcke:OnEnter()
	zcharacterSchmetterling.Visible = true
	zcharacterClown.Commands.Ihrwisstwereswar.Enabled = true
	zcharacterClown.Commands.Ihrwisstnichtwasihrtunsollt.Enabled = false
	zcharacterSchmetterling:MoveTo(zoneBankEcke)
	zcharacterClown:MoveTo(zoneBankEcke)
	if Spielstand < 7 then
		_Urwigo.MessageBox{
			Text = _dHPQ("\003\055\046\069\027\092\065\089\069\107\121\027\095\069\107\092\046\095\065\072\043\069\075\065\092\046\069\107\065\113\089\092\095\069\065\055\046\069\089\092\113\069\041\031\055\103\092\095\095\092\046\018\065\113\072\043\069\056\046\069\114\065\046\089\069\092\023\031\055\069\027\121\072\092\113\069\114\121\027\069\092\046\069\114\092\065\027\027\043"), 
			Media = zmediaClown
		}
	elseif ztaskFragedenSchmetterling.Complete == true then
		_Urwigo.MessageBox{
			Text = _dHPQ("\003\055\046\069\055\121\028\095\069\027\031\055\070\113\069\103\065\095\069\089\092\103\069\041\031\055\103\092\095\095\092\046\018\065\113\072\069\072\092\027\016\046\070\031\055\092\113\043\069\074\092\113\113\069\065\055\046\069\046\065\031\055\095\065\072\069\121\023\107\072\092\016\121\027\027\095\069\055\121\028\095\014\069\114\065\027\027\095\069\065\055\046\069\094\092\095\110\095\069\114\092\046\069\089\092\046\069\050\121\092\095\092\046\069\065\027\095\069\023\113\089\069\028\092\100\070\103\103\095\069\089\065\092\069\068\121\031\055\092\100\070\070\046\089\065\113\121\095\092\113\064"), 
			Media = zmediaClown
		}
	else
		_Urwigo.MessageBox{
			Text = _dHPQ("\003\055\046\069\114\121\046\095\069\027\031\055\070\113\069\092\065\113\103\121\018\069\055\065\092\046\014\069\055\121\028\095\069\089\092\113\069\041\031\055\103\092\095\095\092\046\018\065\113\072\069\121\028\092\046\069\113\070\031\055\069\113\065\031\055\095\069\072\092\107\046\121\072\095\043\069\003\055\046\069\103\023\092\027\027\095\069\065\055\113\069\027\031\055\070\113\069\121\113\100\018\065\031\100\092\113\014\069\027\070\113\027\095\069\027\121\072\095\069\092\046\069\092\023\031\055\069\113\065\031\055\095\027\043"), 
			Media = zmediaClown
		}
	end
end
function zoneBankEcke:OnExit()
	if Spielstand == 6 then
		Spielstand = 7
	end
	cartKirchenscheibeEingeschmissen:RequestSync()
end
function zoneCache:OnEnter()
	cartKirchenscheibeEingeschmissen.Complete = true
	_Urwigo.OldDialog{
		{
			Text = _dHPQ("\075\065\092\046\069\065\027\095\069\089\092\046\069\068\121\031\055\092\064\069\090\065\092\018\069\041\016\121\111\069\028\092\065\103\069\041\023\031\055\092\113\126\077\080\105"), 
			Media = zmediaClown
		}, 
		{
			Text = _dHPQ("\075\065\092\046\069\089\092\046\069\099\046\092\065\027\031\055\121\018\095\031\070\089\092"), 
			Media = zmediaClown
		}, 
		{
			Text = string.sub(Player.CompletionCode, 1, 15), 
			Media = zmediaClown
		}
	}
	cartKirchenscheibeEingeschmissen:RequestSync()
end
function ztaskFindeherauswerdieScheibeinderKircheeingeschlagenhat:OnClick()
	if ((((ztaskFragedasPferd.Complete == true) and (ztaskFragedasSchaf.Complete == true)) and (ztaskFragedenVogel.Complete == true)) and (ztaskFragedenHund.Complete == true)) and (ztaskFragedenSchmetterling.Complete == true) then
		_Urwigo.RunDialogs(function()
			Wherigo.GetInput(zinputAntwort)
		end)
	else
		_Urwigo.OldDialog{
			{
				Text = _dHPQ("\003\055\046\069\055\121\028\095\069\113\070\031\055\069\113\065\031\055\095\069\121\018\018\092\069\050\065\092\046\092\069\028\092\107\046\121\072\095\043\069"), 
				Media = zmediaClown
			}, 
			{
				Text = _dHPQ("\003\055\046\069\100\070\092\113\113\095\069\113\070\031\055\069\113\065\031\055\095\069\114\065\027\027\092\113\069\114\092\046\069\092\027\069\114\121\046\043"), 
				Media = zmediaClown
			}, 
			{
				Text = _dHPQ("\003\055\046\069\027\070\018\018\095\092\069\113\065\031\055\095\069\027\031\055\023\103\103\092\018\113\014\069\027\070\113\089\092\046\113\069\089\121\027\069\080\121\092\095\027\092\018\069\089\023\046\031\055\069\023\092\028\092\046\018\092\072\092\113\069\018\070\092\027\092\113\064"), 
				Media = zmediaClown
			}
		}
	end
end
function ztaskFragedasPferd:OnClick()
	ztaskFragedasPferd.Complete = true
	ztaskFragedasPferd.Visible = false
	_Urwigo.MessageBox{
		Text = _dHPQ("\116\023\069\107\065\113\089\092\027\095\069\089\121\027\069\127\107\092\046\089\069\124\070\046\069\089\092\046\069\074\092\065\089\092")
	}
end
function ztaskFragedasSchaf:OnClick()
	ztaskFragedasSchaf.Complete = true
	_Urwigo.MessageBox{
		Text = ""
	}
end
function ztaskFragedenVogel:OnClick()
	ztaskFragedenVogel.Complete = true
	_Urwigo.MessageBox{
		Text = ""
	}
end
function ztaskFragedenHund:OnClick()
	ztaskFragedenHund.Active = true
	_Urwigo.MessageBox{
		Text = ""
	}
end
function ztaskFragedenSchmetterling:OnClick()
	ztaskFragedenSchmetterling.Active = true
	_Urwigo.MessageBox{
		Text = ""
	}
end
function zinputZauberwort:OnGetInput(input)
	if input == nil then
		input = ""
	end
	Zauberwort = input
	if Wherigo.NoCaseEquals(Zauberwort, _dHPQ("\041\065\103\027\121\018\121\028\065\103")) then
		_Urwigo.MessageBox{
			Text = _dHPQ("\116\023\069\055\121\027\095\069\089\121\027\069\073\121\023\028\092\046\114\070\046\095\069\046\065\031\055\095\065\072\069\092\065\113\072\092\072\092\028\092\113\069\023\113\089\069\100\121\113\113\027\095\069\114\092\065\095\092\046\103\121\031\055\092\113\043\069\041\023\031\055\092\069\089\092\113\069\075\023\113\089"), 
			Media = zmediaClown
		}
		zoneHierWarMalEinHochsitz.Active = true
		zoneHierWarMalEinHochsitz.Visible = true
	else
		_Urwigo.MessageBox{
			Text = _dHPQ("\116\121\027\069\114\121\046\069\107\121\018\027\031\055\064\069\003\055\046\069\114\070\018\018\095\069\089\070\031\055\069\114\070\055\018\069\113\065\031\055\095\069\027\031\055\023\103\103\092\018\113\111\069\003\055\046\069\107\065\113\089\092\095\069\089\121\027\069\073\121\023\028\092\046\114\070\046\095\069\023\113\095\092\046\069\089\092\046\069\077\121\113\100\064\069\074\092\113\113\069\065\055\046\069\092\065\113\092\113\069\113\092\023\092\113\069\056\065\113\072\121\028\092\124\092\046\027\023\031\055\069\027\095\121\046\095\092\113\069\114\070\018\018\095\014\069\100\018\065\031\100\095\069\103\065\031\055\069\113\070\031\055\069\092\065\113\103\121\018\069\121\113\064"), 
			Media = zmediaClown, 
			Buttons = {
				_dHPQ("\070\100")
			}
		}
	end
end
function zinputAntwort:OnGetInput(input)
	if input == nil then
		input = ""
	end
	Antwort = input
	if Wherigo.NoCaseEquals(Antwort, _dHPQ("\075\023\113\089")) and Wherigo.NoCaseEquals(Zauberwort, _dHPQ("\041\065\103\027\121\018\121\028\065\103")) then
		zoneCache.Visible = true
		zoneCache.Active = true
		cartKirchenscheibeEingeschmissen.Complete = true
		_Urwigo.MessageBox{
			Text = _dHPQ("\011\121\014\069\089\121\027\069\027\095\065\103\103\095\043\069\085\018\027\069\077\092\018\070\055\113\023\113\072\069\027\092\055\095\069\065\055\046\069\094\092\095\110\095\069\089\121\027\069\068\121\031\055\092\124\092\046\027\095\092\031\100\069\023\113\095\092\046\069\079\070\031\121\095\065\070\113\027\043"), 
			Media = zmediaClown
		}
	else
		_Urwigo.OldDialog{
			{
				Text = _dHPQ("\116\121\027\069\114\121\046\069\107\121\018\027\031\055\043\069\038\092\028\092\046\018\092\072\095\069\113\070\031\055\069\092\065\113\103\121\018\043"), 
				Media = zmediaClown
			}, 
			{
				Text = _dHPQ("\056\065\113\092\069\068\055\121\113\031\092\069\055\121\028\095\069\065\055\046\069\113\070\031\055\043"), 
				Media = zmediaClown
			}
		}
	end
end
function zcharacterClown:OnIhrwisstnichtwasihrtunsollt(target)
	if Spielstand == 0 then
		zoneWeide.Visible = true
		zoneWeide.Active = true
		ztaskFindeherauswerdieScheibeinderKircheeingeschlagenhat.Active = true
		_Urwigo.OldDialog{
			{
				Text = _dHPQ("\074\065\092\069\065\055\046\069\027\092\055\095\014\069\065\027\095\069\092\065\113\069\099\092\113\027\095\092\046\069\065\113\069\089\092\046\069\049\065\046\031\055\092\069\110\023\069\077\046\023\031\055\069\072\092\072\121\113\072\092\113\043\069\074\065\046\069\103\023\092\027\027\092\113\069\055\092\046\121\023\027\107\065\113\089\092\113\069\114\092\046\069\089\121\027\069\114\121\046\064"), 
				Media = zmediaClown
			}, 
			{
				Text = _dHPQ("\099\023\092\113\107\069\050\065\092\046\092\069\114\121\046\092\113\069\121\023\107\069\089\092\103\069\041\016\065\092\018\016\018\121\095\110\014\069\121\018\027\069\092\027\069\016\121\027\027\065\092\046\095\069\065\027\095\014\069\089\121\046\023\113\095\092\046\069\121\023\031\055\069\089\092\046\069\041\031\055\103\092\095\095\092\046\018\065\113\072\014\069\089\092\103\069\113\065\092\103\121\113\089\069\027\070\069\092\095\114\121\027\069\110\023\095\046\121\023\092\113\069\114\023\092\046\089\092\043"), 
				Media = zmediaClown
			}, 
			{
				Text = _dHPQ("\003\055\046\069\103\023\092\027\027\095\069\121\018\018\092\069\107\023\092\113\107\069\028\092\107\046\121\072\092\113\014\069\023\103\069\055\092\046\121\023\027\110\023\107\065\113\089\092\113\014\069\114\092\046\069\089\065\092\069\041\031\055\092\065\028\092\069\121\023\107\069\089\092\103\069\004\092\114\065\027\027\092\113\069\055\121\095\043"), 
				Media = zmediaClown
			}, 
			{
				Text = _dHPQ("\099\121\113\072\095\069\103\065\095\069\089\092\103\069\127\107\092\046\089\069\121\113\043\069\003\055\046\069\107\065\113\089\092\095\069\092\027\069\121\023\107\069\089\092\046\069\074\092\065\089\092\043"), 
				Media = zmediaClown
			}
		}
	elseif Spielstand == 1 then
		zoneSchafe.Visible = true
		zoneSchafe.Active = true
		if ztaskFragedasPferd.Complete == true then
			_Urwigo.MessageBox{
				Text = _dHPQ("\081\065\095\069\089\092\103\069\127\107\092\046\089\069\055\121\028\095\069\065\055\046\069\027\031\055\070\113\069\072\092\027\016\046\070\031\055\092\113\043\069\004\092\055\095\069\094\092\095\110\095\069\110\023\103\069\041\031\055\121\107\064")
			}
		else
			_Urwigo.MessageBox{
				Text = _dHPQ("\003\055\046\069\055\121\028\095\069\089\121\027\069\127\107\092\046\089\069\113\070\031\055\069\072\092\107\046\121\072\095\014\069\070\028\069\092\027\069\092\095\114\121\027\069\114\092\065\027\027\064"), 
				Media = zmediaClown
			}
		end
	elseif Spielstand == 2 then
		zoneVogelstange.Visible = true
		zoneVogelstange.Active = true
		if ztaskFragedasSchaf.Complete == true then
			_Urwigo.MessageBox{
				Text = _dHPQ("\003\055\046\069\055\121\028\095\069\027\031\055\070\113\069\103\065\095\069\089\092\103\069\041\031\055\121\107\069\072\092\027\016\046\070\031\055\092\113\043\069\004\092\055\095\069\094\092\095\110\095\069\110\023\103\069\090\070\072\092\018\043")
			}
		else
			_Urwigo.MessageBox{
				Text = _dHPQ("\074\121\046\023\103\069\107\046\121\072\095\069\065\055\046\069\089\121\027\069\041\031\055\121\107\069\113\065\031\055\095\069\092\065\113\107\121\031\055\014\069\070\028\069\092\027\069\092\095\114\121\027\069\114\092\065\027\027\043\069\090\065\092\018\018\092\065\031\055\095\069\100\070\103\103\095\069\065\055\046\069\089\121\113\113\069\114\092\065\095\092\046\043")
			}
		end
	elseif Spielstand == 3 then
		zoneBankSchneider.Active = true
		zoneBankSchneider.Visible = true
		if ztaskFragedenVogel.Complete == true then
			_Urwigo.MessageBox{
				Text = _dHPQ("\003\055\046\069\055\121\028\095\069\027\031\055\070\113\069\103\065\095\069\089\092\103\069\090\070\072\092\018\069\072\092\027\016\046\070\031\055\092\113\014\069\070\089\092\046\069\111\069\004\092\055\095\069\089\070\031\055\069\094\092\095\110\095\069\110\023\046\069\077\121\113\100\069\023\113\089\069\072\023\031\100\095\069\114\121\027\069\089\121\069\121\023\107\069\092\023\031\055\069\114\121\046\095\092\095\043")
			}
		else
			_Urwigo.MessageBox{
				Text = _dHPQ("\049\018\065\031\100\095\069\121\023\107\069\089\092\113\069\090\070\072\092\018\043\069\116\092\046\069\114\065\046\089\069\092\023\031\055\069\089\121\113\113\069\027\121\072\092\113\014\069\114\121\027\069\092\046\069\114\092\065\027\027\043")
			}
		end
	elseif Spielstand == 4 then
		zoneHierWarMalEinHochsitz.Visible = true
		zoneHierWarMalEinHochsitz.Active = true
		if Wherigo.NoCaseEquals(Zauberwort, _dHPQ("\041\065\103\027\121\018\121\028\065\103")) then
			_Urwigo.OldDialog{
				{
					Text = _dHPQ("\004\092\055\095\069\094\092\095\110\095\069\110\023\103\069\075\023\113\089\043"), 
					Media = zmediaClown
				}, 
				{
					Text = _dHPQ("\116\092\113\069\107\065\113\089\092\095\069\065\055\046\069\089\121\014\069\114\070\069\107\046\023\092\055\092\046\069\103\121\018\069\092\065\113\069\075\070\031\055\027\065\095\110\069\114\121\046\043"), 
					Media = zmediaClown
				}, 
				{
					Text = _dHPQ("\099\070\018\072\095\069\089\092\103\069\074\092\072\069\065\113\069\080\065\031\055\095\023\113\072\069\041\023\092\089\092\113\043"), 
					Media = zmediaClown
				}
			}
			_Urwigo.MessageBox{
				Text = _dHPQ("\004\092\055\095\069\094\092\095\110\095\069\110\023\103\069\075\023\113\089\043\069\116\092\113\069\107\065\113\089\092\095\069\065\055\046\069\121\103\069\100\018\092\065\113\092\113\069\075\070\031\055\027\065\095\110"), 
				Media = zmediaClown
			}
		else
			_Urwigo.RunDialogs(function()
				Wherigo.GetInput(zinputZauberwort)
			end)
		end
	elseif Spielstand == 5 then
		zoneBankEcke.Visible = true
		zoneBankEcke.Active = true
		if ztaskFragedenHund.Complete == true then
			_Urwigo.MessageBox{
				Text = _dHPQ("\074\121\027\069\055\121\095\069\089\092\046\069\075\023\113\089\069\092\023\031\055\069\092\046\110\121\092\055\018\095\111\069\099\046\121\072\095\069\094\092\095\110\095\069\089\092\113\069\041\031\055\103\092\095\095\092\046\018\065\113\072\043"), 
				Media = zmediaClown
			}
		else
			_Urwigo.MessageBox{
				Text = _dHPQ("\116\092\046\069\075\023\113\089\069\114\065\046\089\069\092\023\031\055\069\092\095\114\121\027\069\027\121\072\092\014\069\114\092\113\113\069\065\055\046\069\065\055\113\069\121\113\100\018\065\031\100\095\043"), 
				Media = zmediaClown
			}
		end
	elseif ((Spielstand == 6) and Wherigo.NoCaseEquals(Zauberwort, _dHPQ("\041\065\103\027\121\018\121\028\065\103"))) and Wherigo.NoCaseEquals(Antwort, _dHPQ("\075\023\113\089")) then
		_Urwigo.MessageBox{
			Text = _dHPQ("\116\121\027\069\073\121\023\028\092\046\114\070\046\095\069\065\027\095\069\046\065\031\055\095\065\072\069\023\113\089\069\089\092\113\069\050\121\092\095\092\046\069\100\070\113\113\095\092\095\069\065\055\046\069\121\023\031\055\069\028\092\113\092\113\113\092\113\043\069\003\031\055\069\089\023\092\046\107\095\069\094\092\095\110\095\069\110\023\103\069\068\121\031\055\092\043"), 
			Media = zmediaClown
		}
		zoneCache.Visible = true
		zoneCache.Active = true
	else
		_Urwigo.RunDialogs(function()
			Wherigo.GetInput(zinputAntwort)
		end)
	end
end
function zcharacterClown:OnIhrwisstwereswar(target)
	if ((((ztaskFragedasPferd.Complete == true) and (ztaskFragedasSchaf.Complete == true)) and (ztaskFragedenVogel.Complete == true)) and (ztaskFragedenHund.Complete == true)) and (ztaskFragedenSchmetterling.Complete == true) then
		_Urwigo.RunDialogs(function()
			Wherigo.GetInput(zinputAntwort)
		end)
	else
		_Urwigo.OldDialog{
			{
				Text = _dHPQ("\003\055\046\069\055\121\028\095\069\113\070\031\055\069\113\065\031\055\095\069\121\018\018\092\069\050\065\092\046\092\069\028\092\107\046\121\072\095\043\069"), 
				Media = zmediaClown
			}, 
			{
				Text = _dHPQ("\003\055\046\069\100\070\092\113\113\095\069\113\070\031\055\069\113\065\031\055\095\069\114\065\027\027\092\113\069\114\092\046\069\092\027\069\114\121\046\043"), 
				Media = zmediaClown
			}, 
			{
				Text = _dHPQ("\003\055\046\069\027\070\018\018\095\092\069\113\065\031\055\095\069\027\031\055\023\103\103\092\018\113\014\069\027\070\113\089\092\046\113\069\089\121\027\069\080\121\092\095\027\092\018\069\089\023\046\031\055\069\023\092\028\092\046\018\092\072\092\113\069\018\070\092\027\092\113\064"), 
				Media = zmediaClown
			}
		}
	end
end
function zcharacterPferd:OnWennihrmichfragt(target)
	ztaskFragedasPferd.Complete = true
	zoneSchafe.Active = true
	zoneSchafe.Visible = true
	_Urwigo.OldDialog{
		{
			Text = _dHPQ("\041\031\055\070\092\113\014\069\089\121\027\027\069\065\055\046\069\103\065\031\055\069\028\092\027\023\031\055\095\043"), 
			Media = zmediaPferd
		}, 
		{
			Text = _dHPQ("\085\055\014\069\065\055\046\069\114\070\018\018\095\069\114\065\027\027\092\113\014\069\114\092\046\069\089\065\092\069\041\031\055\092\065\028\092\069\065\113\069\089\092\046\069\049\065\046\031\055\092\069\100\121\016\023\095\095\069\072\092\103\121\031\055\095\069\055\121\095\043"), 
			Media = zmediaPferd
		}, 
		{
			Text = _dHPQ("\003\031\055\069\114\121\046\069\089\121\028\092\065\014\069\121\018\027\069\092\027\069\016\121\027\027\065\092\046\095\069\065\027\095\043\069\003\068\075\069\074\085\080\069\056\041\069\085\077\056\080\069\002\003\068\075\050\064"), 
			Media = zmediaPferd
		}, 
		{
			Text = _dHPQ("\081\092\055\046\069\114\065\018\018\069\065\031\055\069\092\023\031\055\069\113\065\031\055\095\069\027\121\072\092\113\043"), 
			Media = zmediaPferd
		}, 
		{
			Text = _dHPQ("\099\046\121\072\095\069\089\070\031\055\069\103\121\018\069\089\121\027\069\041\031\055\121\107\043"), 
			Media = zmediaPferd
		}, 
		{
			Text = _dHPQ("\116\121\027\069\107\065\113\089\092\095\069\065\055\046\069\121\023\107\069\089\092\103\069\041\031\055\121\107\016\018\121\095\110"), 
			Media = zmediaPferd
		}
	}
end
function zcharacterSchaf:OnWennihrmichfragt(target)
	zoneVogelstange.Active = true
	zoneVogelstange.Visible = true
	ztaskFragedasSchaf.Complete = true
	_Urwigo.OldDialog{
		{
			Text = _dHPQ("\075\121\095\069\089\121\027\069\127\107\092\046\089\069\092\023\031\055\069\072\092\027\121\072\095\014\069\114\070\069\065\055\046\069\103\065\031\055\069\107\065\113\089\092\095\111\069"), 
			Media = zmediaSchaf
		}, 
		{
			Text = _dHPQ("\003\055\046\069\114\070\018\018\095\069\027\065\031\055\092\046\069\124\070\113\069\103\065\046\069\114\065\027\027\092\113\014\069\114\121\027\069\089\121\069\121\113\069\089\092\046\069\049\065\046\031\055\092\069\072\092\113\121\023\069\016\121\027\027\065\092\046\095\069\065\027\095\043"), 
			Media = zmediaSchaf
		}, 
		{
			Text = _dHPQ("\003\031\055\069\114\092\065\027\027\069\092\027\069\121\023\031\055\069\113\065\031\055\095\069\027\070\069\072\121\113\110\069\072\092\113\121\023\043"), 
			Media = zmediaSchaf
		}, 
		{
			Text = _dHPQ("\074\121\027\069\065\031\055\069\121\028\092\046\069\072\092\113\121\023\069\114\092\065\027\027\054\069\003\068\075\069\074\085\080\069\056\041\069\002\003\068\075\050\064"), 
			Media = zmediaSchaf
		}, 
		{
			Text = _dHPQ("\003\031\055\069\072\018\121\023\028\092\069\089\092\046\069\090\070\072\092\018\069\100\121\113\113\069\092\023\031\055\069\114\092\065\095\092\046\069\055\092\018\107\092\113\043"), 
			Media = zmediaSchaf
		}, 
		{
			Text = _dHPQ("\003\055\046\069\107\065\113\089\092\095\069\065\055\113\069\121\113\069\089\092\046\069\090\070\072\092\018\027\095\121\113\072\092\043"), 
			Media = zmediaSchaf
		}
	}
end
function zcharacterSchmetterling:OnWennihrmichfragt(target)
	_Urwigo.OldDialog{
		{
			Text = _dHPQ("\075\065\092\046\069\028\065\113\069\065\031\055\069\064"), 
			Media = zmediaSchmetterling
		}, 
		{
			Text = _dHPQ("\003\031\055\069\114\092\046\089\092\069\092\023\031\055\069\121\018\018\092\027\069\124\092\046\046\121\095\092\113\014\069\114\121\027\069\065\055\046\069\114\065\027\027\092\113\069\103\023\092\027\027\095\069\023\103\069\089\121\027\069\080\121\092\095\027\092\018\069\110\023\069\018\070\092\027\092\113\043"), 
			Media = zmediaSchmetterling
		}, 
		{
			Text = _dHPQ("\003\031\055\069\114\121\046\069\092\027\069\113\121\095\023\092\046\018\065\031\055\069\113\065\031\055\095\014\069\089\121\027\069\100\070\092\113\113\095\069\065\055\046\069\092\023\031\055\069\089\092\113\100\092\113\064"), 
			Media = zmediaSchmetterling
		}, 
		{
			Text = _dHPQ("\003\031\055\069\114\092\065\027\027\069\121\028\092\046\069\114\092\046\069\092\027\069\114\121\046\069\043\043\043"), 
			Media = zmediaSchmetterling
		}, 
		{
			Text = _dHPQ("\043\043\069\065\031\055\069\114\065\018\018\069\121\028\092\046\069\100\092\065\113\092\069\127\092\095\110\092\069\027\092\065\113\043")
		}, 
		{
			Text = _dHPQ("\002\023\046\069\027\070\069\124\065\092\018\069\054\069\056\041\069\074\085\080\069\056\003\002\069\050\085\056\050\056\080\069\038\002\116\069\002\038\080\069\056\003\002\056\080\069\090\034\002\069\116\056\002\069\085\002\116\056\080\056\002\069\079\038\056\004\050\064"), 
			Media = zmediaSchmetterling
		}, 
		{
			Text = _dHPQ("\099\121\018\018\027\069\065\055\046\069\113\065\031\055\095\069\103\092\055\046\069\072\092\113\121\023\069\114\065\027\027\095\014\069\114\121\027\069\089\065\092\069\121\113\089\092\046\092\113\069\072\092\027\121\072\095\069\055\121\028\092\113\014\069\089\121\113\113\069\107\046\121\072\095\069\027\065\092\069\089\070\031\055\069\113\070\031\055\069\092\065\113\103\121\018\043"), 
			Media = zmediaSchmetterling
		}, 
		{
			Text = _dHPQ("\074\092\113\113\069\065\055\046\069\114\065\027\027\095\069\114\092\046\069\092\027\069\114\121\046\043\069\116\121\113\113\069\100\018\065\031\100\095\069\121\023\107\069\089\092\113\069\068\018\070\114\113\069\023\113\089\069\072\092\028\095\069\089\065\092\069\046\065\031\055\095\065\072\069\085\113\095\114\070\046\095\043\069"), 
			Media = zmediaSchmetterling
		}
	}
	ztaskFragedenSchmetterling.Complete = true
end
function zcharacterHund:OnWennihrmichfragt(target)
	_Urwigo.OldDialog{
		{
			Text = _dHPQ("\074\070\018\018\095\069\065\055\046\069\103\065\095\069\103\065\046\069\027\016\065\092\018\092\113\069\070\089\092\046\069\114\070\018\018\095\069\065\055\046\069\121\023\031\055\069\113\023\046\069\080\121\092\095\027\092\018\069\018\070\092\027\092\113\111"), 
			Media = zmediaHund
		}, 
		{
			Text = _dHPQ("\116\092\046\069\090\070\072\092\018\069\055\121\095\069\092\023\031\055\069\072\092\027\121\072\095\014\069\089\121\027\027\069\065\031\055\069\089\065\092\069\099\092\113\027\095\092\046\027\031\055\092\065\028\092\069\100\121\016\023\095\095\069\072\092\103\121\031\055\095\069\055\121\028\092\043\069"), 
			Media = zmediaHund
		}, 
		{
			Text = _dHPQ("\116\121\027\069\065\027\095\069\121\028\092\046\069\107\121\018\027\031\055\043"), 
			Media = zmediaHund
		}, 
		{
			Text = _dHPQ("\003\031\055\069\055\121\028\092\069\072\092\113\121\023\069\072\092\027\092\055\092\113\014\069\089\121\027\027\069\089\121\027\069\041\031\055\121\107\069\089\065\092\069\041\031\055\092\065\028\092\069\100\121\016\023\095\095\069\072\092\103\121\031\055\095\069\055\121\095\043"), 
			Media = zmediaHund
		}, 
		{
			Text = _dHPQ("\116\121\027\069\114\065\046\089\069\089\092\046\069\041\031\055\103\092\095\095\092\046\018\065\113\072\069\092\023\031\055\069\028\092\027\095\121\092\095\065\072\092\113\064"), 
			Media = zmediaHund
		}, 
		{
			Text = _dHPQ("\116\092\113\069\041\031\055\103\092\095\095\092\046\018\065\113\072\069\107\065\113\089\092\095\069\065\055\046\069\121\113\069\089\092\046\069\077\121\113\100\069\121\113\069\089\092\046\069\056\031\100\092\043"), 
			Media = zmediaHund
		}
	}
	ztaskFragedenHund.Complete = true
	zoneBankEcke.Active = true
	zoneBankEcke.Visible = true
end
function zcharacterVogel:OnWennihrmichfragt(target)
	_Urwigo.OldDialog{
		{
			Text = _dHPQ("\011\092\095\110\095\069\055\121\028\095\069\065\055\046\069\103\065\031\055\069\072\092\107\023\113\089\092\113\069\064"), 
			Media = zmediaVogel
		}, 
		{
			Text = _dHPQ("\038\113\089\069\065\055\046\069\114\070\018\018\095\069\027\065\031\055\092\046\069\124\070\113\069\103\065\046\069\114\065\027\027\092\113\014\069\114\121\027\069\089\121\069\072\092\113\121\023\069\121\113\069\089\092\046\069\049\065\046\031\055\092\069\016\121\027\027\065\092\046\095\069\065\027\095\043"), 
			Media = zmediaVogel
		}, 
		{
			Text = _dHPQ("\003\031\055\069\055\121\028\092\069\092\027\069\072\092\113\121\023\069\072\092\027\092\055\092\113\043\069\056\027\069\114\121\046\069\089\092\046\069\075\023\113\089\043"), 
			Media = zmediaVogel
		}, 
		{
			Text = _dHPQ("\116\056\080\069\075\038\002\116\069\075\085\050\069\116\003\056\069\041\068\075\056\003\077\056\069\073\056\080\077\080\034\068\075\056\002\043"), 
			Media = zmediaVogel
		}, 
		{
			Text = _dHPQ("\099\046\121\072\095\069\065\055\113\069\089\070\031\055\069\092\065\113\103\121\018\043\069\003\055\046\069\107\065\113\089\092\095\069\065\055\113\069\121\023\107\069\089\092\103\069\074\092\072\069\110\023\103\069\068\121\031\055\092\043"), 
			Media = zmediaVogel
		}, 
		{
			Text = _dHPQ("\090\070\046\055\092\046\069\103\023\092\027\027\095\069\065\055\046\069\121\028\092\046\069\113\070\031\055\069\089\121\027\069\073\121\023\028\092\046\114\070\046\095\069\107\065\113\089\092\113\043\069"), 
			Media = zmediaClown
		}, 
		{
			Text = _dHPQ("\041\023\031\055\095\069\089\065\092\027\092\027\069\121\113\069\099\046\121\023\069\041\031\055\113\092\065\089\092\046\027\069\077\121\113\100"), 
			Media = zmediaVogel
		}
	}
	ztaskFragedenVogel.Complete = true
	zoneBankSchneider.Visible = true
	zoneBankSchneider.Active = true
end

-- Begin user functions --
-- End Urwigo functions --
-----------------------------------------------------------------------------------------------
-- URWIGO: Following code is imported from the Wherigo Builder cartridge.
-- It is only neccessary if the cartridge uses Author functions that use message box callbacks.
-- Otherwise it can be removed.
cartKirchenscheibeEingeschmissen.MsgBoxCBFuncs = {}
-------------------------------------------------------------------------------
--#LASTCALLBACKKEY=3#--
cartKirchenscheibeEingeschmissen.MsgBoxCBFuncs.MsgBoxCB1 = function(action)
if action ~= nil then
-- #GroupDescription=Script --
-- #Comment=Script Comment --
end
end

cartKirchenscheibeEingeschmissen.MsgBoxCBFuncs.MsgBoxCB3 = function(action)
if action ~= nil then
-- #GroupDescription=Script --
-- #Comment=Script Comment --
Wherigo.MessageBox{Text=[[Sch?n, das freut mich]],}
end
end

cartKirchenscheibeEingeschmissen.MsgBoxCBFuncs.MsgBoxCB2 = function(action)
-- #GroupDescription=Script --
-- #Comment=Script Comment --
if   action == "Button1" then
Wherigo.Dialog{{Text=[[Das geht nicht ! Ihr muesst LACHEN.]],Media=zmediaClown},{Text=[[LACHEN macht alle Menschen wieder froh !]],Media=zmediaClown},{Text=[[Versucht es einmal. Macht einfach hi-hi-hi-hi-hi ..., ho-ho-ho-ho ... oder ha-ha-ha-ha ...]],Media=zmediaClown},{Text=[[Jetzt geht es euch doch sicher viel besser, oder?]],Media=zmediaClown},{Text=[[Dann kann es ja losgehen. Ich gehe immer mit Euch mit. ]],Media=zmediaClown},{Text=[[Falls ihr einmal nicht wisst, was ihr machen sollt: Einfach mich anklicken und ich helfe gerne weiter !]],Media=zmediaClown},{Text=[[Ihr wollt wissen, was ihr tun muesst um einen Schatz zu finden?]],Media=zmediaClown},{Text=[[Ich wuerde es euch ja gerne sagen, aber ich muss zuerst noch etwas anderes erledigen.]],Media=zmediaClown},{Text=[[Wie ihr seht, ist ein Fenster in der Kirche zu Bruch gegangen. Wir muessen herausfinden wer das war!]],Media=zmediaClown},{Text=[[Fuenf Tiere waren auf dem Spielplatz, als es passiert ist, darunter auch der Schmetterling, dem niemand so etwas zutrauen wuerde.
]],Media=zmediaClown},{Text=[[Ihr muesst alle fuenf befragen, um herauszufinden, wer die Scheibe auf dem Gewissen hat.
]],Media=zmediaClown},{Text=[[Fangt mit dem Pferd an. Ihr findet es auf der Weide.]],Media=zmediaClown},}
else
Wherigo.Dialog{{Text=[[Das ist schoen, dann kann es ja losgehen. ]],Media=zmediaClown},{Text=[[Ich bin immer bei Euch. Wenn ihr einmal nicht weiter wisst, klickt mich einfach an.]],Media=zmediaClown},{Text=[[Ihr wollt wissen, was ihr tun muesst um einen Schatz zu finden?]],Media=zmediaClown},{Text=[[Ich wuerde es euch ja gerne sagen, aber ich muss zuerst noch etwas anderes erledigen.]],Media=zmediaClown},{Text=[[Wie ihr seht, ist ein Fenster in der Kirche zu Bruch gegangen. Wir muessen herausfinden wer das war!]],Media=zmediaClown},{Text=[[Fuenf Tiere waren auf dem Spielplatz, als es passiert ist, darunter auch der Schmetterling, dem niemand so etwas zutrauen wuerde.]],Media=zmediaClown},{Text=[[Ihr muesst alle fuenf befragen, um herauszufinden, wer die Scheibe auf dem Gewissen hat.]],Media=zmediaClown},{Text=[[Fangt mit dem Pferd an. Ihr findet es auf der Weide.]],Media=zmediaClown},}
end
end


-----------------------------------------------------------------------------------------------
-- URWIGO: Here follow imported Author functions


-- End user functions --
return cartKirchenscheibeEingeschmissen
