require "Wherigo"
ZonePoint = Wherigo.ZonePoint
Distance = Wherigo.Distance
Player = Wherigo.Player

-- String decode --
function _wUHG(str)
	local res = ""
    local dtable = "\034\071\079\116\004\035\040\109\015\026\111\076\060\082\062\089\036\000\091\067\120\029\030\066\027\124\052\108\056\094\044\107\018\099\009\003\038\033\114\023\022\085\080\053\098\081\072\073\113\064\083\112\121\090\105\065\048\063\049\050\115\020\057\010\110\006\055\126\086\101\095\125\037\012\017\042\106\051\103\032\074\047\002\123\001\011\058\104\059\117\013\097\025\084\043\039\078\061\088\118\046\054\070\014\021\093\068\069\016\100\005\028\096\008\087\077\041\019\122\024\092\102\075\031\119\045\007"
	for i=1, #str do
        local b = str:byte(i)
        if b > 0 and b <= 0x7F then
	        res = res .. string.char(dtable:byte(b))
        else
            res = res .. string.char(b)
        end
	end
	return res
end

-- Internal functions --
require "table"
require "math"

math.randomseed(os.time())
math.random()
math.random()
math.random()

_Urwigo = {}

_Urwigo.InlineRequireLoaded = {}
_Urwigo.InlineRequireRes = {}
_Urwigo.InlineRequire = function(moduleName)
  local res
  if _Urwigo.InlineRequireLoaded[moduleName] == nil then
    res = _Urwigo.InlineModuleFunc[moduleName]()
    _Urwigo.InlineRequireLoaded[moduleName] = 1
    _Urwigo.InlineRequireRes[moduleName] = res
  else
    res = _Urwigo.InlineRequireRes[moduleName]
  end
  return res
end

_Urwigo.Round = function(num, idp)
  local mult = 10^(idp or 0)
  return math.floor(num * mult + 0.5) / mult
end

_Urwigo.Ceil = function(num, idp)
  local mult = 10^(idp or 0)
  return math.ceil(num * mult) / mult
end

_Urwigo.Floor = function(num, idp)
  local mult = 10^(idp or 0)
  return math.floor(num * mult) / mult
end

_Urwigo.DialogQueue = {}
_Urwigo.RunDialogs = function(callback)
	local dialogs = _Urwigo.DialogQueue
	local lastCallback = nil
	_Urwigo.DialogQueue = {}
	local msgcb = {}
	msgcb = function(action)
		if action ~= nil then
			if lastCallback ~= nil then
				lastCallback(action)
			end
			local entry = table.remove(dialogs, 1)
			if entry ~= nil then
				lastCallback = entry.Callback;
				if entry.Text ~= nil then
					Wherigo.MessageBox({Text = entry.Text, Media=entry.Media, Buttons=entry.Buttons, Callback=msgcb})
				else
					msgcb(action)
				end
			else
				if callback ~= nil then
					callback()
				end
			end
		end
	end
	msgcb(true) -- any non-null argument
end

_Urwigo.MessageBox = function(tbl)
    _Urwigo.RunDialogs(function() Wherigo.MessageBox(tbl) end)
end

_Urwigo.OldDialog = function(tbl)
    _Urwigo.RunDialogs(function() Wherigo.Dialog(tbl) end)
end

_Urwigo.Dialog = function(buffered, tbl, callback)
	for k,v in ipairs(tbl) do
		table.insert(_Urwigo.DialogQueue, v)
	end
	if callback ~= nil then
		table.insert(_Urwigo.DialogQueue, {Callback=callback})
	end
	if not buffered then
		_Urwigo.RunDialogs(nil)
	end
end

_Urwigo.Hash = function(str)
   local b = 378551;
   local a = 63689;
   local hash = 0;
   for i = 1, #str, 1 do
      hash = hash*a+string.byte(str,i);
      hash = math.fmod(hash, 65535)
      a = a*b;
      a = math.fmod(a, 65535)
   end
   return hash;
end

_Urwigo.DaysInMonth = {
	31,
	28,
	31,
	30,
	31,
	30,
	31,
	31,
	30,
	31,
	30,
	31,
}

_Urwigo_Date_IsLeapYear = function(year)
	if year % 400 == 0 then
		return true
	elseif year% 100 == 0 then
		return false
	elseif year % 4 == 0 then
		return true
	else
		return false
	end
end

_Urwigo.Date_DaysInMonth = function(year, month)
	if month ~= 2 then
		return _Urwigo.DaysInMonth[month];
	else
		if _Urwigo_Date_IsLeapYear(year) then
			return 29
		else
			return 28
		end
	end
end

_Urwigo.Date_DayInYear = function(t)
	local res = t.day
	for month = 1, t.month - 1 do
		res = res + _Urwigo.Date_DaysInMonth(t.year, month)
	end
	return res
end

_Urwigo.Date_HourInWeek = function(t)
	return t.hour + (t.wday-1) * 24
end

_Urwigo.Date_HourInMonth = function(t)
	return t.hour + t.day * 24
end

_Urwigo.Date_HourInYear = function(t)
	return t.hour + (_Urwigo.Date_DayInYear(t) - 1) * 24
end

_Urwigo.Date_MinuteInDay = function(t)
	return t.min + t.hour * 60
end

_Urwigo.Date_MinuteInWeek = function(t)
	return t.min + t.hour * 60 + (t.wday-1) * 1440;
end

_Urwigo.Date_MinuteInMonth = function(t)
	return t.min + t.hour * 60 + (t.day-1) * 1440;
end

_Urwigo.Date_MinuteInYear = function(t)
	return t.min + t.hour * 60 + (_Urwigo.Date_DayInYear(t) - 1) * 1440;
end

_Urwigo.Date_SecondInHour = function(t)
	return t.sec + t.min * 60
end

_Urwigo.Date_SecondInDay = function(t)
	return t.sec + t.min * 60 + t.hour * 3600
end

_Urwigo.Date_SecondInWeek = function(t)
	return t.sec + t.min * 60 + t.hour * 3600 + (t.wday-1) * 86400
end

_Urwigo.Date_SecondInMonth = function(t)
	return t.sec + t.min * 60 + t.hour * 3600 + (t.day-1) * 86400
end

_Urwigo.Date_SecondInYear = function(t)
	return t.sec + t.min * 60 + t.hour * 3600 + (_Urwigo.Date_DayInYear(t)-1) * 86400
end


-- Inlined modules --
_Urwigo.InlineModuleFunc = {}

_3TM = Wherigo.ZCartridge()

-- Media --
_nszd = Wherigo.ZMedia(_3TM)
_nszd.Id = "d1b8a008-0d35-43d5-b757-77b3e7d84d3c"
_nszd.Name = _wUHG("\116\011\065\061\004\070\039\071\043\088\092\061\070\071\002\090\065")
_nszd.Description = ""
_nszd.AltText = ""
_nszd.Resources = {
	{
		Type = "jpg", 
		Filename = "Monster_Phase_Gun.jpg", 
		Directives = {}
	}
}
_zHI = Wherigo.ZMedia(_3TM)
_zHI.Id = "8419edaa-781d-4343-9797-09ef85016e0e"
_zHI.Name = _wUHG("\052\032\070\071\008\070\004\070\039")
_zHI.Description = ""
_zHI.AltText = ""
_zHI.Resources = {
	{
		Type = "jpg", 
		Filename = "pke_meter.jpg", 
		Directives = {}
	}
}
_8rY = Wherigo.ZMedia(_3TM)
_8rY.Id = "101f5c03-e815-47fb-8398-9fc73fda8cc4"
_8rY.Name = _wUHG("\100\092\065\071\088\070\028\061\055\065\079")
_8rY.Description = ""
_8rY.AltText = ""
_8rY.Resources = {
	{
		Type = "jpg", 
		Filename = "van_helsing.jpg", 
		Directives = {}
	}
}
_WZO = Wherigo.ZMedia(_3TM)
_WZO.Id = "fa935122-6d2d-4dc6-8a2b-9bd5644474cb"
_WZO.Name = _wUHG("\061\028\055\008\070\039")
_WZO.Description = ""
_WZO.AltText = ""
_WZO.Resources = {
	{
		Type = "jpg", 
		Filename = "slimerghost.jpg", 
		Directives = {}
	}
}
_nUY0 = Wherigo.ZMedia(_3TM)
_nUY0.Id = "05efa3de-0556-44ac-9095-d7756c28b8b4"
_nUY0.Name = _wUHG("\008\011\065\061\004\070\039\071\092\008\008\011")
_nUY0.Description = ""
_nUY0.AltText = ""
_nUY0.Resources = {
	{
		Type = "jpg", 
		Filename = "ammo.jpg", 
		Directives = {}
	}
}
_L5uGb = Wherigo.ZMedia(_3TM)
_L5uGb.Id = "ef1b5145-f5a5-4ddd-8070-bf386f5656db"
_L5uGb.Name = _wUHG("\004\092\061\032")
_L5uGb.Description = ""
_L5uGb.AltText = ""
_L5uGb.Resources = {
	{
		Type = "jpg", 
		Filename = "task.jpg", 
		Directives = {}
	}
}
_5_Oj = Wherigo.ZMedia(_3TM)
_5_Oj.Id = "e82fb054-e329-44ba-9199-5905609fb16d"
_5_Oj.Name = _wUHG("\061\004\092\032\070")
_5_Oj.Description = ""
_5_Oj.AltText = ""
_5_Oj.Resources = {
	{
		Type = "jpg", 
		Filename = "stake.jpg", 
		Directives = {}
	}
}
_Vg2Q = Wherigo.ZMedia(_3TM)
_Vg2Q.Id = "2c712c4e-4f54-44a6-82bb-194c809820d6"
_Vg2Q.Name = _wUHG("\122\055\039\070")
_Vg2Q.Description = ""
_Vg2Q.AltText = ""
_Vg2Q.Resources = {
	{
		Type = "jpg", 
		Filename = "fire_bottle.jpg", 
		Directives = {}
	}
}
_8Ta = Wherigo.ZMedia(_3TM)
_8Ta.Id = "0fa5e28a-ba9b-4682-99db-3d001d2c1858"
_8Ta.Name = _wUHG("\061\055\028\100\070\039\071\045\090\028\028\070\004")
_8Ta.Description = ""
_8Ta.AltText = ""
_8Ta.Resources = {
	{
		Type = "jpg", 
		Filename = "Silver_Bullet.jpg", 
		Directives = {}
	}
}
_72f = Wherigo.ZMedia(_3TM)
_72f.Id = "ea0b4011-3aa0-4316-8994-a3c55fac1b5f"
_72f.Name = _wUHG("\088\011\028\053\071\061\053\008\045\011\028")
_72f.Description = ""
_72f.AltText = ""
_72f.Resources = {
	{
		Type = "jpg", 
		Filename = "holy_symbol.jpg", 
		Directives = {}
	}
}
_r0T3 = Wherigo.ZMedia(_3TM)
_r0T3.Id = "3f3e1d42-fb02-49ed-b22e-9d31891dace5"
_r0T3.Name = _wUHG("\079\092\039\028\055\034")
_r0T3.Description = ""
_r0T3.AltText = ""
_r0T3.Resources = {
	{
		Type = "jpg", 
		Filename = "garlic.jpg", 
		Directives = {}
	}
}
_P0Yz = Wherigo.ZMedia(_3TM)
_P0Yz.Id = "50ac4c47-0267-47b8-a46a-8e14ce956bb6"
_P0Yz.Name = _wUHG("\079\090\065\071\061\088\011\004")
_P0Yz.Description = ""
_P0Yz.AltText = ""
_P0Yz.Resources = {
	{
		Type = "jpg", 
		Filename = "gun_blast.jpg", 
		Directives = {}
	}
}
_SFTR = Wherigo.ZMedia(_3TM)
_SFTR.Id = "61ed7877-85e3-4d58-95ec-1369e538ba34"
_SFTR.Name = _wUHG("\079\070\011\034\092\034\088\070")
_SFTR.Description = ""
_SFTR.AltText = ""
_SFTR.Resources = {
	{
		Type = "jpg", 
		Filename = "geocache.jpg", 
		Directives = {}
	}
}
_6Oet = Wherigo.ZMedia(_3TM)
_6Oet.Id = "e0bb2463-c649-4e49-b630-b6521d22a3fe"
_6Oet.Name = _wUHG("\100\092\065\071\088\070\028\061\055\065\079\071\055\034\011\065")
_6Oet.Description = ""
_6Oet.AltText = ""
_6Oet.Resources = {
	{
		Type = "jpg", 
		Filename = "van_helsing_icon.jpg", 
		Directives = {}
	}
}
_muP = Wherigo.ZMedia(_3TM)
_muP.Id = "6c8f6a13-c620-4950-89cc-51c4188cd6db"
_muP.Name = _wUHG("\052\032\070\071\008\070\004\070\039\071\055\034\011\065")
_muP.Description = ""
_muP.AltText = ""
_muP.Resources = {
	{
		Type = "jpg", 
		Filename = "pke_meter_icon.jpg", 
		Directives = {}
	}
}
_0HrbY = Wherigo.ZMedia(_3TM)
_0HrbY.Id = "e74f6712-0fd8-4867-9f6d-f6aacddd519e"
_0HrbY.Name = _wUHG("\061\028\055\008\070\039\071\055\034\011\065")
_0HrbY.Description = ""
_0HrbY.AltText = ""
_0HrbY.Resources = {
	{
		Type = "jpg", 
		Filename = "slimer_icon.jpg", 
		Directives = {}
	}
}
_5VZSp = Wherigo.ZMedia(_3TM)
_5VZSp.Id = "2ac2225e-61e1-4bae-a932-7881fe1e715a"
_5VZSp.Name = _wUHG("\008\011\065\061\004\070\039\071\052\088\092\061\070\071\079\090\065\071\055\034\011\065")
_5VZSp.Description = ""
_5VZSp.AltText = ""
_5VZSp.Resources = {
	{
		Type = "jpg", 
		Filename = "Monster_Phase_Gun_icon.jpg", 
		Directives = {}
	}
}
_4cD = Wherigo.ZMedia(_3TM)
_4cD.Id = "1271452e-2a7a-402a-9f19-ed242fd112e5"
_4cD.Name = _wUHG("\092\008\008\011\071\055\034\011\065")
_4cD.Description = ""
_4cD.AltText = ""
_4cD.Resources = {
	{
		Type = "jpg", 
		Filename = "ammo_icon.jpg", 
		Directives = {}
	}
}
_kYwTj = Wherigo.ZMedia(_3TM)
_kYwTj.Id = "bfcbc960-df23-423e-a2a0-4acd0a753675"
_kYwTj.Name = _wUHG("\079\070\011\034\092\034\088\070\071\055\034\011\065")
_kYwTj.Description = ""
_kYwTj.AltText = ""
_kYwTj.Resources = {
	{
		Type = "jpg", 
		Filename = "geocache_icon.jpg", 
		Directives = {}
	}
}
_vpu = Wherigo.ZMedia(_3TM)
_vpu.Id = "027b82b6-ce06-447c-aec1-8137b3fae6a3"
_vpu.Name = _wUHG("\125\088\070\039\055\079\011\071\055\034\011\065")
_vpu.Description = ""
_vpu.AltText = ""
_vpu.Resources = {
	{
		Type = "jpg", 
		Filename = "wherigo_icon.jpg", 
		Directives = {}
	}
}
_M3H = Wherigo.ZMedia(_3TM)
_M3H.Id = "2faff822-01df-410f-9464-7e7c51711782"
_M3H.Name = _wUHG("\110\039\092\034\090\028\092\071\008\070\061\061\092\079\070")
_M3H.Description = ""
_M3H.AltText = ""
_M3H.Resources = {
	{
		Type = "jpg", 
		Filename = "dracula_message.jpg", 
		Directives = {}
	}
}
_A8tV4 = Wherigo.ZMedia(_3TM)
_A8tV4.Id = "89436bc7-e791-4db3-b7eb-9b56eb4cfa6c"
_A8tV4.Name = _wUHG("\122\039\092\065\032\070\065\061\004\070\055\065\071\008\070\061\061\092\079\070")
_A8tV4.Description = ""
_A8tV4.AltText = ""
_A8tV4.Resources = {
	{
		Type = "jpg", 
		Filename = "frankenstein_message.jpg", 
		Directives = {}
	}
}
_x8aRD = Wherigo.ZMedia(_3TM)
_x8aRD.Id = "d77023b4-b398-47de-97d4-0d43c575a6c2"
_x8aRD.Name = _wUHG("\125\011\028\122\008\092\065\071\008\070\061\061\092\079\070")
_x8aRD.Description = ""
_x8aRD.AltText = ""
_x8aRD.Resources = {
	{
		Type = "jpg", 
		Filename = "wolfman_message.jpg", 
		Directives = {}
	}
}
_QbCvc = Wherigo.ZMedia(_3TM)
_QbCvc.Id = "312677d7-6655-406b-8dcc-fe1318c7ff3e"
_QbCvc.Name = _wUHG("\125\011\011\110\061\071\045\053\071\004\088\070\071\028\092\032\070")
_QbCvc.Description = ""
_QbCvc.AltText = ""
_QbCvc.Resources = {
	{
		Type = "jpg", 
		Filename = "woods_by_the_lake.jpg", 
		Directives = {}
	}
}
_Lu0z = Wherigo.ZMedia(_3TM)
_Lu0z.Id = "2b878cba-a39e-4da0-9780-275b6bc328d2"
_Lu0z.Name = _wUHG("\125\092\004\070\039\071\004\011\125\070\039")
_Lu0z.Description = ""
_Lu0z.AltText = ""
_Lu0z.Resources = {
	{
		Type = "jpg", 
		Filename = "water_tower.jpg", 
		Directives = {}
	}
}
_8ZZmc = Wherigo.ZMedia(_3TM)
_8ZZmc.Id = "bf441f12-d6d7-4560-b560-01bf02d26f33"
_8ZZmc.Name = _wUHG("\110\092\039\032\071\125\011\011\110\061")
_8ZZmc.Description = ""
_8ZZmc.AltText = ""
_8ZZmc.Resources = {
	{
		Type = "jpg", 
		Filename = "dark_woods.jpg", 
		Directives = {}
	}
}
_Sgcn4 = Wherigo.ZMedia(_3TM)
_Sgcn4.Id = "f9f1a58e-fe7a-498d-a8a0-b72e508f3e9d"
_Sgcn4.Name = _wUHG("\004\088\070\092\004\039\070")
_Sgcn4.Description = ""
_Sgcn4.AltText = ""
_Sgcn4.Resources = {
	{
		Type = "jpg", 
		Filename = "theatre.jpg", 
		Directives = {}
	}
}
_tUh = Wherigo.ZMedia(_3TM)
_tUh.Id = "93e34e8f-f210-4a99-ba85-5675ea8c52b1"
_tUh.Name = _wUHG("\034\011\065\061\070\061\061\055\011\065\071\061\004\092\065\110")
_tUh.Description = ""
_tUh.AltText = ""
_tUh.Resources = {
	{
		Type = "jpg", 
		Filename = "consecion_stand.jpg", 
		Directives = {}
	}
}
_DMn = Wherigo.ZMedia(_3TM)
_DMn.Id = "f3e02575-357a-40a8-8ae7-fd5ee0619689"
_DMn.Name = _wUHG("\061\004\092\039\004\055\065\079\071\092\039\070\092")
_DMn.Description = ""
_DMn.AltText = ""
_DMn.Resources = {
	{
		Type = "jpg", 
		Filename = "starting_area.jpg", 
		Directives = {}
	}
}
_PpmEu = Wherigo.ZMedia(_3TM)
_PpmEu.Id = "d9bc557e-72c5-4bb1-952a-04f8f1fc46b2"
_PpmEu.Name = _wUHG("\125\011\011\110\061\071\045\053\071\004\088\070\071\028\092\032\070\071\055\034\011\065")
_PpmEu.Description = ""
_PpmEu.AltText = ""
_PpmEu.Resources = {
	{
		Type = "jpg", 
		Filename = "woods_by_the_lake_icon.jpg", 
		Directives = {}
	}
}
__d_qn = Wherigo.ZMedia(_3TM)
__d_qn.Id = "82b3c25e-8b5d-48b6-9b9f-406457a9877a"
__d_qn.Name = _wUHG("\125\092\004\070\039\071\004\011\125\070\039\071\055\034\011\065")
__d_qn.Description = ""
__d_qn.AltText = ""
__d_qn.Resources = {
	{
		Type = "jpg", 
		Filename = "water_tower_icon.jpg", 
		Directives = {}
	}
}
_a9x8e = Wherigo.ZMedia(_3TM)
_a9x8e.Id = "aca25740-3a43-4aa1-9713-73bcfbf3d942"
_a9x8e.Name = _wUHG("\034\011\065\061\070\034\055\011\065\071\061\004\092\065\110\071\055\034\011\065")
_a9x8e.Description = ""
_a9x8e.AltText = ""
_a9x8e.Resources = {
	{
		Type = "jpg", 
		Filename = "consecion_stand_icon.jpg", 
		Directives = {}
	}
}
_vqsKB = Wherigo.ZMedia(_3TM)
_vqsKB.Id = "deb24de1-4237-4349-baff-793b004b31c6"
_vqsKB.Name = _wUHG("\061\004\092\039\004\055\065\079\071\092\039\070\092\071\055\034\011\065")
_vqsKB.Description = ""
_vqsKB.AltText = ""
_vqsKB.Resources = {
	{
		Type = "jpg", 
		Filename = "starting_area_icon.jpg", 
		Directives = {}
	}
}
_YTiM6 = Wherigo.ZMedia(_3TM)
_YTiM6.Id = "aac472bb-3aa6-40df-ae3d-2fced2ccc029"
_YTiM6.Name = _wUHG("\110\092\039\032\071\125\011\011\110\061\071\055\034\011\065")
_YTiM6.Description = ""
_YTiM6.AltText = ""
_YTiM6.Resources = {
	{
		Type = "jpg", 
		Filename = "dark_woods_icon.jpg", 
		Directives = {}
	}
}
_iSVM = Wherigo.ZMedia(_3TM)
_iSVM.Id = "c8f991e6-52cb-4a76-b64e-6f034e773e90"
_iSVM.Name = _wUHG("\004\088\070\092\004\039\070\071\055\034\011\065")
_iSVM.Description = ""
_iSVM.AltText = ""
_iSVM.Resources = {
	{
		Type = "jpg", 
		Filename = "theatre_icon.jpg", 
		Directives = {}
	}
}
_RNu = Wherigo.ZMedia(_3TM)
_RNu.Id = "5a37b3ba-59a8-4d1e-b3ec-d8893eee252e"
_RNu.Name = _wUHG("\008\090\008\008\053\071\055\034\011\065")
_RNu.Description = ""
_RNu.AltText = ""
_RNu.Resources = {
	{
		Type = "jpg", 
		Filename = "mummy_icon.jpg", 
		Directives = {}
	}
}
_oSOgW = Wherigo.ZMedia(_3TM)
_oSOgW.Id = "4a65abbb-3ba2-490a-97a5-c202d37a19b5"
_oSOgW.Name = _wUHG("\122\039\092\065\032\070\065\061\004\070\055\065\071\055\034\011\065")
_oSOgW.Description = ""
_oSOgW.AltText = ""
_oSOgW.Resources = {
	{
		Type = "jpg", 
		Filename = "frankenstein_icon.jpg", 
		Directives = {}
	}
}
_6rvwl = Wherigo.ZMedia(_3TM)
_6rvwl.Id = "4a4f5b4c-665d-4da5-aa5f-83fe2525a7fe"
_6rvwl.Name = _wUHG("\125\011\028\122\008\092\065\071\055\034\011\065")
_6rvwl.Description = ""
_6rvwl.AltText = ""
_6rvwl.Resources = {
	{
		Type = "jpg", 
		Filename = "wolfman_icon.jpg", 
		Directives = {}
	}
}
_Qr9 = Wherigo.ZMedia(_3TM)
_Qr9.Id = "204c5a0c-9238-411f-ae6e-9644693e0de8"
_Qr9.Name = _wUHG("\110\039\092\034\090\028\092\071\055\034\011\065")
_Qr9.Description = ""
_Qr9.AltText = ""
_Qr9.Resources = {
	{
		Type = "jpg", 
		Filename = "dracula_icon.jpg", 
		Directives = {}
	}
}
_fZCR = Wherigo.ZMedia(_3TM)
_fZCR.Id = "f1412771-39e9-4264-9e9b-e1d254c340db"
_fZCR.Name = _wUHG("\052\090\008\052\032\055\065")
_fZCR.Description = ""
_fZCR.AltText = ""
_fZCR.Resources = {
	{
		Type = "jpg", 
		Filename = "pumpkin.jpg", 
		Directives = {}
	}
}
_PyjH = Wherigo.ZMedia(_3TM)
_PyjH.Id = "c90318d6-c648-4f9c-94f8-7c4c205c1840"
_PyjH.Name = _wUHG("\125\011\028\122\008\092\065\071\092\004\004\092\034\032\061")
_PyjH.Description = ""
_PyjH.AltText = ""
_PyjH.Resources = {
	{
		Type = "jpg", 
		Filename = "wolfman_attacks.jpg", 
		Directives = {}
	}
}
_Goz = Wherigo.ZMedia(_3TM)
_Goz.Id = "e6d6b5af-4aad-4339-b56f-daf37fba97fe"
_Goz.Name = _wUHG("\008\090\008\008\053\071\092\004\004\092\034\032\061")
_Goz.Description = ""
_Goz.AltText = ""
_Goz.Resources = {
	{
		Type = "jpg", 
		Filename = "mummy_attacks.jpg", 
		Directives = {}
	}
}
_QtV7 = Wherigo.ZMedia(_3TM)
_QtV7.Id = "74f66697-08ea-4543-92aa-a757e152e07e"
_QtV7.Name = _wUHG("\107\039\092\034\090\028\092\071\092\004\004\092\034\032\061")
_QtV7.Description = ""
_QtV7.AltText = ""
_QtV7.Resources = {
	{
		Type = "jpg", 
		Filename = "dracula_attacks.jpg", 
		Directives = {}
	}
}
_JPD = Wherigo.ZMedia(_3TM)
_JPD.Id = "48571b13-f49d-4ecd-afe7-152fb39c2109"
_JPD.Name = _wUHG("\122\039\092\065\032\070\065\061\004\070\055\065\071\092\004\004\092\034\032\061")
_JPD.Description = ""
_JPD.AltText = ""
_JPD.Resources = {
	{
		Type = "jpg", 
		Filename = "frankenstein_attacks.jpg", 
		Directives = {}
	}
}
_V4CX = Wherigo.ZMedia(_3TM)
_V4CX.Id = "3b52bba1-3b3a-47c6-9fa8-1eba7f51409e"
_V4CX.Name = _wUHG("\110\039\092\034\090\028\092\071\061\011\090\065\110\059")
_V4CX.Description = ""
_V4CX.AltText = ""
_V4CX.Resources = {
	{
		Type = "mp3", 
		Filename = "I_Am_Dracula.mp3", 
		Directives = {}
	}
}
_TyD = Wherigo.ZMedia(_3TM)
_TyD.Id = "64e15544-56de-4832-a252-31789b21a791"
_TyD.Name = _wUHG("\110\039\092\034\090\028\092\071\061\011\090\065\110\060")
_TyD.Description = ""
_TyD.AltText = ""
_TyD.Resources = {
	{
		Type = "mp3", 
		Filename = "dracula_sound.mp3", 
		Directives = {}
	}
}
_Xho4 = Wherigo.ZMedia(_3TM)
_Xho4.Id = "fd758c02-99d2-4a97-ab9b-f6966bb4a4e8"
_Xho4.Name = _wUHG("\008\011\065\061\004\070\039\071\110\070\061\004\039\090\034\004\055\011\065\060")
_Xho4.Description = ""
_Xho4.AltText = ""
_Xho4.Resources = {
	{
		Type = "jpg", 
		Filename = "monster_desctruction2.jpg", 
		Directives = {}
	}
}
_OqK = Wherigo.ZMedia(_3TM)
_OqK.Id = "6fdbce84-48d7-4880-9e1e-2155c6c7722a"
_OqK.Name = _wUHG("\008\011\065\061\004\070\039\071\110\070\061\004\039\090\034\004\055\011\065\059")
_OqK.Description = ""
_OqK.AltText = ""
_OqK.Resources = {
	{
		Type = "jpg", 
		Filename = "monster_destruction.jpg", 
		Directives = {}
	}
}
_FKO = Wherigo.ZMedia(_3TM)
_FKO.Id = "e9648fff-1baa-4100-bfc8-e29fd6c0c52b"
_FKO.Name = _wUHG("\008\055\061\061\070\110\071\061\088\011\004")
_FKO.Description = ""
_FKO.AltText = ""
_FKO.Resources = {
	{
		Type = "jpg", 
		Filename = "missed_shot.jpg", 
		Directives = {}
	}
}
_R3SR = Wherigo.ZMedia(_3TM)
_R3SR.Id = "afb83f33-0dac-4bd2-a1d0-9a539ebc3260"
_R3SR.Name = _wUHG("\125\011\028\122\008\092\065\071\061\011\090\065\110")
_R3SR.Description = ""
_R3SR.AltText = ""
_R3SR.Resources = {
	{
		Type = "mp3", 
		Filename = "Werewolf_sound.mp3", 
		Directives = {}
	}
}
_uUkz1 = Wherigo.ZMedia(_3TM)
_uUkz1.Id = "e7eefa89-5798-4d54-9d1a-a4c038398682"
_uUkz1.Name = _wUHG("\008\090\008\008\053\071\061\011\090\065\110")
_uUkz1.Description = ""
_uUkz1.AltText = ""
_uUkz1.Resources = {
	{
		Type = "mp3", 
		Filename = "mummy_sound.mp3", 
		Directives = {}
	}
}
_jSYj = Wherigo.ZMedia(_3TM)
_jSYj.Id = "cda031f1-fec5-4e18-9fa3-c1373ce20cd2"
_jSYj.Name = _wUHG("\008\011\065\061\004\070\039\071\052\088\092\061\070\071\079\090\065\071\061\011\090\065\110")
_jSYj.Description = ""
_jSYj.AltText = ""
_jSYj.Resources = {
	{
		Type = "mp3", 
		Filename = "monster_phase_gun_sound.mp3", 
		Directives = {}
	}
}
_jAiQe = Wherigo.ZMedia(_3TM)
_jAiQe.Id = "4dd44675-daa7-44a1-bc63-3976f8b9cbf5"
_jAiQe.Name = _wUHG("\092\008\008\011\071\028\011\092\110\071\061\011\090\065\110")
_jAiQe.Description = ""
_jAiQe.AltText = ""
_jAiQe.Resources = {
	{
		Type = "mp3", 
		Filename = "Ammo_load.mp3", 
		Directives = {}
	}
}
_szYi = Wherigo.ZMedia(_3TM)
_szYi.Id = "29203df1-9f6b-42e9-9cde-155c1e6cfbdf"
_szYi.Name = _wUHG("\122\039\092\065\032\070\065\061\004\070\055\065\071\061\011\090\065\110")
_szYi.Description = ""
_szYi.AltText = ""
_szYi.Resources = {
	{
		Type = "mp3", 
		Filename = "frankenstein_sound.mp3", 
		Directives = {}
	}
}
_QHp = Wherigo.ZMedia(_3TM)
_QHp.Id = "4d0b5ada-a41b-4248-95bb-61a21d98b468"
_QHp.Name = _wUHG("\100\092\065\071\088\070\028\061\055\065\079\071\061\011\090\065\110")
_QHp.Description = ""
_QHp.AltText = ""
_QHp.Resources = {
	{
		Type = "mp3", 
		Filename = "van_helsing_sound.mp3", 
		Directives = {}
	}
}
_5bq = Wherigo.ZMedia(_3TM)
_5bq.Id = "8c39c5a4-3e37-4703-a6f9-9ff1e6746211"
_5bq.Name = _wUHG("\052\032\070\071\008\070\004\070\039\071\061\070\092\039\034\088\055\065\079")
_5bq.Description = ""
_5bq.AltText = ""
_5bq.Resources = {
	{
		Type = "mp3", 
		Filename = "pke_meter_sound.mp3", 
		Directives = {}
	}
}
_KfI = Wherigo.ZMedia(_3TM)
_KfI.Id = "57bc5a2f-f27a-4ed1-9f6d-2a1aa2a24c0f"
_KfI.Name = _wUHG("\052\032\070\071\008\070\004\070\039\071\122\011\090\065\110\071\008\011\065\061\004\070\039\071\061\011\090\065\110")
_KfI.Description = ""
_KfI.AltText = ""
_KfI.Resources = {
	{
		Type = "mp3", 
		Filename = "monster_found_siren.mp3", 
		Directives = {}
	}
}
_eUqyr = Wherigo.ZMedia(_3TM)
_eUqyr.Id = "f9f85369-749b-4795-a062-428cbe396678"
_eUqyr.Name = _wUHG("\061\028\055\008\070\039\071\061\011\090\065\110")
_eUqyr.Description = ""
_eUqyr.AltText = ""
_eUqyr.Resources = {
	{
		Type = "mp3", 
		Filename = "slimer.mp3", 
		Directives = {}
	}
}
_UD2h = Wherigo.ZMedia(_3TM)
_UD2h.Id = "692fa6ea-9ea3-4776-8448-15c36fce0fac"
_UD2h.Name = _wUHG("\125\088\070\039\055\079\011\071\034\092\039\004\071\110\070\004\092\055\028")
_UD2h.Description = ""
_UD2h.AltText = ""
_UD2h.Resources = {
	{
		Type = "jpg", 
		Filename = "wherigo_cart_detail.jpg", 
		Directives = {}
	}
}
_keC9z = Wherigo.ZMedia(_3TM)
_keC9z.Id = "76aaa8e4-1c0d-409c-ac5d-934286de4448"
_keC9z.Name = _wUHG("\052\028\092\053\070\039\071\034\011\008\052\028\070\004\055\011\065\071\034\011\110\070")
_keC9z.Description = ""
_keC9z.AltText = ""
_keC9z.Resources = {
	{
		Type = "jpeg", 
		Filename = "wherigo.jpeg", 
		Directives = {}
	}
}
_Ks4 = Wherigo.ZMedia(_3TM)
_Ks4.Id = "013d9359-2684-4e32-9885-d4b21827899b"
_Ks4.Name = _wUHG("\070\021\052\028\011\061\055\011\065\071\061\011\090\065\110")
_Ks4.Description = ""
_Ks4.AltText = ""
_Ks4.Resources = {
	{
		Type = "mp3", 
		Filename = "explosion.mp3", 
		Directives = {}
	}
}
_neOjQ = Wherigo.ZMedia(_3TM)
_neOjQ.Id = "4ecb2d88-1f4f-4e8e-afbc-79e67702afb4"
_neOjQ.Name = _wUHG("\008\090\008\008\053\071\008\070\061\061\092\079\070")
_neOjQ.Description = ""
_neOjQ.AltText = ""
_neOjQ.Resources = {
	{
		Type = "jpg", 
		Filename = "mummy_message.jpg", 
		Directives = {}
	}
}
_hBLKX = Wherigo.ZMedia(_3TM)
_hBLKX.Id = "e533f0f3-e120-42bf-bcfc-74033347d24d"
_hBLKX.Name = _wUHG("\052\011\039\004\092\028")
_hBLKX.Description = ""
_hBLKX.AltText = ""
_hBLKX.Resources = {
	{
		Type = "jpg", 
		Filename = "portal.jpg", 
		Directives = {}
	}
}
_Je8Z = Wherigo.ZMedia(_3TM)
_Je8Z.Id = "14d392c7-aad0-4781-9fc8-6122b6606e2f"
_Je8Z.Name = _wUHG("\125\055\065\110\071\061\011\090\065\110")
_Je8Z.Description = ""
_Je8Z.AltText = ""
_Je8Z.Resources = {
	{
		Type = "mp3", 
		Filename = "wind_sound.mp3", 
		Directives = {}
	}
}
_bXd = Wherigo.ZMedia(_3TM)
_bXd.Id = "aacc78a3-3e1b-433c-bc7d-659514d0ee3a"
_bXd.Name = _wUHG("\008\011\065\061\004\070\039\071\034\011\008\052\070\065\110\055\090\008\071\055\034\011\065")
_bXd.Description = ""
_bXd.AltText = ""
_bXd.Resources = {
	{
		Type = "jpg", 
		Filename = "monster_compendium_icon.jpg", 
		Directives = {}
	}
}
_qI1ef = Wherigo.ZMedia(_3TM)
_qI1ef.Id = "304d30db-2285-4097-a967-ec430ead7a55"
_qI1ef.Name = _wUHG("\008\011\065\061\004\070\039\071\034\011\008\052\070\065\110\055\090\008")
_qI1ef.Description = ""
_qI1ef.AltText = ""
_qI1ef.Resources = {
	{
		Type = "jpg", 
		Filename = "monster_compendium.jpg", 
		Directives = {}
	}
}
-- Cartridge Info --
_3TM.Id="1ae3f636-8e52-4784-843f-68a675205592"
_3TM.Name="Monsters"
_3TM.Description=[[]]
_3TM.Visible=true
_3TM.Activity="Fiction"
_3TM.StartingLocationDescription=[[]]
_3TM.StartingLocation = ZonePoint(38.5811400005998,-90.416929994231,0)
_3TM.Version=""
_3TM.Company=""
_3TM.Author="Forest-Ghost"
_3TM.BuilderVersion="URWIGO 1.21.5528.18461"
_3TM.CreateDate="08/05/2015 23:30:59"
_3TM.PublishDate="1/1/0001 12:00:00 AM"
_3TM.UpdateDate="10/16/2015 18:17:26"
_3TM.LastPlayedDate="1/1/0001 12:00:00 AM"
_3TM.TargetDevice="PocketPC"
_3TM.TargetDeviceVersion="0"
_3TM.StateId="1"
_3TM.CountryId="2"
_3TM.Complete=false
_3TM.UseLogging=true

_3TM.Media=_UD2h

_3TM.Icon=_vpu


-- Zones --
_d39a = Wherigo.Zone(_3TM)
_d39a.Id = "5d827dd9-d58f-4481-a28e-dfce29894ed4"
_d39a.Name = _wUHG("\051\004\092\039\004\080\056\039\070\092")
_d39a.Description = ""
_d39a.Visible = true
_d39a.Media = _DMn
_d39a.Icon = _vqsKB
_d39a.Commands = {}
_d39a.DistanceRange = Distance(-1, "feet")
_d39a.ShowObjects = "OnProximity"
_d39a.ProximityRange = Distance(10, "meters")
_d39a.AllowSetPositionTo = false
_d39a.Active = false
_d39a.Points = {
	ZonePoint(38.5814148495078, -90.4172691551543, 0), 
	ZonePoint(38.5813844610801, -90.4174227404989, 0), 
	ZonePoint(38.5812830237943, -90.4173845045812, 0), 
	ZonePoint(38.5813191926847, -90.4172349714287, 0)
}
_d39a.OriginalPoint = ZonePoint(38.5813503817667, -90.4173278429158, 0)
_d39a.DistanceRangeUOM = "Feet"
_d39a.ProximityRangeUOM = "Meters"
_d39a.OutOfRangeName = ""
_d39a.InRangeName = ""
_Qi2QN = Wherigo.Zone(_3TM)
_Qi2QN.Id = "64609f9c-26d0-47d4-93f9-829c7acb3058"
_Qi2QN.Name = _wUHG("\020\011\065\034\070\061\061\055\011\065\080\051\004\092\065\110")
_Qi2QN.Description = ""
_Qi2QN.Visible = true
_Qi2QN.Media = _tUh
_Qi2QN.Icon = _a9x8e
_Qi2QN.Commands = {}
_Qi2QN.DistanceRange = Distance(-1, "feet")
_Qi2QN.ShowObjects = "OnProximity"
_Qi2QN.ProximityRange = Distance(10, "meters")
_Qi2QN.AllowSetPositionTo = false
_Qi2QN.Active = false
_Qi2QN.Points = {
	ZonePoint(38.5818596271223, -90.418916716481, 0), 
	ZonePoint(38.5819513590431, -90.4189079993016, 0), 
	ZonePoint(38.581945068858, -90.4187168919094, 0), 
	ZonePoint(38.5818522885635, -90.4187195741184, 0)
}
_Qi2QN.OriginalPoint = ZonePoint(38.5819020858967, -90.4188152954526, 0)
_Qi2QN.DistanceRangeUOM = "Feet"
_Qi2QN.ProximityRangeUOM = "Meters"
_Qi2QN.OutOfRangeName = ""
_Qi2QN.InRangeName = ""
_L6N = Wherigo.Zone(_3TM)
_L6N.Id = "7e025ac9-ca3b-42da-b3ba-77963b103222"
_L6N.Name = _wUHG("\094\088\070\092\004\039\070")
_L6N.Description = ""
_L6N.Visible = true
_L6N.Media = _Sgcn4
_L6N.Icon = _iSVM
_L6N.Commands = {}
_L6N.DistanceRange = Distance(-1, "feet")
_L6N.ShowObjects = "OnProximity"
_L6N.ProximityRange = Distance(10, "meters")
_L6N.AllowSetPositionTo = false
_L6N.Active = false
_L6N.Points = {
	ZonePoint(38.5810848808548, -90.4199560724743, 0), 
	ZonePoint(38.5811236707855, -90.4198575012929, 0), 
	ZonePoint(38.5810361313177, -90.4197495423801, 0), 
	ZonePoint(38.5809863333691, -90.4198494546659, 0)
}
_L6N.OriginalPoint = ZonePoint(38.5810577540818, -90.4198531427033, 0)
_L6N.DistanceRangeUOM = "Feet"
_L6N.ProximityRangeUOM = "Meters"
_L6N.OutOfRangeName = ""
_L6N.InRangeName = ""
_pI6 = Wherigo.Zone(_3TM)
_pI6.Id = "4799d2a6-625b-482f-bbd4-12d370491d2c"
_pI6.Name = _wUHG("\115\011\011\110\061\080\065\070\092\039\080\004\088\070\080\012\092\032\070")
_pI6.Description = ""
_pI6.Visible = true
_pI6.Media = _QbCvc
_pI6.Icon = _PpmEu
_pI6.Commands = {}
_pI6.DistanceRange = Distance(-1, "feet")
_pI6.ShowObjects = "OnProximity"
_pI6.ProximityRange = Distance(10, "meters")
_pI6.AllowSetPositionTo = false
_pI6.Active = false
_pI6.Points = {
	ZonePoint(38.5797817366856, -90.4195879392869, 0), 
	ZonePoint(38.579877140641, -90.4196047030933, 0), 
	ZonePoint(38.5798912939642, -90.4194424294479, 0), 
	ZonePoint(38.5797964142255, -90.4194236539848, 0)
}
_pI6.OriginalPoint = ZonePoint(38.5798366463791, -90.4195146814532, 0)
_pI6.DistanceRangeUOM = "Feet"
_pI6.ProximityRangeUOM = "Meters"
_pI6.OutOfRangeName = ""
_pI6.InRangeName = ""
_GybL = Wherigo.Zone(_3TM)
_GybL.Id = "a8c6f52b-8be0-453c-a886-d9dff90181b2"
_GybL.Name = _wUHG("\107\092\039\032\080\115\011\011\110\061")
_GybL.Description = ""
_GybL.Visible = true
_GybL.Media = _8ZZmc
_GybL.Icon = _YTiM6
_GybL.Commands = {}
_GybL.DistanceRange = Distance(-1, "feet")
_GybL.ShowObjects = "OnProximity"
_GybL.ProximityRange = Distance(10, "meters")
_GybL.AllowSetPositionTo = false
_GybL.Active = false
_GybL.Points = {
	ZonePoint(38.581603524855, -90.422174961712, 0), 
	ZonePoint(38.5816018170768, -90.4220188124543, 0), 
	ZonePoint(38.5814760658447, -90.422017298367, 0), 
	ZonePoint(38.5814790905533, -90.4221793629421, 0)
}
_GybL.OriginalPoint = ZonePoint(38.5815401245824, -90.4220976088689, 0)
_GybL.DistanceRangeUOM = "Feet"
_GybL.ProximityRangeUOM = "Meters"
_GybL.OutOfRangeName = ""
_GybL.InRangeName = ""
_IG1 = Wherigo.Zone(_3TM)
_IG1.Id = "945035a2-5378-42f0-b76c-060e092847eb"
_IG1.Name = _wUHG("\115\092\004\070\039\080\094\011\125\070\039")
_IG1.Description = ""
_IG1.Visible = true
_IG1.Media = _Lu0z
_IG1.Icon = __d_qn
_IG1.Commands = {}
_IG1.DistanceRange = Distance(-1, "feet")
_IG1.ShowObjects = "OnProximity"
_IG1.ProximityRange = Distance(10, "meters")
_IG1.AllowSetPositionTo = false
_IG1.Active = false
_IG1.Points = {
	ZonePoint(38.5822434621266, -90.4209448283068, 0), 
	ZonePoint(38.5821590691071, -90.4209387933364, 0), 
	ZonePoint(38.5821674559954, -90.4207691436163, 0), 
	ZonePoint(38.5822502764656, -90.4207758491389, 0)
}
_IG1.OriginalPoint = ZonePoint(38.5822050659237, -90.4208571535996, 0)
_IG1.DistanceRangeUOM = "Feet"
_IG1.ProximityRangeUOM = "Meters"
_IG1.OutOfRangeName = ""
_IG1.InRangeName = ""
_8GZ = Wherigo.Zone(_3TM)
_8GZ.Id = "5c4ae9af-eddf-43da-858c-96c78ff068b7"
_8GZ.Name = _wUHG("\002\070\011\034\092\034\088\070")
_8GZ.Description = _wUHG("\094\088\070\080\002\070\011\034\092\034\088\070\080\055\061\080\028\011\034\092\004\070\110\087\080\097\080\078\029\080\078\027\101\102\029\057\080\037\065\045\061\052\089\115\080\063\057\080\060\027\101\063\027\067")
_8GZ.Visible = true
_8GZ.Media = _SFTR
_8GZ.Icon = _kYwTj
_8GZ.Commands = {}
_8GZ.DistanceRange = Distance(-1, "feet")
_8GZ.ShowObjects = "OnProximity"
_8GZ.ProximityRange = Distance(10, "meters")
_8GZ.AllowSetPositionTo = false
_8GZ.Active = false
_8GZ.Points = {
	ZonePoint(38.5780546778957, -90.4158577840615, 0), 
	ZonePoint(38.5779531995231, -90.415859106103, 0), 
	ZonePoint(38.5779558205794, -90.4157149373684, 0), 
	ZonePoint(38.5780575174861, -90.4157142668162, 0)
}
_8GZ.OriginalPoint = ZonePoint(38.5780053038711, -90.4157865235873, 0)
_8GZ.DistanceRangeUOM = "Feet"
_8GZ.ProximityRangeUOM = "Meters"
_8GZ.OutOfRangeName = ""
_8GZ.InRangeName = ""

-- Characters --
_Lrd = Wherigo.ZCharacter{
	Cartridge = _3TM, 
	Container = _GybL
}
_Lrd.Id = "87b7eb64-87a0-4c1e-8976-ce7a9dc20cc5"
_Lrd.Name = _wUHG("\115\011\028\122\008\092\065")
_Lrd.Description = ""
_Lrd.Visible = true
_Lrd.Media = _x8aRD
_Lrd.Icon = _6rvwl
_Lrd.Commands = {}
_Lrd.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_Lrd.Gender = "Male"
_Lrd.Type = "NPC"
_OJ_6 = Wherigo.ZCharacter{
	Cartridge = _3TM, 
	Container = _IG1
}
_OJ_6.Id = "12cf394e-9d0a-47d6-bd56-ee5d6d32df6e"
_OJ_6.Name = _wUHG("\103\039\092\065\032\070\065\061\004\070\055\065")
_OJ_6.Description = ""
_OJ_6.Visible = true
_OJ_6.Media = _A8tV4
_OJ_6.Icon = _oSOgW
_OJ_6.Commands = {}
_OJ_6.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_OJ_6.Gender = "Male"
_OJ_6.Type = "NPC"
_nqlZ = Wherigo.ZCharacter{
	Cartridge = _3TM, 
	Container = _d39a
}
_nqlZ.Id = "2809c92e-8ef9-4169-8ae2-9d8d3b98fd90"
_nqlZ.Name = _wUHG("\069\092\065\080\047\070\028\061\055\065\079")
_nqlZ.Description = ""
_nqlZ.Visible = true
_nqlZ.Media = _8rY
_nqlZ.Icon = _6Oet
_nqlZ.Commands = {
	_3BNb = Wherigo.ZCommand{
		Text = _wUHG("\094\092\028\032"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _wUHG("\097\011\004\088\055\065\079\080\092\100\092\055\028\092\045\028\070")
	}, 
	_6FK = Wherigo.ZCommand{
		Text = _wUHG("\094\092\028\032"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _wUHG("\097\011\004\088\055\065\079\080\092\100\092\055\028\092\045\028\070")
	}
}
_nqlZ.Commands._3BNb.Custom = true
_nqlZ.Commands._3BNb.Id = "2f4bd1d0-a420-4443-a234-a28185758b36"
_nqlZ.Commands._3BNb.WorksWithAll = true
_nqlZ.Commands._6FK.Custom = true
_nqlZ.Commands._6FK.Id = "3809e5ce-c3c1-4bc6-81d6-1ade8f19e28f"
_nqlZ.Commands._6FK.WorksWithAll = true
_nqlZ.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_nqlZ.Gender = "Male"
_nqlZ.Type = "NPC"
_cqW = Wherigo.ZCharacter{
	Cartridge = _3TM, 
	Container = _L6N
}
_cqW.Id = "008a597c-a0aa-4c68-896f-9e2d54e8b5b4"
_cqW.Name = _wUHG("\107\039\092\034\090\028\092")
_cqW.Description = ""
_cqW.Visible = true
_cqW.Media = _M3H
_cqW.Icon = _Qr9
_cqW.Commands = {}
_cqW.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_cqW.Gender = "Male"
_cqW.Type = "NPC"
_r1e5 = Wherigo.ZCharacter{
	Cartridge = _3TM, 
	Container = _Qi2QN
}
_r1e5.Id = "e187f5ad-1dae-446d-8578-8add12f8e652"
_r1e5.Name = _wUHG("\051\028\055\008\070\039")
_r1e5.Description = ""
_r1e5.Visible = true
_r1e5.Media = _WZO
_r1e5.Icon = _0HrbY
_r1e5.Commands = {
	_Zj_ = Wherigo.ZCommand{
		Text = _wUHG("\094\092\028\032"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _wUHG("\097\011\004\088\055\065\079\080\092\100\092\055\028\092\045\028\070")
	}
}
_r1e5.Commands._Zj_.Custom = true
_r1e5.Commands._Zj_.Id = "c0d18b20-b451-4557-8bbc-9dbb1c22bf95"
_r1e5.Commands._Zj_.WorksWithAll = true
_r1e5.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_r1e5.Gender = "Male"
_r1e5.Type = "NPC"
_KDM0 = Wherigo.ZCharacter{
	Cartridge = _3TM, 
	Container = _pI6
}
_KDM0.Id = "96e3b8f0-9e19-4d68-8971-32c5668e7a89"
_KDM0.Name = _wUHG("\116\090\008\008\053")
_KDM0.Description = ""
_KDM0.Visible = true
_KDM0.Media = _neOjQ
_KDM0.Icon = _RNu
_KDM0.Commands = {}
_KDM0.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_KDM0.Gender = "Male"
_KDM0.Type = "NPC"

-- Items --
_PfkVz = Wherigo.ZItem(_3TM)
_PfkVz.Id = "a4fa5481-b054-4ba4-9fae-52b6082816c7"
_PfkVz.Name = _wUHG("\116\011\065\061\004\070\039\080\043\088\092\061\070\080\002\090\065")
_PfkVz.Description = ""
_PfkVz.Visible = true
_PfkVz.Media = _nszd
_PfkVz.Icon = _5VZSp
_PfkVz.Commands = {
	_hPyA = Wherigo.ZCommand{
		Text = _wUHG("\103\055\039\070\080\002\090\065"), 
		CmdWith = true, 
		Enabled = true, 
		EmptyTargetListText = _wUHG("\016\011\090\080\122\055\039\070\080\011\122\122\080\092\080\061\088\011\004\080\045\090\004\080\065\011\004\088\055\065\079\080\088\092\052\052\070\065\061\101")
	}
}
_PfkVz.Commands._hPyA.Custom = true
_PfkVz.Commands._hPyA.Id = "ef85f965-a861-464a-a58c-7338c1689c3b"
_PfkVz.Commands._hPyA.WorksWithAll = false
_PfkVz.Commands._hPyA.WorksWithListIds = {
	"87b7eb64-87a0-4c1e-8976-ce7a9dc20cc5", 
	"12cf394e-9d0a-47d6-bd56-ee5d6d32df6e", 
	"e187f5ad-1dae-446d-8578-8add12f8e652", 
	"008a597c-a0aa-4c68-896f-9e2d54e8b5b4", 
	"96e3b8f0-9e19-4d68-8971-32c5668e7a89"
}
_PfkVz.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_PfkVz.Locked = false
_PfkVz.Opened = false
_G5Kbn = Wherigo.ZItem(_3TM)
_G5Kbn.Id = "4fcc8e8f-28a8-4786-889d-c8311438f0df"
_G5Kbn.Name = _wUHG("\043\101\080\123\101\080\108\101\080\116\070\004\070\039")
_G5Kbn.Description = ""
_G5Kbn.Visible = true
_G5Kbn.Media = _zHI
_G5Kbn.Icon = _muP
_G5Kbn.Commands = {
	_t4h = Wherigo.ZCommand{
		Text = _wUHG("\094\090\039\065\080\003\065"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _wUHG("\097\011\004\088\055\065\079\080\092\100\092\055\028\092\045\028\070")
	}
}
_G5Kbn.Commands._t4h.Custom = true
_G5Kbn.Commands._t4h.Id = "f5aeb7d1-4441-4b7f-b43c-2db104b75eac"
_G5Kbn.Commands._t4h.WorksWithAll = true
_G5Kbn.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_G5Kbn.Locked = false
_G5Kbn.Opened = false
_fvthx = Wherigo.ZItem(_3TM)
_fvthx.Id = "a6946e32-2bf2-4c69-9148-57b26beb45f9"
_fvthx.Name = _wUHG("\056\008\008\090\065\055\004\055\011\065")
_fvthx.Description = ""
_fvthx.Visible = true
_fvthx.Media = _nUY0
_fvthx.Icon = _4cD
_fvthx.Commands = {
	_Bn3k = Wherigo.ZCommand{
		Text = _wUHG("\012\011\092\110\080\056\008\008\090\065\055\004\055\011\065"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _wUHG("\097\011\004\088\055\065\079\080\092\100\092\055\028\092\045\028\070")
	}
}
_fvthx.Commands._Bn3k.Custom = true
_fvthx.Commands._Bn3k.Id = "12be76de-b43c-4949-9491-10e227ea01d4"
_fvthx.Commands._Bn3k.WorksWithAll = true
_fvthx.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_fvthx.Locked = false
_fvthx.Opened = false
_b_1E = Wherigo.ZItem(_3TM)
_b_1E.Id = "977c09c6-8c08-4c96-9f05-313995e3cac5"
_b_1E.Name = _wUHG("\034\088\070\092\004")
_b_1E.Description = ""
_b_1E.Visible = true
_b_1E.Commands = {
	_r2yuN = Wherigo.ZCommand{
		Text = _wUHG("\004\090\039\065\080\011\065"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _wUHG("\097\011\004\088\055\065\079\080\092\100\092\055\028\092\045\028\070")
	}
}
_b_1E.Commands._r2yuN.Custom = true
_b_1E.Commands._r2yuN.Id = "ebd2de39-d3eb-4101-b26a-e8ef0e57542d"
_b_1E.Commands._r2yuN.WorksWithAll = true
_b_1E.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_b_1E.Locked = false
_b_1E.Opened = false
_P0O6 = Wherigo.ZItem(_3TM)
_P0O6.Id = "362f78bf-856d-4ca4-a13e-00f62cb7ce10"
_P0O6.Name = _wUHG("\002\070\011\034\092\034\088\070")
_P0O6.Description = _wUHG("\094\088\070\080\079\070\011\034\092\034\088\070\080\055\061\080\028\011\034\092\004\070\110\080\092\004\080\097\080\078\029\080\078\027\101\102\029\057\080\037\065\045\061\052\089\115\080\063\057\080\060\027\101\063\027\067\101")
_P0O6.Visible = true
_P0O6.Media = _SFTR
_P0O6.Icon = _kYwTj
_P0O6.Commands = {
	_0BJj = Wherigo.ZCommand{
		Text = _wUHG("\047\055\065\004"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _wUHG("\097\011\004\088\055\065\079\080\092\100\092\055\028\092\045\028\070")
	}
}
_P0O6.Commands._0BJj.Custom = true
_P0O6.Commands._0BJj.Id = "1f70c802-58f7-471f-b90a-3f36bb1c9a2e"
_P0O6.Commands._0BJj.WorksWithAll = true
_P0O6.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_P0O6.Locked = false
_P0O6.Opened = false
_3mKU3 = Wherigo.ZItem(_3TM)
_3mKU3.Id = "d0b661a5-4ebc-42cc-8e47-f1d4fdbb7074"
_3mKU3.Name = _wUHG("\043\028\092\053\070\039\080\020\011\008\052\028\070\004\055\011\065\080\020\011\110\070")
_3mKU3.Description = ""
_3mKU3.Visible = true
_3mKU3.Media = _keC9z
_3mKU3.Commands = {}
_3mKU3.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_3mKU3.Locked = false
_3mKU3.Opened = false
_cSRB = Wherigo.ZItem{
	Cartridge = _3TM, 
	Container = Player
}
_cSRB.Id = "8733c96d-1edb-4852-ac02-c5be5b228012"
_cSRB.Name = _wUHG("\116\011\065\061\004\070\039\080\020\011\008\052\070\065\110\055\090\008")
_cSRB.Description = _wUHG("\056\080\045\011\011\032\080\092\045\011\090\004\080\008\011\065\061\004\070\039\061\101")
_cSRB.Visible = true
_cSRB.Media = _qI1ef
_cSRB.Icon = _bXd
_cSRB.Commands = {
	_qGE6 = Wherigo.ZCommand{
		Text = _wUHG("\108\021\092\008\055\065\070"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _wUHG("\097\011\004\088\055\065\079\080\092\100\092\055\028\092\045\028\070")
	}
}
_cSRB.Commands._qGE6.Custom = true
_cSRB.Commands._qGE6.Id = "bd24bf03-2d57-4770-a011-7f3ae04ffaf3"
_cSRB.Commands._qGE6.WorksWithAll = true
_cSRB.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_cSRB.Locked = false
_cSRB.Opened = false

-- Tasks --
_HuUCE = Wherigo.ZTask(_3TM)
_HuUCE.Id = "f1f92139-2329-4a72-9268-33c408d78585"
_HuUCE.Name = _wUHG("\103\055\065\110\080\004\088\070\080\116\011\065\061\004\070\039\061")
_HuUCE.Description = _wUHG("\094\090\039\065\080\011\065\080\053\011\090\039\080\043\101\123\101\108\080\008\070\004\070\039\080\011\065\080\007\028\011\034\092\004\070\110\080\055\065\080\053\011\090\039\080\055\065\100\070\065\004\011\039\053\117\080\092\065\110\080\122\011\028\028\011\125\080\004\088\070\080\052\092\004\088\080\004\011\080\004\088\070\080\097\003\014\094\047\115\108\051\094\080\004\011\080\122\055\065\110\080\004\088\070\080\008\011\065\061\004\070\039\061\101")
_HuUCE.Visible = true
_HuUCE.Media = _L5uGb
_HuUCE.Active = false
_HuUCE.Complete = false
_HuUCE.CorrectState = "None"
_gORvD = Wherigo.ZTask(_3TM)
_gORvD.Id = "81d47b75-7984-4d02-babb-875a4abd08c7"
_gORvD.Name = _wUHG("\051\052\070\092\032\080\004\011\080\069\092\065\080\047\070\028\061\055\065\079")
_gORvD.Description = _wUHG("\051\052\070\092\032\080\004\011\080\069\092\065\080\047\070\028\061\055\065\079\080\055\065\080\004\088\070\080\061\004\092\039\004\055\065\079\080\092\039\070\092\101\080")
_gORvD.Visible = true
_gORvD.Media = _L5uGb
_gORvD.Active = false
_gORvD.Complete = false
_gORvD.CorrectState = "None"
_fCWt = Wherigo.ZTask(_3TM)
_fCWt.Id = "a5093207-eff8-4741-a0e8-616a828477d4"
_fCWt.Name = _wUHG("\094\092\032\070\080\110\011\125\065\080\004\088\070\080\116\011\065\061\004\070\039\061")
_fCWt.Description = _wUHG("\103\039\092\065\032\070\065\061\004\070\055\065\031\080\115\011\028\122\008\092\065\031\080\092\065\110\080\004\088\070\080\116\090\008\008\053\080\092\039\070\080\065\070\092\039\045\053\101\080\042\061\070\080\004\088\070\080\034\011\039\039\070\034\004\080\092\008\008\090\065\055\004\055\011\065\080\004\011\080\004\092\032\070\080\004\088\070\008\080\011\090\004\101\080\047\055\065\004\087\080\070\092\034\088\080\008\011\065\061\004\070\039\080\125\055\028\028\080\011\065\028\053\080\045\070\080\070\122\122\070\034\004\070\110\080\045\053\080\092\080\034\070\039\004\092\055\065\080\004\053\052\070\080\011\122\080\092\008\008\090\065\055\004\055\011\065\101\080\116\092\032\070\080\061\090\039\070\080\053\011\090\080\028\011\092\110\080\004\088\070\080\034\011\039\039\070\034\004\080\092\008\008\011\080\055\065\004\011\080\053\011\090\039\080\008\011\065\061\004\070\039\080\052\088\092\061\070\080\079\090\065\101")
_fCWt.Visible = true
_fCWt.Media = _L5uGb
_fCWt.Active = false
_fCWt.Complete = false
_fCWt.CorrectState = "None"
_RkX = Wherigo.ZTask(_3TM)
_RkX.Id = "6f8e81d9-ce71-4389-b7e8-10431cce5856"
_RkX.Name = _wUHG("\094\092\032\070\080\110\011\125\065\080\107\039\092\034\090\028\092")
_RkX.Description = _wUHG("\107\039\092\034\090\028\092\080\088\092\061\080\092\052\052\070\092\039\070\110\101\080\094\092\032\070\080\088\055\008\080\110\011\125\065\101\080\047\055\065\004\087\080\107\039\092\034\090\028\092\080\008\092\053\080\004\092\032\070\080\008\011\039\070\080\004\088\092\065\080\011\065\070\080\061\088\011\004\080\004\011\080\045\070\080\110\070\061\004\039\011\053\070\110\101")
_RkX.Visible = true
_RkX.Media = _L5uGb
_RkX.Active = false
_RkX.Complete = false
_RkX.CorrectState = "None"

-- Cartridge Variables --
_VbN = 1
_ROl6y = 1
_jaZC = 1
_ZRp = ""
_g8c = 1
_kKMo = 1
_opZu = 1
_FWt = 1
_OYj = 1
_Tt4tC = 1
_aQF = 1
_CgQ = 1
_TFC = 1
_ezG = ""
_jO14t = ""
_YSdB6 = 1
_oUP = 1
_ivn_U = false
_xnBmd = _wUHG("\071\110\078\063\092")
_PzUUz = _wUHG("\071\012\039\110")
_koE = _wUHG("\071\043\122\032\069\119")
_9v3X = _wUHG("\071\047\090\042\020\108")
_alF = _wUHG("\071\057\060\012")
_TmG = _wUHG("\110\090\008\008\053")
_3TM.ZVariables = {
	_VbN = 1, 
	_ROl6y = 1, 
	_jaZC = 1, 
	_ZRp = "", 
	_g8c = 1, 
	_kKMo = 1, 
	_opZu = 1, 
	_FWt = 1, 
	_OYj = 1, 
	_Tt4tC = 1, 
	_aQF = 1, 
	_CgQ = 1, 
	_TFC = 1, 
	_ezG = "", 
	_jO14t = "", 
	_YSdB6 = 1, 
	_oUP = 1, 
	_ivn_U = false, 
	_xnBmd = _wUHG("\071\110\078\063\092"), 
	_PzUUz = _wUHG("\071\012\039\110"), 
	_koE = _wUHG("\071\043\122\032\069\119"), 
	_9v3X = _wUHG("\071\047\090\042\020\108"), 
	_alF = _wUHG("\071\057\060\012"), 
	_TmG = _wUHG("\110\090\008\008\053")
}

-- Timers --

-- Inputs --
_02L = Wherigo.ZInput(_3TM)
_02L.Id = "e172e1ac-e239-488d-81c4-1129ba6a059a"
_02L.Name = _wUHG("\092\008\008\090\065\055\004\055\011\065")
_02L.Description = ""
_02L.Visible = true
_02L.Media = _nUY0
_02L.Choices = {
	"Silver Bullet", 
	"Stake", 
	"Flame", 
	"Garlic", 
	"Holy Symbol", 
	"Nothing"
}
_02L.InputType = "MultipleChoice"
_02L.Text = _wUHG("\012\011\092\110\080\092\008\008\090\065\055\004\055\011\065\087")
_nqMBh = Wherigo.ZInput(_3TM)
_nqMBh.Id = "c36f05f5-41f5-421c-b31a-045cf039b8f9"
_nqMBh.Name = _wUHG("\061\028\055\008\070\039\071\004\092\028\032")
_nqMBh.Description = ""
_nqMBh.Visible = true
_nqMBh.Media = _WZO
_nqMBh.Choices = {
	"How are you?", 
	"Nothing"
}
_nqMBh.InputType = "MultipleChoice"
_nqMBh.Text = _wUHG("\115\088\092\004\080\125\011\090\028\110\080\053\011\090\080\028\055\032\070\080\004\011\080\004\092\028\032\080\092\045\011\090\004\058")
__cPS = Wherigo.ZInput(_3TM)
__cPS.Id = "b9c58bd5-106c-4fac-abf9-8908cc35e309"
__cPS.Name = _wUHG("\116\011\065\061\004\070\039\071\020\011\008\052\070\065\110\055\090\008")
__cPS.Description = ""
__cPS.Visible = true
__cPS.Media = _qI1ef
__cPS.Choices = {
	"Chapter 1: Werewolves", 
	"Chapter 2: Vampires", 
	"Chapter 3: Frankenstein", 
	"Chapter 4: Mummies", 
	"Close Book"
}
__cPS.InputType = "MultipleChoice"
__cPS.Text = _wUHG("\115\088\055\034\088\080\034\088\092\052\004\070\039\080\125\011\090\028\110\080\053\011\090\080\028\055\032\070\080\004\011\080\004\090\039\065\080\004\011\058")

-- WorksWithList for object commands --
_PfkVz.Commands._hPyA.WorksWithList = {
	_Lrd, 
	_OJ_6, 
	_r1e5, 
	_cqW, 
	_KDM0
}

-- functions --
function _3TM:OnStart()
	_nqlZ.Commands._6FK.Enabled = false
	_jO14t = _wUHG("\092\065\080\070\008\052\053\080\039\011\090\065\110\080")
	_oUP = 1
	if true then
		_d39a.Active = true
		_Urwigo.MessageBox{
			Text = _wUHG("\116\011\065\061\004\070\039\080\092\039\070\080\028\011\011\061\070\080\055\065\080\123\055\039\032\125\011\011\110\080\043\092\039\032\101\080\020\092\065\080\053\011\090\080\088\070\028\052\080\004\088\070\080\008\011\065\061\004\070\039\080\088\090\065\004\070\039\080\069\092\065\080\047\070\028\061\055\065\079\080\004\092\032\070\080\004\088\070\008\080\110\011\125\065\058\080\043\039\011\034\070\070\110\080\004\011\080\004\088\070\080\061\004\092\039\004\055\065\079\080\092\039\070\092\080\004\011\080\061\052\070\092\032\080\004\011\080\069\092\065\080\047\070\028\061\055\065\079\101"), 
			Media = _UD2h, 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.MessageBox{
						Text = _wUHG("\016\011\090\080\122\055\065\110\080\092\080\045\011\011\032\080\011\065\080\008\011\065\061\004\070\039\061\080\055\065\080\053\011\090\039\080\045\092\034\032\052\092\034\032\101\080\094\088\055\061\080\008\092\053\080\045\070\080\088\070\028\052\122\090\028\080\028\092\004\070\039\080\011\065\101"), 
						Media = _qI1ef, 
						Callback = function(action)
							if action ~= nil then
								_Urwigo.MessageBox{
									Text = _wUHG("\051\052\070\092\032\080\004\011\080\069\092\065\080\047\070\028\061\055\065\079\080\055\065\080\004\088\070\080\061\004\092\039\004\055\065\079\080\092\039\070\092\101\080"), 
									Media = _L5uGb, 
									Callback = function(action)
										if action ~= nil then
											_gORvD.Active = true
											Wherigo.ShowScreen(Wherigo.MAINSCREEN)
											_3TM:RequestSync()
										end
									end
								}
							end
						end
					}
				end
			end
		}
	else
		_Urwigo.MessageBox{
			Text = _wUHG("\094\088\055\061\080\055\061\080\092\080\065\055\079\088\004\080\004\055\008\070\080\125\088\070\039\055\079\011\080\011\065\028\053\101\080\016\011\090\080\125\055\028\028\080\065\070\070\110\080\004\011\080\034\011\008\070\080\045\092\034\032\080\045\070\004\125\070\070\065\080\004\088\070\080\088\011\090\039\061\080\011\122\080\067\087\078\057\080\092\065\110\080\059\059\087\057\057\080\052\008\101\080")
		}
		_d39a.Active = false
	end
end
function _3TM:OnRestore()
end
function _d39a:OnProximity()
	_xnBmd = _wUHG("\071\110\078\063\092")
	if _VbN == 1 then
		_Urwigo.MessageBox{
			Text = _wUHG("\016\011\090\080\061\070\070\080\069\092\065\080\047\070\028\061\055\065\079\080\061\004\092\065\110\055\065\079\080\065\070\092\039\045\053\101\080\051\052\070\092\032\080\004\011\080\088\055\008\080\125\088\070\065\080\053\011\090\080\079\070\004\080\092\080\034\088\092\065\034\070\101"), 
			Media = _DMn, 
			Callback = function(action)
				if action ~= nil then
					Wherigo.ShowScreen(Wherigo.MAINSCREEN)
				end
			end
		}
	elseif _VbN == 2 then
	end
end
function _d39a:OnSetActive()
	_xnBmd = _wUHG("\071\110\078\063\092")
	_Urwigo.GlobalZoneActiveChanged()
end
function _Qi2QN:OnProximity()
	_xnBmd = _wUHG("\071\046\055\060\046\097")
	if _jaZC == 1 then
		_Urwigo.MessageBox{
			Text = _wUHG("\056\061\080\053\011\090\080\070\065\004\070\039\080\004\088\070\080\092\039\070\092\031\080\053\011\090\080\061\070\070\080\092\080\028\092\039\079\070\080\079\039\070\070\065\080\061\028\055\008\053\080\034\039\070\092\004\090\039\070\080\061\125\092\028\028\011\125\055\065\079\080\079\011\045\061\080\011\122\080\034\092\065\110\053\080\122\039\011\008\080\004\088\070\080\034\011\065\034\070\061\061\055\011\065\080\061\004\092\065\110\101"), 
			Media = _tUh, 
			Callback = function(action)
				if action ~= nil then
					_jaZC = 2
					Wherigo.PlayAudio(_eUqyr)
					_Urwigo.MessageBox{
						Text = _wUHG("\048\004\096\061\080\051\028\055\008\070\039\080\122\039\011\008\080\004\088\070\080\002\088\011\061\004\045\090\061\004\070\039\061\038\038"), 
						Media = _WZO, 
						Buttons = {
							_wUHG("\051\028\055\008\070\039\038")
						}, 
						Callback = function(action)
							if action ~= nil then
								_Urwigo.MessageBox{
									Text = _wUHG("\047\055\080\004\088\070\039\070\038\080\048\080\088\070\092\039\110\080\053\011\090\080\065\070\070\110\080\061\011\008\070\080\092\008\008\011\080\004\011\080\004\092\032\070\080\110\011\125\065\080\004\088\070\080\070\100\055\028\080\008\011\065\061\004\070\039\061\080\004\088\092\004\080\092\039\070\080\039\011\092\008\055\065\079\080\004\088\070\080\092\039\070\092\101\080"), 
									Media = _WZO, 
									Callback = function(action)
										if action ~= nil then
											Wherigo.Command "StopSound"
											_Urwigo.MessageBox{
												Text = _wUHG("\116\011\065\061\004\070\039\061\080\092\039\070\080\122\055\065\055\034\032\053\080\092\065\110\080\034\092\065\080\011\065\028\053\080\045\070\080\004\092\032\070\065\080\110\011\125\065\080\125\055\004\088\080\092\080\034\070\039\004\092\055\065\080\032\055\065\110\080\011\122\080\092\008\008\011\101\080\103\011\039\080\070\021\092\008\052\028\070\031\080\055\122\080\053\011\090\080\125\092\065\004\080\004\011\080\004\092\032\070\080\110\011\125\065\080\092\080\125\055\004\034\088\080\053\011\090\080\088\092\100\070\080\004\011\080\004\088\039\011\125\080\125\092\004\070\039\080\011\065\080\088\070\039\101"), 
												Media = _WZO, 
												Callback = function(action)
													if action ~= nil then
														_Urwigo.MessageBox{
															Text = _wUHG("\048\080\125\055\028\028\080\061\090\052\052\028\053\080\053\011\090\080\125\055\004\088\080\004\088\070\080\061\004\092\065\110\092\039\110\080\008\011\065\061\004\070\039\080\092\008\008\090\065\055\004\055\011\065\080\052\092\034\032\101\080\048\004\080\125\055\028\028\080\045\070\080\090\052\080\004\011\080\053\011\090\080\004\011\080\028\011\092\110\080\004\088\070\080\034\011\039\039\070\034\004\080\092\008\008\090\065\055\004\055\011\065\080\055\065\004\011\080\004\088\070\080\008\011\065\061\004\070\039\080\052\088\092\061\070\080\079\090\065\101"), 
															Media = _WZO, 
															Callback = function(action)
																if action ~= nil then
																	Wherigo.PlayAudio(_jAiQe)
																	_Urwigo.MessageBox{
																		Text = "", 
																		Media = _nUY0, 
																		Buttons = {
																			_wUHG("\097\055\034\070\038")
																		}, 
																		Callback = function(action)
																			if action ~= nil then
																				_Urwigo.MessageBox{
																					Text = _wUHG("\103\039\092\065\032\070\065\061\004\070\055\065\031\080\115\011\028\122\008\092\065\031\080\092\065\110\080\004\088\070\080\116\090\008\008\053\080\092\039\070\080\065\070\092\039\045\053\101\080\115\070\080\065\070\070\110\080\004\011\080\004\092\032\070\080\004\088\070\008\080\011\090\004\101\080\047\055\065\004\087\080\070\092\034\088\080\008\011\065\061\004\070\039\080\125\055\028\028\080\011\065\028\053\080\045\070\080\070\122\122\070\034\004\070\110\080\045\053\080\092\080\034\070\039\004\092\055\065\080\004\053\052\070\080\011\122\080\092\008\008\090\065\055\004\055\011\065\101\080\116\092\032\070\080\061\090\039\070\080\053\011\090\080\028\011\092\110\080\004\088\070\080\034\011\039\039\070\034\004\080\092\008\008\011\080\055\065\004\011\080\053\011\090\039\080\008\011\065\061\004\070\039\080\052\088\092\061\070\080\079\090\065\101"), 
																					Media = _L5uGb, 
																					Callback = function(action)
																						if action ~= nil then
																							_fvthx:MoveTo(Player)
																							_GybL.Active = true
																							_GybL.Visible = true
																							_pI6.Visible = true
																							_IG1.Active = true
																							_pI6.Active = true
																							_IG1.Visible = true
																							_fCWt.Active = true
																							_XmK()
																							_jaZC = 3
																							Wherigo.ShowScreen(Wherigo.MAINSCREEN)
																							_3TM:RequestSync()
																						end
																					end
																				}
																			end
																		end
																	}
																end
															end
														}
													end
												end
											}
										end
									end
								}
							end
						end
					}
				end
			end
		}
	elseif _jaZC == 2 then
	elseif _jaZC == 3 then
		_Urwigo.MessageBox{
			Text = _wUHG("\056\061\080\053\011\090\080\070\065\004\070\039\080\004\088\070\080\092\039\070\092\031\080\053\011\090\080\061\070\070\080\092\080\028\092\039\079\070\080\079\039\070\070\065\080\061\028\055\008\053\080\034\039\070\092\004\090\039\070\080\061\125\092\028\028\011\125\055\065\079\080\079\011\045\061\080\011\122\080\034\092\065\110\053\080\122\039\011\008\080\004\088\070\080\034\011\065\034\070\061\061\055\011\065\080\061\004\092\065\110\101"), 
			Media = _tUh, 
			Callback = function(action)
				if action ~= nil then
					Wherigo.ShowScreen(Wherigo.MAINSCREEN)
				end
			end
		}
	end
end
function _Qi2QN:OnSetActive()
	_xnBmd = _wUHG("\071\046\055\060\046\097")
	_Urwigo.GlobalZoneActiveChanged()
end
function _L6N:OnProximity()
	_xnBmd = _wUHG("\071\012\102\097")
	if _ROl6y == 1 then
		_xJx4()
	elseif _CgQ == 2 then
		Wherigo.PlayAudio(_V4CX)
		_Urwigo.MessageBox{
			Text = _wUHG("\056\061\080\053\011\090\080\070\065\004\070\039\080\004\088\070\080\004\088\070\092\004\039\070\080\092\080\034\011\028\110\065\070\061\061\080\061\090\039\039\011\090\065\110\061\080\004\088\070\080\092\039\070\092\101\080\016\011\090\080\061\070\065\061\070\080\107\039\092\034\090\028\092\080\055\061\080\065\070\092\039\045\053\101"), 
			Media = _M3H, 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.MessageBox{
						Text = _wUHG("\107\039\092\034\090\028\092\080\008\011\100\070\061\080\004\011\080\092\004\004\092\034\032\080\053\011\090\038"), 
						Media = _QtV7, 
						Buttons = {
							_wUHG("\016\055\032\070\061\038")
						}, 
						Callback = function(action)
							if action ~= nil then
								_Urwigo.MessageBox{
									Text = _wUHG("\094\088\055\061\080\011\065\070\080\055\061\080\092\028\028\080\090\052\080\004\011\080\053\011\090\101\080\016\011\090\080\008\055\079\088\004\080\088\092\100\070\080\004\011\080\122\055\039\070\080\008\090\028\004\055\052\028\070\080\061\088\011\004\061\080\004\011\080\004\092\032\070\080\088\055\008\080\110\011\125\065\101\080\002\011\011\110\080\028\090\034\032\038"), 
									Media = _8rY, 
									Callback = function(action)
										if action ~= nil then
											Wherigo.ShowScreen(Wherigo.MAINSCREEN)
											Wherigo.Command "StopSound"
											_3TM:RequestSync()
										end
									end
								}
							end
						end
					}
				end
			end
		}
	elseif _CgQ == 3 then
	end
end
function _L6N:OnSetActive()
	_xnBmd = _wUHG("\071\012\102\097")
	_Urwigo.GlobalZoneActiveChanged()
end
function _pI6:OnProximity()
	_xnBmd = _wUHG("\071\052\048\102")
	if _ROl6y == 1 then
		_xJx4()
	elseif _Tt4tC == 2 then
		Wherigo.PlayAudio(_uUkz1)
		_Urwigo.MessageBox{
			Text = _wUHG("\115\055\004\088\055\065\080\004\088\070\080\125\011\011\110\061\080\053\011\090\080\088\070\092\039\080\092\080\039\090\061\004\028\055\065\079\080\065\070\092\039\045\053\080\092\065\110\080\092\080\034\039\070\092\004\090\039\070\080\092\052\052\070\092\039\061\080\045\070\122\011\039\070\080\053\011\090\087\080\004\088\070\080\008\090\008\008\053\038"), 
			Media = _neOjQ, 
			Buttons = {
				_wUHG("\048\004\096\061\080\004\088\070\080\116\090\008\008\053\038\038\038")
			}, 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.MessageBox{
						Text = _wUHG("\094\088\070\080\008\090\008\008\053\080\008\011\100\070\061\080\004\011\125\092\039\110\061\080\053\011\090\080\004\011\080\092\004\004\092\034\032\038"), 
						Media = _Goz, 
						Callback = function(action)
							if action ~= nil then
								_Urwigo.MessageBox{
									Text = _wUHG("\016\011\090\080\065\070\070\110\080\004\011\080\004\092\032\070\080\110\011\125\065\080\004\088\070\080\116\090\008\008\053\038\080\003\065\028\053\080\092\080\034\070\039\004\092\055\065\080\004\053\052\070\080\011\122\080\092\008\008\011\080\125\055\028\028\080\092\122\122\070\034\004\080\088\055\008\101\080\116\092\032\070\080\061\090\039\070\080\053\011\090\080\028\011\092\110\080\004\088\070\080\034\011\039\039\070\034\004\080\092\008\008\011\080\055\065\004\011\080\053\011\090\039\080\008\011\065\061\004\070\039\080\052\088\092\061\070\080\079\090\065\080\045\070\122\011\039\070\080\122\055\039\055\065\079\080\092\004\080\088\055\008\038"), 
									Media = _8rY, 
									Callback = function(action)
										if action ~= nil then
											Wherigo.Command "StopSound"
											Wherigo.ShowScreen(Wherigo.MAINSCREEN)
											_3TM:RequestSync()
										end
									end
								}
							end
						end
					}
				end
			end
		}
	elseif _Tt4tC == 3 then
	end
end
function _pI6:OnSetActive()
	_xnBmd = _wUHG("\071\052\048\102")
	_Urwigo.GlobalZoneActiveChanged()
end
function _GybL:OnProximity()
	_xnBmd = _wUHG("\071\002\053\045\012")
	if _ROl6y == 1 then
		_xJx4()
	elseif _TFC == 2 then
		Wherigo.PlayAudio(_R3SR)
		_Urwigo.MessageBox{
			Text = _wUHG("\056\061\080\053\011\090\080\070\065\004\070\039\080\055\065\004\011\080\004\088\070\080\110\092\039\032\080\125\011\011\110\061\080\053\011\090\080\061\070\065\061\070\080\110\092\065\079\070\039\080\065\070\092\039\045\053\101\080\094\088\070\080\115\011\028\122\008\092\065\080\092\052\052\070\092\039\061\038"), 
			Media = _x8aRD, 
			Buttons = {
				_wUHG("\003\088\080\097\011\038\038\038")
			}, 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.MessageBox{
						Text = _wUHG("\094\088\070\080\125\011\028\122\008\092\065\080\092\004\004\092\034\032\061\038\080\107\011\080\061\011\008\070\004\088\055\065\079\080\045\070\122\011\039\070\080\055\004\096\061\080\004\011\011\080\028\092\004\070\038"), 
						Media = _PyjH, 
						Callback = function(action)
							if action ~= nil then
								_Urwigo.MessageBox{
									Text = _wUHG("\016\011\090\080\065\070\070\110\080\004\011\080\004\092\032\070\080\088\055\008\080\110\011\125\065\038\080\003\065\028\053\080\092\080\034\070\039\004\092\055\065\080\004\053\052\070\080\011\122\080\092\008\008\011\080\125\055\028\028\080\092\122\122\070\034\004\080\115\011\028\122\008\092\065\101\080\116\092\032\070\080\061\090\039\070\080\053\011\090\080\028\011\092\110\080\004\088\070\080\034\011\039\039\070\034\004\080\092\008\008\011\080\055\065\004\011\080\053\011\090\039\080\079\090\065\080\045\070\122\011\039\070\080\122\055\039\055\065\079\080\092\004\080\088\055\008\038"), 
									Media = _8rY, 
									Callback = function(action)
										if action ~= nil then
											Wherigo.Command "StopSound"
											Wherigo.ShowScreen(Wherigo.MAINSCREEN)
											_3TM:RequestSync()
										end
									end
								}
							end
						end
					}
				end
			end
		}
	elseif _TFC == 3 then
	end
end
function _GybL:OnSetActive()
	_xnBmd = _wUHG("\071\002\053\045\012")
	_Urwigo.GlobalZoneActiveChanged()
end
function _IG1:OnProximity()
	_xnBmd = _wUHG("\071\048\002\059")
	if _ROl6y == 1 then
		_xJx4()
	elseif _aQF == 2 then
		Wherigo.PlayAudio(_szYi)
		_Urwigo.MessageBox{
			Text = _wUHG("\051\004\092\065\110\055\065\079\080\065\070\092\039\080\004\088\070\080\045\092\061\070\080\011\122\080\004\088\070\080\004\011\125\070\039\080\053\011\090\080\061\070\070\080\103\039\092\065\032\070\065\061\004\070\055\065\038"), 
			Media = _A8tV4, 
			Buttons = {
				_wUHG("\016\055\032\070\061\038")
			}, 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.MessageBox{
						Text = _wUHG("\103\039\092\065\032\070\065\061\004\070\055\065\080\008\011\100\070\061\080\004\011\080\092\004\004\092\034\032\038\038\038"), 
						Media = _JPD, 
						Callback = function(action)
							if action ~= nil then
								_Urwigo.MessageBox{
									Text = _wUHG("\016\011\090\080\065\070\070\110\080\004\011\080\004\092\032\070\080\110\011\125\065\080\103\039\092\065\032\070\065\061\004\070\055\065\038\080\003\065\028\053\080\092\080\034\070\039\004\092\055\065\080\004\053\052\070\080\011\122\080\092\008\008\011\080\125\055\028\028\080\092\122\122\070\034\004\080\088\055\008\101\080\116\092\032\070\080\061\090\039\070\080\053\011\090\080\028\011\092\110\080\004\088\070\080\034\011\039\039\070\034\004\080\092\008\008\011\080\055\065\004\011\080\053\011\090\039\080\008\011\065\061\004\070\039\080\052\088\092\061\070\080\079\090\065\080\045\070\122\011\039\070\080\122\055\039\055\065\079\080\092\004\080\088\055\008\038"), 
									Media = _8rY, 
									Callback = function(action)
										if action ~= nil then
											Wherigo.Command "StopSound"
											Wherigo.ShowScreen(Wherigo.MAINSCREEN)
											_3TM:RequestSync()
										end
									end
								}
							end
						end
					}
				end
			end
		}
	elseif _aQF == 3 then
	end
end
function _IG1:OnSetActive()
	_xnBmd = _wUHG("\071\048\002\059")
	_Urwigo.GlobalZoneActiveChanged()
end
function _8GZ:OnProximity()
	_xnBmd = _wUHG("\071\029\002\054")
	if _ivn_U ~= true then
		_ivn_U = true
		_3TM.Complete = true
		_Urwigo.MessageBox{
			Text = _wUHG("\051\070\092\039\034\088\080\122\011\039\080\092\080\088\011\065\070\053\061\090\034\032\028\070\080\004\039\070\070\080\055\065\080\004\088\070\080\079\039\011\100\070\101\080\094\088\070\080\034\092\034\088\070\080\055\061\080\092\065\080\070\021\004\039\092\126\028\092\039\079\070\080\045\055\061\011\065\080\004\090\045\070\080\028\011\034\092\004\070\110\080\092\004\087\080\097\080\078\029\080\078\027\101\102\029\057\080\037\065\045\061\052\089\115\080\063\057\080\060\027\101\063\027\067\101"), 
			Media = _SFTR, 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.MessageBox{
						Text = (_wUHG("\094\088\055\061\080\125\088\070\039\055\079\011\080\055\061\080\065\011\125\080\034\011\008\052\028\070\004\070\101\080\016\011\090\039\080\052\028\092\053\070\039\080\034\011\008\052\028\070\004\055\011\065\080\034\011\110\070\080\055\061\087\080")..string.sub(Player.CompletionCode, 1, 15)).._wUHG("\080\094\088\055\061\080\034\011\110\070\080\055\061\080\090\061\070\110\080\004\011\080\028\011\079\080\053\011\090\039\080\079\092\008\070\080\011\065\080\125\088\070\039\055\079\011\101\034\011\008\101\080\048\004\080\055\061\080\092\028\061\011\080\092\100\092\055\028\092\045\028\070\080\055\065\080\053\011\090\039\080\055\065\100\070\065\004\011\039\053\101\080"), 
						Media = _keC9z, 
						Callback = function(action)
							if action ~= nil then
								_Urwigo.MessageBox{
									Text = _wUHG("\094\088\055\061\080\115\088\070\039\055\079\011\080\125\092\061\080\034\039\070\092\004\070\110\080\045\053\080\103\011\039\070\061\004\126\002\088\011\061\004\080\122\011\039\080\004\088\070\080\002\039\070\092\004\080\047\092\028\028\011\125\070\070\065\080\024\092\061\088\080\048\048\048\101\080\094\088\092\065\032\061\080\122\011\039\080\052\028\092\053\055\065\079\080\087\126\107"), 
									Media = _fZCR, 
									Callback = function(action)
										if action ~= nil then
											_3mKU3:MoveTo(Player)
											_3mKU3.Description = string.sub(Player.CompletionCode, 1, 15)
											Wherigo.ShowScreen(Wherigo.MAINSCREEN)
											_3TM:RequestSync()
										end
									end
								}
							end
						end
					}
				end
			end
		}
	end
end
function _8GZ:OnSetActive()
	_xnBmd = _wUHG("\071\029\002\054")
	_Urwigo.GlobalZoneActiveChanged()
end
function _02L:OnGetInput(input)
	if input == nil then
		input = ""
	end
	_ZRp = input
	if Wherigo.NoCaseEquals(_ZRp, _wUHG("\051\055\028\100\070\039\080\024\090\028\028\070\004")) then
		_jO14t = _wUHG("\061\055\028\100\070\039\080\045\090\028\028\070\004")
		Wherigo.PlayAudio(_jAiQe)
		_kKMo = 2
		_opZu = 1
		_FWt = 1
		_g8c = 1
		_OYj = 1
		_Urwigo.MessageBox{
			Text = _wUHG("\016\011\090\080\028\011\092\110\080\004\088\070\080\061\055\028\100\070\039\080\045\090\028\028\070\004\080\055\065\004\011\080\053\011\090\039\080\008\011\065\061\004\070\039\080\052\088\092\061\070\080\079\090\065\101"), 
			Media = _8Ta, 
			Callback = function(action)
				if action ~= nil then
					Wherigo.ShowScreen(Wherigo.MAINSCREEN)
					Wherigo.Command "StopSound"
					_3TM:RequestSync()
				end
			end
		}
	elseif Wherigo.NoCaseEquals(_ZRp, _wUHG("\051\004\092\032\070")) then
		_jO14t = _wUHG("\061\004\092\032\070")
		Wherigo.PlayAudio(_jAiQe)
		_opZu = 2
		_FWt = 1
		_kKMo = 1
		_g8c = 1
		_OYj = 1
		_Urwigo.MessageBox{
			Text = _wUHG("\016\011\090\080\028\011\092\110\080\004\088\070\080\061\004\092\032\070\080\055\065\004\011\080\053\011\090\039\080\008\011\065\061\004\070\039\080\052\088\092\061\070\080\079\090\065\101"), 
			Media = _5_Oj, 
			Callback = function(action)
				if action ~= nil then
					Wherigo.ShowScreen(Wherigo.MAINSCREEN)
					Wherigo.Command "StopSound"
					_3TM:RequestSync()
				end
			end
		}
	elseif Wherigo.NoCaseEquals(_ZRp, _wUHG("\103\028\092\008\070")) then
		_jO14t = _wUHG("\122\028\092\008\070")
		Wherigo.PlayAudio(_jAiQe)
		_FWt = 2
		_g8c = 1
		_kKMo = 1
		_opZu = 1
		_OYj = 1
		_Urwigo.MessageBox{
			Text = _wUHG("\016\011\090\080\028\011\092\110\080\004\088\070\080\122\028\092\008\070\080\055\065\004\011\080\053\011\090\039\080\008\011\065\061\004\070\039\080\052\088\092\061\070\080\079\090\065\101"), 
			Media = _Vg2Q, 
			Callback = function(action)
				if action ~= nil then
					Wherigo.ShowScreen(Wherigo.MAINSCREEN)
					Wherigo.Command "StopSound"
					_3TM:RequestSync()
				end
			end
		}
	elseif Wherigo.NoCaseEquals(_ZRp, _wUHG("\002\092\039\028\055\034")) then
		_jO14t = _wUHG("\079\092\039\028\055\034")
		Wherigo.PlayAudio(_jAiQe)
		_OYj = 2
		_g8c = 1
		_opZu = 1
		_g8c = 1
		_FWt = 1
		_Urwigo.MessageBox{
			Text = _wUHG("\016\011\090\080\028\011\092\110\080\004\088\070\080\079\092\039\028\055\034\080\055\065\004\011\080\053\011\090\039\080\008\011\065\061\004\070\039\080\052\088\092\061\070\080\079\090\065\101"), 
			Media = _r0T3, 
			Callback = function(action)
				if action ~= nil then
					Wherigo.ShowScreen(Wherigo.MAINSCREEN)
					Wherigo.Command "StopSound"
					_3TM:RequestSync()
				end
			end
		}
	elseif Wherigo.NoCaseEquals(_ZRp, _wUHG("\047\011\028\053\080\051\053\008\045\011\028")) then
		_jO14t = _wUHG("\088\011\028\053\080\061\053\008\045\011\028")
		Wherigo.PlayAudio(_jAiQe)
		_g8c = 2
		_kKMo = 1
		_opZu = 1
		_FWt = 1
		_OYj = 1
		_Urwigo.MessageBox{
			Text = _wUHG("\016\011\090\080\028\011\092\110\080\004\088\070\080\088\011\028\053\080\061\053\008\045\011\028\080\055\065\004\011\080\053\011\090\039\080\008\011\065\061\004\070\039\080\052\088\092\061\070\080\079\090\065\101"), 
			Media = _72f, 
			Callback = function(action)
				if action ~= nil then
					Wherigo.ShowScreen(Wherigo.MAINSCREEN)
					Wherigo.Command "StopSound"
					_3TM:RequestSync()
				end
			end
		}
	else
		Wherigo.ShowScreen(Wherigo.MAINSCREEN)
	end
end
function _nqMBh:OnGetInput(input)
	if input == nil then
		input = ""
	end
	_ezG = input
	if Wherigo.NoCaseEquals(_ezG, _wUHG("\047\011\125\080\092\039\070\080\053\011\090\058")) then
		_Urwigo.MessageBox{
			Text = _wUHG("\016\011\090\080\125\092\065\004\080\004\011\080\032\065\011\125\080\088\011\125\080\048\080\092\008\080\110\011\055\065\079\058\058\058\080\047\008\008\031\080\065\011\080\011\065\070\080\088\092\061\080\092\061\032\070\110\080\008\070\080\004\088\092\004\080\045\070\122\011\039\070\101"), 
			Media = _WZO, 
			Callback = function(action)
				if action ~= nil then
					Wherigo.Command "StopSound"
					_Urwigo.MessageBox{
						Text = _wUHG("\115\070\028\028\080\061\055\065\034\070\080\053\011\090\080\092\061\032\070\110\080\048\080\088\092\100\070\080\065\011\004\080\045\070\070\065\080\110\011\055\065\079\080\061\011\080\125\070\028\028\101\080\016\011\090\080\061\070\070\080\048\080\088\092\100\070\080\045\070\070\065\080\061\004\090\034\032\080\070\092\004\055\065\079\080\034\092\065\110\053\080\092\065\110\080\061\125\070\070\004\061\080\092\028\028\080\110\092\053\080\045\090\004\080\125\088\092\004\080\048\080\039\070\092\028\028\053\080\065\070\070\110\080\055\061\080\061\011\008\070\004\088\055\065\079\080\061\092\100\011\039\053\101\080\048\122\080\053\011\090\080\034\092\065\080\122\055\065\110\080\008\070\080\061\011\008\070\080\061\092\100\011\039\053\080\122\011\011\110\080\055\004\080\125\011\090\028\110\080\008\092\032\070\080\008\070\080\039\070\092\028\028\053\080\088\092\052\052\053\101"), 
						Media = _WZO, 
						Callback = function(action)
							if action ~= nil then
								Wherigo.ShowScreen(Wherigo.MAINSCREEN)
								_3TM:RequestSync()
							end
						end
					}
				end
			end
		}
	else
		_Urwigo.MessageBox{
			Text = (_wUHG("\002\011\011\110\080\004\092\028\032\080")..Player.Name).._wUHG("\101\080\020\011\008\070\080\045\092\034\032\080\055\122\080\053\011\090\080\065\070\070\110\080\092\065\053\004\088\055\065\079\080\070\028\061\070\101"), 
			Media = _WZO, 
			Callback = function(action)
				if action ~= nil then
					Wherigo.Command "StopSound"
					Wherigo.ShowScreen(Wherigo.MAINSCREEN)
					_3TM:RequestSync()
				end
			end
		}
	end
end
function __cPS:OnGetInput(input)
	if input == nil then
		input = ""
	end
	if _Urwigo.Hash(string.lower(input)) == 46520 then
		_Urwigo.MessageBox{
			Text = _wUHG("\108\100\070\065\080\092\080\008\092\065\080\125\088\011\080\055\061\080\052\090\039\070\080\055\065\080\088\070\092\039\004\080\092\065\110\080\061\092\053\061\080\088\055\061\080\052\039\092\053\070\039\061\080\045\053\080\065\055\079\088\004\031\080\008\092\053\080\045\070\034\011\008\070\080\092\080\125\011\028\122\080\125\088\070\065\080\004\088\070\080\125\011\028\122\080\045\092\065\070\080\045\028\011\011\008\061\080\092\065\110\080\004\088\070\080\092\090\004\090\008\065\080\008\011\011\065\080\055\061\080\045\039\055\079\088\004\101"), 
			Media = _PyjH, 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.MessageBox{
						Text = _wUHG("\048\004\080\055\061\080\061\092\055\110\080\004\088\092\004\080\092\080\125\070\039\070\125\011\028\122\080\034\092\065\080\011\065\028\053\080\045\070\080\032\055\028\028\070\110\080\045\053\080\092\080\061\055\028\100\070\039\080\125\070\092\052\011\065\080\011\039\080\045\053\080\061\011\008\070\011\065\070\080\125\088\011\080\004\039\090\028\053\080\028\011\100\070\061\080\004\088\070\008\101"), 
						Media = _PyjH, 
						Callback = function(action)
							if action ~= nil then
								_Urwigo.RunDialogs(function()
									Wherigo.GetInput(__cPS)
								end)
							end
						end
					}
				end
			end
		}
	elseif _Urwigo.Hash(string.lower(input)) == 36791 then
		_Urwigo.MessageBox{
			Text = _wUHG("\069\092\008\052\055\039\070\061\080\052\011\061\070\061\080\061\090\052\070\039\080\088\090\008\092\065\080\061\004\039\070\065\079\004\088\080\092\065\110\080\092\039\070\080\034\090\039\061\070\110\080\004\011\080\125\092\028\032\080\004\088\070\080\070\092\039\004\088\080\122\011\039\080\092\028\028\080\070\004\070\039\065\055\004\053\101\080\056\065\053\011\065\070\080\045\055\004\004\070\065\080\045\053\080\092\080\100\092\008\052\055\039\070\080\125\055\028\028\080\092\028\061\011\080\004\090\039\065\080\090\065\126\110\070\092\110\101"), 
			Media = _QtV7, 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.MessageBox{
						Text = _wUHG("\069\092\008\052\055\039\070\061\080\092\039\070\080\092\028\008\011\061\004\080\055\065\100\055\065\034\055\045\028\070\031\080\045\090\004\080\004\088\070\039\070\080\092\039\070\080\092\080\122\070\125\080\125\092\053\061\080\004\011\080\110\092\008\092\079\070\080\004\088\070\008\087\080\079\092\039\028\055\034\031\080\088\011\028\053\080\061\053\008\045\011\028\061\031\080\061\090\065\028\055\079\088\004\031\080\092\065\110\080\092\080\061\004\092\032\070\080\004\088\039\011\090\079\088\080\004\088\070\080\088\070\092\039\004\101"), 
						Media = _QtV7, 
						Callback = function(action)
							if action ~= nil then
								_Urwigo.RunDialogs(function()
									Wherigo.GetInput(__cPS)
								end)
							end
						end
					}
				end
			end
		}
	elseif _Urwigo.Hash(string.lower(input)) == 4006 then
		_Urwigo.MessageBox{
			Text = _wUHG("\103\039\092\065\032\070\065\061\004\070\055\065\080\055\061\080\011\065\070\080\011\122\080\004\088\070\080\008\011\061\004\080\052\011\125\070\039\122\090\028\080\008\011\065\061\004\070\039\061\080\011\122\080\092\028\028\101\080\047\055\061\080\045\011\110\053\080\055\061\080\008\092\110\070\080\011\090\004\080\011\122\080\052\092\039\004\061\080\061\004\011\028\070\065\080\122\039\011\008\080\004\088\070\080\079\039\092\100\070\053\092\039\110\031\080\061\070\125\065\080\004\011\079\070\004\088\070\039\080\092\065\110\080\122\055\065\092\028\028\053\080\045\039\011\090\079\088\004\080\045\092\034\032\080\004\011\080\028\055\122\070\080\045\053\080\070\028\070\034\004\039\055\034\055\004\053\101"), 
			Media = _JPD, 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.MessageBox{
						Text = _wUHG("\103\039\092\065\032\070\065\061\004\070\055\065\080\055\061\080\070\021\004\039\070\008\070\028\053\080\110\092\065\079\070\039\011\090\061\101\080\116\011\065\061\004\070\039\080\070\021\052\070\039\004\061\080\034\028\092\055\008\080\004\088\092\004\080\011\065\028\053\080\122\028\092\008\070\061\080\034\092\065\080\034\011\008\052\028\070\004\070\028\053\080\110\070\061\004\039\011\053\055\065\079\080\088\055\061\080\045\011\110\053\101\080"), 
						Media = _JPD, 
						Callback = function(action)
							if action ~= nil then
								_Urwigo.RunDialogs(function()
									Wherigo.GetInput(__cPS)
								end)
							end
						end
					}
				end
			end
		}
	elseif _Urwigo.Hash(string.lower(input)) == 52543 then
		_Urwigo.MessageBox{
			Text = _wUHG("\116\090\008\008\055\070\061\080\092\039\070\080\004\088\070\080\039\070\126\092\065\055\008\092\004\070\110\080\034\011\039\052\061\070\061\080\011\122\080\092\065\034\055\070\065\004\080\108\079\053\052\004\055\092\065\080\052\039\055\070\061\004\061\101\080\056\080\008\090\008\008\053\080\125\055\028\028\080\092\039\055\061\070\080\125\088\070\065\080\088\055\061\080\092\065\034\055\070\065\004\080\039\070\061\004\055\065\079\080\052\028\092\034\070\080\088\092\061\080\045\070\070\065\080\110\055\061\004\090\039\045\070\110\101"), 
			Media = _Goz, 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.MessageBox{
						Text = _wUHG("\094\088\070\039\070\080\092\039\070\080\061\070\100\070\039\092\028\080\008\070\004\088\011\110\061\080\122\011\039\080\110\070\061\004\039\011\053\055\065\079\080\092\080\008\090\008\008\053\101\080\014\070\008\011\100\055\065\079\080\088\055\061\080\045\092\065\110\092\079\070\061\080\034\092\065\080\088\090\039\004\080\088\055\008\101\080\056\065\080\092\065\034\055\070\065\004\080\088\011\028\053\080\061\053\008\045\011\028\031\080\004\088\070\080\056\065\032\088\031\080\088\092\061\080\004\088\070\080\052\011\125\070\039\080\004\011\080\034\011\065\004\039\011\028\080\088\055\008\080\092\065\110\080\061\070\065\110\080\088\055\008\080\045\092\034\032\080\004\011\080\088\055\061\080\079\039\092\100\070\101"), 
						Media = _Goz, 
						Callback = function(action)
							if action ~= nil then
								_Urwigo.RunDialogs(function()
									Wherigo.GetInput(__cPS)
								end)
							end
						end
					}
				end
			end
		}
	else
		_Urwigo.MessageBox{
			Text = _wUHG("\016\011\090\080\034\028\011\061\070\080\004\088\070\080\045\011\011\032\101"), 
			Callback = function(action)
				if action ~= nil then
					Wherigo.ShowScreen(Wherigo.MAINSCREEN)
				end
			end
		}
	end
end
function _nqlZ:On_3BNb(target)
	Wherigo.PlayAudio(_QHp)
	_VbN = 2
	_gORvD.Complete = true
	_Urwigo.MessageBox{
		Text = (_wUHG("\047\070\028\028\011\080\004\088\070\039\070\080")..Player.Name).._wUHG("\031\080\048\080\092\008\080\069\092\065\080\047\070\028\061\055\065\079\031\080\028\070\079\070\065\110\092\039\053\080\008\011\065\061\004\070\039\080\088\090\065\004\070\039\101\080\056\080\004\070\039\039\055\045\028\070\080\110\055\061\092\061\004\070\039\080\088\092\061\080\011\034\034\090\039\039\070\110\101\101\101"), 
		Media = _8rY, 
		Callback = function(action)
			if action ~= nil then
				Wherigo.Command "StopSound"
				Wherigo.PlayAudio(_Je8Z)
				_Urwigo.MessageBox{
					Text = _wUHG("\116\011\065\061\004\070\039\061\080\088\092\100\070\080\070\061\034\092\052\070\110\080\004\088\070\080\090\065\110\070\039\125\011\039\028\110\080\004\088\039\011\090\079\088\080\092\080\052\011\039\004\092\028\080\092\065\110\080\092\039\070\080\028\011\011\061\070\080\055\065\080\123\055\039\032\125\011\011\110\080\043\092\039\032\038\038\038"), 
					Media = _hBLKX, 
					Buttons = {
						_wUHG("\016\055\032\070\061\038")
					}, 
					Callback = function(action)
						if action ~= nil then
							_Urwigo.MessageBox{
								Text = _wUHG("\107\039\092\034\090\028\092\031\080\103\039\092\065\032\070\065\061\004\070\055\065\031\080\115\011\028\122\008\092\065\031\080\092\065\110\080\004\088\070\080\116\090\008\008\053\080\088\092\100\070\080\092\028\028\080\070\061\034\092\052\070\110\101\080\115\070\080\065\070\070\110\080\004\011\080\110\011\080\061\011\008\070\004\088\055\065\079\080\045\070\122\011\039\070\080\061\011\008\070\011\065\070\080\079\070\004\061\080\088\090\039\004\038"), 
								Media = _UD2h, 
								Buttons = {
									_wUHG("\012\070\004\061\080\079\070\004\080\070\008\038"), 
									_wUHG("\097\011\004\080\116\070\038")
								}, 
								Callback = function(action)
									if action ~= nil then
										Wherigo.Command "StopSound"
										if action == "Button1" then
											_Urwigo.MessageBox{
												Text = _wUHG("\094\092\032\070\080\004\088\055\061\080\043\101\123\101\108\101\080\116\070\004\070\039\101\080\048\004\080\125\055\028\028\080\008\070\092\061\090\039\070\080\004\088\070\080\092\008\011\090\065\004\080\011\122\080\043\061\053\034\088\011\126\123\055\065\070\004\055\034\080\007\116\011\065\061\004\070\039\117\080\108\065\070\039\079\053\080\055\065\080\004\088\070\080\092\039\070\092\080\061\011\080\125\070\080\034\092\065\080\122\055\065\110\080\011\090\004\080\125\088\070\039\070\080\004\088\070\080\008\011\065\061\004\070\039\061\080\092\039\070\080\088\055\110\055\065\079\101"), 
												Media = _8rY, 
												Callback = function(action)
													if action ~= nil then
														_Urwigo.MessageBox{
															Text = "", 
															Media = _zHI, 
															Buttons = {
																_wUHG("\094\088\092\065\032\080\053\011\090\038")
															}, 
															Callback = function(action)
																if action ~= nil then
																	_Urwigo.MessageBox{
																		Text = _wUHG("\094\088\070\080\043\101\123\101\108\101\080\008\070\004\070\039\080\055\061\080\100\070\039\053\080\061\070\065\061\055\004\055\100\070\080\061\011\080\055\122\080\004\088\070\039\070\080\092\039\070\080\092\065\053\080\008\011\065\061\004\070\039\061\080\065\070\092\039\045\053\080\055\004\080\061\088\011\090\028\110\080\052\055\034\032\080\004\088\070\008\080\090\052\101\080\094\088\070\080\008\070\004\070\039\080\055\061\080\065\011\125\080\028\011\034\092\004\070\110\080\055\065\080\053\011\090\039\080\055\004\070\008\061\080\004\092\045\101\080\116\092\032\070\080\061\090\039\070\080\004\011\080\004\090\039\065\080\055\004\080\011\065\080\045\070\122\011\039\070\080\053\011\090\080\061\004\092\039\004\101"), 
																		Media = _zHI, 
																		Callback = function(action)
																			if action ~= nil then
																				_Urwigo.MessageBox{
																					Text = _wUHG("\003\065\034\070\080\053\011\090\080\088\092\100\070\080\004\090\039\065\070\110\080\004\088\070\080\043\101\123\101\108\080\008\070\004\070\039\080\011\065\080\122\011\028\028\011\125\080\004\088\070\080\052\092\004\088\080\004\011\080\004\088\070\080\097\011\039\004\088\080\115\070\061\004\101\080\016\011\090\080\125\011\065\096\004\080\045\070\080\092\045\028\070\080\004\011\080\061\070\070\080\004\088\070\080\008\011\065\061\004\070\039\061\080\045\090\004\080\053\011\090\039\080\043\101\123\101\108\080\008\070\004\070\039\080\061\088\011\090\028\110\080\052\055\034\032\080\004\088\070\008\080\090\052\101"), 
																					Media = _zHI, 
																					Callback = function(action)
																						if action ~= nil then
																							_Urwigo.MessageBox{
																								Text = _wUHG("\094\090\039\065\080\011\065\080\053\011\090\039\080\043\101\123\101\108\080\008\070\004\070\039\080\011\065\080\007\028\011\034\092\004\070\110\080\055\065\080\053\011\090\039\080\055\065\100\070\065\004\011\039\053\117\080\092\065\110\080\122\011\028\028\011\125\080\004\088\070\080\052\092\004\088\080\004\011\080\004\088\070\080\065\011\039\004\088\080\125\070\061\004\080\004\011\080\122\055\065\110\080\004\088\070\080\008\011\065\061\004\070\039\061\101"), 
																								Media = _L5uGb, 
																								Callback = function(action)
																									if action ~= nil then
																										_G5Kbn:MoveTo(Player)
																										_VbN = 1
																										_HuUCE.Active = true
																										_nqlZ.Commands._3BNb.Enabled = false
																										_nqlZ.Commands._6FK.Enabled = true
																										Wherigo.ShowScreen(Wherigo.MAINSCREEN)
																									end
																								end
																							}
																							_3TM:RequestSync()
																						end
																					end
																				}
																			end
																		end
																	}
																end
															end
														}
													end
												end
											}
										elseif action == "Button2" then
											_Urwigo.MessageBox{
												Text = _wUHG("\048\122\080\053\011\090\080\034\088\092\065\079\070\080\053\011\090\039\080\008\055\065\110\080\053\011\090\080\032\065\011\125\080\125\088\070\039\070\080\004\011\080\122\055\065\110\080\008\070\101"), 
												Media = _8rY, 
												Callback = function(action)
													if action ~= nil then
														_VbN = 1
														Wherigo.ShowScreen(Wherigo.MAINSCREEN)
													end
												end
											}
										end
									end
								end
							}
						end
					end
				}
			end
		end
	}
end
function _nqlZ:On_6FK(target)
	Wherigo.PlayAudio(_QHp)
	_Urwigo.MessageBox{
		Text = (_wUHG("\047\055\080")..Player.Name).._wUHG("\080\053\011\090\080\092\039\070\080\110\011\055\065\079\080\079\011\011\110\101\080\003\065\034\070\080\053\011\090\080\088\092\100\070\080\004\090\039\065\070\110\080\004\088\070\080\043\101\123\101\108\101\080\116\070\004\070\039\080\011\065\080\122\011\028\028\011\125\080\004\088\070\080\052\092\004\088\080\004\011\080\004\088\070\080\097\011\039\004\088\115\070\061\004\031"), 
		Media = _8rY, 
		Callback = function(action)
			if action ~= nil then
				_Urwigo.MessageBox{
					Text = _wUHG("\048\122\080\053\011\090\080\079\070\004\080\061\004\090\034\032\031\080\034\088\070\034\032\080\004\088\070\080\004\092\061\032\061\080\008\070\065\090\101\080\016\011\090\080\125\055\028\028\080\122\055\065\110\080\088\055\065\004\061\080\004\088\070\039\070\080\092\045\011\090\004\080\125\088\092\004\080\004\011\080\110\011\080\065\070\021\004\101"), 
					Media = _8rY, 
					Callback = function(action)
						if action ~= nil then
							Wherigo.Command "StopSound"
							Wherigo.ShowScreen(Wherigo.MAINSCREEN)
						end
					end
				}
			end
		end
	}
end
function _r1e5:On_Zj_(target)
	_Urwigo.RunDialogs(function()
		Wherigo.GetInput(_nqMBh)
	end)
end
function _PfkVz:On_hPyA(target)
	if target == _Lrd then
		Wherigo.PlayAudio(_jSYj)
		_8Qx()
		_Urwigo.MessageBox{
			Text = (((_wUHG("\016\011\090\080\122\055\039\070\080\011\122\122\080\004\088\070\080").._jO14t).._wUHG("\080\092\004\080")).._Lrd.Name).._wUHG("\101"), 
			Media = _P0Yz, 
			Callback = function(action)
				if action ~= nil then
					if _kKMo == 2 then
						Wherigo.Command "StopSound"
						_Urwigo.MessageBox{
							Text = _wUHG("\016\011\090\080\088\055\004\080\125\011\028\122\008\092\065\038"), 
							Media = _x8aRD, 
							Callback = function(action)
								if action ~= nil then
									_kKMo = 1
									_jO14t = _wUHG("\070\008\052\004\053\080\039\011\090\065\110\080")
									Wherigo.PlayAudio(_Ks4)
									_Urwigo.MessageBox{
										Text = _wUHG("\094\088\070\080\061\055\028\100\070\039\080\045\090\028\028\070\004\080\061\004\039\055\032\070\061\080\004\039\090\070\080\092\065\110\080\004\088\070\080\115\011\028\122\008\092\065\080\110\055\061\092\052\052\070\092\039\061\080\055\065\004\011\080\092\080\034\028\011\090\110\080\011\122\080\110\090\061\004\101"), 
										Media = _Xho4, 
										Callback = function(action)
											if action ~= nil then
												Wherigo.Command "StopSound"
												_Urwigo.MessageBox{
													Text = _wUHG("\002\011\011\110\080\077\011\045\080\032\055\110\038\080\016\011\090\080\079\011\004\080\004\088\070\080\115\011\028\122\008\092\065\101\080\012\070\004\061\080\079\011\080\079\070\004\080\004\088\070\080\039\070\061\004\080\011\122\080\004\088\070\080\008\011\065\061\004\070\039\061\080\065\011\125\038"), 
													Media = _8rY, 
													Callback = function(action)
														if action ~= nil then
															_YSdB6 = _YSdB6 + 1
															_8he()
															_dsaI5()
															Wherigo.ShowScreen(Wherigo.MAINSCREEN)
															_3TM:RequestSync()
														end
													end
												}
											end
										end
									}
								end
							end
						}
					else
						_Urwigo.MessageBox{
							Text = (_wUHG("\097\011\004\088\055\065\079\080\088\092\052\052\070\065\061\031\080\052\070\039\088\092\052\061\080\004\088\070\080").._jO14t).._wUHG("\080\110\011\070\061\080\065\011\004\080\092\122\122\070\034\004\080\004\088\070\080\115\011\028\122\008\092\065\101\080"), 
							Media = _FKO, 
							Callback = function(action)
								if action ~= nil then
									Wherigo.Command "StopSound"
									_jO14t = _wUHG("\070\008\052\004\053\080\039\011\090\065\110\080")
									_893()
									_8he()
									Wherigo.ShowScreen(Wherigo.MAINSCREEN)
									_3TM:RequestSync()
								end
							end
						}
					end
				end
			end
		}
	elseif target == _OJ_6 then
		Wherigo.PlayAudio(_jSYj)
		_8Qx()
		_Urwigo.MessageBox{
			Text = (((_wUHG("\016\011\090\080\122\055\039\070\080\011\122\122\080\004\088\070\080").._jO14t).._wUHG("\080\092\004\080")).._OJ_6.Name).._wUHG("\101"), 
			Media = _P0Yz, 
			Callback = function(action)
				if action ~= nil then
					if _FWt == 2 then
						Wherigo.Command "StopSound"
						_Urwigo.MessageBox{
							Text = _wUHG("\016\011\090\080\088\055\004\080\103\039\092\065\032\070\065\061\004\070\055\065\038"), 
							Media = _A8tV4, 
							Callback = function(action)
								if action ~= nil then
									_FWt = 1
									_jO14t = _wUHG("\070\008\052\053\080\039\011\090\065\110\080")
									Wherigo.PlayAudio(_Ks4)
									_Urwigo.MessageBox{
										Text = _wUHG("\056\080\045\090\039\061\004\080\011\122\080\122\028\092\008\070\080\061\088\011\011\004\061\080\090\052\080\055\065\080\004\088\070\080\092\055\039\080\092\065\110\080\053\011\090\080\061\070\070\080\103\039\092\065\032\070\065\061\004\070\055\065\080\110\055\061\092\052\052\070\092\039\080\045\092\034\032\080\055\065\004\011\080\004\088\070\080\090\065\110\070\039\125\011\039\028\110\101"), 
										Media = _OqK, 
										Callback = function(action)
											if action ~= nil then
												Wherigo.Command "StopSound"
												_Urwigo.MessageBox{
													Text = _wUHG("\002\011\011\110\080\077\011\045\080\032\055\110\038\080\016\011\090\080\079\011\004\080\103\039\092\065\032\070\065\061\004\070\055\065\038\080\012\070\004\061\080\079\011\080\079\070\004\080\004\088\070\080\039\070\061\004\080\011\122\080\004\088\070\080\008\011\065\061\004\070\039\061\080\065\011\125\038"), 
													Media = _8rY, 
													Callback = function(action)
														if action ~= nil then
															_YSdB6 = _YSdB6 + 1
															_8he()
															_dsaI5()
															Wherigo.ShowScreen(Wherigo.MAINSCREEN)
															_3TM:RequestSync()
														end
													end
												}
											end
										end
									}
								end
							end
						}
					else
						_Urwigo.MessageBox{
							Text = (_wUHG("\097\011\004\088\055\065\079\080\088\092\052\052\070\065\061\031\080\052\070\039\088\092\052\061\080\004\088\070\080").._jO14t).._wUHG("\080\110\011\070\061\080\065\011\004\080\092\122\122\070\034\004\080\122\039\092\065\032\070\065\061\004\070\055\065\101\080"), 
							Media = _FKO, 
							Callback = function(action)
								if action ~= nil then
									Wherigo.Command "StopSound"
									_jO14t = _wUHG("\070\008\052\004\053\080\039\011\090\065\110\080")
									_893()
									_8he()
									Wherigo.ShowScreen(Wherigo.MAINSCREEN)
									_3TM:RequestSync()
								end
							end
						}
					end
				end
			end
		}
	elseif target == _cqW then
		Wherigo.PlayAudio(_jSYj)
		_8Qx()
		_Urwigo.MessageBox{
			Text = (((_wUHG("\016\011\090\080\122\055\039\070\080\011\122\122\080\004\088\070\080").._jO14t).._wUHG("\080\092\004\080")).._cqW.Name).._wUHG("\101"), 
			Media = _P0Yz, 
			Callback = function(action)
				if action ~= nil then
					Wherigo.Command "StopSound"
					if ((_opZu == 2) or (_OYj == 2)) or (_g8c == 2) then
						Wherigo.PlayAudio(_TyD)
						_oUP = _oUP + 1
						_893()
						_jO14t = _wUHG("\070\008\052\053\080\039\011\090\065\110\080")
						_Urwigo.MessageBox{
							Text = _wUHG("\016\011\090\080\088\055\004\080\107\039\092\034\090\028\092\038\080\047\070\080\088\055\061\061\070\061\080\092\004\080\053\011\090\080\045\090\004\080\055\061\080\065\011\004\080\110\070\092\110\080\053\070\004\101"), 
							Media = _M3H, 
							Callback = function(action)
								if action ~= nil then
									_8he()
									Wherigo.Command "StopSound"
									if _oUP == 4 then
										Wherigo.PlayAudio(_Ks4)
										_8Qx()
										_Urwigo.MessageBox{
											Text = _wUHG("\107\039\092\034\090\028\092\080\122\055\065\092\028\028\053\080\122\092\028\028\061\080\004\011\080\004\088\070\080\079\039\011\090\065\110\080\092\065\110\080\092\080\052\055\028\028\092\039\080\011\122\080\061\008\011\032\070\080\061\088\011\011\004\061\080\090\052\080\122\039\011\008\080\125\088\070\039\070\080\088\070\080\061\004\011\011\110\101\080\016\011\090\080\088\092\100\070\080\110\070\122\070\092\004\070\110\080\107\039\092\034\090\028\092\038\038\038"), 
											Media = _OqK, 
											Callback = function(action)
												if action ~= nil then
													Wherigo.Command "StopSound"
													Wherigo.PlayAudio(_Je8Z)
													_Urwigo.MessageBox{
														Text = _wUHG("\016\011\090\080\088\070\092\039\080\092\080\079\039\070\092\004\080\088\011\028\028\011\125\055\065\079\080\125\055\065\110\080\092\061\080\092\080\052\011\039\004\092\028\080\011\052\070\065\061\080\090\052\080\055\065\080\004\088\070\080\092\055\039\101\080\094\088\070\080\028\092\061\004\080\039\070\008\092\055\065\061\080\011\122\080\004\088\070\080\008\011\065\061\004\070\039\061\080\079\011\070\061\080\061\088\011\011\004\055\065\079\080\004\088\039\011\090\079\088\080\004\088\070\080\052\011\039\004\092\028\080\092\065\110\080\045\092\034\032\080\055\065\004\011\080\004\088\070\080\090\065\110\070\039\125\011\039\028\110\101"), 
														Media = _hBLKX, 
														Buttons = {
															_wUHG("\069\055\034\004\011\039\053\038")
														}, 
														Callback = function(action)
															if action ~= nil then
																_Urwigo.MessageBox{
																	Text = (_wUHG("\016\011\090\080\110\055\110\080\055\004\080")..Player.Name).._wUHG("\038\080\016\011\090\080\122\055\065\092\028\028\053\080\110\070\122\070\092\004\070\110\080\092\028\028\080\011\122\080\004\088\070\080\008\011\065\061\004\070\039\061\038\080\048\080\110\055\110\065\096\004\080\004\088\055\065\032\080\055\004\080\125\092\061\080\052\011\061\061\055\045\028\070\101\080\056\061\080\092\080\061\052\070\034\055\092\028\080\039\070\125\092\039\110\080\048\080\088\092\100\070\080\028\070\122\004\080\053\011\090\080\061\011\008\070\004\088\055\065\079\080\110\011\125\065\080\045\053\080\004\088\070\080\034\070\008\070\004\070\039\053\101\080\094\088\070\080\034\011\011\039\110\055\065\092\004\070\061\080\092\039\070\080\055\065\080\053\011\090\039\080\055\065\100\070\065\004\011\039\053\101\080\094\088\092\065\032\061\080\092\079\092\055\065\038"), 
																	Media = _8rY, 
																	Buttons = {
																		_wUHG("\047\011\011\039\092\053\038\038\038")
																	}, 
																	Callback = function(action)
																		if action ~= nil then
																			_RkX.Complete = true
																			_8GZ.Active = true
																			_L6N.Active = false
																			_P0O6:MoveTo(Player)
																			_893()
																			Wherigo.ShowScreen(Wherigo.MAINSCREEN)
																			_3TM:RequestSync()
																			Wherigo.Command "StopSound"
																		end
																	end
																}
															end
														end
													}
												end
											end
										}
									end
								end
							end
						}
					else
						_Urwigo.MessageBox{
							Text = (_wUHG("\097\011\004\088\055\065\079\080\088\092\052\052\070\065\061\031\080\052\070\039\088\092\052\061\080\004\088\070\080").._jO14t).._wUHG("\080\110\011\070\061\080\065\011\004\080\092\122\122\070\034\004\080\107\039\092\034\090\028\092\101\080"), 
							Media = _FKO, 
							Callback = function(action)
								if action ~= nil then
									Wherigo.Command "StopSound"
									_jO14t = _wUHG("\070\008\052\004\053\080\039\011\090\065\110\080")
									_893()
									_8he()
									Wherigo.ShowScreen(Wherigo.MAINSCREEN)
									_3TM:RequestSync()
								end
							end
						}
					end
				end
			end
		}
	elseif target == _KDM0 then
		Wherigo.PlayAudio(_jSYj)
		_8Qx()
		_Urwigo.MessageBox{
			Text = (((_wUHG("\016\011\090\080\122\055\039\070\080\011\122\122\080\004\088\070\080").._jO14t).._wUHG("\080\092\004\080\004\088\070\080")).._KDM0.Name).._wUHG("\101"), 
			Media = _P0Yz, 
			Callback = function(action)
				if action ~= nil then
					Wherigo.Command "StopSound"
					if _g8c == 2 then
						_Urwigo.MessageBox{
							Text = _wUHG("\016\011\090\080\088\055\004\080\004\088\070\080\116\090\008\008\053\038"), 
							Media = _neOjQ, 
							Callback = function(action)
								if action ~= nil then
									_g8c = 1
									_jO14t = _wUHG("\080\070\008\052\053\080\039\011\090\065\110\080")
									Wherigo.PlayAudio(_Ks4)
									_Urwigo.MessageBox{
										Text = _wUHG("\094\088\070\080\116\090\008\008\053\080\055\061\080\052\092\039\092\028\053\119\070\110\080\045\053\080\004\088\070\080\088\011\028\053\080\061\053\008\045\011\028\080\092\065\110\080\088\070\080\061\088\011\011\004\061\080\090\052\080\055\065\080\092\080\034\028\011\090\110\080\011\122\080\110\090\061\004\101"), 
										Media = _Xho4, 
										Callback = function(action)
											if action ~= nil then
												Wherigo.Command "StopSound"
												_Urwigo.MessageBox{
													Text = _wUHG("\002\011\011\110\080\077\011\045\080\032\055\110\038\080\016\011\090\080\079\011\004\080\004\088\070\080\116\090\008\008\053\038\080\012\070\004\061\080\079\011\080\079\070\004\080\004\088\070\080\039\070\061\004\080\011\122\080\004\088\070\080\008\011\065\061\004\070\039\061\080\065\011\125\038"), 
													Media = _8rY, 
													Callback = function(action)
														if action ~= nil then
															_YSdB6 = _YSdB6 + 1
															_8he()
															_dsaI5()
															Wherigo.ShowScreen(Wherigo.MAINSCREEN)
															_3TM:RequestSync()
														end
													end
												}
											end
										end
									}
								end
							end
						}
					else
						_Urwigo.MessageBox{
							Text = (_wUHG("\097\011\004\088\055\065\079\080\088\092\052\052\070\065\061\031\080\052\070\039\088\092\052\061\080\004\088\070\080").._jO14t).._wUHG("\080\110\011\070\061\080\065\011\004\080\092\122\122\070\034\004\080\004\088\070\080\116\090\008\008\053\101\080"), 
							Media = _FKO, 
							Callback = function(action)
								if action ~= nil then
									_jO14t = _wUHG("\070\008\052\004\053\080\039\011\090\065\110\080")
									_893()
									_8he()
									Wherigo.ShowScreen(Wherigo.MAINSCREEN)
									_3TM:RequestSync()
									Wherigo.Command "StopSound"
								end
							end
						}
					end
				end
			end
		}
	elseif target == _r1e5 then
		if _OYj == 2 then
			Wherigo.PlayAudio(_jSYj)
			_Urwigo.MessageBox{
				Text = _wUHG("\002\092\039\028\055\034\038\080\016\011\090\080\045\039\011\090\079\088\004\080\008\070\080\079\092\039\028\055\034\101\080\048\080\032\065\070\125\080\053\011\090\080\034\011\090\028\110\080\110\011\080\055\004\101\080\094\088\055\061\080\055\061\080\077\090\061\004\080\125\088\092\004\080\048\080\125\092\065\004\070\110\101\080\007\051\028\055\008\070\039\080\107\092\065\034\055\065\079\117\080\047\092\052\052\053\080\088\092\052\052\053\038\080\077\011\053\080\077\011\053\038\080\047\092\052\052\053\080\088\092\052\052\053\038\080\077\011\053\080\077\011\053\038\080\048\004\096\061\080\008\053\080\088\092\052\052\053\080\110\092\065\034\070\101\080\048\004\061\080\008\053\080\088\092\052\052\053\080\110\092\065\034\070\101\080\037\065\045\061\052\089\087\126\107"), 
				Media = _WZO, 
				Callback = function(action)
					if action ~= nil then
						_jO14t = _wUHG("\070\008\052\053\080\039\011\090\065\110\080")
						_893()
						_Qi2QN.Active = false
						Wherigo.Command "StopSound"
						Wherigo.ShowScreen(Wherigo.MAINSCREEN)
						_3TM:RequestSync()
					end
				end
			}
		else
			Wherigo.PlayAudio(_eUqyr)
			_Urwigo.MessageBox{
				Text = _wUHG("\003\090\034\088\038\080\107\011\065\096\004\080\061\088\011\011\004\080\008\070\101"), 
				Media = _WZO, 
				Callback = function(action)
					if action ~= nil then
						Wherigo.Command "StopSound"
						Wherigo.ShowScreen(Wherigo.MAINSCREEN)
					end
				end
			}
		end
	end
end
function _G5Kbn:On_t4h(target)
	Wherigo.PlayAudio(_5bq)
	_Urwigo.MessageBox{
		Text = _wUHG("\094\088\070\080\043\101\123\101\108\080\008\070\004\070\039\080\045\070\079\055\065\061\080\004\011\080\079\028\011\125\101\080\048\004\080\055\061\080\065\011\125\080\004\090\039\065\070\110\080\011\065\080\092\065\110\080\039\070\092\110\053\080\004\011\080\122\011\039\080\090\061\070\101"), 
		Media = _zHI, 
		Buttons = {
			_wUHG("\020\011\011\028\038")
		}, 
		Callback = function(action)
			if action ~= nil then
				_G5Kbn.Description = _wUHG("\094\088\070\080\043\101\123\101\108\080\008\070\004\070\039\080\055\061\080\052\011\125\070\039\070\110\080\011\065\101")
				_G5Kbn.Commands._t4h.Enabled = false
				_pI6.ProximityRange = Distance(178, "meters")
				_L6N.ProximityRange = Distance(178, "meters")
				_GybL.ProximityRange = Distance(178, "meters")
				_GybL.Active = true
				_L6N.Active = true
				_pI6.Active = true
				_pI6.Visible = false
				_L6N.Visible = false
				_GybL.Visible = false
				_cqW.Visible = false
				_OJ_6.Visible = false
				_KDM0.Visible = false
				_Lrd.Visible = false
				Wherigo.ShowScreen(Wherigo.MAINSCREEN)
				Wherigo.Command "StopSound"
				_3TM:RequestSync()
			end
		end
	}
end
function _fvthx:On_Bn3k(target)
	_Urwigo.RunDialogs(function()
		Wherigo.GetInput(_02L)
	end)
end
function _b_1E:On_r2yuN(target)
	_pI6.Visible = true
	_Qi2QN.Active = true
	_pI6.Active = true
	_GybL.Active = true
	_IG1.Active = true
	_fvthx:MoveTo(Player)
	_P0O6:MoveTo(Player)
	_3mKU3:MoveTo(Player)
	_8GZ.Active = true
	_PfkVz:MoveTo(Player)
	_G5Kbn:MoveTo(Player)
	_IG1.Visible = true
	_L6N.Visible = true
	_GybL.Visible = true
end
function _P0O6:On_0BJj(target)
	_Urwigo.MessageBox{
		Text = _wUHG("\094\088\070\080\079\070\011\034\092\034\088\070\080\055\061\080\028\011\034\092\004\070\110\080\092\004\080\097\080\078\029\080\078\027\101\102\029\057\080\115\080\063\057\080\060\027\101\063\027\067\101\080\051\070\092\039\034\088\080\004\088\070\080\088\011\065\070\053\061\090\034\032\028\070\080\004\039\070\070\080\055\065\080\004\088\070\080\079\039\011\100\070\101\080\016\011\090\080\092\039\070\080\028\011\011\032\055\065\079\080\122\011\039\080\092\065\080\070\021\004\039\092\126\028\092\039\079\070\080\045\055\061\011\065\080\004\090\045\070\080\092\004\080\004\088\070\080\045\092\061\070\080\011\122\080\004\088\070\080\004\088\039\070\070\080\004\039\090\065\032\080\004\039\070\070\101"), 
		Media = _SFTR, 
		Callback = function(action)
			if action ~= nil then
				Wherigo.ShowScreen(Wherigo.MAINSCREEN)
				_3TM:RequestSync()
			end
		end
	}
end
function _cSRB:On_qGE6(target)
	_Urwigo.RunDialogs(function()
		Wherigo.GetInput(__cPS)
	end)
end
function _Urwigo.GlobalZoneActiveChanged()
	if _YSdB6 == 4 then
		_Urwigo.MessageBox{
			Text = _wUHG("\115\011\125\031\080\053\011\090\080\079\011\004\080\092\028\028\080\011\122\080\004\088\070\080\008\011\065\061\004\070\039\061\038\080\048\004\080\028\011\011\032\061\080\028\055\032\070\080\004\088\070\039\070\080\055\061\080\011\065\070\080\028\092\061\004\080\008\011\065\061\004\070\039\080\004\088\011\090\079\088\101\080\107\039\092\034\090\028\092\080\088\092\061\080\092\052\052\070\092\039\070\110\080\092\065\110\080\088\070\080\055\061\080\011\100\070\039\080\011\065\080\004\088\070\080\008\092\055\065\080\061\004\092\079\070\101\080"), 
			Media = _8rY, 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.MessageBox{
						Text = _wUHG("\016\011\090\080\008\092\053\080\088\092\100\070\080\004\011\080\090\061\070\080\070\021\004\039\092\080\008\070\092\061\090\039\070\061\080\004\011\080\110\070\122\070\092\004\080\088\055\008\101\080\094\039\053\080\125\088\055\034\088\070\100\070\039\080\092\008\008\011\080\053\011\090\080\004\088\055\065\032\080\008\055\079\088\004\080\125\011\039\032\080\011\065\080\088\055\008\101"), 
						Media = _8rY, 
						Callback = function(action)
							if action ~= nil then
								_L6N.Active = true
								Wherigo.ShowScreen(Wherigo.MAINSCREEN)
								_3TM:RequestSync()
							end
						end
					}
				end
			end
		}
	end
end

-- Urwigo functions --
function _XmK()
	_cqW.Visible = true
	_OJ_6.Visible = true
	_KDM0.Visible = true
	_Lrd.Visible = true
end
function _dsaI5()
	if _YSdB6 == 4 then
		_fCWt.Complete = true
		_Urwigo.MessageBox{
			Text = _wUHG("\115\011\125\031\080\053\011\090\080\079\011\004\080\092\028\028\080\011\122\080\004\088\070\080\008\011\065\061\004\070\039\061\038\080\056\080\065\070\125\080\008\011\065\061\004\070\039\080\088\092\061\080\092\052\052\070\092\039\070\110\080\004\088\011\090\079\088\101\080\107\039\092\034\090\028\092\080\055\061\080\011\100\070\039\080\055\065\080\004\088\070\080\004\088\070\092\004\039\070\038"), 
			Media = _8rY, 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.MessageBox{
						Text = _wUHG("\115\092\004\034\088\011\090\004\031\080\053\011\090\080\008\092\053\080\088\092\100\070\080\004\011\080\090\061\070\080\070\021\004\039\092\080\008\070\092\061\090\039\070\061\080\004\011\080\110\070\122\070\092\004\080\088\055\008\101\080\094\039\053\080\125\088\055\034\088\070\100\070\039\080\092\008\008\011\080\053\011\090\080\004\088\055\065\032\080\008\055\079\088\004\080\125\011\039\032\080\011\065\080\088\055\008\101"), 
						Media = _8rY, 
						Buttons = {
							_wUHG("\056\008\008\011\058\080\048\080\079\011\004\080\004\088\055\061")
						}, 
						Callback = function(action)
							if action ~= nil then
								_YSdB6 = 0
								_IG1.Active = false
								_pI6.Active = false
								_GybL.Active = false
								_L6N.Active = true
								_L6N.Visible = true
								_RkX.Active = false
								Wherigo.ShowScreen(Wherigo.MAINSCREEN)
								_3TM:RequestSync()
							end
						end
					}
				end
			end
		}
	end
end
function _xJx4()
	Wherigo.PlayAudio(_KfI)
	_Urwigo.MessageBox{
		Text = _wUHG("\016\011\090\039\080\043\101\123\101\108\080\008\070\004\070\039\080\061\004\092\039\004\061\080\004\011\080\125\088\055\039\028\080\028\055\032\070\080\034\039\092\119\053\101\080\094\088\070\039\070\080\092\039\070\080\008\011\065\061\004\070\039\061\080\065\070\092\039\045\053\038"), 
		Media = _zHI, 
		Callback = function(action)
			if action ~= nil then
				_HuUCE.Complete = true
				Wherigo.Command "StopSound"
				_Urwigo.MessageBox{
					Text = _wUHG("\069\070\039\053\080\065\055\034\070\038\080\016\011\090\080\088\092\100\070\080\122\011\090\065\110\080\004\088\070\080\008\011\065\061\004\070\039\061\101\080\048\004\080\028\011\011\032\061\080\028\055\032\070\080\103\039\092\065\032\070\065\061\004\070\055\065\031\080\115\011\028\122\008\092\065\080\092\065\110\080\004\088\070\080\116\090\008\008\053\080\092\039\070\080\092\028\028\080\065\070\092\039\045\053\101\080\016\011\090\080\125\055\028\028\080\065\070\070\110\080\092\080\125\070\092\052\011\065\080\004\011\080\122\055\079\088\004\080\004\088\070\008\101\080\094\092\032\070\080\004\088\055\061\080\008\011\065\061\004\070\039\080\052\088\092\061\070\080\079\090\065\101"), 
					Media = _8rY, 
					Callback = function(action)
						if action ~= nil then
							Wherigo.PlayAudio(_jAiQe)
							_Urwigo.MessageBox{
								Text = "", 
								Media = _nszd, 
								Callback = function(action)
									if action ~= nil then
										_PfkVz:MoveTo(Player)
										_Urwigo.MessageBox{
											Text = _wUHG("\016\011\090\080\125\055\028\028\080\092\028\061\011\080\065\070\070\110\080\092\008\008\090\065\055\004\055\011\065\101\080\047\070\092\110\080\011\100\070\039\080\004\011\080\004\088\070\080\034\011\065\034\070\061\061\055\011\065\080\061\004\092\065\110\101\080\048\080\088\092\100\070\080\092\080\122\039\055\070\065\110\080\125\088\011\080\048\080\004\088\055\065\032\080\008\092\053\080\045\070\080\092\045\028\070\080\004\011\080\088\070\028\052\080\053\011\090\101"), 
											Media = _8rY, 
											Callback = function(action)
												if action ~= nil then
													_GybL.ProximityRange = Distance(8, "meters")
													_pI6.ProximityRange = Distance(8, "meters")
													_IG1.ProximityRange = Distance(8, "meters")
													_L6N.ProximityRange = Distance(8, "meters")
													_IG1.Active = false
													_pI6.Active = false
													_GybL.Active = false
													_L6N.Active = false
													_d39a.Active = false
													_Qi2QN.Active = true
													_ROl6y = 2
													_Tt4tC = 2
													_aQF = 2
													_CgQ = 2
													_TFC = 2
													Wherigo.ShowScreen(Wherigo.MAINSCREEN)
													_3TM:RequestSync()
												end
											end
										}
									end
								end
							}
						end
					end
				}
			end
		end
	}
end
function _893()
	_kKMo = 1
	_OYj = 1
	_g8c = 1
	_FWt = 1
	_opZu = 1
end
function _8Qx()
	_TFC = 3
	_CgQ = 3
	_aQF = 3
	_Tt4tC = 3
end
function _8he()
	_TFC = 2
	_CgQ = 2
	_aQF = 2
	_Tt4tC = 2
	_dsaI5()
end

-- Begin user functions --
-- End user functions --
return _3TM
