require "Wherigo"
ZonePoint = Wherigo.ZonePoint
Distance = Wherigo.Distance
Player = Wherigo.Player

-- #Author Directives Go Here# --
require "math"
-- #End Author Directives# --

cartDasHausvonNikolaus = Wherigo.ZCartridge()

-- MessageBox Callback Functions Table used by the Builder --
cartDasHausvonNikolaus.MsgBoxCBFuncs = {}

zmediaTitel = Wherigo.ZMedia(cartDasHausvonNikolaus)
zmediaTitel.Name="Titel"
zmediaTitel.Description=""
zmediaTitel.AltText=""
zmediaTitel.Id="59aacdc2-8546-40bc-a325-5862a4b123f8"
zmediaTitel.Resources = {
{ Type = "jpg", Filename = "titel.JPG", Directives = {},},
}
zmediaHaus1 = Wherigo.ZMedia(cartDasHausvonNikolaus)
zmediaHaus1.Name="Haus1"
zmediaHaus1.Description=""
zmediaHaus1.AltText=""
zmediaHaus1.Id="9cd5ad36-32ad-45f2-87cd-6cbf1631372f"
zmediaHaus1.Resources = {
{ Type = "jpg", Filename = "Haus1.jpg", Directives = {},},
}
zmediaHaus2 = Wherigo.ZMedia(cartDasHausvonNikolaus)
zmediaHaus2.Name="Haus2"
zmediaHaus2.Description=""
zmediaHaus2.AltText=""
zmediaHaus2.Id="f09fd86e-b135-40b4-96d1-5c007eef54c7"
zmediaHaus2.Resources = {
{ Type = "jpg", Filename = "Haus2.jpg", Directives = {},},
}
zmediaGewonnen = Wherigo.ZMedia(cartDasHausvonNikolaus)
zmediaGewonnen.Name="Gewonnen"
zmediaGewonnen.Description=""
zmediaGewonnen.AltText=""
zmediaGewonnen.Id="df992b28-aebc-4f23-8eb6-e8c5a9c547b8"
zmediaGewonnen.Resources = {
{ Type = "jpg", Filename = "gewonnen.JPG", Directives = {},},
}
zmediawieweiter = Wherigo.ZMedia(cartDasHausvonNikolaus)
zmediawieweiter.Name="wieweiter"
zmediawieweiter.Description=""
zmediawieweiter.AltText=""
zmediawieweiter.Id="3dbbb33a-198b-44a0-8c96-1f5695e9f6bc"
zmediawieweiter.Resources = {
{ Type = "jpg", Filename = "wieweiter.JPG", Directives = {},},
}
zmediaVerloren = Wherigo.ZMedia(cartDasHausvonNikolaus)
zmediaVerloren.Name="Verloren"
zmediaVerloren.Description=""
zmediaVerloren.AltText=""
zmediaVerloren.Id="7c266e4b-3535-4cb6-85be-e03324a64cac"
zmediaVerloren.Resources = {
{ Type = "jpg", Filename = "verloren.JPG", Directives = {},},
}
zmediastartscreen = Wherigo.ZMedia(cartDasHausvonNikolaus)
zmediastartscreen.Name="startscreen"
zmediastartscreen.Description=""
zmediastartscreen.AltText=""
zmediastartscreen.Id="492835e8-19a3-4699-a28c-7efc8b68b7ae"
zmediastartscreen.Resources = {
{ Type = "jpg", Filename = "start.jpg", Directives = {},},
}
-- Cartridge Info --
cartDasHausvonNikolaus.Id="d0c656ce-ab0b-4888-908a-0dbf59da23cc"
cartDasHausvonNikolaus.Name="La Maison de Saint-Nicolas"
cartDasHausvonNikolaus.Description=[[Jouer partout: Dessinez la Maison de Saint-Nicolas d'un seul trait. Un jeu facile. Cette cartouche a ete concue et programmee par espe2310 qui a genereusement accepte que je puisse la traduire et l'utiliser pour une cache Wherigo qui m'appartient.
Dessinez la Maison de Saint-Nicolas d'un seul trait et obtenez les coordonnees necessaires pour trouver la cache associee au jeu.
Si vous etes eloigne, il est quand meme possible de la jouer par pur plaisir.
Amusez-vous bien! ]]
cartDasHausvonNikolaus.Visible=true
cartDasHausvonNikolaus.Activity="Geocache"
cartDasHausvonNikolaus.StartingLocationDescription=[[Chicoutimi, Quebec, Canada]]
cartDasHausvonNikolaus.StartingLocation = Wherigo.INVALID_ZONEPOINT
cartDasHausvonNikolaus.Version="1.1_fr"
cartDasHausvonNikolaus.Company=""
cartDasHausvonNikolaus.Author="Danatisy (espe2310)"
cartDasHausvonNikolaus.BuilderVersion="2.0.5129.5086"
cartDasHausvonNikolaus.CreateDate="01/26/2011 8:36:43 PM"
cartDasHausvonNikolaus.PublishDate="1/1/0001 12:00:00 AM"
cartDasHausvonNikolaus.UpdateDate="01/29/2011 09:16:15 PM"
cartDasHausvonNikolaus.LastPlayedDate="1/1/0001 12:00:00 AM"
cartDasHausvonNikolaus.TargetDevice="PocketPC"
cartDasHausvonNikolaus.TargetDeviceVersion="0"
cartDasHausvonNikolaus.StateId="1"
cartDasHausvonNikolaus.CountryId="2"
cartDasHausvonNikolaus.Complete=false
cartDasHausvonNikolaus.UseLogging=true
cartDasHausvonNikolaus.Media=zmediastartscreen

-- Zones --
zoneA = Wherigo.Zone(cartDasHausvonNikolaus)
zoneA.Id="b1894114-2088-4f3b-be0c-b07216e3873f"
zoneA.Name="A"
zoneA.Description=[[]]
zoneA.Visible=true
zoneA.DistanceRange = Distance(-1, "feet")
zoneA.ShowObjects="OnEnter"
zoneA.ProximityRange = Distance(0, "feet")
zoneA.AllowSetPositionTo=false
zoneA.Active=false
zoneA.Points = {
  ZonePoint(50.59001,6.64998,0),
  ZonePoint(50.59001,6.65002,0),
  ZonePoint(50.58999,6.65002,0),
  ZonePoint(50.58999,6.64998,0)
}
zoneA.OriginalPoint = ZonePoint(50.59,6.65,0)
zoneA.DistanceRangeUOM = "Feet"
zoneA.ProximityRangeUOM = "Feet"
zoneA.OutOfRangeName = ""
zoneA.InRangeName = ""
zoneA.Media=zmediaHaus1

zoneB = Wherigo.Zone(cartDasHausvonNikolaus)
zoneB.Id="460b87d3-5313-4ca5-8fad-7ecf8262c855"
zoneB.Name="B"
zoneB.Description=[[]]
zoneB.Visible=true
zoneB.DistanceRange = Distance(-1, "feet")
zoneB.ShowObjects="OnEnter"
zoneB.ProximityRange = Distance(0, "feet")
zoneB.AllowSetPositionTo=false
zoneB.Active=false
zoneB.Points = {
  ZonePoint(50.59001,6.65098,0),
  ZonePoint(50.59001,6.65102,0),
  ZonePoint(50.58999,6.65102,0),
  ZonePoint(50.58999,6.65098,0)
}
zoneB.OriginalPoint = ZonePoint(50.59,6.651,0)
zoneB.DistanceRangeUOM = "Feet"
zoneB.ProximityRangeUOM = "Feet"
zoneB.OutOfRangeName = ""
zoneB.InRangeName = ""
zoneB.Media=zmediaHaus1

zoneC = Wherigo.Zone(cartDasHausvonNikolaus)
zoneC.Id="e99ca1cd-f81e-4273-babe-99bfba491b08"
zoneC.Name="C"
zoneC.Description=[[]]
zoneC.Visible=true
zoneC.DistanceRange = Distance(-1, "feet")
zoneC.ShowObjects="OnEnter"
zoneC.ProximityRange = Distance(0, "feet")
zoneC.AllowSetPositionTo=false
zoneC.Active=false
zoneC.Points = {
  ZonePoint(50.59101,6.64998,0),
  ZonePoint(50.59101,6.65002,0),
  ZonePoint(50.59099,6.65002,0),
  ZonePoint(50.59099,6.64998,0)
}
zoneC.OriginalPoint = ZonePoint(50.591,6.65,0)
zoneC.DistanceRangeUOM = "Feet"
zoneC.ProximityRangeUOM = "Feet"
zoneC.OutOfRangeName = ""
zoneC.InRangeName = ""
zoneC.Media=zmediaHaus1

zoneD = Wherigo.Zone(cartDasHausvonNikolaus)
zoneD.Id="047aa18f-9e38-4f28-b525-9c220808c146"
zoneD.Name="D"
zoneD.Description=[[]]
zoneD.Visible=true
zoneD.DistanceRange = Distance(-1, "feet")
zoneD.ShowObjects="OnEnter"
zoneD.ProximityRange = Distance(0, "feet")
zoneD.AllowSetPositionTo=false
zoneD.Active=false
zoneD.Points = {
  ZonePoint(50.59101,6.65098,0),
  ZonePoint(50.59101,6.65102,0),
  ZonePoint(50.59099,6.65102,0),
  ZonePoint(50.59099,6.65098,0)
}
zoneD.OriginalPoint = ZonePoint(50.591,6.651,0)
zoneD.DistanceRangeUOM = "Feet"
zoneD.ProximityRangeUOM = "Feet"
zoneD.OutOfRangeName = ""
zoneD.InRangeName = ""
zoneD.Media=zmediaHaus1

zoneE = Wherigo.Zone(cartDasHausvonNikolaus)
zoneE.Id="1f10c2f8-326b-40de-b67a-f87fc1c3c2a5"
zoneE.Name="E"
zoneE.Description=[[]]
zoneE.Visible=true
zoneE.DistanceRange = Distance(-1, "feet")
zoneE.ShowObjects="OnEnter"
zoneE.ProximityRange = Distance(0, "feet")
zoneE.AllowSetPositionTo=false
zoneE.Active=false
zoneE.Points = {
  ZonePoint(50.59051,6.65185,0),
  ZonePoint(50.59051,6.65188,0),
  ZonePoint(50.59049,6.65188,0),
  ZonePoint(50.59049,6.65185,0)
}
zoneE.OriginalPoint = ZonePoint(50.5905,6.651866,0)
zoneE.DistanceRangeUOM = "Feet"
zoneE.ProximityRangeUOM = "Feet"
zoneE.OutOfRangeName = ""
zoneE.InRangeName = ""
zoneE.Media=zmediaHaus1

-- Characters --

-- Items --
zitemSetzePunktA = Wherigo.ZItem(cartDasHausvonNikolaus)
zitemSetzePunktA.Id="3dee60fe-6c96-4ab2-96b4-931c0861cce0"
zitemSetzePunktA.Name="Marquer Point A"
zitemSetzePunktA.Description=[[Trouvez un endroit pour le point de depart A qui sera celui du coin inferieur gauche de la Maison.]]
zitemSetzePunktA.Visible=true
zitemSetzePunktA.ObjectLocation = Wherigo.INVALID_ZONEPOINT
zitemSetzePunktA.Media=zmediaHaus1
zitemSetzePunktA.Locked = false
zitemSetzePunktA.Opened = false
zitemSetzePunktA.Commands = {
  Speichern = Wherigo.ZCommand{Text="Marquer", CmdWith=false, Enabled=true, EmptyTargetListText="Rien de disponible"},
}
zitemSetzePunktA.Commands.Speichern.Custom = true
zitemSetzePunktA.Commands.Speichern.Id="e870cbad-073d-4944-a39c-4a90733cc4e7"
zitemSetzePunktA.Commands.Speichern.WorksWithAll = true

zitemSetzePunktB = Wherigo.ZItem(cartDasHausvonNikolaus)
zitemSetzePunktB.Id="2586efca-de16-4e6d-abd0-f85ac5b77507"
zitemSetzePunktB.Name="Marquer Point B"
zitemSetzePunktB.Description=[[Maintenant, pour tracer la ligne de base, trouvons un endroit pour le Point B, soit le coin inferieur droit.]]
zitemSetzePunktB.Visible=true
zitemSetzePunktB.ObjectLocation = Wherigo.INVALID_ZONEPOINT
zitemSetzePunktB.Media=zmediaHaus2
zitemSetzePunktB.Locked = false
zitemSetzePunktB.Opened = false
zitemSetzePunktB.Commands = {
  Speichern = Wherigo.ZCommand{Text="Marquer", CmdWith=false, Enabled=true, EmptyTargetListText="Rien de disponible"},
}
zitemSetzePunktB.Commands.Speichern.Custom = true
zitemSetzePunktB.Commands.Speichern.Id="5d621557-a6d6-4091-bc0f-1e72c1f33c31"
zitemSetzePunktB.Commands.Speichern.WorksWithAll = true

zitemOptionen = Wherigo.ZItem(cartDasHausvonNikolaus)
zitemOptionen.Id="216071aa-0cd5-4b7f-b3c6-9248f30bc84d"
zitemOptionen.Name="Options"
zitemOptionen.Description=[[La surface de la zone est 8 par defaut, ce qui veut dire que le rayon est 1/8 de la longueur de la ligne de base. Vous pouvez augmenter la surface en entrant une valeur inferieure si necessaire..]]
zitemOptionen.Visible=true
zitemOptionen.ObjectLocation = Wherigo.INVALID_ZONEPOINT
zitemOptionen.Locked = false
zitemOptionen.Opened = false
zitemOptionen.Commands = {
  SetzeZonengroesse = Wherigo.ZCommand{Text="Surface de la zone", CmdWith=false, Enabled=true, EmptyTargetListText="Rien de disponible"},
}
zitemOptionen.Commands.SetzeZonengroesse.Custom = true
zitemOptionen.Commands.SetzeZonengroesse.Id="ccbec931-cd63-47a2-af89-323e32c3449e"
zitemOptionen.Commands.SetzeZonengroesse.WorksWithAll = true

-- Tasks --
ztaskZeichnedasHaus = Wherigo.ZTask(cartDasHausvonNikolaus)
ztaskZeichnedasHaus.Id="d99cfc3e-7da9-4982-9b1a-75c408fb00e5"
ztaskZeichnedasHaus.Name="Dessinez la Maison"
ztaskZeichnedasHaus.Description=[[Dessinez la Maison d'un seul trait! La ligne de base est deja tracee. Il reste donc 12 possibilites.

Les enfants allemands disent les mots suivants en dessinant la Maison:
Das - ist - das - Haus - von - Ni - ko - laus
(La - mai - son - de - Saint - Ni - co - las)

Ce ne peut etre difficille :-)]]
ztaskZeichnedasHaus.Visible=true
ztaskZeichnedasHaus.Media=zmediastartscreen
ztaskZeichnedasHaus.Active=true
ztaskZeichnedasHaus.Complete=false
ztaskZeichnedasHaus.CorrectState = "None"

ztaskStartedieCartridgeneu = Wherigo.ZTask(cartDasHausvonNikolaus)
ztaskStartedieCartridgeneu.Id="35f7bded-58cd-44dc-8e32-cf25ffa4d08c"
ztaskStartedieCartridgeneu.Name="Redemarrez la cartouche!!!"
ztaskStartedieCartridgeneu.Description=[[Desole! Vous devrez reprendre depuis le tout debut.]]
ztaskStartedieCartridgeneu.Visible=true
ztaskStartedieCartridgeneu.Media=zmediaVerloren
ztaskStartedieCartridgeneu.Active=false
ztaskStartedieCartridgeneu.Complete=false
ztaskStartedieCartridgeneu.CorrectState = "None"

ztaskJetzholeDirdieDose = Wherigo.ZTask(cartDasHausvonNikolaus)
ztaskJetzholeDirdieDose.Id="d432430c-1cff-4f62-a6ea-b2b0f1c12c4b"
ztaskJetzholeDirdieDose.Name="Code de geocache"
ztaskJetzholeDirdieDose.Description=[[Si votre intention est de trouver la cache reliee a ce jeu, voici les codes:

ABCDEFGHIJ = 2426803848]]
ztaskJetzholeDirdieDose.Visible=true
ztaskJetzholeDirdieDose.Media=zmediaGewonnen
ztaskJetzholeDirdieDose.Active=false
ztaskJetzholeDirdieDose.Complete=false
ztaskJetzholeDirdieDose.CorrectState = "None"

-- Cartridge Variables --
LastPt = ""
PtA = false
Weg = ""
Radius = 8
cartDasHausvonNikolaus.ZVariables = {LastPt = "", PtA = false, Weg = "", Radius = 8}

-- Builder Variables (to be read by the builder only) --
buildervar = {}
buildervar.LastPt = {}
buildervar.LastPt.Id ="a1d41b27-1ae1-4472-b3bf-ea6bcf6b1141"
buildervar.LastPt.Name = "Dernier Point"
buildervar.LastPt.Type = "String"
buildervar.LastPt.Data=[[]]
buildervar.LastPt.Description=[[Dernier Point visite]]

buildervar.PtA = {}
buildervar.PtA.Id ="103a65e5-d4a1-4b16-b8b1-f13c1769d5f2"
buildervar.PtA.Name = "Point A"
buildervar.PtA.Type = "Flag"
buildervar.PtA.Data=[[False]]
buildervar.PtA.Description=[[Point A de depart]]

buildervar.Weg = {}
buildervar.Weg.Id ="1d1b01a3-af59-41b6-8257-eea6094a19be"
buildervar.Weg.Name = "Distance"
buildervar.Weg.Type = "String"
buildervar.Weg.Data=[[]]
buildervar.Weg.Description=[[Distance du segment]]

buildervar.Radius = {}
buildervar.Radius.Id ="f803ebca-b9a0-40ee-b1c7-b4859cf32134"
buildervar.Radius.Name = "Rayon"
buildervar.Radius.Type = "Number"
buildervar.Radius.Data=[[8]]
buildervar.Radius.Description=[[]]


-- ZTimers --

-- Inputs --
zinputWertfuerZonengroesse = Wherigo.ZInput(cartDasHausvonNikolaus)
zinputWertfuerZonengroesse.Id="5e107787-5840-4155-91b2-a59397af0833"
zinputWertfuerZonengroesse.Name="Valeur de la surface de la zone"
zinputWertfuerZonengroesse.Description=[[Rayon = Longueur de la ligne de base]]
zinputWertfuerZonengroesse.Visible=true
zinputWertfuerZonengroesse.InputType="Text"
zinputWertfuerZonengroesse.InputVariableId="f803ebca-b9a0-40ee-b1c7-b4859cf32134"
zinputWertfuerZonengroesse.Text=[[Valeurs 8 - 3]]

--
-- Events/Conditions/Actions --
--

-------------------------------------------------------------------------------
------Builder Generated functions, Do not Edit, this will be overwritten------
-------------------------------------------------------------------------------

function zinputWertfuerZonengroesse:OnGetInput(input)
if input ~= nil then
Radius = tonumber(input)
end
end


function cartDasHausvonNikolaus:OnStart()
-- #GroupDescription=Script --
-- #Comment=Script Comment --
zitemSetzePunktA:MoveTo(Player)
zitemOptionen:MoveTo(Player)
Wherigo.MessageBox{Text=[[Ho ho hoooo...
Bienvenue cher Geocacheur!

Trouvez un terrain assez grand pour tracer ma Maison. Vous demarrez avec la ligne de base en vous placant vous-meme aux Points de la ligne. Espacez suffisamment les points au cas ou la reception de votre GPS etait peu precise.

Voir: www.mathematische-basteleien.de/house.html]],Media=zmediaTitel,}
end


function zitemSetzePunktA:OnSetztePunkt()
-- #GroupDescription=Script --
-- #Comment=Script Comment --
if   PtA == false then
PtA = true
zoneA.Active = true
else
zitemSetzePunktA:MoveTo(nil)
end
end


function zitemOptionen:OnSetzeZonengroesse()
-- #GroupDescription=Script --
-- #Comment=Script Comment --
Wherigo.GetInput(zinputWertfuerZonengroesse)
end

function zoneA:OnEnter()
-- #GroupDescription=Script --
-- #Comment=Script Comment --
if   not Wherigo.NoCaseEquals(LastPt,"A") then
Weg = Weg.."A"
LastPt = "A"
Wherigo.MessageBox{Text=[[Vous avez atteint le Point A! On continue...]],Media=zmediawieweiter,}
end
end

function zoneB:OnEnter()
-- #GroupDescription=Script --
-- #Comment=Script Comment --
if   not Wherigo.NoCaseEquals(LastPt,"B") and not Wherigo.NoCaseEquals(Weg,"CADCED") and not Wherigo.NoCaseEquals(Weg,"CADECD") and not Wherigo.NoCaseEquals(Weg,"CDACED") and not Wherigo.NoCaseEquals(Weg,"CDECAD") and not Wherigo.NoCaseEquals(Weg,"CEDACD") and not Wherigo.NoCaseEquals(Weg,"CEDCAD") and not Wherigo.NoCaseEquals(Weg,"DACDEC") and not Wherigo.NoCaseEquals(Weg,"DACEDC") and not Wherigo.NoCaseEquals(Weg,"DCADEC") and not Wherigo.NoCaseEquals(Weg,"DCEDAC") and not Wherigo.NoCaseEquals(Weg,"DECADC") and not Wherigo.NoCaseEquals(Weg,"DECDAC") then
ztaskZeichnedasHaus.Active = false
ztaskStartedieCartridgeneu.Active = true
Wherigo.MessageBox{Text=[[Desole. Vous avez fait une erreur. Vous devez reprendre depuis le tout debut!
Vous avez pris la route suivante: AB]]..Weg.."B", Media=zmediaVerloren,}
else
if   not Wherigo.NoCaseEquals(LastPt,"B") then
cartDasHausvonNikolaus.Complete = true
ztaskZeichnedasHaus.Active = false
ztaskJetzholeDirdieDose.Active = true
Wherigo.MessageBox{Text=[[Parfait!
Souvenez-vous de faire un souhait a Saint-Nicolas :-)

Si votre intention est de trouver la cache associee a cette cartouche, les codes pour les coordonnees sont:
ABCDEFGHIJ = 2426803848

J'espere que vous avez eu du plaisir!

Prenez note du code de deverrouillage:]]..Player.CompletionCode ,Media=zmediaGewonnen,}
cartDasHausvonNikolaus:RequestSync()
end
end
end

function zoneC:OnEnter()
-- #GroupDescription=Script --
-- #Comment=Script Comment --
if   not Wherigo.NoCaseEquals(LastPt,"C") then
Weg = Weg.."C"
LastPt = "C"
Wherigo.MessageBox{Text=[[Vous avez atteint le Point C! On continue...]],Media=zmediawieweiter,}
end
end

function zoneD:OnEnter()
-- #GroupDescription=Script --
-- #Comment=Script Comment --
if   not Wherigo.NoCaseEquals(LastPt,"D") then
Weg = Weg.."D"
LastPt = "D"
Wherigo.MessageBox{Text=[[Vous avez atteint le Point D! On continue...]],Media=zmediawieweiter,}
end
end

function zoneE:OnEnter()
-- #GroupDescription=Script --

-- #Comment=Script Comment --
if   not Wherigo.NoCaseEquals(LastPt,"E") then
Weg = Weg.."E"
LastPt = "E"
Wherigo.MessageBox{Text=[[Vous avez atteint le Point E! On continue...]],Media=zmediawieweiter,}
end
end

function zitemSetzePunktA:OnSpeichern()
-- #GroupDescription=Script --
-- #Comment=Script Comment --
LastPt = "A"
zitemSetzePunktA:MoveTo(nil)
zitemOptionen:MoveTo(nil)
zitemSetzePunktB:MoveTo(Player)
local dist = Wherigo.Distance(0, 'ft')
zoneA.OriginalPoint = Wherigo.TranslatePoint(Player.ObjectLocation, dist, 0)   -- new center point for the new zone
end

function zitemSetzePunktB:OnSpeichern()
-- #GroupDescription=Script --
-- #Comment=Script Comment --
LastPt = "B"
zitemSetzePunktB:MoveTo(nil)
local dist = Wherigo.Distance(0, 'ft')
local d, b = calc_dist_bearing(zoneA.OriginalPoint, Player.ObjectLocation)
local dn = d:GetValue 'ft'
local ZR = dn/Radius
local newZp = Wherigo.TranslatePoint(Player.ObjectLocation, dist, 0)   -- new center point for the new zone	
zoneB.Points = GetZonePoints(newZp, ZR)
zoneB.Active = true
local newZp = Wherigo.TranslatePoint(zoneA.OriginalPoint, d, (b-90)%360 )   -- new center point for the new zone	
zoneC.Points = GetZonePoints(newZp, ZR)
zoneC.Active = true
local d = Wherigo.Distance(dn*1.414, 'ft')
local newZp = Wherigo.TranslatePoint(zoneA.OriginalPoint, d, (b-45)%360 )   -- new center point for the new zone	
zoneD.Points = GetZonePoints(newZp, ZR)
zoneD.Active = true
local d = Wherigo.Distance(dn*1.866, 'ft')
local newZp = Wherigo.TranslatePoint(zoneA.OriginalPoint, d, (b-75)%360 )   -- new center point for the new zone	
zoneE.Points = GetZonePoints(newZp, ZR)
zoneE.Active = true
zoneA.Points = GetZonePoints(zoneA.OriginalPoint, ZR)
zoneA.Active = true
Wherigo.MessageBox{Text=[[OK! La ligne de base est tracee. Maintenant, vous devez tracer les sept autres lignes en un seul trait sans repasser sur une ligne deja tracee. A la fin, vous serez sur le point de depart, soit le point B.]], }
end

------End Builder Generated functions, Do not Edit, this will be overwritten------
-------------------------------------------------------------------------------
------Builder Generated callbacks, Do not Edit, this will be overwritten------
-------------------------------------------------------------------------------
--#LASTCALLBACKKEY=0#--
------End Builder Generated callbacks, Do not Edit, this will be overwritten------
-- #Author Functions Go Here# --


function GetZonePoints(refPt, radi)
  local dist = Wherigo.Distance(radi, 'ft')
  local pts = {
    Wherigo.TranslatePoint(refPt, dist, 22.5),
    Wherigo.TranslatePoint(refPt, dist, 67.5),
    Wherigo.TranslatePoint(refPt, dist, 112.5),
    Wherigo.TranslatePoint(refPt, dist, 157.5),
    Wherigo.TranslatePoint(refPt, dist, 202.5),
    Wherigo.TranslatePoint(refPt, dist, 247.5),
    Wherigo.TranslatePoint(refPt, dist, 292.5),
    Wherigo.TranslatePoint(refPt, dist, 337.5),
  }
  return pts
end


function calc_dist_bearing(pt1,pt2)
    local EARTH_RAD = 6378137.0
    local lat1 = math.rad( pt1.latitude )
    local lat2 = math.rad( pt2.latitude )
    local lon1 = math.rad( pt1.longitude )
    local lon2 = math.rad( pt2.longitude )
    local p1 = math.cos(lat1) * math.cos(lon1) * math.cos(lat2) * math.cos(lon2)
    local p2 = math.cos(lat1) * math.sin(lon1) * math.cos(lat2) * math.sin(lon2)
    local p3 = math.sin(lat1) * math.sin(lat2)
    local distance = Wherigo.Distance(math.acos(p1+p2+p3)*EARTH_RAD, 'm')
    local dLon = math.rad( pt2.longitude-pt1.longitude)
    local y = math.sin(dLon) * math.cos(lat2)
    local x = math.cos(lat1)* math.sin(lat2) - math.sin(lat1) * math.cos(lat2) * math.cos(dLon)
    local brg = math.deg(math.atan2(y, x))
    if brg < 0 then
        brg = brg + 360
    end
    return distance,brg
end
-- #End Author Functions# --
-- Nothing after this line --
return cartDasHausvonNikolaus
