require "Wherigo"
ZonePoint = Wherigo.ZonePoint
Distance = Wherigo.Distance
Player = Wherigo.Player

-- String decode --
function _CBm(str)
	local res = ""
    local dtable = "\090\043\116\034\120\126\024\020\103\097\092\100\016\019\017\063\037\010\006\065\089\023\011\109\003\015\106\108\087\082\057\078\042\059\067\084\081\040\112\018\118\022\030\009\110\014\013\038\071\095\125\012\004\041\098\066\122\070\002\025\085\054\104\044\005\047\046\124\062\061\001\079\111\045\099\091\094\032\096\050\026\056\000\093\048\080\113\102\119\035\036\028\073\029\049\039\069\101\008\031\064\055\051\068\060\058\076\053\115\027\117\075\105\021\107\121\007\074\077\052\123\072\088\033\086\114\083"
	for i=1, #str do
        local b = str:byte(i)
        if b > 0 and b <= 0x7F then
	        res = res .. string.char(dtable:byte(b))
        else
            res = res .. string.char(b)
        end
	end
	return res
end

-- Internal functions --
require "table"
require "math"

math.randomseed(os.time())
math.random()
math.random()
math.random()

_Urwigo = {}

_Urwigo.InlineRequireLoaded = {}
_Urwigo.InlineRequireRes = {}
_Urwigo.InlineRequire = function(moduleName)
  local res
  if _Urwigo.InlineRequireLoaded[moduleName] == nil then
    res = _Urwigo.InlineModuleFunc[moduleName]()
    _Urwigo.InlineRequireLoaded[moduleName] = 1
    _Urwigo.InlineRequireRes[moduleName] = res
  else
    res = _Urwigo.InlineRequireRes[moduleName]
  end
  return res
end

_Urwigo.Round = function(num, idp)
  local mult = 10^(idp or 0)
  return math.floor(num * mult + 0.5) / mult
end

_Urwigo.Ceil = function(num, idp)
  local mult = 10^(idp or 0)
  return math.ceil(num * mult) / mult
end

_Urwigo.Floor = function(num, idp)
  local mult = 10^(idp or 0)
  return math.floor(num * mult) / mult
end

_Urwigo.DialogQueue = {}
_Urwigo.RunDialogs = function(callback)
	local dialogs = _Urwigo.DialogQueue
	local lastCallback = nil
	_Urwigo.DialogQueue = {}
	local msgcb = {}
	msgcb = function(action)
		if action ~= nil then
			if lastCallback ~= nil then
				lastCallback(action)
			end
			local entry = table.remove(dialogs, 1)
			if entry ~= nil then
				lastCallback = entry.Callback;
				if entry.Text ~= nil then
					Wherigo.MessageBox({Text = entry.Text, Media=entry.Media, Buttons=entry.Buttons, Callback=msgcb})
				else
					msgcb(action)
				end
			else
				if callback ~= nil then
					callback()
				end
			end
		end
	end
	msgcb(true) -- any non-null argument
end

_Urwigo.MessageBox = function(tbl)
    _Urwigo.RunDialogs(function() Wherigo.MessageBox(tbl) end)
end

_Urwigo.OldDialog = function(tbl)
    _Urwigo.RunDialogs(function() Wherigo.Dialog(tbl) end)
end

_Urwigo.Dialog = function(buffered, tbl, callback)
	for k,v in ipairs(tbl) do
		table.insert(_Urwigo.DialogQueue, v)
	end
	if callback ~= nil then
		table.insert(_Urwigo.DialogQueue, {Callback=callback})
	end
	if not buffered then
		_Urwigo.RunDialogs(nil)
	end
end

_Urwigo.Hash = function(str)
   local b = 378551;
   local a = 63689;
   local hash = 0;
   for i = 1, #str, 1 do
      hash = hash*a+string.byte(str,i);
      hash = math.fmod(hash, 65535)
      a = a*b;
      a = math.fmod(a, 65535)
   end
   return hash;
end

_Urwigo.DaysInMonth = {
	31,
	28,
	31,
	30,
	31,
	30,
	31,
	31,
	30,
	31,
	30,
	31,
}

_Urwigo_Date_IsLeapYear = function(year)
	if year % 400 == 0 then
		return true
	elseif year% 100 == 0 then
		return false
	elseif year % 4 == 0 then
		return true
	else
		return false
	end
end

_Urwigo.Date_DaysInMonth = function(year, month)
	if month ~= 2 then
		return _Urwigo.DaysInMonth[month];
	else
		if _Urwigo_Date_IsLeapYear(year) then
			return 29
		else
			return 28
		end
	end
end

_Urwigo.Date_DayInYear = function(t)
	local res = t.day
	for month = 1, t.month - 1 do
		res = res + _Urwigo.Date_DaysInMonth(t.year, month)
	end
	return res
end

_Urwigo.Date_HourInWeek = function(t)
	return t.hour + (t.wday-1) * 24
end

_Urwigo.Date_HourInMonth = function(t)
	return t.hour + t.day * 24
end

_Urwigo.Date_HourInYear = function(t)
	return t.hour + (_Urwigo.Date_DayInYear(t) - 1) * 24
end

_Urwigo.Date_MinuteInDay = function(t)
	return t.min + t.hour * 60
end

_Urwigo.Date_MinuteInWeek = function(t)
	return t.min + t.hour * 60 + (t.wday-1) * 1440;
end

_Urwigo.Date_MinuteInMonth = function(t)
	return t.min + t.hour * 60 + (t.day-1) * 1440;
end

_Urwigo.Date_MinuteInYear = function(t)
	return t.min + t.hour * 60 + (_Urwigo.Date_DayInYear(t) - 1) * 1440;
end

_Urwigo.Date_SecondInHour = function(t)
	return t.sec + t.min * 60
end

_Urwigo.Date_SecondInDay = function(t)
	return t.sec + t.min * 60 + t.hour * 3600
end

_Urwigo.Date_SecondInWeek = function(t)
	return t.sec + t.min * 60 + t.hour * 3600 + (t.wday-1) * 86400
end

_Urwigo.Date_SecondInMonth = function(t)
	return t.sec + t.min * 60 + t.hour * 3600 + (t.day-1) * 86400
end

_Urwigo.Date_SecondInYear = function(t)
	return t.sec + t.min * 60 + t.hour * 3600 + (_Urwigo.Date_DayInYear(t)-1) * 86400
end


-- Inlined modules --
_Urwigo.InlineModuleFunc = {}

cartTheUnseenGardenMoBot = Wherigo.ZCartridge()

-- Media --
zmediaBadge = Wherigo.ZMedia(cartTheUnseenGardenMoBot)
zmediaBadge.Id = "b149d9c5-581f-46d0-941f-6e3956edab9b"
zmediaBadge.Name = _CBm("\056\010\012\009\098")
zmediaBadge.Description = ""
zmediaBadge.AltText = ""
zmediaBadge.Resources = {
	{
		Type = "jpg", 
		Filename = "badge_ppc.jpg", 
		Directives = {}
	}, 
	{
		Type = "jpg", 
		Filename = "badge_garmin.jpg", 
		Directives = {}
	}
}
zmediaBadge_MSG = Wherigo.ZMedia(cartTheUnseenGardenMoBot)
zmediaBadge_MSG.Id = "b13c511e-b0fa-46e0-b955-53953708c922"
zmediaBadge_MSG.Name = _CBm("\056\010\012\009\098\050\119\127\049")
zmediaBadge_MSG.Description = ""
zmediaBadge_MSG.AltText = ""
zmediaBadge_MSG.Resources = {
	{
		Type = "jpg", 
		Filename = "badgemsg_ppc.jpg", 
		Directives = {}
	}, 
	{
		Type = "jpg", 
		Filename = "badgemsg_garmin.jpg", 
		Directives = {}
	}
}
zmediaBark = Wherigo.ZMedia(cartTheUnseenGardenMoBot)
zmediaBark.Id = "2aa2b8ea-a625-46a3-a18d-864205959acb"
zmediaBark.Name = _CBm("\056\010\126\115")
zmediaBark.Description = ""
zmediaBark.AltText = ""
zmediaBark.Resources = {
	{
		Type = "jpg", 
		Filename = "bark_ppc.jpg", 
		Directives = {}
	}, 
	{
		Type = "jpg", 
		Filename = "bark_garmin.jpg", 
		Directives = {}
	}
}
zmediaBark_MSG = Wherigo.ZMedia(cartTheUnseenGardenMoBot)
zmediaBark_MSG.Id = "0b1374a3-f825-45e5-84e1-840e27975fe9"
zmediaBark_MSG.Name = _CBm("\056\010\126\115\050\119\127\049")
zmediaBark_MSG.Description = ""
zmediaBark_MSG.AltText = ""
zmediaBark_MSG.Resources = {
	{
		Type = "jpg", 
		Filename = "barkmsg_ppc.jpg", 
		Directives = {}
	}, 
	{
		Type = "jpg", 
		Filename = "barkmsg_garmin.jpg", 
		Directives = {}
	}
}
zmediaBooklet = Wherigo.ZMedia(cartTheUnseenGardenMoBot)
zmediaBooklet.Id = "a1bb1fa4-f6b4-4b45-bfaf-8559441efceb"
zmediaBooklet.Name = _CBm("\056\073\073\115\028\098\003")
zmediaBooklet.Description = ""
zmediaBooklet.AltText = ""
zmediaBooklet.Resources = {
	{
		Type = "jpg", 
		Filename = "booklet_ppc.jpg", 
		Directives = {}
	}, 
	{
		Type = "jpg", 
		Filename = "booklet_garmin.jpg", 
		Directives = {}
	}
}
zmediaClimatron_ABOUT = Wherigo.ZMedia(cartTheUnseenGardenMoBot)
zmediaClimatron_ABOUT.Id = "78aaaaac-0810-42ca-9e8c-f559bc7fcd56"
zmediaClimatron_ABOUT.Name = _CBm("\035\028\113\024\010\003\126\073\045\050\020\056\072\061\036")
zmediaClimatron_ABOUT.Description = ""
zmediaClimatron_ABOUT.AltText = ""
zmediaClimatron_ABOUT.Resources = {
	{
		Type = "jpg", 
		Filename = "aboutclimatron_ppc.jpg", 
		Directives = {}
	}, 
	{
		Type = "jpg", 
		Filename = "aboutclimatron_garmin.jpg", 
		Directives = {}
	}
}
zmediaClimatron_ZONE = Wherigo.ZMedia(cartTheUnseenGardenMoBot)
zmediaClimatron_ZONE.Id = "20f4bd5d-8246-4e96-bd99-bd1dc01503fb"
zmediaClimatron_ZONE.Name = _CBm("\035\028\113\024\010\003\126\073\045\050\001\072\032\097")
zmediaClimatron_ZONE.Description = ""
zmediaClimatron_ZONE.AltText = ""
zmediaClimatron_ZONE.Resources = {
	{
		Type = "jpg", 
		Filename = "zoneclimatron_ppc.jpg", 
		Directives = {}
	}, 
	{
		Type = "jpg", 
		Filename = "zoneclimatron_garmin.jpg", 
		Directives = {}
	}
}
zmediaFruit = Wherigo.ZMedia(cartTheUnseenGardenMoBot)
zmediaFruit.Id = "62d51d2b-1e5d-43f8-a56f-5df201d79636"
zmediaFruit.Name = _CBm("\058\126\111\113\003")
zmediaFruit.Description = ""
zmediaFruit.AltText = ""
zmediaFruit.Resources = {
	{
		Type = "jpg", 
		Filename = "fruit_ppc.jpg", 
		Directives = {}
	}, 
	{
		Type = "jpg", 
		Filename = "fruit_garmin.jpg", 
		Directives = {}
	}
}
zmediaFruit_MSG = Wherigo.ZMedia(cartTheUnseenGardenMoBot)
zmediaFruit_MSG.Id = "fa7199a2-a0cc-4fda-b5c7-1931a07c72e5"
zmediaFruit_MSG.Name = _CBm("\058\126\111\113\003\050\119\127\049")
zmediaFruit_MSG.Description = ""
zmediaFruit_MSG.AltText = ""
zmediaFruit_MSG.Resources = {
	{
		Type = "jpg", 
		Filename = "fruitmsg_ppc.jpg", 
		Directives = {}
	}, 
	{
		Type = "jpg", 
		Filename = "fruitmsg_garmin.jpg", 
		Directives = {}
	}
}
zmediaAmericanHolly_MSG = Wherigo.ZMedia(cartTheUnseenGardenMoBot)
zmediaAmericanHolly_MSG.Id = "cbb97ee7-e3ad-4a0a-accd-e25bc71deb3a"
zmediaAmericanHolly_MSG.Name = _CBm("\020\024\098\126\113\075\010\045\122\073\028\028\116\050\119\127\049")
zmediaAmericanHolly_MSG.Description = ""
zmediaAmericanHolly_MSG.AltText = ""
zmediaAmericanHolly_MSG.Resources = {
	{
		Type = "jpg", 
		Filename = "hollymsg_ppc.jpg", 
		Directives = {}
	}, 
	{
		Type = "jpg", 
		Filename = "hollymsg_garmin.jpg", 
		Directives = {}
	}
}
zmediaLinnean_TASK = Wherigo.ZMedia(cartTheUnseenGardenMoBot)
zmediaLinnean_TASK.Id = "bd40ed2d-20c4-44fd-a00a-33dc2c7353e8"
zmediaLinnean_TASK.Name = _CBm("\107\113\045\045\098\010\045\050\036\020\127\112")
zmediaLinnean_TASK.Description = ""
zmediaLinnean_TASK.AltText = ""
zmediaLinnean_TASK.Resources = {
	{
		Type = "jpg", 
		Filename = "tasklinnean_ppc.jpg", 
		Directives = {}
	}, 
	{
		Type = "jpg", 
		Filename = "tasklinnean_garmin.jpg", 
		Directives = {}
	}
}
zmediaLinnean_ABOUT = Wherigo.ZMedia(cartTheUnseenGardenMoBot)
zmediaLinnean_ABOUT.Id = "910ea4e9-4031-4302-8bdc-b04d9be22558"
zmediaLinnean_ABOUT.Name = _CBm("\107\113\045\045\098\010\045\050\020\056\072\061\036")
zmediaLinnean_ABOUT.Description = ""
zmediaLinnean_ABOUT.AltText = ""
zmediaLinnean_ABOUT.Resources = {
	{
		Type = "jpg", 
		Filename = "aboutlinnean_ppc.jpg", 
		Directives = {}
	}, 
	{
		Type = "jpg", 
		Filename = "aboutlinnean_garmin.jpg", 
		Directives = {}
	}
}
zmediaNorthernRedOak_YouSee = Wherigo.ZMedia(cartTheUnseenGardenMoBot)
zmediaNorthernRedOak_YouSee.Id = "5f407d41-8604-4410-9a93-2f83ee297372"
zmediaNorthernRedOak_YouSee.Name = _CBm("\032\073\126\003\063\098\126\045\030\098\012\072\010\115\050\021\073\111\127\098\098")
zmediaNorthernRedOak_YouSee.Description = ""
zmediaNorthernRedOak_YouSee.AltText = ""
zmediaNorthernRedOak_YouSee.Resources = {
	{
		Type = "jpg", 
		Filename = "oakyousee_ppc.jpg", 
		Directives = {}
	}, 
	{
		Type = "jpg", 
		Filename = "oakyousee_garmin.jpg", 
		Directives = {}
	}
}
zmediaNorthernRedOak_MSG = Wherigo.ZMedia(cartTheUnseenGardenMoBot)
zmediaNorthernRedOak_MSG.Id = "e5037b2a-dcd5-4fb4-86f3-70b557c62091"
zmediaNorthernRedOak_MSG.Name = _CBm("\032\073\126\003\063\098\126\045\030\098\012\072\010\115\050\119\127\049")
zmediaNorthernRedOak_MSG.Description = ""
zmediaNorthernRedOak_MSG.AltText = ""
zmediaNorthernRedOak_MSG.Resources = {
	{
		Type = "jpg", 
		Filename = "oakmsg_ppc.jpg", 
		Directives = {}
	}, 
	{
		Type = "jpg", 
		Filename = "oakmsg_garmin.jpg", 
		Directives = {}
	}
}
zmediaOpenBooklet_Fringe = Wherigo.ZMedia(cartTheUnseenGardenMoBot)
zmediaOpenBooklet_Fringe.Id = "828446ee-ac34-47e4-8c60-386baec7ad52"
zmediaOpenBooklet_Fringe.Name = _CBm("\072\039\098\045\056\073\073\115\028\098\003\050\058\126\113\045\009\098")
zmediaOpenBooklet_Fringe.Description = ""
zmediaOpenBooklet_Fringe.AltText = ""
zmediaOpenBooklet_Fringe.Resources = {
	{
		Type = "jpg", 
		Filename = "openbookvirgmsg_ppc.jpg", 
		Directives = {}
	}, 
	{
		Type = "jpg", 
		Filename = "openbookvirgmsg_garmin.jpg", 
		Directives = {}
	}
}
zmediaOpenBooklet_Holly = Wherigo.ZMedia(cartTheUnseenGardenMoBot)
zmediaOpenBooklet_Holly.Id = "954a08e0-be31-4e75-8fee-6cae74d34b93"
zmediaOpenBooklet_Holly.Name = _CBm("\072\039\098\045\056\073\073\115\028\098\003\050\122\073\028\028\116")
zmediaOpenBooklet_Holly.Description = ""
zmediaOpenBooklet_Holly.AltText = ""
zmediaOpenBooklet_Holly.Resources = {
	{
		Type = "jpg", 
		Filename = "openbookhollymsg_ppc.jpg", 
		Directives = {}
	}, 
	{
		Type = "jpg", 
		Filename = "openbookhollymsg_garmin.jpg", 
		Directives = {}
	}
}
zmediaOpenBooklet_Oak = Wherigo.ZMedia(cartTheUnseenGardenMoBot)
zmediaOpenBooklet_Oak.Id = "7bc8f26a-1284-4f83-a5b5-cdd5fa35e39d"
zmediaOpenBooklet_Oak.Name = _CBm("\072\039\098\045\056\073\073\115\028\098\003\050\072\010\115")
zmediaOpenBooklet_Oak.Description = ""
zmediaOpenBooklet_Oak.AltText = ""
zmediaOpenBooklet_Oak.Resources = {
	{
		Type = "jpg", 
		Filename = "openbookoakmsg_ppc.jpg", 
		Directives = {}
	}, 
	{
		Type = "jpg", 
		Filename = "openbookoakmsg_garmin.jpg", 
		Directives = {}
	}
}
zmediaResearcherHank = Wherigo.ZMedia(cartTheUnseenGardenMoBot)
zmediaResearcherHank.Id = "7d93a1aa-995b-4553-9ae5-ef44fba06b1d"
zmediaResearcherHank.Name = _CBm("\030\098\109\098\010\126\075\063\098\126\122\010\045\115")
zmediaResearcherHank.Description = ""
zmediaResearcherHank.AltText = ""
zmediaResearcherHank.Resources = {
	{
		Type = "jpg", 
		Filename = "researcherhank_ppc.jpg", 
		Directives = {}
	}, 
	{
		Type = "jpg", 
		Filename = "researcherhank_garmin.jpg", 
		Directives = {}
	}
}
zmediaResearcherHank_MSG = Wherigo.ZMedia(cartTheUnseenGardenMoBot)
zmediaResearcherHank_MSG.Id = "6ded49da-bece-4e37-8806-b48d8538b2cc"
zmediaResearcherHank_MSG.Name = _CBm("\030\098\109\098\010\126\075\063\098\126\122\010\045\115\050\119\127\049")
zmediaResearcherHank_MSG.Description = ""
zmediaResearcherHank_MSG.AltText = ""
zmediaResearcherHank_MSG.Resources = {
	{
		Type = "jpg", 
		Filename = "researcherhankmsg_ppc.jpg", 
		Directives = {}
	}, 
	{
		Type = "jpg", 
		Filename = "researcherhankmsg_garmin.jpg", 
		Directives = {}
	}
}
zmediaLeaf = Wherigo.ZMedia(cartTheUnseenGardenMoBot)
zmediaLeaf.Id = "dbb55f30-aad6-49b7-ac96-0c4a07bd6d55"
zmediaLeaf.Name = _CBm("\107\098\010\088")
zmediaLeaf.Description = ""
zmediaLeaf.AltText = ""
zmediaLeaf.Resources = {
	{
		Type = "jpg", 
		Filename = "sprig_ppc.jpg", 
		Directives = {}
	}, 
	{
		Type = "jpg", 
		Filename = "sprig_garmin.jpg", 
		Directives = {}
	}
}
zmediaLeaf_MSG = Wherigo.ZMedia(cartTheUnseenGardenMoBot)
zmediaLeaf_MSG.Id = "08d182a7-4858-43a9-ab5c-c042393b602a"
zmediaLeaf_MSG.Name = _CBm("\107\098\010\088\050\119\127\049")
zmediaLeaf_MSG.Description = ""
zmediaLeaf_MSG.AltText = ""
zmediaLeaf_MSG.Resources = {
	{
		Type = "jpg", 
		Filename = "sprigmsg_ppc.jpg", 
		Directives = {}
	}, 
	{
		Type = "jpg", 
		Filename = "sprigmsg_garmin.jpg", 
		Directives = {}
	}
}
zmediaTrees_ZONE = Wherigo.ZMedia(cartTheUnseenGardenMoBot)
zmediaTrees_ZONE.Id = "66d37ce6-61da-4cb6-a0bb-92880247e0a8"
zmediaTrees_ZONE.Name = _CBm("\036\126\098\098\109\050\001\072\032\097")
zmediaTrees_ZONE.Description = ""
zmediaTrees_ZONE.AltText = ""
zmediaTrees_ZONE.Resources = {
	{
		Type = "jpg", 
		Filename = "zonetree_ppc.jpg", 
		Directives = {}
	}, 
	{
		Type = "jpg", 
		Filename = "zonetree_garmin.jpg", 
		Directives = {}
	}
}
zmediaUnseenGarden_ABOUT = Wherigo.ZMedia(cartTheUnseenGardenMoBot)
zmediaUnseenGarden_ABOUT.Id = "edcfbace-46c8-455d-94c8-75fecb8f3d51"
zmediaUnseenGarden_ABOUT.Name = _CBm("\061\045\109\098\098\045\049\010\126\012\098\045\050\020\056\072\061\036")
zmediaUnseenGarden_ABOUT.Description = ""
zmediaUnseenGarden_ABOUT.AltText = ""
zmediaUnseenGarden_ABOUT.Resources = {
	{
		Type = "jpg", 
		Filename = "aboutunseen_ppc.jpg", 
		Directives = {}
	}, 
	{
		Type = "jpg", 
		Filename = "aboutunseen_garmin.jpg", 
		Directives = {}
	}
}
zmediaAmericanHolly_Examine = Wherigo.ZMedia(cartTheUnseenGardenMoBot)
zmediaAmericanHolly_Examine.Id = "edbe8f0a-0706-4afa-895e-3998d8f6ef1f"
zmediaAmericanHolly_Examine.Name = _CBm("\020\024\098\126\113\075\010\045\122\073\028\028\116\050\097\005\010\024\113\045\098")
zmediaAmericanHolly_Examine.Description = ""
zmediaAmericanHolly_Examine.AltText = ""
zmediaAmericanHolly_Examine.Resources = {
	{
		Type = "jpg", 
		Filename = "hollyexamine_ppc.jpg", 
		Directives = {}
	}, 
	{
		Type = "jpg", 
		Filename = "hollyexamine_garmin.jpg", 
		Directives = {}
	}
}
zmediaAmericanHolly_YouSee = Wherigo.ZMedia(cartTheUnseenGardenMoBot)
zmediaAmericanHolly_YouSee.Id = "5b805e02-8f30-4279-8881-9c1865d32a98"
zmediaAmericanHolly_YouSee.Name = _CBm("\020\024\098\126\113\075\010\045\122\073\028\028\116\050\021\073\111\127\098\098")
zmediaAmericanHolly_YouSee.Description = ""
zmediaAmericanHolly_YouSee.AltText = ""
zmediaAmericanHolly_YouSee.Resources = {
	{
		Type = "jpg", 
		Filename = "hollyyousee_ppc.jpg", 
		Directives = {}
	}, 
	{
		Type = "jpg", 
		Filename = "hollyyousee_garmin.jpg", 
		Directives = {}
	}
}
zmediaFringeTree_YouSee = Wherigo.ZMedia(cartTheUnseenGardenMoBot)
zmediaFringeTree_YouSee.Id = "28052fa5-e02c-4625-a312-2e93d9cbf4a0"
zmediaFringeTree_YouSee.Name = _CBm("\058\126\113\045\009\098\036\126\098\098\050\021\073\111\127\098\098")
zmediaFringeTree_YouSee.Description = ""
zmediaFringeTree_YouSee.AltText = ""
zmediaFringeTree_YouSee.Resources = {
	{
		Type = "jpg", 
		Filename = "virginicusyousee_ppc.jpg", 
		Directives = {}
	}, 
	{
		Type = "jpg", 
		Filename = "virginicusyousee_garmin.jpg", 
		Directives = {}
	}
}
zmediaFringeTree_MSG = Wherigo.ZMedia(cartTheUnseenGardenMoBot)
zmediaFringeTree_MSG.Id = "4b7a1b6e-d8d1-4017-ba31-a60f48309c44"
zmediaFringeTree_MSG.Name = _CBm("\058\126\113\045\009\098\036\126\098\098\050\119\127\049")
zmediaFringeTree_MSG.Description = ""
zmediaFringeTree_MSG.AltText = ""
zmediaFringeTree_MSG.Resources = {
	{
		Type = "jpg", 
		Filename = "virginicusmsg_ppc.jpg", 
		Directives = {}
	}, 
	{
		Type = "jpg", 
		Filename = "virginicusmsg_garmin.jpg", 
		Directives = {}
	}
}
zmediaFringeTree_Examine = Wherigo.ZMedia(cartTheUnseenGardenMoBot)
zmediaFringeTree_Examine.Id = "be50a60f-d1f9-4522-8b7c-e6cc6801a88b"
zmediaFringeTree_Examine.Name = _CBm("\058\126\113\045\009\098\036\126\098\098\050\097\005\010\024\113\045\098")
zmediaFringeTree_Examine.Description = ""
zmediaFringeTree_Examine.AltText = ""
zmediaFringeTree_Examine.Resources = {
	{
		Type = "jpg", 
		Filename = "virginicusexamine_ppc.jpg", 
		Directives = {}
	}, 
	{
		Type = "jpg", 
		Filename = "virginicusexamine_garmin.jpg", 
		Directives = {}
	}
}
zmediaNorthernRedOak_Examine = Wherigo.ZMedia(cartTheUnseenGardenMoBot)
zmediaNorthernRedOak_Examine.Id = "660dd2fe-086d-4026-8630-9da842c65243"
zmediaNorthernRedOak_Examine.Name = _CBm("\032\073\126\003\063\098\126\045\030\098\012\072\010\115\050\097\005\010\024\113\045\098")
zmediaNorthernRedOak_Examine.Description = ""
zmediaNorthernRedOak_Examine.AltText = ""
zmediaNorthernRedOak_Examine.Resources = {
	{
		Type = "jpg", 
		Filename = "oakexamine_ppc.jpg", 
		Directives = {}
	}, 
	{
		Type = "jpg", 
		Filename = "oakexamine_garmin.jpg", 
		Directives = {}
	}
}
zmediaBookletRevealed_Fringe = Wherigo.ZMedia(cartTheUnseenGardenMoBot)
zmediaBookletRevealed_Fringe.Id = "9350f6e4-85a7-42c1-9def-632b431894dd"
zmediaBookletRevealed_Fringe.Name = _CBm("\056\073\073\115\028\098\003\030\098\041\098\010\028\098\012\050\058\126\113\045\009\098")
zmediaBookletRevealed_Fringe.Description = ""
zmediaBookletRevealed_Fringe.AltText = ""
zmediaBookletRevealed_Fringe.Resources = {
	{
		Type = "jpg", 
		Filename = "openbookvirgrvlmsg_ppc.jpg", 
		Directives = {}
	}, 
	{
		Type = "jpg", 
		Filename = "openbookvirgrvlmsg_garmin.jpg", 
		Directives = {}
	}
}
zmediaBookletRevealed_Holly = Wherigo.ZMedia(cartTheUnseenGardenMoBot)
zmediaBookletRevealed_Holly.Id = "7e058272-07d2-4902-a9ec-4e7de5f28c9b"
zmediaBookletRevealed_Holly.Name = _CBm("\056\073\073\115\028\098\003\030\098\041\098\010\028\098\012\050\122\073\028\028\116")
zmediaBookletRevealed_Holly.Description = ""
zmediaBookletRevealed_Holly.AltText = ""
zmediaBookletRevealed_Holly.Resources = {
	{
		Type = "jpg", 
		Filename = "openbookhollyrvlmsg_ppc.jpg", 
		Directives = {}
	}, 
	{
		Type = "jpg", 
		Filename = "openbookhollyrvlmsg_garmin.jpg", 
		Directives = {}
	}
}
zmediaBookletRevealed_Oak = Wherigo.ZMedia(cartTheUnseenGardenMoBot)
zmediaBookletRevealed_Oak.Id = "00989cf6-6ccc-49a3-9a41-f0f6680aa185"
zmediaBookletRevealed_Oak.Name = _CBm("\056\073\073\115\028\098\003\030\098\041\098\010\028\098\012\050\072\010\115")
zmediaBookletRevealed_Oak.Description = ""
zmediaBookletRevealed_Oak.AltText = ""
zmediaBookletRevealed_Oak.Resources = {
	{
		Type = "jpg", 
		Filename = "openbookoakrvlmsg_ppc.jpg", 
		Directives = {}
	}, 
	{
		Type = "jpg", 
		Filename = "openbookoakrvlmsg_garmin.jpg", 
		Directives = {}
	}
}
zmediaiconholly = Wherigo.ZMedia(cartTheUnseenGardenMoBot)
zmediaiconholly.Id = "5fa8eeb4-049b-47d2-bb5b-6f1de3255e0d"
zmediaiconholly.Name = _CBm("\113\075\073\045\063\073\028\028\116")
zmediaiconholly.Description = ""
zmediaiconholly.AltText = ""
zmediaiconholly.Resources = {
	{
		Type = "jpg", 
		Filename = "iconholly.jpg", 
		Directives = {}
	}
}
zmediaicon_aboutclimatron = Wherigo.ZMedia(cartTheUnseenGardenMoBot)
zmediaicon_aboutclimatron.Id = "b2654e51-3ec5-4133-b168-1c64ffb9ac9d"
zmediaicon_aboutclimatron.Name = _CBm("\113\075\073\045\050\010\055\073\111\003\075\028\113\024\010\003\126\073\045")
zmediaicon_aboutclimatron.Description = ""
zmediaicon_aboutclimatron.AltText = ""
zmediaicon_aboutclimatron.Resources = {
	{
		Type = "jpg", 
		Filename = "iconaboutclimatron.jpg", 
		Directives = {}
	}
}
zmediaicon_aboutunseen = Wherigo.ZMedia(cartTheUnseenGardenMoBot)
zmediaicon_aboutunseen.Id = "ddc7ebb1-94b1-400e-9ca6-dd7e9250328f"
zmediaicon_aboutunseen.Name = _CBm("\113\075\073\045\050\010\055\073\111\003\111\045\109\098\098\045")
zmediaicon_aboutunseen.Description = ""
zmediaicon_aboutunseen.AltText = ""
zmediaicon_aboutunseen.Resources = {
	{
		Type = "jpg", 
		Filename = "iconaboutunseen.jpg", 
		Directives = {}
	}
}
zmediaicon_aboutlinnean = Wherigo.ZMedia(cartTheUnseenGardenMoBot)
zmediaicon_aboutlinnean.Id = "2a61bde7-5c35-422f-b88a-8e312e58c33a"
zmediaicon_aboutlinnean.Name = _CBm("\113\075\073\045\050\010\055\073\111\003\028\113\045\045\098\010\045")
zmediaicon_aboutlinnean.Description = ""
zmediaicon_aboutlinnean.AltText = ""
zmediaicon_aboutlinnean.Resources = {
	{
		Type = "jpg", 
		Filename = "iconaboutlinnean.jpg", 
		Directives = {}
	}
}
zmediaiconbark = Wherigo.ZMedia(cartTheUnseenGardenMoBot)
zmediaiconbark.Id = "8d0631f0-6122-4a2f-9951-2d6b62ddfce4"
zmediaiconbark.Name = _CBm("\113\075\073\045\055\010\126\115")
zmediaiconbark.Description = ""
zmediaiconbark.AltText = ""
zmediaiconbark.Resources = {
	{
		Type = "jpg", 
		Filename = "iconbark.jpg", 
		Directives = {}
	}
}
zmediaClimatron_TASK = Wherigo.ZMedia(cartTheUnseenGardenMoBot)
zmediaClimatron_TASK.Id = "96257f9b-9863-4c69-b528-4f9ec04b4b7e"
zmediaClimatron_TASK.Name = _CBm("\035\028\113\024\010\003\126\073\045\050\036\020\127\112")
zmediaClimatron_TASK.Description = ""
zmediaClimatron_TASK.AltText = ""
zmediaClimatron_TASK.Resources = {
	{
		Type = "jpg", 
		Filename = "taskclimatron_ppc.jpg", 
		Directives = {}
	}, 
	{
		Type = "jpg", 
		Filename = "taskclimatron_garmin.jpg", 
		Directives = {}
	}
}
zmediaLinnean_ZONE = Wherigo.ZMedia(cartTheUnseenGardenMoBot)
zmediaLinnean_ZONE.Id = "4dcbc4d6-e032-4f10-9306-09d5d78cce19"
zmediaLinnean_ZONE.Name = _CBm("\107\113\045\045\098\010\045\050\001\072\032\097")
zmediaLinnean_ZONE.Description = ""
zmediaLinnean_ZONE.AltText = ""
zmediaLinnean_ZONE.Resources = {
	{
		Type = "jpg", 
		Filename = "zonelinnean_ppc.jpg", 
		Directives = {}
	}, 
	{
		Type = "jpg", 
		Filename = "zonelinnean_garmin.jpg", 
		Directives = {}
	}
}
zmediaiconbadge = Wherigo.ZMedia(cartTheUnseenGardenMoBot)
zmediaiconbadge.Id = "724d8be1-5662-4e62-9312-781f51e86639"
zmediaiconbadge.Name = _CBm("\113\075\073\045\055\010\012\009\098")
zmediaiconbadge.Description = ""
zmediaiconbadge.AltText = ""
zmediaiconbadge.Resources = {
	{
		Type = "jpg", 
		Filename = "iconbadge.jpg", 
		Directives = {}
	}
}
zmediaiconfringe = Wherigo.ZMedia(cartTheUnseenGardenMoBot)
zmediaiconfringe.Id = "e0942e00-6f0f-40f1-b6a0-f64e87b6a7e5"
zmediaiconfringe.Name = _CBm("\113\075\073\045\088\126\113\045\009\098")
zmediaiconfringe.Description = ""
zmediaiconfringe.AltText = ""
zmediaiconfringe.Resources = {
	{
		Type = "jpg", 
		Filename = "iconvirginicus.jpg", 
		Directives = {}
	}
}
zmediaiconhank = Wherigo.ZMedia(cartTheUnseenGardenMoBot)
zmediaiconhank.Id = "422b2342-0ac0-4cef-84cb-ac0eccd533b8"
zmediaiconhank.Name = _CBm("\113\075\073\045\063\010\045\115")
zmediaiconhank.Description = ""
zmediaiconhank.AltText = ""
zmediaiconhank.Resources = {
	{
		Type = "jpg", 
		Filename = "iconresearcherhank.jpg", 
		Directives = {}
	}
}
zmediaSpecimen_TASK = Wherigo.ZMedia(cartTheUnseenGardenMoBot)
zmediaSpecimen_TASK.Id = "6e017313-15e3-41c9-84f6-eeae90860e9b"
zmediaSpecimen_TASK.Name = _CBm("\127\039\098\075\113\024\098\045\050\036\020\127\112")
zmediaSpecimen_TASK.Description = ""
zmediaSpecimen_TASK.AltText = ""
zmediaSpecimen_TASK.Resources = {
	{
		Type = "jpg", 
		Filename = "taskspecimen_ppc.jpg", 
		Directives = {}
	}, 
	{
		Type = "jpg", 
		Filename = "taskspecimen_garmin.jpg", 
		Directives = {}
	}
}
zmediaiconoak = Wherigo.ZMedia(cartTheUnseenGardenMoBot)
zmediaiconoak.Id = "79aee89d-094b-4bfe-9ec9-4a9039747812"
zmediaiconoak.Name = _CBm("\113\075\073\045\073\010\115")
zmediaiconoak.Description = ""
zmediaiconoak.AltText = ""
zmediaiconoak.Resources = {
	{
		Type = "jpg", 
		Filename = "iconoak.jpg", 
		Directives = {}
	}
}
zmediaiconsprig = Wherigo.ZMedia(cartTheUnseenGardenMoBot)
zmediaiconsprig.Id = "89f5fe49-6fd3-4918-9167-e611c1a61003"
zmediaiconsprig.Name = _CBm("\113\075\073\045\109\039\126\113\009")
zmediaiconsprig.Description = ""
zmediaiconsprig.AltText = ""
zmediaiconsprig.Resources = {
	{
		Type = "jpg", 
		Filename = "iconsprig.jpg", 
		Directives = {}
	}
}
zmediaiconfruit = Wherigo.ZMedia(cartTheUnseenGardenMoBot)
zmediaiconfruit.Id = "00d1765d-62ac-4e14-b7da-cf11b43b6273"
zmediaiconfruit.Name = _CBm("\113\075\073\045\088\126\111\113\003")
zmediaiconfruit.Description = ""
zmediaiconfruit.AltText = ""
zmediaiconfruit.Resources = {
	{
		Type = "jpg", 
		Filename = "iconfruit.jpg", 
		Directives = {}
	}
}
zmediaiconbooklet = Wherigo.ZMedia(cartTheUnseenGardenMoBot)
zmediaiconbooklet.Id = "6a095f5a-b107-4b68-866d-d0a25e6ba136"
zmediaiconbooklet.Name = _CBm("\113\075\073\045\055\073\073\115\028\098\003")
zmediaiconbooklet.Description = ""
zmediaiconbooklet.AltText = ""
zmediaiconbooklet.Resources = {
	{
		Type = "jpg", 
		Filename = "iconbooklet.jpg", 
		Directives = {}
	}
}
zmediaTrees_TASK = Wherigo.ZMedia(cartTheUnseenGardenMoBot)
zmediaTrees_TASK.Id = "61a5e0aa-2987-4490-804d-bb0601da71dd"
zmediaTrees_TASK.Name = _CBm("\036\126\098\098\109\050\036\020\127\112")
zmediaTrees_TASK.Description = ""
zmediaTrees_TASK.AltText = ""
zmediaTrees_TASK.Resources = {
	{
		Type = "jpg", 
		Filename = "tasktrees_ppc.jpg", 
		Directives = {}
	}, 
	{
		Type = "jpg", 
		Filename = "tasktrees_garmin.jpg", 
		Directives = {}
	}
}
_XL5 = Wherigo.ZMedia(cartTheUnseenGardenMoBot)
_XL5.Id = "a7efbfe2-d395-4557-917e-1529ee1fdedb"
_XL5.Name = _CBm("\049\098\073\075\010\075\063\098")
_XL5.Description = ""
_XL5.AltText = ""
_XL5.Resources = {
	{
		Type = "jpg", 
		Filename = "geocache.jpg", 
		Directives = {}
	}
}
_a0D = Wherigo.ZMedia(cartTheUnseenGardenMoBot)
_a0D.Id = "418f2284-87d8-4a07-9200-d59fcf9a68cf"
_a0D.Name = _CBm("\035\073\045\009\126\010\003\109")
_a0D.Description = ""
_a0D.AltText = ""
_a0D.Resources = {
	{
		Type = "jpg", 
		Filename = "Congrats.jpg", 
		Directives = {}
	}
}
_LDp = Wherigo.ZMedia(cartTheUnseenGardenMoBot)
_LDp.Id = "0bba1901-dc3e-41c9-b685-f0a1f090c046"
_LDp.Name = _CBm("\035\073\045\009\126\010\003\111\028\010\003\113\073\045\109")
_LDp.Description = ""
_LDp.AltText = ""
_LDp.Resources = {
	{
		Type = "jpg", 
		Filename = "Congrats1.jpg", 
		Directives = {}
	}
}
_QSU = Wherigo.ZMedia(cartTheUnseenGardenMoBot)
_QSU.Id = "fdbdba41-952d-47e3-b1f9-dd3764cc728b"
_QSU.Name = _CBm("\049\126\073\111\045\012\001\098\126\073")
_QSU.Description = ""
_QSU.AltText = ""
_QSU.Resources = {
	{
		Type = "jpg", 
		Filename = "UnseenGardenFinalresize.jpg", 
		Directives = {}
	}
}
-- Cartridge Info --
cartTheUnseenGardenMoBot.Id="afd9ff23-478d-4289-b611-e1d5a20cf007"
cartTheUnseenGardenMoBot.Name="The Unseen Garden MoBot"
cartTheUnseenGardenMoBot.Description=[[This wherigo is set at the Missouri Botanical Garden. Help Researcher Hank find three elusive specimens and become part of the Unseen Garden archive's history. Cartridge takes approximately 30 minutes. For more information, please visit www.mobot.org.]]
cartTheUnseenGardenMoBot.Visible=true
cartTheUnseenGardenMoBot.Activity="TourGuide"
cartTheUnseenGardenMoBot.StartingLocationDescription=[[Missouri Botanical Garden]]
cartTheUnseenGardenMoBot.StartingLocation = ZonePoint(38.614665,-90.257667,0)
cartTheUnseenGardenMoBot.Version=""
cartTheUnseenGardenMoBot.Company=""
cartTheUnseenGardenMoBot.Author=""
cartTheUnseenGardenMoBot.BuilderVersion="URWIGO 1.20.5218.24064"
cartTheUnseenGardenMoBot.CreateDate="10/25/2007 12:23:13"
cartTheUnseenGardenMoBot.PublishDate="1/1/0001 12:00:00 AM"
cartTheUnseenGardenMoBot.UpdateDate="12/27/2014 10:09:51"
cartTheUnseenGardenMoBot.LastPlayedDate="1/1/0001 12:00:00 AM"
cartTheUnseenGardenMoBot.TargetDevice="PocketPC"
cartTheUnseenGardenMoBot.TargetDeviceVersion="0"
cartTheUnseenGardenMoBot.StateId="1"
cartTheUnseenGardenMoBot.CountryId="2"
cartTheUnseenGardenMoBot.Complete=false
cartTheUnseenGardenMoBot.UseLogging=true

cartTheUnseenGardenMoBot.Media=zmediaClimatron_ZONE

cartTheUnseenGardenMoBot.Icon=zmediaicon_aboutclimatron


-- Zones --
zoneLinneanHouse = Wherigo.Zone(cartTheUnseenGardenMoBot)
zoneLinneanHouse.Id = "a79432f1-edd7-4a4b-adfe-f8396d1c9499"
zoneLinneanHouse.Name = _CBm("\107\113\045\045\098\010\045\078\122\073\111\109\098")
zoneLinneanHouse.Description = ""
zoneLinneanHouse.Visible = true
zoneLinneanHouse.Media = zmediaLinnean_ZONE
zoneLinneanHouse.Commands = {}
zoneLinneanHouse.DistanceRange = Distance(-1, "feet")
zoneLinneanHouse.ShowObjects = "OnEnter"
zoneLinneanHouse.ProximityRange = Distance(200, "feet")
zoneLinneanHouse.AllowSetPositionTo = false
zoneLinneanHouse.Active = true
zoneLinneanHouse.Points = {
	ZonePoint(38.6150588675355, -90.2577493005944, 0), 
	ZonePoint(38.6148870726153, -90.2577863852501, 0), 
	ZonePoint(38.6148519042433, -90.2574519239425, 0), 
	ZonePoint(38.6150259036502, -90.2574402037048, 0)
}
zoneLinneanHouse.OriginalPoint = ZonePoint(38.61513, -90.25787, 0)
zoneLinneanHouse.DistanceRangeUOM = "Feet"
zoneLinneanHouse.ProximityRangeUOM = "Feet"
zoneLinneanHouse.OutOfRangeName = ""
zoneLinneanHouse.InRangeName = ""
zoneMissouriNativeTreesArea = Wherigo.Zone(cartTheUnseenGardenMoBot)
zoneMissouriNativeTreesArea.Id = "046d683c-742d-4cc1-ad96-c6fcebfee47d"
zoneMissouriNativeTreesArea.Name = _CBm("\119\113\109\109\073\111\126\113\078\032\010\003\113\041\098\078\036\126\098\098\109\078\020\126\098\010")
zoneMissouriNativeTreesArea.Description = _CBm("\032\098\010\126\078\003\063\098\078\030\113\012\009\098\089\010\116\078\035\098\045\003\098\126\067")
zoneMissouriNativeTreesArea.Visible = false
zoneMissouriNativeTreesArea.Media = zmediaTrees_ZONE
zoneMissouriNativeTreesArea.Commands = {}
zoneMissouriNativeTreesArea.DistanceRange = Distance(-1, "feet")
zoneMissouriNativeTreesArea.ShowObjects = "OnEnter"
zoneMissouriNativeTreesArea.ProximityRange = Distance(200, "feet")
zoneMissouriNativeTreesArea.AllowSetPositionTo = false
zoneMissouriNativeTreesArea.Active = false
zoneMissouriNativeTreesArea.Points = {
	ZonePoint(38.6153263941695, -90.2582867066764, 0), 
	ZonePoint(38.6150951006376, -90.2583309348487, 0), 
	ZonePoint(38.615050602787, -90.2580170846558, 0), 
	ZonePoint(38.6152889685776, -90.2579840244673, 0)
}
zoneMissouriNativeTreesArea.OriginalPoint = ZonePoint(38.6155, -90.25874, 0)
zoneMissouriNativeTreesArea.DistanceRangeUOM = "Feet"
zoneMissouriNativeTreesArea.ProximityRangeUOM = "Feet"
zoneMissouriNativeTreesArea.OutOfRangeName = ""
zoneMissouriNativeTreesArea.InRangeName = ""
zoneClimatron = Wherigo.Zone(cartTheUnseenGardenMoBot)
zoneClimatron.Id = "f0f1b6ce-5190-4f4f-b5da-69eff02de84e"
zoneClimatron.Name = _CBm("\035\028\113\024\010\003\126\073\045")
zoneClimatron.Description = ""
zoneClimatron.Visible = false
zoneClimatron.Media = zmediaClimatron_ZONE
zoneClimatron.Commands = {}
zoneClimatron.DistanceRange = Distance(-1, "feet")
zoneClimatron.ShowObjects = "OnEnter"
zoneClimatron.ProximityRange = Distance(200, "feet")
zoneClimatron.AllowSetPositionTo = false
zoneClimatron.Active = false
zoneClimatron.Points = {
	ZonePoint(38.6141910544102, -90.2582371717932, 0), 
	ZonePoint(38.613900707065, -90.2583195042991, 0), 
	ZonePoint(38.6139146034897, -90.2586455104162, 0), 
	ZonePoint(38.6142054631587, -90.2585607876969, 0)
}
zoneClimatron.OriginalPoint = ZonePoint(38.61424, -90.25877, 0)
zoneClimatron.DistanceRangeUOM = "Feet"
zoneClimatron.ProximityRangeUOM = "Feet"
zoneClimatron.OutOfRangeName = ""
zoneClimatron.InRangeName = ""
zoneNorthernRedOak = Wherigo.Zone(cartTheUnseenGardenMoBot)
zoneNorthernRedOak.Id = "9713040f-4dd0-492b-a112-3008c3336c82"
zoneNorthernRedOak.Name = _CBm("\032\073\126\003\063\098\126\045\078\030\098\012\078\072\010\115")
zoneNorthernRedOak.Description = ""
zoneNorthernRedOak.Visible = false
zoneNorthernRedOak.Media = zmediaNorthernRedOak_YouSee
zoneNorthernRedOak.Commands = {}
zoneNorthernRedOak.DistanceRange = Distance(-1, "feet")
zoneNorthernRedOak.ShowObjects = "OnEnter"
zoneNorthernRedOak.ProximityRange = Distance(200, "feet")
zoneNorthernRedOak.AllowSetPositionTo = false
zoneNorthernRedOak.Active = false
zoneNorthernRedOak.Points = {
	ZonePoint(38.614966856354, -90.2587270257949, 0), 
	ZonePoint(38.614966856354, -90.2584709325409, 0), 
	ZonePoint(38.6147836225025, -90.2584441104508, 0), 
	ZonePoint(38.6147857182719, -90.2587364135265, 0)
}
zoneNorthernRedOak.OriginalPoint = ZonePoint(38.61487, -90.25843, 0)
zoneNorthernRedOak.DistanceRangeUOM = "Feet"
zoneNorthernRedOak.ProximityRangeUOM = "Feet"
zoneNorthernRedOak.OutOfRangeName = ""
zoneNorthernRedOak.InRangeName = ""
zoneFringeTree = Wherigo.Zone(cartTheUnseenGardenMoBot)
zoneFringeTree.Id = "c755f79f-8e14-414a-bcd2-3db7799664bd"
zoneFringeTree.Name = _CBm("\058\126\113\045\009\098\078\036\126\098\098")
zoneFringeTree.Description = ""
zoneFringeTree.Visible = false
zoneFringeTree.Media = zmediaFringeTree_YouSee
zoneFringeTree.Commands = {}
zoneFringeTree.DistanceRange = Distance(-1, "feet")
zoneFringeTree.ShowObjects = "OnEnter"
zoneFringeTree.ProximityRange = Distance(200, "feet")
zoneFringeTree.AllowSetPositionTo = false
zoneFringeTree.Active = false
zoneFringeTree.Points = {
	ZonePoint(38.6152594760611, -90.2587875220728, 0), 
	ZonePoint(38.6152589521222, -90.2584985717582, 0), 
	ZonePoint(38.6150657633435, -90.2584878429221, 0), 
	ZonePoint(38.6150662872838, -90.2587982509089, 0)
}
zoneFringeTree.OriginalPoint = ZonePoint(38.61516, -90.25875, 0)
zoneFringeTree.DistanceRangeUOM = "Feet"
zoneFringeTree.ProximityRangeUOM = "Feet"
zoneFringeTree.OutOfRangeName = ""
zoneFringeTree.InRangeName = ""
zoneAmericanHolly = Wherigo.Zone(cartTheUnseenGardenMoBot)
zoneAmericanHolly.Id = "649b8308-e0b4-4cf6-b8d4-35f78f6da3d1"
zoneAmericanHolly.Name = _CBm("\020\024\098\126\113\075\010\045\078\122\073\028\028\116")
zoneAmericanHolly.Description = ""
zoneAmericanHolly.Visible = false
zoneAmericanHolly.Media = zmediaAmericanHolly_YouSee
zoneAmericanHolly.Commands = {}
zoneAmericanHolly.DistanceRange = Distance(-1, "feet")
zoneAmericanHolly.ShowObjects = "OnEnter"
zoneAmericanHolly.ProximityRange = Distance(200, "feet")
zoneAmericanHolly.AllowSetPositionTo = false
zoneAmericanHolly.Active = false
zoneAmericanHolly.Points = {
	ZonePoint(38.6148892911943, -90.2588400588608, 0), 
	ZonePoint(38.6149000242842, -90.258632245369, 0), 
	ZonePoint(38.6146921371618, -90.2585772600841, 0), 
	ZonePoint(38.6146751911942, -90.2588561521148, 0)
}
zoneAmericanHolly.OriginalPoint = ZonePoint(38.61472, -90.25894, 0)
zoneAmericanHolly.DistanceRangeUOM = "Feet"
zoneAmericanHolly.ProximityRangeUOM = "Feet"
zoneAmericanHolly.OutOfRangeName = ""
zoneAmericanHolly.InRangeName = ""
_z14Hx = Wherigo.Zone(cartTheUnseenGardenMoBot)
_z14Hx.Id = "c419c440-67fb-4e74-9e5b-099518939b43"
_z14Hx.Name = _CBm("\049\098\073\075\010\075\063\098")
_z14Hx.Description = _CBm("\021\073\111\078\024\010\116\078\045\073\089\078\039\126\073\075\098\098\012\078\003\073\078\003\063\098\078\088\113\045\010\028\067\078\036\063\098\078\009\098\073\075\010\075\063\098\078\113\109\078\028\073\075\010\003\098\012\078\073\111\003\109\113\012\098\078\073\088\078\003\063\098\078\119\113\109\109\073\111\126\113\078\056\073\003\010\045\113\075\010\028\078\049\010\126\012\098\045\078\010\003\078\032\078\103\082\078\103\062\067\120\120\103\078\029\078\031\085\078\095\062\067\085\031\103\067\078")
_z14Hx.Visible = true
_z14Hx.Media = _XL5
_z14Hx.Icon = _XL5
_z14Hx.Commands = {}
_z14Hx.DistanceRange = Distance(-1, "feet")
_z14Hx.ShowObjects = "OnEnter"
_z14Hx.ProximityRange = Distance(60, "meters")
_z14Hx.AllowSetPositionTo = false
_z14Hx.Active = false
_z14Hx.Points = {
	ZonePoint(38.6072866612126, -90.2682793877316, 0), 
	ZonePoint(38.60741, -90.26828, 0), 
	ZonePoint(38.60743, -90.26816, 0), 
	ZonePoint(38.607292214952, -90.2681465889549, 0)
}
_z14Hx.OriginalPoint = ZonePoint(38.6073547190411, -90.2682164941716, 0)
_z14Hx.DistanceRangeUOM = "Feet"
_z14Hx.ProximityRangeUOM = "Meters"
_z14Hx.OutOfRangeName = ""
_z14Hx.InRangeName = ""

-- Characters --
zcharacterResearcherHank = Wherigo.ZCharacter{
	Cartridge = cartTheUnseenGardenMoBot, 
	Container = zoneLinneanHouse
}
zcharacterResearcherHank.Id = "7c4dfae5-fad6-4691-a175-a2a3d43365e8"
zcharacterResearcherHank.Name = _CBm("\030\098\109\098\010\126\075\063\098\126\078\122\010\045\115")
zcharacterResearcherHank.Description = ""
zcharacterResearcherHank.Visible = true
zcharacterResearcherHank.Media = zmediaResearcherHank
zcharacterResearcherHank.Icon = zmediaiconhank
zcharacterResearcherHank.Commands = {
	Talk = Wherigo.ZCommand{
		Text = _CBm("\036\010\028\115"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _CBm("\032\073\003\063\113\045\009\078\010\041\010\113\028\010\055\028\098")
	}, 
	Examine = Wherigo.ZCommand{
		Text = _CBm("\097\005\010\024\113\045\098"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _CBm("\032\073\003\063\113\045\009\078\010\041\010\113\028\010\055\028\098")
	}
}
zcharacterResearcherHank.Commands.Talk.Custom = true
zcharacterResearcherHank.Commands.Talk.Id = "e6d56032-6b4e-4eb1-b1db-700782cf1a0d"
zcharacterResearcherHank.Commands.Talk.WorksWithAll = true
zcharacterResearcherHank.Commands.Examine.Custom = true
zcharacterResearcherHank.Commands.Examine.Id = "fb7dd2b5-6fc8-41ec-afe1-d73ffb79e476"
zcharacterResearcherHank.Commands.Examine.WorksWithAll = true
zcharacterResearcherHank.ObjectLocation = Wherigo.INVALID_ZONEPOINT
zcharacterResearcherHank.Gender = "Male"
zcharacterResearcherHank.Type = "NPC"
zcharacterAmericanHolly = Wherigo.ZCharacter(cartTheUnseenGardenMoBot)
zcharacterAmericanHolly.Id = "8632454d-97d2-446c-9fb3-439a0d8fedde"
zcharacterAmericanHolly.Name = _CBm("\020\024\098\126\113\075\010\045\078\122\073\028\028\116")
zcharacterAmericanHolly.Description = ""
zcharacterAmericanHolly.Visible = true
zcharacterAmericanHolly.Media = zmediaAmericanHolly_YouSee
zcharacterAmericanHolly.Icon = zmediaiconholly
zcharacterAmericanHolly.Commands = {
	Talk = Wherigo.ZCommand{
		Text = _CBm("\036\010\028\115"), 
		CmdWith = false, 
		Enabled = false, 
		EmptyTargetListText = _CBm("\032\073\003\063\113\045\009\078\010\041\010\113\028\010\055\028\098")
	}, 
	Examine = Wherigo.ZCommand{
		Text = _CBm("\097\005\010\024\113\045\098"), 
		CmdWith = false, 
		Enabled = false, 
		EmptyTargetListText = _CBm("\032\073\003\063\113\045\009\078\010\041\010\113\028\010\055\028\098")
	}
}
zcharacterAmericanHolly.Commands.Talk.Custom = true
zcharacterAmericanHolly.Commands.Talk.Id = "62cc7eb7-ce90-42fc-9dd5-0af202473506"
zcharacterAmericanHolly.Commands.Talk.WorksWithAll = true
zcharacterAmericanHolly.Commands.Examine.Custom = true
zcharacterAmericanHolly.Commands.Examine.Id = "3b92e7db-9d9a-46c1-8b83-34e54875d348"
zcharacterAmericanHolly.Commands.Examine.WorksWithAll = true
zcharacterAmericanHolly.ObjectLocation = Wherigo.INVALID_ZONEPOINT
zcharacterAmericanHolly.Gender = "Female"
zcharacterAmericanHolly.Type = "NPC"
zcharacterNorthernRedOak = Wherigo.ZCharacter(cartTheUnseenGardenMoBot)
zcharacterNorthernRedOak.Id = "4834952e-bd7a-48c1-bcaf-90503be08eba"
zcharacterNorthernRedOak.Name = _CBm("\032\073\126\003\063\098\126\045\078\030\098\012\078\072\010\115")
zcharacterNorthernRedOak.Description = ""
zcharacterNorthernRedOak.Visible = true
zcharacterNorthernRedOak.Media = zmediaNorthernRedOak_YouSee
zcharacterNorthernRedOak.Icon = zmediaiconoak
zcharacterNorthernRedOak.Commands = {
	Talk = Wherigo.ZCommand{
		Text = _CBm("\036\010\028\115"), 
		CmdWith = false, 
		Enabled = false, 
		EmptyTargetListText = _CBm("\032\073\003\063\113\045\009\078\010\041\010\113\028\010\055\028\098")
	}, 
	Examine = Wherigo.ZCommand{
		Text = _CBm("\097\005\010\024\113\045\098"), 
		CmdWith = false, 
		Enabled = false, 
		EmptyTargetListText = _CBm("\032\073\003\063\113\045\009\078\010\041\010\113\028\010\055\028\098")
	}
}
zcharacterNorthernRedOak.Commands.Talk.Custom = true
zcharacterNorthernRedOak.Commands.Talk.Id = "dc4cf334-1f70-4513-ae8b-95246aebfc39"
zcharacterNorthernRedOak.Commands.Talk.WorksWithAll = true
zcharacterNorthernRedOak.Commands.Examine.Custom = true
zcharacterNorthernRedOak.Commands.Examine.Id = "5f88a9f6-fe80-4c7c-af4c-b8cd094cd8f0"
zcharacterNorthernRedOak.Commands.Examine.WorksWithAll = true
zcharacterNorthernRedOak.ObjectLocation = Wherigo.INVALID_ZONEPOINT
zcharacterNorthernRedOak.Gender = "Male"
zcharacterNorthernRedOak.Type = "NPC"
zcharacterFringeTree = Wherigo.ZCharacter(cartTheUnseenGardenMoBot)
zcharacterFringeTree.Id = "765589a9-f490-46bb-bb13-96bfe0bf6aec"
zcharacterFringeTree.Name = _CBm("\058\126\113\045\009\098\078\036\126\098\098")
zcharacterFringeTree.Description = ""
zcharacterFringeTree.Visible = true
zcharacterFringeTree.Media = zmediaFringeTree_YouSee
zcharacterFringeTree.Icon = zmediaiconfringe
zcharacterFringeTree.Commands = {
	Talk = Wherigo.ZCommand{
		Text = _CBm("\036\010\028\115"), 
		CmdWith = false, 
		Enabled = false, 
		EmptyTargetListText = _CBm("\032\073\003\063\113\045\009\078\010\041\010\113\028\010\055\028\098")
	}, 
	Examine = Wherigo.ZCommand{
		Text = _CBm("\097\005\010\024\113\045\098"), 
		CmdWith = false, 
		Enabled = false, 
		EmptyTargetListText = _CBm("\032\073\003\063\113\045\009\078\010\041\010\113\028\010\055\028\098")
	}
}
zcharacterFringeTree.Commands.Talk.Custom = true
zcharacterFringeTree.Commands.Talk.Id = "40a904ce-ff70-4ed8-bf37-5b0ee95af6d9"
zcharacterFringeTree.Commands.Talk.WorksWithAll = true
zcharacterFringeTree.Commands.Examine.Custom = true
zcharacterFringeTree.Commands.Examine.Id = "cf1bc317-b967-4699-b601-dc694ee70b61"
zcharacterFringeTree.Commands.Examine.WorksWithAll = true
zcharacterFringeTree.ObjectLocation = Wherigo.INVALID_ZONEPOINT
zcharacterFringeTree.Gender = "Male"
zcharacterFringeTree.Type = "NPC"

-- Items --
zitemBooklet = Wherigo.ZItem(cartTheUnseenGardenMoBot)
zitemBooklet.Id = "25bb9b3e-75aa-4db9-aa57-61a88e56d847"
zitemBooklet.Name = _CBm("\056\073\073\115\028\098\003")
zitemBooklet.Description = ""
zitemBooklet.Visible = true
zitemBooklet.Media = zmediaBooklet
zitemBooklet.Icon = zmediaiconbooklet
zitemBooklet.Commands = {
	NorthernRedOak = Wherigo.ZCommand{
		Text = _CBm("\032\073\126\003\063\098\126\045\078\030\098\012\078\072\010\115"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _CBm("\032\073\003\063\113\045\009\078\010\041\010\113\028\010\055\028\098")
	}, 
	AmericanHolly = Wherigo.ZCommand{
		Text = _CBm("\020\024\098\126\113\075\010\045\078\122\073\028\028\116"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _CBm("\032\073\003\063\113\045\009\078\010\041\010\113\028\010\055\028\098")
	}, 
	FringeTree = Wherigo.ZCommand{
		Text = _CBm("\058\126\113\045\009\098\078\036\126\098\098"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _CBm("\032\073\003\063\113\045\009\078\010\041\010\113\028\010\055\028\098")
	}
}
zitemBooklet.Commands.NorthernRedOak.Custom = true
zitemBooklet.Commands.NorthernRedOak.Id = "ce759053-ce4c-40b7-8463-740e102b9b08"
zitemBooklet.Commands.NorthernRedOak.WorksWithAll = true
zitemBooklet.Commands.AmericanHolly.Custom = true
zitemBooklet.Commands.AmericanHolly.Id = "233433d7-9625-425c-b958-cf0873c64e82"
zitemBooklet.Commands.AmericanHolly.WorksWithAll = true
zitemBooklet.Commands.FringeTree.Custom = true
zitemBooklet.Commands.FringeTree.Id = "2bc3239a-72d7-49a2-90ec-135d8ac3b635"
zitemBooklet.Commands.FringeTree.WorksWithAll = true
zitemBooklet.ObjectLocation = Wherigo.INVALID_ZONEPOINT
zitemBooklet.Locked = false
zitemBooklet.Opened = false
zitemFruit = Wherigo.ZItem(cartTheUnseenGardenMoBot)
zitemFruit.Id = "1ee79cb0-9825-4c5a-88ba-6e4912fade43"
zitemFruit.Name = _CBm("\058\126\111\113\003")
zitemFruit.Description = ""
zitemFruit.Visible = true
zitemFruit.Media = zmediaFruit
zitemFruit.Icon = zmediaiconfruit
zitemFruit.Commands = {
	Examine = Wherigo.ZCommand{
		Text = _CBm("\097\005\010\024\113\045\098"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _CBm("\032\073\003\063\113\045\009\078\010\041\010\113\028\010\055\028\098")
	}, 
	Give = Wherigo.ZCommand{
		Text = _CBm("\049\113\041\098"), 
		CmdWith = true, 
		Enabled = false, 
		EmptyTargetListText = _CBm("\032\073\003\063\113\045\009\078\010\041\010\113\028\010\055\028\098")
	}
}
zitemFruit.Commands.Examine.Custom = true
zitemFruit.Commands.Examine.Id = "0b7a1661-a803-4bf9-a8ed-b1a2c9deafa1"
zitemFruit.Commands.Examine.WorksWithAll = true
zitemFruit.Commands.Give.Custom = true
zitemFruit.Commands.Give.Id = "8225a8e1-f2c9-4c06-b372-b6a7b35149ad"
zitemFruit.Commands.Give.WorksWithAll = false
zitemFruit.Commands.Give.WorksWithListIds = {
	"7c4dfae5-fad6-4691-a175-a2a3d43365e8"
}
zitemFruit.ObjectLocation = Wherigo.INVALID_ZONEPOINT
zitemFruit.Locked = false
zitemFruit.Opened = false
zitemLeaf = Wherigo.ZItem(cartTheUnseenGardenMoBot)
zitemLeaf.Id = "2a13dff6-30b6-4cd4-8790-0dcf0ed822d9"
zitemLeaf.Name = _CBm("\107\098\010\088")
zitemLeaf.Description = ""
zitemLeaf.Visible = true
zitemLeaf.Media = zmediaLeaf
zitemLeaf.Icon = zmediaiconsprig
zitemLeaf.Commands = {
	Examine = Wherigo.ZCommand{
		Text = _CBm("\097\005\010\024\113\045\098"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _CBm("\032\073\003\063\113\045\009\078\010\041\010\113\028\010\055\028\098")
	}, 
	Give = Wherigo.ZCommand{
		Text = _CBm("\049\113\041\098"), 
		CmdWith = true, 
		Enabled = false, 
		EmptyTargetListText = _CBm("\032\073\003\063\113\045\009\078\010\041\010\113\028\010\055\028\098")
	}
}
zitemLeaf.Commands.Examine.Custom = true
zitemLeaf.Commands.Examine.Id = "35756345-0b9f-4879-beae-56d13d6fbb33"
zitemLeaf.Commands.Examine.WorksWithAll = true
zitemLeaf.Commands.Give.Custom = true
zitemLeaf.Commands.Give.Id = "fdd5911a-0b99-48c6-b42d-89bca1f1acfd"
zitemLeaf.Commands.Give.WorksWithAll = false
zitemLeaf.Commands.Give.WorksWithListIds = {
	"7c4dfae5-fad6-4691-a175-a2a3d43365e8"
}
zitemLeaf.ObjectLocation = Wherigo.INVALID_ZONEPOINT
zitemLeaf.Locked = false
zitemLeaf.Opened = false
zitemBark = Wherigo.ZItem(cartTheUnseenGardenMoBot)
zitemBark.Id = "6846be50-ffd2-48e7-ae74-121aade0d30c"
zitemBark.Name = _CBm("\056\010\126\115")
zitemBark.Description = ""
zitemBark.Visible = true
zitemBark.Media = zmediaBark
zitemBark.Icon = zmediaiconbark
zitemBark.Commands = {
	Examine = Wherigo.ZCommand{
		Text = _CBm("\097\005\010\024\113\045\098"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _CBm("\032\073\003\063\113\045\009\078\010\041\010\113\028\010\055\028\098")
	}, 
	Give = Wherigo.ZCommand{
		Text = _CBm("\049\113\041\098"), 
		CmdWith = true, 
		Enabled = false, 
		EmptyTargetListText = _CBm("\032\073\003\063\113\045\009\078\010\041\010\113\028\010\055\028\098")
	}
}
zitemBark.Commands.Examine.Custom = true
zitemBark.Commands.Examine.Id = "8aa6ee86-b2ba-4762-b2bc-eef4cd9a5ff0"
zitemBark.Commands.Examine.WorksWithAll = true
zitemBark.Commands.Give.Custom = true
zitemBark.Commands.Give.Id = "c580f6be-a36b-4223-a918-f0bd4111d834"
zitemBark.Commands.Give.WorksWithAll = false
zitemBark.Commands.Give.WorksWithListIds = {
	"7c4dfae5-fad6-4691-a175-a2a3d43365e8"
}
zitemBark.ObjectLocation = Wherigo.INVALID_ZONEPOINT
zitemBark.Locked = false
zitemBark.Opened = false
zitemSecretHelperBadge = Wherigo.ZItem(cartTheUnseenGardenMoBot)
zitemSecretHelperBadge.Id = "2229e812-2e24-40cb-9457-f3c79474c19d"
zitemSecretHelperBadge.Name = _CBm("\127\098\075\126\098\003\078\122\098\028\039\098\126\078\056\010\012\009\098")
zitemSecretHelperBadge.Description = ""
zitemSecretHelperBadge.Visible = true
zitemSecretHelperBadge.Media = zmediaBadge
zitemSecretHelperBadge.Icon = zmediaiconbadge
zitemSecretHelperBadge.Commands = {
	Examine = Wherigo.ZCommand{
		Text = _CBm("\097\005\010\024\113\045\098"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _CBm("\032\073\003\063\113\045\009\078\010\041\010\113\028\010\055\028\098")
	}
}
zitemSecretHelperBadge.Commands.Examine.Custom = true
zitemSecretHelperBadge.Commands.Examine.Id = "2266ffcc-ac3a-4bba-af6e-f9d954d1d3be"
zitemSecretHelperBadge.Commands.Examine.WorksWithAll = true
zitemSecretHelperBadge.ObjectLocation = Wherigo.INVALID_ZONEPOINT
zitemSecretHelperBadge.Locked = false
zitemSecretHelperBadge.Opened = false
zitemAbouttheLinneanHouse = Wherigo.ZItem{
	Cartridge = cartTheUnseenGardenMoBot, 
	Container = zoneLinneanHouse
}
zitemAbouttheLinneanHouse.Id = "85d63bb1-8f40-4fec-ab44-a49deb0f91ef"
zitemAbouttheLinneanHouse.Name = _CBm("\020\055\073\111\003\078\003\063\098\078\107\113\045\045\098\010\045\078\122\073\111\109\098")
zitemAbouttheLinneanHouse.Description = _CBm("\030\113\009\063\003\078\045\073\089\078\116\073\111\078\010\126\098\078\028\073\073\115\113\045\009\078\010\003\078\073\045\098\078\073\088\078\003\063\098\078\073\028\012\098\109\003\078\009\126\098\098\045\063\073\111\109\098\109\078\113\045\078\020\024\098\126\113\075\010\067\078\093\003\078\089\010\109\078\055\111\113\028\003\078\113\045\078\095\082\082\080\078\055\116\078\122\098\045\126\116\078\127\063\010\089\064\078\003\063\098\078\088\073\111\045\012\098\126\078\073\088\078\003\063\098\078\119\113\109\109\113\073\111\126\113\078\056\073\003\010\045\113\075\010\028\078\049\010\126\012\098\045\067\078\105\056\030\069\036\063\098\078\107\113\045\045\098\010\045\078\009\126\098\098\045\063\073\111\109\098\078\010\003\003\126\010\075\003\109\078\041\113\109\113\003\073\126\109\078\012\111\126\113\045\009\078\089\113\045\003\098\126\078\003\113\024\098\078\089\113\003\063\078\039\113\045\115\078\010\045\012\078\116\098\028\028\073\089\078\035\010\024\098\028\028\113\010\109\067\078\107\073\073\115\078\088\073\126\078\003\063\098\024\124\078\036\063\098\116\096\126\098\078\087\111\113\003\098\078\010\055\111\045\012\010\045\003\067")
zitemAbouttheLinneanHouse.Visible = true
zitemAbouttheLinneanHouse.Media = zmediaLinnean_ABOUT
zitemAbouttheLinneanHouse.Icon = zmediaicon_aboutlinnean
zitemAbouttheLinneanHouse.Commands = {}
zitemAbouttheLinneanHouse.ObjectLocation = Wherigo.INVALID_ZONEPOINT
zitemAbouttheLinneanHouse.Locked = false
zitemAbouttheLinneanHouse.Opened = false
zitemAbouttheClimatron = Wherigo.ZItem{
	Cartridge = cartTheUnseenGardenMoBot, 
	Container = zoneClimatron
}
zitemAbouttheClimatron.Id = "23c03d79-c901-4002-a802-d13eb7f4cf25"
zitemAbouttheClimatron.Name = _CBm("\020\055\073\111\003\078\003\063\098\078\035\028\113\024\010\003\126\073\045")
zitemAbouttheClimatron.Description = _CBm("\093\024\010\009\113\045\098\078\010\078\028\111\109\063\078\009\126\098\098\045\078\003\126\073\039\113\075\010\028\078\126\010\113\045\088\073\126\098\109\003\078\010\028\028\078\116\098\010\126\067\078\036\063\098\078\035\028\113\024\010\003\126\073\045\078\073\088\078\003\063\098\078\119\113\109\109\073\111\126\113\078\056\073\003\010\045\113\075\010\028\078\049\010\126\012\098\045\078\089\010\109\078\055\111\113\028\003\078\113\045\078\095\031\062\085\064\078\010\045\012\078\126\098\045\073\041\010\003\098\012\078\113\045\078\095\031\082\082\064\078\003\073\078\063\073\111\109\098\078\073\041\098\126\078\095\064\080\085\085\078\109\039\098\075\113\098\109\078\073\088\078\039\028\010\045\003\109\078\010\045\012\078\003\126\073\039\113\075\010\028\078\010\045\113\024\010\028\109\067\105\056\030\069\020\109\115\078\010\055\073\111\003\078\003\063\098\078\035\116\075\010\012\109\064\078\073\045\098\078\073\088\078\003\063\098\078\073\028\012\098\109\003\078\039\028\010\045\003\109\078\010\028\113\041\098\067\078\036\063\098\113\126\078\010\045\075\113\098\045\003\078\126\098\028\010\003\113\041\098\109\078\075\010\045\078\055\098\078\003\126\010\075\098\012\078\055\010\075\115\078\045\098\010\126\028\116\078\103\085\085\078\024\113\028\028\113\073\045\078\116\098\010\126\109\078\089\063\098\045\078\012\113\045\073\109\010\111\126\109\078\109\003\113\028\028\078\126\073\010\024\098\012\078\003\063\098\078\098\010\126\003\063\124")
zitemAbouttheClimatron.Visible = true
zitemAbouttheClimatron.Media = zmediaClimatron_ABOUT
zitemAbouttheClimatron.Icon = zmediaicon_aboutclimatron
zitemAbouttheClimatron.Commands = {}
zitemAbouttheClimatron.ObjectLocation = Wherigo.INVALID_ZONEPOINT
zitemAbouttheClimatron.Locked = false
zitemAbouttheClimatron.Opened = false
zitemAbouttheUnseenGarden = Wherigo.ZItem{
	Cartridge = cartTheUnseenGardenMoBot, 
	Container = zoneLinneanHouse
}
zitemAbouttheUnseenGarden.Id = "a253dd6e-b9a1-475d-9069-808d507b5302"
zitemAbouttheUnseenGarden.Name = _CBm("\020\055\073\111\003\078\003\063\098\078\061\045\109\098\098\045\078\049\010\126\012\098\045")
zitemAbouttheUnseenGarden.Description = _CBm("\036\063\098\078\061\045\109\098\098\045\078\049\010\126\012\098\045\078\113\109\078\010\045\078\113\045\003\098\126\045\010\003\113\073\045\010\028\078\126\098\109\098\010\126\075\063\078\098\045\003\098\126\039\126\113\109\098\078\010\003\078\003\063\098\078\119\113\109\109\073\111\126\113\078\056\073\003\010\045\113\075\010\028\078\049\010\126\012\098\045\067\105\056\030\069\036\063\098\126\098\078\010\126\098\078\108\085\078\055\073\003\010\045\113\109\003\109\078\010\045\012\078\073\041\098\126\078\095\085\085\078\041\073\028\111\045\003\098\098\126\109\078\010\028\028\078\089\073\126\115\113\045\009\078\003\073\089\010\126\012\109\078\010\078\109\113\045\009\028\098\078\009\073\010\028\078\073\088\078\028\098\010\126\045\113\045\009\078\010\055\073\111\003\078\039\028\010\045\003\109\078\010\045\012\078\010\126\075\063\113\041\113\045\009\078\003\063\098\024\067\078\036\063\098\113\126\078\039\028\010\045\003\078\010\126\075\063\113\041\098\078\109\063\098\028\041\098\109\078\098\005\003\098\045\012\078\088\126\073\024\078\088\028\073\073\126\078\003\073\078\075\098\113\028\113\045\009\124")
zitemAbouttheUnseenGarden.Visible = true
zitemAbouttheUnseenGarden.Media = zmediaUnseenGarden_ABOUT
zitemAbouttheUnseenGarden.Icon = zmediaicon_aboutunseen
zitemAbouttheUnseenGarden.Commands = {}
zitemAbouttheUnseenGarden.ObjectLocation = Wherigo.INVALID_ZONEPOINT
zitemAbouttheUnseenGarden.Locked = false
zitemAbouttheUnseenGarden.Opened = false
_Op1jc = Wherigo.ZItem(cartTheUnseenGardenMoBot)
_Op1jc.Id = "c80a4e31-e95a-4428-8bac-71a6ff10dba1"
_Op1jc.Name = _CBm("\035\073\024\039\028\098\003\113\073\045\078\035\073\012\098")
_Op1jc.Description = ""
_Op1jc.Visible = true
_Op1jc.Commands = {}
_Op1jc.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_Op1jc.Locked = false
_Op1jc.Opened = false

-- Tasks --
ztaskCollect3Specimens = Wherigo.ZTask(cartTheUnseenGardenMoBot)
ztaskCollect3Specimens.Id = "66692262-1bef-4871-8681-aaba2aba66d6"
ztaskCollect3Specimens.Name = _CBm("\035\073\028\028\098\075\003\078\103\078\127\039\098\075\113\024\098\045\109")
ztaskCollect3Specimens.Description = _CBm("\036\063\098\078\061\045\109\098\098\045\078\049\010\126\012\098\045\078\045\098\098\012\109\078\116\073\111\126\078\063\098\028\039\078\003\073\078\075\073\028\028\098\075\003\078\003\063\098\078\088\113\045\010\028\078\103\078\109\039\098\075\113\024\098\045\109\067")
ztaskCollect3Specimens.Visible = false
ztaskCollect3Specimens.Media = zmediaSpecimen_TASK
ztaskCollect3Specimens.Active = false
ztaskCollect3Specimens.Complete = false
ztaskCollect3Specimens.CorrectState = "None"
ztaskMeettheTrees = Wherigo.ZTask(cartTheUnseenGardenMoBot)
ztaskMeettheTrees.Id = "4431a60c-44ca-4ccd-a8b7-84330803dcc8"
ztaskMeettheTrees.Name = _CBm("\119\098\098\003\078\003\063\098\078\036\126\098\098\109")
ztaskMeettheTrees.Description = _CBm("\058\113\045\012\078\113\045\012\113\041\113\012\111\010\028\078\003\126\098\098\109\078\055\116\078\088\073\028\028\073\089\113\045\009\078\003\063\098\078\126\098\012\078\010\126\126\073\089\067\078\036\010\028\115\078\003\073\078\003\063\098\024\078\003\073\078\010\075\087\111\113\126\098\078\024\073\126\098\078\113\045\088\073\126\024\010\003\113\073\045\067")
ztaskMeettheTrees.Visible = false
ztaskMeettheTrees.Media = zmediaTrees_TASK
ztaskMeettheTrees.Active = false
ztaskMeettheTrees.Complete = false
ztaskMeettheTrees.CorrectState = "None"
ztaskReturnthespecimens = Wherigo.ZTask(cartTheUnseenGardenMoBot)
ztaskReturnthespecimens.Id = "f714b942-3279-49fd-a929-2f4d17d65cc9"
ztaskReturnthespecimens.Name = _CBm("\030\098\003\111\126\045\078\003\063\098\078\109\039\098\075\113\024\098\045\109")
ztaskReturnthespecimens.Description = _CBm("\049\073\078\003\073\078\003\063\098\078\035\028\113\024\010\003\126\073\045\078\003\073\078\024\098\098\003\078\111\039\078\089\113\003\063\078\030\098\109\098\010\126\075\063\098\126\078\122\010\045\115\067\078\049\113\041\098\078\063\113\024\078\003\063\098\078\113\003\098\024\109\078\113\045\078\116\073\111\126\078\113\045\041\098\045\003\073\126\116\067")
ztaskReturnthespecimens.Visible = true
ztaskReturnthespecimens.Media = zmediaClimatron_TASK
ztaskReturnthespecimens.Active = false
ztaskReturnthespecimens.Complete = false
ztaskReturnthespecimens.CorrectState = "None"
ztaskGototheNativeTreesArea = Wherigo.ZTask(cartTheUnseenGardenMoBot)
ztaskGototheNativeTreesArea.Id = "d0547516-7544-4f50-b17d-ddcd4c9f8baf"
ztaskGototheNativeTreesArea.Name = _CBm("\049\073\078\003\073\078\003\063\098\078\032\010\003\113\041\098\078\036\126\098\098\109\078\020\126\098\010")
ztaskGototheNativeTreesArea.Description = _CBm("\036\063\098\078\109\039\098\075\113\024\098\045\109\078\116\073\111\078\045\098\098\012\078\003\073\078\075\073\028\028\098\075\003\078\010\126\098\078\113\045\078\003\063\098\078\119\113\109\109\073\111\126\113\078\032\010\003\113\041\098\078\036\126\098\098\109\078\020\126\098\010")
ztaskGototheNativeTreesArea.Visible = false
ztaskGototheNativeTreesArea.Media = zmediaTrees_ZONE
ztaskGototheNativeTreesArea.Active = false
ztaskGototheNativeTreesArea.Complete = false
ztaskGototheNativeTreesArea.CorrectState = "None"
ztaskGototheLinneanHouse = Wherigo.ZTask(cartTheUnseenGardenMoBot)
ztaskGototheLinneanHouse.Id = "08def541-eb60-45cd-b121-d3db829cf3dc"
ztaskGototheLinneanHouse.Name = _CBm("\049\073\078\003\073\078\003\063\098\078\107\113\045\045\098\010\045\078\122\073\111\109\098")
ztaskGototheLinneanHouse.Description = _CBm("\127\073\024\098\073\045\098\078\113\109\078\089\010\113\003\113\045\009\078\003\063\098\126\098\078\088\073\126\078\116\073\111\067\067\067")
ztaskGototheLinneanHouse.Visible = false
ztaskGototheLinneanHouse.Media = zmediaLinnean_TASK
ztaskGototheLinneanHouse.Active = false
ztaskGototheLinneanHouse.Complete = false
ztaskGototheLinneanHouse.CorrectState = "None"

-- Cartridge Variables --
HankTalk = 0
FringeComplete = 0
FringeQ1Answer = ""
GiveSpecimens = 0
OakQuest = 0
OakQ1Answer = ""
OakComplete = 0
FringeQ2Answer = ""
HollyQuest = 0
Booklet = ""
HollyQ3Answer = ""
HollyQ2Answer = ""
OakQ2Answer = ""
FringeQ3Answer = ""
OakQ3Answer = ""
HollyComplete = 0
HollyQ1Answer = ""
FringeQuest = 0
_Yg7n = ""
_Z8Q = _CBm("\057\073\045\098\107\113\045\045\098\010\045\122\073\111\109\098")
_MrNEa = _CBm("\057\075\063\010\126\010\075\003\098\126\030\098\109\098\010\126\075\063\098\126\122\010\045\115")
_ZvqwF = _CBm("\057\113\003\098\024\056\073\073\115\028\098\003")
_pPNIP = _CBm("\057\003\010\109\115\035\073\028\028\098\075\003\103\127\039\098\075\113\024\098\045\109")
_g8Or = _CBm("\057\113\045\039\111\003\122\073\028\028\116\037\095")
_8gwEH = _CBm("\012\111\024\024\116")
cartTheUnseenGardenMoBot.ZVariables = {
	HankTalk = 0, 
	FringeComplete = 0, 
	FringeQ1Answer = "", 
	GiveSpecimens = 0, 
	OakQuest = 0, 
	OakQ1Answer = "", 
	OakComplete = 0, 
	FringeQ2Answer = "", 
	HollyQuest = 0, 
	Booklet = "", 
	HollyQ3Answer = "", 
	HollyQ2Answer = "", 
	OakQ2Answer = "", 
	FringeQ3Answer = "", 
	OakQ3Answer = "", 
	HollyComplete = 0, 
	HollyQ1Answer = "", 
	FringeQuest = 0, 
	_Yg7n = "", 
	_Z8Q = _CBm("\057\073\045\098\107\113\045\045\098\010\045\122\073\111\109\098"), 
	_MrNEa = _CBm("\057\075\063\010\126\010\075\003\098\126\030\098\109\098\010\126\075\063\098\126\122\010\045\115"), 
	_ZvqwF = _CBm("\057\113\003\098\024\056\073\073\115\028\098\003"), 
	_pPNIP = _CBm("\057\003\010\109\115\035\073\028\028\098\075\003\103\127\039\098\075\113\024\098\045\109"), 
	_g8Or = _CBm("\057\113\045\039\111\003\122\073\028\028\116\037\095"), 
	_8gwEH = _CBm("\012\111\024\024\116")
}

-- Timers --

-- Inputs --
zinputHollyQ1 = Wherigo.ZInput(cartTheUnseenGardenMoBot)
zinputHollyQ1.Id = "01db18d7-2b26-4967-9001-7646d3c103af"
zinputHollyQ1.Name = _CBm("\122\073\028\028\116\037\095")
zinputHollyQ1.Description = ""
zinputHollyQ1.Visible = true
zinputHollyQ1.Choices = {
	"French", 
	"Dutch", 
	"Russian", 
	"American"
}
zinputHollyQ1.InputType = "MultipleChoice"
zinputHollyQ1.Text = _CBm("\004\093\088\078\093\078\089\098\126\098\078\010\078\088\028\010\009\064\078\024\116\078\075\073\028\073\126\109\078\089\073\111\028\012\078\055\098\078\126\098\012\064\078\089\063\113\003\098\064\078\010\045\012\078\055\028\111\098\067\078\029\063\010\003\078\003\116\039\098\078\073\088\078\122\073\028\028\116\078\010\024\078\093\016\004")
zinputHollyQ2 = Wherigo.ZInput(cartTheUnseenGardenMoBot)
zinputHollyQ2.Id = "f6663772-03c8-4483-b494-1ccd4443d8e2"
zinputHollyQ2.Name = _CBm("\122\073\028\028\116\037\080")
zinputHollyQ2.Description = ""
zinputHollyQ2.Visible = true
zinputHollyQ2.Choices = {
	"Rough", 
	"Waxy", 
	"Velvety", 
	"Hairy"
}
zinputHollyQ2.InputType = "MultipleChoice"
zinputHollyQ2.Text = _CBm("\004\058\098\098\028\078\024\116\078\028\098\010\041\098\109\067\078\122\073\089\078\089\073\111\028\012\078\116\073\111\078\012\098\109\075\126\113\055\098\078\003\063\098\078\003\098\005\003\111\126\098\016\004")
zinputHollyQ3 = Wherigo.ZInput(cartTheUnseenGardenMoBot)
zinputHollyQ3.Id = "4bc0842b-60ce-4def-a1ae-1526ba533656"
zinputHollyQ3.Name = _CBm("\122\073\028\028\116\037\103")
zinputHollyQ3.Description = ""
zinputHollyQ3.Visible = true
zinputHollyQ3.Choices = {
	"Bright orange", 
	"Yellow tint", 
	"Green", 
	"Red"
}
zinputHollyQ3.InputType = "MultipleChoice"
zinputHollyQ3.Text = _CBm("\004\029\063\010\003\078\075\073\028\073\126\078\010\126\098\078\024\116\078\028\098\010\041\098\109\078\012\111\126\113\045\009\078\088\010\028\028\016\004")
zinputOakQ1 = Wherigo.ZInput(cartTheUnseenGardenMoBot)
zinputOakQ1.Id = "1053882c-6223-49af-b0e7-6ba96a7236c7"
zinputOakQ1.Name = _CBm("\072\010\115\037\095")
zinputOakQ1.Description = ""
zinputOakQ1.Visible = true
zinputOakQ1.InputType = "Text"
zinputOakQ1.Text = _CBm("\004\029\098\078\063\010\041\098\078\024\010\045\116\078\012\113\088\088\098\126\098\045\003\078\045\010\024\098\109\064\078\055\111\003\078\093\078\075\073\024\098\078\088\126\073\024\078\010\078\041\098\126\116\078\109\039\098\075\113\088\113\075\078\055\126\010\045\075\063\078\038\063\098\063\098\064\078\009\098\003\078\113\003\016\054\067\078\036\063\113\045\115\078\073\088\078\010\078\039\063\126\010\109\098\078\003\063\010\003\078\113\109\078\073\039\039\073\109\113\003\098\078\088\126\073\024\078\096\127\073\111\003\063\098\126\045\078\049\126\098\098\045\096\067\078\029\063\010\003\078\113\109\078\024\116\078\075\073\024\024\073\045\078\045\010\024\098\016\004")
zinputOakQ2 = Wherigo.ZInput(cartTheUnseenGardenMoBot)
zinputOakQ2.Id = "6bdf01ea-3a49-4a56-9726-ece202ea6233"
zinputOakQ2.Name = _CBm("\072\010\115\037\080")
zinputOakQ2.Description = ""
zinputOakQ2.Visible = true
zinputOakQ2.InputType = "Text"
zinputOakQ2.Text = _CBm("\004\093\088\078\024\116\078\039\073\028\028\113\045\010\003\113\073\045\078\063\010\039\039\098\045\109\078\113\045\078\118\010\045\111\010\126\116\064\078\012\111\126\113\045\009\078\089\063\113\075\063\078\024\073\045\003\063\078\012\073\078\003\063\098\078\088\126\111\113\003\109\078\126\113\039\098\045\016\004")
zinputOakQ3 = Wherigo.ZInput(cartTheUnseenGardenMoBot)
zinputOakQ3.Id = "bcdaf354-1ded-4865-af92-9a4cb987399f"
zinputOakQ3.Name = _CBm("\072\010\115\037\103")
zinputOakQ3.Description = ""
zinputOakQ3.Visible = true
zinputOakQ3.Choices = {
	"Big black bumps", 
	"White blotchy spots", 
	"Rough deep vertical wrinkles", 
	"Smooth gray"
}
zinputOakQ3.InputType = "MultipleChoice"
zinputOakQ3.Text = _CBm("\004\036\010\115\098\078\010\078\028\073\073\115\078\010\003\078\024\116\078\055\010\126\115\067\078\122\073\089\078\089\073\111\028\012\078\116\073\111\078\012\098\109\075\126\113\055\098\078\113\003\016\078\036\126\116\078\003\073\111\075\063\113\045\009\078\113\003\078\113\088\078\116\073\111\078\089\010\045\003\067\004")
zinputFringeQ1 = Wherigo.ZInput(cartTheUnseenGardenMoBot)
zinputFringeQ1.Id = "a787f704-8833-422c-a9cc-5945064ca3f8"
zinputFringeQ1.Name = _CBm("\058\126\113\045\009\098\037\095")
zinputFringeQ1.Description = ""
zinputFringeQ1.Visible = true
zinputFringeQ1.Choices = {
	"Old Man's Beard", 
	"Grancy Holly", 
	"White Palm", 
	"Rubber Tree"
}
zinputFringeQ1.InputType = "MultipleChoice"
zinputFringeQ1.Text = _CBm("\004\086\098\073\039\028\098\078\075\010\028\028\078\024\098\078\096\058\126\113\045\009\098\078\036\126\098\098\096\078\055\098\075\010\111\109\098\078\073\088\078\024\116\078\088\028\073\089\098\126\109\067\078\093\078\063\010\041\098\078\010\045\073\003\063\098\126\078\045\010\024\098\078\003\063\010\003\078\088\113\003\109\078\024\116\078\039\098\126\109\073\045\010\028\113\003\116\078\055\098\003\003\098\126\067\078\029\063\010\003\078\113\109\078\113\003\016\004")
zinputFringeQ2 = Wherigo.ZInput(cartTheUnseenGardenMoBot)
zinputFringeQ2.Id = "4c36db02-bd16-46e4-a96b-3f2b1ce98765"
zinputFringeQ2.Name = _CBm("\058\126\113\045\009\098\037\080")
zinputFringeQ2.Description = ""
zinputFringeQ2.Visible = true
zinputFringeQ2.Choices = {
	"Sleeping problems ", 
	"Breathing problems", 
	"Tooth ache", 
	"Skin problems"
}
zinputFringeQ2.InputType = "MultipleChoice"
zinputFringeQ2.Text = _CBm("\004\119\116\078\055\010\126\115\078\075\010\045\078\055\098\078\111\109\098\012\078\003\073\078\003\126\098\010\003\078\089\063\113\075\063\078\075\073\045\012\113\003\113\073\045\109\016\004")
zinputFringeQ3 = Wherigo.ZInput(cartTheUnseenGardenMoBot)
zinputFringeQ3.Id = "dc94b5bb-9909-4ce1-a651-7599ea255dcc"
zinputFringeQ3.Name = _CBm("\058\126\113\045\009\098\037\103")
zinputFringeQ3.Description = ""
zinputFringeQ3.Visible = true
zinputFringeQ3.Choices = {
	"Needlelike leaves; sharp margins", 
	"Glossy leaves; smooth margins", 
	"Hairy leaves; teethed margins", 
	"Rough leaves; smooth margins"
}
zinputFringeQ3.InputType = "MultipleChoice"
zinputFringeQ3.Text = _CBm("\004\036\126\116\078\012\098\109\075\126\113\055\113\045\009\078\024\116\078\028\098\010\041\098\109\067\078\122\111\024\073\126\078\024\098\067\004")
_93W = Wherigo.ZInput(cartTheUnseenGardenMoBot)
_93W.Id = "d1dd8460-8aa1-4f02-8338-ca527998ccad"
_93W.Name = _CBm("\104\113\012\078\116\073\111\078\058\113\045\012\078\003\063\098\078\049\098\073\075\010\075\063\098\016")
_93W.Description = ""
_93W.Visible = true
_93W.Media = _XL5
_93W.Icon = _XL5
_93W.Choices = {
	"Found it", 
	"Didn't Find it"
}
_93W.InputType = "MultipleChoice"
_93W.Text = _CBm("\104\113\012\078\116\073\111\078\088\113\045\012\078\003\063\098\078\009\098\073\075\010\075\063\098\016")

-- WorksWithList for object commands --
zitemFruit.Commands.Give.WorksWithList = {
	zcharacterResearcherHank
}
zitemLeaf.Commands.Give.WorksWithList = {
	zcharacterResearcherHank
}
zitemBark.Commands.Give.WorksWithList = {
	zcharacterResearcherHank
}

-- functions --
function cartTheUnseenGardenMoBot:OnStart()
	_Urwigo.OldDialog{
		{
			Text = _CBm("\036\063\098\078\061\045\109\098\098\045\078\049\010\126\012\098\045\078\045\098\098\012\109\078\116\073\111\126\078\063\098\028\039\124\078\127\073\024\098\073\045\098\078\113\109\078\010\045\005\113\073\111\109\028\116\078\010\089\010\113\003\113\045\009\078\116\073\111\126\078\010\126\126\113\041\010\028\078\010\003\078\003\063\098\078\107\113\045\045\098\010\045\078\122\073\111\109\098\067\067\067")
		}, 
		{
			Text = _CBm("\032\098\089\078\036\010\109\115\106\078\049\073\078\003\073\078\003\063\098\078\107\113\045\045\098\010\045\078\122\073\111\109\098\105\056\030\069\105\056\030\069\035\063\098\075\115\078\003\063\098\078\096\107\073\075\010\003\113\073\045\109\096\078\003\010\055\078\003\073\078\045\010\041\113\009\010\003\098\067"), 
			Media = zmediaLinnean_TASK
		}
	}
	ztaskGototheLinneanHouse.Visible = true
	ztaskGototheLinneanHouse.Active = true
end
function cartTheUnseenGardenMoBot:OnRestore()
end
function zoneLinneanHouse:OnEnter()
	_Z8Q = _CBm("\057\073\045\098\107\113\045\045\098\010\045\122\073\111\109\098")
	if ztaskGototheLinneanHouse.Complete == false then
		_Urwigo.OldDialog{
			{
				Text = _CBm("\004\021\073\111\078\024\010\012\098\078\113\003\124\078\119\116\078\045\010\024\098\078\113\109\078\122\010\045\115\067\078\093\096\024\078\003\063\098\078\028\098\010\012\078\030\098\109\098\010\126\075\063\098\126\078\088\073\126\078\003\063\098\078\061\045\109\098\098\045\078\049\010\126\012\098\045\067\078\105\056\030\069\105\056\030\069\004\093\088\078\116\073\111\096\126\098\078\075\111\126\113\073\111\109\078\010\055\073\111\003\078\111\109\064\078\126\098\010\012\078\096\020\055\073\111\003\078\003\063\098\078\061\045\109\098\098\045\078\049\010\126\012\098\045\096\078\111\045\012\098\126\078\003\063\098\078\096\021\073\111\078\127\098\098\096\078\003\010\055\067\004"), 
				Media = zmediaResearcherHank_MSG
			}, 
			{
				Text = _CBm("\004\072\111\126\078\009\073\010\028\078\003\063\113\109\078\024\073\045\003\063\078\113\109\078\003\073\078\075\073\028\028\098\075\003\078\095\085\064\085\085\085\078\039\028\010\045\003\078\109\039\098\075\113\024\098\045\109\064\078\055\111\003\078\003\063\098\078\028\010\109\003\078\088\098\089\078\063\010\041\098\078\055\098\098\045\078\003\126\113\075\115\116\124\078\105\056\030\069\105\056\030\069\004\035\010\045\078\116\073\111\078\063\098\028\039\078\111\109\078\075\073\028\028\098\075\003\078\003\063\098\078\088\113\045\010\028\078\103\078\109\039\098\075\113\024\098\045\109\016\004"), 
				Media = zmediaResearcherHank_MSG
			}, 
			{
				Text = _CBm("\004\119\098\098\003\078\024\098\078\010\003\078\003\063\098\078\035\028\113\024\010\003\126\073\045\078\089\063\098\045\078\116\073\111\078\063\010\041\098\078\075\073\028\028\098\075\003\098\012\078\010\028\028\078\003\063\098\078\109\039\098\075\113\024\098\045\109\067\078\105\056\030\069\105\056\030\069\004\072\063\064\078\010\045\012\078\003\010\115\098\078\003\063\113\109\078\055\073\073\115\028\098\003\078\089\113\003\063\078\116\073\111\067\078\020\078\009\073\073\012\078\126\098\109\098\010\126\075\063\098\126\078\045\098\041\098\126\078\028\098\010\041\098\109\078\063\073\024\098\078\089\113\003\063\073\111\003\078\113\003\067\004"), 
				Media = zmediaResearcherHank_MSG
			}, 
			{
				Text = _CBm("\032\098\089\078\093\045\041\098\045\003\073\126\116\078\093\003\098\024\106\078\105\056\030\069\044\074\078\056\073\073\115\028\098\003"), 
				Media = zmediaBooklet
			}, 
			{
				Text = _CBm("\033\032\073\003\098\033\078\127\073\024\098\078\073\088\078\003\063\098\078\003\126\098\098\109\078\024\010\116\078\045\073\003\078\055\098\078\024\010\126\115\098\012\067\078\061\109\098\078\003\063\098\078\056\073\073\115\028\098\003\078\003\073\078\063\098\028\039\078\116\073\111\078\010\045\109\089\098\126\078\087\111\098\109\003\113\073\045\109\078\010\055\073\111\003\078\003\063\098\078\003\126\098\098\109\067")
			}, 
			{
				Text = _CBm("\032\098\089\078\036\010\109\115\106\078\035\073\028\028\098\075\003\078\103\078\127\039\098\075\113\024\098\045\109"), 
				Media = zmediaSpecimen_TASK
			}, 
			{
				Text = _CBm("\032\098\089\078\036\010\109\115\106\078\049\073\078\003\073\078\003\063\098\078\032\010\003\113\041\098\078\036\126\098\098\109\078\020\126\098\010\105\056\030\069\044\105\056\030\069\035\063\098\075\115\078\003\063\098\078\096\107\073\075\010\003\113\073\045\109\096\078\003\010\055\078\003\073\078\045\010\041\113\009\010\003\098\067"), 
				Media = zmediaTrees_TASK
			}
		}
		ztaskGototheLinneanHouse.Complete = true
		zitemAbouttheLinneanHouse:MoveTo(zoneLinneanHouse)
		zitemAbouttheUnseenGarden:MoveTo(zoneLinneanHouse)
		ztaskCollect3Specimens.Visible = true
		ztaskCollect3Specimens.Active = true
		ztaskGototheNativeTreesArea.Visible = true
		ztaskGototheNativeTreesArea.Active = true
		zoneMissouriNativeTreesArea.Visible = true
		zoneMissouriNativeTreesArea.Active = true
		zitemBooklet:MoveTo(Player)
		HankTalk = HankTalk + 1
		zoneLinneanHouse.Active = false
	end
end
function zoneMissouriNativeTreesArea:OnEnter()
	_Z8Q = _CBm("\057\073\045\098\119\113\109\109\073\111\126\113\032\010\003\113\041\098\036\126\098\098\109\020\126\098\010")
	if ztaskGototheNativeTreesArea.Complete == false then
		_Urwigo.OldDialog{
			{
				Text = _CBm("\036\063\113\109\078\010\126\098\010\078\075\073\045\003\010\113\045\109\078\003\126\098\098\109\078\003\063\010\003\078\010\126\098\078\045\010\003\113\041\098\078\003\073\078\119\113\109\109\073\111\126\113\067\078\036\073\078\075\073\028\028\098\075\003\078\109\039\098\075\113\024\098\045\109\078\116\073\111\078\045\098\098\012\078\003\073\078\096\036\010\028\115\096\078\003\073\078\098\010\075\063\078\003\126\098\098\078\010\045\012\078\010\045\109\089\098\126\078\113\003\109\078\087\111\098\109\003\113\073\045\109\078\075\073\126\126\098\075\003\028\116\067")
			}, 
			{
				Text = _CBm("\032\098\089\078\036\010\109\115\106\078\119\098\098\003\078\003\063\098\078\003\126\098\098\109\105\056\030\069\105\056\030\069\035\063\098\075\115\078\003\063\098\078\096\107\073\075\010\003\113\073\045\109\096\078\003\010\055\078\003\073\078\045\010\041\113\009\010\003\098\067"), 
				Media = zmediaTrees_TASK
			}
		}
		ztaskGototheNativeTreesArea.Complete = true
		ztaskMeettheTrees.Visible = true
		ztaskMeettheTrees.Active = true
		zoneAmericanHolly.Visible = true
		zoneAmericanHolly.Active = true
		zoneNorthernRedOak.Visible = true
		zoneNorthernRedOak.Active = true
		zoneFringeTree.Visible = true
		zoneFringeTree.Active = true
		zoneMissouriNativeTreesArea.Visible = false
		zoneMissouriNativeTreesArea.Active = false
	end
end
function zoneClimatron:OnEnter()
	_Z8Q = _CBm("\057\073\045\098\035\028\113\024\010\003\126\073\045")
	zitemFruit.Commands.Give.Enabled = true
	zitemLeaf.Commands.Give.Enabled = true
	zitemBark.Commands.Give.Enabled = true
	_Urwigo.MessageBox{
		Text = _CBm("\030\098\109\098\010\126\075\063\098\126\078\122\010\045\115\078\113\109\078\109\003\010\045\012\113\045\009\078\113\045\078\088\126\073\045\003\078\073\088\078\003\063\098\078\035\028\113\024\010\003\126\073\045\067"), 
		Media = zmediaResearcherHank_MSG
	}
	zitemAbouttheClimatron:MoveTo(zoneClimatron)
	zcharacterResearcherHank:MoveTo(zoneClimatron)
end
function zoneNorthernRedOak:OnEnter()
	_Z8Q = _CBm("\057\073\045\098\032\073\126\003\063\098\126\045\030\098\012\072\010\115")
	zcharacterNorthernRedOak:MoveTo(zoneNorthernRedOak)
	_Urwigo.MessageBox{
		Text = _CBm("\072\010\115\078\109\098\098\024\109\078\028\073\109\003\078\113\045\078\003\063\073\111\009\063\003\064\078\010\109\078\113\088\078\063\098\096\109\078\109\073\024\098\039\028\010\075\098\078\098\028\109\098\067"), 
		Media = zmediaNorthernRedOak_YouSee
	}
	zcharacterNorthernRedOak.Commands.Talk.Enabled = true
	zcharacterNorthernRedOak.Commands.Examine.Enabled = true
end
function zoneNorthernRedOak:OnExit()
	_Z8Q = _CBm("\057\073\045\098\032\073\126\003\063\098\126\045\030\098\012\072\010\115")
	zcharacterNorthernRedOak:MoveTo(nil)
	zcharacterNorthernRedOak.Commands.Examine.Enabled = false
	zcharacterNorthernRedOak.Commands.Talk.Enabled = false
end
function zoneFringeTree:OnEnter()
	_Z8Q = _CBm("\057\073\045\098\058\126\113\045\009\098\036\126\098\098")
	zcharacterFringeTree:MoveTo(zoneFringeTree)
	_Urwigo.MessageBox{
		Text = _CBm("\029\010\041\113\045\009\078\113\045\078\003\063\098\078\089\113\045\012\064\078\058\126\113\045\009\098\078\010\039\039\098\010\126\109\078\126\098\010\012\116\078\003\073\078\039\010\126\003\116\067"), 
		Media = zmediaFringeTree_YouSee
	}
	zcharacterFringeTree.Commands.Talk.Enabled = true
	zcharacterFringeTree.Commands.Examine.Enabled = true
end
function zoneFringeTree:OnExit()
	_Z8Q = _CBm("\057\073\045\098\058\126\113\045\009\098\036\126\098\098")
	zcharacterFringeTree:MoveTo(nil)
	zcharacterFringeTree.Commands.Examine.Enabled = false
	zcharacterFringeTree.Commands.Talk.Enabled = false
end
function zoneAmericanHolly:OnEnter()
	_Z8Q = _CBm("\057\073\045\098\020\024\098\126\113\075\010\045\122\073\028\028\116")
	zcharacterAmericanHolly:MoveTo(zoneAmericanHolly)
	_Urwigo.MessageBox{
		Text = _CBm("\122\073\028\028\116\078\126\111\088\088\028\098\109\078\063\098\126\078\028\098\010\041\098\109\078\010\045\012\078\028\073\073\115\109\078\010\003\078\116\073\111\078\075\111\126\113\073\111\109\028\116\067"), 
		Media = zmediaAmericanHolly_YouSee
	}
	zcharacterAmericanHolly.Commands.Examine.Enabled = true
	zcharacterAmericanHolly.Commands.Talk.Enabled = true
end
function zoneAmericanHolly:OnExit()
	_Z8Q = _CBm("\057\073\045\098\020\024\098\126\113\075\010\045\122\073\028\028\116")
	zcharacterAmericanHolly:MoveTo(nil)
	zcharacterAmericanHolly.Commands.Examine.Enabled = false
	zcharacterAmericanHolly.Commands.Talk.Enabled = false
end
function _z14Hx:OnEnter()
	_Z8Q = _CBm("\050\057\095\120\122\005")
	_Urwigo.RunDialogs(function()
		Wherigo.GetInput(_93W)
	end)
end
function zinputHollyQ1:OnGetInput(input)
	if input == nil then
		input = ""
	end
	if true then
		HollyQ1Answer = input
		if (Wherigo.NoCaseEquals(HollyQ1Answer, _CBm("\058\126\098\045\075\063")) or Wherigo.NoCaseEquals(HollyQ1Answer, _CBm("\104\111\003\075\063"))) or Wherigo.NoCaseEquals(HollyQ1Answer, _CBm("\030\111\109\109\113\010\045")) then
			_Urwigo.MessageBox{
				Text = _CBm("\004\122\024\067\078\036\063\010\003\096\109\078\045\073\003\078\113\003\067\078\093\096\028\028\078\055\098\078\063\098\126\098\078\089\063\098\045\078\116\073\111\096\126\098\078\126\098\010\012\116\078\003\073\078\003\126\116\078\010\009\010\113\045\067\004"), 
				Media = zmediaAmericanHolly_MSG
			}
		elseif Wherigo.NoCaseEquals(HollyQ1Answer, _CBm("\020\024\098\126\113\075\010\045")) then
			HollyQuest = HollyQuest + 1
			_Urwigo.MessageBox{
				Text = _CBm("\004\036\063\010\003\096\109\078\126\113\009\063\003\124\078\119\116\078\045\010\024\098\078\113\109\078\020\024\098\126\113\075\010\045\078\122\073\028\028\116\067\078\127\073\078\088\010\126\064\078\109\073\078\009\073\073\012\067\004"), 
				Media = zmediaAmericanHolly_MSG, 
				Callback = function(action)
					if action ~= nil then
						if (action) ~= nil then
							if HollyQuest == 0 then
								_Urwigo.RunDialogs(function()
									Wherigo.GetInput(zinputHollyQ1)
								end)
							elseif HollyQuest == 1 then
								_Urwigo.RunDialogs(function()
									Wherigo.GetInput(zinputHollyQ2)
								end)
							elseif HollyQuest == 2 then
								_Urwigo.RunDialogs(function()
									Wherigo.GetInput(zinputHollyQ3)
								end)
							end
						end
					end
				end
			}
		else
			_Urwigo.MessageBox{
				Text = _CBm("\004\049\073\078\010\063\098\010\012\067\078\104\073\078\109\073\024\098\078\126\098\109\098\010\126\075\063\067\078\093\096\028\028\078\055\098\078\063\098\126\098\078\089\063\098\045\078\116\073\111\096\126\098\078\126\098\010\012\116\067\004"), 
				Media = zmediaAmericanHolly_MSG
			}
		end
	end
end
function zinputHollyQ2:OnGetInput(input)
	if input == nil then
		input = ""
	end
	if true then
		HollyQ2Answer = input
		if (Wherigo.NoCaseEquals(HollyQ2Answer, _CBm("\030\073\111\009\063")) or Wherigo.NoCaseEquals(HollyQ2Answer, _CBm("\125\098\028\041\098\003\116"))) or Wherigo.NoCaseEquals(HollyQ2Answer, _CBm("\122\010\113\126\116")) then
			_Urwigo.MessageBox{
				Text = _CBm("\004\029\063\116\078\012\073\045\096\003\078\116\073\111\078\075\073\024\098\078\055\010\075\115\078\089\063\098\045\078\116\073\111\096\041\098\078\012\073\045\098\078\116\073\111\126\078\126\098\109\098\010\126\075\063\067\004"), 
				Media = zmediaAmericanHolly_MSG
			}
		elseif Wherigo.NoCaseEquals(HollyQ2Answer, _CBm("\029\010\005\116")) then
			HollyQuest = HollyQuest + 1
			_Urwigo.MessageBox{
				Text = _CBm("\004\036\063\010\003\096\109\078\075\073\126\126\098\075\003\124\078\119\116\078\028\098\010\041\098\109\078\010\126\098\078\010\028\109\073\078\098\041\098\126\009\126\098\098\045\067\004"), 
				Media = zmediaAmericanHolly_MSG, 
				Callback = function(action)
					if action ~= nil then
						if (action) ~= nil then
							if HollyQuest == 0 then
								_Urwigo.RunDialogs(function()
									Wherigo.GetInput(zinputHollyQ1)
								end)
							elseif HollyQuest == 1 then
								_Urwigo.RunDialogs(function()
									Wherigo.GetInput(zinputHollyQ2)
								end)
							elseif HollyQuest == 2 then
								_Urwigo.RunDialogs(function()
									Wherigo.GetInput(zinputHollyQ3)
								end)
							end
						end
					end
				end
			}
		else
			_Urwigo.MessageBox{
				Text = _CBm("\004\036\010\115\098\078\116\073\111\126\078\003\113\024\098\067\004"), 
				Media = zmediaAmericanHolly_MSG
			}
		end
	end
end
function zinputHollyQ3:OnGetInput(input)
	if input == nil then
		input = ""
	end
	if true then
		HollyQ3Answer = input
		if (Wherigo.NoCaseEquals(HollyQ3Answer, _CBm("\056\126\113\009\063\003\078\073\126\010\045\009\098")) or Wherigo.NoCaseEquals(HollyQ3Answer, _CBm("\021\098\028\028\073\089\078\003\113\045\003"))) or Wherigo.NoCaseEquals(HollyQ3Answer, _CBm("\030\098\012")) then
			_Urwigo.MessageBox{
				Text = _CBm("\004\127\073\126\126\116\067\078\036\063\010\003\096\109\078\045\073\003\078\075\073\126\126\098\075\003\067\078\035\073\024\098\078\055\010\075\115\078\089\063\098\045\078\116\073\111\096\126\098\078\126\098\010\012\116\067\004"), 
				Media = zmediaAmericanHolly_MSG
			}
		elseif Wherigo.NoCaseEquals(HollyQ3Answer, _CBm("\049\126\098\098\045")) then
			_Urwigo.MessageBox{
				Text = _CBm("\004\029\098\028\028\078\012\073\045\098\067\078\093\078\003\063\113\045\115\078\116\073\111\078\012\098\109\098\126\041\098\078\010\078\109\039\098\075\113\024\098\045\078\088\073\126\078\116\073\111\126\078\115\045\073\089\028\098\012\009\098\078\073\088\078\122\073\028\028\116\078\003\126\098\098\109\124\078\122\098\126\098\078\116\073\111\078\010\126\098\067\004\078\105\056\030\069\105\056\030\069\033\033\020\024\098\126\113\075\010\045\078\122\073\028\028\116\078\098\005\003\098\045\012\109\078\063\098\126\078\055\126\010\045\075\063\078\010\045\012\078\063\010\045\012\109\078\116\073\111\078\063\098\126\078\039\126\098\075\113\073\111\109\078\028\098\010\088\067\033\033"), 
				Media = zmediaAmericanHolly_MSG, 
				Callback = function(action)
					if action ~= nil then
						if (action) ~= nil then
							if ((OakComplete == 2) and (FringeComplete == 2)) and (HollyComplete == 2) then
								ztaskMeettheTrees.Complete = true
								ztaskCollect3Specimens.Complete = true
								ztaskReturnthespecimens.Visible = true
								ztaskReturnthespecimens.Active = true
								zoneClimatron.Visible = true
								zoneClimatron.Active = true
								HankTalk = HankTalk + 1
								_Urwigo.MessageBox{
									Text = _CBm("\032\098\089\078\036\010\109\115\106\078\030\098\003\111\126\045\078\003\063\098\078\109\039\098\075\113\024\098\045\109\067\078\105\056\030\069\105\056\030\069\030\098\109\098\010\126\075\063\098\126\078\122\010\045\115\078\113\109\078\089\010\113\003\113\045\009\078\088\073\126\078\116\073\111\078\010\003\078\003\063\098\078\035\028\113\024\010\003\126\073\045\067"), 
									Media = zmediaClimatron_TASK
								}
							end
						end
					end
				end
			}
			HollyQuest = HollyQuest + 1
			HollyComplete = HollyComplete + 1
			zitemLeaf:MoveTo(Player)
			zoneAmericanHolly.Active = false
		else
			_Urwigo.MessageBox{
				Text = _CBm("\004\036\010\115\098\078\116\073\111\126\078\003\113\024\098\067\078\035\073\024\098\078\055\010\075\115\078\089\063\098\045\098\041\098\126\078\116\073\111\096\126\098\078\126\098\010\012\116\067\004"), 
				Media = zmediaAmericanHolly_MSG
			}
		end
	end
end
function zinputOakQ1:OnGetInput(input)
	if input == nil then
		input = ""
	end
	if input ~= tostring(nil) then
		OakQ1Answer = input
		if ((Wherigo.NoCaseEquals(OakQ1Answer, _CBm("\032\073\126\003\063\098\126\045\078\030\098\012\078\072\010\115")) or Wherigo.NoCaseEquals(OakQ1Answer, _CBm("\032\073\126\003\063\098\126\045\078\030\098\012"))) or Wherigo.NoCaseEquals(OakQ1Answer, _CBm("\032\073\126\003\063\098\126\045\030\098\012\072\010\115"))) or Wherigo.NoCaseEquals(OakQ1Answer, _CBm("\032\073\126\003\063\098\126\045\030\098\012")) then
			OakQuest = OakQuest + 1
			_Urwigo.MessageBox{
				Text = _CBm("\004\049\073\073\012\067\078\030\098\024\098\024\055\098\126\078\024\116\078\045\010\024\098\067\078\093\003\096\109\078\032\073\126\003\063\098\126\045\078\030\098\012\078\072\010\115\067\004"), 
				Media = zmediaNorthernRedOak_MSG, 
				Callback = function(action)
					if action ~= nil then
						if (action) ~= nil then
							if OakQuest == 0 then
								_Urwigo.RunDialogs(function()
									Wherigo.GetInput(zinputOakQ1)
								end)
							elseif OakQuest == 1 then
								_Urwigo.RunDialogs(function()
									Wherigo.GetInput(zinputOakQ2)
								end)
							elseif OakQuest == 2 then
								_Urwigo.RunDialogs(function()
									Wherigo.GetInput(zinputOakQ3)
								end)
							end
						end
					end
				end
			}
		else
			_Urwigo.MessageBox{
				Text = _CBm("\004\093\003\096\109\078\073\115\010\116\078\113\088\078\116\073\111\078\089\010\045\003\078\003\073\078\012\073\078\109\073\024\098\078\126\098\109\098\010\126\075\063\067\004"), 
				Media = zmediaNorthernRedOak_MSG
			}
		end
	end
end
function zinputOakQ2:OnGetInput(input)
	if input == nil then
		input = ""
	end
	if input ~= tostring(nil) then
		OakQ2Answer = input
		if Wherigo.NoCaseEquals(OakQ2Answer, _CBm("\062")) or Wherigo.NoCaseEquals(OakQ2Answer, _CBm("\118\111\045\098")) then
			OakQuest = OakQuest + 1
			_Urwigo.MessageBox{
				Text = _CBm("\004\035\073\126\126\098\075\003\124\078\056\116\078\003\063\098\078\089\010\116\064\078\024\116\078\088\126\111\113\003\109\078\010\126\098\078\010\078\009\073\073\012\078\109\073\111\126\075\098\078\073\088\078\088\073\073\012\078\088\073\126\078\109\087\111\113\126\126\098\028\109\078\010\045\012\078\089\073\073\012\039\098\075\115\098\126\109\067\004"), 
				Media = zmediaNorthernRedOak_MSG, 
				Callback = function(action)
					if action ~= nil then
						if (action) ~= nil then
							if OakQuest == 0 then
								_Urwigo.RunDialogs(function()
									Wherigo.GetInput(zinputOakQ1)
								end)
							elseif OakQuest == 1 then
								_Urwigo.RunDialogs(function()
									Wherigo.GetInput(zinputOakQ2)
								end)
							elseif OakQuest == 2 then
								_Urwigo.RunDialogs(function()
									Wherigo.GetInput(zinputOakQ3)
								end)
							end
						end
					end
				end
			}
		else
			_Urwigo.MessageBox{
				Text = _CBm("\004\035\028\098\010\126\028\116\064\078\116\073\111\096\126\098\078\045\073\003\078\039\126\098\039\010\126\098\012\067\078\035\073\024\098\078\055\010\075\115\078\089\063\098\045\078\116\073\111\096\126\098\078\126\098\010\012\116\067\004"), 
				Media = zmediaNorthernRedOak_MSG
			}
		end
	end
end
function zinputOakQ3:OnGetInput(input)
	if input == nil then
		input = ""
	end
	if true then
		OakQ3Answer = input
		if (Wherigo.NoCaseEquals(OakQ3Answer, _CBm("\056\113\009\078\055\028\010\075\115\078\055\111\024\039\109")) or Wherigo.NoCaseEquals(OakQ3Answer, _CBm("\029\063\113\003\098\078\055\028\073\003\075\063\116\078\109\039\073\003\109"))) or Wherigo.NoCaseEquals(OakQ3Answer, _CBm("\127\024\073\073\003\063\078\009\126\010\116")) then
			_Urwigo.MessageBox{
				Text = _CBm("\004\032\073\067\078\093\096\024\078\010\088\126\010\113\012\078\003\063\010\003\096\109\078\045\073\003\078\075\073\126\126\098\075\003\067\078\035\073\024\098\078\055\010\075\115\078\089\063\098\045\078\116\073\111\096\126\098\078\126\098\010\012\116\067\004"), 
				Media = zmediaNorthernRedOak_MSG
			}
		elseif Wherigo.NoCaseEquals(OakQ3Answer, _CBm("\030\073\111\009\063\078\012\098\098\039\078\041\098\126\003\113\075\010\028\078\089\126\113\045\115\028\098\109")) then
			_Urwigo.MessageBox{
				Text = _CBm("\004\036\063\010\003\096\109\078\041\098\126\116\078\009\073\073\012\067\078\021\073\111\078\063\010\041\098\078\039\126\073\041\098\045\078\116\073\111\126\109\098\028\088\078\003\073\078\024\098\067\004\078\105\056\030\069\105\056\030\069\033\033\032\073\126\003\063\098\126\045\078\030\098\012\078\072\010\115\078\009\098\045\003\028\116\078\003\010\115\098\109\078\010\078\039\113\098\075\098\078\073\088\078\055\010\126\115\078\088\126\073\024\078\063\113\109\078\055\126\010\045\075\063\078\010\045\012\078\009\113\041\098\109\078\113\003\078\003\073\078\116\073\111\067\033\033"), 
				Media = zmediaNorthernRedOak_MSG, 
				Callback = function(action)
					if action ~= nil then
						if (action) ~= nil then
							if ((OakComplete == 2) and (FringeComplete == 2)) and (HollyComplete == 2) then
								ztaskMeettheTrees.Complete = true
								ztaskCollect3Specimens.Complete = true
								ztaskReturnthespecimens.Visible = true
								ztaskReturnthespecimens.Active = true
								zoneClimatron.Visible = true
								zoneClimatron.Active = true
								HankTalk = HankTalk + 1
								_Urwigo.MessageBox{
									Text = _CBm("\032\098\089\078\036\010\109\115\106\078\030\098\003\111\126\045\078\003\063\098\078\109\039\098\075\113\024\098\045\109\067\078\105\056\030\069\105\056\030\069\030\098\109\098\010\126\075\063\098\126\078\122\010\045\115\078\113\109\078\089\010\113\003\113\045\009\078\088\073\126\078\116\073\111\078\010\003\078\003\063\098\078\035\028\113\024\010\003\126\073\045\067"), 
									Media = zmediaClimatron_TASK
								}
							end
						end
					end
				end
			}
			OakQuest = OakQuest + 1
			OakComplete = OakComplete + 1
			zitemBark:MoveTo(Player)
			zoneNorthernRedOak.Active = false
		else
			_Urwigo.MessageBox{
				Text = _CBm("\004\032\073\003\078\126\098\010\012\116\078\116\098\003\016\078\036\063\010\003\096\109\078\073\115\010\116\067\004"), 
				Media = zmediaNorthernRedOak_MSG
			}
		end
	end
end
function zinputFringeQ1:OnGetInput(input)
	if input == nil then
		input = ""
	end
	if true then
		FringeQ1Answer = input
		if (Wherigo.NoCaseEquals(FringeQ1Answer, _CBm("\049\126\010\045\075\116\078\122\073\028\028\116")) or Wherigo.NoCaseEquals(FringeQ1Answer, _CBm("\029\063\113\003\098\078\086\010\028\024"))) or Wherigo.NoCaseEquals(FringeQ1Answer, _CBm("\030\111\055\055\098\126\078\036\126\098\098")) then
			_Urwigo.MessageBox{
				Text = _CBm("\004\032\073\039\098\067\078\104\073\078\109\073\024\098\078\126\098\109\098\010\126\075\063\078\010\045\012\078\003\126\116\078\010\009\010\113\045\078\028\010\003\098\126\067\004"), 
				Media = zmediaFringeTree_MSG
			}
		elseif Wherigo.NoCaseEquals(FringeQ1Answer, _CBm("\072\028\012\078\119\010\045\096\109\078\056\098\010\126\012")) then
			FringeQuest = FringeQuest + 1
			_Urwigo.MessageBox{
				Text = _CBm("\004\035\073\126\126\098\075\003\124\078\093\078\063\010\041\098\078\010\045\073\003\063\098\126\078\045\113\075\115\045\010\024\098\078\089\063\113\075\063\078\093\078\028\113\115\098\078\003\073\073\067\078\093\003\096\109\078\049\126\010\045\075\116\078\049\126\010\116\055\098\010\126\012\067\004"), 
				Media = zmediaFringeTree_MSG, 
				Callback = function(action)
					if action ~= nil then
						if (action) ~= nil then
							if FringeQuest == 0 then
								_Urwigo.RunDialogs(function()
									Wherigo.GetInput(zinputFringeQ1)
								end)
							elseif FringeQuest == 1 then
								_Urwigo.RunDialogs(function()
									Wherigo.GetInput(zinputFringeQ2)
								end)
							elseif FringeQuest == 2 then
								_Urwigo.RunDialogs(function()
									Wherigo.GetInput(zinputFringeQ3)
								end)
							end
						end
					end
				end
			}
		else
			_Urwigo.MessageBox{
				Text = _CBm("\004\093\096\028\028\078\055\098\078\063\098\126\098\078\089\063\098\045\078\116\073\111\096\126\098\078\126\098\010\012\116\067\004"), 
				Media = zmediaFringeTree_MSG
			}
		end
	end
end
function zinputFringeQ2:OnGetInput(input)
	if input == nil then
		input = ""
	end
	if true then
		FringeQ2Answer = input
		if (Wherigo.NoCaseEquals(FringeQ2Answer, _CBm("\127\028\098\098\039\113\045\009\078\039\126\073\055\028\098\024\109")) or Wherigo.NoCaseEquals(FringeQ2Answer, _CBm("\056\126\098\010\003\063\113\045\009\078\039\126\073\055\028\098\024\109"))) or Wherigo.NoCaseEquals(FringeQ2Answer, _CBm("\036\073\073\003\063\078\010\075\063\098")) then
			_Urwigo.MessageBox{
				Text = _CBm("\004\093\078\003\063\113\045\115\078\116\073\111\096\012\078\055\098\003\003\098\126\078\003\126\116\078\010\009\010\113\045\078\010\088\003\098\126\078\116\073\111\096\041\098\078\012\073\045\098\078\024\073\126\098\078\126\098\109\098\010\126\075\063\067\004"), 
				Media = zmediaFringeTree_MSG
			}
		elseif Wherigo.NoCaseEquals(FringeQ2Answer, _CBm("\127\115\113\045\078\039\126\073\055\028\098\024\109")) then
			FringeQuest = FringeQuest + 1
			_Urwigo.MessageBox{
				Text = _CBm("\004\021\098\039\124\078\093\096\024\078\010\024\010\057\113\045\009\124\078\119\116\078\055\010\126\115\078\126\098\012\111\075\098\109\078\088\098\041\098\126\078\010\109\078\089\098\028\028\067\004"), 
				Media = zmediaFringeTree_MSG, 
				Callback = function(action)
					if action ~= nil then
						if (action) ~= nil then
							if FringeQuest == 0 then
								_Urwigo.RunDialogs(function()
									Wherigo.GetInput(zinputFringeQ1)
								end)
							elseif FringeQuest == 1 then
								_Urwigo.RunDialogs(function()
									Wherigo.GetInput(zinputFringeQ2)
								end)
							elseif FringeQuest == 2 then
								_Urwigo.RunDialogs(function()
									Wherigo.GetInput(zinputFringeQ3)
								end)
							end
						end
					end
				end
			}
		else
			_Urwigo.MessageBox{
				Text = _CBm("\004\072\115\010\116\067\078\036\010\115\098\078\116\073\111\126\078\003\113\024\098\067\078\035\073\024\098\078\055\010\075\115\078\089\063\098\045\098\041\098\126\078\116\073\111\096\126\098\078\126\098\010\012\116\067\004"), 
				Media = zmediaFringeTree_MSG
			}
		end
	end
end
function zinputFringeQ3:OnGetInput(input)
	if input == nil then
		input = ""
	end
	if true then
		FringeQ3Answer = input
		if (Wherigo.NoCaseEquals(FringeQ3Answer, _CBm("\032\098\098\012\028\098\028\113\115\098\078\028\098\010\041\098\109\034\078\109\063\010\126\039\078\024\010\126\009\113\045\109")) or Wherigo.NoCaseEquals(FringeQ3Answer, _CBm("\122\010\113\126\116\078\028\098\010\041\098\109\034\078\003\098\098\003\063\098\012\078\024\010\126\009\113\045\109"))) or Wherigo.NoCaseEquals(FringeQ3Answer, _CBm("\030\073\111\009\063\078\028\098\010\041\098\109\034\078\109\024\073\073\003\063\078\024\010\126\009\113\045\109")) then
			_Urwigo.MessageBox{
				Text = _CBm("\004\093\045\075\073\126\126\098\075\003\067\078\093\078\009\111\098\109\109\078\116\073\111\096\012\078\055\098\003\003\098\126\078\109\003\111\012\116\078\024\073\126\098\067\004"), 
				Media = zmediaFringeTree_MSG
			}
		elseif Wherigo.NoCaseEquals(FringeQ3Answer, _CBm("\049\028\073\109\109\116\078\028\098\010\041\098\109\034\078\109\024\073\073\003\063\078\024\010\126\009\113\045\109")) then
			_Urwigo.MessageBox{
				Text = _CBm("\004\122\024\067\078\093\024\039\126\098\109\109\113\041\098\067\078\021\073\111\126\078\115\045\073\089\028\098\012\009\098\078\113\109\067\067\067\089\073\126\003\063\116\078\073\088\078\024\116\078\088\126\111\113\003\067\004\078\105\056\030\069\105\056\030\069\033\033\058\126\113\045\009\098\078\036\126\098\098\078\109\098\010\126\075\063\098\109\078\088\073\126\078\063\113\109\078\088\126\111\113\003\109\078\010\045\012\078\039\113\075\115\109\078\003\063\098\024\078\073\088\088\078\088\073\126\078\116\073\111\067\033\033"), 
				Media = zmediaFringeTree_MSG, 
				Callback = function(action)
					if action ~= nil then
						if (action) ~= nil then
							if ((OakComplete == 2) and (FringeComplete == 2)) and (HollyComplete == 2) then
								ztaskMeettheTrees.Complete = true
								ztaskCollect3Specimens.Complete = true
								ztaskReturnthespecimens.Visible = true
								ztaskReturnthespecimens.Active = true
								zoneClimatron.Visible = true
								zoneClimatron.Active = true
								HankTalk = HankTalk + 1
								_Urwigo.MessageBox{
									Text = _CBm("\032\098\089\078\036\010\109\115\106\078\030\098\003\111\126\045\078\003\063\098\078\109\039\098\075\113\024\098\045\109\067\078\105\056\030\069\105\056\030\069\030\098\109\098\010\126\075\063\098\126\078\122\010\045\115\078\113\109\078\089\010\113\003\113\045\009\078\088\073\126\078\116\073\111\078\010\003\078\003\063\098\078\035\028\113\024\010\003\126\073\045\067"), 
									Media = zmediaClimatron_TASK
								}
							end
						end
					end
				end
			}
			FringeQuest = FringeQuest + 1
			FringeComplete = FringeComplete + 1
			zitemFruit:MoveTo(Player)
			zoneFringeTree.Active = false
		else
			_Urwigo.MessageBox{
				Text = _CBm("\004\093\096\028\028\078\027\111\109\003\078\089\010\113\003\078\063\098\126\098\078\111\045\003\113\028\078\116\073\111\096\126\098\078\126\098\010\012\116\067\004"), 
				Media = zmediaFringeTree_MSG
			}
		end
	end
end
function _93W:OnGetInput(input)
	if input == nil then
		input = ""
	end
	_Yg7n = input
	if Wherigo.NoCaseEquals(_Yg7n, _CBm("\058\073\111\045\012\078\113\003")) then
		_Urwigo.MessageBox{
			Text = _CBm("\125\098\126\116\078\032\113\075\098\124"), 
			Media = _a0D, 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.MessageBox{
						Text = (_CBm("\036\063\113\109\078\075\010\126\003\126\113\012\009\098\078\089\010\109\078\055\126\073\111\009\063\003\078\003\073\078\116\073\111\078\055\116\078\118\080\056\080\078\048\010\024\039\034\078\058\073\126\098\109\003\074\049\063\073\109\003\078\113\045\078\075\073\045\027\111\045\075\003\113\073\045\078\089\113\003\063\078\003\063\098\078\119\113\109\109\073\111\126\113\078\056\073\003\010\045\113\075\010\028\078\049\010\126\012\098\045\067\078\036\073\078\028\098\010\126\045\078\024\073\126\098\078\010\055\073\111\003\078\003\063\098\078\119\113\109\109\073\111\126\113\078\056\073\003\010\045\113\075\010\028\078\049\010\126\012\098\045\064\078\039\028\098\010\109\098\078\041\113\109\113\003\078\089\089\089\067\024\073\055\073\003\067\073\126\009\067\078\021\073\111\126\078\039\028\010\116\098\126\078\075\073\024\039\028\098\003\113\073\045\078\035\073\012\098\078\113\109\106\078")..string.sub(Player.CompletionCode, 1, 15)).._CBm("\078\030\098\024\098\024\055\098\126\078\003\073\078\028\073\009\078\116\073\111\126\078\039\028\010\116\113\045\009\078\098\005\039\098\126\113\098\045\075\098\078\010\003\078\089\089\089\067\089\063\098\126\113\009\073\067\075\073\024\067\078\036\063\010\045\115\109\078\088\073\126\078\039\028\010\116\113\045\009\124"), 
						Media = _LDp, 
						Callback = function(action)
							if action ~= nil then
								_Op1jc.Visible = true
							end
						end
					}
					_Op1jc:MoveTo(Player)
					cartTheUnseenGardenMoBot.Complete = true
					_Op1jc.Description = _CBm("\035\073\024\039\028\098\003\113\073\045\078\035\073\012\098")..string.sub(Player.CompletionCode, 1, 15)
				end
			end
		}
	else
		_Urwigo.MessageBox{
			Text = _CBm("\093\078\010\024\078\109\073\126\126\116\078\003\063\010\003\078\116\073\111\078\012\113\012\045\096\003\078\088\113\045\012\078\113\003\067\078\036\063\098\078\009\098\073\075\010\075\063\098\078\113\109\078\028\073\075\010\003\098\012\078\010\003\078\032\078\103\082\078\103\062\067\120\120\103\078\029\078\031\085\078\095\062\067\085\031\103\067\078\021\073\111\078\010\126\098\078\028\073\073\115\113\045\009\078\088\073\126\078\010\078\039\098\010\045\111\003\078\055\111\003\003\098\126\078\027\010\126\078\010\003\078\003\063\098\078\055\010\109\098\078\073\088\078\003\063\098\078\003\126\098\098\067\078\093\088\078\116\073\111\078\012\073\078\045\073\003\078\109\098\098\078\003\063\098\078\075\010\075\063\098\078\113\003\078\024\010\116\078\055\098\078\024\113\109\109\113\045\009\064\078\039\028\098\010\109\098\078\075\073\045\003\010\075\003\078\003\063\098\078\035\072\067"), 
			Media = _QSU, 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.RunDialogs(function()
						Wherigo.GetInput(_93W)
					end)
				end
			end
		}
	end
end
function zcharacterResearcherHank:OnTalk(target)
	if HankTalk == 1 then
		_Urwigo.MessageBox{
			Text = _CBm("\004\035\028\073\109\098\078\073\055\109\098\126\041\010\003\113\073\045\078\010\045\012\078\109\063\010\126\039\078\126\098\109\098\010\126\075\063\078\109\115\113\028\028\109\078\010\126\098\078\003\063\098\078\115\098\116\067\105\056\030\069\105\056\030\069\004\029\098\096\126\098\078\010\028\028\078\075\073\111\045\003\113\045\009\078\073\045\078\116\073\111\124\004"), 
			Media = zmediaResearcherHank_MSG
		}
	elseif HankTalk == 2 then
		_Urwigo.MessageBox{
			Text = _CBm("\004\107\098\003\096\109\078\109\098\098\078\089\063\010\003\078\116\073\111\096\041\098\078\055\126\073\111\009\063\003\067\078\086\028\098\010\109\098\064\078\096\049\113\041\098\096\078\024\098\078\098\010\075\063\078\109\039\098\075\113\024\098\045\067\004"), 
			Media = zmediaResearcherHank_MSG
		}
	elseif HankTalk == 3 then
		_Urwigo.MessageBox{
			Text = _CBm("\004\036\063\010\045\115\109\078\010\009\010\113\045\078\088\073\126\078\116\073\111\126\078\063\098\028\039\124\004"), 
			Media = zmediaResearcherHank_MSG
		}
	end
end
function zcharacterResearcherHank:OnExamine(target)
	if not Player:Contains(zitemSecretHelperBadge) then
		_Urwigo.MessageBox{
			Text = _CBm("\030\098\109\098\010\126\075\063\098\126\078\122\010\045\115\078\113\109\078\010\078\041\098\003\098\126\010\045\078\056\073\003\010\045\113\109\003\067"), 
			Media = zmediaResearcherHank
		}
	elseif Player:Contains(zitemSecretHelperBadge) then
		_Urwigo.MessageBox{
			Text = _CBm("\030\098\109\098\010\126\075\063\098\126\078\122\010\045\115\078\113\109\078\075\010\126\098\088\111\028\028\116\078\109\003\111\012\116\113\045\009\078\003\063\098\078\109\039\098\075\113\024\098\045\109\067\078\122\098\078\109\098\098\024\109\078\041\098\126\116\078\039\028\098\010\109\098\012\067"), 
			Media = zmediaResearcherHank
		}
	end
end
function zcharacterAmericanHolly:OnTalk(target)
	if ((HollyComplete == 2) and (OakComplete == 2)) and (FringeComplete == 2) then
		_Urwigo.MessageBox{
			Text = _CBm("\004\021\073\111\096\041\098\078\009\073\003\078\089\063\010\003\078\116\073\111\078\045\098\098\012\078\088\126\073\024\078\024\098\067\078\105\056\030\069\105\056\030\069\004\035\063\098\075\115\078\003\063\098\078\096\036\010\109\115\109\096\078\024\098\045\111\078\113\088\078\116\073\111\078\012\073\045\096\003\078\115\045\073\089\078\089\063\010\003\078\003\073\078\012\073\078\045\098\005\003\067\004"), 
			Media = zmediaAmericanHolly_MSG
		}
	elseif HollyComplete == 0 then
		_Urwigo.MessageBox{
			Text = _CBm("\004\127\073\064\078\116\073\111\096\126\098\078\010\045\078\122\073\045\073\126\010\126\116\078\119\098\024\055\098\126\078\073\088\078\003\063\098\078\061\045\109\098\098\045\078\049\010\126\012\098\045\016\078\036\063\098\116\078\010\126\098\078\075\073\045\109\003\010\045\003\028\116\078\003\010\115\113\045\009\078\109\010\024\039\028\098\109\078\073\088\078\024\116\078\088\126\113\098\045\012\109\067\078\020\028\028\078\088\073\126\078\009\073\073\012\078\126\098\010\109\073\045\109\064\078\093\078\109\111\039\039\073\109\098\067\004"), 
			Media = zmediaAmericanHolly_MSG, 
			Callback = function(action)
				if action ~= nil then
					if (action) ~= nil then
						_Urwigo.MessageBox{
							Text = _CBm("\004\036\063\073\111\009\063\064\078\116\073\111\078\109\098\098\024\078\088\010\113\126\028\116\078\063\010\126\024\028\098\109\109\067\078\093\078\089\113\028\028\078\028\098\003\078\116\073\111\078\003\010\115\098\078\010\078\109\039\098\075\113\024\098\045\078\113\088\078\116\073\111\078\028\113\115\098\067\078\058\113\126\109\003\064\078\093\078\003\063\113\045\115\078\116\073\111\078\109\063\073\111\028\012\078\115\045\073\089\078\109\073\024\098\003\063\113\045\009\078\010\055\073\111\003\078\024\116\078\115\113\045\012\067\004"), 
							Media = zmediaAmericanHolly_MSG, 
							Callback = function(action)
								if action ~= nil then
									if (action) ~= nil then
										if HollyQuest == 0 then
											_Urwigo.RunDialogs(function()
												Wherigo.GetInput(zinputHollyQ1)
											end)
										elseif HollyQuest == 1 then
											_Urwigo.RunDialogs(function()
												Wherigo.GetInput(zinputHollyQ2)
											end)
										elseif HollyQuest == 2 then
											_Urwigo.RunDialogs(function()
												Wherigo.GetInput(zinputHollyQ3)
											end)
										end
									end
								end
							end
						}
						HollyComplete = HollyComplete + 1
					end
				end
			end
		}
	elseif HollyComplete == 1 then
		_Urwigo.MessageBox{
			Text = _CBm("\004\093\078\063\073\039\098\078\116\073\111\096\041\098\078\012\073\045\098\078\116\073\111\126\078\126\098\109\098\010\126\075\063\124\078\093\078\012\073\045\096\003\078\009\113\041\098\078\109\010\024\039\028\098\109\078\010\089\010\116\078\003\073\078\027\111\109\003\078\010\045\116\073\045\098\078\116\073\111\078\115\045\073\089\067\004"), 
			Media = zmediaAmericanHolly_MSG, 
			Callback = function(action)
				if action ~= nil then
					if (action) ~= nil then
						if HollyQuest == 0 then
							_Urwigo.RunDialogs(function()
								Wherigo.GetInput(zinputHollyQ1)
							end)
						elseif HollyQuest == 1 then
							_Urwigo.RunDialogs(function()
								Wherigo.GetInput(zinputHollyQ2)
							end)
						elseif HollyQuest == 2 then
							_Urwigo.RunDialogs(function()
								Wherigo.GetInput(zinputHollyQ3)
							end)
						end
					end
				end
			end
		}
	elseif HollyComplete == 2 then
		_Urwigo.MessageBox{
			Text = _CBm("\004\036\010\028\115\078\003\073\078\073\003\063\098\126\078\003\126\098\098\109\078\010\055\073\111\003\078\116\073\111\126\078\126\098\109\098\010\126\075\063\067\004"), 
			Media = zmediaAmericanHolly_MSG
		}
	end
end
function zcharacterAmericanHolly:OnExamine(target)
	_Urwigo.MessageBox{
		Text = "", 
		Media = zmediaAmericanHolly_Examine
	}
end
function zcharacterNorthernRedOak:OnTalk(target)
	if ((OakComplete == 2) and (HollyComplete == 2)) and (FringeComplete == 2) then
		_Urwigo.MessageBox{
			Text = _CBm("\004\021\073\111\096\126\098\078\010\028\028\078\012\073\045\098\078\063\098\126\098\067\078\105\056\030\069\105\056\030\069\004\035\063\098\075\115\078\003\063\098\078\096\036\010\109\115\109\096\078\024\098\045\111\078\113\088\078\116\073\111\078\012\073\045\096\003\078\115\045\073\089\078\089\063\010\003\078\003\073\078\012\073\078\045\098\005\003\067\004"), 
			Media = zmediaNorthernRedOak_MSG
		}
	elseif OakComplete == 0 then
		_Urwigo.MessageBox{
			Text = _CBm("\004\093\078\109\111\039\039\073\109\098\078\116\073\111\078\010\126\098\078\028\073\073\115\113\045\009\078\088\073\126\078\010\078\039\113\098\075\098\078\073\088\078\073\010\115\078\003\073\078\003\010\115\098\078\089\113\003\063\078\116\073\111\067\078\021\073\111\078\063\111\024\010\045\109\078\075\098\126\003\010\113\045\028\116\078\115\045\073\089\078\063\073\089\078\003\073\078\115\098\098\039\078\010\078\003\126\098\098\078\073\045\078\126\073\073\003\109\096\078\098\045\012\067\004"), 
			Media = zmediaNorthernRedOak_MSG, 
			Callback = function(action)
				if action ~= nil then
					if (action) ~= nil then
						_Urwigo.MessageBox{
							Text = _CBm("\004\021\073\111\096\126\098\078\010\078\126\098\109\098\010\126\075\063\098\126\064\078\116\073\111\078\109\010\116\016\078\029\098\028\028\064\078\113\088\078\116\073\111\096\126\098\078\109\073\078\109\024\010\126\003\064\078\003\063\098\045\078\003\098\028\028\078\024\098\078\109\073\024\098\078\003\063\113\045\009\109\078\010\055\073\111\003\078\073\010\115\078\003\126\098\098\109\067\004"), 
							Media = zmediaNorthernRedOak_MSG, 
							Callback = function(action)
								if action ~= nil then
									if (action) ~= nil then
										if OakQuest == 0 then
											_Urwigo.RunDialogs(function()
												Wherigo.GetInput(zinputOakQ1)
											end)
										elseif OakQuest == 1 then
											_Urwigo.RunDialogs(function()
												Wherigo.GetInput(zinputOakQ2)
											end)
										elseif OakQuest == 2 then
											_Urwigo.RunDialogs(function()
												Wherigo.GetInput(zinputOakQ3)
											end)
										end
									end
								end
							end
						}
						OakComplete = OakComplete + 1
					end
				end
			end
		}
	elseif OakComplete == 1 then
		_Urwigo.MessageBox{
			Text = _CBm("\004\093\078\063\073\039\098\078\116\073\111\096\041\098\078\012\073\045\098\078\116\073\111\126\078\126\098\109\098\010\126\075\063\067\004"), 
			Media = zmediaNorthernRedOak_MSG, 
			Callback = function(action)
				if action ~= nil then
					if (action) ~= nil then
						if OakQuest == 0 then
							_Urwigo.RunDialogs(function()
								Wherigo.GetInput(zinputOakQ1)
							end)
						elseif OakQuest == 1 then
							_Urwigo.RunDialogs(function()
								Wherigo.GetInput(zinputOakQ2)
							end)
						elseif OakQuest == 2 then
							_Urwigo.RunDialogs(function()
								Wherigo.GetInput(zinputOakQ3)
							end)
						end
					end
				end
			end
		}
	elseif OakComplete == 2 then
		_Urwigo.MessageBox{
			Text = _CBm("\004\020\028\126\113\009\063\003\064\078\098\045\073\111\009\063\078\003\010\028\115\113\045\009\067\078\093\096\041\098\078\009\073\003\078\039\028\010\075\098\109\078\003\073\078\009\073\064\078\003\126\098\098\109\078\003\073\078\109\098\098\067\078\105\056\030\069\105\056\030\069\004\093\088\078\116\073\111\078\045\098\098\012\078\003\073\078\003\010\028\115\078\010\055\073\111\003\078\116\073\111\126\078\126\098\109\098\010\126\075\063\064\078\003\126\116\078\073\045\098\078\073\088\078\003\063\098\078\073\003\063\098\126\078\003\126\098\098\109\067\004"), 
			Media = zmediaNorthernRedOak_MSG
		}
	end
end
function zcharacterNorthernRedOak:OnExamine(target)
	_Urwigo.MessageBox{
		Text = "", 
		Media = zmediaNorthernRedOak_Examine
	}
end
function zcharacterFringeTree:OnTalk(target)
	if ((FringeComplete == 2) and (HollyComplete == 2)) and (OakComplete == 2) then
		_Urwigo.MessageBox{
			Text = _CBm("\004\093\078\003\063\113\045\115\078\116\073\111\096\126\098\078\010\028\028\078\012\073\045\098\078\063\098\126\098\067\078\105\056\030\069\105\056\030\069\004\035\063\098\075\115\078\003\063\098\078\096\036\010\109\115\109\096\078\024\098\045\111\078\113\088\078\116\073\111\096\126\098\078\111\045\109\111\126\098\078\073\088\078\089\063\010\003\078\003\073\078\012\073\078\045\098\005\003\067\004"), 
			Media = zmediaFringeTree_MSG
		}
	elseif FringeComplete == 0 then
		_Urwigo.MessageBox{
			Text = _CBm("\004\029\098\028\028\064\078\063\098\116\078\003\063\098\126\098\067\078\093\003\078\109\098\098\024\109\078\028\113\115\098\078\116\073\111\096\126\098\078\028\073\073\115\113\045\009\078\088\073\126\078\109\073\024\098\003\063\113\045\009\016\078\119\098\078\126\113\009\063\003\016\124\078\093\078\115\045\098\089\078\113\003\124\078\093\096\024\078\010\078\075\028\098\041\098\126\078\073\028\012\078\003\126\098\098\067\004"), 
			Media = zmediaFringeTree_MSG, 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.MessageBox{
						Text = _CBm("\004\093\096\028\028\078\055\098\003\078\093\078\115\045\073\089\078\089\063\010\003\078\116\073\111\096\126\098\078\063\098\126\098\078\088\073\126\078\003\073\073\067\078\029\098\028\028\064\078\093\078\075\010\045\096\003\078\028\098\003\078\116\073\111\078\009\098\003\078\113\003\078\003\063\010\003\078\098\010\109\113\028\116\067\004"), 
						Media = zmediaFringeTree_MSG, 
						Callback = function(action)
							if action ~= nil then
								if (action) ~= nil then
									if FringeQuest == 0 then
										_Urwigo.RunDialogs(function()
											Wherigo.GetInput(zinputFringeQ1)
										end)
									elseif FringeQuest == 1 then
										_Urwigo.RunDialogs(function()
											Wherigo.GetInput(zinputFringeQ2)
										end)
									elseif FringeQuest == 2 then
										_Urwigo.RunDialogs(function()
											Wherigo.GetInput(zinputFringeQ3)
										end)
									end
								end
							end
						end
					}
					FringeComplete = FringeComplete + 1
				end
			end
		}
	elseif FringeComplete == 1 then
		_Urwigo.MessageBox{
			Text = _CBm("\004\030\098\024\098\024\055\098\126\064\078\010\078\009\073\073\012\078\009\111\024\109\063\073\098\078\012\073\098\109\078\003\063\073\126\073\111\009\063\078\126\098\109\098\010\126\075\063\067\004"), 
			Media = zmediaFringeTree_MSG, 
			Callback = function(action)
				if action ~= nil then
					if (action) ~= nil then
						if FringeQuest == 0 then
							_Urwigo.RunDialogs(function()
								Wherigo.GetInput(zinputFringeQ1)
							end)
						elseif FringeQuest == 1 then
							_Urwigo.RunDialogs(function()
								Wherigo.GetInput(zinputFringeQ2)
							end)
						elseif FringeQuest == 2 then
							_Urwigo.RunDialogs(function()
								Wherigo.GetInput(zinputFringeQ3)
							end)
						end
					end
				end
			end
		}
	elseif FringeComplete == 2 then
		_Urwigo.MessageBox{
			Text = _CBm("\004\035\073\028\028\010\055\073\126\010\003\113\073\045\078\113\109\078\003\063\098\078\115\098\116\078\003\073\078\126\098\109\098\010\126\075\063\067\078\036\063\098\126\098\078\010\126\098\078\073\003\063\098\126\078\003\126\098\098\109\078\055\098\109\113\012\098\078\024\116\109\098\028\088\078\089\063\073\078\089\073\111\028\012\078\055\098\078\063\010\039\039\116\078\003\073\078\063\010\041\098\078\010\078\075\063\010\003\067\004"), 
			Media = zmediaFringeTree_MSG
		}
	end
end
function zcharacterFringeTree:OnExamine(target)
	_Urwigo.MessageBox{
		Text = "", 
		Media = zmediaFringeTree_Examine
	}
end
function zitemBooklet:OnNorthernRedOak(target)
	if OakComplete == 2 then
		_Urwigo.MessageBox{
			Text = _CBm("\107\010\003\113\045\078\032\010\024\098\106\078\037\111\098\126\075\111\109\078\030\111\055\126\010\078\105\056\030\069\035\073\024\024\073\045\078\032\010\024\098\106\078\032\073\126\003\063\098\126\045\078\030\098\012\078\072\010\115\078\105\056\030\069\074\044\030\098\028\010\003\113\041\098\028\116\078\028\010\126\009\098\078\028\098\010\041\098\109\067\078\122\010\041\098\078\102\074\095\095\078\003\073\073\003\063\098\012\078\024\010\126\009\113\045\109\078\038\024\010\126\009\113\045\109\078\010\126\098\078\003\063\098\078\098\012\009\098\078\073\088\078\003\063\098\078\028\098\010\041\098\109\054\067\078\105\056\030\069\074\044\058\126\111\113\003\109\078\126\113\039\098\045\078\113\045\078\003\063\098\078\095\082\003\063\078\024\073\045\003\063\078\010\088\003\098\126\078\039\073\028\028\113\045\010\003\113\073\045\067\078\105\056\030\069\074\044\058\126\111\113\003\109\078\063\010\041\098\078\012\010\126\115\078\055\126\073\089\045\078\075\010\039\078\010\045\012\078\010\126\098\078\085\067\102\108\004\078\003\073\078\095\004\078\028\073\045\009\067"), 
			Media = zmediaBookletRevealed_Oak
		}
	else
		_Urwigo.MessageBox{
			Text = _CBm("\107\010\003\113\045\078\032\010\024\098\106\078\037\111\098\126\075\111\109\078\030\111\055\126\010\078\105\056\030\069\035\073\024\024\073\045\078\032\010\024\098\106\078\032\073\126\003\063\098\126\045\078\030\098\012\078\072\010\115\078\105\056\030\069\074\044\030\098\028\010\003\113\041\098\028\116\078\028\010\126\009\098\078\028\098\010\041\098\109\067\078\122\010\041\098\078\102\074\095\095\078\003\073\073\003\063\098\012\078\024\010\126\009\113\045\109\078\038\024\010\126\009\113\045\109\078\010\126\098\078\003\063\098\078\098\012\009\098\078\073\088\078\003\063\098\078\028\098\010\041\098\109\054\067\078\105\056\030\069\074\044\058\126\111\113\003\109\078\126\113\039\098\045\078\113\045\078\003\063\098\078\095\082\003\063\078\024\073\045\003\063\078\010\088\003\098\126\078\039\073\028\028\113\045\010\003\113\073\045\067\078\105\056\030\069\074\044\058\126\111\113\003\109\078\063\010\041\098\078\012\010\126\115\078\055\126\073\089\045\078\075\010\039\078\010\045\012\078\010\126\098\078\085\067\102\108\004\078\003\073\078\095\004\078\028\073\045\009\067"), 
			Media = zmediaOpenBooklet_Oak
		}
	end
end
function zitemBooklet:OnAmericanHolly(target)
	if HollyComplete == 2 then
		_Urwigo.MessageBox{
			Text = _CBm("\107\010\003\113\045\078\032\010\024\098\106\078\093\028\098\005\078\072\039\010\075\010\078\105\056\030\069\035\073\024\024\073\045\078\032\010\024\098\106\078\020\024\098\126\113\075\010\045\078\122\073\028\028\116\078\105\056\030\069\074\044\097\041\098\126\009\126\098\098\045\078\028\098\010\041\098\109\078\089\113\003\063\078\009\126\098\098\045\078\075\073\028\073\126\067\078\105\056\030\069\074\044\058\010\113\126\028\116\078\109\063\010\126\039\078\109\039\113\045\098\109\078\039\073\113\045\003\078\073\111\003\078\073\088\078\028\098\010\088\078\024\010\126\009\113\045\109\078\038\024\010\126\009\113\045\109\078\010\126\098\078\003\063\098\078\098\012\009\098\078\073\088\078\003\063\098\078\028\098\010\041\098\109\054\067\078\105\056\030\069\074\044\029\063\098\045\078\003\063\098\078\088\126\111\113\003\109\078\010\126\098\078\075\073\045\109\111\024\098\012\078\055\116\078\075\063\113\028\012\126\098\045\078\003\063\098\116\078\075\010\111\109\098\078\012\113\010\126\126\063\098\010\078\010\045\012\078\041\073\024\113\003\113\045\009\067"), 
			Media = zmediaBookletRevealed_Holly
		}
	else
		_Urwigo.MessageBox{
			Text = _CBm("\107\010\003\113\045\078\032\010\024\098\106\078\093\028\098\005\078\072\039\010\075\010\078\105\056\030\069\035\073\024\024\073\045\078\032\010\024\098\106\078\020\024\098\126\113\075\010\045\078\122\073\028\028\116\078\105\056\030\069\074\044\097\041\098\126\009\126\098\098\045\078\028\098\010\041\098\109\078\089\113\003\063\078\009\126\098\098\045\078\075\073\028\073\126\067\078\105\056\030\069\074\044\058\010\113\126\028\116\078\109\063\010\126\039\078\109\039\113\045\098\109\078\039\073\113\045\003\078\073\111\003\078\073\088\078\028\098\010\088\078\024\010\126\009\113\045\109\078\038\024\010\126\009\113\045\109\078\010\126\098\078\003\063\098\078\098\012\009\098\078\073\088\078\003\063\098\078\028\098\010\041\098\109\054\067\078\105\056\030\069\074\044\029\063\098\045\078\003\063\098\078\088\126\111\113\003\109\078\010\126\098\078\075\073\045\109\111\024\098\012\078\055\116\078\075\063\113\028\012\126\098\045\078\003\063\098\116\078\075\010\111\109\098\078\012\113\010\126\126\063\098\010\078\010\045\012\078\041\073\024\113\003\113\045\009\067"), 
			Media = zmediaOpenBooklet_Holly
		}
	end
end
function zitemBooklet:OnFringeTree(target)
	if FringeComplete == 2 then
		_Urwigo.MessageBox{
			Text = _CBm("\107\010\003\113\045\078\032\010\024\098\106\078\035\063\113\073\045\010\045\003\063\111\109\078\125\113\126\009\113\045\113\075\111\109\078\105\056\030\069\035\073\024\024\073\045\078\032\010\024\098\106\078\058\126\113\045\009\098\078\036\126\098\098\064\078\072\028\012\078\119\010\045\096\109\078\056\098\010\126\012\078\105\056\030\069\074\044\127\113\024\039\028\098\064\078\109\024\073\073\003\063\078\024\010\126\009\113\045\109\078\038\024\010\126\009\113\045\109\078\010\126\098\078\003\063\098\078\098\012\009\098\078\073\088\078\003\063\098\078\028\098\010\041\098\109\054\067\078\105\056\030\069\074\044\107\098\010\041\098\109\078\003\111\126\045\078\075\028\098\010\126\078\116\098\028\028\073\089\078\113\045\078\010\111\003\111\024\045\067\078\058\028\073\089\098\126\109\078\010\126\098\078\088\126\010\009\126\010\045\003\078\113\045\078\028\010\003\098\078\109\039\126\113\045\009\067\078\105\056\030\069\074\044\036\126\098\098\078\055\010\126\115\078\075\010\045\078\055\098\078\010\039\039\028\113\098\012\078\003\073\078\089\073\111\045\012\109\064\078\109\073\126\098\109\064\078\010\045\012\078\055\126\111\113\109\098\109\078\003\073\078\063\098\010\028\078\003\063\098\024\067"), 
			Media = zmediaBookletRevealed_Fringe
		}
	else
		_Urwigo.MessageBox{
			Text = _CBm("\107\010\003\113\045\078\032\010\024\098\106\078\035\063\113\073\045\010\045\003\063\111\109\078\125\113\126\009\113\045\113\075\111\109\078\105\056\030\069\035\073\024\024\073\045\078\032\010\024\098\106\078\058\126\113\045\009\098\078\036\126\098\098\064\078\072\028\012\078\119\010\045\096\109\078\056\098\010\126\012\078\105\056\030\069\074\044\127\113\024\039\028\098\064\078\109\024\073\073\003\063\078\024\010\126\009\113\045\109\078\038\024\010\126\009\113\045\109\078\010\126\098\078\003\063\098\078\098\012\009\098\078\073\088\078\003\063\098\078\028\098\010\041\098\109\054\067\078\105\056\030\069\074\044\107\098\010\041\098\109\078\003\111\126\045\078\075\028\098\010\126\078\116\098\028\028\073\089\078\113\045\078\010\111\003\111\024\045\067\078\058\028\073\089\098\126\109\078\010\126\098\078\088\126\010\009\126\010\045\003\078\113\045\078\028\010\003\098\078\109\039\126\113\045\009\067\078\105\056\030\069\074\044\036\126\098\098\078\055\010\126\115\078\075\010\045\078\055\098\078\010\039\039\028\113\098\012\078\003\073\078\089\073\111\045\012\109\064\078\109\073\126\098\109\064\078\010\045\012\078\055\126\111\113\109\098\109\078\003\073\078\063\098\010\028\078\003\063\098\024\067"), 
			Media = zmediaOpenBooklet_Fringe
		}
	end
end
function zitemFruit:OnExamine(target)
	_Urwigo.MessageBox{
		Text = _CBm("\036\063\098\078\088\126\111\113\003\109\078\010\126\098\078\012\010\126\115\078\055\028\111\098\078\009\126\010\039\098\078\028\113\115\098\078\075\028\111\109\003\098\126\109\067\078\107\073\073\115\109\078\010\039\039\098\003\113\057\113\045\009\067"), 
		Media = zmediaFruit_MSG
	}
end
function zitemFruit:OnGive(target)
	if GiveSpecimens == 2 then
		_Urwigo.MessageBox{
			Text = _CBm("\004\029\098\028\028\078\012\073\045\098\124\078\021\073\111\096\041\098\078\024\010\045\010\009\098\012\078\003\073\078\009\098\003\078\010\028\028\078\003\063\126\098\098\078\109\010\024\039\028\098\109\124\078\021\073\111\078\024\010\115\098\078\010\078\009\126\098\010\003\078\126\098\109\098\010\126\075\063\098\126\124\004"), 
			Media = zmediaResearcherHank_MSG, 
			Callback = function(action)
				if action ~= nil then
					if (action) ~= nil then
						_Urwigo.OldDialog{
							{
								Text = _CBm("\004\036\063\098\078\109\010\024\039\028\098\109\078\116\073\111\078\075\073\028\028\098\075\003\098\012\078\089\113\028\028\078\055\098\075\073\024\098\078\010\078\039\010\126\003\078\073\088\078\073\111\126\078\039\028\010\045\003\078\028\113\055\126\010\126\116\064\078\003\063\098\078\122\098\126\055\010\126\113\111\024\067\004"), 
								Media = zmediaResearcherHank_MSG
							}, 
							{
								Text = _CBm("\004\058\073\126\078\116\073\111\126\078\010\109\109\113\109\003\010\045\075\098\064\078\093\096\024\078\010\089\010\126\012\113\045\009\078\116\073\111\078\003\063\113\109\078\109\039\098\075\113\010\028\078\055\010\012\009\098\067\004"), 
								Media = zmediaResearcherHank_MSG
							}, 
							{
								Text = _CBm("\093\003\096\109\078\003\063\098\078\127\098\075\126\098\003\078\122\098\028\039\098\126\078\055\010\012\009\098\124\078\036\063\113\109\078\055\010\012\009\098\078\028\098\003\109\078\098\041\098\126\116\073\045\098\078\115\045\073\089\078\010\055\073\111\003\078\116\073\111\126\078\010\075\075\073\024\039\028\113\109\063\024\098\045\003\067\078\072\045\078\003\063\098\078\055\073\003\003\073\024\078\073\088\078\003\063\098\078\055\010\012\009\098\078\116\073\111\078\109\098\098\078\010\078\109\098\003\078\073\088\078\075\073\073\126\012\113\045\010\003\098\109\067\078\036\063\098\078\009\098\073\075\010\075\063\098\078\113\109\078\045\073\089\078\041\113\109\113\055\028\098\078\113\045\078\028\073\075\010\003\113\073\045\109\067"), 
								Media = zmediaBadge_MSG
							}
						}
						ztaskReturnthespecimens.Complete = true
						zitemSecretHelperBadge:MoveTo(Player)
						GiveSpecimens = GiveSpecimens + 1
						HankTalk = HankTalk + 1
						zitemBark.Commands.Give.Enabled = false
						zitemLeaf.Commands.Give.Enabled = false
						zitemFruit.Commands.Give.Enabled = false
					end
				end
			end
		}
		zitemFruit:MoveTo(zcharacterResearcherHank)
		_z14Hx.Active = true
		zoneClimatron.Active = false
	elseif GiveSpecimens == 1 then
		_Urwigo.MessageBox{
			Text = _CBm("\004\029\063\010\003\078\010\078\028\073\041\098\028\116\078\088\126\111\113\003\078\109\010\024\039\028\098\067\078\036\089\073\078\012\073\089\045\124\004"), 
			Media = zmediaResearcherHank_MSG
		}
		GiveSpecimens = GiveSpecimens + 1
		zitemFruit:MoveTo(zcharacterResearcherHank)
	elseif GiveSpecimens == 0 then
		_Urwigo.MessageBox{
			Text = _CBm("\004\029\063\010\003\078\010\078\028\073\041\098\028\116\078\088\126\111\113\003\078\109\010\024\039\028\098\067\078\072\045\098\078\012\073\089\045\124\004"), 
			Media = zmediaResearcherHank_MSG
		}
		GiveSpecimens = GiveSpecimens + 1
		zitemFruit:MoveTo(zcharacterResearcherHank)
	end
end
function zitemLeaf:OnExamine(target)
	_Urwigo.MessageBox{
		Text = _CBm("\049\126\098\098\045\078\039\073\113\045\003\116\078\028\098\010\041\098\109\078\010\045\012\078\126\098\012\078\088\126\111\113\003\109\078\010\126\098\078\009\126\098\010\003\078\088\073\126\078\010\126\075\063\113\041\113\045\009\064\078\055\111\003\078\010\028\109\073\078\088\073\126\078\122\073\028\113\012\010\116\078\012\098\075\073\126\010\003\113\073\045\109\067"), 
		Media = zmediaLeaf_MSG
	}
end
function zitemLeaf:OnGive(target)
	if GiveSpecimens == 2 then
		_Urwigo.MessageBox{
			Text = _CBm("\004\029\098\028\028\078\012\073\045\098\124\078\021\073\111\096\041\098\078\024\010\045\010\009\098\012\078\003\073\078\009\098\003\078\010\028\028\078\003\063\126\098\098\078\109\010\024\039\028\098\109\124\078\021\073\111\078\024\010\115\098\078\010\078\009\126\098\010\003\078\126\098\109\098\010\126\075\063\098\126\124\004"), 
			Media = zmediaResearcherHank_MSG, 
			Callback = function(action)
				if action ~= nil then
					if (action) ~= nil then
						_Urwigo.OldDialog{
							{
								Text = _CBm("\004\036\063\098\078\109\010\024\039\028\098\109\078\116\073\111\078\075\073\028\028\098\075\003\098\012\078\089\113\028\028\078\055\098\075\073\024\098\078\010\078\039\010\126\003\078\073\088\078\073\111\126\078\039\028\010\045\003\078\028\113\055\126\010\126\116\064\078\003\063\098\078\122\098\126\055\010\126\113\111\024\067\004"), 
								Media = zmediaResearcherHank_MSG
							}, 
							{
								Text = _CBm("\004\058\073\126\078\116\073\111\126\078\010\109\109\113\109\003\010\045\075\098\064\078\093\096\024\078\010\089\010\126\012\113\045\009\078\116\073\111\078\003\063\113\109\078\109\039\098\075\113\010\028\078\055\010\012\009\098\067\004"), 
								Media = zmediaResearcherHank_MSG
							}, 
							{
								Text = _CBm("\036\063\098\078\127\098\075\126\098\003\078\122\098\028\039\098\126\078\055\010\012\009\098\078\028\098\003\109\078\098\041\098\126\116\073\045\098\078\115\045\073\089\078\010\055\073\111\003\078\116\073\111\126\078\010\075\075\073\024\039\028\113\109\063\024\098\045\003\067\078\072\045\078\003\063\098\078\055\073\003\003\073\024\078\073\088\078\003\063\098\078\055\010\012\009\098\078\116\073\111\078\109\098\098\078\010\078\109\098\003\078\073\088\078\075\073\073\126\012\113\045\010\003\098\109\067\078\036\063\098\078\009\098\073\075\010\075\063\098\078\113\109\078\045\073\089\078\041\113\109\113\055\028\098\078\113\045\078\028\073\075\010\003\113\073\045\109\067"), 
								Media = zmediaBadge_MSG
							}
						}
						ztaskReturnthespecimens.Complete = true
						zitemSecretHelperBadge:MoveTo(Player)
						GiveSpecimens = GiveSpecimens + 1
						HankTalk = HankTalk + 1
						zitemBark.Commands.Give.Enabled = false
						zitemLeaf.Commands.Give.Enabled = false
						zitemFruit.Commands.Give.Enabled = false
					end
				end
			end
		}
		zitemLeaf:MoveTo(zcharacterResearcherHank)
		_z14Hx.Active = true
		zoneClimatron.Active = false
	elseif GiveSpecimens == 1 then
		_Urwigo.MessageBox{
			Text = _CBm("\004\020\078\041\098\126\116\078\045\113\075\098\078\028\098\010\088\078\109\010\024\039\028\098\124\078\036\089\073\078\012\073\089\045\124\004"), 
			Media = zmediaResearcherHank_MSG
		}
		GiveSpecimens = GiveSpecimens + 1
		zitemLeaf:MoveTo(zcharacterResearcherHank)
	elseif GiveSpecimens == 0 then
		_Urwigo.MessageBox{
			Text = _CBm("\004\020\078\041\098\126\116\078\045\113\075\098\078\028\098\010\088\078\109\010\024\039\028\098\124\078\072\045\098\078\012\073\089\045\124\004"), 
			Media = zmediaResearcherHank_MSG
		}
		GiveSpecimens = GiveSpecimens + 1
		zitemLeaf:MoveTo(zcharacterResearcherHank)
	end
end
function zitemBark:OnExamine(target)
	_Urwigo.MessageBox{
		Text = _CBm("\056\126\073\089\045\113\109\063\078\010\045\012\078\009\126\010\116\078\089\126\113\045\115\028\116\078\055\010\126\115\067"), 
		Media = zmediaBark_MSG
	}
end
function zitemBark:OnGive(target)
	if GiveSpecimens == 2 then
		_Urwigo.MessageBox{
			Text = _CBm("\004\029\098\028\028\078\012\073\045\098\124\078\021\073\111\096\041\098\078\024\010\045\010\009\098\012\078\003\073\078\009\098\003\078\010\028\028\078\003\063\126\098\098\078\109\010\024\039\028\098\109\124\078\021\073\111\078\024\010\115\098\078\010\078\009\126\098\010\003\078\126\098\109\098\010\126\075\063\098\126\124\004"), 
			Media = zmediaResearcherHank_MSG, 
			Callback = function(action)
				if action ~= nil then
					if (action) ~= nil then
						_Urwigo.OldDialog{
							{
								Text = _CBm("\004\036\063\098\078\109\010\024\039\028\098\109\078\116\073\111\078\075\073\028\028\098\075\003\098\012\078\089\113\028\028\078\055\098\075\073\024\098\078\010\078\039\010\126\003\078\073\088\078\073\111\126\078\039\028\010\045\003\078\028\113\055\126\010\126\116\064\078\003\063\098\078\122\098\126\055\010\126\113\111\024\067\004"), 
								Media = zmediaResearcherHank_MSG
							}, 
							{
								Text = _CBm("\004\058\073\126\078\116\073\111\126\078\010\109\109\113\109\003\010\045\075\098\064\078\093\096\024\078\010\089\010\126\012\113\045\009\078\116\073\111\078\003\063\113\109\078\109\039\098\075\113\010\028\078\055\010\012\009\098\067\004"), 
								Media = zmediaResearcherHank_MSG
							}, 
							{
								Text = _CBm("\093\003\096\109\078\003\063\098\078\127\098\075\126\098\003\078\122\098\028\039\098\126\078\055\010\012\009\098\124\078\036\063\113\109\078\055\010\012\009\098\078\028\098\003\109\078\098\041\098\126\116\073\045\098\078\115\045\073\089\078\010\055\073\111\003\078\116\073\111\126\078\010\075\075\073\024\039\028\113\109\063\024\098\045\003\067\078\072\045\078\003\063\098\078\055\073\003\003\073\024\078\073\088\078\003\063\098\078\055\010\012\009\098\078\116\073\111\078\109\098\098\078\010\078\109\098\003\078\073\088\078\075\073\073\126\012\113\045\010\003\098\109\067\078\036\063\098\078\009\098\073\075\010\075\063\098\078\113\109\078\045\073\089\078\041\113\109\113\055\028\098\078\113\045\078\028\073\075\010\003\113\073\045\109\067"), 
								Media = zmediaBadge_MSG
							}
						}
						ztaskReturnthespecimens.Complete = true
						zitemSecretHelperBadge:MoveTo(Player)
						GiveSpecimens = GiveSpecimens + 1
						HankTalk = HankTalk + 1
						zitemBark.Commands.Give.Enabled = false
						zitemLeaf.Commands.Give.Enabled = false
						zitemFruit.Commands.Give.Enabled = false
					end
				end
			end
		}
		zitemBark:MoveTo(zcharacterResearcherHank)
		_z14Hx.Active = true
		zoneClimatron.Active = false
	elseif GiveSpecimens == 1 then
		_Urwigo.MessageBox{
			Text = _CBm("\004\036\063\113\109\078\055\010\126\115\078\109\010\024\039\028\098\078\113\109\078\113\024\039\098\075\075\010\055\028\098\124\078\029\098\028\028\078\012\073\045\098\067\078\036\089\073\078\012\073\089\045\124\004"), 
			Media = zmediaResearcherHank_MSG
		}
		GiveSpecimens = GiveSpecimens + 1
		zitemBark:MoveTo(zcharacterResearcherHank)
	elseif GiveSpecimens == 0 then
		_Urwigo.MessageBox{
			Text = _CBm("\004\036\063\113\109\078\055\010\126\115\078\109\010\024\039\028\098\078\113\109\078\113\024\039\098\075\075\010\055\028\098\124\078\029\098\028\028\078\012\073\045\098\067\078\072\045\098\078\012\073\089\045\124\004"), 
			Media = zmediaResearcherHank_MSG
		}
		GiveSpecimens = GiveSpecimens + 1
		zitemBark:MoveTo(zcharacterResearcherHank)
	end
end
function zitemSecretHelperBadge:OnExamine(target)
	_Urwigo.MessageBox{
		Text = _CBm("\036\063\098\078\127\098\075\126\098\003\078\122\098\028\039\098\126\078\055\010\012\009\098\078\028\098\003\109\078\098\041\098\126\116\073\045\098\078\115\045\073\089\078\010\055\073\111\003\078\116\073\111\126\078\010\075\075\073\024\039\028\113\109\063\024\098\045\003\067\078\086\098\126\063\010\039\109\078\116\073\111\078\109\063\073\111\028\012\078\039\111\003\078\113\003\078\073\045\078\116\073\111\126\078\027\010\075\115\098\003\016"), 
		Media = zmediaBadge_MSG
	}
end

-- Urwigo functions --

-- Begin user functions --
-----------------------------------------------------------------------------------------------
-- URWIGO: Following code is imported from the Wherigo Builder cartridge.
-- It is only neccessary if the cartridge uses Author functions that use message box callbacks.
-- Otherwise it can be removed.
cartTheUnseenGardenMoBot.MsgBoxCBFuncs = {}
-------------------------------------------------------------------------------
--#LASTCALLBACKKEY=8#--
cartTheUnseenGardenMoBot.MsgBoxCBFuncs.MsgBoxCB1 = function(action)
if action ~= nil then
-- #GroupDescription=Script Description --
-- #Comment=Script Comment --
Wherigo.MessageBox{Text=[["I'll bet I know what you're here for too. Well, I can't let you get it that easily."]],Media=zmediaFringeTree_MSG,Callback=cartTheUnseenGardenMoBot.MsgBoxCBFuncs.MsgBoxCB2}
FringeComplete = FringeComplete + 1
end
end

cartTheUnseenGardenMoBot.MsgBoxCBFuncs.MsgBoxCB2 = function(action)
-- #GroupDescription=Script --
-- #Comment=Script Comment --
if action ~= nil then
if   FringeQuest == 0 then
Wherigo.GetInput(zinputFringeQ1)
elseif FringeQuest == 1 then
Wherigo.GetInput(zinputFringeQ2)
elseif FringeQuest == 2 then
Wherigo.GetInput(zinputFringeQ3)
end
end
end

cartTheUnseenGardenMoBot.MsgBoxCBFuncs.MsgBoxCB5 = function(action)
-- #GroupDescription=Script Description --
-- #Comment=Script Comment --
if action ~= nil then
Wherigo.MessageBox{Text=[["You're a researcher, you say? Well, if you're so smart, then tell me some things about oak trees."]],Media=zmediaNorthernRedOak_MSG,Callback=cartTheUnseenGardenMoBot.MsgBoxCBFuncs.MsgBoxCB6}
OakComplete = OakComplete + 1
end
end

cartTheUnseenGardenMoBot.MsgBoxCBFuncs.MsgBoxCB6 = function(action)
-- #GroupDescription=Script Description --
-- #Comment=Script Comment --
if action ~= nil then
if   OakQuest == 0 then
Wherigo.GetInput(zinputOakQ1)
elseif OakQuest == 1 then
Wherigo.GetInput(zinputOakQ2)
elseif OakQuest == 2 then
Wherigo.GetInput(zinputOakQ3)
end
end
end

cartTheUnseenGardenMoBot.MsgBoxCBFuncs.MsgBoxCB7 = function(action)
-- #GroupDescription=Script Description --
-- #Comment=Script Comment --
if action ~= nil then
if   OakComplete == 2 and FringeComplete == 2 and HollyComplete == 2 then
ztaskMeettheTrees.Complete = true
ztaskCollect3Specimens.Complete = true
ztaskReturnthespecimens.Visible = true
ztaskReturnthespecimens.Active = true
zoneClimatron.Visible = true
zoneClimatron.Active = true
HankTalk = HankTalk + 1
Wherigo.MessageBox{Text=[[New Task: Return the specimens. 

Researcher Hank is waiting for you at the Climatron.]],Media=zmediaClimatron_TASK}
end
end
end

cartTheUnseenGardenMoBot.MsgBoxCBFuncs.MsgBoxCB4 = function(action)
-- #GroupDescription=Script --
-- #Comment=Script Comment --
if action ~= nil then
if   HollyQuest == 0 then
Wherigo.GetInput(zinputHollyQ1)
elseif HollyQuest == 1 then
Wherigo.GetInput(zinputHollyQ2)
elseif HollyQuest == 2 then
Wherigo.GetInput(zinputHollyQ3)
end
end
end

cartTheUnseenGardenMoBot.MsgBoxCBFuncs.MsgBoxCB3 = function(action)
-- #GroupDescription=Script Description --
-- #Comment=Script Comment --
if action ~= nil then
Wherigo.MessageBox{Text=[["Though, you seem fairly harmless. I will let you take a specimen if you like. First, I think you should know something about my kind."]],Media=zmediaAmericanHolly_MSG,Callback=cartTheUnseenGardenMoBot.MsgBoxCBFuncs.MsgBoxCB4}
HollyComplete = HollyComplete + 1
end
end

cartTheUnseenGardenMoBot.MsgBoxCBFuncs.MsgBoxCB8 = function(action)
-- #GroupDescription=Script Description --
-- #Comment=Script Comment --
if action ~= nil then
Wherigo.Dialog{{Text=[["The samples you collected will become a part of our plant library, the Herbarium."]],Media=zmediaResearcherHank_MSG},{Text=[["For your assistance, I'm awarding you this special badge."]],Media=zmediaResearcherHank_MSG},{Text=[[This cartridge was brought to you by J2B2 in conjunction with the Missouri Botanical Garden. 

Remember to log your playing experience at www.wherigo.com. 

To learn more about the Missouri Botanical Garden, please visit www.mobot.org. Thanks for playing!]],Media=zmediaBadge_MSG},}
ztaskReturnthespecimens.Complete = true
zitemSecretHelperBadge:MoveTo(Player)
GiveSpecimens = GiveSpecimens + 1
HankTalk = HankTalk + 1
zitemBark.Commands["Give"].Enabled = false
zitemLeaf.Commands["Give"].Enabled = false
zitemFruit.Commands["Give"].Enabled = false
end
end


-----------------------------------------------------------------------------------------------
-- URWIGO: Here follow imported Author functions


-- End user functions --
return cartTheUnseenGardenMoBot
