require "Wherigo"
ZonePoint = Wherigo.ZonePoint
Distance = Wherigo.Distance
Player = Wherigo.Player

cartGC2C5FN = Wherigo.ZCartridge()

-- String decode --
function _o9p(str)
	local res = ""
    local dtable = "\092\031\012\021\028\125\006\101\038\016\034\115\118\061\071\117\108\062\009\027\063\004\100\107\032\064\110\013\003\119\037\067\102\050\077\083\075\022\087\103\000\124\033\068\039\044\070\081\049\085\007\105\036\008\120\043\046\099\109\090\023\051\055\025\122\095\078\112\113\026\084\042\040\011\019\082\058\097\088\018\086\014\054\096\098\024\093\126\069\106\002\030\094\010\059\080\089\015\111\065\048\060\045\001\079\116\076\114\041\047\121\066\057\020\017\073\072\052\123\005\029\074\035\056\104\091\053"
	for i=1, #str do
        local b = str:byte(i)
        if b > 0 and b <= 0x7F then
	        res = res .. string.char(dtable:byte(b))
        else
            res = res .. string.char(b)
        end
	end
	return res
end

-- Internal functions --
require "table"
require "math"

math.randomseed(os.time())
math.random()
math.random()
math.random()

_Urwigo = {}

_Urwigo.Round = function(num, idp)
  local mult = 10^(idp or 0)
  return math.floor(num * mult + 0.5) / mult
end

_Urwigo.Ceil = function(num, idp)
  local mult = 10^(idp or 0)
  return math.ceil(num * mult) / mult
end

_Urwigo.Floor = function(num, idp)
  local mult = 10^(idp or 0)
  return math.floor(num * mult) / mult
end

_Urwigo.DialogQueue = {}
_Urwigo.RunDialogs = function(callback)
	local dialogs = _Urwigo.DialogQueue
	local lastCallback = nil
	_Urwigo.DialogQueue = {}
	local msgcb = {}
	msgcb = function(action)
		if action ~= nil then
			if lastCallback ~= nil then
				lastCallback(action)
			end
			local entry = table.remove(dialogs, 1)
			if entry ~= nil then
				lastCallback = entry.Callback;
				if entry.Text ~= nil then
					Wherigo.MessageBox({Text = entry.Text, Media=entry.Media, Buttons=entry.Buttons, Callback=msgcb})
				else
					msgcb(action)
				end
			else
				if callback ~= nil then
					callback()
				end
			end
		end
	end
	msgcb(true) -- any non-null argument
end

_Urwigo.MessageBox = function(tbl)
    _Urwigo.RunDialogs(function() Wherigo.MessageBox(tbl) end)
end

_Urwigo.OldDialog = function(tbl)
    _Urwigo.RunDialogs(function() Wherigo.Dialog(tbl) end)
end

_Urwigo.Dialog = function(buffered, tbl, callback)
	for k,v in ipairs(tbl) do
		table.insert(_Urwigo.DialogQueue, v)
	end
	if callback ~= nil then
		table.insert(_Urwigo.DialogQueue, {Callback=callback})
	end
	if not buffered then
		_Urwigo.RunDialogs(nil)
	end
end

_Urwigo.Hash = function(str)
   local b = 378551;
   local a = 63689;
   local hash = 0;
   for i = 1, #str, 1 do
      hash = hash*a+string.byte(str,i);
      hash = math.fmod(hash, 65535)
      a = a*b;
      a = math.fmod(a, 65535)
   end
   return hash;
end


-- Media --
zmediaC3DETAILS100 = Wherigo.ZMedia(cartGC2C5FN)
zmediaC3DETAILS100.Id = "444693f3-5369-4a26-9191-c2e7b103f5f9"
zmediaC3DETAILS100.Name = _o9p("\032\062\103\044\089\071\100\116\107\036\103\049\101\101")
zmediaC3DETAILS100.Description = _o9p("\015\078\059\008\025\044\008\106\078\052\017\012")
zmediaC3DETAILS100.AltText = _o9p("\015\100\035\089\025\044\089\071\100\116\107\036")
zmediaC3DETAILS100.Resources = {
	{
		Type = "jpg", 
		Filename = "C3-DETAILS-100.jpg", 
		Directives = {}
	}
}
zmediaC3DETAILS130 = Wherigo.ZMedia(cartGC2C5FN)
zmediaC3DETAILS130.Id = "18237917-483f-40af-be70-24a78404e73e"
zmediaC3DETAILS130.Name = _o9p("\032\062\103\044\089\071\100\116\107\036\103\049\062\101")
zmediaC3DETAILS130.Description = _o9p("\015\078\059\008\025\044\008\106\078\052\017\012")
zmediaC3DETAILS130.AltText = _o9p("\015\100\035\089\025\044\089\071\100\116\107\036")
zmediaC3DETAILS130.Resources = {
	{
		Type = "jpg", 
		Filename = "C3-DETAILS-130.jpg", 
		Directives = {}
	}
}
zmediaC3POSTERWEB = Wherigo.ZMedia(cartGC2C5FN)
zmediaC3POSTERWEB.Id = "70b6d1d6-9353-43d6-b5b1-d83ef5868cfd"
zmediaC3POSTERWEB.Name = _o9p("\032\062\103\096\105\036\071\089\076\039\089\112")
zmediaC3POSTERWEB.Description = _o9p("\015\078\059\008\025\096\099\012\106\008\108")
zmediaC3POSTERWEB.AltText = _o9p("\015\100\035\089\025\096\105\036\071\089\076")
zmediaC3POSTERWEB.Resources = {
	{
		Type = "jpg", 
		Filename = "C3-POSTERWEB.jpg", 
		Directives = {}
	}
}
zmediacGIMME1 = Wherigo.ZMedia(cartGC2C5FN)
zmediacGIMME1.Id = "28a70de2-efbf-4ab7-9c43-9a51997bd4fd"
zmediacGIMME1.Name = _o9p("\058\015\116\035\035\089\049")
zmediacGIMME1.Description = _o9p("\067\111\078\108\017\078\106\125\099\106\008\068\025\096\099\108\106\108\078\052\106")
zmediacGIMME1.AltText = _o9p("\067\097\100\076\107\100\071\117\105\071\089\096\025\096\105\076\071\076\100\116\071")
zmediacGIMME1.Resources = {
	{
		Type = "jpg", 
		Filename = "cGIMME1.jpg", 
		Directives = {}
	}
}
zmediacGIMME2 = Wherigo.ZMedia(cartGC2C5FN)
zmediacGIMME2.Id = "1c6f5924-62b5-4c6c-80a3-13ce1e051a32"
zmediacGIMME2.Name = _o9p("\058\015\116\035\035\089\034")
zmediacGIMME2.Description = _o9p("\067\111\078\108\017\078\106\125\099\106\008\068\025\096\099\108\106\108\078\052\106")
zmediacGIMME2.AltText = _o9p("\067\097\100\076\107\100\071\117\105\071\089\096\025\096\105\076\071\076\100\116\071")
zmediacGIMME2.Resources = {
	{
		Type = "jpg", 
		Filename = "cGIMME2.jpg", 
		Directives = {}
	}
}
zmediacGIMME3 = Wherigo.ZMedia(cartGC2C5FN)
zmediacGIMME3.Id = "e16750e5-bdc1-44ab-bebf-a38e8fe1109f"
zmediacGIMME3.Name = _o9p("\058\015\116\035\035\089\062")
zmediacGIMME3.Description = _o9p("\067\111\078\108\017\078\106\125\099\106\008\068\025\096\099\108\106\108\078\052\106")
zmediacGIMME3.AltText = _o9p("\067\097\100\076\107\100\071\117\105\071\089\096\025\096\105\076\071\076\100\116\071")
zmediacGIMME3.Resources = {
	{
		Type = "jpg", 
		Filename = "cGIMME3.jpg", 
		Directives = {}
	}
}
zmediacGIMME4 = Wherigo.ZMedia(cartGC2C5FN)
zmediacGIMME4.Id = "20af9d82-c5ef-45aa-940b-43d3dc90bb2a"
zmediacGIMME4.Name = _o9p("\058\015\116\035\035\089\118")
zmediacGIMME4.Description = _o9p("\067\111\078\108\017\078\106\125\099\106\008\068\025\096\099\108\106\108\078\052\106")
zmediacGIMME4.AltText = _o9p("\067\097\100\076\107\100\071\117\105\071\089\096\025\096\105\076\071\076\100\116\071")
zmediacGIMME4.Resources = {
	{
		Type = "jpg", 
		Filename = "cGIMME4.jpg", 
		Directives = {}
	}
}
zmediacHOODS1 = Wherigo.ZMedia(cartGC2C5FN)
zmediacHOODS1.Id = "30a1be6b-6e8d-472f-9e2d-9e68ea660105"
zmediacHOODS1.Name = _o9p("\058\117\105\105\044\036\049")
zmediacHOODS1.Description = _o9p("\117\099\099\023\008\023\025\047\052\040\016\108\008\012")
zmediacHOODS1.AltText = _o9p("\117\105\105\044\089\044\025\047\116\015\050\076\089\036")
zmediacHOODS1.Resources = {
	{
		Type = "jpg", 
		Filename = "cHOODS1.jpg", 
		Directives = {}
	}
}
zmediacHOODS2 = Wherigo.ZMedia(cartGC2C5FN)
zmediacHOODS2.Id = "b1eb3cd0-48f1-451d-bee5-c2a54ae90521"
zmediacHOODS2.Name = _o9p("\058\117\105\105\044\036\034")
zmediacHOODS2.Description = _o9p("\117\099\099\023\008\023\025\047\052\040\016\108\008\012")
zmediacHOODS2.AltText = _o9p("\117\105\105\044\089\044\025\047\116\015\050\076\089\036")
zmediacHOODS2.Resources = {
	{
		Type = "jpg", 
		Filename = "cHOODS2.jpg", 
		Directives = {}
	}
}
zmediacRAVENS = Wherigo.ZMedia(cartGC2C5FN)
zmediacRAVENS.Id = "7df699ce-fd91-40e4-9312-b3f72bd6c025"
zmediacRAVENS.Name = _o9p("\058\076\100\081\089\067\036")
zmediacRAVENS.Description = _o9p("\076\078\013\008\027\012")
zmediacRAVENS.AltText = _o9p("\076\100\081\089\067\036")
zmediacRAVENS.Resources = {
	{
		Type = "jpg", 
		Filename = "cRAVENS.jpg", 
		Directives = {}
	}
}
zmediacRISEN1 = Wherigo.ZMedia(cartGC2C5FN)
zmediacRISEN1.Id = "38860260-1f3e-417a-8e6d-ca7c4a3f72a7"
zmediacRISEN1.Name = _o9p("\058\076\116\036\089\067\049")
zmediacRISEN1.Description = _o9p("\032\106\125\016\017\125\016\025\076\052\012\008\027")
zmediacRISEN1.AltText = _o9p("\032\071\117\050\107\117\050\025\076\116\036\089\067")
zmediacRISEN1.Resources = {
	{
		Type = "jpg", 
		Filename = "cRISEN1.jpg", 
		Directives = {}
	}
}
zmediacRISEN2 = Wherigo.ZMedia(cartGC2C5FN)
zmediacRISEN2.Id = "6d5c448d-5c1c-4bfa-a168-de352a816eb2"
zmediacRISEN2.Name = _o9p("\058\076\116\036\089\067\034")
zmediacRISEN2.Description = _o9p("\032\106\125\016\017\125\016\025\076\052\012\008\027")
zmediacRISEN2.AltText = _o9p("\032\071\117\050\107\117\050\025\076\116\036\089\067")
zmediacRISEN2.Resources = {
	{
		Type = "jpg", 
		Filename = "cRISEN2.jpg", 
		Directives = {}
	}
}
zmediacRISEN3 = Wherigo.ZMedia(cartGC2C5FN)
zmediacRISEN3.Id = "02944806-1dac-4236-a262-07a9bac917e4"
zmediacRISEN3.Name = _o9p("\058\076\116\036\089\067\062")
zmediacRISEN3.Description = _o9p("\032\106\125\016\017\125\016\025\076\052\012\008\027")
zmediacRISEN3.AltText = _o9p("\032\071\117\050\107\117\050\025\076\116\036\089\067")
zmediacRISEN3.Resources = {
	{
		Type = "jpg", 
		Filename = "cRISEN3.jpg", 
		Directives = {}
	}
}
zmediacRISEN4 = Wherigo.ZMedia(cartGC2C5FN)
zmediacRISEN4.Id = "17c9d8f5-b32f-4a26-80cf-5c8072607fb1"
zmediacRISEN4.Name = _o9p("\058\076\116\036\089\067\118")
zmediacRISEN4.Description = _o9p("\032\106\125\016\017\125\016\025\076\052\012\008\027")
zmediacRISEN4.AltText = _o9p("\032\071\117\050\107\117\050\025\076\116\036\089\067")
zmediacRISEN4.Resources = {
	{
		Type = "jpg", 
		Filename = "cRISEN4.jpg", 
		Directives = {}
	}
}
zmediacRISEN5 = Wherigo.ZMedia(cartGC2C5FN)
zmediacRISEN5.Id = "78e62a4f-b445-419f-b06f-09718cb361ef"
zmediacRISEN5.Name = _o9p("\058\076\116\036\089\067\127")
zmediacRISEN5.Description = _o9p("\032\106\125\016\017\125\016\025\076\052\012\008\027")
zmediacRISEN5.AltText = _o9p("\032\071\117\050\107\117\050\025\076\116\036\089\067")
zmediacRISEN5.Resources = {
	{
		Type = "jpg", 
		Filename = "cRISEN5.jpg", 
		Directives = {}
	}
}
zmediacWOLVES = Wherigo.ZMedia(cartGC2C5FN)
zmediacWOLVES.Id = "63119399-bd98-403f-9e70-94b38304114f"
zmediacWOLVES.Name = _o9p("\058\039\105\107\081\089\036")
zmediacWOLVES.Description = _o9p("\039\099\017\013\008\012")
zmediacWOLVES.AltText = _o9p("\039\105\107\081\089\036\025\089\100\071\116\067\015")
zmediacWOLVES.Resources = {
	{
		Type = "jpg", 
		Filename = "cWOLVES.jpg", 
		Directives = {}
	}
}
zmediaeDONE = Wherigo.ZMedia(cartGC2C5FN)
zmediaeDONE.Id = "5a4a685d-512e-4fca-bb0c-d57dd0ba6811"
zmediaeDONE.Name = _o9p("\008\044\105\067\089")
zmediaeDONE.Description = _o9p("\032\099\027\040\108\078\106\016\017\078\106\052\099\027\012\043")
zmediaeDONE.AltText = _o9p("\032\105\067\015\076\100\071\050\107\100\071\116\105\067\036\043")
zmediaeDONE.Resources = {
	{
		Type = "jpg", 
		Filename = "eDONE.jpg", 
		Directives = {}
	}
}
zmediaeMOON = Wherigo.ZMedia(cartGC2C5FN)
zmediaeMOON.Id = "275ce5e6-0393-4381-bc27-bea71bd6e84a"
zmediaeMOON.Name = _o9p("\008\035\105\105\067")
zmediaeMOON.Description = _o9p("\089\058\017\052\068\012\008")
zmediaeMOON.AltText = _o9p("\089\032\107\116\096\036\089")
zmediaeMOON.Resources = {
	{
		Type = "jpg", 
		Filename = "eMOON.jpg", 
		Directives = {}
	}
}
zmediaePYRE1 = Wherigo.ZMedia(cartGC2C5FN)
zmediaePYRE1.Id = "9d572900-a008-43fa-bc44-a347dbc1a359"
zmediaePYRE1.Name = _o9p("\008\096\097\076\089\049")
zmediaePYRE1.Description = _o9p("\032\008\108\008\059\099\027\111\025\008\027\012\016\008\012")
zmediaePYRE1.AltText = _o9p("\032\089\076\089\035\105\067\097\025\089\067\036\050\089\036")
zmediaePYRE1.Resources = {
	{
		Type = "jpg", 
		Filename = "ePYRE1.jpg", 
		Directives = {}
	}
}
zmediaeSHINE = Wherigo.ZMedia(cartGC2C5FN)
zmediaeSHINE.Id = "d4473048-13de-4adf-9ae5-17c2eed11c2a"
zmediaeSHINE.Name = _o9p("\008\036\117\116\067\089")
zmediaeSHINE.Description = _o9p("\036\125\052\027\052\027\040\025\047\017\078\012\125\017\052\040\125\106")
zmediaeSHINE.AltText = _o9p("\036\117\116\067\116\067\015\025\047\107\100\036\117\107\116\015\117\071")
zmediaeSHINE.Resources = {
	{
		Type = "jpg", 
		Filename = "eSHINE.jpg", 
		Directives = {}
	}
}
zmediaeSTORM = Wherigo.ZMedia(cartGC2C5FN)
zmediaeSTORM.Id = "3697fb92-99fb-47eb-9e15-37ccceae67de"
zmediaeSTORM.Name = _o9p("\008\036\071\105\076\035")
zmediaeSTORM.Description = _o9p("\036\106\099\108\059\025\112\108\008\030\052\027\040")
zmediaeSTORM.AltText = _o9p("\036\071\105\076\035\025\112\076\089\039\116\067\015")
zmediaeSTORM.Resources = {
	{
		Type = "jpg", 
		Filename = "eSTORM.jpg", 
		Directives = {}
	}
}
zmediaicBIRD = Wherigo.ZMedia(cartGC2C5FN)
zmediaicBIRD.Id = "c66cbc64-7a73-4ab7-8fb6-3e8727d1ee8a"
zmediaicBIRD.Name = _o9p("\052\058\112\116\076\044")
zmediaicBIRD.Description = _o9p("\116\058\099\027\077\112\052\108\023")
zmediaicBIRD.AltText = _o9p("\116\032\105\067\077\112\116\076\044")
zmediaicBIRD.Resources = {
	{
		Type = "jpg", 
		Filename = "icBIRD.jpg", 
		Directives = {}
	}
}
zmediaicBOAT = Wherigo.ZMedia(cartGC2C5FN)
zmediaicBOAT.Id = "b3e3a8c7-4b39-454b-b617-3c2f41ecba09"
zmediaicBOAT.Name = _o9p("\052\058\112\105\100\071")
zmediaicBOAT.Description = _o9p("\116\058\099\027\077\112\099\078\106")
zmediaicBOAT.AltText = _o9p("\116\032\105\067\077\112\105\100\071")
zmediaicBOAT.Resources = {
	{
		Type = "jpg", 
		Filename = "icBOAT.jpg", 
		Directives = {}
	}
}
zmediaicC3 = Wherigo.ZMedia(cartGC2C5FN)
zmediaicC3.Id = "4f1bed91-fb49-480f-aa36-1a256c8318b0"
zmediaicC3.Name = _o9p("\052\058\032\062")
zmediaicC3.Description = _o9p("\116\058\099\027\077\015\078\059\008")
zmediaicC3.AltText = _o9p("\116\032\105\067\077\015\100\035\089")
zmediaicC3.Resources = {
	{
		Type = "jpg", 
		Filename = "icC3.jpg", 
		Directives = {}
	}
}
zmediaicCACHE = Wherigo.ZMedia(cartGC2C5FN)
zmediaicCACHE.Id = "f296e70b-8e9c-4ad3-9ede-21f9bfe52efc"
zmediaicCACHE.Name = _o9p("\052\058\032\100\032\117\089")
zmediaicCACHE.Description = _o9p("\116\058\099\027\077\032\078\058\125\008")
zmediaicCACHE.AltText = _o9p("\116\032\105\067\077\032\100\032\117\089")
zmediaicCACHE.Resources = {
	{
		Type = "jpg", 
		Filename = "icCACHE.jpg", 
		Directives = {}
	}
}
zmediaicCAM = Wherigo.ZMedia(cartGC2C5FN)
zmediaicCAM.Id = "853cc2f9-a4de-4862-9422-061604527142"
zmediaicCAM.Name = _o9p("\052\058\032\100\035")
zmediaicCAM.Description = _o9p("\116\058\099\027\077\032\078\059\008\108\078")
zmediaicCAM.AltText = _o9p("\116\032\105\067\077\032\100\035\089\076\100")
zmediaicCAM.Resources = {
	{
		Type = "jpg", 
		Filename = "icCAM.jpg", 
		Directives = {}
	}
}
zmediaicCAR = Wherigo.ZMedia(cartGC2C5FN)
zmediaicCAR.Id = "d4c76e45-a14a-4d86-89b0-a65592a4ecbc"
zmediaicCAR.Name = _o9p("\052\058\032\100\076")
zmediaicCAR.Description = _o9p("\116\058\099\027\077\032\078\108")
zmediaicCAR.AltText = _o9p("\116\032\105\067\077\032\100\076")
zmediaicCAR.Resources = {
	{
		Type = "jpg", 
		Filename = "icCAR.jpg", 
		Directives = {}
	}
}
zmediaicCELL = Wherigo.ZMedia(cartGC2C5FN)
zmediaicCELL.Id = "4012d876-b5b6-44a5-a342-6537c7efe9e3"
zmediaicCELL.Name = _o9p("\052\058\032\089\107\107")
zmediaicCELL.Description = _o9p("\116\058\099\027\077\032\008\017\017")
zmediaicCELL.AltText = _o9p("\116\032\105\067\077\032\089\107\107")
zmediaicCELL.Resources = {
	{
		Type = "jpg", 
		Filename = "icCELL.jpg", 
		Directives = {}
	}
}
zmediaicCHECK = Wherigo.ZMedia(cartGC2C5FN)
zmediaicCHECK.Id = "fe885264-846c-4a39-819d-2aad91ca2de7"
zmediaicCHECK.Name = _o9p("\052\058\032\117\089\032\037")
zmediaicCHECK.Description = _o9p("\116\058\099\027\077\032\125\008\058\024\059\078\108\024")
zmediaicCHECK.AltText = _o9p("\116\032\105\067\077\032\117\089\032\037\035\100\076\037")
zmediaicCHECK.Resources = {
	{
		Type = "jpg", 
		Filename = "icCHECK.jpg", 
		Directives = {}
	}
}
zmediaicDANGER = Wherigo.ZMedia(cartGC2C5FN)
zmediaicDANGER.Id = "11048dad-eb01-45d9-98c4-371af77e5a78"
zmediaicDANGER.Name = _o9p("\052\058\044\100\067\015\089\076")
zmediaicDANGER.Description = _o9p("\116\058\099\027\077\044\078\027\040\008\108")
zmediaicDANGER.AltText = _o9p("\116\032\105\067\077\044\100\067\015\089\076")
zmediaicDANGER.Resources = {
	{
		Type = "jpg", 
		Filename = "icDANGER.jpg", 
		Directives = {}
	}
}
zmediaicDRUMS = Wherigo.ZMedia(cartGC2C5FN)
zmediaicDRUMS.Id = "87017a3d-544b-4967-8322-240a1d413ac1"
zmediaicDRUMS.Name = _o9p("\052\058\044\076\050\035\036")
zmediaicDRUMS.Description = _o9p("\116\058\099\027\077\044\108\016\059\012")
zmediaicDRUMS.AltText = _o9p("\116\032\105\067\077\044\076\050\035\036")
zmediaicDRUMS.Resources = {
	{
		Type = "jpg", 
		Filename = "icDRUMS.jpg", 
		Directives = {}
	}
}
zmediaicFACEHAPPY = Wherigo.ZMedia(cartGC2C5FN)
zmediaicFACEHAPPY.Id = "130a55b9-4544-40c0-83ff-bdc9ff154cab"
zmediaicFACEHAPPY.Name = _o9p("\052\058\047\100\032\089\117\100\096\096\097")
zmediaicFACEHAPPY.Description = _o9p("\116\058\099\027\077\025\117\078\068\068\111\025\047\078\058\008")
zmediaicFACEHAPPY.AltText = _o9p("\116\032\105\067\077\117\100\096\096\097\025\047\100\032\089")
zmediaicFACEHAPPY.Resources = {
	{
		Type = "jpg", 
		Filename = "icFACEHAPPY.jpg", 
		Directives = {}
	}
}
zmediaicFACESAD = Wherigo.ZMedia(cartGC2C5FN)
zmediaicFACESAD.Id = "d5c11ae2-fbb4-47d5-82fc-f175bbfb4a53"
zmediaicFACESAD.Name = _o9p("\052\058\047\100\032\089\036\100\044")
zmediaicFACESAD.Description = _o9p("\116\058\099\027\077\025\036\078\023\025\047\078\058\008")
zmediaicFACESAD.AltText = _o9p("\116\032\105\067\077\036\100\044\025\047\100\032\089")
zmediaicFACESAD.Resources = {
	{
		Type = "jpg", 
		Filename = "icFACESAD.jpg", 
		Directives = {}
	}
}
zmediaicFISH = Wherigo.ZMedia(cartGC2C5FN)
zmediaicFISH.Id = "3f14a7ec-8e7a-4ae5-8da7-6ddfa9b6f470"
zmediaicFISH.Name = _o9p("\052\058\047\116\036\117")
zmediaicFISH.Description = _o9p("\116\058\099\027\077\025\047\052\012\125")
zmediaicFISH.AltText = _o9p("\116\032\105\067\077\047\116\036\117")
zmediaicFISH.Resources = {
	{
		Type = "jpg", 
		Filename = "icFISH.jpg", 
		Directives = {}
	}
}
zmediaicFLASHLIGHT = Wherigo.ZMedia(cartGC2C5FN)
zmediaicFLASHLIGHT.Id = "915524ab-1b57-469b-8d4c-ff421d37a1d1"
zmediaicFLASHLIGHT.Name = _o9p("\052\058\047\107\100\036\117\107\116\015\117\071")
zmediaicFLASHLIGHT.Description = _o9p("\116\058\099\027\077\047\017\078\012\125\017\052\040\125\106")
zmediaicFLASHLIGHT.AltText = _o9p("\116\032\105\067\077\047\107\100\036\117\107\116\015\117\071")
zmediaicFLASHLIGHT.Resources = {
	{
		Type = "jpg", 
		Filename = "icFLASHLIGHT.jpg", 
		Directives = {}
	}
}
zmediaicGRASS = Wherigo.ZMedia(cartGC2C5FN)
zmediaicGRASS.Id = "62bfce89-b992-4a3c-8c70-ef812224f02a"
zmediaicGRASS.Name = _o9p("\052\058\015\076\100\036\036")
zmediaicGRASS.Description = _o9p("\116\058\099\027\077\015\108\078\012\012")
zmediaicGRASS.AltText = _o9p("\116\032\105\067\077\015\076\100\036\036")
zmediaicGRASS.Resources = {
	{
		Type = "jpg", 
		Filename = "icGRASS.jpg", 
		Directives = {}
	}
}
zmediaicHIKE = Wherigo.ZMedia(cartGC2C5FN)
zmediaicHIKE.Id = "313e974d-32b4-4b6d-818d-40cb8a8e9251"
zmediaicHIKE.Name = _o9p("\052\058\117\116\037\089")
zmediaicHIKE.Description = _o9p("\116\058\099\027\077\117\052\024\008")
zmediaicHIKE.AltText = _o9p("\116\032\105\067\077\117\116\037\089")
zmediaicHIKE.Resources = {
	{
		Type = "jpg", 
		Filename = "icHIKE.jpg", 
		Directives = {}
	}
}
zmediaicIDEA = Wherigo.ZMedia(cartGC2C5FN)
zmediaicIDEA.Id = "58f8a4ac-fb59-428b-8012-a5f012f3b44e"
zmediaicIDEA.Name = _o9p("\052\058\116\044\089\100")
zmediaicIDEA.Description = _o9p("\116\058\099\027\077\116\023\008\078")
zmediaicIDEA.AltText = _o9p("\116\032\105\067\077\116\044\089\100")
zmediaicIDEA.Resources = {
	{
		Type = "jpg", 
		Filename = "icIDEA.jpg", 
		Directives = {}
	}
}
zmediaicINFO = Wherigo.ZMedia(cartGC2C5FN)
zmediaicINFO.Id = "cf62072a-0e33-4498-b7df-226291491a48"
zmediaicINFO.Name = _o9p("\052\058\116\067\047\105")
zmediaicINFO.Description = _o9p("\116\058\099\027\077\116\027\033\099")
zmediaicINFO.AltText = _o9p("\116\032\105\067\077\116\067\047\105")
zmediaicINFO.Resources = {
	{
		Type = "jpg", 
		Filename = "icINFO.jpg", 
		Directives = {}
	}
}
zmediaicKEY = Wherigo.ZMedia(cartGC2C5FN)
zmediaicKEY.Id = "4def561e-209b-4ae6-a290-0046e86ecd11"
zmediaicKEY.Name = _o9p("\052\058\037\089\097")
zmediaicKEY.Description = _o9p("\116\058\099\027\077\037\008\111")
zmediaicKEY.AltText = _o9p("\116\032\105\067\077\037\089\097")
zmediaicKEY.Resources = {
	{
		Type = "jpg", 
		Filename = "icKEY.jpg", 
		Directives = {}
	}
}
zmediaicMONSTER = Wherigo.ZMedia(cartGC2C5FN)
zmediaicMONSTER.Id = "14510561-eb85-401c-8955-f45f4638ab90"
zmediaicMONSTER.Name = _o9p("\052\058\035\105\067\036\071\089\076")
zmediaicMONSTER.Description = _o9p("\116\058\099\027\077\035\099\027\012\106\008\108")
zmediaicMONSTER.AltText = _o9p("\116\032\105\067\077\035\105\067\036\071\089\076")
zmediaicMONSTER.Resources = {
	{
		Type = "jpg", 
		Filename = "icMONSTER.jpg", 
		Directives = {}
	}
}
zmediaicNOTE = Wherigo.ZMedia(cartGC2C5FN)
zmediaicNOTE.Id = "576183f3-7ba0-46df-a2c1-2c3af7dcb70a"
zmediaicNOTE.Name = _o9p("\052\058\067\105\071\089")
zmediaicNOTE.Description = _o9p("\116\058\099\027\077\067\099\106\008")
zmediaicNOTE.AltText = _o9p("\116\032\105\067\077\067\105\071\089")
zmediaicNOTE.Resources = {
	{
		Type = "jpg", 
		Filename = "icNOTE.jpg", 
		Directives = {}
	}
}
zmediaicNOWALK = Wherigo.ZMedia(cartGC2C5FN)
zmediaicNOWALK.Id = "17c6fbab-1b44-45a1-8567-4c9debab5486"
zmediaicNOWALK.Name = _o9p("\052\058\067\105\039\100\107\037")
zmediaicNOWALK.Description = _o9p("\116\058\099\027\077\067\099\025\039\078\017\024")
zmediaicNOWALK.AltText = _o9p("\116\032\105\067\077\067\105\025\039\100\107\037")
zmediaicNOWALK.Resources = {
	{
		Type = "jpg", 
		Filename = "icNOWALK.jpg", 
		Directives = {}
	}
}
zmediaicPAW = Wherigo.ZMedia(cartGC2C5FN)
zmediaicPAW.Id = "79e25aed-aea7-4172-8f31-e0e135625887"
zmediaicPAW.Name = _o9p("\052\058\096\100\039")
zmediaicPAW.Description = _o9p("\116\058\099\027\077\096\078\030\025\096\108\052\027\106")
zmediaicPAW.AltText = _o9p("\116\032\105\067\077\096\100\039\025\096\076\116\067\071")
zmediaicPAW.Resources = {
	{
		Type = "jpg", 
		Filename = "icPAW.jpg", 
		Directives = {}
	}
}
zmediaicPUZZLE = Wherigo.ZMedia(cartGC2C5FN)
zmediaicPUZZLE.Id = "0d03f520-94d7-4da6-acea-6f21588144ef"
zmediaicPUZZLE.Name = _o9p("\052\058\096\050\060\060\107\089")
zmediaicPUZZLE.Description = _o9p("\116\058\099\027\077\096\016\065\065\017\008")
zmediaicPUZZLE.AltText = _o9p("\116\032\105\067\077\096\050\060\060\107\089")
zmediaicPUZZLE.Resources = {
	{
		Type = "jpg", 
		Filename = "icPUZZLE.jpg", 
		Directives = {}
	}
}
zmediaicQUESTION = Wherigo.ZMedia(cartGC2C5FN)
zmediaicQUESTION.Id = "de8ca885-95f7-4390-bb1e-ddaf9e68170f"
zmediaicQUESTION.Name = _o9p("\052\058\048\050\089\036\071\116\105\067")
zmediaicQUESTION.Description = _o9p("\116\058\099\027\077\048\016\008\012\106\052\099\027")
zmediaicQUESTION.AltText = _o9p("\116\032\105\067\077\048\050\089\036\071\116\105\067")
zmediaicQUESTION.Resources = {
	{
		Type = "jpg", 
		Filename = "icQUESTION.jpg", 
		Directives = {}
	}
}
zmediaicRUN = Wherigo.ZMedia(cartGC2C5FN)
zmediaicRUN.Id = "28d2b5f4-5925-426f-a48a-6c596e499ac3"
zmediaicRUN.Name = _o9p("\052\058\076\050\067")
zmediaicRUN.Description = _o9p("\116\058\099\027\077\076\016\027")
zmediaicRUN.AltText = _o9p("\116\032\105\067\077\076\050\067")
zmediaicRUN.Resources = {
	{
		Type = "jpg", 
		Filename = "icRUN.jpg", 
		Directives = {}
	}
}
zmediaicSAVE = Wherigo.ZMedia(cartGC2C5FN)
zmediaicSAVE.Id = "61a9f34d-4571-4e4d-8255-75a1bc951b15"
zmediaicSAVE.Name = _o9p("\052\058\036\100\081\089")
zmediaicSAVE.Description = _o9p("\116\058\099\027\077\036\078\013\008")
zmediaicSAVE.AltText = _o9p("\116\032\105\067\077\036\100\081\089")
zmediaicSAVE.Resources = {
	{
		Type = "jpg", 
		Filename = "icSAVE.jpg", 
		Directives = {}
	}
}
zmediaicSCROLL = Wherigo.ZMedia(cartGC2C5FN)
zmediaicSCROLL.Id = "a63e2bff-4571-41a7-90ac-c090a8e9cd55"
zmediaicSCROLL.Name = _o9p("\052\058\036\032\076\105\107\107")
zmediaicSCROLL.Description = _o9p("\116\058\099\027\077\036\058\108\099\017\017")
zmediaicSCROLL.AltText = _o9p("\116\032\105\067\077\036\032\076\105\107\107")
zmediaicSCROLL.Resources = {
	{
		Type = "jpg", 
		Filename = "icSCROLL.jpg", 
		Directives = {}
	}
}
zmediaicSEE = Wherigo.ZMedia(cartGC2C5FN)
zmediaicSEE.Id = "3c23cbad-9a8c-4849-a752-d8d101d0462d"
zmediaicSEE.Name = _o9p("\052\058\036\089\089")
zmediaicSEE.Description = _o9p("\116\058\099\027\077\116\025\036\008\008")
zmediaicSEE.AltText = _o9p("\116\032\105\067\077\116\025\036\089\089")
zmediaicSEE.Resources = {
	{
		Type = "jpg", 
		Filename = "icSEE.jpg", 
		Directives = {}
	}
}
zmediaicSKULL = Wherigo.ZMedia(cartGC2C5FN)
zmediaicSKULL.Id = "03eb6d15-bbd6-4184-96ee-c2ffcd5e4458"
zmediaicSKULL.Name = _o9p("\052\058\036\037\050\107\107")
zmediaicSKULL.Description = _o9p("\116\058\099\027\077\036\024\016\017\017")
zmediaicSKULL.AltText = _o9p("\116\032\105\067\077\036\037\050\107\107")
zmediaicSKULL.Resources = {
	{
		Type = "jpg", 
		Filename = "icSKULL.jpg", 
		Directives = {}
	}
}
zmediaicSTATUE = Wherigo.ZMedia(cartGC2C5FN)
zmediaicSTATUE.Id = "34842252-3f9e-4865-a14d-c22d7bec3a7b"
zmediaicSTATUE.Name = _o9p("\052\058\036\071\100\071\050\089")
zmediaicSTATUE.Description = _o9p("\116\058\099\027\077\036\106\078\106\016\008")
zmediaicSTATUE.AltText = _o9p("\116\032\105\067\077\036\071\100\071\050\089")
zmediaicSTATUE.Resources = {
	{
		Type = "jpg", 
		Filename = "icSTATUE.jpg", 
		Directives = {}
	}
}
zmediaicSTOP = Wherigo.ZMedia(cartGC2C5FN)
zmediaicSTOP.Id = "928f277e-857f-4f4f-9a0d-e3db9b07435a"
zmediaicSTOP.Name = _o9p("\052\058\036\071\105\096")
zmediaicSTOP.Description = _o9p("\116\058\099\027\077\036\106\099\068")
zmediaicSTOP.AltText = _o9p("\116\032\105\067\077\036\071\105\096")
zmediaicSTOP.Resources = {
	{
		Type = "jpg", 
		Filename = "icSTOP.jpg", 
		Directives = {}
	}
}
zmediaicTHUMBD = Wherigo.ZMedia(cartGC2C5FN)
zmediaicTHUMBD.Id = "d19cbf91-e24d-49f3-b40e-4ad72872bbdc"
zmediaicTHUMBD.Name = _o9p("\052\058\071\117\050\035\112\044")
zmediaicTHUMBD.Description = _o9p("\116\058\099\027\077\071\125\016\059\085\012\025\044\099\030\027")
zmediaicTHUMBD.AltText = _o9p("\116\032\105\067\077\071\117\050\035\112\036\025\044\105\039\067")
zmediaicTHUMBD.Resources = {
	{
		Type = "jpg", 
		Filename = "icTHUMBD.jpg", 
		Directives = {}
	}
}
zmediaicTHUMBU = Wherigo.ZMedia(cartGC2C5FN)
zmediaicTHUMBU.Id = "8281db6c-1043-403e-a4d3-d306e9e44dd5"
zmediaicTHUMBU.Name = _o9p("\052\058\071\117\050\035\112\050")
zmediaicTHUMBU.Description = _o9p("\116\058\099\027\077\071\125\016\059\085\012\025\050\068")
zmediaicTHUMBU.AltText = _o9p("\116\032\105\067\077\071\117\050\035\112\036\025\050\096")
zmediaicTHUMBU.Resources = {
	{
		Type = "jpg", 
		Filename = "icTHUMBU.jpg", 
		Directives = {}
	}
}
zmediaicTIME = Wherigo.ZMedia(cartGC2C5FN)
zmediaicTIME.Id = "a3f2f478-06d4-4787-ba36-f995e3f947ad"
zmediaicTIME.Name = _o9p("\052\058\071\116\035\089")
zmediaicTIME.Description = _o9p("\116\058\099\027\077\071\052\059\008")
zmediaicTIME.AltText = _o9p("\116\032\105\067\077\071\116\035\089")
zmediaicTIME.Resources = {
	{
		Type = "jpg", 
		Filename = "icTIME.jpg", 
		Directives = {}
	}
}
zmediaicVIEW = Wherigo.ZMedia(cartGC2C5FN)
zmediaicVIEW.Id = "9bbda3de-db04-47bf-8b1e-6ad24331d71b"
zmediaicVIEW.Name = _o9p("\052\058\081\116\089\039")
zmediaicVIEW.Description = _o9p("\116\058\099\027\077\081\052\008\030")
zmediaicVIEW.AltText = _o9p("\116\032\105\067\077\081\116\089\039")
zmediaicVIEW.Resources = {
	{
		Type = "jpg", 
		Filename = "icVIEW.jpg", 
		Directives = {}
	}
}
zmediaicWALK = Wherigo.ZMedia(cartGC2C5FN)
zmediaicWALK.Id = "5c21619b-f426-4240-bb17-0f99e567f355"
zmediaicWALK.Name = _o9p("\052\058\039\100\107\037")
zmediaicWALK.Description = _o9p("\116\058\099\027\077\039\078\017\024")
zmediaicWALK.AltText = _o9p("\116\032\105\067\077\039\100\107\037")
zmediaicWALK.Resources = {
	{
		Type = "jpg", 
		Filename = "icWALK.jpg", 
		Directives = {}
	}
}
zmediaicWOLF = Wherigo.ZMedia(cartGC2C5FN)
zmediaicWOLF.Id = "912f115b-1e7b-455d-a0f0-7aeea8753f5e"
zmediaicWOLF.Name = _o9p("\052\058\039\105\107\047")
zmediaicWOLF.Description = _o9p("\116\058\099\027\077\039\099\017\033")
zmediaicWOLF.AltText = _o9p("\116\032\105\067\077\039\105\107\047")
zmediaicWOLF.Resources = {
	{
		Type = "jpg", 
		Filename = "icWOLF.jpg", 
		Directives = {}
	}
}
zmediaicYINYANG = Wherigo.ZMedia(cartGC2C5FN)
zmediaicYINYANG.Id = "7a226ab4-4ae2-48b4-9724-557e52c324b1"
zmediaicYINYANG.Name = _o9p("\052\058\097\116\067\097\100\067\015")
zmediaicYINYANG.Description = _o9p("\116\058\099\027\077\097\052\027\097\078\027\040")
zmediaicYINYANG.AltText = _o9p("\116\032\105\067\077\097\116\067\097\100\067\015")
zmediaicYINYANG.Resources = {
	{
		Type = "jpg", 
		Filename = "icYINYANG.jpg", 
		Directives = {}
	}
}
zmediaitBROKENCAR1 = Wherigo.ZMedia(cartGC2C5FN)
zmediaitBROKENCAR1.Id = "148b5c48-da5b-49fa-ae93-3a522b6d90a8"
zmediaitBROKENCAR1.Name = _o9p("\052\106\112\076\105\037\089\067\032\100\076\049")
zmediaitBROKENCAR1.Description = _o9p("\112\108\099\024\008\027\025\032\078\108")
zmediaitBROKENCAR1.AltText = _o9p("\112\076\105\037\089\067\025\032\100\076")
zmediaitBROKENCAR1.Resources = {
	{
		Type = "jpg", 
		Filename = "itBROKENCAR1.jpg", 
		Directives = {}
	}
}
zmediaitBROKENCAR2 = Wherigo.ZMedia(cartGC2C5FN)
zmediaitBROKENCAR2.Id = "68af61c0-b8c7-4904-a003-b5703357cf76"
zmediaitBROKENCAR2.Name = _o9p("\052\106\112\076\105\037\089\067\032\100\076\034")
zmediaitBROKENCAR2.Description = _o9p("\112\108\099\024\008\027\025\032\078\108")
zmediaitBROKENCAR2.AltText = _o9p("\112\076\105\037\089\067\025\032\100\076")
zmediaitBROKENCAR2.Resources = {
	{
		Type = "jpg", 
		Filename = "itBROKENCAR2.jpg", 
		Directives = {}
	}
}
zmediaitBROKENCAR3 = Wherigo.ZMedia(cartGC2C5FN)
zmediaitBROKENCAR3.Id = "86491867-cc42-478b-9794-fe7bb41d8dc4"
zmediaitBROKENCAR3.Name = _o9p("\052\106\112\076\105\037\089\067\032\100\076\062")
zmediaitBROKENCAR3.Description = _o9p("\112\108\099\024\008\027\025\032\078\108")
zmediaitBROKENCAR3.AltText = _o9p("\112\076\105\037\089\067\025\032\100\076")
zmediaitBROKENCAR3.Resources = {
	{
		Type = "jpg", 
		Filename = "itBROKENCAR3.jpg", 
		Directives = {}
	}
}
zmediaitCELL0 = Wherigo.ZMedia(cartGC2C5FN)
zmediaitCELL0.Id = "b5722001-bf10-41ce-946c-e17e0cc9f41b"
zmediaitCELL0.Name = _o9p("\052\106\032\089\107\107\101")
zmediaitCELL0.Description = _o9p("\032\008\017\017\025\116\027\078\058\106\052\013\008\025")
zmediaitCELL0.AltText = _o9p("\032\089\107\107\025\116\067\100\032\071\116\081\089")
zmediaitCELL0.Resources = {
	{
		Type = "jpg", 
		Filename = "itCELL0.jpg", 
		Directives = {}
	}
}
zmediaitCELL1 = Wherigo.ZMedia(cartGC2C5FN)
zmediaitCELL1.Id = "ae7f8744-b290-424a-94f5-ae8bf873c4d4"
zmediaitCELL1.Name = _o9p("\052\106\032\089\107\107\049")
zmediaitCELL1.Description = _o9p("\032\008\017\017\025\100\058\106\052\013\008")
zmediaitCELL1.AltText = _o9p("\032\089\107\107\025\100\032\071\116\081\089")
zmediaitCELL1.Resources = {
	{
		Type = "jpg", 
		Filename = "itCELL1.jpg", 
		Directives = {}
	}
}
zmediaitDRUMS0 = Wherigo.ZMedia(cartGC2C5FN)
zmediaitDRUMS0.Id = "45a0435e-e840-4c57-ae7d-253d9f6ef586"
zmediaitDRUMS0.Name = _o9p("\052\106\044\076\050\035\036\101")
zmediaitDRUMS0.Description = _o9p("\044\108\016\059\012\025\116\027\078\058\106\052\013\008")
zmediaitDRUMS0.AltText = _o9p("\044\076\050\035\036\025\116\067\100\032\071\116\081\089")
zmediaitDRUMS0.Resources = {
	{
		Type = "jpg", 
		Filename = "itDRUMS0.jpg", 
		Directives = {}
	}
}
zmediaitDRUMS1 = Wherigo.ZMedia(cartGC2C5FN)
zmediaitDRUMS1.Id = "a66e5290-1635-421f-928e-4434a0fc1bea"
zmediaitDRUMS1.Name = _o9p("\052\106\044\076\050\035\036\049")
zmediaitDRUMS1.Description = _o9p("\044\108\016\059\012\025\100\058\106\052\013\008")
zmediaitDRUMS1.AltText = _o9p("\044\076\050\035\036\025\100\032\071\116\081\089")
zmediaitDRUMS1.Resources = {
	{
		Type = "jpg", 
		Filename = "itDRUMS1.jpg", 
		Directives = {}
	}
}
zmediaitFEATHER = Wherigo.ZMedia(cartGC2C5FN)
zmediaitFEATHER.Id = "646b986b-ce3f-429e-8a1a-bef23535e2d0"
zmediaitFEATHER.Name = _o9p("\052\106\047\089\100\071\117\089\076")
zmediaitFEATHER.Description = _o9p("\047\008\078\106\125\008\108")
zmediaitFEATHER.AltText = _o9p("\047\008\078\106\125\008\108")
zmediaitFEATHER.Resources = {
	{
		Type = "jpg", 
		Filename = "itFEATHER.jpg", 
		Directives = {}
	}
}
zmediaitFLASHLIGHT0 = Wherigo.ZMedia(cartGC2C5FN)
zmediaitFLASHLIGHT0.Id = "c80e83d3-6450-4bf7-976d-fac6c629cbb5"
zmediaitFLASHLIGHT0.Name = _o9p("\052\106\047\107\100\036\117\107\116\015\117\071\101")
zmediaitFLASHLIGHT0.Description = _o9p("\047\017\078\012\125\017\052\040\125\106\025\116\027\078\058\106\052\013\008")
zmediaitFLASHLIGHT0.AltText = _o9p("\047\107\100\036\117\107\116\015\117\071\025\116\067\100\032\071\116\081\089")
zmediaitFLASHLIGHT0.Resources = {
	{
		Type = "jpg", 
		Filename = "itFLASHLIGHT0.jpg", 
		Directives = {}
	}
}
zmediaitFLASHLIGHT1 = Wherigo.ZMedia(cartGC2C5FN)
zmediaitFLASHLIGHT1.Id = "de4d166d-c0ec-4e06-84e0-e772b3a0187f"
zmediaitFLASHLIGHT1.Name = _o9p("\052\106\047\107\100\036\117\107\116\015\117\071\049")
zmediaitFLASHLIGHT1.Description = _o9p("\047\017\078\012\125\017\052\040\125\106\025\100\058\106\052\013\008")
zmediaitFLASHLIGHT1.AltText = _o9p("\047\107\100\036\117\107\116\015\117\071\025\100\032\071\116\081\089")
zmediaitFLASHLIGHT1.Resources = {
	{
		Type = "jpg", 
		Filename = "itFLASHLIGHT1.jpg", 
		Directives = {}
	}
}
zmediaitGPS0 = Wherigo.ZMedia(cartGC2C5FN)
zmediaitGPS0.Id = "f5d9b9e2-d0bc-4b1e-a823-19c7394584cf"
zmediaitGPS0.Name = _o9p("\052\106\015\096\036\101")
zmediaitGPS0.Description = _o9p("\015\096\036\025\116\027\078\058\106\052\013\008")
zmediaitGPS0.AltText = _o9p("\015\096\036\025\116\067\100\032\071\116\081\089")
zmediaitGPS0.Resources = {
	{
		Type = "jpg", 
		Filename = "itGPS0.jpg", 
		Directives = {}
	}
}
zmediaitGPS1 = Wherigo.ZMedia(cartGC2C5FN)
zmediaitGPS1.Id = "d4166fd1-d0dc-4392-b32d-ddbd7a9a54ba"
zmediaitGPS1.Name = _o9p("\052\106\015\096\036\049")
zmediaitGPS1.Description = _o9p("\015\096\036\025\100\058\106\052\013\008")
zmediaitGPS1.AltText = _o9p("\015\096\036\025\100\032\071\116\081\089")
zmediaitGPS1.Resources = {
	{
		Type = "jpg", 
		Filename = "itGPS1.jpg", 
		Directives = {}
	}
}
zmediaitMPILL = Wherigo.ZMedia(cartGC2C5FN)
zmediaitMPILL.Id = "05a9f78d-e186-4ef7-8628-3e16fe6a43d5"
zmediaitMPILL.Name = _o9p("\052\106\035\096\116\107\107")
zmediaitMPILL.Description = _o9p("\035\008\106\078\017\025\096\052\017\017\078\108")
zmediaitMPILL.AltText = _o9p("\035\089\071\100\107\025\096\116\107\107\100\076")
zmediaitMPILL.Resources = {
	{
		Type = "jpg", 
		Filename = "itMPILL.jpg", 
		Directives = {}
	}
}
zmediaitNOTEPAD0 = Wherigo.ZMedia(cartGC2C5FN)
zmediaitNOTEPAD0.Id = "1a34ae6f-0453-471f-8079-3cb38d4d0362"
zmediaitNOTEPAD0.Name = _o9p("\052\106\067\105\071\089\096\100\044\101")
zmediaitNOTEPAD0.Description = _o9p("\067\099\106\008\068\078\023\025\116\027\078\058\106\052\013\008")
zmediaitNOTEPAD0.AltText = _o9p("\067\105\071\089\096\100\044\025\116\067\100\032\071\116\081\089")
zmediaitNOTEPAD0.Resources = {
	{
		Type = "jpg", 
		Filename = "itNOTEPAD0.jpg", 
		Directives = {}
	}
}
zmediaitNOTEPAD1 = Wherigo.ZMedia(cartGC2C5FN)
zmediaitNOTEPAD1.Id = "bfa24d31-4981-489e-b1a3-ae16b546b528"
zmediaitNOTEPAD1.Name = _o9p("\052\106\067\105\071\089\096\100\044\049")
zmediaitNOTEPAD1.Description = _o9p("\067\099\106\008\068\078\023\025\100\058\106\052\013\008")
zmediaitNOTEPAD1.AltText = _o9p("\067\105\071\089\096\100\044\025\100\032\071\116\081\089")
zmediaitNOTEPAD1.Resources = {
	{
		Type = "jpg", 
		Filename = "itNOTEPAD1.jpg", 
		Directives = {}
	}
}
zmediaitPAWPRINTS = Wherigo.ZMedia(cartGC2C5FN)
zmediaitPAWPRINTS.Id = "7bf881b5-b864-49eb-afe8-2566f14aef85"
zmediaitPAWPRINTS.Name = _o9p("\052\106\096\100\039\096\076\116\067\071\036")
zmediaitPAWPRINTS.Description = _o9p("\096\078\030\025\096\108\052\027\106\012")
zmediaitPAWPRINTS.AltText = _o9p("\096\100\039\025\096\076\116\067\071\036")
zmediaitPAWPRINTS.Resources = {
	{
		Type = "jpg", 
		Filename = "itPAWPRINTS.jpg", 
		Directives = {}
	}
}
zmediaitSTATUE = Wherigo.ZMedia(cartGC2C5FN)
zmediaitSTATUE.Id = "6817bba3-0a18-44b5-bf3a-9518cd8c48d2"
zmediaitSTATUE.Name = _o9p("\052\106\036\071\100\071\050\089")
zmediaitSTATUE.Description = _o9p("\036\106\108\078\027\040\008\025\036\106\078\106\016\008")
zmediaitSTATUE.AltText = _o9p("\036\071\076\100\067\015\089\025\036\071\100\071\050\089")
zmediaitSTATUE.Resources = {
	{
		Type = "jpg", 
		Filename = "itSTATUE.jpg", 
		Directives = {}
	}
}
zmediaitTORCH = Wherigo.ZMedia(cartGC2C5FN)
zmediaitTORCH.Id = "764fefe9-c66d-42f0-94e5-cd53f918af28"
zmediaitTORCH.Name = _o9p("\052\106\071\105\076\032\117")
zmediaitTORCH.Description = _o9p("\112\016\108\027\052\027\040\025\071\099\108\058\125\008\012")
zmediaitTORCH.AltText = _o9p("\112\050\076\067\116\067\015\025\071\105\076\032\117\089\036")
zmediaitTORCH.Resources = {
	{
		Type = "jpg", 
		Filename = "itTORCH.jpg", 
		Directives = {}
	}
}
zmediaitWPILL = Wherigo.ZMedia(cartGC2C5FN)
zmediaitWPILL.Id = "55d56ea7-8379-40e8-b450-a24f34192f77"
zmediaitWPILL.Name = _o9p("\052\106\039\096\116\107\107")
zmediaitWPILL.Description = _o9p("\039\099\099\023\008\027\025\096\052\017\017\078\108")
zmediaitWPILL.AltText = _o9p("\039\105\105\044\089\067\025\096\116\107\107\100\076")
zmediaitWPILL.Resources = {
	{
		Type = "jpg", 
		Filename = "itWPILL.jpg", 
		Directives = {}
	}
}
zmediaSNDBGMechoes = Wherigo.ZMedia(cartGC2C5FN)
zmediaSNDBGMechoes.Id = "371a84e5-59bb-4b2d-af12-f9834933f7eb"
zmediaSNDBGMechoes.Name = _o9p("\036\067\044\103\112\015\035\103\008\058\125\099\008\012")
zmediaSNDBGMechoes.Description = _o9p("\035\016\012\052\058\077\089\058\125\099\008\012")
zmediaSNDBGMechoes.AltText = _o9p("\035\050\036\116\032\077\089\032\117\105\089\036")
zmediaSNDBGMechoes.Resources = {
	{
		Type = "mp3", 
		Filename = "SND-BGM-echoes.mp3", 
		Directives = {}
	}
}
zmediaSNDBGMindustrial = Wherigo.ZMedia(cartGC2C5FN)
zmediaSNDBGMindustrial.Id = "5b5f8aad-e243-489c-8d8b-3f71d3a0c2ed"
zmediaSNDBGMindustrial.Name = _o9p("\036\067\044\103\112\015\035\103\052\027\023\016\012\106\108\052\078\017")
zmediaSNDBGMindustrial.Description = _o9p("\035\016\012\052\058\077\116\027\023\016\012\106\108\052\078\017")
zmediaSNDBGMindustrial.AltText = _o9p("\035\050\036\116\032\077\116\067\044\050\036\071\076\116\100\107")
zmediaSNDBGMindustrial.Resources = {
	{
		Type = "mp3", 
		Filename = "SND-BGM-industrial.mp3", 
		Directives = {}
	}
}
zmediaSNDBGMleadin = Wherigo.ZMedia(cartGC2C5FN)
zmediaSNDBGMleadin.Id = "ac11fdf3-5bec-456e-9a90-23f7eca9df91"
zmediaSNDBGMleadin.Name = _o9p("\036\067\044\103\112\015\035\103\017\008\078\023\052\027")
zmediaSNDBGMleadin.Description = _o9p("\035\016\012\052\058\077\107\008\078\023\103\116\027")
zmediaSNDBGMleadin.AltText = _o9p("\035\050\036\116\032\077\107\089\100\044\103\116\067")
zmediaSNDBGMleadin.Resources = {
	{
		Type = "mp3", 
		Filename = "SND-BGM-leadin.mp3", 
		Directives = {}
	}
}
zmediaSNDBGMsolemn = Wherigo.ZMedia(cartGC2C5FN)
zmediaSNDBGMsolemn.Id = "c27eedd5-e55f-44dc-92d4-68e92963efdf"
zmediaSNDBGMsolemn.Name = _o9p("\036\067\044\103\112\015\035\103\012\099\017\008\059\027")
zmediaSNDBGMsolemn.Description = _o9p("\035\016\012\052\058\077\036\099\017\008\059\027")
zmediaSNDBGMsolemn.AltText = _o9p("\035\050\036\116\032\077\036\105\107\089\035\067")
zmediaSNDBGMsolemn.Resources = {
	{
		Type = "mp3", 
		Filename = "SND-BGM-solemn.mp3", 
		Directives = {}
	}
}
zmediaSNDBGMundertones = Wherigo.ZMedia(cartGC2C5FN)
zmediaSNDBGMundertones.Id = "b7a26138-93af-4985-81e9-8b4649701a66"
zmediaSNDBGMundertones.Name = _o9p("\036\067\044\103\112\015\035\103\016\027\023\008\108\106\099\027\008\012")
zmediaSNDBGMundertones.Description = _o9p("\035\016\012\052\058\077\050\027\023\008\108\106\099\027\008\012")
zmediaSNDBGMundertones.AltText = _o9p("\035\050\036\116\032\077\050\067\044\089\076\071\105\067\089\036")
zmediaSNDBGMundertones.Resources = {
	{
		Type = "mp3", 
		Filename = "SND-BGM-undertones.mp3", 
		Directives = {}
	}
}
zmediaSNDbird = Wherigo.ZMedia(cartGC2C5FN)
zmediaSNDbird.Id = "a040122d-8e82-4329-9a7f-67eacc8e8406"
zmediaSNDbird.Name = _o9p("\036\067\044\103\085\052\108\023")
zmediaSNDbird.Description = _o9p("\036\099\016\027\023\077\112\052\108\023")
zmediaSNDbird.AltText = _o9p("\036\105\050\067\044\077\112\116\076\044")
zmediaSNDbird.Resources = {
	{
		Type = "mp3", 
		Filename = "SND-bird.mp3", 
		Directives = {}
	}
}
zmediaSNDboat = Wherigo.ZMedia(cartGC2C5FN)
zmediaSNDboat.Id = "ec472b90-b19c-4a4f-8a4f-d7704cfdf702"
zmediaSNDboat.Name = _o9p("\036\067\044\103\085\099\078\106")
zmediaSNDboat.Description = _o9p("\036\099\016\027\023\077\112\099\078\106")
zmediaSNDboat.AltText = _o9p("\036\105\050\067\044\077\112\105\100\071")
zmediaSNDboat.Resources = {
	{
		Type = "mp3", 
		Filename = "SND-boat.mp3", 
		Directives = {}
	}
}
zmediaSNDcamera = Wherigo.ZMedia(cartGC2C5FN)
zmediaSNDcamera.Id = "c6f79835-d7f6-4bf4-923f-998542acdab3"
zmediaSNDcamera.Name = _o9p("\036\067\044\103\058\078\059\008\108\078")
zmediaSNDcamera.Description = _o9p("\036\099\016\027\023\077\032\078\059\008\108\078")
zmediaSNDcamera.AltText = _o9p("\036\105\050\067\044\077\032\100\035\089\076\100")
zmediaSNDcamera.Resources = {
	{
		Type = "mp3", 
		Filename = "SND-camera.mp3", 
		Directives = {}
	}
}
zmediaSNDchoir = Wherigo.ZMedia(cartGC2C5FN)
zmediaSNDchoir.Id = "ab61dd53-c67a-4193-aff8-b6292cd69efb"
zmediaSNDchoir.Name = _o9p("\036\067\044\103\058\125\099\052\108")
zmediaSNDchoir.Description = _o9p("\036\099\016\027\023\077\032\125\099\052\108")
zmediaSNDchoir.AltText = _o9p("\036\105\050\067\044\077\032\117\105\116\076")
zmediaSNDchoir.Resources = {
	{
		Type = "mp3", 
		Filename = "SND-choir.mp3", 
		Directives = {}
	}
}
zmediaSNDcreek = Wherigo.ZMedia(cartGC2C5FN)
zmediaSNDcreek.Id = "3fa69391-0505-461a-9a22-d3cb8d460ed9"
zmediaSNDcreek.Name = _o9p("\036\067\044\103\058\108\008\008\024")
zmediaSNDcreek.Description = _o9p("\036\099\016\027\023\077\032\108\008\008\024")
zmediaSNDcreek.AltText = _o9p("\036\105\050\067\044\077\032\076\089\089\037")
zmediaSNDcreek.Resources = {
	{
		Type = "mp3", 
		Filename = "SND-creek.mp3", 
		Directives = {}
	}
}
zmediaSNDdock = Wherigo.ZMedia(cartGC2C5FN)
zmediaSNDdock.Id = "0238a8eb-a541-46a4-accc-595493603b4b"
zmediaSNDdock.Name = _o9p("\036\067\044\103\023\099\058\024")
zmediaSNDdock.Description = _o9p("\036\099\016\027\023\077\044\099\058\024")
zmediaSNDdock.AltText = _o9p("\036\105\050\067\044\077\044\105\032\037")
zmediaSNDdock.Resources = {
	{
		Type = "mp3", 
		Filename = "SND-dock.mp3", 
		Directives = {}
	}
}
zmediaSNDdrums = Wherigo.ZMedia(cartGC2C5FN)
zmediaSNDdrums.Id = "d8745325-4bc8-47fd-8567-2eae98b763ed"
zmediaSNDdrums.Name = _o9p("\036\067\044\103\023\108\016\059\012")
zmediaSNDdrums.Description = _o9p("\036\099\016\027\023\077\044\108\016\059\012")
zmediaSNDdrums.AltText = _o9p("\036\105\050\067\044\077\044\076\050\035\036")
zmediaSNDdrums.Resources = {
	{
		Type = "mp3", 
		Filename = "SND-drums.mp3", 
		Directives = {}
	}
}
zmediaSNDdundundun = Wherigo.ZMedia(cartGC2C5FN)
zmediaSNDdundundun.Id = "9807c35f-0765-43ec-b432-482a905c5fdc"
zmediaSNDdundundun.Name = _o9p("\036\067\044\103\023\016\027\023\016\027\023\016\027")
zmediaSNDdundundun.Description = _o9p("\036\099\016\027\023\077\044\108\078\059\078")
zmediaSNDdundundun.AltText = _o9p("\036\105\050\067\044\077\044\076\100\035\100")
zmediaSNDdundundun.Resources = {
	{
		Type = "mp3", 
		Filename = "SND-dundundun.mp3", 
		Directives = {}
	}
}
zmediaSNDengine = Wherigo.ZMedia(cartGC2C5FN)
zmediaSNDengine.Id = "590c1ca2-6458-4168-876b-bd685bb26964"
zmediaSNDengine.Name = _o9p("\036\067\044\103\008\027\040\052\027\008")
zmediaSNDengine.Description = _o9p("\036\099\016\027\023\077\089\027\040\052\027\008\025\032\125\099\024\008")
zmediaSNDengine.AltText = _o9p("\036\105\050\067\044\077\089\067\015\116\067\089\025\032\117\105\037\089")
zmediaSNDengine.Resources = {
	{
		Type = "mp3", 
		Filename = "SND-engine.mp3", 
		Directives = {}
	}
}
zmediaSNDenginesputter = Wherigo.ZMedia(cartGC2C5FN)
zmediaSNDenginesputter.Id = "2bd59d0d-f0db-449a-9766-ac380cd533ad"
zmediaSNDenginesputter.Name = _o9p("\036\067\044\103\008\027\040\052\027\008\012\068\016\106\106\008\108")
zmediaSNDenginesputter.Description = _o9p("\036\099\016\027\023\077\089\027\040\052\027\008\025\036\068\016\106\106\008\108")
zmediaSNDenginesputter.AltText = _o9p("\036\105\050\067\044\077\089\067\015\116\067\089\025\036\096\050\071\071\089\076")
zmediaSNDenginesputter.Resources = {
	{
		Type = "mp3", 
		Filename = "SND-enginesputter.mp3", 
		Directives = {}
	}
}
zmediaSNDghostly = Wherigo.ZMedia(cartGC2C5FN)
zmediaSNDghostly.Id = "20e22374-ff3c-41c1-8fe9-108921eed36f"
zmediaSNDghostly.Name = _o9p("\036\067\044\103\040\125\099\012\106\017\111")
zmediaSNDghostly.Description = _o9p("\036\099\016\027\023\077\015\125\099\012\106\017\111")
zmediaSNDghostly.AltText = _o9p("\036\105\050\067\044\077\015\117\105\036\071\107\097")
zmediaSNDghostly.Resources = {
	{
		Type = "mp3", 
		Filename = "SND-ghostly.mp3", 
		Directives = {}
	}
}
zmediaSNDgrowl = Wherigo.ZMedia(cartGC2C5FN)
zmediaSNDgrowl.Id = "f0905559-a048-4075-8999-198bc8855de5"
zmediaSNDgrowl.Name = _o9p("\036\067\044\103\040\108\099\030\017")
zmediaSNDgrowl.Description = _o9p("\036\099\016\027\023\077\015\108\099\030\017")
zmediaSNDgrowl.AltText = _o9p("\036\105\050\067\044\077\015\076\105\039\107")
zmediaSNDgrowl.Resources = {
	{
		Type = "mp3", 
		Filename = "SND-growl.mp3", 
		Directives = {}
	}
}
zmediaSNDhowl = Wherigo.ZMedia(cartGC2C5FN)
zmediaSNDhowl.Id = "67527647-3a0a-467d-bff7-a917623389fb"
zmediaSNDhowl.Name = _o9p("\036\067\044\103\125\099\030\017")
zmediaSNDhowl.Description = _o9p("\036\099\016\027\023\077\117\099\030\017")
zmediaSNDhowl.AltText = _o9p("\036\105\050\067\044\077\015\076\105\039\107")
zmediaSNDhowl.Resources = {
	{
		Type = "mp3", 
		Filename = "SND-howl.mp3", 
		Directives = {}
	}
}
zmediaSNDhut = Wherigo.ZMedia(cartGC2C5FN)
zmediaSNDhut.Id = "c1405b1b-56e5-4cdc-bbbe-5aa7977bcef5"
zmediaSNDhut.Name = _o9p("\036\067\044\103\125\016\106")
zmediaSNDhut.Description = _o9p("\036\099\016\027\023\077\117\016\106\025\032\108\008\008\024")
zmediaSNDhut.AltText = _o9p("\036\105\050\067\044\077\117\050\071\025\032\108\008\008\024")
zmediaSNDhut.Resources = {
	{
		Type = "mp3", 
		Filename = "SND-hut.mp3", 
		Directives = {}
	}
}
zmediaSNDnoservice = Wherigo.ZMedia(cartGC2C5FN)
zmediaSNDnoservice.Id = "8febd45f-514f-4b23-9fe5-8d8b5321ef47"
zmediaSNDnoservice.Name = _o9p("\036\067\044\103\027\099\012\008\108\013\052\058\008")
zmediaSNDnoservice.Description = _o9p("\036\099\016\027\023\077\067\099\025\032\008\017\017\025\036\008\108\013\052\058\008")
zmediaSNDnoservice.AltText = _o9p("\036\105\050\067\044\077\067\105\025\032\089\107\107\025\036\089\076\081\116\032\089")
zmediaSNDnoservice.Resources = {
	{
		Type = "mp3", 
		Filename = "SND-noservice.mp3", 
		Directives = {}
	}
}
zmediaSNDraven = Wherigo.ZMedia(cartGC2C5FN)
zmediaSNDraven.Id = "382df83f-2eec-4187-87d0-54dc843f8162"
zmediaSNDraven.Name = _o9p("\036\067\044\103\108\078\013\008\027")
zmediaSNDraven.Description = _o9p("\036\099\016\027\023\077\076\078\013\008\027")
zmediaSNDraven.AltText = _o9p("\036\105\050\067\044\077\076\100\081\089\067")
zmediaSNDraven.Resources = {
	{
		Type = "mp3", 
		Filename = "SND-raven.mp3", 
		Directives = {}
	}
}
zmediaSNDrisen = Wherigo.ZMedia(cartGC2C5FN)
zmediaSNDrisen.Id = "8ffab762-dbcb-451c-b7a1-b70f68debb7d"
zmediaSNDrisen.Name = _o9p("\036\067\044\103\108\052\012\008\027")
zmediaSNDrisen.Description = _o9p("\036\099\016\027\023\077\076\052\012\008\027")
zmediaSNDrisen.AltText = _o9p("\036\105\050\067\044\077\076\116\036\089\067")
zmediaSNDrisen.Resources = {
	{
		Type = "mp3", 
		Filename = "SND-risen.mp3", 
		Directives = {}
	}
}
zmediaSNDritualdrums = Wherigo.ZMedia(cartGC2C5FN)
zmediaSNDritualdrums.Id = "a85d9dec-c420-48b5-a07b-438aa75ba984"
zmediaSNDritualdrums.Name = _o9p("\036\067\044\103\108\052\106\016\078\017\023\108\016\059\012")
zmediaSNDritualdrums.Description = _o9p("\036\099\016\027\023\077\076\052\106\016\078\017\025\044\108\016\059\012")
zmediaSNDritualdrums.AltText = _o9p("\036\105\050\067\044\077\076\116\071\050\100\107\025\044\076\050\035\036")
zmediaSNDritualdrums.Resources = {
	{
		Type = "mp3", 
		Filename = "SND-ritualdrums.mp3", 
		Directives = {}
	}
}
zmediaSNDthunder = Wherigo.ZMedia(cartGC2C5FN)
zmediaSNDthunder.Id = "12813a65-5a54-4b23-a078-156a36c174e9"
zmediaSNDthunder.Name = _o9p("\036\067\044\103\106\125\016\027\023\008\108")
zmediaSNDthunder.Description = _o9p("\036\099\016\027\023\077\071\125\016\027\023\008\108")
zmediaSNDthunder.AltText = _o9p("\036\105\050\067\044\077\071\117\050\067\044\089\076")
zmediaSNDthunder.Resources = {
	{
		Type = "mp3", 
		Filename = "SND-thunder.mp3", 
		Directives = {}
	}
}
zmediaSNDtireroll = Wherigo.ZMedia(cartGC2C5FN)
zmediaSNDtireroll.Id = "e6746e22-3848-404c-8d0a-7b941c627fe6"
zmediaSNDtireroll.Name = _o9p("\036\067\044\103\106\052\108\008\108\099\017\017")
zmediaSNDtireroll.Description = _o9p("\036\099\016\027\023\077\071\052\108\008\025\076\099\017\017\052\027\040")
zmediaSNDtireroll.AltText = _o9p("\036\105\050\067\044\077\071\116\076\089\025\076\105\107\107\116\067\015")
zmediaSNDtireroll.Resources = {
	{
		Type = "mp3", 
		Filename = "SND-tireroll.mp3", 
		Directives = {}
	}
}
zmediaSNDwailing = Wherigo.ZMedia(cartGC2C5FN)
zmediaSNDwailing.Id = "33b6a291-7194-4488-9259-c53bb2fcddec"
zmediaSNDwailing.Name = _o9p("\036\067\044\103\030\078\052\017\052\027\040")
zmediaSNDwailing.Description = _o9p("\036\099\016\027\023\077\039\078\052\017\052\027\040")
zmediaSNDwailing.AltText = _o9p("\036\105\050\067\044\077\039\100\116\107\116\067\015")
zmediaSNDwailing.Resources = {
	{
		Type = "mp3", 
		Filename = "SND-wailing.mp3", 
		Directives = {}
	}
}
zmediaSNDwhispers = Wherigo.ZMedia(cartGC2C5FN)
zmediaSNDwhispers.Id = "10fa95cf-a492-4392-abfd-636923afeab0"
zmediaSNDwhispers.Name = _o9p("\036\067\044\103\030\125\052\012\068\008\108\012")
zmediaSNDwhispers.Description = _o9p("\036\099\016\027\023\077\039\125\052\012\068\008\108\012")
zmediaSNDwhispers.AltText = _o9p("\036\105\050\067\044\077\039\117\116\036\096\089\076\036")
zmediaSNDwhispers.Resources = {
	{
		Type = "mp3", 
		Filename = "SND-whispers.mp3", 
		Directives = {}
	}
}
zmediaSNDwind = Wherigo.ZMedia(cartGC2C5FN)
zmediaSNDwind.Id = "4784a6f8-1eb4-44e7-a404-bc6d64192a16"
zmediaSNDwind.Name = _o9p("\036\067\044\103\030\052\027\023")
zmediaSNDwind.Description = _o9p("\036\099\016\027\023\077\039\052\027\023")
zmediaSNDwind.AltText = _o9p("\036\105\050\067\044\077\039\116\067\044")
zmediaSNDwind.Resources = {
	{
		Type = "mp3", 
		Filename = "SND-wind.mp3", 
		Directives = {}
	}
}
zmediaSNDzap = Wherigo.ZMedia(cartGC2C5FN)
zmediaSNDzap.Id = "af2d3979-b12d-420b-8a08-a6135459c680"
zmediaSNDzap.Name = _o9p("\036\067\044\103\065\078\068")
zmediaSNDzap.Description = _o9p("\036\099\016\027\023\077\060\078\068")
zmediaSNDzap.AltText = _o9p("\036\105\050\067\044\077\060\100\096")
zmediaSNDzap.Resources = {
	{
		Type = "mp3", 
		Filename = "SND-zap.mp3", 
		Directives = {}
	}
}
zmediazBED = Wherigo.ZMedia(cartGC2C5FN)
zmediazBED.Id = "36c97b19-9b05-431c-804c-644933b5f964"
zmediazBED.Name = _o9p("\065\112\089\044")
zmediazBED.Description = _o9p("\116\027\025\106\125\008\025\112\008\023")
zmediazBED.AltText = _o9p("\116\067\025\071\117\089\025\112\089\044")
zmediazBED.Resources = {
	{
		Type = "jpg", 
		Filename = "zBED.jpg", 
		Directives = {}
	}
}
zmediazEDGE1 = Wherigo.ZMedia(cartGC2C5FN)
zmediazEDGE1.Id = "ac16cc6d-a51f-4e6f-bd9e-161335325b58"
zmediazEDGE1.Name = _o9p("\065\089\044\015\089\049")
zmediazEDGE1.Description = _o9p("\107\099\099\024\052\027\040\025\078\106\025\106\125\008\025\089\023\040\008")
zmediazEDGE1.AltText = _o9p("\107\105\105\037\116\067\015\025\100\071\025\071\117\089\025\089\044\015\089")
zmediazEDGE1.Resources = {
	{
		Type = "jpg", 
		Filename = "zEDGE1.jpg", 
		Directives = {}
	}
}
zmediazEDGE2 = Wherigo.ZMedia(cartGC2C5FN)
zmediazEDGE2.Id = "6af0392d-d608-41d2-8b69-ab6a5ed83573"
zmediazEDGE2.Name = _o9p("\065\089\044\015\089\034")
zmediazEDGE2.Description = _o9p("\107\099\099\024\052\027\040\025\078\106\025\106\125\008\025\089\023\040\008")
zmediazEDGE2.AltText = _o9p("\107\105\105\037\116\067\015\025\100\071\025\071\117\089\025\089\044\015\089")
zmediazEDGE2.Resources = {
	{
		Type = "jpg", 
		Filename = "zEDGE2.jpg", 
		Directives = {}
	}
}
zmediazHUT = Wherigo.ZMedia(cartGC2C5FN)
zmediazHUT.Id = "3742e057-c984-40e7-918b-146b41676f72"
zmediazHUT.Name = _o9p("\065\117\050\071")
zmediazHUT.Description = _o9p("\117\016\106\025\052\027\025\106\125\008\025\039\099\099\023\012")
zmediazHUT.AltText = _o9p("\117\050\071\025\116\067\025\071\117\089\025\039\105\105\044\036")
zmediazHUT.Resources = {
	{
		Type = "jpg", 
		Filename = "zHUT.jpg", 
		Directives = {}
	}
}
zmediazLAKE = Wherigo.ZMedia(cartGC2C5FN)
zmediazLAKE.Id = "06a4a8d6-cce5-4f24-af0c-b2aafe4157f9"
zmediazLAKE.Name = _o9p("\065\107\100\037\089")
zmediazLAKE.Description = _o9p("\107\078\024\008\025\076\052\059")
zmediazLAKE.AltText = _o9p("\107\100\037\089\025\076\116\035")
zmediazLAKE.Resources = {
	{
		Type = "jpg", 
		Filename = "zLAKE.jpg", 
		Directives = {}
	}
}
zmediazROAD = Wherigo.ZMedia(cartGC2C5FN)
zmediazROAD.Id = "3377af97-d8b0-4651-8f14-6ca755bd4c18"
zmediazROAD.Name = _o9p("\065\076\105\100\044")
zmediazROAD.Description = _o9p("\048\016\052\008\106\025\076\099\078\023")
zmediazROAD.AltText = _o9p("\048\050\116\089\071\025\076\105\100\044")
zmediazROAD.Resources = {
	{
		Type = "jpg", 
		Filename = "zROAD.jpg", 
		Directives = {}
	}
}
zmediazSHORE1 = Wherigo.ZMedia(cartGC2C5FN)
zmediazSHORE1.Id = "4053e004-88c4-4dca-b748-29ac36cc7cc8"
zmediazSHORE1.Name = _o9p("\065\036\117\105\076\089\049")
zmediazSHORE1.Description = _o9p("\107\078\024\008\025\036\125\099\108\008\017\052\027\008")
zmediazSHORE1.AltText = _o9p("\107\100\037\089\025\036\117\105\076\089\107\116\067\089")
zmediazSHORE1.Resources = {
	{
		Type = "jpg", 
		Filename = "zSHORE1.jpg", 
		Directives = {}
	}
}
zmediazSHORE2 = Wherigo.ZMedia(cartGC2C5FN)
zmediazSHORE2.Id = "7c8a2ade-4e13-4786-87ee-8f22e3c0b51d"
zmediazSHORE2.Name = _o9p("\065\036\117\105\076\089\034")
zmediazSHORE2.Description = _o9p("\107\078\024\008\025\036\125\099\108\008\017\052\027\008")
zmediazSHORE2.AltText = _o9p("\107\100\037\089\025\036\117\105\076\089\107\116\067\089")
zmediazSHORE2.Resources = {
	{
		Type = "jpg", 
		Filename = "zSHORE2.jpg", 
		Directives = {}
	}
}
zmediazSHORE3 = Wherigo.ZMedia(cartGC2C5FN)
zmediazSHORE3.Id = "a1fcfc96-d3bd-48e4-a0d7-e16a31e75146"
zmediazSHORE3.Name = _o9p("\065\036\117\105\076\089\062")
zmediazSHORE3.Description = _o9p("\107\078\024\008\025\036\125\099\108\008\017\052\027\008")
zmediazSHORE3.AltText = _o9p("\107\100\037\089\025\036\117\105\076\089\107\116\067\089")
zmediazSHORE3.Resources = {
	{
		Type = "jpg", 
		Filename = "zSHORE3.jpg", 
		Directives = {}
	}
}
zmediazSRD1 = Wherigo.ZMedia(cartGC2C5FN)
zmediazSRD1.Id = "a89d7e20-159f-49be-bace-ee9a59758505"
zmediazSRD1.Name = _o9p("\065\036\076\044\049")
zmediazSRD1.Description = _o9p("\036\052\023\008\025\071\108\078\052\017")
zmediazSRD1.AltText = _o9p("\036\116\044\089\025\071\076\100\116\107")
zmediazSRD1.Resources = {
	{
		Type = "jpg", 
		Filename = "zSRD1.jpg", 
		Directives = {}
	}
}
zmediazSRD2 = Wherigo.ZMedia(cartGC2C5FN)
zmediazSRD2.Id = "3ee796b7-07f5-46dd-a9ed-0dd15c71aba5"
zmediazSRD2.Name = _o9p("\065\036\076\044\034")
zmediazSRD2.Description = _o9p("\036\052\023\008\025\071\108\078\052\017")
zmediazSRD2.AltText = _o9p("\036\116\044\089\025\071\076\100\116\107")
zmediazSRD2.Resources = {
	{
		Type = "jpg", 
		Filename = "zSRD2.jpg", 
		Directives = {}
	}
}
zmediazSTRM1 = Wherigo.ZMedia(cartGC2C5FN)
zmediazSTRM1.Id = "53f13d40-0585-4a6c-9a5a-1ff64a4235fe"
zmediazSTRM1.Name = _o9p("\065\036\071\076\035\049")
zmediazSTRM1.Description = _o9p("\036\106\108\008\078\059")
zmediazSTRM1.AltText = _o9p("\036\071\076\089\100\035")
zmediazSTRM1.Resources = {
	{
		Type = "jpg", 
		Filename = "zSTRM1.jpg", 
		Directives = {}
	}
}
zmediaINTRO3 = Wherigo.ZMedia(cartGC2C5FN)
zmediaINTRO3.Id = "2c5b4c5e-7927-4755-be14-9c9fe4137b51"
zmediaINTRO3.Name = _o9p("\116\067\071\076\105\062")
zmediaINTRO3.Description = _o9p("\126\112\078\106\058\125\025\116\059\068\099\108\106\025\035\008\023\052\078\087")
zmediaINTRO3.AltText = ""
zmediaINTRO3.Resources = {
	{
		Type = "jpg", 
		Filename = "INTRO3.jpg", 
		Directives = {}
	}
}
zmediaSNDBGMnightscape = Wherigo.ZMedia(cartGC2C5FN)
zmediaSNDBGMnightscape.Id = "a3255ede-fc26-470c-8e6f-9b9ec391b8c8"
zmediaSNDBGMnightscape.Name = _o9p("\036\067\044\103\112\015\035\103\027\052\040\125\106\012\058\078\068\008")
zmediaSNDBGMnightscape.Description = _o9p("\035\016\012\052\058\077\067\052\040\125\106\012\058\078\068\008")
zmediaSNDBGMnightscape.AltText = _o9p("\035\050\036\116\032\077\067\116\015\117\071\036\032\100\096\089")
zmediaSNDBGMnightscape.Resources = {
	{
		Type = "mp3", 
		Filename = "SND-BGM-nightscape.mp3", 
		Directives = {}
	}
}
zmediaINTRO21 = Wherigo.ZMedia(cartGC2C5FN)
zmediaINTRO21.Id = "0857dfa8-4779-4425-928b-ad27bdfd09b8"
zmediaINTRO21.Name = _o9p("\116\067\071\076\105\034\049")
zmediaINTRO21.Description = _o9p("\126\112\078\106\058\125\025\116\059\068\099\108\106\025\035\008\023\052\078\087")
zmediaINTRO21.AltText = ""
zmediaINTRO21.Resources = {
	{
		Type = "jpg", 
		Filename = "INTRO21.jpg", 
		Directives = {}
	}
}
zmediazTRAIL4 = Wherigo.ZMedia(cartGC2C5FN)
zmediazTRAIL4.Id = "34eb7913-d261-44be-94ca-a26512e1e94c"
zmediazTRAIL4.Name = _o9p("\065\071\076\100\116\107\118")
zmediazTRAIL4.Description = _o9p("\107\078\024\008\025\076\052\059\025\071\108\078\052\017")
zmediazTRAIL4.AltText = _o9p("\107\100\037\089\025\076\116\035\025\071\076\100\116\107")
zmediazTRAIL4.Resources = {
	{
		Type = "jpg", 
		Filename = "zTRAIL4.jpg", 
		Directives = {}
	}
}
zmediaINTRO2 = Wherigo.ZMedia(cartGC2C5FN)
zmediaINTRO2.Id = "d6c5d26e-9023-4515-ba21-384e7e6474bc"
zmediaINTRO2.Name = _o9p("\116\067\071\076\105\034")
zmediaINTRO2.Description = _o9p("\126\112\078\106\058\125\025\116\059\068\099\108\106\025\035\008\023\052\078\087")
zmediaINTRO2.AltText = ""
zmediaINTRO2.Resources = {
	{
		Type = "jpg", 
		Filename = "INTRO2.jpg", 
		Directives = {}
	}
}
zmediaINTRO7 = Wherigo.ZMedia(cartGC2C5FN)
zmediaINTRO7.Id = "88ef595e-59e5-4e1c-821f-fade6d1822cd"
zmediaINTRO7.Name = _o9p("\116\067\071\076\105\063")
zmediaINTRO7.Description = _o9p("\126\112\078\106\058\125\025\116\059\068\099\108\106\025\035\008\023\052\078\087")
zmediaINTRO7.AltText = ""
zmediaINTRO7.Resources = {
	{
		Type = "jpg", 
		Filename = "INTRO7.jpg", 
		Directives = {}
	}
}
zmediaINTRO10 = Wherigo.ZMedia(cartGC2C5FN)
zmediaINTRO10.Id = "778f8b77-7c88-4653-8767-df8d37b1ce36"
zmediaINTRO10.Name = _o9p("\116\067\071\076\105\049\101")
zmediaINTRO10.Description = _o9p("\126\112\078\106\058\125\025\116\059\068\099\108\106\025\035\008\023\052\078\087")
zmediaINTRO10.AltText = ""
zmediaINTRO10.Resources = {
	{
		Type = "jpg", 
		Filename = "INTRO10.jpg", 
		Directives = {}
	}
}
zmediazSRD3 = Wherigo.ZMedia(cartGC2C5FN)
zmediazSRD3.Id = "6c44c424-d827-44c6-a8b8-c1a1766ed9b1"
zmediazSRD3.Name = _o9p("\065\036\076\044\062")
zmediazSRD3.Description = _o9p("\036\052\023\008\025\071\108\078\052\017")
zmediazSRD3.AltText = _o9p("\036\116\044\089\025\071\076\100\116\107")
zmediazSRD3.Resources = {
	{
		Type = "jpg", 
		Filename = "zSRD3.jpg", 
		Directives = {}
	}
}
zmediazSTR2 = Wherigo.ZMedia(cartGC2C5FN)
zmediazSTR2.Id = "cfdf9f15-d519-4d7b-ac95-0cfef3f0a421"
zmediazSTR2.Name = _o9p("\065\036\071\076\034")
zmediazSTR2.Description = _o9p("\036\106\108\008\078\059")
zmediazSTR2.AltText = _o9p("\036\071\076\089\100\035")
zmediazSTR2.Resources = {
	{
		Type = "jpg", 
		Filename = "zSTR2.jpg", 
		Directives = {}
	}
}
zmediaINTRO12 = Wherigo.ZMedia(cartGC2C5FN)
zmediaINTRO12.Id = "2226d255-0884-4299-80c0-aa6aab5933ce"
zmediaINTRO12.Name = _o9p("\116\067\071\076\105\049\034")
zmediaINTRO12.Description = _o9p("\126\112\078\106\058\125\025\116\059\068\099\108\106\025\035\008\023\052\078\087")
zmediaINTRO12.AltText = ""
zmediaINTRO12.Resources = {
	{
		Type = "jpg", 
		Filename = "INTRO12.jpg", 
		Directives = {}
	}
}
zmediaePYRE2 = Wherigo.ZMedia(cartGC2C5FN)
zmediaePYRE2.Id = "993a9a01-b247-47db-9af6-b2714260e38f"
zmediaePYRE2.Name = _o9p("\008\096\097\076\089\034")
zmediaePYRE2.Description = _o9p("\032\008\108\008\059\099\027\052\078\017\025\096\111\108\008")
zmediaePYRE2.AltText = _o9p("\032\089\076\089\035\105\067\116\100\107\025\096\097\076\089")
zmediaePYRE2.Resources = {
	{
		Type = "jpg", 
		Filename = "ePYRE2.jpg", 
		Directives = {}
	}
}
zmediaINTRO6 = Wherigo.ZMedia(cartGC2C5FN)
zmediaINTRO6.Id = "254b25a5-990c-42bf-b984-dcc4e2ebcd34"
zmediaINTRO6.Name = _o9p("\116\067\071\076\105\083")
zmediaINTRO6.Description = _o9p("\126\112\078\106\058\125\025\116\059\068\099\108\106\025\035\008\023\052\078\087")
zmediaINTRO6.AltText = ""
zmediaINTRO6.Resources = {
	{
		Type = "jpg", 
		Filename = "INTRO6.jpg", 
		Directives = {}
	}
}
zmediaicMASK = Wherigo.ZMedia(cartGC2C5FN)
zmediaicMASK.Id = "de3473eb-c079-426f-95c9-f7eac6a9df31"
zmediaicMASK.Name = _o9p("\052\058\035\100\036\037")
zmediaicMASK.Description = _o9p("\116\058\099\027\077\035\078\012\024")
zmediaicMASK.AltText = _o9p("\116\032\105\067\077\035\100\036\037")
zmediaicMASK.Resources = {
	{
		Type = "jpg", 
		Filename = "icMASK.jpg", 
		Directives = {}
	}
}
zmediaINTRO18 = Wherigo.ZMedia(cartGC2C5FN)
zmediaINTRO18.Id = "d38c9cbe-d0cf-446d-bf91-321be7300b70"
zmediaINTRO18.Name = _o9p("\116\067\071\076\105\049\124")
zmediaINTRO18.Description = _o9p("\126\112\078\106\058\125\025\116\059\068\099\108\106\025\035\008\023\052\078\087")
zmediaINTRO18.AltText = ""
zmediaINTRO18.Resources = {
	{
		Type = "jpg", 
		Filename = "INTRO18.jpg", 
		Directives = {}
	}
}
zmediazTRAIL1 = Wherigo.ZMedia(cartGC2C5FN)
zmediazTRAIL1.Id = "4b542e4a-8814-4b30-b086-14087e886894"
zmediazTRAIL1.Name = _o9p("\065\071\076\100\116\107\049")
zmediazTRAIL1.Description = _o9p("\107\078\024\008\025\076\052\059\025\071\108\078\052\017")
zmediazTRAIL1.AltText = _o9p("\107\100\037\089\025\076\116\035\025\071\076\100\116\107")
zmediazTRAIL1.Resources = {
	{
		Type = "jpg", 
		Filename = "zTRAIL1.jpg", 
		Directives = {}
	}
}
zmediaINTRO1 = Wherigo.ZMedia(cartGC2C5FN)
zmediaINTRO1.Id = "b9a36b14-e4a0-44e5-accc-5305ee5fa98e"
zmediaINTRO1.Name = _o9p("\116\067\071\076\105\049")
zmediaINTRO1.Description = _o9p("\126\112\078\106\058\125\025\116\059\068\099\108\106\025\035\008\023\052\078\087")
zmediaINTRO1.AltText = ""
zmediaINTRO1.Resources = {
	{
		Type = "jpg", 
		Filename = "INTRO1.jpg", 
		Directives = {}
	}
}
zmediaINTRO19 = Wherigo.ZMedia(cartGC2C5FN)
zmediaINTRO19.Id = "4442af4f-f63e-4943-ae0e-760e4dd72b1b"
zmediaINTRO19.Name = _o9p("\116\067\071\076\105\049\113")
zmediaINTRO19.Description = _o9p("\126\112\078\106\058\125\025\116\059\068\099\108\106\025\035\008\023\052\078\087")
zmediaINTRO19.AltText = ""
zmediaINTRO19.Resources = {
	{
		Type = "jpg", 
		Filename = "INTRO19.jpg", 
		Directives = {}
	}
}
zmediaINTRO11 = Wherigo.ZMedia(cartGC2C5FN)
zmediaINTRO11.Id = "71d49efa-1e35-489f-805f-7b9543fa0cd4"
zmediaINTRO11.Name = _o9p("\116\067\071\076\105\049\049")
zmediaINTRO11.Description = _o9p("\126\112\078\106\058\125\025\116\059\068\099\108\106\025\035\008\023\052\078\087")
zmediaINTRO11.AltText = ""
zmediaINTRO11.Resources = {
	{
		Type = "jpg", 
		Filename = "INTRO11.jpg", 
		Directives = {}
	}
}
zmediaicGPS = Wherigo.ZMedia(cartGC2C5FN)
zmediaicGPS.Id = "20542095-3aaa-480a-b679-bed1c87f5d96"
zmediaicGPS.Name = _o9p("\052\058\015\096\036")
zmediaicGPS.Description = _o9p("\116\058\099\027\077\015\096\036")
zmediaicGPS.AltText = _o9p("\116\032\105\067\077\015\096\036")
zmediaicGPS.Resources = {
	{
		Type = "jpg", 
		Filename = "icGPS.jpg", 
		Directives = {}
	}
}
zmediaINTRO5 = Wherigo.ZMedia(cartGC2C5FN)
zmediaINTRO5.Id = "a2d25dbe-3ddb-4a51-be5c-4978628e96fe"
zmediaINTRO5.Name = _o9p("\116\067\071\076\105\127")
zmediaINTRO5.Description = _o9p("\126\112\078\106\058\125\025\116\059\068\099\108\106\025\035\008\023\052\078\087")
zmediaINTRO5.AltText = ""
zmediaINTRO5.Resources = {
	{
		Type = "jpg", 
		Filename = "INTRO5.jpg", 
		Directives = {}
	}
}
zmediazTRAIL5 = Wherigo.ZMedia(cartGC2C5FN)
zmediazTRAIL5.Id = "ab20280c-df11-49b7-90fd-498c084a73c2"
zmediazTRAIL5.Name = _o9p("\065\071\076\100\116\107\127")
zmediazTRAIL5.Description = _o9p("\107\078\024\008\025\076\052\059\025\071\108\078\052\017")
zmediazTRAIL5.AltText = _o9p("\107\100\037\089\025\076\116\035\025\071\076\100\116\107")
zmediazTRAIL5.Resources = {
	{
		Type = "jpg", 
		Filename = "zTRAIL5.jpg", 
		Directives = {}
	}
}
zmediaINTRO15 = Wherigo.ZMedia(cartGC2C5FN)
zmediaINTRO15.Id = "d03b2b1a-1a38-49ca-ba74-80b7d938c486"
zmediaINTRO15.Name = _o9p("\116\067\071\076\105\049\127")
zmediaINTRO15.Description = _o9p("\126\112\078\106\058\125\025\116\059\068\099\108\106\025\035\008\023\052\078\087")
zmediaINTRO15.AltText = ""
zmediaINTRO15.Resources = {
	{
		Type = "jpg", 
		Filename = "INTRO15.jpg", 
		Directives = {}
	}
}
zmediaINTRO9 = Wherigo.ZMedia(cartGC2C5FN)
zmediaINTRO9.Id = "a497f421-e1db-42d3-8f13-fa390242fd35"
zmediaINTRO9.Name = _o9p("\116\067\071\076\105\113")
zmediaINTRO9.Description = _o9p("\126\112\078\106\058\125\025\116\059\068\099\108\106\025\035\008\023\052\078\087")
zmediaINTRO9.AltText = ""
zmediaINTRO9.Resources = {
	{
		Type = "jpg", 
		Filename = "INTRO9.jpg", 
		Directives = {}
	}
}
zmediaINTRO14 = Wherigo.ZMedia(cartGC2C5FN)
zmediaINTRO14.Id = "3bc64d6b-335b-44f0-a0a4-f5c0506d782e"
zmediaINTRO14.Name = _o9p("\116\067\071\076\105\049\118")
zmediaINTRO14.Description = _o9p("\126\112\078\106\058\125\025\116\059\068\099\108\106\025\035\008\023\052\078\087")
zmediaINTRO14.AltText = ""
zmediaINTRO14.Resources = {
	{
		Type = "jpg", 
		Filename = "INTRO14.jpg", 
		Directives = {}
	}
}
zmediaSNDBGMintro = Wherigo.ZMedia(cartGC2C5FN)
zmediaSNDBGMintro.Id = "d12c5c74-cf82-4ce8-8a0e-1c5cc931c906"
zmediaSNDBGMintro.Name = _o9p("\036\067\044\103\112\015\035\103\052\027\106\108\099")
zmediaSNDBGMintro.Description = _o9p("\035\016\012\052\058\077\116\027\106\108\099")
zmediaSNDBGMintro.AltText = _o9p("\035\050\036\116\032\077\116\067\071\076\105")
zmediaSNDBGMintro.Resources = {
	{
		Type = "mp3", 
		Filename = "SND-BGM-intro.mp3", 
		Directives = {}
	}
}
zmediazTRAIL2 = Wherigo.ZMedia(cartGC2C5FN)
zmediazTRAIL2.Id = "7197b475-0748-48dd-8fc0-c8a3ddf3d3eb"
zmediazTRAIL2.Name = _o9p("\065\071\076\100\116\107\034")
zmediazTRAIL2.Description = _o9p("\107\078\024\008\025\076\052\059\025\071\108\078\052\017")
zmediazTRAIL2.AltText = _o9p("\107\100\037\089\025\076\116\035\025\071\076\100\116\107")
zmediazTRAIL2.Resources = {
	{
		Type = "jpg", 
		Filename = "zTRAIL2.jpg", 
		Directives = {}
	}
}
zmediazSTRM3 = Wherigo.ZMedia(cartGC2C5FN)
zmediazSTRM3.Id = "63882559-08b1-47ca-af06-2c01a5164fc8"
zmediazSTRM3.Name = _o9p("\065\036\071\076\035\062")
zmediazSTRM3.Description = _o9p("\036\106\108\008\078\059")
zmediazSTRM3.AltText = _o9p("\036\071\076\089\100\035")
zmediazSTRM3.Resources = {
	{
		Type = "jpg", 
		Filename = "zSTRM3.jpg", 
		Directives = {}
	}
}
zmediaINTRO20 = Wherigo.ZMedia(cartGC2C5FN)
zmediaINTRO20.Id = "83542197-4814-4d73-a988-ac7962e19a4b"
zmediaINTRO20.Name = _o9p("\116\067\071\076\105\034\101")
zmediaINTRO20.Description = _o9p("\126\112\078\106\058\125\025\116\059\068\099\108\106\025\035\008\023\052\078\087")
zmediaINTRO20.AltText = ""
zmediaINTRO20.Resources = {
	{
		Type = "jpg", 
		Filename = "INTRO20.jpg", 
		Directives = {}
	}
}
zmediazTRAIL3 = Wherigo.ZMedia(cartGC2C5FN)
zmediazTRAIL3.Id = "b625ae80-bb49-423c-b8f5-a4f9c8dd644f"
zmediazTRAIL3.Name = _o9p("\065\071\076\100\116\107\062")
zmediazTRAIL3.Description = _o9p("\107\078\024\008\025\076\052\059\025\071\108\078\052\017")
zmediazTRAIL3.AltText = _o9p("\107\100\037\089\025\076\116\035\025\071\076\100\116\107")
zmediazTRAIL3.Resources = {
	{
		Type = "jpg", 
		Filename = "zTRAIL3.jpg", 
		Directives = {}
	}
}
zmediazSTR1 = Wherigo.ZMedia(cartGC2C5FN)
zmediazSTR1.Id = "dc042cfe-3f5b-45fc-8ce3-c27a96a347ae"
zmediazSTR1.Name = _o9p("\065\036\071\076\049")
zmediazSTR1.Description = _o9p("\036\106\108\008\078\059")
zmediazSTR1.AltText = _o9p("\036\071\076\089\100\035")
zmediazSTR1.Resources = {
	{
		Type = "jpg", 
		Filename = "zSTR1.jpg", 
		Directives = {}
	}
}
zmediaINTRO22 = Wherigo.ZMedia(cartGC2C5FN)
zmediaINTRO22.Id = "c07d8c09-20ec-495a-bc15-c5776f53de95"
zmediaINTRO22.Name = _o9p("\116\067\071\076\105\034\034")
zmediaINTRO22.Description = _o9p("\126\112\078\106\058\125\025\116\059\068\099\108\106\025\035\008\023\052\078\087")
zmediaINTRO22.AltText = ""
zmediaINTRO22.Resources = {
	{
		Type = "jpg", 
		Filename = "INTRO22.jpg", 
		Directives = {}
	}
}
zmediaINTRO4 = Wherigo.ZMedia(cartGC2C5FN)
zmediaINTRO4.Id = "20d3723d-860f-4a56-9d48-83b57fa74452"
zmediaINTRO4.Name = _o9p("\116\067\071\076\105\118")
zmediaINTRO4.Description = _o9p("\126\112\078\106\058\125\025\116\059\068\099\108\106\025\035\008\023\052\078\087")
zmediaINTRO4.AltText = ""
zmediaINTRO4.Resources = {
	{
		Type = "jpg", 
		Filename = "INTRO4.jpg", 
		Directives = {}
	}
}
zmediaINTRO13 = Wherigo.ZMedia(cartGC2C5FN)
zmediaINTRO13.Id = "7e23ca99-5bb1-401a-b01b-b0cebf6de3b1"
zmediaINTRO13.Name = _o9p("\116\067\071\076\105\049\062")
zmediaINTRO13.Description = _o9p("\126\112\078\106\058\125\025\116\059\068\099\108\106\025\035\008\023\052\078\087")
zmediaINTRO13.AltText = ""
zmediaINTRO13.Resources = {
	{
		Type = "jpg", 
		Filename = "INTRO13.jpg", 
		Directives = {}
	}
}
zmediaINTRO16 = Wherigo.ZMedia(cartGC2C5FN)
zmediaINTRO16.Id = "3f312436-8b1e-4314-8363-7e19a3e6d68e"
zmediaINTRO16.Name = _o9p("\116\067\071\076\105\049\083")
zmediaINTRO16.Description = _o9p("\126\112\078\106\058\125\025\116\059\068\099\108\106\025\035\008\023\052\078\087")
zmediaINTRO16.AltText = ""
zmediaINTRO16.Resources = {
	{
		Type = "jpg", 
		Filename = "INTRO16.jpg", 
		Directives = {}
	}
}
zmediaINTRO8 = Wherigo.ZMedia(cartGC2C5FN)
zmediaINTRO8.Id = "17671964-4725-4dcb-a914-0a2966ce5d26"
zmediaINTRO8.Name = _o9p("\116\067\071\076\105\124")
zmediaINTRO8.Description = _o9p("\126\112\078\106\058\125\025\116\059\068\099\108\106\025\035\008\023\052\078\087")
zmediaINTRO8.AltText = ""
zmediaINTRO8.Resources = {
	{
		Type = "jpg", 
		Filename = "INTRO8.jpg", 
		Directives = {}
	}
}
zmediazSTRM2 = Wherigo.ZMedia(cartGC2C5FN)
zmediazSTRM2.Id = "995d5659-bc2a-4464-9dc1-f08132715585"
zmediazSTRM2.Name = _o9p("\065\036\071\076\035\034")
zmediazSTRM2.Description = _o9p("\036\106\108\008\078\059")
zmediazSTRM2.AltText = _o9p("\036\071\076\089\100\035")
zmediazSTRM2.Resources = {
	{
		Type = "jpg", 
		Filename = "zSTRM2.jpg", 
		Directives = {}
	}
}
zmediaINTRO17 = Wherigo.ZMedia(cartGC2C5FN)
zmediaINTRO17.Id = "e264cf50-c9c1-4043-9788-01f0fa0caa46"
zmediaINTRO17.Name = _o9p("\116\067\071\076\105\049\063")
zmediaINTRO17.Description = _o9p("\126\112\078\106\058\125\025\116\059\068\099\108\106\025\035\008\023\052\078\087")
zmediaINTRO17.AltText = ""
zmediaINTRO17.Resources = {
	{
		Type = "jpg", 
		Filename = "INTRO17.jpg", 
		Directives = {}
	}
}
zmediaicBED = Wherigo.ZMedia(cartGC2C5FN)
zmediaicBED.Id = "098e2726-6228-487a-b47c-9d3f9371068a"
zmediaicBED.Name = _o9p("\052\058\112\089\044")
zmediaicBED.Description = _o9p("\116\058\099\027\077\112\008\023")
zmediaicBED.AltText = _o9p("\116\032\105\067\077\112\089\044")
zmediaicBED.Resources = {
	{
		Type = "jpg", 
		Filename = "icBED.jpg", 
		Directives = {}
	}
}
zmediaEND1 = Wherigo.ZMedia(cartGC2C5FN)
zmediaEND1.Id = "9749d67b-5dd7-447a-aeca-b2ad8070bda2"
zmediaEND1.Name = _o9p("\089\067\044\049")
zmediaEND1.Description = ""
zmediaEND1.AltText = ""
zmediaEND1.Resources = {
	{
		Type = "jpg", 
		Filename = "END1.jpg", 
		Directives = {}
	}
}
zmediaEND2 = Wherigo.ZMedia(cartGC2C5FN)
zmediaEND2.Id = "553bc14e-73e5-422b-8157-e1ad354058e2"
zmediaEND2.Name = _o9p("\089\067\044\034")
zmediaEND2.Description = ""
zmediaEND2.AltText = ""
zmediaEND2.Resources = {
	{
		Type = "jpg", 
		Filename = "END2.jpg", 
		Directives = {}
	}
}
zmediaEND3 = Wherigo.ZMedia(cartGC2C5FN)
zmediaEND3.Id = "f5d5f593-f46b-495d-9fab-c88da05ec5ac"
zmediaEND3.Name = _o9p("\089\067\044\062")
zmediaEND3.Description = ""
zmediaEND3.AltText = ""
zmediaEND3.Resources = {
	{
		Type = "jpg", 
		Filename = "END3.jpg", 
		Directives = {}
	}
}
zmediaEND4 = Wherigo.ZMedia(cartGC2C5FN)
zmediaEND4.Id = "2a07e524-55f8-40d1-9267-646cfbc25244"
zmediaEND4.Name = _o9p("\089\067\044\118")
zmediaEND4.Description = ""
zmediaEND4.AltText = ""
zmediaEND4.Resources = {
	{
		Type = "jpg", 
		Filename = "END4.jpg", 
		Directives = {}
	}
}
zmediaEND5 = Wherigo.ZMedia(cartGC2C5FN)
zmediaEND5.Id = "aecaeb5f-8913-4c1c-8cd5-97ecb44e26bb"
zmediaEND5.Name = _o9p("\089\067\044\127")
zmediaEND5.Description = ""
zmediaEND5.AltText = ""
zmediaEND5.Resources = {
	{
		Type = "jpg", 
		Filename = "END5.jpg", 
		Directives = {}
	}
}
-- Cartridge Info --
cartGC2C5FN.Id="5ea8693a-3672-498b-ad0d-dd1a26dc546f"
cartGC2C5FN.Name="At the Edge of Madness - GC2C5FN"
cartGC2C5FN.Description=[[A Wherigo Adventure Geocache
If you experience ANY issues playing this cartridge, 
please contact us and we will do what we can to get it fixed ASAP.]]
cartGC2C5FN.Visible=true
cartGC2C5FN.Activity="Geocache"
cartGC2C5FN.StartingLocationDescription=[[Driving down the road...]]
cartGC2C5FN.StartingLocation = ZonePoint(35.0328785568566,-79.0352172903485,0)
cartGC2C5FN.Version="1.666"
cartGC2C5FN.Company="Jigsaw Developments"
cartGC2C5FN.Author="Steve Wilson (Waya) - waya@tumulu.us"
cartGC2C5FN.BuilderVersion="URWIGO 1.2.3718.30064"
cartGC2C5FN.CreateDate="08/16/2010 00:49:43"
cartGC2C5FN.PublishDate="1/1/0001 12:00:00 AM"
cartGC2C5FN.UpdateDate="11/02/2010 15:25:00"
cartGC2C5FN.LastPlayedDate="1/1/0001 12:00:00 AM"
cartGC2C5FN.TargetDevice="PocketPC"
cartGC2C5FN.TargetDeviceVersion="0"
cartGC2C5FN.StateId="1"
cartGC2C5FN.CountryId="2"
cartGC2C5FN.Complete=false
cartGC2C5FN.UseLogging=true

cartGC2C5FN.Icon=zmediaicC3


-- Zones --
zoneTheDrive = Wherigo.Zone(cartGC2C5FN)
zoneTheDrive.Id = "81896853-1381-4e4e-9881-702eee74b0b1"
zoneTheDrive.Name = _o9p("\071\125\008\025\044\108\052\013\008")
zoneTheDrive.Description = _o9p("\071\125\008\025\017\099\027\040\025\023\108\052\013\008\025\125\099\059\008\057\057\057")
zoneTheDrive.Visible = false
zoneTheDrive.Media = zmediazROAD
zoneTheDrive.Icon = zmediaicCAR
zoneTheDrive.Commands = {}
zoneTheDrive.DistanceRange = Distance(-1, "feet")
zoneTheDrive.ShowObjects = "OnProximity"
zoneTheDrive.ProximityRange = Distance(500, "feet")
zoneTheDrive.AllowSetPositionTo = false
zoneTheDrive.Active = false
zoneTheDrive.Points = {
	ZonePoint(35.0317472235779, -79.039555365572, 0), 
	ZonePoint(35.0314770801731, -79.0394588060474, 0), 
	ZonePoint(35.0311915617828, -79.0404834098911, 0), 
	ZonePoint(35.0314573135474, -79.0405638761616, 0)
}
zoneTheDrive.OriginalPoint = ZonePoint(35.03177, -79.03956, 0)
zoneTheDrive.DistanceRangeUOM = "Feet"
zoneTheDrive.ProximityRangeUOM = "Feet"
zoneTheDrive.OutOfRangeName = ""
zoneTheDrive.InRangeName = ""
zoneParkingSpot = Wherigo.Zone(cartGC2C5FN)
zoneParkingSpot.Id = "db4e32d3-c0c6-4113-ba0a-9978de24fb9f"
zoneParkingSpot.Name = _o9p("\096\078\108\024\052\027\040\025\036\068\099\106")
zoneParkingSpot.Description = _o9p("\035\078\108\024\008\023\025\030\125\008\108\008\025\111\099\016\025\096\078\108\024\008\023")
zoneParkingSpot.Visible = false
zoneParkingSpot.Media = zmediaitBROKENCAR1
zoneParkingSpot.Icon = zmediaicCAR
zoneParkingSpot.Commands = {}
zoneParkingSpot.DistanceRange = Distance(-1, "feet")
zoneParkingSpot.ShowObjects = "OnProximity"
zoneParkingSpot.ProximityRange = Distance(20, "feet")
zoneParkingSpot.AllowSetPositionTo = false
zoneParkingSpot.Active = false
zoneParkingSpot.Points = {
	ZonePoint(35.0182984635222, -79.0346698467887, 0), 
	ZonePoint(35.0182976397801, -79.0345501532114, 0), 
	ZonePoint(35.0182018110607, -79.0345498179352, 0), 
	ZonePoint(35.0182012618987, -79.0346698467887, 0)
}
zoneParkingSpot.OriginalPoint = ZonePoint(35.01825, -79.0346111111111, 0)
zoneParkingSpot.DistanceRangeUOM = "Feet"
zoneParkingSpot.ProximityRangeUOM = "Feet"
zoneParkingSpot.OutOfRangeName = ""
zoneParkingSpot.InRangeName = ""
zoneBoatRamp = Wherigo.Zone(cartGC2C5FN)
zoneBoatRamp.Id = "151d4687-fd92-4471-8b38-2a8ee8611d2c"
zoneBoatRamp.Name = _o9p("\112\099\078\106\025\076\078\059\068")
zoneBoatRamp.Description = _o9p("\100\025\085\099\078\106\025\108\078\059\068\025\008\078\012\008\012\025\052\106\012\025\030\078\111\025\052\027\106\099\025\106\125\008\025\030\078\106\008\108\012\025\099\033\025\107\078\024\008\025\076\052\059")
zoneBoatRamp.Visible = false
zoneBoatRamp.Media = zmediazLAKE
zoneBoatRamp.Icon = zmediaicBOAT
zoneBoatRamp.Commands = {}
zoneBoatRamp.DistanceRange = Distance(500, "feet")
zoneBoatRamp.ShowObjects = "OnProximity"
zoneBoatRamp.ProximityRange = Distance(20, "feet")
zoneBoatRamp.AllowSetPositionTo = false
zoneBoatRamp.Active = false
zoneBoatRamp.Points = {
	ZonePoint(35.0326838553557, -79.040179417162, 0), 
	ZonePoint(35.0326860516147, -79.0403993583012, 0), 
	ZonePoint(35.0328551633816, -79.0403993583012, 0), 
	ZonePoint(35.0328595558904, -79.040179417162, 0)
}
zoneBoatRamp.OriginalPoint = ZonePoint(35.0327777777778, -79.0402777777778, 0)
zoneBoatRamp.DistanceRangeUOM = "Feet"
zoneBoatRamp.ProximityRangeUOM = "Feet"
zoneBoatRamp.OutOfRangeName = ""
zoneBoatRamp.InRangeName = ""
zoneTrailhead = Wherigo.Zone(cartGC2C5FN)
zoneTrailhead.Id = "9c82813c-acf3-45e7-ab72-b12ada4fcb01"
zoneTrailhead.Name = _o9p("\071\108\078\052\017\125\008\078\023")
zoneTrailhead.Description = _o9p("\036\106\078\108\106\052\027\040\025\068\099\052\027\106\025\033\099\108\025\078\025\106\108\078\052\017\025\017\008\078\023\052\027\040\025\052\027\106\099\025\106\125\008\025\030\099\099\023\012\057\057\057")
zoneTrailhead.Visible = false
zoneTrailhead.Media = zmediazTRAIL1
zoneTrailhead.Icon = zmediaicGRASS
zoneTrailhead.Commands = {}
zoneTrailhead.DistanceRange = Distance(-1, "feet")
zoneTrailhead.ShowObjects = "OnProximity"
zoneTrailhead.ProximityRange = Distance(20, "feet")
zoneTrailhead.AllowSetPositionTo = false
zoneTrailhead.Active = false
zoneTrailhead.Points = {
	ZonePoint(35.0328434344797, -79.039779489584, 0), 
	ZonePoint(35.0328478269891, -79.039610510416, 0), 
	ZonePoint(35.0327314254104, -79.039605145998, 0), 
	ZonePoint(35.0327314254104, -79.039779489584, 0)
}
zoneTrailhead.OriginalPoint = ZonePoint(35.0328055555556, -79.0396944444444, 0)
zoneTrailhead.DistanceRangeUOM = "Feet"
zoneTrailhead.ProximityRangeUOM = "Feet"
zoneTrailhead.OutOfRangeName = ""
zoneTrailhead.InRangeName = ""
zoneFishingPier = Wherigo.Zone(cartGC2C5FN)
zoneFishingPier.Id = "9c8fa1f6-7cef-40cb-8c2b-db126d5d651b"
zoneFishingPier.Name = _o9p("\047\052\012\125\052\027\040\025\096\052\008\108")
zoneFishingPier.Description = _o9p("\100\025\033\052\012\125\052\027\040\025\068\052\008\108\025\008\055\106\008\027\023\012\025\099\016\106\025\099\013\008\108\025\106\125\008\025\012\125\099\108\008\017\052\027\008\025\099\033\025\107\078\024\008\025\076\052\059\057")
zoneFishingPier.Visible = false
zoneFishingPier.Media = zmediazLAKE
zoneFishingPier.Icon = zmediaicFISH
zoneFishingPier.Commands = {}
zoneFishingPier.DistanceRange = Distance(500, "feet")
zoneFishingPier.ShowObjects = "OnProximity"
zoneFishingPier.ProximityRange = Distance(20, "feet")
zoneFishingPier.AllowSetPositionTo = false
zoneFishingPier.Active = false
zoneFishingPier.Points = {
	ZonePoint(35.033091985649, -79.0402190957356, 0), 
	ZonePoint(35.0331666580495, -79.0399776969242, 0), 
	ZonePoint(35.0329646031613, -79.0399160061169, 0), 
	ZonePoint(35.0329140893611, -79.0400957141209, 0)
}
zoneFishingPier.OriginalPoint = ZonePoint(35.0330277777778, -79.0400277777778, 0)
zoneFishingPier.DistanceRangeUOM = "Feet"
zoneFishingPier.ProximityRangeUOM = "Feet"
zoneFishingPier.OutOfRangeName = ""
zoneFishingPier.InRangeName = ""
zoneBranch1 = Wherigo.Zone(cartGC2C5FN)
zoneBranch1.Id = "77da3c15-7d66-49c4-b7fe-dae45a286a1e"
zoneBranch1.Name = _o9p("\096\078\106\125\025\100\125\008\078\023")
zoneBranch1.Description = _o9p("\100\025\068\078\106\125\025\085\108\078\027\058\125\008\012\025\099\033\033\025\033\108\099\059\025\106\125\008\025\059\078\052\027\025\106\108\078\052\017\057\057\057")
zoneBranch1.Visible = false
zoneBranch1.Media = zmediazTRAIL2
zoneBranch1.Icon = zmediaicHIKE
zoneBranch1.Commands = {}
zoneBranch1.DistanceRange = Distance(-1, "feet")
zoneBranch1.ShowObjects = "OnProximity"
zoneBranch1.ProximityRange = Distance(20, "feet")
zoneBranch1.AllowSetPositionTo = false
zoneBranch1.Active = false
zoneBranch1.Points = {
	ZonePoint(35.0331296724467, -79.0386560932541, 0), 
	ZonePoint(35.033048411265, -79.0386668220902, 0), 
	ZonePoint(35.0330506075142, -79.0387472883606, 0), 
	ZonePoint(35.0331351630642, -79.0387459472561, 0)
}
zoneBranch1.OriginalPoint = ZonePoint(35.0330909635725, -79.0387040377402, 0)
zoneBranch1.DistanceRangeUOM = "Feet"
zoneBranch1.ProximityRangeUOM = "Feet"
zoneBranch1.OutOfRangeName = ""
zoneBranch1.InRangeName = ""
zoneBranch2 = Wherigo.Zone(cartGC2C5FN)
zoneBranch2.Id = "01a0b402-d86e-4ba1-96e1-c1f8e26ae4ec"
zoneBranch2.Name = _o9p("\096\078\106\125\025\100\125\008\078\023")
zoneBranch2.Description = _o9p("\100\025\068\078\106\125\025\085\108\078\027\058\125\008\012\025\099\033\033\025\033\108\099\059\025\106\125\008\025\059\078\052\027\025\106\108\078\052\017\057\057\057")
zoneBranch2.Visible = false
zoneBranch2.Media = zmediazTRAIL2
zoneBranch2.Icon = zmediaicHIKE
zoneBranch2.Commands = {}
zoneBranch2.DistanceRange = Distance(-1, "feet")
zoneBranch2.ShowObjects = "OnProximity"
zoneBranch2.ProximityRange = Distance(20, "feet")
zoneBranch2.AllowSetPositionTo = false
zoneBranch2.Active = false
zoneBranch2.Points = {
	ZonePoint(35.03933, -79.03567, 0), 
	ZonePoint(35.03933, -79.03555, 0), 
	ZonePoint(35.0392459607407, -79.0355496502971, 0), 
	ZonePoint(35.0392481568234, -79.0356730319118, 0)
}
zoneBranch2.OriginalPoint = ZonePoint(35.039288529391, -79.0356106705522, 0)
zoneBranch2.DistanceRangeUOM = "Feet"
zoneBranch2.ProximityRangeUOM = "Feet"
zoneBranch2.OutOfRangeName = ""
zoneBranch2.InRangeName = ""
zoneRuins1 = Wherigo.Zone(cartGC2C5FN)
zoneRuins1.Id = "20f904cb-e81e-4a7d-aa03-3f81e5122739"
zoneRuins1.Name = _o9p("\076\016\052\027\012")
zoneRuins1.Description = _o9p("\076\016\052\027\008\023\025\108\008\059\027\078\027\106\012\025\078\108\008\025\012\008\008\027\025\052\027\025\106\125\008\025\099\013\008\108\040\108\099\030\106\125\057\057\057")
zoneRuins1.Visible = false
zoneRuins1.Media = zmediazSTR1
zoneRuins1.Icon = zmediaicGRASS
zoneRuins1.Commands = {}
zoneRuins1.DistanceRange = Distance(300, "feet")
zoneRuins1.ShowObjects = "OnProximity"
zoneRuins1.ProximityRange = Distance(20, "feet")
zoneRuins1.AllowSetPositionTo = false
zoneRuins1.Active = false
zoneRuins1.Points = {
	ZonePoint(35.03352, -79.03834, 0), 
	ZonePoint(35.03352, -79.03822, 0), 
	ZonePoint(35.03342, -79.03822, 0), 
	ZonePoint(35.03342, -79.03834, 0)
}
zoneRuins1.OriginalPoint = ZonePoint(35.03347, -79.03828, 0)
zoneRuins1.DistanceRangeUOM = "Feet"
zoneRuins1.ProximityRangeUOM = "Feet"
zoneRuins1.OutOfRangeName = ""
zoneRuins1.InRangeName = ""
zoneShore1 = Wherigo.Zone(cartGC2C5FN)
zoneShore1.Id = "973be03d-7d7d-4fa1-bd70-18cf2cc87d74"
zoneShore1.Name = _o9p("\036\125\099\108\008\017\052\027\008")
zoneShore1.Description = _o9p("\071\125\008\025\012\125\099\108\008\017\052\027\008\025\099\033\025\107\078\024\008\025\076\052\059\025\058\078\027\025\085\008\025\012\008\008\027\025\033\108\099\059\025\125\008\108\008\057\057\057")
zoneShore1.Visible = false
zoneShore1.Media = zmediazSHORE1
zoneShore1.Icon = zmediaicGRASS
zoneShore1.Commands = {}
zoneShore1.DistanceRange = Distance(100, "feet")
zoneShore1.ShowObjects = "OnProximity"
zoneShore1.ProximityRange = Distance(20, "feet")
zoneShore1.AllowSetPositionTo = false
zoneShore1.Active = false
zoneShore1.Points = {
	ZonePoint(35.03422, -79.039, 0), 
	ZonePoint(35.03422, -79.03889, 0), 
	ZonePoint(35.03412, -79.03889, 0), 
	ZonePoint(35.03412, -79.039, 0)
}
zoneShore1.OriginalPoint = ZonePoint(35.03417, -79.038945, 0)
zoneShore1.DistanceRangeUOM = "Feet"
zoneShore1.ProximityRangeUOM = "Feet"
zoneShore1.OutOfRangeName = ""
zoneShore1.InRangeName = ""
zoneStream1 = Wherigo.Zone(cartGC2C5FN)
zoneStream1.Id = "58a93457-0cdf-4c04-895e-afe5c6728f84"
zoneStream1.Name = _o9p("\036\106\108\008\078\059")
zoneStream1.Description = _o9p("\100\025\012\106\108\008\078\059\025\058\016\106\012\025\052\106\012\025\030\078\111\025\078\058\108\099\012\012\025\106\125\008\025\068\078\106\125\025\099\027\025\052\106\012\025\030\078\111\025\106\099\025\106\125\008\025\017\078\024\008\057\057\057")
zoneStream1.Visible = false
zoneStream1.Media = zmediazSTRM1
zoneStream1.Icon = zmediaicRUN
zoneStream1.Commands = {}
zoneStream1.DistanceRange = Distance(500, "feet")
zoneStream1.ShowObjects = "OnProximity"
zoneStream1.ProximityRange = Distance(20, "feet")
zoneStream1.AllowSetPositionTo = false
zoneStream1.Active = false
zoneStream1.Points = {
	ZonePoint(35.03341, -79.03839, 0), 
	ZonePoint(35.03341, -79.03827, 0), 
	ZonePoint(35.03331, -79.03827, 0), 
	ZonePoint(35.03331, -79.03839, 0)
}
zoneStream1.OriginalPoint = ZonePoint(35.03336, -79.03833, 0)
zoneStream1.DistanceRangeUOM = "Feet"
zoneStream1.ProximityRangeUOM = "Feet"
zoneStream1.OutOfRangeName = ""
zoneStream1.InRangeName = ""
zoneRuins10 = Wherigo.Zone(cartGC2C5FN)
zoneRuins10.Id = "7d5311da-d9ae-4aa4-9b83-f1a01ee7617b"
zoneRuins10.Name = _o9p("\076\016\052\027\012")
zoneRuins10.Description = _o9p("\076\016\052\027\008\023\025\108\008\059\027\078\027\106\012\025\078\108\008\025\012\008\008\027\025\052\027\025\106\125\008\025\099\013\008\108\040\108\099\030\106\125\057\057\057")
zoneRuins10.Visible = false
zoneRuins10.Media = zmediazSTR1
zoneRuins10.Icon = zmediaicGRASS
zoneRuins10.Commands = {}
zoneRuins10.DistanceRange = Distance(200, "feet")
zoneRuins10.ShowObjects = "OnProximity"
zoneRuins10.ProximityRange = Distance(20, "feet")
zoneRuins10.AllowSetPositionTo = false
zoneRuins10.Active = false
zoneRuins10.Points = {
	ZonePoint(35.03819, -79.03784, 0), 
	ZonePoint(35.03819, -79.03772, 0), 
	ZonePoint(35.03809, -79.03772, 0), 
	ZonePoint(35.03809, -79.03784, 0)
}
zoneRuins10.OriginalPoint = ZonePoint(35.03814, -79.03778, 0)
zoneRuins10.DistanceRangeUOM = "Feet"
zoneRuins10.ProximityRangeUOM = "Feet"
zoneRuins10.OutOfRangeName = ""
zoneRuins10.InRangeName = ""
zoneRuins11 = Wherigo.Zone(cartGC2C5FN)
zoneRuins11.Id = "5fff8201-6d88-4a2f-956b-2d0f23f4e51a"
zoneRuins11.Name = _o9p("\076\016\052\027\012")
zoneRuins11.Description = _o9p("\076\016\052\027\008\023\025\108\008\059\027\078\027\106\012\025\078\108\008\025\012\008\008\027\025\052\027\025\106\125\008\025\099\013\008\108\040\108\099\030\106\125\057\057\057")
zoneRuins11.Visible = false
zoneRuins11.Media = zmediazSTR1
zoneRuins11.Icon = zmediaicGRASS
zoneRuins11.Commands = {}
zoneRuins11.DistanceRange = Distance(200, "feet")
zoneRuins11.ShowObjects = "OnProximity"
zoneRuins11.ProximityRange = Distance(20, "feet")
zoneRuins11.AllowSetPositionTo = false
zoneRuins11.Active = false
zoneRuins11.Points = {
	ZonePoint(35.03899, -79.03739, 0), 
	ZonePoint(35.03899, -79.03727, 0), 
	ZonePoint(35.0389, -79.03727, 0), 
	ZonePoint(35.0389, -79.03739, 0)
}
zoneRuins11.OriginalPoint = ZonePoint(35.038945, -79.03733, 0)
zoneRuins11.DistanceRangeUOM = "Feet"
zoneRuins11.ProximityRangeUOM = "Feet"
zoneRuins11.OutOfRangeName = ""
zoneRuins11.InRangeName = ""
zoneRuins12 = Wherigo.Zone(cartGC2C5FN)
zoneRuins12.Id = "c56743c2-d823-4179-a76c-ed6b2dc5acd2"
zoneRuins12.Name = _o9p("\076\016\052\027\012")
zoneRuins12.Description = _o9p("\076\016\052\027\008\023\025\108\008\059\027\078\027\106\012\025\078\108\008\025\012\008\008\027\025\052\027\025\106\125\008\025\099\013\008\108\040\108\099\030\106\125\057\057\057")
zoneRuins12.Visible = false
zoneRuins12.Media = zmediazSTR1
zoneRuins12.Icon = zmediaicGRASS
zoneRuins12.Commands = {}
zoneRuins12.DistanceRange = Distance(100, "feet")
zoneRuins12.ShowObjects = "OnProximity"
zoneRuins12.ProximityRange = Distance(20, "feet")
zoneRuins12.AllowSetPositionTo = false
zoneRuins12.Active = false
zoneRuins12.Points = {
	ZonePoint(35.03938, -79.03578, 0), 
	ZonePoint(35.03938, -79.03566, 0), 
	ZonePoint(35.03928, -79.03566, 0), 
	ZonePoint(35.03928, -79.03578, 0)
}
zoneRuins12.OriginalPoint = ZonePoint(35.03933, -79.03572, 0)
zoneRuins12.DistanceRangeUOM = "Feet"
zoneRuins12.ProximityRangeUOM = "Feet"
zoneRuins12.OutOfRangeName = ""
zoneRuins12.InRangeName = ""
zoneRuins2 = Wherigo.Zone(cartGC2C5FN)
zoneRuins2.Id = "a4bcebdc-1ce2-47ed-bb47-9717a4448690"
zoneRuins2.Name = _o9p("\076\016\052\027\012")
zoneRuins2.Description = _o9p("\076\016\052\027\008\023\025\108\008\059\027\078\027\106\012\025\078\108\008\025\012\008\008\027\025\052\027\025\106\125\008\025\099\013\008\108\040\108\099\030\106\125\057\057\057")
zoneRuins2.Visible = false
zoneRuins2.Media = zmediazSTR1
zoneRuins2.Icon = zmediaicGRASS
zoneRuins2.Commands = {}
zoneRuins2.DistanceRange = Distance(100, "feet")
zoneRuins2.ShowObjects = "OnProximity"
zoneRuins2.ProximityRange = Distance(20, "feet")
zoneRuins2.AllowSetPositionTo = false
zoneRuins2.Active = false
zoneRuins2.Points = {
	ZonePoint(35.03383, -79.03856, 0), 
	ZonePoint(35.03383, -79.03844, 0), 
	ZonePoint(35.03373, -79.03844, 0), 
	ZonePoint(35.03373, -79.03856, 0)
}
zoneRuins2.OriginalPoint = ZonePoint(35.03378, -79.0385, 0)
zoneRuins2.DistanceRangeUOM = "Feet"
zoneRuins2.ProximityRangeUOM = "Feet"
zoneRuins2.OutOfRangeName = ""
zoneRuins2.InRangeName = ""
zoneShore2 = Wherigo.Zone(cartGC2C5FN)
zoneShore2.Id = "6ddd72e3-af08-46ba-9aba-72b4c9afa8b1"
zoneShore2.Name = _o9p("\036\125\099\108\008\017\052\027\008")
zoneShore2.Description = _o9p("\071\125\008\025\012\125\099\108\008\017\052\027\008\025\099\033\025\107\078\024\008\025\076\052\059\025\058\078\027\025\085\008\025\012\008\008\027\025\033\108\099\059\025\125\008\108\008\057\057\057")
zoneShore2.Visible = false
zoneShore2.Media = zmediazSHORE2
zoneShore2.Icon = zmediaicGRASS
zoneShore2.Commands = {}
zoneShore2.DistanceRange = Distance(-1, "feet")
zoneShore2.ShowObjects = "OnProximity"
zoneShore2.ProximityRange = Distance(20, "feet")
zoneShore2.AllowSetPositionTo = false
zoneShore2.Active = false
zoneShore2.Points = {
	ZonePoint(35.03749, -79.0382, 0), 
	ZonePoint(35.03749, -79.03808, 0), 
	ZonePoint(35.0374, -79.03808, 0), 
	ZonePoint(35.0374, -79.0382, 0)
}
zoneShore2.OriginalPoint = ZonePoint(35.037445, -79.03814, 0)
zoneShore2.DistanceRangeUOM = "Feet"
zoneShore2.ProximityRangeUOM = "Feet"
zoneShore2.OutOfRangeName = ""
zoneShore2.InRangeName = ""
zoneStream2 = Wherigo.Zone(cartGC2C5FN)
zoneStream2.Id = "5b8873dc-6610-4e90-98e7-ed7265468c17"
zoneStream2.Name = _o9p("\036\106\108\008\078\059")
zoneStream2.Description = _o9p("\100\025\012\106\108\008\078\059\025\058\016\106\012\025\052\106\012\025\030\078\111\025\078\058\108\099\012\012\025\106\125\008\025\068\078\106\125\025\099\027\025\052\106\012\025\030\078\111\025\106\099\025\106\125\008\025\017\078\024\008\057\057\057")
zoneStream2.Visible = false
zoneStream2.Media = zmediazSTRM2
zoneStream2.Icon = zmediaicRUN
zoneStream2.Commands = {}
zoneStream2.DistanceRange = Distance(500, "feet")
zoneStream2.ShowObjects = "OnProximity"
zoneStream2.ProximityRange = Distance(20, "feet")
zoneStream2.AllowSetPositionTo = false
zoneStream2.Active = false
zoneStream2.Points = {
	ZonePoint(35.03591, -79.03734, 0), 
	ZonePoint(35.03591, -79.03722, 0), 
	ZonePoint(35.03581, -79.03722, 0), 
	ZonePoint(35.03581, -79.03734, 0)
}
zoneStream2.OriginalPoint = ZonePoint(35.03586, -79.03728, 0)
zoneStream2.DistanceRangeUOM = "Feet"
zoneStream2.ProximityRangeUOM = "Feet"
zoneStream2.OutOfRangeName = ""
zoneStream2.InRangeName = ""
zoneBranch3 = Wherigo.Zone(cartGC2C5FN)
zoneBranch3.Id = "aee312bc-9957-4174-b50b-7abb0b15888a"
zoneBranch3.Name = _o9p("\096\078\106\125\025\100\125\008\078\023")
zoneBranch3.Description = _o9p("\100\025\068\078\106\125\025\085\108\078\027\058\125\008\012\025\099\033\033\025\033\108\099\059\025\106\125\008\025\059\078\052\027\025\106\108\078\052\017\057\057\057")
zoneBranch3.Visible = false
zoneBranch3.Media = zmediazTRAIL3
zoneBranch3.Icon = zmediaicHIKE
zoneBranch3.Commands = {}
zoneBranch3.DistanceRange = Distance(-1, "feet")
zoneBranch3.ShowObjects = "OnProximity"
zoneBranch3.ProximityRange = Distance(20, "feet")
zoneBranch3.AllowSetPositionTo = false
zoneBranch3.Active = false
zoneBranch3.Points = {
	ZonePoint(35.0397672155055, -79.0355885276127, 0), 
	ZonePoint(35.0396705884266, -79.0355938920307, 0), 
	ZonePoint(35.0396683923553, -79.0356877693462, 0), 
	ZonePoint(35.0397672155055, -79.0356877693462, 0)
}
zoneBranch3.OriginalPoint = ZonePoint(35.0397183529482, -79.035639489584, 0)
zoneBranch3.DistanceRangeUOM = "Feet"
zoneBranch3.ProximityRangeUOM = "Feet"
zoneBranch3.OutOfRangeName = ""
zoneBranch3.InRangeName = ""
zoneRuins3 = Wherigo.Zone(cartGC2C5FN)
zoneRuins3.Id = "7f3390dd-2e45-416d-ab77-60746ab11dc0"
zoneRuins3.Name = _o9p("\076\016\052\027\012")
zoneRuins3.Description = _o9p("\076\016\052\027\008\023\025\108\008\059\027\078\027\106\012\025\078\108\008\025\012\008\008\027\025\052\027\025\106\125\008\025\099\013\008\108\040\108\099\030\106\125\057\057\057")
zoneRuins3.Visible = false
zoneRuins3.Media = zmediazSTR1
zoneRuins3.Icon = zmediaicGRASS
zoneRuins3.Commands = {}
zoneRuins3.DistanceRange = Distance(100, "feet")
zoneRuins3.ShowObjects = "OnProximity"
zoneRuins3.ProximityRange = Distance(20, "feet")
zoneRuins3.AllowSetPositionTo = false
zoneRuins3.Active = false
zoneRuins3.Points = {
	ZonePoint(35.03402, -79.03886, 0), 
	ZonePoint(35.03402, -79.03875, 0), 
	ZonePoint(35.03392, -79.03875, 0), 
	ZonePoint(35.03392, -79.03886, 0)
}
zoneRuins3.OriginalPoint = ZonePoint(35.03397, -79.038805, 0)
zoneRuins3.DistanceRangeUOM = "Feet"
zoneRuins3.ProximityRangeUOM = "Feet"
zoneRuins3.OutOfRangeName = ""
zoneRuins3.InRangeName = ""
zoneStream3 = Wherigo.Zone(cartGC2C5FN)
zoneStream3.Id = "46a10a56-3302-420c-87cc-d2fabacdf154"
zoneStream3.Name = _o9p("\036\106\108\008\078\059")
zoneStream3.Description = _o9p("\100\025\012\106\108\008\078\059\025\058\016\106\012\025\052\106\012\025\030\078\111\025\078\058\108\099\012\012\025\106\125\008\025\068\078\106\125\025\099\027\025\052\106\012\025\030\078\111\025\106\099\025\106\125\008\025\017\078\024\008\057\057\057")
zoneStream3.Visible = false
zoneStream3.Media = zmediazSTRM3
zoneStream3.Icon = zmediaicRUN
zoneStream3.Commands = {}
zoneStream3.DistanceRange = Distance(500, "feet")
zoneStream3.ShowObjects = "OnProximity"
zoneStream3.ProximityRange = Distance(20, "feet")
zoneStream3.AllowSetPositionTo = false
zoneStream3.Active = false
zoneStream3.Points = {
	ZonePoint(35.03935, -79.0357, 0), 
	ZonePoint(35.03935, -79.03558, 0), 
	ZonePoint(35.03926, -79.03558, 0), 
	ZonePoint(35.03926, -79.0357, 0)
}
zoneStream3.OriginalPoint = ZonePoint(35.039305, -79.03564, 0)
zoneStream3.DistanceRangeUOM = "Feet"
zoneStream3.ProximityRangeUOM = "Feet"
zoneStream3.OutOfRangeName = ""
zoneStream3.InRangeName = ""
zoneBranch4 = Wherigo.Zone(cartGC2C5FN)
zoneBranch4.Id = "4d754bc1-a93c-4e72-a153-f6d8c982ee06"
zoneBranch4.Name = _o9p("\071\108\078\052\017\025\112\108\078\027\058\125")
zoneBranch4.Description = _o9p("\096\078\106\125\012\025\085\108\078\027\058\125\025\099\033\033\025\033\108\099\059\025\106\125\008\025\059\078\052\027\025\106\108\078\052\017\057\057\057\025")
zoneBranch4.Visible = false
zoneBranch4.Media = zmediazTRAIL4
zoneBranch4.Icon = zmediaicHIKE
zoneBranch4.Commands = {
	InvestigatePaths = Wherigo.ZCommand{
		Text = _o9p("\116\027\013\008\012\106\052\040\078\106\008\025\096\078\106\125\012"), 
		CmdWith = false, 
		Enabled = false, 
		EmptyTargetListText = _o9p("\067\099\106\125\052\027\040\025\078\013\078\052\017\078\085\017\008")
	}
}
zoneBranch4.Commands.InvestigatePaths.Custom = true
zoneBranch4.Commands.InvestigatePaths.Id = "bd9ce710-2138-497d-9de8-d7e7c5f406ca"
zoneBranch4.Commands.InvestigatePaths.WorksWithAll = true
zoneBranch4.DistanceRange = Distance(-1, "feet")
zoneBranch4.ShowObjects = "OnProximity"
zoneBranch4.ProximityRange = Distance(20, "feet")
zoneBranch4.AllowSetPositionTo = false
zoneBranch4.Active = false
zoneBranch4.Points = {
	ZonePoint(35.04033, -79.03517, 0), 
	ZonePoint(35.04033, -79.03505, 0), 
	ZonePoint(35.04023, -79.03505, 0), 
	ZonePoint(35.04023, -79.03517, 0)
}
zoneBranch4.OriginalPoint = ZonePoint(35.04028, -79.03511, 0)
zoneBranch4.DistanceRangeUOM = "Feet"
zoneBranch4.ProximityRangeUOM = "Feet"
zoneBranch4.OutOfRangeName = ""
zoneBranch4.InRangeName = ""
zoneRuins4 = Wherigo.Zone(cartGC2C5FN)
zoneRuins4.Id = "e7736369-a320-4ac2-bd06-3253fde7b398"
zoneRuins4.Name = _o9p("\076\016\052\027\012")
zoneRuins4.Description = _o9p("\076\016\052\027\008\023\025\108\008\059\027\078\027\106\012\025\078\108\008\025\012\008\008\027\025\052\027\025\106\125\008\025\099\013\008\108\040\108\099\030\106\125\057\057\057")
zoneRuins4.Visible = false
zoneRuins4.Media = zmediazSTR1
zoneRuins4.Icon = zmediaicGRASS
zoneRuins4.Commands = {}
zoneRuins4.DistanceRange = Distance(200, "feet")
zoneRuins4.ShowObjects = "OnProximity"
zoneRuins4.ProximityRange = Distance(20, "feet")
zoneRuins4.AllowSetPositionTo = false
zoneRuins4.Active = false
zoneRuins4.Points = {
	ZonePoint(35.03472, -79.03925, 0), 
	ZonePoint(35.03472, -79.03914, 0), 
	ZonePoint(35.03462, -79.03914, 0), 
	ZonePoint(35.03462, -79.03925, 0)
}
zoneRuins4.OriginalPoint = ZonePoint(35.03467, -79.039195, 0)
zoneRuins4.DistanceRangeUOM = "Feet"
zoneRuins4.ProximityRangeUOM = "Feet"
zoneRuins4.OutOfRangeName = ""
zoneRuins4.InRangeName = ""
zoneRuins5 = Wherigo.Zone(cartGC2C5FN)
zoneRuins5.Id = "47fcb23e-99e5-47d3-b2c3-cc07646082aa"
zoneRuins5.Name = _o9p("\076\016\052\027\012")
zoneRuins5.Description = _o9p("\076\016\052\027\008\023\025\108\008\059\027\078\027\106\012\025\078\108\008\025\012\008\008\027\025\052\027\025\106\125\008\025\099\013\008\108\040\108\099\030\106\125\057\057\057")
zoneRuins5.Visible = false
zoneRuins5.Media = zmediazSTR1
zoneRuins5.Icon = zmediaicGRASS
zoneRuins5.Commands = {}
zoneRuins5.DistanceRange = Distance(300, "feet")
zoneRuins5.ShowObjects = "OnProximity"
zoneRuins5.ProximityRange = Distance(20, "feet")
zoneRuins5.AllowSetPositionTo = false
zoneRuins5.Active = false
zoneRuins5.Points = {
	ZonePoint(35.03566, -79.03861, 0), 
	ZonePoint(35.03566, -79.0385, 0), 
	ZonePoint(35.03556, -79.0385, 0), 
	ZonePoint(35.03556, -79.03861, 0)
}
zoneRuins5.OriginalPoint = ZonePoint(35.03561, -79.038555, 0)
zoneRuins5.DistanceRangeUOM = "Feet"
zoneRuins5.ProximityRangeUOM = "Feet"
zoneRuins5.OutOfRangeName = ""
zoneRuins5.InRangeName = ""
zoneRuins6 = Wherigo.Zone(cartGC2C5FN)
zoneRuins6.Id = "7bcb48ed-67b1-499e-a7ca-a196e729750c"
zoneRuins6.Name = _o9p("\076\016\052\027\012")
zoneRuins6.Description = _o9p("\076\016\052\027\008\023\025\108\008\059\027\078\027\106\012\025\078\108\008\025\012\008\008\027\025\052\027\025\106\125\008\025\099\013\008\108\040\108\099\030\106\125\057\057\057")
zoneRuins6.Visible = false
zoneRuins6.Media = zmediazSTR2
zoneRuins6.Icon = zmediaicGRASS
zoneRuins6.Commands = {}
zoneRuins6.DistanceRange = Distance(100, "feet")
zoneRuins6.ShowObjects = "OnProximity"
zoneRuins6.ProximityRange = Distance(20, "feet")
zoneRuins6.AllowSetPositionTo = false
zoneRuins6.Active = false
zoneRuins6.Points = {
	ZonePoint(35.03583, -79.03739, 0), 
	ZonePoint(35.03583, -79.03727, 0), 
	ZonePoint(35.03573, -79.03727, 0), 
	ZonePoint(35.03573, -79.03739, 0)
}
zoneRuins6.OriginalPoint = ZonePoint(35.03578, -79.03733, 0)
zoneRuins6.DistanceRangeUOM = "Feet"
zoneRuins6.ProximityRangeUOM = "Feet"
zoneRuins6.OutOfRangeName = ""
zoneRuins6.InRangeName = ""
zoneRuins7 = Wherigo.Zone(cartGC2C5FN)
zoneRuins7.Id = "a66d82d2-1505-4db4-b48f-0ca9474ca54a"
zoneRuins7.Name = _o9p("\076\016\052\027\012")
zoneRuins7.Description = _o9p("\076\016\052\027\008\023\025\108\008\059\027\078\027\106\012\025\078\108\008\025\012\008\008\027\025\052\027\025\106\125\008\025\099\013\008\108\040\108\099\030\106\125\057\057\057")
zoneRuins7.Visible = false
zoneRuins7.Media = zmediazSTR1
zoneRuins7.Icon = zmediaicGRASS
zoneRuins7.Commands = {}
zoneRuins7.DistanceRange = Distance(100, "feet")
zoneRuins7.ShowObjects = "OnProximity"
zoneRuins7.ProximityRange = Distance(20, "feet")
zoneRuins7.AllowSetPositionTo = false
zoneRuins7.Active = false
zoneRuins7.Points = {
	ZonePoint(35.03619, -79.03731, 0), 
	ZonePoint(35.03619, -79.03719, 0), 
	ZonePoint(35.03609, -79.03719, 0), 
	ZonePoint(35.03609, -79.03731, 0)
}
zoneRuins7.OriginalPoint = ZonePoint(35.03614, -79.03725, 0)
zoneRuins7.DistanceRangeUOM = "Feet"
zoneRuins7.ProximityRangeUOM = "Feet"
zoneRuins7.OutOfRangeName = ""
zoneRuins7.InRangeName = ""
zoneRuins8 = Wherigo.Zone(cartGC2C5FN)
zoneRuins8.Id = "bd94ac19-b31b-434d-b15f-04977c56f05d"
zoneRuins8.Name = _o9p("\076\016\052\027\012")
zoneRuins8.Description = _o9p("\076\016\052\027\008\023\025\108\008\059\027\078\027\106\012\025\078\108\008\025\012\008\008\027\025\052\027\025\106\125\008\025\099\013\008\108\040\108\099\030\106\125\057\057\057")
zoneRuins8.Visible = false
zoneRuins8.Media = zmediazSTR1
zoneRuins8.Icon = zmediaicGRASS
zoneRuins8.Commands = {}
zoneRuins8.DistanceRange = Distance(300, "feet")
zoneRuins8.ShowObjects = "OnProximity"
zoneRuins8.ProximityRange = Distance(20, "feet")
zoneRuins8.AllowSetPositionTo = false
zoneRuins8.Active = false
zoneRuins8.Points = {
	ZonePoint(35.03677, -79.03828, 0), 
	ZonePoint(35.03677, -79.03816, 0), 
	ZonePoint(35.03667, -79.03816, 0), 
	ZonePoint(35.03667, -79.03828, 0)
}
zoneRuins8.OriginalPoint = ZonePoint(35.03672, -79.03822, 0)
zoneRuins8.DistanceRangeUOM = "Feet"
zoneRuins8.ProximityRangeUOM = "Feet"
zoneRuins8.OutOfRangeName = ""
zoneRuins8.InRangeName = ""
zoneRuins9 = Wherigo.Zone(cartGC2C5FN)
zoneRuins9.Id = "c3b2b1dd-d23e-444e-9f8c-f6490120f94f"
zoneRuins9.Name = _o9p("\076\016\052\027\012")
zoneRuins9.Description = _o9p("\076\016\052\027\008\023\025\108\008\059\027\078\027\106\012\025\078\108\008\025\012\008\008\027\025\052\027\025\106\125\008\025\099\013\008\108\040\108\099\030\106\125\057\057\057")
zoneRuins9.Visible = false
zoneRuins9.Media = zmediazSTR1
zoneRuins9.Icon = zmediaicGRASS
zoneRuins9.Commands = {}
zoneRuins9.DistanceRange = Distance(100, "feet")
zoneRuins9.ShowObjects = "OnProximity"
zoneRuins9.ProximityRange = Distance(20, "feet")
zoneRuins9.AllowSetPositionTo = false
zoneRuins9.Active = false
zoneRuins9.Points = {
	ZonePoint(35.03744, -79.03817, 0), 
	ZonePoint(35.03744, -79.03805, 0), 
	ZonePoint(35.03734, -79.03805, 0), 
	ZonePoint(35.03734, -79.03817, 0)
}
zoneRuins9.OriginalPoint = ZonePoint(35.03739, -79.03811, 0)
zoneRuins9.DistanceRangeUOM = "Feet"
zoneRuins9.ProximityRangeUOM = "Feet"
zoneRuins9.OutOfRangeName = ""
zoneRuins9.InRangeName = ""
zoneMBS1 = Wherigo.Zone(cartGC2C5FN)
zoneMBS1.Id = "b9e52f2e-12b2-40cb-a714-42fca245b029"
zoneMBS1.Name = _o9p("\096\008\078\058\008\033\016\017\025\100\108\008\078")
zoneMBS1.Description = _o9p("\071\125\052\012\025\078\108\008\078\025\085\108\052\027\040\012\025\099\027\025\078\025\012\106\108\078\027\040\008\025\033\008\008\017\052\027\040\025\099\033\025\068\008\078\058\008\025\078\027\023\025\058\078\017\059\057\057\057")
zoneMBS1.Visible = false
zoneMBS1.Media = zmediaicYINYANG
zoneMBS1.Icon = zmediaicYINYANG
zoneMBS1.Commands = {
	LookAround = Wherigo.ZCommand{
		Text = _o9p("\107\099\099\024\025\100\108\099\016\027\023"), 
		CmdWith = false, 
		Enabled = false, 
		EmptyTargetListText = _o9p("\067\099\106\125\052\027\040\025\078\013\078\052\017\078\085\017\008")
	}, 
	LeaveitBe = Wherigo.ZCommand{
		Text = _o9p("\107\008\078\013\008\025\052\106\025\112\008"), 
		CmdWith = false, 
		Enabled = false, 
		EmptyTargetListText = _o9p("\067\099\106\125\052\027\040\025\078\013\078\052\017\078\085\017\008")
	}, 
	Exit = Wherigo.ZCommand{
		Text = _o9p("\089\055\052\106"), 
		CmdWith = false, 
		Enabled = false, 
		EmptyTargetListText = _o9p("\067\099\106\125\052\027\040\025\078\013\078\052\017\078\085\017\008")
	}
}
zoneMBS1.Commands.LookAround.Custom = true
zoneMBS1.Commands.LookAround.Id = "24a5c1a9-748e-4233-b76c-3f99fc057de6"
zoneMBS1.Commands.LookAround.WorksWithAll = true
zoneMBS1.Commands.LeaveitBe.Custom = true
zoneMBS1.Commands.LeaveitBe.Id = "5608c63c-a21f-4102-b08b-4396acc224ac"
zoneMBS1.Commands.LeaveitBe.WorksWithAll = true
zoneMBS1.Commands.Exit.Custom = true
zoneMBS1.Commands.Exit.Id = "709542c3-e4b5-41b5-bc8e-bed6e41bb1b1"
zoneMBS1.Commands.Exit.WorksWithAll = true
zoneMBS1.DistanceRange = Distance(100, "feet")
zoneMBS1.ShowObjects = "OnProximity"
zoneMBS1.ProximityRange = Distance(20, "feet")
zoneMBS1.AllowSetPositionTo = false
zoneMBS1.Active = false
zoneMBS1.Points = {
	ZonePoint(35.03705, -79.03814, 0), 
	ZonePoint(35.03705, -79.03802, 0), 
	ZonePoint(35.03695, -79.03802, 0), 
	ZonePoint(35.03695, -79.03814, 0)
}
zoneMBS1.OriginalPoint = ZonePoint(35.037, -79.03808, 0)
zoneMBS1.DistanceRangeUOM = "Feet"
zoneMBS1.ProximityRangeUOM = "Feet"
zoneMBS1.OutOfRangeName = ""
zoneMBS1.InRangeName = ""
zoneMBS2 = Wherigo.Zone(cartGC2C5FN)
zoneMBS2.Id = "e04ade67-4e95-4e4b-be09-cb5eff819d22"
zoneMBS2.Name = _o9p("\096\008\078\058\008\033\016\017\025\100\108\008\078")
zoneMBS2.Description = _o9p("\071\125\052\012\025\078\108\008\078\025\085\108\052\027\040\012\025\099\027\025\078\025\012\106\108\078\027\040\008\025\033\008\008\017\052\027\040\025\099\033\025\068\008\078\058\008\025\078\027\023\025\058\078\017\059\057\057\057")
zoneMBS2.Visible = false
zoneMBS2.Media = zmediaicYINYANG
zoneMBS2.Icon = zmediaicYINYANG
zoneMBS2.Commands = {
	LookAround = Wherigo.ZCommand{
		Text = _o9p("\107\099\099\024\025\100\108\099\016\027\023"), 
		CmdWith = false, 
		Enabled = false, 
		EmptyTargetListText = _o9p("\067\099\106\125\052\027\040\025\078\013\078\052\017\078\085\017\008")
	}, 
	LeaveitBe = Wherigo.ZCommand{
		Text = _o9p("\107\008\078\013\008\025\052\106\025\112\008"), 
		CmdWith = false, 
		Enabled = false, 
		EmptyTargetListText = _o9p("\067\099\106\125\052\027\040\025\078\013\078\052\017\078\085\017\008")
	}, 
	Exit = Wherigo.ZCommand{
		Text = _o9p("\089\055\052\106"), 
		CmdWith = false, 
		Enabled = false, 
		EmptyTargetListText = _o9p("\067\099\106\125\052\027\040\025\078\013\078\052\017\078\085\017\008")
	}
}
zoneMBS2.Commands.LookAround.Custom = true
zoneMBS2.Commands.LookAround.Id = "e9d6e074-2b53-467e-ab59-321c08bb7d61"
zoneMBS2.Commands.LookAround.WorksWithAll = true
zoneMBS2.Commands.LeaveitBe.Custom = true
zoneMBS2.Commands.LeaveitBe.Id = "c5c69d2e-75ea-4900-a38e-817ff4a53de1"
zoneMBS2.Commands.LeaveitBe.WorksWithAll = true
zoneMBS2.Commands.Exit.Custom = true
zoneMBS2.Commands.Exit.Id = "217119a3-1ff5-4aa3-9e9b-a05a0e49407d"
zoneMBS2.Commands.Exit.WorksWithAll = true
zoneMBS2.DistanceRange = Distance(200, "feet")
zoneMBS2.ShowObjects = "OnProximity"
zoneMBS2.ProximityRange = Distance(20, "feet")
zoneMBS2.AllowSetPositionTo = false
zoneMBS2.Active = false
zoneMBS2.Points = {
	ZonePoint(35.04066, -79.03609, 0), 
	ZonePoint(35.04066, -79.03597, 0), 
	ZonePoint(35.04056, -79.03597, 0), 
	ZonePoint(35.04056, -79.03609, 0)
}
zoneMBS2.OriginalPoint = ZonePoint(35.04061, -79.03603, 0)
zoneMBS2.DistanceRangeUOM = "Feet"
zoneMBS2.ProximityRangeUOM = "Feet"
zoneMBS2.OutOfRangeName = ""
zoneMBS2.InRangeName = ""
zoneHut = Wherigo.Zone(cartGC2C5FN)
zoneHut.Id = "36c83f29-cb80-4d44-a97b-0d984e134c26"
zoneHut.Name = _o9p("\112\016\052\017\023\052\027\040")
zoneHut.Description = _o9p("\097\099\016\025\012\008\008\025\078\025\012\106\108\078\027\040\008\025\023\052\017\078\068\052\023\078\106\008\023\025\085\016\052\017\023\052\027\040\025\085\008\033\099\108\008\025\111\099\016\057\057\057")
zoneHut.Visible = false
zoneHut.Media = zmediazHUT
zoneHut.Icon = zmediaicSEE
zoneHut.Commands = {}
zoneHut.DistanceRange = Distance(100, "feet")
zoneHut.ShowObjects = "OnProximity"
zoneHut.ProximityRange = Distance(20, "feet")
zoneHut.AllowSetPositionTo = false
zoneHut.Active = false
zoneHut.Points = {
	ZonePoint(35.0389947054469, -79.0368510785389, 0), 
	ZonePoint(35.0389947054469, -79.036679417162, 0), 
	ZonePoint(35.0388717243457, -79.036687463789, 0), 
	ZonePoint(35.0388717243457, -79.0368564429569, 0)
}
zoneHut.OriginalPoint = ZonePoint(35.0389332148963, -79.0367686006117, 0)
zoneHut.DistanceRangeUOM = "Feet"
zoneHut.ProximityRangeUOM = "Feet"
zoneHut.OutOfRangeName = ""
zoneHut.InRangeName = ""
zoneHeap = Wherigo.Zone(cartGC2C5FN)
zoneHeap.Id = "e7a5961f-784e-428b-a7ab-30461ac130a0"
zoneHeap.Name = _o9p("\117\008\078\068")
zoneHeap.Description = _o9p("\097\099\016\025\012\008\008\025\099\085\090\008\058\106\012\025\012\106\108\008\030\027\025\078\085\099\016\106\025\033\108\099\059\025\030\125\078\106\025\017\099\099\024\012\025\017\052\024\008\025\106\125\008\025\108\008\059\078\052\027\012\025\099\033\025\078\025\108\052\106\016\078\017\025\099\108\025\058\008\108\008\059\099\027\111\057\057\057")
zoneHeap.Visible = false
zoneHeap.Media = zmediaicSEE
zoneHeap.Icon = zmediaicSEE
zoneHeap.Commands = {
	_iZW = Wherigo.ZCommand{
		Text = _o9p("\036\008\078\108\058\125\025\099\085\090\008\058\106\012"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _o9p("\067\099\106\125\052\027\040\025\078\013\078\052\017\078\085\017\008")
	}, 
	_CXA = Wherigo.ZCommand{
		Text = _o9p("\107\008\078\013\008\025\052\106\025\085\008"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _o9p("\067\099\106\125\052\027\040\025\078\013\078\052\017\078\085\017\008")
	}
}
zoneHeap.Commands._iZW.Custom = true
zoneHeap.Commands._iZW.Id = "91476685-0a84-4622-a612-99444ce143b5"
zoneHeap.Commands._iZW.WorksWithAll = true
zoneHeap.Commands._CXA.Custom = true
zoneHeap.Commands._CXA.Id = "b450628d-cc30-4413-935d-76521296d627"
zoneHeap.Commands._CXA.WorksWithAll = true
zoneHeap.DistanceRange = Distance(100, "feet")
zoneHeap.ShowObjects = "OnProximity"
zoneHeap.ProximityRange = Distance(20, "feet")
zoneHeap.AllowSetPositionTo = false
zoneHeap.Active = false
zoneHeap.Points = {
	ZonePoint(35.03877, -79.03678, 0), 
	ZonePoint(35.03877, -79.03666, 0), 
	ZonePoint(35.03867, -79.03666, 0), 
	ZonePoint(35.03867, -79.03678, 0)
}
zoneHeap.OriginalPoint = ZonePoint(35.03872, -79.03672, 0)
zoneHeap.DistanceRangeUOM = "Feet"
zoneHeap.ProximityRangeUOM = "Feet"
zoneHeap.OutOfRangeName = ""
zoneHeap.InRangeName = ""
zoneEdge = Wherigo.Zone(cartGC2C5FN)
zoneEdge.Id = "8c3b3db9-c326-426e-b2cc-c6ed079214b5"
zoneEdge.Name = _o9p("\071\125\008\025\089\023\040\008")
zoneEdge.Description = _o9p("\071\125\008\025\068\078\106\125\025\078\027\023\025\106\108\008\008\012\025\099\068\008\027\025\016\068\025\085\008\033\099\108\008\025\111\099\016\025\106\099\025\078\027\025\008\027\099\108\059\099\016\012\025\089\023\040\008\025\099\033\025\058\017\008\078\108\008\023\025\106\108\008\008\012\057\057\057")
zoneEdge.Visible = false
zoneEdge.Media = zmediaicGRASS
zoneEdge.Icon = zmediaicGRASS
zoneEdge.Commands = {}
zoneEdge.DistanceRange = Distance(-1, "feet")
zoneEdge.ShowObjects = "OnProximity"
zoneEdge.ProximityRange = Distance(20, "feet")
zoneEdge.AllowSetPositionTo = false
zoneEdge.Active = false
zoneEdge.Points = {
	ZonePoint(35.04079, -79.03459, 0), 
	ZonePoint(35.04079, -79.03435, 0), 
	ZonePoint(35.0406, -79.03435, 0), 
	ZonePoint(35.0406, -79.03459, 0)
}
zoneEdge.OriginalPoint = ZonePoint(35.040695, -79.03447, 0)
zoneEdge.DistanceRangeUOM = "Feet"
zoneEdge.ProximityRangeUOM = "Feet"
zoneEdge.OutOfRangeName = ""
zoneEdge.InRangeName = ""
zoneMetalPillar = Wherigo.Zone(cartGC2C5FN)
zoneMetalPillar.Id = "77952027-0d94-4eba-8edc-5c985c646d0e"
zoneMetalPillar.Name = _o9p("\035\008\106\078\017\025\096\052\017\017\078\108")
zoneMetalPillar.Description = _o9p("\100\025\059\078\012\012\052\013\008\025\059\008\106\078\017\025\068\052\017\017\078\108\025\017\099\099\059\012\025\085\008\033\099\108\008\025\111\099\016\057\057\057")
zoneMetalPillar.Visible = false
zoneMetalPillar.Media = zmediaitMPILL
zoneMetalPillar.Icon = zmediaicSEE
zoneMetalPillar.Commands = {}
zoneMetalPillar.DistanceRange = Distance(-1, "feet")
zoneMetalPillar.ShowObjects = "OnProximity"
zoneMetalPillar.ProximityRange = Distance(20, "feet")
zoneMetalPillar.AllowSetPositionTo = false
zoneMetalPillar.Active = false
zoneMetalPillar.Points = {
	ZonePoint(35.0412436663038, -79.0342312392521, 0), 
	ZonePoint(35.0411294727164, -79.0342339214611, 0), 
	ZonePoint(35.0411272766843, -79.0343868073749, 0), 
	ZonePoint(35.0412480583617, -79.0343868073749, 0)
}
zoneMetalPillar.OriginalPoint = ZonePoint(35.0411871185166, -79.0343096938658, 0)
zoneMetalPillar.DistanceRangeUOM = "Feet"
zoneMetalPillar.ProximityRangeUOM = "Feet"
zoneMetalPillar.OutOfRangeName = ""
zoneMetalPillar.InRangeName = ""
zoneWoodPillar = Wherigo.Zone(cartGC2C5FN)
zoneWoodPillar.Id = "8446b092-dad3-42a0-8743-10d473719c1a"
zoneWoodPillar.Name = _o9p("\039\099\099\023\008\027\025\096\052\017\017\078\108")
zoneWoodPillar.Description = _o9p("\100\025\059\078\012\012\052\013\008\025\030\099\099\023\008\027\025\068\052\017\017\078\108\025\017\099\099\059\012\025\085\008\033\099\108\008\025\111\099\016\057\057\057")
zoneWoodPillar.Visible = false
zoneWoodPillar.Media = zmediaitWPILL
zoneWoodPillar.Icon = zmediaicSEE
zoneWoodPillar.Commands = {}
zoneWoodPillar.DistanceRange = Distance(-1, "feet")
zoneWoodPillar.ShowObjects = "OnProximity"
zoneWoodPillar.ProximityRange = Distance(20, "feet")
zoneWoodPillar.AllowSetPositionTo = false
zoneWoodPillar.Active = false
zoneWoodPillar.Points = {
	ZonePoint(35.0411624303224, -79.0341425070691, 0), 
	ZonePoint(35.0411624303224, -79.0339976677823, 0), 
	ZonePoint(35.0410564717494, -79.0340016910958, 0), 
	ZonePoint(35.0410581187749, -79.0341438481736, 0)
}
zoneWoodPillar.OriginalPoint = ZonePoint(35.0411098627923, -79.0340714285302, 0)
zoneWoodPillar.DistanceRangeUOM = "Feet"
zoneWoodPillar.ProximityRangeUOM = "Feet"
zoneWoodPillar.OutOfRangeName = ""
zoneWoodPillar.InRangeName = ""
zoneCeremony = Wherigo.Zone(cartGC2C5FN)
zoneCeremony.Id = "8d26538e-b418-49a3-9bcd-cd3b6b3908a1"
zoneCeremony.Name = _o9p("\032\008\108\008\059\099\027\111")
zoneCeremony.Description = _o9p("\100\025\023\078\108\024\046\025\106\030\052\012\106\008\023\025\058\008\108\008\059\099\027\111\025\052\012\025\085\008\052\027\040\025\068\108\008\068\078\108\008\023\025\085\008\033\099\108\008\025\111\099\016\057\057\057")
zoneCeremony.Visible = false
zoneCeremony.Media = zmediaitTORCH
zoneCeremony.Icon = zmediaicSKULL
zoneCeremony.Commands = {}
zoneCeremony.DistanceRange = Distance(-1, "feet")
zoneCeremony.ShowObjects = "Always"
zoneCeremony.ProximityRange = Distance(20, "feet")
zoneCeremony.AllowSetPositionTo = false
zoneCeremony.Active = false
zoneCeremony.Points = {
	ZonePoint(35.0413170752454, -79.0341804227018, 0), 
	ZonePoint(35.0413170752454, -79.034032901206, 0), 
	ZonePoint(35.0412149599252, -79.034038265624, 0), 
	ZonePoint(35.0412149599252, -79.0341817638063, 0)
}
zoneCeremony.OriginalPoint = ZonePoint(35.0412660175853, -79.0341083383345, 0)
zoneCeremony.DistanceRangeUOM = "Feet"
zoneCeremony.ProximityRangeUOM = "Feet"
zoneCeremony.OutOfRangeName = ""
zoneCeremony.InRangeName = ""
zoneStoneworks = Wherigo.Zone(cartGC2C5FN)
zoneStoneworks.Id = "52fb0f5d-7c69-4645-b6da-89010d2d0724"
zoneStoneworks.Name = _o9p("\036\106\099\027\008\030\099\108\024\012")
zoneStoneworks.Description = _o9p("\100\025\017\078\108\040\008\025\008\027\040\108\078\013\008\023\025\012\106\099\027\008\025\017\052\008\012\025\033\078\017\017\008\027\025\125\008\108\008\025\016\068\099\027\025\030\125\052\058\125\025\052\012\025\052\027\012\058\108\052\085\008\023\077\025\102\112\076\018\067\025\062\127\025\101\034\057\118\113\124\025\009\027\085\012\068\095\039\025\101\063\113\025\101\034\057\101\127\062")
zoneStoneworks.Visible = false
zoneStoneworks.Media = zmediaicCACHE
zoneStoneworks.Icon = zmediaicCACHE
zoneStoneworks.Commands = {}
zoneStoneworks.DistanceRange = Distance(-1, "feet")
zoneStoneworks.ShowObjects = "OnProximity"
zoneStoneworks.ProximityRange = Distance(20, "feet")
zoneStoneworks.AllowSetPositionTo = false
zoneStoneworks.Active = false
zoneStoneworks.Points = {
	ZonePoint(35.04174, -79.03434, 0), 
	ZonePoint(35.04174, -79.0341, 0), 
	ZonePoint(35.04154, -79.0341, 0), 
	ZonePoint(35.04154, -79.03434, 0)
}
zoneStoneworks.OriginalPoint = ZonePoint(35.04164, -79.03422, 0)
zoneStoneworks.DistanceRangeUOM = "Feet"
zoneStoneworks.ProximityRangeUOM = "Feet"
zoneStoneworks.OutOfRangeName = ""
zoneStoneworks.InRangeName = ""
zoneHutSide = Wherigo.Zone(cartGC2C5FN)
zoneHutSide.Id = "47680ee1-fb9a-44f6-8763-31908bb9dc46"
zoneHutSide.Name = _o9p("\036\099\059\008\106\125\052\027\040\025\052\027\025\106\125\008\025\030\099\099\023\012")
zoneHutSide.Description = _o9p("\036\099\059\008\106\125\052\027\040\025\085\052\040\025\078\027\023\025\023\078\108\024\025\052\027\025\106\125\008\025\030\099\099\023\012\025\099\033\033\025\106\125\008\025\068\078\106\125\025\058\078\106\058\125\008\012\025\111\099\016\108\025\008\111\008\057\057\057")
zoneHutSide.Visible = false
zoneHutSide.Media = zmediazTRAIL2
zoneHutSide.Icon = zmediaicSEE
zoneHutSide.Commands = {}
zoneHutSide.DistanceRange = Distance(100, "feet")
zoneHutSide.ShowObjects = "OnProximity"
zoneHutSide.ProximityRange = Distance(20, "feet")
zoneHutSide.AllowSetPositionTo = false
zoneHutSide.Active = false
zoneHutSide.Points = {
	ZonePoint(35.03916, -79.03692, 0), 
	ZonePoint(35.03916, -79.0368, 0), 
	ZonePoint(35.03906, -79.0368, 0), 
	ZonePoint(35.03906, -79.03692, 0)
}
zoneHutSide.OriginalPoint = ZonePoint(35.03911, -79.03686, 0)
zoneHutSide.DistanceRangeUOM = "Feet"
zoneHutSide.ProximityRangeUOM = "Feet"
zoneHutSide.OutOfRangeName = ""
zoneHutSide.InRangeName = ""
zoneSafeParking = Wherigo.Zone(cartGC2C5FN)
zoneSafeParking.Id = "b0561f22-e0cb-4e7b-b22e-30651f5a6590"
zoneSafeParking.Name = _o9p("\036\078\033\008\025\096\078\108\024\052\027\040")
zoneSafeParking.Description = _o9p("\036\078\033\008\025\096\078\108\024\052\027\040\025\068\017\078\058\008\025\027\008\078\108\025\107\078\024\008\025\076\052\059")
zoneSafeParking.Visible = false
zoneSafeParking.Media = zmediazLAKE
zoneSafeParking.Icon = zmediaicCAR
zoneSafeParking.Commands = {}
zoneSafeParking.DistanceRange = Distance(-1, "feet")
zoneSafeParking.ShowObjects = "OnProximity"
zoneSafeParking.ProximityRange = Distance(100, "feet")
zoneSafeParking.AllowSetPositionTo = false
zoneSafeParking.Active = false
zoneSafeParking.Points = {
	ZonePoint(35.0317409542731, -79.0399731484794, 0), 
	ZonePoint(35.0317387579887, -79.0402145472908, 0), 
	ZonePoint(35.0326655847679, -79.0402145472908, 0), 
	ZonePoint(35.0326633885083, -79.0395225373649, 0), 
	ZonePoint(35.0324261921279, -79.039530583992, 0)
}
zoneSafeParking.OriginalPoint = ZonePoint(35.0322469755332, -79.0398910728836, 0)
zoneSafeParking.DistanceRangeUOM = "Feet"
zoneSafeParking.ProximityRangeUOM = "Feet"
zoneSafeParking.OutOfRangeName = ""
zoneSafeParking.InRangeName = ""
zonePathOnwards = Wherigo.Zone(cartGC2C5FN)
zonePathOnwards.Id = "4d47fc5d-7b09-4f3d-8e65-620c82a1b09d"
zonePathOnwards.Name = _o9p("\096\078\106\125\025\105\027\030\078\108\023\012")
zonePathOnwards.Description = ""
zonePathOnwards.Visible = false
zonePathOnwards.Media = zmediaicGRASS
zonePathOnwards.Icon = zmediaicGRASS
zonePathOnwards.Commands = {}
zonePathOnwards.DistanceRange = Distance(200, "feet")
zonePathOnwards.ShowObjects = "OnProximity"
zonePathOnwards.ProximityRange = Distance(20, "feet")
zonePathOnwards.AllowSetPositionTo = false
zonePathOnwards.Active = false
zonePathOnwards.Points = {
	ZonePoint(35.0407957331264, -79.0356346753979, 0), 
	ZonePoint(35.0407979291674, -79.03546569623, 0), 
	ZonePoint(35.0406464021997, -79.03546569623, 0), 
	ZonePoint(35.0406464021997, -79.035645404234, 0)
}
zonePathOnwards.OriginalPoint = ZonePoint(35.0407216166733, -79.035552868023, 0)
zonePathOnwards.DistanceRangeUOM = "Feet"
zonePathOnwards.ProximityRangeUOM = "Feet"
zonePathOnwards.OutOfRangeName = ""
zonePathOnwards.InRangeName = ""
zoneSidePath3 = Wherigo.Zone(cartGC2C5FN)
zoneSidePath3.Id = "7185fbf3-6630-4496-b31f-9be384defb4f"
zoneSidePath3.Name = _o9p("\036\052\023\008\025\096\078\106\125")
zoneSidePath3.Description = _o9p("\100\025\096\078\106\125\025\085\108\078\027\058\125\008\012\025\099\033\033\025\033\108\099\059\025\106\125\008\025\059\078\052\027\025\106\108\078\052\017\057\057\057")
zoneSidePath3.Visible = false
zoneSidePath3.Media = zmediazSRD3
zoneSidePath3.Icon = zmediaicHIKE
zoneSidePath3.Commands = {}
zoneSidePath3.DistanceRange = Distance(100, "feet")
zoneSidePath3.ShowObjects = "OnProximity"
zoneSidePath3.ProximityRange = Distance(20, "feet")
zoneSidePath3.AllowSetPositionTo = false
zoneSidePath3.Active = false
zoneSidePath3.Points = {
	ZonePoint(35.0396705884265, -79.0355590233135, 0), 
	ZonePoint(35.0397606272992, -79.0355563411045, 0), 
	ZonePoint(35.0397606272992, -79.035457099371, 0), 
	ZonePoint(35.0396683923552, -79.035457099371, 0)
}
zoneSidePath3.OriginalPoint = ZonePoint(35.039715058845, -79.03550739079, 0)
zoneSidePath3.DistanceRangeUOM = "Feet"
zoneSidePath3.ProximityRangeUOM = "Feet"
zoneSidePath3.OutOfRangeName = ""
zoneSidePath3.InRangeName = ""
zoneSidePath1 = Wherigo.Zone(cartGC2C5FN)
zoneSidePath1.Id = "eb3a332b-dc9c-4420-8818-c5eda186b840"
zoneSidePath1.Name = _o9p("\036\052\023\008\025\096\078\106\125")
zoneSidePath1.Description = _o9p("\100\025\096\078\106\125\025\085\108\078\027\058\125\008\012\025\099\033\033\025\033\108\099\059\025\106\125\008\025\059\078\052\027\025\106\108\078\052\017\057\057\057")
zoneSidePath1.Visible = false
zoneSidePath1.Media = zmediazSRD1
zoneSidePath1.Icon = zmediaicHIKE
zoneSidePath1.Commands = {}
zoneSidePath1.DistanceRange = Distance(-1, "feet")
zoneSidePath1.ShowObjects = "OnProximity"
zoneSidePath1.ProximityRange = Distance(20, "feet")
zoneSidePath1.AllowSetPositionTo = false
zoneSidePath1.Active = false
zoneSidePath1.Points = {
	ZonePoint(35.0330330375188, -79.0387124196434, 0), 
	ZonePoint(35.0330879437419, -79.03864, 0), 
	ZonePoint(35.0330308412691, -79.0385890380287, 0), 
	ZonePoint(35.0329781312588, -79.0386587754631, 0)
}
zoneSidePath1.OriginalPoint = ZonePoint(35.0330324884471, -79.0386500582838, 0)
zoneSidePath1.DistanceRangeUOM = "Feet"
zoneSidePath1.ProximityRangeUOM = "Feet"
zoneSidePath1.OutOfRangeName = ""
zoneSidePath1.InRangeName = ""
zoneSidePath2 = Wherigo.Zone(cartGC2C5FN)
zoneSidePath2.Id = "feff0c44-1f01-4b4b-a7e5-f983bd316e1a"
zoneSidePath2.Name = _o9p("\036\052\023\008\025\096\078\106\125")
zoneSidePath2.Description = _o9p("\100\025\096\078\106\125\025\085\108\078\027\058\125\008\012\025\099\033\033\025\033\108\099\059\025\106\125\008\025\059\078\052\027\025\106\108\078\052\017\057\057\057")
zoneSidePath2.Visible = false
zoneSidePath2.Media = zmediazSRD2
zoneSidePath2.Icon = zmediaicHIKE
zoneSidePath2.Commands = {}
zoneSidePath2.DistanceRange = Distance(100, "feet")
zoneSidePath2.ShowObjects = "OnProximity"
zoneSidePath2.ProximityRange = Distance(20, "feet")
zoneSidePath2.AllowSetPositionTo = false
zoneSidePath2.Active = false
zoneSidePath2.Points = {
	ZonePoint(35.0392327842435, -79.0356247521496, 0), 
	ZonePoint(35.0392723137287, -79.035520145998, 0), 
	ZonePoint(35.0391976469073, -79.0354718662357, 0), 
	ZonePoint(35.039158117386, -79.0355925656414, 0)
}
zoneSidePath2.OriginalPoint = ZonePoint(35.0392152155664, -79.0355523325062, 0)
zoneSidePath2.DistanceRangeUOM = "Feet"
zoneSidePath2.ProximityRangeUOM = "Feet"
zoneSidePath2.OutOfRangeName = ""
zoneSidePath2.InRangeName = ""

-- Characters --
zcharacterCTHULHU = Wherigo.ZCharacter{
	Cartridge = cartGC2C5FN, 
	Container = zoneCeremony
}
zcharacterCTHULHU.Id = "f3a61d8f-8544-4b34-9e54-3290f1cfbfc8"
zcharacterCTHULHU.Name = _o9p("\032\071\117\050\107\117\050")
zcharacterCTHULHU.Description = _o9p("\032\106\125\016\017\125\016")
zcharacterCTHULHU.Visible = false
zcharacterCTHULHU.Media = zmediacRISEN1
zcharacterCTHULHU.Icon = zmediaicMONSTER
zcharacterCTHULHU.Commands = {
	WatchinFear = Wherigo.ZCommand{
		Text = _o9p("\039\078\106\058\125\025\052\027\025\047\008\078\108"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _o9p("\067\099\106\125\052\027\040\025\078\013\078\052\017\078\085\017\008")
	}
}
zcharacterCTHULHU.Commands.WatchinFear.Custom = true
zcharacterCTHULHU.Commands.WatchinFear.Id = "1068152c-2868-4f40-9a3c-30d2c0831361"
zcharacterCTHULHU.Commands.WatchinFear.WorksWithAll = true
zcharacterCTHULHU.ObjectLocation = Wherigo.INVALID_ZONEPOINT
zcharacterCTHULHU.Gender = "It"
zcharacterCTHULHU.Type = "NPC"
zcharacterHOODEDFIGURES = Wherigo.ZCharacter{
	Cartridge = cartGC2C5FN, 
	Container = zoneCeremony
}
zcharacterHOODEDFIGURES.Id = "79269a83-5a0f-47bc-98c0-f8c222dfaaf8"
zcharacterHOODEDFIGURES.Name = _o9p("\117\105\105\044\089\044\025\047\116\015\050\076\089\036")
zcharacterHOODEDFIGURES.Description = _o9p("\117\099\099\023\008\023\025\033\052\040\016\108\008\012\025\078\106\025\106\125\008\025\058\008\108\008\059\099\027\111")
zcharacterHOODEDFIGURES.Visible = false
zcharacterHOODEDFIGURES.Media = zmediacHOODS1
zcharacterHOODEDFIGURES.Icon = zmediaicSKULL
zcharacterHOODEDFIGURES.Commands = {}
zcharacterHOODEDFIGURES.ObjectLocation = Wherigo.INVALID_ZONEPOINT
zcharacterHOODEDFIGURES.Gender = "It"
zcharacterHOODEDFIGURES.Type = "NPC"
zcharacterNYARLATHOTEP = Wherigo.ZCharacter{
	Cartridge = cartGC2C5FN, 
	Container = zoneCeremony
}
zcharacterNYARLATHOTEP.Id = "60c350cf-5e08-4fc0-9c2d-d2a5ece8b40b"
zcharacterNYARLATHOTEP.Name = _o9p("\067\097\100\076\107\100\071\117\105\071\089\096")
zcharacterNYARLATHOTEP.Description = _o9p("\044\078\108\024\025\047\052\040\016\108\008")
zcharacterNYARLATHOTEP.Visible = false
zcharacterNYARLATHOTEP.Media = zmediacGIMME1
zcharacterNYARLATHOTEP.Icon = zmediaicMASK
zcharacterNYARLATHOTEP.Commands = {
	Conversate = Wherigo.ZCommand{
		Text = _o9p("\032\099\027\013\008\108\012\078\106\008"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _o9p("\067\099\106\125\052\027\040\025\078\013\078\052\017\078\085\017\008")
	}
}
zcharacterNYARLATHOTEP.Commands.Conversate.Custom = true
zcharacterNYARLATHOTEP.Commands.Conversate.Id = "e1f7723f-978c-4c13-8b2f-c82383eeee9a"
zcharacterNYARLATHOTEP.Commands.Conversate.WorksWithAll = true
zcharacterNYARLATHOTEP.ObjectLocation = Wherigo.INVALID_ZONEPOINT
zcharacterNYARLATHOTEP.Gender = "It"
zcharacterNYARLATHOTEP.Type = "NPC"

-- Items --
zitemGearPack = Wherigo.ZItem(cartGC2C5FN)
zitemGearPack.Id = "ff9548d3-adc4-44e8-9a00-d070f942746e"
zitemGearPack.Name = _o9p("\015\008\078\108\025\096\078\058\024")
zitemGearPack.Description = ""
zitemGearPack.Visible = true
zitemGearPack.Commands = {
	OpenUp = Wherigo.ZCommand{
		Text = _o9p("\105\068\008\027\025\050\068"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _o9p("\067\099\106\125\052\027\040\025\078\013\078\052\017\078\085\017\008")
	}, 
	EmptyOut = Wherigo.ZCommand{
		Text = _o9p("\089\059\068\106\111\025\105\016\106"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _o9p("\067\099\106\125\052\027\040\025\078\013\078\052\017\078\085\017\008")
	}, 
	CloseUp = Wherigo.ZCommand{
		Text = _o9p("\032\017\099\012\008\025\050\068"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _o9p("\067\099\106\125\052\027\040\025\078\013\078\052\017\078\085\017\008")
	}
}
zitemGearPack.Commands.OpenUp.Custom = true
zitemGearPack.Commands.OpenUp.Id = "a352c09d-b227-413f-8abe-49668e749aed"
zitemGearPack.Commands.OpenUp.WorksWithAll = true
zitemGearPack.Commands.EmptyOut.Custom = true
zitemGearPack.Commands.EmptyOut.Id = "930dd221-677f-4d66-856b-b95be1ed0a60"
zitemGearPack.Commands.EmptyOut.WorksWithAll = true
zitemGearPack.Commands.CloseUp.Custom = true
zitemGearPack.Commands.CloseUp.Id = "61585455-58d7-4bf9-b337-5048fdea6509"
zitemGearPack.Commands.CloseUp.WorksWithAll = true
zitemGearPack.ObjectLocation = Wherigo.INVALID_ZONEPOINT
zitemGearPack.Locked = false
zitemGearPack.Opened = false
zitemYourBrokenCar = Wherigo.ZItem(cartGC2C5FN)
zitemYourBrokenCar.Id = "4c30b438-41ae-4887-9db9-b800c346a19d"
zitemYourBrokenCar.Name = _o9p("\097\099\016\108\025\112\108\099\024\008\027\025\032\078\108")
zitemYourBrokenCar.Description = ""
zitemYourBrokenCar.Visible = true
zitemYourBrokenCar.Media = zmediaitBROKENCAR1
zitemYourBrokenCar.Icon = zmediaicCAR
zitemYourBrokenCar.Commands = {
	Leaveitbe = Wherigo.ZCommand{
		Text = _o9p("\107\008\078\013\008\025\052\106\025\085\008\057\057\057"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _o9p("\067\099\106\125\052\027\040\025\078\013\078\052\017\078\085\017\008")
	}, 
	Checkitout = Wherigo.ZCommand{
		Text = _o9p("\032\125\008\058\024\025\052\106\025\099\016\106\057\057\057"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _o9p("\067\099\106\125\052\027\040\025\078\013\078\052\017\078\085\017\008")
	}
}
zitemYourBrokenCar.Commands.Leaveitbe.Custom = true
zitemYourBrokenCar.Commands.Leaveitbe.Id = "ec683089-a4cc-4f35-8287-5f3ef355ec7d"
zitemYourBrokenCar.Commands.Leaveitbe.WorksWithAll = true
zitemYourBrokenCar.Commands.Checkitout.Custom = true
zitemYourBrokenCar.Commands.Checkitout.Id = "8e276291-9c3e-4438-aa94-5b4cda48fa2e"
zitemYourBrokenCar.Commands.Checkitout.WorksWithAll = true
zitemYourBrokenCar.ObjectLocation = Wherigo.INVALID_ZONEPOINT
zitemYourBrokenCar.Locked = false
zitemYourBrokenCar.Opened = true
zitemCell = Wherigo.ZItem(cartGC2C5FN)
zitemCell.Id = "d100b28f-8c5b-4aa2-8359-27504879f0ac"
zitemCell.Name = _o9p("\032\008\017\017")
zitemCell.Description = _o9p("\025\032\008\017\017\025\068\125\099\027\008")
zitemCell.Visible = true
zitemCell.Media = zmediaitCELL0
zitemCell.Icon = zmediaicCELL
zitemCell.Commands = {
	CheckBattery = Wherigo.ZCommand{
		Text = _o9p("\032\125\008\058\024\025\112\078\106\106\008\108\111\057\057\057"), 
		CmdWith = false, 
		Enabled = false, 
		EmptyTargetListText = _o9p("\067\099\106\125\052\027\040\025\078\013\078\052\017\078\085\017\008")
	}, 
	CheckPhotos = Wherigo.ZCommand{
		Text = _o9p("\096\125\099\106\099\012\057\057\057"), 
		CmdWith = false, 
		Enabled = false, 
		EmptyTargetListText = _o9p("\067\099\106\125\052\027\040\025\078\013\078\052\017\078\085\017\008")
	}, 
	CheckforService = Wherigo.ZCommand{
		Text = _o9p("\032\125\008\058\024\025\033\099\108\025\036\008\108\013\052\058\008\057\057\057"), 
		CmdWith = false, 
		Enabled = false, 
		EmptyTargetListText = _o9p("\067\099\106\125\052\027\040\025\078\013\078\052\017\078\085\017\008")
	}, 
	TurnOff = Wherigo.ZCommand{
		Text = _o9p("\071\016\108\027\025\105\033\033\057\057\057"), 
		CmdWith = false, 
		Enabled = false, 
		EmptyTargetListText = _o9p("\067\099\106\125\052\027\040\025\078\013\078\052\017\078\085\017\008")
	}, 
	Makesureitsworking = Wherigo.ZCommand{
		Text = _o9p("\035\078\024\008\025\012\016\108\008\025\052\106\045\012\025\030\099\108\024\052\027\040\057\057\057"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _o9p("\067\099\106\125\052\027\040\025\078\013\078\052\017\078\085\017\008")
	}, 
	_mJR = Wherigo.ZCommand{
		Text = _o9p("\096\016\106\025\052\027\025\096\078\058\024"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _o9p("\067\099\106\125\052\027\040\025\078\013\078\052\017\078\085\017\008")
	}, 
	_XpToy = Wherigo.ZCommand{
		Text = _o9p("\076\008\059\099\013\008\025\033\108\099\059\025\096\078\058\024"), 
		CmdWith = false, 
		Enabled = false, 
		EmptyTargetListText = _o9p("\067\099\106\125\052\027\040\025\078\013\078\052\017\078\085\017\008")
	}, 
	_W6m = Wherigo.ZCommand{
		Text = _o9p("\089\055\052\106"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _o9p("\067\099\106\125\052\027\040\025\078\013\078\052\017\078\085\017\008")
	}
}
zitemCell.Commands.CheckBattery.Custom = true
zitemCell.Commands.CheckBattery.Id = "be7009bd-31dc-4418-92cb-440a85b5250c"
zitemCell.Commands.CheckBattery.WorksWithAll = true
zitemCell.Commands.CheckPhotos.Custom = true
zitemCell.Commands.CheckPhotos.Id = "c1f33d13-4b50-49b7-81ec-6753ae538491"
zitemCell.Commands.CheckPhotos.WorksWithAll = true
zitemCell.Commands.CheckforService.Custom = true
zitemCell.Commands.CheckforService.Id = "f418c30d-deb4-412c-8df6-d2ba620c08b8"
zitemCell.Commands.CheckforService.WorksWithAll = true
zitemCell.Commands.TurnOff.Custom = true
zitemCell.Commands.TurnOff.Id = "f9f247f5-ad6d-4dd7-b44f-3b3579f2274a"
zitemCell.Commands.TurnOff.WorksWithAll = true
zitemCell.Commands.Makesureitsworking.Custom = true
zitemCell.Commands.Makesureitsworking.Id = "d9d496bc-7e73-4532-af61-8039f4914cc7"
zitemCell.Commands.Makesureitsworking.WorksWithAll = true
zitemCell.Commands._mJR.Custom = true
zitemCell.Commands._mJR.Id = "9c2e9179-1003-44b6-b625-e11d96865d95"
zitemCell.Commands._mJR.WorksWithAll = true
zitemCell.Commands._XpToy.Custom = true
zitemCell.Commands._XpToy.Id = "98b11676-bafa-4e4d-ae21-2cfbffd5124a"
zitemCell.Commands._XpToy.WorksWithAll = true
zitemCell.Commands._W6m.Custom = true
zitemCell.Commands._W6m.Id = "b7d1fc32-a0a6-4768-b2a4-4981c9240810"
zitemCell.Commands._W6m.WorksWithAll = true
zitemCell.ObjectLocation = Wherigo.INVALID_ZONEPOINT
zitemCell.Locked = false
zitemCell.Opened = false
zitemDrums = Wherigo.ZItem{
	Cartridge = cartGC2C5FN, 
	Container = zoneTrailhead
}
zitemDrums.Id = "6686be35-e0ec-4a5a-8f63-fcfe400be0fa"
zitemDrums.Name = _o9p("\044\108\016\059\012")
zitemDrums.Description = _o9p("\025\100\025\068\078\052\108\025\099\033\025\023\052\012\058\078\108\023\008\023\025\106\108\052\085\078\017\025\023\108\016\059\012")
zitemDrums.Visible = false
zitemDrums.Media = zmediaitDRUMS0
zitemDrums.Icon = zmediaicDRUMS
zitemDrums.Commands = {
	_qYjb = Wherigo.ZCommand{
		Text = _o9p("\096\016\106\025\052\027\025\096\078\058\024"), 
		CmdWith = false, 
		Enabled = false, 
		EmptyTargetListText = _o9p("\067\099\106\125\052\027\040\025\078\013\078\052\017\078\085\017\008")
	}, 
	_kSg = Wherigo.ZCommand{
		Text = _o9p("\076\008\059\099\013\008\025\033\108\099\059\025\096\078\058\024"), 
		CmdWith = false, 
		Enabled = false, 
		EmptyTargetListText = _o9p("\067\099\106\125\052\027\040\025\078\013\078\052\017\078\085\017\008")
	}, 
	_QNwA = Wherigo.ZCommand{
		Text = _o9p("\107\008\078\013\008\025\052\106\025\085\008"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _o9p("\067\099\106\125\052\027\040\025\078\013\078\052\017\078\085\017\008")
	}, 
	_SMVlT = Wherigo.ZCommand{
		Text = _o9p("\071\078\024\008\025\052\106"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _o9p("\067\099\106\125\052\027\040\025\078\013\078\052\017\078\085\017\008")
	}, 
	_Yumwa = Wherigo.ZCommand{
		Text = _o9p("\089\055\052\106"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _o9p("\067\099\106\125\052\027\040\025\078\013\078\052\017\078\085\017\008")
	}
}
zitemDrums.Commands._qYjb.Custom = true
zitemDrums.Commands._qYjb.Id = "d272989d-1029-476c-afe4-e59504b064ef"
zitemDrums.Commands._qYjb.WorksWithAll = true
zitemDrums.Commands._kSg.Custom = true
zitemDrums.Commands._kSg.Id = "eac8244c-1609-43db-8d33-2d9fd93eb640"
zitemDrums.Commands._kSg.WorksWithAll = true
zitemDrums.Commands._QNwA.Custom = true
zitemDrums.Commands._QNwA.Id = "bc1efe04-72eb-4492-ba3a-96f03723379e"
zitemDrums.Commands._QNwA.WorksWithAll = true
zitemDrums.Commands._SMVlT.Custom = true
zitemDrums.Commands._SMVlT.Id = "9bb37077-bfa6-4935-8325-a40941897fc9"
zitemDrums.Commands._SMVlT.WorksWithAll = true
zitemDrums.Commands._Yumwa.Custom = true
zitemDrums.Commands._Yumwa.Id = "7009a222-1a4a-435a-8d47-6273c3bc567e"
zitemDrums.Commands._Yumwa.WorksWithAll = true
zitemDrums.ObjectLocation = Wherigo.INVALID_ZONEPOINT
zitemDrums.Locked = false
zitemDrums.Opened = false
zitemFeather = Wherigo.ZItem{
	Cartridge = cartGC2C5FN, 
	Container = zoneFishingPier
}
zitemFeather.Id = "5338200e-d20d-456c-9327-50cbf6c4d973"
zitemFeather.Name = _o9p("\047\008\078\106\125\008\108")
zitemFeather.Description = _o9p("\047\008\078\106\125\008\108\025\099\027\025\106\125\008\025\040\108\099\016\027\023")
zitemFeather.Visible = true
zitemFeather.Media = zmediaitFEATHER
zitemFeather.Icon = zmediaicBIRD
zitemFeather.Commands = {
	Leaveitbe = Wherigo.ZCommand{
		Text = _o9p("\107\008\078\013\008\025\052\106\025\085\008\057\057\057"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _o9p("\067\099\106\125\052\027\040\025\078\013\078\052\017\078\085\017\008")
	}, 
	Checkitout = Wherigo.ZCommand{
		Text = _o9p("\032\125\008\058\024\025\052\106\025\099\016\106\057\057\057"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _o9p("\067\099\106\125\052\027\040\025\078\013\078\052\017\078\085\017\008")
	}
}
zitemFeather.Commands.Leaveitbe.Custom = true
zitemFeather.Commands.Leaveitbe.Id = "43111a9b-fdec-401e-8d7d-fa134bbafa20"
zitemFeather.Commands.Leaveitbe.WorksWithAll = true
zitemFeather.Commands.Checkitout.Custom = true
zitemFeather.Commands.Checkitout.Id = "31708264-cc60-405a-bec4-73f32fdec98e"
zitemFeather.Commands.Checkitout.WorksWithAll = true
zitemFeather.ObjectLocation = ZonePoint(35.0330357707502, -79.0400436002751, 0)
zitemFeather.Locked = true
zitemFeather.Opened = false
zitemFlashlight = Wherigo.ZItem(cartGC2C5FN)
zitemFlashlight.Id = "c089aad7-c09e-4ae5-900a-6287aad8cd39"
zitemFlashlight.Name = _o9p("\047\017\078\012\125\017\052\040\125\106")
zitemFlashlight.Description = _o9p("\025\047\017\078\012\125\017\052\040\125\106")
zitemFlashlight.Visible = true
zitemFlashlight.Media = zmediaitFLASHLIGHT0
zitemFlashlight.Icon = zmediaicFLASHLIGHT
zitemFlashlight.Commands = {
	Makesureitsworking = Wherigo.ZCommand{
		Text = _o9p("\035\078\024\008\025\012\016\108\008\025\052\106\045\012\025\030\099\108\024\052\027\040\057\057\057"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _o9p("\067\099\106\125\052\027\040\025\078\013\078\052\017\078\085\017\008")
	}, 
	_zsNb = Wherigo.ZCommand{
		Text = _o9p("\096\016\106\025\052\027\025\096\078\058\024"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _o9p("\067\099\106\125\052\027\040\025\078\013\078\052\017\078\085\017\008")
	}, 
	_v5M = Wherigo.ZCommand{
		Text = _o9p("\076\008\059\099\013\008\025\033\108\099\059\025\096\078\058\024"), 
		CmdWith = false, 
		Enabled = false, 
		EmptyTargetListText = _o9p("\067\099\106\125\052\027\040\025\078\013\078\052\017\078\085\017\008")
	}, 
	TurnOff = Wherigo.ZCommand{
		Text = _o9p("\071\016\108\027\025\105\033\033\057\057\057"), 
		CmdWith = false, 
		Enabled = false, 
		EmptyTargetListText = _o9p("\067\099\106\125\052\027\040\025\078\013\078\052\017\078\085\017\008")
	}, 
	CheckBattery = Wherigo.ZCommand{
		Text = _o9p("\032\125\008\058\024\025\112\078\106\106\008\108\111\057\057\057"), 
		CmdWith = false, 
		Enabled = false, 
		EmptyTargetListText = _o9p("\067\099\106\125\052\027\040\025\078\013\078\052\017\078\085\017\008")
	}, 
	_0hBQ = Wherigo.ZCommand{
		Text = _o9p("\089\055\052\106"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _o9p("\067\099\106\125\052\027\040\025\078\013\078\052\017\078\085\017\008")
	}
}
zitemFlashlight.Commands.Makesureitsworking.Custom = true
zitemFlashlight.Commands.Makesureitsworking.Id = "166ed45c-df19-47dc-ad7f-8ead86cbd079"
zitemFlashlight.Commands.Makesureitsworking.WorksWithAll = true
zitemFlashlight.Commands._zsNb.Custom = true
zitemFlashlight.Commands._zsNb.Id = "952c372d-9763-4cf2-8a81-7eb59b609456"
zitemFlashlight.Commands._zsNb.WorksWithAll = true
zitemFlashlight.Commands._v5M.Custom = true
zitemFlashlight.Commands._v5M.Id = "5795258e-2e51-4971-928a-d461f7ec9260"
zitemFlashlight.Commands._v5M.WorksWithAll = true
zitemFlashlight.Commands.TurnOff.Custom = true
zitemFlashlight.Commands.TurnOff.Id = "9763aebf-9c10-48d8-b056-79ab62bf1d17"
zitemFlashlight.Commands.TurnOff.WorksWithAll = true
zitemFlashlight.Commands.CheckBattery.Custom = true
zitemFlashlight.Commands.CheckBattery.Id = "baf61c8a-5e15-4a85-8440-5cabcae72909"
zitemFlashlight.Commands.CheckBattery.WorksWithAll = true
zitemFlashlight.Commands._0hBQ.Custom = true
zitemFlashlight.Commands._0hBQ.Id = "c21e3669-5c4b-4c79-84d2-9183d937a624"
zitemFlashlight.Commands._0hBQ.WorksWithAll = true
zitemFlashlight.ObjectLocation = Wherigo.INVALID_ZONEPOINT
zitemFlashlight.Locked = false
zitemFlashlight.Opened = false
zitemGPS = Wherigo.ZItem(cartGC2C5FN)
zitemGPS.Id = "2ed099e2-fac9-4003-ab95-5c4e53151898"
zitemGPS.Name = _o9p("\015\096\036")
zitemGPS.Description = _o9p("\025\015\096\036")
zitemGPS.Visible = true
zitemGPS.Media = zmediaitGPS0
zitemGPS.Icon = zmediaicGPS
zitemGPS.Commands = {
	Makesureitsworking = Wherigo.ZCommand{
		Text = _o9p("\035\078\024\008\025\012\016\108\008\025\052\106\045\012\025\030\099\108\024\052\027\040\057\057\057"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _o9p("\067\099\106\125\052\027\040\025\078\013\078\052\017\078\085\017\008")
	}, 
	_Df0 = Wherigo.ZCommand{
		Text = _o9p("\096\016\106\025\052\027\025\096\078\058\024"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _o9p("\067\099\106\125\052\027\040\025\078\013\078\052\017\078\085\017\008")
	}, 
	_uA1 = Wherigo.ZCommand{
		Text = _o9p("\076\008\059\099\013\008\025\033\108\099\059\025\096\078\058\024"), 
		CmdWith = false, 
		Enabled = false, 
		EmptyTargetListText = _o9p("\067\099\106\125\052\027\040\025\078\013\078\052\017\078\085\017\008")
	}, 
	CheckBattery = Wherigo.ZCommand{
		Text = _o9p("\032\125\008\058\024\025\112\078\106\106\008\108\111\057\057\057"), 
		CmdWith = false, 
		Enabled = false, 
		EmptyTargetListText = _o9p("\067\099\106\125\052\027\040\025\078\013\078\052\017\078\085\017\008")
	}, 
	TurnOff = Wherigo.ZCommand{
		Text = _o9p("\071\016\108\027\025\105\033\033\057\057\057"), 
		CmdWith = false, 
		Enabled = false, 
		EmptyTargetListText = _o9p("\067\099\106\125\052\027\040\025\078\013\078\052\017\078\085\017\008")
	}, 
	CheckPosition = Wherigo.ZCommand{
		Text = _o9p("\032\125\008\058\024\025\096\099\012\052\106\052\099\027\057\057\057"), 
		CmdWith = false, 
		Enabled = false, 
		EmptyTargetListText = _o9p("\067\099\106\125\052\027\040\025\078\013\078\052\017\078\085\017\008")
	}, 
	_GXDKm = Wherigo.ZCommand{
		Text = _o9p("\089\055\052\106"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _o9p("\067\099\106\125\052\027\040\025\078\013\078\052\017\078\085\017\008")
	}
}
zitemGPS.Commands.Makesureitsworking.Custom = true
zitemGPS.Commands.Makesureitsworking.Id = "18022cd4-359b-4e69-ab9f-677e51ca6513"
zitemGPS.Commands.Makesureitsworking.WorksWithAll = true
zitemGPS.Commands._Df0.Custom = true
zitemGPS.Commands._Df0.Id = "be160657-ab1a-45c7-8b99-3279714fa2da"
zitemGPS.Commands._Df0.WorksWithAll = true
zitemGPS.Commands._uA1.Custom = true
zitemGPS.Commands._uA1.Id = "ac9f0165-f326-44aa-aebe-c922c17cd3c4"
zitemGPS.Commands._uA1.WorksWithAll = true
zitemGPS.Commands.CheckBattery.Custom = true
zitemGPS.Commands.CheckBattery.Id = "3226d9c2-216e-4320-a4e2-402b96c93230"
zitemGPS.Commands.CheckBattery.WorksWithAll = true
zitemGPS.Commands.TurnOff.Custom = true
zitemGPS.Commands.TurnOff.Id = "bad0ca82-d0df-43ac-88a5-ae990a4eb4ee"
zitemGPS.Commands.TurnOff.WorksWithAll = true
zitemGPS.Commands.CheckPosition.Custom = true
zitemGPS.Commands.CheckPosition.Id = "8db2b026-e10b-4ff7-95a7-58edb234eed3"
zitemGPS.Commands.CheckPosition.WorksWithAll = true
zitemGPS.Commands._GXDKm.Custom = true
zitemGPS.Commands._GXDKm.Id = "a5c46d64-9e56-4c44-98d6-8da743315b30"
zitemGPS.Commands._GXDKm.WorksWithAll = true
zitemGPS.ObjectLocation = Wherigo.INVALID_ZONEPOINT
zitemGPS.Locked = false
zitemGPS.Opened = false
zitemNotepad = Wherigo.ZItem(cartGC2C5FN)
zitemNotepad.Id = "1dca586d-1f60-4353-b5ef-df3a76113ebb"
zitemNotepad.Name = _o9p("\067\099\106\008\068\078\023")
zitemNotepad.Description = _o9p("\025\067\099\106\008\068\078\023")
zitemNotepad.Visible = true
zitemNotepad.Media = zmediaitNOTEPAD0
zitemNotepad.Icon = zmediaicNOTE
zitemNotepad.Commands = {
	Scribbleanote = Wherigo.ZCommand{
		Text = _o9p("\036\058\108\052\085\085\017\008\025\078\025\027\099\106\008\057\057\057"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _o9p("\067\099\106\125\052\027\040\025\078\013\078\052\017\078\085\017\008")
	}, 
	Readthenotepad = Wherigo.ZCommand{
		Text = _o9p("\076\008\078\023\025\106\125\008\025\027\099\106\008\068\078\023\057\057\057"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _o9p("\067\099\106\125\052\027\040\025\078\013\078\052\017\078\085\017\008")
	}, 
	_U7LY = Wherigo.ZCommand{
		Text = _o9p("\096\016\106\025\052\027\025\096\078\058\024"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _o9p("\067\099\106\125\052\027\040\025\078\013\078\052\017\078\085\017\008")
	}, 
	_KWA = Wherigo.ZCommand{
		Text = _o9p("\076\008\059\099\013\008\025\033\108\099\059\025\096\078\058\024"), 
		CmdWith = false, 
		Enabled = false, 
		EmptyTargetListText = _o9p("\067\099\106\125\052\027\040\025\078\013\078\052\017\078\085\017\008")
	}, 
	_KFsD = Wherigo.ZCommand{
		Text = _o9p("\089\055\052\106"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _o9p("\067\099\106\125\052\027\040\025\078\013\078\052\017\078\085\017\008")
	}
}
zitemNotepad.Commands.Scribbleanote.Custom = true
zitemNotepad.Commands.Scribbleanote.Id = "72f34f1c-b9c7-4390-94b7-ab666e0df6db"
zitemNotepad.Commands.Scribbleanote.WorksWithAll = true
zitemNotepad.Commands.Readthenotepad.Custom = true
zitemNotepad.Commands.Readthenotepad.Id = "17479dc0-87e1-4969-b768-a1d75da96a06"
zitemNotepad.Commands.Readthenotepad.WorksWithAll = true
zitemNotepad.Commands._U7LY.Custom = true
zitemNotepad.Commands._U7LY.Id = "ac750e3f-abd5-4b0f-9ea4-07c6634a8136"
zitemNotepad.Commands._U7LY.WorksWithAll = true
zitemNotepad.Commands._KWA.Custom = true
zitemNotepad.Commands._KWA.Id = "3d2ca1a6-3873-4eb7-ab0e-0aa346fe9402"
zitemNotepad.Commands._KWA.WorksWithAll = true
zitemNotepad.Commands._KFsD.Custom = true
zitemNotepad.Commands._KFsD.Id = "a575cbbf-923c-4534-a917-8a6cb7c7d6b6"
zitemNotepad.Commands._KFsD.WorksWithAll = true
zitemNotepad.ObjectLocation = Wherigo.INVALID_ZONEPOINT
zitemNotepad.Locked = false
zitemNotepad.Opened = false
zitemPawPrints = Wherigo.ZItem{
	Cartridge = cartGC2C5FN, 
	Container = zoneBoatRamp
}
zitemPawPrints.Id = "03b62bfb-cf64-4197-8feb-1278ebb5b284"
zitemPawPrints.Name = _o9p("\096\078\030\025\096\108\052\027\106\012")
zitemPawPrints.Description = _o9p("\096\078\030\068\108\052\027\106\012\025\099\027\025\106\125\008\025\040\108\099\016\027\023")
zitemPawPrints.Visible = true
zitemPawPrints.Media = zmediaitPAWPRINTS
zitemPawPrints.Icon = zmediaicPAW
zitemPawPrints.Commands = {
	Leaveitbe = Wherigo.ZCommand{
		Text = _o9p("\107\008\078\013\008\025\052\106\025\085\008\057\057\057"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _o9p("\067\099\106\125\052\027\040\025\078\013\078\052\017\078\085\017\008")
	}, 
	Checkitout = Wherigo.ZCommand{
		Text = _o9p("\032\125\008\058\024\025\052\106\025\099\016\106\057\057\057"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _o9p("\067\099\106\125\052\027\040\025\078\013\078\052\017\078\085\017\008")
	}
}
zitemPawPrints.Commands.Leaveitbe.Custom = true
zitemPawPrints.Commands.Leaveitbe.Id = "271695cd-bc59-420b-92df-c93b2980ffe2"
zitemPawPrints.Commands.Leaveitbe.WorksWithAll = true
zitemPawPrints.Commands.Checkitout.Custom = true
zitemPawPrints.Commands.Checkitout.Id = "85c4534a-ad07-4aec-a3ca-cbd1ab4ae7fc"
zitemPawPrints.Commands.Checkitout.WorksWithAll = true
zitemPawPrints.ObjectLocation = ZonePoint(35.0327873094296, -79.0402990397536, 0)
zitemPawPrints.Locked = true
zitemPawPrints.Opened = false
zitemStrangeStatue = Wherigo.ZItem{
	Cartridge = cartGC2C5FN, 
	Container = zoneHeap
}
zitemStrangeStatue.Id = "a82db7f0-81aa-4417-ae5d-b28f1b2e10f8"
zitemStrangeStatue.Name = _o9p("\036\106\108\078\027\040\008\025\036\106\078\106\016\008")
zitemStrangeStatue.Description = _o9p("\025\036\106\108\078\027\040\008\025\036\106\078\106\016\008")
zitemStrangeStatue.Visible = false
zitemStrangeStatue.Media = zmediaitSTATUE
zitemStrangeStatue.Icon = zmediaicSTATUE
zitemStrangeStatue.Commands = {
	_tUEtG = Wherigo.ZCommand{
		Text = _o9p("\096\016\106\025\052\027\025\096\078\058\024"), 
		CmdWith = false, 
		Enabled = false, 
		EmptyTargetListText = _o9p("\067\099\106\125\052\027\040\025\078\013\078\052\017\078\085\017\008")
	}, 
	_vTwm = Wherigo.ZCommand{
		Text = _o9p("\076\008\059\099\013\008\025\033\108\099\059\025\096\078\058\024"), 
		CmdWith = false, 
		Enabled = false, 
		EmptyTargetListText = _o9p("\067\099\106\125\052\027\040\025\078\013\078\052\017\078\085\017\008")
	}, 
	_LTI = Wherigo.ZCommand{
		Text = _o9p("\089\055\078\059\052\027\008\025\052\106"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _o9p("\067\099\106\125\052\027\040\025\078\013\078\052\017\078\085\017\008")
	}, 
	_2IMjF = Wherigo.ZCommand{
		Text = _o9p("\071\078\024\008\025\052\106"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _o9p("\067\099\106\125\052\027\040\025\078\013\078\052\017\078\085\017\008")
	}, 
	_NxuBg = Wherigo.ZCommand{
		Text = _o9p("\107\008\078\013\008\025\052\106\025\085\008"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _o9p("\067\099\106\125\052\027\040\025\078\013\078\052\017\078\085\017\008")
	}, 
	_cMyG = Wherigo.ZCommand{
		Text = _o9p("\089\055\052\106"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _o9p("\067\099\106\125\052\027\040\025\078\013\078\052\017\078\085\017\008")
	}
}
zitemStrangeStatue.Commands._tUEtG.Custom = true
zitemStrangeStatue.Commands._tUEtG.Id = "69e6ff47-6edc-49d5-a5bd-d6d3764f0c3c"
zitemStrangeStatue.Commands._tUEtG.WorksWithAll = true
zitemStrangeStatue.Commands._vTwm.Custom = true
zitemStrangeStatue.Commands._vTwm.Id = "4aaba8fb-b4f4-4a29-85c3-eb510bb64a85"
zitemStrangeStatue.Commands._vTwm.WorksWithAll = true
zitemStrangeStatue.Commands._LTI.Custom = true
zitemStrangeStatue.Commands._LTI.Id = "d91ef028-dfde-44d2-9092-4566295fe146"
zitemStrangeStatue.Commands._LTI.WorksWithAll = true
zitemStrangeStatue.Commands._2IMjF.Custom = true
zitemStrangeStatue.Commands._2IMjF.Id = "ece4dcb4-2c38-4100-b25b-e845202fdaa7"
zitemStrangeStatue.Commands._2IMjF.WorksWithAll = true
zitemStrangeStatue.Commands._NxuBg.Custom = true
zitemStrangeStatue.Commands._NxuBg.Id = "aa711cfc-48ae-471a-876d-1a8ac518d35f"
zitemStrangeStatue.Commands._NxuBg.WorksWithAll = true
zitemStrangeStatue.Commands._cMyG.Custom = true
zitemStrangeStatue.Commands._cMyG.Id = "8bc49baf-2cdd-443b-b8d0-28d1bd1df840"
zitemStrangeStatue.Commands._cMyG.WorksWithAll = true
zitemStrangeStatue.ObjectLocation = Wherigo.INVALID_ZONEPOINT
zitemStrangeStatue.Locked = false
zitemStrangeStatue.Opened = false
zitemMENU = Wherigo.ZItem(cartGC2C5FN)
zitemMENU.Id = "b638fa91-0bcb-4a2d-aa4c-a992cef5169b"
zitemMENU.Name = _o9p("\103\025\035\089\067\050\025\103")
zitemMENU.Description = _o9p("\025\015\078\059\008\025\116\027\033\099\046\025\116\027\012\106\108\016\058\106\052\099\027\012\025\078\027\023\025\013\078\108\052\099\016\012\025\105\068\106\052\099\027\012\057")
zitemMENU.Visible = true
zitemMENU.Icon = zmediaicNOTE
zitemMENU.Commands = {
	GotoMENU = Wherigo.ZCommand{
		Text = _o9p("\015\099\025\106\099\025\035\089\067\050"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _o9p("\067\099\106\125\052\027\040\025\078\013\078\052\017\078\085\017\008")
	}, 
	_8aJ = Wherigo.ZCommand{
		Text = _o9p("\089\055\052\106"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _o9p("\067\099\106\125\052\027\040\025\078\013\078\052\017\078\085\017\008")
	}
}
zitemMENU.Commands.GotoMENU.Custom = true
zitemMENU.Commands.GotoMENU.Id = "97572f31-f033-4836-a40d-a6046c3a9957"
zitemMENU.Commands.GotoMENU.WorksWithAll = true
zitemMENU.Commands._8aJ.Custom = true
zitemMENU.Commands._8aJ.Id = "d60c1baa-2002-488f-993c-190a35b8540c"
zitemMENU.Commands._8aJ.WorksWithAll = true
zitemMENU.ObjectLocation = Wherigo.INVALID_ZONEPOINT
zitemMENU.Locked = false
zitemMENU.Opened = true
zitemPP1 = Wherigo.ZItem{
	Cartridge = cartGC2C5FN, 
	Container = zitemCell
}
zitemPP1.Id = "b9b3383a-15bf-4c5f-bb2d-1e3d2a70e504"
zitemPP1.Name = _o9p("\096\125\099\106\099\025\036\017\099\106\025\049")
zitemPP1.Description = _o9p("\089\059\068\106\111\025\036\017\099\106")
zitemPP1.Visible = true
zitemPP1.Commands = {
	_skeUc = Wherigo.ZCommand{
		Text = _o9p("\067\008\055\106"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _o9p("\067\099\106\125\052\027\040\025\078\013\078\052\017\078\085\017\008")
	}, 
	_KzW = Wherigo.ZCommand{
		Text = _o9p("\044\008\017\008\106\008"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _o9p("\067\099\106\125\052\027\040\025\078\013\078\052\017\078\085\017\008")
	}, 
	_2oPN = Wherigo.ZCommand{
		Text = _o9p("\089\055\052\106"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _o9p("\067\099\106\125\052\027\040\025\078\013\078\052\017\078\085\017\008")
	}, 
	_5j9 = Wherigo.ZCommand{
		Text = _o9p("\032\125\078\027\040\008\025\067\099\106\008"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _o9p("\067\099\106\125\052\027\040\025\078\013\078\052\017\078\085\017\008")
	}
}
zitemPP1.Commands._skeUc.Custom = true
zitemPP1.Commands._skeUc.Id = "0e8ad30d-cf01-408b-b6bb-f5b087e192f1"
zitemPP1.Commands._skeUc.WorksWithAll = true
zitemPP1.Commands._KzW.Custom = true
zitemPP1.Commands._KzW.Id = "d54878ca-7585-42fd-ae00-4feaa518db08"
zitemPP1.Commands._KzW.WorksWithAll = true
zitemPP1.Commands._2oPN.Custom = true
zitemPP1.Commands._2oPN.Id = "51f0c3fd-c926-4469-b06c-9107861839d1"
zitemPP1.Commands._2oPN.WorksWithAll = true
zitemPP1.Commands._5j9.Custom = true
zitemPP1.Commands._5j9.Id = "7636298d-79f7-473a-8e47-107752cab90c"
zitemPP1.Commands._5j9.WorksWithAll = true
zitemPP1.ObjectLocation = Wherigo.INVALID_ZONEPOINT
zitemPP1.Locked = false
zitemPP1.Opened = false
zitemPP2 = Wherigo.ZItem{
	Cartridge = cartGC2C5FN, 
	Container = zitemCell
}
zitemPP2.Id = "bfaa992d-4d13-476d-aabd-8351f40e3ef1"
zitemPP2.Name = _o9p("\096\125\099\106\099\025\036\017\099\106\025\034")
zitemPP2.Description = _o9p("\089\059\068\106\111\025\036\017\099\106")
zitemPP2.Visible = true
zitemPP2.Commands = {
	_Qxk4A = Wherigo.ZCommand{
		Text = _o9p("\096\108\008\013"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _o9p("\067\099\106\125\052\027\040\025\078\013\078\052\017\078\085\017\008")
	}, 
	_sh9Qa = Wherigo.ZCommand{
		Text = _o9p("\067\008\055\106"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _o9p("\067\099\106\125\052\027\040\025\078\013\078\052\017\078\085\017\008")
	}, 
	_S0_J = Wherigo.ZCommand{
		Text = _o9p("\044\008\017\008\106\008"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _o9p("\067\099\106\125\052\027\040\025\078\013\078\052\017\078\085\017\008")
	}, 
	_IzD3 = Wherigo.ZCommand{
		Text = _o9p("\089\055\052\106"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _o9p("\067\099\106\125\052\027\040\025\078\013\078\052\017\078\085\017\008")
	}, 
	_9Ib = Wherigo.ZCommand{
		Text = _o9p("\032\125\078\027\040\008\025\067\099\106\008"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _o9p("\067\099\106\125\052\027\040\025\078\013\078\052\017\078\085\017\008")
	}
}
zitemPP2.Commands._Qxk4A.Custom = true
zitemPP2.Commands._Qxk4A.Id = "d41aa1f2-3aae-4889-89dd-f97df7751103"
zitemPP2.Commands._Qxk4A.WorksWithAll = true
zitemPP2.Commands._sh9Qa.Custom = true
zitemPP2.Commands._sh9Qa.Id = "3d09d4b1-6e89-4471-adad-93b14887f2f4"
zitemPP2.Commands._sh9Qa.WorksWithAll = true
zitemPP2.Commands._S0_J.Custom = true
zitemPP2.Commands._S0_J.Id = "dc89c279-a156-4491-8155-2876f320a86e"
zitemPP2.Commands._S0_J.WorksWithAll = true
zitemPP2.Commands._IzD3.Custom = true
zitemPP2.Commands._IzD3.Id = "df9f2409-749d-42e4-ac50-cb641befed4f"
zitemPP2.Commands._IzD3.WorksWithAll = true
zitemPP2.Commands._9Ib.Custom = true
zitemPP2.Commands._9Ib.Id = "b951bacb-3bbf-487e-bc4e-de22d9045ce7"
zitemPP2.Commands._9Ib.WorksWithAll = true
zitemPP2.ObjectLocation = Wherigo.INVALID_ZONEPOINT
zitemPP2.Locked = false
zitemPP2.Opened = false
zitemPP3 = Wherigo.ZItem{
	Cartridge = cartGC2C5FN, 
	Container = zitemCell
}
zitemPP3.Id = "3b4f0551-4c72-4715-88d7-6d311dc4fab8"
zitemPP3.Name = _o9p("\096\125\099\106\099\025\036\017\099\106\025\062")
zitemPP3.Description = _o9p("\089\059\068\106\111\025\036\017\099\106")
zitemPP3.Visible = true
zitemPP3.Commands = {
	_ry0 = Wherigo.ZCommand{
		Text = _o9p("\096\108\008\013"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _o9p("\067\099\106\125\052\027\040\025\078\013\078\052\017\078\085\017\008")
	}, 
	_N4_e = Wherigo.ZCommand{
		Text = _o9p("\067\008\055\106"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _o9p("\067\099\106\125\052\027\040\025\078\013\078\052\017\078\085\017\008")
	}, 
	_AhrOW = Wherigo.ZCommand{
		Text = _o9p("\044\008\017\008\106\008"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _o9p("\067\099\106\125\052\027\040\025\078\013\078\052\017\078\085\017\008")
	}, 
	_5MTVW = Wherigo.ZCommand{
		Text = _o9p("\089\055\052\106"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _o9p("\067\099\106\125\052\027\040\025\078\013\078\052\017\078\085\017\008")
	}, 
	_pQe = Wherigo.ZCommand{
		Text = _o9p("\032\125\078\027\040\008\025\067\099\106\008"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _o9p("\067\099\106\125\052\027\040\025\078\013\078\052\017\078\085\017\008")
	}
}
zitemPP3.Commands._ry0.Custom = true
zitemPP3.Commands._ry0.Id = "162c7ffe-f905-4173-a330-1419df83b885"
zitemPP3.Commands._ry0.WorksWithAll = true
zitemPP3.Commands._N4_e.Custom = true
zitemPP3.Commands._N4_e.Id = "8c44d5d2-5ce5-4905-a473-a8cab79eb79d"
zitemPP3.Commands._N4_e.WorksWithAll = true
zitemPP3.Commands._AhrOW.Custom = true
zitemPP3.Commands._AhrOW.Id = "15740efa-6a86-4696-a21e-81a6784cb9c5"
zitemPP3.Commands._AhrOW.WorksWithAll = true
zitemPP3.Commands._5MTVW.Custom = true
zitemPP3.Commands._5MTVW.Id = "313ba623-d6fa-4a6e-91c3-89d4908f74b7"
zitemPP3.Commands._5MTVW.WorksWithAll = true
zitemPP3.Commands._pQe.Custom = true
zitemPP3.Commands._pQe.Id = "ad9833ac-ad67-44b4-93cb-3c9e1c3ede4d"
zitemPP3.Commands._pQe.WorksWithAll = true
zitemPP3.ObjectLocation = Wherigo.INVALID_ZONEPOINT
zitemPP3.Locked = false
zitemPP3.Opened = false
zitemPP4 = Wherigo.ZItem{
	Cartridge = cartGC2C5FN, 
	Container = zitemCell
}
zitemPP4.Id = "f65a9ef6-1410-49df-9fab-22d1ba6bd8de"
zitemPP4.Name = _o9p("\096\125\099\106\099\025\036\017\099\106\025\118")
zitemPP4.Description = _o9p("\089\059\068\106\111\025\036\017\099\106")
zitemPP4.Visible = true
zitemPP4.Commands = {
	_wUFf = Wherigo.ZCommand{
		Text = _o9p("\096\108\008\013"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _o9p("\067\099\106\125\052\027\040\025\078\013\078\052\017\078\085\017\008")
	}, 
	_zM3l = Wherigo.ZCommand{
		Text = _o9p("\067\008\055\106"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _o9p("\067\099\106\125\052\027\040\025\078\013\078\052\017\078\085\017\008")
	}, 
	_5iLdh = Wherigo.ZCommand{
		Text = _o9p("\044\008\017\008\106\008"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _o9p("\067\099\106\125\052\027\040\025\078\013\078\052\017\078\085\017\008")
	}, 
	_OfKB = Wherigo.ZCommand{
		Text = _o9p("\089\055\052\106"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _o9p("\067\099\106\125\052\027\040\025\078\013\078\052\017\078\085\017\008")
	}, 
	_5OT = Wherigo.ZCommand{
		Text = _o9p("\032\125\078\027\040\008\025\067\099\106\008"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _o9p("\067\099\106\125\052\027\040\025\078\013\078\052\017\078\085\017\008")
	}
}
zitemPP4.Commands._wUFf.Custom = true
zitemPP4.Commands._wUFf.Id = "81e2d71e-fe03-416d-9279-a6252f873b2c"
zitemPP4.Commands._wUFf.WorksWithAll = true
zitemPP4.Commands._zM3l.Custom = true
zitemPP4.Commands._zM3l.Id = "0430c497-534b-46a3-8fda-98881f7daa1e"
zitemPP4.Commands._zM3l.WorksWithAll = true
zitemPP4.Commands._5iLdh.Custom = true
zitemPP4.Commands._5iLdh.Id = "e7fd7f10-d944-4cb3-a601-8fdd1c5263be"
zitemPP4.Commands._5iLdh.WorksWithAll = true
zitemPP4.Commands._OfKB.Custom = true
zitemPP4.Commands._OfKB.Id = "7f8b7342-7b78-4009-add8-39b77843565a"
zitemPP4.Commands._OfKB.WorksWithAll = true
zitemPP4.Commands._5OT.Custom = true
zitemPP4.Commands._5OT.Id = "4c9a5789-d018-4abb-8046-248ecc61d586"
zitemPP4.Commands._5OT.WorksWithAll = true
zitemPP4.ObjectLocation = Wherigo.INVALID_ZONEPOINT
zitemPP4.Locked = false
zitemPP4.Opened = false
zitemPP5 = Wherigo.ZItem{
	Cartridge = cartGC2C5FN, 
	Container = zitemCell
}
zitemPP5.Id = "ca998b82-9906-4c51-86d6-5697666da165"
zitemPP5.Name = _o9p("\096\125\099\106\099\025\036\017\099\106\025\127")
zitemPP5.Description = _o9p("\089\059\068\106\111\025\036\017\099\106")
zitemPP5.Visible = true
zitemPP5.Commands = {
	_BpXpg = Wherigo.ZCommand{
		Text = _o9p("\096\108\008\013"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _o9p("\067\099\106\125\052\027\040\025\078\013\078\052\017\078\085\017\008")
	}, 
	_T6T = Wherigo.ZCommand{
		Text = _o9p("\044\008\017\008\106\008"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _o9p("\067\099\106\125\052\027\040\025\078\013\078\052\017\078\085\017\008")
	}, 
	_jE0 = Wherigo.ZCommand{
		Text = _o9p("\089\055\052\106"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _o9p("\067\099\106\125\052\027\040\025\078\013\078\052\017\078\085\017\008")
	}, 
	_aGA = Wherigo.ZCommand{
		Text = _o9p("\032\125\078\027\040\008\025\067\099\106\008"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _o9p("\067\099\106\125\052\027\040\025\078\013\078\052\017\078\085\017\008")
	}
}
zitemPP5.Commands._BpXpg.Custom = true
zitemPP5.Commands._BpXpg.Id = "5823a72f-8dc8-4c10-996f-ea1836f8bbc8"
zitemPP5.Commands._BpXpg.WorksWithAll = true
zitemPP5.Commands._T6T.Custom = true
zitemPP5.Commands._T6T.Id = "ed0a45ca-a6bf-4417-ae30-b879118f7b2f"
zitemPP5.Commands._T6T.WorksWithAll = true
zitemPP5.Commands._jE0.Custom = true
zitemPP5.Commands._jE0.Id = "f2299c62-40d2-48f7-a78b-32fcdf8a51a1"
zitemPP5.Commands._jE0.WorksWithAll = true
zitemPP5.Commands._aGA.Custom = true
zitemPP5.Commands._aGA.Id = "7ddf371c-7680-41d5-81cc-e4fdfffe83b2"
zitemPP5.Commands._aGA.WorksWithAll = true
zitemPP5.ObjectLocation = Wherigo.INVALID_ZONEPOINT
zitemPP5.Locked = false
zitemPP5.Opened = false

-- Tasks --
ztask1SANITY = Wherigo.ZTask(cartGC2C5FN)
ztask1SANITY.Id = "ff8c061e-2737-48c7-8996-29fa3b84edfb"
ztask1SANITY.Name = _o9p("\049\025\036\100\067\116\071\097")
ztask1SANITY.Description = ""
ztask1SANITY.Visible = true
ztask1SANITY.Icon = zmediaicCHECK
ztask1SANITY.Active = true
ztask1SANITY.Complete = false
ztask1SANITY.CorrectState = "Correct"
ztask2TIMER = Wherigo.ZTask(cartGC2C5FN)
ztask2TIMER.Id = "8e4ee839-2752-45ae-8cf2-59d8d2f912b7"
ztask2TIMER.Name = _o9p("\034\025\071\116\035\089\076")
ztask2TIMER.Description = ""
ztask2TIMER.Visible = true
ztask2TIMER.Icon = zmediaicTIME
ztask2TIMER.Active = true
ztask2TIMER.Complete = false
ztask2TIMER.CorrectState = "Correct"
ztask3LOCATION = Wherigo.ZTask(cartGC2C5FN)
ztask3LOCATION.Id = "48fb6af4-e658-4b34-ba78-d48f5d5e2962"
ztask3LOCATION.Name = _o9p("\062\025\107\105\032\100\071\116\105\067")
ztask3LOCATION.Description = _o9p("\103\103\103\103\103\103\103\103\103\103\103\103\103\103\103\103\103\103\103\103\103\103\103\103\103\103\103\103\103\103\103\103\103\103\103\103\103\103\103\103\103\103\103\103\103\103\103")
ztask3LOCATION.Visible = true
ztask3LOCATION.Icon = zmediaicCHECK
ztask3LOCATION.Active = true
ztask3LOCATION.Complete = false
ztask3LOCATION.CorrectState = "Correct"
ztask4LATITUDE = Wherigo.ZTask(cartGC2C5FN)
ztask4LATITUDE.Id = "e128f455-2a78-4589-b4b7-0bea700ef123"
ztask4LATITUDE.Name = _o9p("\118\025\107\100\071\116\071\050\044\089")
ztask4LATITUDE.Description = ""
ztask4LATITUDE.Visible = true
ztask4LATITUDE.Icon = zmediaicSEE
ztask4LATITUDE.Active = true
ztask4LATITUDE.Complete = false
ztask4LATITUDE.CorrectState = "Correct"
ztask5LONGITUDE = Wherigo.ZTask(cartGC2C5FN)
ztask5LONGITUDE.Id = "52d43208-1bd4-43e9-bcef-4988800ee927"
ztask5LONGITUDE.Name = _o9p("\127\025\107\105\067\015\116\071\050\044\089")
ztask5LONGITUDE.Description = ""
ztask5LONGITUDE.Visible = true
ztask5LONGITUDE.Icon = zmediaicSEE
ztask5LONGITUDE.Active = true
ztask5LONGITUDE.Complete = false
ztask5LONGITUDE.CorrectState = "Correct"

-- Cartridge Variables --
startLon = 0
AnimCount = 0
SuppScreen = _o9p("\089\067\100\112\107\089\044")
MMPSSEL = ""
StatPaw = true
dejavu = false
StatBar = _o9p("\089\067\100\112\107\089\044")
STUvar = 0
EventCar = 0
DevID = ""
SuppSound = _o9p("\089\067\100\112\107\089\044")
Photo1 = ""
Photo5 = ""
SuppOpenWIG = _o9p("\089\067\100\112\107\089\044")
MMOPTSEL = ""
MMADVOPTSEL = ""
PowerCell = 75
SanityLevel = 100
Photo2 = ""
SuppGarmin = _o9p("\044\116\036\100\112\107\089\044")
CheckCell = false
GameStart = false
TestVar = ""
CheckGPS = false
SuppPA = _o9p("\044\116\036\100\112\107\089\044")
CheckFlashlight = false
startLat = 0
PowerGPS = 75
SuppAndroid = _o9p("\089\067\100\112\107\089\044")
Photo4 = ""
setPark = false
SuppEmulator = _o9p("\089\067\100\112\107\089\044")
SuppPPC = _o9p("\089\067\100\112\107\089\044")
SuppStatTime = 1
StatFeather = true
MMMENUSEL = ""
NotePadEntry = ""
Photo3 = ""
PowerFlashlight = 75
AnimStop = 22
SuppApple = _o9p("\044\116\036\100\112\107\089\044")
_f2Wa = _o9p("\089\067\100\112\107\089\044")
DetNote = ""
CheckCar = false
Score = 0
ScoreCode = ""
SaveStateTimer = 0
MBS1Clue = 0
MBS2Clue = 0
IgnoreMe = false
CereAct = 0
RandEnc = false
cartGC2C5FN.ZVariables = {
	startLon = 0, 
	AnimCount = 0, 
	SuppScreen = _o9p("\089\067\100\112\107\089\044"), 
	MMPSSEL = "", 
	StatPaw = true, 
	dejavu = false, 
	StatBar = _o9p("\089\067\100\112\107\089\044"), 
	STUvar = 0, 
	EventCar = 0, 
	DevID = "", 
	SuppSound = _o9p("\089\067\100\112\107\089\044"), 
	Photo1 = "", 
	Photo5 = "", 
	SuppOpenWIG = _o9p("\089\067\100\112\107\089\044"), 
	MMOPTSEL = "", 
	MMADVOPTSEL = "", 
	PowerCell = 75, 
	SanityLevel = 100, 
	Photo2 = "", 
	SuppGarmin = _o9p("\044\116\036\100\112\107\089\044"), 
	CheckCell = false, 
	GameStart = false, 
	TestVar = "", 
	CheckGPS = false, 
	SuppPA = _o9p("\044\116\036\100\112\107\089\044"), 
	CheckFlashlight = false, 
	startLat = 0, 
	PowerGPS = 75, 
	SuppAndroid = _o9p("\089\067\100\112\107\089\044"), 
	Photo4 = "", 
	setPark = false, 
	SuppEmulator = _o9p("\089\067\100\112\107\089\044"), 
	SuppPPC = _o9p("\089\067\100\112\107\089\044"), 
	SuppStatTime = 1, 
	StatFeather = true, 
	MMMENUSEL = "", 
	NotePadEntry = "", 
	Photo3 = "", 
	PowerFlashlight = 75, 
	AnimStop = 22, 
	SuppApple = _o9p("\044\116\036\100\112\107\089\044"), 
	_f2Wa = _o9p("\089\067\100\112\107\089\044"), 
	DetNote = "", 
	CheckCar = false, 
	Score = 0, 
	ScoreCode = "", 
	SaveStateTimer = 0, 
	MBS1Clue = 0, 
	MBS2Clue = 0, 
	IgnoreMe = false, 
	CereAct = 0, 
	RandEnc = false
}

-- Timers --
ztimerDOOM = Wherigo.ZTimer(cartGC2C5FN)
ztimerDOOM.Id = "f8c89dca-7e90-4fb1-b7e6-eed61f5ebaaa"
ztimerDOOM.Name = _o9p("\044\105\105\035")
ztimerDOOM.Description = _o9p("\071\052\059\008\108\025\099\033\025\044\099\099\059\043")
ztimerDOOM.Visible = true
ztimerDOOM.Duration = 7200
ztimerDOOM.Type = "Countdown"
ztimerlilDOOM = Wherigo.ZTimer(cartGC2C5FN)
ztimerlilDOOM.Id = "96cf9711-356f-4400-9573-5c321577e7eb"
ztimerlilDOOM.Name = _o9p("\017\052\017\044\105\105\035")
ztimerlilDOOM.Description = _o9p("\017\052\017\025\071\052\059\008\108\025\099\033\025\044\099\099\059\043")
ztimerlilDOOM.Visible = true
ztimerlilDOOM.Duration = 1
ztimerlilDOOM.Type = "Countdown"
ztimerANIM = Wherigo.ZTimer(cartGC2C5FN)
ztimerANIM.Id = "11b22224-0b49-4326-a5c0-be7431d97855"
ztimerANIM.Name = _o9p("\100\067\116\035")
ztimerANIM.Description = ""
ztimerANIM.Visible = true
ztimerANIM.Duration = 1
ztimerANIM.Type = "Countdown"
ztimerSanity = Wherigo.ZTimer(cartGC2C5FN)
ztimerSanity.Id = "7356223e-d737-40e3-a856-729e499b0ad0"
ztimerSanity.Name = _o9p("\036\078\027\052\106\111\071\052\058\024")
ztimerSanity.Description = _o9p("\036\078\027\052\106\111\025\078\027\023\025\096\099\030\008\108\025\106\052\058\024")
ztimerSanity.Visible = true
ztimerSanity.Duration = 300
ztimerSanity.Type = "Interval"
ztimerSave = Wherigo.ZTimer(cartGC2C5FN)
ztimerSave.Id = "ef89a2af-5af5-4909-8647-adfa5a6a39ba"
ztimerSave.Name = _o9p("\036\078\013\008\071\052\059\008\108")
ztimerSave.Description = _o9p("\100\016\106\099\103\012\078\013\008\012")
ztimerSave.Visible = true
ztimerSave.Duration = 120
ztimerSave.Type = "Interval"
ztimerDrum = Wherigo.ZTimer(cartGC2C5FN)
ztimerDrum.Id = "42f1efb2-42d3-46b6-8e30-20d6ca7b5ba5"
ztimerDrum.Name = _o9p("\044\108\016\059\071\052\058\024")
ztimerDrum.Description = ""
ztimerDrum.Visible = true
ztimerDrum.Duration = 600
ztimerDrum.Type = "Interval"

-- Inputs --
zinputNotepadInput = Wherigo.ZInput(cartGC2C5FN)
zinputNotepadInput.Id = "61fa5d5a-bbcd-4680-bc87-1105d1733b5b"
zinputNotepadInput.Name = _o9p("\067\099\106\008\068\078\023\116\027\068\016\106")
zinputNotepadInput.Description = _o9p("\067\099\106\008\068\078\023\025\036\058\108\052\085\085\017\008")
zinputNotepadInput.Visible = true
zinputNotepadInput.InputType = "Text"
zinputNotepadInput.Text = ""
zinputMenuList = Wherigo.ZInput(cartGC2C5FN)
zinputMenuList.Id = "cf459745-815f-4975-9d7b-a4ccea35f40a"
zinputMenuList.Name = _o9p("\035\008\027\016\107\052\012\106")
zinputMenuList.Description = ""
zinputMenuList.Visible = true
zinputMenuList.Choices = {
	"Introduction", 
	"Instructions", 
	"ABOUT", 
	"OPTIONS", 
	"START"
}
zinputMenuList.InputType = "MultipleChoice"
zinputMenuList.Text = _o9p("\036\008\017\008\058\106\025\078\025\035\089\067\050\025\105\096\071\116\105\067\077")
zinputOptionsList = Wherigo.ZInput(cartGC2C5FN)
zinputOptionsList.Id = "2f591c31-8eb3-4611-89c2-6ac829163411"
zinputOptionsList.Name = _o9p("\105\068\106\052\099\027\012\107\052\012\106")
zinputOptionsList.Description = ""
zinputOptionsList.Visible = true
zinputOptionsList.Choices = {
	"SmartPhone Support", 
	"Garmin Support", 
	"PC Support", 
	"Advanced Options", 
	"Back to Menu"
}
zinputOptionsList.InputType = "MultipleChoice"
zinputOptionsList.Text = _o9p("\036\008\017\008\058\106\025\078\027\025\105\096\071\116\105\067\077")
zinputAdjustStatTime = Wherigo.ZInput(cartGC2C5FN)
zinputAdjustStatTime.Id = "e9909a57-3a31-4883-9c9f-e8a8d78559a0"
zinputAdjustStatTime.Name = _o9p("\100\023\090\016\012\106\036\106\078\106\071\052\059\008")
zinputAdjustStatTime.Description = ""
zinputAdjustStatTime.Visible = true
zinputAdjustStatTime.InputType = "Text"
zinputAdjustStatTime.Text = _o9p("\089\027\106\008\108\025\027\016\059\085\008\108\025\099\033\025\012\008\058\099\027\023\012\025\085\008\106\030\008\008\027\025\012\106\078\106\016\012\025\108\008\033\108\008\012\125\008\012\025\073\030\125\099\017\008\025\027\016\059\085\008\108\025\099\027\017\111\025\068\017\008\078\012\008\109")
zinputAdvOptList = Wherigo.ZInput(cartGC2C5FN)
zinputAdvOptList.Id = "1d06e6d2-1a85-4c9c-8606-5980ddb662a6"
zinputAdvOptList.Name = _o9p("\100\023\013\105\068\106\107\052\012\106")
zinputAdvOptList.Description = ""
zinputAdvOptList.Visible = true
zinputAdvOptList.Choices = {
	"Menu Support", 
	"Sound Support", 
	"Status Bar Support", 
	"Direct Screen Support", 
	"Status Update Timing", 
	"PlayAnywhere", 
	"Back to Options Menu"
}
zinputAdvOptList.InputType = "MultipleChoice"
zinputAdvOptList.Text = _o9p("\036\008\017\008\058\106\025\078\027\025\100\044\081\100\067\032\089\044\025\105\096\071\116\105\067\077\025")
zinputPhoneOptList = Wherigo.ZInput(cartGC2C5FN)
zinputPhoneOptList.Id = "fc1e56a8-81df-4889-af15-7f5f3be117bb"
zinputPhoneOptList.Name = _o9p("\096\125\099\027\008\105\068\106\107\052\012\106")
zinputPhoneOptList.Description = ""
zinputPhoneOptList.Visible = true
zinputPhoneOptList.Choices = {
	"Android Devices", 
	"OpenWIG (Java)", 
	"Windows Mobile (Touch)", 
	"I-Phone/Pad/Pod Touch", 
	"Back to Options Menu"
}
zinputPhoneOptList.InputType = "MultipleChoice"
zinputPhoneOptList.Text = _o9p("\116\033\025\111\099\016\025\125\078\013\008\025\078\025\039\125\008\108\052\040\099\025\068\017\078\111\008\108\025\108\016\027\027\052\027\040\025\099\027\025\111\099\016\108\025\023\008\013\052\058\008\046\025\012\008\017\008\058\106\025\106\125\008\025\078\068\068\017\052\058\078\085\017\008\025\068\017\078\111\008\108\025\012\016\068\068\099\108\106\077")
zinputGearPackList = Wherigo.ZInput(cartGC2C5FN)
zinputGearPackList.Id = "07ef6bd2-d605-408b-afe5-f60973a72708"
zinputGearPackList.Name = _o9p("\015\008\078\108\096\078\058\024\107\052\012\106")
zinputGearPackList.Description = ""
zinputGearPackList.Visible = true
zinputGearPackList.Choices = {
	"Cell", 
	"Drums", 
	"Flashlight", 
	"GPS", 
	"Notepad", 
	"Strange Statue", 
	"---EXIT---"
}
zinputGearPackList.InputType = "MultipleChoice"
zinputGearPackList.Text = _o9p("\036\008\017\008\058\106\025\116\106\008\059\077")
zinputMBS1Clue = Wherigo.ZInput(cartGC2C5FN)
zinputMBS1Clue.Id = "22c24ffb-5e0e-4aa6-9f6a-534fb2175133"
zinputMBS1Clue.Name = _o9p("\035\112\036\049\032\017\016\008")
zinputMBS1Clue.Description = ""
zinputMBS1Clue.Visible = true
zinputMBS1Clue.Media = zmediaicYINYANG
zinputMBS1Clue.Icon = zmediaicYINYANG
zinputMBS1Clue.InputType = "Text"
zinputMBS1Clue.Text = _o9p("\039\125\078\106\025\052\012\025\078\025\012\068\008\058\052\078\017\025\058\017\016\008\025\033\099\016\027\023\025\052\027\025\106\125\008\025\058\078\058\125\008\025\017\099\058\078\106\008\023\025\078\108\099\016\027\023\025\125\008\108\008\021")
zinputMBS2Clue = Wherigo.ZInput(cartGC2C5FN)
zinputMBS2Clue.Id = "d1c555ad-db5f-40a5-ac48-01b9a4adf440"
zinputMBS2Clue.Name = _o9p("\035\112\036\034\032\017\016\008")
zinputMBS2Clue.Description = ""
zinputMBS2Clue.Visible = true
zinputMBS2Clue.Media = zmediaicYINYANG
zinputMBS2Clue.Icon = zmediaicYINYANG
zinputMBS2Clue.InputType = "Text"
zinputMBS2Clue.Text = _o9p("\039\125\078\106\025\052\012\025\106\125\008\025\012\068\008\058\052\078\017\025\058\017\016\008\025\033\099\016\027\023\025\052\027\025\106\125\008\025\058\078\058\125\008\025\017\099\058\078\106\008\023\025\078\108\099\016\027\023\025\125\008\108\008\021")
zinputPathCheck = Wherigo.ZInput(cartGC2C5FN)
zinputPathCheck.Id = "a7dc231f-f189-4948-9adc-935ce0fc7047"
zinputPathCheck.Name = _o9p("\096\078\106\125\032\125\008\058\024")
zinputPathCheck.Description = ""
zinputPathCheck.Visible = true
zinputPathCheck.Media = zmediaicGRASS
zinputPathCheck.Icon = zmediaicGRASS
zinputPathCheck.Choices = {
	"Left Path", 
	"Hill Path", 
	"Right Path", 
	"Exit"
}
zinputPathCheck.InputType = "MultipleChoice"
zinputPathCheck.Text = _o9p("\039\125\052\058\125\025\068\078\106\125\025\023\099\025\111\099\016\025\030\078\027\106\025\106\099\025\052\027\013\008\012\106\052\040\078\106\008\021")
zinputPhonePics = Wherigo.ZInput(cartGC2C5FN)
zinputPhonePics.Id = "7b5c8ac2-b6c6-4dc0-a956-9bb77f8989b8"
zinputPhonePics.Name = _o9p("\096\125\099\027\008\096\052\058\012")
zinputPhonePics.Description = ""
zinputPhonePics.Visible = true
zinputPhonePics.Media = zmediaicCAM
zinputPhonePics.Icon = zmediaicCAM
zinputPhonePics.Choices = {
	"Take a Pic", 
	"Check Pics"
}
zinputPhonePics.InputType = "MultipleChoice"
zinputPhonePics.Text = _o9p("\039\125\078\106\025\023\099\025\111\099\016\025\030\078\027\106\025\106\099\025\023\099\025\030\052\106\125\025\111\099\016\108\025\068\125\099\027\008\045\012\025\058\078\059\008\108\078\021")
zinputNotePP1 = Wherigo.ZInput(cartGC2C5FN)
zinputNotePP1.Id = "b3ac0b22-c2ad-41be-a5de-1044d8cce522"
zinputNotePP1.Name = _o9p("\067\099\106\008\096\096\049")
zinputNotePP1.Description = ""
zinputNotePP1.Visible = true
zinputNotePP1.InputType = "Text"
zinputNotePP1.Text = _o9p("\116\027\068\016\106\025\078\025\027\008\030\025\023\008\012\058\108\052\068\106\052\099\027\025\027\099\106\008\025\033\099\108\025\096\125\099\106\099\025\049\102\112\076\018\032\016\108\108\008\027\106\017\111\077\025\087\087\057\057\025\096\125\099\106\099\049\025\057\057\126\126")
zinputNotePP2 = Wherigo.ZInput(cartGC2C5FN)
zinputNotePP2.Id = "13ebb129-46af-4c1e-b07c-e4361cecb482"
zinputNotePP2.Name = _o9p("\067\099\106\008\096\096\034")
zinputNotePP2.Description = ""
zinputNotePP2.Visible = true
zinputNotePP2.InputType = "Text"
zinputNotePP2.Text = _o9p("\116\027\068\016\106\025\078\025\027\008\030\025\023\008\012\058\108\052\068\106\052\099\027\025\027\099\106\008\025\033\099\108\025\096\125\099\106\099\025\034\102\112\076\018\032\016\108\108\008\027\106\017\111\077\025\087\087\057\057\025\096\125\099\106\099\034\025\057\057\126\126")
zinputNotePP3 = Wherigo.ZInput(cartGC2C5FN)
zinputNotePP3.Id = "89aa4b3c-8c2b-4927-8d50-40f10e2da2c7"
zinputNotePP3.Name = _o9p("\067\099\106\008\096\096\062")
zinputNotePP3.Description = ""
zinputNotePP3.Visible = true
zinputNotePP3.InputType = "Text"
zinputNotePP3.Text = _o9p("\116\027\068\016\106\025\078\025\027\008\030\025\023\008\012\058\108\052\068\106\052\099\027\025\027\099\106\008\025\033\099\108\025\096\125\099\106\099\025\062\102\112\076\018\032\016\108\108\008\027\106\017\111\077\025\087\087\057\057\025\096\125\099\106\099\062\025\057\057\126\126")
zinputNotePP4 = Wherigo.ZInput(cartGC2C5FN)
zinputNotePP4.Id = "39ac79f9-6379-4d9d-8814-8b766004a490"
zinputNotePP4.Name = _o9p("\067\099\106\008\096\096\118")
zinputNotePP4.Description = ""
zinputNotePP4.Visible = true
zinputNotePP4.InputType = "Text"
zinputNotePP4.Text = _o9p("\116\027\068\016\106\025\078\025\027\008\030\025\023\008\012\058\108\052\068\106\052\099\027\025\027\099\106\008\025\033\099\108\025\096\125\099\106\099\025\118\102\112\076\018\032\016\108\108\008\027\106\017\111\077\025\087\087\057\057\025\096\125\099\106\099\118\025\057\057\126\126")
zinputNotePP5 = Wherigo.ZInput(cartGC2C5FN)
zinputNotePP5.Id = "41771939-8b50-41a0-b732-79044617fe9d"
zinputNotePP5.Name = _o9p("\067\099\106\008\096\096\127")
zinputNotePP5.Description = ""
zinputNotePP5.Visible = true
zinputNotePP5.InputType = "Text"
zinputNotePP5.Text = _o9p("\116\027\068\016\106\025\078\025\027\008\030\025\023\008\012\058\108\052\068\106\052\099\027\025\027\099\106\008\025\033\099\108\025\096\125\099\106\099\025\127\102\112\076\018\032\016\108\108\008\027\106\017\111\077\025\087\087\057\057\025\096\125\099\106\099\127\025\057\057\126\126")
zEnding = Wherigo.ZInput(cartGC2C5FN)
zEnding.Id = "9678662b-28cd-4691-b689-4c785abdd0f3"
zEnding.Name = _o9p("\089\027\023\052\027\040")
zEnding.Description = ""
zEnding.Visible = true
zEnding.Choices = {
	"CONTINUE"
}
zEnding.InputType = "MultipleChoice"
zEnding.Text = _o9p("\057\057\057")

-- WorksWithList for object commands --

-- functions --
function cartGC2C5FN:OnStart()
	DevID = (""..(autosetdev()))..""
	_Urwigo.Dialog(false, {
		{
			Text = ((((((((((((((((_o9p("\044\008\106\008\058\106\052\027\040\025\096\017\078\111\008\108\025\044\008\013\052\058\008\025\057\057\057\025")..DevID).._o9p("\025\102\112\076\018\073\058\078\108\106\108\052\023\040\008\025\085\016\052\017\106\025\033\099\108\025"))..Env.Device).._o9p("\109\102\112\076\018\036\008\106\106\052\027\040\025\105\068\106\052\059\078\017\025\036\008\106\106\052\027\040\012\025\033\099\108\077\025"))..DevID).._o9p("\102\112\076\018\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\102\112\076\018\035\008\027\016\025\036\016\068\068\099\108\106\025\077\025")).._f2Wa).._o9p("\025\102\112\076\018\036\099\016\027\023\025\036\016\068\068\099\108\106\025\077\025"))..SuppSound).._o9p("\102\112\076\018\036\106\078\106\016\012\025\112\078\108\025\077\025"))..StatBar).._o9p("\102\112\076\018\036\106\078\106\016\012\025\050\068\023\078\106\008\012\077\025\008\013\008\108\111\025"))..SuppStatTime).._o9p("\025\012\008\058\012\102\112\076\018\036\058\108\008\008\027\025\044\052\108\008\058\106\012\025\077\025"))..SuppScreen).._o9p("\102\112\076\018\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\102\112\076\018"))..DetNote
		}
	}, function(action)
		zitemMENU:MoveTo(Player)
		_Urwigo.RunDialogs(function()
			Wherigo.GetInput(zinputMenuList)
		end)
	end)
end
function cartGC2C5FN:OnRestore()
	if Wherigo.NoCaseEquals(Env.Platform, _o9p("\039\052\027\062\034")) then
		_Urwigo.MessageBox{
			Text = _o9p("\039\008\025\078\068\099\017\099\040\052\065\008\025\052\033\025\111\099\016\025\125\078\023\025\106\099\025\108\008\012\106\099\108\008\025\111\099\016\108\025\040\078\059\008\025\023\016\008\025\106\099\025\078\025\068\017\078\111\008\108\025\058\108\078\012\125\057\025\096\017\008\078\012\008\025\027\099\106\008\025\106\125\078\106\025\111\099\016\025\030\052\017\017\025\027\008\008\023\025\106\099\025\059\099\013\008\025\111\099\016\108\025\078\013\078\106\078\108\025\085\078\058\024\025\106\099\025\106\125\008\025\017\052\040\125\106\025\085\017\016\008\025\065\099\027\008\012\025\106\125\078\106\025\030\008\108\008\025\078\058\106\052\013\008\025\078\106\025\106\125\008\025\106\052\059\008\025\099\033\025\106\125\008\025\012\078\013\008\025\073\012\125\099\016\017\023\025\085\008\025\030\008\012\106\025\106\099\025\027\099\108\106\125\030\008\012\106\025\099\033\025\111\099\016\108\025\058\016\108\108\008\027\106\025\017\099\058\078\106\052\099\027\109"), 
			Media = zmediaicSAVE
		}
	end
	ztimerDOOM:Stop()
	ztimerlilDOOM:Stop()
	ztimerSanity:Stop()
	ztimerDrum:Stop()
	ztimerSave:Stop()
	ztimerDOOM.Duration = SaveStateTimer
	ztimerDOOM:Start()
	ztimerlilDOOM:Start()
	ztimerSanity:Start()
	ztimerSave:Start()
	ztimerDrum:Start()
end
function cartGC2C5FN:OnSync()
	SaveStateTimer = ztimerDOOM.Remaining
end
function zoneTheDrive:OnProximity()
	zoneTheDrive.Visible = false
	zoneTheDrive.Active = false
	Wherigo.PlayAudio(zmediaSNDenginesputter)
	zoneSafeParking.Active = true
	zoneSafeParking.Visible = true
	_Urwigo.MessageBox{
		Text = _o9p("\071\125\008\025\058\078\108\025\008\027\040\052\027\008\025\085\008\040\052\027\012\025\106\099\025\012\068\016\106\106\008\108\025\106\099\025\078\025\125\078\017\106\057\025\071\052\108\008\023\025\078\027\023\025\008\055\125\078\016\012\106\008\023\046\025\111\099\016\025\023\008\058\052\023\008\025\106\099\025\068\016\017\017\025\099\033\033\025\012\099\059\008\030\125\008\108\008\025\012\078\033\008\025\027\008\078\108\085\111\025\012\099\025\106\125\078\106\025\111\099\016\025\058\078\027\025\058\125\008\058\024\025\111\099\016\108\025\008\027\040\052\027\008\057\057\057"), 
		Media = zmediaicCAR, 
		Buttons = {
			_o9p("\047\052\027\023\025\078\025\012\078\033\008\025\068\017\078\058\008\025\027\008\078\108\085\111\025\106\099\025\068\016\017\017\025\099\033\033\057\057\057")
		}, 
		Callback = function(action)
			if action ~= nil then
				Wherigo.ShowScreen(Wherigo.DETAILSCREEN, zoneSafeParking)
			end
		end
	}
end
function zoneParkingSpot:OnExit()
	Wherigo.ShowScreen(Wherigo.LOCATIONSCREEN)
end
function zoneParkingSpot:OnProximity()
	if dejavu == true then
		_Urwigo.MessageBox{
			Text = _o9p("\089\013\008\108\111\106\125\052\027\040\025\068\108\008\106\106\111\025\059\016\058\125\025\017\099\099\024\012\025\106\125\008\025\012\078\059\008\025\078\012\025\111\099\016\025\017\008\033\106\025\052\106\025\008\078\108\017\052\008\108\057\025\032\078\108\025\012\106\052\017\017\025\085\108\099\024\008\027\057\025\044\099\099\108\025\012\106\052\017\017\025\017\099\058\024\008\023\057\025\037\008\111\012\025\012\106\052\017\017\025\017\099\058\024\008\023\025\052\027\025\106\125\008\025\058\078\108\057"), 
			Media = zmediaitBROKENCAR2, 
			Buttons = {
				_o9p("\107\099\099\024\025\078\108\099\016\027\023\025\059\099\108\008\057\057\057")
			}, 
			Callback = function(action)
				if action ~= nil then
					Wherigo.ShowScreen(Wherigo.LOCATIONSCREEN)
				end
			end
		}
	end
end
function zoneBoatRamp:OnProximity()
	if (ZoneCheck(zoneBoatRamp)) == false then
		Wherigo.PlayAudio(zmediaSNDboat)
		_Urwigo.MessageBox{
			Text = _o9p("\100\012\025\111\099\016\025\027\008\078\108\025\106\125\008\025\112\099\078\106\025\076\078\059\068\046\025\111\099\016\025\012\008\008\025\012\099\059\008\106\125\052\027\040\025\099\027\025\106\125\008\025\040\108\099\016\027\023\057\057\057"), 
			Media = zmediaicSEE, 
			Callback = function(action)
				if action ~= nil then
					Wherigo.ShowScreen(Wherigo.DETAILSCREEN, zitemPawPrints)
				end
			end
		}
	end
end
function zoneTrailhead:OnProximity()
	if (ZoneCheck(zoneTrailhead)) == false then
		RandEnc = true
		Wherigo.PlayAudio(zmediaSNDritualdrums)
		_Urwigo.MessageBox{
			Text = _o9p("\071\125\008\025\012\099\016\027\023\012\025\099\033\025\106\108\052\085\078\017\025\023\108\016\059\012\025\085\008\078\106\052\027\040\025\058\078\106\058\125\008\012\025\111\099\016\108\025\078\106\106\008\027\106\052\099\027\025\078\012\025\111\099\016\025\027\008\078\108\025\106\125\008\025\106\108\078\052\017\125\008\078\023\057\057\057"), 
			Media = zmediaicINFO, 
			Buttons = {
				_o9p("\116\027\013\008\012\106\052\040\078\106\008"), 
				_o9p("\107\008\078\013\008\025\052\106\025\085\008")
			}, 
			Callback = function(action)
				if action ~= nil then
					if action == "Button1" then
						zitemDrums.Visible = true
						_Urwigo.MessageBox{
							Text = _o9p("\100\012\025\111\099\016\025\040\008\106\025\058\017\099\012\008\108\025\106\099\025\030\125\008\108\008\025\106\125\008\025\023\108\016\059\025\012\099\016\027\023\012\025\008\059\078\027\078\106\008\046\025\106\125\008\025\012\099\016\027\023\012\025\012\016\023\023\008\027\017\111\057\057\057\025\012\106\099\068\057\025\097\099\016\025\078\108\108\052\013\008\025\106\099\025\033\052\027\023\025\027\099\025\099\027\008\025\078\085\099\016\106\046\025\085\016\106\025\078\025\069\016\052\058\024\025\012\008\078\108\058\125\025\099\033\025\106\125\008\025\078\108\008\078\025\108\008\012\016\017\106\012\025\052\027\025\106\125\008\025\023\052\012\058\099\013\008\108\111\025\099\033\025\106\125\008\025\012\099\016\108\058\008\025\099\033\025\106\125\008\025\012\099\016\027\023\012\057\057\057\025\078\025\023\052\012\058\078\108\023\008\023\025\012\008\106\025\099\033\025\106\108\052\085\078\017\025\023\108\016\059\012\057"), 
							Media = zmediaicSEE, 
							Buttons = {
								_o9p("\032\099\027\106\052\027\016\008\057\057\057")
							}, 
							Callback = function(action)
								if action ~= nil then
									Wherigo.ShowScreen(Wherigo.DETAILSCREEN, zitemDrums)
								end
							end
						}
					else
						Wherigo.ShowScreen(Wherigo.LOCATIONSCREEN)
					end
				end
			end
		}
	end
	zg1()
end
function zoneFishingPier:OnProximity()
	if (ZoneCheck(zoneFishingPier)) == false then
		Wherigo.PlayAudio(zmediaSNDdock)
		_Urwigo.MessageBox{
			Text = _o9p("\100\012\025\111\099\016\025\027\008\078\108\025\106\125\008\025\047\052\012\125\052\027\040\025\096\052\008\108\046\025\111\099\016\025\012\008\008\025\012\099\059\008\106\125\052\027\040\025\099\027\025\106\125\008\025\040\108\099\016\027\023\057\057\057"), 
			Media = zmediaicSEE, 
			Callback = function(action)
				if action ~= nil then
					Wherigo.ShowScreen(Wherigo.DETAILSCREEN, zitemFeather)
				end
			end
		}
	end
end
function zoneBranch1:OnProximity()
	if (ZoneCheck(zoneBranch1)) == false then
	end
	zg2()
end
function zoneBranch2:OnProximity()
	if (ZoneCheck(zoneBranch2)) == false then
	end
	zg17()
end
function zoneRuins1:OnProximity()
	if (ZoneCheck(zoneRuins1)) == false then
	end
	zg3()
end
function zoneShore1:OnProximity()
	if (ZoneCheck(zoneShore1)) == false then
		Wherigo.PlayAudio(zmediaSNDboat)
		StatFeather = false
		zitemFeather:MoveTo(zoneShore1)
		_Urwigo.MessageBox{
			Text = _o9p("\100\012\025\111\099\016\025\078\068\068\108\099\078\058\125\025\106\125\052\012\025\078\108\008\078\046\025\111\099\016\025\012\008\008\025\012\099\059\008\106\125\052\027\040\025\099\027\025\106\125\008\025\040\108\099\016\027\023\057\057\057"), 
			Media = zmediaicSEE, 
			Callback = function(action)
				if action ~= nil then
					Wherigo.ShowScreen(Wherigo.DETAILSCREEN, zitemFeather)
				end
			end
		}
	end
	zg6()
end
function zoneStream1:OnProximity()
	if (ZoneCheck(zoneStream1)) == false then
		Wherigo.PlayAudio(zmediaSNDcreek)
	end
	zg3()
end
function zoneRuins10:OnProximity()
	if (ZoneCheck(zoneRuins10)) == false then
	end
	zg14()
end
function zoneRuins11:OnProximity()
	if (ZoneCheck(zoneRuins11)) == false then
	end
	zg15()
end
function zoneRuins12:OnProximity()
	if (ZoneCheck(zoneRuins12)) == false then
	end
	zg17()
end
function zoneRuins2:OnProximity()
	if (ZoneCheck(zoneRuins2)) == false then
	end
	zg4()
end
function zoneShore2:OnProximity()
	if (ZoneCheck(zoneShore2)) == false then
		Wherigo.PlayAudio(zmediaSNDboat)
		StatPaw = false
		zitemPawPrints:MoveTo(zoneShore2)
		_Urwigo.MessageBox{
			Text = _o9p("\100\012\025\111\099\016\025\078\068\068\108\099\078\058\125\025\106\125\052\012\025\078\108\008\078\046\025\111\099\016\025\012\008\008\025\012\099\059\008\106\125\052\027\040\025\099\027\025\106\125\008\025\040\108\099\016\027\023\057\057\057"), 
			Media = zmediaicSEE, 
			Callback = function(action)
				if action ~= nil then
					Wherigo.ShowScreen(Wherigo.DETAILSCREEN, zitemPawPrints)
				end
			end
		}
	end
	zg13()
end
function zoneStream2:OnProximity()
	if (ZoneCheck(zoneStream2)) == false then
		Wherigo.PlayAudio(zmediaSNDcreek)
	end
	zg9()
end
function zoneBranch3:OnProximity()
	if (ZoneCheck(zoneBranch3)) == false then
	end
	zg18()
end
function zoneRuins3:OnProximity()
	if (ZoneCheck(zoneRuins3)) == false then
	end
	zg5()
end
function zoneStream3:OnProximity()
	if (ZoneCheck(zoneStream3)) == false then
		Wherigo.PlayAudio(zmediaSNDcreek)
	end
	zg17()
end
function zoneBranch4:OnInvestigatePaths(target)
	_Urwigo.RunDialogs(function()
		Wherigo.GetInput(zinputPathCheck)
	end)
end
function zoneBranch4:OnProximity()
	if (ZoneCheck(zoneBranch4)) == false then
		zoneBranch4.Commands.InvestigatePaths.Enabled = true
	end
	zg20()
end
function zoneRuins4:OnProximity()
	if (ZoneCheck(zoneRuins4)) == false then
	end
	zg7()
end
function zoneRuins5:OnProximity()
	if (ZoneCheck(zoneRuins5)) == false then
	end
	zg8()
end
function zoneRuins6:OnProximity()
	if (ZoneCheck(zoneRuins6)) == false then
	end
	zg9()
end
function zoneRuins7:OnProximity()
	if (ZoneCheck(zoneRuins7)) == false then
	end
	zg10()
end
function zoneRuins8:OnProximity()
	if (ZoneCheck(zoneRuins8)) == false then
	end
	zg11()
end
function zoneRuins9:OnProximity()
	if (ZoneCheck(zoneRuins9)) == false then
	end
	zg13()
end
function zoneMBS1:OnLookAround(target)
	_Urwigo.MessageBox{
		Text = _o9p("\097\099\016\025\078\108\008\025\040\108\078\106\008\033\016\017\025\033\099\108\025\106\125\008\025\059\099\059\008\027\106\025\099\033\025\106\108\078\027\069\016\052\017\052\106\111\025\078\027\023\025\058\078\017\059\025\078\027\023\025\017\099\099\024\025\078\108\099\016\027\023\025\106\099\025\012\008\008\025\030\125\078\106\025\008\055\078\058\106\017\111\025\052\012\025\085\108\052\027\040\052\027\040\025\106\125\008\025\033\008\008\017\052\027\040\025\078\085\099\016\106\057\025\107\008\106\106\008\108\012\025\078\027\023\025\027\016\059\085\008\108\012\025\033\099\108\059\025\052\027\025\111\099\016\108\025\059\052\027\023\057\057\057\057\025\015\032\034\100\096\063\048\057\025\035\078\111\085\008\025\106\125\008\108\008\025\052\012\025\012\099\059\008\106\125\052\027\040\025\125\008\108\008\025\106\099\025\023\052\012\058\099\013\008\108\057\057\057"), 
		Media = zmediaicYINYANG, 
		Buttons = {
			_o9p("\047\099\016\027\023\025\116\106\043"), 
			_o9p("\107\008\078\013\008\025\052\106\025\112\008")
		}, 
		Callback = function(action)
			if action ~= nil then
				if action == "Button1" then
					if MBS1Clue == 2 then
						_Urwigo.MessageBox{
							Text = _o9p("\097\099\016\025\125\078\013\008\025\078\017\108\008\078\023\111\025\033\099\016\027\023\025\106\125\008\025\012\099\016\108\058\008\025\099\033\025\106\125\008\025\106\108\078\027\069\016\052\017\052\106\111\057\025\035\099\013\008\025\078\017\099\027\040\057\057\057"), 
							Media = zmediaicINFO
						}
					else
						_Urwigo.MessageBox{
							Text = _o9p("\116\033\025\111\099\016\025\125\078\068\068\008\027\008\023\025\106\099\025\125\078\013\008\025\108\008\078\017\017\111\025\033\099\016\027\023\025\106\125\008\025\058\078\058\125\008\025\017\099\058\078\106\008\023\025\027\008\078\108\025\125\008\108\008\046\025\106\125\008\108\008\025\078\108\008\025\012\068\008\058\052\078\017\025\058\017\016\008\012\025\017\099\058\078\106\008\023\025\030\052\106\125\052\027\025\052\106\025\106\125\078\106\025\111\099\016\025\058\078\027\025\008\027\106\008\108\025\125\008\108\008\025\078\017\012\099\025\033\099\108\025\012\099\059\008\106\125\052\027\040\025\012\068\008\058\052\078\017\057\057\057"), 
							Media = zmediaicCACHE, 
							Buttons = {
								_o9p("\089\027\106\008\108\025\106\125\008\025\032\017\016\008"), 
								_o9p("\047\052\027\008\057\057\057\025\116\025\017\052\008\023\057\057\057")
							}, 
							Callback = function(action)
								if action ~= nil then
									_Urwigo.RunDialogs(function()
										Wherigo.GetInput(zinputMBS1Clue)
									end)
								end
							end
						}
					end
				elseif action == "Button2" then
					Wherigo.ShowScreen(Wherigo.LOCATIONSCREEN)
				end
			end
		end
	}
end
function zoneMBS1:OnLeaveitBe(target)
end
function zoneMBS1:OnExit(target)
	Wherigo.ShowScreen(Wherigo.LOCATIONSCREEN)
end
function zoneMBS1:OnProximity()
	if (ZoneCheck(zoneMBS1)) == false then
		Wherigo.PlayAudio(zmediaSNDBGMsolemn)
		StatFeather = true
		zitemFeather:MoveTo(zoneMBS1)
		zoneMBS1.Commands.LookAround.Enabled = true
		zoneMBS1.Commands.LeaveitBe.Enabled = true
		zoneMBS1.Commands.Exit.Enabled = true
		_Urwigo.MessageBox{
			Text = _o9p("\100\012\025\111\099\016\025\078\068\068\108\099\078\058\125\025\106\125\052\012\025\068\008\078\058\008\033\016\017\025\078\108\008\078\046\025\111\099\016\025\012\008\008\025\012\099\059\008\106\125\052\027\040\025\099\027\025\106\125\008\025\040\108\099\016\027\023\057\057\057"), 
			Media = zmediaicSEE, 
			Callback = function(action)
				if action ~= nil then
					Wherigo.ShowScreen(Wherigo.DETAILSCREEN, zitemFeather)
				end
			end
		}
	end
	zg12()
end
function zoneMBS2:OnLookAround(target)
	_Urwigo.MessageBox{
		Text = _o9p("\097\099\016\025\078\108\008\025\040\108\078\106\008\033\016\017\025\033\099\108\025\106\125\008\025\059\099\059\008\027\106\025\099\033\025\106\108\078\027\069\016\052\017\052\106\111\025\078\027\023\025\058\078\017\059\025\078\027\023\025\017\099\099\024\025\078\108\099\016\027\023\025\106\099\025\012\008\008\025\030\125\078\106\025\008\055\078\058\106\017\111\025\052\012\025\085\108\052\027\040\052\027\040\025\106\125\008\025\033\008\008\017\052\027\040\025\078\085\099\016\106\057\025\107\008\106\106\008\108\012\025\078\027\023\025\027\016\059\085\008\108\012\025\033\099\108\059\025\052\027\025\111\099\016\108\025\059\052\027\023\057\057\057\057\025\015\032\034\100\076\100\101\057\025\035\078\111\085\008\025\106\125\008\108\008\025\052\012\025\012\099\059\008\106\125\052\027\040\025\125\008\108\008\025\106\099\025\023\052\012\058\099\013\008\108\057\057\057"), 
		Media = zmediaicYINYANG, 
		Buttons = {
			_o9p("\047\099\016\027\023\025\116\106\043"), 
			_o9p("\107\008\078\013\008\025\052\106\025\112\008")
		}, 
		Callback = function(action)
			if action ~= nil then
				if action == "Button1" then
					if MBS2Clue == 2 then
						_Urwigo.MessageBox{
							Text = _o9p("\097\099\016\025\125\078\013\008\025\078\017\108\008\078\023\111\025\033\099\016\027\023\025\106\125\008\025\012\099\016\108\058\008\025\099\033\025\106\125\008\025\106\108\078\027\069\016\052\017\052\106\111\057\025\035\099\013\008\025\078\017\099\027\040\057\057\057"), 
							Media = zmediaicINFO, 
							Callback = function(action)
								if action ~= nil then
									Wherigo.ShowScreen(Wherigo.LOCATIONSCREEN)
								end
							end
						}
					else
						_Urwigo.RunDialogs(function()
							Wherigo.GetInput(zinputMBS2Clue)
						end)
					end
				end
			end
		end
	}
end
function zoneMBS2:OnLeaveitBe(target)
	Wherigo.ShowScreen(Wherigo.DETAILSCREEN, zoneMBS2)
end
function zoneMBS2:OnExit(target)
	Wherigo.ShowScreen(Wherigo.LOCATIONSCREEN)
end
function zoneMBS2:OnProximity()
	if (ZoneCheck(zoneMBS2)) == false then
		Wherigo.PlayAudio(zmediaSNDBGMsolemn)
		StatPaw = true
		zitemPawPrints:MoveTo(zoneMBS2)
		zoneMBS2.Commands.LookAround.Enabled = true
		zoneMBS2.Commands.LeaveitBe.Enabled = true
		zoneMBS2.Commands.Exit.Enabled = true
		_Urwigo.MessageBox{
			Text = _o9p("\100\012\025\111\099\016\025\078\068\068\108\099\078\058\125\025\106\125\052\012\025\078\108\008\078\046\025\111\099\016\025\012\008\008\025\012\099\059\008\106\125\052\027\040\025\099\027\025\106\125\008\025\040\108\099\016\027\023\057\057\057"), 
			Media = zmediaicSEE, 
			Callback = function(action)
				if action ~= nil then
					Wherigo.ShowScreen(Wherigo.DETAILSCREEN, zitemPawPrints)
				end
			end
		}
	end
	zg19()
end
function zoneHut:OnProximity()
	if (ZoneCheck(zoneHut)) == false then
		Wherigo.PlayAudio(zmediaSNDhut)
	end
end
function zoneHeap:On_iZW(target)
	zitemStrangeStatue.Visible = true
	_Urwigo.MessageBox{
		Text = _o9p("\097\099\016\025\012\008\078\108\058\125\025\106\125\108\099\016\040\125\025\106\125\008\025\099\085\090\008\058\106\012\025\012\106\108\008\030\027\025\078\085\099\016\106\025\078\027\023\025\023\052\012\058\099\013\008\108\025\012\099\059\008\106\125\052\027\040\025\099\023\023\025\078\059\099\027\040\012\106\025\106\125\008\059\025\106\125\078\106\025\058\078\106\058\125\008\012\025\111\099\016\108\025\008\111\008\057\057\057"), 
		Media = zmediaicSEE, 
		Callback = function(action)
			if action ~= nil then
				Wherigo.ShowScreen(Wherigo.DETAILSCREEN, zitemStrangeStatue)
			end
		end
	}
end
function zoneHeap:On_CXA(target)
	Wherigo.ShowScreen(Wherigo.DETAILSCREEN, zoneHeap)
end
function zoneHeap:OnProximity()
	if (ZoneCheck(zoneHeap)) == false then
		Wherigo.PlayAudio(zmediaSNDBGMechoes)
		zitemStrangeStatue.Visible = true
	end
end
function zoneEdge:OnExit()
	Wherigo.ShowScreen(Wherigo.LOCATIONSCREEN)
end
function zoneEdge:OnProximity()
	if (ZoneCheck(zoneEdge)) == false then
		RandEnc = false
		Wherigo.PlayAudio(zmediaSNDBGMnightscape)
		_Urwigo.MessageBox{
			Text = _o9p("\097\099\016\025\108\008\078\058\125\025\106\125\008\025\008\027\023\025\099\033\025\106\125\008\025\106\108\008\008\017\052\027\008\025\078\012\025\106\125\008\025\078\108\008\078\025\099\068\008\027\012\025\016\068\025\085\008\033\099\108\008\025\111\099\016\025\106\099\025\078\027\025\008\027\099\016\108\059\099\016\012\025\089\023\040\008\025\099\033\025\058\017\008\078\108\008\023\025\078\027\023\025\033\078\017\017\008\027\025\106\108\008\008\012\057\025\116\027\025\106\125\008\025\023\052\012\106\078\027\058\008\046\025\111\099\016\025\058\078\027\025\012\008\008\025\030\125\078\106\025\078\068\068\008\078\108\012\025\106\099\025\085\008\025\125\016\040\008\025\068\052\017\017\078\108\012\025\108\008\078\058\125\052\027\040\025\016\068\025\052\027\106\099\025\106\125\008\025\012\024\111\025\078\027\023\025\033\078\052\027\106\025\040\017\052\059\059\008\108\025\099\033\025\033\052\108\008\017\052\040\125\106\057\057\057"), 
			Media = zmediaicGRASS, 
			Callback = function(action)
				if action ~= nil then
					Wherigo.PlayAudio(zmediaSNDwind)
					_Urwigo.MessageBox{
						Text = _o9p("\071\125\008\025\012\024\111\025\012\016\023\023\008\027\017\111\025\106\016\108\027\012\025\023\078\108\024\025\078\027\023\025\085\017\008\078\024\025\078\012\025\106\125\008\025\012\016\027\025\052\012\025\012\017\099\030\017\111\025\058\099\013\008\108\008\023\025\085\111\025\106\125\008\025\008\008\108\052\008\025\012\125\078\023\099\030\025\099\033\025\106\125\008\025\059\099\099\027\025\052\027\025\078\027\025\016\027\078\027\027\099\016\027\058\008\023\025\008\058\017\052\068\012\008\057\057\057"), 
						Media = zmediaeMOON, 
						Callback = function(action)
							if action ~= nil then
								Wherigo.PlayAudio(zmediaSNDthunder)
								_Urwigo.MessageBox{
									Text = _o9p("\071\125\008\025\008\058\017\052\068\012\008\023\025\012\016\027\025\078\027\023\025\106\125\008\025\108\008\012\106\025\099\033\025\106\125\008\025\012\024\111\025\085\008\058\099\059\008\012\025\058\099\013\008\108\008\023\025\030\052\106\125\025\099\059\052\027\099\016\012\017\111\025\023\078\108\024\025\012\106\099\108\059\025\058\017\099\016\023\012\025\078\027\023\025\078\025\058\017\078\068\025\099\033\025\106\125\016\027\023\008\108\025\078\027\023\025\078\025\085\099\017\106\025\099\033\025\017\052\040\125\106\027\052\027\040\025\068\052\008\108\058\008\012\025\106\125\008\025\012\052\017\008\027\058\008\025\078\027\023\025\023\078\108\024\027\008\012\012\057\057\057"), 
									Media = zmediaeSTORM, 
									Callback = function(action)
										if action ~= nil then
											_Urwigo.MessageBox{
												Text = _o9p("\097\099\016\025\085\008\040\052\027\025\106\099\025\068\078\027\052\058\025\078\025\017\052\106\106\017\008\025\078\012\025\052\106\025\040\008\106\012\025\125\078\108\023\008\108\025\078\027\023\025\125\078\108\023\008\108\025\106\099\025\012\008\008\025\052\027\025\106\125\008\025\008\013\008\108\025\052\027\058\108\008\078\012\052\027\040\025\023\078\108\024\027\008\012\012\057\057\057"), 
												Media = zmediaicRUN, 
												Buttons = {
													_o9p("\044\099\025\116\025\125\078\013\008\025\078\025\017\052\040\125\106\025\099\027\025\059\008\021")
												}, 
												Callback = function(action)
													if action ~= nil then
														if Player:Contains(zitemGearPack) then
															_Urwigo.MessageBox{
																Text = _o9p("\097\099\016\025\033\016\059\085\017\008\025\078\108\099\016\027\023\025\111\099\016\108\025\068\099\012\012\008\012\012\052\099\027\012\025\078\027\023\025\078\108\008\025\106\125\078\027\024\033\016\017\025\106\125\078\106\025\111\099\016\025\125\078\013\008\025\111\099\016\108\025\047\017\078\012\125\017\052\040\125\106\057\025\097\099\016\025\068\016\017\017\025\099\016\106\025\111\099\016\108\025\047\017\078\012\125\017\052\040\125\106\025\078\027\023\025\016\012\008\025\052\106\025\106\099\025\052\017\017\016\059\052\027\078\106\008\025\106\125\008\025\012\016\108\108\099\016\027\023\052\027\040\025\023\078\108\024\027\008\012\012\057\057\057\102\112\076\018\073\015\078\052\027\025\049\101\025\036\078\027\052\106\111\109"), 
																Media = zmediaeSHINE, 
																Callback = function(action)
																	if action ~= nil then
																		SanityLevel = SanityLevel + 10
																		_Urwigo.MessageBox{
																			Text = _o9p("\071\052\059\008\025\106\099\025\125\008\078\023\025\052\027\025\106\125\008\025\023\052\108\008\058\106\052\099\027\025\099\033\025\106\125\008\025\068\052\017\017\078\108\012\025\078\027\023\025\106\125\008\025\033\052\108\008\017\052\040\125\106\025\078\027\023\025\012\008\008\025\052\033\025\111\099\016\025\058\078\027\025\008\027\023\025\106\125\052\012\025\052\027\012\078\027\052\106\111\057\057\057"), 
																			Media = zmediaicVIEW, 
																			Callback = function(action)
																				if action ~= nil then
																					Wherigo.ShowScreen(Wherigo.DETAILSCREEN, zoneMetalPillar)
																				end
																			end
																		}
																	end
																end
															}
														else
															_Urwigo.MessageBox{
																Text = _o9p("\097\099\016\025\033\016\059\085\017\008\025\078\108\099\016\027\023\025\111\099\016\108\025\068\099\012\012\008\012\012\052\099\027\012\025\099\027\017\111\025\106\099\025\033\052\027\023\025\106\125\078\106\025\111\099\016\025\023\099\025\027\099\106\025\125\078\013\008\025\078\027\111\025\017\052\040\125\106\025\012\099\016\108\058\008\012\057\025\097\099\016\025\017\099\012\008\025\012\099\059\008\025\036\078\027\052\106\111\025\023\016\008\025\106\099\025\125\078\013\052\027\040\025\106\099\025\012\106\016\059\085\017\008\025\078\108\099\016\027\023\025\052\027\025\106\125\008\025\023\078\108\024\027\008\012\012\057\057\057\102\112\076\018\073\107\099\012\008\025\049\101\025\036\078\027\052\106\111\109"), 
																Media = zmediaicTHUMBD, 
																Callback = function(action)
																	if action ~= nil then
																		SanityLevel = SanityLevel + -10
																		_Urwigo.MessageBox{
																			Text = _o9p("\071\052\059\008\025\106\099\025\125\008\078\023\025\052\027\025\106\125\008\025\023\052\108\008\058\106\052\099\027\025\099\033\025\106\125\008\025\068\052\017\017\078\108\012\025\078\027\023\025\106\125\008\025\033\052\108\008\017\052\040\125\106\025\078\027\023\025\012\008\008\025\052\033\025\111\099\016\025\058\078\027\025\008\027\023\025\106\125\052\012\025\052\027\012\078\027\052\106\111\057\057\057"), 
																			Media = zmediaicVIEW, 
																			Callback = function(action)
																				if action ~= nil then
																					Wherigo.ShowScreen(Wherigo.DETAILSCREEN, zoneMetalPillar)
																				end
																			end
																		}
																	end
																end
															}
														end
													end
												end
											}
										end
									end
								}
							end
						end
					}
				end
			end
		}
	end
	zg21()
end
function zoneMetalPillar:OnProximity()
	if (ZoneCheck(zoneMetalPillar)) == false then
		_Urwigo.MessageBox{
			Text = _o9p("\100\012\025\111\099\016\025\108\008\078\058\125\025\106\125\008\025\035\008\106\078\017\025\096\052\017\017\078\108\046\025\052\106\025\017\099\099\059\012\025\085\008\033\099\108\008\025\111\099\016\025\108\008\078\058\125\052\027\040\025\016\068\025\052\027\106\099\025\106\125\008\025\125\008\078\013\008\027\012\057\025\116\027\012\058\108\052\085\008\023\025\099\027\025\099\027\008\025\012\052\023\008\025\052\012\025\078\025\012\052\040\052\017\025\099\033\025\016\027\024\027\099\030\027\025\059\008\078\027\052\027\040\046\025\085\016\106\025\111\099\016\025\033\008\008\017\025\052\106\025\059\052\040\125\106\025\085\008\025\106\125\008\025\024\008\111\025\106\099\025\016\027\017\099\058\024\052\027\040\025\012\099\059\008\106\125\052\027\040\025\085\052\040\057\025\100\017\017\025\111\099\016\025\024\027\099\030\025\052\012\025\106\125\078\106\025\111\099\016\025\058\078\027\025\033\008\008\017\025\008\027\008\108\040\111\025\008\059\078\027\078\106\052\027\040\025\099\033\033\025\052\106\012\025\012\016\108\033\078\058\008\025\017\052\024\008\025\078\027\025\008\017\008\058\106\108\052\058\025\058\125\078\108\040\008\057\057\057"), 
			Media = zmediaicKEY, 
			Buttons = {
				_o9p("\116\027\012\068\008\058\106\025\052\106\057\057\057"), 
				_o9p("\107\008\078\013\008\025\052\106\025\085\008\057\057\057")
			}, 
			Callback = function(action)
				if action ~= nil then
					if action == "Button1" then
						_Urwigo.MessageBox{
							Text = _o9p("\097\099\016\025\106\099\016\058\125\025\106\125\008\025\012\052\040\052\017\025\078\027\023\025\108\008\058\008\052\013\008\025\078\027\025\008\017\008\058\106\108\052\058\025\012\125\099\058\024\025\106\125\078\106\025\059\078\024\008\012\025\111\099\016\025\090\016\059\068\025\078\025\017\052\106\106\017\008\057\025\097\099\016\025\017\099\099\024\025\085\078\058\024\025\078\106\025\052\106\025\078\027\023\025\078\108\008\025\012\106\078\108\106\017\008\023\025\106\099\025\012\008\008\025\027\016\059\085\008\108\012\025\125\078\013\008\025\078\068\068\008\078\108\008\023\025\085\008\017\099\030\025\052\106\057\057\057\057\025\073\023\052\012\058\099\013\008\108\025\106\125\099\012\008\025\027\016\059\085\008\108\012\025\030\125\008\027\025\111\099\016\025\013\052\012\052\106\025\106\125\008\025\015\060\109"), 
							Media = zmediaicPUZZLE, 
							Callback = function(action)
								if action ~= nil then
									Wherigo.ShowScreen(Wherigo.DETAILSCREEN, zoneMetalPillar)
								end
							end
						}
					else
						Wherigo.ShowScreen(Wherigo.LOCATIONSCREEN)
					end
				end
			end
		}
		CereAct = CereAct + 1
		if CereAct == 2 then
			zoneCeremony.Active = true
			zoneCeremony.Visible = true
		end
	end
	if cartGC2C5FN.Complete == true then
		zg24()
	else
		zg22()
	end
end
function zoneWoodPillar:OnProximity()
	if (ZoneCheck(zoneWoodPillar)) == false then
		_Urwigo.MessageBox{
			Text = _o9p("\100\012\025\111\099\016\025\108\008\078\058\125\025\106\125\008\025\039\099\099\023\008\027\025\096\052\017\017\078\108\046\025\052\106\025\017\099\099\059\012\025\085\008\033\099\108\008\025\111\099\016\025\108\008\078\058\125\052\027\040\025\016\068\025\052\027\106\099\025\106\125\008\025\125\008\078\013\008\027\012\057\025\116\027\012\058\108\052\085\008\023\025\099\027\025\099\027\008\025\012\052\023\008\025\052\012\025\078\025\012\052\040\052\017\025\099\033\025\016\027\024\027\099\030\027\025\059\008\078\027\052\027\040\046\025\085\016\106\025\111\099\016\025\033\008\008\017\025\052\106\025\059\052\040\125\106\025\085\008\025\106\125\008\025\024\008\111\025\106\099\025\016\027\017\099\058\024\052\027\040\025\012\099\059\008\106\125\052\027\040\025\085\052\040\057\025\100\017\017\025\111\099\016\025\024\027\099\030\025\052\012\025\106\125\078\106\025\111\099\016\025\058\078\027\025\033\008\008\017\025\125\008\078\106\025\008\059\078\027\078\106\052\027\040\025\099\033\033\025\052\106\012\025\012\016\108\033\078\058\008\025\017\052\024\008\025\078\025\033\052\108\008\025\085\016\108\027\012\025\030\052\106\125\052\027\025\052\106\057\057\057"), 
			Media = zmediaicKEY, 
			Buttons = {
				_o9p("\116\027\012\068\008\058\106\025\052\106\057\057\057"), 
				_o9p("\107\008\078\013\008\025\052\106\025\085\008\057\057\057")
			}, 
			Callback = function(action)
				if action ~= nil then
					if action == "Button1" then
						_Urwigo.MessageBox{
							Text = _o9p("\097\099\016\025\106\099\016\058\125\025\106\125\008\025\012\052\040\052\017\025\078\027\023\025\085\016\108\027\025\111\099\016\108\025\033\052\027\040\008\108\057\025\100\012\025\111\099\016\108\025\027\016\108\012\008\025\111\099\016\108\025\085\016\108\027\046\025\111\099\016\025\017\099\099\024\025\085\078\058\024\025\078\106\025\106\125\008\025\012\052\040\052\017\025\078\027\023\025\078\108\008\025\012\106\078\108\106\017\008\023\025\106\099\025\012\008\008\025\078\025\017\008\106\106\008\108\025\125\078\012\025\078\068\068\008\078\108\008\023\025\085\008\017\099\030\025\052\106\057\057\057\057\025\073\023\052\012\058\099\013\008\108\025\106\125\078\106\025\017\008\106\106\008\108\025\030\125\008\027\025\111\099\016\025\013\052\012\052\106\025\106\125\008\025\015\060\109"), 
							Media = zmediaicPUZZLE, 
							Callback = function(action)
								if action ~= nil then
									Wherigo.ShowScreen(Wherigo.DETAILSCREEN, zoneWoodPillar)
								end
							end
						}
					else
						Wherigo.ShowScreen(Wherigo.LOCATIONSCREEN)
					end
				end
			end
		}
		CereAct = CereAct + 1
		if CereAct == 2 then
			zoneCeremony.Active = true
			zoneCeremony.Visible = true
		end
	end
	if cartGC2C5FN.Complete == true then
		zg24()
	else
		zg22()
	end
end
function zoneCeremony:OnProximity()
	if (ZoneCheck(zoneCeremony)) == false then
	end
	Wherigo.PlayAudio(zmediaSNDBGMleadin)
	_Urwigo.MessageBox{
		Text = _o9p("\112\008\033\099\108\008\025\111\099\016\108\025\008\111\008\012\046\025\106\099\108\058\125\008\012\025\033\017\078\108\008\025\106\099\025\085\108\052\017\017\052\078\027\058\008\025\108\008\013\008\078\017\052\027\040\025\078\025\059\078\058\078\085\108\008\025\012\058\008\027\008\057\025\036\099\059\008\025\106\030\052\012\106\008\023\046\025\023\078\108\024\025\058\008\108\008\059\099\027\111\025\012\008\008\059\012\025\106\099\025\085\008\025\052\027\025\068\108\008\068\078\108\078\106\052\099\027\057\057\057"), 
		Media = zmediaitTORCH, 
		Buttons = {
			_o9p("\015\008\106\025\078\025\058\017\099\012\008\108\025\017\099\099\024\057\057\057")
		}, 
		Callback = function(action)
			if action ~= nil then
				zcharacterHOODEDFIGURES.Visible = true
				Wherigo.PlayAudio(zmediaSNDwhispers)
				_Urwigo.MessageBox{
					Text = _o9p("\097\099\016\025\059\099\013\008\025\052\027\025\106\099\025\040\008\106\025\078\025\058\017\099\012\008\108\025\017\099\099\024\025\099\033\025\030\125\078\106\045\012\025\040\099\052\027\040\025\099\027\025\078\027\023\025\027\099\106\052\058\008\025\078\025\040\108\099\016\068\025\099\033\025\125\099\099\023\008\023\025\033\052\040\016\108\008\012\025\078\108\099\016\027\023\025\078\027\025\052\027\058\108\008\078\012\052\027\040\017\111\025\108\078\040\052\027\040\025\033\052\108\008\025\012\008\106\025\085\008\106\030\008\008\027\025\106\125\008\025\106\030\099\025\068\052\017\017\078\108\012\057\057"), 
					Media = zmediacHOODS1, 
					Buttons = {
						_o9p("\015\008\106\025\058\017\099\012\008\108\057\057\057"), 
						_o9p("\107\008\078\013\008\025\027\099\030\043")
					}, 
					Callback = function(action)
						if action ~= nil then
							Wherigo.PlayAudio(zmediaSNDghostly)
							_Urwigo.MessageBox{
								Text = _o9p("\071\125\008\025\125\099\099\023\008\023\025\033\052\040\016\108\008\012\025\125\078\013\008\025\058\078\016\040\125\106\025\012\052\040\125\106\025\099\033\025\111\099\016\025\078\027\023\025\108\016\012\125\025\106\099\025\111\099\016\108\025\068\099\012\052\106\052\099\027\025\106\099\025\078\068\068\108\008\125\008\027\023\025\111\099\016\043\025\097\099\016\025\106\108\111\025\106\099\025\108\016\027\046\025\085\016\106\025\106\125\008\025\033\052\040\016\108\008\012\025\058\078\106\058\125\025\111\099\016\025\085\008\033\099\108\008\025\058\078\027\025\008\012\058\078\068\008\057\025\071\125\008\052\108\025\012\106\108\099\027\040\046\025\085\099\027\008\111\025\033\052\027\040\008\108\012\025\125\099\017\023\025\111\099\016\025\030\052\106\125\025\078\025\023\008\078\106\125\017\052\024\008\025\040\108\052\068\025\078\012\025\106\125\008\111\025\023\108\078\040\025\111\099\016\025\106\099\030\078\108\023\012\025\106\125\008\025\085\099\027\033\052\108\008\057\057\057"), 
								Media = zmediacHOODS2, 
								Callback = function(action)
									if action ~= nil then
										zcharacterNYARLATHOTEP.Visible = true
										_Urwigo.MessageBox{
											Text = _o9p("\039\125\008\027\025\111\099\016\025\078\108\108\052\013\008\025\078\106\025\106\125\008\025\085\099\027\033\052\108\008\046\025\106\125\008\108\008\025\052\012\025\078\025\106\078\017\017\046\025\023\078\108\024\025\033\052\040\016\108\008\025\012\106\078\027\023\052\027\040\025\085\008\033\099\108\008\025\106\125\008\025\033\052\108\008\025\030\078\052\106\052\027\040\025\033\099\108\025\111\099\016\025\008\055\068\008\058\106\078\027\106\017\111\057\057\057"), 
											Media = zmediaitTORCH, 
											Callback = function(action)
												if action ~= nil then
													Wherigo.ShowScreen(Wherigo.DETAILSCREEN, zcharacterNYARLATHOTEP)
												end
											end
										}
									end
								end
							}
						end
					end
				}
			end
		end
	}
	if cartGC2C5FN.Complete == true then
		zg24()
	else
		zg22()
	end
end
function zoneStoneworks:OnProximity()
	if (ZoneCheck(zoneStoneworks)) == false then
	end
	if cartGC2C5FN.Complete == true then
		zg24()
	else
		zg23()
	end
end
function zoneHutSide:OnProximity()
	if (ZoneCheck(zoneHutSide)) == false then
	end
	zg16()
end
function zoneSafeParking:OnProximity()
	ztimerDOOM:Start()
	ztimerlilDOOM:Start()
	ztimerSanity:Start()
	ztimerDrum:Start()
	_Urwigo.MessageBox{
		Text = _o9p("\100\025\012\106\108\078\027\040\008\025\033\008\008\017\052\027\040\025\068\078\012\012\008\012\025\099\013\008\108\025\111\099\016\025\078\012\025\111\099\016\025\027\099\106\052\058\008\025\111\099\016\108\025\030\108\052\012\106\030\078\106\058\125\025\059\016\012\106\025\085\008\025\078\058\106\052\027\040\025\016\068\025\106\099\099\046\025\012\052\027\058\008\025\052\106\025\052\012\025\012\106\016\058\024\025\099\027\025\078\025\106\052\059\008\108\025\106\125\078\106\025\125\078\012\025\085\008\040\016\027\025\106\099\025\012\106\008\078\023\052\017\111\025\058\099\016\027\106\025\023\099\030\027\025\034\025\125\099\016\108\012\057\057\057"), 
		Media = zmediaicTIME, 
		Callback = function(action)
			if action ~= nil then
				SafeParkingWorkAround()
			end
		end
	}
end
function zonePathOnwards:OnExit()
	Wherigo.ShowScreen(Wherigo.LOCATIONSCREEN)
end
function zonePathOnwards:OnProximity()
	if (ZoneCheck(zonePathOnwards)) == false then
		_Urwigo.MessageBox{
			Text = _o9p("\071\125\008\025\106\108\078\052\017\025\058\099\027\106\052\027\016\008\012\025\099\027\030\078\108\023\025\027\099\108\106\125\046\025\085\016\106\025\111\099\016\025\033\008\008\017\025\111\099\016\025\078\108\008\025\040\099\052\027\040\025\052\027\025\106\125\008\025\030\108\099\027\040\025\023\052\108\008\058\106\052\099\027\046\025\059\078\111\085\008\025\052\106\025\030\099\016\017\023\025\085\008\025\085\008\012\106\025\106\099\025\125\008\078\023\025\085\078\058\024\025\078\027\023\025\058\125\008\058\024\025\033\099\108\025\078\027\099\106\125\008\108\025\108\099\016\106\008\025\078\017\099\027\040\025\106\125\008\025\030\078\111\057\057\057"), 
			Media = zmediaicSTOP
		}
	end
	zg19()
end
function zoneSidePath3:OnProximity()
	if (ZoneCheck(zoneSidePath3)) == false then
	end
end
function zoneSidePath1:OnProximity()
	if (ZoneCheck(zoneSidePath1)) == false then
		StatPaw = false
		zitemPawPrints:MoveTo(zoneSidePath1)
		_Urwigo.MessageBox{
			Text = _o9p("\100\012\025\111\099\016\025\078\068\068\108\099\078\058\125\025\106\125\052\012\025\078\108\008\078\046\025\111\099\016\025\012\008\008\025\012\099\059\008\106\125\052\027\040\025\099\027\025\106\125\008\025\040\108\099\016\027\023\057\057\057"), 
			Media = zmediaicSEE, 
			Callback = function(action)
				if action ~= nil then
					Wherigo.ShowScreen(Wherigo.DETAILSCREEN, zitemPawPrints)
				end
			end
		}
	end
end
function zoneSidePath2:OnProximity()
	if (ZoneCheck(zoneSidePath2)) == false then
		StatFeather = false
		zitemFeather:MoveTo(zoneSidePath2)
		_Urwigo.MessageBox{
			Text = _o9p("\100\012\025\111\099\016\025\078\068\068\108\099\078\058\125\025\106\125\052\012\025\078\108\008\078\046\025\111\099\016\025\012\008\008\025\012\099\059\008\106\125\052\027\040\025\099\027\025\106\125\008\025\040\108\099\016\027\023\057\057\057"), 
			Media = zmediaicSEE, 
			Callback = function(action)
				if action ~= nil then
					Wherigo.ShowScreen(Wherigo.DETAILSCREEN, zitemFeather)
				end
			end
		}
	end
end
function zinputNotepadInput:OnGetInput(input)
	NotePadEntry = input
end
function zinputMenuList:OnGetInput(input)
	MMMENUSEL = input
	if Wherigo.NoCaseEquals(MMMENUSEL, _o9p("\116\027\106\108\099\023\016\058\106\052\099\027")) then
		_Urwigo.Dialog(false, {
			{
				Text = _o9p("\073\049\110\118\109\025\039\008\017\058\099\059\008\025\106\099\025\032\106\125\016\017\125\016\025\032\078\017\017\008\023\025\116\116\116\025\077\025\100\106\025\106\125\008\025\089\023\040\008\025\099\033\025\035\078\023\027\008\012\012\043\025\071\125\052\012\025\039\125\008\108\052\040\099\025\078\023\013\008\027\106\016\108\008\025\030\078\012\025\023\008\012\052\040\027\008\023\025\106\099\025\085\008\025\016\012\008\023\025\052\027\025\058\099\027\090\016\027\058\106\052\099\027\025\030\052\106\125\025\015\008\099\058\078\058\125\008\025\015\032\034\032\127\047\067\057\025\097\099\016\025\059\078\111\025\068\017\078\111\025\106\125\052\012\025\099\033\033\017\052\027\008\025\052\027\025\078\027\025\008\059\016\017\078\106\099\108\025\099\108\025\099\027\103\012\052\106\008\025\030\052\106\125\025\078\025\012\016\068\068\099\108\106\008\023\025\023\008\013\052\058\008\057\025\071\099\025\108\008\058\008\052\013\008\025\058\108\008\023\052\106\025\033\099\108\025\106\125\008\025\058\078\058\125\008\046\025\111\099\016\025\030\052\017\017\025\012\106\052\017\017\025\027\008\008\023\025\106\099\025\040\099\025\106\099\025\106\125\008\025\033\052\027\078\017\025\058\099\099\108\023\052\027\078\106\008\012\025\040\052\013\008\027\025\052\027\025\106\125\008\025\040\078\059\008\025\016\068\099\027\025\058\099\059\068\017\008\106\052\099\027\025\078\027\023\025\068\125\111\012\052\058\078\017\017\111\025\012\052\040\027\025\106\125\008\025\017\099\040\085\099\099\024\057\025\039\008\025\125\099\068\008\025\111\099\016\025\008\027\090\099\111\025\106\125\008\025\078\023\013\008\027\106\016\108\008\043"), 
				Media = zmediaicFACEHAPPY
			}, 
			{
				Text = _o9p("\073\034\110\118\109\025\071\125\052\012\025\040\078\059\008\025\068\052\058\024\012\025\016\068\025\099\027\025\106\125\008\025\012\106\099\108\111\017\052\027\008\025\078\108\058\025\023\008\013\008\017\099\068\008\023\025\052\027\025\106\125\008\025\032\106\125\016\017\125\016\025\032\078\017\017\008\023\025\012\008\108\052\008\012\025\073\106\125\052\012\025\125\078\068\068\008\027\012\025\106\099\025\085\008\025\068\078\108\106\025\062\025\099\033\025\083\025\052\027\025\106\125\008\025\012\008\108\052\008\012\109\057\025\096\017\008\078\012\008\025\058\125\008\058\024\025\099\016\106\025\106\125\008\025\040\008\099\058\078\058\125\008\025\068\078\040\008\025\073\015\032\034\032\127\047\067\109\025\033\099\108\025\059\099\108\008\025\085\078\058\024\040\108\099\016\027\023\025\052\027\033\099\108\059\078\106\052\099\027\057\025\071\125\052\012\025\040\078\059\008\025\106\099\016\058\125\008\012\025\099\027\025\012\016\085\090\008\058\106\012\025\099\033\025\078\025\125\099\108\108\099\108\025\027\078\106\016\108\008\025\078\027\023\025\052\106\025\052\012\025\027\099\106\025\108\008\058\099\059\059\008\027\023\008\023\025\033\099\108\025\111\099\016\027\040\008\108\025\052\027\023\052\013\052\023\016\078\017\012\057\025\071\125\008\108\008\025\052\012\025\027\099\025\085\017\099\099\023\025\099\108\025\013\052\099\017\008\027\058\008\046\025\085\016\106\025\052\106\025\052\012\025\008\008\108\052\008\025\052\027\025\012\099\059\008\025\068\078\108\106\012\057\025\097\099\016\025\125\078\013\008\025\085\008\008\027\025\030\078\108\027\008\023\043"), 
				Media = zmediaicINFO
			}, 
			{
				Text = _o9p("\073\062\110\118\109\025\067\105\071\089\077\025\071\125\052\012\025\039\125\008\108\052\040\099\025\078\023\013\008\027\106\016\108\008\025\052\012\025\078\025\023\008\058\008\027\106\025\078\017\017\103\106\008\108\108\078\052\027\025\125\052\024\008\025\099\033\025\078\108\099\016\027\023\025\034\025\059\052\017\008\012\025\073\108\099\016\027\023\025\106\108\052\068\109\025\078\027\023\025\059\078\111\025\027\099\106\025\085\008\025\012\016\052\106\078\085\017\008\025\033\099\108\025\012\059\078\017\017\025\058\125\052\017\023\108\008\027\025\073\016\027\017\008\012\012\025\111\099\016\025\023\099\025\027\099\106\025\059\052\027\023\025\058\078\108\108\111\052\027\040\025\106\125\008\059\025\078\033\106\008\108\025\078\030\125\052\017\008\109\025\099\108\025\052\027\023\052\013\052\023\016\078\017\012\025\030\052\106\125\025\125\008\078\017\106\125\025\108\052\012\024\012\057\025\116\106\025\052\012\025\100\044\081\116\036\089\044\025\106\125\078\106\025\111\099\016\025\085\108\052\027\040\025\068\017\008\027\106\111\025\099\033\025\023\108\052\027\024\052\027\040\025\030\078\106\008\108\025\078\027\023\025\078\025\030\078\017\024\052\027\040\025\012\106\052\058\024\025\073\099\068\106\052\099\027\078\017\109\057\025\112\008\025\012\016\108\008\025\106\099\025\058\125\008\058\024\025\099\016\106\025\012\099\059\008\025\099\033\025\106\125\008\025\099\106\125\008\108\025\052\027\106\008\108\008\012\106\052\027\040\025\040\008\099\058\078\058\125\008\012\025\052\027\025\106\125\008\025\107\078\024\008\025\076\052\059\025\078\108\008\078\025\030\125\052\017\008\025\111\099\016\025\078\108\008\025\106\125\008\108\008\057\025\117\078\068\068\111\025\078\027\023\025\012\078\033\008\025\058\078\058\125\052\027\040\043"), 
				Media = zmediaicSTOP
			}
		}, function(action)
			_Urwigo.MessageBox{
				Text = _o9p("\073\118\110\118\109\025\097\099\016\025\125\078\013\008\025\012\016\108\013\052\013\008\023\025\106\125\008\025\125\078\108\108\099\030\052\027\040\025\125\099\108\108\099\108\012\025\073\015\032\034\032\127\047\096\109\025\099\033\025\106\125\008\025\023\078\108\024\025\108\008\058\008\012\012\008\012\025\099\033\025\106\125\008\025\008\078\108\106\125\025\078\027\023\025\023\052\012\058\099\013\008\108\008\023\025\106\125\008\025\033\078\106\008\025\099\033\025\106\125\008\025\008\012\099\106\008\108\052\058\025\106\099\059\008\046\025\106\125\008\025\015\008\099\027\099\059\052\058\099\027\025\073\015\032\034\032\083\049\118\109\046\025\024\008\008\068\008\108\025\099\033\025\106\125\008\025\012\008\058\108\008\106\012\025\099\033\025\076\045\017\111\008\125\046\025\106\125\008\025\012\016\027\024\008\027\025\058\052\106\111\025\030\125\008\108\008\025\012\017\008\008\068\052\027\040\025\032\106\125\016\017\125\016\046\025\030\099\108\017\023\025\023\008\012\106\108\099\111\008\108\046\025\017\052\008\012\025\012\017\008\008\068\052\027\040\046\025\030\078\052\106\052\027\040\025\033\099\108\025\106\125\008\025\023\078\111\025\106\099\025\085\008\025\108\008\078\030\078\024\008\027\025\106\099\025\085\108\052\027\040\025\078\085\099\016\106\025\125\016\059\078\027\052\106\111\045\012\025\023\008\059\052\012\008\057\025\097\099\016\025\040\008\106\025\052\027\106\099\025\111\099\016\108\025\058\078\108\025\078\027\023\025\085\008\040\052\027\025\106\099\025\125\008\078\023\025\125\099\059\008\057\057"), 
				Media = zmediaicCAR, 
				Buttons = {
					_o9p("\112\078\058\024\025\106\099\025\035\078\052\027\025\035\008\027\016")
				}, 
				Callback = function(action)
					if action ~= nil then
						_Urwigo.RunDialogs(function()
							Wherigo.GetInput(zinputMenuList)
						end)
					end
				end
			}
		end)
	end
	if Wherigo.NoCaseEquals(MMMENUSEL, _o9p("\116\027\012\106\108\016\058\106\052\099\027\012")) then
		_Urwigo.MessageBox{
			Text = _o9p("\116\067\036\071\076\050\032\071\116\105\067\036\077\025\071\125\052\012\025\052\012\025\078\027\025\052\027\106\008\108\078\058\106\052\013\008\025\078\023\013\008\027\106\016\108\008\057\025\122\099\016\108\027\008\111\025\106\125\108\099\016\040\125\025\106\125\008\025\023\078\108\024\025\012\052\023\008\025\099\033\025\012\078\027\052\106\111\025\016\027\106\052\017\025\111\099\016\025\108\008\078\058\125\025\106\125\008\025\089\023\040\008\025\099\033\025\035\078\023\027\008\012\012\057\025\100\012\025\111\099\016\025\106\108\008\024\025\106\125\108\099\016\040\125\025\106\125\008\025\030\052\017\023\012\046\025\111\099\016\108\025\036\078\027\052\106\111\025\030\052\017\017\025\085\008\025\106\008\012\106\008\023\025\052\027\025\059\078\027\111\025\030\078\111\012\057\025\097\099\016\108\025\036\078\027\052\106\111\025\017\008\013\008\017\046\025\078\027\025\016\027\008\055\068\017\078\052\027\008\023\025\071\052\059\008\108\025\078\027\023\025\097\105\050\076\025\058\125\099\052\058\008\012\025\030\052\017\017\025\023\008\106\008\108\059\052\027\008\025\106\125\008\025\033\052\027\078\017\025\099\016\106\058\099\059\008\025\099\033\025\111\099\016\108\025\090\099\016\108\027\008\111\057\025\032\078\027\025\111\099\016\025\059\078\024\008\025\052\106\025\106\099\025\106\125\008\025\008\027\023\025\030\052\106\125\025\111\099\016\108\025\036\078\027\052\106\111\025\052\027\106\078\058\106\025\085\008\033\099\108\008\025\106\125\008\025\071\052\059\008\108\025\108\016\027\012\025\099\016\106\021\025\044\099\027\045\106\025\030\099\108\108\111\046\025\111\099\016\108\025\068\108\099\040\108\008\012\012\025\030\052\017\017\025\085\008\025\078\016\106\099\059\078\106\052\058\078\017\017\111\025\012\078\013\008\023\025\078\017\099\027\040\025\106\125\008\025\030\078\111\025\052\027\025\058\078\012\008\025\078\027\111\106\125\052\027\040\057\057\057\025\023\052\108\008\057\057\057\025\012\125\099\016\017\023\025\125\078\068\068\008\027\057\025\100\106\025\106\125\008\025\008\027\023\046\025\078\025\012\058\099\108\008\025\030\052\017\017\025\085\008\025\040\052\013\008\027\025\085\078\012\008\023\025\099\027\025\111\099\016\108\025\068\008\108\033\099\108\059\078\027\058\008\057\025"), 
			Media = zmediaicCHECK, 
			Buttons = {
				_o9p("\032\099\027\106\052\027\016\008\057\057\057")
			}, 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.RunDialogs(function()
						Wherigo.GetInput(zinputMenuList)
					end)
				end
			end
		}
	end
	if Wherigo.NoCaseEquals(MMMENUSEL, _o9p("\100\112\105\050\071")) then
		_Urwigo.MessageBox{
			Text = _o9p("\103\025\036\099\059\008\025\085\078\058\024\040\108\099\016\027\023\025\052\059\078\040\008\012\025\032\099\068\111\108\052\040\125\106\057\025\102\112\076\018\025\076\111\078\027\025\112\017\052\012\012\025\073\023\052\040\052\106\078\017\085\017\078\012\068\125\008\059\111\057\058\099\059\109\025\102\112\076\018\025\050\012\008\023\025\030\052\106\125\025\068\008\108\059\052\012\012\052\099\027\025\073\012\008\008\025\012\052\106\008\109\057\025\102\112\076\018\025\103\025\036\099\059\008\025\068\125\099\106\099\012\025\032\099\068\111\108\052\040\125\106\057\025\102\112\076\018\025\036\106\008\068\125\008\027\025\039\052\017\012\099\027\025\073\059\008\109\057\025\102\112\076\018\025\050\012\008\023\025\030\052\106\125\025\059\111\025\099\030\027\025\068\008\108\059\052\012\012\052\099\027\057\025\102\112\076\018\025\103\025\105\106\125\008\108\025\052\059\078\040\008\012\025\078\013\078\052\017\078\085\017\008\025\013\052\078\025\068\016\085\017\052\058\025\023\099\059\078\052\027\057\102\112\076\018\025\032\108\008\078\106\052\013\008\025\032\099\059\059\099\027\012\025\107\052\058\008\027\012\008\057\025\102\112\076\018\025\103\025\036\099\016\027\023\012\110\035\016\012\052\058\025\073\033\108\008\008\012\099\016\027\023\057\099\108\040\109\102\112\076\018\025\032\108\008\078\106\052\013\008\025\032\099\059\059\099\027\012\025\107\052\058\008\027\012\008\057\025\009\027\085\012\068\095\009\027\085\012\068\095\009\027\085\012\068\095\102\112\076\018\025\071\125\078\027\024\012\025\040\099\008\012\025\106\099\077\025\102\112\076\018\025\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\102\112\076\018\025\103\025\106\125\008\025\068\108\099\040\108\078\059\059\008\108\012\025\099\027\025\106\125\008\025\039\125\008\108\052\040\099\025\033\099\108\016\059\012\025\102\112\076\018\025\033\099\108\025\106\125\008\025\106\052\068\012\025\078\027\023\025\058\099\023\008\025\012\027\052\068\068\008\106\012\046\025\027\078\059\008\017\111\077\102\112\076\018\076\078\027\040\008\108\025\047\099\055\102\112\076\018\058\078\027\106\016\017\078\027\023\102\112\076\018\058\125\078\108\017\008\027\027\052\102\112\076\018\059\078\106\008\090\058\052\024\102\112\076\018\102\112\076\018\025\103\025\059\111\025\085\008\078\016\106\052\033\016\017\025\039\099\111\052\025\073\071\078\027\111\078\109\102\112\076\018\025\033\099\108\025\068\016\106\106\052\027\040\025\016\068\025\030\052\106\125\025\059\008\025\078\027\023\025\017\099\013\052\027\040\025\059\008\102\112\076\018\102\112\076\018\025\103\025\015\108\099\016\027\023\012\068\008\078\024\025\102\112\076\018\025\033\099\108\025\059\078\024\052\027\040\025\106\125\052\012\025\068\099\012\012\052\085\017\008\102\112\076\018\073\085\016\106\046\025\030\125\111\025\125\078\012\106\025\106\125\099\016\025\033\099\108\012\078\024\008\027\102\112\076\018\111\099\016\108\025\108\008\023\103\125\008\078\023\008\023\025\012\106\008\068\025\068\108\099\040\008\027\111\021\109"), 
			Media = zmediaicSCROLL, 
			Buttons = {
				_o9p("\112\078\058\024\025\106\099\025\035\008\027\016")
			}, 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.RunDialogs(function()
						Wherigo.GetInput(zinputMenuList)
					end)
				end
			end
		}
	end
	if Wherigo.NoCaseEquals(MMMENUSEL, _o9p("\105\096\071\116\105\067\036")) then
		_Urwigo.RunDialogs(function()
			Wherigo.GetInput(zinputOptionsList)
		end)
	end
	if Wherigo.NoCaseEquals(MMMENUSEL, _o9p("\112\100\032\037\025\071\105\025\035\100\116\067")) then
		IgnoreMe = false
		Wherigo.ShowScreen(Wherigo.MAINSCREEN)
	end
	if Wherigo.NoCaseEquals(MMMENUSEL, _o9p("\036\071\100\076\071")) then
		if GameStart ~= true then
			Wherigo.PlayAudio(zmediaSNDBGMintro)
			if SuppEmulator == "ENABLED" or SuppOpenWIG == "ENABLED"  or SuppAndroid == "ENABLED" then
			animedia = {}
			        animedia = {
			        zmediaINTRO1,
			        zmediaINTRO2,
			        zmediaINTRO3, 
			        zmediaINTRO4,
			        zmediaINTRO5, 
			        zmediaINTRO6,
			        zmediaINTRO7,
			         zmediaINTRO8,
			         zmediaINTRO9,
			         zmediaINTRO10,
			         zmediaINTRO11,
			         zmediaINTRO12,
			         zmediaINTRO13,
			         zmediaINTRO14,
			         zmediaINTRO15,
			         zmediaINTRO16,
			         zmediaINTRO17,
			         zmediaINTRO18,
			         zmediaINTRO19,
			         zmediaINTRO20,
			         zmediaINTRO21,
			         zmediaINTRO22
			         }
			else
			animedia = {}
			  animedia = {
			  zmediaINTRO2,
			  zmediaINTRO4,
			  zmediaINTRO5,  
			  zmediaINTRO7, 
			  zmediaINTRO10, 
			  zmediaINTRO11, 
			  zmediaINTRO13, 
			  zmediaINTRO14, 
			  zmediaINTRO17, 
			  zmediaINTRO19, 
			  zmediaINTRO22
			  }
			end
			ztimerANIM:Start()
			ztimerSave:Start()
		end
	end
end
function zinputOptionsList:OnGetInput(input)
	MMOPTSEL = input
	if Wherigo.NoCaseEquals(MMOPTSEL, _o9p("\036\059\078\108\106\096\125\099\027\008\025\036\016\068\068\099\108\106")) then
		_Urwigo.RunDialogs(function()
			Wherigo.GetInput(zinputPhoneOptList)
		end)
	end
	if Wherigo.NoCaseEquals(MMOPTSEL, _o9p("\015\078\108\059\052\027\025\036\016\068\068\099\108\106")) then
		_Urwigo.MessageBox{
			Text = (_o9p("\036\008\017\008\058\106\025\106\125\052\012\025\099\068\106\052\099\027\025\052\033\025\111\099\016\025\078\108\008\025\068\017\078\111\052\027\040\025\099\027\025\078\025\039\125\008\108\052\040\099\103\012\016\068\068\099\108\106\008\023\025\015\078\108\059\052\027\025\023\008\013\052\058\008\057\025\032\008\108\106\078\052\027\025\012\008\106\106\052\027\040\012\025\030\052\017\017\025\085\008\025\008\027\078\085\017\008\023\025\099\108\025\023\052\012\078\085\017\008\023\025\106\099\025\008\027\012\016\108\008\025\099\068\106\052\059\052\065\008\023\025\058\099\059\068\078\106\052\085\052\017\052\106\111\025\033\099\108\025\015\078\108\059\052\027\025\023\008\013\052\058\008\012\057\025\073\036\106\078\106\016\012\077\025")..SuppGarmin).._o9p("\109"), 
			Media = zmediaicSAVE, 
			Buttons = {
				_o9p("\032\117\100\067\015\089"), 
				_o9p("\032\078\027\058\008\017")
			}, 
			Callback = function(action)
				if action ~= nil then
					if action == "Button1" then
						PHTest = SuppGarmin
						if Wherigo.NoCaseEquals(PHTest, _o9p("\044\116\036\100\112\107\089\044")) then
							SuppGarmin = _o9p("\089\067\100\112\107\089\044")
							_f2Wa = _o9p("\089\067\100\112\107\089\044")
							SuppSound = _o9p("\089\067\100\112\107\089\044")
							StatBar = _o9p("\044\116\036\100\112\107\089\044")
							SuppScreen = _o9p("\044\116\036\100\112\107\089\044")
							SuppStatTime = 10
							ztimerlilDOOM.Duration = SuppStatTime
							_Urwigo.MessageBox{
								Text = _o9p("\015\100\076\035\116\067\025\036\050\096\096\105\076\071\025\089\067\100\112\107\089\044\077\025\102\112\076\018\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\102\112\076\018\035\008\027\016\077\025\089\067\100\112\107\089\044\102\112\076\018\036\099\016\027\023\077\025\089\067\100\112\107\089\044\025\102\112\076\018\036\106\078\106\016\012\025\112\078\108\077\025\044\116\036\100\112\107\089\044\025\102\112\076\018\036\106\078\106\016\012\025\050\068\023\078\106\008\012\077\025\008\013\008\108\111\025\049\101\025\012\008\058\012\102\112\076\018\036\058\108\008\008\027\044\052\108\008\058\106\077\025\044\116\036\100\112\107\089\044"), 
								Media = zmediaicTHUMBU, 
								Buttons = {
									_o9p("\032\099\027\106\052\027\016\008\057\057\057")
								}, 
								Callback = function(action)
									if action ~= nil then
										_Urwigo.RunDialogs(function()
											Wherigo.GetInput(zinputOptionsList)
										end)
									end
								end
							}
						else
							SuppGarmin = _o9p("\044\116\036\100\112\107\089\044")
							_f2Wa = _o9p("\089\067\100\112\107\089\044")
							SuppSound = _o9p("\089\067\100\112\107\089\044")
							StatBar = _o9p("\089\067\100\112\107\089\044")
							SuppScreen = _o9p("\044\116\036\100\112\107\089\044")
							SuppStatTime = 10
							ztimerlilDOOM.Duration = SuppStatTime
							_Urwigo.MessageBox{
								Text = _o9p("\015\100\076\035\116\067\025\036\050\096\096\105\076\071\025\044\116\036\100\112\107\089\044\077\025\102\112\076\018\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\102\112\076\018\035\008\027\016\077\025\089\067\100\112\107\089\044\102\112\076\018\036\099\016\027\023\077\025\089\067\100\112\107\089\044\025\102\112\076\018\036\106\078\106\016\012\025\112\078\108\077\025\089\067\100\112\107\089\044\025\102\112\076\018\036\106\078\106\016\012\025\050\068\023\078\106\008\012\077\025\008\013\008\108\111\025\049\101\025\012\008\058\012\102\112\076\018\036\058\108\008\008\027\044\052\108\008\058\106\077\025\089\067\100\112\107\089\044"), 
								Media = zmediaicTHUMBD, 
								Buttons = {
									_o9p("\032\099\027\106\052\027\016\008\057\057\057")
								}, 
								Callback = function(action)
									if action ~= nil then
										_Urwigo.RunDialogs(function()
											Wherigo.GetInput(zinputOptionsList)
										end)
									end
								end
							}
						end
					else
						_Urwigo.RunDialogs(function()
							Wherigo.GetInput(zinputOptionsList)
						end)
					end
				end
			end
		}
	end
	if Wherigo.NoCaseEquals(MMOPTSEL, _o9p("\096\032\025\036\016\068\068\099\108\106")) then
		_Urwigo.MessageBox{
			Text = (_o9p("\036\008\017\008\058\106\025\106\125\052\012\025\099\068\106\052\099\027\025\052\033\025\111\099\016\025\078\108\008\025\068\017\078\111\052\027\040\025\013\052\078\025\106\125\008\025\089\059\016\017\078\106\099\108\025\099\027\025\078\025\096\032\057\025\032\008\108\106\078\052\027\025\012\008\106\106\052\027\040\012\025\030\052\017\017\025\085\008\025\008\027\078\085\017\008\023\025\099\108\025\023\052\012\078\085\017\008\023\025\106\099\025\008\027\012\016\108\008\025\099\068\106\052\059\052\065\008\023\025\058\099\059\068\078\106\052\085\052\017\052\106\111\025\033\099\108\025\099\033\033\017\052\027\008\025\089\059\016\017\078\106\099\108\025\068\017\078\111\057\025\073\036\106\078\106\016\012\077\025")..SuppEmulator).._o9p("\109"), 
			Media = zmediaicSAVE, 
			Buttons = {
				_o9p("\032\117\100\067\015\089"), 
				_o9p("\032\078\027\058\008\017")
			}, 
			Callback = function(action)
				if action ~= nil then
					if action == "Button1" then
						PHTest = SuppEmulator
						if Wherigo.NoCaseEquals(PHTest, _o9p("\044\116\036\100\112\107\089\044")) then
							SuppEmulator = _o9p("\089\067\100\112\107\089\044")
							_f2Wa = _o9p("\089\067\100\112\107\089\044")
							SuppSound = _o9p("\089\067\100\112\107\089\044")
							StatBar = _o9p("\089\067\100\112\107\089\044")
							SuppScreen = _o9p("\089\067\100\112\107\089\044")
							SuppStatTime = 1
							ztimerlilDOOM.Duration = SuppStatTime
							_Urwigo.MessageBox{
								Text = _o9p("\096\032\025\036\050\096\096\105\076\071\025\089\067\100\112\107\089\044\077\025\102\112\076\018\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\102\112\076\018\035\008\027\016\077\025\089\067\100\112\107\089\044\102\112\076\018\036\099\016\027\023\077\025\089\067\100\112\107\089\044\025\102\112\076\018\036\106\078\106\016\012\025\112\078\108\077\025\089\067\100\112\107\089\044\102\112\076\018\036\106\078\106\016\012\025\050\068\023\078\106\008\012\077\025\008\013\008\108\111\025\049\025\012\008\058\012\102\112\076\018\036\058\108\008\008\027\044\052\108\008\058\106\077\025\089\067\100\112\107\089\044"), 
								Media = zmediaicTHUMBU, 
								Buttons = {
									_o9p("\032\099\027\106\052\027\016\008\057\057\057")
								}, 
								Callback = function(action)
									if action ~= nil then
										_Urwigo.RunDialogs(function()
											Wherigo.GetInput(zinputOptionsList)
										end)
									end
								end
							}
						else
							SuppEmulator = _o9p("\044\116\036\100\112\107\089\044")
							_f2Wa = _o9p("\089\067\100\112\107\089\044")
							SuppSound = _o9p("\044\116\036\100\112\107\089\044")
							StatBar = _o9p("\044\116\036\100\112\107\089\044")
							SuppScreen = _o9p("\044\116\036\100\112\107\089\044")
							SuppStatTime = 10
							ztimerlilDOOM.Duration = SuppStatTime
							_Urwigo.MessageBox{
								Text = _o9p("\096\032\025\036\050\096\096\105\076\071\025\044\116\036\100\112\107\089\044\077\025\102\112\076\018\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\102\112\076\018\035\008\027\016\077\025\089\067\100\112\107\089\044\102\112\076\018\036\099\016\027\023\077\025\044\116\036\100\112\107\089\044\025\102\112\076\018\036\106\078\106\016\012\025\112\078\108\077\025\044\116\036\100\112\107\089\044\102\112\076\018\036\106\078\106\016\012\025\050\068\023\078\106\008\012\077\025\008\013\008\108\111\025\049\101\025\012\008\058\012\102\112\076\018\036\058\108\008\008\027\044\052\108\008\058\106\077\025\044\116\036\100\112\107\089\044"), 
								Media = zmediaicTHUMBD, 
								Buttons = {
									_o9p("\032\099\027\106\052\027\016\008\057\057\057")
								}, 
								Callback = function(action)
									if action ~= nil then
										_Urwigo.RunDialogs(function()
											Wherigo.GetInput(zinputOptionsList)
										end)
									end
								end
							}
						end
					else
						_Urwigo.RunDialogs(function()
							Wherigo.GetInput(zinputOptionsList)
						end)
					end
				end
			end
		}
	end
	if Wherigo.NoCaseEquals(MMOPTSEL, _o9p("\100\023\013\078\027\058\008\023\025\105\068\106\052\099\027\012")) then
		_Urwigo.RunDialogs(function()
			Wherigo.GetInput(zinputAdvOptList)
		end)
	end
	if Wherigo.NoCaseEquals(MMOPTSEL, _o9p("\112\078\058\024\025\106\099\025\035\008\027\016")) then
		_Urwigo.RunDialogs(function()
			Wherigo.GetInput(zinputMenuList)
		end)
	end
end
function zinputAdjustStatTime:OnGetInput(input)
	STUvar = tonumber(input)
	if (STUvar < 100) and (STUvar > 0) then
		SuppStatTime = STUvar
		ztimerlilDOOM.Duration = SuppStatTime
		_Urwigo.MessageBox{
			Text = (_o9p("\036\106\078\106\016\012\025\050\068\023\078\106\008\012\025\012\008\106\025\106\099\025\108\008\033\108\008\012\125\025\008\013\008\108\111\025")..SuppStatTime).._o9p("\025\012\008\058\012\057"), 
			Media = zmediaicSAVE, 
			Buttons = {
				_o9p("\032\099\027\106\052\027\016\008\057\057\057")
			}, 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.RunDialogs(function()
						Wherigo.GetInput(zinputAdvOptList)
					end)
				end
			end
		}
	else
		_Urwigo.MessageBox{
			Text = (_o9p("\036\106\078\106\016\012\025\050\068\023\078\106\008\012\025\106\052\059\052\027\040\025\016\027\058\125\078\027\040\008\023\057\025\107\008\078\013\052\027\040\025\108\008\033\108\008\012\125\025\078\106\025\008\013\008\108\111\025")..SuppStatTime).._o9p("\025\012\008\058\012\057"), 
			Media = zmediaicSAVE, 
			Buttons = {
				_o9p("\032\099\027\106\052\027\016\008\057\057\057")
			}, 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.RunDialogs(function()
						Wherigo.GetInput(zinputAdvOptList)
					end)
				end
			end
		}
	end
end
function zinputAdvOptList:OnGetInput(input)
	MMADVOPTSEL = input
	if Wherigo.NoCaseEquals(MMADVOPTSEL, _o9p("\035\008\027\016\025\036\016\068\068\099\108\106")) then
		_Urwigo.MessageBox{
			Text = (_o9p("\036\008\017\008\058\106\025\106\125\052\012\025\099\068\106\052\099\027\025\052\033\025\111\099\016\025\030\078\027\106\025\035\008\027\016\025\036\016\068\068\099\108\106\025\008\027\078\085\017\008\023\025\073\016\012\008\012\025\068\108\099\068\008\108\025\052\027\068\016\106\025\017\052\012\106\103\085\078\012\008\023\025\059\008\027\016\012\109\057\025\071\125\052\012\025\052\012\025\106\016\108\027\008\023\025\099\027\025\085\111\025\023\008\033\078\016\017\106\025\085\016\106\025\078\013\078\052\017\078\085\017\008\025\033\099\108\025\106\016\108\027\052\027\040\025\099\033\033\025\078\012\025\078\025\030\099\108\024\078\108\099\016\027\023\025\033\099\108\025\106\125\008\025\039\125\008\108\096\052\015\099\025\073\116\103\096\125\099\027\008\109\025\068\017\078\111\008\108\025\078\027\023\025\052\033\025\111\099\016\025\068\108\008\033\008\108\025\052\106\008\059\103\085\078\012\008\023\025\059\008\027\016\012\025\073\023\052\033\033\008\108\008\027\106\025\017\099\099\024\025\099\027\025\012\099\059\008\025\023\008\013\052\058\008\012\109\057\025\009\027\085\012\068\095\102\112\076\018\073\036\106\078\106\016\012\077\025").._f2Wa).._o9p("\109"), 
			Media = zmediaicSAVE, 
			Buttons = {
				_o9p("\032\117\100\067\015\089"), 
				_o9p("\032\078\027\058\008\017")
			}, 
			Callback = function(action)
				if action ~= nil then
					if action == "Button1" then
						PHTest = _f2Wa
						if Wherigo.NoCaseEquals(PHTest, _o9p("\044\116\036\100\112\107\089\044")) then
							_f2Wa = _o9p("\089\067\100\112\107\089\044")
							_Urwigo.MessageBox{
								Text = _o9p("\035\089\067\050\025\036\050\096\096\105\076\071\025\089\067\100\112\107\089\044\077\102\112\076\018\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\102\112\076\018\039\052\106\125\025\035\008\027\016\025\036\016\068\068\099\108\106\025\089\067\100\112\107\089\044\046\025\078\017\017\025\059\008\027\016\012\025\030\052\017\017\025\016\012\008\025\052\027\068\016\106\025\017\052\012\106\103\085\078\012\008\023\025\059\008\027\016\012\025\073\023\008\033\078\016\017\106\109\046\102\112\076\018"), 
								Media = zmediaicTHUMBU, 
								Buttons = {
									_o9p("\032\099\027\106\052\027\016\008\057\057\057")
								}, 
								Callback = function(action)
									if action ~= nil then
										_Urwigo.RunDialogs(function()
											Wherigo.GetInput(zinputAdvOptList)
										end)
									end
								end
							}
						else
							_f2Wa = _o9p("\044\116\036\100\112\107\089\044")
							_Urwigo.MessageBox{
								Text = _o9p("\035\089\067\050\025\036\050\096\096\105\076\071\025\044\116\036\100\112\107\089\044\077\102\112\076\018\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\102\112\076\018\039\052\106\125\025\035\008\027\016\025\036\016\068\068\099\108\106\025\044\116\036\100\112\107\089\044\046\025\078\017\017\025\059\008\027\016\012\025\030\052\017\017\025\016\012\008\025\052\106\008\059\103\085\078\012\008\023\025\059\008\027\016\012\025\073\030\125\008\108\008\025\078\013\078\052\017\078\085\017\008\109\025\067\099\106\008\077\025\071\125\052\012\025\052\012\025\068\108\099\013\052\023\008\023\025\059\078\052\027\017\111\025\078\012\025\078\025\085\016\040\025\030\099\108\024\078\108\099\016\027\023\025\033\099\108\025\106\125\008\025\039\125\008\108\096\052\015\099\025\068\017\078\111\008\108\025\078\027\023\025\033\099\108\025\106\125\099\012\008\025\106\125\078\106\025\068\108\008\033\008\108\025\106\125\008\025\017\099\099\024\025\099\033\025\052\106\008\059\103\085\078\012\008\023\025\017\052\012\106\012\057"), 
								Media = zmediaicTHUMBD, 
								Buttons = {
									_o9p("\032\099\027\106\052\027\016\008\057\057\057")
								}, 
								Callback = function(action)
									if action ~= nil then
										_Urwigo.RunDialogs(function()
											Wherigo.GetInput(zinputAdvOptList)
										end)
									end
								end
							}
						end
					else
						_Urwigo.RunDialogs(function()
							Wherigo.GetInput(zinputAdvOptList)
						end)
					end
				end
			end
		}
	end
	if Wherigo.NoCaseEquals(MMADVOPTSEL, _o9p("\036\099\016\027\023\025\036\016\068\068\099\108\106")) then
		_Urwigo.MessageBox{
			Text = (_o9p("\036\008\017\008\058\106\025\106\125\052\012\025\099\068\106\052\099\027\025\052\033\025\111\099\016\025\030\078\027\106\025\106\099\025\008\027\078\085\017\008\025\012\099\016\027\023\057\025\116\033\025\008\027\078\085\017\008\023\025\099\027\025\078\025\015\078\108\059\052\027\046\025\106\125\008\025\012\111\012\106\008\059\025\030\052\017\017\025\078\016\106\099\059\078\106\052\058\078\017\017\111\025\078\106\106\008\059\068\106\025\106\099\025\012\016\068\068\099\108\106\025\047\044\107\025\012\099\016\027\023\025\033\052\017\008\012\025\073\052\033\025\078\068\068\017\052\058\078\085\017\008\109\057\025\116\033\025\111\099\016\025\078\108\008\025\008\055\068\008\108\052\008\027\058\052\027\040\025\058\108\078\012\125\008\012\046\025\023\052\012\078\085\017\008\025\012\099\016\027\023\025\078\027\023\025\012\008\008\025\052\033\025\052\106\025\125\008\017\068\012\057\025\102\112\076\018\073\036\106\078\106\016\012\077\025")..SuppSound).._o9p("\109"), 
			Media = zmediaicSAVE, 
			Buttons = {
				_o9p("\032\117\100\067\015\089"), 
				_o9p("\032\078\027\058\008\017")
			}, 
			Callback = function(action)
				if action ~= nil then
					if action == "Button1" then
						PHTest = SuppSound
						if Wherigo.NoCaseEquals(PHTest, _o9p("\044\116\036\100\112\107\089\044")) then
							SuppSound = _o9p("\089\067\100\112\107\089\044")
							Wherigo.PlayAudio(zmediaSNDnoservice)
							_Urwigo.MessageBox{
								Text = _o9p("\036\105\050\067\044\025\036\050\096\096\105\076\071\025\089\067\100\112\107\089\044\077\025\102\112\076\018\025\009\027\085\012\068\095\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\025\102\112\076\018\025\009\027\085\012\068\095\035\096\062\110\039\100\081\025\036\099\016\027\023\077\025\089\067\100\112\107\089\044\025\102\112\076\018\025\009\027\085\012\068\095\047\044\107\025\036\099\016\027\023\077\025\089\067\100\112\107\089\044\025\073\052\033\025\016\012\052\027\040\025\015\078\108\059\052\027\109\102\112\076\018\102\112\076\018\025\009\027\085\012\068\095\071\008\012\106\052\027\040\025\036\099\016\027\023\057\057\057\102\112\076\018\025\009\027\085\012\068\095\073\111\099\016\025\012\125\099\016\017\023\025\125\078\013\008\025\125\008\078\108\023\025\012\099\059\008\025\106\099\027\008\025\085\008\008\068\012\109"), 
								Media = zmediaicTHUMBU, 
								Buttons = {
									_o9p("\032\099\027\106\052\027\016\008\057\057\057")
								}, 
								Callback = function(action)
									if action ~= nil then
										_Urwigo.RunDialogs(function()
											Wherigo.GetInput(zinputAdvOptList)
										end)
									end
								end
							}
						else
							SuppSound = _o9p("\044\116\036\100\112\107\089\044")
							_Urwigo.MessageBox{
								Text = _o9p("\036\105\050\067\044\025\036\050\096\096\105\076\071\025\044\116\036\100\112\107\089\044\077\025\102\112\076\018\025\009\027\085\012\068\095\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\102\112\076\018\025\009\027\085\012\068\095\035\096\062\110\039\100\081\025\036\099\016\027\023\077\025\044\116\036\100\112\107\089\044\025\102\112\076\018\025\009\027\085\012\068\095\047\044\107\025\036\099\016\027\023\077\025\044\116\036\100\112\107\089\044"), 
								Media = zmediaicTHUMBD, 
								Buttons = {
									_o9p("\032\099\027\106\052\027\016\008\057\057\057")
								}, 
								Callback = function(action)
									if action ~= nil then
										_Urwigo.RunDialogs(function()
											Wherigo.GetInput(zinputAdvOptList)
										end)
									end
								end
							}
						end
					else
						_Urwigo.RunDialogs(function()
							Wherigo.GetInput(zinputAdvOptList)
						end)
					end
				end
			end
		}
	end
	if Wherigo.NoCaseEquals(MMADVOPTSEL, _o9p("\036\106\078\106\016\012\025\112\078\108\025\036\016\068\068\099\108\106")) then
		_Urwigo.MessageBox{
			Text = (_o9p("\036\008\017\008\058\106\025\106\125\052\012\025\099\068\106\052\099\027\025\052\033\025\111\099\016\025\030\078\027\106\025\106\125\008\025\036\106\078\106\016\012\025\112\078\108\025\008\027\078\085\017\008\023\025\073\012\125\099\030\012\025\108\008\078\017\103\106\052\059\008\025\052\027\033\099\108\059\078\106\052\099\027\025\017\052\024\008\025\036\078\027\052\106\111\025\078\027\023\025\071\052\059\008\108\109\057\025\050\027\033\099\108\106\016\027\078\106\008\017\111\046\025\106\125\052\012\025\099\068\106\052\099\027\025\023\099\008\012\025\027\099\106\025\030\099\108\024\025\030\008\017\017\025\099\027\025\058\008\108\106\078\052\027\025\068\017\078\111\008\108\012\057\025\071\016\108\027\025\099\033\033\046\025\052\033\025\111\099\016\025\078\108\008\025\008\055\068\008\108\052\008\027\058\052\027\040\025\068\108\099\085\017\008\059\012\025\099\108\025\012\058\108\008\008\027\025\052\012\012\016\008\012\057\025\102\112\076\018\073\036\106\078\106\016\012\077\025")..StatBar).._o9p("\109"), 
			Media = zmediaicSAVE, 
			Buttons = {
				_o9p("\032\117\100\067\015\089"), 
				_o9p("\032\078\027\058\008\017")
			}, 
			Callback = function(action)
				if action ~= nil then
					if action == "Button1" then
						PHTest = StatBar
						if Wherigo.NoCaseEquals(PHTest, _o9p("\044\116\036\100\112\107\089\044")) then
							StatBar = _o9p("\089\067\100\112\107\089\044")
							_Urwigo.MessageBox{
								Text = _o9p("\036\071\100\071\050\036\025\112\100\076\025\089\067\100\112\107\089\044\077\102\112\076\018\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\102\112\076\018\036\052\027\058\008\025\106\125\008\025\036\106\078\106\016\012\025\112\078\108\025\052\012\025\089\067\100\112\107\089\044\046\025\111\099\016\025\030\052\017\017\025\085\008\025\078\085\017\008\025\106\099\025\013\052\008\030\025\106\125\008\025\036\078\027\052\106\111\025\107\008\013\008\017\025\078\027\023\025\044\099\099\059\025\071\052\059\008\108\025\085\111\025\017\099\099\024\052\027\040\025\078\106\025\106\125\008\025\085\099\106\106\099\059\025\099\108\025\106\099\068\025\099\033\025\111\099\016\108\025\023\008\013\052\058\008\025\073\111\099\016\025\058\078\027\025\078\017\012\099\025\013\052\008\030\025\106\125\008\025\052\027\033\099\025\085\111\025\058\125\008\058\024\052\027\040\025\106\125\008\025\071\100\036\037\036\025\078\108\008\078\057"), 
								Media = zmediaicTHUMBU, 
								Buttons = {
									_o9p("\032\099\027\106\052\027\016\008\057\057\057")
								}, 
								Callback = function(action)
									if action ~= nil then
										_Urwigo.RunDialogs(function()
											Wherigo.GetInput(zinputAdvOptList)
										end)
									end
								end
							}
						else
							StatBar = _o9p("\044\116\036\100\112\107\089\044")
							_Urwigo.MessageBox{
								Text = _o9p("\036\071\100\071\050\036\025\112\100\076\025\044\116\036\100\112\107\089\044\077\102\112\076\018\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\102\112\076\018\036\052\027\058\008\025\106\125\008\025\036\106\078\106\016\012\025\112\078\108\025\052\012\025\044\116\036\100\112\107\089\044\046\025\111\099\016\025\058\078\027\025\040\008\106\025\106\125\008\025\036\078\027\052\106\111\025\107\008\013\008\017\025\099\108\025\044\099\099\059\025\071\052\059\008\108\025\085\111\025\058\125\008\058\024\052\027\040\025\106\125\008\025\071\100\036\037\036\025\078\108\008\078\025\073\111\099\016\025\058\078\027\025\078\017\012\099\025\040\008\106\025\111\099\016\108\025\058\016\108\108\008\027\106\025\017\099\058\078\106\052\099\027\025\052\027\033\099\108\059\078\106\052\099\027\025\033\108\099\059\025\106\125\008\108\008\025\106\099\099\109\057"), 
								Media = zmediaicTHUMBD, 
								Buttons = {
									_o9p("\032\099\027\106\052\027\016\008\057\057\057")
								}, 
								Callback = function(action)
									if action ~= nil then
										_Urwigo.RunDialogs(function()
											Wherigo.GetInput(zinputAdvOptList)
										end)
									end
								end
							}
						end
					else
						_Urwigo.RunDialogs(function()
							Wherigo.GetInput(zinputAdvOptList)
						end)
					end
				end
			end
		}
	end
	if Wherigo.NoCaseEquals(MMADVOPTSEL, _o9p("\044\052\108\008\058\106\025\036\058\108\008\008\027\025\036\016\068\068\099\108\106")) then
		_Urwigo.MessageBox{
			Text = (_o9p("\036\008\017\008\058\106\025\106\125\052\012\025\099\068\106\052\099\027\025\052\033\025\111\099\016\025\030\078\027\106\025\036\058\108\008\008\027\044\052\108\008\058\106\025\036\016\068\068\099\108\106\025\008\027\078\085\017\008\023\025\073\078\017\017\099\030\012\025\012\030\052\106\058\125\052\027\040\025\023\052\108\008\058\106\025\106\099\025\012\068\008\058\052\033\052\058\025\012\058\108\008\008\027\012\025\030\125\008\027\025\008\013\008\027\106\012\025\099\108\025\052\106\008\059\012\025\068\099\068\025\016\068\109\057\025\050\027\033\099\108\106\016\027\078\106\008\017\111\046\025\106\125\052\012\025\099\068\106\052\099\027\025\023\099\008\012\025\027\099\106\025\030\099\108\024\025\030\008\017\017\025\099\027\025\058\008\108\106\078\052\027\025\068\017\078\111\008\108\012\025\078\027\023\025\023\099\008\012\027\106\025\030\099\108\024\025\078\017\017\025\106\125\008\025\106\052\059\008\025\078\027\111\030\078\111\012\057\025\071\016\108\027\025\099\033\033\046\025\052\033\025\111\099\016\025\078\108\008\025\008\055\068\008\108\052\008\027\058\052\027\040\025\068\108\099\085\017\008\059\012\025\099\108\025\012\058\108\008\008\027\025\052\012\012\016\008\012\057\025\102\112\076\018\073\036\106\078\106\016\012\077\025")..SuppScreen).._o9p("\109"), 
			Media = zmediaicSAVE, 
			Buttons = {
				_o9p("\032\117\100\067\015\089"), 
				_o9p("\032\078\027\058\008\017")
			}, 
			Callback = function(action)
				if action ~= nil then
					if action == "Button1" then
						PHTest = SuppScreen
						if Wherigo.NoCaseEquals(PHTest, _o9p("\044\116\036\100\112\107\089\044")) then
							SuppScreen = _o9p("\089\067\100\112\107\089\044")
							_Urwigo.MessageBox{
								Text = _o9p("\036\032\076\089\089\067\044\116\076\089\032\071\025\036\050\096\096\105\076\071\025\089\067\100\112\107\089\044\077\102\112\076\018\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\102\112\076\018\039\052\106\125\025\036\058\108\008\008\027\025\044\052\108\008\058\106\025\089\067\100\112\107\089\044\046\025\111\099\016\025\030\052\017\017\025\085\008\025\106\078\024\008\027\025\023\052\108\008\058\106\017\111\025\073\125\099\068\008\033\016\017\017\111\109\025\106\099\025\078\068\068\108\099\068\108\052\078\106\008\025\012\058\108\008\008\027\012\025\030\125\008\027\025\052\106\008\059\012\025\099\108\025\008\013\008\027\106\012\025\078\058\106\052\013\078\106\008\025\073\108\078\106\125\008\108\025\106\125\078\027\025\106\125\008\025\035\078\052\027\025\036\058\108\008\008\027\109\057"), 
								Media = zmediaicTHUMBU, 
								Buttons = {
									_o9p("\032\099\027\106\052\027\016\008\057\057\057")
								}, 
								Callback = function(action)
									if action ~= nil then
										_Urwigo.RunDialogs(function()
											Wherigo.GetInput(zinputAdvOptList)
										end)
									end
								end
							}
						else
							SuppScreen = _o9p("\044\116\036\100\112\107\089\044")
							_Urwigo.MessageBox{
								Text = _o9p("\036\032\076\089\089\067\044\116\076\089\032\071\025\036\050\096\096\105\076\071\025\044\116\036\100\112\107\089\044\077\102\112\076\018\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\102\112\076\018\039\052\106\125\025\036\058\108\008\008\027\025\044\052\108\008\058\106\025\044\116\036\100\112\107\089\044\046\025\111\099\016\025\030\052\017\017\025\085\008\025\106\078\024\008\027\025\023\052\108\008\058\106\017\111\025\106\099\025\106\125\008\025\035\078\052\027\025\012\058\108\008\008\027\025\030\125\008\027\025\052\106\008\059\012\025\099\108\025\008\013\008\027\106\012\025\078\058\106\052\013\078\106\008\025\073\108\078\106\125\008\108\025\106\125\078\027\025\106\125\008\025\078\068\068\108\099\068\108\052\078\106\008\025\012\058\108\008\008\027\012\109\057"), 
								Media = zmediaicTHUMBD, 
								Buttons = {
									_o9p("\032\099\027\106\052\027\016\008\057\057\057")
								}, 
								Callback = function(action)
									if action ~= nil then
										_Urwigo.RunDialogs(function()
											Wherigo.GetInput(zinputAdvOptList)
										end)
									end
								end
							}
						end
					else
						_Urwigo.RunDialogs(function()
							Wherigo.GetInput(zinputAdvOptList)
						end)
					end
				end
			end
		}
	end
	if Wherigo.NoCaseEquals(MMADVOPTSEL, _o9p("\036\106\078\106\016\012\025\050\068\023\078\106\008\025\071\052\059\052\027\040")) then
		_Urwigo.MessageBox{
			Text = (_o9p("\036\008\017\008\058\106\025\106\125\052\012\025\099\068\106\052\099\027\025\052\033\025\111\099\016\025\030\078\027\106\025\106\099\025\078\023\090\016\012\106\025\106\125\008\025\108\008\033\108\008\012\125\025\106\052\059\052\027\040\025\099\027\025\106\125\008\025\036\106\078\106\016\012\025\050\068\023\078\106\008\025\073\036\106\078\106\016\012\025\112\078\108\025\078\027\023\110\099\108\025\071\078\012\024\025\116\027\033\099\108\059\078\106\052\099\027\025\030\052\017\017\025\099\027\017\111\025\108\008\033\017\008\058\106\025\058\016\108\108\008\027\106\025\052\027\033\099\108\059\078\106\052\099\027\025\008\013\008\108\111\025\079\025\012\008\058\099\027\023\012\109\025\102\112\076\018\073\036\106\078\106\016\012\077\025")..SuppStatTime).._o9p("\025\012\008\058\099\027\023\012\109"), 
			Media = zmediaicSAVE, 
			Buttons = {
				_o9p("\032\117\100\067\015\089"), 
				_o9p("\032\078\027\058\008\017")
			}, 
			Callback = function(action)
				if action ~= nil then
					if action == "Button1" then
						_Urwigo.RunDialogs(function()
							Wherigo.GetInput(zinputAdjustStatTime)
						end)
					else
						_Urwigo.RunDialogs(function()
							Wherigo.GetInput(zinputAdvOptList)
						end)
					end
				end
			end
		}
	end
	if Wherigo.NoCaseEquals(MMADVOPTSEL, _o9p("\096\017\078\111\100\027\111\030\125\008\108\008")) then
		_Urwigo.MessageBox{
			Text = (_o9p("\036\008\017\008\058\106\025\106\125\052\012\025\099\068\106\052\099\027\025\052\033\025\111\099\016\025\030\078\027\106\025\106\099\025\106\008\012\106\025\106\125\008\025\058\078\108\106\108\052\023\040\008\025\078\012\025\078\025\096\017\078\111\100\027\111\030\125\008\108\008\025\058\078\108\106\108\052\023\040\008\025\073\058\078\027\025\085\008\025\068\017\078\111\008\023\025\078\027\111\030\125\008\108\008\046\025\125\008\027\058\008\025\106\125\008\025\027\078\059\008\109\025\067\105\071\089\077\025\071\125\052\012\025\099\068\106\052\099\027\025\052\012\025\059\078\052\027\017\111\025\033\099\108\025\052\027\052\106\052\078\017\025\106\008\012\106\052\027\040\025\078\027\023\025\027\099\106\025\013\008\108\111\025\125\008\017\068\033\016\017\025\033\099\108\025\059\016\058\125\025\008\017\012\008\025\023\016\008\025\106\099\025\106\125\008\025\016\027\052\069\016\008\025\017\078\111\099\016\106\025\099\033\025\106\125\008\025\068\017\078\111\052\027\040\025\033\052\008\017\023\025\027\099\108\025\052\012\025\052\106\025\040\016\078\108\078\027\106\008\008\023\025\106\099\025\030\099\108\024\025\099\027\025\078\017\017\025\023\008\013\052\058\008\012\057\102\112\076\018\073\036\106\078\106\016\012\077\025")..SuppPA).._o9p("\109"), 
			Media = zmediaicSAVE, 
			Buttons = {
				_o9p("\032\117\100\067\015\089"), 
				_o9p("\032\078\027\058\008\017")
			}, 
			Callback = function(action)
				if action ~= nil then
					if action == "Button1" then
						PHTest = SuppPA
						if Wherigo.NoCaseEquals(PHTest, _o9p("\044\116\036\100\112\107\089\044")) then
							SuppPA = _o9p("\089\067\100\112\107\089\044")
							TestVar = (""..(MakePA()))..""
							_Urwigo.MessageBox{
								Text = _o9p("\096\107\100\097\100\067\097\039\117\089\076\089\025\036\050\096\096\105\076\071\025\089\067\100\112\107\089\044\077\102\112\076\018\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\102\112\076\018\039\052\106\125\025\096\017\078\111\100\027\111\030\125\008\108\008\025\036\016\068\068\099\108\106\025\089\067\100\112\107\089\044\046\025\106\125\008\025\012\106\078\108\106\052\027\040\025\058\099\099\108\023\052\027\078\106\008\012\025\033\099\108\025\106\125\008\025\040\078\059\008\025\030\052\017\017\025\085\008\025\016\068\023\078\106\008\023\025\106\099\025\111\099\016\108\025\058\016\108\108\008\027\106\025\017\099\058\078\106\052\099\027\025\078\027\023\025\111\099\016\025\058\078\027\025\068\017\078\111\025\106\125\008\025\040\078\059\008\025\030\125\008\108\008\013\008\108\025\111\099\016\025\078\108\008\025\073\067\105\071\089\077\025\023\016\008\025\106\099\025\106\125\008\025\016\027\016\012\016\078\017\025\017\078\111\099\016\106\025\099\033\025\106\125\008\025\099\108\052\040\052\027\078\017\025\068\017\078\111\052\027\040\025\033\052\008\017\023\046\025\111\099\016\025\059\078\111\025\027\099\106\025\085\008\025\078\085\017\008\025\106\099\025\068\017\078\111\025\106\125\008\025\040\078\059\008\025\068\108\099\068\008\108\017\111\057\025\071\125\052\012\025\033\008\078\106\016\108\008\025\052\012\025\052\059\068\017\008\059\008\027\106\008\023\025\059\078\052\027\017\111\025\033\099\108\025\071\089\036\071\116\067\015\025\096\050\076\096\105\036\089\036\025\105\067\107\097\109"), 
								Media = zmediaicTHUMBU, 
								Buttons = {
									_o9p("\032\099\027\106\052\027\016\008\057\057\057")
								}, 
								Callback = function(action)
									if action ~= nil then
										_Urwigo.RunDialogs(function()
											Wherigo.GetInput(zinputAdvOptList)
										end)
									end
								end
							}
						else
							SuppPA = _o9p("\044\116\036\100\112\107\089\044")
							TestVar = (""..(MakePA()))..""
							_Urwigo.MessageBox{
								Text = _o9p("\096\107\100\097\100\067\097\039\117\089\076\089\025\036\050\096\096\105\076\071\025\044\116\036\100\112\107\089\044\077\102\112\076\018\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\102\112\076\018\039\052\106\125\025\096\017\078\111\100\027\111\030\125\008\108\008\025\036\016\068\068\099\108\106\025\044\116\036\100\112\107\089\044\046\025\111\099\016\025\030\052\017\017\025\027\008\008\023\025\106\099\025\068\017\078\111\025\106\125\008\025\040\078\059\008\025\052\027\025\106\125\008\025\033\052\008\017\023\025\073\078\012\025\052\027\106\008\027\023\008\023\109\025\099\108\025\013\052\078\025\106\125\008\025\089\059\016\017\078\106\099\108\057\025\073\067\105\071\089\077\025\071\125\052\012\025\033\008\078\106\016\108\008\025\052\012\025\016\012\016\078\017\017\111\025\023\052\012\078\085\017\008\023\025\078\027\111\030\078\111\012\046\025\023\099\027\045\106\025\030\099\108\108\111\057\057\057\025\106\125\008\108\008\025\052\012\025\027\099\025\078\023\013\078\027\106\078\040\008\025\085\111\025\125\078\013\052\027\040\025\052\106\025\099\027\025\008\055\058\008\068\106\025\033\099\108\025\106\008\012\106\052\027\040\025\068\016\108\068\099\012\008\012\109"), 
								Media = zmediaicTHUMBU, 
								Buttons = {
									_o9p("\032\099\027\106\052\027\016\008\057\057\057")
								}, 
								Callback = function(action)
									if action ~= nil then
										_Urwigo.RunDialogs(function()
											Wherigo.GetInput(zinputAdvOptList)
										end)
									end
								end
							}
						end
					else
						_Urwigo.RunDialogs(function()
							Wherigo.GetInput(zinputAdvOptList)
						end)
					end
				end
			end
		}
	end
	if Wherigo.NoCaseEquals(MMADVOPTSEL, _o9p("\096\017\078\111\100\027\111\030\125\008\108\008\025\103\025\067\110\100")) then
		_Urwigo.MessageBox{
			Text = (_o9p("\071\125\052\012\025\099\068\106\052\099\027\025\052\012\025\067\105\071\025\100\081\100\116\107\100\112\107\089\025\030\125\052\017\008\025\078\025\040\078\059\008\025\052\012\025\078\058\106\052\013\008\057\025\097\099\016\025\030\052\017\017\025\027\008\008\023\025\106\099\025\108\008\012\106\078\108\106\025\106\125\008\025\040\078\059\008\025\052\033\025\111\099\016\025\030\078\027\106\025\106\099\025\016\012\008\025\106\125\052\012\025\078\023\013\078\027\058\008\023\025\071\089\036\071\116\067\015\025\099\068\106\052\099\027\057\025\102\112\076\018\073\036\106\078\106\016\012\077\025")..SuppPA).._o9p("\109"), 
			Media = zmediaicSAVE, 
			Buttons = {
				_o9p("\032\099\027\106\052\027\016\008\057\057\057")
			}, 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.RunDialogs(function()
						Wherigo.GetInput(zinputAdvOptList)
					end)
				end
			end
		}
	end
	if Wherigo.NoCaseEquals(MMADVOPTSEL, _o9p("\112\078\058\024\025\106\099\025\105\068\106\052\099\027\012\025\035\008\027\016")) then
		_Urwigo.RunDialogs(function()
			Wherigo.GetInput(zinputOptionsList)
		end)
	end
end
function zinputPhoneOptList:OnGetInput(input)
	MMPSSEL = input
	if Wherigo.NoCaseEquals(MMPSSEL, _o9p("\100\027\023\108\099\052\023\025\044\008\013\052\058\008\012")) then
		_Urwigo.MessageBox{
			Text = (_o9p("\036\008\017\008\058\106\025\106\125\052\012\025\099\068\106\052\099\027\025\052\033\025\111\099\016\025\078\108\008\025\068\017\078\111\052\027\040\025\099\027\025\078\027\025\100\027\023\108\099\052\023\025\023\008\013\052\058\008\025\016\012\052\027\040\025\106\125\008\025\039\125\008\108\008\097\099\016\015\099\025\078\068\068\057\025\032\008\108\106\078\052\027\025\012\008\106\106\052\027\040\012\025\030\052\017\017\025\085\008\025\008\027\078\085\017\008\023\025\099\108\025\023\052\012\078\085\017\008\023\025\106\099\025\008\027\012\016\108\008\025\099\068\106\052\059\052\065\008\023\025\058\099\059\068\078\106\052\085\052\017\052\106\111\025\033\099\108\025\068\017\078\111\052\027\040\025\016\027\023\008\108\025\106\125\008\025\039\125\008\108\008\097\099\016\015\099\025\078\068\068\057\025\073\036\106\078\106\016\012\077\025")..SuppAndroid).._o9p("\109"), 
			Media = zmediaicSAVE, 
			Buttons = {
				_o9p("\032\117\100\067\015\089"), 
				_o9p("\032\078\027\058\008\017")
			}, 
			Callback = function(action)
				if action ~= nil then
					if action == "Button1" then
						PHTest = SuppAndroid
						if Wherigo.NoCaseEquals(PHTest, _o9p("\044\116\036\100\112\107\089\044")) then
							SuppAndroid = _o9p("\089\067\100\112\107\089\044")
							_f2Wa = _o9p("\089\067\100\112\107\089\044")
							SuppSound = _o9p("\089\067\100\112\107\089\044")
							StatBar = _o9p("\089\067\100\112\107\089\044")
							SuppScreen = _o9p("\089\067\100\112\107\089\044")
							SuppStatTime = 1
							ztimerlilDOOM.Duration = SuppStatTime
							_Urwigo.MessageBox{
								Text = _o9p("\039\117\089\076\089\097\105\050\015\105\025\036\050\096\096\105\076\071\025\089\067\100\112\107\089\044\077\025\102\112\076\018\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\102\112\076\018\035\008\027\016\077\025\089\067\100\112\107\089\044\102\112\076\018\036\099\016\027\023\077\025\089\067\100\112\107\089\044\025\102\112\076\018\036\106\078\106\016\012\025\112\078\108\077\025\089\067\100\112\107\089\044\025\102\112\076\018\036\106\078\106\016\012\025\050\068\023\078\106\008\012\077\025\008\013\008\108\111\025\049\025\012\008\058\012\102\112\076\018\036\058\108\008\008\027\044\052\108\008\058\106\077\025\089\067\100\112\107\089\044"), 
								Media = zmediaicTHUMBU, 
								Buttons = {
									_o9p("\032\099\027\106\052\027\016\008\057\057\057")
								}, 
								Callback = function(action)
									if action ~= nil then
										_Urwigo.RunDialogs(function()
											Wherigo.GetInput(zinputOptionsList)
										end)
									end
								end
							}
						else
							SuppAndroid = _o9p("\044\116\036\100\112\107\089\044")
							_f2Wa = _o9p("\089\067\100\112\107\089\044")
							SuppSound = _o9p("\044\116\036\100\112\107\089\044")
							StatBar = _o9p("\044\116\036\100\112\107\089\044")
							SuppScreen = _o9p("\044\116\036\100\112\107\089\044")
							SuppStatTime = 10
							ztimerlilDOOM.Duration = SuppStatTime
							_Urwigo.MessageBox{
								Text = _o9p("\039\117\089\076\089\097\105\050\015\105\025\036\050\096\096\105\076\071\025\044\116\036\100\112\107\089\044\077\025\102\112\076\018\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\102\112\076\018\035\008\027\016\077\025\089\067\100\112\107\089\044\102\112\076\018\036\099\016\027\023\077\025\044\116\036\100\112\107\089\044\025\102\112\076\018\036\106\078\106\016\012\025\112\078\108\077\025\044\116\036\100\112\107\089\044\025\102\112\076\018\036\106\078\106\016\012\025\050\068\023\078\106\008\012\077\025\008\013\008\108\111\025\049\101\025\012\008\058\012\102\112\076\018\036\058\108\008\008\027\044\052\108\008\058\106\077\025\044\116\036\100\112\107\089\044"), 
								Media = zmediaicTHUMBD, 
								Buttons = {
									_o9p("\032\099\027\106\052\027\016\008\057\057\057")
								}, 
								Callback = function(action)
									if action ~= nil then
										_Urwigo.RunDialogs(function()
											Wherigo.GetInput(zinputOptionsList)
										end)
									end
								end
							}
						end
					else
						_Urwigo.RunDialogs(function()
							Wherigo.GetInput(zinputOptionsList)
						end)
					end
				end
			end
		}
	end
	if Wherigo.NoCaseEquals(MMPSSEL, _o9p("\105\068\008\027\039\116\015\025\073\122\078\013\078\109")) then
		_Urwigo.MessageBox{
			Text = (_o9p("\036\008\017\008\058\106\025\106\125\052\012\025\099\068\106\052\099\027\025\052\033\025\111\099\016\025\078\108\008\025\068\017\078\111\052\027\040\025\099\027\025\078\025\012\059\078\108\106\025\068\125\099\027\008\025\016\012\052\027\040\025\105\068\008\027\039\116\015\025\016\027\023\008\108\025\122\078\013\078\025\073\052\057\008\057\025\039\052\027\023\099\030\012\025\035\099\085\052\017\008\025\027\099\027\103\106\099\016\058\125\012\058\108\008\008\027\046\025\068\099\012\012\052\085\017\111\025\112\017\078\058\024\085\008\108\108\111\025\078\027\023\025\036\111\059\085\052\078\027\025\023\008\013\052\058\008\012\109\057\025\032\008\108\106\078\052\027\025\012\008\106\106\052\027\040\012\025\030\052\017\017\025\085\008\025\008\027\078\085\017\008\023\025\099\108\025\023\052\012\078\085\017\008\023\025\106\099\025\008\027\012\016\108\008\025\099\068\106\052\059\052\065\008\023\025\058\099\059\068\078\106\052\085\052\017\052\106\111\025\033\099\108\025\068\017\078\111\052\027\040\025\016\027\023\008\108\025\106\125\008\025\105\068\008\027\039\116\015\025\078\068\068\057\025\073\036\106\078\106\016\012\077\025")..SuppOpenWIG).._o9p("\109"), 
			Media = zmediaicSAVE, 
			Buttons = {
				_o9p("\032\117\100\067\015\089"), 
				_o9p("\032\078\027\058\008\017")
			}, 
			Callback = function(action)
				if action ~= nil then
					if action == "Button1" then
						PHTest = SuppOpenWIG
						if Wherigo.NoCaseEquals(PHTest, _o9p("\044\116\036\100\112\107\089\044")) then
							SuppOpenWIG = _o9p("\089\067\100\112\107\089\044")
							_f2Wa = _o9p("\089\067\100\112\107\089\044")
							SuppSound = _o9p("\089\067\100\112\107\089\044")
							StatBar = _o9p("\089\067\100\112\107\089\044")
							SuppScreen = _o9p("\089\067\100\112\107\089\044")
							SuppStatTime = 20
							_Urwigo.MessageBox{
								Text = _o9p("\122\100\081\100\025\105\096\089\067\039\116\015\025\036\050\096\096\105\076\071\025\089\067\100\112\107\089\044\077\025\102\112\076\018\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\102\112\076\018\035\008\027\016\077\025\089\067\100\112\107\089\044\102\112\076\018\036\099\016\027\023\077\025\089\067\100\112\107\089\044\025\102\112\076\018\036\106\078\106\016\012\025\112\078\108\077\025\089\067\100\112\107\089\044\025\102\112\076\018\036\106\078\106\016\012\025\050\068\023\078\106\008\012\077\025\008\013\008\108\111\025\034\101\025\012\008\058\012\102\112\076\018\036\058\108\008\008\027\044\052\108\008\058\106\077\025\089\067\100\112\107\089\044"), 
								Media = zmediaicTHUMBU, 
								Buttons = {
									_o9p("\032\099\027\106\052\027\016\008\057\057\057")
								}, 
								Callback = function(action)
									if action ~= nil then
										_Urwigo.RunDialogs(function()
											Wherigo.GetInput(zinputOptionsList)
										end)
									end
								end
							}
						else
							SuppOpenWIG = _o9p("\044\116\036\100\112\107\089\044")
							_f2Wa = _o9p("\089\067\100\112\107\089\044")
							SuppSound = _o9p("\044\116\036\100\112\107\089\044")
							StatBar = _o9p("\044\116\036\100\112\107\089\044")
							SuppScreen = _o9p("\044\116\036\100\112\107\089\044")
							SuppStatTime = 10
							ztimerlilDOOM.Duration = SuppStatTime
							_Urwigo.MessageBox{
								Text = _o9p("\122\100\081\100\025\105\096\089\067\039\116\015\025\036\050\096\096\105\076\071\025\044\116\036\100\112\107\089\044\077\025\102\112\076\018\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\102\112\076\018\035\008\027\016\077\025\089\067\100\112\107\089\044\102\112\076\018\036\099\016\027\023\077\025\044\116\036\100\112\107\089\044\025\102\112\076\018\036\106\078\106\016\012\025\112\078\108\077\025\044\116\036\100\112\107\089\044\025\102\112\076\018\036\106\078\106\016\012\025\050\068\023\078\106\008\012\077\025\008\013\008\108\111\025\049\101\025\012\008\058\012\102\112\076\018\036\058\108\008\008\027\044\052\108\008\058\106\077\025\044\116\036\100\112\107\089\044"), 
								Media = zmediaicTHUMBD, 
								Buttons = {
									_o9p("\032\099\027\106\052\027\016\008\057\057\057")
								}, 
								Callback = function(action)
									if action ~= nil then
										_Urwigo.RunDialogs(function()
											Wherigo.GetInput(zinputOptionsList)
										end)
									end
								end
							}
						end
					else
						_Urwigo.RunDialogs(function()
							Wherigo.GetInput(zinputOptionsList)
						end)
					end
				end
			end
		}
	end
	if Wherigo.NoCaseEquals(MMPSSEL, _o9p("\039\052\027\023\099\030\012\025\035\099\085\052\017\008\025\073\106\099\016\058\125\109")) then
		_Urwigo.MessageBox{
			Text = (_o9p("\036\008\017\008\058\106\025\106\125\052\012\025\099\068\106\052\099\027\025\052\033\025\111\099\016\025\078\108\008\025\068\017\078\111\052\027\040\025\099\027\025\078\027\025\039\052\027\023\099\030\012\025\035\099\085\052\017\008\025\096\099\058\024\008\106\096\032\025\099\108\025\036\059\078\108\106\096\125\099\027\008\025\073\106\099\016\058\125\012\058\108\008\008\027\109\057\025\032\008\108\106\078\052\027\025\012\008\106\106\052\027\040\012\025\030\052\017\017\025\085\008\025\008\027\078\085\017\008\023\025\099\108\025\023\052\012\078\085\017\008\023\025\106\099\025\008\027\012\016\108\008\025\099\068\106\052\059\052\065\008\023\025\058\099\059\068\078\106\052\085\052\017\052\106\111\025\033\099\108\025\039\052\027\023\099\030\012\025\035\099\085\052\017\008\012\025\068\125\099\027\008\012\025\068\017\078\111\052\027\040\025\016\027\023\008\108\025\106\125\008\025\099\033\033\052\058\052\078\017\025\015\108\099\016\027\023\012\068\008\078\024\025\096\099\058\024\008\106\096\032\025\078\068\068\057\025\073\036\106\078\106\016\012\077\025")..SuppPPC).._o9p("\109"), 
			Media = zmediaicSAVE, 
			Buttons = {
				_o9p("\032\117\100\067\015\089"), 
				_o9p("\032\078\027\058\008\017")
			}, 
			Callback = function(action)
				if action ~= nil then
					if action == "Button1" then
						PHTest = SuppPPC
						if Wherigo.NoCaseEquals(PHTest, _o9p("\044\116\036\100\112\107\089\044")) then
							SuppPPC = _o9p("\089\067\100\112\107\089\044")
							_f2Wa = _o9p("\089\067\100\112\107\089\044")
							SuppSound = _o9p("\089\067\100\112\107\089\044")
							StatBar = _o9p("\089\067\100\112\107\089\044")
							SuppScreen = _o9p("\089\067\100\112\107\089\044")
							SuppStatTime = 1
							ztimerlilDOOM.Duration = SuppStatTime
							_Urwigo.MessageBox{
								Text = _o9p("\039\116\067\025\035\105\112\116\107\089\025\036\050\096\096\105\076\071\025\089\067\100\112\107\089\044\077\025\102\112\076\018\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\102\112\076\018\035\008\027\016\077\025\089\067\100\112\107\089\044\102\112\076\018\036\099\016\027\023\077\025\089\067\100\112\107\089\044\025\102\112\076\018\036\106\078\106\016\012\025\112\078\108\077\025\089\067\100\112\107\089\044\102\112\076\018\036\106\078\106\016\012\025\050\068\023\078\106\008\012\077\025\008\013\008\108\111\025\049\025\012\008\058\012\102\112\076\018\036\058\108\008\008\027\044\052\108\008\058\106\077\025\089\067\100\112\107\089\044"), 
								Media = zmediaicTHUMBU, 
								Buttons = {
									_o9p("\032\099\027\106\052\027\016\008\057\057\057")
								}, 
								Callback = function(action)
									if action ~= nil then
										_Urwigo.RunDialogs(function()
											Wherigo.GetInput(zinputOptionsList)
										end)
									end
								end
							}
						else
							SuppPPC = _o9p("\044\116\036\100\112\107\089\044")
							_f2Wa = _o9p("\089\067\100\112\107\089\044")
							SuppSound = _o9p("\044\116\036\100\112\107\089\044")
							StatBar = _o9p("\044\116\036\100\112\107\089\044")
							SuppScreen = _o9p("\044\116\036\100\112\107\089\044")
							SuppStatTime = 10
							ztimerlilDOOM.Duration = SuppStatTime
							_Urwigo.MessageBox{
								Text = _o9p("\039\116\067\025\035\105\112\116\107\089\025\036\050\096\096\105\076\071\025\044\116\036\100\112\107\089\044\077\025\102\112\076\018\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\102\112\076\018\035\008\027\016\077\025\089\067\100\112\107\089\044\102\112\076\018\036\099\016\027\023\077\025\044\116\036\100\112\107\089\044\025\102\112\076\018\036\106\078\106\016\012\025\112\078\108\077\025\044\116\036\100\112\107\089\044\102\112\076\018\036\106\078\106\016\012\025\050\068\023\078\106\008\012\077\025\008\013\008\108\111\025\049\101\025\012\008\058\012\102\112\076\018\036\058\108\008\008\027\044\052\108\008\058\106\077\025\044\116\036\100\112\107\089\044"), 
								Media = zmediaicTHUMBD, 
								Buttons = {
									_o9p("\032\099\027\106\052\027\016\008\057\057\057")
								}, 
								Callback = function(action)
									if action ~= nil then
										_Urwigo.RunDialogs(function()
											Wherigo.GetInput(zinputOptionsList)
										end)
									end
								end
							}
						end
					else
						_Urwigo.RunDialogs(function()
							Wherigo.GetInput(zinputOptionsList)
						end)
					end
				end
			end
		}
	end
	if Wherigo.NoCaseEquals(MMPSSEL, _o9p("\116\103\096\125\099\027\008\110\096\078\023\110\096\099\023\025\071\099\016\058\125")) then
		_Urwigo.MessageBox{
			Text = (_o9p("\036\008\017\008\058\106\025\106\125\052\012\025\099\068\106\052\099\027\025\052\033\025\111\099\016\025\078\108\008\025\068\017\078\111\052\027\040\025\099\027\025\078\027\025\100\068\068\017\008\025\023\008\013\052\058\008\025\073\052\057\008\057\025\116\103\096\125\099\027\008\046\025\116\103\096\078\023\046\025\116\103\096\099\023\025\071\099\016\058\125\109\057\025\067\105\071\089\077\025\039\008\025\125\078\013\008\025\027\099\106\025\033\016\017\017\111\025\099\068\106\052\059\052\065\008\023\025\099\016\108\025\058\078\108\106\108\052\023\040\008\012\025\030\052\106\125\025\106\125\008\025\027\008\030\025\039\125\008\108\052\040\099\025\068\017\078\111\008\108\025\033\099\108\025\106\125\008\012\008\025\023\008\013\052\058\008\012\057\025\117\099\030\008\013\008\108\046\025\030\008\025\030\052\017\017\025\078\106\106\008\059\068\106\025\106\099\025\012\008\106\025\078\025\033\008\030\025\012\008\106\106\052\027\040\012\025\106\099\025\008\027\078\085\017\008\025\099\108\025\023\052\012\078\085\017\008\025\099\068\106\052\059\052\065\008\023\025\058\099\059\068\078\106\052\085\052\017\052\106\111\025\033\099\108\025\106\125\008\012\008\025\023\008\013\052\058\008\012\025\085\078\012\008\023\025\099\027\025\033\099\108\016\059\025\052\027\033\099\108\059\078\106\052\099\027\057\025\009\027\085\012\068\095\073\036\106\078\106\016\012\077\025")..SuppApple).._o9p("\109"), 
			Media = zmediaicSAVE, 
			Buttons = {
				_o9p("\032\117\100\067\015\089"), 
				_o9p("\032\078\027\058\008\017")
			}, 
			Callback = function(action)
				if action ~= nil then
					if action == "Button1" then
						PHTest = SuppApple
						if Wherigo.NoCaseEquals(PHTest, _o9p("\044\116\036\100\112\107\089\044")) then
							SuppApple = _o9p("\089\067\100\112\107\089\044")
							_f2Wa = _o9p("\044\116\036\100\112\107\089\044")
							SuppSound = _o9p("\089\067\100\112\107\089\044")
							StatBar = _o9p("\044\116\036\100\112\107\089\044")
							SuppScreen = _o9p("\089\067\100\112\107\089\044")
							SuppStatTime = 5
							ztimerlilDOOM.Duration = SuppStatTime
							_Urwigo.MessageBox{
								Text = _o9p("\100\096\096\107\089\025\044\089\081\116\032\089\025\036\050\096\096\105\076\071\025\089\067\100\112\107\089\044\077\025\102\112\076\018\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\102\112\076\018\035\008\027\016\077\025\044\116\036\100\112\107\089\044\102\112\076\018\036\099\016\027\023\077\025\089\067\100\112\107\089\044\025\102\112\076\018\036\106\078\106\016\012\025\112\078\108\077\025\044\116\036\100\112\107\089\044\102\112\076\018\036\106\078\106\016\012\025\050\068\023\078\106\008\012\077\025\008\013\008\108\111\025\127\025\012\008\058\012\102\112\076\018\036\058\108\008\008\027\044\052\108\008\058\106\077\025\089\067\100\112\107\089\044"), 
								Media = zmediaicTHUMBU, 
								Buttons = {
									_o9p("\032\099\027\106\052\027\016\008\057\057\057")
								}, 
								Callback = function(action)
									if action ~= nil then
										_Urwigo.RunDialogs(function()
											Wherigo.GetInput(zinputOptionsList)
										end)
									end
								end
							}
						else
							SuppApple = _o9p("\044\116\036\100\112\107\089\044")
							_f2Wa = _o9p("\089\067\100\112\107\089\044")
							SuppSound = _o9p("\044\116\036\100\112\107\089\044")
							StatBar = _o9p("\044\116\036\100\112\107\089\044")
							SuppScreen = _o9p("\044\116\036\100\112\107\089\044")
							SuppStatTime = 10
							ztimerlilDOOM.Duration = SuppStatTime
							_Urwigo.MessageBox{
								Text = _o9p("\100\096\096\107\089\025\044\089\081\116\032\089\025\036\050\096\096\105\076\071\025\044\116\036\100\112\107\089\044\077\025\102\112\076\018\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\102\112\076\018\035\008\027\016\077\025\089\067\100\112\107\089\044\102\112\076\018\036\099\016\027\023\077\025\044\116\036\100\112\107\089\044\025\102\112\076\018\036\106\078\106\016\012\025\112\078\108\077\025\044\116\036\100\112\107\089\044\102\112\076\018\036\106\078\106\016\012\025\050\068\023\078\106\008\012\077\025\008\013\008\108\111\025\049\101\025\012\008\058\012\102\112\076\018\036\058\108\008\008\027\044\052\108\008\058\106\077\025\044\116\036\100\112\107\089\044"), 
								Media = zmediaicTHUMBD, 
								Buttons = {
									_o9p("\032\099\027\106\052\027\016\008\057\057\057")
								}, 
								Callback = function(action)
									if action ~= nil then
										_Urwigo.RunDialogs(function()
											Wherigo.GetInput(zinputOptionsList)
										end)
									end
								end
							}
						end
					else
						_Urwigo.RunDialogs(function()
							Wherigo.GetInput(zinputOptionsList)
						end)
					end
				end
			end
		}
	end
	if Wherigo.NoCaseEquals(MMPSSEL, _o9p("\112\078\058\024\025\106\099\025\105\068\106\052\099\027\012\025\035\008\027\016")) then
		_Urwigo.RunDialogs(function()
			Wherigo.GetInput(zinputOptionsList)
		end)
	end
end
function zinputGearPackList:OnGetInput(input)
	TestVar = input
	if Wherigo.NoCaseEquals(TestVar, _o9p("\103\103\103\089\079\116\071\103\103\103")) then
		Wherigo.ShowScreen(Wherigo.DETAILSCREEN, zitemGearPack)
	end
	if Wherigo.NoCaseEquals(TestVar, _o9p("\032\008\017\017")) then
		Wherigo.ShowScreen(Wherigo.DETAILSCREEN, zitemCell)
	end
	if Wherigo.NoCaseEquals(TestVar, _o9p("\044\108\016\059\012")) then
		Wherigo.ShowScreen(Wherigo.DETAILSCREEN, zitemDrums)
	end
	if Wherigo.NoCaseEquals(TestVar, _o9p("\047\017\078\012\125\017\052\040\125\106")) then
		Wherigo.ShowScreen(Wherigo.DETAILSCREEN, zitemFlashlight)
	end
	if Wherigo.NoCaseEquals(TestVar, _o9p("\015\096\036")) then
		Wherigo.ShowScreen(Wherigo.DETAILSCREEN, zitemGPS)
	end
	if Wherigo.NoCaseEquals(TestVar, _o9p("\067\099\106\008\068\078\023")) then
		Wherigo.ShowScreen(Wherigo.DETAILSCREEN, zitemNotepad)
	end
	if Wherigo.NoCaseEquals(TestVar, _o9p("\036\106\108\078\027\040\008\025\036\106\078\106\016\008")) then
		Wherigo.ShowScreen(Wherigo.DETAILSCREEN, zitemStrangeStatue)
	end
end
function zinputMBS1Clue:OnGetInput(input)
	if (((_Urwigo.Hash(string.lower(input)) == 101) or (_Urwigo.Hash(string.lower(input)) == 101)) or (_Urwigo.Hash(string.lower(input)) == 115)) or (_Urwigo.Hash(string.lower(input)) == 115) then
		MBS1Clue = 2
		SanityLevel = SanityLevel + 20
		_Urwigo.MessageBox{
			Text = _o9p("\032\099\108\108\008\058\106\043\025\097\099\016\108\025\023\052\012\058\099\013\008\108\111\025\099\033\025\106\125\008\025\012\099\016\108\058\008\025\099\033\025\106\125\008\025\106\108\078\027\069\016\052\017\052\106\111\025\125\078\012\025\125\008\017\068\008\023\025\111\099\016\108\025\036\078\027\052\106\111\043\102\112\076\018\073\015\078\052\027\025\034\101\025\036\078\027\052\106\111\109"), 
			Media = zmediaicFACEHAPPY, 
			Callback = function(action)
				if action ~= nil then
					IgnoreMe = false
				end
			end
		}
	else
		if MBS1Clue == 1 then
			_Urwigo.MessageBox{
				Text = _o9p("\116\027\058\099\108\108\008\058\106\043\025\097\099\016\025\059\078\111\025\027\099\106\025\125\078\013\008\025\023\052\012\058\099\013\008\108\008\023\025\106\125\008\025\012\099\016\108\058\008\025\099\033\025\106\125\008\025\106\108\078\027\069\016\052\017\052\106\111\025\085\016\106\025\052\106\012\025\008\033\033\008\058\106\012\025\125\078\013\008\025\008\078\012\008\023\025\111\099\016\108\025\059\052\027\023\025\012\099\059\008\025\073\078\017\108\008\078\023\111\109\057\057\057"), 
				Callback = function(action)
					if action ~= nil then
						Wherigo.ShowScreen(Wherigo.DETAILSCREEN, zoneMBS1)
					end
				end
			}
		else
			MBS1Clue = 1
			SanityLevel = SanityLevel + 5
			_Urwigo.MessageBox{
				Text = _o9p("\116\027\058\099\108\108\008\058\106\043\025\097\099\016\025\059\078\111\025\027\099\106\025\125\078\013\008\025\023\052\012\058\099\013\008\108\008\023\025\106\125\008\025\012\099\016\108\058\008\025\099\033\025\106\125\008\025\106\108\078\027\069\016\052\017\052\106\111\025\085\016\106\025\052\106\012\025\008\033\033\008\058\106\012\025\125\078\013\008\025\008\078\012\008\023\025\111\099\016\108\025\059\052\027\023\025\012\099\059\008\057\057\057\102\112\076\018\073\015\078\052\027\025\127\025\036\078\027\052\106\111\109"), 
				Media = zmediaicFACESAD, 
				Callback = function(action)
					if action ~= nil then
						Wherigo.ShowScreen(Wherigo.DETAILSCREEN, zoneMBS1)
					end
				end
			}
		end
	end
end
function zinputMBS2Clue:OnGetInput(input)
	if (_Urwigo.Hash(string.lower(input)) == 111) or (_Urwigo.Hash(string.lower(input)) == 111) then
		MBS2Clue = 2
		SanityLevel = SanityLevel + 20
		_Urwigo.MessageBox{
			Text = _o9p("\032\099\108\108\008\058\106\043\025\097\099\016\108\025\023\052\012\058\099\013\008\108\111\025\099\033\025\106\125\008\025\012\099\016\108\058\008\025\099\033\025\106\125\008\025\106\108\078\027\069\016\052\017\052\106\111\025\125\078\012\025\125\008\017\068\008\023\025\111\099\016\108\025\036\078\027\052\106\111\043\102\112\076\018\073\015\078\052\027\025\034\101\025\036\078\027\052\106\111\109"), 
			Media = zmediaicFACEHAPPY
		}
	else
		if MBS2Clue == 1 then
			_Urwigo.MessageBox{
				Text = _o9p("\116\027\058\099\108\108\008\058\106\043\025\097\099\016\025\059\078\111\025\027\099\106\025\125\078\013\008\025\023\052\012\058\099\013\008\108\008\023\025\106\125\008\025\012\099\016\108\058\008\025\099\033\025\106\125\008\025\106\108\078\027\069\016\052\017\052\106\111\025\085\016\106\025\052\106\012\025\008\033\033\008\058\106\012\025\125\078\013\008\025\008\078\012\008\023\025\111\099\016\108\025\059\052\027\023\025\012\099\059\008\025\073\078\017\108\008\078\023\111\109\057\057\057"), 
				Callback = function(action)
					if action ~= nil then
						Wherigo.ShowScreen(Wherigo.DETAILSCREEN, zoneMBS2)
					end
				end
			}
		else
			MBS2Clue = 1
			SanityLevel = SanityLevel + 5
			_Urwigo.MessageBox{
				Text = _o9p("\116\027\058\099\108\108\008\058\106\043\025\097\099\016\025\059\078\111\025\027\099\106\025\125\078\013\008\025\023\052\012\058\099\013\008\108\008\023\025\106\125\008\025\012\099\016\108\058\008\025\099\033\025\106\125\008\025\106\108\078\027\069\016\052\017\052\106\111\025\085\016\106\025\052\106\012\025\008\033\033\008\058\106\012\025\125\078\013\008\025\008\078\012\008\023\025\111\099\016\108\025\059\052\027\023\025\012\099\059\008\057\057\057\102\112\076\018\073\015\078\052\027\025\127\025\036\078\027\052\106\111\109"), 
				Media = zmediaicFACESAD, 
				Callback = function(action)
					if action ~= nil then
						Wherigo.ShowScreen(Wherigo.DETAILSCREEN, zoneMBS2)
					end
				end
			}
		end
	end
end
function zinputPathCheck:OnGetInput(input)
	if _Urwigo.Hash(string.lower(input)) == 29033 then
		_Urwigo.MessageBox{
			Text = _o9p("\097\099\016\025\017\099\099\024\025\023\099\030\027\025\106\125\008\025\107\008\033\106\025\096\078\106\125\025\078\027\023\025\027\099\106\052\058\008\025\106\125\078\106\025\052\106\025\125\008\078\023\012\025\099\027\025\033\099\108\025\078\025\085\052\106\025\106\125\008\027\025\023\108\099\068\012\025\099\033\033\057\025\116\106\025\012\008\008\059\012\025\106\099\025\125\008\078\023\025\085\078\058\024\025\106\099\030\078\108\023\012\025\106\125\008\025\059\078\052\027\025\106\108\078\052\017\025\111\099\016\025\058\078\059\008\025\016\068\025\099\108\052\040\052\027\078\017\017\111\057\057\057"), 
			Media = zmediazEDGE2, 
			Callback = function(action)
				if action ~= nil then
					Wherigo.ShowScreen(Wherigo.DETAILSCREEN, zoneBranch4)
				end
			end
		}
	elseif _Urwigo.Hash(string.lower(input)) == 11584 then
		_Urwigo.MessageBox{
			Text = _o9p("\097\099\016\025\017\099\099\024\025\078\125\008\078\023\025\023\099\030\027\025\106\125\008\025\012\125\099\108\106\025\117\052\017\017\025\096\078\106\125\025\078\012\025\052\106\025\023\108\099\068\012\025\023\099\030\027\025\099\013\008\108\025\078\025\125\052\017\017\025\078\027\023\025\058\099\027\106\052\027\016\008\012\025\012\017\052\040\125\106\017\111\025\099\027\030\078\108\023\025\052\027\106\099\025\078\025\058\017\008\078\108\052\027\040\057\025\044\008\085\108\052\012\025\052\012\025\012\106\108\008\030\027\025\078\085\099\016\106\025\052\106\025\078\125\008\078\023\025\078\027\023\025\108\008\008\024\012\025\099\033\025\023\008\078\106\125\057\057\057"), 
			Media = zmediazEDGE1, 
			Callback = function(action)
				if action ~= nil then
					Wherigo.ShowScreen(Wherigo.DETAILSCREEN, zoneBranch4)
				end
			end
		}
	elseif _Urwigo.Hash(string.lower(input)) == 49686 then
		_Urwigo.MessageBox{
			Text = _o9p("\097\099\016\025\017\099\099\024\025\016\068\025\106\125\008\025\085\052\040\040\008\108\025\076\052\040\125\106\025\096\078\106\125\025\078\027\023\025\027\099\106\052\058\008\025\078\025\040\017\099\030\052\027\040\025\017\052\040\125\106\025\033\016\108\106\125\008\108\025\016\068\025\106\125\008\025\068\078\106\125\057\057\057\025\017\099\099\024\012\025\017\052\024\008\025\106\125\008\025\030\078\111\025\106\099\025\040\099\043"), 
			Media = zmediazTRAIL5, 
			Callback = function(action)
				if action ~= nil then
					Wherigo.ShowScreen(Wherigo.DETAILSCREEN, zoneBranch4)
				end
			end
		}
	else
		Wherigo.ShowScreen(Wherigo.LOCATIONSCREEN)
	end
end
function zinputPhonePics:OnGetInput(input)
	zitemPP1:MoveTo(Player)
	zitemPP2:MoveTo(Player)
	zitemPP3:MoveTo(Player)
	zitemPP4:MoveTo(Player)
	zitemPP5:MoveTo(Player)
	if _Urwigo.Hash(string.lower(input)) == 54442 then
		Wherigo.ShowScreen(Wherigo.DETAILSCREEN, zitemPP1)
	elseif _Urwigo.Hash(string.lower(input)) == 35834 then
		Wherigo.PlayAudio(zmediaSNDcamera)
		PicZone()
		PicsWork(OFF)
		Wherigo.ShowScreen(Wherigo.DETAILSCREEN, zitemCell)
	end
end
function zinputNotePP1:OnGetInput(input)
	Photo1 = input
	Wherigo.ShowScreen(Wherigo.DETAILSCREEN, zitemPP1)
end
function zinputNotePP2:OnGetInput(input)
	Photo2 = input
	Wherigo.ShowScreen(Wherigo.DETAILSCREEN, zitemPP2)
end
function zinputNotePP3:OnGetInput(input)
	Photo3 = input
	Wherigo.ShowScreen(Wherigo.DETAILSCREEN, zitemPP3)
end
function zinputNotePP4:OnGetInput(input)
	Photo4 = input
	Wherigo.ShowScreen(Wherigo.DETAILSCREEN, zitemPP4)
end
function zinputNotePP5:OnGetInput(input)
	Photo5 = input
	Wherigo.ShowScreen(Wherigo.DETAILSCREEN, zitemPP5)
end
function zEnding:OnGetInput(input)
	if _Urwigo.Hash(string.lower(input)) == 23797 then
		if Score >= 700 then
			acend = 5
			Score = Score + 500
			SCGen()
			Wherigo.PlayAudio(zmediaSNDBGMintro)
			zitemStrangeStatue:MoveTo(nil)
			_Urwigo.MessageBox{
				Text = _o9p("\097\099\016\025\012\027\078\068\025\085\078\058\024\025\106\099\025\058\099\027\012\058\052\099\016\012\027\008\012\012\025\090\016\012\106\025\078\012\025\032\106\125\016\017\125\016\025\106\099\016\058\125\008\012\025\111\099\016\043\025\097\099\016\025\012\016\108\068\108\052\012\008\025\111\099\016\108\025\058\078\068\106\099\108\012\025\078\027\023\025\085\108\008\078\024\025\033\108\008\008\025\099\033\025\106\125\008\052\108\025\040\108\078\012\068\057\025\097\099\016\025\023\099\023\040\008\025\111\099\016\108\025\058\078\068\106\099\108\012\025\078\027\023\025\032\106\125\016\017\125\016\045\012\025\033\017\078\052\017\052\027\040\025\106\008\027\106\078\058\017\008\012\025\078\027\023\025\040\108\078\085\025\106\125\008\025\008\033\033\052\040\111\025\078\027\023\025\106\099\012\012\025\052\106\025\052\027\106\099\025\106\125\008\025\068\099\108\106\078\017\057\025\039\052\106\125\025\078\025\017\099\016\023\025\012\125\108\052\008\024\052\027\040\025\030\078\052\017\025\033\108\099\059\025\032\106\125\016\017\125\016\025\078\027\023\025\111\099\016\108\025\058\078\068\106\099\108\012\046\025\106\125\008\025\033\052\108\008\025\033\017\078\108\008\012\025\106\099\025\078\027\025\099\013\008\108\030\125\008\017\059\052\027\040\025\052\027\106\008\027\012\052\106\111\025\106\125\078\106\025\058\078\016\012\008\012\025\111\099\016\025\106\099\025\012\125\052\008\017\023\025\111\099\016\108\025\033\078\058\008\057\025\071\125\008\025\040\108\099\016\027\023\025\012\125\078\024\008\012\025\013\052\099\017\008\027\106\017\111\025\078\027\023\025\106\125\008\025\030\078\052\017\052\027\040\025\058\108\008\012\058\008\027\023\099\012\025\052\027\106\099\025\078\025\023\008\078\033\008\027\052\027\040\025\108\099\078\108\057\025\100\027\023\025\106\125\008\027\057\057\057\025\078\017\017\025\052\012\025\012\052\017\008\027\106\025\078\027\023\025\012\106\052\017\017\057"), 
				Media = zmediaEND5, 
				Callback = function(action)
					if action ~= nil then
						zoneStoneworks.Active = true
						zoneStoneworks.Visible = true
						_Urwigo.MessageBox{
							Text = _o9p("\097\099\016\025\068\008\008\108\025\106\125\108\099\016\040\125\025\111\099\016\108\025\033\052\027\040\008\108\012\025\106\099\025\033\052\027\023\025\106\125\078\106\025\052\106\025\052\012\025\023\078\111\017\052\040\125\106\025\078\040\078\052\027\025\078\027\023\025\106\125\078\106\025\111\099\016\025\078\108\008\025\012\106\078\027\023\052\027\040\025\052\027\025\106\125\008\025\059\052\023\023\017\008\025\099\033\025\106\125\008\025\058\017\008\078\108\008\023\025\008\023\040\008\025\027\008\055\106\025\106\099\025\106\125\008\025\108\008\059\078\052\027\012\025\099\033\025\078\025\023\030\052\027\023\017\052\027\040\046\025\012\059\099\017\023\008\108\052\027\040\025\033\052\108\008\057\025\067\008\052\106\125\008\108\025\032\106\125\016\017\125\016\025\027\099\108\025\111\099\016\108\025\058\078\068\106\099\108\012\025\078\108\008\025\078\027\111\030\125\008\108\008\025\052\027\025\012\052\040\125\106\057\025\097\099\016\025\017\099\099\024\025\078\108\099\016\027\023\025\078\027\023\025\033\052\027\023\025\027\099\025\058\017\008\078\108\025\008\013\052\023\008\027\058\008\025\099\033\025\106\125\008\025\008\013\008\027\106\012\025\106\125\078\106\025\090\016\012\106\025\068\078\012\012\008\023\025\008\052\106\125\008\108\057\025\117\099\030\008\013\008\108\046\025\027\008\078\108\025\106\125\008\025\033\052\108\008\068\052\106\025\111\099\016\025\023\052\012\058\099\013\008\108\025\078\025\017\078\108\040\008\025\008\027\040\108\078\013\008\023\025\012\106\099\027\008\025\106\125\078\106\025\017\099\099\024\012\025\017\052\024\008\025\078\025\068\078\108\106\025\099\033\025\032\106\125\016\017\125\016\045\012\025\068\099\108\106\078\017\057\025\105\027\025\052\106\025\052\012\025\052\027\012\058\108\052\085\008\023\077\025\102\112\076\018\067\025\062\127\025\101\034\057\118\113\124\025\009\027\085\012\068\095\039\025\101\063\113\025\101\034\057\101\127\062\025\102\112\076\018\073\107\099\058\078\106\052\099\027\025\078\023\023\008\023\025\078\012\025\036\106\099\027\008\030\099\108\024\012\025\052\027\025\040\078\059\008\109"), 
							Media = zmediaicINFO, 
							Callback = function(action)
								if action ~= nil then
									Wherigo.PlayAudio(zmediaSNDBGMindustrial)
									_Urwigo.MessageBox{
										Text = "", 
										Media = zmediaeDONE, 
										Buttons = {
											_o9p("\032\105\067\071\116\067\050\089")
										}, 
										Callback = function(action)
											if action ~= nil then
												_Urwigo.MessageBox{
													Text = (_o9p("\097\099\016\108\025\039\125\008\108\052\040\099\025\032\099\059\068\017\008\106\052\099\027\025\032\099\023\008\025\052\012\077\102\112\076\018\025")..string.sub(Player.CompletionCode, 1, 15)).._o9p("\102\112\076\018\073\052\027\068\016\106\025\099\027\025\039\125\008\108\052\040\099\057\058\099\059\025\106\099\025\059\078\108\024\025\106\125\078\106\025\111\099\016\025\058\099\059\068\017\008\106\008\023\025\052\106\109"), 
													Media = zmediaicSAVE, 
													Callback = function(action)
														if action ~= nil then
															_Urwigo.MessageBox{
																Text = (((_o9p("\097\099\016\108\025\047\052\027\078\017\025\036\058\099\108\008\077\025")..Score).._o9p("\102\112\076\018\097\099\016\108\025\036\058\099\108\008\025\032\099\023\008\077\025"))..ScoreCode).._o9p("\102\112\076\018\073\052\027\068\016\106\025\112\105\071\117\025\099\027\025\106\125\008\025\040\008\099\058\078\058\125\008\025\017\099\040\012\025\033\099\108\025\013\008\108\052\033\052\058\078\106\052\099\027\025\078\027\023\025\085\108\078\040\040\052\027\040\025\108\052\040\125\106\012\109"), 
																Media = zmediaicSCROLL, 
																Buttons = {
																	_o9p("\089\079\116\071\025\015\100\035\089")
																}, 
																Callback = function(action)
																	if action ~= nil then
																		cartGC2C5FN.Complete = true
																		_Urwigo.MessageBox{
																			Text = _o9p("\097\099\016\025\125\078\013\008\025\058\099\059\068\017\008\106\008\023\025\106\125\008\025\040\078\059\008\057\025\097\099\016\025\058\078\027\025\027\099\030\025\089\079\116\071\025\106\125\008\025\040\078\059\008\025\099\108\025\032\105\067\071\116\067\050\089\025\106\099\025\017\099\099\024\025\078\108\099\016\027\023\025\052\027\025\040\078\059\008\057\025\097\099\016\108\025\068\078\108\024\052\027\040\025\017\099\058\078\106\052\099\027\025\052\012\025\078\013\078\052\017\078\085\017\008\025\052\027\025\106\125\008\025\107\099\058\078\106\052\099\027\012\025\078\108\008\078\057\025\071\125\078\027\024\012\025\033\099\108\025\068\017\078\111\052\027\040\043"), 
																			Media = zmediaicSAVE, 
																			Buttons = {
																				_o9p("\089\079\116\071"), 
																				_o9p("\032\105\067\071\116\067\050\089")
																			}, 
																			Callback = function(action)
																				if action ~= nil then
																					if action == "Button1" then
																						Wherigo.Command "SaveClose"
																					else
																						cartGC2C5FN:RequestSync()
																						Wherigo.ShowScreen(Wherigo.DETAILSCREEN, zoneStoneworks)
																					end
																				end
																			end
																		}
																	end
																end
															}
														end
													end
												}
											end
										end
									}
								end
							end
						}
					end
				end
			}
		elseif (Score >= 500) and (Score <= 699) then
			acend = 4
			Score = Score + 400
			SCGen()
			Wherigo.PlayAudio(zmediaSNDBGMintro)
			zitemStrangeStatue:MoveTo(nil)
			zoneStoneworks.Active = true
			zoneStoneworks.Visible = true
			_Urwigo.MessageBox{
				Text = _o9p("\097\099\016\025\012\017\052\068\025\052\027\106\099\025\016\027\058\099\027\012\058\052\099\016\012\027\008\012\012\025\090\016\012\106\025\078\012\025\032\106\125\016\017\125\016\025\106\099\016\058\125\008\012\025\111\099\016\057\025\097\099\016\025\125\078\013\008\025\023\078\108\024\025\078\027\023\025\106\030\052\012\106\008\023\025\023\108\008\078\059\012\025\078\027\023\025\078\030\078\024\008\027\025\106\099\025\111\099\016\108\012\008\017\033\025\012\058\108\008\078\059\052\027\040\057\025\097\099\016\025\017\099\099\024\025\078\108\099\016\027\023\025\078\027\023\025\033\052\027\023\025\106\125\078\106\025\052\106\025\052\012\025\023\078\111\017\052\040\125\106\025\078\040\078\052\027\025\078\027\023\025\106\125\078\106\025\111\099\016\025\078\108\008\025\017\078\111\052\027\040\025\052\027\025\106\125\008\025\059\052\023\023\017\008\025\099\033\025\106\125\008\025\058\017\008\078\108\008\023\025\008\023\040\008\025\027\008\055\106\025\106\099\025\106\125\008\025\108\008\059\078\052\027\012\025\099\033\025\078\025\023\030\052\027\023\017\052\027\040\046\025\012\059\099\017\023\008\108\052\027\040\025\033\052\108\008\057\025\067\008\052\106\125\008\108\025\032\106\125\016\017\125\016\025\027\099\108\025\111\099\016\108\025\058\078\068\106\099\108\012\025\078\108\008\025\078\027\111\030\125\008\108\008\025\052\027\025\012\052\040\125\106\057\025\097\099\016\025\017\099\099\024\025\078\108\099\016\027\023\025\078\027\023\025\033\052\027\023\025\027\099\025\058\017\008\078\108\025\008\013\052\023\008\027\058\008\025\099\033\025\106\125\008\025\008\013\008\027\106\012\025\106\125\078\106\025\090\016\012\106\025\068\078\012\012\008\023\025\008\052\106\125\008\108\057\025\117\099\030\008\013\008\108\046\025\027\008\078\108\025\106\125\008\025\033\052\108\008\068\052\106\025\111\099\016\025\023\052\012\058\099\013\008\108\025\078\025\017\078\108\040\008\025\008\027\040\108\078\013\008\023\025\012\106\099\027\008\025\106\125\078\106\025\017\099\099\024\012\025\017\052\024\008\025\078\025\068\078\108\106\025\099\033\025\032\106\125\016\017\125\016\045\012\025\068\099\108\106\078\017\057\025\105\027\025\052\106\025\052\012\025\052\027\012\058\108\052\085\008\023\077\102\112\076\018\067\025\062\127\025\101\034\057\118\113\124\025\009\027\085\012\068\095\039\025\101\063\113\025\101\034\057\101\127\062\102\112\076\018\073\107\099\058\078\106\052\099\027\025\078\023\023\008\023\025\078\012\025\036\106\099\027\008\030\099\108\024\012\025\052\027\025\040\078\059\008\109"), 
				Media = zmediaEND4, 
				Callback = function(action)
					if action ~= nil then
						Wherigo.PlayAudio(zmediaSNDBGMindustrial)
						_Urwigo.MessageBox{
							Text = "", 
							Media = zmediaeDONE, 
							Buttons = {
								_o9p("\032\105\067\071\116\067\050\089")
							}, 
							Callback = function(action)
								if action ~= nil then
									_Urwigo.MessageBox{
										Text = (_o9p("\097\099\016\108\025\039\125\008\108\052\040\099\025\032\099\059\068\017\008\106\052\099\027\025\032\099\023\008\025\052\012\077\102\112\076\018\025")..string.sub(Player.CompletionCode, 1, 15)).._o9p("\102\112\076\018\073\052\027\068\016\106\025\099\027\025\039\125\008\108\052\040\099\057\058\099\059\025\106\099\025\059\078\108\024\025\106\125\078\106\025\111\099\016\025\058\099\059\068\017\008\106\008\023\025\052\106\109"), 
										Media = zmediaicSAVE, 
										Callback = function(action)
											if action ~= nil then
												_Urwigo.MessageBox{
													Text = (((_o9p("\097\099\016\108\025\047\052\027\078\017\025\036\058\099\108\008\077\025")..Score).._o9p("\102\112\076\018\097\099\016\108\025\036\058\099\108\008\025\032\099\023\008\077\025"))..ScoreCode).._o9p("\102\112\076\018\073\052\027\068\016\106\025\112\105\071\117\025\099\027\025\106\125\008\025\040\008\099\058\078\058\125\008\025\017\099\040\012\025\033\099\108\025\013\008\108\052\033\052\058\078\106\052\099\027\025\078\027\023\025\085\108\078\040\040\052\027\040\025\108\052\040\125\106\012\109"), 
													Media = zmediaicSCROLL, 
													Buttons = {
														_o9p("\089\079\116\071\025\015\100\035\089")
													}, 
													Callback = function(action)
														if action ~= nil then
															cartGC2C5FN.Complete = true
															_Urwigo.MessageBox{
																Text = _o9p("\097\099\016\025\125\078\013\008\025\058\099\059\068\017\008\106\008\023\025\106\125\008\025\040\078\059\008\057\025\097\099\016\025\058\078\027\025\027\099\030\025\089\079\116\071\025\106\125\008\025\040\078\059\008\025\099\108\025\032\105\067\071\116\067\050\089\025\106\099\025\017\099\099\024\025\078\108\099\016\027\023\025\052\027\025\040\078\059\008\057\025\097\099\016\108\025\068\078\108\024\052\027\040\025\017\099\058\078\106\052\099\027\025\052\012\025\078\013\078\052\017\078\085\017\008\025\052\027\025\106\125\008\025\107\099\058\078\106\052\099\027\012\025\078\108\008\078\057\025\071\125\078\027\024\012\025\033\099\108\025\068\017\078\111\052\027\040\043"), 
																Media = zmediaicSAVE, 
																Buttons = {
																	_o9p("\089\079\116\071"), 
																	_o9p("\032\105\067\071\116\067\050\089")
																}, 
																Callback = function(action)
																	if action ~= nil then
																		if action == "Button1" then
																			Wherigo.Command "SaveClose"
																		else
																			cartGC2C5FN:RequestSync()
																			Wherigo.ShowScreen(Wherigo.DETAILSCREEN, zoneStoneworks)
																		end
																	end
																end
															}
														end
													end
												}
											end
										end
									}
								end
							end
						}
					end
				end
			}
		elseif (Score >= 300) and (Score <= 499) then
			acend = 3
			Score = Score + 300
			SCGen()
			Wherigo.PlayAudio(zmediaSNDBGMintro)
			zitemStrangeStatue:MoveTo(nil)
			_Urwigo.MessageBox{
				Text = _o9p("\097\099\016\025\012\017\052\068\025\052\027\106\099\025\016\027\058\099\027\012\058\052\099\016\012\027\008\012\012\025\090\016\012\106\025\078\012\025\032\106\125\016\017\125\016\025\106\099\016\058\125\008\012\025\111\099\016\057\025\097\099\016\025\125\078\013\008\025\023\078\108\024\025\078\027\023\025\106\030\052\012\106\008\023\025\023\108\008\078\059\012\025\078\027\023\025\078\030\078\024\008\027\025\106\099\025\111\099\016\108\012\008\017\033\025\012\058\108\008\078\059\052\027\040\057\025\097\099\016\025\017\099\099\024\025\078\108\099\016\027\023\025\078\027\023\025\033\052\027\023\025\106\125\078\106\025\052\106\025\052\012\025\023\078\111\017\052\040\125\106\025\078\040\078\052\027\025\078\027\023\025\106\125\078\106\025\111\099\016\025\078\108\008\025\017\078\111\052\027\040\025\052\027\025\106\125\008\025\059\052\023\023\017\008\025\099\033\025\106\125\008\025\058\017\008\078\108\008\023\025\008\023\040\008\025\027\008\055\106\025\106\099\025\106\125\008\025\108\008\059\078\052\027\012\025\099\033\025\078\025\023\030\052\027\023\017\052\027\040\046\025\012\059\099\017\023\008\108\052\027\040\025\033\052\108\008\057\025\067\008\052\106\125\008\108\025\032\106\125\016\017\125\016\025\027\099\108\025\111\099\016\108\025\058\078\068\106\099\108\012\025\078\108\008\025\078\027\111\030\125\008\108\008\025\052\027\025\012\052\040\125\106\057\025\097\099\016\025\017\099\099\024\025\078\108\099\016\027\023\025\078\027\023\025\033\052\027\023\025\027\099\025\058\017\008\078\108\025\008\013\052\023\008\027\058\008\025\099\033\025\106\125\008\025\008\013\008\027\106\012\025\106\125\078\106\025\090\016\012\106\025\068\078\012\012\008\023\025\008\052\106\125\008\108\057\025\117\099\030\008\013\008\108\046\025\027\008\078\108\025\106\125\008\025\033\052\108\008\068\052\106\025\111\099\016\025\023\052\012\058\099\013\008\108\025\078\025\017\078\108\040\008\025\008\027\040\108\078\013\008\023\025\012\106\099\027\008\025\106\125\078\106\025\017\099\099\024\012\025\017\052\024\008\025\078\025\068\078\108\106\025\099\033\025\032\106\125\016\017\125\016\045\012\025\068\099\108\106\078\017\057\025\105\027\025\052\106\025\052\012\025\052\027\012\058\108\052\085\008\023\077\102\112\076\018\067\025\062\127\025\101\034\057\118\113\124\025\009\027\085\012\068\095\039\025\101\063\113\025\101\034\057\101\127\062"), 
				Media = zmediaEND3, 
				Callback = function(action)
					if action ~= nil then
						Wherigo.PlayAudio(zmediaSNDBGMindustrial)
						_Urwigo.MessageBox{
							Text = "", 
							Media = zmediaeDONE, 
							Buttons = {
								_o9p("\032\105\067\071\116\067\050\089")
							}, 
							Callback = function(action)
								if action ~= nil then
									_Urwigo.MessageBox{
										Text = (_o9p("\097\099\016\108\025\039\125\008\108\052\040\099\025\032\099\059\068\017\008\106\052\099\027\025\032\099\023\008\025\052\012\077\102\112\076\018\025")..string.sub(Player.CompletionCode, 1, 15)).._o9p("\102\112\076\018\073\052\027\068\016\106\025\099\027\025\039\125\008\108\052\040\099\057\058\099\059\025\106\099\025\059\078\108\024\025\106\125\078\106\025\111\099\016\025\058\099\059\068\017\008\106\008\023\025\052\106\109"), 
										Media = zmediaicSAVE, 
										Callback = function(action)
											if action ~= nil then
												_Urwigo.MessageBox{
													Text = (((_o9p("\097\099\016\108\025\047\052\027\078\017\025\036\058\099\108\008\077\025")..Score).._o9p("\102\112\076\018\097\099\016\108\025\036\058\099\108\008\025\032\099\023\008\077\025"))..ScoreCode).._o9p("\102\112\076\018\073\052\027\068\016\106\025\112\105\071\117\025\099\027\025\106\125\008\025\040\008\099\058\078\058\125\008\025\017\099\040\012\025\033\099\108\025\013\008\108\052\033\052\058\078\106\052\099\027\025\078\027\023\025\085\108\078\040\040\052\027\040\025\108\052\040\125\106\012\109"), 
													Media = zmediaicSCROLL, 
													Buttons = {
														_o9p("\089\079\116\071\025\015\100\035\089")
													}, 
													Callback = function(action)
														if action ~= nil then
															cartGC2C5FN.Complete = true
															_Urwigo.MessageBox{
																Text = _o9p("\097\099\016\025\125\078\013\008\025\058\099\059\068\017\008\106\008\023\025\106\125\008\025\040\078\059\008\057\025\097\099\016\025\058\078\027\025\027\099\030\025\089\079\116\071\025\106\125\008\025\040\078\059\008\025\099\108\025\032\105\067\071\116\067\050\089\025\106\099\025\017\099\099\024\025\078\108\099\016\027\023\025\052\027\025\040\078\059\008\057\025\097\099\016\108\025\068\078\108\024\052\027\040\025\017\099\058\078\106\052\099\027\025\052\012\025\078\013\078\052\017\078\085\017\008\025\052\027\025\106\125\008\025\107\099\058\078\106\052\099\027\012\025\078\108\008\078\057\025\071\125\078\027\024\012\025\033\099\108\025\068\017\078\111\052\027\040\043"), 
																Media = zmediaicSAVE, 
																Buttons = {
																	_o9p("\089\079\116\071"), 
																	_o9p("\032\105\067\071\116\067\050\089")
																}, 
																Callback = function(action)
																	if action ~= nil then
																		if action == "Button1" then
																			Wherigo.Command "SaveClose"
																		else
																			cartGC2C5FN:RequestSync()
																			Wherigo.ShowScreen(Wherigo.DETAILSCREEN, zoneStoneworks)
																		end
																	end
																end
															}
														end
													end
												}
											end
										end
									}
								end
							end
						}
					end
				end
			}
		elseif (Score >= 150) and (Score <= 299) then
			acend = 2
			Score = Score + 200
			SCGen()
			Wherigo.PlayAudio(zmediaSNDBGMintro)
			zitemStrangeStatue:MoveTo(nil)
			_Urwigo.MessageBox{
				Text = _o9p("\097\099\016\025\012\017\052\068\025\052\027\106\099\025\016\027\058\099\027\012\058\052\099\016\012\027\008\012\012\025\090\016\012\106\025\078\012\025\032\106\125\016\017\125\016\025\106\099\016\058\125\008\012\025\111\099\016\057\025\097\099\016\025\125\078\013\008\025\023\078\108\024\025\078\027\023\025\106\030\052\012\106\008\023\025\023\108\008\078\059\012\025\078\027\023\025\078\030\078\024\008\027\025\106\099\025\111\099\016\108\012\008\017\033\025\012\058\108\008\078\059\052\027\040\057"), 
				Media = zmediaEND2, 
				Callback = function(action)
					if action ~= nil then
						_Urwigo.MessageBox{
							Text = _o9p("\097\099\016\025\017\099\099\024\025\078\108\099\016\027\023\025\078\027\023\025\033\052\027\023\025\106\125\078\106\025\111\099\016\025\078\108\008\025\052\027\025\111\099\016\108\025\085\008\023\057\057\057\025\039\078\012\025\052\106\025\078\017\017\025\078\025\023\108\008\078\059\021\025\097\099\016\025\012\030\008\078\108\025\106\125\078\106\025\052\106\025\030\078\012\025\012\099\025\013\052\013\052\023\025\078\027\023\025\023\008\106\078\052\017\008\023\057\057\057\025\116\106\025\058\099\016\017\023\027\045\106\025\125\078\013\008\025\085\008\008\027\025\078\025\023\108\008\078\059\043\025\107\099\099\024\052\027\040\025\078\108\099\016\027\023\025\106\125\008\025\108\099\099\059\046\025\111\099\016\025\012\106\099\068\025\078\012\025\111\099\016\025\027\099\106\052\058\008\025\106\125\078\106\025\016\068\099\027\025\111\099\016\108\025\030\078\017\017\046\025\052\027\012\058\108\052\085\008\023\025\052\027\025\085\017\099\099\023\046\025\052\012\077\102\112\076\018\067\025\062\127\025\101\034\057\118\113\124\025\009\027\085\012\068\095\039\025\101\063\113\025\101\034\057\101\127\062"), 
							Media = zmediazBED, 
							Callback = function(action)
								if action ~= nil then
									Wherigo.PlayAudio(zmediaSNDBGMindustrial)
									_Urwigo.MessageBox{
										Text = "", 
										Media = zmediaeDONE, 
										Buttons = {
											_o9p("\032\105\067\071\116\067\050\089")
										}, 
										Callback = function(action)
											if action ~= nil then
												_Urwigo.MessageBox{
													Text = (_o9p("\097\099\016\108\025\039\125\008\108\052\040\099\025\032\099\059\068\017\008\106\052\099\027\025\032\099\023\008\025\052\012\077\102\112\076\018\025")..string.sub(Player.CompletionCode, 1, 15)).._o9p("\102\112\076\018\073\052\027\068\016\106\025\099\027\025\039\125\008\108\052\040\099\057\058\099\059\025\106\099\025\059\078\108\024\025\106\125\078\106\025\111\099\016\025\058\099\059\068\017\008\106\008\023\025\052\106\109"), 
													Media = zmediaicSAVE, 
													Callback = function(action)
														if action ~= nil then
															_Urwigo.MessageBox{
																Text = (((_o9p("\097\099\016\108\025\047\052\027\078\017\025\036\058\099\108\008\077\025")..Score).._o9p("\102\112\076\018\097\099\016\108\025\036\058\099\108\008\025\032\099\023\008\077\025"))..ScoreCode).._o9p("\102\112\076\018\073\052\027\068\016\106\025\112\105\071\117\025\099\027\025\106\125\008\025\040\008\099\058\078\058\125\008\025\017\099\040\012\025\033\099\108\025\013\008\108\052\033\052\058\078\106\052\099\027\025\078\027\023\025\085\108\078\040\040\052\027\040\025\108\052\040\125\106\012\109"), 
																Media = zmediaicSCROLL, 
																Buttons = {
																	_o9p("\089\079\116\071\025\015\100\035\089")
																}, 
																Callback = function(action)
																	if action ~= nil then
																		cartGC2C5FN.Complete = true
																		Wherigo.Command "SaveClose"
																	end
																end
															}
														end
													end
												}
											end
										end
									}
								end
							end
						}
					end
				end
			}
		elseif Score <= 149 then
			acend = 1
			Score = Score + 100
			SCGen()
			Wherigo.PlayAudio(zmediaSNDBGMintro)
			zitemStrangeStatue:MoveTo(nil)
			_Urwigo.MessageBox{
				Text = _o9p("\097\099\016\025\012\017\052\068\025\052\027\106\099\025\016\027\058\099\027\012\058\052\099\016\012\027\008\012\012\025\090\016\012\106\025\078\012\025\032\106\125\016\017\125\016\025\106\099\016\058\125\008\012\025\111\099\016\057\025\097\099\016\025\125\078\013\008\025\023\078\108\024\025\078\027\023\025\106\030\052\012\106\008\023\025\023\108\008\078\059\012\025\078\027\023\025\078\030\078\024\008\027\025\106\099\025\111\099\016\108\012\008\017\033\025\012\058\108\008\078\059\052\027\040\057"), 
				Media = zmediaEND1, 
				Callback = function(action)
					if action ~= nil then
						_Urwigo.MessageBox{
							Text = _o9p("\097\099\016\025\017\099\099\024\025\078\108\099\016\027\023\025\078\027\023\025\033\052\027\023\025\106\125\078\106\025\111\099\016\025\078\108\008\025\052\027\025\111\099\016\108\025\085\008\023\057\057\057\025\039\078\012\025\052\106\025\078\017\017\025\078\025\023\108\008\078\059\021\025\097\099\016\025\012\030\008\078\108\025\106\125\078\106\025\052\106\025\030\078\012\025\012\099\025\013\052\013\052\023\025\078\027\023\025\023\008\106\078\052\017\008\023\057\057\057\025\116\106\025\058\099\016\017\023\027\045\106\025\125\078\013\008\025\085\008\008\027\025\078\025\023\108\008\078\059\043\025\107\099\099\024\052\027\040\025\078\108\099\016\027\023\025\106\125\008\025\108\099\099\059\025\111\099\016\025\027\099\106\052\058\008\025\027\099\106\125\052\027\040\025\106\125\078\106\025\030\099\016\017\023\025\052\027\023\052\058\078\106\008\025\078\027\111\106\125\052\027\040\025\108\008\078\017\017\111\025\125\078\068\068\008\027\008\023\057\057\057"), 
							Media = zmediazBED, 
							Callback = function(action)
								if action ~= nil then
									_Urwigo.MessageBox{
										Text = _o9p("\071\008\058\125\027\052\058\078\017\017\111\046\025\111\099\016\025\017\099\012\106\025\106\125\008\025\040\078\059\008\057\025\112\016\106\025\085\008\058\078\016\012\008\025\030\008\025\078\108\008\025\027\052\058\008\025\078\027\023\025\106\125\078\027\024\025\111\099\016\025\033\099\108\025\068\017\078\111\052\027\040\046\025\125\008\108\008\025\078\108\008\025\106\125\008\025\058\099\099\108\023\052\027\078\106\008\012\025\033\099\108\025\106\125\008\025\058\078\058\125\008\077\102\112\076\018\067\025\062\127\025\101\034\057\118\113\124\025\009\027\085\012\068\095\039\025\101\063\113\025\101\034\057\101\127\062"), 
										Media = zmediaicDANGER, 
										Callback = function(action)
											if action ~= nil then
												Wherigo.PlayAudio(zmediaSNDBGMindustrial)
												_Urwigo.MessageBox{
													Text = "", 
													Media = zmediaeDONE, 
													Buttons = {
														_o9p("\032\105\067\071\116\067\050\089")
													}, 
													Callback = function(action)
														if action ~= nil then
															_Urwigo.MessageBox{
																Text = (_o9p("\097\099\016\108\025\039\125\008\108\052\040\099\025\032\099\059\068\017\008\106\052\099\027\025\032\099\023\008\025\052\012\077\102\112\076\018\025")..string.sub(Player.CompletionCode, 1, 15)).._o9p("\102\112\076\018\073\052\027\068\016\106\025\099\027\025\039\125\008\108\052\040\099\057\058\099\059\025\106\099\025\059\078\108\024\025\106\125\078\106\025\111\099\016\025\058\099\059\068\017\008\106\008\023\025\052\106\109"), 
																Media = zmediaicSAVE, 
																Callback = function(action)
																	if action ~= nil then
																		_Urwigo.MessageBox{
																			Text = (((_o9p("\097\099\016\108\025\047\052\027\078\017\025\036\058\099\108\008\077\025")..Score).._o9p("\102\112\076\018\097\099\016\108\025\036\058\099\108\008\025\032\099\023\008\077\025"))..ScoreCode).._o9p("\102\112\076\018\073\052\027\068\016\106\025\112\105\071\117\025\099\027\025\106\125\008\025\040\008\099\058\078\058\125\008\025\017\099\040\012\025\033\099\108\025\013\008\108\052\033\052\058\078\106\052\099\027\025\078\027\023\025\085\108\078\040\040\052\027\040\025\108\052\040\125\106\012\109"), 
																			Media = zmediaicSCROLL, 
																			Buttons = {
																				_o9p("\089\079\116\071\025\015\100\035\089")
																			}, 
																			Callback = function(action)
																				if action ~= nil then
																					cartGC2C5FN.Complete = true
																					Wherigo.Command "SaveClose"
																				end
																			end
																		}
																	end
																end
															}
														end
													end
												}
											end
										end
									}
								end
							end
						}
					end
				end
			}
		end
	end
end
function ztimerlilDOOM:OnTick()
	TestVar = (""..(UpdateStats()))..""
	ztimerlilDOOM:Start()
end
function ztimerANIM:OnTick()
	AnimCount = AnimCount + 1
	TestVar = (""..(animatic(AnimCount)))..""
end
function ztimerSanity:OnTick()
	if Player:Contains(zitemGearPack) then
		if zitemFlashlight.Opened == true then
			PowerFlashlight = PowerFlashlight + -5
			if PowerFlashlight <= 0 then
				zitemFlashlight.Locked = true
				zitemFlashlight.Commands.TurnOff.Enabled = false
				zitemFlashlight.Commands.CheckBattery.Enabled = false
				zitemFlashlight.Commands.Makesureitsworking.Enabled = true
				zitemFlashlight.Media = zmediaitFLASHLIGHT0
			end
		end
		if zitemGPS.Opened == true then
			PowerGPS = PowerGPS + -5
			if PowerGPS <= 0 then
				zitemGPS.Locked = true
				zitemGPS.Media = zmediaitGPS0
				zitemGPS.Commands.Makesureitsworking.Enabled = true
				zitemGPS.Commands.CheckBattery.Enabled = false
				zitemGPS.Commands.TurnOff.Enabled = false
				zitemGPS.Commands.CheckPosition.Enabled = false
			end
		end
		if zitemCell.Opened == true then
			PowerCell = PowerCell + -5
			if PowerCell <= 0 then
				zitemCell.Locked = true
				zitemCell.Media = zmediaitCELL0
				zitemCell.Commands.CheckBattery.Enabled = false
				zitemCell.Commands.CheckPhotos.Enabled = false
				zitemCell.Commands.CheckforService.Enabled = false
				zitemCell.Commands.TurnOff.Enabled = false
				zitemCell.Commands.Makesureitsworking.Enabled = true
			end
		end
	end
	SanityLevel = SanityLevel + -2
	ztimerSanity:Start()
end
function ztimerSave:OnTick()
	HandCheck()
	if RandEnc == true then
		local _rndChoiceValue = math.random()
		if _rndChoiceValue < 0.25 then
			_Urwigo.MessageBox{
				Text = _o9p("\097\099\016\025\125\008\078\108\025\106\125\008\025\012\099\016\027\023\025\099\033\025\012\099\059\008\106\125\052\027\040\025\108\016\012\106\017\052\027\040\025\052\027\025\106\125\008\025\085\108\016\012\125\025\016\068\025\078\125\008\078\023\057\025\039\125\008\027\025\111\099\016\025\108\008\078\058\125\025\052\106\046\025\111\099\016\025\033\052\027\023\025\027\099\106\125\052\027\040\025\099\108\025\027\099\025\099\027\008\025\106\099\025\085\008\025\012\008\008\027\057\057\057")
			}
		elseif _rndChoiceValue < 0.5 then
			_Urwigo.MessageBox{
				Text = _o9p("\050\068\025\078\125\008\078\023\025\099\033\025\111\099\016\046\025\111\099\016\025\058\078\106\058\125\025\078\025\040\017\052\059\068\012\008\025\099\033\025\012\099\059\008\106\125\052\027\040\025\059\099\013\052\027\040\057\025\097\099\016\025\125\008\078\023\025\033\099\108\030\078\108\023\025\078\025\017\052\106\106\017\008\025\078\027\023\025\033\052\027\023\025\027\099\106\125\052\027\040\025\099\108\025\027\099\025\099\027\008\025\052\027\025\012\052\040\125\106\057\057\057")
			}
		elseif _rndChoiceValue < 0.75 then
			_Urwigo.MessageBox{
				Text = _o9p("\097\099\016\025\012\106\099\068\025\033\099\108\025\078\025\059\099\059\008\027\106\025\030\052\106\125\025\078\025\012\106\078\108\106\017\008\025\078\012\025\111\099\016\025\040\008\106\025\106\125\008\025\016\027\027\008\108\013\052\027\040\025\033\008\008\017\052\027\040\025\106\125\078\106\025\012\099\059\008\099\027\008\025\099\108\025\012\099\059\008\106\125\052\027\040\025\052\012\025\030\078\106\058\125\052\027\040\025\111\099\016\057\025\097\099\016\025\017\099\099\024\025\078\108\099\016\027\023\046\025\085\016\106\025\023\099\027\045\106\025\012\008\008\025\078\027\111\106\125\052\027\040\057\057\057")
			}
		else
			_Urwigo.MessageBox{
				Text = _o9p("\116\027\025\106\125\008\025\023\052\012\106\078\027\058\008\025\078\125\008\078\023\046\025\111\099\016\025\125\008\078\108\025\012\099\059\008\106\125\052\027\040\025\106\125\078\106\025\012\099\016\027\023\012\025\078\025\017\052\106\106\017\008\025\085\052\106\025\017\052\024\008\025\078\025\012\058\108\008\078\059\057\025\097\099\016\025\058\099\027\013\052\027\058\008\025\111\099\016\108\012\008\017\033\025\106\125\078\106\025\111\099\016\025\078\108\008\025\099\027\017\111\025\052\059\078\040\052\027\052\027\040\025\106\125\052\027\040\012\057\057\057")
			}
		end
	end
	cartGC2C5FN:RequestSync()
	ztimerSave:Start()
end
function ztimerDrum:OnTick()
	if Player:Contains(zitemDrums) or zitemGearPack:Contains(zitemDrums) then
	else
		Wherigo.PlayAudio(zmediaSNDritualdrums)
		SanityLevel = SanityLevel + -2
	end
	ztimerDrum:Start()
end
function zcharacterCTHULHU:OnWatchinFear(target)
	_Urwigo.MessageBox{
		Text = _o9p("\015\017\099\030\052\027\040\025\008\111\008\012\025\068\052\008\108\058\008\025\106\125\008\025\085\017\078\058\024\027\008\012\012\025\099\033\025\106\125\008\025\012\125\052\059\059\008\108\052\027\040\025\078\085\111\012\012\025\085\008\033\099\108\008\025\111\099\016\057\025\097\099\016\025\058\078\027\025\099\027\017\111\025\078\012\012\016\059\008\025\106\125\078\106\025\106\125\052\012\025\052\012\025\032\106\125\016\017\125\016\025\111\099\016\025\012\008\008\025\085\008\033\099\108\008\025\111\099\016\057\057\057"), 
		Media = zmediacRISEN1, 
		Callback = function(action)
			if action ~= nil then
				_Urwigo.MessageBox{
					Text = _o9p("\100\025\040\078\106\008\030\078\111\025\040\108\078\023\016\078\017\017\111\025\059\078\106\008\108\052\078\017\052\065\008\012\025\033\108\099\059\025\030\052\106\125\052\027\025\106\125\008\025\078\085\111\012\012\025\078\027\023\025\017\099\027\040\025\012\017\052\059\111\025\106\008\027\106\078\058\017\008\012\025\008\059\008\108\040\008\025\033\108\099\059\025\052\106\057\057\057"), 
					Media = zmediacRISEN2, 
					Callback = function(action)
						if action ~= nil then
							_Urwigo.MessageBox{
								Text = _o9p("\071\125\008\025\040\078\106\008\030\078\111\025\078\027\023\025\106\125\008\025\106\008\108\108\099\108\025\030\052\106\125\052\027\025\012\099\017\052\023\052\033\052\008\012\025\052\027\106\099\025\108\008\078\017\052\106\111\057\057\057\102\112\076\018\097\099\016\108\025\058\078\068\106\099\108\012\025\058\016\106\025\111\099\016\108\025\125\078\027\023\025\099\068\008\027\025\030\052\106\125\025\078\025\023\078\040\040\008\108\025\078\027\023\025\068\016\012\125\025\052\106\025\106\099\030\078\108\023\012\025\106\125\008\025\068\099\108\106\078\017\057\057\057"), 
								Media = zmediacRISEN3, 
								Callback = function(action)
									if action ~= nil then
										Wherigo.PlayAudio(zmediaSNDrisen)
										_Urwigo.MessageBox{
											Text = _o9p("\112\017\099\099\023\025\033\017\099\030\012\025\033\108\099\059\025\111\099\016\108\025\030\099\016\027\023\025\078\027\023\025\033\078\017\017\012\025\106\099\025\106\125\008\025\040\108\099\016\027\023\057\025\032\106\125\016\017\125\016\025\008\059\008\108\040\008\012\025\033\108\099\059\025\106\125\008\025\008\017\023\108\052\106\058\125\025\068\099\108\106\078\017\025\078\027\023\025\108\008\078\058\125\008\012\025\099\016\106\025\106\099\025\058\017\078\052\059\025\125\052\012\025\012\078\058\108\052\033\052\058\008\057\057\057"), 
											Media = zmediacRISEN4, 
											Callback = function(action)
												if action ~= nil then
													_Urwigo.MessageBox{
														Text = _o9p("\039\008\078\024\025\033\108\099\059\025\106\125\008\025\106\108\078\016\059\078\025\099\033\025\106\125\008\025\099\108\023\008\078\017\025\078\027\023\025\111\099\016\108\025\052\027\058\108\008\078\012\052\027\040\025\017\099\012\012\025\099\033\025\085\017\099\099\023\046\025\111\099\016\025\085\008\040\052\027\025\106\099\025\068\078\012\012\025\099\016\106\025\078\012\025\032\106\125\016\017\125\016\025\040\008\106\012\025\008\013\008\108\025\058\017\099\012\008\108\025\106\099\025\058\017\078\052\059\052\027\040\025\111\099\016\108\025\012\099\016\017\057\057\057"), 
														Media = zmediacRISEN5, 
														Buttons = {
															_o9p("\067\067\067\105\105\099\099\099\099\099\099\043")
														}, 
														Callback = function(action)
															if action ~= nil then
																Wherigo.PlayAudio(zmediaSNDzap)
																if SaveStateTimer > 0 then
																	actimer = SaveStateTimer
																else
																	actimer = 0
																end
																acsanity = SanityLevel
																if MBS1Clue == 2 then
																	acmbs1 = 1
																else
																	acmbs1 = 0
																end
																if MBS2Clue == 2 then
																	acmbs2 = 1
																else
																	acmbs2 = 0
																end
																if Player:Contains(zitemStrangeStatue) or zitemGearPack:Contains(zitemStrangeStatue) then
																	acstatue = 1
																else
																	acstatue = 0
																end
																if Player:Contains(zitemDrums) or zitemGearPack:Contains(zitemDrums) then
																	acdrums = 1
																else
																	acdrums = 0
																end
																if Player:Contains(zitemGearPack) then
																	acgear = 1
																	acpower = PowerCell + PowerFlashlight + PowerGPS
																else
																	acgear = 0
																	acpower = 0
																end
																EndThis()
																cartGC2C5FN:RequestSync()
																_Urwigo.RunDialogs(function()
																	Wherigo.GetInput(zEnding)
																end)
															end
														end
													}
												end
											end
										}
									end
								end
							}
						end
					end
				}
			end
		end
	}
end
function zcharacterNYARLATHOTEP:OnConversate(target)
	_Urwigo.MessageBox{
		Text = _o9p("\015\017\078\023\025\111\099\016\025\058\099\016\017\023\025\090\099\052\027\025\016\012\025\033\052\027\078\017\017\111\057\025\039\008\025\125\078\013\008\025\085\008\008\027\025\030\078\052\106\052\027\040\025\033\099\108\025\111\099\016\057\025\039\008\025\125\078\013\008\025\085\008\008\027\025\030\078\052\106\052\027\040\025\033\099\108\025\106\125\052\012\025\059\099\059\008\027\106\025\033\099\108\025\012\099\059\008\025\106\052\059\008\057\025\097\099\016\025\030\052\017\017\025\085\008\025\030\052\106\027\008\012\012\025\106\099\025\078\027\025\008\013\008\027\106\025\106\125\078\106\025\125\078\012\027\045\106\025\125\078\068\068\008\027\008\023\025\052\027\025\008\099\027\012\057\057\057\025\106\125\008\025\078\030\078\024\008\027\052\027\040\025\099\033\025\106\125\008\025\012\017\008\008\068\008\108\057\025\015\108\008\078\106\025\032\106\125\016\017\125\016\025\078\030\078\024\008\025\078\040\078\052\027\025\078\106\025\017\078\012\106\057\025"), 
		Media = zmediacGIMME1, 
		Buttons = {
			_o9p("\117\099\030\025\058\078\027\025\106\125\078\106\025\085\008\025\068\099\012\012\052\085\017\008\021\043")
		}, 
		Callback = function(action)
			if action ~= nil then
				_Urwigo.MessageBox{
					Text = _o9p("\097\099\016\025\125\008\017\068\008\023\025\017\008\078\023\025\016\012\025\106\099\025\106\125\008\025\015\008\099\027\099\059\052\058\099\027\025\008\078\108\017\052\008\108\057\025\039\008\025\125\078\013\008\025\108\008\058\099\013\008\108\008\023\025\015\108\008\078\106\025\032\106\125\016\017\125\016\045\012\025\008\033\033\052\040\111\057\025\039\008\025\125\078\023\025\078\017\017\025\106\125\008\025\027\008\008\023\008\023\025\058\099\059\068\099\027\008\027\106\012\025\033\099\108\025\106\125\008\025\076\052\106\016\078\017\025\012\078\013\008\025\099\027\008\057\057\057\025\111\099\016\057"), 
					Media = zmediacGIMME2, 
					Callback = function(action)
						if action ~= nil then
							_Urwigo.MessageBox{
								Text = _o9p("\039\125\078\106\025\023\099\025\030\008\025\027\008\008\023\025\111\099\016\025\033\099\108\046\025\111\099\016\025\059\078\111\025\085\008\025\078\012\024\052\027\040\025\111\099\016\108\012\008\017\033\021\025\073\017\078\016\040\125\012\057\057\057\109\025\071\125\008\025\108\052\106\016\078\017\025\012\078\111\012\077\102\112\076\018\035\008\106\078\017\025\106\099\025\012\125\099\030\025\106\125\008\025\012\106\108\008\027\040\106\125\025\099\033\025\106\125\008\025\008\078\108\106\125\025\102\112\076\018\057\057\057\073\068\099\052\027\106\012\025\078\106\025\106\125\008\025\059\008\106\078\017\025\068\052\017\017\078\108\025\106\099\025\106\125\008\025\012\052\023\008\109\102\112\076\018\047\052\108\008\025\106\099\025\108\078\040\008\025\078\027\023\025\030\078\024\008\025\125\052\012\025\108\008\085\052\108\106\125\102\112\076\018\057\057\057\073\068\099\052\027\106\012\025\106\099\030\078\108\023\012\025\106\125\008\025\085\099\027\033\052\108\008\025\085\008\125\052\027\023\109\102\112\076\018\039\099\099\023\025\106\099\025\033\016\008\017\025\106\125\008\025\052\027\033\008\108\027\099\045\012\025\106\125\052\108\012\106\102\112\076\018\057\057\057\073\068\099\052\027\106\012\025\106\099\030\078\108\023\012\025\106\125\008\025\030\099\099\023\025\068\052\017\017\078\108\025\106\099\025\106\125\008\025\012\052\023\008\109\102\112\076\018\036\106\099\027\008\025\052\059\078\040\008\025\106\099\025\085\078\106\125\008\025\052\027\025\012\078\058\108\052\033\052\058\008\102\112\076\018\057\057\057\073\068\099\052\027\106\012\025\078\106\025\032\106\125\016\017\125\016\045\012\025\012\106\078\106\016\008\025\068\017\078\058\008\023\025\085\008\033\099\108\008\025\106\125\008\025\033\052\108\008\109\102\112\076\018\112\017\099\099\023\025\099\033\025\106\125\008\025\052\027\027\099\058\008\027\106\046\025\106\125\008\025\033\052\027\078\017\025\068\108\052\058\008\102\112\076\018\057\057\057\073\106\125\008\025\033\052\040\016\108\008\025\027\099\030\025\068\099\052\027\106\012\025\078\106\025\111\099\016\109"), 
								Media = zmediacGIMME2, 
								Callback = function(action)
									if action ~= nil then
										_Urwigo.MessageBox{
											Text = _o9p("\097\099\016\025\085\008\040\052\027\025\106\099\025\068\078\027\052\058\025\078\027\023\025\106\108\111\025\106\099\025\085\108\008\078\024\025\033\108\008\008\025\099\033\025\106\125\008\025\040\108\052\068\012\025\099\033\025\111\099\016\108\025\058\078\068\106\099\108\012\025\085\016\106\025\078\012\025\111\099\016\025\023\099\025\106\125\008\111\025\106\052\040\125\106\008\027\025\106\125\008\052\108\025\040\108\052\068\012\025\008\013\008\027\025\059\099\108\008\057"), 
											Media = zmediaicNOWALK, 
											Callback = function(action)
												if action ~= nil then
													_Urwigo.MessageBox{
														Text = _o9p("\116\106\025\052\012\025\106\052\059\008\025\106\099\025\085\008\040\052\027\057\025\039\099\108\108\111\025\027\099\106\057\025\097\099\016\108\025\012\078\058\108\052\033\052\058\008\025\030\052\017\017\025\017\008\078\023\025\106\125\008\025\030\078\111\025\106\099\025\106\125\008\025\040\017\099\108\052\099\016\012\025\023\099\030\027\033\078\017\017\025\099\033\025\059\078\027\024\052\027\023\057\025\073\071\125\008\025\033\052\040\016\108\008\025\085\008\040\052\027\012\025\106\099\025\058\125\078\027\106\025\012\099\059\008\025\040\016\106\106\008\108\078\017\025\017\078\027\040\016\078\040\008\057\025\097\099\016\108\025\012\024\052\027\025\085\008\040\052\027\012\025\106\099\025\058\108\078\030\017\025\078\012\025\106\125\008\025\078\052\108\025\052\012\025\058\125\078\108\040\008\023\025\030\052\106\125\025\008\027\008\108\040\111\057\109"), 
														Media = zmediacGIMME3, 
														Callback = function(action)
															if action ~= nil then
																_Urwigo.MessageBox{
																	Text = _o9p("\071\125\008\025\033\052\040\016\108\008\045\012\025\008\111\008\012\025\040\017\099\030\025\030\052\106\125\025\078\027\025\008\059\008\108\078\017\023\025\040\108\008\008\027\025\085\108\052\017\017\052\078\027\058\008\057\025\036\099\059\008\106\125\052\027\040\025\052\012\025\078\085\099\016\106\025\106\099\025\125\078\068\068\008\027\057\025\036\099\059\008\106\125\052\027\040\025\085\078\023\057"), 
																	Media = zmediacGIMME4, 
																	Callback = function(action)
																		if action ~= nil then
																			_Urwigo.MessageBox{
																				Text = _o9p("\071\125\008\025\033\052\040\016\108\008\025\106\016\108\027\012\025\106\099\025\106\125\008\025\108\078\040\052\027\040\025\085\099\027\033\052\108\008\025\106\125\078\106\025\125\078\012\025\085\008\040\016\027\025\106\099\025\085\016\108\027\025\078\027\025\008\069\016\078\017\017\111\025\085\108\052\017\017\052\078\027\106\025\040\108\008\008\027\025\040\017\099\030\025\078\027\023\025\085\008\040\052\027\012\025\106\099\025\058\125\078\027\106\025\008\013\008\027\025\059\099\108\008\025\033\016\108\052\099\016\012\017\111\057\057\057"), 
																				Media = zmediaePYRE1, 
																				Callback = function(action)
																					if action ~= nil then
																						Wherigo.PlayAudio(zmediaSNDghostly)
																						_Urwigo.MessageBox{
																							Text = _o9p("\071\008\027\023\108\052\017\012\025\099\033\025\040\108\008\008\027\025\033\017\078\059\008\025\108\052\012\008\025\016\068\025\052\027\106\099\025\106\125\008\025\078\052\108\025\033\108\099\059\025\106\125\008\025\085\099\027\033\052\108\008\057\057\057"), 
																							Media = zmediaePYRE2, 
																							Callback = function(action)
																								if action ~= nil then
																									_Urwigo.MessageBox{
																										Text = _o9p("\078\027\023\025\023\078\027\058\008\025\078\108\099\016\027\023\025\106\125\008\025\078\052\108\025\052\027\025\059\008\012\059\008\108\052\065\052\027\040\025\012\030\052\108\017\052\027\040\025\059\099\106\052\099\027\012\025\106\125\078\106\025\058\078\016\012\008\025\106\125\008\025\078\052\108\025\106\099\025\012\125\052\059\059\008\108\046\025\078\012\025\052\033\025\106\125\008\025\033\078\085\108\052\058\025\099\033\025\099\016\108\025\030\099\108\017\023\025\030\078\012\025\016\027\108\078\013\008\017\052\027\040\025\085\008\033\099\108\008\025\111\099\016\108\025\008\111\008\012\057\057"), 
																										Media = zmediaePYRE1, 
																										Callback = function(action)
																											if action ~= nil then
																												zcharacterCTHULHU.Visible = true
																												Wherigo.ShowScreen(Wherigo.DETAILSCREEN, zcharacterCTHULHU)
																											end
																										end
																									}
																								end
																							end
																						}
																					end
																				end
																			}
																		end
																	end
																}
															end
														end
													}
												end
											end
										}
									end
								end
							}
						end
					end
				}
			end
		end
	}
end
function zitemGearPack:OnOpenUp(target)
	conOpen()
end
function zitemGearPack:OnEmptyOut(target)
	conEmpty()
end
function zitemGearPack:OnCloseUp(target)
	conClose()
	IgnoreMe = false
end
function zitemYourBrokenCar:OnLeaveitbe(target)
	if (EventCar > 0) and (CheckCar == false) then
		_Urwigo.MessageBox{
			Text = _o9p("\097\099\016\025\023\008\058\052\023\008\025\106\125\008\025\008\027\040\052\027\008\025\052\012\025\085\008\106\106\008\108\025\099\033\033\025\052\027\025\106\125\008\025\125\078\027\023\012\025\099\033\025\078\025\068\108\099\033\008\012\012\052\099\027\078\017\025\078\027\023\025\017\008\078\013\008\025\052\106\025\085\008\057\025\097\099\016\025\030\078\017\024\025\078\108\099\016\027\023\025\106\099\025\106\125\008\025\023\108\052\013\008\108\025\023\099\099\108\025\078\027\023\025\108\008\059\008\059\085\008\108\025\106\125\078\106\025\111\099\016\025\017\099\058\024\008\023\025\111\099\016\108\025\024\008\111\012\025\052\027\025\106\125\008\025\058\078\108\043\025\015\016\008\012\012\025\111\099\016\025\085\008\106\106\008\108\025\125\078\013\008\025\078\025\017\099\099\024\025\078\108\099\016\027\023\025\106\125\008\027\021\025\073\015\078\052\027\025\127\025\036\078\027\052\106\111\109"), 
			Media = zmediaicCAR, 
			Buttons = {
				_o9p("\047\052\027\008\043")
			}, 
			Callback = function(action)
				if action ~= nil then
					SanityLevel = SanityLevel + 5
					CheckCar = true
					Wherigo.ShowScreen(Wherigo.LOCATIONSCREEN)
				end
			end
		}
	else
		_Urwigo.MessageBox{
			Text = _o9p("\097\099\016\025\023\008\058\052\023\008\025\106\125\008\025\008\027\040\052\027\008\025\052\012\025\085\008\106\106\008\108\025\099\033\033\025\052\027\025\106\125\008\025\125\078\027\023\012\025\099\033\025\078\025\068\108\099\033\008\012\012\052\099\027\078\017\025\078\027\023\025\017\008\078\013\008\025\052\106\025\085\008\057\025\097\099\016\025\030\078\017\024\025\078\108\099\016\027\023\025\106\099\025\106\125\008\025\023\108\052\013\008\108\025\023\099\099\108\025\078\027\023\025\108\008\059\008\059\085\008\108\025\106\125\078\106\025\111\099\016\025\017\099\058\024\008\023\025\111\099\016\108\025\024\008\111\012\025\052\027\025\106\125\008\025\058\078\108\043\025\015\016\008\012\012\025\111\099\016\025\085\008\106\106\008\108\025\125\078\013\008\025\078\025\017\099\099\024\025\078\108\099\016\027\023\025\106\125\008\027\021"), 
			Media = zmediaicCAR, 
			Buttons = {
				_o9p("\047\052\027\008\043")
			}, 
			Callback = function(action)
				if action ~= nil then
					Wherigo.ShowScreen(Wherigo.LOCATIONSCREEN)
				end
			end
		}
	end
end
function zitemYourBrokenCar:OnCheckitout(target)
	if EventCar == 0 then
		zitemYourBrokenCar.Media = zmediaitBROKENCAR2
		_Urwigo.MessageBox{
			Text = _o9p("\071\125\008\025\012\059\099\024\008\025\012\016\085\012\052\023\008\012\057\057\057"), 
			Media = zmediaicCAR, 
			Callback = function(action)
				if action ~= nil then
					EventCar = EventCar + 1
				end
			end
		}
	elseif EventCar == 1 then
		zitemYourBrokenCar.Media = zmediaitBROKENCAR3
		Wherigo.PlayAudio(zmediaSNDdundundun)
		_Urwigo.MessageBox{
			Text = _o9p("\039\125\078\106\025\052\027\025\106\125\008\025\030\099\108\017\023\025\052\012\025\106\125\078\106\021\043\025\102\112\076\018\073\107\099\012\008\025\049\101\025\036\078\027\052\106\111\109"), 
			Media = zmediaicMONSTER, 
			Callback = function(action)
				if action ~= nil then
					EventCar = EventCar + 1
					SanityLevel = SanityLevel + -10
				end
			end
		}
	elseif EventCar == 2 then
		zitemYourBrokenCar.Media = zmediaitBROKENCAR2
		_Urwigo.MessageBox{
			Text = _o9p("\039\125\078\106\008\013\008\108\025\052\106\025\030\078\012\025\052\012\025\008\052\106\125\008\108\025\040\099\027\008\025\099\108\025\078\025\033\052\040\059\008\027\106\025\099\033\025\111\099\016\108\025\052\059\078\040\052\027\078\106\052\099\027\057\057\057\057"), 
			Media = zmediaicQUESTION, 
			Callback = function(action)
				if action ~= nil then
					EventCar = EventCar + 1
				end
			end
		}
	else
		_Urwigo.MessageBox{
			Text = _o9p("\067\099\025\059\099\108\008\025\012\052\040\027\025\099\033\025\078\027\111\106\125\052\027\040\057\057\057\025\090\016\012\106\025\106\125\008\025\012\078\059\008\025\099\017\023\025\085\108\099\024\008\027\025\008\027\040\052\027\008\057\057\057\025\071\052\059\008\025\106\099\025\106\016\108\027\025\111\099\016\108\025\078\106\106\008\027\106\052\099\027\025\008\017\012\008\030\125\008\108\008\057\057\057"), 
			Media = zmediaicCAR
		}
	end
end
function zitemCell:OnCheckBattery(target)
	_Urwigo.MessageBox{
		Text = (_o9p("\112\078\106\106\008\108\111\025\107\008\013\008\017\025\052\012\025\058\016\108\108\008\027\106\017\111\025\078\106\025")..PowerCell).._o9p("\031"), 
		Media = zmediaicINFO, 
		Callback = function(action)
			if action ~= nil then
				if CheckCell ~= true then
					if PowerCell == 75 then
						SanityLevel = SanityLevel + 5
						CheckCell = true
					elseif PowerCell >= 50 then
						SanityLevel = SanityLevel + 1
						CheckCell = true
					end
				end
				if PowerCell <= 25 then
					SanityLevel = SanityLevel + -1
				elseif PowerCell <= 10 then
					SanityLevel = SanityLevel + -5
				end
			end
		end
	}
end
function zitemCell:OnCheckPhotos(target)
	_Urwigo.RunDialogs(function()
		Wherigo.GetInput(zinputPhonePics)
	end)
end
function zitemCell:OnCheckforService(target)
	if Wherigo.NoCaseEquals(SuppSound, _o9p("\089\067\100\112\107\089\044")) then
		Wherigo.Command "StopSound"
		Wherigo.PlayAudio(zmediaSNDnoservice)
	end
	_Urwigo.MessageBox{
		Text = _o9p("\067\099\068\008\057\057\057\025\027\099\025\012\008\108\013\052\058\008\025\012\106\052\017\017\057\057\057\025\102\112\076\018\073\107\099\012\008\025\049\025\036\078\027\052\106\111\109"), 
		Media = zmediaicCELL, 
		Callback = function(action)
			if action ~= nil then
				SanityLevel = SanityLevel - 1
			end
		end
	}
end
function zitemCell:OnTurnOff(target)
	if CheckCell == true then
		_Urwigo.MessageBox{
			Text = _o9p("\015\099\099\023\025\052\023\008\078\057\057\057\025\058\099\027\012\008\108\013\008\025\068\099\030\008\108\057\057\057"), 
			Media = zmediaitCELL0
		}
	else
		_Urwigo.MessageBox{
			Text = _o9p("\015\099\099\023\025\052\023\008\078\057\057\057\025\058\099\027\012\008\108\013\008\025\068\099\030\008\108\057\057\057\025\102\112\076\018\073\015\078\052\027\025\127\025\036\078\027\052\106\111\109"), 
			Media = zmediaitCELL0, 
			Callback = function(action)
				if action ~= nil then
					SanityLevel = SanityLevel + 5
				end
			end
		}
	end
	CheckCell = true
	zitemCell.Opened = false
	zitemCell.Commands.Makesureitsworking.Enabled = true
	zitemCell.Commands.CheckforService.Enabled = false
	zitemCell.Commands.CheckBattery.Enabled = false
	zitemCell.Commands.CheckPhotos.Enabled = false
	zitemCell.Commands.TurnOff.Enabled = false
	zitemCell.Media = zmediaitCELL0
end
function zitemCell:OnMakesureitsworking(target)
	if zitemCell.Locked == true then
		_Urwigo.MessageBox{
			Text = _o9p("\036\099\108\108\111\057\057\057\025\052\106\045\012\025\023\008\078\023\057\057\057"), 
			Media = zmediaitCELL0
		}
	elseif zitemCell.Opened ~= true then
		PowerCell = PowerCell + -1
		if CheckCell ~= true then
			_Urwigo.MessageBox{
				Text = _o9p("\097\008\068\057\057\057\025\052\106\025\012\106\052\017\017\025\030\099\108\024\012\043\025\102\112\076\018\073\015\078\052\027\025\034\025\036\078\027\052\106\111\109"), 
				Media = zmediaitCELL1, 
				Buttons = {
					_o9p("\107\008\078\013\008\025\052\106\025\099\027\057\057\057"), 
					_o9p("\071\016\108\027\025\052\106\025\099\033\033\057\057\057")
				}, 
				Callback = function(action)
					if action ~= nil then
						CheckCell = true
						SanityLevel = SanityLevel + 2
						if action == "Button1" then
							zitemCell.Opened = true
							zitemCell.Commands.Makesureitsworking.Enabled = false
							zitemCell.Commands.CheckforService.Enabled = true
							zitemCell.Commands.CheckBattery.Enabled = true
							zitemCell.Commands.CheckPhotos.Enabled = true
							zitemCell.Commands.TurnOff.Enabled = true
							zitemCell.Media = zmediaitCELL1
						else
							_Urwigo.MessageBox{
								Text = _o9p("\097\099\016\025\106\016\108\027\025\052\106\025\099\033\033\025\078\027\023\025\068\016\106\025\052\106\025\085\078\058\024\025\052\027\025\111\099\016\108\025\068\078\058\024\057\057\057"), 
								Media = zmediaicCHECK, 
								Buttons = {
									_o9p("\032\099\027\106\052\027\016\008\057\057\057")
								}
							}
						end
					end
				end
			}
		else
			_Urwigo.MessageBox{
				Text = _o9p("\097\008\068\057\057\057\025\052\106\025\012\106\052\017\017\025\030\099\108\024\012\043"), 
				Media = zmediaitCELL1, 
				Buttons = {
					_o9p("\107\008\078\013\008\025\052\106\025\099\027\057\057\057"), 
					_o9p("\071\016\108\027\025\052\106\025\099\033\033\057\057\057")
				}, 
				Callback = function(action)
					if action ~= nil then
						if action == "Button1" then
							zitemCell.Opened = true
							zitemCell.Commands.Makesureitsworking.Enabled = false
							zitemCell.Commands.CheckforService.Enabled = true
							zitemCell.Commands.CheckBattery.Enabled = true
							zitemCell.Commands.CheckPhotos.Enabled = true
							zitemCell.Commands.TurnOff.Enabled = true
							zitemCell.Media = zmediaitCELL1
						else
							_Urwigo.MessageBox{
								Text = _o9p("\097\099\016\025\106\016\108\027\025\052\106\025\099\033\033\025\078\027\023\025\068\016\106\025\052\106\025\085\078\058\024\025\052\027\025\111\099\016\108\025\068\078\058\024\057\057\057"), 
								Media = zmediaicCHECK, 
								Buttons = {
									_o9p("\032\099\027\106\052\027\016\008\057\057\057")
								}
							}
						end
					end
				end
			}
		end
	end
end
function zitemCell:On_mJR(target)
	zitemCell:MoveTo(zitemGearPack)
	conUpdate()
end
function zitemCell:On_XpToy(target)
	zitemCell:MoveTo(Player)
	conUpdate()
end
function zitemCell:On_W6m(target)
	IgnoreMe = false
	Wherigo.ShowScreen(Wherigo.INVENTORYSCREEN)
end
function zitemDrums:On_qYjb(target)
	zitemDrums:MoveTo(zitemGearPack)
	conUpdate()
end
function zitemDrums:On_kSg(target)
	zitemDrums:MoveTo(Player)
	conUpdate()
end
function zitemDrums:On_QNwA(target)
	_Urwigo.MessageBox{
		Text = _o9p("\097\099\016\025\023\008\058\052\023\008\025\052\106\025\030\099\016\017\023\025\085\008\025\085\008\012\106\025\106\099\025\090\016\012\106\025\017\008\078\013\008\025\052\106\025\078\017\099\027\008\057\057\057"), 
		Media = zmediaicINFO, 
		Callback = function(action)
			if action ~= nil then
				_Urwigo.MessageBox{
					Text = _o9p("\071\125\008\025\078\085\012\008\027\058\008\025\099\033\025\106\125\008\025\099\030\027\008\108\025\099\033\025\106\125\008\025\023\108\016\059\012\025\125\078\012\025\111\099\016\025\068\008\108\068\017\008\055\008\023\025\078\027\023\025\012\017\052\040\125\106\017\111\025\023\052\012\106\016\108\085\008\023\057\025\039\125\111\025\068\017\078\111\025\012\099\059\008\025\023\108\016\059\012\025\078\027\023\025\106\125\008\027\025\017\008\078\013\008\025\106\125\008\059\025\078\012\025\012\099\099\027\025\078\012\025\111\099\016\025\040\008\106\025\106\125\008\108\008\021\025\078\027\023\025\030\125\008\108\008\025\023\052\023\025\106\125\008\025\068\008\108\012\099\027\025\040\099\021\025\035\078\111\085\008\025\106\125\008\111\025\058\078\027\025\125\008\017\068\025\111\099\016\025\030\052\106\125\025\111\099\016\108\025\058\078\108\057\025\097\099\016\025\012\016\012\068\008\058\106\025\106\125\008\111\025\125\008\078\023\008\023\025\016\068\025\106\125\008\025\106\108\078\052\017\057\057\057"), 
					Media = zmediaicQUESTION, 
					Callback = function(action)
						if action ~= nil then
							Wherigo.PlayAudio(zmediaSNDBGMleadin)
							zitemDrums:MoveTo(zoneTrailhead)
							Wherigo.ShowScreen(Wherigo.LOCATIONSCREEN)
						end
					end
				}
			end
		end
	}
end
function zitemDrums:On_SMVlT(target)
	_Urwigo.MessageBox{
		Text = _o9p("\071\125\008\025\078\085\012\008\027\058\008\025\099\033\025\106\125\008\025\099\030\027\008\108\025\099\033\025\106\125\008\025\023\108\016\059\012\025\125\078\012\025\111\099\016\025\068\008\108\068\017\008\055\008\023\025\078\027\023\025\012\017\052\040\125\106\017\111\025\023\052\012\106\016\108\085\008\023\057\025\039\125\111\025\068\017\078\111\025\012\099\059\008\025\023\108\016\059\012\025\078\027\023\025\106\125\008\027\025\017\008\078\013\008\025\106\125\008\059\025\078\012\025\012\099\099\027\025\078\012\025\111\099\016\025\040\008\106\025\106\125\008\108\008\021\025\078\027\023\025\030\125\008\108\008\025\023\052\023\025\106\125\008\025\068\008\108\012\099\027\025\040\099\021\025\035\078\111\085\008\025\106\125\008\111\025\058\078\027\025\125\008\017\068\025\111\099\016\025\030\052\106\125\025\111\099\016\108\025\058\078\108\057\025\097\099\016\025\012\016\012\068\008\058\106\025\106\125\008\111\025\125\008\078\023\008\023\025\016\068\025\106\125\008\025\106\108\078\052\017\057\057\057"), 
		Media = zmediaicQUESTION, 
		Callback = function(action)
			if action ~= nil then
				Wherigo.PlayAudio(zmediaSNDBGMleadin)
				zitemDrums:MoveTo(Player)
				if Player:Contains(zitemGearPack) then
					zitemDrums.Commands._qYjb.Enabled = true
				end
				zitemDrums.Commands._QNwA.Enabled = false
				zitemDrums.Commands._SMVlT.Enabled = false
				Wherigo.ShowScreen(Wherigo.LOCATIONSCREEN)
			end
		end
	}
end
function zitemDrums:On_Yumwa(target)
	IgnoreMe = false
	Wherigo.ShowScreen(Wherigo.INVENTORYSCREEN)
end
function zitemFeather:OnLeaveitbe(target)
	zitemFeather:MoveTo(nil)
	if StatFeather == true then
		_Urwigo.MessageBox{
			Text = _o9p("\097\099\016\025\023\008\058\052\023\008\025\106\125\078\106\025\045\058\016\108\052\099\016\012\052\106\111\025\024\052\017\017\008\023\025\106\125\008\025\058\078\106\045\057\057\057\025\089\013\008\108\025\125\008\078\108\025\045\012\078\106\052\012\033\078\058\106\052\099\027\025\085\108\099\016\040\125\106\025\052\106\025\085\078\058\024\045\021\025\015\016\008\012\012\025\111\099\016\025\030\099\027\045\106\025\024\027\099\030\025\052\027\025\106\125\052\012\025\058\078\012\008\057\057\057"), 
			Media = zmediaicTHUMBD
		}
	else
		_Urwigo.MessageBox{
			Text = _o9p("\097\099\016\025\023\008\058\052\023\008\025\106\125\078\106\025\045\058\016\108\052\099\016\012\052\106\111\025\024\052\017\017\008\023\025\106\125\008\025\058\078\106\045\057\057\057\025\096\008\108\125\078\068\012\025\106\125\078\106\025\030\078\012\025\078\025\040\099\099\023\025\058\078\017\017\025\099\027\025\111\099\016\108\025\068\078\108\106\057\057\057"), 
			Media = zmediaicTHUMBU
		}
	end
	IgnoreMe = false
end
function zitemFeather:OnCheckitout(target)
	if StatFeather == true then
		Wherigo.PlayAudio(zmediaSNDbird)
		_Urwigo.MessageBox{
			Text = _o9p("\097\099\016\025\023\052\012\058\099\013\008\108\025\039\099\111\052\045\012\025\106\108\078\023\008\059\078\108\024\057\057\057\025\102\112\076\018\073\015\078\052\027\025\127\025\036\078\027\052\106\111\109"), 
			Media = zmediaitFEATHER, 
			Buttons = {
				_o9p("\067\052\058\008\043")
			}, 
			Callback = function(action)
				if action ~= nil then
					zitemFeather:MoveTo(nil)
					SanityLevel = SanityLevel + 5
					_Urwigo.MessageBox{
						Text = _o9p("\071\125\008\025\047\008\078\106\125\008\108\025\085\017\099\030\012\025\078\030\078\111\057\057\057"), 
						Media = zmediaicFACESAD, 
						Buttons = {
							_o9p("\112\111\008\103\112\111\008")
						}
					}
				end
			end
		}
	else
		Wherigo.PlayAudio(zmediaSNDraven)
		_Urwigo.MessageBox{
			Text = _o9p("\097\099\016\025\023\052\012\058\099\013\008\108\025\106\125\108\008\078\106\008\027\052\027\040\025\076\078\013\008\027\012\025\068\052\058\024\052\027\040\025\078\030\078\111\025\078\106\025\106\125\008\025\108\008\059\078\052\027\012\025\099\033\025\078\025\017\078\108\040\008\025\078\027\052\059\078\017\043\025\102\112\076\018\073\107\099\012\008\025\049\101\025\036\078\027\052\106\111\109"), 
			Media = zmediacRAVENS, 
			Buttons = {
				_o9p("\100\058\024\043")
			}, 
			Callback = function(action)
				if action ~= nil then
					zitemFeather:MoveTo(nil)
					SanityLevel = SanityLevel - 10
					_Urwigo.MessageBox{
						Text = _o9p("\097\099\016\025\023\008\058\052\023\008\025\052\106\025\030\099\016\017\023\025\085\008\025\085\008\012\106\025\106\099\025\017\008\078\013\008\025\106\125\008\025\076\078\013\008\027\012\025\106\099\025\106\125\008\052\108\025\033\008\078\012\106\057\057\057"), 
						Media = zmediaicHIKE, 
						Buttons = {
							_o9p("\107\078\106\008\108\043")
						}
					}
				end
			end
		}
	end
end
function zitemFlashlight:OnMakesureitsworking(target)
	if zitemFlashlight.Locked == true then
		_Urwigo.MessageBox{
			Text = _o9p("\036\099\108\108\111\057\057\057\025\052\106\045\012\025\023\008\078\023\057\057\057"), 
			Media = zmediaitFLASHLIGHT0
		}
	elseif zitemFlashlight.Opened ~= true then
		PowerFlashlight = PowerFlashlight + -1
		if CheckFlashlight ~= true then
			_Urwigo.MessageBox{
				Text = _o9p("\097\008\068\057\057\057\025\052\106\025\012\106\052\017\017\025\030\099\108\024\012\043\025\102\112\076\018\073\015\078\052\027\025\034\025\036\078\027\052\106\111\109"), 
				Media = zmediaitFLASHLIGHT1, 
				Buttons = {
					_o9p("\107\008\078\013\008\025\052\106\025\099\027\057\057\057"), 
					_o9p("\071\016\108\027\025\052\106\025\099\033\033\057\057\057")
				}, 
				Callback = function(action)
					if action ~= nil then
						SanityLevel = SanityLevel + 2
						CheckFlashlight = true
						if action == "Button1" then
							zitemFlashlight.Opened = true
							zitemFlashlight.Commands.Makesureitsworking.Enabled = false
							zitemFlashlight.Commands.CheckBattery.Enabled = true
							zitemFlashlight.Commands.TurnOff.Enabled = true
							zitemFlashlight.Media = zmediaitFLASHLIGHT1
						else
							_Urwigo.MessageBox{
								Text = _o9p("\097\099\016\025\106\016\108\027\025\052\106\025\099\033\033\025\078\027\023\025\068\016\106\025\052\106\025\085\078\058\024\025\052\027\025\111\099\016\108\025\068\078\058\024\057\057\057"), 
								Media = zmediaicCHECK, 
								Buttons = {
									_o9p("\032\099\027\106\052\027\016\008\057\057\057")
								}
							}
						end
					end
				end
			}
		else
			_Urwigo.MessageBox{
				Text = _o9p("\097\008\068\057\057\057\025\052\106\025\012\106\052\017\017\025\030\099\108\024\012\043"), 
				Media = zmediaitFLASHLIGHT1, 
				Buttons = {
					_o9p("\107\008\078\013\008\025\052\106\025\099\027\057\057\057"), 
					_o9p("\071\016\108\027\025\052\106\025\099\033\033\057\057\057")
				}, 
				Callback = function(action)
					if action ~= nil then
						if action == "Button1" then
							zitemFlashlight.Opened = true
							zitemFlashlight.Commands.Makesureitsworking.Enabled = false
							zitemFlashlight.Commands.CheckBattery.Enabled = true
							zitemFlashlight.Commands.TurnOff.Enabled = true
							zitemFlashlight.Media = zmediaitFLASHLIGHT1
						else
							_Urwigo.MessageBox{
								Text = _o9p("\097\099\016\025\106\016\108\027\025\052\106\025\099\033\033\025\078\027\023\025\068\016\106\025\052\106\025\085\078\058\024\025\052\027\025\111\099\016\108\025\068\078\058\024\057\057\057"), 
								Media = zmediaicCHECK, 
								Buttons = {
									_o9p("\032\099\027\106\052\027\016\008\057\057\057")
								}
							}
						end
					end
				end
			}
		end
	end
end
function zitemFlashlight:On_zsNb(target)
	zitemFlashlight:MoveTo(zitemGearPack)
	conUpdate()
end
function zitemFlashlight:On_v5M(target)
	zitemFlashlight:MoveTo(Player)
	conUpdate()
end
function zitemFlashlight:OnTurnOff(target)
	if CheckFlashlight == true then
		_Urwigo.MessageBox{
			Text = _o9p("\015\099\099\023\025\052\023\008\078\057\057\057\025\058\099\027\012\008\108\013\008\025\068\099\030\008\108\057\057\057"), 
			Media = zmediaitFLASHLIGHT0
		}
	else
		_Urwigo.MessageBox{
			Text = _o9p("\015\099\099\023\025\052\023\008\078\057\057\057\025\058\099\027\012\008\108\013\008\025\068\099\030\008\108\057\057\057\025\102\112\076\018\073\015\078\052\027\025\127\025\036\078\027\052\106\111\109"), 
			Media = zmediaitFLASHLIGHT0, 
			Callback = function(action)
				if action ~= nil then
					SanityLevel = SanityLevel + 5
				end
			end
		}
	end
	CheckFlashlight = true
	zitemFlashlight.Opened = false
	zitemFlashlight.Commands.Makesureitsworking.Enabled = true
	zitemFlashlight.Commands.CheckBattery.Enabled = false
	zitemFlashlight.Commands.TurnOff.Enabled = false
	zitemFlashlight.Media = zmediaitFLASHLIGHT0
end
function zitemFlashlight:OnCheckBattery(target)
	_Urwigo.MessageBox{
		Text = (_o9p("\047\108\099\059\025\106\125\008\025\085\108\052\040\125\106\027\008\012\012\025\099\033\025\106\125\008\025\017\052\040\125\106\025\111\099\016\025\040\016\008\012\012\106\052\059\078\106\008\025\106\125\008\025\112\078\106\106\008\108\111\025\107\008\013\008\017\025\052\012\025\058\016\108\108\008\027\106\017\111\025\078\106\025")..PowerFlashlight).._o9p("\031"), 
		Media = zmediaicINFO, 
		Callback = function(action)
			if action ~= nil then
				if CheckFlashlight ~= true then
					if PowerFlashlight == 75 then
						SanityLevel = SanityLevel + 5
						CheckFlashlight = true
					elseif PowerFlashlight >= 50 then
						SanityLevel = SanityLevel + 1
						CheckFlashlight = true
					end
				end
				if PowerFlashlight <= 25 then
					SanityLevel = SanityLevel + -1
				elseif PowerFlashlight <= 10 then
					SanityLevel = SanityLevel + -5
				end
			end
		end
	}
end
function zitemFlashlight:On_0hBQ(target)
	IgnoreMe = false
	Wherigo.ShowScreen(Wherigo.INVENTORYSCREEN)
end
function zitemGPS:OnMakesureitsworking(target)
	if zitemGPS.Locked == true then
		_Urwigo.MessageBox{
			Text = _o9p("\036\099\108\108\111\057\057\057\025\052\106\045\012\025\023\008\078\023\057\057\057"), 
			Media = zmediaitGPS0
		}
	elseif zitemGPS.Opened ~= true then
		PowerGPS = PowerGPS + -1
		if CheckGPS ~= true then
			_Urwigo.MessageBox{
				Text = _o9p("\097\008\068\057\057\057\025\052\106\025\012\106\052\017\017\025\030\099\108\024\012\043\025\102\112\076\018\073\015\078\052\027\025\034\025\036\078\027\052\106\111\109"), 
				Media = zmediaitGPS1, 
				Buttons = {
					_o9p("\107\008\078\013\008\025\052\106\025\099\027\057\057\057"), 
					_o9p("\071\016\108\027\025\052\106\025\099\033\033\057\057\057")
				}, 
				Callback = function(action)
					if action ~= nil then
						SanityLevel = SanityLevel + 2
						CheckGPS = true
						if action == "Button1" then
							zitemGPS.Opened = true
							zitemGPS.Commands.Makesureitsworking.Enabled = false
							zitemGPS.Commands.CheckBattery.Enabled = true
							zitemGPS.Commands.TurnOff.Enabled = true
							zitemGPS.Commands.CheckPosition.Enabled = true
							zitemGPS.Media = zmediaitGPS1
						else
							_Urwigo.MessageBox{
								Text = _o9p("\097\099\016\025\106\016\108\027\025\052\106\025\099\033\033\025\078\027\023\025\068\016\106\025\052\106\025\085\078\058\024\025\052\027\025\111\099\016\108\025\068\078\058\024\057\057\057"), 
								Media = zmediaicCHECK, 
								Buttons = {
									_o9p("\032\099\027\106\052\027\016\008\057\057\057")
								}
							}
						end
					end
				end
			}
		else
			_Urwigo.MessageBox{
				Text = _o9p("\097\008\068\057\057\057\025\052\106\025\012\106\052\017\017\025\030\099\108\024\012\043"), 
				Media = zmediaitGPS1, 
				Buttons = {
					_o9p("\107\008\078\013\008\025\052\106\025\099\027\057\057\057"), 
					_o9p("\071\016\108\027\025\052\106\025\099\033\033\057\057\057")
				}, 
				Callback = function(action)
					if action ~= nil then
						if action == "Button1" then
							zitemGPS.Opened = true
							zitemGPS.Commands.Makesureitsworking.Enabled = false
							zitemGPS.Commands.CheckBattery.Enabled = true
							zitemGPS.Commands.TurnOff.Enabled = true
							zitemGPS.Commands.CheckPosition.Enabled = true
							zitemGPS.Media = zmediaitGPS1
						else
							_Urwigo.MessageBox{
								Text = _o9p("\097\099\016\025\106\016\108\027\025\052\106\025\099\033\033\025\078\027\023\025\068\016\106\025\052\106\025\085\078\058\024\025\052\027\025\111\099\016\108\025\068\078\058\024\057\057\057"), 
								Media = zmediaicCHECK, 
								Buttons = {
									_o9p("\032\099\027\106\052\027\016\008\057\057\057")
								}
							}
						end
					end
				end
			}
		end
	end
end
function zitemGPS:On_Df0(target)
	zitemGPS:MoveTo(zitemGearPack)
	conUpdate()
end
function zitemGPS:On_uA1(target)
	zitemGPS:MoveTo(Player)
	conUpdate()
end
function zitemGPS:OnCheckBattery(target)
	_Urwigo.MessageBox{
		Text = (_o9p("\112\078\106\106\008\108\111\025\107\008\013\008\017\025\052\012\025\058\016\108\108\008\027\106\017\111\025\078\106\025")..PowerGPS).._o9p("\031"), 
		Media = zmediaicINFO, 
		Callback = function(action)
			if action ~= nil then
				if CheckGPS ~= true then
					if PowerGPS == 75 then
						SanityLevel = SanityLevel + 5
						CheckGPS = true
					elseif PowerGPS >= 50 then
						SanityLevel = SanityLevel + 1
						CheckGPS = true
					end
				end
				if PowerGPS <= 25 then
					SanityLevel = SanityLevel + -1
				elseif PowerGPS <= 10 then
					SanityLevel = SanityLevel + -5
				end
			end
		end
	}
end
function zitemGPS:OnTurnOff(target)
	if CheckGPS == true then
		_Urwigo.MessageBox{
			Text = _o9p("\015\099\099\023\025\052\023\008\078\057\057\057\025\058\099\027\012\008\108\013\008\025\068\099\030\008\108\057\057\057"), 
			Media = zmediaitGPS0
		}
	else
		_Urwigo.MessageBox{
			Text = _o9p("\015\099\099\023\025\052\023\008\078\057\057\057\025\058\099\027\012\008\108\013\008\025\068\099\030\008\108\057\057\057\025\102\112\076\018\073\015\078\052\027\025\127\025\036\078\027\052\106\111\109"), 
			Media = zmediaitGPS0, 
			Callback = function(action)
				if action ~= nil then
					SanityLevel = SanityLevel + 5
				end
			end
		}
	end
	CheckGPS = true
	zitemGPS.Opened = false
	zitemGPS.Commands.Makesureitsworking.Enabled = true
	zitemGPS.Commands.CheckBattery.Enabled = false
	zitemGPS.Commands.TurnOff.Enabled = false
	zitemGPS.Commands.CheckPosition.Enabled = false
	zitemGPS.Media = zmediaitGPS0
end
function zitemGPS:OnCheckPosition(target)
	local PLocLat = Player.ObjectLocation.latitude
	local PLocLon = Player.ObjectLocation.longitude
	local CLocLat = ConvertWP(PLocLat)
	local CLocLon = ConvertWP(PLocLon)
	local CAcc = Player.PositionAccuracy:GetValue(ft)
	local GPSCurrPos = "GPS INFORMATION:\060BR\062\010"
	GPSCurrPos = GPSCurrPos .. "================\060BR\062\010"
	GPSCurrPos = GPSCurrPos .. "LAT: ".. CLocLat .."\060BR\062\010"
	GPSCurrPos = GPSCurrPos .. "LON: ".. CLocLon .."\060BR\062\010"
	GPSCurrPos = GPSCurrPos .. "Accuracy: ".. CAcc .." feet\060BR\062\010"
	GPSCurrPos = GPSCurrPos .. "================\060BR\062\010"
	Wherigo.MessageBox{Text="".. GPSCurrPos .."",Media=zmediaicGPS}
end
function zitemGPS:On_GXDKm(target)
	IgnoreMe = false
	Wherigo.ShowScreen(Wherigo.INVENTORYSCREEN)
end
function zitemNotepad:OnScribbleanote(target)
	_Urwigo.RunDialogs(function()
		Wherigo.GetInput(zinputNotepadInput)
	end)
end
function zitemNotepad:OnReadthenotepad(target)
	_Urwigo.MessageBox{
		Text = (_o9p("\097\099\016\025\017\099\099\024\025\106\099\025\012\008\008\025\030\125\078\106\045\012\025\099\027\025\111\099\016\108\025\027\099\106\008\068\078\023\077\102\112\076\018\011")..NotePadEntry).._o9p("\011"), 
		Media = zmediaicNOTE
	}
end
function zitemNotepad:On_U7LY(target)
	zitemNotepad:MoveTo(zitemGearPack)
	conUpdate()
end
function zitemNotepad:On_KWA(target)
	zitemNotepad:MoveTo(Player)
	conUpdate()
end
function zitemNotepad:On_KFsD(target)
	IgnoreMe = false
	Wherigo.ShowScreen(Wherigo.INVENTORYSCREEN)
end
function zitemPawPrints:OnLeaveitbe(target)
	zitemPawPrints:MoveTo(nil)
	if StatPaw == true then
		_Urwigo.MessageBox{
			Text = _o9p("\097\099\016\025\023\008\058\052\023\008\025\106\125\078\106\025\045\058\016\108\052\099\016\012\052\106\111\025\024\052\017\017\008\023\025\106\125\008\025\058\078\106\045\057\057\057\025\089\013\008\108\025\125\008\078\108\025\045\012\078\106\052\012\033\078\058\106\052\099\027\025\085\108\099\016\040\125\106\025\052\106\025\085\078\058\024\045\021\025\015\016\008\012\012\025\111\099\016\025\030\099\027\045\106\025\024\027\099\030\025\052\027\025\106\125\052\012\025\058\078\012\008\057\057\057\025\078\012\025\106\125\008\025\068\108\052\027\106\012\025\033\078\023\008\025\085\008\033\099\108\008\025\111\099\016\108\025\008\111\008\012\057\057"), 
			Media = zmediaicTHUMBD
		}
	else
		_Urwigo.MessageBox{
			Text = _o9p("\097\099\016\025\023\008\058\052\023\008\025\106\125\078\106\025\045\058\016\108\052\099\016\012\052\106\111\025\024\052\017\017\008\023\025\106\125\008\025\058\078\106\045\057\057\057\025\096\008\108\125\078\068\012\025\106\125\078\106\025\030\078\012\025\078\025\040\099\099\023\025\058\078\017\017\025\099\027\025\111\099\016\108\025\068\078\108\106\057\057\057"), 
			Media = zmediaicTHUMBU
		}
	end
	IgnoreMe = false
end
function zitemPawPrints:OnCheckitout(target)
	if StatPaw == true then
		Wherigo.PlayAudio(zmediaSNDhowl)
		_Urwigo.MessageBox{
			Text = _o9p("\097\099\016\025\023\052\012\058\099\013\008\108\025\039\078\111\078\045\012\025\106\108\078\023\008\059\078\108\024\057\057\057\025\102\112\076\018\073\015\078\052\027\025\127\025\036\078\027\052\106\111\109"), 
			Media = zmediaitPAWPRINTS, 
			Buttons = {
				_o9p("\097\078\111\043")
			}, 
			Callback = function(action)
				if action ~= nil then
					zitemPawPrints:MoveTo(nil)
					SanityLevel = SanityLevel + 5
					_Urwigo.MessageBox{
						Text = _o9p("\097\099\016\025\106\016\108\027\025\111\099\016\108\025\078\106\106\008\027\106\052\099\027\025\078\030\078\111\025\033\099\108\025\078\025\059\099\059\008\027\106\025\078\027\023\025\030\125\008\027\025\111\099\016\025\017\099\099\024\025\085\078\058\024\046\025\111\099\016\025\033\052\027\023\025\111\099\016\025\017\099\012\106\025\012\052\040\125\106\025\099\033\025\106\125\008\025\068\078\030\025\068\108\052\027\106\012\025\078\027\023\025\058\078\027\045\106\025\033\052\027\023\025\106\125\008\059\025\078\040\078\052\027\057\057\057"), 
						Media = zmediaicFACESAD, 
						Buttons = {
							_o9p("\112\111\008\103\112\111\008\043")
						}
					}
				end
			end
		}
	else
		Wherigo.PlayAudio(zmediaSNDgrowl)
		_Urwigo.MessageBox{
			Text = _o9p("\097\099\016\025\023\052\012\058\099\013\008\108\025\076\078\013\008\027\099\016\012\025\039\099\017\013\008\012\025\040\027\078\030\052\027\040\025\078\030\078\111\025\078\106\025\106\125\008\025\108\008\059\078\052\027\012\025\099\033\025\078\025\017\078\108\040\008\025\078\027\052\059\078\017\043\025\102\112\076\018\073\107\099\012\008\025\049\101\025\036\078\027\052\106\111\109"), 
			Media = zmediacWOLVES, 
			Buttons = {
				_o9p("\105\125\025\027\099\043")
			}, 
			Callback = function(action)
				if action ~= nil then
					zitemPawPrints:MoveTo(nil)
					SanityLevel = SanityLevel - 10
					_Urwigo.MessageBox{
						Text = _o9p("\097\099\016\025\023\008\058\052\023\008\025\052\106\025\030\099\016\017\023\025\085\008\025\085\008\012\106\025\106\099\025\017\008\106\025\106\125\008\025\039\099\017\013\008\012\025\008\078\106\025\052\027\025\068\008\078\058\008\057\057\057"), 
						Media = zmediaicHIKE, 
						Buttons = {
							_o9p("\112\008\078\106\025\033\008\008\106\043")
						}
					}
				end
			end
		}
	end
end
function zitemStrangeStatue:On_tUEtG(target)
	zitemStrangeStatue:MoveTo(zitemGearPack)
	conUpdate()
end
function zitemStrangeStatue:On_vTwm(target)
	zitemStrangeStatue:MoveTo(Player)
end
function zitemStrangeStatue:On_LTI(target)
	Wherigo.PlayAudio(zmediaSNDghostly)
	_Urwigo.MessageBox{
		Text = _o9p("\097\099\016\025\008\055\078\059\052\027\008\025\106\125\008\025\012\106\108\078\027\040\008\025\012\106\078\106\016\008\025\078\027\023\025\023\052\012\058\099\013\008\108\025\052\106\025\052\012\025\012\099\059\008\025\040\108\099\106\008\012\069\016\008\025\008\033\033\052\040\111\025\099\033\025\012\099\059\008\025\106\030\052\012\106\008\023\025\058\108\008\078\106\016\108\008\025\059\078\023\008\025\099\033\025\078\025\085\017\078\058\024\025\106\108\078\027\012\017\016\058\008\027\106\025\059\078\106\008\108\052\078\017\025\111\099\016\045\013\008\025\027\008\013\008\108\025\012\008\008\027\025\085\008\033\099\108\008\057\025\039\125\099\025\030\099\016\017\023\025\125\078\013\008\025\059\078\023\008\025\106\125\052\012\025\106\125\052\027\040\025\078\027\023\025\030\125\111\021"), 
		Media = zmediaitSTATUE
	}
end
function zitemStrangeStatue:On_2IMjF(target)
	_Urwigo.MessageBox{
		Text = _o9p("\097\099\016\025\106\078\024\008\025\106\125\008\025\012\106\108\078\027\040\008\025\012\106\078\106\016\008\025\078\027\023\025\068\017\078\058\008\025\052\106\025\030\052\106\125\025\111\099\016\108\025\068\099\012\012\008\012\012\052\099\027\012\057\057\057"), 
		Media = zmediaicSTATUE, 
		Callback = function(action)
			if action ~= nil then
				zitemStrangeStatue:MoveTo(Player)
				zoneHeap.Commands._iZW.Enabled = false
				if Player:Contains(zitemGearPack) then
					zitemStrangeStatue.Commands._tUEtG.Enabled = true
				end
				zitemStrangeStatue.Commands._NxuBg.Enabled = false
				zitemStrangeStatue.Commands._2IMjF.Enabled = false
				Wherigo.ShowScreen(Wherigo.LOCATIONSCREEN)
			end
		end
	}
end
function zitemStrangeStatue:On_NxuBg(target)
	_Urwigo.MessageBox{
		Text = _o9p("\097\099\016\025\023\008\058\052\023\008\025\052\106\025\030\099\016\017\023\025\085\008\025\085\008\012\106\025\106\099\025\090\016\012\106\025\017\008\078\013\008\025\052\106\025\078\017\099\027\008\057\057\057"), 
		Media = zmediaicINFO
	}
end
function zitemStrangeStatue:On_cMyG(target)
	IgnoreMe = false
	Wherigo.ShowScreen(Wherigo.INVENTORYSCREEN)
end
function zitemMENU:OnGotoMENU(target)
	_Urwigo.RunDialogs(function()
		Wherigo.GetInput(zinputMenuList)
	end)
end
function zitemMENU:On_8aJ(target)
	IgnoreMe = false
	Wherigo.ShowScreen(Wherigo.INVENTORYSCREEN)
end
function zitemPP1:On_skeUc(target)
	Wherigo.ShowScreen(Wherigo.DETAILSCREEN, zitemPP2)
end
function zitemPP1:On_KzW(target)
	zitemPP1.Media = nil
	zitemPP1.Description = _o9p("\089\059\068\106\111\025\036\017\099\106")
	Photo1 = ""
end
function zitemPP1:On_2oPN(target)
	PicsWork(OFF)
	Wherigo.ShowScreen(Wherigo.DETAILSCREEN, zitemCell)
end
function zitemPP1:On_5j9(target)
	_Urwigo.RunDialogs(function()
		Wherigo.GetInput(zinputNotePP1)
	end)
end
function zitemPP2:On_Qxk4A(target)
	Wherigo.ShowScreen(Wherigo.DETAILSCREEN, zitemPP1)
end
function zitemPP2:On_sh9Qa(target)
	Wherigo.ShowScreen(Wherigo.DETAILSCREEN, zitemPP3)
end
function zitemPP2:On_S0_J(target)
	zitemPP2.Media = nil
	zitemPP2.Description = _o9p("\089\059\068\106\111\025\036\017\099\106")
	Photo2 = ""
end
function zitemPP2:On_IzD3(target)
	PicsWork(OFF)
	Wherigo.ShowScreen(Wherigo.DETAILSCREEN, zitemCell)
end
function zitemPP2:On_9Ib(target)
	_Urwigo.RunDialogs(function()
		Wherigo.GetInput(zinputNotePP2)
	end)
end
function zitemPP3:On_ry0(target)
	Wherigo.ShowScreen(Wherigo.DETAILSCREEN, zitemPP2)
end
function zitemPP3:On_N4_e(target)
	Wherigo.ShowScreen(Wherigo.DETAILSCREEN, zitemPP4)
end
function zitemPP3:On_AhrOW(target)
	zitemPP3.Media = nil
	zitemPP3.Description = _o9p("\089\059\068\106\111\025\036\017\099\106")
	Photo3 = ""
end
function zitemPP3:On_5MTVW(target)
	PicsWork(OFF)
	Wherigo.ShowScreen(Wherigo.DETAILSCREEN, zitemCell)
end
function zitemPP3:On_pQe(target)
	_Urwigo.RunDialogs(function()
		Wherigo.GetInput(zinputNotePP3)
	end)
end
function zitemPP4:On_wUFf(target)
	Wherigo.ShowScreen(Wherigo.DETAILSCREEN, zitemPP3)
end
function zitemPP4:On_zM3l(target)
	Wherigo.ShowScreen(Wherigo.DETAILSCREEN, zitemPP5)
end
function zitemPP4:On_5iLdh(target)
	zitemPP4.Media = nil
	zitemPP4.Description = _o9p("\089\059\068\106\111\025\036\017\099\106")
	Photo4 = ""
end
function zitemPP4:On_OfKB(target)
	PicsWork(OFF)
	Wherigo.ShowScreen(Wherigo.DETAILSCREEN, zitemCell)
end
function zitemPP4:On_5OT(target)
	_Urwigo.RunDialogs(function()
		Wherigo.GetInput(zinputNotePP4)
	end)
end
function zitemPP5:On_BpXpg(target)
	Wherigo.ShowScreen(Wherigo.DETAILSCREEN, zitemPP4)
end
function zitemPP5:On_T6T(target)
	zitemPP5.Media = nil
	zitemPP5.Description = _o9p("\089\059\068\106\111\025\036\017\099\106")
	Photo5 = ""
end
function zitemPP5:On_jE0(target)
	PicsWork(OFF)
	Wherigo.ShowScreen(Wherigo.DETAILSCREEN, zitemCell)
end
function zitemPP5:On_aGA(target)
	_Urwigo.RunDialogs(function()
		Wherigo.GetInput(zinputNotePP5)
	end)
end

-- Begin user functions --
originalFns = {
	Dialog = Wherigo.Dialog, 
	MessageBox = Wherigo.MessageBox, 
	GetInput = Wherigo.GetInput,
	PlayAudio = Wherigo.PlayAudio,
	ShowScreen = Wherigo.ShowScreen
}
dialogStrings = {}
require "table"

function rundialog()
	local ds = dialogStrings
	dialogStrings = {}
	local cb = {}
	cb = function(thing)
		if thing ~= nil then
			local item = table.remove(ds, 1)
			if item ~= nil then
				if item.Callback == nil then
					item.Callback = cb
				end
				originalFns.MessageBox(item)
			end
		end
	end
	cb(1)
end

function Wherigo.Dialog(tbl)
	IgnoreMe = true
	for kd, vd in ipairs(tbl) do
		table.insert(dialogStrings, vd)
	end
	if (((#dialogStrings) > 0) and (dialogStrings[#dialogStrings].Text == nil)) and (dialogStrings[#dialogStrings].Media == nil) then
		table.remove(dialogStrings)
		rundialog()
	end
end

function Wherigo.MessageBox(tbl)
	IgnoreMe = true
	table.insert(dialogStrings, tbl)
	rundialog()
end

function Wherigo.GetInput(input)
	IgnoreMe = true
	-- added alternate menu support
--	if SuppMenu == "ENABLED" then
--		if (#dialogStrings) == 0 then
--			originalFns.GetInput(input)
--		else
--			dialogStrings[#dialogStrings].Callback = function(thing)
--				originalFns.GetInput(input)
--			end
--			rundialog()
--		end
--	else
		-- if disabled, then check for existing item alternate, if not, continue
--		local AllInputs = cartridge:GetAllOfType('ZInput')
--		for kin, vin in pairs(AllInputs) do
--			if vin.Name == input.Name then
--				local AllItems = cartridge:GetAllOfType('ZItem')
--				for k, v in pairs(AllItems) do
--					if v.Name == vin.Name then
--						Wherigo.ShowScreen(Wherigo.DETAILSCREEN,v)
--					else
						if (#dialogStrings) == 0 then
							originalFns.GetInput(input)
						else
							dialogStrings[#dialogStrings].Callback = function(thing)
							originalFns.GetInput(input)
							end
							rundialog()
						end				
--					end
				--end
			-- end
--		end
	-- end
end

-- check audio support, replace accordingly
function Wherigo.PlayAudio(sndparam)
	IgnoreMe = true
	if SuppSound == "ENABLED" then
		-- WherPiGo doesnt support stopsound command, atm
		if SuppApple == "DISABLED" then
			Wherigo.Command("StopSound")
		end
		originalFns.PlayAudio(sndparam)
	end
end

-- check screen directing, replace accordinly
function Wherigo.ShowScreen(scr,scrdtl)
	if SuppScreen == "ENABLED" then
		-- DETAILSCREEN, preserve passed params
		if scr == 5 then
			IgnoreMe = true
			originalFns.ShowScreen(scr,scrdtl)
  		end
  		if scr == 4 then
   			originalFns.ShowScreen(scr)
  		end
  		if scr == 3 then
   			originalFns.ShowScreen(scr)
  		end
  		if scr == 2 then
  			IgnoreMe = false
   			originalFns.ShowScreen(Wherigo.ITEMSCREEN)
  		end 
  		if scr == 1 then
  			IgnoreMe = false
   			originalFns.ShowScreen(Wherigo.LOCATIONSCREEN)
  		end
  		if scr == 0 then
  			IgnoreMe = false
   			originalFns.ShowScreen(Wherigo.MAINSCREEN)
  		end
  	else
		IgnoreMe = false
		originalFns.ShowScreen(Wherigo.MAINSCREEN)
 	end
end

zochk = {}

function PicsWork(toggle)
	if toggle == "ON" then
		zitemPP1:MoveTo(Player)
		zitemPP2:MoveTo(Player)
		zitemPP3:MoveTo(Player)
		zitemPP4:MoveTo(Player)
		zitemPP5:MoveTo(Player)
	else
		zitemPP1:MoveTo(zitemCell)
		zitemPP2:MoveTo(zitemCell)
		zitemPP3:MoveTo(zitemCell)
		zitemPP4:MoveTo(zitemCell)
		zitemPP5:MoveTo(zitemCell)
	end
end

function ZoneCheck(czone)
	if zochk[czone] == true then
		return true
	else
		zochk[czone]=true
		Wherigo.ShowScreen(Wherigo.DETAILSCREEN,czone)
		return false
	end		
end

function HandCheck()
	if IgnoreMe == false then
		PicsWork(OFF)
		if #Player.Inventory > 4 then
			local emptyit = function(action)
				if action == "Button1" then
					Wherigo.ShowScreen(Wherigo.INVENTORYSCREEN)
				end
			end
			SanityLevel = SanityLevel - 1
			Wherigo.MessageBox{Text="You can only have 2 items in your hands at any given time, put the extra items into your Gear Pack! (Lose 1 Sanity)",Media=zmediaicSTOP,Buttons={},Callback=emptyit}		
		end
	else
		-- ninja deduction
		SanityLevel = SanityLevel - 1
	end
end

-- animation - SAW
function animatic(anidx)
	local startit = function(action)
		if action == "Button1" then
			Wherigo.ShowScreen(Wherigo.DETAILSCREEN,zoneTheDrive)
		end
	end
	local showgo = function(action)
		if action == "Button1" then
			zoneTheDrive.Active = true
			zoneTheDrive.Visible = true
			zitemMENU:MoveTo(Player)
			GameStart = true
			zinputMenuList.Choices[5] = "BACK TO MAIN"
			table.remove(zinputAdvOptList.Choices,6)
			Wherigo.MessageBox{Text="You are exhausted and can't wait to get home to finally get some rest...",Media=zmediazROAD,Buttons={"Keep driving home..."},Callback=startit}
		end
	end
	local cancel = function(action)
		if action == "Button1" then
			if SuppEmulator == "ENABLED" or SuppOpenWIG == "ENABLED"  or SuppAndroid == "ENABLED" then
			   AnimCount = 21
			else
			   AnimCount = 10
			end
			if SuppSound == "ENABLED" and SuppApple ~= "ENABLED" then
					Wherigo.Command("StopSound")
			end
			Wherigo.MessageBox{Text="        Let us begin then...",Media=zmediaINTRO22,Buttons={"Start"},Callback=showgo}
      		end
	end
	if AnimCount >= AnimStop then
		cancel("Button1")
	else
		Wherigo.MessageBox{Text = "",Media = animedia[anidx],Buttons = {"Skip Intro"},Callback=cancel}       
		ztimerANIM:Start()
	end
	return ""
end

-- modify zone dynamically, thanks to Ranger Fox
function CenterZoneOnPoint(zZone, point)
	local ZoneRadius = 50
	local dist = Wherigo.Distance(0, "ft")
	local newZp = Wherigo.TranslatePoint(point, dist, 0)
	dist = Wherigo.Distance(ZoneRadius, "ft")
	local pts = {
		Wherigo.TranslatePoint(newZp, dist, 45), 
		Wherigo.TranslatePoint(newZp, dist, 135), 
		Wherigo.TranslatePoint(newZp, dist, 225), 
		Wherigo.TranslatePoint(newZp, dist, 315)
	}
	zZone.Active = false
	zZone.OriginalPoint.latitude = newZp.latitude
	zZone.OriginalPoint.longitude = newZp.longitude
	zZone.Points = pts
end

-- playanywhere, thanks to Ranger Fox, cantuland and SAW (me)
function MakePA()
	-- set variables we are going to use
	local gpsdev = Env.DeviceID
    	local gpsacc = Player.PositionAccuracy:GetValue(ft)
	local AllZones = cartridge:GetAllOfType('Zone')
	local AllItems = cartridge:GetAllOfType('ZItem')
	local AllChars = cartridge:GetAllOfType('ZCharacter')
	local Indicator = "="
	nextcount = 0
	local paact = "INITIALIZING"
	
	-- debug vars, keeping because informative
	local zonest = "0/"..#AllZones..""
	local pointst = "0 moved"
	local itemst = "0/"..#AllItems..""
	local charst = "0/"..#AllChars..""
	local zonenum = 0
	local pointnum = 0
	local itemnum = 0
	local charnum = 0
	local zonename = "N/A"
	local itemname = "N/A"
	local charname = "N/A"
	
	-- generate counter for progress meter
	zonecount = #AllZones + #AllItems + #AllChars
	zonecount = 100 / zonecount
	stepcount = math.ceil(zonecount)

	-- cancel function
	local cancel = function(action)
		if action == "Button1" then
			Wherigo.MessageBox{Text = "Unfortunately, the only way to cancel the changes made is to finish running the process and then Please run PLAYANYWHERE again after COMPLETED to reset everything.",}
			return
		end
	end

	-- progress function, inspired by cantuland
	local progressm = function(statusm)
		nextcount = nextcount + stepcount
		Indicator = [[.]] .. Indicator .. [[]]
Wherigo.MessageBox{Text = [[
PlayAnywhere ]] .. paact .. [[ Progress
(this may take a few minutes...)
========================
STATUS: ]] .. statusm .. [[...
-----------------------------------------
Zone (]] .. zonest .. [[) : ]] .. zonename .. [[
Points (]] .. pointst .. [[)
Item (]] .. itemst .. [[) : ]] .. itemname .. [[
Char (]] .. charst .. [[) : ]] .. charname .. [[
-----------------------------------------
]] .. Indicator .. [[>]] .. nextcount .. [[%]], Buttons = {"Cancel"}, Callback = cancel}
	end
	
	-- start it up
	progressm("Initializing")

	-- Reference starting point for my cartridge
	startLat = 35.0328565943156
	startLon = -79.0352923922009
	startloc = ZonePoint(startLat, startLon, 0)	

	-- check what to do with PlayAnywhere, enable or disable it
	if SuppPA == "ENABLED" then
		-- if enable, change start point to player loc
		cartridge.StartingLocation = Player.ObjectLocation
		ReferencePoint = startloc
		paact = "ACTIVATE"
		currpos = Player.ObjectLocation
	else
		-- if disable, change start point to saved start loc
		cartridge.StartingLocation = startloc
		ReferencePoint = Player.ObjectLocation
		paact = "DEACTIVATE"
		currpos = startloc
	end

	-- gps accuracy check
--	if not Wherigo.NoCaseEquals(gpsdev,"DeskTop") then
--		if gpsacc < 3 or gpsacc > 150 then
--			Wherigo.MessageBox{Text="GPS SIGNAL FAILURE. PLAYANYWHERE ABORTED.",}
--		        return 
--        	end
--	end

	-- begin zone parsing
	for _,zone in ipairs(AllZones) do
	 	if zone ~= nil then
			-- save original zone states
			local ActiveOrNot = zone.Active
			zone.Active = false

			-- reposition zones, originalpoint then zone points
			zop = zone.OriginalPoint
		
			local zdist, zbear = Wherigo.VectorToPoint(ReferencePoint, zop)
			local newZPoint = Wherigo.TranslatePoint(currpos, zdist, zbear)
			zop.latitude = newZPoint.latitude
			zop.longitude = newZPoint.longitude

			-- track zone point moving
			pointnum = pointnum + 1
			pointst = "" .. pointnum .. " moved"
			
			for _, p in ipairs(zone.Points) do
				local d, b = Wherigo.VectorToPoint(ReferencePoint, p)
				local newPoint = Wherigo.TranslatePoint(currpos, d, b)
				p.latitude = newPoint.latitude
				p.longitude = newPoint.longitude

				pointnum = pointnum + 1
				pointst = "" .. pointnum .. " moved"
			end

			-- tracks zone moving, can be slow if you have alot of zones
			zonenum = zonenum + 1
			zonest = "" .. zonenum .. "/" .. #AllZones .. ""
			zonename = zone.Name
			progressm("Moving Zones")

			-- restore original zone states
			zone.Active = true
			zone.Active = false
			zone.Active = ActiveOrNot
		end
	end
	zonest = "DONE"	
	pointst = "DONE"	
	zonename = "DONE"

	-- reposition items
	for _,v in ipairs(AllItems) do
		local i = v.ObjectLocation
		if Wherigo.ZonePoint:made(i) then
			local d, b = Wherigo.VectorToPoint(ReferencePoint, i)	
			local newPoint = Wherigo.TranslatePoint(currpos, d, b)	
			i.latitude = newPoint.latitude
			i.longitude = newPoint.longitude
		end
		
		-- track item moves
		itemnum = itemnum + 1
		itemst = "" .. itemnum .. "/" .. #AllItems .. ""
		itemname = v.Name
		progressm("Moving Items")
	end
	itemst = "DONE"
	itemname = "DONE"

	-- reposition characters
	for _,v in ipairs(AllChars) do
		local c = v.ObjectLocation
		if Wherigo.ZonePoint:made(c) then
			local d, b = Wherigo.VectorToPoint(ReferencePoint, c)
			local newPoint = Wherigo.TranslatePoint(currpos, d, b)
			c.latitude = newPoint.latitude
			c.longitude = newPoint.longitude
		end
		-- track character moves
		charnum = charnum + 1
		charest = "" .. charnum .. "/" .. #AllChars .. ""
		charname = v.Name
		progressm("Moving Characters")
	end
	charst = "DONE"
	charname = "DONE"

	-- thats all folks
	progressm("COMPLETE")
	return ""
end

-- lat/lon formatter
function ConvertWP(WPLatLon)
	degpat = "(%d+%.?%d*)"
	minpat = "(%d+)%s+(%d+%.?%d*)"
	secpat = "(%d+)%s+(%d+)%s+(%d+%.?%d*)"
	deg, min, sec = string.match(WPLatLon, secpat)
	if not deg then
		deg, min = string.match(WPLatLon, minpat)
		if deg then
			min, sec = math.modf(min)
			sec = sec * 60
		else
			deg = string.match(WPLatLon, degpat)
			if deg then
				deg, min = math.modf(deg)
				min, sec = math.modf(min * 60)
				sec = sec * 60
			else
				print "format not recognized"
			end
		end
	end
	CLatLon = string.format("%3.0f %2.0f %5.2f", deg, min, sec)
	return (""..CLatLon)..""
end

-- status info updater w/countdown timer - SAW
function UpdateStats()
	ztask1SANITY.Description = "".. SanityLevel ..""
	DTimeS = ztimerDOOM.Remaining
	DTimeF = DTimeS
	if DTimeS == 0 then
		DTimeF = "TIMES UP"
	else
		DTimeH = math.floor(DTimeS / 3600)
		DTimeS = DTimeS - (DTimeH * 3600)
		DTimeM = math.floor(DTimeS / 60)
		DTimeS = DTimeS - (DTimeM * 60)
		DTimeF = (((((""..DTimeH).."h ")..DTimeM).."m ")..DTimeS).."s"
	end
	PLocLat = Player.ObjectLocation.latitude
	PLocLon = Player.ObjectLocation.longitude
	CLocLat = ConvertWP(PLocLat)
	CLocLon = ConvertWP(PLocLon)
	ztask2TIMER.Description = (""..DTimeF)..""
	ztask4LATITUDE.Description = (""..CLocLat)..""
	ztask5LONGITUDE.Description = (""..CLocLon)..""
	if StatBar == "ENABLED" then
		Wherigo.ShowStatusText(((("SANITY: "..SanityLevel).." | TIME: ")..DTimeF).."")
	end
	return ""
end

function PicZone()
	PLocLat = Player.ObjectLocation.latitude
	PLocLon = Player.ObjectLocation.longitude
	CLocLat = ConvertWP(PLocLat)
	CLocLon = ConvertWP(PLocLon)
	CurrTD = os.date("%c")
	
	if zitemPP1.Media == false then
		for k,v in pairs(Player.InsideOfZones) do
			if v ~= nil then
				zitemPP1.Media = v.Media
				zitemPP1.Description = "LOC:".. v.Name .."\060BR\062\010"
				zitemPP1.Description = zitemPP1.Description .. "STAMP: ".. CurrTD .. "\060BR\062\010"
				zitemPP1.Description = zitemPP1.Description .. "COORD: ".. CLocLat .." ".. CLocLon  .."\060BR\062\010"
			end
		end
	elseif zitemPP2.Media == false then
		for k,v in pairs(Player.InsideOfZones) do
			if v ~= nil then
				zitemPP2.Media = v.Media
				zitemPP2.Description = "LOC:".. v.Name .."\060BR\062\010"
				zitemPP2.Description = zitemPP2.Description .. "STAMP: ".. CurrTD .. "\060BR\062\010"
				zitemPP2.Description = zitemPP2.Description .. "COORD: ".. CLocLat .." ".. CLocLon  .."\060BR\062\010"
			end
		end
	elseif zitemPP3.Media == false then
		for k,v in pairs(Player.InsideOfZones) do
			if v ~= nil then
				zitemPP3.Media = v.Media
				zitemPP3.Description = "LOC:".. v.Name .."\060BR\062\010"
				zitemPP3.Description = zitemPP3.Description .. "STAMP: ".. CurrTD .. "\060BR\062\010"
				zitemPP3.Description = zitemPP3.Description .. "COORD: ".. CLocLat .." ".. CLocLon  .."\060BR\062\010"
			end
		end
	elseif zitemPP4.Media == false then
		for k,v in pairs(Player.InsideOfZones) do
			if v ~= nil then
				zitemPP4.Media = v.Media
				zitemPP4.Description = "LOC:".. v.Name .."\060BR\062\010"
				zitemPP4.Description = zitemPP4.Description .. "STAMP: ".. CurrTD .. "\060BR\062\010"
				zitemPP4.Description = zitemPP4.Description .. "COORD: ".. CLocLat .." ".. CLocLon  .."\060BR\062\010"
			end
		end
	elseif zitemPP5.Media == false then
		for k,v in pairs(Player.InsideOfZones) do
			if v ~= nil then
				zitemPP5.Media = v.Media
				zitemPP5.Description = "LOC:".. v.Name .."\060BR\062\010"
				zitemPP5.Description = zitemPP5.Description .. "STAMP: ".. CurrTD .. "\060BR\062\010"
				zitemPP5.Description = zitemPP5.Description .. "COORD: ".. CLocLat .." ".. CLocLon  .."\060BR\062\010"
			end
		end
	else
		Wherigo.MessageBox{Text="All available picture slots are taken. You will need to delete a picture to make more room to take another picture."}
	end
end

-- player hardware detection and autoset optimal settings - SAW
function autosetdev()
	DevID = Env.Platform
	SuppPA = "DISABLED"
	if Wherigo.NoCaseEquals(Env.Platform, "Win32") then
		DevID = "Emulator"
		SuppApple = "DISABLED"
		SuppAndroid = "DISABLED"
		SuppOpenWIG = "DISABLED"
		SuppPPC = "DISABLED"
		SuppGarmin = "DISABLED"
		SuppEmulator = "ENABLED"
		SuppMenu = "ENABLED"
		SuppSound = "ENABLED"
		SuppScreen = "ENABLED"
		StatBar = "ENABLED"
		DetNote = "NOTE: Zoom in to 50m, turn on Satellite view and drop the player along route rather than use 'Go Here' for the best experience."
		SuppStatTime = 1
		AnimCount = 0
		AnimStop = 22
		ztimerANIM.Duration = 1
		ztimerlilDOOM.Duration = SuppStatTime
	elseif Wherigo.NoCaseEquals(Env.Platform, "Vendor 1 ARM9") then
		DevID = "Garmin"
		SuppApple = "DISABLED"
		SuppAndroid = "DISABLED"
		SuppOpenWIG = "DISABLED"
		SuppPPC = "DISABLED"
		SuppGarmin = "ENABLED"
		SuppEmulator = "DISABLED"
		SuppMenu = "ENABLED"
		SuppSound = "ENABLED"
		SuppScreen = "DISABLED"
		StatBar = "DISABLED"
		DetNote = "NOTE: If you experience any problems, experiment with turning off various options."
		SuppStatTime = 10
	       ztimerANIM.Duration = 2
		AnimCount = 21
		AnimStop = 22
		ztimerlilDOOM.Duration = SuppStatTime
	elseif Wherigo.NoCaseEquals(Env.Platform, "PocketPC 2003") then
		DevID = "PocketPC"
		SuppApple = "DISABLED"
		SuppAndroid = "DISABLED"
		SuppOpenWIG = "DISABLED"
		SuppPPC = "ENABLED"
		SuppGarmin = "DISABLED"
		SuppEmulator = "DISABLED"
		SuppMenu = "ENABLED"
		SuppSound = "ENABLED"
		SuppScreen = "ENABLED"
		StatBar = "ENABLED"
		DetNote = "NOTE: If you experience any problems, experiment with turning off various options."
		SuppStatTime = 10
	       ztimerANIM.Duration = 2
	       AnimCount = 0
	       AnimStop = 22
		ztimerlilDOOM.Duration = SuppStatTime
	elseif Wherigo.NoCaseEquals(Env.Platform, "MIDP-2.0/CLDC-1.1") then
		DevID = "OpenWIG"
		SuppApple = "DISABLED"
		SuppPPC = "DISABLED"
		SuppGarmin = "DISABLED"
		SuppEmulator = "DISABLED"
		SuppMenu = "ENABLED"
		SuppSound = "ENABLED"
		SuppScreen = "ENABLED"
		StatBar = "ENABLED"
		DetNote = "NOTE: If you experience any problems, experiment with turning off various options."
		if Env.DeviceID ~= nil then
			DevID = "J2ME/OpenWIG"
			SuppOpenWIG = "ENABLED"
			SuppAndroid = "DISABLED"
			SuppStatTime = 20
			ztimerANIM.Duration = 1
			AnimCount = 0
			AnimStop = 22
		else
			DevID = "Android/WhereYouGo"
			SuppAndroid = "ENABLED"
			SuppOpenWIG = "DISABLED"
			SuppStatTime = 1
			ztimerANIM.Duration = 1
			AnimCount = 0
			AnimStop = 22
		end
		ztimerlilDOOM.Duration = SuppStatTime
	elseif Wherigo.NoCaseEquals(Env.Platform, "Crapple") then
		DevID = "Apple Device"
		SuppApple = "ENABLED"
		SuppAndroid = "DISABLED"
		SuppOpenWIG = "DISABLED"
		SuppPPC = "DISABLED"
		SuppGarmin = "DISABLED"
		SuppEmulator = "DISABLED"
		SuppMenu = "DISABLED"
		SuppSound = "ENABLED"
		SuppScreen = "ENABLED"
		StatBar = "DISABLED"
		DetNote = "NOTE: If you experience any problems, experiment with turning off various options."
		SuppStatTime = 10
	       ztimerANIM.Duration = 2
	       AnimCount = 21
	       AnimStop = 22
		ztimerlilDOOM.Duration = SuppStatTime
	else 
		DevID = "ERROR"
		SuppApple = "DISABLED"
		SuppAndroid = "DISABLED"
		SuppOpenWIG = "DISABLED"
		SuppPPC = "DISABLED"
		SuppGarmin = "DISABLED"
		SuppEmulator = "DISABLED"
		SuppMenu = "ENABLED"
		SuppSound = "DISABLED"
		SuppScreen = "DISABLED"
		StatBar = "DISABLED"
		DetNote = "NOTE: If you experience any problems, experiment with turning off various options."
		SuppStatTime = 10
		ztimerAnim.Duration = 1
		AnimCount = 21
		AnimStop = 22
		ztimerlilDOOM.Duration = SuppStatTime
	end
	return DevID
end

-- simple makeshift container - SAW
-- had issues with builtin container and forum container code
-- updates description with contents
function conUpdate()
	local varInventory = zitemGearPack.Inventory
	local conDesc = "Your Gear goes in here!\060BR\062\010"
	conDesc = conDesc .. "There are "..#varInventory.." item(s) in the Gear Pack.\060BR\062\010\060BR\062\010"
	conDesc = conDesc .. "Contents of Gear Pack:\060BR\062\010"
       for k,v in pairs(varInventory) do 
       		conDesc = conDesc .. "- "..v.Name.." \060BR\062\010" 
       	end
       zitemGearPack.Description = conDesc
end

-- empty out contents of Gear Pack into Player Inventory
function conEmpty()
	while #zitemGearPack.Inventory > 0 do
		for k,v in pairs(zitemGearPack.Inventory) do 
			v:MoveTo(Player)			
		end
	end
	-- this makes sure the menu and gearpack are at top of inventory list
	zitemMENU:MoveTo(nil)
	zitemGearPack:MoveTo(nil)
	zitemMENU:MoveTo(Player)
	zitemGearPack:MoveTo(Player)
	conUpdate()
end

-- create input handling for list
function conUpdateList(CUL)
	if CUL == "---EXIT---" then Wherigo.ShowScreen(Wherigo.DETAILSCREEN,zitemGearPack)
	-- not working for some reason - SAW
--	else
--		for k,v in pairs(zitemGearPack.Inventory) do
--			if v.Name == CUL then
--				Wherigo.ShowScreen(Wherigo.DETAILSCREEN,v)
--			end				
--		end
	-- do it the manual way then, awww
	elseif CUL == "Cell" then Wherigo.ShowScreen(Wherigo.DETAILSCREEN,zitemCell)
	elseif CUL == "Drums" then Wherigo.ShowScreen(Wherigo.DETAILSCREEN,zitemDrums)
	elseif CUL == "Flashlight" then Wherigo.ShowScreen(Wherigo.DETAILSCREEN,zitemFlashlight)
	elseif CUL == "GPS" then Wherigo.ShowScreen(Wherigo.DETAILSCREEN,zitemGPS)
	elseif CUL == "Notepad" then Wherigo.ShowScreen(Wherigo.DETAILSCREEN,zitemNotepad)
	elseif CUL == "Strange Statue" then Wherigo.ShowScreen(Wherigo.DETAILSCREEN,zitemStrangeStatue)
	else
	end
end

-- open and list contents as input list
function conOpen()
	-- flush current list, refreshes list if anything has been added
	zinputGearPackList.Choices = nil
	-- replenish current list
	zinputGearPackList.Choices = {}
	for k,v in pairs(zitemGearPack.Inventory) do
		zinputGearPackList.Choices[k] = ""..v.Name..""
	end
	-- tacks on exit option at end of list
	local gptally = #zinputGearPackList.Choices + 1
	zinputGearPackList.Choices[gptally] = "---EXIT---"
	Wherigo.GetInput(zinputGearPackList)
end

-- close up the Gear Pack, return to screen
function conClose()
	Wherigo.ShowScreen(Wherigo.INVENTORYSCREEN)
end

-- too many nested statements crashing builders, redone in this func - SAW
function SafeParkingWorkAround()
	local DFL5 = function(action)
		if (action == "Button2") then
			Wherigo.ShowScreen(Wherigo.LOCATIONSCREEN)
		else
			Wherigo.ShowScreen(Wherigo.DETAILSCREEN,zitemYourBrokenCar)
		end
	end

	local DFL4A = function(action)
		if (action == "Button1") then
			zitemCell:MoveTo(zitemGearPack)
			zitemFlashlight:MoveTo(zitemGearPack)
			zitemGPS:MoveTo(zitemGearPack)
			zitemNotepad:MoveTo(zitemGearPack)
			zitemGearPack:MoveTo(Player)
			conUpdate()
                      SanityLevel = SanityLevel + 10
			Wherigo.MessageBox{Text="You shut the car door and realize that you left your keys in the car just as the doors automatically lock. Good thing you grabbed your gear! (Gain 10 Sanity)",Media=zmediaicTHUMBU,Buttons={"Check engine?","Look around?",},Callback=DFL5}
		end
	end

	local DFL4B = function(action)
		if (action == "Button1") then
			SanityLevel = SanityLevel - 10
			Wherigo.MessageBox{Text="You shut the car door and realize that you left your keys, along with all your gear, in the car just as the doors automatically lock. (Lose 10 Sanity)",Media=zmediaicTHUMBD,Buttons={"Check engine?","Look around?",},Callback=DFL5}
		end
	end
	
	local DFL4 = function(action)
		dejavu = true
		if (action == "Button1") then
			Wherigo.MessageBox{Text="You step out of the car and glance around. The area looks pretty deserted.",Media=zmediazLAKE,Buttons={},Callback=DFL4A}
		else
			Wherigo.MessageBox{Text="You step out of the car and glance around. The area looks pretty deserted.",Media=zmediazLAKE,Buttons={},Callback=DFL4B}
		end
	end

	local DFL3 = function(action)
 		if (action == "Button1") then
			Wherigo.MessageBox{Text="You pull the latch to open the engine hood. Before you exit your car, you happen to notice your gear pack.",Media=zmediaicCAR,Buttons={"Grab your gear","Leave it in the car",},Callback=DFL4}
		end
	end

	local BrokenDown2 = function(DFLevel, DFType)
		if DFType == 3 then
			Wherigo.PlayAudio(zmediaSNDengine)
		else
			Wherigo.PlayAudio(zmediaSNDnoservice)
		end
		if  DFLevel == 2 and DFType == 3 then
			Wherigo.MessageBox{Text="Hmm... that didn't sound too good...",Media=zmediaicCAR,Buttons={"Check engine!",},Callback=DFL3}
		else
			Wherigo.MessageBox{Text="You pull out your cell phone to find there's no service in the area...",Media=zmediaicCELL,Buttons={"Check engine!",},Callback=DFL3}
		end
	end

	local DFL22 = function(action)
		if (action == "Button1") then	
			BrokenDown2(2,3)
		else
			DFL3("Button1")
		end
	end

	local DFL21 = function(action)
		if (action == "Button1") then
			BrokenDown2(2,2)
		else
			DFL3("Button1")
		end
	end

	local BrokenDown = function(DFLevel, DFType)
		if DFType == 3 then
			Wherigo.PlayAudio(zmediaSNDengine)
		else
			Wherigo.PlayAudio(zmediaSNDnoservice)
		end	
		if DFLevel == 1 and DFType == 3 then
			Wherigo.MessageBox{Text="Hmm... that didn't sound too good...",Media=zmediaicCAR,Buttons={"Call AAA now?","Check engine?",},Callback=DFL21}
		else
			Wherigo.MessageBox{Text="You pull out your cell phone to find there's no service in the area...",Media=zmediaicCELL,Buttons={"Crank car again?","Check engine?",},Callback=DFL22}
		end
	end

	local DFL1 = function(action)
		if (action == "Button1") then
			BrokenDown(1,3)		
		else	
			BrokenDown(1,4)
		end
	end

	local DerFrootLoops = function(action)
		if (action == "Button1") then	
			local zp = CenterZoneOnPoint(zoneParkingSpot, Player.ObjectLocation)
			zitemYourBrokenCar:MoveTo(zoneParkingSpot)
			PLocLat = Player.ObjectLocation.latitude
			PLocLon = Player.ObjectLocation.longitude
			CLocLat = ConvertWP(PLocLat)
			CLocLon = ConvertWP(PLocLon)
			zoneParkingSpot.Description = zoneParkingSpot.Description .. "\060BR\062\010 COORD: ".. CLocLat .." ".. CLocLon  .."\060BR\062\010"
			zoneParkingSpot.Active = true
			zoneParkingSpot.Visible = true
			zoneBoatRamp.Active = true
			zoneBoatRamp.Visible = true
			zoneTrailhead.Active = true
			zoneTrailhead.Visible = true
			zoneFishingPier.Active = true
			zoneFishingPier.Visible = true
			Wherigo.MessageBox{Text="Now that you've parked the car. What do you want to try?",Media=zmediaicCAR,Buttons={"Crank car again?","Call AAA?",},Callback=DFL1}
		end
	end	

	zoneSafeParking.Visible = false
	zoneSafeParking.Active = false
      	Wherigo.PlayAudio(zmediaSNDtireroll) 
	Wherigo.MessageBox{Text="This seems like a good place to stop and find out what happened to your car.",Media=zmediazLAKE,Buttons={"Click once you are parked",},Callback=DerFrootLoops}       		
end

-- too many issues with ZLL, lets do this the hard way
function zg1() -- trailhead
zoneSidePath1.Visible = false
zoneSidePath1.Active = false
zoneStream1.Visible = false
zoneStream1.Active = false
zoneRuins1.Visible = false
zoneRuins1.Active = false
zoneBoatRamp.Active = true
zoneBoatRamp.Visible = true
zoneFishingPier.Active = true
zoneFishingPier.Visible = true
-- mid
zoneBranch1.Active = true
zoneBranch1.Visible = true
end

function zg2() -- branch1
zoneBoatRamp.Visible = false
zoneBoatRamp.Active = false
zoneFishingPier.Visible = false
zoneFishingPier.Active = false
zoneRuins2.Visible = false
zoneRuins2.Active = false
zoneTrailhead.Active = true
zoneTrailhead.Visible = true
zoneSidePath1.Active = true
zoneSidePath1.Visible = true
-- mid
zoneStream1.Active = true
zoneStream1.Visible = true
zoneRuins1.Active = true
zoneRuins1.Visible = true
end

function zg3() -- ruins1, stream1
zoneTrailhead.Visible = false
zoneTrailhead.Active = false
zoneSidePath1.Visible = false
zoneSidePath1.Active = false
zoneRuins3.Visible = false
zoneRuins3.Active = false
zoneBranch1.Active = true
zoneBranch1.Visible = true
-- mid
zoneRuins2.Active = true
zoneRuins2.Visible = true
end

function zg4() -- ruins2
zoneBranch1.Visible = false
zoneBranch1.Active = false
zoneShore1.Visible = false
zoneShore1.Active = false
zoneRuins3.Active = true
zoneRuins3.Visible = true
-- mid
zoneRuins1.Active = true
zoneRuins1.Visible = true
zoneStream1.Active = true
zoneStream1.Visible = true
end

function zg5() -- ruins3
zoneRuins1.Visible = false
zoneRuins1.Active = false
zoneStream1.Visible = false
zoneStream1.Active = false
zoneRuins4.Visible = false
zoneRuins4.Active = false
zoneShore1.Active = true
zoneShore1.Visible = true
-- mid
zoneRuins2.Active = true
zoneRuins2.Visible = true
end

function zg6() -- shore1
zoneRuins2.Visible = false
zoneRuins2.Active = false
zoneRuins5.Visible = false
zoneRuins5.Active = false
zoneRuins4.Active = true
zoneRuins4.Visible = true
-- mid
zoneRuins3.Active = true
zoneRuins3.Visible = true
end

function zg7() -- ruins4
zoneRuins3.Visible = false
zoneRuins3.Active = false
zoneStream2.Visible = false
zoneStream2.Active = false
zoneRuins6.Visible = false
zoneRuins6.Active = false
zoneRuins5.Active = true
zoneRuins5.Visible = true
-- mid
zoneShore1.Active = true
zoneShore1.Visible = true
end

function zg8() -- ruins5
zoneRuins7.Visible = false
zoneRuins7.Active = false
zoneShore1.Visible = false
zoneShore1.Active = false
zoneStream2.Active = true
zoneStream2.Visible = true
zoneRuins6.Active = true
zoneRuins6.Visible = true
-- mid
zoneRuins4.Active = true
zoneRuins4.Visible = true
end

function zg9() -- ruins6,stream2
zoneRuins4.Visible = false
zoneRuins4.Active = false
zoneRuins8.Visible = false
zoneRuins8.Active = false
zoneRuins7.Active = true
zoneRuins7.Visible = true
-- mid
zoneRuins5.Active = true
zoneRuins5.Visible = true
end

function zg10() -- ruins7
zoneRuins5.Visible = false
zoneRuins5.Active = false
zoneMBS1.Visible = false
zoneMBS1.Active = false
zoneRuins8.Active = true
zoneRuins8.Visible = true
-- mid
zoneRuins6.Active = true
zoneRuins6.Visible = true
zoneStream2.Active = true
zoneStream2.Visible = true
end

function zg11() -- ruins8
zoneStream2.Visible = false
zoneStream2.Active = false
zoneRuins6.Visible = false	 
zoneRuins6.Active = false
zoneShore2.Visible = false
zoneShore2.Active = false
zoneRuins9.Visible = false
zoneRuins9.Active = false
zoneMBS1.Active = true
zoneMBS1.Visible = true
-- mid
zoneRuins7.Active = true
zoneRuins7.Visible = true
end

function zg12() -- mbs1
zoneRuins7.Visible = false
zoneRuins7.Active = false
zoneRuins10.Visible = false
zoneRuins10.Active = false
zoneShore2.Active = true
zoneShore2.Visible = true
zoneRuins9.Active = true
zoneRuins9.Visible = true
-- mid
zoneRuins8.Active = true
zoneRuins8.Visible = true
end

function zg13() -- ruins9,shore2
zoneRuins8.Visible = false
zoneRuins8.Active = false
zoneRuins11.Visible = false
zoneRuins11.Active = false
zoneRuins10.Active = true
zoneRuins10.Visible = true
-- mid
zoneMBS1.Active = true
zoneMBS1.Visible = true
end

function zg14() -- ruins10
zoneMBS1.Visible = false
zoneMBS1.Active = false
zoneHut.Visible = false
zoneHut.Active = false
zoneHutSide.Visible = false
zoneHutSide.Active = false
zoneHeap.Visible = false
zoneHeap.Active = false
zoneRuins11.Active = true
zoneRuins11.Visible = true
-- mid
zoneShore2.Active = true
zoneShore2.Visible = true
zoneRuins9.Active = true
zoneRuins9.Visible = true
end

function zg15() -- ruins11
zoneRuins9.Visible = false
zoneRuins9.Active = false
zoneBranch2.Visible = false
zoneBranch2.Active = false
zoneStream3.Visible = false
zoneStream3.Active = false
zoneRuins12.Visible = false
zoneRuins12.Active = false
zoneHutSide.Active = true
zoneHutSide.Visible = true
-- mid
zoneRuins10.Active = true
zoneRuins10.Visible = true
zoneShore2.Active = true
zoneShore2.Visible = true
end

function zg16() -- hutside,hut,heap
zoneRuins10.Visible = false
zoneRuins10.Active = false
zoneShore2.Visible = false
zoneShore2.Active = false
zoneBranch3.Visible = false
zoneBranch3.Active = false
zoneSidePath2.Visible = false
zoneSidePath2.Active = false
zoneRuins12.Active = true
zoneRuins12.Visible = true
zoneStream3.Active = true
zoneStream3.Visible = true
zoneBranch2.Active = true
zoneBranch2.Visible = true
-- mid
zoneHut.Active = true
zoneHut.Visible = true
zoneHeap.Active = true
zoneHeap.Visible = true
zoneRuins11.Active = true
zoneRuins11.Visible = true
end

function zg17() -- ruins12,stream3,branch2
zoneRuins11.Visible = false
zoneRuins11.Active = false
zoneMBS2.Visible = false
zoneMBS2.Active = false
zonePathOnwards.Visible = false
zonePathOnwards.Active = false
zoneSidePath3.Visible = false
zoneSidePath3.Active = false
zoneBranch4.Visible = false
zoneBranch4.Active = false
zoneBranch3.Active = true
zoneBranch3.Visible = true
zoneSidePath2.Active = true
zoneSidePath2.Visible = true
-- mid
zoneHutSide.Active = true
zoneHutSide.Visible = true
end

function zg18() -- branch3
zoneSidePath2.Visible = false
zoneSidePath2.Active = false
zoneHut.Visible = false
zoneHut.Active = false
zoneHutSide.Visible = false
zoneHutSide.Active = false
zoneHeap.Visible = false
zoneHeap.Active = false
zoneEdge.Visible = false
zoneEdge.Active = false
zoneMBS2.Active = true
zoneMBS2.Visible = true
zonePathOnwards.Active = true
zonePathOnwards.Visible = true
zoneBranch4.Active = true
zoneBranch4.Visible = true
zoneSidePath3.Active = true
zoneSidePath3.Visible = true
-- mid
zoneRuins12.Active = true
zoneRuins12.Visible = true
zoneBranch2.Active = true
zoneBranch2.Visible = true
zoneStream3.Active = true
zoneStream3.Visible = true
end

function zg19() -- mbs2
zoneRuins12.Visible = false
zoneRuins12.Active = false
zoneBranch2.Visible = false
zoneBranch2.Active = false
zoneStream3.Visible = false
zoneStream3.Active = false
zoneEdge.Visible = false
zoneEdge.Active = false
zoneBranch3.Active = true
zoneBranch3.Visible = true
zonePathOnwards.Active = true
zonePathOnwards.Visible = true
--
zoneBranch4.Active = true
zoneBranch4.Visible = true
end

function zg20() -- branch4
zoneRuins12.Visible = false
zoneRuins12.Active = false
zoneStream3.Visible = false
zoneStream3.Active = false
zoneBranch2.Visible = false
zoneBranch2.Active = false
zoneCeremony.Visible = false
zoneCeremony.Active = false
zoneMetalPillar.Visible = false
zoneMetalPillar.Active = false
zoneWoodPillar.Visible = false
zoneWoodPillar.Active = false
zoneEdge.Active = true
zoneEdge.Visible = true
zoneMBS2.Active = true
zoneMBS2.Visible = true
zonePathOnwards.Active = true
zonePathOnwards.Visible = true
zoneSidePath3.Active = true
zoneSidePath3.Visible = true
zoneBranch3.Active = true
zoneBranch3.Visible = true
end

function zg21() -- edge
zonePathOnwards.Visible = false
zonePathOnwards.Active = false
zoneSidePath3.Visible = false
zoneSidePath3.Active = false
zoneBranch3.Visible = false
zoneBranch3.Active = false
zoneRuins12.Visible = false
zoneRuins12.Active = false
zoneStream3.Visible = false
zoneStream3.Active = false
zoneBranch2.Visible = false
zoneBranch2.Active = false
zoneMetalPillar.Active = true
zoneMetalPillar.Visible = true
zoneWoodPillar.Active = true
zoneWoodPillar.Visible = true
--zoneCeremony.Active = true
--zoneCeremony.Visible = true
-- mid 
zoneBranch4.Active = true
zoneBranch4.Visible = true
zoneMBS2.Visible = false
zoneMBS2.Active = false
end

function zg22() -- ceremony,metalpillar,woodpillar,sepulchre
zoneBranch4.Visible = false
zoneBranch4.Active = false
-- mid
zoneEdge.Active = true
zoneEdge.Visible = true
end

function zg23() -- sepulchre
zoneEdge.Visible = false
zoneEdge.Active = false
zoneWoodPillar.Active = true
zoneWoodPillar.Visible = true
zoneMetalPillar.Active = true
zoneMetalPillar.Visible = true
zoneCeremony.Active = true
zoneCeremony.Visible = true
end

function zg24()
zoneEdge.Visible = false
zoneEdge.Active = false
zoneCeremony.Visible = false
zoneCeremony.Active = false
end

function SCGen()
	ScoreCode = "".. tostring(acgear) .."".. tostring(acpower) .."-".. tostring(actimer) .."-".. tostring(acsanity) .."-".. tostring(acdrums) .."".. tostring(acstatue) .."".. tostring(acmbs1) .."".. tostring(acmbs2) .."".. tostring(acend) ..""
end

-- calculate the ending
function EndThis()
	-- got gearpack, 10 pts
	if acgear == 1 then
		Score = Score + 10
	end
	-- if you used the power items, give you credit for half the power value combined, max 111 pts
	if acpower > 0 or acpower < 225 then
		Score = Score + (acpower / 2)
		Score = math.ceil(Score)
	end
	-- 10% of timer, unless you used emulator, half off timer, then 10% of that
	if actimer > 0 then
		if DevID == "Emulator" then
			actimer = actimer / 2
			Score = Score + (actimer / 10)
			Score = math.ceil(Score)
		else
			Score = Score + (actimer / 10)
			Score = math.ceil(Score)
		end
	end

	-- whatever sanity is, even if negative
	Score = Score + acsanity

	-- got drums, 10pts
	if acdrums == 1 then
		Score = Score + 10
	end
	-- got statue, 10pts
	if acstatue == 1 then
		Score = Score + 10
	end
	-- got mbs1, 10 pts
	if acmbs1 == 1 then
		Score = Score + 10
	end
	-- got mbs2, 10 pts
	if acmbs2 == 1 then
		Score = Score + 10
	end
end
-- End user functions --
return cartGC2C5FN
