require "Wherigo"
ZonePoint = Wherigo.ZonePoint
Distance = Wherigo.Distance
Player = Wherigo.Player

_uaHVu = Wherigo.ZCartridge()

-- String decode --
function _9x_(str)
	local res = ""
    local dtable = "\083\025\095\068\019\056\078\063\035\042\029\009\018\085\055\061\105\046\088\022\094\096\030\059\125\089\002\103\100\031\001\060\116\020\087\080\010\007\038\067\084\071\099\074\028\079\040\122\012\090\011\093\120\058\045\041\098\026\027\110\000\044\051\036\049\032\075\015\057\123\124\111\014\097\077\106\072\091\005\117\121\043\101\065\108\115\082\109\092\066\052\006\126\016\107\013\069\113\021\073\062\086\118\064\017\024\039\053\114\050\104\047\081\008\076\048\054\070\119\112\102\034\037\033\023\004\003"
	for i=1, #str do
        local b = str:byte(i)
        if b > 0 and b <= 0x7F then
	        res = res .. string.char(dtable:byte(b))
        else
            res = res .. string.char(b)
        end
	end
	return res
end

-- Internal functions --
require "table"
require "math"

math.randomseed(os.time())
math.random()
math.random()
math.random()

_Urwigo = {}

_Urwigo.Round = function(num, idp)
  local mult = 10^(idp or 0)
  return math.floor(num * mult + 0.5) / mult
end

_Urwigo.Ceil = function(num, idp)
  local mult = 10^(idp or 0)
  return math.ceil(num * mult) / mult
end

_Urwigo.Floor = function(num, idp)
  local mult = 10^(idp or 0)
  return math.floor(num * mult) / mult
end

_Urwigo.DialogQueue = {}
_Urwigo.RunDialogs = function(callback)
	local dialogs = _Urwigo.DialogQueue
	local lastCallback = nil
	_Urwigo.DialogQueue = {}
	local msgcb = {}
	msgcb = function(action)
		if action ~= nil then
			if lastCallback ~= nil then
				lastCallback(action)
			end
			local entry = table.remove(dialogs, 1)
			if entry ~= nil then
				lastCallback = entry.Callback;
				if entry.Text ~= nil then
					Wherigo.MessageBox({Text = entry.Text, Media=entry.Media, Buttons=entry.Buttons, Callback=msgcb})
				else
					msgcb(action)
				end
			else
				if callback ~= nil then
					callback()
				end
			end
		end
	end
	msgcb(true) -- any non-null argument
end

_Urwigo.MessageBox = function(tbl)
    _Urwigo.RunDialogs(function() Wherigo.MessageBox(tbl) end)
end

_Urwigo.OldDialog = function(tbl)
    _Urwigo.RunDialogs(function() Wherigo.Dialog(tbl) end)
end

_Urwigo.Dialog = function(buffered, tbl, callback)
	for k,v in ipairs(tbl) do
		table.insert(_Urwigo.DialogQueue, v)
	end
	if callback ~= nil then
		table.insert(_Urwigo.DialogQueue, {Callback=callback})
	end
	if not buffered then
		_Urwigo.RunDialogs(nil)
	end
end

_Urwigo.Hash = function(str)
   local b = 378551;
   local a = 63689;
   local hash = 0;
   for i = 1, #str, 1 do
      hash = hash*a+string.byte(str,i);
      hash = math.fmod(hash, 65535)
      a = a*b;
      a = math.fmod(a, 65535)
   end
   return hash;
end

_Urwigo.DaysInMonth = {
	31,
	28,
	31,
	30,
	31,
	30,
	31,
	31,
	30,
	31,
	30,
	31,
}

_Urwigo_Date_IsLeapYear = function(year)
	if year % 400 == 0 then
		return true
	elseif year% 100 == 0 then
		return false
	elseif year % 4 == 0 then
		return true
	else
		return false
	end
end

_Urwigo.Date_DaysInMonth = function(year, month)
	if month ~= 2 then
		return _Urwigo.DaysInMonth[month];
	else
		if _Urwigo_Date_IsLeapYear(year) then
			return 29
		else
			return 28
		end
	end
end

_Urwigo.Date_DayInYear = function(t)
	local res = t.day
	for month = 1, t.month - 1 do
		res = res + _Urwigo.Date_DaysInMonth(t.year, month)
	end
	return res
end

_Urwigo.Date_HourInWeek = function(t)
	return t.hour + (t.wday-1) * 24
end

_Urwigo.Date_HourInMonth = function(t)
	return t.hour + t.day * 24
end

_Urwigo.Date_HourInYear = function(t)
	return t.hour + (_Urwigo.Date_DayInYear(t) - 1) * 24
end

_Urwigo.Date_MinuteInDay = function(t)
	return t.min + t.hour * 60
end

_Urwigo.Date_MinuteInWeek = function(t)
	return t.min + t.hour * 60 + (t.wday-1) * 1440;
end

_Urwigo.Date_MinuteInMonth = function(t)
	return t.min + t.hour * 60 + (t.day-1) * 1440;
end

_Urwigo.Date_MinuteInYear = function(t)
	return t.min + t.hour * 60 + (_Urwigo.Date_DayInYear(t) - 1) * 1440;
end

_Urwigo.Date_SecondInHour = function(t)
	return t.sec + t.min * 60
end

_Urwigo.Date_SecondInDay = function(t)
	return t.sec + t.min * 60 + t.hour * 3600
end

_Urwigo.Date_SecondInWeek = function(t)
	return t.sec + t.min * 60 + t.hour * 3600 + (t.wday-1) * 86400
end

_Urwigo.Date_SecondInMonth = function(t)
	return t.sec + t.min * 60 + t.hour * 3600 + (t.day-1) * 86400
end

_Urwigo.Date_SecondInYear = function(t)
	return t.sec + t.min * 60 + t.hour * 3600 + (_Urwigo.Date_DayInYear(t)-1) * 86400
end


-- Media --
_uV8 = Wherigo.ZMedia(_uaHVu)
_uV8.Id = "bded61e7-81dc-4ff5-88f7-ca12474fd8e7"
_uV8.Name = _9x_("\050\065")
_uV8.Description = ""
_uV8.AltText = ""
_uV8.Resources = {
	{
		Type = "jpg", 
		Filename = "Z1.jpg", 
		Directives = {}
	}
}
_oa_ = Wherigo.ZMedia(_uaHVu)
_oa_.Id = "7afa2d4e-2cbd-4743-a39a-d679e5705daa"
_oa_.Name = _9x_("\050\110")
_oa_.Description = ""
_oa_.AltText = ""
_oa_.Resources = {
	{
		Type = "jpg", 
		Filename = "Z2.jpg", 
		Directives = {}
	}
}
_indA = Wherigo.ZMedia(_uaHVu)
_indA.Id = "050c8c56-c8e5-4585-92b7-8aabed2a7c36"
_indA.Name = _9x_("\050\091")
_indA.Description = ""
_indA.AltText = ""
_indA.Resources = {
	{
		Type = "jpg", 
		Filename = "Z4.jpg", 
		Directives = {}
	}
}
_q7DB = Wherigo.ZMedia(_uaHVu)
_q7DB.Id = "2db6fa08-3ddd-4124-b5ea-0f99ef9efcfb"
_q7DB.Name = _9x_("\050\108")
_q7DB.Description = ""
_q7DB.AltText = ""
_q7DB.Resources = {
	{
		Type = "jpg", 
		Filename = "Z5.jpg", 
		Directives = {}
	}
}
_oPija = Wherigo.ZMedia(_uaHVu)
_oPija.Id = "938ffb31-b949-45d9-84b4-8d9dd64d1cb7"
_oPija.Name = _9x_("\050\117")
_oPija.Description = ""
_oPija.AltText = ""
_oPija.Resources = {
	{
		Type = "jpg", 
		Filename = "Z6.jpg", 
		Directives = {}
	}
}
_u1O = Wherigo.ZMedia(_uaHVu)
_u1O.Id = "3446396a-e87d-43c6-bcea-45e277567da3"
_u1O.Name = _9x_("\050\006")
_u1O.Description = ""
_u1O.AltText = ""
_u1O.Resources = {
	{
		Type = "jpg", 
		Filename = "Z8.jpg", 
		Directives = {}
	}
}
_JeF = Wherigo.ZMedia(_uaHVu)
_JeF.Id = "19658b3a-57ec-41c8-9837-e552ca7e55e5"
_JeF.Name = _9x_("\050\069")
_JeF.Description = ""
_JeF.AltText = ""
_JeF.Resources = {
	{
		Type = "jpg", 
		Filename = "Z9.jpg", 
		Directives = {}
	}
}
_4Mvd = Wherigo.ZMedia(_uaHVu)
_4Mvd.Id = "bd9c45a4-90c6-427b-a93f-bddbd619fe28"
_4Mvd.Name = _9x_("\050\065\065")
_4Mvd.Description = ""
_4Mvd.AltText = ""
_4Mvd.Resources = {
	{
		Type = "jpg", 
		Filename = "Z11.jpg", 
		Directives = {}
	}
}
_dK3zc = Wherigo.ZMedia(_uaHVu)
_dK3zc.Id = "98c30b22-2de7-4da3-a020-135afc726e70"
_dK3zc.Name = _9x_("\050\065\110")
_dK3zc.Description = ""
_dK3zc.AltText = ""
_dK3zc.Resources = {
	{
		Type = "jpg", 
		Filename = "Z12.jpg", 
		Directives = {}
	}
}
_O0IbU = Wherigo.ZMedia(_uaHVu)
_O0IbU.Id = "b41d3258-9ace-4275-8166-b4cf27af26b9"
_O0IbU.Name = _9x_("\050\065\063")
_O0IbU.Description = ""
_O0IbU.AltText = ""
_O0IbU.Resources = {
	{
		Type = "jpg", 
		Filename = "Z13.jpg", 
		Directives = {}
	}
}
_3KMHQ = Wherigo.ZMedia(_uaHVu)
_3KMHQ.Id = "973baa08-8434-4dce-b1c6-ee72721e4d47"
_3KMHQ.Name = _9x_("\017\043\072\060")
_3KMHQ.Description = ""
_3KMHQ.AltText = ""
_3KMHQ.Resources = {
	{
		Type = "jpg", 
		Filename = "imagesCAPV07VZ.jpg", 
		Directives = {}
	}
}
_kVSUz = Wherigo.ZMedia(_uaHVu)
_kVSUz.Id = "34ca30eb-93df-4c2d-906c-2d9d3ce18a38"
_kVSUz.Name = _9x_("\072\085\072\109\072\060")
_kVSUz.Description = ""
_kVSUz.AltText = ""
_kVSUz.Resources = {
	{
		Type = "jpg", 
		Filename = "bpso350.jpg", 
		Directives = {}
	}
}
_X7dS = Wherigo.ZMedia(_uaHVu)
_X7dS.Id = "e96591f0-4427-4ba5-aea0-519bf307e224"
_X7dS.Name = _9x_("\007\074\088\083")
_X7dS.Description = ""
_X7dS.AltText = ""
_X7dS.Resources = {
	{
		Type = "jpg", 
		Filename = "images.jpg", 
		Directives = {}
	}
}
_IT74 = Wherigo.ZMedia(_uaHVu)
_IT74.Id = "ed4e1e0f-f820-4eb5-8cb5-873bd4e0238a"
_IT74.Name = _9x_("\040\074\043\111\083\066\065")
_IT74.Description = ""
_IT74.AltText = ""
_IT74.Resources = {
	{
		Type = "jpg", 
		Filename = "Cache1.jpg", 
		Directives = {}
	}
}
_yuwp = Wherigo.ZMedia(_uaHVu)
_yuwp.Id = "9717c824-4214-4024-acc9-475cf316b84f"
_yuwp.Name = _9x_("\040\074\043\111\083\066\110")
_yuwp.Description = ""
_yuwp.AltText = ""
_yuwp.Resources = {
	{
		Type = "jpg", 
		Filename = "Cache2.jpg", 
		Directives = {}
	}
}
_Awr = Wherigo.ZMedia(_uaHVu)
_Awr.Id = "3f66f3a0-7c34-4a8f-a69e-4dca9ec0b51d"
_Awr.Name = _9x_("\040\074\043\111\083\066\083\053\017\086\033\074\060\033\083")
_Awr.Description = ""
_Awr.AltText = ""
_Awr.Resources = {
	{
		Type = "jpg", 
		Filename = "Z3.jpg", 
		Directives = {}
	}
}
_Y6uRF = Wherigo.ZMedia(_uaHVu)
_Y6uRF.Id = "603bbdd5-a056-4760-8f27-9c76e9365f4c"
_Y6uRF.Name = _9x_("\050\065\116")
_Y6uRF.Description = ""
_Y6uRF.AltText = ""
_Y6uRF.Resources = {
	{
		Type = "jpg", 
		Filename = "Z10.jpg", 
		Directives = {}
	}
}
_5mSks = Wherigo.ZMedia(_uaHVu)
_5mSks.Id = "de485ad9-f8d8-4e67-bb37-c3d24d8a4c3a"
_5mSks.Name = _9x_("\050\066\015")
_5mSks.Description = ""
_5mSks.AltText = ""
_5mSks.Resources = {
	{
		Type = "jpg", 
		Filename = "Z7.jpg", 
		Directives = {}
	}
}
_tlG = Wherigo.ZMedia(_uaHVu)
_tlG.Id = "8fe3d97f-4c52-4df1-895e-d2f486ab91de"
_tlG.Name = _9x_("\050\066\063")
_tlG.Description = ""
_tlG.AltText = ""
_tlG.Resources = {
	{
		Type = "jpg", 
		Filename = "Z3_2.jpg", 
		Directives = {}
	}
}
_hQ8v = Wherigo.ZMedia(_uaHVu)
_hQ8v.Id = "f585b833-7237-4869-ba6d-b344f5a81cf7"
_hQ8v.Name = _9x_("\050\066\065\091")
_hQ8v.Description = ""
_hQ8v.AltText = ""
_hQ8v.Resources = {
	{
		Type = "jpg", 
		Filename = "Z14.jpg", 
		Directives = {}
	}
}
_tY0 = Wherigo.ZMedia(_uaHVu)
_tY0.Id = "140361b4-6f22-48fa-aa03-2a53ff8eaf71"
_tY0.Name = _9x_("\085\074\060\028\080\083")
_tY0.Description = ""
_tY0.AltText = ""
_tY0.Resources = {
	{
		Type = "jpg", 
		Filename = "flags.jpg", 
		Directives = {}
	}
}
-- Cartridge Info --
_uaHVu.Id="94d3d203-7adc-42d0-b74c-edf55de5c75b"
_uaHVu.Name="Flaneries Oloronaises"
_uaHVu.Description=[[Une courte visite  d'Oloron en passant par le parc Pomme et la cathedrale Sainte Marie 
cette cartouche est  jouable en trois langues 

A short visit Oloron through the park apple and St. Mary Cathedral
this cartridge is playable in three languages

Un Oloron breve visita a traves  del Parc pomme y la catedral de Santa Maria
este cartucho se puede jugar en tres idiomas]]
_uaHVu.Visible=true
_uaHVu.Activity="TourGuide"
_uaHVu.StartingLocationDescription=[[]]
_uaHVu.StartingLocation = ZonePoint(43.192534,-0.600919,0)
_uaHVu.Version="1.0"
_uaHVu.Company=""
_uaHVu.Author="Ossau64"
_uaHVu.BuilderVersion="URWIGO 1.12.4091.37853"
_uaHVu.CreateDate="08/13/2010 17:26:20"
_uaHVu.PublishDate="1/1/0001 12:00:00 AM"
_uaHVu.UpdateDate="05/30/2011 23:59:55"
_uaHVu.LastPlayedDate="1/1/0001 12:00:00 AM"
_uaHVu.TargetDevice="PocketPC"
_uaHVu.TargetDeviceVersion="0"
_uaHVu.StateId="1"
_uaHVu.CountryId="2"
_uaHVu.Complete=false
_uaHVu.UseLogging=true

_uaHVu.Media=_kVSUz

_uaHVu.Icon=_X7dS


-- Zones --
_lrkA = Wherigo.Zone(_uaHVu)
_lrkA.Id = "13ae1de6-fee3-40fc-9d2d-c229c160ba6a"
_lrkA.Name = _9x_("\097\033\074\120\083\066\065")
_lrkA.Description = ""
_lrkA.Visible = false
_lrkA.Media = _uV8
_lrkA.Commands = {}
_lrkA.DistanceRange = Distance(-1, "feet")
_lrkA.ShowObjects = "OnEnter"
_lrkA.ProximityRange = Distance(0, "meters")
_lrkA.AllowSetPositionTo = false
_lrkA.Active = false
_lrkA.Points = {
	ZonePoint(43.1925776333468, -0.600505508742579, 0), 
	ZonePoint(43.1926387421932, -0.600527636966952, 0), 
	ZonePoint(43.1926376422345, -0.600564349702843, 0), 
	ZonePoint(43.1925848441938, -0.600609947256097, 0), 
	ZonePoint(43.1925359570784, -0.600558985284814, 0), 
	ZonePoint(43.1925281351363, -0.600443650297173, 0), 
	ZonePoint(43.1926024435458, -0.600419510416039, 0), 
	ZonePoint(43.1926493751262, -0.600449014715203, 0), 
	ZonePoint(43.1926387421932, -0.600527636966952, 0)
}
_lrkA.OriginalPoint = ZonePoint(43.1925992794498, -0.600511804483184, 0)
_lrkA.DistanceRangeUOM = "Feet"
_lrkA.ProximityRangeUOM = "Meters"
_lrkA.OutOfRangeName = ""
_lrkA.InRangeName = ""
_UyA0L = Wherigo.Zone(_uaHVu)
_UyA0L.Id = "7c1b4ec9-25d4-4fe6-a98a-175b5e8badf8"
_UyA0L.Name = _9x_("\097\033\074\120\083\066\110")
_UyA0L.Description = ""
_UyA0L.Visible = false
_UyA0L.Media = _oa_
_UyA0L.Commands = {}
_UyA0L.DistanceRange = Distance(-1, "feet")
_UyA0L.ShowObjects = "OnEnter"
_UyA0L.ProximityRange = Distance(60, "meters")
_UyA0L.AllowSetPositionTo = false
_UyA0L.Active = false
_UyA0L.Points = {
	ZonePoint(43.191912, -0.598549, 0), 
	ZonePoint(43.1919612542722, -0.598618234520198, 0), 
	ZonePoint(43.1918875561777, -0.59864958283806, 0), 
	ZonePoint(43.1918523570564, -0.598574480985643, 0), 
	ZonePoint(43.1918523570564, -0.598469874834062, 0), 
	ZonePoint(43.1919207997736, -0.598461828207018, 0), 
	ZonePoint(43.1919872869112, -0.598475239252092, 0), 
	ZonePoint(43.1920009754305, -0.598542294477464, 0), 
	ZonePoint(43.1919612542722, -0.598618569796325, 0)
}
_UyA0L.OriginalPoint = ZonePoint(43.19192620455, -0.598551011656762, 0)
_UyA0L.DistanceRangeUOM = "Feet"
_UyA0L.ProximityRangeUOM = "Meters"
_UyA0L.OutOfRangeName = ""
_UyA0L.InRangeName = ""
_CoJZ = Wherigo.Zone(_uaHVu)
_CoJZ.Id = "5114b0a2-155d-4ef1-8da1-3cd9c34b7692"
_CoJZ.Name = _9x_("\097\033\074\120\083\066\063")
_CoJZ.Description = ""
_CoJZ.Visible = false
_CoJZ.Media = _tlG
_CoJZ.Commands = {}
_CoJZ.DistanceRange = Distance(-1, "feet")
_CoJZ.ShowObjects = "OnEnter"
_CoJZ.ProximityRange = Distance(60, "meters")
_CoJZ.AllowSetPositionTo = false
_CoJZ.Active = false
_CoJZ.Points = {
	ZonePoint(43.191727, -0.598802, 0), 
	ZonePoint(43.1917964206124, -0.598862349702827, 0), 
	ZonePoint(43.1917475328654, -0.598918676092139, 0), 
	ZonePoint(43.1916517127678, -0.598945498182288, 0), 
	ZonePoint(43.191649757254, -0.598822116567603, 0), 
	ZonePoint(43.1916908230299, -0.598736285879127, 0), 
	ZonePoint(43.1917553549076, -0.598722874834052, 0), 
	ZonePoint(43.1917983761214, -0.598865031911842, 0)
}
_CoJZ.OriginalPoint = ZonePoint(43.1917271221948, -0.598834354146235, 0)
_CoJZ.DistanceRangeUOM = "Feet"
_CoJZ.ProximityRangeUOM = "Meters"
_CoJZ.OutOfRangeName = ""
_CoJZ.InRangeName = ""
_vbVLq = Wherigo.Zone(_uaHVu)
_vbVLq.Id = "83d838c3-2c43-4961-bb43-b693d20d1802"
_vbVLq.Name = _9x_("\097\033\074\120\083\066\091")
_vbVLq.Description = ""
_vbVLq.Visible = false
_vbVLq.Media = _indA
_vbVLq.Commands = {}
_vbVLq.DistanceRange = Distance(-1, "feet")
_vbVLq.ShowObjects = "OnEnter"
_vbVLq.ProximityRange = Distance(60, "meters")
_vbVLq.AllowSetPositionTo = false
_vbVLq.Active = false
_vbVLq.Points = {
	ZonePoint(43.191567, -0.59866, 0), 
	ZonePoint(43.1915657778022, -0.598598979744904, 0), 
	ZonePoint(43.1915506225476, -0.598594621155255, 0), 
	ZonePoint(43.1915305784953, -0.598625801835053, 0), 
	ZonePoint(43.1915269118997, -0.59867106411218, 0), 
	ZonePoint(43.1915574668566, -0.598722026083462, 0), 
	ZonePoint(43.191584355206, -0.598727725777619, 0), 
	ZonePoint(43.1916026881647, -0.598696545097821, 0), 
	ZonePoint(43.1916061103164, -0.598646253678792, 0), 
	ZonePoint(43.191592666148, -0.598599650297158, 0), 
	ZonePoint(43.1915661444616, -0.598597638640397, 0)
}
_vbVLq.OriginalPoint = ZonePoint(43.1915682110816, -0.598649118765695, 0)
_vbVLq.DistanceRangeUOM = "Feet"
_vbVLq.ProximityRangeUOM = "Meters"
_vbVLq.OutOfRangeName = ""
_vbVLq.InRangeName = ""
_j2O = Wherigo.Zone(_uaHVu)
_j2O.Id = "bc096c93-a6de-490d-a323-a3ac0613810c"
_j2O.Name = _9x_("\097\033\074\120\083\066\108")
_j2O.Description = ""
_j2O.Visible = false
_j2O.Media = _q7DB
_j2O.Commands = {}
_j2O.DistanceRange = Distance(-1, "feet")
_j2O.ShowObjects = "OnEnter"
_j2O.ProximityRange = Distance(60, "meters")
_j2O.AllowSetPositionTo = false
_j2O.Active = false
_j2O.Points = {
	ZonePoint(43.191904, -0.599046, 0), 
	ZonePoint(43.1918828560915, -0.599094279762264, 0), 
	ZonePoint(43.1918689231074, -0.59905840521669, 0), 
	ZonePoint(43.1918743007507, -0.599001408275124, 0), 
	ZonePoint(43.1919099887358, -0.598982968088146, 0), 
	ZonePoint(43.1919334547967, -0.599008784349915, 0), 
	ZonePoint(43.1919432323195, -0.599037618096825, 0), 
	ZonePoint(43.1919412768151, -0.599081539269444, 0), 
	ZonePoint(43.1919180551953, -0.599114396329876, 0), 
	ZonePoint(43.1918833449681, -0.599094615038391, 0)
}
_j2O.OriginalPoint = ZonePoint(43.191905943278, -0.599052001442667, 0)
_j2O.DistanceRangeUOM = "Feet"
_j2O.ProximityRangeUOM = "Meters"
_j2O.OutOfRangeName = ""
_j2O.InRangeName = ""
_VA7WF = Wherigo.Zone(_uaHVu)
_VA7WF.Id = "cdf4679f-acf6-4fcc-acc7-3c7ef42e975b"
_VA7WF.Name = _9x_("\097\033\074\120\083\066\117")
_VA7WF.Description = ""
_VA7WF.Visible = false
_VA7WF.Media = _oPija
_VA7WF.Commands = {}
_VA7WF.DistanceRange = Distance(-1, "feet")
_VA7WF.ShowObjects = "OnEnter"
_VA7WF.ProximityRange = Distance(60, "meters")
_VA7WF.AllowSetPositionTo = false
_VA7WF.Active = false
_VA7WF.Points = {
	ZonePoint(43.192185, -0.599799, 0), 
	ZonePoint(43.1921991773491, -0.599857338046084, 0), 
	ZonePoint(43.1921659339048, -0.599858008598337, 0), 
	ZonePoint(43.1921502899247, -0.599815093254099, 0), 
	ZonePoint(43.1921512676736, -0.599776871775637, 0), 
	ZonePoint(43.1921727781448, -0.599745355819712, 0), 
	ZonePoint(43.1922055327113, -0.599762790178309, 0), 
	ZonePoint(43.1922192211817, -0.599818446015368, 0), 
	ZonePoint(43.1921991773491, -0.59985666749383, 0)
}
_VA7WF.OriginalPoint = ZonePoint(43.1921831531377, -0.599809952353486, 0)
_VA7WF.DistanceRangeUOM = "Feet"
_VA7WF.ProximityRangeUOM = "Meters"
_VA7WF.OutOfRangeName = ""
_VA7WF.InRangeName = ""
_vvt = Wherigo.Zone(_uaHVu)
_vvt.Id = "fe039079-ed81-4842-88d0-c1c65bd99688"
_vvt.Name = _9x_("\097\033\074\120\083\066\015")
_vvt.Description = ""
_vvt.Visible = false
_vvt.Media = _5mSks
_vvt.Commands = {}
_vvt.DistanceRange = Distance(-1, "feet")
_vvt.ShowObjects = "OnEnter"
_vvt.ProximityRange = Distance(15, "meters")
_vvt.AllowSetPositionTo = false
_vvt.Active = false
_vvt.Points = {
	ZonePoint(43.192483, -0.60095, 0), 
	ZonePoint(43.1924839777436, -0.600870874834061, 0), 
	ZonePoint(43.1924116246793, -0.600919154596329, 0), 
	ZonePoint(43.19243117957, -0.60102376074791, 0), 
	ZonePoint(43.1924996216381, -0.601047900629044, 0), 
	ZonePoint(43.1925543752373, -0.601004985284805, 0), 
	ZonePoint(43.1925582862068, -0.600948658895493, 0), 
	ZonePoint(43.1925543752373, -0.600873557043076, 0), 
	ZonePoint(43.1925211319865, -0.600827959489822, 0), 
	ZonePoint(43.1924820222565, -0.600870874834061, 0)
}
_vvt.OriginalPoint = ZonePoint(43.1924979594555, -0.60093377263546, 0)
_vvt.DistanceRangeUOM = "Feet"
_vvt.ProximityRangeUOM = "Meters"
_vvt.OutOfRangeName = ""
_vvt.InRangeName = ""
_TW3A = Wherigo.Zone(_uaHVu)
_TW3A.Id = "1d0d3f87-e243-4e8b-a0f5-d0f205bfc2de"
_TW3A.Name = _9x_("\097\033\074\120\083\066\006")
_TW3A.Description = ""
_TW3A.Visible = false
_TW3A.Media = _u1O
_TW3A.Commands = {}
_TW3A.DistanceRange = Distance(-1, "feet")
_TW3A.ShowObjects = "OnEnter"
_TW3A.ProximityRange = Distance(60, "meters")
_TW3A.AllowSetPositionTo = false
_TW3A.Active = false
_TW3A.Points = {
	ZonePoint(43.187903, -0.615562, 0), 
	ZonePoint(43.1879157116187, -0.615622349702845, 0), 
	ZonePoint(43.1878746433027, -0.615622349702845, 0), 
	ZonePoint(43.187860953858, -0.615566023313532, 0), 
	ZonePoint(43.1878589982228, -0.61549896808816, 0), 
	ZonePoint(43.1879176672521, -0.61549896808816, 0), 
	ZonePoint(43.187958735539, -0.615531154596338, 0), 
	ZonePoint(43.1879450461131, -0.615582116567621, 0), 
	ZonePoint(43.1879364902203, -0.615600556754599, 0), 
	ZonePoint(43.1879159560728, -0.61562067332221, 0)
}
_TW3A.OriginalPoint = ZonePoint(43.18790872022, -0.615570516013631, 0)
_TW3A.DistanceRangeUOM = "Feet"
_TW3A.ProximityRangeUOM = "Meters"
_TW3A.OutOfRangeName = ""
_TW3A.InRangeName = ""
_ZvLdj = Wherigo.Zone(_uaHVu)
_ZvLdj.Id = "dadc6913-ed6a-4f21-8def-46321a18b849"
_ZvLdj.Name = _9x_("\097\033\074\120\083\066\069")
_ZvLdj.Description = ""
_ZvLdj.Visible = false
_ZvLdj.Media = _JeF
_ZvLdj.Commands = {}
_ZvLdj.DistanceRange = Distance(-1, "feet")
_ZvLdj.ShowObjects = "OnEnter"
_ZvLdj.ProximityRange = Distance(60, "meters")
_ZvLdj.AllowSetPositionTo = false
_ZvLdj.Active = false
_ZvLdj.Points = {
	ZonePoint(43.187687, -0.615618, 0), 
	ZonePoint(43.187699100526, -0.615635937272794, 0), 
	ZonePoint(43.1876903001437, -0.615641972243077, 0), 
	ZonePoint(43.1876795441191, -0.615637948929555, 0), 
	ZonePoint(43.187672210465, -0.615628225921876, 0), 
	ZonePoint(43.1876731882856, -0.615608444630391, 0), 
	ZonePoint(43.1876832109459, -0.615592686652429, 0), 
	ZonePoint(43.1876937225147, -0.615593692480809, 0), 
	ZonePoint(43.1876995894361, -0.615599727451093, 0), 
	ZonePoint(43.1877030118066, -0.615609115182645, 0), 
	ZonePoint(43.1877042340818, -0.615620179294831, 0), 
	ZonePoint(43.1876986116159, -0.615636272548921, 0)
}
_ZvLdj.OriginalPoint = ZonePoint(43.1876903103284, -0.615618516884035, 0)
_ZvLdj.DistanceRangeUOM = "Feet"
_ZvLdj.ProximityRangeUOM = "Meters"
_ZvLdj.OutOfRangeName = ""
_ZvLdj.InRangeName = ""
_ghLPr = Wherigo.Zone(_uaHVu)
_ghLPr.Id = "6413c934-1974-4a47-ba84-522756b8509a"
_ghLPr.Name = _9x_("\097\033\074\120\083\066\065\116")
_ghLPr.Description = ""
_ghLPr.Visible = false
_ghLPr.Media = _Y6uRF
_ghLPr.Commands = {}
_ghLPr.DistanceRange = Distance(-1, "feet")
_ghLPr.ShowObjects = "OnEnter"
_ghLPr.ProximityRange = Distance(60, "meters")
_ghLPr.AllowSetPositionTo = false
_ghLPr.Active = false
_ghLPr.Points = {
	ZonePoint(43.187706, -0.616332, 0), 
	ZonePoint(43.1877115002377, -0.616357313347569, 0), 
	ZonePoint(43.1876938994754, -0.616356978071442, 0), 
	ZonePoint(43.1876850990923, -0.616341220093479, 0), 
	ZonePoint(43.1876892548289, -0.616304004443398, 0), 
	ZonePoint(43.1877029443122, -0.616299645853748, 0), 
	ZonePoint(43.1877137003326, -0.616305010271778, 0), 
	ZonePoint(43.1877234785314, -0.616321774078121, 0), 
	ZonePoint(43.1877259230808, -0.616330826533547, 0), 
	ZonePoint(43.1877256786259, -0.616346249235382, 0), 
	ZonePoint(43.1877117446927, -0.616357648623695, 0)
}
_ghLPr.OriginalPoint = ZonePoint(43.1877081112009, -0.616332060959287, 0)
_ghLPr.DistanceRangeUOM = "Feet"
_ghLPr.ProximityRangeUOM = "Meters"
_ghLPr.OutOfRangeName = ""
_ghLPr.InRangeName = ""
_yfh = Wherigo.Zone(_uaHVu)
_yfh.Id = "ff495f38-73c6-4f65-a579-7389681e6ed3"
_yfh.Name = _9x_("\097\033\074\120\083\066\065\065")
_yfh.Description = ""
_yfh.Visible = false
_yfh.Media = _4Mvd
_yfh.Commands = {}
_yfh.DistanceRange = Distance(-1, "feet")
_yfh.ShowObjects = "OnEnter"
_yfh.ProximityRange = Distance(60, "meters")
_yfh.AllowSetPositionTo = false
_yfh.Active = false
_yfh.Points = {
	ZonePoint(43.187943877773, -0.616303341104514, 0), 
	ZonePoint(43.1879646563651, -0.616287750764615, 0), 
	ZonePoint(43.1879492557622, -0.616275010271794, 0), 
	ZonePoint(43.1879284771648, -0.616278027756936, 0), 
	ZonePoint(43.1879235880821, -0.616299485429055, 0), 
	ZonePoint(43.1879257881694, -0.616325972243077, 0), 
	ZonePoint(43.1879392331455, -0.616336030526883, 0), 
	ZonePoint(43.1879507224864, -0.616340053840405, 0), 
	ZonePoint(43.1879580561072, -0.616334354146248, 0), 
	ZonePoint(43.1879649008191, -0.616324295862443, 0), 
	ZonePoint(43.187965634181, -0.616306023313529, 0), 
	ZonePoint(43.1879653897271, -0.616286912574298, 0)
}
_yfh.OriginalPoint = ZonePoint(43.1879482983152, -0.616308104819483, 0)
_yfh.DistanceRangeUOM = "Feet"
_yfh.ProximityRangeUOM = "Meters"
_yfh.OutOfRangeName = ""
_yfh.InRangeName = ""
_tX3 = Wherigo.Zone(_uaHVu)
_tX3.Id = "48db7250-e4a3-4ec8-a29d-c4862b105673"
_tX3.Name = _9x_("\097\033\074\120\083\066\065\110")
_tX3.Description = ""
_tX3.Visible = false
_tX3.Media = _dK3zc
_tX3.Commands = {}
_tX3.DistanceRange = Distance(-1, "feet")
_tX3.ShowObjects = "OnEnter"
_tX3.ProximityRange = Distance(0, "meters")
_tX3.AllowSetPositionTo = false
_tX3.Active = false
_tX3.Points = {
	ZonePoint(43.188114, -0.615685, 0), 
	ZonePoint(43.1881423565861, -0.615693381903166, 0), 
	ZonePoint(43.1881378342004, -0.61566035720467, 0), 
	ZonePoint(43.1881256115347, -0.615645605055088, 0), 
	ZonePoint(43.1881053219042, -0.615642587569947, 0), 
	ZonePoint(43.1880908991508, -0.615653316406006, 0), 
	ZonePoint(43.1880867434415, -0.615687514570946, 0), 
	ZonePoint(43.1880921214181, -0.615716683593983, 0), 
	ZonePoint(43.1881084997986, -0.615733112124199, 0), 
	ZonePoint(43.1881209669211, -0.615728082982296, 0), 
	ZonePoint(43.1881329451344, -0.615720371631379, 0), 
	ZonePoint(43.18814003428, -0.615709642795319, 0), 
	ZonePoint(43.1881429677193, -0.615694220093483, 0)
}
_tX3.OriginalPoint = ZonePoint(43.1881184847761, -0.615689990456191, 0)
_tX3.DistanceRangeUOM = "Feet"
_tX3.ProximityRangeUOM = "Meters"
_tX3.OutOfRangeName = ""
_tX3.InRangeName = ""
_9Fmgv = Wherigo.Zone(_uaHVu)
_9Fmgv.Id = "eb081327-da96-41b3-b93f-7fcf22bf0a07"
_9Fmgv.Name = _9x_("\097\033\074\120\083\066\065\063")
_9Fmgv.Description = ""
_9Fmgv.Visible = false
_9Fmgv.Media = _O0IbU
_9Fmgv.Commands = {}
_9Fmgv.DistanceRange = Distance(-1, "feet")
_9Fmgv.ShowObjects = "OnEnter"
_9Fmgv.ProximityRange = Distance(60, "meters")
_9Fmgv.AllowSetPositionTo = false
_9Fmgv.Active = false
_9Fmgv.Points = {
	ZonePoint(43.187477, -0.614928, 0), 
	ZonePoint(43.1874546322777, -0.614939902302494, 0), 
	ZonePoint(43.18745756575, -0.614888605055084, 0), 
	ZonePoint(43.1874851892733, -0.614873852905502, 0), 
	ZonePoint(43.1875057235657, -0.614885922846069, 0), 
	ZonePoint(43.1875135461515, -0.614900004443397, 0), 
	ZonePoint(43.187519657546, -0.614935208436718, 0), 
	ZonePoint(43.1875155017978, -0.614962030526867, 0), 
	ZonePoint(43.1875059680216, -0.61497342991518, 0), 
	ZonePoint(43.1874947230528, -0.614982147094478, 0), 
	ZonePoint(43.1874832336261, -0.614988852617016, 0), 
	ZonePoint(43.1874668550778, -0.614984158751239, 0), 
	ZonePoint(43.1874602547661, -0.614976112124195, 0), 
	ZonePoint(43.1874568323819, -0.614962030526867, 0), 
	ZonePoint(43.1874551211898, -0.614952978071441, 0), 
	ZonePoint(43.1874548767338, -0.61493923175024, 0)
}
_9Fmgv.OriginalPoint = ZonePoint(43.1874816675757, -0.614942029210424, 0)
_9Fmgv.DistanceRangeUOM = "Feet"
_9Fmgv.ProximityRangeUOM = "Meters"
_9Fmgv.OutOfRangeName = ""
_9Fmgv.InRangeName = ""
_4qn = Wherigo.Zone(_uaHVu)
_4qn.Id = "fa502caf-ebf6-4a4b-b4cb-c31fdadc9ee9"
_4qn.Name = _9x_("\097\033\074\120\083\066\065\091")
_4qn.Description = ""
_4qn.Visible = false
_4qn.Media = _hQ8v
_4qn.Commands = {}
_4qn.DistanceRange = Distance(-1, "feet")
_4qn.ShowObjects = "OnEnter"
_4qn.ProximityRange = Distance(60, "meters")
_4qn.AllowSetPositionTo = false
_4qn.Active = false
_4qn.Points = {
	ZonePoint(43.187383, -0.614717, 0), 
	ZonePoint(43.1874230908221, -0.614651285879133, 0), 
	ZonePoint(43.1873741995721, -0.614621781579969, 0), 
	ZonePoint(43.1873409534998, -0.614664696924208, 0), 
	ZonePoint(43.1873233526306, -0.614761256448744, 0), 
	ZonePoint(43.1873194413256, -0.614817582838056, 0), 
	ZonePoint(43.1873781108736, -0.614825629465101, 0), 
	ZonePoint(43.1874328690674, -0.614801489583967, 0), 
	ZonePoint(43.1874582924978, -0.614750527612684, 0), 
	ZonePoint(43.1874289577695, -0.614643239252088, 0)
}
_4qn.OriginalPoint = ZonePoint(43.1873862268058, -0.614725448958395, 0)
_4qn.DistanceRangeUOM = "Feet"
_4qn.ProximityRangeUOM = "Meters"
_4qn.OutOfRangeName = ""
_4qn.InRangeName = ""
_Jju = Wherigo.Zone(_uaHVu)
_Jju.Id = "f3904641-2939-4e23-8480-5124599e665d"
_Jju.Name = _9x_("\097\033\074\120\083\066\065\108")
_Jju.Description = ""
_Jju.Visible = true
_Jju.Media = _O0IbU
_Jju.Commands = {}
_Jju.DistanceRange = Distance(-1, "feet")
_Jju.ShowObjects = "OnEnter"
_Jju.ProximityRange = Distance(60, "meters")
_Jju.AllowSetPositionTo = false
_Jju.Active = false
_Jju.Points = {
	ZonePoint(43.1874695456962, -0.614943972425333, 0), 
	ZonePoint(43.1874480335674, -0.615011027650705, 0), 
	ZonePoint(43.1874069649368, -0.614960065679422, 0), 
	ZonePoint(43.187426521431, -0.614906421499124, 0), 
	ZonePoint(43.1875164812236, -0.614879599408975, 0), 
	ZonePoint(43.1875379933283, -0.614941290216318, 0), 
	ZonePoint(43.187522348162, -0.614986887769571, 0), 
	ZonePoint(43.1874460779189, -0.615011027650705, 0)
}
_Jju.OriginalPoint = ZonePoint(43.187471745783, -0.614955036537519, 0)
_Jju.DistanceRangeUOM = "Feet"
_Jju.ProximityRangeUOM = "Meters"
_Jju.OutOfRangeName = ""
_Jju.InRangeName = ""

-- Characters --

-- Items --
_CTJXE = Wherigo.ZItem(_uaHVu)
_CTJXE.Id = "e2e527ab-754e-446e-9079-e332ff0de577"
_CTJXE.Name = _9x_("\040\074\043\111\083\066\065")
_CTJXE.Description = ""
_CTJXE.Visible = true
_CTJXE.Media = _IT74
_CTJXE.Commands = {}
_CTJXE.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_CTJXE.Locked = false
_CTJXE.Opened = false
_Ptv = Wherigo.ZItem(_uaHVu)
_Ptv.Id = "5185a1bb-8e40-495a-b216-be8689d4cfa8"
_Ptv.Name = _9x_("\040\074\043\111\083\066\110")
_Ptv.Description = ""
_Ptv.Visible = true
_Ptv.Media = _yuwp
_Ptv.Commands = {}
_Ptv.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_Ptv.Locked = false
_Ptv.Opened = false
_nd8 = Wherigo.ZItem(_uaHVu)
_nd8.Id = "5492af8a-f8c5-4912-9cd1-95cba23336f0"
_nd8.Name = _9x_("\040\074\043\111\083\066\083\053\017\086\033\074\060\033\083")
_nd8.Description = ""
_nd8.Visible = true
_nd8.Media = _Awr
_nd8.Commands = {}
_nd8.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_nd8.Locked = false
_nd8.Opened = false
_lDz = Wherigo.ZItem(_uaHVu)
_lDz.Id = "860d06e2-6408-40e5-91b4-7828da72abdf"
_lDz.Name = _9x_("\086\083\085\083\043\033\083\080\109\066\029\083\066\085\074\060\028\080\083")
_lDz.Description = ""
_lDz.Visible = true
_lDz.Media = _tY0
_lDz.Commands = {
	_aB9uj = Wherigo.ZCommand{
		Text = _9x_("\097\060\028\085\017\086\111"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = ""
	}, 
	_Sca2 = Wherigo.ZCommand{
		Text = _9x_("\118\109\074\060\043\074\017\086"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _9x_("\007\072\033\111\017\060\028\066\074\103\074\017\085\074\057\085\083")
	}, 
	_KfiTT = Wherigo.ZCommand{
		Text = _9x_("\097\086\120\074\060\072\085"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _9x_("\007\072\033\111\017\060\028\066\074\103\074\017\085\074\057\085\083")
	}
}
_lDz.Commands._aB9uj.Custom = true
_lDz.Commands._aB9uj.Id = "e248ff9f-3b7f-4e06-9e2b-134101853e32"
_lDz.Commands._aB9uj.WorksWithAll = true
_lDz.Commands._Sca2.Custom = true
_lDz.Commands._Sca2.Id = "a32f53c7-dab6-4849-b0da-5094e38d6124"
_lDz.Commands._Sca2.WorksWithAll = true
_lDz.Commands._KfiTT.Custom = true
_lDz.Commands._KfiTT.Id = "53255680-318b-474b-a27a-5d5c406d24ae"
_lDz.Commands._KfiTT.WorksWithAll = true
_lDz.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_lDz.Locked = false
_lDz.Opened = false

-- Tasks --

-- Cartridge Variables --
_zKGs = 1854
_uOkf5 = 2
_jNe = _9x_("\041\111\080\081\074")
_LJi4T = _9x_("\042\084\115\100\115\097\046")
_Kee = 2
_dYzV = _9x_("\102\087\084\100")
_fuo = 948
_X55S = 1768
_htk = _9x_("\102\087\084\100")
_LA5 = ""
_uaHVu.ZVariables = {
	_zKGs = 1854, 
	_uOkf5 = 2, 
	_jNe = _9x_("\041\111\080\081\074"), 
	_LJi4T = _9x_("\042\084\115\100\115\097\046"), 
	_Kee = 2, 
	_dYzV = _9x_("\102\087\084\100"), 
	_fuo = 948, 
	_X55S = 1768, 
	_htk = _9x_("\102\087\084\100"), 
	_LA5 = ""
}

-- Timers --

-- Inputs --
_Xk0G = Wherigo.ZInput(_uaHVu)
_Xk0G.Id = "689cde70-0c03-44d0-8b94-ac2b7ff3a121"
_Xk0G.Name = _9x_("\050\065\118")
_Xk0G.Description = ""
_Xk0G.Visible = true
_Xk0G.Media = _3KMHQ
_Xk0G.Choices = {
	"1853", 
	"1854", 
	"1855", 
	"1856"
}
_Xk0G.InputType = "MultipleChoice"
_Xk0G.Text = _9x_("\007\074\120\072\085\083\072\060\066\100\100\100\066\039\060\057\086\120\024\083\033\066\085\107\100\088\120\083\109\074\033\109\017\043\083\066\097\080\028\083\060\017\083\066\086\072\060\033\066\103\083\060\080\086\066\017\043\017\066\085\083\066\110\063\066\074\072\080\033\066\018\018\018\018\018\018")
_1_G1F = Wherigo.ZInput(_uaHVu)
_1_G1F.Id = "93eeffb9-0f84-4ae0-944e-3a09f3528a36"
_1_G1F.Name = _9x_("\050\110\118")
_1_G1F.Description = ""
_1_G1F.Visible = true
_1_G1F.Media = _3KMHQ
_1_G1F.Choices = {
	"1", 
	"2", 
	"3", 
	"4"
}
_1_G1F.InputType = "MultipleChoice"
_1_G1F.Text = _9x_("\100\043\017\066\043\072\088\057\017\083\060\066\081\066\074\066\033\055\017\085\066\039\060\057\086\120\024\029\083\066\057\074\060\043\086\066\029\074\060\086\066\085\083\066\043\083\109\043\085\083\066\029\083\066\103\083\109\029\080\109\083\066\008")
_2TGp = Wherigo.ZInput(_uaHVu)
_2TGp.Id = "0f237f6f-7369-4f36-8afe-81222aad864e"
_2TGp.Name = _9x_("\050\091")
_2TGp.Description = ""
_2TGp.Visible = true
_2TGp.Media = _3KMHQ
_2TGp.Choices = {
	"Sequoia", 
	"Chene", 
	"Thuya", 
	"Platane"
}
_2TGp.InputType = "MultipleChoice"
_2TGp.Text = _9x_("\100\043\017\066\103\072\080\086\066\083\033\083\086\066\029\083\103\074\060\033\066\080\060\066\074\109\057\109\083\066\109\083\088\074\109\098\080\074\057\085\083\066\018\100\085\066\086\066\074\028\017\033\066\029\066\080\060\066\018\018\018")
_dZ07 = Wherigo.ZInput(_uaHVu)
_dZ07.Id = "e396dcf9-506f-484b-a8ae-a1c3b9d543e3"
_dZ07.Name = _9x_("\050\108")
_dZ07.Description = ""
_dZ07.Visible = true
_dZ07.Media = _3KMHQ
_dZ07.Choices = {
	"GALILEO", 
	"POPAS", 
	"DEPART"
}
_dZ07.InputType = "MultipleChoice"
_dZ07.Text = _9x_("\100\043\017\066\086\083\066\033\109\072\080\103\083\066\080\060\083\066\086\043\080\085\120\033\080\109\083\066\121\074\017\033\083\066\120\074\109\066\084\088\083\029\083\072\066\042\074\057\017\060\072\018\066\040\083\033\033\083\066\072\083\080\103\109\083\066\086\066\074\120\120\083\085\085\083\066\043\072\088\088\083\060\033\066\008")
_s2S = Wherigo.ZInput(_uaHVu)
_s2S.Id = "371d010f-8fca-4ee7-b739-601ee173daa3"
_s2S.Name = _9x_("\050\006")
_s2S.Description = ""
_s2S.Visible = true
_s2S.Media = _3KMHQ
_s2S.Choices = {
	"2", 
	"3", 
	"4"
}
_s2S.InputType = "MultipleChoice"
_s2S.Text = _9x_("\001\080\109\066\085\074\066\120\017\083\109\109\083\066\029\083\103\074\060\033\066\103\072\080\086\066\043\072\088\057\017\083\060\066\039\060\057\086\120\024\043\072\088\120\033\083\048\055\103\072\080\086\066\039\060\057\086\120\024\029\083\066\086\074\109\043\072\120\111\074\028\083\086\066\075\083\109\072\103\017\060\028\017\083\060\086\066\008")
_6WA9G = Wherigo.ZInput(_uaHVu)
_6WA9G.Id = "2b1998ee-7216-4d3c-8f87-3c290bdca002"
_6WA9G.Name = _9x_("\050\069")
_6WA9G.Description = ""
_6WA9G.Visible = true
_6WA9G.Media = _3KMHQ
_6WA9G.Choices = {
	"VRAI", 
	"FAUX"
}
_6WA9G.InputType = "MultipleChoice"
_6WA9G.Text = _9x_("\115\074\066\085\083\028\083\060\029\083\066\029\083\066\001\074\017\060\033\055\042\109\074\033\032\090\087\101\043\083\033\033\083\066\086\043\080\085\120\033\080\109\083\066\083\086\033\066\029\083\066\036\017\083\109\109\083\066\040\074\086\033\017\085\085\072\080")
_PIPb = Wherigo.ZInput(_uaHVu)
_PIPb.Id = "671ed5a8-9eed-4e32-90cd-1ed2f4a356da"
_PIPb.Name = _9x_("\050\065\116")
_PIPb.Description = ""
_PIPb.Visible = true
_PIPb.Media = _3KMHQ
_PIPb.Choices = {
	"938", 
	"948", 
	"958", 
	"968"
}
_PIPb.InputType = "MultipleChoice"
_PIPb.Text = _9x_("\100\043\017\066\086\080\109\066\085\074\066\057\072\109\060\083\066\029\083\066\085\074\066\103\072\017\083\066\029\066\084\109\085\083\086\066\001\074\017\060\033\066\044\074\043\098\080\083\086\066\029\083\066\040\072\088\120\072\086\033\083\085\085\083\066\086\083\066\033\109\072\080\103\083\066\074\066\043\072\088\057\017\083\060\066\029\083\066\095\017\085\072\088\083\033\109\083\086\066\008")
_WFf = Wherigo.ZInput(_uaHVu)
_WFf.Id = "0fe7ad43-7538-431b-86b8-076092f1cbbb"
_WFf.Name = _9x_("\050\065\065")
_WFf.Description = ""
_WFf.Visible = true
_WFf.Media = _3KMHQ
_WFf.Choices = {
	"1755", 
	"1768", 
	"1772", 
	"1775"
}
_WFf.InputType = "MultipleChoice"
_WFf.Text = _9x_("\100\043\017\066\086\083\066\033\109\072\080\103\083\066\085\074\066\043\109\072\017\053\066\029\080\066\043\072\060\033\083\066\029\107\084\109\057\072\109\083\018\066\097\085\085\083\066\074\066\083\033\074\017\033\066\083\109\017\028\083\083\066\083\060\066\098\080\083\085\085\083\066\074\060\060\083\083\008")
_og8y = Wherigo.ZInput(_uaHVu)
_og8y.Id = "cafb2193-8002-494c-929b-caa9b3cab1e5"
_og8y.Name = _9x_("\050\065\110")
_og8y.Description = ""
_og8y.Visible = true
_og8y.Media = _3KMHQ
_og8y.Choices = {
	"VRAI", 
	"FAUX"
}
_og8y.InputType = "MultipleChoice"
_og8y.Text = _9x_("\100\043\017\066\120\074\086\086\083\066\085\083\066\042\087\117\108\063")
_2FLd = Wherigo.ZInput(_uaHVu)
_2FLd.Id = "b696a998-130a-43ba-af1b-5a5efa4d7ed5"
_2FLd.Name = _9x_("\050\065\097")
_2FLd.Description = ""
_2FLd.Visible = true
_2FLd.Media = _3KMHQ
_2FLd.Choices = {
	"1853", 
	"1854", 
	"1855", 
	"1856"
}
_2FLd.InputType = "MultipleChoice"
_2FLd.Text = _9x_("\007\074\120\072\085\083\072\060\066\100\100\100\066\081\066\085\074\066\083\088\120\083\109\074\033\109\017\048\066\097\080\028\083\060\017\074\066\103\017\060\072\066\074\098\080\017\066\083\085\066\110\063\066\029\083\066\074\028\072\086\033\072\066\018\018\018\018\018\018")
_aXC9y = Wherigo.ZInput(_uaHVu)
_aXC9y.Id = "12aa455c-fd47-4a03-a95b-e0cca9afa629"
_aXC9y.Name = _9x_("\050\065\084")
_aXC9y.Description = ""
_aXC9y.Visible = true
_aXC9y.Media = _3KMHQ
_aXC9y.Choices = {
	"1853", 
	"1854", 
	"1855", 
	"1856"
}
_aXC9y.InputType = "MultipleChoice"
_aXC9y.Text = _9x_("\007\074\120\072\085\083\072\060\066\100\100\100\066\074\060\029\066\097\088\120\109\083\086\086\066\097\080\028\083\060\017\083\066\043\074\088\083\066\111\083\109\083\066\072\060\066\084\080\028\080\086\033\066\110\063\066\018\018\018\018\018\018")
_tqPe = Wherigo.ZInput(_uaHVu)
_tqPe.Id = "de5eb118-afe8-40b5-b35a-4ecba0183846"
_tqPe.Name = _9x_("\050\110\084")
_tqPe.Description = ""
_tqPe.Visible = true
_tqPe.Media = _3KMHQ
_tqPe.Choices = {
	"1", 
	"2", 
	"3", 
	"4"
}
_tqPe.InputType = "MultipleChoice"
_tqPe.Text = _9x_("\077\083\109\083\066\017\086\066\111\072\119\066\088\080\043\111\066\111\083\066\057\083\060\043\111\083\086\066\017\060\066\033\111\083\066\043\017\109\043\085\083\066\072\121\066\028\109\083\083\060\083\109\081\008")
_KJu = Wherigo.ZInput(_uaHVu)
_KJu.Id = "c5fbde3e-40f9-425f-ae82-3e809f322a58"
_KJu.Name = _9x_("\050\110\097")
_KJu.Description = ""
_KJu.Visible = true
_KJu.Media = _3KMHQ
_KJu.Choices = {
	"1", 
	"2", 
	"3", 
	"4"
}
_KJu.InputType = "MultipleChoice"
_KJu.Text = _9x_("\084\098\080\017\066\083\086\066\085\072\066\088\080\043\111\072\066\098\080\083\066\085\072\086\066\057\074\060\043\072\086\066\083\060\066\083\085\066\043\017\109\043\080\085\072\066\029\083\066\103\083\028\083\033\074\043\017\072\060\008")
_Xsd = Wherigo.ZInput(_uaHVu)
_Xsd.Id = "ccaadf8f-c22c-4189-9fc1-506cdea74c52"
_Xsd.Name = _9x_("\050\091\097")
_Xsd.Description = ""
_Xsd.Visible = true
_Xsd.Media = _3KMHQ
_Xsd.Choices = {
	"Secoya", 
	"Roble", 
	"Thuja", 
	"Plano"
}
_Xsd.InputType = "MultipleChoice"
_Xsd.Text = _9x_("\084\098\080\017\066\083\086\033\074\060\066\074\085\066\121\109\083\060\033\083\066\029\083\066\080\060\066\074\109\057\072\085\066\060\072\033\074\057\085\083\018\066\086\074\066\080\060\066\018\018\018")
__OJT = Wherigo.ZInput(_uaHVu)
__OJT.Id = "9580c1e5-dc6f-4682-b1d4-9201b7e0aa0b"
__OJT.Name = _9x_("\050\091\084")
__OJT.Description = ""
__OJT.Visible = true
__OJT.Media = _3KMHQ
__OJT.Choices = {
	"Sequoia", 
	"Oak", 
	"Thuja", 
	"Plane"
}
__OJT.InputType = "MultipleChoice"
__OJT.Text = _9x_("\077\083\109\083\066\081\072\080\066\074\109\083\066\017\060\066\121\109\072\060\033\066\072\121\066\074\066\109\083\088\074\109\095\074\057\085\083\066\033\109\083\083\018\066\100\033\066\086\074\066\072\060\083\066\018\018\018")
_R5vD = Wherigo.ZInput(_uaHVu)
_R5vD.Id = "8376ca40-3d80-4618-b069-7d782178e6b9"
_R5vD.Name = _9x_("\050\108\084")
_R5vD.Description = ""
_R5vD.Visible = true
_R5vD.Media = _3KMHQ
_R5vD.Choices = {
	"GALILEO", 
	"POPAS", 
	"DEPART"
}
_R5vD.InputType = "MultipleChoice"
_R5vD.Text = _9x_("\077\083\109\083\066\017\086\066\074\066\086\043\080\085\120\033\080\109\083\066\088\074\029\083\066\008\008\057\081\066\084\088\074\029\083\072\066\042\074\057\017\060\072\018\066\041\111\017\086\066\119\072\109\095\066\086\066\060\074\088\083\008")
_azk = Wherigo.ZInput(_uaHVu)
_azk.Id = "07a69313-e2da-48b1-ab17-2a8aa4014cd2"
_azk.Name = _9x_("\050\108\097")
_azk.Description = ""
_azk.Visible = true
_azk.Media = _3KMHQ
_azk.Choices = {
	"GALILEO", 
	"POPAS", 
	"DEPART"
}
_azk.InputType = "MultipleChoice"
_azk.Text = _9x_("\084\098\080\017\066\083\086\033\074\066\080\060\074\066\083\086\043\080\085\033\080\109\074\066\029\083\066\084\088\074\029\083\072\066\042\074\057\017\060\072\018\066\097\086\033\074\066\072\057\109\074\066\086\066\060\072\088\057\109\083\008")
_mFRn = Wherigo.ZInput(_uaHVu)
_mFRn.Id = "7124c7e3-4ed3-428a-851f-b5c434070f70"
_mFRn.Name = _9x_("\050\006\097")
_mFRn.Description = ""
_mFRn.Visible = true
_mFRn.Media = _3KMHQ
_mFRn.Choices = {
	"2", 
	"3", 
	"4"
}
_mFRn.InputType = "MultipleChoice"
_mFRn.Text = _9x_("\001\072\057\109\083\066\085\074\066\120\017\083\029\109\074\066\029\083\085\074\060\033\083\066\029\083\066\080\086\033\083\029\062\066\008\043\072\088\072\066\086\074\109\043\072\121\074\028\072\086\066\088\083\109\072\103\017\060\028\017\072\086\008")
_rI8F = Wherigo.ZInput(_uaHVu)
_rI8F.Id = "dffec770-9954-441a-b935-43407d17f792"
_rI8F.Name = _9x_("\050\006\084")
_rI8F.Description = ""
_rI8F.Visible = true
_rI8F.Media = _3KMHQ
_rI8F.Choices = {
	"2", 
	"3", 
	"4"
}
_rI8F.InputType = "MultipleChoice"
_rI8F.Text = _9x_("\046\060\066\033\111\083\066\086\033\072\060\083\066\017\060\066\121\109\072\060\033\066\072\121\066\081\072\080\066\111\072\119\066\029\072\066\081\072\080\066\075\083\109\072\103\017\060\028\017\074\060\066\086\074\109\043\072\120\111\074\028\017\008")
_bAPHN = Wherigo.ZInput(_uaHVu)
_bAPHN.Id = "c1de978d-4fb8-4b8f-8dc8-21e08ac2e324"
_bAPHN.Name = _9x_("\050\069\084")
_bAPHN.Description = ""
_bAPHN.Visible = true
_bAPHN.Media = _3KMHQ
_bAPHN.Choices = {
	"TRUE", 
	"FALSE"
}
_bAPHN.InputType = "MultipleChoice"
_bAPHN.Text = _9x_("\041\111\083\066\085\083\028\083\060\029\066\072\121\066\001\074\017\060\033\066\042\109\074\033\032\090\087\101\033\111\017\086\066\086\043\080\085\120\033\080\109\083\066\072\121\066\036\083\033\083\109\066\040\074\086\033\017\085\085\072\080")
_PJCg = Wherigo.ZInput(_uaHVu)
_PJCg.Id = "f9767ac2-c312-4f97-8544-346e481e2561"
_PJCg.Name = _9x_("\050\069\097")
_PJCg.Description = ""
_PJCg.Visible = true
_PJCg.Media = _3KMHQ
_PJCg.Choices = {
	"VERDADERO", 
	"FALSO"
}
_PJCg.InputType = "MultipleChoice"
_PJCg.Text = _9x_("\115\074\066\085\083\081\083\060\029\074\066\029\083\085\066\001\074\017\060\033\066\042\109\074\033\032\090\087\101\083\086\033\074\066\083\086\043\080\085\033\080\109\074\066\029\083\066\036\083\029\109\072\066\040\074\086\033\017\085\085\072\080")
_hBe = Wherigo.ZInput(_uaHVu)
_hBe.Id = "727745d9-1ace-4987-8d22-d351692dacda"
_hBe.Name = _9x_("\050\065\116\097")
_hBe.Description = ""
_hBe.Visible = true
_hBe.Media = _3KMHQ
_hBe.Choices = {
	"938", 
	"948", 
	"958", 
	"968"
}
_hBe.InputType = "MultipleChoice"
_hBe.Text = _9x_("\084\098\080\017\066\083\060\066\083\085\066\033\083\109\088\017\060\074\085\066\083\060\066\083\085\066\043\074\088\017\060\072\066\029\083\066\084\109\085\083\086\062\066\001\074\017\060\033\055\044\074\043\098\080\083\086\066\029\083\066\040\072\088\120\072\086\033\083\085\074\066\083\086\033\074\066\074\066\095\017\085\072\088\083\033\109\072\086\066\029\083\066\043\080\074\060\033\072\086\008")
_rEj1a = Wherigo.ZInput(_uaHVu)
_rEj1a.Id = "64f4967b-dc6c-4edc-9e74-f102ba5336c5"
_rEj1a.Name = _9x_("\050\065\116\084")
_rEj1a.Description = ""
_rEj1a.Visible = true
_rEj1a.Media = _3KMHQ
_rEj1a.Choices = {
	"938", 
	"948", 
	"958", 
	"968"
}
_rEj1a.InputType = "MultipleChoice"
_rEj1a.Text = _9x_("\077\083\109\083\066\072\060\066\033\111\083\066\033\083\109\088\017\060\074\085\066\017\060\066\033\111\083\066\119\074\081\066\072\121\066\084\109\085\083\086\066\001\074\017\060\033\066\044\074\043\098\080\083\086\066\029\083\066\040\072\088\120\072\086\033\083\085\074\066\017\086\066\111\072\119\066\088\074\060\081\066\095\017\085\072\088\083\033\083\109\086\008")
_Q5nw = Wherigo.ZInput(_uaHVu)
_Q5nw.Id = "ef0d2dba-44cd-459b-86be-8038fcff20dd"
_Q5nw.Name = _9x_("\050\065\065\084")
_Q5nw.Description = ""
_Q5nw.Visible = true
_Q5nw.Media = _3KMHQ
_Q5nw.Choices = {
	"1755", 
	"1768", 
	"1772", 
	"1775"
}
_Q5nw.InputType = "MultipleChoice"
_Q5nw.Text = _9x_("\077\083\109\083\066\033\111\083\109\083\066\017\086\066\033\111\083\066\043\109\072\086\086\066\072\121\066\040\072\080\060\033\066\084\109\057\072\109\083\018\066\100\033\066\119\074\086\066\057\080\017\085\033\066\017\060\066\119\111\074\033\066\081\083\074\109\008")
_uJSX8 = Wherigo.ZInput(_uaHVu)
_uJSX8.Id = "21054e1f-cfb0-4d71-9eba-7c0ba6a9f5c8"
_uJSX8.Name = _9x_("\050\065\065\097")
_uJSX8.Description = ""
_uJSX8.Visible = true
_uJSX8.Media = _3KMHQ
_uJSX8.Choices = {
	"1755", 
	"1768", 
	"1772", 
	"1775"
}
_uJSX8.InputType = "MultipleChoice"
_uJSX8.Text = _9x_("\084\098\080\017\066\039\060\057\086\120\024\083\086\066\085\074\066\043\109\080\048\066\029\083\085\066\043\072\060\029\083\066\074\109\057\072\085\083\086\018\066\118\080\083\066\043\072\060\086\033\109\080\017\029\072\066\083\060\066\098\080\083\066\074\060\072\008")
_iTS = Wherigo.ZInput(_uaHVu)
_iTS.Id = "6c980947-54d7-486a-8425-d18ac1f80022"
_iTS.Name = _9x_("\050\065\110\084")
_iTS.Description = ""
_iTS.Visible = true
_iTS.Media = _3KMHQ
_iTS.Choices = {
	"TRUE", 
	"FALSE"
}
_iTS.InputType = "MultipleChoice"
_iTS.Text = _9x_("\077\083\109\083\066\028\072\083\086\066\033\111\083\066\042\087\117\108\063")
_cxS = Wherigo.ZInput(_uaHVu)
_cxS.Id = "feb3262c-cd0c-432f-90fb-cb4d25614cef"
_cxS.Name = _9x_("\050\065\110\097")
_cxS.Description = ""
_cxS.Visible = true
_cxS.Media = _3KMHQ
_cxS.Choices = {
	"VERDADERO", 
	"FALSO"
}
_cxS.InputType = "MultipleChoice"
_cxS.Text = _9x_("\084\098\080\017\066\103\074\066\085\074\066\042\087\117\108\063")

-- WorksWithList for object commands --

-- functions --
function _uaHVu:OnStart()
	_lDz:MoveTo(Player)
	Wherigo.ShowScreen(Wherigo.DETAILSCREEN, _lDz)
end
function _uaHVu:OnRestore()
end
function _lrkA:OnEnter()
	if Wherigo.NoCaseEquals(_LA5, _9x_("\065")) then
		_Urwigo.RunDialogs(function()
			Wherigo.GetInput(_Xk0G)
		end)
		_lrkA.Active = false
		_lrkA.Visible = false
		_UyA0L.Active = true
		_UyA0L.Visible = true
		_uaHVu:RequestSync()
	elseif Wherigo.NoCaseEquals(_LA5, _9x_("\110")) then
		_Urwigo.RunDialogs(function()
			Wherigo.GetInput(_2FLd)
		end)
		_lrkA.Active = false
		_lrkA.Visible = false
		_UyA0L.Active = true
		_UyA0L.Visible = true
		_uaHVu:RequestSync()
	elseif Wherigo.NoCaseEquals(_LA5, _9x_("\063")) then
		_Urwigo.RunDialogs(function()
			Wherigo.GetInput(_aXC9y)
		end)
		_lrkA.Active = false
		_lrkA.Visible = false
		_UyA0L.Active = true
		_UyA0L.Visible = true
		_uaHVu:RequestSync()
	end
end
function _UyA0L:OnEnter()
	if Wherigo.NoCaseEquals(_LA5, _9x_("\065")) then
		_Urwigo.RunDialogs(function()
			Wherigo.GetInput(_1_G1F)
		end)
		_UyA0L.Active = false
		_UyA0L.Active = false
		_CoJZ.Active = true
		_CoJZ.Visible = true
		_uaHVu:RequestSync()
	elseif Wherigo.NoCaseEquals(_LA5, _9x_("\110")) then
		_Urwigo.RunDialogs(function()
			Wherigo.GetInput(_KJu)
		end)
		_UyA0L.Active = false
		_UyA0L.Active = false
		_CoJZ.Active = true
		_CoJZ.Visible = true
		_uaHVu:RequestSync()
	elseif Wherigo.NoCaseEquals(_LA5, _9x_("\063")) then
		_Urwigo.RunDialogs(function()
			Wherigo.GetInput(_tqPe)
		end)
		_UyA0L.Visible = false
		_UyA0L.Active = false
		_CoJZ.Active = true
		_CoJZ.Visible = true
		_uaHVu:RequestSync()
	end
end
function _CoJZ:OnEnter()
	if Wherigo.NoCaseEquals(_LA5, _9x_("\110")) then
		_Urwigo.Dialog(false, {
			{
				Text = _9x_("\084\098\080\017\066\083\086\033\074\066\083\085\066\103\017\028\083\060\033\083\066\043\074\043\111\083\066\042\040\065\004\117\077\102\066\115\083\066\036\074\109\043\066\036\072\088\088\083\066\032\090\087\101\036\074\109\074\066\074\081\080\029\074\109\085\083\066\074\066\086\120\072\017\085\083\109\066\121\072\033\072\066\083\086\033\074\066\083\060\066\033\080\066\017\060\103\083\060\033\074\109\017\072"), 
				Media = _3KMHQ
			}
		}, function(action)
			_nd8:MoveTo(Player)
			_CoJZ.Visible = false
			_CoJZ.Active = false
			_vbVLq.Active = true
			_vbVLq.Visible = true
		end)
	elseif Wherigo.NoCaseEquals(_LA5, _9x_("\063")) then
		_Urwigo.Dialog(false, {
			{
				Text = _9x_("\077\083\109\083\066\017\086\066\033\111\083\066\083\053\017\086\033\017\060\028\066\043\074\043\111\083\066\042\040\065\004\117\077\102\066\115\083\066\036\074\109\043\066\036\072\088\088\083\066\032\090\087\101\041\072\066\111\083\085\120\066\081\072\080\066\120\017\043\033\080\109\083\066\086\120\072\017\085\083\109\066\017\086\066\017\060\066\081\072\080\109\066\017\060\103\083\060\033\072\109\081"), 
				Media = _3KMHQ
			}
		}, function(action)
			_nd8:MoveTo(Player)
			_CoJZ.Visible = false
			_CoJZ.Active = false
			_vbVLq.Active = true
			_vbVLq.Visible = true
		end)
	elseif Wherigo.NoCaseEquals(_LA5, _9x_("\065")) then
		_Urwigo.Dialog(false, {
			{
				Text = _9x_("\100\043\017\066\086\083\066\033\109\072\080\103\083\066\085\074\066\043\074\043\111\083\066\083\053\017\086\033\074\060\033\083\066\042\040\065\004\117\077\102\066\039\060\057\086\120\024\115\083\066\036\074\109\043\066\036\072\088\088\083\066\018\032\090\087\101\036\072\080\109\066\103\072\080\086\066\074\017\029\083\109\066\080\060\083\066\120\111\072\033\072\066\086\120\072\017\085\083\109\066\086\083\066\033\109\072\080\103\083\066\029\074\060\086\066\103\072\033\109\083\066\017\060\103\083\060\033\074\017\109\083"), 
				Media = _3KMHQ
			}
		}, function(action)
			_nd8:MoveTo(Player)
			_CoJZ.Visible = false
			_CoJZ.Active = false
			_vbVLq.Active = true
			_vbVLq.Visible = true
		end)
	end
	_uaHVu:RequestSync()
end
function _vbVLq:OnEnter()
	_nd8.Visible = false
	if Wherigo.NoCaseEquals(_LA5, _9x_("\065")) then
		_Urwigo.RunDialogs(function()
			Wherigo.GetInput(_2TGp)
		end)
		_j2O.Active = true
		_j2O.Visible = true
		_vbVLq.Active = false
		_vbVLq.Visible = false
	elseif Wherigo.NoCaseEquals(_LA5, _9x_("\110")) then
		_Urwigo.RunDialogs(function()
			Wherigo.GetInput(_Xsd)
		end)
		_j2O.Active = true
		_j2O.Visible = true
		_vbVLq.Active = false
		_vbVLq.Visible = false
	elseif Wherigo.NoCaseEquals(_LA5, _9x_("\063")) then
		_Urwigo.RunDialogs(function()
			Wherigo.GetInput(__OJT)
		end)
		_j2O.Active = true
		_j2O.Visible = true
		_vbVLq.Active = false
		_vbVLq.Visible = false
	end
	_uaHVu:RequestSync()
end
function _j2O:OnEnter()
	if Wherigo.NoCaseEquals(_LA5, _9x_("\065")) then
		_Urwigo.RunDialogs(function()
			Wherigo.GetInput(_dZ07)
		end)
		_j2O.Active = false
		_j2O.Visible = false
		_VA7WF.Active = true
		_VA7WF.Visible = true
	elseif Wherigo.NoCaseEquals(_LA5, _9x_("\110")) then
		_Urwigo.RunDialogs(function()
			Wherigo.GetInput(_azk)
		end)
		_j2O.Active = false
		_j2O.Visible = false
		_VA7WF.Active = true
		_VA7WF.Visible = true
	elseif Wherigo.NoCaseEquals(_LA5, _9x_("\063")) then
		_Urwigo.RunDialogs(function()
			Wherigo.GetInput(_R5vD)
		end)
		_j2O.Active = false
		_j2O.Visible = false
		_VA7WF.Active = true
		_VA7WF.Visible = true
	end
	_uaHVu:RequestSync()
end
function _VA7WF:OnEnter()
	if Wherigo.NoCaseEquals(_LA5, _9x_("\065")) then
		if (((_zKGs == 1854) and (_uOkf5 == 2)) and Wherigo.NoCaseEquals(_jNe, _9x_("\041\111\080\081\074"))) and Wherigo.NoCaseEquals(_LJi4T, _9x_("\042\084\115\100\115\097\046")) then
			_Urwigo.Dialog(false, {
				{
					Text = _9x_("\090\109\074\103\072\066\103\072\080\086\066\074\103\083\048\066\057\017\083\060\066\109\083\120\072\060\029\080\066\074\066\033\072\080\033\083\086\066\085\083\086\066\098\080\083\086\033\017\072\060\086\066\039\060\057\086\120\024\083\033\066\103\072\080\086\066\120\072\080\103\083\048\066\074\085\085\083\109\066\074\066\085\074\066\109\083\043\111\083\109\043\111\083\066\029\083\066\085\074\066\043\074\043\111\083\066\088\081\086\033\083\109\081\066\054\066\042\040\110\004\040\075\036\066\122\036\074\109\043\066\036\072\088\088\083\066\122"), 
					Media = _3KMHQ
				}
			}, function(action)
				_VA7WF.Active = false
				_VA7WF.Visible = false
				_vvt.Active = true
				_vvt.Visible = true
			end)
		else
			_Urwigo.MessageBox{
				Text = _9x_("\004\083\086\072\085\083\066\103\072\080\086\066\074\103\083\048\066\074\080\066\088\072\017\060\086\066\080\060\083\066\109\083\120\072\060\086\083\066\029\083\066\121\074\080\086\086\083\066\083\033\066\017\085\066\103\072\080\086\066\121\074\080\033\066\109\083\043\072\088\088\083\060\043\083\109\066\085\074\066\043\074\109\033\072\080\043\111\083\066"), 
				Media = _3KMHQ
			}
			_VA7WF.Active = false
			_VA7WF.Visible = false
			_lrkA.Visible = true
			_lrkA.Active = true
		end
	elseif Wherigo.NoCaseEquals(_LA5, _9x_("\110")) then
		if (((_zKGs == 1854) and (_uOkf5 == 2)) and Wherigo.NoCaseEquals(_jNe, _9x_("\041\111\080\076\074"))) and Wherigo.NoCaseEquals(_LJi4T, _9x_("\042\084\115\100\115\097\046")) then
			_Urwigo.Dialog(false, {
				{
					Text = _9x_("\097\060\111\072\109\074\057\080\083\060\074\066\098\080\083\066\111\074\081\074\066\043\072\060\033\083\086\033\074\029\072\066\033\072\029\074\086\066\085\074\086\066\120\109\083\028\080\060\033\074\086\066\081\066\086\083\066\120\080\083\029\083\066\017\109\066\083\060\066\057\080\086\043\074\066\029\083\085\066\088\017\086\033\083\109\081\066\039\060\057\086\120\024\043\074\043\111\083\054\066\042\040\110\004\040\075\036\066\122\036\074\109\043\066\036\072\088\088\083\122"), 
					Media = _3KMHQ
				}
			}, function(action)
				_VA7WF.Active = false
				_VA7WF.Visible = false
				_vvt.Active = true
				_vvt.Visible = true
			end)
		else
			_Urwigo.Dialog(false, {
				{
					Text = _9x_("\115\072\066\086\017\083\060\033\072\066\098\080\083\066\111\074\081\074\066\074\085\066\088\083\060\072\086\066\080\060\074\066\109\083\086\120\080\083\086\033\074\066\017\060\043\072\109\109\083\043\033\074\066\081\066\029\083\057\083\066\109\083\017\060\017\043\017\074\109\066\083\085\066\119\111\083\109\017\028\072\032\090\087\101"), 
					Media = _3KMHQ
				}
			}, function(action)
				_VA7WF.Visible = false
				_lrkA.Active = true
				_lrkA.Visible = true
				_VA7WF.Active = false
			end)
		end
	elseif Wherigo.NoCaseEquals(_LA5, _9x_("\063")) then
		if (((_zKGs == 1854) and (_uOkf5 == 2)) and Wherigo.NoCaseEquals(_jNe, _9x_("\041\111\080\076\074"))) and Wherigo.NoCaseEquals(_LJi4T, _9x_("\042\084\115\100\115\097\046")) then
			_Urwigo.Dialog(false, {
				{
					Text = _9x_("\040\072\060\028\109\074\033\080\085\074\033\017\072\060\086\066\081\072\080\066\111\074\103\083\066\074\060\086\119\083\109\083\029\066\074\085\085\066\033\111\083\066\098\080\083\086\033\017\072\060\086\066\074\060\029\066\081\072\080\066\043\074\060\066\028\072\066\017\060\066\086\083\074\109\043\111\066\072\121\066\111\017\029\029\083\060\066\088\081\086\033\083\109\081\054\066\042\040\110\004\040\075\036\066\122\036\074\109\043\066\036\072\088\088\083\122"), 
					Media = _3KMHQ
				}
			}, function(action)
				_VA7WF.Active = false
				_VA7WF.Visible = false
				_vvt.Active = true
				_vvt.Visible = true
			end)
		else
			_Urwigo.MessageBox{
				Text = _9x_("\001\072\109\109\081\066\081\072\080\066\111\074\103\083\066\074\033\066\085\083\074\086\033\066\072\060\083\066\074\060\086\119\083\109\066\119\109\072\060\028\066\074\060\029\066\081\072\080\066\088\080\086\033\066\109\083\086\033\074\109\033\066\033\111\083\066\043\074\109\033\109\017\029\028\083"), 
				Media = _3KMHQ
			}
		end
	end
end
function _vvt:OnEnter()
	if Wherigo.NoCaseEquals(_LA5, _9x_("\065")) then
		_Urwigo.Dialog(false, {
			{
				Text = _9x_("\115\074\066\043\074\043\111\083\066\083\086\033\066\033\072\080\033\083\066\120\109\072\043\111\083\018\018\018\018\018\018"), 
				Media = _3KMHQ
			}, 
			{
				Text = _9x_("\014\060\083\066\121\072\017\066\085\074\066\043\074\043\111\083\066\029\083\043\072\080\103\083\109\033\083\066\017\085\066\121\074\080\029\109\074\066\103\072\080\086\066\109\083\060\029\109\083\066\074\080\053\066\043\072\072\109\029\072\060\060\083\083\086\066\086\080\017\103\074\060\033\083\066\120\072\080\109\066\121\017\060\017\109\066\085\074\066\043\074\109\033\072\080\043\111\083\066\032\090\087\101\007\066\039\060\057\086\120\024\091\063\018\065\065\018\110\108\110\066\039\060\057\086\120\024\035\066\039\060\057\086\120\024\116\116\116\066\063\117\018\069\108\065\032\090\087\101"), 
				Media = _3KMHQ
			}
		}, function(action)
			_vvt.Active = false
			_vvt.Visible = false
			_TW3A.Active = true
			_TW3A.Visible = true
			_uaHVu:RequestSync()
		end)
	elseif Wherigo.NoCaseEquals(_LA5, _9x_("\110")) then
		_Urwigo.Dialog(false, {
			{
				Text = _9x_("\097\085\066\043\074\043\111\083\066\083\086\033\074\066\043\083\109\043\074\018"), 
				Media = _3KMHQ
			}, 
			{
				Text = _9x_("\014\060\066\029\083\086\043\080\057\109\017\088\017\083\060\033\072\066\043\074\043\111\083\066\029\083\066\085\074\066\121\083\066\017\109\074\066\074\066\085\074\066\086\017\028\080\017\083\060\033\083\066\029\017\109\083\043\043\017\072\060\066\120\074\109\074\066\033\083\109\088\017\060\074\109\066\083\085\066\043\074\109\033\080\043\111\072\032\090\087\101\007\066\091\063\018\065\065\018\110\108\110\066\035\066\116\116\116\066\063\117\066\069\108\065\032\090\087\101"), 
				Media = _3KMHQ
			}
		}, function(action)
			_vvt.Active = false
			_vvt.Visible = false
			_TW3A.Active = true
			_TW3A.Visible = true
			_uaHVu:RequestSync()
		end)
	elseif Wherigo.NoCaseEquals(_LA5, _9x_("\063")) then
		_Urwigo.Dialog(false, {
			{
				Text = _9x_("\041\111\083\066\043\074\043\111\083\066\017\086\066\060\083\074\109\057\081\018"), 
				Media = _3KMHQ
			}, 
			{
				Text = _9x_("\084\066\121\074\017\033\111\066\043\074\043\111\083\066\029\017\086\043\072\103\083\109\081\066\017\033\066\119\017\085\085\066\028\072\066\033\072\066\033\111\083\066\074\029\029\109\083\086\086\066\057\083\085\072\119\066\033\072\066\121\017\060\017\086\111\066\033\111\083\066\043\074\109\033\109\017\029\028\083\032\090\087\101\007\066\091\063\018\065\065\018\110\108\110\066\035\066\116\116\116\066\063\117\066\069\108\065\032\090\087\101"), 
				Media = _3KMHQ
			}
		}, function(action)
			_vvt.Active = false
			_vvt.Visible = false
			_TW3A.Active = true
			_TW3A.Visible = true
			_uaHVu:RequestSync()
		end)
	end
end
function _vvt:OnProximity()
	if Wherigo.NoCaseEquals(_LA5, _9x_("\065")) then
		_Urwigo.Dialog(false, {
			{
				Text = _9x_("\032\090\087\101\103\072\080\086\066\074\109\109\017\103\083\048\066\033\072\080\033\066\120\109\083\086\066\029\083\066\085\074\066\043\074\043\111\083\066\083\033\066\080\060\083\066\120\111\072\033\072\066\086\120\072\017\085\083\109\066\086\083\066\033\109\072\080\103\083\066\029\074\060\086\066\103\072\033\109\083\066\017\060\103\083\060\033\074\017\109\083"), 
				Media = _3KMHQ
			}
		}, function(action)
			_CTJXE:MoveTo(Player)
		end)
	elseif Wherigo.NoCaseEquals(_LA5, _9x_("\063")) then
		_Urwigo.Dialog(false, {
			{
				Text = _9x_("\032\090\087\101\081\072\080\066\028\083\033\066\060\083\074\109\066\074\060\081\066\072\121\066\033\111\083\066\043\074\043\111\083\066\074\060\029\066\074\066\120\111\072\033\072\066\086\120\072\017\085\083\109\066\017\086\066\017\060\066\081\072\080\109\066\017\060\103\083\060\033\072\109\081"), 
				Media = _3KMHQ
			}
		}, function(action)
			_CTJXE:MoveTo(Player)
		end)
	elseif Wherigo.NoCaseEquals(_LA5, _9x_("\110")) then
		_Urwigo.Dialog(false, {
			{
				Text = _9x_("\032\090\087\101\033\083\066\074\043\083\109\098\080\083\086\066\074\066\043\080\074\085\098\080\017\083\109\074\066\029\083\066\085\074\066\088\083\088\072\109\017\074\066\043\074\043\111\083\066\081\066\080\060\066\074\085\083\109\072\060\066\121\072\033\072\066\083\086\033\074\066\083\060\066\033\080\066\017\060\103\083\060\033\074\109\017\072"), 
				Media = _3KMHQ
			}
		}, function(action)
			_CTJXE:MoveTo(Player)
		end)
	end
end
function _TW3A:OnEnter()
	_CTJXE.Visible = false
	if Wherigo.NoCaseEquals(_LA5, _9x_("\065")) then
		_Urwigo.RunDialogs(function()
			Wherigo.GetInput(_s2S)
		end)
		_TW3A.Active = false
		_TW3A.Visible = false
		_ZvLdj.Active = true
		_ZvLdj.Visible = true
		_uaHVu:RequestSync()
	elseif Wherigo.NoCaseEquals(_LA5, _9x_("\110")) then
		_Urwigo.RunDialogs(function()
			Wherigo.GetInput(_mFRn)
		end)
		_TW3A.Active = false
		_TW3A.Visible = false
		_ZvLdj.Active = true
		_ZvLdj.Visible = true
		_uaHVu:RequestSync()
	elseif Wherigo.NoCaseEquals(_LA5, _9x_("\063")) then
		_Urwigo.RunDialogs(function()
			Wherigo.GetInput(_rI8F)
		end)
		_TW3A.Active = false
		_TW3A.Visible = false
		_ZvLdj.Active = true
		_ZvLdj.Visible = true
		_uaHVu:RequestSync()
	end
end
function _ZvLdj:OnEnter()
	if Wherigo.NoCaseEquals(_LA5, _9x_("\065")) then
		_Urwigo.RunDialogs(function()
			Wherigo.GetInput(_6WA9G)
		end)
		_ZvLdj.Active = false
		_ZvLdj.Visible = false
		_ghLPr.Active = true
		_ghLPr.Visible = true
		_uaHVu:RequestSync()
	elseif Wherigo.NoCaseEquals(_LA5, _9x_("\110")) then
		_Urwigo.RunDialogs(function()
			Wherigo.GetInput(_PJCg)
		end)
		_ZvLdj.Active = false
		_ZvLdj.Visible = false
		_ghLPr.Active = true
		_ghLPr.Visible = true
		_uaHVu:RequestSync()
	elseif Wherigo.NoCaseEquals(_LA5, _9x_("\063")) then
		_Urwigo.RunDialogs(function()
			Wherigo.GetInput(_bAPHN)
		end)
		_ZvLdj.Active = false
		_ZvLdj.Visible = false
		_ghLPr.Active = true
		_ghLPr.Visible = true
		_uaHVu:RequestSync()
	end
end
function _ghLPr:OnEnter()
	_uaHVu:RequestSync()
	if Wherigo.NoCaseEquals(_LA5, _9x_("\065")) then
		_Urwigo.RunDialogs(function()
			Wherigo.GetInput(_PIPb)
		end)
		_ghLPr.Active = false
		_ghLPr.Visible = false
		_yfh.Active = true
		_yfh.Visible = true
		_uaHVu:RequestSync()
	elseif Wherigo.NoCaseEquals(_LA5, _9x_("\110")) then
		_Urwigo.RunDialogs(function()
			Wherigo.GetInput(_hBe)
		end)
		_ghLPr.Active = false
		_ghLPr.Visible = false
		_yfh.Active = true
		_yfh.Visible = true
		_uaHVu:RequestSync()
	elseif Wherigo.NoCaseEquals(_LA5, _9x_("\063")) then
		_Urwigo.RunDialogs(function()
			Wherigo.GetInput(_rEj1a)
		end)
		_ghLPr.Active = false
		_ghLPr.Visible = false
		_yfh.Active = true
		_yfh.Visible = true
		_uaHVu:RequestSync()
	end
end
function _yfh:OnEnter()
	if Wherigo.NoCaseEquals(_LA5, _9x_("\065")) then
		_Urwigo.RunDialogs(function()
			Wherigo.GetInput(_WFf)
		end)
		_yfh.Active = false
		_yfh.Visible = false
		_tX3.Active = true
		_tX3.Visible = true
		_uaHVu:RequestSync()
	elseif Wherigo.NoCaseEquals(_LA5, _9x_("\110")) then
		_Urwigo.RunDialogs(function()
			Wherigo.GetInput(_uJSX8)
		end)
		_yfh.Active = false
		_yfh.Visible = false
		_tX3.Active = true
		_tX3.Visible = true
		_uaHVu:RequestSync()
	elseif Wherigo.NoCaseEquals(_LA5, _9x_("\063")) then
		_Urwigo.RunDialogs(function()
			Wherigo.GetInput(_Q5nw)
		end)
		_yfh.Active = false
		_yfh.Visible = false
		_tX3.Active = true
		_tX3.Visible = true
		_uaHVu:RequestSync()
	end
end
function _tX3:OnEnter()
	if Wherigo.NoCaseEquals(_LA5, _9x_("\065")) then
		_Urwigo.RunDialogs(function()
			Wherigo.GetInput(_og8y)
		end)
		_tX3.Active = false
		_tX3.Visible = false
		_9Fmgv.Active = true
		_9Fmgv.Visible = true
		_uaHVu:RequestSync()
	elseif Wherigo.NoCaseEquals(_LA5, _9x_("\110")) then
		_Urwigo.RunDialogs(function()
			Wherigo.GetInput(_cxS)
		end)
		_tX3.Active = false
		_tX3.Visible = false
		_9Fmgv.Active = true
		_9Fmgv.Visible = true
		_uaHVu:RequestSync()
	elseif Wherigo.NoCaseEquals(_LA5, _9x_("\063")) then
		_Urwigo.RunDialogs(function()
			Wherigo.GetInput(_iTS)
		end)
		_tX3.Active = false
		_tX3.Visible = false
		_9Fmgv.Active = true
		_9Fmgv.Visible = true
		_uaHVu:RequestSync()
	end
end
function _9Fmgv:OnEnter()
	if Wherigo.NoCaseEquals(_LA5, _9x_("\065")) then
		if ((((_fuo == 948) and (_Kee == 2)) and Wherigo.NoCaseEquals(_dYzV, _9x_("\102\087\084\100"))) and (_X55S == 1768)) and Wherigo.NoCaseEquals(_htk, _9x_("\102\087\084\100")) then
			_Urwigo.Dialog(false, {
				{
					Text = _9x_("\090\109\074\103\072\066\103\072\080\086\066\074\103\083\048\066\057\017\083\060\066\109\083\120\072\060\029\080\066\074\066\033\072\080\033\083\086\066\085\083\086\066\098\080\083\086\033\017\072\060\086\066\039\060\057\086\120\024\083\033\066\103\072\080\086\066\120\072\080\103\083\048\066\074\085\085\083\109\066\074\066\085\074\066\109\083\043\111\083\109\043\111\083\066\029\083\066\085\074\066\043\074\043\111\083"), 
					Media = _3KMHQ
				}
			}, function(action)
				_9Fmgv.Active = false
				_9Fmgv.Visible = false
				_4qn.Active = true
				_4qn.Visible = true
				_Ptv:MoveTo(Player)
			end)
		else
			_Urwigo.MessageBox{
				Text = _9x_("\004\083\086\072\085\083\066\103\072\080\086\066\074\103\083\048\066\074\080\066\088\072\017\060\086\066\080\060\083\066\109\083\120\072\060\086\083\066\029\083\066\121\074\080\086\086\083\066\083\033\066\017\085\066\103\072\080\086\066\121\074\080\033\066\109\083\043\072\088\088\083\060\043\083\109\066\085\074\066\043\074\109\033\072\080\043\111\083\066"), 
				Media = _3KMHQ
			}
			_9Fmgv.Active = false
			_9Fmgv.Visible = false
			_TW3A.Active = true
			_TW3A.Visible = true
		end
		_uaHVu:RequestSync()
	elseif Wherigo.NoCaseEquals(_LA5, _9x_("\110")) then
		if ((((_fuo == 948) and (_Kee == 2)) and Wherigo.NoCaseEquals(_dYzV, _9x_("\102\097\087\004\084\004\097\087\046"))) and (_X55S == 1768)) and Wherigo.NoCaseEquals(_htk, _9x_("\102\097\087\004\084\004\097\087\046")) then
			_Urwigo.Dialog(false, {
				{
					Text = _9x_("\097\060\111\072\109\074\057\080\083\060\074\066\098\080\083\066\111\074\081\074\066\043\072\060\033\083\086\033\074\029\072\066\033\072\029\074\086\066\085\074\086\066\120\109\083\028\080\060\033\074\086\066\081\066\086\083\066\120\080\083\029\083\066\017\109\066\083\060\066\057\080\086\043\074\066\029\083\066\085\074\066\088\083\088\072\109\017\074\066\043\074\043\111\083"), 
					Media = _3KMHQ
				}
			}, function(action)
				_9Fmgv.Active = false
				_9Fmgv.Visible = false
				_4qn.Active = true
				_4qn.Visible = true
				_Ptv:MoveTo(Player)
			end)
		elseif _TW3A.Visible then
			_Urwigo.MessageBox{
				Text = _9x_("\115\072\066\086\017\083\060\033\072\066\098\080\083\066\111\074\081\074\066\074\085\066\088\083\060\072\086\066\080\060\074\066\109\083\086\120\080\083\086\033\074\066\017\060\043\072\109\109\083\043\033\074\066\081\066\029\083\057\083\066\109\083\017\060\017\043\017\074\109\066\083\085\066\043\074\109\033\080\043\111\072"), 
				Media = _3KMHQ
			}
			_TW3A.Active = true
			_TW3A.Visible = true
			_9Fmgv.Active = false
			_9Fmgv.Visible = false
		end
		_uaHVu:RequestSync()
	elseif Wherigo.NoCaseEquals(_LA5, _9x_("\063")) then
		if ((((_fuo == 948) and (_Kee == 2)) and Wherigo.NoCaseEquals(_dYzV, _9x_("\041\087\014\097"))) and (_X55S == 1768)) and Wherigo.NoCaseEquals(_htk, _9x_("\041\087\014\097")) then
			_Urwigo.Dialog(false, {
				{
					Text = _9x_("\040\072\060\028\109\074\033\080\085\074\033\017\072\060\086\066\081\072\080\066\111\074\103\083\066\074\060\086\119\083\109\083\029\066\074\085\085\066\033\111\083\066\098\080\083\086\033\017\072\060\086\066\074\060\029\066\081\072\080\066\043\074\060\066\028\072\066\017\060\066\086\083\074\109\043\111\066\072\121\066\033\111\083\066\043\074\043\111\083\032\090\087\101"), 
					Media = _3KMHQ
				}
			}, function(action)
				_9Fmgv.Active = false
				_9Fmgv.Visible = false
				_4qn.Active = true
				_4qn.Visible = true
				_Ptv:MoveTo(Player)
			end)
		else
			_Urwigo.MessageBox{
				Text = _9x_("\001\072\109\109\081\066\081\072\080\066\111\074\103\083\066\074\033\066\085\083\074\086\033\066\072\060\083\066\074\060\086\119\083\109\066\119\109\072\060\028\066\074\060\029\066\081\072\080\066\088\080\086\033\066\109\083\086\033\074\109\033\066\033\111\083\066\043\074\109\033\109\017\029\028\083"), 
				Media = _3KMHQ
			}
			_9Fmgv.Active = false
			_9Fmgv.Visible = false
			_TW3A.Active = true
			_TW3A.Visible = true
		end
		_uaHVu:RequestSync()
	end
end
function _4qn:OnEnter()
	if Wherigo.NoCaseEquals(_LA5, _9x_("\065")) then
		_Urwigo.Dialog(false, {
			{
				Text = _9x_("\066\014\060\066\017\060\029\017\043\083\066\086\083\066\033\109\072\080\103\083\066\029\074\060\086\066\103\072\033\109\083\066\017\060\103\083\060\033\074\017\109\083"), 
				Media = _3KMHQ
			}, 
			{
				Text = _9x_("\040\111\083\109\043\111\083\048\066\057\017\083\060\066\085\074\066\043\074\043\111\083\066\060\107\083\086\033\066\120\074\086\066\033\109\083\086\066\085\072\017\060\066"), 
				Media = _3KMHQ
			}
		}, function(action)
			_4qn.Active = false
			_4qn.Visible = false
			_Jju.Active = true
			_Jju.Visible = true
			_uaHVu:RequestSync()
		end)
	elseif Wherigo.NoCaseEquals(_LA5, _9x_("\110")) then
		_Urwigo.Dialog(false, {
			{
				Text = _9x_("\014\060\074\066\120\017\086\033\074\066\083\086\033\074\066\083\060\066\083\085\066\017\060\103\083\060\033\074\109\017\072"), 
				Media = _3KMHQ
			}, 
			{
				Text = _9x_("\075\017\109\074\066\057\017\083\060\066\085\074\066\043\074\043\111\083\066\060\072\066\083\086\033\074\066\088\080\081\066\085\083\076\072\086"), 
				Media = _3KMHQ
			}
		}, function(action)
			_4qn.Active = false
			_4qn.Visible = false
			_Jju.Active = true
			_Jju.Visible = true
			_uaHVu:RequestSync()
		end)
	elseif Wherigo.NoCaseEquals(_LA5, _9x_("\063")) then
		_Urwigo.Dialog(false, {
			{
				Text = _9x_("\084\066\043\085\080\083\066\017\086\066\017\060\066\081\072\080\109\066\017\060\103\083\060\033\072\109\081"), 
				Media = _3KMHQ
			}, 
			{
				Text = _9x_("\115\072\072\095\066\119\083\085\085\066\033\111\083\066\043\074\043\111\083\066\017\086\066\060\072\033\066\103\083\109\081\066\121\074\109"), 
				Media = _3KMHQ
			}
		}, function(action)
			_4qn.Active = false
			_4qn.Visible = false
			_Jju.Active = true
			_Jju.Visible = true
			_uaHVu:RequestSync()
		end)
	end
end
function _Jju:OnEnter()
	if Wherigo.NoCaseEquals(_LA5, _9x_("\110")) then
		_uaHVu.Complete = true
		_Urwigo.OldDialog{
			{
				Text = _9x_("\097\060\066\083\085\066\088\083\060\086\074\076\083\062\066\120\072\109\066\121\074\103\072\109\066\033\083\060\028\074\066\083\060\066\043\080\083\060\033\074\066\098\080\083\066\074\085\028\080\060\074\086\066\029\083\066\085\074\086\066\120\017\086\033\074\086\066\120\074\109\074\066\109\083\086\072\085\103\083\109\066\083\085\066\083\060\017\028\088\074\066\029\083\066\085\074\066\043\074\043\111\083\066\029\083\066\057\072\060\017\121\017\043\074\043\017\072\060\066\035\111\083\109\017\028\072\066\042\040\110\118\084\065\113\066\035\111\083\109\017\028\072\066\118\085\074\060\083\109\017\083\086\066\009\066\057\072\060\080\086\066\009\066"), 
				Media = _3KMHQ
			}, 
			{
				Text = _9x_("\065\116\066\039\060\057\086\120\024\036\100\113\014\097\066\018\066\102\066\040\046\097\014\087\066\018\066\084\001\066\039\060\057\086\120\024\040\084\087\087\097\084\014\018\066\084\001\066\039\060\057\086\120\024\041\087\097\118\115\097\066\032\090\087\101\069\066\039\060\057\086\120\024\041\087\097\118\115\097\066\018\084\001\066\039\060\057\086\120\024\041\087\097\118\115\097\066\018\065\116\066\039\060\057\086\120\024\036\100\113\014\097\066\018\102\066\039\060\057\086\120\024\040\084\087\087\097\084\014\018\032\090\087\101\066\102\066\039\060\057\086\120\024\036\100\113\014\097\018\066\102\066\039\060\057\086\120\024\040\084\087\087\097\084\014\066\018\066\069\066\041\087\097\118\115\097\066\084\001\066\039\060\057\086\120\024\036\100\113\014\097\066\018\032\090\087\101\066\087\066\039\060\057\086\120\024\041\087\097\118\115\097\066\018\065\116\066\039\060\057\086\120\024\041\087\097\118\115\097\066\018\102\066\041\087\097\118\115\097\066\018\066\102\066\036\100\113\014\097\018\066\069\066\041\087\097\118\115\097\032\090\087\101\084\066\036\100\113\014\097\018\066\065\116\066\039\060\057\086\120\024\040\084\087\087\097\084\014\066\018\066\087\066\039\060\057\086\120\024\041\087\097\118\115\097\018\066\065\116\066\039\060\057\086\120\024\036\100\113\014\097\066\018\066\102\066\039\060\057\086\120\024\040\046\097\014\087"), 
				Media = _3KMHQ
			}, 
			{
				Text = _9x_("\086\017\066\060\072\066\111\074\060\066\060\072\033\074\029\072\066\074\098\080\017\066\029\083\066\060\080\083\103\072\066\085\072\086\066\017\060\029\017\043\083\086\032\090\087\101\032\090\087\101\065\116\066\039\060\057\086\120\024\036\100\113\014\097\066\018\066\102\066\040\046\097\014\087\066\018\066\084\001\066\039\060\057\086\120\024\040\084\087\087\097\084\014\018\066\084\001\066\039\060\057\086\120\024\041\087\097\118\115\097\066\032\090\087\101\069\066\039\060\057\086\120\024\041\087\097\118\115\097\066\018\084\001\066\039\060\057\086\120\024\041\087\097\118\115\097\066\018\065\116\066\039\060\057\086\120\024\036\100\113\014\097\066\018\102\066\039\060\057\086\120\024\040\084\087\087\097\084\014\018\032\090\087\101\066\102\066\039\060\057\086\120\024\036\100\113\014\097\018\066\102\066\039\060\057\086\120\024\040\084\087\087\097\084\014\066\018\066\069\066\041\087\097\118\115\097\066\084\001\066\039\060\057\086\120\024\036\100\113\014\097\066\018\032\090\087\101\066\087\066\039\060\057\086\120\024\041\087\097\118\115\097\066\018\065\116\066\039\060\057\086\120\024\041\087\097\118\115\097\066\018\102\066\041\087\097\118\115\097\066\018\066\102\066\036\100\113\014\097\018\066\069\066\041\087\097\118\115\097\032\090\087\101\084\066\036\100\113\014\097\018\066\065\116\066\039\060\057\086\120\024\040\084\087\087\097\084\014\066\018\066\087\066\039\060\057\086\120\024\041\087\097\118\115\097\018\066\065\116\066\039\060\057\086\120\024\036\100\113\014\097\066\018\066\102\066\039\060\057\086\120\024\040\046\097\014\087"), 
				Media = _3KMHQ
			}, 
			{
				Text = _9x_("\042\109\074\043\017\074\086\066\120\072\109\066\086\083\028\080\017\109\088\083\066\074\066\085\072\066\085\074\109\028\072\066\029\083\066\085\074\066\043\074\088\017\060\074\033\074\062\066\083\085\066\043\074\109\033\080\043\111\072\066\029\083\066\074\111\072\109\074\062\066\028\080\074\109\029\083\066\081\066\043\017\083\109\109\083"), 
				Media = _3KMHQ
			}
		}
	elseif Wherigo.NoCaseEquals(_LA5, _9x_("\065")) then
		_uaHVu.Complete = true
		_Urwigo.OldDialog{
			{
				Text = _9x_("\004\074\060\086\066\085\083\066\088\083\086\086\074\028\083\066\086\080\017\103\074\060\033\066\060\072\033\083\048\066\057\017\083\060\066\043\083\033\033\083\066\120\074\109\033\017\083\066\029\083\086\066\017\060\029\017\043\083\086\066\120\072\080\109\066\109\083\086\072\080\029\109\083\066\085\107\083\060\017\028\088\083\066\029\083\066\085\074\066\043\074\043\111\083\066\054\066\042\040\110\118\084\065\113\066\035\111\083\109\017\028\072\066\118\085\074\060\083\109\017\083\086\066\009\066\057\072\060\080\086\066\009\066"), 
				Media = _3KMHQ
			}, 
			{
				Text = _9x_("\065\116\066\039\060\057\086\120\024\036\100\113\014\097\066\018\066\102\066\040\046\097\014\087\066\018\066\084\001\066\039\060\057\086\120\024\040\084\087\087\097\084\014\018\066\084\001\066\039\060\057\086\120\024\041\087\097\118\115\097\066\032\090\087\101\069\066\039\060\057\086\120\024\041\087\097\118\115\097\066\018\084\001\066\039\060\057\086\120\024\041\087\097\118\115\097\066\018\065\116\066\039\060\057\086\120\024\036\100\113\014\097\066\018\102\066\039\060\057\086\120\024\040\084\087\087\097\084\014\018\032\090\087\101\066\102\066\039\060\057\086\120\024\036\100\113\014\097\018\066\102\066\039\060\057\086\120\024\040\084\087\087\097\084\014\066\018\066\069\066\041\087\097\118\115\097\066\084\001\066\039\060\057\086\120\024\036\100\113\014\097\066\018\032\090\087\101\066\087\066\039\060\057\086\120\024\041\087\097\118\115\097\066\018\065\116\066\039\060\057\086\120\024\041\087\097\118\115\097\066\018\102\066\041\087\097\118\115\097\066\018\066\102\066\036\100\113\014\097\018\066\069\066\041\087\097\118\115\097\032\090\087\101\084\066\036\100\113\014\097\018\066\065\116\066\039\060\057\086\120\024\040\084\087\087\097\084\014\066\018\066\087\066\039\060\057\086\120\024\041\087\097\118\115\097\018\066\065\116\066\039\060\057\086\120\024\036\100\113\014\097\066\018\066\102\066\039\060\057\086\120\024\040\046\097\014\087\032\090\087\101\032\090\087\101"), 
				Media = _3KMHQ
			}, 
			{
				Text = _9x_("\086\017\066\103\072\080\086\066\074\103\083\048\066\088\074\085\066\060\072\033\083\066\103\072\017\043\017\066\029\083\066\060\072\080\103\083\074\080\066\039\060\057\086\120\024\085\083\086\066\017\060\029\017\043\083\086\066\032\090\087\101\032\090\087\101\065\116\066\039\060\057\086\120\024\036\100\113\014\097\066\018\066\102\066\040\046\097\014\087\066\018\066\084\001\066\039\060\057\086\120\024\040\084\087\087\097\084\014\018\066\084\001\066\039\060\057\086\120\024\041\087\097\118\115\097\066\032\090\087\101\069\066\039\060\057\086\120\024\041\087\097\118\115\097\066\018\084\001\066\039\060\057\086\120\024\041\087\097\118\115\097\066\018\065\116\066\039\060\057\086\120\024\036\100\113\014\097\066\018\102\066\039\060\057\086\120\024\040\084\087\087\097\084\014\018\032\090\087\101\066\102\066\039\060\057\086\120\024\036\100\113\014\097\018\066\102\066\039\060\057\086\120\024\040\084\087\087\097\084\014\066\018\066\069\066\041\087\097\118\115\097\066\084\001\066\039\060\057\086\120\024\036\100\113\014\097\066\018\032\090\087\101\066\087\066\039\060\057\086\120\024\041\087\097\118\115\097\066\018\065\116\066\039\060\057\086\120\024\041\087\097\118\115\097\066\018\102\066\041\087\097\118\115\097\066\018\066\102\066\036\100\113\014\097\018\066\069\066\041\087\097\118\115\097\032\090\087\101\084\066\036\100\113\014\097\018\066\065\116\066\039\060\057\086\120\024\040\084\087\087\097\084\014\066\018\066\087\066\039\060\057\086\120\024\041\087\097\118\115\097\018\066\065\116\066\039\060\057\086\120\024\036\100\113\014\097\066\018\066\102\066\039\060\057\086\120\024\040\046\097\014\087"), 
				Media = _3KMHQ
			}, 
			{
				Text = _9x_("\044\083\066\103\072\080\086\066\109\083\088\083\109\043\017\083\066\029\083\066\088\107\074\103\072\017\109\066\086\080\017\103\017\066\033\072\080\033\066\074\080\066\085\072\060\028\066\029\083\066\043\083\033\033\083\066\120\109\072\088\083\060\074\029\083\066\062\066\088\074\017\060\033\083\060\074\060\033\066\085\074\066\043\074\109\033\072\080\043\111\083\066\103\074\066\086\083\066\086\074\080\103\083\028\074\109\029\083\109\066\083\033\066\086\083\066\121\083\109\088\083\109"), 
				Media = _3KMHQ
			}
		}
	elseif Wherigo.NoCaseEquals(_LA5, _9x_("\063")) then
		_uaHVu.Complete = true
		_Urwigo.OldDialog{
			{
				Text = _9x_("\100\060\066\033\111\083\066\088\083\086\086\074\028\083\066\120\085\083\074\086\083\066\060\072\033\083\066\033\111\074\033\066\086\072\088\083\066\072\121\066\033\111\083\066\043\085\080\083\086\066\033\072\066\086\072\085\103\083\066\033\111\083\066\109\017\029\029\085\083\066\072\121\066\033\111\083\066\040\074\043\111\083\066\035\111\083\109\017\028\072\066\042\040\110\118\084\065\113\066\009\066\035\111\083\109\017\028\072\066\118\085\074\060\083\109\017\083\086\066\057\072\060\080\086\066\009\066"), 
				Media = _3KMHQ
			}, 
			{
				Text = _9x_("\065\116\066\039\060\057\086\120\024\036\100\113\014\097\066\018\066\102\066\040\046\097\014\087\066\018\066\084\001\066\039\060\057\086\120\024\040\084\087\087\097\084\014\018\066\084\001\066\039\060\057\086\120\024\041\087\097\118\115\097\066\032\090\087\101\069\066\039\060\057\086\120\024\041\087\097\118\115\097\066\018\084\001\066\039\060\057\086\120\024\041\087\097\118\115\097\066\018\065\116\066\039\060\057\086\120\024\036\100\113\014\097\066\018\102\066\039\060\057\086\120\024\040\084\087\087\097\084\014\018\032\090\087\101\066\102\066\039\060\057\086\120\024\036\100\113\014\097\018\066\102\066\039\060\057\086\120\024\040\084\087\087\097\084\014\066\018\066\069\066\041\087\097\118\115\097\066\084\001\066\039\060\057\086\120\024\036\100\113\014\097\066\018\032\090\087\101\066\087\066\039\060\057\086\120\024\041\087\097\118\115\097\066\018\065\116\066\039\060\057\086\120\024\041\087\097\118\115\097\066\018\102\066\041\087\097\118\115\097\066\018\066\102\066\036\100\113\014\097\018\066\069\066\041\087\097\118\115\097\032\090\087\101\084\066\036\100\113\014\097\018\066\065\116\066\039\060\057\086\120\024\040\084\087\087\097\084\014\066\018\066\087\066\039\060\057\086\120\024\041\087\097\118\115\097\018\066\065\116\066\039\060\057\086\120\024\036\100\113\014\097\066\018\066\102\066\039\060\057\086\120\024\040\046\097\014\087\032\090\087\101\032\090\087\101"), 
				Media = _3KMHQ
			}, 
			{
				Text = _9x_("\017\121\066\081\072\080\066\111\074\103\083\066\060\072\033\066\060\072\033\083\029\066\111\083\109\083\066\074\028\074\017\060\066\017\060\029\017\043\083\086\032\090\087\101\032\090\087\101\065\116\066\039\060\057\086\120\024\036\100\113\014\097\066\018\066\102\066\040\046\097\014\087\066\018\066\084\001\066\039\060\057\086\120\024\040\084\087\087\097\084\014\018\066\084\001\066\039\060\057\086\120\024\041\087\097\118\115\097\066\032\090\087\101\069\066\039\060\057\086\120\024\041\087\097\118\115\097\066\018\084\001\066\039\060\057\086\120\024\041\087\097\118\115\097\066\018\065\116\066\039\060\057\086\120\024\036\100\113\014\097\066\018\102\066\039\060\057\086\120\024\040\084\087\087\097\084\014\018\032\090\087\101\066\102\066\039\060\057\086\120\024\036\100\113\014\097\018\066\102\066\039\060\057\086\120\024\040\084\087\087\097\084\014\066\018\066\069\066\041\087\097\118\115\097\066\084\001\066\039\060\057\086\120\024\036\100\113\014\097\066\018\032\090\087\101\066\087\066\039\060\057\086\120\024\041\087\097\118\115\097\066\018\065\116\066\039\060\057\086\120\024\041\087\097\118\115\097\066\018\102\066\041\087\097\118\115\097\066\018\066\102\066\036\100\113\014\097\018\066\069\066\041\087\097\118\115\097\032\090\087\101\084\066\036\100\113\014\097\018\066\065\116\066\039\060\057\086\120\024\040\084\087\087\097\084\014\066\018\066\087\066\039\060\057\086\120\024\041\087\097\118\115\097\018\066\065\116\066\039\060\057\086\120\024\036\100\113\014\097\066\018\066\102\066\039\060\057\086\120\024\040\046\097\014\087"), 
				Media = _3KMHQ
			}, 
			{
				Text = _9x_("\041\111\074\060\095\066\081\072\080\066\121\072\109\066\121\072\085\085\072\119\017\060\028\066\088\083\066\033\111\109\072\080\028\111\072\080\033\066\033\111\083\066\119\074\085\095\062\066\033\111\083\066\043\074\109\033\109\017\029\028\083\066\119\017\085\085\066\060\072\119\066\086\074\103\083\066\074\060\029\066\043\085\072\086\083"), 
				Media = _3KMHQ
			}
		}
	end
	Wherigo.Command "SaveClose"
end
function _Xk0G:OnGetInput(input)
	if input == nil then
		input = ""
	end
	_zKGs = tonumber(input)
end
function _1_G1F:OnGetInput(input)
	if input == nil then
		input = ""
	end
	_uOkf5 = tonumber(input)
end
function _2TGp:OnGetInput(input)
	if input == nil then
		input = ""
	end
	_jNe = input
end
function _dZ07:OnGetInput(input)
	if input == nil then
		input = ""
	end
	_LJi4T = input
end
function _s2S:OnGetInput(input)
	if input == nil then
		input = ""
	end
	_Kee = tonumber(input)
end
function _6WA9G:OnGetInput(input)
	if input == nil then
		input = ""
	end
	_dYzV = input
end
function _PIPb:OnGetInput(input)
	if input == nil then
		input = ""
	end
	_fuo = 948
end
function _WFf:OnGetInput(input)
	if input == nil then
		input = ""
	end
	_X55S = tonumber(input)
end
function _og8y:OnGetInput(input)
	if input == nil then
		input = ""
	end
	_htk = input
end
function _2FLd:OnGetInput(input)
	if input == nil then
		input = ""
	end
	_zKGs = tonumber(input)
end
function _aXC9y:OnGetInput(input)
	if input == nil then
		input = ""
	end
end
function _tqPe:OnGetInput(input)
	if input == nil then
		input = ""
	end
	_uOkf5 = tonumber(input)
end
function _KJu:OnGetInput(input)
	if input == nil then
		input = ""
	end
	_uOkf5 = tonumber(input)
end
function _Xsd:OnGetInput(input)
	if input == nil then
		input = ""
	end
	_jNe = input
end
function __OJT:OnGetInput(input)
	if input == nil then
		input = ""
	end
	_jNe = input
end
function _R5vD:OnGetInput(input)
	if input == nil then
		input = ""
	end
	_LJi4T = input
end
function _azk:OnGetInput(input)
	if input == nil then
		input = ""
	end
	_LJi4T = input
end
function _mFRn:OnGetInput(input)
	if input == nil then
		input = ""
	end
	_Kee = tonumber(input)
end
function _rI8F:OnGetInput(input)
	if input == nil then
		input = ""
	end
	_Kee = tonumber(input)
end
function _bAPHN:OnGetInput(input)
	if input == nil then
		input = ""
	end
	_dYzV = input
end
function _PJCg:OnGetInput(input)
	if input == nil then
		input = ""
	end
	_dYzV = input
end
function _hBe:OnGetInput(input)
	if input == nil then
		input = ""
	end
	_fuo = 948
end
function _rEj1a:OnGetInput(input)
	if input == nil then
		input = ""
	end
	_fuo = 948
end
function _Q5nw:OnGetInput(input)
	if input == nil then
		input = ""
	end
	_X55S = tonumber(input)
end
function _uJSX8:OnGetInput(input)
	if input == nil then
		input = ""
	end
	_X55S = tonumber(input)
end
function _iTS:OnGetInput(input)
	if input == nil then
		input = ""
	end
	_htk = input
end
function _cxS:OnGetInput(input)
	if input == nil then
		input = ""
	end
	_htk = input
end
function _lDz:On_aB9uj(target)
	_LA5 = _9x_("\063")
	_Urwigo.Dialog(false, {
		{
			Text = _9x_("\090\083\121\072\109\083\066\086\033\074\109\033\017\060\028\066\033\111\017\086\066\043\074\109\033\109\017\029\028\083\066\081\072\080\066\090\109\017\060\028\066\074\066\120\074\120\083\109\066\074\060\029\066\074\066\120\083\060\043\017\085\066\033\072\066\119\109\017\033\083\066\029\072\119\060\066\033\111\083\066\080\060\085\072\043\095\066\043\072\029\083\066\121\072\109\066\033\111\017\086\066\043\074\109\033\109\017\029\028\083\066\074\060\029\066\043\085\080\083\086\066\033\072\066\086\072\085\103\083\066\033\111\083\066\111\017\029\029\083\060\066\057\072\060\080\086\054\066\039\060\057\086\120\024\042\040\110\118\084\065\113\066\035\111\083\109\017\028\072\066\118\085\074\060\083\109\017\083\086\066\009\066\057\072\060\080\086\066\009\066"), 
			Media = _3KMHQ
		}
	}, function(action)
		_lrkA.Active = true
		_lrkA.Visible = true
		_lDz.Visible = false
	end)
end
function _lDz:On_Sca2(target)
	_LA5 = _9x_("\065")
	_Urwigo.Dialog(false, {
		{
			Text = _9x_("\084\103\074\060\033\066\029\083\066\043\072\088\088\083\060\043\083\109\066\043\083\033\033\083\066\043\074\109\033\072\080\043\111\083\066\088\080\060\017\086\086\083\048\066\103\072\080\086\066\029\107\080\060\066\120\074\120\017\083\109\066\083\033\066\029\107\080\060\066\043\109\074\081\072\060\066\120\072\080\109\066\060\072\033\083\109\066\085\083\066\043\072\029\083\066\029\083\066\029\083\103\083\109\072\080\017\085\085\074\028\083\066\029\083\066\043\083\033\033\083\066\043\074\109\033\072\080\043\111\083\066\083\033\066\085\083\086\066\017\060\029\017\043\083\086\066\074\121\017\060\066\029\083\066\109\083\086\072\080\029\109\083\066\085\074\066\043\074\043\111\083\066\057\072\060\080\086\066\054\066\042\040\110\118\084\065\113\066\035\111\083\109\017\028\072\066\118\085\074\060\083\109\017\083\086\066\009\066\057\072\060\080\086\066\009\066"), 
			Media = _3KMHQ
		}
	}, function(action)
		_lrkA.Visible = true
		_lrkA.Active = true
		_lDz.Visible = false
	end)
end
function _lDz:On_KfiTT(target)
	_LA5 = _9x_("\110")
	_Urwigo.Dialog(false, {
		{
			Text = _9x_("\084\060\033\083\086\066\029\083\066\043\072\088\083\060\048\074\109\066\083\086\033\083\066\043\074\109\033\080\043\111\072\066\098\080\083\066\033\109\074\083\109\066\080\060\066\120\074\120\083\085\066\081\066\080\060\066\085\074\120\017\048\066\120\074\109\074\066\083\086\043\109\017\057\017\109\066\083\085\066\043\072\029\017\028\072\066\029\083\066\029\083\086\057\085\072\098\080\083\072\066\120\074\109\074\066\083\086\033\083\066\043\074\109\033\080\043\111\072\066\081\066\120\017\086\033\074\086\066\120\074\109\074\066\109\083\086\072\085\103\083\109\066\083\085\066\057\072\060\080\086\066\072\043\080\085\033\072\086\054\066\039\060\057\086\120\024\009\066\042\040\110\118\084\065\113\066\035\111\083\109\017\028\072\066\118\085\074\060\083\109\017\083\086\066\009\066\057\072\060\080\086\066\009\066"), 
			Media = _3KMHQ
		}
	}, function(action)
		_lrkA.Visible = true
		_lrkA.Active = true
		_lDz.Visible = false
	end)
end

-- Begin user functions --
-- End Urwigo functions --
-- End user functions --
return _uaHVu
