﻿require "Wherigo"
ZonePoint = Wherigo.ZonePoint
Distance = Wherigo.Distance
Player = Wherigo.Player

-- String decode --
function _eqwc(str)
	local res = ""
    local dtable = "\050\085\047\068\056\040\060\082\125\120\038\081\041\013\107\052\103\099\093\102\025\001\051\022\078\121\010\067\070\031\123\110\033\088\016\020\075\035\045\046\119\062\089\014\101\109\006\059\106\042\058\011\009\117\074\079\029\026\057\065\049\071\036\021\018\007\044\072\112\104\098\054\002\094\027\030\055\096\084\023\063\000\095\066\003\061\076\032\005\077\053\048\124\019\086\043\090\092\105\087\126\118\008\116\122\024\108\034\080\113\015\064\091\083\114\073\012\100\115\069\097\028\111\004\037\017\039"
	for i=1, #str do
        local b = str:byte(i)
        if b > 0 and b <= 0x7F then
	        res = res .. string.char(dtable:byte(b))
        else
            res = res .. string.char(b)
        end
	end
	return res
end

-- Internal functions --
require "table"
require "math"

math.randomseed(os.time())
math.random()
math.random()
math.random()

_Urwigo = {}

_Urwigo.InlineRequireLoaded = {}
_Urwigo.InlineRequireRes = {}
_Urwigo.InlineRequire = function(moduleName)
  local res
  if _Urwigo.InlineRequireLoaded[moduleName] == nil then
    res = _Urwigo.InlineModuleFunc[moduleName]()
    _Urwigo.InlineRequireLoaded[moduleName] = 1
    _Urwigo.InlineRequireRes[moduleName] = res
  else
    res = _Urwigo.InlineRequireRes[moduleName]
  end
  return res
end

_Urwigo.Round = function(num, idp)
  local mult = 10^(idp or 0)
  return math.floor(num * mult + 0.5) / mult
end

_Urwigo.Ceil = function(num, idp)
  local mult = 10^(idp or 0)
  return math.ceil(num * mult) / mult
end

_Urwigo.Floor = function(num, idp)
  local mult = 10^(idp or 0)
  return math.floor(num * mult) / mult
end

_Urwigo.DialogQueue = {}
_Urwigo.RunDialogs = function(callback)
	local dialogs = _Urwigo.DialogQueue
	local lastCallback = nil
	_Urwigo.DialogQueue = {}
	local msgcb = {}
	msgcb = function(action)
		if action ~= nil then
			if lastCallback ~= nil then
				lastCallback(action)
			end
			local entry = table.remove(dialogs, 1)
			if entry ~= nil then
				lastCallback = entry.Callback;
				if entry.Text ~= nil then
					Wherigo.MessageBox({Text = entry.Text, Media=entry.Media, Buttons=entry.Buttons, Callback=msgcb})
				else
					msgcb(action)
				end
			else
				if callback ~= nil then
					callback()
				end
			end
		end
	end
	msgcb(true) -- any non-null argument
end

_Urwigo.MessageBox = function(tbl)
    _Urwigo.RunDialogs(function() Wherigo.MessageBox(tbl) end)
end

_Urwigo.OldDialog = function(tbl)
    _Urwigo.RunDialogs(function() Wherigo.Dialog(tbl) end)
end

_Urwigo.Dialog = function(buffered, tbl, callback)
	for k,v in ipairs(tbl) do
		table.insert(_Urwigo.DialogQueue, v)
	end
	if callback ~= nil then
		table.insert(_Urwigo.DialogQueue, {Callback=callback})
	end
	if not buffered then
		_Urwigo.RunDialogs(nil)
	end
end

_Urwigo.Hash = function(str)
   local b = 378551;
   local a = 63689;
   local hash = 0;
   for i = 1, #str, 1 do
      hash = hash*a+string.byte(str,i);
      hash = math.fmod(hash, 65535)
      a = a*b;
      a = math.fmod(a, 65535)
   end
   return hash;
end

_Urwigo.DaysInMonth = {
	31,
	28,
	31,
	30,
	31,
	30,
	31,
	31,
	30,
	31,
	30,
	31,
}

_Urwigo_Date_IsLeapYear = function(year)
	if year % 400 == 0 then
		return true
	elseif year% 100 == 0 then
		return false
	elseif year % 4 == 0 then
		return true
	else
		return false
	end
end

_Urwigo.Date_DaysInMonth = function(year, month)
	if month ~= 2 then
		return _Urwigo.DaysInMonth[month];
	else
		if _Urwigo_Date_IsLeapYear(year) then
			return 29
		else
			return 28
		end
	end
end

_Urwigo.Date_DayInYear = function(t)
	local res = t.day
	for month = 1, t.month - 1 do
		res = res + _Urwigo.Date_DaysInMonth(t.year, month)
	end
	return res
end

_Urwigo.Date_HourInWeek = function(t)
	return t.hour + (t.wday-1) * 24
end

_Urwigo.Date_HourInMonth = function(t)
	return t.hour + t.day * 24
end

_Urwigo.Date_HourInYear = function(t)
	return t.hour + (_Urwigo.Date_DayInYear(t) - 1) * 24
end

_Urwigo.Date_MinuteInDay = function(t)
	return t.min + t.hour * 60
end

_Urwigo.Date_MinuteInWeek = function(t)
	return t.min + t.hour * 60 + (t.wday-1) * 1440;
end

_Urwigo.Date_MinuteInMonth = function(t)
	return t.min + t.hour * 60 + (t.day-1) * 1440;
end

_Urwigo.Date_MinuteInYear = function(t)
	return t.min + t.hour * 60 + (_Urwigo.Date_DayInYear(t) - 1) * 1440;
end

_Urwigo.Date_SecondInHour = function(t)
	return t.sec + t.min * 60
end

_Urwigo.Date_SecondInDay = function(t)
	return t.sec + t.min * 60 + t.hour * 3600
end

_Urwigo.Date_SecondInWeek = function(t)
	return t.sec + t.min * 60 + t.hour * 3600 + (t.wday-1) * 86400
end

_Urwigo.Date_SecondInMonth = function(t)
	return t.sec + t.min * 60 + t.hour * 3600 + (t.day-1) * 86400
end

_Urwigo.Date_SecondInYear = function(t)
	return t.sec + t.min * 60 + t.hour * 3600 + (_Urwigo.Date_DayInYear(t)-1) * 86400
end


-- Inlined modules --
_Urwigo.InlineModuleFunc = {}

cartMaxlamenace = Wherigo.ZCartridge()

-- Media --
zmediaDbarquement = Wherigo.ZMedia(cartMaxlamenace)
zmediaDbarquement.Id = "ce7a5677-d9cf-4e3e-9da8-9fead5fe46bd"
zmediaDbarquement.Name = _eqwc("\004\195\169\071\121\115\110\054\045\046\045\032\104")
zmediaDbarquement.Description = _eqwc("\046\045\118\099\121")
zmediaDbarquement.AltText = ""
zmediaDbarquement.Resources = {
	{
		Type = "jpg", 
		Filename = "66cad272-47bb-44e7-aed1-181d6dcc231f.jpg", 
		Directives = {}
	}
}
zmediapasserllle = Wherigo.ZMedia(cartMaxlamenace)
zmediapasserllle.Id = "29698956-3f45-45be-a9e5-dc20c398966b"
zmediapasserllle.Name = _eqwc("\069\121\119\119\045\115\045\107\107\045")
zmediapasserllle.Description = _eqwc("\046\045\118\099\121")
zmediapasserllle.AltText = ""
zmediapasserllle.Resources = {
	{
		Type = "jpg", 
		Filename = "IMG_20140605_213414.jpg", 
		Directives = {}
	}
}
zmediabataille = Wherigo.ZMedia(cartMaxlamenace)
zmediabataille.Id = "f652c1ea-8a4a-4f74-84f5-ec760175af1a"
zmediabataille.Name = _eqwc("\071\121\104\121\099\107\107\045")
zmediabataille.Description = _eqwc("\046\045\118\099\121")
zmediabataille.AltText = ""
zmediabataille.Resources = {
	{
		Type = "jpg", 
		Filename = "6119dfc4-4f10-4543-ab68-ca3ce69da7ef.jpg", 
		Directives = {}
	}
}
zmedialabelle = Wherigo.ZMedia(cartMaxlamenace)
zmedialabelle.Id = "75b9e965-a334-4aed-b4d3-ece4126edd39"
zmedialabelle.Name = _eqwc("\107\121\088\071\045\107\107\045")
zmedialabelle.Description = _eqwc("\046\045\118\099\121")
zmedialabelle.AltText = ""
zmedialabelle.Resources = {
	{
		Type = "jpg", 
		Filename = "c053b4c8-685c-4c8c-a136-ab218f0a7991.jpg", 
		Directives = {}
	}
}
zmediaFeudartifice = Wherigo.ZMedia(cartMaxlamenace)
zmediaFeudartifice.Id = "e4d1cb53-425b-4c80-8d08-b12e6a933e6f"
zmediaFeudartifice.Name = _eqwc("\029\045\054\088\118\127\121\115\104\099\020\099\018\045")
zmediaFeudartifice.Description = _eqwc("\046\045\118\099\121")
zmediaFeudartifice.AltText = ""
zmediaFeudartifice.Resources = {
	{
		Type = "jpg", 
		Filename = "eb640685-507c-4647-9332-706ea93c46ca.jpg", 
		Directives = {}
	}
}
zmediaentete = Wherigo.ZMedia(cartMaxlamenace)
zmediaentete.Id = "4e3e190e-62f0-4207-996f-12a2fd52f2ca"
zmediaentete.Name = _eqwc("\045\032\104\045\104\045")
zmediaentete.Description = _eqwc("\046\045\118\099\121")
zmediaentete.AltText = ""
zmediaentete.Resources = {
	{
		Type = "jpg", 
		Filename = "poster-pirate.jpg", 
		Directives = {}
	}
}
zmediaepee = Wherigo.ZMedia(cartMaxlamenace)
zmediaepee.Id = "6d08c52c-35f4-4c1e-9cfa-4268919e69b8"
zmediaepee.Name = _eqwc("\045\069\045\045")
zmediaepee.Description = _eqwc("\046\045\118\099\121")
zmediaepee.AltText = ""
zmediaepee.Resources = {
	{
		Type = "jpg", 
		Filename = "af218dd3-f831-443f-8831-ce398f93b42f.jpg", 
		Directives = {}
	}
}
zmediapirateenfete = Wherigo.ZMedia(cartMaxlamenace)
zmediapirateenfete.Id = "f9e12e1c-cf87-4da6-9bb6-a705a10fcbde"
zmediapirateenfete.Name = _eqwc("\069\099\115\121\104\045\088\045\032\088\020\045\104\045")
zmediapirateenfete.Description = _eqwc("\046\045\118\099\121")
zmediapirateenfete.AltText = ""
zmediapirateenfete.Resources = {
	{
		Type = "jpg", 
		Filename = "pirates.jpg", 
		Directives = {}
	}
}
zmediatrsor = Wherigo.ZMedia(cartMaxlamenace)
zmediatrsor.Id = "f78c642c-045f-44a0-8833-e0cbebcc2467"
zmediatrsor.Name = _eqwc("\104\115\195\169\119\123\115")
zmediatrsor.Description = _eqwc("\046\045\118\099\121")
zmediatrsor.AltText = ""
zmediatrsor.Resources = {
	{
		Type = "jpg", 
		Filename = "tresor.jpg", 
		Directives = {}
	}
}
_abc = Wherigo.ZMedia(cartMaxlamenace)
_abc.Id = "e544cbc8-b506-4e1e-ab8b-f0fa752aa17d"
_abc.Name = _eqwc("\107\121\088\062\107\123\099\115\045\088\045\104\088\107\121\088\115\045\018\123\032\032\121\099\119\119\121\032\018\045")
_abc.Description = _eqwc("\046\045\118\099\121")
_abc.AltText = ""
_abc.Resources = {
	{
		Type = "jpg", 
		Filename = "coueron.jpg", 
		Directives = {}
	}
}
_AR_ = Wherigo.ZMedia(cartMaxlamenace)
_AR_.Id = "a9190897-58ec-4257-a7f7-db7357c46e3b"
_AR_.Name = _eqwc("\090\121\010\088\107\045\088\068\195\169\115\123\119")
_AR_.Description = _eqwc("\046\045\118\099\121")
_AR_.AltText = ""
_AR_.Resources = {
	{
		Type = "png", 
		Filename = "characters_jack.png", 
		Directives = {}
	}
}
_l3Xze = Wherigo.ZMedia(cartMaxlamenace)
_l3Xze.Id = "e9b36f82-8d8b-4476-92b6-fe8efae5d62c"
_l3Xze.Name = _eqwc("\069\099\115\121\104\045\119\001")
_l3Xze.Description = _eqwc("\046\045\118\099\121\007\084\008\042")
_l3Xze.AltText = ""
_l3Xze.Resources = {
	{
		Type = "mp3", 
		Filename = "15-Pirates_des_Caraibes-He_s_A_Pirate.mp3", 
		Directives = {}
	}
}
_AzQ57 = Wherigo.ZMedia(cartMaxlamenace)
_AzQ57.Id = "bc3708ca-2195-4527-8493-5708dd3cdd6a"
_AzQ57.Name = _eqwc("\109\099\115\121\104\045\061")
_AzQ57.Description = _eqwc("\046\045\118\099\121")
_AzQ57.AltText = ""
_AzQ57.Resources = {
	{
		Type = "mp3", 
		Filename = "Z-Pirates_des_caraibes-Bande_originale.mp3", 
		Directives = {}
	}
}
_Hlgs = Wherigo.ZMedia(cartMaxlamenace)
_Hlgs.Id = "69040da3-80b2-49b8-b70d-1bfa759d59a5"
_Hlgs.Name = _eqwc("\109\099\115\121\104\045\119")
_Hlgs.Description = ""
_Hlgs.AltText = ""
_Hlgs.Resources = {
	{
		Type = "mp3", 
		Filename = "10ToThePiratesCave.mp3", 
		Directives = {}
	}
}
-- Cartridge Info --
cartMaxlamenace.Id="d6d1fa66-357a-4bf5-8036-352db60613a0"
cartMaxlamenace.Name="Max la menace"
cartMaxlamenace.Description=[[Courte histoire de Pirates]]
cartMaxlamenace.Visible=true
cartMaxlamenace.Activity="Fiction"
cartMaxlamenace.StartingLocationDescription=[[Une grande aire de jeu pour tous]]
cartMaxlamenace.StartingLocation = ZonePoint(47.20941666667,-1.730825,0)
cartMaxlamenace.Version="1.00"
cartMaxlamenace.Company=""
cartMaxlamenace.Author="MAXANAIS44"
cartMaxlamenace.BuilderVersion="URWIGO 1.20.5218.24064"
cartMaxlamenace.CreateDate="06/05/2014 09:45:40"
cartMaxlamenace.PublishDate="1/1/0001 12:00:00 AM"
cartMaxlamenace.UpdateDate="06/17/2014 16:28:53"
cartMaxlamenace.LastPlayedDate="1/1/0001 12:00:00 AM"
cartMaxlamenace.TargetDevice="PocketPC"
cartMaxlamenace.TargetDeviceVersion="0"
cartMaxlamenace.StateId="1"
cartMaxlamenace.CountryId="2"
cartMaxlamenace.Complete=false
cartMaxlamenace.UseLogging=true

cartMaxlamenace.Media=zmediaentete


-- Zones --
zone1lePort = Wherigo.Zone(cartMaxlamenace)
zone1lePort.Id = "63e064d4-4502-4214-bad0-338a5bc63f8e"
zone1lePort.Name = _eqwc("\061\039\088\107\045\088\109\123\115\104")
zone1lePort.Description = _eqwc("\109\099\115\121\104\045\033\033\007\084\008\042\079\054\088\121\115\115\099\102\045\119\088\119\054\115\088\032\123\104\115\045\088\099\107\045")
zone1lePort.Visible = true
zone1lePort.Media = zmediaDbarquement
zone1lePort.Commands = {
	SAMBA = Wherigo.ZCommand{
		Text = _eqwc("\060\002\004\116\056"), 
		CmdWith = true, 
		Enabled = false, 
		EmptyTargetListText = _eqwc("\025\123\104\070\099\032\017\088\121\102\121\099\107\121\071\107\045")
	}
}
zone1lePort.Commands.SAMBA.Custom = true
zone1lePort.Commands.SAMBA.Id = "678dd81f-2ef2-402b-a99b-695068d97254"
zone1lePort.Commands.SAMBA.WorksWithAll = false
zone1lePort.Commands.SAMBA.WorksWithListIds = {
	"63e064d4-4502-4214-bad0-338a5bc63f8e"
}
zone1lePort.DistanceRange = Distance(-1, "feet")
zone1lePort.ShowObjects = "OnEnter"
zone1lePort.ProximityRange = Distance(3, "meters")
zone1lePort.AllowSetPositionTo = false
zone1lePort.Active = true
zone1lePort.Points = {
	ZonePoint(47.2095013181576, -1.73132766749382, 0), 
	ZonePoint(47.2095773338891, -1.73125688037396, 0), 
	ZonePoint(47.2095373339323, -1.73123542270184, 0), 
	ZonePoint(47.2094825768073, -1.7312887754631, 0)
}
zone1lePort.OriginalPoint = ZonePoint(47.2095, -1.73124166666667, 0)
zone1lePort.DistanceRangeUOM = "Feet"
zone1lePort.ProximityRangeUOM = "Meters"
zone1lePort.OutOfRangeName = ""
zone1lePort.InRangeName = ""
zone2lapasserelle = Wherigo.Zone(cartMaxlamenace)
zone2lapasserelle.Id = "81f93f5d-64a2-4641-afd5-39399b657744"
zone2lapasserelle.Name = _eqwc("\001\039\088\107\121\088\069\121\119\119\045\115\045\107\107\045")
zone2lapasserelle.Description = _eqwc("\028\045\088\069\123\032\104\088\032\127\121\088\115\099\045\032\088\118\127\045\010\018\045\069\104\099\123\032")
zone2lapasserelle.Visible = true
zone2lapasserelle.Media = zmediapasserllle
zone2lapasserelle.Commands = {}
zone2lapasserelle.DistanceRange = Distance(-1, "feet")
zone2lapasserelle.ShowObjects = "OnEnter"
zone2lapasserelle.ProximityRange = Distance(3, "meters")
zone2lapasserelle.AllowSetPositionTo = false
zone2lapasserelle.Active = true
zone2lapasserelle.Points = {
	ZonePoint(47.2095733497129, -1.7315706416988, 0), 
	ZonePoint(47.2095346976567, -1.73153326562408, 0), 
	ZonePoint(47.2094992368561, -1.73158489814762, 0), 
	ZonePoint(47.2094470565007, -1.73164909631248, 0), 
	ZonePoint(47.2094764168298, -1.73169046640396, 0), 
	ZonePoint(47.2095292413576, -1.73163011670113, 0)
}
zone2lapasserelle.OriginalPoint = ZonePoint(47.2094305555556, -1.73167222222222, 0)
zone2lapasserelle.DistanceRangeUOM = "Feet"
zone2lapasserelle.ProximityRangeUOM = "Meters"
zone2lapasserelle.OutOfRangeName = ""
zone2lapasserelle.InRangeName = ""
zone3labataille = Wherigo.Zone(cartMaxlamenace)
zone3labataille.Id = "e8930c25-bebb-48e2-be79-649850925fb0"
zone3labataille.Name = _eqwc("\023\039\088\107\121\088\071\121\104\121\099\107\107\045")
zone3labataille.Description = _eqwc("\068\121\107\104\045\039\107\121\088\104\123\099\088\107\045\088\046\123\032\119\104\115\045\033\033\033\033")
zone3labataille.Visible = true
zone3labataille.Media = zmediaepee
zone3labataille.Commands = {}
zone3labataille.DistanceRange = Distance(-1, "feet")
zone3labataille.ShowObjects = "OnEnter"
zone3labataille.ProximityRange = Distance(3, "meters")
zone3labataille.AllowSetPositionTo = false
zone3labataille.Active = true
zone3labataille.Points = {
	ZonePoint(47.2085558443566, -1.73103332519531, 0), 
	ZonePoint(47.2085667959775, -1.73093676567078, 0), 
	ZonePoint(47.2084611449523, -1.73081606626511, 0), 
	ZonePoint(47.2083600032249, -1.73080064356327, 0), 
	ZonePoint(47.2083007353715, -1.73098638653755, 0), 
	ZonePoint(47.2084385974502, -1.7309682816267, 0), 
	ZonePoint(47.2084437511658, -1.73103667795658, 0)
}
zone3labataille.OriginalPoint = ZonePoint(47.2083861111111, -1.73101666666667, 0)
zone3labataille.DistanceRangeUOM = "Feet"
zone3labataille.ProximityRangeUOM = "Meters"
zone3labataille.OutOfRangeName = ""
zone3labataille.InRangeName = ""
zone4lamour = Wherigo.Zone(cartMaxlamenace)
zone4lamour.Id = "749d2b2e-0f11-404f-9778-ddbfb74b05ab"
zone4lamour.Name = _eqwc("\016\039\088\107\127\121\046\123\054\115")
zone4lamour.Description = _eqwc("\002\032\045\088\121\069\069\121\115\099\104\099\123\032\081\081\081")
zone4lamour.Visible = true
zone4lamour.Media = zmediabataille
zone4lamour.Commands = {}
zone4lamour.DistanceRange = Distance(-1, "feet")
zone4lamour.ShowObjects = "OnEnter"
zone4lamour.ProximityRange = Distance(3, "meters")
zone4lamour.AllowSetPositionTo = false
zone4lamour.Active = true
zone4lamour.Points = {
	ZonePoint(47.2087095748544, -1.73060029141902, 0), 
	ZonePoint(47.2086715663804, -1.73041014599801, 0), 
	ZonePoint(47.2086022694506, -1.73049262392522, 0), 
	ZonePoint(47.2086183747606, -1.73057346932887, 0)
}
zone4lamour.OriginalPoint = ZonePoint(47.2086277777778, -1.73052777777778, 0)
zone4lamour.DistanceRangeUOM = "Feet"
zone4lamour.ProximityRangeUOM = "Meters"
zone4lamour.OutOfRangeName = ""
zone4lamour.InRangeName = ""
zone5leroidumonde = Wherigo.Zone(cartMaxlamenace)
zone5leroidumonde.Id = "3af1ba52-edaa-4fdb-85c2-c13eda94a849"
zone5leroidumonde.Name = _eqwc("\091\039\088\107\045\088\115\123\099\088\118\054\088\046\123\032\118\045")
zone5leroidumonde.Description = _eqwc("\095\123\054\119\088\018\123\032\104\045\046\069\107\045\105\088\107\045\088\071\123\054\104\088\118\045\088\107\127\099\107\045\040\040\040\040")
zone5leroidumonde.Visible = true
zone5leroidumonde.Media = zmediapirateenfete
zone5leroidumonde.Commands = {}
zone5leroidumonde.DistanceRange = Distance(-1, "feet")
zone5leroidumonde.ShowObjects = "OnEnter"
zone5leroidumonde.ProximityRange = Distance(3, "meters")
zone5leroidumonde.AllowSetPositionTo = false
zone5leroidumonde.Active = true
zone5leroidumonde.Points = {
	ZonePoint(47.2085870275465, -1.72979967915057, 0), 
	ZonePoint(47.208563191672, -1.7297394460154, 0), 
	ZonePoint(47.2085515664518, -1.7297394460154, 0), 
	ZonePoint(47.2085470569599, -1.72981443130016, 0)
}
zone5leroidumonde.OriginalPoint = ZonePoint(47.2085305555556, -1.72973333333333, 0)
zone5leroidumonde.DistanceRangeUOM = "Feet"
zone5leroidumonde.ProximityRangeUOM = "Meters"
zone5leroidumonde.OutOfRangeName = ""
zone5leroidumonde.InRangeName = ""
zone7Letresor = Wherigo.Zone(cartMaxlamenace)
zone7Letresor.Id = "39edd742-6624-48f4-8498-4ea9036bf4d4"
zone7Letresor.Name = _eqwc("\077\039\088\087\045\088\104\115\045\119\123\115")
zone7Letresor.Description = _eqwc("\120\104\045\119\039\102\123\054\119\088\054\032\088\069\099\115\121\104\045\088\018\123\046\071\107\195\169\081\088\011\032\071\119\069\048\011\032\071\119\069\048\011\032\071\119\069\048\011\032\071\119\069\048\011\032\071\119\069\048\011\032\071\119\069\048\011\032\071\119\069\048")
zone7Letresor.Visible = true
zone7Letresor.Media = zmediatrsor
zone7Letresor.Commands = {}
zone7Letresor.DistanceRange = Distance(-1, "feet")
zone7Letresor.ShowObjects = "OnEnter"
zone7Letresor.ProximityRange = Distance(3, "meters")
zone7Letresor.AllowSetPositionTo = false
zone7Letresor.Active = true
zone7Letresor.Points = {
	ZonePoint(47.2094087755895, -1.73160597681999, 0), 
	ZonePoint(47.2093984683452, -1.73160061240196, 0), 
	ZonePoint(47.2093907379108, -1.73159256577492, 0), 
	ZonePoint(47.2093598161617, -1.73155836760998, 0), 
	ZonePoint(47.2093282501909, -1.73157647252083, 0), 
	ZonePoint(47.2093720560229, -1.73162676393986, 0), 
	ZonePoint(47.2094068429813, -1.73163883388042, 0), 
	ZonePoint(47.2094235922495, -1.73162274062634, 0), 
	ZonePoint(47.2094235922495, -1.73161201179028, 0)
}
zone7Letresor.OriginalPoint = ZonePoint(47.209425, -1.73164444444, 0)
zone7Letresor.DistanceRangeUOM = "Feet"
zone7Letresor.ProximityRangeUOM = "Meters"
zone7Letresor.OutOfRangeName = ""
zone7Letresor.InRangeName = ""
zone6laGloire = Wherigo.Zone(cartMaxlamenace)
zone6laGloire.Id = "f3bf8c02-601c-4673-b2cb-4dd362517da0"
zone6laGloire.Name = _eqwc("\072\039\088\107\121\088\062\107\123\099\115\045")
zone6laGloire.Description = _eqwc("\087\121\088\017\107\123\099\115\045")
zone6laGloire.Visible = true
zone6laGloire.Media = _AR_
zone6laGloire.Commands = {
	_7PW = Wherigo.ZCommand{
		Text = _eqwc("\090\045\119\119\121\017\045"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _eqwc("\087\045\088\104\115\195\169\119\123\115\088\118\045\102\115\121\099\104\088\104\123\054\049\123\054\115\119\088\119\045\088\104\115\123\054\102\045\115\088\099\018\099\088\051\007\084\008\042\025\088\016\077\194\176\061\001\127\023\016\040\001\059\007\084\008\042\056\088\092\092\061\194\176\016\023\127\091\023\040\091\092\007\084\008\042")
	}
}
zone6laGloire.Commands._7PW.Custom = true
zone6laGloire.Commands._7PW.Id = "10dc7fb2-d131-4331-8669-3313e3eff45a"
zone6laGloire.Commands._7PW.WorksWithAll = true
zone6laGloire.DistanceRange = Distance(-1, "feet")
zone6laGloire.ShowObjects = "OnEnter"
zone6laGloire.ProximityRange = Distance(3, "meters")
zone6laGloire.AllowSetPositionTo = false
zone6laGloire.Active = true
zone6laGloire.Points = {
	ZonePoint(47.2089786524895, -1.73109329447743, 0), 
	ZonePoint(47.2089464420836, -1.73103793005941, 0), 
	ZonePoint(47.2089235283822, -1.73104597668646, 0), 
	ZonePoint(47.2089563830103, -1.73110670552251, 0)
}
zone6laGloire.OriginalPoint = ZonePoint(47.208925, -1.731075, 0)
zone6laGloire.DistanceRangeUOM = "Feet"
zone6laGloire.ProximityRangeUOM = "Meters"
zone6laGloire.OutOfRangeName = ""
zone6laGloire.InRangeName = ""

-- Characters --

-- Items --

-- Tasks --

-- Cartridge Variables --
Answer = ""
_Q8B_ = _eqwc("\105\123\032\045\061\107\045\109\123\115\104")
_F0H = _eqwc("\118\054\046\046\026")
_NWNFS = _eqwc("\118\054\046\046\026")
_TnC = _eqwc("\118\054\046\046\026")
_9PK = _eqwc("\118\054\046\046\026")
_htS1 = _eqwc("\118\054\046\046\026")
cartMaxlamenace.ZVariables = {
	Answer = "", 
	_Q8B_ = _eqwc("\105\123\032\045\061\107\045\109\123\115\104"), 
	_F0H = _eqwc("\118\054\046\046\026"), 
	_NWNFS = _eqwc("\118\054\046\046\026"), 
	_TnC = _eqwc("\118\054\046\046\026"), 
	_9PK = _eqwc("\118\054\046\046\026"), 
	_htS1 = _eqwc("\118\054\046\046\026")
}

-- Timers --

-- Inputs --

-- WorksWithList for object commands --

-- functions --
function cartMaxlamenace:OnStart()
	if (_G[_eqwc("\120\032\102")][_eqwc("\109\107\121\104\020\123\115\046")] == _eqwc("\100\099\032\023\001")) or (_G[_eqwc("\120\032\102")][_eqwc("\004\045\102\099\018\045\116\004")] == _eqwc("\004\045\119\015\104\123\069")) then
		for k, v in pairs(_G[_eqwc("\018\121\115\104\090\121\010\107\121\046\045\032\121\018\045")][_eqwc("\060\107\107\097\056\071\049\045\018\104\119")]) do
			v[_eqwc("\095\099\119\099\071\107\045")] = false
			v[_eqwc("\060\018\104\099\102\045")] = false
		end
		_G[_eqwc("\100\070\045\115\099\017\123")][_eqwc("\028\123\046\046\121\032\118")](_eqwc("\114\121\102\045\028\107\123\119\045"))
		return
	end
end
function cartMaxlamenace:OnRestore()
end
function zone1lePort:OnSAMBA(target)
	_Q8B_ = _eqwc("\105\123\032\045\061\107\045\109\123\115\104")
end
function zone1lePort:OnEnter()
	_Q8B_ = _eqwc("\105\123\032\045\061\107\045\109\123\115\104")
	zone1lePort.Active = false
	Wherigo.PlayAudio(_AzQ57)
	_Urwigo.MessageBox{
		Text = _eqwc("\120\119\104\039\018\045\088\054\032\045\088\102\099\119\099\104\045\088\118\045\088\018\123\054\115\104\123\099\119\099\045\007\084\008\042\123\054\088\071\099\045\032\088\104\045\088\069\115\195\169\069\121\115\045\119\088\104\054\088\195\160\088\118\195\169\102\121\119\104\045\115\088\032\123\104\115\045\088\099\107\045\081\007\084\008\042"), 
		Media = zmediaDbarquement, 
		Buttons = {
			_eqwc("\056\037")
		}
	}
end
function zone1lePort:OnExit()
	_Q8B_ = _eqwc("\105\123\032\045\061\107\045\109\123\115\104")
	zone1lePort.Active = false
	_Urwigo.MessageBox{
		Text = _eqwc("\004\099\115\099\017\045\088\104\123\099\088\102\045\115\119\088\107\121\088\069\121\119\119\045\115\045\107\107\045")
	}
end
function zone2lapasserelle:OnEnter()
	_Q8B_ = _eqwc("\105\123\032\045\001\107\121\069\121\119\119\045\115\045\107\107\045")
	_Urwigo.MessageBox{
		Text = _eqwc("\084\099\045\032\033\033\033\088\114\099\088\104\054\088\102\045\054\010\088\195\170\104\115\045\088\121\069\069\115\045\018\099\195\169\088\118\045\119\088\017\045\032\119\088\118\127\099\018\099\088\104\054\088\118\045\102\115\121\119\088\046\123\032\104\115\045\115\088\104\121\088\102\121\099\107\107\121\032\018\045\088\045\104\088\018\123\046\071\121\104\104\115\045\088\054\032\088\046\123\032\119\104\115\045\088\119\045\115\121\119\039\104\054\088\104\195\169\046\195\169\115\121\099\115\045\081"), 
		Media = zmediapasserllle
	}
end
function zone2lapasserelle:OnExit()
	_Q8B_ = _eqwc("\105\123\032\045\001\107\121\069\121\119\119\045\115\045\107\107\045")
	zone2lapasserelle.Active = false
	Wherigo.PlayAudio(_Hlgs)
	_Urwigo.MessageBox{
		Text = _eqwc("\069\123\054\115\088\107\121\088\071\121\104\121\099\107\107\045\040\040\040\018\127\045\119\104\088\102\045\115\119\088\107\045\088\020\123\032\118\088\118\045\088\107\127\099\107\045\088\045\104\088\071\123\032\088\018\123\054\115\121\017\045")
	}
end
function zone3labataille:OnEnter()
	_Q8B_ = _eqwc("\105\123\032\045\023\107\121\071\121\104\121\099\107\107\045")
	zone3labataille.Active = false
	_Urwigo.MessageBox{
		Text = _eqwc("\114\099\088\104\054\088\032\045\088\104\045\088\071\123\054\017\045\119\088\069\121\119\088\118\045\088\046\123\032\088\018\070\045\046\099\032\088\107\045\088\046\123\032\119\104\115\045\040\040\040\055\045\088\102\121\099\119\088\046\127\123\018\018\054\069\045\115\088\118\045\088\104\123\032\088\046\121\104\115\099\018\054\107\045"), 
		Media = zmediaepee
	}
end
function zone3labataille:OnExit()
	_Q8B_ = _eqwc("\105\123\032\045\023\107\121\071\121\104\121\099\107\107\045")
	zone3labataille.Active = false
	_Urwigo.MessageBox{
		Text = _eqwc("\084\115\121\102\123\033\033\088\107\045\088\046\123\032\119\104\115\045\088\119\127\045\032\088\102\121\067\088\104\054\088\069\045\054\010\088\069\123\054\115\119\054\099\102\115\045\088\104\123\032\088\121\102\045\032\104\054\115\045\040\040\040\040\088\011\032\071\119\069\048\011\032\071\119\069\048\011\032\071\119\069\048\011\032\071\119\069\048\011\032\071\119\069\048\011\032\071\119\069\048\011\032\071\119\069\048\011\032\071\119\069\048\011\032\071\119\069\048\011\032\071\119\069\048\011\032\071\119\069\048\011\032\071\119\069\048\011\032\071\119\069\048\011\032\071\119\069\048\011\032\071\119\069\048\011\032\071\119\069\048\011\032\071\119\069\048\011\032\071\119\069\048\011\032\071\119\069\048\011\032\071\119\069\048\011\032\071\119\069\048\011\032\071\119\069\048\011\032\071\119\069\048\011\032\071\119\069\048\011\032\071\119\069\048\011\032\071\119\069\048\011\032\071\119\069\048\011\032\071\119\069\048\011\032\071\119\069\048\011\032\071\119\069\048\011\032\071\119\069\048\011\032\071\119\069\048\011\032\071\119\069\048\011\032\071\119\069\048\011\032\071\119\069\048\011\032\071\119\069\048\011\032\071\119\069\048\011\032\071\119\069\048\011\032\071\119\069\048\011\032\071\119\069\048\011\032\071\119\069\048\011\032\071\119\069\048\011\032\071\119\069\048\011\032\071\119\069\048\011\032\071\119\069\048\011\032\071\119\069\048\011\032\071\119\069\048\011\032\071\119\069\048\011\032\071\119\069\048\011\032\071\119\069\048\011\032\071\119\069\048\011\032\071\119\069\048\011\032\071\119\069\048\011\032\071\119\069\048\011\032\071\119\069\048\011\032\071\119\069\048\011\032\071\119\069\048\011\032\071\119\069\048\011\032\071\119\069\048\011\032\071\119\069\048\011\032\071\119\069\048\011\032\071\119\069\048\011\032\071\119\069\048\011\032\071\119\069\048\090\121\099\119\088\110\054\045\107\107\045\088\045\119\104\088\018\045\104\104\045\088\121\069\069\121\115\099\104\099\123\032\081\040\040\040"), 
		Media = zmediabataille
	}
end
function zone4lamour:OnEnter()
	_Q8B_ = _eqwc("\105\123\032\045\016\107\121\046\123\054\115")
	zone4lamour.Active = false
	_Urwigo.MessageBox{
		Text = _eqwc("\084\123\032\049\123\054\115\007\084\008\042\060\032\121\099\119\088\107\121\088\069\115\099\032\018\045\119\119\045\088\118\045\088\028\123\054\045\115\123\032\007\084\008\042\055\045\088\102\123\054\119\088\118\123\099\119\088\054\032\045\088\020\099\195\168\115\045\088\018\070\121\032\118\045\107\107\045\033\033\033"), 
		Media = zmedialabelle, 
		Buttons = {
			_eqwc("\056\037")
		}
	}
end
function zone4lamour:OnExit()
	_Q8B_ = _eqwc("\105\123\032\045\016\107\121\046\123\054\115")
	zone4lamour.Active = false
	_Urwigo.MessageBox{
		Text = _eqwc("\095\123\054\119\088\046\127\121\102\045\105\088\118\195\169\107\099\102\115\195\169\088\118\045\119\088\017\115\099\020\020\045\119\088\118\045\088\018\045\104\088\121\020\020\115\045\054\010\088\046\123\032\119\104\115\045\007\084\008\042\055\045\088\119\054\099\119\088\119\121\088\069\115\099\119\123\032\032\099\195\168\115\045\067\088\099\107\088\046\045\088\115\045\104\099\045\032\104\088\119\054\115\088\018\045\104\104\045\088\099\107\045\007\084\008\042\045\104\088\069\107\054\119\088\069\045\115\119\123\032\032\045\088\123\119\045\088\102\045\032\099\115\088\119\127\121\102\045\032\104\054\115\045\115\088\099\018\099\039\071\121\119"), 
		Media = zmedialabelle
	}
end
function zone5leroidumonde:OnEnter()
	_Q8B_ = _eqwc("\105\123\032\045\091\107\045\115\123\099\118\054\046\123\032\118\045")
	zone5leroidumonde.Active = false
	_Urwigo.MessageBox{
		Text = _eqwc("\079\123\054\119\088\107\045\119\088\102\099\107\107\121\017\045\123\099\119\088\119\123\032\104\088\115\195\169\054\032\099\119\088\069\123\054\115\088\018\045\107\045\071\115\045\115\088\102\123\104\115\045\088\102\099\018\104\123\099\115\045\088\119\054\115\088\107\045\088\118\115\121\017\123\032\088\045\104\088\102\123\104\115\045\088\115\045\032\018\123\032\104\115\045\088\121\102\045\018\088\107\121\088\069\115\099\032\018\045\119\119\045\088\060\032\121\195\175\119\007\084\008\042\095\123\054\119\088\121\102\045\105\088\115\045\032\118\045\105\039\102\123\054\119\088\121\102\045\018\088\107\121\088\017\107\123\099\115\045\088\045\104\088\107\121\088\115\045\018\123\032\032\121\099\119\119\121\032\018\045\088\118\045\119\088\070\121\071\099\104\121\032\104\119\088\118\045\088\107\127\099\107\045\040\040\040\007\084\008\042"), 
		Media = zmediaFeudartifice
	}
end
function zone5leroidumonde:OnExit()
	_Q8B_ = _eqwc("\105\123\032\045\091\107\045\115\123\099\118\054\046\123\032\118\045")
	zone5leroidumonde.Active = false
	_Urwigo.MessageBox{
		Text = _eqwc("\107\121\088\119\054\099\104\045\088\118\045\088\107\127\121\102\045\032\104\054\115\045\007\084\008\042\045\032\088\118\099\115\045\018\104\099\123\032\088\118\045\088\087\121\088\017\107\123\099\115\045"), 
		Media = _AR_
	}
end
function zone7Letresor:OnEnter()
	_Q8B_ = _eqwc("\105\123\032\045\077\087\045\104\115\045\119\123\115")
	zone7Letresor.Active = false
	_Urwigo.MessageBox{
		Text = _eqwc("\095\123\054\119\088\045\104\045\119\088\069\121\119\088\107\123\099\032\088\118\045\088\104\115\123\054\102\045\115\088\107\045\088\104\115\195\169\119\123\115\088\118\045\119\088\069\099\115\121\104\045\119\088\007\084\008\042\046\045\088\119\045\046\071\107\045\039\104\039\099\107\088\081\088\011\032\071\119\069\048\011\032\071\119\069\048\011\032\071\119\069\048\011\032\071\119\069\048\011\032\071\119\069\048\011\032\071\119\069\048\011\032\071\119\069\048\011\032\071\119\069\048\011\032\071\119\069\048\011\032\071\119\069\048\011\032\071\119\069\048\011\032\071\119\069\048\011\032\071\119\069\048\011\032\071\119\069\048\011\032\071\119\069\048\011\032\071\119\069\048\011\032\071\119\069\048\011\032\071\119\069\048\011\032\071\119\069\048\011\032\071\119\069\048\011\032\071\119\069\048\011\032\071\119\069\048\011\032\071\119\069\048\011\032\071\119\069\048\011\032\071\119\069\048\011\032\071\119\069\048\011\032\071\119\069\048\011\032\071\119\069\048\011\032\071\119\069\048\011\032\071\119\069\048\011\032\071\119\069\048\011\032\071\119\069\048\011\032\071\119\069\048\011\032\071\119\069\048\011\032\071\119\069\048\011\032\071\119\069\048\011\032\071\119\069\048\011\032\071\119\069\048\011\032\071\119\069\048\011\032\071\119\069\048\011\032\071\119\069\048\011\032\071\119\069\048\007\084\008\042\018\070\045\115\018\070\045\105\088\071\099\045\032\088\099\107\088\119\045\088\046\045\115\099\104\045\040\040\040\007\084\008\042\116\107\088\102\123\054\119\088\107\099\102\115\045\115\121\088\107\045\088\018\123\118\045\088\118\127\121\018\070\195\169\102\045\046\045\032\104\088\195\160\088\195\169\018\115\099\115\045\088\118\121\032\119\088\102\123\104\115\045\088\107\123\017\088\007\084\008\042\119\054\115\088\107\045\088\119\099\104\045\088\099\032\104\045\115\032\045\104\088\008\060\025\062\120\008\029\056\034\040\032\045\104\088\102\099\121\088\062\120\056\028\060\028\068\116\025\062\040\018\123\046\007\084\008\042\090\060\034\088\107\121\088\046\045\032\121\018\045\088\119\045\088\018\070\121\115\017\045\088\118\045\088\102\121\107\099\118\045\115\088\102\123\104\115\045\088\118\195\169\018\123\054\102\045\115\104\045\088"), 
		Media = zmediatrsor, 
		Buttons = {
			_eqwc("\056\037")
		}
	}
end
function zone6laGloire:On_7PW(target)
	_Q8B_ = _eqwc("\105\123\032\045\072\107\121\062\107\123\099\115\045")
end
function zone6laGloire:OnEnter()
	_Q8B_ = _eqwc("\105\123\032\045\072\107\121\062\107\123\099\115\045")
	Wherigo.PlayAudio(_l3Xze)
	zone6laGloire.Active = false
	_Urwigo.MessageBox{
		Text = _eqwc("\120\032\088\115\123\054\104\045\088\069\123\054\115\088\107\045\088\104\115\195\169\119\123\115\088\118\045\088\107\127\099\107\045\088\051\007\084\008\042\025\088\016\077\194\176\088\061\001\088\023\016\040\001\059\007\084\008\042\056\088\092\092\061\194\176\088\016\023\088\091\023\040\091\092"), 
		Media = _AR_
	}
end

-- Urwigo functions --

-- Begin user functions --
-----------------------------------------------------------------------------------------------
-- URWIGO: Following code is imported from the Wherigo Builder cartridge.
-- It is only neccessary if the cartridge uses Author functions that use message box callbacks.
-- Otherwise it can be removed.
cartMaxlamenace.MsgBoxCBFuncs = {}
-------------------------------------------------------------------------------
--#LASTCALLBACKKEY=0#--

-----------------------------------------------------------------------------------------------
-- URWIGO: Here follow imported Author functions


-- End user functions --
return cartMaxlamenace
