require "Wherigo"
ZonePoint = Wherigo.ZonePoint
Distance = Wherigo.Distance
Player = Wherigo.Player

-- #Author Directives Go Here# --
-- #End Author Directives# --

cartNationalMallandMemorialParks = Wherigo.ZCartridge()

-- MessageBox Callback Functions Table used by the Builder --
cartNationalMallandMemorialParks.MsgBoxCBFuncs = {}

zmediaWashingtonMonument = Wherigo.ZMedia(cartNationalMallandMemorialParks)
zmediaWashingtonMonument.Name="Washington Monument"
zmediaWashingtonMonument.Description=""
zmediaWashingtonMonument.AltText=""
zmediaWashingtonMonument.Id="03e537f4-62d7-463a-a6f6-b470df358dc1"
zmediaWashingtonMonument.Resources = {
{ Type = "jpg", Filename = "washingtonmonument.jpg", Directives = {},},
}
-- Cartridge Info --
cartNationalMallandMemorialParks.Id="ba417d81-b8b8-44d5-bff7-646e8bde831d"
cartNationalMallandMemorialParks.Name="National Mall and Memorial Parks"
cartNationalMallandMemorialParks.Description=[[Officially established in 1965, National Mall & Memorial Parks contains some of the oldest protected park lands in the National Park Service. The areas within National Mall & Memorial Parks provides visitors with ample opportunities to commemorate presidential legacies; honor the courage and sacrifice of war veterans; celebrate the United States commitment to freedom and equality.]]
cartNationalMallandMemorialParks.Visible=true
cartNationalMallandMemorialParks.Activity="TourGuide"
cartNationalMallandMemorialParks.StartingLocationDescription=[[]]
cartNationalMallandMemorialParks.StartingLocation = ZonePoint(38.891125,-77.036551,0)
cartNationalMallandMemorialParks.Version="1.0"
cartNationalMallandMemorialParks.Company="Ereigo"
cartNationalMallandMemorialParks.Author="Marion Jensen"
cartNationalMallandMemorialParks.BuilderVersion="2.0.4825.3287"
cartNationalMallandMemorialParks.CreateDate="3/3/2008 10:09:10 AM"
cartNationalMallandMemorialParks.PublishDate="1/1/0001 12:00:00 AM"
cartNationalMallandMemorialParks.UpdateDate="3/4/2008 10:16:16 AM"
cartNationalMallandMemorialParks.LastPlayedDate="1/1/0001 12:00:00 AM"
cartNationalMallandMemorialParks.TargetDevice="PocketPC"
cartNationalMallandMemorialParks.TargetDeviceVersion="0"
cartNationalMallandMemorialParks.StateId="1"
cartNationalMallandMemorialParks.CountryId="2"
cartNationalMallandMemorialParks.Complete=false
cartNationalMallandMemorialParks.UseLogging=false
cartNationalMallandMemorialParks.Media=zmediaWashingtonMonument
cartNationalMallandMemorialParks.Icon=zmediaWashingtonMonument

-- Zones --
zoneWashingtonMonument = Wherigo.Zone(cartNationalMallandMemorialParks)
zoneWashingtonMonument.Id="e2daa29b-e0cb-4a21-8fe8-b89269565a02"
zoneWashingtonMonument.Name="Washington Monument"
zoneWashingtonMonument.Description=[[The Washington Monument is the most prominent, as well as one of the older, attractions in Washington, D.C. It was built in honor of George Washington, who led the country to independence, and then became its first President. The Monument is shaped like an Egyptian obelisk, 555 feet 5/8 inches high, and averages 30 to 40 miles visibility in clear weather. It was finished on December 6, 1884.]]
zoneWashingtonMonument.Visible=true
zoneWashingtonMonument.DistanceRange = Distance(1500, "feet")
zoneWashingtonMonument.ShowObjects="OnEnter"
zoneWashingtonMonument.ProximityRange = Distance(200, "feet")
zoneWashingtonMonument.AllowSetPositionTo=false
zoneWashingtonMonument.Active=true
zoneWashingtonMonument.Points = {
  ZonePoint(38.8901309454343,-77.0352745056152,0),
  ZonePoint(38.8890787363981,-77.0360791683197,0),
  ZonePoint(38.8891121400991,-77.0344698429108,0)
}
zoneWashingtonMonument.OriginalPoint = ZonePoint(38.88982,-77.03525,0)
zoneWashingtonMonument.DistanceRangeUOM = "Feet"
zoneWashingtonMonument.ProximityRangeUOM = "Feet"
zoneWashingtonMonument.OutOfRangeName = ""
zoneWashingtonMonument.InRangeName = ""

zoneLincolnMemorial = Wherigo.Zone(cartNationalMallandMemorialParks)
zoneLincolnMemorial.Id="e9507456-843f-4ac6-94f8-75052177c9ac"
zoneLincolnMemorial.Name="Lincoln Memorial"
zoneLincolnMemorial.Description=[["In this temple, as in the hearts of the people for whom he saved the Union, the memory of Abraham Lincoln is enshrined forever." Beneath these words, the 16th President of the United States - the Great Emancipator and preserver of the nation during the Civil War - sits immortalized in marble. As an enduring symbol of Freedom, the Lincoln Memorial attracts anyone who seeks inspiration and hope.]]
zoneLincolnMemorial.Visible=true
zoneLincolnMemorial.DistanceRange = Distance(1500, "feet")
zoneLincolnMemorial.ShowObjects="OnEnter"
zoneLincolnMemorial.ProximityRange = Distance(200, "feet")
zoneLincolnMemorial.AllowSetPositionTo=false
zoneLincolnMemorial.Active=true
zoneLincolnMemorial.Points = {
  ZonePoint(38.8896,-77.05059,0),
  ZonePoint(38.88959,-77.04986,0),
  ZonePoint(38.88889,-77.04986,0),
  ZonePoint(38.88888,-77.0506,0)
}
zoneLincolnMemorial.OriginalPoint = ZonePoint(38.8896,-77.05059,0)
zoneLincolnMemorial.DistanceRangeUOM = "Feet"
zoneLincolnMemorial.ProximityRangeUOM = "Feet"
zoneLincolnMemorial.OutOfRangeName = ""
zoneLincolnMemorial.InRangeName = ""

zoneThomasJeffersonMemorial = Wherigo.Zone(cartNationalMallandMemorialParks)
zoneThomasJeffersonMemorial.Id="b2eb2be0-7d8d-4bc4-9b82-d0ab5620988a"
zoneThomasJeffersonMemorial.Name="Thomas Jefferson Memorial"
zoneThomasJeffersonMemorial.Description=[[The words of Thomas Jefferson, some written more than 200 years ago, have shaped American ideals. Today, many of these impressive, stirring words adorn the interior walls of his memorial. The Thomas Jefferson Memorial stands as a symbol of liberty and endures as a site for reflection and inspiration for all citizens of the United States and the world.]]
zoneThomasJeffersonMemorial.Visible=true
zoneThomasJeffersonMemorial.DistanceRange = Distance(1500, "feet")
zoneThomasJeffersonMemorial.ShowObjects="OnEnter"
zoneThomasJeffersonMemorial.ProximityRange = Distance(200, "feet")
zoneThomasJeffersonMemorial.AllowSetPositionTo=false
zoneThomasJeffersonMemorial.Active=true
zoneThomasJeffersonMemorial.Points = {
  ZonePoint(38.8817,-77.03698,0),
  ZonePoint(38.88168,-77.03611,0),
  ZonePoint(38.88091,-77.03611,0),
  ZonePoint(38.88096,-77.03708,0)
}
zoneThomasJeffersonMemorial.OriginalPoint = ZonePoint(38.8817,-77.03698,0)
zoneThomasJeffersonMemorial.DistanceRangeUOM = "Feet"
zoneThomasJeffersonMemorial.ProximityRangeUOM = "Feet"
zoneThomasJeffersonMemorial.OutOfRangeName = ""
zoneThomasJeffersonMemorial.InRangeName = ""

zoneWorldWarIIMemorial = Wherigo.Zone(cartNationalMallandMemorialParks)
zoneWorldWarIIMemorial.Id="186d984c-ad42-40e1-ab1d-301b75f12a9d"
zoneWorldWarIIMemorial.Name="World War II Memorial"
zoneWorldWarIIMemorial.Description=[[The National World War II Memorial commemorates the sacrifice and celebrates the victory of the of the WWII generation. Friedrich St.Florian's winning design balances classical and modernist styles of architecture, harmonizes with its natural and cultural surroundings, and connects the legacy of the American Revolution and the American Civil War with great crusade to rid the world of fascism.]]
zoneWorldWarIIMemorial.Visible=true
zoneWorldWarIIMemorial.DistanceRange = Distance(1500, "feet")
zoneWorldWarIIMemorial.ShowObjects="OnEnter"
zoneWorldWarIIMemorial.ProximityRange = Distance(200, "feet")
zoneWorldWarIIMemorial.AllowSetPositionTo=false
zoneWorldWarIIMemorial.Active=true
zoneWorldWarIIMemorial.Points = {
  ZonePoint(38.88987,-77.04101,0),
  ZonePoint(38.88989,-77.0401,0),
  ZonePoint(38.88885,-77.04006,0),
  ZonePoint(38.88882,-77.04101,0)
}
zoneWorldWarIIMemorial.OriginalPoint = ZonePoint(38.88987,-77.04101,0)
zoneWorldWarIIMemorial.DistanceRangeUOM = "Feet"
zoneWorldWarIIMemorial.ProximityRangeUOM = "Feet"
zoneWorldWarIIMemorial.OutOfRangeName = ""
zoneWorldWarIIMemorial.InRangeName = ""

zoneFranklinDelanoRooseveltMemorial = Wherigo.Zone(cartNationalMallandMemorialParks)
zoneFranklinDelanoRooseveltMemorial.Id="7997ef7b-7115-4d2f-ae39-6578e3cbe07e"
zoneFranklinDelanoRooseveltMemorial.Name="Franklin Delano Roosevelt Memorial"
zoneFranklinDelanoRooseveltMemorial.Description=[[The only thing we have to fear is fear itself. These are the words of our 32nd President, a man who truly knew the meaning of the word courage. Despite, at age 39, being stricken with polio and paralyzed from the waist down, he emerged as a true leader, guiding our country through some of its darkest times: the Great Depression and World War II. The FDR Memorial honors this man and his story.]]
zoneFranklinDelanoRooseveltMemorial.Visible=true
zoneFranklinDelanoRooseveltMemorial.DistanceRange = Distance(1500, "feet")
zoneFranklinDelanoRooseveltMemorial.ShowObjects="OnEnter"
zoneFranklinDelanoRooseveltMemorial.ProximityRange = Distance(200, "feet")
zoneFranklinDelanoRooseveltMemorial.AllowSetPositionTo=false
zoneFranklinDelanoRooseveltMemorial.Active=true
zoneFranklinDelanoRooseveltMemorial.Points = {
  ZonePoint(38.8827108690058,-77.0419317483902,0),
  ZonePoint(38.8825187802033,-77.041888833046,0),
  ZonePoint(38.8825939454488,-77.0416313409805,0),
  ZonePoint(38.8827943857144,-77.0416796207428,0)
}
zoneFranklinDelanoRooseveltMemorial.OriginalPoint = ZonePoint(38.88271,-77.04193,0)
zoneFranklinDelanoRooseveltMemorial.DistanceRangeUOM = "Feet"
zoneFranklinDelanoRooseveltMemorial.ProximityRangeUOM = "Feet"
zoneFranklinDelanoRooseveltMemorial.OutOfRangeName = ""
zoneFranklinDelanoRooseveltMemorial.InRangeName = ""

zoneKoreanWarVeterans = Wherigo.Zone(cartNationalMallandMemorialParks)
zoneKoreanWarVeterans.Id="ff69506f-9242-4894-97c6-2fe0fcfddced"
zoneKoreanWarVeterans.Name="Korean War Veterans"
zoneKoreanWarVeterans.Description=[["Freedom is not free." Here, one finds the expression of American gratitude to those who restored freedom to South Korea. Nineteen stainless steel sculptures stand silently under the watchful eye of a sea of faces upon a granite wall - reminders of the human cost of defending freedom. These elements all bear witness to the patriotism, devotion to duty, and courage of Korean War veterans.]]
zoneKoreanWarVeterans.Visible=true
zoneKoreanWarVeterans.DistanceRange = Distance(1500, "feet")
zoneKoreanWarVeterans.ShowObjects="OnEnter"
zoneKoreanWarVeterans.ProximityRange = Distance(200, "feet")
zoneKoreanWarVeterans.AllowSetPositionTo=false
zoneKoreanWarVeterans.Active=true
zoneKoreanWarVeterans.Points = {
  ZonePoint(38.8880974956732,-77.0480042695999,0),
  ZonePoint(38.8876882934087,-77.0480579137802,0),
  ZonePoint(38.8876799423175,-77.0472103357315,0)
}
zoneKoreanWarVeterans.OriginalPoint = ZonePoint(38.8881,-77.048,0)
zoneKoreanWarVeterans.DistanceRangeUOM = "Feet"
zoneKoreanWarVeterans.ProximityRangeUOM = "Feet"
zoneKoreanWarVeterans.OutOfRangeName = ""
zoneKoreanWarVeterans.InRangeName = ""

zoneVietnamVeteransMemorial = Wherigo.Zone(cartNationalMallandMemorialParks)
zoneVietnamVeteransMemorial.Id="57fc26ba-149f-4472-979a-b7557c39b6ec"
zoneVietnamVeteransMemorial.Name="Vietnam Veterans Memorial"
zoneVietnamVeteransMemorial.Description=[[Deliberately setting aside the controversies of the war, the Vietnam Veterans Memorial honors the men and women who served when their Nation called upon them. The designer, Maya Lin, felt that "the politics had eclipsed the veterans, their service and their lives." She kept the design elegantly simple to "allow everyone to respond and remember."]]
zoneVietnamVeteransMemorial.Visible=true
zoneVietnamVeteransMemorial.DistanceRange = Distance(1500, "feet")
zoneVietnamVeteransMemorial.ShowObjects="OnEnter"
zoneVietnamVeteransMemorial.ProximityRange = Distance(200, "feet")
zoneVietnamVeteransMemorial.AllowSetPositionTo=false
zoneVietnamVeteransMemorial.Active=true
zoneVietnamVeteransMemorial.Points = {
  ZonePoint(38.89141,-77.04781,0),
  ZonePoint(38.89087,-77.04837,0),
  ZonePoint(38.89113,-77.04679,0)
}
zoneVietnamVeteransMemorial.OriginalPoint = ZonePoint(38.89141,-77.04781,0)
zoneVietnamVeteransMemorial.DistanceRangeUOM = "Feet"
zoneVietnamVeteransMemorial.ProximityRangeUOM = "Feet"
zoneVietnamVeteransMemorial.OutOfRangeName = ""
zoneVietnamVeteransMemorial.InRangeName = ""

zoneNationalMallTour = Wherigo.Zone(cartNationalMallandMemorialParks)
zoneNationalMallTour.Id="4f8458e3-777f-445a-978c-2b426484b2ba"
zoneNationalMallTour.Name="National Mall Tour"
zoneNationalMallTour.Description=[[National Mall Tour]]
zoneNationalMallTour.Visible=false
zoneNationalMallTour.DistanceRange = Distance(1500, "feet")
zoneNationalMallTour.ShowObjects="OnEnter"
zoneNationalMallTour.ProximityRange = Distance(200, "feet")
zoneNationalMallTour.AllowSetPositionTo=false
zoneNationalMallTour.Active=true
zoneNationalMallTour.Points = {
  ZonePoint(38.89259,-77.0539,0),
  ZonePoint(38.89241,-77.03103,0),
  ZonePoint(38.87876,-77.03107,0),
  ZonePoint(38.88273,-77.05419,0)
}
zoneNationalMallTour.OriginalPoint = ZonePoint(38.89259,-77.0539,0)
zoneNationalMallTour.DistanceRangeUOM = "Feet"
zoneNationalMallTour.ProximityRangeUOM = "Feet"
zoneNationalMallTour.OutOfRangeName = ""
zoneNationalMallTour.InRangeName = ""

-- Characters --

-- Items --

-- Tasks --
ztaskVisittheWashingtonMonument = Wherigo.ZTask(cartNationalMallandMemorialParks)
ztaskVisittheWashingtonMonument.Id="0bd1e4c3-8023-4fd1-a60b-90cf223c9cc0"
ztaskVisittheWashingtonMonument.Name="Visit the Washington Monument"
ztaskVisittheWashingtonMonument.Description=[[]]
ztaskVisittheWashingtonMonument.Visible=true
ztaskVisittheWashingtonMonument.Active=true
ztaskVisittheWashingtonMonument.Complete=false
ztaskVisittheWashingtonMonument.CorrectState = "None"

ztaskVisittheLincolnMemorial = Wherigo.ZTask(cartNationalMallandMemorialParks)
ztaskVisittheLincolnMemorial.Id="abf413e1-c6e7-410c-a31c-0addecff980c"
ztaskVisittheLincolnMemorial.Name="Visit the Lincoln Memorial"
ztaskVisittheLincolnMemorial.Description=[[]]
ztaskVisittheLincolnMemorial.Visible=true
ztaskVisittheLincolnMemorial.Active=true
ztaskVisittheLincolnMemorial.Complete=false
ztaskVisittheLincolnMemorial.CorrectState = "None"

ztaskVisittheThomasJeffersonMemorial = Wherigo.ZTask(cartNationalMallandMemorialParks)
ztaskVisittheThomasJeffersonMemorial.Id="c5a5b6ed-6bb9-4e51-80e5-9052f329a93a"
ztaskVisittheThomasJeffersonMemorial.Name="Visit the Thomas Jefferson Memorial"
ztaskVisittheThomasJeffersonMemorial.Description=[[]]
ztaskVisittheThomasJeffersonMemorial.Visible=true
ztaskVisittheThomasJeffersonMemorial.Active=true
ztaskVisittheThomasJeffersonMemorial.Complete=false
ztaskVisittheThomasJeffersonMemorial.CorrectState = "None"

ztaskVisittheWWIIMemorial = Wherigo.ZTask(cartNationalMallandMemorialParks)
ztaskVisittheWWIIMemorial.Id="5e7f76cf-c695-4e1d-be42-c26076ab9b27"
ztaskVisittheWWIIMemorial.Name="Visit the WWII Memorial"
ztaskVisittheWWIIMemorial.Description=[[]]
ztaskVisittheWWIIMemorial.Visible=true
ztaskVisittheWWIIMemorial.Active=true
ztaskVisittheWWIIMemorial.Complete=false
ztaskVisittheWWIIMemorial.CorrectState = "None"

ztaskVisittheFDRMemorial = Wherigo.ZTask(cartNationalMallandMemorialParks)
ztaskVisittheFDRMemorial.Id="41bd33bc-eb9f-4cc3-b6a4-ecae6d3ea29e"
ztaskVisittheFDRMemorial.Name="Visit the FDR Memorial"
ztaskVisittheFDRMemorial.Description=[[]]
ztaskVisittheFDRMemorial.Visible=true
ztaskVisittheFDRMemorial.Active=true
ztaskVisittheFDRMemorial.Complete=false
ztaskVisittheFDRMemorial.CorrectState = "None"

ztaskVisittheKoreanWarVeteransMemorial = Wherigo.ZTask(cartNationalMallandMemorialParks)
ztaskVisittheKoreanWarVeteransMemorial.Id="6c4bbe72-33c1-4300-848b-8586473408d0"
ztaskVisittheKoreanWarVeteransMemorial.Name="Visit the Korean War Veterans Memorial"
ztaskVisittheKoreanWarVeteransMemorial.Description=[[]]
ztaskVisittheKoreanWarVeteransMemorial.Visible=true
ztaskVisittheKoreanWarVeteransMemorial.Active=true
ztaskVisittheKoreanWarVeteransMemorial.Complete=false
ztaskVisittheKoreanWarVeteransMemorial.CorrectState = "None"

ztaskVisittheVietnamVeteransMemorial = Wherigo.ZTask(cartNationalMallandMemorialParks)
ztaskVisittheVietnamVeteransMemorial.Id="d447dad6-54d8-4fca-9ab7-38302f051203"
ztaskVisittheVietnamVeteransMemorial.Name="Visit the Vietnam Veterans Memorial"
ztaskVisittheVietnamVeteransMemorial.Description=[[]]
ztaskVisittheVietnamVeteransMemorial.Visible=true
ztaskVisittheVietnamVeteransMemorial.Active=true
ztaskVisittheVietnamVeteransMemorial.Complete=false
ztaskVisittheVietnamVeteransMemorial.CorrectState = "None"

-- Cartridge Variables --
Visited = 0
cartNationalMallandMemorialParks.ZVariables = {Visited = 0}

-- Builder Variables (to be read by the builder only) --
buildervar = {}
buildervar.Visited = {}
buildervar.Visited.Id ="fd0aaa2b-26cc-4468-9e83-5809abf3dbef"
buildervar.Visited.Name = "Visited"
buildervar.Visited.Type = "Number"
buildervar.Visited.Data=[[0]]
buildervar.Visited.Description=[[]]


-- ZTimers --

-- Inputs --
zinputcomplete = Wherigo.ZInput(cartNationalMallandMemorialParks)
zinputcomplete.Id="2f0c0ea6-bdce-416a-b86e-6045f2574593"
zinputcomplete.Name="complete"
zinputcomplete.Description=[[Did you visit every site?]]
zinputcomplete.Visible=true
zinputcomplete.Choices = {"Yes", "No"}
zinputcomplete.InputType="MultipleChoice"
zinputcomplete.InputVariableId="00000000-0000-0000-0000-000000000000"
zinputcomplete.Text=[[]]

--
-- Events/Conditions/Actions --
--

-------------------------------------------------------------------------------
------Builder Generated functions, Do not Edit, this will be overwritten------
-------------------------------------------------------------------------------

function zoneFranklinDelanoRooseveltMemorial:OnProximity()
-- #GroupDescription=FDR --
-- #Comment=FDR Comment --
if   ztaskVisittheFDRMemorial.Complete ~= true then
Visited = Visited + 1
end
ztaskVisittheFDRMemorial.Complete = true
Wherigo.MessageBox{Text=[[Dedicated to May 2, 1997, the monument, spread over 7.5 acres, traces 12 years of the history of the United States through a sequence of four outdoor rooms, one for each of FDR's terms of office. Sculptures inspired by photographs depict the 32nd president alongside his dog Fala. Other sculptures depict scenes from the Great Depression, such as listening to a fireside chat on the radio and waiting in a bread line. A bronze statue of First Lady Eleanor Roosevelt standing before the United Nations emblem honors her dedication to the UN.

Considering Roosevelt's disability, the memorial's designers intended to create a memorial that would be accessible to those with various physical impairments. Among other features, the memorial includes an area with tactile reliefs with braille writing for people who are blind. However, the memorial faced serious criticism from disabled activists. Some of the braille and reliefs were placed well above the reach of even a very tall person, rendering the braille pointless because no blind person could reach high enough to read it. The statue of FDR also stirred controversy over the issue of his disability. Designers decided against plans to have FDR shown in a wheelchair. Instead, the statue depicts the president in a chair with a cloak obscuring the chair. In deference to the disability advocates, the sculptor added casters to the back of the chair, making it a symbolic "wheelchair." These casters can only be seen if one looks behind the statue.

Many disability advocates remained upset with the FDR statue. A group spearheaded by the National Organization on Disability raised $1.65 million over two years to fund the addition of another statue that clearly showed the president in a wheelchair. In January 2001, the additional statue was placed near the memorial entrance showing FDR seated in a wheelchair much like the one he actually used.

In his 1941 State of the Union Address, as the nation contemplated the increasingly more inevitable prospect of being drawn into the war, President Roosevelt spelled out "Four Freedoms" as a reminder of what America must stand for. From the days of his first presidential campaign during the Great Depression, Roosevelt spoke directly to the people. "I pledge you, I pledge myself," he said in his 1932 acceptance speech, "to a new deal for the American people." Four years later, he proclaimed that "this generation of Americans has a rendezvous with destiny." Throughout his presidency, 1933-1945, he addressed America by radio in what came to be known as fireside chats. Each idea, each phrase was underscored by courage and optimism that inspired the people he served.

More than 50 years after Roosevelt's death, his own words call out from the walls of his memorial as if he were somehow present. Those who know FDR only as a historical figure recognize these words by their association with great and catastrophic events. For the many Americans who lived through the Roosevelt years, the words recall personal struggles and triumphs during 12 years that seemed like a lifetime.

Running water is an important physical and metaphoric component of the memorial. Each of the four "rooms" representing Roosevelt's respective terms in office contains a waterfall. As one moves from room to room, the waterfalls become larger and more complex, reflecting the increasing complexity of a presidency marked by the vast upheavals of economic depression and world war. When the memorial first opened, people were encouraged to wade into the fountains and waterfalls. Within a matter of days, the National Park Service prohibited people from entering the water because they were unable to get insurance.[citation needed]

Tour guides describe the symbolism of the five main water areas as:

    * A single large drop - The crash of the economy that led to the Great Depression
    * Multiple stairstep drops - The Tennessee Valley Authority dam-building project
    * Chaotic falls at varying angles - World War II
    * A still pool - Roosevelt's death
    * A wide array combining the earlier waterfalls - A retrospective of Roosevelt's presidency

Smaller waterfalls and a reflecting pool located between the "rooms" lend continuity to the water theme.

The memorial was designed by Lawrence Halprin, and includes sculptures and works by Leonard Baskin, Neil Estern, Robert Graham, Thomas Hardy, and George Segal. The national memorial is part of National Mall and Memorial Parks. As an historic area managed by the National Park Service, the memorial was administratively listed on the National Register of Historic Places on date of its establishment, May 2, 1997.]],}
end

function cartNationalMallandMemorialParks:OnSync()
-- #GroupDescription=save --
-- #Comment=save Comment --
Wherigo.GetInput(zinputcomplete)
end

function zoneKoreanWarVeterans:OnProximity()
-- #GroupDescription=KoreanWar --
-- #Comment=KoreanWar Comment --
if   ztaskVisittheKoreanWarVeteransMemorial.Complete ~= true then
Visited = Visited + 1
end
ztaskVisittheKoreanWarVeteransMemorial.Complete = true
Wherigo.MessageBox{Text=[[The Korean War Veterans Memorial was authorized by the U.S. Congress (Public Law 99-572) on October 28, 1986,[1] with design and construction managed by the Korean War Veterans Memorial Advisory Board and the American Battle Monuments Commission. President George H. W. Bush conducted the groundbreaking for the Memorial on June 14, 1992, Flag Day. It was dedicated on July 27, 1995, the 42nd anniversary of the armistice that ended the war, by President Bill Clinton and Kim Young Sam, President of the Republic of Korea, to the men and women who served during the conflict. Management of the memorial was turned over to the National Park Service, under its National Mall and Memorial Parks group. As with all National Park Service historic areas, the memorial was administratively listed on the National Register of Historic Places on the day of its dedication.

The memorial is in the form of a triangle intersecting a circle. Within the triangle are 19 stainless steel statues designed by Frank Gaylord,[2] each larger than life-size (between 7 feet 3 inches and 7 feet 6 inches), representing a squad on patrol, 15 Army, 2 Marines, 1 Navy Corpsman, and 1 Air Force Forward Air Observer, dressed in full combat gear, dispersed among strips of granite and juniper bushes, representing the rugged terrain of Korea. To the north of the statues is a path, forming one side of the triangle, and behind, to the south, is a 164 foot long black granite wall, created by Louis Nelson, with photographic images sandblasted into it depicting soldiers, equipment and people involved in the war, forming the second side. The third side of the triangle, facing towards the Lincoln Memorial, is open.

To the north of the statues and path is the United Nations Wall, a low wall listing the 22 members of the United Nations that contributed troops or medical support to the Korean war effort.

The circle contains the Pool of Remembrance, a shallow 30-foot-diameter pool lined with black granite and surrounded by a grove of trees with benches. Inscriptions list the numbers killed, wounded, missing in action, and held as prisoners of war, and a nearby plaque in inscribed: "Our nation honors her sons and daughters who answered the call to defend a country they never knew and a people they never met." Additionally, right next to the numbers of American soldiers are those of the United Nations troops in the same categories. In the south side of the memorial, there are three bushes of the Rose of Sharon hibiscus plant, South Korea's national flower.

A further granite wall bears the simple message, inlaid in silver: "Freedom Is Not Free".

Engraved on granite blocks near the water pool at the east end of the monument are the casualty statistics for the soldiers who fought in the war.

    * Dead   United States: 54,246,[3] United Nations: 628,833
    * Wounded   United States: 103,284, United Nations: 1,064,453.
    * Captured   United States: 7,140, United Nations: 92,970.
    * Missing   United States: 8,177,[4] United Nations: 470,267.]],}
end

function zoneNationalMallTour:OnEnter()
-- #GroupDescription=NationalMallTour --
-- #Comment=NationalMallTour Comment --
Wherigo.MessageBox{Text=[[Welcome to the National Mall Tour!  There are 7 sites to visit in this tour, and each site is listed in your tasks section.  As you enter each zone, that task will be complete.  If, upon leaving the tour, you've visited all of the locations, the cartridge will be marked as complete.  Have fun, and enjoy your trip to Washington D.C.!]],}
end

function zoneNationalMallTour:OnExit()
-- #GroupDescription=Exit --
-- #Comment=Exit Comment --
if   Visited == 7 then
Wherigo.MessageBox{Text=[[Congratulations, you visited every site!  Your cartridge has been marked as complete.]],}
end
if   Visited < 7 then
Wherigo.MessageBox{Text=[[It looks like you still have a few sites to visit, save your cartridge and come back soon!]],}
end
end

function zoneLincolnMemorial:OnProximity()
-- #GroupDescription=LincolnMemorial --
-- #Comment=LincolnMemorial Comment --
if   ztaskVisittheLincolnMemorial.Complete ~= true then
Visited = Visited + 1
end
ztaskVisittheLincolnMemorial.Complete = true
Wherigo.MessageBox{Text=[[The Lincoln Memorial, is located in the National Mall in Washington, D.C. it is a United States Presidential memorial built to honor 16th President Abraham Lincoln. The architect was Henry Bacon, the sculptor was Daniel Chester French, and the painter of the interior murals was Jules Guerin.

The building is in the form of a Greek Doric temple and contains a large seated sculpture of Abraham Lincoln and inscriptions of two well-known speeches by Lincoln. The memorial has been the site of many famous speeches, including Martin Luther King's "I Have a Dream" speech, delivered on August 28, 1963, during the rally at the end of the March on Washington for Jobs and Freedom.

Like the other monuments on the National Mall, including the nearby Vietnam Veterans Memorial, Korean War Veterans Memorial, and National World War II Memorial, the Lincoln Memorial is administered by the National Park Service under its National Mall and Memorial Parks group. The National Memorial has been listed on the National Register of Historic Places since October 15, 1966. It is open to the public 24 hours a day.

The Lincoln Monument Association was incorporated by the United States Congress in March 1867 to build a memorial to Lincoln. A site was not chosen until 1901, in an area that was then swampland. Congress formally authorized the memorial on February 9, 1911, and the first stone was put into place on Lincoln's birthday, February 12, 1914. The monument was dedicated by Chief Justice William Howard Taft on May 30, 1922, a ceremony attended by Lincoln's only surviving child, Robert Todd Lincoln. The stone for the building is Indiana limestone and Yule marble, quarried at the town of Marble, Colorado. The Lincoln sculpture within is made of Georgian marble, quarried at the town of Tate, Georgia. In 1923, designer Henry Bacon received the Gold Medal of the American Institute of Architects, his profession's highest honor, for the design of the memorial. Originally under the care of the Office of Public Buildings and Public Parks, it was transferred to the National Park Service on August 10 1933

Standing apart from the somewhat triumphal and Roman manner of most of Washington, the memorial takes the severe form of a Greek Doric temple. It is 'peripteral,' with 36 massive columns, each 37 feet (10 m) high, surrounding the cella of the building itself, which rises above the porticos. As an afterthought, the 36 columns required for the design were seen to represent the 36 U.S. states at the time of Lincoln's death, and their names were inscribed in the entablature above each column. The names of the 48 states of the Union when the memorial was completed are carved on the exterior attic walls, and a later plaque commemorates the admission of Alaska and Hawaii in 1959.

The main influence on the style of the Lincoln Memorial was the Temple of Zeus at Olympia, Greece. The focus of the memorial is Daniel Chester French's sculpture of Lincoln, seated on a throne. French studied many of Mathew Brady's photographs of Lincoln and depicted the President as worn and pensive, gazing eastwards down the Reflecting Pool toward the capital's starkest emblem of the Union, the Washington Monument. Beneath his hands, the Roman fasces, symbols of the authority of the Republic, are sculpted in relief on the seat. The statue stands 19 feet 9 inches (6 m) tall and 19 feet (6 m) wide, and was carved from 28 blocks of white Georgia marble.

The central cella is flanked by two others. In one, Lincoln's Gettysburg Address is inscribed on the south wall, and in the other, Lincoln's second inaugural address is inscribed on the north wall.On the latter, the word Future was carved with an E instead of F and had to be filled in and can still be seen today. Above the texts are a series of murals by Jules Guerin that depict an angel (representing truth), the freeing of a slave (on the south wall, above the Gettysburg Address) and the unity of the American North and South (above the Second Inaugural Address). On the wall behind the statue, and over Abraham's head is this dedication:

IN THIS TEMPLE

AS IN THE HEARTS OF THE PEOPLE

FOR WHOM HE SAVED THE UNION

THE MEMORY OF ABRAHAM LINCOLN

IS ENSHRINED FOREVER

In 1939 Marian Anderson was refused permission by the Daughters of the American Revolution to perform at Constitution Hall in Washington because of her skin color. At the suggestion of Eleanor Roosevelt, the wife of Franklin Delano Roosevelt, Harold L. Ickes, the Secretary of the Interior, arranged for Anderson to perform from the steps of the Lincoln Memorial, to a live audience of 70,000, and a nationwide radio audience.

On August 28, 1963, the memorial grounds were the site of one of the greatest political rallies in American history, the March on Washington for Jobs and Freedom, which proved to be a high point of the American Civil Rights Movement. It is estimated that approximately 250,000 people came to the event, where they heard Martin Luther King, Jr., deliver his memorable speech, "I Have a Dream," before the memorial honoring the president who had issued the Emancipation Proclamation 100 years earlier. D.C. police also appreciated the location because it was surrounded on three sides by water, so that any incident could be easily contained.[1] A marked tile on the memorial's steps shows where Dr. King stood. On August 28, 1983, crowds gathered again to mark the 20th Anniversary Mobilization for Jobs, Peace and Freedom, to reflect on progress in gaining civil rights for African Americans, and to commit to correcting continuing injustices.

The site has had its share of unusual events. On May 9, 1970, President Richard Nixon had a remarkable middle-of-the-night impromptu, brief meeting with protestors preparing to march against the Vietnam War just days after the Kent State shootings. For President Bush's 2001 inauguration celebration, the Rockettes dance troupe kicked their legs in the air while marching down the monument's steps. On November 27, 2006, the memorial was partially closed when a suspicious liquid was found in a bathroom. Also found was an "anthrax threat letter", according to authorities.

There are a number of urban legends associated with the memorial. Some have claimed that Robert E. Lee's face is carved onto the back of Lincoln's statue. Another popular legend is that Lincoln is shown using sign language to represent his initials, with his left hand shaped to form an "A" and his right hand to form an "L". The National Park Service denies both stories. However, historian Gerald Prokopowicz writes that, while it is not clear that sculptor Daniel Chester French intended Lincoln's hands to be formed into sign language versions of his initials, it is possible that French did intend it, since he was familiar with American Sign Language, and he would have had a reason to do so, i.e., to pay tribute to Lincoln for having signed the federal legislation giving Gallaudet University, a university for the deaf, the authority to grant college degrees.]],}
end

function zoneThomasJeffersonMemorial:OnProximity()
-- #GroupDescription=ThomasJefferson --
-- #Comment=ThomasJefferson Comment --
if   ztaskVisittheThomasJeffersonMemorial.Complete ~= true then
Visited = Visited + 1
end
ztaskVisittheThomasJeffersonMemorial.Complete = true
Wherigo.MessageBox{Text=[[The Thomas Jefferson Memorial is a presidential memorial in Washington, D.C. that is dedicated to Thomas Jefferson, an American Founding Father and the third president of the United States. The neoclassical building was designed by John Russell Pope. It was built by Philadelphia contractor John McShain and was completed in 1943. When completed, the memorial occupied one of the last significant sites left in the city.

Composed of circular marble steps, a portico, a circular colonnade of Ionic order columns, and a shallow dome, the building is open to the elements. Pope made references to the Roman Pantheon and Jefferson's own design for the Rotunda at the University of Virginia. It is situated in West Potomac Park, on the shore of the Tidal Basin of the Potomac River. The Jefferson Memorial and the White House located directly north, form one of the main anchor points in the area of the National Mall in D.C. The Washington Monument just east of the axis on the national Mall was intended to be located at the intersection of the White House and the site for the Jefferson Memorial to the south but soft swampy ground which defied nineteenth century engineering required it be sited to the east. The Jefferson Memorial is managed by the National Park Service under its National Mall and Memorial Parks division.

By 1930, there were monuments in Washington D.C. commemorating great United States presidents, including Abraham Lincoln and George Washington. President Franklin Roosevelt thought that Thomas Jefferson also deserved a monument. On June 26, 1934, following his initiative, Congress passed a resolution to create a monument commemorating Jefferson.

The memorial was designed by John Russell Pope   also the architect of the original (west) building of the National Gallery of Art. The memorial's design reflects characteristics of buildings designed by Jefferson such as Monticello and the Rotunda, which reflect his fascination with Roman architecture. The Jefferson Memorial bears some resemblance to the Pantheon of Rome.

The cornerstone was laid on November 15, 1939   two years after Pope's death. Daniel P. Higgins and Otto R. Eggers took over construction of the memorial. The memorial was constructed with Danby Imperial marble (Vermont) for the exterior walls and columns, Tennessee pink marble for the interior floor, Georgian white marble for the interior wall panels, and Missouri gray marble for the pedestal. Indiana limestone was used in construction of the ceiling. [1] The cost of construction was slightly more than $3 million.

The Jefferson Memorial was officially dedicated on April 13, 1943   the 200th anniversary of Jefferson's birthday. One of the last American public monuments in the Beaux-Arts tradition, it was severely criticized even as it was being built, by those who adhered to the modernist argument that dressing 20th century buildings like Greek and Roman temples constituted a "tired architectural lie." More than 60 years ago, Pope responded with silence to critics who dismissed him as part of an enervated architectural elite practicing "styles that are safely dead". As a National Memorial it was administratively listed on the National Register of Historic Places on October 15, 1966.

The interior of the memorial has a 19 foot (5.8 m) tall, 10,000 pound (5 ton) bronze statue of Jefferson by sculptor Rudulph Evans which was added four years after the dedication, and the interior walls are engraved with passages from Jefferson's writings. Most prominent are the words which are inscribed in a frieze below the dome: "I have sworn upon the altar of God eternal hostility against every form of tyranny over the mind of man." This sentence is taken from a September 23, 1800, letter by Jefferson to Dr. Benjamin Rush.

The Jefferson Memorial has a room filled with his accomplishments and a 5 foot tall bio inscribed in granite.

The site of the monument in Washington D.C West Potomac Park, on the shore of the Potomac River Tidal Basin, is enhanced with the massed planting of Japanese cherry trees, the gift of the people of Japan in 1912. The monument is not as prominent in popular culture as other Washington, D.C. buildings and monuments, possibly due to its location well removed from the National Mall and the Washington Metro.

The Jefferson Memorial hosts many events and ceremonies each year, including memorial exercises, the Easter Sunrise Service, and the annual National Cherry Blossom Festival.]],}
end

function zoneVietnamVeteransMemorial:OnProximity()
-- #GroupDescription=VietNam --
-- #Comment=VietNam Comment --
if   ztaskVisittheVietnamVeteransMemorial.Complete ~= true then
Visited = Visited + 1
end
ztaskVisittheVietnamVeteransMemorial.Complete = true
Wherigo.MessageBox{Text=[[The Vietnam Veterans Memorial is a national war memorial located in Washington, D.C., that honors members of the U.S. armed forces who fought in the Vietnam War and who died in service or are still unaccounted for.

Its construction and related issues have been the source of numerous controversies, some of which have resulted in additions to the memorial complex. The memorial currently consists of three separate parts: the Three Soldiers statue, the Vietnam Women's Memorial, and the Vietnam Veterans Memorial Wall, which is the most recognized part of the memorial.

The main part of the memorial was completed in 1982 and is located in Constitution Gardens adjacent to the National Mall, just northeast of the Lincoln Memorial. The Vietnam Veterans Memorial is maintained by the U.S. National Park Service, and receives around 3 million visitors each year. The Memorial Wall was designed by U.S. architect Maya Lin. The typesetting was performed by Datalantic in Atlanta, Georgia.

Memorial Wall

The Memorial Wall, designed by Maya Ying Lin, is made up of two black granite walls 246 feet 9 inches (75 meters) long. The walls are sunk into the ground, with the earth behind them. At the highest tip (the apex where they meet), they are 10.1 feet (3 m) high, and they taper to a height of eight inches (20cm) at their extremities. Granite for the wall came from Bangalore, Karnataka, India and was deliberately chosen because of its reflective quality. Stone cutting and fabrication was done in Barre, Vermont. Stones were then shipped to Memphis, Tennessee where the names were etched. The etching was completed using a photoemulsion and sandblasting process developed at GlassCraft by their research and development division (now known as Glassical, Inc.). The negatives used in the process are in storage at the Smithsonian Institution. When a visitor looks upon the wall, his or her reflection can be seen simultaneously with the engraved names, which is meant to symbolically bring the past and present together. One wall points toward the Washington Monument, the other in the direction of the Lincoln Memorial, meeting at an angle of 125  12 . Each wall has 72 panels, 70 listing names (numbered 1E through 70E and 70W through 1W) and 2 very small blank panels at the extremities. There is a pathway along the base of the Wall, where visitors may walk, read the names, make a pencil rubbing of a particular name, or pray. Some people leave sentimental items there for their deceased loved ones, and non-perishable items are stored at the Museum and Archaeological Regional Storage Facility, with the exception of miniature American flags.

Inscribed on the walls with the Optima typeface are the names of servicemen who either KIA (Killed in Action) or remained classified as MIA (Missing in Action) when the walls were constructed in 1982. They are listed in chronological order, starting at the apex on panel 1E in 1959 (although it was later discovered that the first casualties were military advisers who were killed by artillery fire in 1957), moving day by day to the end of the eastern wall at panel 70E, which ends on May 25, 1968, starting again at panel 70W at the end of the western wall which completes the list for May 25, 1968, and returning to the apex at panel 1W in 1975. Symbolically, this is described as a "wound that is closed and healing." Information about rank, unit, and decorations are not given. The wall listed 58,159 names when it was completed in 1993; as of May 5, 2007, when another name was added, there are 58,256 names, including 8 women. Approximately 1,200 of these are listed as missing (MIAs, POWs, and others), denoted with a cross; the confirmed dead are marked with a diamond. If the missing return alive, the cross is circumscribed by a circle, (although this has never occurred as of January 2007); if their death is confirmed, a diamond is superimposed over the cross. According to the Vietnam Veterans Memorial Fund "there is no definitive answer to exactly how many, but there could be as many as 38 names of personnel who survived, but through clerical errors, were added to the list of fatalities provided by the Department of Defense."[1] Visitors can use directories to locate specific names.

A short distance away from the wall is another part of the memorial, a bronze statue named The Three Soldiers (sometimes called The Three Servicemen). Negative reactions to Lin's design created a raging controversy; a compromise was reached by commissioning Frederick Hart (who had placed third in the original design competition) to produce a bronze figurative sculpture in the heroic tradition in order to complement the memorial wall. The statue was unveiled in 1984 and depicts three soldiers, purposefully identifiable as White American, Black American, and Hispanic American. The statue and the Wall appear to interact with each other, with the soldiers looking on in solemn tribute at the names of their dead comrades. The distance between the two allows them to interact while minimizing the impact of the addition on Lin's design.

Also part of the memorial is the Vietnam Women's memorial. It is located a short distance south of The Wall, north of the Reflecting Pool. It was designed by Glenna Goodacre and dedicated on November 11, 1993, to the women of the United States who served in the Vietnam War, most of whom were nurses.

In Memory memorial plaque

A memorial plaque, authorized by Pub.L. 106-214, was dedicated on November 10, 2004, at the northeast corner of the plaza surrounding the Three Soldiers statue to honor veterans who died after the war as a direct result of injuries suffered in Vietnam, but who fall outside Department of Defense guidelines. The plaque is a carved block of black granite, 3 feet (0.91 m) by 2 feet (0.61 m), inscribed "In memory of the men and women who served in the Vietnam War and later died as a result of their service. We honor and remember their sacrifice."

Ruth Coder Fitzgerald, founder of The Vietnam War In Memory Memorial Plaque Project, worked for years and struggled against opposition to have the In Memory Memorial Plaque completed. The organization was disbanded, but their web site is maintained by the Vietnam War Project at Texas Tech University.

Controversies

The Vietnam War was both the longest, and arguably most controversial war in United States history to date. A stated goal of the memorial fund was to avoid commentary on the war itself, serving solely as a memorial to those who served. Nevertheless, a large number of controversies have surrounded the memorial.

One early controversy related to the political leaders who did not appear at the 1982 dedication of the Vietnam Veterans Memorial. Neither Richard Nixon, Jimmy Carter or Ronald Reagan attended the ceremony. 

Despite this, or even perhaps partly due to it, the memorial seems to have been very successful in many ways. As noted above, it is visited by millions of people every year, and thousands of offerings and tokens are left by visitors.

The initial design for the complex was that of the memorial wall. The other elements were added later and were not part of the initial plans. The design was chosen by a panel of eight professional artists and architects. It is abstract in form, and strikingly in contrast to the figurative memorials, usually in white stone or bronze, whose tradition goes back hundreds, if not thousands of years. Thus, it did not meet many people's ideas of what a monument should look like.

Veterans and others[attribution needed] complained that it looked too much like an ugly scar in the ground, reflecting the attitude and stigma the American government and public had towards the war and its veterans. In particular, the fact that the wall sloped down below ground level caused some to claim that the monument attempted to hide the war. Some say[attribution needed] that the downward slope, changing to a rise, serves as a powerful metaphor for the American experience during the war for visitors who walk its length. The simple, elegant listing of the names of the fallen starts slowly and grows in magnitude on descent. They believe that it is not possible to visit without gaining an understanding of the cultural trauma that gripped the nation during these years. Others claimed the dark stone made it look like a gravestone rather than glorifying the dead. On exiting, the view opens with a view toward the Washington Monument, giving those who lived through the era an uneasy sense of relief that the war is in the past and the nation was able to rise above it.]],}
end

function zoneWashingtonMonument:OnProximity()
-- #GroupDescription=WashingtonMonument --
-- #Comment=WashingtonMonument Comment --
if   ztaskVisittheWashingtonMonument.Complete ~= true then
Visited = Visited + 1
end
ztaskVisittheWashingtonMonument.Complete = true
Wherigo.MessageBox{Text=[[The Washington Monument is a large, tall white-colored obelisk at the west end of the National Mall in Washington, D.C. It is a United States Presidential Memorial constructed to commemorate George Washington.

The monument is among the world's tallest masonry structures and is the world's tallest obelisk, standing 555 feet 5.125 inches (169.29 m) in height and made of marble, granite, and sandstone. It was designed by Robert Mills, a prominent American architect of the 1840s. The actual construction of the monument began in 1848 but was not completed until 1884, almost 30 years after the architect's death. This hiatus in construction was because of a lack of funds and the intervention of the American Civil War. A difference in shading of the marble, visible approximately 150 feet (45 m) up, clearly delineates the initial construction from its resumption in 1876.

Its cornerstone was laid on July 4, 1848; the capstone was set on December 6, 1884, and the completed monument was dedicated on February 21, 1885. It officially opened October 9, 1888. Upon completion, it became the world's tallest structure, a title it inherited from the Cologne Cathedral and held until 1889, when the Eiffel Tower was finished in Paris, France.

The Washington Monument reflection can be seen in the aptly named Reflecting Pool, a rectangular pool extending to the west towards the Lincoln Memorial.

Above the Founding Fathers of the United States, George Washington earned the title "Father of the Country" in recognition of his leadership in the cause of American independence. Appointed as commander of the Continental Army in 1775, he molded a fighting force that won independence from the Kingdom of Great Britain. In 1787, as president of the Constitutional Convention, he helped guide the deliberations to form a government that has lasted for more than 200 years. Two years later he was unanimously elected the President of the United States. Washington defined the Presidency and helped develop the relationships among the three branches of government. He established precedents which successfully launched the new government on its course. He refused the trappings of power and veered from monarchical government and traditions and twice despite considerable pressure to do otherwise gave up the most powerful position in the Americas. Washington remained ever mindful of the ramifications of his decisions and actions. With this monument the citizens of the United States show their enduring gratitude and respect.

When the Revolutionary War ended, no man in the United States commanded more respect than George Washington. Americans celebrated his ability to win the war despite limited supplies and inexperienced men, and they admired his decision to refuse a salary and accept only reimbursements for his expenses. Their regard increased further when it became known that he had rejected a proposal by some of his officers to make him king of the new country. It was not only what Washington did but the way he did it: Abigail Adams, wife of John Adams, described him as "polite with dignity, affable without familiarity, distant without haughtiness, grave without austerity, modest, wise, and good."

Washington retired to his plantation at Mount Vernon after the war, but he soon had to decide whether to return to public life. As it became clear the Articles of Confederation had left the federal government too weak to levy taxes, regulate trade, or control its borders, men such as James Madison began calling for a convention that would strengthen its authority. Washington was reluctant to attend because he had business affairs to manage at Mount Vernon. If he did not go to Philadelphia, however, he worried about his reputation and about the future of the country. He finally decided that, since "to see this nation happy  is so much the wish of my soul," he would serve as one of Virginia's representatives. The other delegates during the summer of 1787 chose him to preside over their deliberations, which ultimately produced the U.S. Constitution.

A key part of the Constitution was the development of the office of president of the United States. No one seemed more qualified to fill that position than Washington, and in 1789 he began the first of his two terms. He used the nation's respect for him to develop respect for this new office, but he simultaneously tried to quiet fears that the president would become as powerful as the king the new country had fought against. He tried to create the kind of solid government he thought the nation needed, supporting a national bank, collecting taxes to pay for expenses, and strengthening the Army and Navy. Though many people wanted him to stay for a third term, in 1797 he again retired to Mount Vernon.[1] Washington died suddenly two years later. His death restarted attempts to honor him. As early as 1783, the Continental Congress had resolved "That an equestrian statue of George Washington be erected at the place where the residence of Congress shall be established." The proposal called for engraving on the statue which explained it had been erected "in honor of George Washington, the illustrious Commander-in-Chief of the Armies of the United States of America during the war which vindicated and secured their liberty, sovereignty, and independence."

Ten days after Washington's death, a Congressional committee recommended a different type of monument. John Marshall, a Representative from Virginia (who later became Chief Justice of the Supreme Court) proposed that a tomb be erected within the Capitol. But a lack of funds, disagreement over what type of memorial would best honor the country's first president, and the Washington family's reluctance to move his body prevented progress on any project. 


Progress towards a memorial finally began in 1833. That year, which marked the 100th anniversary of Washington's birth, a large group of concerned citizens formed the Washington National Monument Society. They began collecting donations, much in the way Blodgett had suggested. By the middle of the 1830s, they had raised over $28,000 and announced a competition for the design of the memorial.

On September 23, 1835, the board of managers of the society described their expectations:

    "It is proposed that the contemplated monument shall be like him in whose honor it is to be constructed, unparalleled in the world, and commensurate with the gratitude, liberality, and patriotism of the people by whom it is to be erected  [It] should blend stupendousness with elegance, and be of such magnitude and beauty as to be an object of pride to the American people, and of admiration to all who see it. Its material is intended to be wholly American, and to be of marble and granite brought from each state, that each state may participate in the glory of contributing material as well as in funds to its construction."

The society held a competition for designs in 1836. The winner, architect Robert Mills, was well-qualified for the commission. The citizens of Baltimore had chosen him to build a monument to Washington, and he had designed a tall Greek column surmounted by a statue of the President. Mills also knew the capital well, having just been chosen Architect of Public Buildings for Washington.

His design called for a 600-foot (183 m) tall obelisk an upright, four-sided pillar that tapers as it rises with a nearly flat top. He surrounded the obelisk with a circular colonnade, the top of which would feature Washington standing in a chariot. Inside the colonnade would be statues of 30 prominent Revolutionary War heroes.

Yet criticism of Mills' design and its estimated price tag of more than $1 million (over $21 million in 2008 dollars[2]) caused the society to hesitate. In 1848, its members decided to start building the obelisk and to leave the question of the colonnade for later. They believed that if they used the $87,000 they had already collected to start work, the appearance of the monument would spur further donations that would allow them to complete the project.

The design was also created to be tall and make it look exceptionally grand.

Excavation for the foundation of the Washington Monument began in the spring of 1848. The cornerstone was laid as part of an elaborate Fourth of July ceremony hosted by the Freemasons, a worldwide fraternal organization to which Washington belonged. Speeches that day showed the country continued to revere Washington. One celebrant noted, "No more Washingtons shall come in our time ... But his virtues are stamped on the heart of mankind. He who is great in the battlefield looks upward to the generalship of Washington. He who grows wise in counsel feels that he is imitating Washington. He who can resign power against the wishes of a people, has in his eye the bright example of Washington."

Construction continued until 1854, when donations ran out. The next year, Congress voted to appropriate $200,000 to continue the work but rescinded before the money could be spent. This reversal came because of a new policy the society had adopted in 1849. It had agreed, after a request from some Alabamians, to encourage all states and territories to donate memorial stones that could be fitted into the interior walls. Members of the society believed this practice would make citizens feel they had a part in building the monument, and it would cut costs by limiting the amount of stone that had to be bought. Blocks of Maryland marble, granite and sandstone steadily appeared at the site. American Indian tribes, professional organizations, societies, businesses and foreign nations donated stones that were 4 feet by 2 feet by 12 18 inches (1.2 by 0.6 by 0.3 to 0.5 m). Many, however, carried inscriptions irrelevant to a memorial for George Washington. For example, one from the Templars of Honor and Temperance stated "We will not buy, sell, or use as a beverage, any spiritous or malt liquors, Wine, Cider, or any other Alcoholic Liquor." It was just one memorial stone that started the events that stopped the Congressional appropriation and ultimately construction altogether. In the early 1850s, Pope Pius IX contributed a block of marble. In March 1854, members of the anti-Catholic, nativist American Party better known as the "Know-Nothings" stole the Pope's stone as a protest and supposedly threw it into the Potomac. Then, in order to make sure the monument fit the definition of "American" at that time, the Know-Nothings conducted an election so they could take over the entire society[citation needed]. Congress immediately rescinded its $200,000 contribution.

The Know-Nothings retained control of the society until 1858, adding 13 courses of masonry to the monument all of which was of such poor quality it was later removed. Unable to collect enough money to finish work, they increasingly lost public support. The Know-Nothings eventually gave up and returned all records to the original society, but the stoppage in construction continued into, then after, the Civil War.

Interest in the monument grew after the Civil War ended. Engineers studied the foundation several times to see whether it remained strong enough. In 1876, the Centennial of the Declaration of Independence, Congress agreed to appropriate another $200,000 to resume construction. The monument, which had stood for nearly 20 years at less than one-third of its proposed height, now seemed ready for completion.

Before work could begin again, however, arguments about the most appropriate design resumed. Many people thought a simple obelisk, one without the colonnade, would be too bare. Architect Mills was reputed to have said omitting the colonnade would make the monument look like "a stalk of asparagus"; another critic said it offered "little  to be proud of."

This attitude led people to submit alternative designs. Both the Washington National Monument Society and Congress held discussions about how the monument should be finished. The society considered five new designs, concluding that the one by William Wetmore Story seemed "vastly superior in artistic taste and beauty." Congress deliberated over those five as well as Mills' original; while it was deciding, it ordered work on the obelisk to continue. Finally, the members of the society agreed to abandon the colonnade and alter the obelisk so it conformed to classical Egyptian proportions.

Construction resumed in 1879 under the direction of Lieutenant Colonel Thomas Lincoln Casey of the U.S. Army Corps of Engineers. Casey redesigned the foundation, strengthening it so it could support a structure that ultimately weighed more than 40,000 tons. He then followed the society's orders and figured out what to do with the memorial stones that had accumulated. Though many people ridiculed them, Casey managed to install all 193 stones in the interior walls. One difficulty that is visible to this day is that the builders were unable to find the same quarry stone used in the initial construction and, as a result, the bottom third of the monument is a slightly darker shade than the rest of the construction.

The building of the monument proceeded quickly after Congress had provided sufficient funding. In four years, it was finally completed, with the 100 ounce (2.8 kg) aluminum capstone being put in place on December 6, 1884, during another elaborate dedication ceremony. It was the largest single piece of aluminum cast at the time. At the time of the monument's construction, aluminum was more expensive than silver, gold, or platinum. Over time, however, the price of the metal dropped; the invention of the Hall-H roult process in 1886 caused the high price of aluminum to permanently collapse. The monument opened to the public on October 9, 1888.

At the time of its construction, it was the tallest building in the world. It is still the tallest building in Washington, D.C. A 1910 law restricts new building heights to no more than 20 feet (6 m) greater than the width of the adjacent street. (There is a popular misconception that the law specifies that no building may be taller than the Washington Monument, but in fact the law makes no mention of it). Ordinary antique obelisks were seldom taller than around 100 feet (30 m), making this monument vastly taller than the obelisks around the capitals of Europe and in Egypt.

The Washington Monument brought enormous crowds even before it officially opened. During the six months that followed its dedication, 10,041 people climbed the 893 steps to the top. After the elevator that had been used to raise building materials was altered so that it could carry passengers, the number of visitors grew rapidly. As early as 1888, an average of 55,000 people per month went to the top, and today the Washington Monument has more than 800,000 visitors each year. As with all historic areas administered by the National Park Service, the national memorial was listed on the National Register of Historic Places on October 15, 1966. The stairs are no longer accessible to the general public due to safety issues and vandalism of the interior memory plaques.

For ten hours in December 1982, the Washington Monument was "held hostage" by a nuclear arms protester, Norman Mayer, claiming to have explosives in a van he drove up to the monument's base. Eight tourists trapped in the monument at the time the standoff began were set free, and the incident ended with U.S. Park Police opening fire on Mayer and killing him. The monument was undamaged in the incident, and it was discovered later Mayer did not have explosives.]],}
end

function zoneWorldWarIIMemorial:OnProximity()
-- #GroupDescription=WWII --
-- #Comment=WWII Comment --
if   ztaskVisittheWWIIMemorial.Complete ~= true then
Visited = Visited + 1
end
ztaskVisittheWWIIMemorial.Complete = true
Wherigo.MessageBox{Text=[[The National World War II Memorial is a National Memorial to all Americans that served in the armed forces and on the home front during World War II. It is located on the National Mall in Washington, D.C., on the former site of the Rainbow Pool at the eastern end of the Reflecting Pool, between the Lincoln Memorial and the Washington Monument.

It opened to the public on April 29, 2004, and was dedicated by President George W. Bush on May 29, 2004, two days before Memorial Day. The memorial is administered by the National Park Service under its National Mall and Memorial Parks group.
Contents
[hide]

    * 1 History
          o 1.1 Fundraising
          o 1.2 Picking the site
    * 2 Design and construction
          o 2.1 Freedom Wall
          o 2.2 Construction
    * 3 Controversy
    * 4 References
    * 5 External links

[edit] History

In 1987, World War II veteran Roger Durbin approached Representative Marcy Kaptur, a Democrat from Ohio, to ask if a World War II memorial could be constructed. Kaptur introduced the World War II Memorial Act to the House of Representatives as HR 3742 on December 10. The resolution authorized the American Battle Monuments Commission (ABMC) to establish a World War II memorial in "Washington, D.C., or its environs," but the bill was not voted on before the end of the session, so it was not passed. Two more times, in 1989 and 1991, Rep. Kaptur introduced similar legislation, but these bills suffered the same fate as the first, and did not become law.

Kaptur reintroduced legislation in the House a fourth time as HR 682 on January 27, 1993, one day after Senator Strom Thurmond (a Republican from South Carolina) introduced companion Senate legislation. On March 17, 1993, the Senate approved the act, and the House approved an amended version of the bill on May 4. On May 12, the Senate also approved the amended bill, and the World War II Memorial Act was signed into law by President Bill Clinton on May 25 of that year, becoming Public Law 103-32.

[edit] Fundraising

On September 30, 1994, President Bill Clinton appointed a 12-member Memorial Advisory Board (MAB) to advise the ABMC in picking the site, designing the memorial, and raising money to build it. A direct mail fundraising effort brought in millions of dollars from individual Americans. Additional large donations were made by veterans' groups, including The American Legion, The Veterans of Foreign Wars, Veterans of the Battle of the Bulge and others. The majority of the corporate fundraising effort was led by two co-chairs: Senator Bob Dole, a decorated World War II veteran and 1996 Republican nominee for president; and Frederick W. Smith, the president and chief executive officer of FedEx Corporation and a former U.S. Marine Corps officer. The U.S. federal government provided about $16 million. All told, $197 million was raised.

[edit] Picking the site
Aerial view of The National WWII Memorial (bottom) and the Lincoln Memorial (top)
Aerial view of The National WWII Memorial (bottom) and the Lincoln Memorial (top)

In October 1994, Clinton signed Joint Resolution 227 into law, mandating that the monument be located in downtown Washington, near other memorials. On January 20, 1995, the ABMC and MAB held their first meeting to discuss site selection. Representatives from the United States Commission of Fine Arts (CFA), the National Capital Planning Commission (NCPC), the National Capital Memorial Commission (NCMC), and U.S. Army Corps of Engineers, as well as the National Park Service, also attended the meeting.

Several sites were considered. These quickly gained favor:[1][2]

    * U.S. Capitol Reflecting Pool area   between 3rd Street and the Ulysses S. Grant Memorial.
    * Constitution Gardens   east end, between Constitution Avenue and the Rainbow Pool.
    * Freedom Plaza   on Pennsylvania Avenue between 14th and 15th Streets.

Other sites considered but quickly rejected were:

    * Tidal Basin   northeast side, east of the Tidal Basin parking lot and west of the 14th Street Bridge access road.
    * West Potomac Park   between Ohio Drive and the north shore of the Potomac River, northwest of the Franklin Delano Roosevelt Memorial.
    * Grounds of the Washington Monument   at Constitution Avenue between 14th and 15th Streets, west of the National Museum of American History.
    * Henderson Hall, adjacent to Arlington National Cemetery   this site was dropped from consideration because of its unavailability.

The selection of the Rainbow Pool site was announced on October 5, 1995. The design would incorporate the Rainbow Pool fountain, located across 17th Street from the Washington Monument and near the Constitution Gardens site.[3]

[edit] Design and construction

A nationwide design competition drew more than 600 submissions. Friedrich St. Florian's initial design was selected in 1997. Over the next four years, St. Florian's design was altered during the review and approval process required of proposed memorials in Washington, D.C.
The memorial under construction (August 2002)
The memorial under construction (August 2002)

The final design consists of 56 pillars, each 17 feet (5 m) tall, arranged in a semicircle around a plaza with two 43-foot (13 m) arches on opposite sides. Each pillar is inscribed with the name of one of the 48 U.S. states of 1945, as well as the District of Columbia, the Alaska Territory and Territory of Hawaii, the Commonwealth of the Philippines, Puerto Rico, Guam, American Samoa, and the U.S. Virgin Islands. The northern arch is inscribed with "Atlantic"; the southern one, "Pacific." The plaza is 337 ft, 10 in (103.0 m) long and 240 feet, 2 inches (73.2 m) wide, is sunk 6 feet (1.8 m) below grade, and contains a pool that is 246 feet 9 inches by 147 feet 8 inches (75.2   45.0 m).

Sculptor Raymond Kaskey created the bronze eagles and wreaths that were installed under the arches, and 24 bronze bas-relief panels that depict wartime scenes of combat and the home front.[4]

The memorial includes an engraving typical of the Kilroy graffiti: "Kilroy was here".

[edit] Freedom Wall
"Here we mark the price of freedom"; each of the 4,048 gold stars represents 100 Americans who died during the war.
"Here we mark the price of freedom"; each of the 4,048 gold stars represents 100 Americans who died during the war.

The Freedom Wall is on the west side of the memorial, with a view of the Reflecting Pool and Lincoln Memorial behind it. The wall contains 4,048 gold stars, each representing 100 Americans who died in the war.[5]

[edit] Construction

Ground was broken in September 2001. The construction was managed by the General Services Administration.

The memorial opened to the public on April 29, 2004, and was dedicated on May 29 in a ceremony attended by thousands of people from all parts of the country. The memorial became a national park on November 1, when authority over it was transferred to the National Park Service.

[edit] Controversy

Critics such as the National Coalition to Save Our Mall opposed the design and the location of the memorial. A major criticism of the location is that it would interrupt what had been an unbroken view between the Washington Monument and the Lincoln Memorial. The memorial was also criticized for taking up open space that had been historically used for major demonstrations and protests[6].

Critics were particularly bothered by the expedited approval process, which is normally quite lengthy[7]. The United States Congress, worried that World War II veterans were dying before an appropriate memorial could be built, passed legislation exempting the National World War II Memorial from further site and design review. Congress also dismissed pending legal challenges to the memorial[8]. There were also aesthetic objections to the design. A critic from the Boston Herald described the monument as "vainglorious, demanding of attention and full of trite imagery."[9] The Philadelphia Inquirer argued that "this pompous style was also favored by Hitler and Mussolini"[10] (see Nazi architecture).

Supporters, meanwhile, argued that the design was evocative of federal architecture during the New Deal period, being influenced by an austere interpretation of Art Deco/Beaux Arts styles.[citation needed] Additionally, some questioned the decision to designate the circle of pillars with the names of the U.S. states, as statehood was irrelevant to the federal war effort.]],}
end
------End Builder Generated functions, Do not Edit, this will be overwritten------
-------------------------------------------------------------------------------
------Builder Generated callbacks, Do not Edit, this will be overwritten------
-------------------------------------------------------------------------------
--#LASTCALLBACKKEY=0#--
------End Builder Generated callbacks, Do not Edit, this will be overwritten------
-- #Author Functions Go Here# --
-- #End Author Functions# --
-- Nothing after this line --
return cartNationalMallandMemorialParks
