require "Wherigo"
ZonePoint = Wherigo.ZonePoint
Distance = Wherigo.Distance
Player = Wherigo.Player

-- #Author Directives Go Here# --
-- #End Author Directives# --

cartBattleship = Wherigo.ZCartridge()

-- MessageBox Callback Functions Table used by the Builder --
cartBattleship.MsgBoxCBFuncs = {}

zmediaIcon = Wherigo.ZMedia(cartBattleship)
zmediaIcon.Name="Icon"
zmediaIcon.Description=""
zmediaIcon.AltText=""
zmediaIcon.Id="e9efffff-3391-429e-83e0-87856f6a252b"
zmediaIcon.Resources = {
{ Type = "jpg", Filename = "icon.jpg", Directives = {},},
}
zmedia37mm = Wherigo.ZMedia(cartBattleship)
zmedia37mm.Name="37mm"
zmedia37mm.Description=""
zmedia37mm.AltText=""
zmedia37mm.Id="e9ef0191-3391-429e-83e0-87856f6a252b"
zmedia37mm.Resources = {
{ Type = "jpg", Filename = "37mm.jpg", Directives = {},},
}
zmedia75mm = Wherigo.ZMedia(cartBattleship)
zmedia75mm.Name="75mm"
zmedia75mm.Description=""
zmedia75mm.AltText=""
zmedia75mm.Id="6fe9f276-2de3-4fac-b86d-bda0f34fcbd4"
zmedia75mm.Resources = {
{ Type = "jpg", Filename = "75mm.jpg", Directives = {},},
}
zmedia155mm = Wherigo.ZMedia(cartBattleship)
zmedia155mm.Name="155mm"
zmedia155mm.Description=""
zmedia155mm.AltText=""
zmedia155mm.Id="4fe7c14f-2388-4d24-87c1-c8c86bba2e6f"
zmedia155mm.Resources = {
{ Type = "jpg", Filename = "155mm.jpg", Directives = {},},
}
zmediaSunk = Wherigo.ZMedia(cartBattleship)
zmediaSunk.Name="Sunk"
zmediaSunk.Description=""
zmediaSunk.AltText=""
zmediaSunk.Id="aae7c14f-2388-4d24-87c1-c8c86bba2e6f"
zmediaSunk.Resources = {
{ Type = "jpg", Filename = "sunk.jpg", Directives = {},},
}
zmediaHit = Wherigo.ZMedia(cartBattleship)
zmediaHit.Name="Hit"
zmediaHit.Description=""
zmediaHit.AltText=""
zmediaHit.Id="bbe7c14f-2388-4d24-87c1-c8c86bba2e6f"
zmediaHit.Resources = {
{ Type = "jpg", Filename = "hit.jpg", Directives = {},},
}
zmediaMiss = Wherigo.ZMedia(cartBattleship)
zmediaMiss.Name="Miss"
zmediaMiss.Description=""
zmediaMiss.AltText=""
zmediaMiss.Id="cce7c14f-2388-4d24-87c1-c8c86bba2e6f"
zmediaMiss.Resources = {
{ Type = "jpg", Filename = "miss.jpg", Directives = {},},
}
zmediaBanner = Wherigo.ZMedia(cartBattleship)
zmediaBanner.Name="Banner"
zmediaBanner.Description=""
zmediaBanner.AltText=""
zmediaBanner.Id="dde7c14f-2388-4d24-87c1-c8c86bba2e6f"
zmediaBanner.Resources = {
{ Type = "jpg", Filename = "banner.jpg", Directives = {},},
}
zmediaMedal = Wherigo.ZMedia(cartBattleship)
zmediaMedal.Name="Medal"
zmediaMedal.Description=""
zmediaMedal.AltText=""
zmediaMedal.Id="ddeeff4f-2388-4d24-87c1-c8c86bba2e6f"
zmediaMedal.Resources = {
{ Type = "jpg", Filename = "medal.jpg", Directives = {},},
}
zmediaFail = Wherigo.ZMedia(cartBattleship)
zmediaFail.Name="Fail"
zmediaFail.Description=""
zmediaFail.AltText=""
zmediaFail.Id="ddeeffee-2388-4d24-87c1-c8c86bba2e6f"
zmediaFail.Resources = {
{ Type = "jpg", Filename = "failure.jpg", Directives = {},},
}
-- Cartridge Info --
cartBattleship.Id="c29231d0-f9d5-4ce2-9335-ac14aedc6e45"
cartBattleship.Name="Battleship"
cartBattleship.Description=[[]]
cartBattleship.Visible=true
cartBattleship.Activity="Puzzle"
cartBattleship.StartingLocationDescription=[[]]
cartBattleship.StartingLocation = Wherigo.INVALID_ZONEPOINT
cartBattleship.Version="0.01"
cartBattleship.Company="Ranger Fox Adventures, Ltd."
cartBattleship.Author="Ranger Fox"
cartBattleship.BuilderVersion="2.0.5129.5086"
cartBattleship.CreateDate="2/5/2011 1:57:10 AM"
cartBattleship.PublishDate="1/1/0001 12:00:00 AM"
cartBattleship.UpdateDate="2/8/2011 10:28:11 PM"
cartBattleship.LastPlayedDate="1/1/0001 12:00:00 AM"
cartBattleship.TargetDevice="PocketPC"
cartBattleship.TargetDeviceVersion="0"
cartBattleship.StateId="1"
cartBattleship.CountryId="2"
cartBattleship.Complete=false
cartBattleship.UseLogging=false
cartBattleship.Media=zmediaBanner
cartBattleship.Icon=zmediaIcon

-- Zones --
zoneCenter = Wherigo.Zone(cartBattleship)
zoneCenter.Id="ac5f193b-578e-4e51-ab2b-08a14e59f625"
zoneCenter.Name="Center"
zoneCenter.Description=[[This is the center of the game board.  Same technique as in Whack-A-Lackey.]]
zoneCenter.Visible=false
zoneCenter.DistanceRange = Distance(-1, "feet")
zoneCenter.ShowObjects="OnEnter"
zoneCenter.ProximityRange = Distance(200, "feet")
zoneCenter.AllowSetPositionTo=false
zoneCenter.Active=false
zoneCenter.Points = {
  ZonePoint(36.07888,-79.79488,0),
  ZonePoint(36.07888,-79.79476,0),
  ZonePoint(36.07878,-79.79476,0),
  ZonePoint(36.07878,-79.79488,0)
}
zoneCenter.OriginalPoint = ZonePoint(36.0788333336512,-79.7948166529338,0)
zoneCenter.DistanceRangeUOM = "Feet"
zoneCenter.ProximityRangeUOM = "Feet"
zoneCenter.OutOfRangeName = ""
zoneCenter.InRangeName = ""

zoneGeocache = Wherigo.Zone(cartBattleship)
zoneGeocache.Id="aabbccdd-eeff-4e51-ab2b-08a14e59f625"
zoneGeocache.Name="Geocache"
zoneGeocache.Description=[[The geocache]]
zoneGeocache.Visible=false
zoneGeocache.DistanceRange = Distance(-1, "feet")
zoneGeocache.ShowObjects="OnEnter"
zoneGeocache.ProximityRange = Distance(1, "feet")
zoneGeocache.AllowSetPositionTo=false
zoneGeocache.Active=false
zoneGeocache.Points = {
  ZonePoint(36.21582,-79.90595,0),
  ZonePoint(36.21582,-79.90585,0),
  ZonePoint(36.21574,-79.90585,0),
  ZonePoint(36.21574,-79.90595,0)
}
zoneGeocache.OriginalPoint = ZonePoint(36.215816666666,-79.90616666666667,0)
zoneGeocache.DistanceRangeUOM = "Feet"
zoneGeocache.ProximityRangeUOM = "Feet"
zoneGeocache.OutOfRangeName = ""
zoneGeocache.InRangeName = ""

zoneNVGeocache = Wherigo.Zone(cartBattleship)
zoneNVGeocache.Id="aabbccdd-eeff-4e51-ab2b-08a14e59f626"
zoneNVGeocache.Name="NV Geocache"
zoneNVGeocache.Description=[[The geocache]]
zoneNVGeocache.Visible=false
zoneNVGeocache.DistanceRange = Distance(-1, "feet")
zoneNVGeocache.ShowObjects="OnEnter"
zoneNVGeocache.ProximityRange = Distance(1, "feet")
zoneNVGeocache.AllowSetPositionTo=false
zoneNVGeocache.Active=false
zoneNVGeocache.Points = {
  ZonePoint(38.98594,-119.16975,0),
  ZonePoint(38.98594,-119.16965,0),
  ZonePoint(38.98602,-119.16965,0),
  ZonePoint(38.98602,-119.16975,0)
}
zoneNVGeocache.OriginalPoint = ZonePoint(38.9859833333333,-119.1697,0)
zoneNVGeocache.DistanceRangeUOM = "Feet"
zoneNVGeocache.ProximityRangeUOM = "Feet"
zoneNVGeocache.OutOfRangeName = ""
zoneNVGeocache.InRangeName = ""

-- Characters --

-- Items --
zitemStartGame = Wherigo.ZItem(cartBattleship)
zitemStartGame.Id="ae9d28f5-346c-4006-a821-10addc8acd93"
zitemStartGame.Name="Start Game"
zitemStartGame.Description=[[This is where you can control the game.

Start Game - begins a game]]
zitemStartGame.Visible=true
zitemStartGame.ObjectLocation = ZonePoint(0,0,0)
zitemStartGame.Locked = false
zitemStartGame.Opened = false
zitemStartGame.Commands = {
  StartGame = Wherigo.ZCommand{Text="Start Game", CmdWith=false, Enabled=true, EmptyTargetListText="Nothing available"},
}
zitemStartGame.Commands.StartGame.Custom = true
zitemStartGame.Commands.StartGame.Id="8c45d8ee-a16e-411a-acc3-c7f401683c18"
zitemStartGame.Commands.StartGame.WorksWithAll = true

zitemInstructions = Wherigo.ZItem(cartBattleship)
zitemInstructions.Id="7bf9f1ec-3508-47e0-b145-6fcebe371d44"
zitemInstructions.Name="Instructions"
zitemInstructions.Description=[[What would you like to know?]]
zitemInstructions.Visible=true
zitemInstructions.ObjectLocation = ZonePoint(0,0,0)
zitemInstructions.Locked = false
zitemInstructions.Opened = false
zitemInstructions.Commands = {
  Distances = Wherigo.ZCommand{Text="Distances", CmdWith=false, Enabled=true, EmptyTargetListText="Nothing available"},
  SinkingShips = Wherigo.ZCommand{Text="Sinking Ships", CmdWith=false, Enabled=true, EmptyTargetListText="Nothing available"},
  SavingGame = Wherigo.ZCommand{Text="Saving Game", CmdWith=false, Enabled=true, EmptyTargetListText="Nothing available"},
  Introduction = Wherigo.ZCommand{Text="Introduction", CmdWith=false, Enabled=true, EmptyTargetListText="Nothing available"},
}
zitemInstructions.Commands.Distances.Custom = true
zitemInstructions.Commands.Distances.Id="9163222f-7458-4cb1-9d09-7e67670fc4d3"
zitemInstructions.Commands.Distances.WorksWithAll = true
zitemInstructions.Commands.SinkingShips.Custom = true
zitemInstructions.Commands.SinkingShips.Id="cb73b99c-2d91-4228-a942-19a7dbfda040"
zitemInstructions.Commands.SinkingShips.WorksWithAll = true
zitemInstructions.Commands.SavingGame.Custom = true
zitemInstructions.Commands.SavingGame.Id="e8c268b6-1514-420b-b1ac-6d664e1a7c59"
zitemInstructions.Commands.SavingGame.WorksWithAll = true
zitemInstructions.Commands.Introduction.Custom = true
zitemInstructions.Commands.Introduction.Id="4c080837-7fbf-45e8-a7e7-0380715bfab8"
zitemInstructions.Commands.Introduction.WorksWithAll = true

zitemAdminControl = Wherigo.ZItem(cartBattleship)
zitemAdminControl.Id="aabbf1ec-3508-47e0-b145-6fcebe371d44"
zitemAdminControl.Name="Admin Control"
zitemAdminControl.Description=[[A secret menu for field testing]]
zitemAdminControl.Visible=true
zitemAdminControl.ObjectLocation = ZonePoint(0,0,0)
zitemAdminControl.Locked = false
zitemAdminControl.Opened = false
zitemAdminControl.Commands = {
  ToggleZones = Wherigo.ZCommand{Text="Toggle Zones", CmdWith=false, Enabled=true, EmptyTargetListText="Nothing available"},
  RestoreAmmo = Wherigo.ZCommand{Text="Restore Ammo", CmdWith=false, Enabled=true, EmptyTargetListText="Nothing available"},
  MoveFinalZone = Wherigo.ZCommand{Text="Move Final Zone", CmdWith=false, Enabled=true, EmptyTargetListText="Nothing available"},
  WinGame = Wherigo.ZCommand{Text="Win Game", CmdWith=false, Enabled=true, EmptyTargetListText="Nothing available"},
}
zitemAdminControl.Commands.ToggleZones.Custom = true
zitemAdminControl.Commands.ToggleZones.Id="aabb0837-7fbf-45e8-a7e7-0380715bfab8"
zitemAdminControl.Commands.ToggleZones.WorksWithAll = true
zitemAdminControl.Commands.RestoreAmmo.Custom = true
zitemAdminControl.Commands.RestoreAmmo.Id="aabb0837-7fbf-45e8-a7e7-0380715bfab9"
zitemAdminControl.Commands.RestoreAmmo.WorksWithAll = true
zitemAdminControl.Commands.MoveFinalZone.Custom = true
zitemAdminControl.Commands.MoveFinalZone.Id="aabb0837-7fbf-45e8-a7e7-0380715bfab0"
zitemAdminControl.Commands.MoveFinalZone.WorksWithAll = true
zitemAdminControl.Commands.WinGame.Custom = true
zitemAdminControl.Commands.WinGame.Id="aabb0837-7fbf-45e8-a7e7-0380715bfab7"
zitemAdminControl.Commands.WinGame.WorksWithAll = true

zitem155mmAmmo = Wherigo.ZItem(cartBattleship)
zitem155mmAmmo.Id="e9a250e1-42e8-4012-99cf-0267a9e6cd14"
zitem155mmAmmo.Name="155mm Ammo"
zitem155mmAmmo.Description=[[Remaining: 3

These 155mm high-explosive shells are the largest you have.  These damage a very wide area.]]
zitem155mmAmmo.Visible=true
zitem155mmAmmo.ObjectLocation = Wherigo.INVALID_ZONEPOINT
zitem155mmAmmo.Media=zmedia155mm
zitem155mmAmmo.Locked = false
zitem155mmAmmo.Opened = false
zitem155mmAmmo.Commands = {
  Fire = Wherigo.ZCommand{Text="Fire!", CmdWith=false, Enabled=true, EmptyTargetListText="Nothing available"},
}
zitem155mmAmmo.Commands.Fire.Custom = true
zitem155mmAmmo.Commands.Fire.Id="4604a149-c90a-46cd-94fc-08b5d4a35a88"
zitem155mmAmmo.Commands.Fire.WorksWithAll = true

zitem75mmAmmo = Wherigo.ZItem(cartBattleship)
zitem75mmAmmo.Id="3c4d0331-9024-4732-989a-3728038f18d0"
zitem75mmAmmo.Name="75mm Ammo"
zitem75mmAmmo.Description=[[Remaining: 8

These anti-tank shells will pierce even the toughest armor, causing medium damage to the area.]]
zitem75mmAmmo.Visible=true
zitem75mmAmmo.ObjectLocation = Wherigo.INVALID_ZONEPOINT
zitem75mmAmmo.Media=zmedia75mm
zitem75mmAmmo.Locked = false
zitem75mmAmmo.Opened = false
zitem75mmAmmo.Commands = {
  Fire = Wherigo.ZCommand{Text="Fire!", CmdWith=false, Enabled=true, EmptyTargetListText="Nothing available"},
}
zitem75mmAmmo.Commands.Fire.Custom = true
zitem75mmAmmo.Commands.Fire.Id="74445073-c8d2-4e56-98d7-d2102a7c85f2"
zitem75mmAmmo.Commands.Fire.WorksWithAll = true

zitem37mmAmmo = Wherigo.ZItem(cartBattleship)
zitem37mmAmmo.Id="9126e3a8-8d24-46a8-9273-83052e94e601"
zitem37mmAmmo.Name="37mm Ammo"
zitem37mmAmmo.Description=[[Remaining: 20

The smallest shells in your ship's hold.  While they will pierce armor, their effective radius is quite low.]]
zitem37mmAmmo.Visible=true
zitem37mmAmmo.ObjectLocation = Wherigo.INVALID_ZONEPOINT
zitem37mmAmmo.Media=zmedia37mm
zitem37mmAmmo.Locked = false
zitem37mmAmmo.Opened = false
zitem37mmAmmo.Commands = {
  Fire = Wherigo.ZCommand{Text="Fire!", CmdWith=false, Enabled=true, EmptyTargetListText="Nothing available"},
}
zitem37mmAmmo.Commands.Fire.Custom = true
zitem37mmAmmo.Commands.Fire.Id="72b7fff9-0eed-4fe7-a3e8-cba417456d84"
zitem37mmAmmo.Commands.Fire.WorksWithAll = true

zitemCompletionCode = Wherigo.ZItem(cartBattleship)
zitemCompletionCode.Id="aabbffee-8d24-46a8-9273-83052e94e601"
zitemCompletionCode.Name="Completion Code"
zitemCompletionCode.Description=[[]]
zitemCompletionCode.Visible=true
zitemCompletionCode.ObjectLocation = Wherigo.INVALID_ZONEPOINT
zitemCompletionCode.Locked = false
zitemCompletionCode.Opened = false

-- Tasks --

-- Cartridge Variables --
ammo2Remaining = 7
ammo3Remaining = 3
ammo1Remaining = 20
cartBattleship.ZVariables = {ammo2Remaining = 7, ammo3Remaining = 3, ammo1Remaining = 20}

-- Builder Variables (to be read by the builder only) --
buildervar = {}
buildervar.ammo2Remaining = {}
buildervar.ammo2Remaining.Id ="00fe8a8d-7cba-464a-8635-d94e1aa3a8e6"
buildervar.ammo2Remaining.Name = "ammo2Remaining"
buildervar.ammo2Remaining.Type = "Number"
buildervar.ammo2Remaining.Data=[[7]]
buildervar.ammo2Remaining.Description=[[]]

buildervar.ammo3Remaining = {}
buildervar.ammo3Remaining.Id ="ac934a4f-0423-4486-9bfd-3dbf60670cee"
buildervar.ammo3Remaining.Name = "ammo3Remaining"
buildervar.ammo3Remaining.Type = "Number"
buildervar.ammo3Remaining.Data=[[3]]
buildervar.ammo3Remaining.Description=[[]]

buildervar.ammo1Remaining = {}
buildervar.ammo1Remaining.Id ="f8b7042b-cbcb-48dd-8a67-7d204449c073"
buildervar.ammo1Remaining.Name = "ammo1Remaining"
buildervar.ammo1Remaining.Type = "Number"
buildervar.ammo1Remaining.Data=[[20]]
buildervar.ammo1Remaining.Description=[[]]


-- ZTimers --

-- Inputs --
zinputStartConfirm = Wherigo.ZInput(cartBattleship)
zinputStartConfirm.Id="e389f0ec-80fd-4296-8cc6-2634f8716216"
zinputStartConfirm.Name="StartConfirm"
zinputStartConfirm.Description=[[]]
zinputStartConfirm.Visible=true
zinputStartConfirm.Choices = {"Begin", "Wait"}
zinputStartConfirm.InputType="MultipleChoice"
zinputStartConfirm.InputVariableId="00fe8a8d-7cba-464a-8635-d94e1aa3a8e6"
zinputStartConfirm.Text=[[Ready to begin battleship?

You'll need a 80 yard/meter clear area.]]

--
-- Events/Conditions/Actions --
--

-------------------------------------------------------------------------------
------Builder Generated functions, Do not Edit, this will be overwritten------
-------------------------------------------------------------------------------

function cartBattleship:OnStart()
-- #GroupDescription=Script Description --
-- #Comment=Script Comment --
zitemStartGame:MoveTo(Player)
zitemInstructions:MoveTo(Player)
end

function zitemInstructions:OnIntroduction()
-- #GroupDescription=About Scoring --
-- #Comment=About Scoring Comment --
Wherigo.MessageBox{Text=[[This is a variation on the old battleship game.  In this Wherigo adaptation, the football field on which you're standing is the "sea"--your game board.  The ships you're to sink will be placed, hidden, upon the field.  Your job is to sink them all.

In this game, you are given a limited supply of ammunition to use to sink the ships.  Just as with traditional games of Battleship, you must cause damage along the length of the ship in order to save it.  For instance, in traditional Battleship, a submarine must have three hits before it is sunk.  In this version, a submarine is composed of three zones, which all must be hit in order to sink the ship.]],}
end

function zitemInstructions:OnSinkingShips()
-- #GroupDescription=Sinking ships --
-- #Comment=Sinking ships Comment --
Wherigo.Dialog{{Text=[[Each ship is composed of a certain number of zones, all of which must be hit before a ship is sunk.  These zones are placed in a line somewhere on the field.  Depending on your GPS receiver's accuracy, it might be a straight line or a little bent.

You are given a certain amount of ammunition, called "shells",  to use to sink ships.  The shells are located in the inventory section.  When you run out, it's game over.]],},{Text=[[TYPES OF SHELLS
The shells you have come in different sizes, or calibers.  Larger calibers will damage ships in a larger area while smaller caliber shells damage a smaller area.  The strategy you use in their deployment will have a significant impact on your game.]],},{Text=[[USING SHELLS
To damage ships, you must fire a shell.  To fire a shell, first walk to the area you wish to hit.  Next, go to your inventory screen and select the shell you wish to use.  The shell's item screen will then be displayed.  The item screen tells you how many shells you have left and the shell's damage radius.  To fire the shell, press the "FIRE!" button on the item screen.

After you fire a shell, the game will tell you whether you hit a ship or missed.  If you hit a ship, the sections you hit will be displayed in the LOCATIONS menu.]],},}
end

function zitemInstructions:OnSavingGame()
-- #GroupDescription=Script --
-- #Comment=Script Comment --
Wherigo.MessageBox{Text=[[At the moment, it is not possible to save a game in progress.  This may be a feature in later versions.

If you complete the game, the item with the completion code and, where applicable, the zone with the geocache can be saved and restored without issue.]],}
end
------End Builder Generated functions, Do not Edit, this will be overwritten------
-------------------------------------------------------------------------------
------Builder Generated callbacks, Do not Edit, this will be overwritten------
-------------------------------------------------------------------------------
--#LASTCALLBACKKEY=0#--
------End Builder Generated callbacks, Do not Edit, this will be overwritten------
-- #Author Functions Go Here# --
require "math"

-- ************************************************************
-- ************************************************************
-- ************************************************************
--	Wherigo Battleship
--					Created By Ranger Fox
--
--   This is one of those creative cartridges, making Wherigo
--   do things it was never designed to do.  I hope you enjoy
--   looking through the code that makes this a possibility.
--
--   Whack-A-Lackey was referenced quite a lot by people
--   wishing to better their understanding of Wherigo author
--   script.  However, it was not commented and organized as
--   well as it should have been for this purpose.  This also
--   made localization a small challenge.  This time around,
--   I have started coding with the intent the code will be
--   looked at and someone might want to tweak and/or localize
--   it.  You will find things organized and, for the most
--   part, documented.
--
--   Most of you may notice quite a lot of print() statements
--   in this cartridge.  Since I have not seen this discussed
--   in the forum, I feel I should explain.  Any text within
--   a print() statement will be output to the second tab in
--   the Wherigo Emulator.  Thus, I can output variable values
--   and other statements so I can see where my code is executing
--   and what some values are.  This is extremely useful for
--   tracking down exceptions within the cartridge.  I recommend
--   using this approach if you create custom cartridges; it is
--   quite handy and a time saver.
--
--   (Update: After some testing with the Garmin Oregon and
--   PiGo, I discovered both Players do not like my print()
--   statements.  The Oregon seems to power off when it
--   encounters one and PiGo throws an error per print(), saying
--   the function was not supported.  Thus, I commented out all
--   uses of the print() statement.  Too bad.)
--
--   I hope the way I have set this up is much more readable,
--   understandable, and easier to work with.  Please let me
--   know if you like what you see.
--
--   Note: To change around how Battleship works, all you need
--   to do is change the following sections: "HOW TO ADJUST THE
--   NUMBER OF SHIPS", "PUBLIC, GAME-ALTERING VARIABLES", 
--   and "LOCALIZATION VARIABLES".  You do not have to change
--   anything else beyond this, and everything in these three
--   sections is well-commented.
--
--
--   --\/- Ranger Fox
--
--
--
--   Update 20120603
--	After testing the cartridge on the iPhone, it has come to	
--	my attention the version of lua on the iPhone Player does
--	not like how I use an integer argument as part of
--	string.gsub.  This is used for string replacement so the
--	cartridge will handle localizations.  To fix this, I am
--	converting the integer to a string by appending an empty
--	string to the end of it.
--
--	ABOUT LOCALIZATION: Anywhere I am using the funny text
--	{0} or {1} means I have code elsewhere to replace that
--	with meaningful text.  I do this so you can define a
--	message that says "You sunk the {0} {1}!" and the code
--	will replace {0} with the type of ship and {1} with the
--	name of the ship.  Get it?
--
--
-- ************************************************************
-- ************************************************************
-- ************************************************************













-- ************************************************
--	HOW TO ADJUST THE NUMBER OF SHIPS
-- ************************************************
--
-- This is very important to know, so please read carefully.
--
-- The following function is responsible for creating the battleships.  If you want to change the names or number of ships, you can do it from this function.  The function is as clean as I can write it, with as little code showing the inner working of the cartridge as I can.
--
function CreateBattleships()
	--CreateBattleship parameters:
	--	The name of the battleship
	--	How many zones the battleship has
	table.insert(battleships, CreateBattleship("USS NC", "battleship", 4))
	table.insert(battleships, CreateBattleship("USS Port Royal", "cruiser", 3))
	table.insert(battleships, CreateBattleship("Tullibee", "submarine", 3))
	table.insert(battleships, CreateBattleship("Higgins", "patrol boat", 2))
	table.insert(battleships, CreateBattleship("Yorktown", "carrier", 5))
end













-- ************************************************
--	PUBLIC, GAME-ALTERING VARIABLES
-- ************************************************
--	If you want to change something about the game, look here.  The rest of the code will use these variables.
units = "ft"			--This is the unit system of measure I will be using for this cartridge (ft or m are the only values).  Note this will NOT be used in the Whack-A-Lackey utility functions.

--The following variables control the damage radius for each shell you can fire.  If the damage radius is 10 and the units, above, is set to feet, the damage radius is 10ft.

--The minimum damage radius should be 23, 31, 38 feet and quantity 20, 7, 3
ammo1DamageRadius = 23
ammo2DamageRadius = 34
ammo3DamageRadius = 42
ammo1Quantity = 26
ammo2Quantity = 12
ammo3Quantity = 6

fieldSize = 125
distanceBetweenBattleshipZones = 20
battleshipZoneSize = 6













-- ************************************************
--		LOCALIZATION VARIABLES
-- ************************************************
--	This time around, I am trying to make it easier to localize the game (i.e. make it easy to translate the game into other languages).  All in-game message boxes I will use (or as much as I can) will display the text found here.  This makes the cartridge more difficult to read, but should make it easier to translate.  Trade something, get something...
--	The numbers in {} will be substituted with their real values during the game, so do not remove them.
ammo1Name = "37mm Ammo ({0})"
ammo1Description = [[Remaining: {0}
Damage Radius: {1}{2}

The smallest shells in your ship's hold.  While they will pierce armor, their effective radius is quite low.]]
ammo2Name = "75mm Ammo ({0})"
ammo2Description = [[Remaining: {0}
Damage Radius: {1}{2}

These anti-tank shells will pierce even the toughest armor, causing medium damage to the area.]]
ammo3Name = "155mm Ammo ({0})"
ammo3Description = [[Remaining: {0}
Damage Radius: {1}{2}

These 155mm high-explosive shells are the largest you have.  These damage a very wide area.]]


--NAMING CONVENTION:
--  For those of you not familiar with printing and layout terms, COPY means text we will be working with and putting somewhere.

--This variable is what I use to name the tasks.
taskCopy = [[{0} ({1} zones)]]
taskDescriptionCopy = [[The {1} {0} is still afloat!

You must sink it by firing your ammunition, damaging a total of {2} zones.  Only then will this task be marked as complete.]]

--This is the message shown if the shot was a miss
missedCopy = [[You missed!]]

--This is the message shown if the shot hit something:
hitCopy = [[You hit the {1} {0}!]]
sunkCopy = [[You sunk the {1} {0}!]]
youWinCopy = [[You sunk all the battleships!  You win!]]
youLoseCopy = [[You ran out of ammunition.  Better luck next time!]]
buildingCartridgeCopy = [[Please wait while the cartridge is setting up.]]

completionCodeDescription = [[Your completion code is:
 ]] .. Player.CompletionCode .. [[

.  Please unlock and log your experience on wherigo.com!  Please tell me if you enjoyed the game and suggest things I can do to continue making fun and interesting games!]]

emulator = "  You might want to play this in real life before visiting this spot."








-- ************************************************
--		PRIVATE VARIABLES
-- ************************************************
--	The following variables are for use by the game and should not be messed with or set by anyone.
--Stores the centroid for the game
ReferencePoint = ZonePoint(48.51583,-123.15250, 0)	--This is a cool place. This is the park where I watched some Orcas swim past. This is also where I bought that Orca woodcut artwork I have hanging at my desk at work. Other than that, there is no reason for these coordinates. I just had to have something as default for this, so I thought I would show you a neat place. 
battleships = {}	--This contains all battleships in the cartridge
geocacheUnlockDistance = 32187	--In meters, this is the maximum distance you can be for the cartridge to show you the geocache.









-- ************************************************
--		RESUMING A GAME
--
--	Unfortumately, there is a tiny little bug
--  that lets players clear the game by saving and
--  restoring the cartridge.  This code here will
--  clean that up.  This is because we are using
--  quite a bit of custom code and it cannot be
--  saved when the cartridge is saved.  Thus, we
--  end up with a restored cartridge with just the
--  zones.  That is not good at all.
--
--	To fix this, we wipe the zones, items, and
--  tasks when the cartridge resumes.  Or, at least,
--  that is what I would have liked to do.
--  Unfortunately, I cannot get all tasks or items
--  the same way I do zones.  And, once a task has
--  been created, there is no way for you to remove
--  that task from the Player.  It is these things
--  no one thought about when Wherigo was created.
-- ************************************************
function cartBattleship:OnRestore()
-- #GroupDescription=On resume --
-- #Comment=On resume Comment --


	if zoneGeocache.Active == false then
		Wherigo.MessageBox{Text=[[This type of cartridge cannot be restored except when the final cache is displayed.  Please play it from the beginning.]],}
		Wherigo.Command("SaveClose")
	end


--Note: I do not want to delete the code below, nor do I want to run it (or comment that many lines).
--	Therefore, I put it inside an unreachable if block.
if 1 == 0 then
	--Wanton destruction.  THIS is how you sink battleships!
	local allZones = cartBattleship:GetAllOfType('Zone')
	for _,zone in ipairs(allZones) do
		if zone.Name ~= "cache" and zone.Name ~= "Center" then
			--print('Zone: ' .. zone.Name)
			zone.Visible = false
			zone.Active = false
			zone = nil
		end
	end


	--Clearing the tasks:
	local allTasks = cartBattleship:GetAllOfType('ztask')
--	local allTasks = cartBattleship:GetAllOfType('Task')
--	local allTasks = cartBattleship:GetAllOfType('zTask')
	for _,task in ipairs(allTasks) do
		print('Task: ' .. task.Name)
		task.Visible = false
		task.Active = false
		task = nil
	end


	--Removing the "Ammo" items
	local allItems = cartBattleship:GetAllOfType('zitem')
	for _,item in ipairs(allItems) do
		item.Visible = false
		print('Item: ' .. item.Name)
	end


	--Returning the "Start Game" item to the screen and the inventory.
	zitemStartGame.Visible = true
	zitemStartGame:MoveTo(Player)
	zitemInstructions:MoveTo(Player)
end
end



--function cartBattleship:OnEnd()


	--local x
	--for x=1, #battleships do
	--	battleships[x].Task.Visible = false
	--	battleships[x].Task = nil
	--end


	--cartBattleship:RequestSync()
--end






-- ************************************************
--		BATTLESHIP GAME FUNCTIONS
-- ************************************************

--This is the entry point for starting the game.
function zitemStartGame:OnStartGame()
	Wherigo.MessageBox{Text=buildingCartridgeCopy}
	battleships = nil
	battleships = {}
	StartGame()

	ammo1Remaining = ammo1Quantity
	ammo2Remaining = ammo2Quantity
	ammo3Remaining = ammo3Quantity
	SetAmmoDescriptions()

	zitemStartGame:MoveTo(nil)
	zitem37mmAmmo:MoveTo(Player)
	zitem75mmAmmo:MoveTo(Player)
	zitem155mmAmmo:MoveTo(Player)

	if Player.Name == "Ranger Fox" or Player.Name == "thilo.lu" then
		zitemAdminControl:MoveTo(Player)
	end

	Wherigo.ShowScreen(Wherigo.MAINSCREEN)
end




--A second function for starting the game.  The main entry point function calls this.  I have a second function due to the way I was testing things.  No real reason other than that, I guess.
function StartGame()
	ReferencePoint.latitude = Player.ObjectLocation.latitude
	ReferencePoint.longitude = Player.ObjectLocation.longitude

	--print("Starting game")
	Player:RefreshLocation()
	--print("Creating battleships")
	CreateBattleships()
	--print("Creating tasks")
	CreateTasks()
	--print("StartGame finished")
end



--This function creates the battleship objects.  It is responsible for creating the battleship zones, positioning them, etc.  If I had media for a ship, I would have included it as another argument.
function CreateBattleship(name, boatClass, numberOfZones)
	--print("Creating battleship " .. name)

	local z = CreateNewZone(Player.ObjectLocation, name, battleshipZoneSize, battleshipZoneSize / 2)
	z.Id = 1
	
	--A little object orientation, something that was sorely missed in Whack-A-Lackey.
	local ship = { Name = name, Zones = { z }, IsSunk = false, Class = boatClass, Task = nil }
		--The IsSunk variable is present so I can save some processing time determining if the ship is sunk.

	local x
	for x=2,numberOfZones do
		--We will now create some other zones.
		local zz = CreateNewZone(Player.ObjectLocation, name, battleshipZoneSize, battleshipZoneSize / 2)
		zz.Id = x
		zz.Active = true
		zz.Active = false

		--All battleship zones will be inactive.  This will drastically cut the processing cost on a Wherigo Player.
		--  We do not have any events to fire in those zones, so it makes sense to keep them as inactive.
		--Originally, though, the idea was to have zones as active and invisible, then just make them inactive to
		--  register the hit.  However, the idea concerning processing cost came to mind.  Thus, I wanted to use an
		--  IsZoneHit table/array to determine whether a zone has been hit.
		--Unfortunately, when a zone is hit, we have to make it active and visible, anyway, so the player knows where
		--  the battleship is.  So much for that.

		table.insert(ship.Zones, zz)
	end

	--print("Calling MoveZoneToRandom")
	--Set up the location for the first zone
	MoveZoneToRandom(ship.Zones[1], Player.ObjectLocation, fieldSize)

	--Get a random bearing
	local bearing = math.random(0.000,360.000)

	--print("Calling LineUpZones")
	--Line up all other zones with the first on some random bearing and set distance apart.
	LineUpZones(ship.Zones, ship.Zones[1].Points[1], distanceBetweenBattleshipZones, units, bearing)


	--print("Before setting the ship's visible and active on each zone")
	for x=1,numberOfZones do
		ship.Zones[x].Visible = false
		ship.Zones[x].Active = true
	end

	--print("SHIP CREATED")
	return ship
end



--This updates all ammo descriptions, mainly so the player can see the current quantity.  There does not seem to be too much overhead in doing this, so I am setting all ammo objects every time.
function SetAmmoDescriptions()
	--I am adjusting the description for each item here based on the localization and the number of shells remaining
	zitem37mmAmmo.Name = string.gsub(ammo1Name,"{0}",ammo1Remaining .. "")
	zitem75mmAmmo.Name = string.gsub(ammo2Name,"{0}",ammo2Remaining .. "")
	zitem155mmAmmo.Name = string.gsub(ammo3Name,"{0}",ammo3Remaining .. "")
	zitem37mmAmmo.Description = string.gsub(string.gsub(string.gsub(ammo1Description, "{0}", ammo1Remaining .. ""), "{1}", ammo1DamageRadius .. ""), "{2}", units)
	zitem75mmAmmo.Description = string.gsub(string.gsub(string.gsub(ammo2Description, "{0}", ammo2Remaining .. ""), "{1}", ammo2DamageRadius .. ""), "{2}", units)
	zitem155mmAmmo.Description = string.gsub(string.gsub(string.gsub(ammo3Description, "{0}", ammo3Remaining .. ""), "{1}", ammo3DamageRadius .. ""), "{2}", units)
end


--This creates the "Sink this battleship" tasks for all battleships
function CreateTasks()
	--print("Creating tasks")
	local x
	for x=1, #battleships do
		battleships[x].Task = CreateTask(string.gsub(string.gsub(taskCopy, "{0}", battleships[x].Name .. ""), "{1}", #battleships[x].Zones .. ""), string.gsub(string.gsub(string.gsub(taskDescriptionCopy, "{0}", battleships[x].Name .. ""), "{1}", battleships[x].Class .. ""), "{2}", #battleships[x].Zones .. ""), true)
	end
	--print("Tasks created")
end



--The next few functions represent firing the cartridges.  For the most part, FireShell determines everything.
function zitem37mmAmmo:OnFire()
	ammo1Remaining = ammo1Remaining - 1
	SetAmmoDescriptions()
	FireShell(ammo1DamageRadius)
	if ammo1Remaining == 0 then
		zitem37mmAmmo:MoveTo(nil)
	end
end
function zitem75mmAmmo:OnFire()
	ammo2Remaining = ammo2Remaining - 1
	SetAmmoDescriptions()
	FireShell(ammo2DamageRadius)
	if ammo2Remaining == 0 then
		zitem75mmAmmo:MoveTo(nil)
	end
end
function zitem155mmAmmo:OnFire()
	ammo3Remaining = ammo3Remaining - 1
	SetAmmoDescriptions()
	FireShell(ammo3DamageRadius)
	if ammo3Remaining == 0 then
		zitem155mmAmmo:MoveTo(nil)
	end
end


--This function looks through the battleship zones and determines if any battleships were shot or sunk.  It also determines if the player wins or loses the game.
function FireShell(damageRadius)
	local x
	local shipsWereHit = 0
	local shipsWereSunk = 0
	local lastSunkShip = nil
	local lastHitShip = nil
	local allSunk = true
	local lastSunkShipClass = nil
	local lastHitShipClass = nil
	
	--print("Called FireShell for damage radius " .. damageRadius)

	for x=1, #battleships do
		if not battleships[x].IsSunk then
			--print("Calling ZonesWithinDistance")
			local z = ZonesWithinDistance(battleships[x].Zones, damageRadius, units, false, false, false, true)
			--Test mode:
			--local z = ZonesWithinDistance(battleships[x].Zones, damageRadius, units, true, true, true, false)
			--print("End ZonesWithinDistance")

			--Process the hits
			if z ~= nil and #z > 0 then
				--print("something hit")
				shipsWereHit = shipsWereHit + 1
				lastHitShip = battleships[x].Name
				lastHitShipClass = battleships[x].Class

				local y
				for y=1, #z do
					z[y].Visible = true
					z[y].Active = true
					z[y].IsHit = true
				end

				local isSunk = true
				for y=1, #battleships[x].Zones do
					if not (battleships[x].Zones[y].Active == true and battleships[x].Zones[y].Visible == true) then
						isSunk = false
					end
				end

				if isSunk then
					battleships[x].IsSunk = true
					ToggleZoneStates(battleships[x].Zones, false, false)
					battleships[x].Task.Complete = true
					shipsWereSunk = shipsWereSunk + 1
					lastSunkShip = battleships[x].Name
					lastSunkShipClass = battleships[x].Class
				end
			end
		end

		if allSunk then
			allSunk = battleships[x].IsSunk
		end
	end



	--print("Evaluating if something was sunk")
	if allSunk then
		GameComplete(true)
	elseif ammo1Remaining == 0 and ammo2Remaining == 0 and ammo3Remaining == 0 then
		GameComplete(false)
	elseif shipsWereSunk > 0 then
		Wherigo.MessageBox{Text=string.gsub(string.gsub(sunkCopy, "{0}", lastSunkShip), "{1}", lastSunkShipClass), Media=zmediaSunk, Callback=cartBattleship.MsgBoxCBFuncs.DamagedShipCallback}
	elseif shipsWereHit > 0 then
		Wherigo.MessageBox{Text=string.gsub(string.gsub(hitCopy, "{0}", lastHitShip), "{1}", lastHitShipClass), Media=zmediaHit, Callback=cartBattleship.MsgBoxCBFuncs.DamagedShipCallback}
	else
		Wherigo.MessageBox{Text=missedCopy, Media=zmediaMiss, }
	end
end



--This callback is the super-secret admin menu.  It lets me test this in the field since I will have no clue where the zones are.
toggleState = false
function zitemAdminControl:OnToggleZones()
	toggleState = not toggleState
	local x,y
	for x=1,#battleships do
		for y=1,#battleships[x].Zones do
			battleships[x].Zones[y].Visible = toggleState
			battleships[x].Zones[y].Active = toggleState
		end
	end
end

function zitemAdminControl:OnRestoreAmmo()
	ammo1Remaining = ammo1Quantity
	ammo2Remaining = ammo2Quantity
	ammo3Remaining = ammo3Quantity
	SetAmmoDescriptions()

	zitem37mmAmmo:MoveTo(Player)
	zitem75mmAmmo:MoveTo(Player)
	zitem155mmAmmo:MoveTo(Player)

	Wherigo.MessageBox{Text=[[Your ammo has been fully restocked thanks to Ranger Fox Heavy Industries.  Don't shoot it all in one place!]]}
end


function zitemAdminControl:OnMoveFinalZone()
  local dist = Wherigo.Distance(300, "m")
  local newZp = Wherigo.TranslatePoint(Player.ObjectLocation, dist, math.random(0, 360))

	CenterZoneOnPoint(zoneGeocache, 30, newZp)

	local d2,b2 = Wherigo.VectorToPoint(Player.ObjectLocation, zoneGeocache.Points[1])

	local distInMeters = d2("m")
	local distInFeet = d2("ft")
	local distInMiles = d2("mi")
	local distInKm = d2("km")

	Wherigo.MessageBox{Text="The final zone has been moved.<BR>Zone: " .. zoneGeocache.Points[1].latitude .. " " .. zoneGeocache.Points[1].longitude .. "<BR><BR>Player: " .. Player.ObjectLocation.latitude .. " " .. Player.ObjectLocation.longitude .. "<BR><BR>Meters: " .. distInMeters .. "<BR>Kilometers: " .. distInKm .. "<BR>Feet: " .. distInFeet .. "<BR>Miles: " .. distInMiles}

end

function zitemAdminControl:OnWinGame()
	GameComplete(true)
	zitemAdminControl:MoveTo(Player)
end


cartBattleship.MsgBoxCBFuncs.DamagedShipCallback = function(action)
	--print("Hit/sunk callback")
	Wherigo.ShowScreen(Wherigo.LOCATIONSCREEN)
end



--This is called when the game is done, whether the player wins or loses.  It tears down everything.
function GameComplete(hasWon)
	zitem37mmAmmo:MoveTo(nil)
	zitem75mmAmmo:MoveTo(nil)
	zitem155mmAmmo:MoveTo(nil)
	zitemAdminControl:MoveTo(nil)



	if hasWon then
		Wherigo.MessageBox{Text=youWinCopy, Media=zmediaMedal, }
		zitemCompletionCode.Description = completionCodeDescription
		zitemCompletionCode:MoveTo(Player)
		cartBattleship.Complete = true

		--Check to see if the cache can be found:
		--The distance from the cache
		local d2,b2 = Wherigo.VectorToPoint(Player.ObjectLocation, zoneGeocache.Points[1])
		local dist = d2("m")

		if dist <= geocacheUnlockDistance and (not Wherigo.NoCaseEquals(Env.DeviceID,"desktop")) then
			--I am showing the coordinates to the player in this fashion because you cannot read it by
			--	simply opening the cartridge, nor can you extract it as an image.  I am not that
			--	concerned about security beyond this because the cartridge is designed to be open source.
			local latitude, longitude
			latitude = 12.947
			longitude = 54.354
			zoneGeocache.Description = "N 36 " .. latitude .. "   W 79 " .. longitude

			zoneGeocache.Visible = true
			zoneGeocache.Active = true
		end

		

		local d2,b2 = Wherigo.VectorToPoint(Player.ObjectLocation, zoneNVGeocache.Points[1])
		local dist = d2("m")

		if dist <= geocacheUnlockDistance then
			--I am showing the coordinates to the player in this fashion because you cannot read it by
			--	simply opening the cartridge, nor can you extract it as an image.  I am not that
			--	concerned about security beyond this because the cartridge is designed to be open source.

			if gsub_wig(string.lower(Env.DeviceID),true) ~= "mo3w624" then
				--The user is playing it in the field
				local latitude, longitude
				latitude = 59.159
				longitude = 10.182
				zoneNVGeocache.Description = "N 38 " .. latitude .. "   W 119 " .. longitude

				zoneNVGeocache.Visible = true
				zoneNVGeocache.Active = true
			else
				--The user is playing on the emulator.  If we get here, the person is trying to hack.  Teach them a painful lesson.
				local latitude, longitude
				latitude = 59.174
				longitude = 10.108
				zoneNVGeocache.Description = "N 38 " .. latitude .. "   W 119 " .. longitude .. emulator

				CenterZoneOnPoint(zoneNVGeocache, 10, Wherigo.ZonePoint(38.98623333333, -119.168466667))

				zoneNVGeocache.Visible = true
				zoneNVGeocache.Active = true
			end
		end


	else
		Wherigo.MessageBox{Text=youLoseCopy, Media=zmediaFail, }
		--zitemStartGame:MoveTo(Player)

		--We will be nice and show the player where the battleships he or she did not sink are located:
		local x
		for x=1, #battleships do
			if battleships[x].IsSunk then
				--We will not show sunk battleships.
				ToggleZoneStates(battleships[x].Zones, false, false)
			else
				--But we will show battleships still afloat.
				ToggleZoneStates(battleships[x].Zones, true, true)
			end
		end
	end

	--Notice we do not give the player the opportunity to play again.  The player must exit the cartridge, then run it again.
	--This was on purpose.  I do not have any clean-up script that will nullify all zones on the fly.  This means that, if
	--    the player were to play again without closing the cartridge, we will then have twice as many zones in memory.
	--    Thus, it makes sense, memory-wise, to force the player to unload the cartridge before trying again.
end


--The other part of the instructions.  I put it down here so a Builder will not mess with the function.
function zitemInstructions:OnDistances()
-- #GroupDescription=Distance --
-- #Comment=Distance Comment --
Wherigo.MessageBox{Text=[[To be precise, the game field is not the exact dimensions of a football field.  It is a circle with a radius of ]] .. fieldSize .. [[ ]] .. units .. [[ from where you start the game.

A battleship's zones are spaced ]] .. distanceBetweenBattleshipZones .. [[ ]].. units .. [[ apart.]],}
end












-- ************************************************
--		NEW UTILITY FUNCTIONS
-- ************************************************
--
--	The next section will contain utility functions I copied from Whack-A-Lackey.  This section contains new utility functions.  I tried to make these functions as generic as possible (otherwise, they would be located within the Battleship Game Functions section.

--Puts the passed zones in a line
--	Inputs:
--		zones - A lua table of zones we will put in a line
--		startingPoint - A ZonePoint.  The first zone will go here.
--		distanceBetweenZones - Each zone will be placed this far from the last
--		units - The units of measure we are using for the distance, either feet or meters
--		bearing - The bearing direction the zones should be placed
function LineUpZones(zones, startingPoint, distanceBetweenZones, units, bearing)

	local x
	local lastZonePoint = startingPoint
	for x=1, #zones do
		--print("Call CenterZoneOnPoint")
		CenterZoneOnPoint(zones[x], battleshipZoneSize / 2, lastZonePoint)
		--print("Call MoveZonePoint")
		lastZonePoint = MoveZonePoint(lastZonePoint, distanceBetweenZones, units, bearing)
	end
	--print("End LineUpZones")
end


--Returns all zones a certain distance from the player
function ZonesWithinDistance(zoneArrayToTest, distance, units, includeVisibleZones, includeInvisibleZones, includeActiveZones, includeInactiveZones)

	local x
	local zones = {}	--The zones that are within the distance
	for x=1,#zoneArrayToTest do
		if DistanceFromZone(zoneArrayToTest[x], units) <= distance then

			--print("Zone " .. zoneArrayToTest[x].Name .. " is within distance")
				if zoneArrayToTest[x].Visible == includeVisibleZones or zoneArrayToTest[x].Visible ~= not includeInvisibleZones or zoneArrayToTest[x].Active == includeActiveZones or zoneArrayToTest[x].Active == not includeInactiveZones then
					table.insert(zones, zoneArrayToTest[x])
					--print("ZonesWithinDistance - zone inserted")
				end

		end
	end

	return zones
end

function DistanceFromZone(zone, units)
	local d2,b2 = Wherigo.VectorToPoint(Player.ObjectLocation, zone.OriginalPoint)
	local d = d2(units)
	--print("Distance from zone " .. zone.Name .. " = " .. d)
	return d
end

function MoveZonePoint(zonePoint, distance, units, bearing)
	--local zp = Wherigo.ZonePoint(zonePoint.latitude, zonePoint.longitude)
	local dist = Wherigo.Distance(distance, units)
	return Wherigo.TranslatePoint(zonePoint, dist, bearing)
end

function CreateTask(name, description, isVisible)
	--I LOVE how, if you want to create a zone, you use Wherigo.Zone, but if you want to create a task, you use Wherigo.ZTask...  I forget part of the time.
	--print("Creating task " .. name)
	--local t = Wherigo.ZTask{Cartridge = cartBattleship, Name = name, Description = description, Visible = isVisible, Active = false, Complete = false, CorrectState = "None", }

	-- Yeah... So I cannot do the above statement to create a task all at once on the iPhone Player.  Instead, I have to create a task in pieces if I do not want the Player to crash...
	local t = Wherigo.ZTask(cartBattleship)
	t.Id = "3335370b-5ac3-4d42-938a-9d6e187da66b"
	t.Name = name
	t.Description = description
	t.Visible = isVisible
	t.Active = false
	t.Complete = false
	t.CorrectState = "None"

	--You have to set the task to active AFTER you create it else the Player will not display it.
	t.Active = true
	return t
end

function ToggleZoneStates(zones, visible, active)
	local x
	for x=1, #zones do
		zones[x].Visible = visible
		zones[x].Active = active
	end 
end













-- ************************************************
--	UTILITY FUNCTIONS FROM WHACK-A-LACKEY
-- ************************************************
--
--	Whack-A-Lackey contained a good deal of zone creation and manipulation functions.  Since this is what Battleship needs, I will use them here as well.  (Now with 100% less test and junk code.)
--	
--	For those of you looking at this cartridge source, there is not anything below here that is specific to this or any cartridge I make.  By the way, it is highly possible I will not be using all functions in this section.  I created this utility section before creating the rest of the cartridge, so I myself do not know which functions I will use.  It does not seem to cost the Player much to include additional functions, so I will keep them as they were in Whack-A-Lackey so I can continue to build up a library of utility functions to use when I create games.


function SetZoneLocation(zZone, lat, lon)
	zZone.Active = false

	zZone.latitude = lat
	zZone.longitude = lon

	zZone.Active = true
end

--Moves the zone to a ZonePoint.  This is used to prime all zones
function CenterZoneOnPoint(zZone, ZoneRadius, point)
  local dist = Wherigo.Distance(0, units)
  local newZp = Wherigo.TranslatePoint(point, dist, 0)   -- new center point for the new zone	
  dist = Wherigo.Distance(ZoneRadius, units)
  local pts = {
    Wherigo.TranslatePoint(newZp, dist, 45),
    Wherigo.TranslatePoint(newZp, dist, 135),
    Wherigo.TranslatePoint(newZp, dist, 225),
    Wherigo.TranslatePoint(newZp, dist, 315),
  }

  zZone.Active = false
--print("CenterZoneOnPoint - before setting OriginalPoint")
	zZone.OriginalPoint = newZp
--  zZone.OriginalPoint.latitude = newZp.latitude
--  zZone.OriginalPoint.longitude = newZp.longitude
--print("CenterZoneOnPoint - after setting OriginalPoint")
  zZone.Points = pts
end 

-- Moves a zone to a random location based on a reference point and a maximum distance from that location.
function MoveZoneToRandom(zZone, refPoint, maxDistance)

	local d = 0
	local b = 30
	d = 0

	local newCentroid = Player.ObjectLocation


	while d < b do

		d = 0

		--Get a random distance
		local distNum = math.random(0, maxDistance)
		if distNum < 70 then
			distNum = distNum * 1.5
		end
		local dist = Wherigo.Distance(distNum, units)

		--Get a random bearing
		local bearing = math.random(0.000,360.000)

		--For this to work, the zone must be set as inactive
		zZone.Active = false

		--Something for debugging
		local txt = ""


		--Make sure the zone is not created on top of the player.
		

		--Update the original point
		local zp = Wherigo.ZonePoint(refPoint.latitude, refPoint.longitude)
		newCentroid = Wherigo.TranslatePoint(zp, dist, bearing)

		--The distance is in meters
		local d2,b2 = Wherigo.VectorToPoint(Player.ObjectLocation, newCentroid)

		d = d2(units)
	end	

	--REQUIREMENT: All zones must have the same shape as the centroid
	local x
	for x=1,#zZone.Points do
		local newPoint = Wherigo.TranslatePoint(newCentroid, Wherigo.Distance(12, units), 45 + (360 / #zZone.Points ) * x)

		zZone.Points[x].latitude = newPoint.latitude
		zZone.Points[x].longitude = newPoint.longitude

	end



	--Make the zone active again and it will update its coordinates
	--zZone.Active = true

	--For Battleship, we will leave it up to the calling function to activate the zones.
end


--Creates a new zone from a reference point.
--	Inputs:
--		refPt - A ZonePoint representing the center of the new zone
--		name - The name of the new zone
--		thedistance - The distance from the center point the new zone will be created at
--		radius - The radial width of the zone; the zone width will be twice the radius
--	Output:
--		The new Wherigo.zone
function CreateNewZone(refPt, name, thedistance, radius)
  -- create a list of zone points
  local dist = Wherigo.Distance(thedistance, units)
  local newZp = Wherigo.TranslatePoint(refPt, dist, math.random(0, 360))   -- new center point for the new zone	
  dist = Wherigo.Distance(radius, units)
  local pts = {
    Wherigo.TranslatePoint(newZp, dist, 45),
    Wherigo.TranslatePoint(newZp, dist, 135),
    Wherigo.TranslatePoint(newZp, dist, 225),
    Wherigo.TranslatePoint(newZp, dist, 315),
  }
--print("Zone created")

  -- create the new zone
  --Using OnEnter here because we will not have any objects in this zone and OnEnter will fire less frequently than OnProximity on most Players
  --OnProximity does not need to fire, so I will set it to a minimum
  local tempz = Wherigo.Zone{
    Cartridge = cartBattleship,
    Name = name,
    OutOfRangeName = "",
    InRangeName = "",		
    Description = [[]],
    Visible = false,
    Active = false,
    DistanceRange = Wherigo.Distance(-1, units),
    ShowObjects = "OnEnter",	
    ProximityRange = Wherigo.Distance(1, units),	
    AllowSetPositionTo = false,
    Points = pts,
    OriginalPoint = newZp,
    IsHit = false
  }

  return tempz
end

function gsub_wig (str, obf)
local result = ""
if (obf == nil) then
obf = true
end
local rot_palette = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789@.-~"
local plen = string.len(rot_palette)
local magic = { ["\001"] = "B"; ["\002"] = "R"; ["\003"] = "" }
str = string.gsub(str, "\038nbsp;", " ")
for i = 1, string.len(str) do
local c = string.sub(str, i, i)
local p = string.find(rot_palette, c, 1, true)	-- true -> plain text search
if (p) then
local jump = (i-1) % 8 + 9
if (obf) then
p = p + jump
if (p > plen) then
p = p - plen
end
else
p = p - jump
if (p < 1) then
p = p + plen
end
end
c = string.sub(rot_palette, p, p)		--(debug) .. "(" .. string.byte(c) .. ")"
else
x = magic[c]
if (x) then
c = x					--(debug) .. "(*)"
else
--(debug) c = c .. "(=" .. string.byte(c) .. ")"
end
end
result = result .. c			--(debug) .. "[i=" .. i .. "]"
end
return result
end
-- #End Author Functions# --
-- Nothing after this line --
return cartBattleship
