require "Wherigo"
function WWB_latin1_string (s, latin1_is_win1252)
if (WWB_utf8_extensions == nil) then
WWB_utf8_extensions = {
[0xC487] = "c";
[0xC48D] = "c";
[0xC48F] = "d";
[0xC49B] = "e";
[0xC4BA] = "l";
[0xC4BE] = "l";
[0xC584] = "n";
[0xC588] = "n";
[0xC593] = "o";
[0xC595] = "r";
[0xC599] = "r";
[0xC59B] = "s";
[0xC5A1] = "s";
[0xC5A5] = "t";
[0xC5AF] = "u";
[0xC5BA] = "z";
[0xC5BE] = "z";
[0xC486] = "C";
[0xC48C] = "C";
[0xC48E] = "D";
[0xC49A] = "E";
[0xC4B9] = "L";
[0xC4BD] = "L";
[0xC583] = "N";
[0xC587] = "N";
[0xC592] = "O";
[0xC594] = "R";
[0xC598] = "R";
[0xC59A] = "S";
[0xC5A0] = "S";
[0xC5A4] = "T";
[0xC5AE] = "U";
[0xC5B8] = "Y";
[0xC5B9] = "Z";
[0xC5BD] = "Z";
[0xE282AC] = string.char(164)
}
if (latin1_is_win1252) then
local i
local r
for i, r in pairs({
[0xE282AC] = string.char(128);
[0xE2809A] = string.char(130);
[0xC692] = string.char(131);
[0xE2809E] = string.char(132);
[0xE280A6] = string.char(133);
[0xE280A0] = string.char(134);
[0xE280A1] = string.char(135);
[0xCB86] = string.char(136);
[0xE280B0] = string.char(137);
[0xC5A0] = string.char(138);
[0xE280B9] = string.char(139);
[0xC592] = string.char(140);
[0xC5BD] = string.char(142);
[0xE28098] = string.char(145);
[0xE28099] = string.char(146);
[0xE2809C] = string.char(147);
[0xE2809D] = string.char(148);
[0xE280A2] = string.char(149);
[0xE28093] = string.char(150);
[0xE28094] = string.char(151);
[0xCB9C] = string.char(152);
[0xE284A2] = string.char(153);
[0xC5A1] = string.char(154);
[0xE280BA] = string.char(155);
[0xC593] = string.char(156);
[0xC5BE] = string.char(158);
[0xC5B8] = string.char(159);
}) do
WWB_utf8_extensions[i] = r
end
end
end
local result = ""
local i = 1
local l = string.len(s)
while (i <= l) do
local c = string.byte(s, i)
local x = '?'
if ((c == 194) or (c == 195)) then
i = i + 1
if (i <= l) then
local n = string.byte(s, i)
if (c == 195) then
n = n + 64
end
x = string.char(n)
end
elseif ((c >= 196) and (c <= 223)) then
i = i + 1
if (i <= l) then
local index = c * 256 + string.byte(s, i)
local e = WWB_utf8_extensions[index]
if (e ~= nil) then
x = e
end
end
elseif ((c >= 224) and (c <= 255)) then
i = i + 2
if (i <= l) then
local index = (c * 256 + string.byte(s, i - 1)) * 256 + string.byte(s, i)
local e = WWB_utf8_extensions[index]
if (e ~= nil) then
x = e
end
end
else
x = string.char(c)
end
result = result .. x
i = i + 1
end
return result
end
function WWB_multiplatform_string (s, latin1_devices)
if (WWB_device == nil) then
WWB_device = ""
end
if (WWB_device == "") then
local platform = "*"
local deviceId = "*"
platform = "iPhone previous version"
if (Env) then
if (Env.Platform) then
platform = Env.Platform
end
if (Env.DeviceID) then
deviceId = Env.DeviceID
end
end
WWB_localize_latin1_buttons = false
local latin1_is_win1252 = false
WWB_strings_unicode = (string.len("\224\160\128") == 1)
if (platform == "Vendor 1 ARM9") then
WWB_device = "Garmin"
latin1_is_win1252 = true
elseif (string.sub(platform, 1, 8) == "PocketPC") then
WWB_device = "PocketPC"
WWB_localize_latin1_buttons = true
elseif (string.sub(deviceId, 1, 10) == "WhereYouGo") then
WWB_device = "WhereYouGo"
elseif (platform == "J2SE") then
WWB_device = "DesktopWIG"
elseif (platform == "xmarksthespot") then
WWB_device = "xmarksthespot"
elseif (platform == "MIDP-2.0/CLDC-1.1") then
WWB_device = "OpenWIG"
elseif (string.sub(platform, 1, 6) == "iPhone") then
WWB_device = "iPhone"
WWB_strings_unicode = false
elseif (deviceId == "Desktop") then
WWB_device = "Emulator_GSP"
WWB_localize_latin1_buttons = true
elseif (deviceId == "webwigo") then
WWB_device = "WebWiGo"
else
WWB_device = "?"
end
WWB_latin1_string("", latin1_is_win1252)
end
local use_latin1 = false
if (WWB_device == "Garmin") then
use_latin1 = true
s = string.gsub(s, "\038amp;\038amp;", "\038amp;")
elseif (    (WWB_device == "WhereYouGo")
or (WWB_device == "OpenWIG")
or (WWB_device == "DesktopWIG")
) then
s = string.gsub(s, "\038amp;\038amp;", "\038")
s = string.gsub(s, "\060BR\062\010", "\010")
elseif (WWB_device == "iPhone") then
s = string.gsub(s, "\038amp;\038amp;", "\038amp;")
end
if (latin1_devices and latin1_devices[WWB_device]) then
use_latin1 = true
end
if (use_latin1) then
s = WWB_latin1_string(s)
end
return s
end
ZonePoint = Wherigo.ZonePoint
Distance = Wherigo.Distance
Player = Wherigo.Player

-- #Author Directives Go Here# --
-- #End Author Directives# --

cartMeetMein1904 = Wherigo.ZCartridge()

WWB_current_cartridge = cartMeetMein1904
-- MessageBox Callback Functions Table used by the Builder --
cartMeetMein1904.MsgBoxCBFuncs = {}

zmediaArtLoc = Wherigo.ZMedia(cartMeetMein1904)
zmediaArtLoc.Id = "4ca78ab3a87e869a2c85bc8baa48a179"
zmediaArtLoc.Name = "ArtLoc"
zmediaArtLoc.AltText = ""
zmediaArtLoc.Resources = {
  { Type = "jpg", Filename = "art_loc.jpg", Directives = {},}
}
zmediaArtPast = Wherigo.ZMedia(cartMeetMein1904)
zmediaArtPast.Id = "83eb3fa33eb33385f22d1bc1cb50c0e3"
zmediaArtPast.Name = "ArtPast"
zmediaArtPast.AltText = ""
zmediaArtPast.Resources = {
  { Type = "jpg", Filename = "art_past.jpg", Directives = {},}
}
zmediaArtPresent = Wherigo.ZMedia(cartMeetMein1904)
zmediaArtPresent.Id = "76370e8387ba2f3549c6da2ad71e96ac"
zmediaArtPresent.Name = "ArtPresent"
zmediaArtPresent.AltText = ""
zmediaArtPresent.Resources = {
  { Type = "jpg", Filename = "art_present.jpg", Directives = {},}
}
zmediaBirdLoc = Wherigo.ZMedia(cartMeetMein1904)
zmediaBirdLoc.Id = "c93edb231b7d19b5202fd1c08d79b349"
zmediaBirdLoc.Name = "BirdLoc"
zmediaBirdLoc.AltText = ""
zmediaBirdLoc.Resources = {
  { Type = "jpg", Filename = "bird_present.jpg", Directives = {},}
}
zmediaBirdPast = Wherigo.ZMedia(cartMeetMein1904)
zmediaBirdPast.Id = "d7ad3a4165d6d14e4daa5a7c6fac042c"
zmediaBirdPast.Name = "BirdPast"
zmediaBirdPast.AltText = ""
zmediaBirdPast.Resources = {
  { Type = "jpg", Filename = "bird_past.jpg", Directives = {},}
}
zmediaBirdPresent = Wherigo.ZMedia(cartMeetMein1904)
zmediaBirdPresent.Id = "548fff210a6fa9447e9ad50a644260c3"
zmediaBirdPresent.Name = "BirdPresent"
zmediaBirdPresent.AltText = ""
zmediaBirdPresent.Resources = {
  { Type = "jpg", Filename = "bird_present.jpg", Directives = {},}
}
zmediaCamera = Wherigo.ZMedia(cartMeetMein1904)
zmediaCamera.Id = "a65065f5fc5c46f9a5abff8a240650a2"
zmediaCamera.Name = "Camera"
zmediaCamera.AltText = ""
zmediaCamera.Resources = {
  { Type = "jpg", Filename = "timeCamera.jpg", Directives = {},}
, { Type = "jpg", Filename = "camera.jpg", Directives = {},}
}
zmediaEduLoc = Wherigo.ZMedia(cartMeetMein1904)
zmediaEduLoc.Id = "7c0a42db46ced70aca5f95490268a349"
zmediaEduLoc.Name = "EduLoc"
zmediaEduLoc.AltText = ""
zmediaEduLoc.Resources = {
  { Type = "jpg", Filename = "edu_loc.jpg", Directives = {},}
}
zmediaEduPast = Wherigo.ZMedia(cartMeetMein1904)
zmediaEduPast.Id = "d3efb68efe8f79fefc249746846777a8"
zmediaEduPast.Name = "EduPast"
zmediaEduPast.AltText = ""
zmediaEduPast.Resources = {
  { Type = "jpg", Filename = "edu_past.jpg", Directives = {},}
}
zmediaEduPresent = Wherigo.ZMedia(cartMeetMein1904)
zmediaEduPresent.Id = "fcb5d93c15af6d94e614c015948fd531"
zmediaEduPresent.Name = "EduPresent"
zmediaEduPresent.AltText = ""
zmediaEduPresent.Resources = {
  { Type = "jpg", Filename = "edu_present.jpg", Directives = {},}
}
zmediaFinalCache = Wherigo.ZMedia(cartMeetMein1904)
zmediaFinalCache.Id = "1c44571aa10a0523054e534b34b84a75"
zmediaFinalCache.Name = "Final Cache"
zmediaFinalCache.AltText = ""
zmediaFinalCache.Resources = {
  { Type = "jpg", Filename = "Finalresize.jpg", Directives = {},}
}
zmediaFireworks = Wherigo.ZMedia(cartMeetMein1904)
zmediaFireworks.Id = "8b2af6862fa028927712b7db722d4be2"
zmediaFireworks.Name = "Fireworks"
zmediaFireworks.AltText = ""
zmediaFireworks.Resources = {
  { Type = "jpg", Filename = "Fireworks.jpg", Directives = {},}
}
zmediaGeocache = Wherigo.ZMedia(cartMeetMein1904)
zmediaGeocache.Id = "1eb5c1fa909bd24e1e336208d7f0f61f"
zmediaGeocache.Name = "Geocache"
zmediaGeocache.AltText = ""
zmediaGeocache.Resources = {
  { Type = "jpg", Filename = "26996d05-5b78-4386-a1a5-8c56c7d35c83.jpg", Directives = {},}
}
zmediaIcoArt = Wherigo.ZMedia(cartMeetMein1904)
zmediaIcoArt.Id = "7af556a33280c443f2b14796247c760f"
zmediaIcoArt.Name = "IcoArt"
zmediaIcoArt.AltText = ""
zmediaIcoArt.Resources = {
  { Type = "jpg", Filename = "IconArtPast.jpg", Directives = {},}
}
zmediaIcoBasin = Wherigo.ZMedia(cartMeetMein1904)
zmediaIcoBasin.Id = "d80690675c644864c5fd3a899973b656"
zmediaIcoBasin.Name = "IcoBasin"
zmediaIcoBasin.AltText = ""
zmediaIcoBasin.Resources = {
  { Type = "jpg", Filename = "IconBasinPast.jpg", Directives = {},}
}
zmediaIcoBird = Wherigo.ZMedia(cartMeetMein1904)
zmediaIcoBird.Id = "fff5f84569565f55cddcf77172a2f1cb"
zmediaIcoBird.Name = "IcoBird"
zmediaIcoBird.AltText = ""
zmediaIcoBird.Resources = {
  { Type = "jpg", Filename = "IconBirdcagePast.jpg", Directives = {},}
}
zmediaIcoCamera = Wherigo.ZMedia(cartMeetMein1904)
zmediaIcoCamera.Id = "669e94b1ab19fa396433de4eeb464e4a"
zmediaIcoCamera.Name = "IcoCamera"
zmediaIcoCamera.AltText = ""
zmediaIcoCamera.Resources = {
  { Type = "jpg", Filename = "IconTimeCamera.jpg", Directives = {},}
}
zmediaIcoEdu = Wherigo.ZMedia(cartMeetMein1904)
zmediaIcoEdu.Id = "e7d6f5e1c48db41c7d2eac3c6609ebae"
zmediaIcoEdu.Name = "IcoEdu"
zmediaIcoEdu.AltText = ""
zmediaIcoEdu.Resources = {
  { Type = "jpg", Filename = "IconEduPast.jpg", Directives = {},}
}
zmediaIcoMach = Wherigo.ZMedia(cartMeetMein1904)
zmediaIcoMach.Id = "ba4bdd369b8c5bd2a666d4b1cb2d580b"
zmediaIcoMach.Name = "IcoMach"
zmediaIcoMach.AltText = ""
zmediaIcoMach.Resources = {
  { Type = "jpg", Filename = "IconElecPast.jpg", Directives = {},}
}
zmediaIcoProfessor = Wherigo.ZMedia(cartMeetMein1904)
zmediaIcoProfessor.Id = "62ebb7ff18964a5403812ddf617e8ab0"
zmediaIcoProfessor.Name = "IcoProfessor"
zmediaIcoProfessor.AltText = ""
zmediaIcoProfessor.Resources = {
  { Type = "jpg", Filename = "IconProfessor.jpg", Directives = {},}
}
zmediaLakePast = Wherigo.ZMedia(cartMeetMein1904)
zmediaLakePast.Id = "f2938d496b1c3b5b0388c3ccd8ebd5b5"
zmediaLakePast.Name = "LakePast"
zmediaLakePast.AltText = ""
zmediaLakePast.Resources = {
  { Type = "jpg", Filename = "lake_past.jpg", Directives = {},}
}
zmediaLakePresent = Wherigo.ZMedia(cartMeetMein1904)
zmediaLakePresent.Id = "8e2b0a5370db145ec5cdd37af3a02096"
zmediaLakePresent.Name = "LakePresent"
zmediaLakePresent.AltText = ""
zmediaLakePresent.Resources = {
  { Type = "jpg", Filename = "lake_present.jpg", Directives = {},}
}
zmediaMachLoc = Wherigo.ZMedia(cartMeetMein1904)
zmediaMachLoc.Id = "cc775178d1b0da71a178fb692484f002"
zmediaMachLoc.Name = "MachLoc"
zmediaMachLoc.AltText = ""
zmediaMachLoc.Resources = {
  { Type = "jpg", Filename = "mach_loc.jpg", Directives = {},}
}
zmediaMachPast = Wherigo.ZMedia(cartMeetMein1904)
zmediaMachPast.Id = "77e93600598d7b557ca5c63de3ef72cf"
zmediaMachPast.Name = "MachPast"
zmediaMachPast.AltText = ""
zmediaMachPast.Resources = {
  { Type = "jpg", Filename = "mach_present.jpg", Directives = {},}
}
zmediaMachPresent = Wherigo.ZMedia(cartMeetMein1904)
zmediaMachPresent.Id = "1866a17411006d451f0d89739e287aad"
zmediaMachPresent.Name = "MachPresent"
zmediaMachPresent.AltText = ""
zmediaMachPresent.Resources = {
  { Type = "jpg", Filename = "mach_present.jpg", Directives = {},}
}
zmediaNewspaper = Wherigo.ZMedia(cartMeetMein1904)
zmediaNewspaper.Id = "2e2696984ebf09700732b61b35beee9b"
zmediaNewspaper.Name = "Newspaper"
zmediaNewspaper.AltText = ""
zmediaNewspaper.Resources = {
  { Type = "jpg", Filename = "newspaper.jpg", Directives = {},}
}
zmediaNotAdolph = Wherigo.ZMedia(cartMeetMein1904)
zmediaNotAdolph.Id = "12b1d7cd956ec741153b11fb459cd863"
zmediaNotAdolph.Name = "NotAdolph"
zmediaNotAdolph.AltText = ""
zmediaNotAdolph.Resources = {
  { Type = "jpg", Filename = "notadolph.jpg", Directives = {},}
}
zmediaPole = Wherigo.ZMedia(cartMeetMein1904)
zmediaPole.Id = "b171d5510d0ea1cc852807b72fac88b3"
zmediaPole.Name = "Pole"
zmediaPole.AltText = ""
zmediaPole.Resources = {
  { Type = "jpg", Filename = "pole.jpg", Directives = {},}
}
zmediaPoster = Wherigo.ZMedia(cartMeetMein1904)
zmediaPoster.Id = "4abe5e6d16f94110657c13688e64436b"
zmediaPoster.Name = "Poster"
zmediaPoster.AltText = ""
zmediaPoster.Resources = {
  { Type = "jpg", Filename = "poster.jpg", Directives = {},}
}
zmediaProfessor = Wherigo.ZMedia(cartMeetMein1904)
zmediaProfessor.Id = "f018a0b7fabb6e3c422f3b3876bfd59d"
zmediaProfessor.Name = "Professor"
zmediaProfessor.AltText = ""
zmediaProfessor.Resources = {
  { Type = "jpg", Filename = "professor.jpg", Directives = {},}
}
zmediaZot = Wherigo.ZMedia(cartMeetMein1904)
zmediaZot.Id = "20eda4b7eb26cc21729695b0bdac24dd"
zmediaZot.Name = "Zot"
zmediaZot.AltText = ""
zmediaZot.Resources = {
  { Type = "jpg", Filename = "Zap.jpg", Directives = {},}
}
-- Cartridge Info --
cartMeetMein1904.Id = "750cc2490ab99c1219a8ae5d678d122c"
cartMeetMein1904.Name = "Meet Me in 1904"
cartMeetMein1904.Activity = "Geocache"
cartMeetMein1904.Version = "00:26"
cartMeetMein1904.Company = "Game Jam 2013"
cartMeetMein1904.Author = "Game Jam 2013"
cartMeetMein1904.TargetDevice = "PocketPC"
cartMeetMein1904.TargetDeviceVersion = "0"
cartMeetMein1904.BuilderVersion = "WWB v0.3.2014.11.04.223804"
cartMeetMein1904.StateId = "1"
cartMeetMein1904.CountryId = "2"
cartMeetMein1904.Description = [[An adventure in time. This cartridge will take you on a walking tour of Forest Park in St. Louis, which in 1904 was the setting of the World's Fair. Renowned British scientist Professor Emmett Smith-Tennant is working on a secret experiment which he claims will "change our understanding of time, the universe, and everything." Something has gone horribly wrong and Dr. Tennant is stuck in the past. Can you help him get back? This cartridge will take approximately one hour to complete.]]
cartMeetMein1904.StartingLocationDescription = [[]]
cartMeetMein1904.Visible = true
cartMeetMein1904.Complete = false
cartMeetMein1904.UseLogging = false
cartMeetMein1904.CreateDate = "5/3/2013 02:06:05 AM"
cartMeetMein1904.PublishDate = "1/1/2001 12:00:00 AM"
cartMeetMein1904.UpdateDate = "12/22/2014 08:04:03 PM"
cartMeetMein1904.LastPlayedDate = "1/1/2001 12:00:00 AM"
cartMeetMein1904.Media = zmediaPoster
cartMeetMein1904.Icon = zmediaPoster
cartMeetMein1904.StartingLocation = ZonePoint(38.639233334859,-90.292166678111,0)

-- Zones --
zoneArtMuseum = Wherigo.Zone(cartMeetMein1904)
zoneArtMuseum.Id = "4fddb101a36b6e5a0b2832463466318a"
zoneArtMuseum.Name = "Art Museum"
zoneArtMuseum.DistanceRangeUOM = "Feet"
zoneArtMuseum.ProximityRangeUOM = "Feet"
zoneArtMuseum.ShowObjects = "OnProximity"
zoneArtMuseum.OutOfRangeName = ""
zoneArtMuseum.InRangeName = ""
zoneArtMuseum.Description = "The St. Louis Art Museum was known at the 1904 World's Fair as The Palace of Fine Arts. It was intended to be the only surviving structure of the main exhibition buildings built around the Grand Basin for the fair, and was built of stone and steel instead of wood like the other buildings."
zoneArtMuseum.Visible = true
zoneArtMuseum.AllowSetPositionTo = false
zoneArtMuseum.Active = false
zoneArtMuseum.DistanceRange = Distance(-1, "feet")
zoneArtMuseum.ProximityRange = Distance(25, "feet")
zoneArtMuseum.Points = {
  ZonePoint(38.63986,-90.29443,0)
, ZonePoint(38.63986,-90.29404,0)
, ZonePoint(38.63954,-90.29404,0)
, ZonePoint(38.63954,-90.29443,0)
}
zoneArtMuseum.OriginalPoint = ZonePoint(38.639699999491,-90.294233322144,0)
zoneArtMuseum.Media = zmediaArtPresent
zoneArtMuseum.Icon = zmediaIcoArt

zoneEducationBuilding = Wherigo.Zone(cartMeetMein1904)
zoneEducationBuilding.Id = "f0679f97ee5b48410131f9209a381b45"
zoneEducationBuilding.Name = "Education Building"
zoneEducationBuilding.DistanceRangeUOM = "Feet"
zoneEducationBuilding.ProximityRangeUOM = "Feet"
zoneEducationBuilding.ShowObjects = "OnProximity"
zoneEducationBuilding.OutOfRangeName = ""
zoneEducationBuilding.InRangeName = ""
zoneEducationBuilding.Description = "This is the site of the former Palace of Education and Social Economy, which represented the idea that the Fair was intended to educate as well as entertain. Fair attendees could watch classes being taught, attend a Washington University course, or learn Braille and calligraphy"
zoneEducationBuilding.Visible = true
zoneEducationBuilding.AllowSetPositionTo = false
zoneEducationBuilding.Active = false
zoneEducationBuilding.DistanceRange = Distance(-1, "feet")
zoneEducationBuilding.ProximityRange = Distance(25, "feet")
zoneEducationBuilding.Points = {
  ZonePoint(38.64261,-90.29045,0)
, ZonePoint(38.64261,-90.29005,0)
, ZonePoint(38.64229,-90.29005,0)
, ZonePoint(38.64229,-90.29045,0)
}
zoneEducationBuilding.OriginalPoint = ZonePoint(38.64245001475,-90.290250015259,0)
zoneEducationBuilding.Media = zmediaEduPresent
zoneEducationBuilding.Icon = zmediaIcoEdu

zoneFinal = Wherigo.Zone(cartMeetMein1904)
zoneFinal.Id = "b1a8198604e3451106906847ab074bca"
zoneFinal.Name = "Final"
zoneFinal.DistanceRangeUOM = "Feet"
zoneFinal.ProximityRangeUOM = "Feet"
zoneFinal.ShowObjects = "OnEnter"
zoneFinal.OutOfRangeName = ""
zoneFinal.InRangeName = ""
zoneFinal.Description = WWB_multiplatform_string("The Professor left a gift for you nearby, at the base of a fallen tree. The coordinates for the final are N 38\194\176 38.008 W 090\194\176 16.979.")
zoneFinal.Visible = true
zoneFinal.AllowSetPositionTo = false
zoneFinal.Active = false
zoneFinal.DistanceRange = Distance(-1, "feet")
zoneFinal.ProximityRange = Distance(20, "feet")
zoneFinal.Points = {
  ZonePoint(38.6334166666667,-90.2829333333333,0)
, ZonePoint(38.6335,-90.2829166666667,0)
, ZonePoint(38.6335166666667,-90.2830333333333,0)
, ZonePoint(38.6334333333333,-90.28305,0)
}
zoneFinal.OriginalPoint = ZonePoint(38.6334666666667,-90.2829833333333,0)
zoneFinal.Media = zmediaGeocache

zoneFountainFront = Wherigo.Zone(cartMeetMein1904)
zoneFountainFront.Id = "e604656b27a67a9edcd06d446deee1cc"
zoneFountainFront.Name = "Fountain Front"
zoneFountainFront.DistanceRangeUOM = "Feet"
zoneFountainFront.ProximityRangeUOM = "Feet"
zoneFountainFront.ShowObjects = "OnProximity"
zoneFountainFront.OutOfRangeName = ""
zoneFountainFront.InRangeName = ""
zoneFountainFront.Description = "There's a lovely view from here."
zoneFountainFront.Visible = true
zoneFountainFront.AllowSetPositionTo = false
zoneFountainFront.Active = false
zoneFountainFront.DistanceRange = Distance(-1, "feet")
zoneFountainFront.ProximityRange = Distance(25, "feet")
zoneFountainFront.Points = {
  ZonePoint(38.64304,-90.29133,0)
, ZonePoint(38.64304,-90.29094,0)
, ZonePoint(38.64273,-90.29094,0)
, ZonePoint(38.64273,-90.29133,0)
}
zoneFountainFront.OriginalPoint = ZonePoint(38.642883364359,-90.2911333402,0)
zoneFountainFront.Media = zmediaLakePresent
zoneFountainFront.Icon = zmediaIcoBasin

zoneMachineryBuilding = Wherigo.Zone(cartMeetMein1904)
zoneMachineryBuilding.Id = "bdb7fd45a8290eb5a9634f8c0bf70927"
zoneMachineryBuilding.Name = "Machinery Building"
zoneMachineryBuilding.DistanceRangeUOM = "Feet"
zoneMachineryBuilding.ProximityRangeUOM = "Feet"
zoneMachineryBuilding.ShowObjects = "OnProximity"
zoneMachineryBuilding.OutOfRangeName = ""
zoneMachineryBuilding.InRangeName = ""
zoneMachineryBuilding.Description = "This is where the Palace of Electricity and Machinery was located. The Palace served as the home to the DeForest Wireless Telegraph tower, an exhibit that allowed fair-goers to transmit telegraph messages to Springfield and Chicago without a needing a telegraph wire. DeForest also had a wireless telephone on display, the earliest known precursor to today's mobile phones."
zoneMachineryBuilding.Visible = true
zoneMachineryBuilding.AllowSetPositionTo = false
zoneMachineryBuilding.Active = false
zoneMachineryBuilding.DistanceRange = Distance(-1, "feet")
zoneMachineryBuilding.ProximityRange = Distance(25, "feet")
zoneMachineryBuilding.Points = {
  ZonePoint(38.64274,-90.29246,0)
, ZonePoint(38.64274,-90.29207,0)
, ZonePoint(38.64243,-90.29207,0)
, ZonePoint(38.64243,-90.29246,0)
}
zoneMachineryBuilding.OriginalPoint = ZonePoint(38.64258333842,-90.292266654968,0)
zoneMachineryBuilding.Media = zmediaMachLoc
zoneMachineryBuilding.Icon = zmediaIcoMach

zoneTemporalControl = Wherigo.Zone(cartMeetMein1904)
zoneTemporalControl.Id = "ade378146996ee450c705b02ce1dabb4"
zoneTemporalControl.Name = "Temporal Control"
zoneTemporalControl.DistanceRangeUOM = "Feet"
zoneTemporalControl.ProximityRangeUOM = "Feet"
zoneTemporalControl.ShowObjects = "OnProximity"
zoneTemporalControl.OutOfRangeName = ""
zoneTemporalControl.InRangeName = ""
zoneTemporalControl.Description = "The 1904 World's Fair Flight Cage was commissioned by the Smithsonian Institution, which intended to move the Cage to the National Zoo after the World's Fair. But St. Louisans rallied to keep the Cage, and soon started a movement to create the St. Louis Zoo around the Cage."
zoneTemporalControl.Visible = true
zoneTemporalControl.AllowSetPositionTo = false
zoneTemporalControl.Active = false
zoneTemporalControl.DistanceRange = Distance(-1, "feet")
zoneTemporalControl.ProximityRange = Distance(25, "feet")
zoneTemporalControl.Points = {
  ZonePoint(38.63584,-90.28758,0)
, ZonePoint(38.63584,-90.28719,0)
, ZonePoint(38.63553,-90.28719,0)
, ZonePoint(38.63553,-90.28758,0)
}
zoneTemporalControl.OriginalPoint = ZonePoint(38.635683314005,-90.287383333842,0)
zoneTemporalControl.Media = zmediaBirdLoc
zoneTemporalControl.Icon = zmediaIcoBird

zoneWhatsthis = Wherigo.Zone(cartMeetMein1904)
zoneWhatsthis.Id = "bfaa9129567f3cdb7c408dc4eecc644a"
zoneWhatsthis.Name = "What's this?"
zoneWhatsthis.DistanceRangeUOM = "Feet"
zoneWhatsthis.ProximityRangeUOM = "Feet"
zoneWhatsthis.ShowObjects = "OnProximity"
zoneWhatsthis.OutOfRangeName = ""
zoneWhatsthis.InRangeName = ""
zoneWhatsthis.Description = "Through your device, you see Adolph and Annie chatting on the lawns near the Grand Basin."
zoneWhatsthis.Visible = true
zoneWhatsthis.AllowSetPositionTo = false
zoneWhatsthis.Active = false
zoneWhatsthis.DistanceRange = Distance(-1, "feet")
zoneWhatsthis.ProximityRange = Distance(25, "feet")
zoneWhatsthis.Points = {
  ZonePoint(38.64132,-90.29361,0)
, ZonePoint(38.64132,-90.29322,0)
, ZonePoint(38.64101,-90.29322,0)
, ZonePoint(38.64101,-90.29361,0)
}
zoneWhatsthis.OriginalPoint = ZonePoint(38.641166687012,-90.293416659037,0)

-- Characters --
zcharacterDrTennent = Wherigo.ZCharacter{Cartridge=cartMeetMein1904, Container=zoneEducationBuilding}
zcharacterDrTennent.Id = "eafbfa91aa844c1215d422851ff6b9a5"
zcharacterDrTennent.Name = "Dr. Tennent"
zcharacterDrTennent.Gender = "Male"
zcharacterDrTennent.Type = "NPC"
zcharacterDrTennent.Description = "Renowned British scientist Professor Emmett Smith-Tennant, the world's foremost expert in theoretical physics. \060BR\062\010\060BR\062\010\060BR\062\010Dr. Tennant recently announced the unveiling of his secret project, which he claims will \"change our understanding of time, the universe, and everything.\" Professor Smith-Tennant caused a stir in 2009 when he left his position at Oxford University to work on this project in an undisclosed location. "
zcharacterDrTennent.Visible = true
zcharacterDrTennent.ObjectLocation = ZonePoint(36.000001777866,-79.000000001859,360)
zcharacterDrTennent.Media = zmediaProfessor
zcharacterDrTennent.Icon = zmediaIcoProfessor
zcharacterDrTennent.Commands = {
  Talk = Wherigo.ZCommand{Text="Talk", EmptyTargetListText="Nothing available", CmdWith=false, Enabled=true}
}
zcharacterDrTennent.Commands.Talk.Id = "65bc719a22adfb7b1c1fe0210c3139e4"
zcharacterDrTennent.Commands.Talk.Custom = true
zcharacterDrTennent.Commands.Talk.WorksWithAll = true

-- Items --
zitemArtPastPhoto = Wherigo.ZItem(cartMeetMein1904)
zitemArtPastPhoto.Id = "68d776d337399831b992b3fb198ce84f"
zitemArtPastPhoto.Name = "Art - Past Photo"
zitemArtPastPhoto.Description = "A photo of the professor near the Art Museum."
zitemArtPastPhoto.Visible = true
zitemArtPastPhoto.Locked = false
zitemArtPastPhoto.Opened = false
zitemArtPastPhoto.ObjectLocation = Wherigo.INVALID_ZONEPOINT
zitemArtPastPhoto.Media = zmediaArtPast
zitemArtPastPhoto.Icon = zmediaIcoArt

zitemBench = Wherigo.ZItem{Cartridge=cartMeetMein1904, Container=zoneMachineryBuilding}
zitemBench.Id = "f89ca457c58747c6dcaf6262bf5d470b"
zitemBench.Name = "Bench"
zitemBench.Description = "Look around at the benches nearby. Maybe one of them has a clue to Adolph and Annie's story."
zitemBench.Visible = false
zitemBench.Locked = false
zitemBench.Opened = false
zitemBench.ObjectLocation = ZonePoint(38.64258333842,-90.292266654968,0)
zitemBench.Commands = {
  Examine = Wherigo.ZCommand{Text="Examine", EmptyTargetListText="Nothing available", CmdWith=false, Enabled=true}
}
zitemBench.Commands.Examine.Id = "655e7c8066528172871e112a6cc94696"
zitemBench.Commands.Examine.Custom = true
zitemBench.Commands.Examine.WorksWithAll = true

zitemBirdPastPhoto = Wherigo.ZItem(cartMeetMein1904)
zitemBirdPastPhoto.Id = "6189bea9f1e070addae938a4165e5bce"
zitemBirdPastPhoto.Name = "Bird - Past Photo"
zitemBirdPastPhoto.Description = "A photo of the Bird Cage in the past."
zitemBirdPastPhoto.Visible = true
zitemBirdPastPhoto.Locked = false
zitemBirdPastPhoto.Opened = false
zitemBirdPastPhoto.ObjectLocation = Wherigo.INVALID_ZONEPOINT
zitemBirdPastPhoto.Media = zmediaBirdPast
zitemBirdPastPhoto.Icon = zmediaIcoBird

zitemCompletionCode = Wherigo.ZItem(cartMeetMein1904)
zitemCompletionCode.Id = "544e6d4cae4fd23bc359f1de5880cbd0"
zitemCompletionCode.Name = "Completion Code"
zitemCompletionCode.Description = "Your Completion Code is ~~Player.CompletionCode~~. You can use this at wherigo.com to prove that you've completed this cartridge."
zitemCompletionCode.Visible = true
zitemCompletionCode.Locked = false
zitemCompletionCode.Opened = false
zitemCompletionCode.ObjectLocation = Wherigo.INVALID_ZONEPOINT

zitemCredits = Wherigo.ZItem(cartMeetMein1904)
zitemCredits.Id = "70b2e5158c7b39c6757d5c0f5c9e1f93"
zitemCredits.Name = "Credits"
zitemCredits.Description = "This Wherigo cartridge was created at the St. Louis Game Jam, using Wherigo Builder and Earwigo. Team members included:\060BR\062\010* Jen Patton (Animuse)\060BR\062\010* Ranger Fox\060BR\062\010* Caitlin Moriarity\060BR\062\010* Elonka Dunin\060BR\062\010* Lara Burnett\060BR\062\010* Data Wrangler\060BR\062\010* Forest-Ghost"
zitemCredits.Visible = true
zitemCredits.Locked = false
zitemCredits.Opened = false
zitemCredits.ObjectLocation = Wherigo.INVALID_ZONEPOINT

zitemEducationalPastPhoto = Wherigo.ZItem(cartMeetMein1904)
zitemEducationalPastPhoto.Id = "d581070249c63945d6f8c2033ab3919d"
zitemEducationalPastPhoto.Name = "Educational - Past Photo"
zitemEducationalPastPhoto.Description = "A photo of the professor near the educational building in the past."
zitemEducationalPastPhoto.Visible = true
zitemEducationalPastPhoto.Locked = false
zitemEducationalPastPhoto.Opened = false
zitemEducationalPastPhoto.ObjectLocation = Wherigo.INVALID_ZONEPOINT
zitemEducationalPastPhoto.Media = zmediaEduPast
zitemEducationalPastPhoto.Icon = zmediaIcoEdu

zitemFountainPastPhoto = Wherigo.ZItem(cartMeetMein1904)
zitemFountainPastPhoto.Id = "9295afa43044b513745b82c1821c6475"
zitemFountainPastPhoto.Name = "Fountain - Past Photo"
zitemFountainPastPhoto.Description = "A photo of the professor near the fountain."
zitemFountainPastPhoto.Visible = true
zitemFountainPastPhoto.Locked = false
zitemFountainPastPhoto.Opened = false
zitemFountainPastPhoto.ObjectLocation = Wherigo.INVALID_ZONEPOINT
zitemFountainPastPhoto.Media = zmediaLakePast
zitemFountainPastPhoto.Icon = zmediaIcoBasin

zitemFountainsidePastPhoto = Wherigo.ZItem(cartMeetMein1904)
zitemFountainsidePastPhoto.Id = "89c6f3f2563ee2ddc6d960365ebb2936"
zitemFountainsidePastPhoto.Name = "Fountainside - Past Photo"
zitemFountainsidePastPhoto.Description = "The professor at the side of the fountain."
zitemFountainsidePastPhoto.Visible = true
zitemFountainsidePastPhoto.Locked = false
zitemFountainsidePastPhoto.Opened = false
zitemFountainsidePastPhoto.ObjectLocation = Wherigo.INVALID_ZONEPOINT
zitemFountainsidePastPhoto.Media = zmediaEduPast
zitemFountainsidePastPhoto.Icon = zmediaIcoMach

zitemPhotoofAdolphandAnnie = Wherigo.ZItem(cartMeetMein1904)
zitemPhotoofAdolphandAnnie.Id = "0f0ae44bb8c26f4d777016ad061ff0e6"
zitemPhotoofAdolphandAnnie.Name = "Photo of Adolph and Annie"
zitemPhotoofAdolphandAnnie.Description = ""
zitemPhotoofAdolphandAnnie.Visible = true
zitemPhotoofAdolphandAnnie.Locked = false
zitemPhotoofAdolphandAnnie.Opened = false
zitemPhotoofAdolphandAnnie.ObjectLocation = Wherigo.INVALID_ZONEPOINT
zitemPhotoofAdolphandAnnie.Media = zmediaNotAdolph
zitemPhotoofAdolphandAnnie.Icon = zmediaIcoBasin

zitemPlaytips = Wherigo.ZItem(cartMeetMein1904)
zitemPlaytips.Id = "259ba482f93b45b774feabab5d5c3455"
zitemPlaytips.Name = "Play tips"
zitemPlaytips.Description = "If playing on a smartphone, it is a good idea to close all other apps when playing a Wherigo cartridge.\060BR\062\010\060BR\062\010While playing this cartridge, if you have trouble getting a zone to register that you have entered already, try leaving the zone and re-entering. Good luck!"
zitemPlaytips.Visible = true
zitemPlaytips.Locked = false
zitemPlaytips.Opened = false
zitemPlaytips.ObjectLocation = Wherigo.INVALID_ZONEPOINT

zitemTEST = Wherigo.ZItem(cartMeetMein1904)
zitemTEST.Id = "0a007f161731fbf974b3970b34e94456"
zitemTEST.Name = "TEST"
zitemTEST.Description = ""
zitemTEST.Visible = true
zitemTEST.Locked = false
zitemTEST.Opened = false
zitemTEST.ObjectLocation = Wherigo.INVALID_ZONEPOINT
zitemTEST.Commands = {
  Adolph = Wherigo.ZCommand{Text="Adolph", CmdWith=false, Enabled=true}
, Art = Wherigo.ZCommand{Text="Art", CmdWith=false, Enabled=true}
, Basin = Wherigo.ZCommand{Text="Basin", CmdWith=false, Enabled=true}
, Bird = Wherigo.ZCommand{Text="Bird", CmdWith=false, Enabled=true}
, Edu = Wherigo.ZCommand{Text="Edu", CmdWith=false, Enabled=true}
, Mach = Wherigo.ZCommand{Text="Mach", CmdWith=false, Enabled=true}
}
zitemTEST.Commands.Adolph.Id = "4dcb4afab30b9c9ea384b787341db03c"
zitemTEST.Commands.Adolph.Custom = true
zitemTEST.Commands.Adolph.WorksWithAll = true
zitemTEST.Commands.Art.Id = "0bdd245f9e4527273dad83a7f8ecf560"
zitemTEST.Commands.Art.Custom = true
zitemTEST.Commands.Art.WorksWithAll = true
zitemTEST.Commands.Basin.Id = "77c545d42b316ba93329db0e2105793f"
zitemTEST.Commands.Basin.Custom = true
zitemTEST.Commands.Basin.WorksWithAll = true
zitemTEST.Commands.Bird.Id = "06411ab23b98239dda177e572593924c"
zitemTEST.Commands.Bird.Custom = true
zitemTEST.Commands.Bird.WorksWithAll = true
zitemTEST.Commands.Edu.Id = "5aac4d5b3ca3b5c24eb96568d53e6ac8"
zitemTEST.Commands.Edu.Custom = true
zitemTEST.Commands.Edu.WorksWithAll = true
zitemTEST.Commands.Mach.Id = "b041adc49123ae389be54800d675d4d7"
zitemTEST.Commands.Mach.Custom = true
zitemTEST.Commands.Mach.WorksWithAll = true

zitemTimeCamera = Wherigo.ZItem(cartMeetMein1904)
zitemTimeCamera.Id = "a9ac5c6c22aa6487c4927e1285e6da47"
zitemTimeCamera.Name = "Time Camera"
zitemTimeCamera.Description = ""
zitemTimeCamera.Visible = true
zitemTimeCamera.Locked = false
zitemTimeCamera.Opened = false
zitemTimeCamera.ObjectLocation = ZonePoint(38.639699999491,-90.294233322144,0)
zitemTimeCamera.Media = zmediaCamera
zitemTimeCamera.Icon = zmediaIcoCamera
zitemTimeCamera.Commands = {
  TakePicture = Wherigo.ZCommand{Text="Take Picture", EmptyTargetListText="Nothing available", CmdWith=false, Enabled=true}
}
zitemTimeCamera.Commands.TakePicture.Id = "2eafa3d8c04abc8f528427ffa3f4ffa0"
zitemTimeCamera.Commands.TakePicture.Custom = true
zitemTimeCamera.Commands.TakePicture.WorksWithAll = true

-- Tasks --
ztaskFindgeocache = Wherigo.ZTask(cartMeetMein1904)
ztaskFindgeocache.Id = "d8a37b193f60d8e34fe1914a3382154a"
ztaskFindgeocache.Name = "Find geocache"
ztaskFindgeocache.CorrectState = "None"
ztaskFindgeocache.Description = "Go to the \"Final\" listed on the Locations menu to find the geocache."
ztaskFindgeocache.Visible = true
ztaskFindgeocache.Active = false
ztaskFindgeocache.Complete = false

ztaskGotoArtMuseum = Wherigo.ZTask(cartMeetMein1904)
ztaskGotoArtMuseum.Id = "ed9a400c5eec7e6434e8d9523607b1f9"
ztaskGotoArtMuseum.Name = "Go to Art Museum"
ztaskGotoArtMuseum.CorrectState = "None"
ztaskGotoArtMuseum.Description = "Check the Locations menu"
ztaskGotoArtMuseum.Visible = true
ztaskGotoArtMuseum.Active = true
ztaskGotoArtMuseum.Complete = false

ztaskGotoBirdCage = Wherigo.ZTask(cartMeetMein1904)
ztaskGotoBirdCage.Id = "ed05afa251e62c1f4ffb87545cfaf54b"
ztaskGotoBirdCage.Name = "Go to Bird Cage"
ztaskGotoBirdCage.CorrectState = "None"
ztaskGotoBirdCage.Description = "Check the Locations menu. To Dr. Tennant, the Bird Case is \"Temporal Control\"."
ztaskGotoBirdCage.Visible = true
ztaskGotoBirdCage.Active = false
ztaskGotoBirdCage.Complete = false

ztaskGotoEducationBuilding = Wherigo.ZTask(cartMeetMein1904)
ztaskGotoEducationBuilding.Id = "be5f4a6e4bc67b14cfe97c8c8b651d2e"
ztaskGotoEducationBuilding.Name = "Go to Education Building"
ztaskGotoEducationBuilding.CorrectState = "None"
ztaskGotoEducationBuilding.Description = "Check the Locations menu"
ztaskGotoEducationBuilding.Visible = true
ztaskGotoEducationBuilding.Active = false
ztaskGotoEducationBuilding.Complete = false

ztaskGotofinallocation = Wherigo.ZTask(cartMeetMein1904)
ztaskGotofinallocation.Id = "ad93d817877c45f3e94cd0c6512793c3"
ztaskGotofinallocation.Name = "Go to final location"
ztaskGotofinallocation.CorrectState = "None"
ztaskGotofinallocation.Description = "Check the Locations menu"
ztaskGotofinallocation.Visible = true
ztaskGotofinallocation.Active = false
ztaskGotofinallocation.Complete = false

ztaskGotoFountainFront = Wherigo.ZTask(cartMeetMein1904)
ztaskGotoFountainFront.Id = "0a9d43f509abdb0898a10a29409ca54d"
ztaskGotoFountainFront.Name = "Go to Fountain Front"
ztaskGotoFountainFront.CorrectState = "None"
ztaskGotoFountainFront.Description = "Check the Locations menu"
ztaskGotoFountainFront.Visible = true
ztaskGotoFountainFront.Active = false
ztaskGotoFountainFront.Complete = false

ztaskGotoMachineryBuilding = Wherigo.ZTask(cartMeetMein1904)
ztaskGotoMachineryBuilding.Id = "6465ab2c5345e2fd4f204cd90300f371"
ztaskGotoMachineryBuilding.Name = "Go to Machinery Building"
ztaskGotoMachineryBuilding.CorrectState = "None"
ztaskGotoMachineryBuilding.Description = "Check the Locations menu"
ztaskGotoMachineryBuilding.Visible = true
ztaskGotoMachineryBuilding.Active = false
ztaskGotoMachineryBuilding.Complete = false

ztaskSearchforsomethingdifferent = Wherigo.ZTask(cartMeetMein1904)
ztaskSearchforsomethingdifferent.Id = "3c96eec0c989f97a13247c6adf418aee"
ztaskSearchforsomethingdifferent.Name = "Search for something different"
ztaskSearchforsomethingdifferent.CorrectState = "None"
ztaskSearchforsomethingdifferent.Description = "Hmm, perhaps one of these benches has a clue to what happened in 1904?"
ztaskSearchforsomethingdifferent.Visible = true
ztaskSearchforsomethingdifferent.Active = false
ztaskSearchforsomethingdifferent.Complete = false

ztaskTalktoProfessor = Wherigo.ZTask(cartMeetMein1904)
ztaskTalktoProfessor.Id = "af46c8d2640152ba87c7d2729f92e72f"
ztaskTalktoProfessor.Name = "Talk to Professor"
ztaskTalktoProfessor.CorrectState = "None"
ztaskTalktoProfessor.Description = "This would be a good time to talk to Professor Tennent. Perhaps he's in one of the Locations nearby."
ztaskTalktoProfessor.Visible = true
ztaskTalktoProfessor.Active = false
ztaskTalktoProfessor.Complete = false

ztaskUsetheTimeCamera = Wherigo.ZTask(cartMeetMein1904)
ztaskUsetheTimeCamera.Id = "94d7704e26cb607acab542f87aab1671"
ztaskUsetheTimeCamera.Name = "Use the Time Camera"
ztaskUsetheTimeCamera.CorrectState = "None"
ztaskUsetheTimeCamera.Description = "Use the Time Camera in your inventory to take a picture."
ztaskUsetheTimeCamera.Visible = true
ztaskUsetheTimeCamera.Active = false
ztaskUsetheTimeCamera.Complete = false

-- Cartridge Variables --
WWB_device = nil
var_picindex = 0
var_var = 0
var_varstr = ""
cartMeetMein1904.ZVariables = {WWB_device = nil, var_picindex = 0, var_var = 0, var_varstr = ""}

-- Builder Variables (to be read by the builder only) --
buildervar = {}
buildervar.var_picindex = {}
buildervar.var_picindex.Id = "d8ef371436279e1afc9cc3e372860bd0"
buildervar.var_picindex.Name = "picindex"
buildervar.var_picindex.Type = "Number"
buildervar.var_picindex.Data = "0"

buildervar.var_var = {}
buildervar.var_var.Id = "04e37330a68c2cca363e2de56586dadf"
buildervar.var_var.Name = "var"
buildervar.var_var.Type = "Number"
buildervar.var_var.Data = "0"

buildervar.var_varstr = {}
buildervar.var_varstr.Id = "bdab9eb397f97038fabec78aa8f9ed20"
buildervar.var_varstr.Name = "varstr"
buildervar.var_varstr.Type = "String"
buildervar.var_varstr.Data = ""

-- ZTimers --
-- Inputs --
zinputArtInput = Wherigo.ZInput(cartMeetMein1904)
zinputArtInput.Id = "8684126f58e4ce56e8e3f544e63fa80a"
zinputArtInput.Name = "Art Input"
zinputArtInput.InputType = "Text"
zinputArtInput.Text = "You need to set your device to the right year.  What year is on the building?"
zinputArtInput.Visible = true
zinputArtInput.InputVariableId = "04e37330a68c2cca363e2de56586dadf"
zinputArtInput.Media = zmediaArtLoc

zinputEduInput = Wherigo.ZInput(cartMeetMein1904)
zinputEduInput.Id = "025afc7e8e2ce9d4b95b6e3d421f8694"
zinputEduInput.Name = "Edu Input"
zinputEduInput.InputType = "Text"
zinputEduInput.Text = "Find the key in the vertical metal pole.  The number is engraved onto the key."
zinputEduInput.Visible = true
zinputEduInput.InputVariableId = "04e37330a68c2cca363e2de56586dadf"
zinputEduInput.Media = zmediaPole

zinputMachInput = Wherigo.ZInput(cartMeetMein1904)
zinputMachInput.Id = "c79a4884c28f7ac563e117813f81017e"
zinputMachInput.Name = "Mach Input"
zinputMachInput.InputType = "Text"
zinputMachInput.Text = "What was Adolph's last name?"
zinputMachInput.Visible = true
zinputMachInput.InputVariableId = "bdab9eb397f97038fabec78aa8f9ed20"

--
-- Events/Conditions/Actions --
--

-------------------------------------------------------------------------------
------Builder Generated functions, Do not Edit, this will be overwritten------
-------------------------------------------------------------------------------

function cartMeetMein1904:OnStart()
Player.CompletionCode15 = Player.CompletionCode:sub(1, 15)
zitemTimeCamera:MoveTo(Player)
Wherigo.Dialog{{Text="HIS SECRET REVEALED?!", Media=zmediaNewspaper}, {Text="St. Louis, MO -- Renowned British scientist Professor Emmett Smith-Tennant, the world's foremost expert in theoretical physics, has called a press conference to announce the unveiling of his secret project, which he claims will \"change our understanding of time, the universe, and everything.\"\060BR\062\010\060BR\062\010Professor Smith-Tennant caused a stir in 2009 when he left his position at Oxford University to work on this project in an undisclosed location. ", Media=zmediaNewspaper}, {Text="You hear a static-y voice from the device you're carrying: \"Resonance... bad ... Need -- help ----- go to ..... Art Museum ... more information ...\" "}, {Text="You should investigate this!  Head to the Art Museum to begin."}}
zoneArtMuseum.Active = true
var_picindex = 0
zitemCredits:MoveTo(Player)
zitemPlaytips:MoveTo(Player)
end

function zoneArtMuseum:OnProximity()
if (var_picindex ~= 1) and (var_picindex ~= 2) then
--  picindex = 1

 var_picindex = 1
 zcharacterDrTennent:MoveTo(zoneArtMuseum)
 Wherigo.MessageBox{Text="You made it to the Art Museum.\060BR\062\010\060BR\062\010Your device says \"Dr. Tennent\" is here, even though you can't see him. Maybe you can use it to talk to him . . .", Media=zmediaArtLoc, Callback=cartMeetMein1904.MsgBoxCBFuncs.MsgBoxCB1}
 ztaskGotoArtMuseum.Active = false
end
end

function zoneEducationBuilding:OnProximity()
if (var_picindex ~= 3) and (var_picindex ~= 4) then
--  picindex = 3

 var_picindex = 3
 zcharacterDrTennent:MoveTo(zoneEducationBuilding)
 Wherigo.MessageBox{Text="As you approach the site of the 1904 Education Building, you hear the tail end of a distant conversation from the past:\060BR\062\010\060BR\062\010You hear the voice of a young man, \"Thank you Doctor, it was nice to meet you.\"\060BR\062\010\060BR\062\010The voice of a young woman chimes in, \"Yes, thank you!\"\060BR\062\010\060BR\062\010Dr. Tennent replies to them, \"You're welcome Adolph and Annie, and I wish you have a good time, as well!\"", Callback=cartMeetMein1904.MsgBoxCBFuncs.MsgBoxCB2}
 ztaskGotoEducationBuilding.Active = false
end
end

function zoneFinal:OnProximity()
if (var_picindex ~= 0) then
--  picindex = 0

 var_picindex = 7
 Wherigo.MessageBox{Text="You have arrived at the location the professor indicated. Do you see the cache?", Buttons={"Found it", "Didn't Find it"}, Callback=cartMeetMein1904.MsgBoxCBFuncs.MsgBoxCB3}
end
end

function zoneFinal:OnEnter()
ztaskFindgeocache.Active = true
end

function zoneFountainFront:OnProximity()
-- picindex = 4

var_picindex = 4
ztaskGotoFountainFront.Active = false
end

function zoneFountainFront:OnEnter()
-- picindex = 4

Wherigo.MessageBox{Text="Things feel attuned here, you should take another picture for the Professor.", Media=zmediaLakePresent, Callback=cartMeetMein1904.MsgBoxCBFuncs.MsgBoxCB8}
end

function zoneMachineryBuilding:OnProximity()
if (var_picindex ~= 5) and (var_picindex ~= 6) then
--  picindex = 5

 var_picindex = 5
 zcharacterDrTennent:MoveTo(zoneMachineryBuilding)
 Wherigo.MessageBox{Text="This is where the Palace of Electricity and Machinery was located. Time to look for the Professor again.", Media=zmediaMachPresent, Callback=cartMeetMein1904.MsgBoxCBFuncs.MsgBoxCB9}
 ztaskGotoMachineryBuilding.Active = false
end
end

function zoneTemporalControl:OnProximity()
zoneTemporalControl.Active = false
ztaskGotoBirdCage.Active = false
-- picindex = 8

var_picindex = 8
Wherigo.MessageBox{Text="The Professor, in the past, set up this entire cage to be a big antenna to help him get back to the present.\060BR\062\010\060BR\062\010Throw the switch to see if it'll work!", Media=zmediaBirdPast, Buttons={"Throw Switch"}, Callback=cartMeetMein1904.MsgBoxCBFuncs.MsgBoxCB10}
end

function zoneWhatsthis:OnProximity()
zcharacterDrTennent:MoveTo(zoneWhatsthis)
Wherigo.Dialog{{Text="You hear the Professor's voice, \"Hello again, Annie and Adolph. Congratulations on the good news!\""}, {Text="Annie replies, \"What good news do you mean, Doctor?\""}, {Text="\"Oh, nothing, nothing, you two crazy kids have fun today ... and for the rest of your lives ... \""}, {Text="It looks like you can take a picture of Adolph and Annie, without talking to the Professor!"}}
-- picindex = 9

var_picindex = 9
end

function zcharacterDrTennent:OnTalk()
ztaskTalktoProfessor.Active = false
if (var_picindex == 1) then
 Wherigo.MessageBox{Text=WWB_multiplatform_string("\"Fantastic! The connection is much better here.\060BR\062\010\060BR\062\010\"I need your help. My experiment has gone terribly wrong, and the temporal resonance has been messed up. Now I\226\128\153m trapped in the past, at the 1904 World's Fair. I need you to gather information for me to help me get home!\060BR\062\010\060BR\062\010\"You\226\128\153ve already helped me by going to the site of the St. Louis Art Museum. Now, we need to align the temporal frequencies. We'll do that by converting the Roman numerals on the Art Museum to numbers on the device.\"", {["PocketPC"]=1;}), Media=zmediaProfessor, Callback=cartMeetMein1904.MsgBoxCBFuncs.MsgBoxCB14}
end
if (var_picindex == 2) then
 Wherigo.MessageBox{Text="Hey, take a picture of me! ", Media=zmediaProfessor}
end
if (var_picindex == 3) then
 Wherigo.MessageBox{Text="\"Nice kids, Adolph and Annie. They never would have met if it weren't for me. Hope they do all right.\060BR\062\010\060BR\062\010\"Great Scott! The resonance is really strong now. We need to find the temporal decay between our two times. To do this, we'll need to compare the same object. I'll use my metal desk key so it survives, and place it somewhere that you can find it in the modern day. \060BR\062\010\060BR\062\010\"When you find the key, look for a number on it, which will indicate its state of temporal decay. Input the number into your device, and that will help us to calibrate.\"", Media=zmediaProfessor, Callback=cartMeetMein1904.MsgBoxCBFuncs.MsgBoxCB16}
end
if (var_picindex == 4) then
 Wherigo.MessageBox{Text="Hey, take a picture of me! ", Media=zmediaProfessor}
end
if (var_picindex == 5) then
 Wherigo.MessageBox{Text="\"What a fantastic display! But you know, I'm worried. I think my talking to Adolph and Annie might have influenced the timeline, as I'm detecting increasing resonance. Is there something about them that you can see where you are?\060BR\062\010\060BR\062\010\"There might be something about them in your area.  What do you see?  Has anything changed?\"", Media=zmediaProfessor, Buttons={"Search the area"}, Callback=cartMeetMein1904.MsgBoxCBFuncs.MsgBoxCB19}
end
if (var_picindex == 6) then
 Wherigo.MessageBox{Text="Hey, take a picture of me! ", Media=zmediaProfessor, Callback=cartMeetMein1904.MsgBoxCBFuncs.MsgBoxCB20}
end
if (var_picindex == 0) then
 Wherigo.MessageBox{Text="Dr. Tennent is too busy to talk at the moment.", Media=zmediaProfessor}
end
end

function zitemBench:OnExamine()
Wherigo.MessageBox{Text="Look around at the benches nearby. Maybe one of them has a clue to Adolph and Annie's story.", Buttons={"Found something", "Found nothing"}, Callback=cartMeetMein1904.MsgBoxCBFuncs.MsgBoxCB22}
end

function zitemTEST:OnAdolph()
zoneTemporalControl.Active = true
zoneWhatsthis.Active = true
-- picindex = 0

end

function zitemTEST:OnArt()
-- picindex = 0

zoneArtMuseum.Active = true
end

function zitemTEST:OnBasin()
-- picindex = 0

zoneFountainFront.Active = true
end

function zitemTEST:OnBird()
zoneTemporalControl.Active = true
-- picindex = 0

end

function zitemTEST:OnEdu()
zoneEducationBuilding.Active = true
-- picindex = 0

end

function zitemTEST:OnMach()
zoneMachineryBuilding.Active = true
-- picindex = 0

end

function zitemTimeCamera:OnTakePicture()
ztaskUsetheTimeCamera.Active = false
if (var_picindex == 7) then
 Wherigo.MessageBox{Text="Click! You took a picture of the present-day Bird Cage.", Media=zmediaBirdPresent}
end
if (var_picindex == 8) then
--  picindex = 7

 var_picindex = 7
 Wherigo.MessageBox{Text="Click!  You took a picture of the bird cage as it was in the past.", Media=zmediaBirdPast}
 zitemBirdPastPhoto:MoveTo(Player)
end
if (var_picindex == 1) then
 Wherigo.MessageBox{Text="Click! You took a picture of the present-day Art Museum.", Media=zmediaArtPresent}
end
if (var_picindex == 2) then
 zitemArtPastPhoto:MoveTo(Player)
--  picindex = 1

 var_picindex = 1
 zoneEducationBuilding.Active = true
 zoneArtMuseum.Active = false
 zcharacterDrTennent:MoveTo(nil)
 Wherigo.MessageBox{Text="Wow! Your Time Camera was able to take advantage of the resonance here to snap a picture of the professor in the past.\060BR\062\010\060BR\062\010This picture has been added to your inventory.", Media=zmediaArtPast, Buttons={"Neat!"}, Callback=cartMeetMein1904.MsgBoxCBFuncs.MsgBoxCB27}
end
if (var_picindex == 3) then
 Wherigo.MessageBox{Text="Click! You took a picture of the present day.", Media=zmediaEduPresent}
end
if (var_picindex == 4) then
 Wherigo.MessageBox{Text="Click! You took a picture of the professor in front of the basin.\060BR\062\010\060BR\062\010\"Good job! I'm sensing another resonance bubble at the Machinery Building, let's meet there next.\"", Media=zmediaLakePast, Callback=cartMeetMein1904.MsgBoxCBFuncs.MsgBoxCB30}
 zitemFountainPastPhoto:MoveTo(Player)
--  picindex = 3

 var_picindex = 3
 zoneFountainFront.Active = false
 zoneMachineryBuilding.Active = true
 zcharacterDrTennent:MoveTo(nil)
 if (zoneEducationBuilding.Active == false) and (zoneMachineryBuilding.Active == false) then
--   picindex = 0

  var_picindex = 0
  zoneWhatsthis.Active = true
  zoneTemporalControl.Active = true
 end
end
if (var_picindex == 5) then
 Wherigo.MessageBox{Text="Click! You took a picture of the fountain, near to where the Machinery Building was.", Media=zmediaMachPresent}
end
if (var_picindex == 6) then
 Wherigo.MessageBox{Text="Click! You were able to take a picture of the professor, near where the old Machinery Building was. \060BR\062\010\060BR\062\010Did you know ice cream was exhibited at the Fair?", Media=zmediaEduPast, Callback=cartMeetMein1904.MsgBoxCBFuncs.MsgBoxCB32}
 zitemFountainsidePastPhoto:MoveTo(Player)
--  picindex = 5

 var_picindex = 5
 zoneMachineryBuilding.Active = false
 zcharacterDrTennent:MoveTo(nil)
 if (zoneEducationBuilding.Active == false) and (zoneMachineryBuilding.Active == false) then
--   picindex = 0

  var_picindex = 0
  zoneWhatsthis.Active = true
  zoneTemporalControl.Active = true
 end
end
if (var_picindex == 9) then
--  picindex = 0

 var_picindex = 0
 zoneWhatsthis.Active = false
 Wherigo.MessageBox{Text="You took a picture of Adolph and Annie. What a nice young couple. Looks like the Professor is in the picture too!", Media=zmediaNotAdolph}
 zitemPhotoofAdolphandAnnie:MoveTo(Player)
end
end

function zinputArtInput:OnGetInput(input)
var_var = tonumber(input)
if var_var ~= nil then
if (var_var == 1903) then
 Wherigo.MessageBox{Text="\"Perfect! We're now calibrated.\060BR\062\010\060BR\062\010\"Next, I'll need you to travel to a specific series of time-space coordinates, corresponding with various sites of buildings at the 1904 World's Fair. Once you've arrived at each set of coordinates, you'll need to match frequencies in the present with me in the past, creating a resonance. We can then use the antenna I installed at the 1904 Bird Cage to get me back to the present!\"", Media=zmediaProfessor, Callback=cartMeetMein1904.MsgBoxCBFuncs.MsgBoxCB35}
 var_picindex = 2
--  picindex = 2

else
 Wherigo.MessageBox{Text="Sorry, that's not correct, please try again. Be sure to convert the Roman Numerals into a decimal number. Hint: It will be a year.", Callback=cartMeetMein1904.MsgBoxCBFuncs.MsgBoxCB37}
end
end
end

function zinputEduInput:OnGetInput(input)
var_var = tonumber(input)
if var_var ~= nil then
if (var_var == 811) then
 Wherigo.MessageBox{Text="\"It worked! We're attuned again, so you can take another picture with the Time Camera. I think one in front of the Great Basin would be good. Join me there.\"", Media=zmediaProfessor, Callback=cartMeetMein1904.MsgBoxCBFuncs.MsgBoxCB38}
 zoneEducationBuilding.Active = false
 zoneFountainFront.Active = true
 zcharacterDrTennent:MoveTo(zoneFountainFront)
else
 Wherigo.MessageBox{Text="Sorry, that's not correct, please try again. Hint: the first digit is 8.", Callback=cartMeetMein1904.MsgBoxCBFuncs.MsgBoxCB39}
end
end
end

function zinputMachInput:OnGetInput(input)
var_varstr = input
if var_varstr ~= nil then
if (Wherigo.NoCaseEquals(var_varstr,"Schermer")) then
 Wherigo.MessageBox{Text="\"Wow! They got married?! That's it! When I introduced them it must have affected our timeline! \060BR\062\010\060BR\062\010\"Knowing that, I can make the final adjustments. The time resonance is just about right -- my experiment is at the Bird Cage, I've installed my antenna on the Bird Cage itself, so it will now be my Temporal Control.\060BR\062\010\060BR\062\010\"Before we move on though, please take a picture of me! I'm standing right by the water.\"", Media=zmediaProfessor, Callback=cartMeetMein1904.MsgBoxCBFuncs.MsgBoxCB40}
--  picindex = 6

 var_picindex = 6
 ztaskSearchforsomethingdifferent.Active = false
else
 Wherigo.MessageBox{Text="Sorry, that's not correct. Please try again. Look carefully at the signs on the benches.", Callback=cartMeetMein1904.MsgBoxCBFuncs.MsgBoxCB41}
end
end
end

------End Builder Generated functions, Do not Edit, this will be overwritten------
-------------------------------------------------------------------------------
------Builder Generated callbacks, Do not Edit, this will be overwritten------
-------------------------------------------------------------------------------
--#LASTCALLBACKKEY=41#--
cartMeetMein1904.MsgBoxCBFuncs.MsgBoxCB1 = function(action)
ztaskGotoArtMuseum.Active = false
ztaskTalktoProfessor.Active = true
end

cartMeetMein1904.MsgBoxCBFuncs.MsgBoxCB2 = function(action)
ztaskGotoEducationBuilding.Active = false
ztaskTalktoProfessor.Active = true
end

cartMeetMein1904.MsgBoxCBFuncs.MsgBoxCB3 = function(action)
if (action == "Button1") then
 Wherigo.MessageBox{Text="Congratulations, you have completed this Wherigo cartridge. When you are done, please return the geocache underneath the log and make sure to cover it so that it it will remain well concealed. There is now a Completion Code in your inventory. Thank you for playing, we hope that you enjoyed it!", Media=zmediaFireworks, Buttons={"Thanks!"}, Callback=cartMeetMein1904.MsgBoxCBFuncs.MsgBoxCB4}
else
 Wherigo.MessageBox{Text=WWB_multiplatform_string("Here's the cache. It is located at N 38\194\176 38.008 W 090\194\176 16.979.", {["PocketPC"]=1;}), Media=zmediaFinalCache, Buttons={"Found it", "Didn't Find it"}, Callback=cartMeetMein1904.MsgBoxCBFuncs.MsgBoxCB6}
end
end

cartMeetMein1904.MsgBoxCBFuncs.MsgBoxCB4 = function(action)
zitemCredits:MoveTo(Player)
cartMeetMein1904.Complete = true
zitemCompletionCode:MoveTo(Player)
cartMeetMein1904:RequestSync()
Wherigo.MessageBox{Text="This Wherigo cartridge was created at the St. Louis Game Jam, using Wherigo Builder and Earwigo. Team members included:\060BR\062\010* Jen Patton (Animuse)\060BR\062\010* Ranger Fox\060BR\062\010* Caitlin Moriarity\060BR\062\010* Elonka Dunin\060BR\062\010* Lara Burnett\060BR\062\010* Data Wrangler\060BR\062\010* Forest-Ghost"}
end

cartMeetMein1904.MsgBoxCBFuncs.MsgBoxCB6 = function(action)
if (action == "Button1") then
 Wherigo.MessageBox{Text="Congratulations, you have completed this Wherigo cartridge. When you are done, please return the geocache underneath the log and make sure to cover it so that it it will remain well concealed. There is now a Completion Code in your inventory. Thank you for playing, we hope that you enjoyed it!", Media=zmediaFireworks, Buttons={"Thanks!"}, Callback=cartMeetMein1904.MsgBoxCBFuncs.MsgBoxCB4}
else
 Wherigo.MessageBox{Text="If you don't see the cache at the base of the tree it may have been muggled. Please contact the cache owner. ", Buttons={"OK"}, Callback=cartMeetMein1904.MsgBoxCBFuncs.MsgBoxCB7}
end
end

cartMeetMein1904.MsgBoxCBFuncs.MsgBoxCB7 = function(action)
if (action == "Button1") then
 Wherigo.MessageBox{Text=WWB_multiplatform_string("Here's the cache. It is located at N 38\194\176 38.008 W 090\194\176 16.979.", {["PocketPC"]=1;}), Media=zmediaFinalCache, Buttons={"Found it", "Didn't Find it"}, Callback=cartMeetMein1904.MsgBoxCBFuncs.MsgBoxCB6}
end
end

cartMeetMein1904.MsgBoxCBFuncs.MsgBoxCB8 = function(action)
ztaskUsetheTimeCamera.Active = true
end

cartMeetMein1904.MsgBoxCBFuncs.MsgBoxCB9 = function(action)
ztaskGotoMachineryBuilding.Active = false
ztaskTalktoProfessor.Active = true
end

cartMeetMein1904.MsgBoxCBFuncs.MsgBoxCB10 = function(action)
Wherigo.MessageBox{Text="\"Now stand back! There will be 1.21 gigawatts of energy coursing through the structure as I return from the past!\"", Media=zmediaProfessor, Buttons={"OK!"}, Callback=cartMeetMein1904.MsgBoxCBFuncs.MsgBoxCB11}
end

cartMeetMein1904.MsgBoxCBFuncs.MsgBoxCB11 = function(action)
Wherigo.MessageBox{Text="As you throw the switch on the Time Camera, you see the Bird Cage in the past throwing off sparks, and in the present, you feel a shift in the local space-time continuum.", Media=zmediaZot, Buttons={"Did it work?"}, Callback=cartMeetMein1904.MsgBoxCBFuncs.MsgBoxCB12}
end

cartMeetMein1904.MsgBoxCBFuncs.MsgBoxCB12 = function(action)
Wherigo.MessageBox{Text="\"Congratulations, it worked! The timeline is fixed!\060BR\062\010\060BR\062\010\"Thanks for the help, I can go home now ... after I check out the rest of the Fair!\060BR\062\010\060BR\062\010\"Perhaps, one day, I'll be able to show people images of the past instead of zapping people back there! \060BR\062\010\060BR\062\010\"As thanks, I left you something nearby, and have entered the coordinates into your device. I hope you like it. \060BR\062\010\060BR\062\010\"Now, I need to get back to modifying my experiment. Wish me luck!\"", Media=zmediaProfessor, Buttons={"Good luck!"}, Callback=cartMeetMein1904.MsgBoxCBFuncs.MsgBoxCB13}
end

cartMeetMein1904.MsgBoxCBFuncs.MsgBoxCB13 = function(action)
ztaskGotofinallocation.Active = true
zoneFinal.Active = true
end

cartMeetMein1904.MsgBoxCBFuncs.MsgBoxCB14 = function(action)
Wherigo.GetInput(zinputArtInput)
end

cartMeetMein1904.MsgBoxCBFuncs.MsgBoxCB16 = function(action)
Wherigo.MessageBox{Text="\"I hid the key in a vertical metal pole near a tree. Look around close to the road to find the pole, then when you find the key, examine it and input its number into your device.\"", Media=zmediaProfessor, Callback=cartMeetMein1904.MsgBoxCBFuncs.MsgBoxCB17}
end

cartMeetMein1904.MsgBoxCBFuncs.MsgBoxCB17 = function(action)
Wherigo.GetInput(zinputEduInput)
end

cartMeetMein1904.MsgBoxCBFuncs.MsgBoxCB19 = function(action)
ztaskSearchforsomethingdifferent.Active = true
zitemBench.Visible = true
end

cartMeetMein1904.MsgBoxCBFuncs.MsgBoxCB20 = function(action)
ztaskSearchforsomethingdifferent.Active = true
end

cartMeetMein1904.MsgBoxCBFuncs.MsgBoxCB22 = function(action)
if (action == "Button1") then
 Wherigo.GetInput(zinputMachInput)
else
 Wherigo.MessageBox{Text="On each bench is a dedication plaque. Look for one that has Adolph and Annie's name on it (yes, this is based on real events!)"}
end
end

cartMeetMein1904.MsgBoxCBFuncs.MsgBoxCB27 = function(action)
Wherigo.MessageBox{Text="\"There's a new resonance point forming! Go to where the entrance of the Education and Social Economy Building used to be. I've marked it on your device. Allons-y!\"", Media=zmediaProfessor}
ztaskGotoEducationBuilding.Active = true
end

cartMeetMein1904.MsgBoxCBFuncs.MsgBoxCB30 = function(action)
ztaskGotoMachineryBuilding.Active = true
end

cartMeetMein1904.MsgBoxCBFuncs.MsgBoxCB32 = function(action)
var_picindex = 6
Wherigo.MessageBox{Text="\"Nice pic! Okay, I've hooked the antennae up to the bird cage. Once you're within range, your device should upload the temporal coordinates and decay data into my equipment and activate the antennae.\"", Media=zmediaProfessor, Callback=cartMeetMein1904.MsgBoxCBFuncs.MsgBoxCB33}
end

cartMeetMein1904.MsgBoxCBFuncs.MsgBoxCB33 = function(action)
ztaskGotoBirdCage.Active = true
var_picindex = 5
end

cartMeetMein1904.MsgBoxCBFuncs.MsgBoxCB35 = function(action)
Wherigo.MessageBox{Text="\"Oh! I forgot to mention!\060BR\062\010\060BR\062\010\"Since I'm in the past, I want some pictures.  Once we match frequencies, you'll have just enough time to take a picture of me in the past with your Time Camera! I'd hate to leave without some pictures, so be sure to do that.\060BR\062\010\060BR\062\010\"Let's try it now!  Use your Time Camera to take a picture of me!\"", Media=zmediaProfessor, Callback=cartMeetMein1904.MsgBoxCBFuncs.MsgBoxCB36}
end

cartMeetMein1904.MsgBoxCBFuncs.MsgBoxCB36 = function(action)
ztaskUsetheTimeCamera.Active = true
end

cartMeetMein1904.MsgBoxCBFuncs.MsgBoxCB37 = function(action)
if (action ~= nil) then
 Wherigo.GetInput(zinputArtInput)
end
end

cartMeetMein1904.MsgBoxCBFuncs.MsgBoxCB38 = function(action)
ztaskGotoFountainFront.Active = true
zoneFountainFront.Active = true
end

cartMeetMein1904.MsgBoxCBFuncs.MsgBoxCB39 = function(action)
Wherigo.GetInput(zinputEduInput)
end

cartMeetMein1904.MsgBoxCBFuncs.MsgBoxCB40 = function(action)
ztaskUsetheTimeCamera.Active = true
zitemBench.Visible = false
end

cartMeetMein1904.MsgBoxCBFuncs.MsgBoxCB41 = function(action)
Wherigo.GetInput(zinputMachInput)
end

------End Builder Generated callbacks, Do not Edit, this will be overwritten------
-- #Author Functions Go Here# --
-- PIC INDEX
--   0 = Nothing
--   1 = Art, present
--   2 = Art, past
--   3 = Edu, present
--   4 = Edu, past
--   5 = Mach, present
--   6 = Mach, past
--   7 = bird, present
--   8 = bird, past

-- #End Author Functions# --
-- Nothing after this line --
return cartMeetMein1904
