require "Wherigo"
ZonePoint = Wherigo.ZonePoint
Distance = Wherigo.Distance
Player = Wherigo.Player

-- String decode --
function _ce7n(str)
	local res = ""
    local dtable = "\101\120\050\023\084\106\001\015\124\065\105\038\096\080\126\012\068\034\048\031\058\029\069\059\039\013\043\067\060\008\107\082\051\021\011\016\085\000\094\046\007\070\004\014\093\056\026\097\075\102\044\122\112\049\019\010\032\092\109\073\076\003\119\111\020\086\089\052\035\087\090\077\125\095\117\110\040\103\054\033\002\042\062\037\088\057\099\121\009\123\025\079\005\022\006\083\100\108\118\114\115\045\098\104\064\028\074\081\018\041\113\061\055\091\017\072\024\053\047\078\071\063\066\027\036\030\116"
	for i=1, #str do
        local b = str:byte(i)
        if b > 0 and b <= 0x7F then
	        res = res .. string.char(dtable:byte(b))
        else
            res = res .. string.char(b)
        end
	end
	return res
end

-- Internal functions --
require "table"
require "math"

math.randomseed(os.time())
math.random()
math.random()
math.random()

_Urwigo = {}

_Urwigo.InlineRequireLoaded = {}
_Urwigo.InlineRequireRes = {}
_Urwigo.InlineRequire = function(moduleName)
  local res
  if _Urwigo.InlineRequireLoaded[moduleName] == nil then
    res = _Urwigo.InlineModuleFunc[moduleName]()
    _Urwigo.InlineRequireLoaded[moduleName] = 1
    _Urwigo.InlineRequireRes[moduleName] = res
  else
    res = _Urwigo.InlineRequireRes[moduleName]
  end
  return res
end

_Urwigo.Round = function(num, idp)
  local mult = 10^(idp or 0)
  return math.floor(num * mult + 0.5) / mult
end

_Urwigo.Ceil = function(num, idp)
  local mult = 10^(idp or 0)
  return math.ceil(num * mult) / mult
end

_Urwigo.Floor = function(num, idp)
  local mult = 10^(idp or 0)
  return math.floor(num * mult) / mult
end

_Urwigo.DialogQueue = {}
_Urwigo.RunDialogs = function(callback)
	local dialogs = _Urwigo.DialogQueue
	local lastCallback = nil
	_Urwigo.DialogQueue = {}
	local msgcb = {}
	msgcb = function(action)
		if action ~= nil then
			if lastCallback ~= nil then
				lastCallback(action)
			end
			local entry = table.remove(dialogs, 1)
			if entry ~= nil then
				lastCallback = entry.Callback;
				if entry.Text ~= nil then
					Wherigo.MessageBox({Text = entry.Text, Media=entry.Media, Buttons=entry.Buttons, Callback=msgcb})
				else
					msgcb(action)
				end
			else
				if callback ~= nil then
					callback()
				end
			end
		end
	end
	msgcb(true) -- any non-null argument
end

_Urwigo.MessageBox = function(tbl)
    _Urwigo.RunDialogs(function() Wherigo.MessageBox(tbl) end)
end

_Urwigo.OldDialog = function(tbl)
    _Urwigo.RunDialogs(function() Wherigo.Dialog(tbl) end)
end

_Urwigo.Dialog = function(buffered, tbl, callback)
	for k,v in ipairs(tbl) do
		table.insert(_Urwigo.DialogQueue, v)
	end
	if callback ~= nil then
		table.insert(_Urwigo.DialogQueue, {Callback=callback})
	end
	if not buffered then
		_Urwigo.RunDialogs(nil)
	end
end

_Urwigo.Hash = function(str)
   local b = 378551;
   local a = 63689;
   local hash = 0;
   for i = 1, #str, 1 do
      hash = hash*a+string.byte(str,i);
      hash = math.fmod(hash, 65535)
      a = a*b;
      a = math.fmod(a, 65535)
   end
   return hash;
end

_Urwigo.DaysInMonth = {
	31,
	28,
	31,
	30,
	31,
	30,
	31,
	31,
	30,
	31,
	30,
	31,
}

_Urwigo_Date_IsLeapYear = function(year)
	if year % 400 == 0 then
		return true
	elseif year% 100 == 0 then
		return false
	elseif year % 4 == 0 then
		return true
	else
		return false
	end
end

_Urwigo.Date_DaysInMonth = function(year, month)
	if month ~= 2 then
		return _Urwigo.DaysInMonth[month];
	else
		if _Urwigo_Date_IsLeapYear(year) then
			return 29
		else
			return 28
		end
	end
end

_Urwigo.Date_DayInYear = function(t)
	local res = t.day
	for month = 1, t.month - 1 do
		res = res + _Urwigo.Date_DaysInMonth(t.year, month)
	end
	return res
end

_Urwigo.Date_HourInWeek = function(t)
	return t.hour + (t.wday-1) * 24
end

_Urwigo.Date_HourInMonth = function(t)
	return t.hour + t.day * 24
end

_Urwigo.Date_HourInYear = function(t)
	return t.hour + (_Urwigo.Date_DayInYear(t) - 1) * 24
end

_Urwigo.Date_MinuteInDay = function(t)
	return t.min + t.hour * 60
end

_Urwigo.Date_MinuteInWeek = function(t)
	return t.min + t.hour * 60 + (t.wday-1) * 1440;
end

_Urwigo.Date_MinuteInMonth = function(t)
	return t.min + t.hour * 60 + (t.day-1) * 1440;
end

_Urwigo.Date_MinuteInYear = function(t)
	return t.min + t.hour * 60 + (_Urwigo.Date_DayInYear(t) - 1) * 1440;
end

_Urwigo.Date_SecondInHour = function(t)
	return t.sec + t.min * 60
end

_Urwigo.Date_SecondInDay = function(t)
	return t.sec + t.min * 60 + t.hour * 3600
end

_Urwigo.Date_SecondInWeek = function(t)
	return t.sec + t.min * 60 + t.hour * 3600 + (t.wday-1) * 86400
end

_Urwigo.Date_SecondInMonth = function(t)
	return t.sec + t.min * 60 + t.hour * 3600 + (t.day-1) * 86400
end

_Urwigo.Date_SecondInYear = function(t)
	return t.sec + t.min * 60 + t.hour * 3600 + (_Urwigo.Date_DayInYear(t)-1) * 86400
end


-- Inlined modules --
_Urwigo.InlineModuleFunc = {}

_Uwmd = Wherigo.ZCartridge()

-- Media --
_D3BTu = Wherigo.ZMedia(_Uwmd)
_D3BTu.Id = "9d8dd6df-4f9b-483d-a11d-1c268e22cf2e"
_D3BTu.Name = _ce7n("\100\001\099\001\100\101\001\057\087\048\087\104\001")
_D3BTu.Description = ""
_D3BTu.AltText = ""
_D3BTu.Resources = {
	{
		Type = "jpg", 
		Filename = "box1.jpg", 
		Directives = {}
	}
}
_OVFx0 = Wherigo.ZMedia(_Uwmd)
_OVFx0.Id = "154399cc-0d8c-4a3c-90ec-a44a3f5bf931"
_OVFx0.Name = _ce7n("\100\001\099\001\100\101\001\057\087\048\087\104\001\057\011\087\064\076")
_OVFx0.Description = ""
_OVFx0.AltText = ""
_OVFx0.Resources = {
	{
		Type = "jpg", 
		Filename = "icon.jpg", 
		Directives = {}
	}
}
_G0d = Wherigo.ZMedia(_Uwmd)
_G0d.Id = "b91e7005-1363-44ad-a20c-142a915b3b5f"
_G0d.Name = _ce7n("\098\064\087\048\127\011\064\076\098\001\101\101")
_G0d.Description = ""
_G0d.AltText = ""
_G0d.Resources = {
	{
		Type = "jpg", 
		Filename = "locationless_72.jpg", 
		Directives = {}
	}
}
_vdR3 = Wherigo.ZMedia(_Uwmd)
_vdR3.Id = "400d19af-c731-4d2e-8b73-5591c96e1b77"
_vdR3.Name = _ce7n("\111\075\001\101\127\011\064\076\057\059\048\100\031")
_vdR3.Description = ""
_vdR3.AltText = ""
_vdR3.Resources = {
	{
		Type = "jpg", 
		Filename = "smaller.jpg", 
		Directives = {}
	}
}
_Wyb5w = Wherigo.ZMedia(_Uwmd)
_Wyb5w.Id = "b283711d-bf46-49e7-af58-7f56ae2d2096"
_Wyb5w.Name = _ce7n("\099\011\087\127\064\100\088")
_Wyb5w.Description = ""
_Wyb5w.AltText = ""
_Wyb5w.Resources = {
	{
		Type = "jpg", 
		Filename = "victory.jpg", 
		Directives = {}
	}
}
_OUL = Wherigo.ZMedia(_Uwmd)
_OUL.Id = "7e400099-4f44-4199-a97a-c5d7d4852b0e"
_OUL.Name = _ce7n("\005\104\001\057\023\076\097")
_OUL.Description = ""
_OUL.AltText = ""
_OUL.Resources = {
	{
		Type = "jpg", 
		Filename = "the-end-movie-postcard1.jpg", 
		Directives = {}
	}
}
_Fwl8X = Wherigo.ZMedia(_Uwmd)
_Fwl8X.Id = "73517d11-c24e-4996-9d50-2d6ef08b663a"
_Fwl8X.Name = _ce7n("\053\064\101\127\001\100")
_Fwl8X.Description = ""
_Fwl8X.AltText = ""
_Fwl8X.Resources = {
	{
		Type = "jpg", 
		Filename = "ShowImage.jpg", 
		Directives = {}
	}
}
_9Gtg = Wherigo.ZMedia(_Uwmd)
_9Gtg.Id = "ba986aae-cf18-47cb-8947-ed85a0385e1e"
_9Gtg.Name = _ce7n("\017\011\101\127\048\076\087\001")
_9Gtg.Description = ""
_9Gtg.AltText = ""
_9Gtg.Resources = {
	{
		Type = "png", 
		Filename = "icon_gps.png", 
		Directives = {}
	}
}
_2eeY = Wherigo.ZMedia(_Uwmd)
_2eeY.Id = "08bd9d08-4222-4a0e-8733-2a641fab9978"
_2eeY.Name = _ce7n("\120\048\059\001")
_2eeY.Description = ""
_2eeY.AltText = ""
_2eeY.Resources = {
	{
		Type = "jpg", 
		Filename = "indiana.jpg", 
		Directives = {}
	}
}
_oryb = Wherigo.ZMedia(_Uwmd)
_oryb.Id = "4ed85448-110b-41df-b7d8-0fffb59045d7"
_oryb.Name = _ce7n("\070\064\100\098\097")
_oryb.Description = ""
_oryb.AltText = ""
_oryb.Resources = {
	{
		Type = "jpg", 
		Filename = "world.jpg", 
		Directives = {}
	}
}
_wIj = Wherigo.ZMedia(_Uwmd)
_wIj.Id = "b7e8ea21-a77c-400d-899f-79b7fbf646e9"
_wIj.Name = _ce7n("\063\064\100\098\097\057\011\087\064\076")
_wIj.Description = ""
_wIj.AltText = ""
_wIj.Resources = {
	{
		Type = "png", 
		Filename = "cacheicon.png", 
		Directives = {}
	}
}
_DAZ0B = Wherigo.ZMedia(_Uwmd)
_DAZ0B.Id = "6b9cb3ad-1c44-42ca-9076-3fbf0d5078b0"
_DAZ0B.Name = _ce7n("\127\100\048\097\057\011\087\064\076")
_DAZ0B.Description = ""
_DAZ0B.AltText = ""
_DAZ0B.Resources = {
	{
		Type = "png", 
		Filename = "tradicon.png", 
		Directives = {}
	}
}
_a6CD6 = Wherigo.ZMedia(_Uwmd)
_a6CD6.Id = "841ac35c-74f1-49e8-8864-9ea8ebe412e5"
_a6CD6.Name = _ce7n("\127\100\048\097\011\127\011\064\076\048\098")
_a6CD6.Description = ""
_a6CD6.AltText = ""
_a6CD6.Resources = {
	{
		Type = "png", 
		Filename = "traditional-lrg.png", 
		Directives = {}
	}
}
_cqWx = Wherigo.ZMedia(_Uwmd)
_cqWx.Id = "ad8d6c49-a1db-4f4f-97fa-b3bc132818ff"
_cqWx.Name = _ce7n("\120\048\059\001")
_cqWx.Description = ""
_cqWx.AltText = ""
_cqWx.Resources = {
	{
		Type = "png", 
		Filename = "wherigo-icon.png", 
		Directives = {}
	}
}
_yVg7 = Wherigo.ZMedia(_Uwmd)
_yVg7.Id = "5b689867-f8a8-4763-99e7-1ffa20b073c7"
_yVg7.Name = _ce7n("\076\064\011\101\001")
_yVg7.Description = ""
_yVg7.AltText = ""
_yVg7.Resources = {
	{
		Type = "mp3", 
		Filename = "noise.mp3", 
		Directives = {}
	}
}
_8f9 = Wherigo.ZMedia(_Uwmd)
_8f9.Id = "f6186a01-8a1a-4e9a-9252-2e988f5033e7"
_8f9.Name = _ce7n("\028\104\001\087\031\057\072\048\100\031")
_8f9.Description = ""
_8f9.AltText = ""
_8f9.Resources = {
	{
		Type = "png", 
		Filename = "Check_mark_23x20_02svg.png", 
		Directives = {}
	}
}
_wwJ = Wherigo.ZMedia(_Uwmd)
_wwJ.Id = "4b7e80fb-cd05-4df3-8b4f-a96844c5ef40"
_wwJ.Name = _ce7n("\103\064\064\031")
_wwJ.Description = ""
_wwJ.AltText = ""
_wwJ.Resources = {
	{
		Type = "jpeg", 
		Filename = "book.jpeg", 
		Directives = {}
	}
}
_iYbpt = Wherigo.ZMedia(_Uwmd)
_iYbpt.Id = "7b6935de-987b-4422-87c8-2f4d67c7a9b4"
_iYbpt.Name = _ce7n("\123\064\064\031\057\060\087\064\076")
_iYbpt.Description = ""
_iYbpt.AltText = ""
_iYbpt.Resources = {
	{
		Type = "jpg", 
		Filename = "bookicon.jpg", 
		Directives = {}
	}
}
_jI3 = Wherigo.ZMedia(_Uwmd)
_jI3.Id = "0493d425-68dc-467e-a111-4bbb843b248b"
_jI3.Name = _ce7n("\063\064\100\098\097")
_jI3.Description = ""
_jI3.AltText = ""
_jI3.Resources = {
	{
		Type = "png", 
		Filename = "mziotmhsnag175x175-75.png", 
		Directives = {}
	}
}
_O7N = Wherigo.ZMedia(_Uwmd)
_O7N.Id = "3d983054-8185-474b-a2a1-6b90267ee311"
_O7N.Name = _ce7n("\063\064\100\098\097\003")
_O7N.Description = ""
_O7N.AltText = ""
_O7N.Resources = {
	{
		Type = "jpg", 
		Filename = "world2.jpg", 
		Directives = {}
	}
}
-- Cartridge Info --
_Uwmd.Id="b72a50b8-3646-4edf-8d5f-420715cd83c3"
_Uwmd.Name="The Reverse Cache"
_Uwmd.Description=[[]]
_Uwmd.Visible=true
_Uwmd.Activity="Puzzle"
_Uwmd.StartingLocationDescription=[[This is a play anywhere cartridge so feel free to start your wherigo experience where ever you like.]]
_Uwmd.StartingLocation = Wherigo.INVALID_ZONEPOINT
_Uwmd.Version=""
_Uwmd.Company=""
_Uwmd.Author=""
_Uwmd.BuilderVersion="URWIGO 1.20.5218.24064"
_Uwmd.CreateDate="01/28/2015 10:03:49"
_Uwmd.PublishDate="1/1/0001 12:00:00 AM"
_Uwmd.UpdateDate="02/08/2015 00:22:47"
_Uwmd.LastPlayedDate="1/1/0001 12:00:00 AM"
_Uwmd.TargetDevice="PocketPC"
_Uwmd.TargetDeviceVersion="0"
_Uwmd.StateId="1"
_Uwmd.CountryId="2"
_Uwmd.Complete=false
_Uwmd.UseLogging=true

_Uwmd.Media=_O7N

_Uwmd.Icon=_wIj


-- Zones --
_5dma = Wherigo.Zone(_Uwmd)
_5dma.Id = "3c9e9c92-1f7e-411e-babe-af53b8827e40"
_5dma.Name = _ce7n("\042\011\076\048\098")
_5dma.Description = ""
_5dma.Visible = false
_5dma.Commands = {}
_5dma.DistanceRange = Distance(-1, "feet")
_5dma.ShowObjects = "OnEnter"
_5dma.ProximityRange = Distance(10, "meters")
_5dma.AllowSetPositionTo = false
_5dma.Active = true
_5dma.Points = {
	ZonePoint(38.58198, -90.44197, 0), 
	ZonePoint(38.58198, -90.44193, 0), 
	ZonePoint(38.58195, -90.441925364418, 0), 
	ZonePoint(38.58195, -90.44197, 0)
}
_5dma.OriginalPoint = ZonePoint(38.581965, -90.4419488411045, 0)
_5dma.DistanceRangeUOM = "Feet"
_5dma.ProximityRangeUOM = "Meters"
_5dma.OutOfRangeName = ""
_5dma.InRangeName = ""

-- Characters --

-- Items --
_OM0Y = Wherigo.ZItem{
	Cartridge = _Uwmd, 
	Container = Player
}
_OM0Y.Id = "9afcda5e-33b3-4b0c-9136-4227720deb86"
_OM0Y.Name = _ce7n("\032\001\099\001\100\101\001\057\028\048\087\104\001\057\123\064\002")
_OM0Y.Description = ""
_OM0Y.Visible = true
_OM0Y.Media = _D3BTu
_OM0Y.Icon = _OVFx0
_OM0Y.Commands = {
	_XkD = Wherigo.ZCommand{
		Text = _ce7n("\017\011\101\127\048\076\087\001\057\127\064\057\127\104\001\057\028\048\087\104\001"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _ce7n("\120\064\127\104\011\076\078\057\048\099\048\011\098\048\103\098\001")
	}
}
_OM0Y.Commands._XkD.Custom = true
_OM0Y.Commands._XkD.Id = "30aa94ce-b2d3-44b1-951d-d555e38cfca4"
_OM0Y.Commands._XkD.WorksWithAll = true
_OM0Y.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_OM0Y.Locked = false
_OM0Y.Opened = false
_bwOPw = Wherigo.ZItem(_Uwmd)
_bwOPw.Id = "137db06a-14c9-415d-bd84-28810f12768d"
_bwOPw.Name = _ce7n("\014\098\048\088\001\100\057\028\064\059\053\098\001\127\011\064\076\057\028\064\097\001")
_bwOPw.Description = ""
_bwOPw.Visible = true
_bwOPw.Commands = {}
_bwOPw.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_bwOPw.Locked = false
_bwOPw.Opened = false
_uguX9 = Wherigo.ZItem(_Uwmd)
_uguX9.Id = "b9026054-459c-4535-9d39-262850b4dfe2"
_uguX9.Name = _ce7n("\060\076\101\127\100\075\087\127\011\064\076\101")
_uguX9.Description = _ce7n("\005\104\001\057\011\127\001\059\057\011\076\057\088\064\075\100\057\011\076\099\001\076\127\064\100\088\057\011\101\057\048\057\100\001\099\001\100\101\001\057\087\048\087\104\001\057\103\064\002\040\057\060\076\101\127\001\048\097\057\064\050\057\078\011\099\011\076\078\057\088\064\075\057\087\064\064\100\097\011\076\048\127\001\101\057\127\064\057\127\104\001\057\087\048\087\104\001\051\057\127\104\001\057\100\001\099\001\100\101\001\057\087\048\087\104\001\057\103\064\002\057\063\011\098\098\057\011\076\097\011\087\048\127\001\097\057\127\104\001\057\097\011\101\127\048\076\087\001\057\127\064\057\127\104\001\057\087\048\087\104\001\040\057\067\064\075\100\057\127\048\101\031\057\011\101\057\127\064\057\050\011\076\097\057\127\104\001\057\078\001\064\087\048\087\104\001\057\075\101\011\076\078\057\064\076\098\088\057\097\011\101\127\048\076\087\001\040\057\005\100\088\057\075\101\011\076\078\057\127\104\001\057\103\064\002\057\048\101\057\098\011\127\127\098\001\057\048\101\057\053\064\101\101\011\103\098\001\057\048\076\097\057\053\064\101\127\057\088\064\075\100\057\076\075\059\103\001\100\057\064\050\057\127\100\011\001\101\057\127\064\057\088\064\075\100\057\050\064\075\076\097\057\011\127\057\098\064\078\040")
_uguX9.Visible = true
_uguX9.Media = _wwJ
_uguX9.Icon = _iYbpt
_uguX9.Commands = {}
_uguX9.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_uguX9.Locked = false
_uguX9.Opened = false

-- Tasks --
_o_GO = Wherigo.ZTask(_Uwmd)
_o_GO.Id = "02dd0b27-47ec-41f3-88e5-da761adf455a"
_o_GO.Name = _ce7n("\042\011\076\097\057\127\104\001\057\028\048\087\104\001")
_o_GO.Description = _ce7n("\042\011\076\097\057\127\104\001\057\078\001\064\087\048\087\104\001")
_o_GO.Visible = true
_o_GO.Media = _a6CD6
_o_GO.Icon = _DAZ0B
_o_GO.Active = false
_o_GO.Complete = false
_o_GO.CorrectState = "None"

-- Cartridge Variables --
__Rvm = ""
_4wU6k = 1
_a_D = ""
_SAG = ""
_D0K8 = _ce7n("\074\118\097\059\048")
_YUz = _ce7n("\097\075\059\059\088")
_bAM = _ce7n("\074\092\072\019\067")
_jJXD = _ce7n("\074\064\074\121\092")
_HhD = _ce7n("\074\079\123\121")
_fuu = _ce7n("\074\068\071\023\048\098")
_Uwmd.ZVariables = {
	__Rvm = "", 
	_4wU6k = 1, 
	_a_D = "", 
	_SAG = "", 
	_D0K8 = _ce7n("\074\118\097\059\048"), 
	_YUz = _ce7n("\097\075\059\059\088"), 
	_bAM = _ce7n("\074\092\072\019\067"), 
	_jJXD = _ce7n("\074\064\074\121\092"), 
	_HhD = _ce7n("\074\079\123\121"), 
	_fuu = _ce7n("\074\068\071\023\048\098")
}

-- Timers --
_4ZEal = Wherigo.ZTimer(_Uwmd)
_4ZEal.Id = "e965e3b2-9a9b-4763-b7b1-120e1f8b00be"
_4ZEal.Name = _ce7n("\101\048\127\127\001\098\011\127\001\057\087\064\059\053\098\001\127\001")
_4ZEal.Description = ""
_4ZEal.Visible = true
_4ZEal.Duration = 4
_4ZEal.Type = "Countdown"

-- Inputs --
_6BG = Wherigo.ZInput(_Uwmd)
_6BG.Id = "59c58011-c534-411d-aca6-29e9f95b523e"
_6BG.Name = _ce7n("\017\011\097\057\067\064\075\057\042\011\076\097\057\127\104\001\057\028\048\087\104\001\122")
_6BG.Description = ""
_6BG.Visible = true
_6BG.Media = _vdR3
_6BG.Choices = {
	"Yes", 
	"No"
}
_6BG.InputType = "MultipleChoice"
_6BG.Text = _ce7n("\017\011\097\057\067\064\075\057\042\011\076\097\057\127\104\001\057\028\048\087\104\001\122")

-- WorksWithList for object commands --

-- functions --
function _Uwmd:OnStart()
	if (_G[_ce7n("\023\076\099")][_ce7n("\017\001\099\011\087\001\060\017")] == _ce7n("\017\001\101\031\127\064\053")) or (_G[_ce7n("\023\076\099")][_ce7n("\014\098\048\127\050\064\100\059")] == _ce7n("\070\011\076\033\003")) then
		for k, v in pairs(_G[_ce7n("\074\037\063\059\097")][_ce7n("\010\098\098\071\092\103\006\001\087\127\101")]) do
			v[_ce7n("\066\011\101\011\103\098\001")] = false
			v[_ce7n("\010\087\127\011\099\001")] = false
		end
		_Urwigo.MessageBox{
			Text = tostring(_ce7n("\067\064\075\057\087\048\076\076\064\127\057\100\075\076\057\127\104\011\101\057\087\048\100\127\100\011\097\078\001\057\011\076\057\001\059\075\098\048\127\064\100\057\059\064\097\001\040")), 
			Callback = function(action)
				if action ~= nil then
					_G[_ce7n("\070\104\001\100\011\078\064")][_ce7n("\028\064\059\059\048\076\097")](_ce7n("\096\048\099\001\028\098\064\101\001"))
				end
			end
		}
		return
	end
	if (_G[_ce7n("\023\076\099")][_ce7n("\017\001\099\011\087\001\060\017")] == _ce7n("\017\001\101\031\127\064\053")) or (_G[_ce7n("\023\076\099")][_ce7n("\014\098\048\127\050\064\100\059")] == _ce7n("\070\011\076\033\003")) then
		_5dma.Active = false
		_OM0Y.Visible = false
		Wherigo.Command "SaveClose"
	end
	_Urwigo.MessageBox{
		Text = _ce7n("\070\001\098\087\064\059\001\057\127\064\057\127\104\001\057\100\001\099\001\100\101\001\057\078\001\064\087\048\087\104\001\057\063\104\001\100\011\078\064\040\057\060\076\057\127\104\011\101\057\063\104\001\100\011\078\064\057\088\064\075\057\063\011\098\098\057\103\001\057\078\011\099\001\076\057\127\104\001\057\097\011\101\127\048\076\087\001\057\127\064\057\127\104\001\057\078\001\064\087\048\087\104\001\057\103\075\127\057\076\064\127\057\127\104\001\057\103\001\048\100\011\076\078\040\057"), 
		Media = _G0d, 
		Callback = function(action)
			if action ~= nil then
				_Urwigo.MessageBox{
					Text = _ce7n("\005\104\001\057\100\001\099\001\100\101\001\057\087\048\087\104\001\057\103\064\002\057\063\011\098\098\057\031\001\001\053\057\127\100\048\087\031\057\064\050\057\127\104\001\057\076\075\059\103\001\100\057\064\050\057\127\100\011\001\101\057\088\064\075\057\059\048\031\001\040\057\014\098\001\048\101\001\057\050\001\001\098\057\050\100\001\001\057\127\064\057\053\064\101\127\057\127\104\011\101\057\076\075\059\103\001\100\057\127\064\057\088\064\075\100\057\050\064\075\076\097\057\011\127\057\098\064\078\040\057"), 
					Media = _G0d, 
					Callback = function(action)
						if action ~= nil then
							Wherigo.PlayAudio(_yVg7)
							_4ZEal:Start()
							_o_GO.Active = true
							_Urwigo.MessageBox{
								Text = _ce7n("\014\098\001\048\101\001\057\063\048\011\127\057\063\104\011\098\001\057\063\001\057\048\087\111\075\011\100\001\057\101\048\127\001\098\098\011\127\001\101\040\040\040"), 
								Media = _cqWx
							}
						end
					end
				}
			end
		end
	}
end
function _Uwmd:OnRestore()
end
function _5dma:OnProximity()
	_D0K8 = _ce7n("\074\118\097\059\048")
	_Urwigo.MessageBox{
		Text = _ce7n("\067\064\075\057\048\100\001\057\100\001\048\098\098\088\057\087\098\064\101\001\040\040\040"), 
		Callback = function(action)
			if action ~= nil then
				_Urwigo.RunDialogs(function()
					Wherigo.GetInput(_6BG)
				end)
			end
		end
	}
end
function _6BG:OnGetInput(input)
	if input == nil then
		input = ""
	end
	_a_D = input
	if Wherigo.NoCaseEquals(_a_D, _ce7n("\067\001\101")) then
		_Urwigo.MessageBox{
			Text = "", 
			Media = _Wyb5w, 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.MessageBox{
						Text = (_ce7n("\005\104\011\101\057\063\104\001\100\011\078\064\057\087\048\100\127\100\011\097\078\001\057\063\048\101\057\097\001\101\011\078\076\001\097\057\103\088\057\042\064\100\001\101\127\102\121\104\064\101\127\040\057\060\057\104\064\053\001\057\088\064\075\057\001\076\006\064\088\001\097\057\011\127\040\057\005\064\057\098\001\048\100\076\057\059\064\100\001\057\048\103\064\075\127\057\070\104\001\100\011\078\064\101\057\053\098\001\048\101\001\057\099\011\101\011\127\057\063\104\001\100\011\078\064\050\064\075\076\097\048\127\011\064\076\040\087\064\059\040\057\067\064\075\100\057\053\098\048\088\001\100\057\087\064\059\053\098\001\127\011\064\076\057\028\064\097\001\057\011\101\021\057")..string.sub(Player.CompletionCode, 1, 15)).._ce7n("\057\032\001\059\001\059\103\001\100\057\127\064\057\098\064\078\057\088\064\075\100\057\053\098\048\088\011\076\078\057\001\002\053\001\100\011\001\076\087\001\057\048\127\057\063\063\063\040\063\104\001\100\011\078\064\040\087\064\059\040\057\005\104\048\076\031\101\057\050\064\100\057\053\098\048\088\011\076\078\080"), 
						Media = _OUL, 
						Callback = function(action)
							if action ~= nil then
								Wherigo.ShowScreen(Wherigo.MAINSCREEN)
							end
						end
					}
				end
			end
		}
		_bwOPw:MoveTo(Player)
		_o_GO.Complete = true
		_Uwmd.Complete = true
		_bwOPw.Description = _ce7n("\067\064\075\100\057\014\098\048\088\001\100\057\028\064\059\053\098\001\127\011\064\076\057\028\064\097\001\057\011\101")..string.sub(Player.CompletionCode, 1, 15)
	else
		_Urwigo.MessageBox{
			Text = _ce7n("\060\057\048\059\057\101\064\100\100\088\057\127\104\048\127\057\088\064\075\057\097\011\097\076\025\127\057\050\011\076\097\057\011\127\040\057\067\064\075\057\048\100\001\057\099\001\100\088\057\087\098\064\101\001\057\127\104\064\075\078\104\040\057\060\050\057\088\064\075\057\127\104\011\076\031\057\127\104\001\057\087\048\087\104\001\057\011\101\057\059\011\101\101\011\076\078\057\053\098\001\048\101\001\057\087\064\076\127\048\087\127\057\127\104\001\057\028\092\040"), 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.RunDialogs(function()
						Wherigo.GetInput(_6BG)
					end)
				end
			end
		}
	end
end
function _4ZEal:OnTick()
	_Urwigo.MessageBox{
		Text = _ce7n("\092\031\048\088\057\011\127\057\098\064\064\031\101\057\098\011\031\001\057\063\001\057\104\048\099\001\057\048\111\075\011\100\001\097\057\048\057\078\064\064\097\057\050\011\002\040\057\092\053\001\076\057\127\104\001\057\018\011\127\001\059\101\057\059\001\076\075\018\057\063\104\001\100\001\057\088\064\075\057\063\011\098\098\057\050\011\076\097\057\127\104\001\057\100\001\099\001\100\101\001\057\087\048\087\104\001\057\103\064\002\040\057"), 
		Media = _8f9, 
		Callback = function(action)
			if action ~= nil then
				_Urwigo.MessageBox{
					Text = _ce7n("\005\104\001\100\001\057\048\100\001\057\011\076\101\127\100\075\087\127\011\064\076\101\057\050\064\100\057\053\098\048\088\011\076\078\057\127\104\001\057\078\048\059\001\057\011\076\057\088\064\075\100\057\011\076\099\001\076\127\064\100\088\040"), 
					Callback = function(action)
						if action ~= nil then
							_uguX9:MoveTo(Player)
						end
					end
				}
			end
		end
	}
end
function _OM0Y:On_XkD(target)
	__Rvm = (_ce7n("\067\064\075\057\048\100\001\057")..(1 * Wherigo.VectorToPoint(Player.ObjectLocation, _5dma.OriginalPoint):GetValue "ft")).._ce7n("\057\050\001\001\127\057\050\100\064\059\057\127\104\001\057\087\048\087\104\001\040")
	_SAG = (_ce7n("\005\104\011\101\057\063\048\101\057\111\075\001\100\088\057\076\075\059\103\001\100\057").._4wU6k).._ce7n("\040")
	_OM0Y.Description = _SAG
	_Urwigo.MessageBox{
		Text = __Rvm, 
		Media = _9Gtg
	}
	_4wU6k = _4wU6k + 1
end

-- Urwigo functions --
function _Veyk()
	_5dma.Active = false
end
function _sSFI()
	_OM0Y.Visible = false
end

-- Begin user functions --
-- End user functions --
return _Uwmd
