require "Wherigo"
ZonePoint = Wherigo.ZonePoint
Distance = Wherigo.Distance
Player = Wherigo.Player

-- String decode --
function _o_Y(str)
	local res = ""
    local dtable = "\078\010\066\003\094\089\027\011\064\024\023\004\030\043\060\032\100\015\048\082\118\058\111\126\102\038\116\005\012\008\065\092\115\099\052\073\112\034\001\106\080\117\105\124\085\083\006\028\035\054\075\088\036\109\044\033\071\114\079\021\101\096\122\103\022\074\000\017\091\040\019\025\039\013\002\029\007\097\050\125\113\067\045\110\068\051\104\020\119\123\077\057\076\014\046\072\061\120\049\084\042\098\108\053\031\087\055\063\107\056\062\095\018\041\070\059\086\026\037\069\047\090\081\093\016\009\121"
	for i=1, #str do
        local b = str:byte(i)
        if b > 0 and b <= 0x7F then
	        res = res .. string.char(dtable:byte(b))
        else
            res = res .. string.char(b)
        end
	end
	return res
end

-- Internal functions --
require "table"
require "math"

math.randomseed(os.time())
math.random()
math.random()
math.random()

_Urwigo = {}

_Urwigo.InlineRequireLoaded = {}
_Urwigo.InlineRequireRes = {}
_Urwigo.InlineRequire = function(moduleName)
  local res
  if _Urwigo.InlineRequireLoaded[moduleName] == nil then
    res = _Urwigo.InlineModuleFunc[moduleName]()
    _Urwigo.InlineRequireLoaded[moduleName] = 1
    _Urwigo.InlineRequireRes[moduleName] = res
  else
    res = _Urwigo.InlineRequireRes[moduleName]
  end
  return res
end

_Urwigo.Round = function(num, idp)
  local mult = 10^(idp or 0)
  return math.floor(num * mult + 0.5) / mult
end

_Urwigo.Ceil = function(num, idp)
  local mult = 10^(idp or 0)
  return math.ceil(num * mult) / mult
end

_Urwigo.Floor = function(num, idp)
  local mult = 10^(idp or 0)
  return math.floor(num * mult) / mult
end

_Urwigo.DialogQueue = {}
_Urwigo.RunDialogs = function(callback)
	local dialogs = _Urwigo.DialogQueue
	local lastCallback = nil
	_Urwigo.DialogQueue = {}
	local msgcb = {}
	msgcb = function(action)
		if action ~= nil then
			if lastCallback ~= nil then
				lastCallback(action)
			end
			local entry = table.remove(dialogs, 1)
			if entry ~= nil then
				lastCallback = entry.Callback;
				if entry.Text ~= nil then
					Wherigo.MessageBox({Text = entry.Text, Media=entry.Media, Buttons=entry.Buttons, Callback=msgcb})
				else
					msgcb(action)
				end
			else
				if callback ~= nil then
					callback()
				end
			end
		end
	end
	msgcb(true) -- any non-null argument
end

_Urwigo.MessageBox = function(tbl)
    _Urwigo.RunDialogs(function() Wherigo.MessageBox(tbl) end)
end

_Urwigo.OldDialog = function(tbl)
    _Urwigo.RunDialogs(function() Wherigo.Dialog(tbl) end)
end

_Urwigo.Dialog = function(buffered, tbl, callback)
	for k,v in ipairs(tbl) do
		table.insert(_Urwigo.DialogQueue, v)
	end
	if callback ~= nil then
		table.insert(_Urwigo.DialogQueue, {Callback=callback})
	end
	if not buffered then
		_Urwigo.RunDialogs(nil)
	end
end

_Urwigo.Hash = function(str)
   local b = 378551;
   local a = 63689;
   local hash = 0;
   for i = 1, #str, 1 do
      hash = hash*a+string.byte(str,i);
      hash = math.fmod(hash, 65535)
      a = a*b;
      a = math.fmod(a, 65535)
   end
   return hash;
end

_Urwigo.DaysInMonth = {
	31,
	28,
	31,
	30,
	31,
	30,
	31,
	31,
	30,
	31,
	30,
	31,
}

_Urwigo_Date_IsLeapYear = function(year)
	if year % 400 == 0 then
		return true
	elseif year% 100 == 0 then
		return false
	elseif year % 4 == 0 then
		return true
	else
		return false
	end
end

_Urwigo.Date_DaysInMonth = function(year, month)
	if month ~= 2 then
		return _Urwigo.DaysInMonth[month];
	else
		if _Urwigo_Date_IsLeapYear(year) then
			return 29
		else
			return 28
		end
	end
end

_Urwigo.Date_DayInYear = function(t)
	local res = t.day
	for month = 1, t.month - 1 do
		res = res + _Urwigo.Date_DaysInMonth(t.year, month)
	end
	return res
end

_Urwigo.Date_HourInWeek = function(t)
	return t.hour + (t.wday-1) * 24
end

_Urwigo.Date_HourInMonth = function(t)
	return t.hour + t.day * 24
end

_Urwigo.Date_HourInYear = function(t)
	return t.hour + (_Urwigo.Date_DayInYear(t) - 1) * 24
end

_Urwigo.Date_MinuteInDay = function(t)
	return t.min + t.hour * 60
end

_Urwigo.Date_MinuteInWeek = function(t)
	return t.min + t.hour * 60 + (t.wday-1) * 1440;
end

_Urwigo.Date_MinuteInMonth = function(t)
	return t.min + t.hour * 60 + (t.day-1) * 1440;
end

_Urwigo.Date_MinuteInYear = function(t)
	return t.min + t.hour * 60 + (_Urwigo.Date_DayInYear(t) - 1) * 1440;
end

_Urwigo.Date_SecondInHour = function(t)
	return t.sec + t.min * 60
end

_Urwigo.Date_SecondInDay = function(t)
	return t.sec + t.min * 60 + t.hour * 3600
end

_Urwigo.Date_SecondInWeek = function(t)
	return t.sec + t.min * 60 + t.hour * 3600 + (t.wday-1) * 86400
end

_Urwigo.Date_SecondInMonth = function(t)
	return t.sec + t.min * 60 + t.hour * 3600 + (t.day-1) * 86400
end

_Urwigo.Date_SecondInYear = function(t)
	return t.sec + t.min * 60 + t.hour * 3600 + (_Urwigo.Date_DayInYear(t)-1) * 86400
end


-- Inlined modules --
_Urwigo.InlineModuleFunc = {}

__Ci9 = Wherigo.ZCartridge()

-- Media --
_58Q = Wherigo.ZMedia(__Ci9)
_58Q.Id = "ec4234b4-3fee-488f-985b-26a25f0e0493"
_58Q.Name = _o_Y("\058\061\021\061\058\033\061\112\034\078\034\087\061")
_58Q.Description = ""
_58Q.AltText = ""
_58Q.Resources = {
	{
		Type = "jpg", 
		Filename = "reverse_cache.jpg", 
		Directives = {}
	}
}
_7Sm = Wherigo.ZMedia(__Ci9)
_7Sm.Id = "dcea7277-1c77-414c-88f4-24f2441765f0"
_7Sm.Name = _o_Y("\058\061\021\061\058\033\061\016\034\078\034\087\061\016\043\034\023\084")
_7Sm.Description = ""
_7Sm.AltText = ""
_7Sm.Resources = {
	{
		Type = "jpg", 
		Filename = "reverse_cache_icon.jpg", 
		Directives = {}
	}
}
_zjK22 = Wherigo.ZMedia(__Ci9)
_zjK22.Id = "3437fb6e-977e-44d9-a466-e2300d5f4d17"
_zjK22.Name = _o_Y("\103\023\034\078\027\043\023\084\103\061\033\033")
_zjK22.Description = ""
_zjK22.AltText = ""
_zjK22.Resources = {
	{
		Type = "jpg", 
		Filename = "locationless.jpg", 
		Directives = {}
	}
}
_KaeL1 = Wherigo.ZMedia(__Ci9)
_KaeL1.Id = "d7552644-f9ef-4a1b-b8d1-04d9cddff5c9"
_KaeL1.Name = _o_Y("\081\042\061\033\027\043\023\084\112\054\078\058\109")
_KaeL1.Description = ""
_KaeL1.AltText = ""
_KaeL1.Resources = {
	{
		Type = "jpg", 
		Filename = "smaller.jpg", 
		Directives = {}
	}
}
_IY8 = Wherigo.ZMedia(__Ci9)
_IY8.Id = "6079ea8f-7c4a-4101-b977-33587da18d17"
_IY8.Name = _o_Y("\021\043\034\027\023\058\127")
_IY8.Description = ""
_IY8.AltText = ""
_IY8.Resources = {
	{
		Type = "jpg", 
		Filename = "victory.jpg", 
		Directives = {}
	}
}
_HAc_ = Wherigo.ZMedia(__Ci9)
_HAc_.Id = "d7d56ab7-54de-4877-ad2a-ef09e17c478f"
_HAc_.Name = _o_Y("\100\087\061\112\120\084\017")
_HAc_.Description = ""
_HAc_.AltText = ""
_HAc_.Resources = {
	{
		Type = "jpg", 
		Filename = "The_End.jpg", 
		Directives = {}
	}
}
_eocRI = Wherigo.ZMedia(__Ci9)
_eocRI.Id = "0b17d5a9-cd72-49d0-9f85-d138fb3ad362"
_eocRI.Name = _o_Y("\037\023\033\027\061\058")
_eocRI.Description = ""
_eocRI.AltText = ""
_eocRI.Resources = {
	{
		Type = "jpg", 
		Filename = "ShowImage.jpg", 
		Directives = {}
	}
}
_3uI = Wherigo.ZMedia(__Ci9)
_3uI.Id = "b3e8615c-bdf7-4f1c-8e89-17c78d92730a"
_3uI.Name = _o_Y("\085\043\033\027\078\084\034\061")
_3uI.Description = ""
_3uI.AltText = ""
_3uI.Resources = {
	{
		Type = "jpg", 
		Filename = "icon_gps.jpg", 
		Directives = {}
	}
}
_9Rdoq = Wherigo.ZMedia(__Ci9)
_9Rdoq.Id = "ddcceea7-acf7-4656-8f31-c12ff2286411"
_9Rdoq.Name = _o_Y("\001\078\054\061")
_9Rdoq.Description = ""
_9Rdoq.AltText = ""
_9Rdoq.Resources = {
	{
		Type = "jpg", 
		Filename = "indiana.jpg", 
		Directives = {}
	}
}
_yjg4 = Wherigo.ZMedia(__Ci9)
_yjg4.Id = "944023e9-79e0-4b83-ab03-9fa8e951b178"
_yjg4.Name = _o_Y("\106\023\058\103\017")
_yjg4.Description = ""
_yjg4.AltText = ""
_yjg4.Resources = {
	{
		Type = "jpg", 
		Filename = "world.jpg", 
		Directives = {}
	}
}
_yHheG = Wherigo.ZMedia(__Ci9)
_yHheG.Id = "634d6374-aca9-4f34-ac9b-f1e4d97950f3"
_yHheG.Name = _o_Y("\089\087\061\058\043\064\023\112\043\034\023\084")
_yHheG.Description = ""
_yHheG.AltText = ""
_yHheG.Resources = {
	{
		Type = "jpg", 
		Filename = "wherigo_icon.jpg", 
		Directives = {}
	}
}
_afQ = Wherigo.ZMedia(__Ci9)
_afQ.Id = "518c70c5-6815-4923-b0b6-ffd90df3823d"
_afQ.Name = _o_Y("\027\058\078\017\043\027\043\023\084\078\103\112\043\034\023\084")
_afQ.Description = ""
_afQ.AltText = ""
_afQ.Resources = {
	{
		Type = "jpg", 
		Filename = "traditional_icon.jpg", 
		Directives = {}
	}
}
_Qn_u = Wherigo.ZMedia(__Ci9)
_Qn_u.Id = "6dc92b9a-b3e7-4ee8-916b-3507917c321d"
_Qn_u.Name = _o_Y("\027\058\078\017\043\027\043\023\084\078\103")
_Qn_u.Description = ""
_Qn_u.AltText = ""
_Qn_u.Resources = {
	{
		Type = "jpg", 
		Filename = "traditional.jpg", 
		Directives = {}
	}
}
_IjtCS = Wherigo.ZMedia(__Ci9)
_IjtCS.Id = "464ce712-6a68-4b73-92cc-7706415bd645"
_IjtCS.Name = _o_Y("\046\078\027\027\061\103\043\027\061")
_IjtCS.Description = ""
_IjtCS.AltText = ""
_IjtCS.Resources = {
	{
		Type = "jpg", 
		Filename = "sattelite.jpg", 
		Directives = {}
	}
}
_H53xE = Wherigo.ZMedia(__Ci9)
_H53xE.Id = "831b8471-cab2-46b3-b3ac-edd551c9d560"
_H53xE.Name = _o_Y("\084\023\043\033\061")
_H53xE.Description = ""
_H53xE.AltText = ""
_H53xE.Resources = {
	{
		Type = "mp3", 
		Filename = "noise.mp3", 
		Directives = {}
	}
}
_Qdir = Wherigo.ZMedia(__Ci9)
_Qdir.Id = "e627560e-c10e-4ec0-8143-3f0bdf92b708"
_Qdir.Name = _o_Y("\082\087\061\034\109\016\091\078\058\109")
_Qdir.Description = ""
_Qdir.AltText = ""
_Qdir.Resources = {
	{
		Type = "jpg", 
		Filename = "Check_Mark.jpg", 
		Directives = {}
	}
}
_gXRR6 = Wherigo.ZMedia(__Ci9)
_gXRR6.Id = "d5b325c0-9ab6-4a86-be52-252de6987497"
_gXRR6.Name = _o_Y("\102\023\023\109")
_gXRR6.Description = ""
_gXRR6.AltText = ""
_gXRR6.Resources = {
	{
		Type = "jpeg", 
		Filename = "book.jpeg", 
		Directives = {}
	}
}
_bk3o = Wherigo.ZMedia(__Ci9)
_bk3o.Id = "39a36e16-7f85-4897-935c-55496759f282"
_bk3o.Name = _o_Y("\003\023\023\109\112\043\034\023\084")
_bk3o.Description = ""
_bk3o.AltText = ""
_bk3o.Resources = {
	{
		Type = "jpg", 
		Filename = "book_icon.jpg", 
		Directives = {}
	}
}
_msEe5 = Wherigo.ZMedia(__Ci9)
_msEe5.Id = "cc168fb1-3d38-41f0-80d6-a67798c901fd"
_msEe5.Name = _o_Y("\089\023\058\103\017")
_msEe5.Description = ""
_msEe5.AltText = ""
_msEe5.Resources = {
	{
		Type = "jpg", 
		Filename = "world2.jpg", 
		Directives = {}
	}
}
__p1P = Wherigo.ZMedia(__Ci9)
__p1P.Id = "28e78fb4-61fe-4b37-adfe-f047ac4558c8"
__p1P.Name = _o_Y("\089\023\058\103\017\079")
__p1P.Description = ""
__p1P.AltText = ""
__p1P.Resources = {
	{
		Type = "jpg", 
		Filename = "world2_1.jpg", 
		Directives = {}
	}
}
-- Cartridge Info --
__Ci9.Id="a5e69057-fa66-4235-9eb2-877df41bdfa7"
__Ci9.Name="The Reverse Cache"
__Ci9.Description=[[]]
__Ci9.Visible=true
__Ci9.Activity="Puzzle"
__Ci9.StartingLocationDescription=[[This is a play anywhere cartridge so you can start the wherigo experience where ever you like.]]
__Ci9.StartingLocation = Wherigo.INVALID_ZONEPOINT
__Ci9.Version=""
__Ci9.Company=""
__Ci9.Author=""
__Ci9.BuilderVersion="URWIGO 1.21.5528.18461"
__Ci9.CreateDate="01/28/2015 10:03:49"
__Ci9.PublishDate="1/1/0001 12:00:00 AM"
__Ci9.UpdateDate="06/06/2015 13:07:44"
__Ci9.LastPlayedDate="1/1/0001 12:00:00 AM"
__Ci9.TargetDevice="PocketPC"
__Ci9.TargetDeviceVersion="0"
__Ci9.StateId="1"
__Ci9.CountryId="2"
__Ci9.Complete=false
__Ci9.UseLogging=true

__Ci9.Media=__p1P

__Ci9.Icon=_yHheG


-- Zones --
_t2O = Wherigo.Zone(__Ci9)
_t2O.Id = "7d3bf54e-4618-43f7-bd0f-124603ab6532"
_t2O.Name = _o_Y("\115\043\084\078\103")
_t2O.Description = ""
_t2O.Visible = false
_t2O.Commands = {}
_t2O.DistanceRange = Distance(-1, "feet")
_t2O.ShowObjects = "OnEnter"
_t2O.ProximityRange = Distance(10, "meters")
_t2O.AllowSetPositionTo = false
_t2O.Active = true
_t2O.Points = {
	ZonePoint(38.58198, -90.44197, 0), 
	ZonePoint(38.58198, -90.44193, 0), 
	ZonePoint(38.58195, -90.441925364418, 0), 
	ZonePoint(38.58195, -90.44197, 0)
}
_t2O.OriginalPoint = ZonePoint(38.581965, -90.4419488411045, 0)
_t2O.DistanceRangeUOM = "Feet"
_t2O.ProximityRangeUOM = "Meters"
_t2O.OutOfRangeName = ""
_t2O.InRangeName = ""

-- Characters --

-- Items --
_SbG = Wherigo.ZItem{
	Cartridge = __Ci9, 
	Container = Player
}
_SbG.Id = "6c8157c2-a7fc-4f0d-a30e-29dd33c91957"
_SbG.Name = _o_Y("\020\061\021\061\058\033\061\016\082\078\034\087\061\016\003\023\098")
_SbG.Description = ""
_SbG.Visible = true
_SbG.Media = _58Q
_SbG.Icon = _7Sm
_SbG.Commands = {
	_cHo = Wherigo.ZCommand{
		Text = _o_Y("\085\043\033\027\078\084\034\061\016\027\023\016\027\087\061\016\082\078\034\087\061"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _o_Y("\001\023\027\087\043\084\064\016\078\021\078\043\103\078\102\103\061")
	}
}
_SbG.Commands._cHo.Custom = true
_SbG.Commands._cHo.Id = "60c62693-1b62-42d2-aef8-18140517a4b5"
_SbG.Commands._cHo.WorksWithAll = true
_SbG.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_SbG.Locked = false
_SbG.Opened = false
_gmOpN = Wherigo.ZItem(__Ci9)
_gmOpN.Id = "bc22acf7-9402-4770-8731-9850ce348e62"
_gmOpN.Name = _o_Y("\041\103\078\127\061\058\016\082\023\054\037\103\061\027\043\023\084\016\082\023\017\061")
_gmOpN.Description = ""
_gmOpN.Visible = true
_gmOpN.Commands = {}
_gmOpN.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_gmOpN.Locked = false
_gmOpN.Opened = false
_sr1C = Wherigo.ZItem(__Ci9)
_sr1C.Id = "9ece0032-11ac-414b-bdf3-b843e3a47f1c"
_sr1C.Name = _o_Y("\036\084\033\027\058\042\034\027\043\023\084\033")
_sr1C.Description = _o_Y("\100\087\061\016\043\027\061\054\016\043\084\016\127\023\042\058\016\043\084\021\061\084\027\023\058\127\016\043\033\016\078\016\058\061\021\061\058\033\061\016\034\078\034\087\061\016\102\023\098\095\016\036\084\033\027\061\078\017\016\023\025\016\064\043\021\043\084\064\016\127\023\042\016\034\023\023\058\017\043\084\078\027\061\033\016\027\023\016\027\087\061\016\034\078\034\087\061\055\016\027\087\061\016\058\061\021\061\058\033\061\016\034\078\034\087\061\016\102\023\098\016\089\043\103\103\016\043\084\017\043\034\078\027\061\017\016\027\087\061\016\017\043\033\027\078\084\034\061\016\027\023\016\027\087\061\016\034\078\034\087\061\095\016\006\023\042\058\016\027\078\033\109\016\043\033\016\027\023\016\025\043\084\017\016\027\087\061\016\064\061\023\034\078\034\087\061\016\042\033\043\084\064\016\023\084\103\127\016\017\043\033\027\078\084\034\061\095\016\100\058\127\016\042\033\043\084\064\016\027\087\061\016\102\023\098\016\078\033\016\103\043\027\027\103\061\016\078\033\016\037\023\033\033\043\102\103\061\016\078\084\017\016\037\023\033\027\016\127\023\042\058\016\084\042\054\102\061\058\016\023\025\016\027\058\043\061\033\016\027\023\016\127\023\042\058\016\025\023\042\084\017\016\043\027\016\103\023\064\095")
_sr1C.Visible = true
_sr1C.Media = _gXRR6
_sr1C.Icon = _bk3o
_sr1C.Commands = {}
_sr1C.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_sr1C.Locked = false
_sr1C.Opened = false

-- Tasks --
_RK4A = Wherigo.ZTask(__Ci9)
_RK4A.Id = "77c084e8-67a2-48f1-9167-2194c20230e9"
_RK4A.Name = _o_Y("\115\043\084\017\016\027\087\061\016\082\078\034\087\061")
_RK4A.Description = _o_Y("\115\043\084\017\016\027\087\061\016\064\061\023\034\078\034\087\061")
_RK4A.Visible = true
_RK4A.Media = _Qn_u
_RK4A.Icon = _afQ
_RK4A.Active = false
_RK4A.Complete = false
_RK4A.CorrectState = "None"

-- Cartridge Variables --
_vd5Cq = ""
_D2cQ6 = 1
_OHmu9 = ""
_y3qf = ""
_SIyv = _o_Y("\112\027\079\059")
_l9PZM = _o_Y("\017\042\054\054\127")
__0OXE = _o_Y("\112\046\102\057")
_TYm = _o_Y("\112\020\051\035\031")
_NsOsp = _o_Y("\112\100\034\120")
_ApRm = _o_Y("\112\035\093\091\041\025")
__Ci9.ZVariables = {
	_vd5Cq = "", 
	_D2cQ6 = 1, 
	_OHmu9 = "", 
	_y3qf = "", 
	_SIyv = _o_Y("\112\027\079\059"), 
	_l9PZM = _o_Y("\017\042\054\054\127"), 
	__0OXE = _o_Y("\112\046\102\057"), 
	_TYm = _o_Y("\112\020\051\035\031"), 
	_NsOsp = _o_Y("\112\100\034\120"), 
	_ApRm = _o_Y("\112\035\093\091\041\025")
}

-- Timers --
_4LMPf = Wherigo.ZTimer(__Ci9)
_4LMPf.Id = "743acf0f-054d-42fe-9bb1-24837e013588"
_4LMPf.Name = _o_Y("\033\078\027\027\061\103\043\027\061\016\034\023\054\037\103\061\027\061")
_4LMPf.Description = ""
_4LMPf.Visible = true
_4LMPf.Duration = 4
_4LMPf.Type = "Countdown"

-- Inputs --
_TcE = Wherigo.ZInput(__Ci9)
_TcE.Id = "16b4c21f-200a-46e1-a6d4-8b4fa67fcc9a"
_TcE.Name = _o_Y("\085\043\017\016\006\023\042\016\115\043\084\017\016\027\087\061\016\082\078\034\087\061\108")
_TcE.Description = ""
_TcE.Visible = true
_TcE.Media = _KaeL1
_TcE.Choices = {
	"Yes", 
	"No"
}
_TcE.InputType = "MultipleChoice"
_TcE.Text = _o_Y("\085\043\017\016\006\023\042\016\115\043\084\017\016\027\087\061\016\082\078\034\087\061\108")

-- WorksWithList for object commands --

-- functions --
function __Ci9:OnStart()
	if (_G[_o_Y("\120\084\021")][_o_Y("\085\061\021\043\034\061\036\085")] == _o_Y("\085\061\033\109\027\023\037")) or (_G[_o_Y("\120\084\021")][_o_Y("\041\103\078\027\025\023\058\054")] == _o_Y("\106\043\084\086\079")) then
		for k, v in pairs(_G[_o_Y("\112\112\082\043\092")][_o_Y("\031\103\103\122\059\102\040\061\034\027\033")]) do
			v[_o_Y("\117\043\033\043\102\103\061")] = false
			v[_o_Y("\031\034\027\043\021\061")] = false
		end
		_Urwigo.MessageBox{
			Text = tostring(_o_Y("\006\023\042\016\034\078\084\084\023\027\016\058\042\084\016\027\087\043\033\016\034\078\058\027\058\043\017\064\061\016\043\084\016\061\054\042\103\078\027\023\058\016\054\023\017\061\095")), 
			Callback = function(action)
				if action ~= nil then
					_G[_o_Y("\106\087\061\058\043\064\023")][_o_Y("\082\023\054\054\078\084\017")](_o_Y("\046\078\021\061\082\103\023\033\061"))
				end
			end
		}
		return
	end
	if (_G[_o_Y("\120\084\021")][_o_Y("\085\061\021\043\034\061\036\085")] == _o_Y("\085\061\033\109\027\023\037")) or (_G[_o_Y("\120\084\021")][_o_Y("\041\103\078\027\025\023\058\054")] == _o_Y("\106\043\084\086\079")) then
		_t2O.Active = false
		_SbG.Visible = false
		Wherigo.Command "SaveClose"
	end
	_Urwigo.MessageBox{
		Text = _o_Y("\106\061\103\034\023\054\061\016\027\023\016\027\087\061\016\058\061\021\061\058\033\061\016\034\078\034\087\061\095\016\036\084\016\027\087\043\033\016\089\087\061\058\043\064\023\016\127\023\042\016\089\043\103\103\016\102\061\016\064\043\021\061\084\016\027\087\061\016\017\043\033\027\078\084\034\061\016\027\023\016\027\087\061\016\064\061\023\034\078\034\087\061\016\102\042\027\016\084\023\027\016\027\087\061\016\102\061\078\058\043\084\064\095\016"), 
		Media = _zjK22, 
		Callback = function(action)
			if action ~= nil then
				_Urwigo.MessageBox{
					Text = _o_Y("\100\087\061\016\058\061\021\061\058\033\061\016\034\078\034\087\061\016\102\023\098\016\089\043\103\103\016\109\061\061\037\016\027\058\078\034\109\016\023\025\016\027\087\061\016\084\042\054\102\061\058\016\023\025\016\027\058\043\061\033\016\127\023\042\016\054\078\109\061\095\016\115\061\061\103\016\025\058\061\061\016\027\023\016\037\023\033\027\016\027\087\043\033\016\084\042\054\102\061\058\016\027\023\016\127\023\042\058\016\025\023\042\084\017\016\043\027\016\103\023\064\095\016"), 
					Media = _zjK22, 
					Callback = function(action)
						if action ~= nil then
							Wherigo.PlayAudio(_H53xE)
							_4LMPf:Start()
							_RK4A.Active = true
							_Urwigo.MessageBox{
								Text = _o_Y("\041\103\061\078\033\061\016\089\078\043\027\016\089\087\043\103\061\016\089\061\016\078\034\081\042\043\058\061\016\033\078\027\061\103\103\043\027\061\033\095\095\095"), 
								Media = _IjtCS
							}
						end
					end
				}
			end
		end
	}
end
function __Ci9:OnRestore()
end
function _t2O:OnProximity()
	_SIyv = _o_Y("\112\027\079\059")
	_Urwigo.MessageBox{
		Text = _o_Y("\006\023\042\016\078\058\061\016\058\061\078\103\103\127\016\034\103\023\033\061\095\095\095"), 
		Callback = function(action)
			if action ~= nil then
				_Urwigo.RunDialogs(function()
					Wherigo.GetInput(_TcE)
				end)
			end
		end
	}
end
function _TcE:OnGetInput(input)
	if input == nil then
		input = ""
	end
	_OHmu9 = input
	if Wherigo.NoCaseEquals(_OHmu9, _o_Y("\006\061\033")) then
		_Urwigo.MessageBox{
			Text = "", 
			Media = _IY8, 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.MessageBox{
						Text = (_o_Y("\100\087\043\033\016\089\087\061\058\043\064\023\016\034\078\058\027\058\043\017\064\061\016\089\078\033\016\017\061\033\043\064\084\061\017\016\102\127\016\115\023\058\061\033\027\083\057\087\023\033\027\095\016\036\016\087\023\037\061\016\127\023\042\016\061\084\040\023\127\061\017\016\043\027\095\016\100\023\016\103\061\078\058\084\016\054\023\058\061\016\078\102\023\042\027\016\106\087\061\058\043\064\023\033\016\037\103\061\078\033\061\016\021\043\033\043\027\016\089\087\061\058\043\064\023\025\023\042\084\017\078\027\043\023\084\095\034\023\054\095\016\006\023\042\058\016\037\103\078\127\061\058\016\034\023\054\037\103\061\027\043\023\084\016\082\023\017\061\016\043\033\022\016")..string.sub(Player.CompletionCode, 1, 15)).._o_Y("\016\020\061\054\061\054\102\061\058\016\027\023\016\103\023\064\016\127\023\042\058\016\037\103\078\127\043\084\064\016\061\098\037\061\058\043\061\084\034\061\016\078\027\016\089\089\089\095\089\087\061\058\043\064\023\095\034\023\054\095\016\100\087\078\084\109\033\016\025\023\058\016\037\103\078\127\043\084\064\056"), 
						Media = _HAc_, 
						Callback = function(action)
							if action ~= nil then
								Wherigo.ShowScreen(Wherigo.MAINSCREEN)
							end
						end
					}
				end
			end
		}
		_gmOpN:MoveTo(Player)
		_RK4A.Complete = true
		__Ci9.Complete = true
		_gmOpN.Description = _o_Y("\006\023\042\058\016\041\103\078\127\061\058\016\082\023\054\037\103\061\027\043\023\084\016\082\023\017\061\016\043\033")..string.sub(Player.CompletionCode, 1, 15)
	else
		_Urwigo.MessageBox{
			Text = _o_Y("\036\016\078\054\016\033\023\058\058\127\016\027\087\078\027\016\127\023\042\016\017\043\017\084\073\027\016\025\043\084\017\016\043\027\095\016\006\023\042\016\078\058\061\016\021\061\058\127\016\034\103\023\033\061\016\027\087\023\042\064\087\095\016\036\025\016\127\023\042\016\027\087\043\084\109\016\027\087\061\016\034\078\034\087\061\016\043\033\016\054\043\033\033\043\084\064\016\037\103\061\078\033\061\016\034\023\084\027\078\034\027\016\027\087\061\016\082\059\095"), 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.RunDialogs(function()
						Wherigo.GetInput(_TcE)
					end)
				end
			end
		}
	end
end
function _4LMPf:OnTick()
	_Urwigo.MessageBox{
		Text = _o_Y("\059\109\078\127\055\016\089\061\016\087\078\021\061\016\078\081\042\043\058\061\017\016\078\016\064\023\023\017\016\025\043\098\095\016\059\037\061\084\016\027\087\061\016\038\043\027\061\054\033\016\054\061\084\042\038\016\089\087\061\058\061\016\127\023\042\016\089\043\103\103\016\025\043\084\017\016\027\087\061\016\058\061\021\061\058\033\061\016\034\078\034\087\061\016\102\023\098\095\016"), 
		Media = _IjtCS, 
		Callback = function(action)
			if action ~= nil then
				_Urwigo.MessageBox{
					Text = _o_Y("\100\087\061\058\061\016\078\058\061\016\043\084\033\027\058\042\034\027\043\023\084\033\016\025\023\058\016\037\103\078\127\043\084\064\016\027\087\061\016\064\078\054\061\016\043\084\016\127\023\042\058\016\043\084\021\061\084\027\023\058\127\095"), 
					Callback = function(action)
						if action ~= nil then
							_sr1C:MoveTo(Player)
						end
					end
				}
			end
		end
	}
end
function _SbG:On_cHo(target)
	_vd5Cq = (_o_Y("\006\023\042\016\078\058\061\016")..(1 * Wherigo.VectorToPoint(Player.ObjectLocation, _t2O.OriginalPoint):GetValue "ft")).._o_Y("\016\025\061\061\027\016\025\058\023\054\016\027\087\061\016\034\078\034\087\061\095")
	_y3qf = (_o_Y("\100\087\043\033\016\089\078\033\016\081\042\061\058\127\016\084\042\054\102\061\058\016").._D2cQ6).._o_Y("\095")
	_SbG.Description = _y3qf
	_Urwigo.MessageBox{
		Text = _vd5Cq, 
		Media = _3uI
	}
	_D2cQ6 = _D2cQ6 + 1
end

-- Urwigo functions --
function _yYI()
	_t2O.Active = false
end
function _Rld()
	_SbG.Visible = false
end

-- Begin user functions --
-- End user functions --
return __Ci9
