require "Wherigo"
ZonePoint = Wherigo.ZonePoint
Distance = Wherigo.Distance
Player = Wherigo.Player

-- String decode --
function _VvPb(str)
	local res = ""
    local dtable = "\049\075\095\106\108\079\123\002\025\003\041\053\034\054\126\109\021\033\068\043\077\103\122\023\039\107\096\084\074\032\124\027\105\000\092\031\012\020\062\093\057\018\010\063\013\076\061\046\014\050\112\110\082\081\094\028\026\089\071\001\115\119\100\066\090\072\038\040\030\121\111\073\087\045\048\044\022\059\004\088\102\101\006\007\042\009\114\104\017\060\056\116\120\035\005\069\067\052\086\098\029\080\078\037\117\051\070\058\118\024\125\099\015\085\065\036\083\019\011\055\113\091\097\047\008\064\016"
	for i=1, #str do
        local b = str:byte(i)
        if b > 0 and b <= 0x7F then
	        res = res .. string.char(dtable:byte(b))
        else
            res = res .. string.char(b)
        end
	end
	return res
end

-- Internal functions --
require "table"
require "math"

math.randomseed(os.time())
math.random()
math.random()
math.random()

_Urwigo = {}

_Urwigo.InlineRequireLoaded = {}
_Urwigo.InlineRequireRes = {}
_Urwigo.InlineRequire = function(moduleName)
  local res
  if _Urwigo.InlineRequireLoaded[moduleName] == nil then
    res = _Urwigo.InlineModuleFunc[moduleName]()
    _Urwigo.InlineRequireLoaded[moduleName] = 1
    _Urwigo.InlineRequireRes[moduleName] = res
  else
    res = _Urwigo.InlineRequireRes[moduleName]
  end
  return res
end

_Urwigo.Round = function(num, idp)
  local mult = 10^(idp or 0)
  return math.floor(num * mult + 0.5) / mult
end

_Urwigo.Ceil = function(num, idp)
  local mult = 10^(idp or 0)
  return math.ceil(num * mult) / mult
end

_Urwigo.Floor = function(num, idp)
  local mult = 10^(idp or 0)
  return math.floor(num * mult) / mult
end

_Urwigo.DialogQueue = {}
_Urwigo.RunDialogs = function(callback)
	local dialogs = _Urwigo.DialogQueue
	local lastCallback = nil
	_Urwigo.DialogQueue = {}
	local msgcb = {}
	msgcb = function(action)
		if action ~= nil then
			if lastCallback ~= nil then
				lastCallback(action)
			end
			local entry = table.remove(dialogs, 1)
			if entry ~= nil then
				lastCallback = entry.Callback;
				if entry.Text ~= nil then
					Wherigo.MessageBox({Text = entry.Text, Media=entry.Media, Buttons=entry.Buttons, Callback=msgcb})
				else
					msgcb(action)
				end
			else
				if callback ~= nil then
					callback()
				end
			end
		end
	end
	msgcb(true) -- any non-null argument
end

_Urwigo.MessageBox = function(tbl)
    _Urwigo.RunDialogs(function() Wherigo.MessageBox(tbl) end)
end

_Urwigo.OldDialog = function(tbl)
    _Urwigo.RunDialogs(function() Wherigo.Dialog(tbl) end)
end

_Urwigo.Dialog = function(buffered, tbl, callback)
	for k,v in ipairs(tbl) do
		table.insert(_Urwigo.DialogQueue, v)
	end
	if callback ~= nil then
		table.insert(_Urwigo.DialogQueue, {Callback=callback})
	end
	if not buffered then
		_Urwigo.RunDialogs(nil)
	end
end

_Urwigo.Hash = function(str)
   local b = 378551;
   local a = 63689;
   local hash = 0;
   for i = 1, #str, 1 do
      hash = hash*a+string.byte(str,i);
      hash = math.fmod(hash, 65535)
      a = a*b;
      a = math.fmod(a, 65535)
   end
   return hash;
end

_Urwigo.DaysInMonth = {
	31,
	28,
	31,
	30,
	31,
	30,
	31,
	31,
	30,
	31,
	30,
	31,
}

_Urwigo_Date_IsLeapYear = function(year)
	if year % 400 == 0 then
		return true
	elseif year% 100 == 0 then
		return false
	elseif year % 4 == 0 then
		return true
	else
		return false
	end
end

_Urwigo.Date_DaysInMonth = function(year, month)
	if month ~= 2 then
		return _Urwigo.DaysInMonth[month];
	else
		if _Urwigo_Date_IsLeapYear(year) then
			return 29
		else
			return 28
		end
	end
end

_Urwigo.Date_DayInYear = function(t)
	local res = t.day
	for month = 1, t.month - 1 do
		res = res + _Urwigo.Date_DaysInMonth(t.year, month)
	end
	return res
end

_Urwigo.Date_HourInWeek = function(t)
	return t.hour + (t.wday-1) * 24
end

_Urwigo.Date_HourInMonth = function(t)
	return t.hour + t.day * 24
end

_Urwigo.Date_HourInYear = function(t)
	return t.hour + (_Urwigo.Date_DayInYear(t) - 1) * 24
end

_Urwigo.Date_MinuteInDay = function(t)
	return t.min + t.hour * 60
end

_Urwigo.Date_MinuteInWeek = function(t)
	return t.min + t.hour * 60 + (t.wday-1) * 1440;
end

_Urwigo.Date_MinuteInMonth = function(t)
	return t.min + t.hour * 60 + (t.day-1) * 1440;
end

_Urwigo.Date_MinuteInYear = function(t)
	return t.min + t.hour * 60 + (_Urwigo.Date_DayInYear(t) - 1) * 1440;
end

_Urwigo.Date_SecondInHour = function(t)
	return t.sec + t.min * 60
end

_Urwigo.Date_SecondInDay = function(t)
	return t.sec + t.min * 60 + t.hour * 3600
end

_Urwigo.Date_SecondInWeek = function(t)
	return t.sec + t.min * 60 + t.hour * 3600 + (t.wday-1) * 86400
end

_Urwigo.Date_SecondInMonth = function(t)
	return t.sec + t.min * 60 + t.hour * 3600 + (t.day-1) * 86400
end

_Urwigo.Date_SecondInYear = function(t)
	return t.sec + t.min * 60 + t.hour * 3600 + (_Urwigo.Date_DayInYear(t)-1) * 86400
end


-- Inlined modules --
_Urwigo.InlineModuleFunc = {}

cartAlienCacher = Wherigo.ZCartridge()

-- Media --
zmediaAlienGeocacher = Wherigo.ZMedia(cartAlienCacher)
zmediaAlienGeocacher.Id = "b6324bee-a6b8-4a54-b2b8-9fed0b0bf8b9"
zmediaAlienGeocacher.Name = _VvPb("\115\005\033\082\052\030\059\082\071\112\123\112\088\082\087")
zmediaAlienGeocacher.Description = ""
zmediaAlienGeocacher.AltText = ""
zmediaAlienGeocacher.Resources = {
	{
		Type = "jpg", 
		Filename = "alien_geocacher.jpg", 
		Directives = {}
	}
}
zmediaAlienMechanic = Wherigo.ZMedia(cartAlienCacher)
zmediaAlienMechanic.Id = "881e87ea-4531-4b4b-ba77-371f16498e8d"
zmediaAlienMechanic.Name = _VvPb("\115\005\033\082\052\030\021\082\112\088\123\052\033\112")
zmediaAlienMechanic.Description = ""
zmediaAlienMechanic.AltText = ""
zmediaAlienMechanic.Resources = {
	{
		Type = "jpg", 
		Filename = "alien_mechanic.jpg", 
		Directives = {}
	}
}
zmediaCar = Wherigo.ZMedia(cartAlienCacher)
zmediaCar.Id = "fd190416-ff18-4f5b-a927-b82018248050"
zmediaCar.Name = _VvPb("\097\123\087")
zmediaCar.Description = ""
zmediaCar.AltText = ""
zmediaCar.Resources = {
	{
		Type = "jpg", 
		Filename = "car.jpg", 
		Directives = {}
	}
}
zmediaFluxCapacitorOff = Wherigo.ZMedia(cartAlienCacher)
zmediaFluxCapacitorOff.Id = "27e21e71-b140-487e-b69e-884ed6d13c7a"
zmediaFluxCapacitorOff.Name = _VvPb("\107\005\105\093\030\097\123\051\123\112\033\092\071\087\030\006\081\081")
zmediaFluxCapacitorOff.Description = ""
zmediaFluxCapacitorOff.AltText = ""
zmediaFluxCapacitorOff.Resources = {
	{
		Type = "jpg", 
		Filename = "flux_capacitor_off.jpg", 
		Directives = {}
	}
}
zmediaFluxCapacitorOn = Wherigo.ZMedia(cartAlienCacher)
zmediaFluxCapacitorOn.Id = "71f1d17c-7dcb-4976-af6e-67656ab7b406"
zmediaFluxCapacitorOn.Name = _VvPb("\107\005\105\093\030\097\123\051\123\112\033\092\071\087\030\006\052")
zmediaFluxCapacitorOn.Description = ""
zmediaFluxCapacitorOn.AltText = ""
zmediaFluxCapacitorOn.Resources = {
	{
		Type = "jpg", 
		Filename = "flux_capacitor_on.jpg", 
		Directives = {}
	}
}
zmediaFlyingSaucer = Wherigo.ZMedia(cartAlienCacher)
zmediaFlyingSaucer.Id = "dd763c29-84b5-4d28-ace9-e085e1f02e00"
zmediaFlyingSaucer.Name = _VvPb("\107\005\070\033\052\022\030\117\123\105\112\082\087")
zmediaFlyingSaucer.Description = ""
zmediaFlyingSaucer.AltText = ""
zmediaFlyingSaucer.Resources = {
	{
		Type = "jpg", 
		Filename = "flying_saucer.jpg", 
		Directives = {}
	}
}
zmediaSpaceshipPart1 = Wherigo.ZMedia(cartAlienCacher)
zmediaSpaceshipPart1.Id = "a88f35e7-d13b-43f3-ae80-d3b7f69ce835"
zmediaSpaceshipPart1.Name = _VvPb("\117\051\123\112\082\061\088\033\051\030\102\123\087\092\030\001")
zmediaSpaceshipPart1.Description = ""
zmediaSpaceshipPart1.AltText = ""
zmediaSpaceshipPart1.Resources = {
	{
		Type = "jpg", 
		Filename = "gadget_1.jpg", 
		Directives = {}
	}
}
zmediaSpaceshipPart2 = Wherigo.ZMedia(cartAlienCacher)
zmediaSpaceshipPart2.Id = "4ce0ccc4-3cae-4e03-9736-3b3017a915b4"
zmediaSpaceshipPart2.Name = _VvPb("\117\051\123\112\082\061\088\033\051\030\102\123\087\092\030\050")
zmediaSpaceshipPart2.Description = ""
zmediaSpaceshipPart2.AltText = ""
zmediaSpaceshipPart2.Resources = {
	{
		Type = "jpg", 
		Filename = "gadget_2.jpg", 
		Directives = {}
	}
}
zmediaSpaceshipPart3 = Wherigo.ZMedia(cartAlienCacher)
zmediaSpaceshipPart3.Id = "be767814-3025-4d7d-9b5c-c64f677b4ec8"
zmediaSpaceshipPart3.Name = _VvPb("\117\051\123\112\082\061\088\033\051\030\102\123\087\092\030\106")
zmediaSpaceshipPart3.Description = ""
zmediaSpaceshipPart3.AltText = ""
zmediaSpaceshipPart3.Resources = {
	{
		Type = "jpg", 
		Filename = "gadget_3.jpg", 
		Directives = {}
	}
}
zmediaGloves = Wherigo.ZMedia(cartAlienCacher)
zmediaGloves.Id = "8230d086-c311-4ae5-8583-0e37f8831903"
zmediaGloves.Name = _VvPb("\059\005\071\109\082\061")
zmediaGloves.Description = ""
zmediaGloves.AltText = ""
zmediaGloves.Resources = {
	{
		Type = "jpg", 
		Filename = "gloves.jpg", 
		Directives = {}
	}
}
zmediaWalkieTalkie = Wherigo.ZMedia(cartAlienCacher)
zmediaWalkieTalkie.Id = "93a79f9f-cf22-4371-8fcb-74beb8f28bd7"
zmediaWalkieTalkie.Name = _VvPb("\073\123\005\026\033\082\030\028\123\005\026\033\082")
zmediaWalkieTalkie.Description = ""
zmediaWalkieTalkie.AltText = ""
zmediaWalkieTalkie.Resources = {
	{
		Type = "jpg", 
		Filename = "radio.jpg", 
		Directives = {}
	}
}
zmediaSunglasses = Wherigo.ZMedia(cartAlienCacher)
zmediaSunglasses.Id = "c65a9560-31fa-49cb-b23a-c6a14beb12ad"
zmediaSunglasses.Name = _VvPb("\117\105\052\022\005\123\061\061\082\061")
zmediaSunglasses.Description = ""
zmediaSunglasses.AltText = ""
zmediaSunglasses.Resources = {
	{
		Type = "jpg", 
		Filename = "sunglasses.jpg", 
		Directives = {}
	}
}
zmediaAlienMultiTool = Wherigo.ZMedia(cartAlienCacher)
zmediaAlienMultiTool.Id = "e853e483-b846-4373-b455-35ca1423f5e5"
zmediaAlienMultiTool.Name = _VvPb("\115\005\033\082\052\030\021\105\005\092\033\028\071\071\005")
zmediaAlienMultiTool.Description = ""
zmediaAlienMultiTool.AltText = ""
zmediaAlienMultiTool.Resources = {
	{
		Type = "jpg", 
		Filename = "wrench.jpg", 
		Directives = {}
	}
}
zmediaMap = Wherigo.ZMedia(cartAlienCacher)
zmediaMap.Id = "f626a7ea-c581-4f6e-8c35-753a48249647"
zmediaMap.Name = _VvPb("\021\123\051")
zmediaMap.Description = ""
zmediaMap.AltText = ""
zmediaMap.Resources = {
	{
		Type = "jpg", 
		Filename = "map.jpg", 
		Directives = {}
	}
}
zmediaGeocacher = Wherigo.ZMedia(cartAlienCacher)
zmediaGeocacher.Id = "0d81de03-a800-4af8-a272-2ae4b08e770f"
zmediaGeocacher.Name = _VvPb("\059\082\071\112\123\112\088\082\087")
zmediaGeocacher.Description = ""
zmediaGeocacher.AltText = ""
zmediaGeocacher.Resources = {
	{
		Type = "jpg", 
		Filename = "geocacher.jpg", 
		Directives = {}
	}
}
zmediaTask = Wherigo.ZMedia(cartAlienCacher)
zmediaTask.Id = "e63a8736-ff2d-41eb-ad27-7d67be812be5"
zmediaTask.Name = _VvPb("\028\123\061\026")
zmediaTask.Description = ""
zmediaTask.AltText = ""
zmediaTask.Resources = {
	{
		Type = "jpg", 
		Filename = "task.jpg", 
		Directives = {}
	}
}
zmediaSpaceCraftinOrbit = Wherigo.ZMedia(cartAlienCacher)
zmediaSpaceCraftinOrbit.Id = "91524215-9f10-49bb-99fd-bc0552e1cbcd"
zmediaSpaceCraftinOrbit.Name = _VvPb("\117\051\123\112\082\030\097\087\123\081\092\030\033\052\030\006\087\100\033\092")
zmediaSpaceCraftinOrbit.Description = ""
zmediaSpaceCraftinOrbit.AltText = ""
zmediaSpaceCraftinOrbit.Resources = {
	{
		Type = "jpg", 
		Filename = "space_craftinorbit.jpg", 
		Directives = {}
	}
}
zmediaWherigo = Wherigo.ZMedia(cartAlienCacher)
zmediaWherigo.Id = "8e795f0c-76ad-45c5-b6db-10c6d4d09f07"
zmediaWherigo.Name = _VvPb("\073\088\082\087\033\022\071")
zmediaWherigo.Description = ""
zmediaWherigo.AltText = ""
zmediaWherigo.Resources = {
	{
		Type = "jpg", 
		Filename = "wherigo.jpg", 
		Directives = {}
	}
}
zmediaGeocache = Wherigo.ZMedia(cartAlienCacher)
zmediaGeocache.Id = "59c92740-4fe2-4227-85e9-d0eed31f5a5e"
zmediaGeocache.Name = _VvPb("\059\082\071\112\123\112\088\082")
zmediaGeocache.Description = ""
zmediaGeocache.AltText = ""
zmediaGeocache.Resources = {
	{
		Type = "jpg", 
		Filename = "geocache.jpg", 
		Directives = {}
	}
}
zmediaSpoiler = Wherigo.ZMedia(cartAlienCacher)
zmediaSpoiler.Id = "b35e7ff4-6d64-4a21-8283-e685b439b580"
zmediaSpoiler.Name = _VvPb("\117\051\071\033\005\082\087")
zmediaSpoiler.Description = ""
zmediaSpoiler.AltText = ""
zmediaSpoiler.Resources = {
	{
		Type = "jpg", 
		Filename = "spoiler.jpg", 
		Directives = {}
	}
}
zmediaAlienSWAG = Wherigo.ZMedia(cartAlienCacher)
zmediaAlienSWAG.Id = "3555b16b-7db0-4069-a92b-81a39e5f7c80"
zmediaAlienSWAG.Name = _VvPb("\115\005\033\082\052\030\117\073\115\059")
zmediaAlienSWAG.Description = ""
zmediaAlienSWAG.AltText = ""
zmediaAlienSWAG.Resources = {
	{
		Type = "jpg", 
		Filename = "swag.jpg", 
		Directives = {}
	}
}
-- Cartridge Info --
cartAlienCacher.Id="72948bd5-40fe-4f0a-89af-16d8a8d3cdf9"
cartAlienCacher.Name="Alien Cacher"
cartAlienCacher.Description=[[A small quest type game that will eventually lead you to find a geocache.]]
cartAlienCacher.Visible=true
cartAlienCacher.Activity="Fiction"
cartAlienCacher.StartingLocationDescription=[[One day a geocacher went to the park to do some geocaching... And he ended helping some aliens from the Acheron System. For a reward they gave him...]]
cartAlienCacher.StartingLocation = ZonePoint(42.14448,24.74096,0)
cartAlienCacher.Version=""
cartAlienCacher.Company="www.geocaching-bg.org"
cartAlienCacher.Author="Squiffy"
cartAlienCacher.BuilderVersion="URWIGO 1.14.4813.25199"
cartAlienCacher.CreateDate="12/03/2012 21:25:00"
cartAlienCacher.PublishDate="1/1/0001 12:00:00 AM"
cartAlienCacher.UpdateDate="05/28/2013 14:07:27"
cartAlienCacher.LastPlayedDate="1/1/0001 12:00:00 AM"
cartAlienCacher.TargetDevice="PocketPC"
cartAlienCacher.TargetDeviceVersion="0"
cartAlienCacher.StateId="1"
cartAlienCacher.CountryId="2"
cartAlienCacher.Complete=false
cartAlienCacher.UseLogging=true


-- Zones --
zoneParking = Wherigo.Zone(cartAlienCacher)
zoneParking.Id = "9ce83c20-46ed-49c6-adcd-675e7bb423aa"
zoneParking.Name = _VvPb("\102\123\087\026\033\052\022")
zoneParking.Description = ""
zoneParking.Visible = true
zoneParking.Media = zmediaMap
zoneParking.Commands = {}
zoneParking.DistanceRange = Distance(-1, "feet")
zoneParking.ShowObjects = "OnEnter"
zoneParking.ProximityRange = Distance(200, "feet")
zoneParking.AllowSetPositionTo = false
zoneParking.Active = true
zoneParking.Points = {
	ZonePoint(42.14455, 24.74067, 0), 
	ZonePoint(42.14455, 24.74093, 0), 
	ZonePoint(42.14435, 24.74093, 0), 
	ZonePoint(42.14435, 24.74067, 0)
}
zoneParking.OriginalPoint = ZonePoint(42.14445, 24.7408, 0)
zoneParking.DistanceRangeUOM = "Feet"
zoneParking.ProximityRangeUOM = "Feet"
zoneParking.OutOfRangeName = ""
zoneParking.InRangeName = ""
zoneCrashSite = Wherigo.Zone(cartAlienCacher)
zoneCrashSite.Id = "a5322f8f-bab8-452c-a21d-300740673fd4"
zoneCrashSite.Name = _VvPb("\097\087\123\061\088\030\117\033\092\082")
zoneCrashSite.Description = ""
zoneCrashSite.Visible = false
zoneCrashSite.Media = zmediaMap
zoneCrashSite.Commands = {}
zoneCrashSite.DistanceRange = Distance(-1, "feet")
zoneCrashSite.ShowObjects = "OnEnter"
zoneCrashSite.ProximityRange = Distance(50, "meters")
zoneCrashSite.AllowSetPositionTo = false
zoneCrashSite.Active = false
zoneCrashSite.Points = {
	ZonePoint(42.1444, 24.73988, 0), 
	ZonePoint(42.1444, 24.74, 0), 
	ZonePoint(42.1443, 24.74, 0), 
	ZonePoint(42.1443, 24.73988, 0)
}
zoneCrashSite.OriginalPoint = ZonePoint(42.14435, 24.73994, 0)
zoneCrashSite.DistanceRangeUOM = "Feet"
zoneCrashSite.ProximityRangeUOM = "Meters"
zoneCrashSite.OutOfRangeName = ""
zoneCrashSite.InRangeName = ""
zoneShipPart1 = Wherigo.Zone(cartAlienCacher)
zoneShipPart1.Id = "259781ab-0936-4e12-9257-95e853aada41"
zoneShipPart1.Name = _VvPb("\117\088\033\051\030\102\123\087\092\030\001")
zoneShipPart1.Description = ""
zoneShipPart1.Visible = false
zoneShipPart1.Media = zmediaMap
zoneShipPart1.Commands = {}
zoneShipPart1.DistanceRange = Distance(-1, "feet")
zoneShipPart1.ShowObjects = "OnEnter"
zoneShipPart1.ProximityRange = Distance(50, "meters")
zoneShipPart1.AllowSetPositionTo = false
zoneShipPart1.Active = false
zoneShipPart1.Points = {
	ZonePoint(42.1439, 24.74069, 0), 
	ZonePoint(42.1439, 24.74082, 0), 
	ZonePoint(42.14381, 24.74082, 0), 
	ZonePoint(42.14381, 24.74069, 0)
}
zoneShipPart1.OriginalPoint = ZonePoint(42.143856, 24.740758, 0)
zoneShipPart1.DistanceRangeUOM = "Feet"
zoneShipPart1.ProximityRangeUOM = "Meters"
zoneShipPart1.OutOfRangeName = ""
zoneShipPart1.InRangeName = ""
zoneShipPart2 = Wherigo.Zone(cartAlienCacher)
zoneShipPart2.Id = "a406bd4d-0cdb-45cb-94e7-cb86d445cddd"
zoneShipPart2.Name = _VvPb("\117\088\033\051\030\102\123\087\092\030\050")
zoneShipPart2.Description = ""
zoneShipPart2.Visible = false
zoneShipPart2.Media = zmediaMap
zoneShipPart2.Commands = {}
zoneShipPart2.DistanceRange = Distance(-1, "feet")
zoneShipPart2.ShowObjects = "OnEnter"
zoneShipPart2.ProximityRange = Distance(50, "meters")
zoneShipPart2.AllowSetPositionTo = false
zoneShipPart2.Active = false
zoneShipPart2.Points = {
	ZonePoint(42.1429, 24.73962, 0), 
	ZonePoint(42.1429, 24.73974, 0), 
	ZonePoint(42.1428, 24.73974, 0), 
	ZonePoint(42.1428, 24.73962, 0)
}
zoneShipPart2.OriginalPoint = ZonePoint(42.14285, 24.73968, 0)
zoneShipPart2.DistanceRangeUOM = "Feet"
zoneShipPart2.ProximityRangeUOM = "Meters"
zoneShipPart2.OutOfRangeName = ""
zoneShipPart2.InRangeName = ""
zoneShipPart3 = Wherigo.Zone(cartAlienCacher)
zoneShipPart3.Id = "b5cf875b-bc82-41d5-b59a-a3dcea7a9383"
zoneShipPart3.Name = _VvPb("\117\088\033\051\030\102\123\087\092\030\106")
zoneShipPart3.Description = ""
zoneShipPart3.Visible = false
zoneShipPart3.Media = zmediaMap
zoneShipPart3.Commands = {}
zoneShipPart3.DistanceRange = Distance(-1, "feet")
zoneShipPart3.ShowObjects = "OnEnter"
zoneShipPart3.ProximityRange = Distance(50, "meters")
zoneShipPart3.AllowSetPositionTo = false
zoneShipPart3.Active = false
zoneShipPart3.Points = {
	ZonePoint(42.143, 24.74098, 0), 
	ZonePoint(42.143, 24.74111, 0), 
	ZonePoint(42.1429, 24.74111, 0), 
	ZonePoint(42.1429, 24.74098, 0)
}
zoneShipPart3.OriginalPoint = ZonePoint(42.14295, 24.741044, 0)
zoneShipPart3.DistanceRangeUOM = "Feet"
zoneShipPart3.ProximityRangeUOM = "Meters"
zoneShipPart3.OutOfRangeName = ""
zoneShipPart3.InRangeName = ""
zoneFluxCapacitor = Wherigo.Zone(cartAlienCacher)
zoneFluxCapacitor.Id = "e3507cfd-2e72-49e3-9cc1-764116c3a34c"
zoneFluxCapacitor.Name = _VvPb("\107\005\105\093\030\097\123\051\123\112\033\092\071\087")
zoneFluxCapacitor.Description = ""
zoneFluxCapacitor.Visible = false
zoneFluxCapacitor.Media = zmediaMap
zoneFluxCapacitor.Commands = {}
zoneFluxCapacitor.DistanceRange = Distance(-1, "feet")
zoneFluxCapacitor.ShowObjects = "OnEnter"
zoneFluxCapacitor.ProximityRange = Distance(50, "meters")
zoneFluxCapacitor.AllowSetPositionTo = false
zoneFluxCapacitor.Active = false
zoneFluxCapacitor.Points = {
	ZonePoint(42.14515, 24.74019, 0), 
	ZonePoint(42.14515, 24.74045, 0), 
	ZonePoint(42.14495, 24.74045, 0), 
	ZonePoint(42.14495, 24.74019, 0)
}
zoneFluxCapacitor.OriginalPoint = ZonePoint(42.14505, 24.74032, 0)
zoneFluxCapacitor.DistanceRangeUOM = "Feet"
zoneFluxCapacitor.ProximityRangeUOM = "Meters"
zoneFluxCapacitor.OutOfRangeName = ""
zoneFluxCapacitor.InRangeName = ""
zoneMysteryNumber = Wherigo.Zone(cartAlienCacher)
zoneMysteryNumber.Id = "49cebbba-2724-41a4-b53a-c2a9b2f9edb3"
zoneMysteryNumber.Name = _VvPb("\021\070\061\092\082\087\070\030\103\105\016\100\082\087")
zoneMysteryNumber.Description = ""
zoneMysteryNumber.Visible = false
zoneMysteryNumber.Media = zmediaMap
zoneMysteryNumber.Commands = {}
zoneMysteryNumber.DistanceRange = Distance(-1, "feet")
zoneMysteryNumber.ShowObjects = "OnEnter"
zoneMysteryNumber.ProximityRange = Distance(50, "meters")
zoneMysteryNumber.AllowSetPositionTo = false
zoneMysteryNumber.Active = false
zoneMysteryNumber.Points = {
	ZonePoint(42.14543, 24.73992, 0), 
	ZonePoint(42.14543, 24.74005, 0), 
	ZonePoint(42.14533, 24.74005, 0), 
	ZonePoint(42.14533, 24.73992, 0)
}
zoneMysteryNumber.OriginalPoint = ZonePoint(42.145382, 24.739989, 0)
zoneMysteryNumber.DistanceRangeUOM = "Feet"
zoneMysteryNumber.ProximityRangeUOM = "Meters"
zoneMysteryNumber.OutOfRangeName = ""
zoneMysteryNumber.InRangeName = ""
zoneGeocache = Wherigo.Zone(cartAlienCacher)
zoneGeocache.Id = "28dd0c27-2574-4619-a960-53e020513227"
zoneGeocache.Name = _VvPb("\059\082\071\112\123\112\088\082")
zoneGeocache.Description = ""
zoneGeocache.Visible = false
zoneGeocache.Media = zmediaMap
zoneGeocache.Commands = {}
zoneGeocache.DistanceRange = Distance(-1, "feet")
zoneGeocache.ShowObjects = "OnEnter"
zoneGeocache.ProximityRange = Distance(50, "meters")
zoneGeocache.AllowSetPositionTo = false
zoneGeocache.Active = false
zoneGeocache.Points = {
	ZonePoint(42.14477, 24.73576, 0), 
	ZonePoint(42.14477, 24.73588, 0), 
	ZonePoint(42.14467, 24.73588, 0), 
	ZonePoint(42.14467, 24.73576, 0)
}
zoneGeocache.OriginalPoint = ZonePoint(42.1447, 24.735433, 0)
zoneGeocache.DistanceRangeUOM = "Feet"
zoneGeocache.ProximityRangeUOM = "Meters"
zoneGeocache.OutOfRangeName = ""
zoneGeocache.InRangeName = ""
zoneMysteryNumber2 = Wherigo.Zone(cartAlienCacher)
zoneMysteryNumber2.Id = "fa1d3fc2-89f9-4457-96c1-564b728199a0"
zoneMysteryNumber2.Name = _VvPb("\021\070\061\092\082\087\070\030\103\105\016\100\082\087\030\050")
zoneMysteryNumber2.Description = ""
zoneMysteryNumber2.Visible = false
zoneMysteryNumber2.Media = zmediaMap
zoneMysteryNumber2.Commands = {}
zoneMysteryNumber2.DistanceRange = Distance(-1, "feet")
zoneMysteryNumber2.ShowObjects = "OnEnter"
zoneMysteryNumber2.ProximityRange = Distance(50, "meters")
zoneMysteryNumber2.AllowSetPositionTo = false
zoneMysteryNumber2.Active = false
zoneMysteryNumber2.Points = {
	ZonePoint(42.14698, 24.73785, 0), 
	ZonePoint(42.14698, 24.73811, 0), 
	ZonePoint(42.14679, 24.73811, 0), 
	ZonePoint(42.14679, 24.73785, 0)
}
zoneMysteryNumber2.OriginalPoint = ZonePoint(42.146883, 24.737983, 0)
zoneMysteryNumber2.DistanceRangeUOM = "Feet"
zoneMysteryNumber2.ProximityRangeUOM = "Meters"
zoneMysteryNumber2.OutOfRangeName = ""
zoneMysteryNumber2.InRangeName = ""

-- Characters --
zcharacterAlienGeocacher = Wherigo.ZCharacter{
	Cartridge = cartAlienCacher, 
	Container = zoneCrashSite
}
zcharacterAlienGeocacher.Id = "fa480fcd-c23f-4437-a99b-414ece8b71ea"
zcharacterAlienGeocacher.Name = _VvPb("\115\005\033\082\052\030\059\082\071\112\123\112\088\082\087")
zcharacterAlienGeocacher.Description = ""
zcharacterAlienGeocacher.Visible = false
zcharacterAlienGeocacher.Media = zmediaAlienGeocacher
zcharacterAlienGeocacher.Commands = {}
zcharacterAlienGeocacher.ObjectLocation = ZonePoint(42.1439411495985, 24.7407399979225, 0)
zcharacterAlienGeocacher.Gender = "Male"
zcharacterAlienGeocacher.Type = "NPC"
zcharacterKrang = Wherigo.ZCharacter{
	Cartridge = cartAlienCacher, 
	Container = zoneCrashSite
}
zcharacterKrang.Id = "3c19478b-d5d4-4d77-be5b-0e0221a50704"
zcharacterKrang.Name = _VvPb("\002\087\123\052\022")
zcharacterKrang.Description = ""
zcharacterKrang.Visible = false
zcharacterKrang.Media = zmediaAlienMechanic
zcharacterKrang.Commands = {}
zcharacterKrang.ObjectLocation = ZonePoint(42.1439411495985, 24.7407399979225, 0)
zcharacterKrang.Gender = "Male"
zcharacterKrang.Type = "NPC"
zcharacterKrath = Wherigo.ZCharacter{
	Cartridge = cartAlienCacher, 
	Container = zoneCrashSite
}
zcharacterKrath.Id = "65e34b89-9461-4d9e-9c17-6af618d28ed2"
zcharacterKrath.Name = _VvPb("\002\087\123\092\088")
zcharacterKrath.Description = ""
zcharacterKrath.Visible = false
zcharacterKrath.Media = zmediaAlienGeocacher
zcharacterKrath.Commands = {}
zcharacterKrath.ObjectLocation = ZonePoint(42.1439411495985, 24.7407399979225, 0)
zcharacterKrath.Gender = "Male"
zcharacterKrath.Type = "NPC"

-- Items --
zitemYourCar = Wherigo.ZItem{
	Cartridge = cartAlienCacher, 
	Container = zoneParking
}
zitemYourCar.Id = "24fec42b-f4e5-4e93-9cee-3f7b46f14c4a"
zitemYourCar.Name = _VvPb("\058\071\105\087\030\097\123\087")
zitemYourCar.Description = ""
zitemYourCar.Visible = true
zitemYourCar.Media = zmediaCar
zitemYourCar.Commands = {}
zitemYourCar.ObjectLocation = ZonePoint(42.1444831279887, 24.7409599978726, 0)
zitemYourCar.Locked = false
zitemYourCar.Opened = false
zitemGloves = Wherigo.ZItem{
	Cartridge = cartAlienCacher, 
	Container = zoneParking
}
zitemGloves.Id = "34968760-91a8-4103-a814-80f726014c42"
zitemGloves.Name = _VvPb("\059\005\071\109\082\061")
zitemGloves.Description = ""
zitemGloves.Visible = false
zitemGloves.Media = zmediaGloves
zitemGloves.Commands = {}
zitemGloves.ObjectLocation = ZonePoint(42.1444815639927, 24.7409599978726, 0)
zitemGloves.Locked = false
zitemGloves.Opened = false
zitemWalkieTalkie = Wherigo.ZItem{
	Cartridge = cartAlienCacher, 
	Container = zoneParking
}
zitemWalkieTalkie.Id = "2cbb1acc-fdb5-41cf-92b8-36e8ae35bf82"
zitemWalkieTalkie.Name = _VvPb("\073\123\005\026\033\082\030\028\123\005\026\033\082")
zitemWalkieTalkie.Description = ""
zitemWalkieTalkie.Visible = false
zitemWalkieTalkie.Media = zmediaWalkieTalkie
zitemWalkieTalkie.Commands = {}
zitemWalkieTalkie.ObjectLocation = ZonePoint(42.1444815639927, 24.7409599978726, 0)
zitemWalkieTalkie.Locked = false
zitemWalkieTalkie.Opened = false
zitemSunglasses = Wherigo.ZItem{
	Cartridge = cartAlienCacher, 
	Container = zoneParking
}
zitemSunglasses.Id = "c83e84ac-1242-44d4-ba2f-4b65c4a615ef"
zitemSunglasses.Name = _VvPb("\117\105\052\022\005\123\061\061\082\061")
zitemSunglasses.Description = ""
zitemSunglasses.Visible = false
zitemSunglasses.Media = zmediaSunglasses
zitemSunglasses.Commands = {}
zitemSunglasses.ObjectLocation = ZonePoint(42.1444815639927, 24.7409599978726, 0)
zitemSunglasses.Locked = false
zitemSunglasses.Opened = false
zitemAlienSpaceCraft = Wherigo.ZItem{
	Cartridge = cartAlienCacher, 
	Container = zoneCrashSite
}
zitemAlienSpaceCraft.Id = "83761ee4-c415-49eb-9a74-08a558525ead"
zitemAlienSpaceCraft.Name = _VvPb("\115\005\033\082\052\030\117\051\123\112\082\030\097\087\123\081\092")
zitemAlienSpaceCraft.Description = ""
zitemAlienSpaceCraft.Visible = true
zitemAlienSpaceCraft.Media = zmediaFlyingSaucer
zitemAlienSpaceCraft.Commands = {}
zitemAlienSpaceCraft.ObjectLocation = ZonePoint(42.1439411495985, 24.7407399979225, 0)
zitemAlienSpaceCraft.Locked = false
zitemAlienSpaceCraft.Opened = false
zitemSpaceShipPart1 = Wherigo.ZItem{
	Cartridge = cartAlienCacher, 
	Container = zoneShipPart1
}
zitemSpaceShipPart1.Id = "a3e2f62f-34a4-4c68-b7b6-bbef2d2bed61"
zitemSpaceShipPart1.Name = _VvPb("\117\051\123\112\082\030\117\088\033\051\030\102\123\087\092\030\001")
zitemSpaceShipPart1.Description = ""
zitemSpaceShipPart1.Visible = true
zitemSpaceShipPart1.Media = zmediaSpaceshipPart1
zitemSpaceShipPart1.Commands = {}
zitemSpaceShipPart1.ObjectLocation = ZonePoint(42.1433511495989, 24.7402499979225, 0)
zitemSpaceShipPart1.Locked = false
zitemSpaceShipPart1.Opened = false
zitemSpaceShipPart2 = Wherigo.ZItem{
	Cartridge = cartAlienCacher, 
	Container = zoneShipPart2
}
zitemSpaceShipPart2.Id = "f7abead8-eb94-486c-b6d1-90d187c95d93"
zitemSpaceShipPart2.Name = _VvPb("\117\051\123\112\082\030\117\088\033\051\030\102\123\087\092\030\050")
zitemSpaceShipPart2.Description = ""
zitemSpaceShipPart2.Visible = true
zitemSpaceShipPart2.Media = zmediaSpaceshipPart2
zitemSpaceShipPart2.Commands = {}
zitemSpaceShipPart2.ObjectLocation = ZonePoint(42.1433511495989, 24.0252999979225, 0)
zitemSpaceShipPart2.Locked = false
zitemSpaceShipPart2.Opened = false
zitemSpaceShipPart3 = Wherigo.ZItem{
	Cartridge = cartAlienCacher, 
	Container = zoneShipPart3
}
zitemSpaceShipPart3.Id = "ae398185-b06d-4763-b992-9bc42902bbcb"
zitemSpaceShipPart3.Name = _VvPb("\117\051\123\112\082\030\117\088\033\051\030\102\123\087\092\030\106")
zitemSpaceShipPart3.Description = ""
zitemSpaceShipPart3.Visible = true
zitemSpaceShipPart3.Media = zmediaSpaceshipPart3
zitemSpaceShipPart3.Commands = {}
zitemSpaceShipPart3.ObjectLocation = ZonePoint(42.1433511495989, 24.7402499979225, 0)
zitemSpaceShipPart3.Locked = false
zitemSpaceShipPart3.Opened = false
zitemAlienMultiTool = Wherigo.ZItem{
	Cartridge = cartAlienCacher, 
	Container = zoneCrashSite
}
zitemAlienMultiTool.Id = "40322e23-9fbe-42dd-affd-ed268dbd0a30"
zitemAlienMultiTool.Name = _VvPb("\115\005\033\082\052\030\021\105\005\092\033\030\028\071\071\005")
zitemAlienMultiTool.Description = ""
zitemAlienMultiTool.Visible = false
zitemAlienMultiTool.Media = zmediaAlienMultiTool
zitemAlienMultiTool.Commands = {}
zitemAlienMultiTool.ObjectLocation = ZonePoint(42.1439411495985, 24.7407399979225, 0)
zitemAlienMultiTool.Locked = false
zitemAlienMultiTool.Opened = false
zitemFluxCapacitor = Wherigo.ZItem{
	Cartridge = cartAlienCacher, 
	Container = zoneFluxCapacitor
}
zitemFluxCapacitor.Id = "4534562d-9876-4199-a773-b7e0dda390c4"
zitemFluxCapacitor.Name = _VvPb("\107\005\105\093\030\097\123\051\123\112\033\092\071\087")
zitemFluxCapacitor.Description = ""
zitemFluxCapacitor.Visible = true
zitemFluxCapacitor.Media = zmediaFluxCapacitorOn
zitemFluxCapacitor.Commands = {}
zitemFluxCapacitor.ObjectLocation = ZonePoint(42.1465211495966, 24.7397799979222, 0)
zitemFluxCapacitor.Locked = false
zitemFluxCapacitor.Opened = false
zitemDisabledFluxCapacitor = Wherigo.ZItem{
	Cartridge = cartAlienCacher, 
	Container = zoneFluxCapacitor
}
zitemDisabledFluxCapacitor.Id = "2b760c00-5e6d-497c-a87f-c7a84d04d811"
zitemDisabledFluxCapacitor.Name = _VvPb("\019\033\061\123\100\005\082\063\030\107\005\105\093\030\097\123\051\123\112\033\092\071\087")
zitemDisabledFluxCapacitor.Description = ""
zitemDisabledFluxCapacitor.Visible = false
zitemDisabledFluxCapacitor.Media = zmediaFluxCapacitorOff
zitemDisabledFluxCapacitor.Commands = {}
zitemDisabledFluxCapacitor.ObjectLocation = ZonePoint(42.1465211495966, 24.7397799979222, 0)
zitemDisabledFluxCapacitor.Locked = false
zitemDisabledFluxCapacitor.Opened = false
zitemOrbitingSpacecraft = Wherigo.ZItem(cartAlienCacher)
zitemOrbitingSpacecraft.Id = "f8316989-1455-4b1e-9038-1fcd13085fdd"
zitemOrbitingSpacecraft.Name = _VvPb("\006\087\100\033\092\033\052\022\030\117\051\123\112\082\112\087\123\081\092")
zitemOrbitingSpacecraft.Description = ""
zitemOrbitingSpacecraft.Visible = false
zitemOrbitingSpacecraft.Media = zmediaSpaceCraftinOrbit
zitemOrbitingSpacecraft.Commands = {}
zitemOrbitingSpacecraft.ObjectLocation = Wherigo.INVALID_ZONEPOINT
zitemOrbitingSpacecraft.Locked = false
zitemOrbitingSpacecraft.Opened = false
zitemAlienSWAG = Wherigo.ZItem(cartAlienCacher)
zitemAlienSWAG.Id = "11b84dcb-ed47-41cb-99ab-66cab00331b1"
zitemAlienSWAG.Name = _VvPb("\115\005\033\082\052\030\117\073\115\059")
zitemAlienSWAG.Description = ""
zitemAlienSWAG.Visible = false
zitemAlienSWAG.Media = zmediaAlienSWAG
zitemAlienSWAG.Commands = {}
zitemAlienSWAG.ObjectLocation = Wherigo.INVALID_ZONEPOINT
zitemAlienSWAG.Locked = false
zitemAlienSWAG.Opened = false
zitemGeocacheCoordinates = Wherigo.ZItem(cartAlienCacher)
zitemGeocacheCoordinates.Id = "be06dd9c-5fa1-4ad8-ac73-3d9063d51a48"
zitemGeocacheCoordinates.Name = _VvPb("\059\082\071\112\123\112\088\082\030\097\071\071\087\063\033\052\123\092\082\061")
zitemGeocacheCoordinates.Description = ""
zitemGeocacheCoordinates.Visible = false
zitemGeocacheCoordinates.Media = zmediaGeocache
zitemGeocacheCoordinates.Commands = {}
zitemGeocacheCoordinates.ObjectLocation = Wherigo.INVALID_ZONEPOINT
zitemGeocacheCoordinates.Locked = false
zitemGeocacheCoordinates.Opened = false
zitemCompletionCode = Wherigo.ZItem(cartAlienCacher)
zitemCompletionCode.Id = "eefcc200-2e4e-4ab5-ae3d-d7d069e4e38d"
zitemCompletionCode.Name = _VvPb("\097\071\016\051\005\082\092\033\071\052\030\097\071\063\082")
zitemCompletionCode.Description = ""
zitemCompletionCode.Visible = false
zitemCompletionCode.Media = zmediaWherigo
zitemCompletionCode.Commands = {}
zitemCompletionCode.ObjectLocation = Wherigo.INVALID_ZONEPOINT
zitemCompletionCode.Locked = false
zitemCompletionCode.Opened = false
zitemSpoiler = Wherigo.ZItem(cartAlienCacher)
zitemSpoiler.Id = "feed51ff-5a3c-4b44-9e76-5d890f1ed15a"
zitemSpoiler.Name = _VvPb("\117\051\071\033\005\082\087")
zitemSpoiler.Description = ""
zitemSpoiler.Visible = false
zitemSpoiler.Media = zmediaGeocache
zitemSpoiler.Commands = {}
zitemSpoiler.ObjectLocation = Wherigo.INVALID_ZONEPOINT
zitemSpoiler.Locked = false
zitemSpoiler.Opened = false

-- Tasks --
ztaskCheckYourMap = Wherigo.ZTask(cartAlienCacher)
ztaskCheckYourMap.Id = "24d2d604-3944-4f59-8d4a-6a670b767dd1"
ztaskCheckYourMap.Name = _VvPb("\097\088\082\112\026\030\058\071\105\087\030\021\123\051")
ztaskCheckYourMap.Description = ""
ztaskCheckYourMap.Visible = false
ztaskCheckYourMap.Media = zmediaTask
ztaskCheckYourMap.Active = true
ztaskCheckYourMap.Complete = false
ztaskCheckYourMap.CorrectState = "None"
ztaskExploreCrashSite = Wherigo.ZTask(cartAlienCacher)
ztaskExploreCrashSite.Id = "70d42db9-c0fb-4237-ad28-f1265b179af4"
ztaskExploreCrashSite.Name = _VvPb("\096\093\051\005\071\087\082\030\097\087\123\061\088\030\117\033\092\082")
ztaskExploreCrashSite.Description = ""
ztaskExploreCrashSite.Visible = false
ztaskExploreCrashSite.Media = zmediaTask
ztaskExploreCrashSite.Active = true
ztaskExploreCrashSite.Complete = false
ztaskExploreCrashSite.CorrectState = "None"
ztaskFindAllMissingParts = Wherigo.ZTask(cartAlienCacher)
ztaskFindAllMissingParts.Id = "424817d2-1f63-4d3c-81a6-759724761d4d"
ztaskFindAllMissingParts.Name = _VvPb("\107\033\052\063\030\115\005\005\030\021\033\061\061\033\052\022\030\102\123\087\092\061")
ztaskFindAllMissingParts.Description = ""
ztaskFindAllMissingParts.Visible = false
ztaskFindAllMissingParts.Media = zmediaTask
ztaskFindAllMissingParts.Active = false
ztaskFindAllMissingParts.Complete = false
ztaskFindAllMissingParts.CorrectState = "None"
ztaskFindtheFluxCapacitor = Wherigo.ZTask(cartAlienCacher)
ztaskFindtheFluxCapacitor.Id = "33dc7e15-6e3a-4fff-961a-f4f73eb69149"
ztaskFindtheFluxCapacitor.Name = _VvPb("\107\033\052\063\030\092\088\082\030\107\005\105\093\030\097\123\051\123\112\033\092\071\087")
ztaskFindtheFluxCapacitor.Description = ""
ztaskFindtheFluxCapacitor.Visible = false
ztaskFindtheFluxCapacitor.Media = zmediaTask
ztaskFindtheFluxCapacitor.Active = true
ztaskFindtheFluxCapacitor.Complete = false
ztaskFindtheFluxCapacitor.CorrectState = "None"
ztaskTakeAllPartstoKrang = Wherigo.ZTask(cartAlienCacher)
ztaskTakeAllPartstoKrang.Id = "e063b6b3-0389-4c5b-be0f-079e3b340d89"
ztaskTakeAllPartstoKrang.Name = _VvPb("\028\123\026\082\030\115\005\005\030\102\123\087\092\061\030\092\071\030\002\087\123\052\022")
ztaskTakeAllPartstoKrang.Description = ""
ztaskTakeAllPartstoKrang.Visible = false
ztaskTakeAllPartstoKrang.Media = zmediaTask
ztaskTakeAllPartstoKrang.Active = true
ztaskTakeAllPartstoKrang.Complete = false
ztaskTakeAllPartstoKrang.CorrectState = "None"
ztaskGobacktotheCrashSite = Wherigo.ZTask(cartAlienCacher)
ztaskGobacktotheCrashSite.Id = "e40d7bbe-6f60-4ea4-bd48-51e415001630"
ztaskGobacktotheCrashSite.Name = _VvPb("\059\071\030\100\123\112\026\030\092\071\030\092\088\082\030\097\087\123\061\088\030\117\033\092\082")
ztaskGobacktotheCrashSite.Description = ""
ztaskGobacktotheCrashSite.Visible = false
ztaskGobacktotheCrashSite.Media = zmediaTask
ztaskGobacktotheCrashSite.Active = true
ztaskGobacktotheCrashSite.Complete = false
ztaskGobacktotheCrashSite.CorrectState = "None"
ztaskRadiotheOrbitingSpacecraft = Wherigo.ZTask(cartAlienCacher)
ztaskRadiotheOrbitingSpacecraft.Id = "283e68b2-f3ab-4bef-8254-64751abfa540"
ztaskRadiotheOrbitingSpacecraft.Name = _VvPb("\053\123\063\033\071\030\092\088\082\030\006\087\100\033\092\033\052\022\030\117\051\123\112\082\112\087\123\081\092\030")
ztaskRadiotheOrbitingSpacecraft.Description = ""
ztaskRadiotheOrbitingSpacecraft.Visible = false
ztaskRadiotheOrbitingSpacecraft.Media = zmediaTask
ztaskRadiotheOrbitingSpacecraft.Active = true
ztaskRadiotheOrbitingSpacecraft.Complete = false
ztaskRadiotheOrbitingSpacecraft.CorrectState = "None"
ztaskFindMysteryNumber = Wherigo.ZTask(cartAlienCacher)
ztaskFindMysteryNumber.Id = "f454370f-adc8-48ac-b603-ca0065d745e0"
ztaskFindMysteryNumber.Name = _VvPb("\107\033\052\063\030\021\070\061\092\082\087\070\030\103\105\016\100\082\087")
ztaskFindMysteryNumber.Description = ""
ztaskFindMysteryNumber.Visible = false
ztaskFindMysteryNumber.Media = zmediaTask
ztaskFindMysteryNumber.Active = true
ztaskFindMysteryNumber.Complete = false
ztaskFindMysteryNumber.CorrectState = "None"
ztaskFindMysteryNumber2 = Wherigo.ZTask(cartAlienCacher)
ztaskFindMysteryNumber2.Id = "d767fcd8-0801-4725-8672-5afc4210cfd6"
ztaskFindMysteryNumber2.Name = _VvPb("\107\033\052\063\030\021\070\061\092\082\087\070\030\103\105\016\100\082\087\030\050")
ztaskFindMysteryNumber2.Description = ""
ztaskFindMysteryNumber2.Visible = false
ztaskFindMysteryNumber2.Media = zmediaTask
ztaskFindMysteryNumber2.Active = true
ztaskFindMysteryNumber2.Complete = false
ztaskFindMysteryNumber2.CorrectState = "None"
ztaskGoFindTheGeocache = Wherigo.ZTask(cartAlienCacher)
ztaskGoFindTheGeocache.Id = "387a1e4e-fe24-468b-892d-bafb0b9e761e"
ztaskGoFindTheGeocache.Name = _VvPb("\059\071\030\107\033\052\063\030\028\088\082\030\059\082\071\112\123\112\088\082")
ztaskGoFindTheGeocache.Description = ""
ztaskGoFindTheGeocache.Visible = false
ztaskGoFindTheGeocache.Media = zmediaTask
ztaskGoFindTheGeocache.Active = true
ztaskGoFindTheGeocache.Complete = false
ztaskGoFindTheGeocache.CorrectState = "None"

-- Cartridge Variables --
Emulator = _VvPb("\019\082\061\026\092\071\051")
MysteryNumber = false
ShipinOrbit = false
Code = 1954
PlayerInput = 0
SunglassesOn = false
FluxCapacitorZone = false
Code2 = 1993
DeviceID = ""
CrashZone = false
MysteryNumber2 = false
NumberParts = 0
Hands = false
GlovesOn = false
CrashZoneReturn = false
Input2 = 0
_XRB = _VvPb("\023\071\052\082\102\123\087\026\033\052\022")
_6cg3E = _VvPb("\023\112\088\123\087\123\112\092\082\087\115\005\033\082\052\059\082\071\112\123\112\088\082\087")
_eoUQ = _VvPb("\023\033\092\082\016\058\071\105\087\097\123\087")
_opE = _VvPb("\023\092\123\061\026\097\088\082\112\026\058\071\105\087\021\123\051")
_qM3Xx = _VvPb("\023\033\052\051\105\092\021\070\061\092\082\087\070\097\071\063\082")
_Waht = _VvPb("\063\105\016\016\070")
cartAlienCacher.ZVariables = {
	Emulator = _VvPb("\019\082\061\026\092\071\051"), 
	MysteryNumber = false, 
	ShipinOrbit = false, 
	Code = 1954, 
	PlayerInput = 0, 
	SunglassesOn = false, 
	FluxCapacitorZone = false, 
	Code2 = 1993, 
	DeviceID = "", 
	CrashZone = false, 
	MysteryNumber2 = false, 
	NumberParts = 0, 
	Hands = false, 
	GlovesOn = false, 
	CrashZoneReturn = false, 
	Input2 = 0, 
	_XRB = _VvPb("\023\071\052\082\102\123\087\026\033\052\022"), 
	_6cg3E = _VvPb("\023\112\088\123\087\123\112\092\082\087\115\005\033\082\052\059\082\071\112\123\112\088\082\087"), 
	_eoUQ = _VvPb("\023\033\092\082\016\058\071\105\087\097\123\087"), 
	_opE = _VvPb("\023\092\123\061\026\097\088\082\112\026\058\071\105\087\021\123\051"), 
	_qM3Xx = _VvPb("\023\033\052\051\105\092\021\070\061\092\082\087\070\097\071\063\082"), 
	_Waht = _VvPb("\063\105\016\016\070")
}

-- Timers --

-- Inputs --
zinputMysteryCode = Wherigo.ZInput(cartAlienCacher)
zinputMysteryCode.Id = "0ec8d229-352d-46e7-9e44-df4a96b57013"
zinputMysteryCode.Name = _VvPb("\021\070\061\092\082\087\070\030\097\071\063\082")
zinputMysteryCode.Description = ""
zinputMysteryCode.Visible = true
zinputMysteryCode.InputType = "Text"
zinputMysteryCode.Text = _VvPb("\096\052\092\082\087\030\092\088\082\030\021\070\061\092\082\087\070\030\097\071\063\082\108")
zinputMysteryCode2 = Wherigo.ZInput(cartAlienCacher)
zinputMysteryCode2.Id = "fd51ceda-b941-4446-9320-88e6b88f8e6a"
zinputMysteryCode2.Name = _VvPb("\021\070\061\092\082\087\070\030\097\071\063\082\030\050")
zinputMysteryCode2.Description = ""
zinputMysteryCode2.Visible = true
zinputMysteryCode2.InputType = "Text"
zinputMysteryCode2.Text = _VvPb("\096\052\092\082\087\030\092\088\082\030\016\070\061\092\082\087\070\030\112\071\063\082\108")

-- WorksWithList for object commands --

-- functions --
function cartAlienCacher:OnStart()
	DeviceID = Env.DeviceID
end
function cartAlienCacher:OnRestore()
end
function zoneCrashSite:OnEnter()
	_XRB = _VvPb("\023\071\052\082\097\087\123\061\088\117\033\092\082")
	cartAlienCacher:RequestSync()
	Wherigo.Command "Alert"
	ztaskCheckYourMap.Visible = false
	CrashZone = true
	if CrashZoneReturn == false then
		_Urwigo.MessageBox{
			Text = _VvPb("\058\071\105\030\088\123\109\082\030\087\082\123\112\088\082\063\030\092\088\082\030\112\087\123\061\088\030\061\033\092\082\048\030\058\071\105\030\092\123\026\082\030\123\030\109\082\087\070\030\112\123\087\082\081\105\005\005\030\005\071\071\026\030\123\087\071\105\052\063\048\030\115\030\061\092\087\123\052\022\082\030\061\016\082\005\005\030\081\033\005\005\061\030\092\088\082\030\123\033\087\048"), 
			Media = zmediaMap, 
			Callback = function(action)
				if action ~= nil then
					Wherigo.ShowScreen(Wherigo.MAINSCREEN)
				end
			end
		}
		CrashZoneReturn = true
	else
		_Urwigo.MessageBox{
			Text = _VvPb("\058\071\105\030\123\087\082\030\123\092\030\092\088\082\030\115\005\033\082\052\030\117\051\123\112\082\061\088\033\051\030\112\087\123\061\088\030\061\033\092\082\048"), 
			Media = zmediaMap, 
			Callback = function(action)
				if action ~= nil then
					Wherigo.ShowScreen(Wherigo.MAINSCREEN)
				end
			end
		}
	end
end
function zoneCrashSite:OnExit()
	_XRB = _VvPb("\023\071\052\082\097\087\123\061\088\117\033\092\082")
	CrashZone = false
end
function zoneShipPart1:OnEnter()
	_XRB = _VvPb("\023\071\052\082\117\088\033\051\102\123\087\092\001")
	cartAlienCacher:RequestSync()
	Wherigo.Command "Alert"
	_Urwigo.MessageBox{
		Text = _VvPb("\058\071\105\030\088\123\109\082\030\087\082\123\112\088\082\063\030\092\088\082\030\123\087\082\123\030\062\088\082\087\082\030\071\052\082\030\071\081\030\092\088\082\030\005\071\061\092\030\051\123\087\092\061\030\033\061\030\061\105\051\051\071\061\082\063\030\092\071\030\100\082\048\030\046\082\092\025\061\030\088\123\109\082\030\123\030\005\071\071\026\030\123\087\071\105\052\063\048"), 
		Media = zmediaMap, 
		Callback = function(action)
			if action ~= nil then
				Wherigo.ShowScreen(Wherigo.MAINSCREEN)
			end
		end
	}
end
function zoneShipPart2:OnEnter()
	_XRB = _VvPb("\023\071\052\082\117\088\033\051\102\123\087\092\050")
	cartAlienCacher:RequestSync()
	Wherigo.Command "Alert"
	_Urwigo.MessageBox{
		Text = _VvPb("\058\071\105\030\088\123\109\082\030\087\082\123\112\088\082\063\030\092\088\082\030\123\087\082\123\030\062\088\082\087\082\030\071\052\082\030\071\081\030\092\088\082\030\005\071\061\092\030\051\123\087\092\061\030\033\061\030\061\105\051\051\071\061\082\063\030\092\071\030\100\082\048\030\046\082\092\025\061\030\088\123\109\082\030\123\030\005\071\071\026\030\123\087\071\105\052\063\048"), 
		Media = zmediaMap, 
		Callback = function(action)
			if action ~= nil then
				Wherigo.ShowScreen(Wherigo.MAINSCREEN)
			end
		end
	}
end
function zoneShipPart3:OnEnter()
	_XRB = _VvPb("\023\071\052\082\117\088\033\051\102\123\087\092\106")
	cartAlienCacher:RequestSync()
	Wherigo.Command "Alert"
	_Urwigo.MessageBox{
		Text = _VvPb("\058\071\105\030\088\123\109\082\030\087\082\123\112\088\082\063\030\092\088\082\030\123\087\082\123\030\062\088\082\087\082\030\071\052\082\030\071\081\030\092\088\082\030\005\071\061\092\030\051\123\087\092\061\030\033\061\030\061\105\051\051\071\061\082\063\030\092\071\030\100\082\048\030\046\082\092\025\061\030\088\123\109\082\030\123\030\005\071\071\026\030\123\087\071\105\052\063\048"), 
		Media = zmediaMap, 
		Callback = function(action)
			if action ~= nil then
				Wherigo.ShowScreen(Wherigo.MAINSCREEN)
			end
		end
	}
end
function zoneFluxCapacitor:OnEnter()
	_XRB = _VvPb("\023\071\052\082\107\005\105\093\097\123\051\123\112\033\092\071\087")
	cartAlienCacher:RequestSync()
	Wherigo.Command "Alert"
	_Urwigo.MessageBox{
		Text = _VvPb("\115\087\071\105\052\063\030\088\082\087\082\030\070\071\105\030\112\123\052\030\081\033\052\063\030\092\088\082\030\107\005\105\093\030\097\123\051\123\112\033\092\071\087\048"), 
		Media = zmediaMap, 
		Callback = function(action)
			if action ~= nil then
				Wherigo.ShowScreen(Wherigo.MAINSCREEN)
			end
		end
	}
	FluxCapacitorZone = true
end
function zoneFluxCapacitor:OnExit()
	_XRB = _VvPb("\023\071\052\082\107\005\105\093\097\123\051\123\112\033\092\071\087")
	FluxCapacitorZone = false
end
function zoneMysteryNumber:OnEnter()
	_XRB = _VvPb("\023\071\052\082\021\070\061\092\082\087\070\103\105\016\100\082\087")
	cartAlienCacher:RequestSync()
	Wherigo.Command "Alert"
	MysteryNumber = true
	zitemOrbitingSpacecraft:MoveTo(zoneMysteryNumber)
	_Urwigo.MessageBox{
		Text = _VvPb("\046\071\071\026\030\123\087\071\105\052\063\048\048\048\030\117\071\016\082\062\088\082\087\082\030\070\071\105\030\061\088\071\105\005\063\030\061\082\082\030\123\030\081\071\105\087\030\063\033\022\033\092\030\052\105\016\100\082\087\048\048\048"), 
		Media = zmediaMap, 
		Callback = function(action)
			if action ~= nil then
				Wherigo.ShowScreen(Wherigo.MAINSCREEN)
			end
		end
	}
end
function zoneGeocache:OnEnter()
	_XRB = _VvPb("\023\071\052\082\059\082\071\112\123\112\088\082")
	cartAlienCacher:RequestSync()
	Wherigo.Command "Alert"
	zitemSpoiler.Visible = true
	zitemCompletionCode.Visible = true
	zitemSpoiler:MoveTo(Player)
	zitemCompletionCode:MoveTo(Player)
	_Urwigo.MessageBox{
		Text = _VvPb("\058\071\105\030\123\087\082\030\109\082\087\070\030\052\082\123\087\048\030\115\030\117\051\071\033\005\082\087\030\051\033\112\092\105\087\082\030\112\123\052\030\100\082\030\081\071\105\052\063\030\033\052\030\070\071\105\087\030\033\052\109\082\052\092\071\087\070\048"), 
		Media = zmediaMap, 
		Callback = function(action)
			if action ~= nil then
				Wherigo.ShowScreen(Wherigo.MAINSCREEN)
			end
		end
	}
end
function zoneMysteryNumber2:OnEnter()
	_XRB = _VvPb("\023\071\052\082\021\070\061\092\082\087\070\103\105\016\100\082\087\050")
	cartAlienCacher:RequestSync()
	Wherigo.Command "Alert"
	zitemOrbitingSpacecraft:MoveTo(zoneMysteryNumber2)
	MysteryNumber2 = true
	_Urwigo.MessageBox{
		Text = _VvPb("\046\071\071\026\030\123\087\071\105\052\063\048\048\048\030\117\071\016\082\062\088\082\087\082\030\070\071\105\030\061\088\071\105\005\063\030\061\082\082\030\123\030\081\071\105\087\030\063\033\022\033\092\030\052\105\016\100\082\087\048\048\048"), 
		Media = zmediaMap, 
		Callback = function(action)
			if action ~= nil then
				Wherigo.ShowScreen(Wherigo.MAINSCREEN)
			end
		end
	}
end
function ztaskCheckYourMap:OnClick()
	_Urwigo.MessageBox{
		Text = _VvPb("\058\071\105\030\092\123\026\082\030\071\105\092\030\070\071\105\087\030\016\123\051\030\071\081\030\092\088\082\030\123\087\082\123\030\123\052\063\030\082\093\051\005\071\087\082\030\033\092\030\092\071\030\081\033\052\063\030\092\088\082\030\061\088\071\087\092\082\061\092\030\062\123\070\030\092\071\030\070\071\105\087\030\022\071\123\005\030\081\071\087\030\092\071\063\123\070\048\030\117\105\063\063\082\052\005\070\030\070\071\105\030\088\082\123\087\030\123\030\061\092\087\123\052\022\082\030\052\071\033\061\082\030\071\109\082\087\088\082\123\063\076\030\123\030\100\087\033\022\088\092\030\005\033\022\088\092\030\081\005\123\061\088\082\061\030\123\052\063\030\061\071\016\082\092\088\033\052\022\030\105\052\105\061\105\123\005\030\112\087\123\061\088\082\061\030\033\052\092\071\030\092\088\082\030\052\082\123\087\100\070\030\100\105\061\088\082\061\048"), 
		Media = zmediaMap, 
		Callback = function(action)
			if action ~= nil then
				ztaskCheckYourMap.Complete = true
				ztaskCheckYourMap.Visible = false
				Wherigo.ShowScreen(Wherigo.MAINSCREEN)
			end
		end
	}
	ztaskExploreCrashSite.Visible = true
	if (Player:Contains(zitemGloves) and Player:Contains(zitemWalkieTalkie)) and Player:Contains(zitemSunglasses) then
		zoneParking.Visible = false
		zoneParking.Active = false
		zitemYourCar.Visible = false
	end
end
function ztaskExploreCrashSite:OnClick()
	zoneCrashSite.Active = true
	zoneCrashSite.Visible = true
	_Urwigo.MessageBox{
		Text = _VvPb("\058\071\105\030\123\087\082\030\112\105\087\033\071\105\061\030\062\088\123\092\030\088\123\051\051\082\052\082\063\030\123\052\063\030\063\082\112\033\063\082\030\092\071\030\022\071\030\123\052\063\030\092\123\026\082\030\123\030\112\005\071\061\082\087\030\005\071\071\026"), 
		Media = zmediaTask, 
		Callback = function(action)
			if action ~= nil then
				Wherigo.ShowScreen(Wherigo.MAINSCREEN)
			end
		end
	}
	ztaskCheckYourMap.Visible = false
end
function ztaskFindAllMissingParts:OnClick()
	if NumberParts == 0 then
		ztaskExploreCrashSite.Visible = false
		zcharacterAlienGeocacher.Visible = false
		zoneShipPart1.Active = true
		zoneShipPart1.Visible = true
		zoneShipPart2.Active = true
		zoneShipPart2.Visible = true
		zoneShipPart3.Active = true
		zoneShipPart3.Visible = true
		_Urwigo.MessageBox{
			Text = _VvPb("\046\082\092\025\061\030\022\082\092\030\092\071\030\062\071\087\026\018\030\073\082\025\005\005\030\081\033\052\063\030\092\088\071\061\082\030\016\033\061\061\033\052\022\030\051\123\087\092\061\030\033\052\030\052\071\030\092\033\016\082\018"), 
			Media = zmediaGeocacher, 
			Callback = function(action)
				if action ~= nil then
					Wherigo.ShowScreen(Wherigo.MAINSCREEN)
				end
			end
		}
	end
end
function ztaskFindtheFluxCapacitor:OnClick()
	zoneFluxCapacitor.Active = true
	zoneFluxCapacitor.Visible = true
	_Urwigo.MessageBox{
		Text = _VvPb("\115\005\005\030\087\033\022\088\092\018\030\046\082\092\025\061\030\022\071\030\123\052\063\030\081\033\052\063\030\092\088\082\030\107\005\105\093\030\097\123\051\123\112\033\092\071\087\048"), 
		Media = zmediaTask, 
		Callback = function(action)
			if action ~= nil then
				Wherigo.ShowScreen(Wherigo.MAINSCREEN)
			end
		end
	}
end
function ztaskTakeAllPartstoKrang:OnClick()
	zcharacterKrang.Visible = true
	_Urwigo.MessageBox{
		Text = _VvPb("\058\071\105\030\088\123\109\082\030\081\071\105\052\063\030\123\005\005\030\092\088\087\082\082\030\016\033\061\061\033\052\022\030\051\123\087\092\061\048\030\028\123\026\082\030\092\088\082\016\030\092\071\030\002\087\123\052\022\048"), 
		Media = zmediaTask, 
		Callback = function(action)
			if action ~= nil then
				Wherigo.ShowScreen(Wherigo.MAINSCREEN)
			end
		end
	}
end
function ztaskGobacktotheCrashSite:OnClick()
	_Urwigo.MessageBox{
		Text = _VvPb("\059\071\030\100\123\112\026\030\092\071\030\092\088\082\030\112\087\123\061\088\030\061\033\092\082\030\123\052\063\030\063\082\005\033\109\082\087\030\092\088\082\030\107\005\105\093\030\097\123\051\123\112\033\092\071\087\048"), 
		Media = zmediaTask, 
		Callback = function(action)
			if action ~= nil then
				Wherigo.ShowScreen(Wherigo.MAINSCREEN)
			end
		end
	}
	zcharacterKrang.Visible = false
	zcharacterKrath.Visible = true
end
function ztaskRadiotheOrbitingSpacecraft:OnClick()
	_Urwigo.MessageBox{
		Text = _VvPb("\019\033\063\030\070\071\105\030\022\082\092\030\070\071\105\087\030\087\123\063\033\071\030\081\087\071\016\030\070\071\105\087\030\112\123\087\044\030\114\061\082\030\033\092\030\092\071\030\112\123\005\005\030\092\088\082\030\115\005\033\082\052\030\117\051\123\112\082\061\088\033\051\030\033\052\030\071\087\100\033\092\030\081\071\087\030\081\105\087\092\088\082\087\030\033\052\061\092\087\105\112\092\033\071\052\061\048"), 
		Media = zmediaTask, 
		Callback = function(action)
			if action ~= nil then
				Wherigo.ShowScreen(Wherigo.INVENTORYSCREEN)
			end
		end
	}
end
function ztaskFindMysteryNumber:OnClick()
	zoneMysteryNumber.Active = true
	zoneMysteryNumber.Visible = true
	_Urwigo.MessageBox{
		Text = _VvPb("\059\071\030\092\071\030\092\088\082\030\022\033\109\082\052\030\112\071\071\087\063\033\052\123\092\082\061\030\123\052\063\030\081\033\052\063\030\071\105\092\030\062\088\123\092\030\092\088\082\030\016\070\061\092\082\087\070\030\081\071\105\087\030\063\033\022\033\092\030\052\105\016\100\082\087\030\033\061\048"), 
		Media = zmediaMap, 
		Callback = function(action)
			if action ~= nil then
				Wherigo.ShowScreen(Wherigo.MAINSCREEN)
			end
		end
	}
end
function ztaskFindMysteryNumber2:OnClick()
	zoneMysteryNumber2.Active = true
	zoneMysteryNumber2.Visible = true
	_Urwigo.MessageBox{
		Text = _VvPb("\059\071\030\092\071\030\092\088\082\030\022\033\109\082\052\030\005\071\112\123\092\033\071\052\030\123\052\063\030\087\082\092\087\033\082\109\082\030\092\088\082\030\061\082\112\071\052\063\030\016\070\061\092\082\087\070\030\052\105\016\100\082\087\048"), 
		Media = zmediaTask, 
		Callback = function(action)
			if action ~= nil then
				Wherigo.ShowScreen(Wherigo.MAINSCREEN)
			end
		end
	}
end
function ztaskGoFindTheGeocache:OnClick()
	zoneMysteryNumber2.Visible = false
	zoneMysteryNumber2.Active = false
	zoneGeocache.Active = true
	zoneGeocache.Visible = true
	ztaskFindMysteryNumber2.Visible = false
	ztaskFindMysteryNumber2.Complete = true
	_Urwigo.MessageBox{
		Text = _VvPb("\059\071\030\022\082\092\030\092\088\033\061\030\059\082\071\112\123\112\088\082\018\018\018"), 
		Media = zmediaMap, 
		Callback = function(action)
			if action ~= nil then
				Wherigo.ShowScreen(Wherigo.MAINSCREEN)
			end
		end
	}
end
function zinputMysteryCode:OnGetInput(input)
	if input == nil then
		input = ""
	end
	PlayerInput = tonumber(input)
	if Code == PlayerInput then
		zoneParking.Active = false
		zoneCrashSite.Active = false
		zoneMysteryNumber.Active = false
		zoneParking.Visible = false
		zoneCrashSite.Visible = false
		zoneMysteryNumber.Visible = false
		ztaskFindMysteryNumber.Visible = false
		ztaskFindMysteryNumber.Complete = true
		_Urwigo.MessageBox{
			Text = _VvPb("\073\071\062\018\018\018\030\072\092\030\033\061\030\063\071\105\100\005\082\030\112\071\063\082\063\018\030\072\030\062\033\005\005\030\052\082\082\063\030\123\030\061\082\112\071\052\063\030\016\070\061\092\082\087\070\030\112\071\063\082\030\092\071\030\100\087\082\123\026\030\092\088\033\061\030\112\070\051\088\082\087\018\030\059\071\071\063\030\092\088\033\052\022\030\072\030\026\052\071\062\030\062\088\082\087\082\030\070\071\105\030\112\123\052\030\081\033\052\063\030\033\092\018\030\072\030\123\016\030\105\051\005\071\123\063\033\052\022\030\092\088\082\030\112\071\071\087\063\033\052\123\092\082\061\030\092\071\030\070\071\105\087\030\063\082\109\033\112\082\018\030\059\071\030\081\033\052\063\030\092\088\082\030\061\082\112\071\052\063\030\016\070\061\092\082\087\070\030\052\105\016\100\082\087\018\030\073\088\082\052\030\070\071\105\030\081\033\052\063\030\092\088\082\030\112\071\063\082\030\112\123\005\005\030\016\082\030\100\123\112\026\018"), 
			Media = zmediaSpaceCraftinOrbit, 
			Callback = function(action)
				if action ~= nil then
					ztaskFindMysteryNumber2.Active = true
					ztaskFindMysteryNumber2.Visible = true
					Wherigo.ShowScreen(Wherigo.MAINSCREEN)
				end
			end
		}
	else
		_Urwigo.MessageBox{
			Text = _VvPb("\103\006\018\030\028\066\072\117\030\103\114\021\064\096\053\030\072\117\030\103\006\028\030\097\006\053\053\096\097\028\018\030\028\053\058\030\115\059\115\072\103\018"), 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.RunDialogs(function()
						Wherigo.GetInput(zinputMysteryCode)
					end)
				end
			end
		}
	end
end
function zinputMysteryCode2:OnGetInput(input)
	if input == nil then
		input = ""
	end
	Input2 = tonumber(input)
	if Code2 == Input2 then
		zitemGeocacheCoordinates.Visible = true
		zitemGeocacheCoordinates:MoveTo(Player)
		ztaskFindMysteryNumber2.Visible = false
		ztaskFindMysteryNumber2.Complete = true
		ztaskGoFindTheGeocache.Active = true
		ztaskGoFindTheGeocache.Visible = true
		_Urwigo.MessageBox{
			Text = _VvPb("\058\105\051\082\082\018\018\018\030\072\092\030\062\071\087\026\082\063\018\030\028\088\082\030\051\105\023\023\005\082\030\033\061\030\061\071\005\109\082\063\018\030\072\030\123\016\030\105\051\005\071\123\063\033\052\022\030\092\088\082\030\081\033\052\123\005\030\112\071\071\087\063\033\052\123\092\082\061\030\092\071\030\070\071\105\087\030\063\082\109\033\112\082\018\030\097\088\082\112\026\030\070\071\105\087\030\033\052\109\082\052\092\071\087\070\018\030\059\071\071\063\030\005\105\112\026\030\096\123\087\092\088\005\033\052\022\018"), 
			Media = zmediaSpaceCraftinOrbit, 
			Callback = function(action)
				if action ~= nil then
					Wherigo.ShowScreen(Wherigo.MAINSCREEN)
				end
			end
		}
	else
		_Urwigo.MessageBox{
			Text = _VvPb("\103\006\018\030\028\066\072\117\030\103\114\021\064\096\053\030\072\117\030\103\006\028\030\097\006\053\053\096\097\028\018\030\028\053\058\030\115\059\115\072\103\018"), 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.RunDialogs(function()
						Wherigo.GetInput(zinputMysteryCode2)
					end)
				end
			end
		}
	end
end
function zcharacterAlienGeocacher:OnClick()
	ztaskExploreCrashSite.Complete = true
	ztaskExploreCrashSite.Visible = false
	ztaskFindAllMissingParts.Active = true
	ztaskFindAllMissingParts.Visible = true
	_Urwigo.Dialog(false, {
		{
			Text = _VvPb("\066\082\005\005\071\030\096\123\087\092\088\005\033\052\022\018\030\072\030\123\016\030\002\087\123\092\088\030\081\087\071\016\030\092\088\082\030\115\112\088\082\087\071\052\030\117\070\061\092\082\016\018\030\072\030\112\071\016\082\030\033\052\030\051\082\123\112\082\048\048\048"), 
			Media = zmediaAlienGeocacher
		}, 
		{
			Text = _VvPb("\066\088\088\082\005\005\071\018\030\072\025\016\048\048\048\030\072\030\123\016\030\123\030\022\082\071\112\123\112\088\082\087\048\048\048\030\072\048\048\048\030\072\048\048\048"), 
			Media = zmediaGeocacher
		}, 
		{
			Text = _VvPb("\072\030\112\123\052\030\061\082\082\030\092\088\123\092\018\030\074\030\002\087\123\092\088\030\005\123\105\022\088\082\063\048\090\064\053\039\074\030\072\030\123\016\030\123\030\022\082\071\112\123\088\082\087\030\016\070\061\082\005\081\018\030\115\005\123\061\030\052\071\092\030\092\071\071\030\005\105\112\026\070\030\092\071\063\123\070\048"), 
			Media = zmediaAlienGeocacher
		}, 
		{
			Text = _VvPb("\073\088\070\030\062\088\123\092\030\088\123\051\051\082\052\082\063\044"), 
			Media = zmediaGeocacher
		}, 
		{
			Text = _VvPb("\021\070\030\081\087\033\082\052\063\030\088\082\087\082\030\074\030\002\087\123\052\022\030\033\061\030\123\030\109\082\087\070\030\022\071\071\063\030\016\082\112\088\123\052\033\112\030\100\105\092\030\123\030\005\071\105\061\070\030\051\033\005\071\092\048\048\048\030\021\123\070\100\082\030\092\088\123\092\025\061\030\062\088\070\030\088\082\030\033\061\030\061\105\112\088\030\123\030\022\071\071\063\030\016\082\112\088\123\052\033\112\030\123\081\092\082\087\030\123\005\005\048\048\048\030\072\052\030\061\088\071\087\092\030\092\071\063\123\070\030\088\082\030\112\087\123\061\088\082\063\030\033\052\092\071\030\092\088\082\030\092\087\082\082\061\030\123\022\123\033\052\030\123\052\063\030\062\082\030\005\071\061\092\030\061\071\016\082\030\051\123\087\092\061\030\071\081\030\071\105\087\030\061\088\033\051\048\030\103\071\062\030\062\082\030\052\082\082\063\030\092\071\030\061\082\123\087\112\088\030\081\071\087\030\092\088\082\016\048\030\073\033\005\005\030\070\071\105\030\088\082\005\051\030\105\061\044"), 
			Media = zmediaAlienGeocacher
		}, 
		{
			Text = _VvPb("\117\105\087\082\030\072\030\062\033\005\005\018\030\064\105\092\030\092\088\082\030\051\123\087\026\030\033\061\030\088\105\022\082\030\088\071\062\030\112\123\052\030\062\082\030\081\033\052\063\030\092\088\071\061\082\030\051\123\087\092\061\044"), 
			Media = zmediaGeocacher
		}, 
		{
			Text = _VvPb("\072\030\088\123\109\082\030\123\052\030\033\063\082\123\030\062\088\082\087\082\030\092\088\082\070\030\016\033\022\088\092\030\100\082\048\048\048\030\059\033\109\082\030\016\082\030\070\071\105\087\030\016\123\051\030\072\030\062\033\005\005\030\051\071\033\052\092\030\092\088\082\030\112\071\071\087\063\033\052\123\092\082\061\030\092\071\030\070\071\105\048\030"), 
			Media = zmediaAlienGeocacher
		}, 
		{
			Text = _VvPb("\073\082\005\005\030\092\088\123\092\025\061\030\123\030\051\033\082\112\082\030\071\081\030\112\123\026\082\018\030\058\071\105\030\061\092\123\070\030\088\033\063\063\082\052\030\088\082\087\082\018\030\103\071\030\016\105\022\022\005\082\030\061\088\071\105\005\063\030\061\082\082\030\070\071\105\018\030\072\030\062\033\005\005\030\087\105\052\030\121\105\033\112\026\005\070\030\123\052\063\030\081\082\092\112\088\030\092\088\082\030\051\123\087\092\061\030\081\071\087\030\070\071\105\018\018\018"), 
			Media = zmediaGeocacher
		}
	}, function(action)
		Wherigo.ShowScreen(Wherigo.MAINSCREEN)
	end)
end
function zcharacterKrang:OnClick()
	if ((not zcharacterKrang:Contains(zitemSpaceShipPart1)) or (not zcharacterKrang:Contains(zitemSpaceShipPart2))) or (not zcharacterKrang:Contains(zitemSpaceShipPart3)) then
		_Urwigo.MessageBox{
			Text = _VvPb("\019\033\063\030\070\071\105\030\081\033\052\063\030\123\005\005\030\092\088\087\082\082\030\016\033\061\061\033\052\022\030\051\123\087\092\061\044\030\059\033\109\082\030\092\088\082\016\030\092\071\030\016\082\018"), 
			Media = zmediaAlienMechanic, 
			Callback = function(action)
				if action ~= nil then
					Wherigo.ShowScreen(Wherigo.INVENTORYSCREEN)
				end
			end
		}
	else
		zitemAlienMultiTool.Visible = true
		ztaskTakeAllPartstoKrang.Visible = false
		ztaskTakeAllPartstoKrang.Complete = true
		ztaskFindtheFluxCapacitor.Visible = true
		_Urwigo.Dialog(false, {
			{
				Text = _VvPb("\058\071\105\025\109\082\030\063\071\052\082\030\123\030\022\087\082\123\092\030\004\071\100\018\030\006\052\005\070\048\048\048\030\092\088\082\087\082\030\033\061\030\123\052\071\092\088\082\087\030\051\087\071\100\005\082\016\048\030\073\082\030\123\087\082\030\016\033\061\061\033\052\022\030\071\105\087\030\107\005\105\093\030\097\123\051\123\112\033\092\071\087\048\030\028\088\082\030\022\071\071\063\030\052\082\062\061\030\033\061\030\072\030\033\052\092\082\087\112\082\051\092\082\063\030\033\092\061\030\112\071\071\087\063\033\052\123\092\082\061\048\030\073\033\005\005\030\070\071\105\030\022\082\092\030\033\092\030\081\071\087\030\016\082\044"), 
				Media = zmediaAlienMechanic
			}, 
			{
				Text = _VvPb("\064\105\092\030\071\081\030\112\071\105\087\061\082\018\030\059\033\109\082\030\016\082\030\092\088\082\030\112\071\071\087\063\033\052\123\092\082\061\018"), 
				Media = zmediaGeocacher
			}, 
			{
				Text = _VvPb("\066\082\087\082\048\048\048\030\064\105\092\030\062\123\033\092\030\123\030\016\033\052\105\092\082\018\030\072\081\030\092\088\082\030\107\005\105\093\030\097\123\051\123\112\033\092\071\087\030\033\061\030\061\092\033\005\005\030\071\051\082\087\123\092\033\071\052\123\005\030\033\092\030\016\033\022\088\092\030\100\082\030\063\123\052\022\082\087\071\105\061\030\092\071\030\088\123\052\063\005\082\048\030\058\071\105\030\062\033\005\005\030\088\123\109\082\030\092\071\030\063\033\061\082\052\022\123\022\082\030\033\092\030\081\033\087\061\092\018\018\018"), 
				Media = zmediaAlienMechanic
			}, 
			{
				Text = _VvPb("\066\071\062\030\063\071\030\072\030\063\071\030\092\088\123\092\044"), 
				Media = zmediaGeocacher
			}, 
			{
				Text = _VvPb("\028\123\026\082\030\016\070\030\061\051\082\112\033\123\005\030\092\071\071\005\030\123\052\063\030\105\061\082\030\033\092\030\092\071\030\063\033\061\082\052\022\123\022\082\030\092\088\082\030\107\005\105\093\030\097\123\051\123\112\033\092\071\087\048"), 
				Media = zmediaAlienMechanic
			}
		}, function(action)
			Wherigo.ShowScreen(Wherigo.MAINSCREEN)
		end)
	end
end
function zcharacterKrath:OnClick()
	if not zcharacterKrath:Contains(zitemDisabledFluxCapacitor) then
		_Urwigo.MessageBox{
			Text = _VvPb("\021\070\030\016\082\112\088\123\052\033\112\030\033\061\030\123\005\005\016\071\061\092\030\087\082\123\063\070\048\030\066\082\030\088\123\061\030\092\071\030\081\033\093\030\004\105\061\092\030\092\088\082\030\107\005\105\093\030\097\123\051\123\112\033\092\071\087\048\030\019\033\063\030\070\071\105\030\081\033\052\063\030\033\092\044"), 
			Media = zmediaAlienGeocacher, 
			Callback = function(action)
				if action ~= nil then
					Wherigo.ShowScreen(Wherigo.INVENTORYSCREEN)
				end
			end
		}
	else
		ztaskGobacktotheCrashSite.Complete = true
		ztaskGobacktotheCrashSite.Visible = false
		zcharacterKrath.Visible = false
		zitemOrbitingSpacecraft.Visible = true
		zitemOrbitingSpacecraft:MoveTo(zoneCrashSite)
		zitemAlienSWAG.Visible = true
		zitemAlienSWAG:MoveTo(Player)
		ztaskRadiotheOrbitingSpacecraft.Visible = true
		ShipinOrbit = true
		_Urwigo.Dialog(false, {
			{
				Text = _VvPb("\058\071\105\030\088\123\109\082\030\063\071\052\082\030\123\030\022\087\082\123\092\030\004\071\100\076\030\100\105\063\063\070\018\030\072\030\063\071\052\025\092\030\026\052\071\062\030\088\071\062\030\092\071\030\087\082\062\123\087\063\030\070\071\105\030\081\071\087\030\070\071\105\087\030\082\081\081\071\087\092\061\048\048\048"), 
				Media = zmediaAlienGeocacher
			}, 
			{
				Text = _VvPb("\073\082\005\005\076\030\033\092\030\062\123\061\030\052\071\092\088\033\052\022\030\087\082\123\005\005\070\048\030\072\030\123\016\030\022\005\123\063\030\072\030\112\071\105\005\063\030\088\082\005\051\018"), 
				Media = zmediaGeocacher
			}, 
			{
				Text = _VvPb("\073\123\033\092\018\030\072\030\026\052\071\062\030\062\088\123\092\030\092\071\030\063\071\018\030\073\082\030\112\123\016\082\030\088\082\087\082\030\092\071\030\016\123\026\082\030\123\030\107\028\107\030\071\081\030\022\082\071\112\123\112\088\082\048\030\103\071\062\030\092\088\082\030\107\028\107\030\033\061\030\070\071\105\087\061\018\018\018"), 
				Media = zmediaAlienGeocacher
			}, 
			{
				Text = _VvPb("\073\071\062\018\030\028\088\123\052\026\030\070\071\105\030\061\071\030\016\105\112\088\018\030\064\105\092\030\062\088\033\112\088\030\112\123\112\088\082\030\033\061\030\092\088\123\092\044\030\072\030\063\071\052\025\092\030\088\123\109\082\030\033\092\030\071\052\030\016\070\030\016\123\051\018"), 
				Media = zmediaGeocacher
			}, 
			{
				Text = _VvPb("\072\092\030\033\061\030\052\071\092\030\051\105\100\005\033\061\088\082\063\030\070\082\092\030\071\052\030\096\123\087\092\088\025\061\030\022\082\071\112\123\112\088\033\052\022\030\061\033\092\082\048\030\072\030\112\123\052\030\022\033\109\082\030\070\071\105\030\092\088\082\030\112\071\071\087\063\033\052\123\092\082\061\076\030\100\105\092\030\072\030\062\033\005\005\030\052\082\082\063\030\123\030\061\082\112\087\082\092\030\112\071\063\082\048\030\028\071\030\051\087\071\112\082\061\061\030\092\088\082\030\112\071\063\082\030\062\082\030\062\033\005\005\030\088\123\109\082\030\092\071\030\022\071\030\033\052\030\051\005\123\052\082\092\123\087\070\030\071\087\100\033\092\030\123\061\030\062\082\030\088\123\109\082\030\052\071\030\112\071\052\052\082\112\092\033\071\052\030\062\033\092\088\030\071\105\087\030\117\070\061\092\082\016\025\061\030\021\123\033\052\081\087\123\016\082\030\112\071\016\051\105\092\082\087\030\088\082\087\082\048\030\006\002\076\030\052\071\062\030\062\082\030\092\123\026\082\030\071\081\081\030\123\052\063\030\062\082\030\062\033\005\005\030\112\071\016\016\105\052\033\112\123\092\082\030\100\070\030\087\123\063\033\071\048"), 
				Media = zmediaAlienGeocacher
			}, 
			{
				Text = _VvPb("\059\071\071\063\030\100\070\082\030\016\070\030\123\005\033\082\052\030\081\087\033\082\052\063\018\030\066\071\051\082\030\072\025\005\005\030\061\082\082\030\070\071\105\030\123\022\123\033\052\030\061\071\016\082\030\063\123\070\018"), 
				Media = zmediaGeocacher
			}, 
			{
				Text = _VvPb("\066\082\087\082\030\092\123\026\082\030\016\070\030\123\005\033\082\052\030\117\073\115\059\018\030\107\123\087\082\062\082\005\005\030\096\123\087\092\088\005\033\052\022\018"), 
				Media = zmediaAlienGeocacher
			}
		}, function(action)
			Wherigo.ShowScreen(Wherigo.INVENTORYSCREEN)
		end)
	end
end
function zitemYourCar:OnClick()
	zitemGloves.Visible = true
	zitemWalkieTalkie.Visible = true
	zitemSunglasses.Visible = true
	ztaskCheckYourMap.Visible = true
	_Urwigo.MessageBox{
		Text = _VvPb("\058\071\105\087\030\022\071\071\063\030\071\005\063\030\112\123\087\048\030\115\030\092\087\105\061\092\070\030\016\071\100\033\005\033\092\070\030\063\082\109\033\112\082\030\092\071\030\088\082\005\051\030\070\071\105\030\092\087\123\109\082\005\030\033\052\030\061\082\123\087\112\088\030\081\071\087\030\022\082\071\112\123\112\088\082\061\048"), 
		Media = zmediaCar, 
		Buttons = {
			_VvPb("\046\006\006\002\030\072\103\117\072\019\096")
		}, 
		Callback = function(action)
			if action ~= nil then
				Wherigo.ShowScreen(Wherigo.ITEMSCREEN)
			end
		end
	}
end
function zitemGloves:OnClick()
	if not Player:Contains(zitemGloves) then
		_Urwigo.MessageBox{
			Text = _VvPb("\058\071\105\087\030\062\071\087\026\033\052\022\030\022\005\071\109\082\061\048\030\099\082\087\070\030\105\061\082\081\105\005\030\092\071\030\088\123\052\063\005\082\030\061\105\061\051\033\112\033\071\105\061\030\071\100\004\082\112\092\061\048\030\072\087\087\082\051\005\123\112\082\123\100\005\082\030\062\088\082\052\030\063\071\033\052\022\030\097\072\028\006\048"), 
			Media = zmediaGloves, 
			Buttons = {
				_VvPb("\028\115\002\096"), 
				_VvPb("\103\006\028\030\103\006\073")
			}, 
			Callback = function(action)
				if action ~= nil then
					if action == "Button1" then
						zitemGloves:MoveTo(Player)
					elseif action == "Button2" then
					end
				end
			end
		}
	elseif GlovesOn == false then
		_Urwigo.MessageBox{
			Text = _VvPb("\058\071\105\087\030\062\071\087\026\033\052\022\030\022\005\071\109\082\061\048\030\099\082\087\070\030\105\061\082\081\105\005\030\092\071\030\088\123\052\063\005\082\030\061\105\061\051\033\112\033\071\105\061\030\071\100\004\082\112\092\061\048\030\072\087\087\082\051\005\123\112\082\123\100\005\082\030\062\088\082\052\030\063\071\033\052\022\030\097\072\028\006\048"), 
			Media = zmediaGloves, 
			Buttons = {
				_VvPb("\102\114\028\030\006\103"), 
				_VvPb("\103\006\028\030\103\006\073")
			}, 
			Callback = function(action)
				if action ~= nil then
					if action == "Button1" then
						GlovesOn = true
						Wherigo.ShowScreen(Wherigo.MAINSCREEN)
					elseif action == "Button2" then
					end
				end
			end
		}
	else
		_Urwigo.MessageBox{
			Text = _VvPb("\058\071\105\087\030\062\071\087\026\033\052\022\030\022\005\071\109\082\061\048\030\099\082\087\070\030\105\061\082\081\105\005\030\092\071\030\088\123\052\063\005\082\030\061\105\061\051\033\112\033\071\105\061\030\071\100\004\082\112\092\061\048\030\072\087\087\082\051\005\123\112\082\123\100\005\082\030\062\088\082\052\030\063\071\033\052\022\030\097\072\028\006\048"), 
			Media = zmediaGloves, 
			Buttons = {
				_VvPb("\028\115\002\096\030\006\107\107"), 
				_VvPb("\103\006\028\030\103\006\073")
			}, 
			Callback = function(action)
				if action ~= nil then
					if action == "Button1" then
						GlovesOn = false
					elseif action == "Button2" then
					end
				end
			end
		}
	end
end
function zitemWalkieTalkie:OnClick()
	if not Player:Contains(zitemWalkieTalkie) then
		_Urwigo.MessageBox{
			Text = _VvPb("\115\030\051\071\087\092\123\100\005\082\030\087\123\063\033\071\048\030\058\071\105\030\112\123\052\030\105\061\082\030\033\092\030\092\071\030\092\123\005\026\030\092\071\030\071\092\088\082\087\030\087\123\063\033\071\030\071\051\082\087\123\092\071\087\061\048"), 
			Media = zmediaWalkieTalkie, 
			Buttons = {
				_VvPb("\028\115\002\096"), 
				_VvPb("\046\096\115\099\096")
			}, 
			Callback = function(action)
				if action ~= nil then
					if action == "Button1" then
						zitemWalkieTalkie:MoveTo(Player)
					else
						Wherigo.ShowScreen(Wherigo.ITEMSCREEN)
					end
				end
			end
		}
	elseif MysteryNumber2 == true then
		_Urwigo.MessageBox{
			Text = _VvPb("\058\071\105\087\030\051\071\087\092\123\100\005\082\030\087\123\063\033\071\048\030\114\061\082\030\033\092\030\092\071\030\112\071\016\016\105\052\033\112\123\092\082\030\092\071\030\071\092\088\082\087\030\087\123\063\033\071\030\071\051\082\087\123\092\071\087\061\048"), 
			Media = zmediaWalkieTalkie, 
			Buttons = {
				_VvPb("\097\115\046\046\030\002\053\115\028\066"), 
				_VvPb("\103\006\028\030\103\006\073")
			}, 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.MessageBox{
						Text = _VvPb("\019\033\063\030\070\071\105\030\081\033\052\063\030\028\088\082\030\021\070\061\092\082\087\070\030\103\105\016\100\082\087\044"), 
						Media = zmediaSpaceCraftinOrbit, 
						Callback = function(action)
							if action ~= nil then
								_Urwigo.RunDialogs(function()
									Wherigo.GetInput(zinputMysteryCode2)
								end)
							end
						end
					}
				end
			end
		}
	elseif MysteryNumber == true then
		_Urwigo.MessageBox{
			Text = _VvPb("\058\071\105\087\030\051\071\087\092\123\100\005\082\030\087\123\063\033\071\048\030\114\061\082\030\033\092\030\092\071\030\112\071\016\016\105\052\033\112\123\092\082\030\092\071\030\071\092\088\082\087\030\087\123\063\033\071\030\071\051\082\087\123\092\071\087\061\048"), 
			Media = zmediaWalkieTalkie, 
			Buttons = {
				_VvPb("\097\115\046\046\030\002\053\115\028\066"), 
				_VvPb("\103\006\028\030\103\006\073")
			}, 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.MessageBox{
						Text = _VvPb("\019\033\063\030\070\071\105\030\081\033\052\063\030\028\088\082\030\021\070\061\092\082\087\070\030\103\105\016\100\082\087\044"), 
						Media = zmediaSpaceCraftinOrbit, 
						Callback = function(action)
							if action ~= nil then
								_Urwigo.RunDialogs(function()
									Wherigo.GetInput(zinputMysteryCode)
								end)
							end
						end
					}
				end
			end
		}
	elseif ShipinOrbit == true then
		_Urwigo.MessageBox{
			Text = _VvPb("\058\071\105\087\030\051\071\087\092\123\100\005\082\030\087\123\063\033\071\048\030\114\061\082\030\033\092\030\092\071\030\112\071\016\016\105\052\033\112\123\092\082\030\092\071\030\071\092\088\082\087\030\087\123\063\033\071\030\071\051\082\087\123\092\071\087\061\048"), 
			Media = zmediaWalkieTalkie, 
			Buttons = {
				_VvPb("\097\115\046\046\030\002\053\115\028\066"), 
				_VvPb("\103\006\028\030\103\006\073")
			}, 
			Callback = function(action)
				if action ~= nil then
					ztaskFindMysteryNumber.Visible = true
					_Urwigo.Dialog(false, {
						{
							Text = _VvPb("\064\023\023\023\023\092\048\048\048\030\066\071\062\030\063\071\030\070\071\105\030\087\082\123\063\030\016\082\030\096\123\087\092\088\005\033\052\022\044"), 
							Media = zmediaAlienGeocacher
						}, 
						{
							Text = _VvPb("\046\071\105\063\030\123\052\063\030\112\005\082\123\087\018\030\059\071\030\123\088\082\123\063\018"), 
							Media = zmediaGeocacher
						}, 
						{
							Text = _VvPb("\115\005\005\030\087\033\022\088\092\018\030\072\030\123\016\030\105\051\005\071\123\063\033\052\022\030\092\071\030\070\071\105\087\030\063\082\109\033\112\082\030\092\088\082\030\112\071\071\087\063\033\052\123\092\082\061\030\071\081\030\092\088\082\030\051\005\123\112\082\030\062\088\082\087\082\030\070\071\105\030\112\123\052\030\081\033\052\063\030\092\088\082\030\021\070\061\092\082\087\070\030\097\071\063\082\048\030\073\088\082\052\030\070\071\105\030\081\033\052\063\030\092\088\082\030\112\071\063\082\030\112\123\005\005\030\016\082\030\100\123\112\026\018"), 
							Media = zmediaAlienGeocacher
						}
					}, function(action)
						Wherigo.ShowScreen(Wherigo.TASKSCREEN)
					end)
				end
			end
		}
	else
		_Urwigo.MessageBox{
			Text = _VvPb("\058\071\105\087\030\051\071\087\092\123\100\005\082\030\087\123\063\033\071\048\030\114\061\082\030\033\092\030\092\071\030\112\071\016\016\105\052\033\112\123\092\082\030\092\071\030\071\092\088\082\087\030\087\123\063\033\071\030\071\051\082\087\123\092\071\087\061\048"), 
			Media = zmediaWalkieTalkie
		}
	end
end
function zitemSunglasses:OnClick()
	if not Player:Contains(zitemSunglasses) then
		_Urwigo.MessageBox{
			Text = _VvPb("\058\071\105\087\030\061\105\052\022\005\123\061\061\082\061\048\030\073\082\123\087\033\052\022\030\092\088\082\016\030\062\033\005\005\030\051\087\071\092\082\112\092\030\070\071\105\087\030\082\070\082\061\048"), 
			Media = zmediaSunglasses, 
			Buttons = {
				_VvPb("\028\115\002\096"), 
				_VvPb("\103\006\028\030\103\006\073")
			}, 
			Callback = function(action)
				if action ~= nil then
					if action == "Button1" then
						zitemSunglasses:MoveTo(Player)
					elseif action == "Button2" then
					end
				end
			end
		}
		zitemSunglasses:MoveTo(Player)
	elseif SunglassesOn == false then
		_Urwigo.MessageBox{
			Text = _VvPb("\058\071\105\087\030\061\105\052\022\005\123\061\061\082\061\030\051\087\071\092\082\112\092\030\070\071\105\087\030\082\070\082\061\030\081\087\071\016\030\092\088\082\030\100\087\033\022\088\092\030\061\105\052\005\033\022\088\092\048"), 
			Media = zmediaSunglasses, 
			Buttons = {
				_VvPb("\102\114\028\030\006\103"), 
				_VvPb("\103\006\028\030\103\006\073")
			}, 
			Callback = function(action)
				if action ~= nil then
					if action == "Button1" then
						SunglassesOn = true
					elseif action == "Button2" then
					end
				end
			end
		}
	else
		_Urwigo.MessageBox{
			Text = _VvPb("\058\071\105\030\005\071\071\026\030\109\082\087\070\030\112\071\071\005\030\062\033\092\088\030\070\071\105\087\030\061\105\052\022\005\123\061\061\082\061\048\030\115\052\063\030\070\071\105\087\030\082\070\082\061\030\123\087\082\030\051\087\071\092\082\112\092\082\063\048"), 
			Media = zmediaSunglasses, 
			Buttons = {
				_VvPb("\028\115\002\096\030\006\107\107"), 
				_VvPb("\103\006\028\030\103\006\073")
			}, 
			Callback = function(action)
				if action ~= nil then
					if action == "Button1" then
						SunglassesOn = false
					elseif action == "Button2" then
					end
				end
			end
		}
	end
end
function zitemAlienSpaceCraft:OnClick()
	_Urwigo.MessageBox{
		Text = _VvPb("\058\071\105\030\061\092\123\052\063\030\051\082\087\051\005\082\093\082\063\018\018\018\030\053\033\022\088\092\030\100\082\081\071\087\082\030\070\071\105\087\030\109\082\087\070\030\082\070\082\061\030\092\088\082\087\082\030\033\061\030\123\030\061\016\123\005\005\030\123\005\033\082\052\030\061\051\123\112\082\112\087\123\081\092\018\030\058\071\105\030\123\087\082\030\016\071\092\033\071\052\005\082\061\061\030\081\071\087\030\123\030\112\071\105\051\005\082\030\071\081\030\016\033\052\105\092\082\061\048\030\028\088\082\052\030\061\105\063\063\082\052\005\070\030\070\071\105\030\088\082\123\087\030\123\030\005\071\062\030\088\033\061\061\033\052\022\030\109\071\033\112\082\030\112\071\016\033\052\022\030\081\087\071\016\030\100\082\088\033\052\063\048\090\064\053\039\074\030\066\082\070\030\096\123\087\092\088\005\033\052\022\018\090\064\053\039\058\071\105\030\061\005\071\062\005\070\030\092\105\087\052\030\123\087\071\105\052\063\076\030\092\088\082\030\100\005\071\071\063\030\081\087\071\023\082\052\030\033\052\030\070\071\105\087\030\109\082\033\052\061\018"), 
		Media = zmediaFlyingSaucer, 
		Callback = function(action)
			if action ~= nil then
				zcharacterAlienGeocacher.Visible = true
				zitemAlienSpaceCraft.Visible = false
				ztaskExploreCrashSite.Visible = false
				Wherigo.ShowScreen(Wherigo.MAINSCREEN)
			end
		end
	}
end
function zitemSpaceShipPart1:OnClick()
	if not Player:Contains(zitemSpaceShipPart1) then
		_Urwigo.MessageBox{
			Text = _VvPb("\117\092\087\123\052\022\082\030\005\071\071\026\033\052\022\030\022\123\063\022\082\092\018\030\019\082\081\033\052\033\092\082\005\070\030\123\005\033\082\052\030\071\081\030\071\087\033\022\033\052\048\030\072\092\025\030\016\105\061\092\030\100\082\030\092\088\082\030\016\033\061\061\033\052\022\030\051\123\087\092\018"), 
			Media = zmediaSpaceshipPart1, 
			Buttons = {
				_VvPb("\028\115\002\096"), 
				_VvPb("\103\006\028\030\103\006\073")
			}, 
			Callback = function(action)
				if action ~= nil then
					if action == "Button1" then
						zitemSpaceShipPart1:MoveTo(Player)
						NumberParts = NumberParts + 1
						zoneShipPart1.Visible = false
						zoneShipPart1.Active = false
						if NumberParts == 3 then
							ztaskFindAllMissingParts.Complete = true
							ztaskFindAllMissingParts.Visible = false
							ztaskTakeAllPartstoKrang.Visible = true
							Wherigo.ShowScreen(Wherigo.MAINSCREEN)
						end
					elseif action == "Button2" then
						Wherigo.ShowScreen(Wherigo.MAINSCREEN)
					end
				end
			end
		}
	elseif CrashZone == true then
		_Urwigo.MessageBox{
			Text = _VvPb("\046\071\061\092\030\061\051\123\112\082\061\088\033\051\030\051\123\087\092\048"), 
			Media = zmediaSpaceshipPart1, 
			Buttons = {
				_VvPb("\059\072\099\096\030\028\006\030\002\053\115\103\059"), 
				_VvPb("\103\006\028\030\103\006\073")
			}, 
			Callback = function(action)
				if action ~= nil then
					if action == "Button1" then
						zitemSpaceShipPart1:MoveTo(zcharacterKrang)
					end
					if action == "Button2" then
						Wherigo.ShowScreen(Wherigo.MAINSCREEN)
					end
				end
			end
		}
	else
		_Urwigo.MessageBox{
			Text = _VvPb("\006\052\082\030\071\081\030\092\088\082\030\005\071\061\092\030\061\051\123\112\082\030\061\088\033\051\030\051\123\087\092\061\048"), 
			Media = zmediaSpaceshipPart1
		}
	end
end
function zitemSpaceShipPart2:OnClick()
	if not Player:Contains(zitemSpaceShipPart2) then
		_Urwigo.MessageBox{
			Text = _VvPb("\117\092\087\123\052\022\082\030\005\071\071\026\033\052\022\030\022\123\063\022\082\092\018\030\019\082\081\033\052\033\092\082\005\070\030\123\005\033\082\052\030\071\081\030\071\087\033\022\033\052\048\030\072\092\025\030\016\105\061\092\030\100\082\030\092\088\082\030\016\033\061\061\033\052\022\030\051\123\087\092\018"), 
			Media = zmediaSpaceshipPart2, 
			Buttons = {
				_VvPb("\028\115\002\096"), 
				_VvPb("\103\006\028\030\103\006\073")
			}, 
			Callback = function(action)
				if action ~= nil then
					if (action == "Button1") and (GlovesOn == true) then
						zitemSpaceShipPart2:MoveTo(Player)
						NumberParts = NumberParts + 1
						zoneShipPart2.Visible = false
						zoneShipPart2.Active = false
						if NumberParts == 3 then
							ztaskFindAllMissingParts.Complete = true
							ztaskFindAllMissingParts.Visible = false
							ztaskTakeAllPartstoKrang.Visible = true
							Wherigo.ShowScreen(Wherigo.MAINSCREEN)
						end
					elseif (action == "Button1") and (GlovesOn == false) then
						_Urwigo.MessageBox{
							Text = _VvPb("\073\071\062\018\030\028\088\033\061\030\092\088\033\052\022\030\005\071\071\026\061\030\088\071\092\018\030\058\071\105\030\016\033\022\088\092\030\100\105\087\052\030\070\071\105\087\030\088\123\052\063\061\018\018\018\030\058\071\105\030\051\105\092\030\070\071\105\087\030\062\071\087\026\033\052\022\030\022\005\071\109\082\061\030\033\052\030\070\071\105\087\030\112\123\087\030\033\052\030\092\088\082\030\016\071\087\052\033\052\022\076\030\063\033\063\025\092\030\070\071\105\044"), 
							Media = zmediaSpaceshipPart2
						}
					elseif action == "Button2" then
						Wherigo.ShowScreen(Wherigo.MAINSCREEN)
					end
				end
			end
		}
	elseif CrashZone == true then
		_Urwigo.MessageBox{
			Text = _VvPb("\046\071\061\092\030\061\051\123\112\082\061\088\033\051\030\051\123\087\092\048"), 
			Media = zmediaSpaceshipPart2, 
			Buttons = {
				_VvPb("\059\072\099\096\030\028\006\030\002\053\115\103\059"), 
				_VvPb("\103\006\028\030\103\006\073")
			}, 
			Callback = function(action)
				if action ~= nil then
					if action == "Button1" then
						zitemSpaceShipPart2:MoveTo(zcharacterKrang)
					end
					if action == "Button2" then
						Wherigo.ShowScreen(Wherigo.MAINSCREEN)
					end
				end
			end
		}
	else
		_Urwigo.MessageBox{
			Text = _VvPb("\006\052\082\030\071\081\030\092\088\082\030\005\071\061\092\030\061\051\123\112\082\030\061\088\033\051\030\051\123\087\092\061\048"), 
			Media = zmediaSpaceshipPart2
		}
	end
end
function zitemSpaceShipPart3:OnClick()
	if not Player:Contains(zitemSpaceShipPart3) then
		_Urwigo.MessageBox{
			Text = _VvPb("\117\092\087\123\052\022\082\030\005\071\071\026\033\052\022\030\022\123\063\022\082\092\018\030\019\082\081\033\052\033\092\082\005\070\030\123\005\033\082\052\030\071\081\030\071\087\033\022\033\052\048\030\072\092\025\030\016\105\061\092\030\100\082\030\092\088\082\030\016\033\061\061\033\052\022\030\051\123\087\092\018"), 
			Media = zmediaSpaceshipPart3, 
			Buttons = {
				_VvPb("\028\115\002\096"), 
				_VvPb("\103\006\028\030\103\006\073")
			}, 
			Callback = function(action)
				if action ~= nil then
					if action == "Button1" then
						zitemSpaceShipPart3:MoveTo(Player)
						NumberParts = NumberParts + 1
						zoneShipPart3.Visible = false
						zoneShipPart3.Active = false
						if NumberParts == 3 then
							ztaskFindAllMissingParts.Complete = true
							ztaskFindAllMissingParts.Visible = false
							ztaskTakeAllPartstoKrang.Visible = true
							Wherigo.ShowScreen(Wherigo.MAINSCREEN)
						end
					elseif action == "Button2" then
						Wherigo.ShowScreen(Wherigo.INVENTORYSCREEN)
					end
				end
			end
		}
	elseif CrashZone == true then
		_Urwigo.MessageBox{
			Text = _VvPb("\046\071\061\092\030\061\051\123\112\082\061\088\033\051\030\051\123\087\092\048"), 
			Media = zmediaSpaceshipPart3, 
			Buttons = {
				_VvPb("\059\072\099\096\030\028\006\030\002\053\115\103\059"), 
				_VvPb("\103\006\028\030\103\006\073")
			}, 
			Callback = function(action)
				if action ~= nil then
					if action == "Button1" then
						zitemSpaceShipPart3:MoveTo(zcharacterKrang)
					end
					if action == "Button2" then
						Wherigo.ShowScreen(Wherigo.MAINSCREEN)
					end
				end
			end
		}
	else
		_Urwigo.MessageBox{
			Text = _VvPb("\006\052\082\030\071\081\030\092\088\082\030\005\071\061\092\030\061\051\123\112\082\030\061\088\033\051\030\051\123\087\092\061\048"), 
			Media = zmediaSpaceshipPart3
		}
	end
end
function zitemAlienMultiTool:OnClick()
	if not Player:Contains(zitemAlienMultiTool) then
		_Urwigo.MessageBox{
			Text = _VvPb("\115\030\109\082\087\070\030\088\123\052\063\070\030\021\105\005\092\033\030\028\071\071\005\018"), 
			Media = zmediaAlienMultiTool, 
			Buttons = {
				_VvPb("\028\115\002\096"), 
				_VvPb("\103\006\028\030\103\006\073")
			}, 
			Callback = function(action)
				if action ~= nil then
					if action == "Button1" then
						zitemAlienMultiTool:MoveTo(Player)
						Wherigo.ShowScreen(Wherigo.MAINSCREEN)
					elseif action == "Button2" then
					end
				end
			end
		}
	elseif (FluxCapacitorZone == true) and (SunglassesOn == true) then
		_Urwigo.MessageBox{
			Text = _VvPb("\073\033\092\088\030\092\088\033\061\030\115\005\033\082\052\030\021\105\005\092\033\030\028\071\071\005\030\070\071\105\030\112\123\052\030\063\033\061\123\100\005\082\030\028\088\082\030\107\005\105\093\030\097\123\051\123\112\033\092\071\087"), 
			Media = zmediaAlienMultiTool, 
			Buttons = {
				_VvPb("\114\117\096\030\028\006\006\046")
			}, 
			Callback = function(action)
				if action ~= nil then
					zitemFluxCapacitor.Visible = false
					zitemDisabledFluxCapacitor.Visible = true
					Wherigo.ShowScreen(Wherigo.ITEMSCREEN)
				end
			end
		}
	elseif (FluxCapacitorZone == true) and (SunglassesOn == false) then
		_Urwigo.MessageBox{
			Text = _VvPb("\028\088\082\030\005\033\022\088\092\030\081\087\071\016\030\092\088\082\030\107\005\105\093\030\097\123\051\123\112\033\092\071\087\030\033\061\030\092\071\071\030\061\092\087\071\052\022\048\030\058\071\105\030\112\123\052\052\071\092\030\022\071\030\052\082\123\087\030\100\082\112\123\105\061\082\030\070\071\105\087\030\082\070\082\061\030\088\105\087\092\048"), 
			Media = zmediaAlienMultiTool
		}
	else
		_Urwigo.MessageBox{
			Text = _VvPb("\099\082\087\070\030\088\123\052\063\070\030\115\005\033\082\052\030\021\105\005\092\033\030\028\071\071\005\048\030\058\071\105\030\112\123\052\030\063\071\030\109\123\087\033\071\105\061\030\004\071\100\061\030\062\033\092\088\030\033\092\048\030\046\033\026\082\030\063\033\061\123\100\005\033\052\022\030\123\030\107\005\105\093\030\097\123\051\123\112\033\092\071\087\048"), 
			Media = zmediaAlienMultiTool
		}
	end
end
function zitemFluxCapacitor:OnClick()
	_Urwigo.MessageBox{
		Text = _VvPb("\058\071\105\030\081\071\105\052\063\030\092\088\082\030\107\005\105\093\030\097\123\051\123\112\033\092\071\087\030\100\105\092\030\033\092\030\033\061\030\071\051\082\087\123\092\033\071\052\123\005\048\030\058\071\105\030\062\033\005\005\030\088\123\109\082\030\092\071\030\063\033\061\123\100\005\082\030\033\092\030\081\033\087\061\092\048"), 
		Media = zmediaFluxCapacitorOn
	}
end
function zitemDisabledFluxCapacitor:OnClick()
	if not Player:Contains(zitemDisabledFluxCapacitor) then
		_Urwigo.MessageBox{
			Text = _VvPb("\103\071\062\030\033\092\030\033\061\030\061\123\081\082\030\092\071\030\092\123\026\082\030\092\088\082\030\107\005\105\093\030\097\123\051\123\112\033\092\071\087\048"), 
			Media = zmediaFluxCapacitorOff, 
			Buttons = {
				_VvPb("\028\115\002\096"), 
				_VvPb("\103\006\028\030\103\006\073")
			}, 
			Callback = function(action)
				if action ~= nil then
					if action == "Button1" then
						zitemDisabledFluxCapacitor:MoveTo(Player)
						ztaskFindtheFluxCapacitor.Complete = true
						ztaskFindtheFluxCapacitor.Visible = false
						zoneFluxCapacitor.Active = false
						zoneFluxCapacitor.Visible = false
						ztaskGobacktotheCrashSite.Visible = true
						Wherigo.ShowScreen(Wherigo.MAINSCREEN)
					elseif action == "Button2" then
					end
				end
			end
		}
	elseif FluxCapacitorZone == true then
		_Urwigo.MessageBox{
			Text = _VvPb("\028\088\082\030\115\005\033\082\052\030\117\088\033\051\030\112\123\052\052\071\092\030\087\105\052\030\062\033\092\088\071\105\092\030\123\030\107\005\105\093\030\097\123\051\123\112\033\092\071\087\048"), 
			Media = zmediaFluxCapacitorOff, 
			Buttons = {
				_VvPb("\059\072\099\096\030\028\006\030\002\053\115\028\066"), 
				_VvPb("\103\006\028\030\103\006\073")
			}, 
			Callback = function(action)
				if action ~= nil then
					if action == "Button1" then
						zitemDisabledFluxCapacitor:MoveTo(zcharacterKrath)
						zitemAlienMultiTool:MoveTo(zcharacterKrath)
						Wherigo.ShowScreen(Wherigo.ITEMSCREEN)
					elseif action == "Button2" then
					end
				end
			end
		}
	elseif FluxCapacitorZone == false then
		_Urwigo.MessageBox{
			Text = _VvPb("\019\033\061\123\100\005\082\063\030\107\005\105\093\030\097\123\051\123\112\033\092\071\087\048\030\028\088\082\030\123\005\033\082\052\061\030\062\033\005\005\030\052\082\082\063\030\033\092\030\092\071\030\081\033\093\030\092\088\082\033\087\030\061\088\033\051\048"), 
			Media = zmediaFluxCapacitorOff
		}
	end
end
function zitemOrbitingSpacecraft:OnClick()
	_Urwigo.MessageBox{
		Text = _VvPb("\028\088\082\030\117\051\123\112\082\112\087\123\081\092\030\033\061\030\033\052\030\051\005\123\052\082\092\123\087\070\030\071\087\100\033\092\048\030\058\071\105\030\112\123\052\030\112\071\016\016\105\052\033\112\123\092\082\030\062\033\092\088\030\033\092\030\100\070\030\087\123\063\033\071\048"), 
		Media = zmediaSpaceCraftinOrbit, 
		Callback = function(action)
			if action ~= nil then
				Wherigo.ShowScreen(Wherigo.INVENTORYSCREEN)
			end
		end
	}
end
function zitemAlienSWAG:OnClick()
	_Urwigo.MessageBox{
		Text = _VvPb("\117\071\016\082\030\109\082\087\070\030\052\033\112\082\030\123\005\033\082\052\030\117\073\115\059\018"), 
		Media = zmediaAlienSWAG, 
		Callback = function(action)
			if action ~= nil then
				Wherigo.ShowScreen(Wherigo.MAINSCREEN)
			end
		end
	}
end
function zitemGeocacheCoordinates:OnClick()
	ztaskFindMysteryNumber.Complete = true
	ztaskRadiotheOrbitingSpacecraft.Complete = true
	ztaskFindMysteryNumber.Visible = false
	ztaskRadiotheOrbitingSpacecraft.Visible = false
	if Wherigo.NoCaseEquals(DeviceID, Emulator) then
		_Urwigo.MessageBox{
			Text = _VvPb("\058\071\105\030\123\087\082\030\051\005\123\070\033\052\022\030\033\052\030\123\052\030\082\016\105\005\123\092\071\087\048\030\028\088\033\061\030\033\092\082\016\030\062\033\005\005\030\052\071\092\030\100\082\030\063\033\061\051\005\123\070\082\063\018\018\018"), 
			Callback = function(action)
				if action ~= nil then
					Wherigo.ShowScreen(Wherigo.MAINSCREEN)
				end
			end
		}
	else
		_Urwigo.MessageBox{
			Text = _VvPb("\028\088\082\030\059\082\071\112\123\112\088\082\030\033\061\030\005\071\112\123\092\082\063\030\123\092\030\103\030\098\050\030\075\091\048\014\091\106\030\096\030\075\050\098\030\098\098\048\001\098\041\048\030\064\082\088\033\052\063\030\123\030\061\092\071\052\082\030\033\052\030\092\088\082\030\062\123\005\005\048\030\073\088\082\052\030\070\071\105\030\087\082\123\112\088\030\092\088\082\030\051\005\123\112\082\030\072\030\062\033\005\005\030\105\051\005\071\123\063\030\123\030\061\051\071\033\005\082\087\030\051\033\112\092\105\087\082\030\092\071\030\070\071\105\087\030\063\082\109\033\112\082\048"), 
			Media = zmediaGeocache, 
			Callback = function(action)
				if action ~= nil then
					ztaskGoFindTheGeocache.Active = true
					ztaskGoFindTheGeocache.Visible = true
					Wherigo.ShowScreen(Wherigo.MAINSCREEN)
				end
			end
		}
	end
end
function zitemCompletionCode:OnClick()
	_Urwigo.MessageBox{
		Text = (_VvPb("\058\071\105\087\030\112\071\016\051\005\082\092\033\071\052\030\112\071\063\082\030\033\061\108\030")..string.sub(Player.CompletionCode, 1, 15)).._VvPb("\030\102\005\082\123\061\082\030\105\061\082\030\092\088\082\030\081\033\087\061\092\030\001\012\030\112\088\123\087\123\112\092\082\087\061\030\071\081\030\033\092\030\071\052\030\073\088\082\087\033\022\071\048\112\071\016\030\092\071\030\105\052\005\071\112\026\030\092\088\082\030\112\123\087\092\087\033\063\022\082")
	}
end
function zitemSpoiler:OnClick()
	if Wherigo.NoCaseEquals(DeviceID, Emulator) then
		_Urwigo.MessageBox{
			Text = _VvPb("\058\071\105\030\123\087\082\030\051\005\123\070\033\052\022\030\033\052\030\123\052\030\082\016\105\005\123\092\071\087\048\030\028\088\033\061\030\033\092\082\016\030\062\033\005\005\030\052\071\092\030\100\082\030\063\033\061\051\005\123\070\082\063\048"), 
			Media = zmediaWherigo, 
			Callback = function(action)
				if action ~= nil then
					Wherigo.ShowScreen(Wherigo.MAINSCREEN)
				end
			end
		}
	else
		_Urwigo.MessageBox{
			Text = _VvPb("\064\082\088\033\052\063\030\123\030\061\092\071\052\082\030\033\052\030\092\088\082\030\062\123\005\005\048"), 
			Media = zmediaSpoiler
		}
	end
end

-- Urwigo functions --

-- Begin user functions --
-----------------------------------------------------------------------------------------------
-- URWIGO: Following code is imported from the Wherigo Builder cartridge.
-- It is only neccessary if the cartridge uses Author functions that use message box callbacks.
-- Otherwise it can be removed.
cartAlienCacher.MsgBoxCBFuncs = {}
-------------------------------------------------------------------------------
--#LASTCALLBACKKEY=61#--
cartAlienCacher.MsgBoxCBFuncs.MsgBoxCB1 = function(action)
if action ~= nil then
-- #GroupDescription=Script --
-- #Comment=Script Comment --
Wherigo.ShowScreen(Wherigo.ITEMSCREEN)
end
end

cartAlienCacher.MsgBoxCBFuncs.MsgBoxCB2 = function(action)
-- #GroupDescription=Script --
-- #Comment=Script Comment --
if   action == "Button1" then
zitemGloves:MoveTo(Player)
else
end
Wherigo.ShowScreen(Wherigo.ITEMSCREEN)
end

cartAlienCacher.MsgBoxCBFuncs.MsgBoxCB4 = function(action)
-- #GroupDescription=Script --
-- #Comment=Script Comment --
if   action == "Button1" then
zitemSunglasses:MoveTo(Player)
else
end
Wherigo.ShowScreen(Wherigo.ITEMSCREEN)
end

cartAlienCacher.MsgBoxCBFuncs.MsgBoxCB5 = function(action)
-- #GroupDescription=Script --
-- #Comment=Script Comment --
if   action == "Button1" then
Hands = true
else
Hands = false
end
end

cartAlienCacher.MsgBoxCBFuncs.MsgBoxCB6 = function(action)
-- #GroupDescription=Script --
-- #Comment=Script Comment --
if   action == "Button1" then
Hands = false
else
Hands = true
end
end

cartAlienCacher.MsgBoxCBFuncs.MsgBoxCB9 = function(action)
if action ~= nil then
-- #GroupDescription=Script --
-- #Comment=Script Comment --
ztaskCheckYourMap.Complete = true
ztaskCheckYourMap.Visible = false
Wherigo.ShowScreen(Wherigo.MAINSCREEN)
end
end

cartAlienCacher.MsgBoxCBFuncs.MsgBoxCB10 = function(action)
if action ~= nil then
-- #GroupDescription=Script --
-- #Comment=Script Comment --
Wherigo.ShowScreen(Wherigo.MAINSCREEN)
end
end

cartAlienCacher.MsgBoxCBFuncs.MsgBoxCB13 = function(action)
if action ~= nil then
-- #GroupDescription=Script --
-- #Comment=Script Comment --
Wherigo.ShowScreen(Wherigo.MAINSCREEN)
end
end

cartAlienCacher.MsgBoxCBFuncs.MsgBoxCB15 = function(action)
-- #GroupDescription=Script --
-- #Comment=Script Comment --
if   action == "Button1" then
zitemSpaceShipPart1:MoveTo(zcharacterKrang)
end
if   action == "Button2" then
Wherigo.ShowScreen(Wherigo.MAINSCREEN)
end
end

cartAlienCacher.MsgBoxCBFuncs.MsgBoxCB16 = function(action)
if action ~= nil then
-- #GroupDescription=Script --
-- #Comment=Script Comment --
Wherigo.ShowScreen(Wherigo.MAINSCREEN)
end
end

cartAlienCacher.MsgBoxCBFuncs.MsgBoxCB18 = function(action)
if action ~= nil then
-- #GroupDescription=Script --
-- #Comment=Script Comment --
Wherigo.ShowScreen(Wherigo.MAINSCREEN)
end
end

cartAlienCacher.MsgBoxCBFuncs.MsgBoxCB19 = function(action)
if action ~= nil then
-- #GroupDescription=Script --
-- #Comment=Script Comment --
Wherigo.ShowScreen(Wherigo.MAINSCREEN)
end
end

cartAlienCacher.MsgBoxCBFuncs.MsgBoxCB17 = function(action)
if action ~= nil then
-- #GroupDescription=Script --
-- #Comment=Script Comment --
Wherigo.ShowScreen(Wherigo.MAINSCREEN)
end
end

cartAlienCacher.MsgBoxCBFuncs.MsgBoxCB22 = function(action)
-- #GroupDescription=Script --
-- #Comment=Script Comment --
if   action == "Button1" then
GlovesOn = false
else
if   action == "Button2" then
end
end
end

cartAlienCacher.MsgBoxCBFuncs.MsgBoxCB23 = function(action)
if action ~= nil then
-- #GroupDescription=Script --
-- #Comment=Script Comment --
Wherigo.ShowScreen(Wherigo.ITEMSCREEN)
end
end

cartAlienCacher.MsgBoxCBFuncs.MsgBoxCB24 = function(action)
-- #GroupDescription=Script --
-- #Comment=Script Comment --
if   action == "Button1" and GlovesOn == true then
zitemSpaceShipPart2:MoveTo(Player)
NumberParts = NumberParts + 1
zoneShipPart2.Visible = false
zoneShipPart2.Active = false
if   NumberParts == 3 then
ztaskFindAllMissingParts.Complete = true
ztaskFindAllMissingParts.Visible = false
ztaskTakeAllPartstoKrang.Visible = true
Wherigo.ShowScreen(Wherigo.MAINSCREEN)
end
else
if   action == "Button1" and GlovesOn == false then
Wherigo.MessageBox{Text=[[Wow! This thing looks hot! You might burn your hands!!! You put your working gloves in your car in the morning, did't you?]],Media=zmediaSpaceshipPart2,}
else
if   action == "Button2" then
Wherigo.ShowScreen(Wherigo.MAINSCREEN)
end
end
end
end

cartAlienCacher.MsgBoxCBFuncs.MsgBoxCB26 = function(action)
-- #GroupDescription=Script --
-- #Comment=Script Comment --
if   action == "Button1" then
zitemSpaceShipPart2:MoveTo(zcharacterKrang)
end
if   action == "Button2" then
Wherigo.ShowScreen(Wherigo.MAINSCREEN)
end
end

cartAlienCacher.MsgBoxCBFuncs.MsgBoxCB27 = function(action)
-- #GroupDescription=Script --
-- #Comment=Script Comment --
if   action == "Button1" then
zitemSpaceShipPart3:MoveTo(zcharacterKrang)
end
if   action == "Button2" then
Wherigo.ShowScreen(Wherigo.MAINSCREEN)
end
end

cartAlienCacher.MsgBoxCBFuncs.MsgBoxCB20 = function(action)
-- #GroupDescription=Script --
-- #Comment=Script Comment --
if   action == "Button1" then
zitemGloves:MoveTo(Player)
else
if   action == "Button2" then
end
end
end

cartAlienCacher.MsgBoxCBFuncs.MsgBoxCB21 = function(action)
-- #GroupDescription=Script --
-- #Comment=Script Comment --
if   action == "Button1" then
GlovesOn = true
Wherigo.ShowScreen(Wherigo.MAINSCREEN)
else
if   action == "Button2" then
end
end
end

cartAlienCacher.MsgBoxCBFuncs.MsgBoxCB25 = function(action)
-- #GroupDescription=Script --
-- #Comment=Script Comment --
if   action == "Button1" then
zitemSpaceShipPart3:MoveTo(Player)
NumberParts = NumberParts + 1
zoneShipPart3.Visible = false
zoneShipPart3.Active = false
if   NumberParts == 3 then
ztaskFindAllMissingParts.Complete = true
ztaskFindAllMissingParts.Visible = false
ztaskTakeAllPartstoKrang.Visible = true
Wherigo.ShowScreen(Wherigo.MAINSCREEN)
end
else
if   action == "Button2" then
Wherigo.ShowScreen(Wherigo.INVENTORYSCREEN)
end
end
end

cartAlienCacher.MsgBoxCBFuncs.MsgBoxCB29 = function(action)
if action ~= nil then
-- #GroupDescription=Script --
-- #Comment=Script Comment --
Wherigo.ShowScreen(Wherigo.MAINSCREEN)
end
end

cartAlienCacher.MsgBoxCBFuncs.MsgBoxCB30 = function(action)
if action ~= nil then
-- #GroupDescription=Script --
-- #Comment=Script Comment --
zitemFluxCapacitor.Visible = false
zitemDisabledFluxCapacitor.Visible = true
Wherigo.ShowScreen(Wherigo.ITEMSCREEN)
end
end

cartAlienCacher.MsgBoxCBFuncs.MsgBoxCB31 = function(action)
-- #GroupDescription=Script --
-- #Comment=Script Comment --
if   action == "Button1" then
SunglassesOn = true
else
if   action == "Button2" then
end
end
end

cartAlienCacher.MsgBoxCBFuncs.MsgBoxCB32 = function(action)
-- #GroupDescription=Script --
-- #Comment=Script Comment --
if   action == "Button1" then
SunglassesOn = false
else
if   action == "Button2" then
end
end
end

cartAlienCacher.MsgBoxCBFuncs.MsgBoxCB12 = function(action)
if action ~= nil then
-- #GroupDescription=Script --
-- #Comment=Script Comment --
Wherigo.ShowScreen(Wherigo.MAINSCREEN)
end
end

cartAlienCacher.MsgBoxCBFuncs.MsgBoxCB34 = function(action)
if action ~= nil then
-- #GroupDescription=Script --
-- #Comment=Script Comment --
Wherigo.ShowScreen(Wherigo.MAINSCREEN)
end
end

cartAlienCacher.MsgBoxCBFuncs.MsgBoxCB33 = function(action)
-- #GroupDescription=Script --
-- #Comment=Script Comment --
if   action == "Button1" then
zitemAlienMultiTool:MoveTo(Player)
Wherigo.ShowScreen(Wherigo.MAINSCREEN)
else
if   action == "Button2" then
end
end
end

cartAlienCacher.MsgBoxCBFuncs.MsgBoxCB40 = function(action)
if action ~= nil then
-- #GroupDescription=Script --
-- #Comment=Script Comment --
Wherigo.ShowScreen(Wherigo.MAINSCREEN)
end
end

cartAlienCacher.MsgBoxCBFuncs.MsgBoxCB37 = function(action)
if action ~= nil then
-- #GroupDescription=Script --
-- #Comment=Script Comment --
Wherigo.ShowScreen(Wherigo.INVENTORYSCREEN)
end
end

cartAlienCacher.MsgBoxCBFuncs.MsgBoxCB36 = function(action)
-- #GroupDescription=Script --
-- #Comment=Script Comment --
if   action == "Button1" then
zitemDisabledFluxCapacitor:MoveTo(zcharacterKrath)
zitemAlienMultiTool:MoveTo(zcharacterKrath)
Wherigo.ShowScreen(Wherigo.ITEMSCREEN)
else
if   action == "Button2" then
end
end
end

cartAlienCacher.MsgBoxCBFuncs.MsgBoxCB41 = function(action)
if action ~= nil then
-- #GroupDescription=Script --
-- #Comment=Script Comment --
Wherigo.ShowScreen(Wherigo.INVENTORYSCREEN)
end
end

cartAlienCacher.MsgBoxCBFuncs.MsgBoxCB42 = function(action)
-- #GroupDescription=Script --
-- #Comment=Script Comment --
if   action == "Button1" then
zitemSunglasses:MoveTo(Player)
else
if   action == "Button2" then
end
end
end

cartAlienCacher.MsgBoxCBFuncs.MsgBoxCB49 = function(action)
if action ~= nil then
-- #GroupDescription=Script --
-- #Comment=Script Comment --
Wherigo.ShowScreen(Wherigo.MAINSCREEN)
end
end

cartAlienCacher.MsgBoxCBFuncs.MsgBoxCB3 = function(action)
-- #GroupDescription=Script --
-- #Comment=Script Comment --
if   action == "Button1" then
zitemWalkieTalkie:MoveTo(Player)
else
Wherigo.ShowScreen(Wherigo.ITEMSCREEN)
end
end

cartAlienCacher.MsgBoxCBFuncs.MsgBoxCB14 = function(action)
-- #GroupDescription=Script --
-- #Comment=Script Comment --
if   action == "Button1" then
zitemSpaceShipPart1:MoveTo(Player)
NumberParts = NumberParts + 1
zoneShipPart1.Visible = false
zoneShipPart1.Active = false
if   NumberParts == 3 then
ztaskFindAllMissingParts.Complete = true
ztaskFindAllMissingParts.Visible = false
ztaskTakeAllPartstoKrang.Visible = true
Wherigo.ShowScreen(Wherigo.MAINSCREEN)
end
else
if   action == "Button2" then
Wherigo.ShowScreen(Wherigo.MAINSCREEN)
end
end
end

cartAlienCacher.MsgBoxCBFuncs.MsgBoxCB52 = function(action)
if action ~= nil then
-- #GroupDescription=Script --
-- #Comment=Script Comment --
Wherigo.ShowScreen(Wherigo.MAINSCREEN)
end
end

cartAlienCacher.MsgBoxCBFuncs.MsgBoxCB11 = function(action)
if action ~= nil then
-- #GroupDescription=Script --
-- #Comment=Script Comment --
zcharacterAlienGeocacher.Visible = true
zitemAlienSpaceCraft.Visible = false
ztaskExploreCrashSite.Visible = false
Wherigo.ShowScreen(Wherigo.MAINSCREEN)
end
end

cartAlienCacher.MsgBoxCBFuncs.MsgBoxCB28 = function(action)
if action ~= nil then
-- #GroupDescription=Script --
-- #Comment=Script Comment --
Wherigo.ShowScreen(Wherigo.MAINSCREEN)
end
end

cartAlienCacher.MsgBoxCBFuncs.MsgBoxCB39 = function(action)
if action ~= nil then
-- #GroupDescription=Script --
-- #Comment=Script Comment --
Wherigo.ShowScreen(Wherigo.INVENTORYSCREEN)
end
end

cartAlienCacher.MsgBoxCBFuncs.MsgBoxCB35 = function(action)
-- #GroupDescription=Script --
-- #Comment=Script Comment --
if   action == "Button1" then
zitemDisabledFluxCapacitor:MoveTo(Player)
ztaskFindtheFluxCapacitor.Complete = true
ztaskFindtheFluxCapacitor.Visible = false
zoneFluxCapacitor.Active = false
zoneFluxCapacitor.Visible = false
ztaskGobacktotheCrashSite.Visible = true
Wherigo.ShowScreen(Wherigo.MAINSCREEN)
else
if   action == "Button2" then
end
end
end

cartAlienCacher.MsgBoxCBFuncs.MsgBoxCB48 = function(action)
if action ~= nil then
-- #GroupDescription=Script --
-- #Comment=Script Comment --
ztaskGoFindTheGeocache.Active = true
ztaskGoFindTheGeocache.Visible = true
Wherigo.ShowScreen(Wherigo.MAINSCREEN)
end
end

cartAlienCacher.MsgBoxCBFuncs.MsgBoxCB54 = function(action)
if action ~= nil then
-- #GroupDescription=Script --
-- #Comment=Script Comment --
Wherigo.ShowScreen(Wherigo.MAINSCREEN)
end
end

cartAlienCacher.MsgBoxCBFuncs.MsgBoxCB53 = function(action)
if action ~= nil then
-- #GroupDescription=Script --
-- #Comment=Script Comment --
Wherigo.ShowScreen(Wherigo.MAINSCREEN)
end
end

cartAlienCacher.MsgBoxCBFuncs.MsgBoxCB45 = function(action)
if action ~= nil then
-- #GroupDescription=Script --
-- #Comment=Script Comment --
ztaskFindMysteryNumber.Visible = true
Wherigo.ShowScreen(Wherigo.TASKSCREEN)
Wherigo.Dialog{{Text=[[Bzzzzt... How do you read me Earthling?]],Media=zmediaAlienGeocacher},{Text=[[Loud and clear! Go ahead!]],Media=zmediaGeocacher},{Text=[[All right! I am uploading to your device the coordinates of the place where you can find the Mystery Code. When you find the code call me back!]],Media=zmediaAlienGeocacher},}
end
end

cartAlienCacher.MsgBoxCBFuncs.MsgBoxCB51 = function(action)
if action ~= nil then
-- #GroupDescription=Script --
-- #Comment=Script Comment --
Wherigo.ShowScreen(Wherigo.MAINSCREEN)
end
end

cartAlienCacher.MsgBoxCBFuncs.MsgBoxCB55 = function(action)
if action ~= nil then
-- #GroupDescription=Script --
-- #Comment=Script Comment --
Wherigo.ShowScreen(Wherigo.MAINSCREEN)
end
end

cartAlienCacher.MsgBoxCBFuncs.MsgBoxCB47 = function(action)
if action ~= nil then
-- #GroupDescription=Script --
-- #Comment=Script Comment --
Wherigo.GetInput(zinputMysteryCode)
end
end

cartAlienCacher.MsgBoxCBFuncs.MsgBoxCB56 = function(action)
if action ~= nil then
-- #GroupDescription=Script --
-- #Comment=Script Comment --
Wherigo.GetInput(zinputMysteryCode2)
end
end

cartAlienCacher.MsgBoxCBFuncs.MsgBoxCB44 = function(action)
if action ~= nil then
-- #GroupDescription=Script --
-- #Comment=Script Comment --
Wherigo.ShowScreen(Wherigo.MAINSCREEN)
end
end

cartAlienCacher.MsgBoxCBFuncs.MsgBoxCB46 = function(action)
if action ~= nil then
-- #GroupDescription=Script --
-- #Comment=Script Comment --
ztaskFindMysteryNumber2.Active = true
ztaskFindMysteryNumber2.Visible = true
Wherigo.ShowScreen(Wherigo.MAINSCREEN)
end
end

cartAlienCacher.MsgBoxCBFuncs.MsgBoxCB50 = function(action)
if action ~= nil then
-- #GroupDescription=Script --
-- #Comment=Script Comment --
Wherigo.GetInput(zinputMysteryCode)
end
end

cartAlienCacher.MsgBoxCBFuncs.MsgBoxCB43 = function(action)
if action ~= nil then
-- #GroupDescription=Script --
-- #Comment=Script Comment --
Wherigo.MessageBox{Text=[[Did you find The Mystery Number?]],Media=zmediaSpaceCraftinOrbit,Callback=cartAlienCacher.MsgBoxCBFuncs.MsgBoxCB50}
end
end

cartAlienCacher.MsgBoxCBFuncs.MsgBoxCB58 = function(action)
if action ~= nil then
-- #GroupDescription=Script --
-- #Comment=Script Comment --
Wherigo.GetInput(zinputMysteryCode2)
end
end

cartAlienCacher.MsgBoxCBFuncs.MsgBoxCB57 = function(action)
if action ~= nil then
-- #GroupDescription=Script --
-- #Comment=Script Comment --
Wherigo.MessageBox{Text=[[Did you find The Mystery Number?]],Media=zmediaSpaceCraftinOrbit,Callback=cartAlienCacher.MsgBoxCBFuncs.MsgBoxCB58}
end
end

cartAlienCacher.MsgBoxCBFuncs.MsgBoxCB60 = function(action)
if action ~= nil then
-- #GroupDescription=Script --
-- #Comment=Script Comment --
Wherigo.ShowScreen(Wherigo.MAINSCREEN)
end
end

cartAlienCacher.MsgBoxCBFuncs.MsgBoxCB38 = function(action)
if action ~= nil then
-- #GroupDescription=Script --
-- #Comment=Script Comment --
Wherigo.ShowScreen(Wherigo.INVENTORYSCREEN)
end
end

cartAlienCacher.MsgBoxCBFuncs.MsgBoxCB59 = function(action)
if action ~= nil then
-- #GroupDescription=Script --
-- #Comment=Script Comment --
Wherigo.ShowScreen(Wherigo.MAINSCREEN)
end
end

cartAlienCacher.MsgBoxCBFuncs.MsgBoxCB61 = function(action)
if action ~= nil then
-- #GroupDescription=Script --
-- #Comment=Script Comment --
Wherigo.ShowScreen(Wherigo.MAINSCREEN)
end
end


-----------------------------------------------------------------------------------------------
-- URWIGO: Here follow imported Author functions
function devicetest()
DeviceID = Env.DeviceID
return DeviceID
end


-- End user functions --
return cartAlienCacher
