require "Wherigo"
ZonePoint = Wherigo.ZonePoint
Distance = Wherigo.Distance
Player = Wherigo.Player

-- #Author Directives Go Here# --
require "math"
-- #End Author Directives# --

cartEggHunt = Wherigo.ZCartridge()

-- MessageBox Callback Functions Table used by the Builder --
cartEggHunt.MsgBoxCBFuncs = {}

-- Cartridge Info --
cartEggHunt.Id="43f31645-c512-4714-9021-553379232d3e"
cartEggHunt.Name="Egg Hunt"
cartEggHunt.Description=[[A quick five-minute mad dash....find as many eggs as possible.  Different eggs have different point values.  How many points can you collect?]]
cartEggHunt.Visible=true
cartEggHunt.Activity="Puzzle"
cartEggHunt.StartingLocationDescription=[[Any open area, at least 100 feet in any direction.]]
cartEggHunt.StartingLocation = Wherigo.INVALID_ZONEPOINT
cartEggHunt.Version=""
cartEggHunt.Company=""
cartEggHunt.Author=""
cartEggHunt.BuilderVersion="2.0.4807.4874"
cartEggHunt.CreateDate="3/21/2008 8:34:19 PM"
cartEggHunt.PublishDate="1/1/0001 12:00:00 AM"
cartEggHunt.UpdateDate="3/21/2008 8:57:32 PM"
cartEggHunt.LastPlayedDate="1/1/0001 12:00:00 AM"
cartEggHunt.TargetDevice="PocketPC"
cartEggHunt.TargetDeviceVersion="0"
cartEggHunt.StateId="1"
cartEggHunt.CountryId="2"
cartEggHunt.Complete=false
cartEggHunt.UseLogging=false

-- Zones --
zoneRedEgg1 = Wherigo.Zone(cartEggHunt)
zoneRedEgg1.Id="16e5dd7b-77c3-4c3e-b41a-57b256944d18"
zoneRedEgg1.Name="Red Egg"
zoneRedEgg1.Description=[[Red Eggs are worth 5 Points!]]
zoneRedEgg1.Visible=true
zoneRedEgg1.DistanceRange = Distance(-1, "feet")
zoneRedEgg1.ShowObjects="OnEnter"
zoneRedEgg1.ProximityRange = Distance(200, "feet")
zoneRedEgg1.AllowSetPositionTo=false
zoneRedEgg1.Active=true
zoneRedEgg1.Points = {
  ZonePoint(39.00814,-94.63366,0),
  ZonePoint(39.00816,-94.63367,0),
  ZonePoint(39.00816,-94.63364,0),
  ZonePoint(39.00811,-94.63358,0)
}
zoneRedEgg1.OriginalPoint = ZonePoint(39.00814,-94.63366,0)
zoneRedEgg1.DistanceRangeUOM = "Feet"
zoneRedEgg1.ProximityRangeUOM = "Feet"
zoneRedEgg1.OutOfRangeName = ""
zoneRedEgg1.InRangeName = ""

zoneRedEgg2 = Wherigo.Zone(cartEggHunt)
zoneRedEgg2.Id="16e5dd7b-77c3-4c3e-b41a-57b256944d19"
zoneRedEgg2.Name="Red Egg"
zoneRedEgg2.Description=[[Red Eggs are worth 5 Points!]]
zoneRedEgg2.Visible=true
zoneRedEgg2.DistanceRange = Distance(-1, "feet")
zoneRedEgg2.ShowObjects="OnEnter"
zoneRedEgg2.ProximityRange = Distance(200, "feet")
zoneRedEgg2.AllowSetPositionTo=false
zoneRedEgg2.Active=true
zoneRedEgg2.Points = {
  ZonePoint(39.00814,-94.63366,0),
  ZonePoint(39.00816,-94.63367,0),
  ZonePoint(39.00816,-94.63364,0),
  ZonePoint(39.00811,-94.63358,0)
}
zoneRedEgg2.OriginalPoint = ZonePoint(39.00814,-94.63366,0)
zoneRedEgg2.DistanceRangeUOM = "Feet"
zoneRedEgg2.ProximityRangeUOM = "Feet"
zoneRedEgg2.OutOfRangeName = ""
zoneRedEgg2.InRangeName = ""

zoneRedEgg3 = Wherigo.Zone(cartEggHunt)
zoneRedEgg3.Id="16e5dd7b-77c3-4c3e-b41a-57b256944d20"
zoneRedEgg3.Name="Red Egg"
zoneRedEgg3.Description=[[Red Eggs are worth 5 Points!]]
zoneRedEgg3.Visible=true
zoneRedEgg3.DistanceRange = Distance(-1, "feet")
zoneRedEgg3.ShowObjects="OnEnter"
zoneRedEgg3.ProximityRange = Distance(200, "feet")
zoneRedEgg3.AllowSetPositionTo=false
zoneRedEgg3.Active=true
zoneRedEgg3.Points = {
  ZonePoint(39.00814,-94.63366,0),
  ZonePoint(39.00816,-94.63367,0),
  ZonePoint(39.00816,-94.63364,0),
  ZonePoint(39.00811,-94.63358,0)
}
zoneRedEgg3.OriginalPoint = ZonePoint(39.00814,-94.63366,0)
zoneRedEgg3.DistanceRangeUOM = "Feet"
zoneRedEgg3.ProximityRangeUOM = "Feet"
zoneRedEgg3.OutOfRangeName = ""
zoneRedEgg3.InRangeName = ""

zoneRedEgg4 = Wherigo.Zone(cartEggHunt)
zoneRedEgg4.Id="16e5dd7b-77c3-4c3e-b41a-57b256944d21"
zoneRedEgg4.Name="Red Egg"
zoneRedEgg4.Description=[[Red Eggs are worth 5 Points!]]
zoneRedEgg4.Visible=true
zoneRedEgg4.DistanceRange = Distance(-1, "feet")
zoneRedEgg4.ShowObjects="OnEnter"
zoneRedEgg4.ProximityRange = Distance(200, "feet")
zoneRedEgg4.AllowSetPositionTo=false
zoneRedEgg4.Active=true
zoneRedEgg4.Points = {
  ZonePoint(39.00814,-94.63366,0),
  ZonePoint(39.00816,-94.63367,0),
  ZonePoint(39.00816,-94.63364,0),
  ZonePoint(39.00811,-94.63358,0)
}
zoneRedEgg4.OriginalPoint = ZonePoint(39.00814,-94.63366,0)
zoneRedEgg4.DistanceRangeUOM = "Feet"
zoneRedEgg4.ProximityRangeUOM = "Feet"
zoneRedEgg4.OutOfRangeName = ""
zoneRedEgg4.InRangeName = ""

zoneBlueEgg1 = Wherigo.Zone(cartEggHunt)
zoneBlueEgg1.Id="f807c28e-a10f-4972-b5b5-8e3145aa3152"
zoneBlueEgg1.Name="Blue Egg"
zoneBlueEgg1.Description=[[Blue Eggs are worth 10 Points!]]
zoneBlueEgg1.Visible=true
zoneBlueEgg1.DistanceRange = Distance(-1, "feet")
zoneBlueEgg1.ShowObjects="OnEnter"
zoneBlueEgg1.ProximityRange = Distance(200, "feet")
zoneBlueEgg1.AllowSetPositionTo=false
zoneBlueEgg1.Active=true
zoneBlueEgg1.Points = {
  ZonePoint(39.00827,-94.63334,0),
  ZonePoint(39.00831,-94.63334,0),
  ZonePoint(39.00831,-94.63328,0),
  ZonePoint(39.00822,-94.63328,0)
}
zoneBlueEgg1.OriginalPoint = ZonePoint(39.00827,-94.63334,0)
zoneBlueEgg1.DistanceRangeUOM = "Feet"
zoneBlueEgg1.ProximityRangeUOM = "Feet"
zoneBlueEgg1.OutOfRangeName = ""
zoneBlueEgg1.InRangeName = ""

zoneBlueEgg2 = Wherigo.Zone(cartEggHunt)
zoneBlueEgg2.Id="f807c28e-a10f-4972-b5b5-8e3145aa3153"
zoneBlueEgg2.Name="Blue Egg"
zoneBlueEgg2.Description=[[Blue Eggs are worth 10 Points!]]
zoneBlueEgg2.Visible=true
zoneBlueEgg2.DistanceRange = Distance(-1, "feet")
zoneBlueEgg2.ShowObjects="OnEnter"
zoneBlueEgg2.ProximityRange = Distance(200, "feet")
zoneBlueEgg2.AllowSetPositionTo=false
zoneBlueEgg2.Active=true
zoneBlueEgg2.Points = {
  ZonePoint(39.00827,-94.63334,0),
  ZonePoint(39.00831,-94.63334,0),
  ZonePoint(39.00831,-94.63328,0),
  ZonePoint(39.00822,-94.63328,0)
}
zoneBlueEgg2.OriginalPoint = ZonePoint(39.00827,-94.63334,0)
zoneBlueEgg2.DistanceRangeUOM = "Feet"
zoneBlueEgg2.ProximityRangeUOM = "Feet"
zoneBlueEgg2.OutOfRangeName = ""
zoneBlueEgg2.InRangeName = ""

zoneBlueEgg3 = Wherigo.Zone(cartEggHunt)
zoneBlueEgg3.Id="f807c28e-a10f-4972-b5b5-8e3145aa3154"
zoneBlueEgg3.Name="Blue Egg"
zoneBlueEgg3.Description=[[Blue Eggs are worth 10 Points!]]
zoneBlueEgg3.Visible=true
zoneBlueEgg3.DistanceRange = Distance(-1, "feet")
zoneBlueEgg3.ShowObjects="OnEnter"
zoneBlueEgg3.ProximityRange = Distance(200, "feet")
zoneBlueEgg3.AllowSetPositionTo=false
zoneBlueEgg3.Active=true
zoneBlueEgg3.Points = {
  ZonePoint(39.00827,-94.63334,0),
  ZonePoint(39.00831,-94.63334,0),
  ZonePoint(39.00831,-94.63328,0),
  ZonePoint(39.00822,-94.63328,0)
}
zoneBlueEgg3.OriginalPoint = ZonePoint(39.00827,-94.63334,0)
zoneBlueEgg3.DistanceRangeUOM = "Feet"
zoneBlueEgg3.ProximityRangeUOM = "Feet"
zoneBlueEgg3.OutOfRangeName = ""
zoneBlueEgg3.InRangeName = ""

zoneBlueEgg4 = Wherigo.Zone(cartEggHunt)
zoneBlueEgg4.Id="f807c28e-a10f-4972-b5b5-8e3145aa3155"
zoneBlueEgg4.Name="Blue Egg"
zoneBlueEgg4.Description=[[Blue Eggs are worth 10 Points!]]
zoneBlueEgg4.Visible=true
zoneBlueEgg4.DistanceRange = Distance(-1, "feet")
zoneBlueEgg4.ShowObjects="OnEnter"
zoneBlueEgg4.ProximityRange = Distance(200, "feet")
zoneBlueEgg4.AllowSetPositionTo=false
zoneBlueEgg4.Active=true
zoneBlueEgg4.Points = {
  ZonePoint(39.00827,-94.63334,0),
  ZonePoint(39.00831,-94.63334,0),
  ZonePoint(39.00831,-94.63328,0),
  ZonePoint(39.00822,-94.63328,0)
}
zoneBlueEgg4.OriginalPoint = ZonePoint(39.00827,-94.63334,0)
zoneBlueEgg4.DistanceRangeUOM = "Feet"
zoneBlueEgg4.ProximityRangeUOM = "Feet"
zoneBlueEgg4.OutOfRangeName = ""
zoneBlueEgg4.InRangeName = ""

zoneGoldEgg = Wherigo.Zone(cartEggHunt)
zoneGoldEgg.Id="36ef3da1-dc35-4941-a113-35ee8e953866"
zoneGoldEgg.Name="Gold Egg"
zoneGoldEgg.Description=[[Golden Eggs are worth 25 Points!]]
zoneGoldEgg.Visible=true
zoneGoldEgg.DistanceRange = Distance(-1, "feet")
zoneGoldEgg.ShowObjects="OnEnter"
zoneGoldEgg.ProximityRange = Distance(200, "feet")
zoneGoldEgg.AllowSetPositionTo=false
zoneGoldEgg.Active=true
zoneGoldEgg.Points = {
  ZonePoint(39.00814,-94.63334,0),
  ZonePoint(39.00815,-94.63334,0),
  ZonePoint(39.00814,-94.6333,0),
  ZonePoint(39.00811,-94.63327,0)
}
zoneGoldEgg.OriginalPoint = ZonePoint(39.00814,-94.63334,0)
zoneGoldEgg.DistanceRangeUOM = "Feet"
zoneGoldEgg.ProximityRangeUOM = "Feet"
zoneGoldEgg.OutOfRangeName = ""
zoneGoldEgg.InRangeName = ""

zoneMoldEgg = Wherigo.Zone(cartEggHunt)
zoneMoldEgg.Id="36ef3da1-dc35-4941-a113-35ee8e953867"
zoneMoldEgg.Name="Rotten Egg"
zoneMoldEgg.Description=[[Rotten Eggs remove all your points!]]
zoneMoldEgg.Visible=true
zoneMoldEgg.DistanceRange = Distance(-1, "feet")
zoneMoldEgg.ShowObjects="OnEnter"
zoneMoldEgg.ProximityRange = Distance(200, "feet")
zoneMoldEgg.AllowSetPositionTo=false
zoneMoldEgg.Active=true
zoneMoldEgg.Points = {
  ZonePoint(39.00814,-94.63334,0),
  ZonePoint(39.00815,-94.63334,0),
  ZonePoint(39.00814,-94.6333,0),
  ZonePoint(39.00811,-94.63327,0)
}
zoneMoldEgg.OriginalPoint = ZonePoint(39.00814,-94.63334,0)
zoneMoldEgg.DistanceRangeUOM = "Feet"
zoneMoldEgg.ProximityRangeUOM = "Feet"
zoneMoldEgg.OutOfRangeName = ""
zoneMoldEgg.InRangeName = ""

-- Characters --

-- Items --

-- Tasks --

-- Cartridge Variables --
Points = 0
cartEggHunt.ZVariables = {Points = 0}

-- Builder Variables (to be read by the builder only) --
buildervar = {}
buildervar.Points = {}
buildervar.Points.Id ="17e47cb8-e82a-4841-8158-ca9fa894be02"
buildervar.Points.Name = "Points"
buildervar.Points.Type = "Number"
buildervar.Points.Data=[[0]]
buildervar.Points.Description=[[]]


-- ZTimers --
ztimerFiveSecondTimer = Wherigo.ZTimer(cartEggHunt)
ztimerFiveSecondTimer.Id="da2dd31d-2d78-480c-94f1-018c8de2f831"
ztimerFiveSecondTimer.Name="FiveSecondTimer"
ztimerFiveSecondTimer.Description=[[Starts when cartridge is launched.  When it fires, eggs are hidden.]]
ztimerFiveSecondTimer.Visible=true
ztimerFiveSecondTimer.Duration=2
ztimerFiveSecondTimer.Type="Countdown"

ztimerFiveMinuteTimer = Wherigo.ZTimer(cartEggHunt)
ztimerFiveMinuteTimer.Id="7c7d43ac-02d6-4129-bc5c-49b9fd2f99e1"
ztimerFiveMinuteTimer.Name="FiveMinuteTimer"
ztimerFiveMinuteTimer.Description=[[Starts once eggs are placed and hunt begins.  ]]
ztimerFiveMinuteTimer.Visible=true
ztimerFiveMinuteTimer.Duration=300
ztimerFiveMinuteTimer.Type="Countdown"

-- Inputs --

--
-- Events/Conditions/Actions --
--

-------------------------------------------------------------------------------
------Builder Generated functions, Do not Edit, this will be overwritten------
-------------------------------------------------------------------------------

function zoneBlueEgg1:OnEnter()
-- #GroupDescription=Script --
-- #Comment=Script Comment --
if   zoneBlueEgg1.Visible == true then
Wherigo.MessageBox{Text=[[You found a blue egg!!!

Five points for you!!!

Quick, find another egg!!!]],}
zoneBlueEgg1.Visible = false
Points = Points + 5
end
end

function zoneBlueEgg2:OnEnter()
-- #GroupDescription=Script --
-- #Comment=Script Comment --
if   zoneBlueEgg2.Visible == true then
Wherigo.MessageBox{Text=[[You found a blue egg!!!

Five points for you!!!

Quick, find another egg!!!]],}
zoneBlueEgg2.Visible = false
Points = Points + 5
end
end

function zoneBlueEgg3:OnEnter()
-- #GroupDescription=Script --
-- #Comment=Script Comment --
if   zoneBlueEgg3.Visible == true then
Wherigo.MessageBox{Text=[[You found a blue egg!!!

Five points for you!!!

Quick, find another egg!!!]],}
zoneBlueEgg3.Visible = false
Points = Points + 5
end
end

function zoneBlueEgg4:OnEnter()
-- #GroupDescription=Script --
-- #Comment=Script Comment --
if   zoneBlueEgg4.Visible == true then
Wherigo.MessageBox{Text=[[You found a blue egg!!!

Five points for you!!!

Quick, find another egg!!!]],}
zoneBlueEgg4.Visible = false
Points = Points + 5
end
end

function zoneGoldEgg:OnEnter()
-- #GroupDescription=Script --
-- #Comment=Script Comment --
if   zoneGoldEgg.Visible == true then
Wherigo.MessageBox{Text=[[You found a gold egg!!!

Gold eggs are worth 25 points!!!

Quick, find another egg!!!]],}
zoneGoldEgg.Visible = false
Points = Points + 25
end
end

function zoneMoldEgg:OnEnter()
-- #GroupDescription=Script --
-- #Comment=Script Comment --
if   zoneMoldEgg.Visible == true then
Wherigo.MessageBox{Text=[[You found a rotten egg!!!

Rotten eggs spoil the whole basket, removing all your points!!!

Quick, find another egg!!!]],}
zoneMoldEgg.Visible = false
Points = 0
end
end

function zoneRedEgg1:OnEnter()
-- #GroupDescription=Script --
-- #Comment=Script Comment --
if   zoneRedEgg1.Visible == true then
Wherigo.MessageBox{Text=[[You found a red egg!!!

Red eggs are worth 10 points!!!

Quick, find another egg!!!]],}
zoneRedEgg1.Visible = false
Points = Points + 10
end
end

function zoneRedEgg2:OnEnter()
-- #GroupDescription=Script --
-- #Comment=Script Comment --
if   zoneRedEgg2.Visible == true then
Wherigo.MessageBox{Text=[[You found a red egg!!!

Red eggs are worth 10 points!!!

Quick, find another egg!!!]],}
zoneRedEgg2.Visible = false
Points = Points + 10
end
end

function zoneRedEgg3:OnEnter()
-- #GroupDescription=Script --
-- #Comment=Script Comment --
if   zoneRedEgg3.Visible == true then
Wherigo.MessageBox{Text=[[You found a red egg!!!

Red eggs are worth 10 points!!!

Quick, find another egg!!!]],}
zoneRedEgg3.Visible = false
Points = Points + 10
end
end

function zoneRedEgg4:OnEnter()
-- #GroupDescription=Script --
-- #Comment=Script Comment --
if   zoneRedEgg4.Visible == true then
Wherigo.MessageBox{Text=[[You found a red egg!!!

Red eggs are worth 10 points!!!

Quick, find another egg!!!]],}
zoneRedEgg4.Visible = false
Points = Points + 10
end
end

function cartEggHunt:OnStart()
-- #GroupDescription=Script --
-- #Comment=Script Comment --
Wherigo.MessageBox{Text=[[By the time you finish reading this, you will be surrounded by virtual eggs.  Some will be blue eggs, some will be red eggs, and a few will be golden eggs.  Blue eggs are worth 5 points.  Red eggs are worth 10 points, and the rare golden eggs are worth 25 points!

You'll have five minutes to gather as many eggs as possible.  Try and collect as many points as possible!

Take a deep breath, count to five, press OK and let the fun begin!!!]],Callback=cartEggHunt.MsgBoxCBFuncs.MsgBoxCB1}
ztimerFiveSecondTimer:Start()
ztimerFiveMinuteTimer:Start()
end

function ztimerFiveMinuteTimer:OnTick()
-- #GroupDescription=Script --
-- #Comment=Script Comment --
Wherigo.MessageBox{Text=[[Your Time is Up!!!!

You collected ]]..Points..[[ points worth of eggs!

Congratulations!]],}
zoneGoldEgg.Visible = false
zoneMoldEgg.Visible = false
zoneBlueEgg1.Visible = false
zoneRedEgg1.Visible = false
zoneBlueEgg2.Visible = false
zoneRedEgg2.Visible = false
zoneBlueEgg3.Visible = false
zoneRedEgg3.Visible = false
zoneBlueEgg4.Visible = false
zoneRedEgg4.Visible = false
cartEggHunt.Complete=true
end

function ztimerFiveSecondTimer:OnTick()
-- #GroupDescription=MoveTheZones --
-- #Comment=MoveTheZones Comment --
local rand_dist = math.random(25, 75)
local rand_ang = math.random(1, 359)
local dist = Wherigo.Distance(rand_dist, 'ft')
local newZp = Wherigo.TranslatePoint(Player.ObjectLocation, dist, rand_ang)   -- new center point for the new zone	
zoneGoldEgg.Points = GetZonePoints(newZp, 5)

rand_dist = math.random(25, 75)
rand_ang = math.random(1, 359)
dist = Wherigo.Distance(rand_dist, 'ft')
newZp = Wherigo.TranslatePoint(Player.ObjectLocation, dist, rand_ang)   -- new center point for the new zone	
zoneMoldEgg.Points = GetZonePoints(newZp, 10)

rand_dist = math.random(25, 75)
rand_ang = math.random(1, 359)
dist = Wherigo.Distance(rand_dist, 'ft')
newZp = Wherigo.TranslatePoint(Player.ObjectLocation, dist, rand_ang)   -- new center point for the new zone	
zoneBlueEgg1.Points = GetZonePoints(newZp, 15)

rand_dist = math.random(25, 75)
rand_ang = math.random(1, 359)
dist = Wherigo.Distance(rand_dist, 'ft')
newZp = Wherigo.TranslatePoint(Player.ObjectLocation, dist, rand_ang)   -- new center point for the new zone	
zoneRedEgg1.Points = GetZonePoints(newZp, 10)

rand_dist = math.random(25, 75)
rand_ang = math.random(1, 359)
dist = Wherigo.Distance(rand_dist, 'ft')
newZp = Wherigo.TranslatePoint(Player.ObjectLocation, dist, rand_ang)   -- new center point for the new zone	
zoneBlueEgg2.Points = GetZonePoints(newZp, 15)

rand_dist = math.random(25, 75)
rand_ang = math.random(1, 359)
dist = Wherigo.Distance(rand_dist, 'ft')
newZp = Wherigo.TranslatePoint(Player.ObjectLocation, dist, rand_ang)   -- new center point for the new zone	
zoneRedEgg2.Points = GetZonePoints(newZp, 10)

rand_dist = math.random(25, 75)
rand_ang = math.random(1, 359)
dist = Wherigo.Distance(rand_dist, 'ft')
newZp = Wherigo.TranslatePoint(Player.ObjectLocation, dist, rand_ang)   -- new center point for the new zone	
zoneBlueEgg3.Points = GetZonePoints(newZp, 15)

rand_dist = math.random(25, 75)
rand_ang = math.random(1, 359)
dist = Wherigo.Distance(rand_dist, 'ft')
newZp = Wherigo.TranslatePoint(Player.ObjectLocation, dist, rand_ang)   -- new center point for the new zone	
zoneRedEgg3.Points = GetZonePoints(newZp, 10)

rand_dist = math.random(25, 75)
rand_ang = math.random(1, 359)
dist = Wherigo.Distance(rand_dist, 'ft')
newZp = Wherigo.TranslatePoint(Player.ObjectLocation, dist, rand_ang)   -- new center point for the new zone	
zoneBlueEgg4.Points = GetZonePoints(newZp, 15)

rand_dist = math.random(25, 75)
rand_ang = math.random(1, 359)
dist = Wherigo.Distance(rand_dist, 'ft')
newZp = Wherigo.TranslatePoint(Player.ObjectLocation, dist, rand_ang)   -- new center point for the new zone	
zoneRedEgg4.Points = GetZonePoints(newZp, 10)
end

------End Builder Generated functions, Do not Edit, this will be overwritten------
-------------------------------------------------------------------------------
------Builder Generated callbacks, Do not Edit, this will be overwritten------
-------------------------------------------------------------------------------
--#LASTCALLBACKKEY=0#--
------End Builder Generated callbacks, Do not Edit, this will be overwritten------
-- #Author Functions Go Here# --

function GetZonePoints(refPt, radius)
  local dist = Wherigo.Distance(radius, 'ft')
  local pts = {
    Wherigo.TranslatePoint(refPt, dist, 22.5),
    Wherigo.TranslatePoint(refPt, dist, 67.5),
    Wherigo.TranslatePoint(refPt, dist, 112.5),
    Wherigo.TranslatePoint(refPt, dist, 157.5),
    Wherigo.TranslatePoint(refPt, dist, 202.5),
    Wherigo.TranslatePoint(refPt, dist, 247.5),
    Wherigo.TranslatePoint(refPt, dist, 292.5),
    Wherigo.TranslatePoint(refPt, dist, 337.5),
  }
  return pts
end

-- #End Author Functions# --
-- Nothing after this line --
return cartEggHunt
