require "Wherigo"
ZonePoint = Wherigo.ZonePoint
Distance = Wherigo.Distance
Player = Wherigo.Player

-- String decode --
function _MdKK(str)
	local res = ""
    local dtable = "\001\050\052\045\096\088\021\120\083\055\094\079\065\125\108\031\023\004\009\024\085\059\077\119\064\082\030\025\070\089\049\035\015\012\060\062\038\076\123\016\007\014\022\071\032\047\114\092\074\048\005\043\057\051\067\110\081\097\063\118\037\087\073\126\069\121\003\061\033\000\029\090\008\117\104\095\107\116\115\075\020\098\017\046\028\066\011\099\056\018\013\068\078\122\105\103\093\086\101\113\053\109\044\027\124\039\084\041\002\040\010\036\091\111\112\054\034\106\058\100\072\102\042\026\019\006\080"
	for i=1, #str do
        local b = str:byte(i)
        if b > 0 and b <= 0x7F then
	        res = res .. string.char(dtable:byte(b))
        else
            res = res .. string.char(b)
        end
	end
	return res
end

-- Internal functions --
require "table"
require "math"

math.randomseed(os.time())
math.random()
math.random()
math.random()

_Urwigo = {}

_Urwigo.InlineRequireLoaded = {}
_Urwigo.InlineRequireRes = {}
_Urwigo.InlineRequire = function(moduleName)
  local res
  if _Urwigo.InlineRequireLoaded[moduleName] == nil then
    res = _Urwigo.InlineModuleFunc[moduleName]()
    _Urwigo.InlineRequireLoaded[moduleName] = 1
    _Urwigo.InlineRequireRes[moduleName] = res
  else
    res = _Urwigo.InlineRequireRes[moduleName]
  end
  return res
end

_Urwigo.Round = function(num, idp)
  local mult = 10^(idp or 0)
  return math.floor(num * mult + 0.5) / mult
end

_Urwigo.Ceil = function(num, idp)
  local mult = 10^(idp or 0)
  return math.ceil(num * mult) / mult
end

_Urwigo.Floor = function(num, idp)
  local mult = 10^(idp or 0)
  return math.floor(num * mult) / mult
end

_Urwigo.DialogQueue = {}
_Urwigo.RunDialogs = function(callback)
	local dialogs = _Urwigo.DialogQueue
	local lastCallback = nil
	_Urwigo.DialogQueue = {}
	local msgcb = {}
	msgcb = function(action)
		if action ~= nil then
			if lastCallback ~= nil then
				lastCallback(action)
			end
			local entry = table.remove(dialogs, 1)
			if entry ~= nil then
				lastCallback = entry.Callback;
				if entry.Text ~= nil then
					Wherigo.MessageBox({Text = entry.Text, Media=entry.Media, Buttons=entry.Buttons, Callback=msgcb})
				else
					msgcb(action)
				end
			else
				if callback ~= nil then
					callback()
				end
			end
		end
	end
	msgcb(true) -- any non-null argument
end

_Urwigo.MessageBox = function(tbl)
    _Urwigo.RunDialogs(function() Wherigo.MessageBox(tbl) end)
end

_Urwigo.OldDialog = function(tbl)
    _Urwigo.RunDialogs(function() Wherigo.Dialog(tbl) end)
end

_Urwigo.Dialog = function(buffered, tbl, callback)
	for k,v in ipairs(tbl) do
		table.insert(_Urwigo.DialogQueue, v)
	end
	if callback ~= nil then
		table.insert(_Urwigo.DialogQueue, {Callback=callback})
	end
	if not buffered then
		_Urwigo.RunDialogs(nil)
	end
end

_Urwigo.Hash = function(str)
   local b = 378551;
   local a = 63689;
   local hash = 0;
   for i = 1, #str, 1 do
      hash = hash*a+string.byte(str,i);
      hash = math.fmod(hash, 65535)
      a = a*b;
      a = math.fmod(a, 65535)
   end
   return hash;
end

_Urwigo.DaysInMonth = {
	31,
	28,
	31,
	30,
	31,
	30,
	31,
	31,
	30,
	31,
	30,
	31,
}

_Urwigo_Date_IsLeapYear = function(year)
	if year % 400 == 0 then
		return true
	elseif year% 100 == 0 then
		return false
	elseif year % 4 == 0 then
		return true
	else
		return false
	end
end

_Urwigo.Date_DaysInMonth = function(year, month)
	if month ~= 2 then
		return _Urwigo.DaysInMonth[month];
	else
		if _Urwigo_Date_IsLeapYear(year) then
			return 29
		else
			return 28
		end
	end
end

_Urwigo.Date_DayInYear = function(t)
	local res = t.day
	for month = 1, t.month - 1 do
		res = res + _Urwigo.Date_DaysInMonth(t.year, month)
	end
	return res
end

_Urwigo.Date_HourInWeek = function(t)
	return t.hour + (t.wday-1) * 24
end

_Urwigo.Date_HourInMonth = function(t)
	return t.hour + t.day * 24
end

_Urwigo.Date_HourInYear = function(t)
	return t.hour + (_Urwigo.Date_DayInYear(t) - 1) * 24
end

_Urwigo.Date_MinuteInDay = function(t)
	return t.min + t.hour * 60
end

_Urwigo.Date_MinuteInWeek = function(t)
	return t.min + t.hour * 60 + (t.wday-1) * 1440;
end

_Urwigo.Date_MinuteInMonth = function(t)
	return t.min + t.hour * 60 + (t.day-1) * 1440;
end

_Urwigo.Date_MinuteInYear = function(t)
	return t.min + t.hour * 60 + (_Urwigo.Date_DayInYear(t) - 1) * 1440;
end

_Urwigo.Date_SecondInHour = function(t)
	return t.sec + t.min * 60
end

_Urwigo.Date_SecondInDay = function(t)
	return t.sec + t.min * 60 + t.hour * 3600
end

_Urwigo.Date_SecondInWeek = function(t)
	return t.sec + t.min * 60 + t.hour * 3600 + (t.wday-1) * 86400
end

_Urwigo.Date_SecondInMonth = function(t)
	return t.sec + t.min * 60 + t.hour * 3600 + (t.day-1) * 86400
end

_Urwigo.Date_SecondInYear = function(t)
	return t.sec + t.min * 60 + t.hour * 3600 + (_Urwigo.Date_DayInYear(t)-1) * 86400
end


-- Inlined modules --
_Urwigo.InlineModuleFunc = {}

_flZ = Wherigo.ZCartridge()

-- Media --
_LuX = Wherigo.ZMedia(_flZ)
_LuX.Id = "8d3d1b80-0d5c-4b78-ba15-af5f5171a60d"
_LuX.Name = "puma"
_LuX.Description = "puma na skale"
_LuX.AltText = ""
_LuX.Resources = {
	{
		Type = "jpg", 
		Filename = "Puma.jpg", 
		Directives = {}
	}
}
_8Drt = Wherigo.ZMedia(_flZ)
_8Drt.Id = "e34663f7-077a-4a8e-b01d-0a7174690a50"
_8Drt.Name = "sladp"
_8Drt.Description = "slad pumy odcisniety"
_8Drt.AltText = ""
_8Drt.Resources = {
	{
		Type = "jpg", 
		Filename = "slad_pumy.jpg", 
		Directives = {}
	}
}
_J6N = Wherigo.ZMedia(_flZ)
_J6N.Id = "33b8bf0f-e3b3-42b6-ba01-d3179a3e8a05"
_J6N.Name = "wilks"
_J6N.Description = "slad wilka"
_J6N.AltText = ""
_J6N.Resources = {
	{
		Type = "jpg", 
		Filename = "slad_wilka.jpg", 
		Directives = {}
	}
}
_Jbi = Wherigo.ZMedia(_flZ)
_Jbi.Id = "e47fac94-5fa3-4bc4-9ac9-bb7833f925fd"
_Jbi.Name = "bieg"
_Jbi.Description = "puma biegnie"
_Jbi.AltText = ""
_Jbi.Resources = {
	{
		Type = "jpg", 
		Filename = "bieg_pumy.jpg", 
		Directives = {}
	}
}
_RYau4 = Wherigo.ZMedia(_flZ)
_RYau4.Id = "ac4ff86c-b1ff-4bcd-896d-e25290446b9b"
_RYau4.Name = "skok"
_RYau4.Description = "puma atakuje"
_RYau4.AltText = ""
_RYau4.Resources = {
	{
		Type = "jpg", 
		Filename = "skokpumy.jpg", 
		Directives = {}
	}
}
_XRjne = Wherigo.ZMedia(_flZ)
_XRjne.Id = "704fe76f-e0fa-4104-a929-083dc663e0e2"
_XRjne.Name = "pumawidzi"
_XRjne.Description = "puma obserwuje"
_XRjne.AltText = ""
_XRjne.Resources = {
	{
		Type = "jpg", 
		Filename = "puma_obserwuje.jpg", 
		Directives = {}
	}
}
_Rh64 = Wherigo.ZMedia(_flZ)
_Rh64.Id = "e931cda8-a2e4-4c89-b54f-b877f265d3cb"
_Rh64.Name = "slad"
_Rh64.Description = "slad pumy jako wzor"
_Rh64.AltText = ""
_Rh64.Resources = {
	{
		Type = "png", 
		Filename = "Puma_slad.png", 
		Directives = {}
	}
}
_tFbeX = Wherigo.ZMedia(_flZ)
_tFbeX.Id = "d5437b6b-d31a-42a1-861c-ba131377defd"
_tFbeX.Name = "pistolet"
_tFbeX.Description = "Pistolet na strzalki"
_tFbeX.AltText = ""
_tFbeX.Resources = {
	{
		Type = "jpg", 
		Filename = "pistolet.jpg", 
		Directives = {}
	}
}
_iiEPM = Wherigo.ZMedia(_flZ)
_iiEPM.Id = "65ac2c68-093e-42d1-98a0-053eadf898d7"
_iiEPM.Name = "strzalka"
_iiEPM.Description = "Strzalka usypiajaca"
_iiEPM.AltText = ""
_iiEPM.Resources = {
	{
		Type = "jpg", 
		Filename = "strzalka.jpg", 
		Directives = {}
	}
}
_4bI7o = Wherigo.ZMedia(_flZ)
_4bI7o.Id = "14f57bd5-217f-4062-aaaa-496365bbce12"
_4bI7o.Name = "nasenna"
_4bI7o.Description = "strzalka nasenna"
_4bI7o.AltText = ""
_4bI7o.Resources = {
	{
		Type = "jpg", 
		Filename = "strzalka_sypia.jpg", 
		Directives = {}
	}
}
_aT9T = Wherigo.ZMedia(_flZ)
_aT9T.Id = "1bbc80cf-0554-4984-aa25-c9e761b144cf"
_aT9T.Name = "strzalka_icon"
_aT9T.Description = "ikonka strzalki"
_aT9T.AltText = ""
_aT9T.Resources = {
	{
		Type = "jpg", 
		Filename = "strzalka_icon.jpg", 
		Directives = {}
	}
}
_a6Yq = Wherigo.ZMedia(_flZ)
_a6Yq.Id = "d5b438f8-9235-43e2-ac3b-9743e0343351"
_a6Yq.Name = "pistolet_icon"
_a6Yq.Description = "ikonka pistoletu"
_a6Yq.AltText = ""
_a6Yq.Resources = {
	{
		Type = "jpg", 
		Filename = "pistolet_icon.jpg", 
		Directives = {}
	}
}
_XNC = Wherigo.ZMedia(_flZ)
_XNC.Id = "db6568a1-ebe1-4508-927f-f81d0e6d90dc"
_XNC.Name = "wujek"
_XNC.Description = ""
_XNC.AltText = ""
_XNC.Resources = {
	{
		Type = "jpg", 
		Filename = "wujek.jpg", 
		Directives = {}
	}
}
_Vpq = Wherigo.ZMedia(_flZ)
_Vpq.Id = "65380c08-4c8d-402a-8bc1-fc6cee0f697e"
_Vpq.Name = "sasiad"
_Vpq.Description = ""
_Vpq.AltText = ""
_Vpq.Resources = {
	{
		Type = "jpg", 
		Filename = "sasiad.jpg", 
		Directives = {}
	}
}
_gW59 = Wherigo.ZMedia(_flZ)
_gW59.Id = "34acf254-bbc8-40af-af82-e49ad5aaa246"
_gW59.Name = "harcerz"
_gW59.Description = ""
_gW59.AltText = ""
_gW59.Resources = {
	{
		Type = "jpg", 
		Filename = "harcerz.jpg", 
		Directives = {}
	}
}
_lytlT = Wherigo.ZMedia(_flZ)
_lytlT.Id = "14a0d933-9772-4d04-932b-35dce548181e"
_lytlT.Name = "harcerka"
_lytlT.Description = ""
_lytlT.AltText = ""
_lytlT.Resources = {
	{
		Type = "jpg", 
		Filename = "harcerka.jpg", 
		Directives = {}
	}
}
_mHL = Wherigo.ZMedia(_flZ)
_mHL.Id = "00cd4e95-b6d5-4c63-a816-946118a0235c"
_mHL.Name = "oboz"
_mHL.Description = ""
_mHL.AltText = ""
_mHL.Resources = {
	{
		Type = "jpg", 
		Filename = "oboz.jpg", 
		Directives = {}
	}
}
_N5j8 = Wherigo.ZMedia(_flZ)
_N5j8.Id = "4b07a915-286f-48f9-b180-cdd4f954cbf5"
_N5j8.Name = "Zuch"
_N5j8.Description = ""
_N5j8.AltText = ""
_N5j8.Resources = {
	{
		Type = "jpg", 
		Filename = "zuch.jpg", 
		Directives = {}
	}
}
_ibk_ = Wherigo.ZMedia(_flZ)
_ibk_.Id = "4028a689-02ef-4dcb-ba1b-7e7d9348ce30"
_ibk_.Name = "bieg_icon"
_ibk_.Description = ""
_ibk_.AltText = ""
_ibk_.Resources = {
	{
		Type = "jpg", 
		Filename = "bieg_pumy_icon.jpg", 
		Directives = {}
	}
}
_7w2n = Wherigo.ZMedia(_flZ)
_7w2n.Id = "3a458cc6-7a45-4bd6-91fb-48072127e245"
_7w2n.Name = "harcerka_icon"
_7w2n.Description = ""
_7w2n.AltText = ""
_7w2n.Resources = {
	{
		Type = "jpg", 
		Filename = "harcerka_icon.jpg", 
		Directives = {}
	}
}
_nNVb = Wherigo.ZMedia(_flZ)
_nNVb.Id = "d7da2334-98fb-4dde-a0b8-3418db2c841b"
_nNVb.Name = "harcerz_icon"
_nNVb.Description = ""
_nNVb.AltText = ""
_nNVb.Resources = {
	{
		Type = "jpg", 
		Filename = "harcerz_icon.jpg", 
		Directives = {}
	}
}
_DLc2X = Wherigo.ZMedia(_flZ)
_DLc2X.Id = "31b70191-964c-469f-97a3-1e9cf81d5c3f"
_DLc2X.Name = "oboz_icon"
_DLc2X.Description = ""
_DLc2X.AltText = ""
_DLc2X.Resources = {
	{
		Type = "jpg", 
		Filename = "oboz_icon.jpg", 
		Directives = {}
	}
}
_dZlH = Wherigo.ZMedia(_flZ)
_dZlH.Id = "9c43d1a4-3de8-4bbe-acab-7595575fe9fe"
_dZlH.Name = "wujek_icon"
_dZlH.Description = ""
_dZlH.AltText = ""
_dZlH.Resources = {
	{
		Type = "jpg", 
		Filename = "wujek_icon.jpg", 
		Directives = {}
	}
}
_Qlk = Wherigo.ZMedia(_flZ)
_Qlk.Id = "fdd21e88-0f1e-421f-acf7-e24442ee9cea"
_Qlk.Name = "sasiad_icon"
_Qlk.Description = ""
_Qlk.AltText = ""
_Qlk.Resources = {
	{
		Type = "jpg", 
		Filename = "sasiad_icon.jpg", 
		Directives = {}
	}
}
_hLsQx = Wherigo.ZMedia(_flZ)
_hLsQx.Id = "c5cf7565-c794-4d47-9f43-a07c1c4b714b"
_hLsQx.Name = "krolik"
_hLsQx.Description = ""
_hLsQx.AltText = ""
_hLsQx.Resources = {
	{
		Type = "jpg", 
		Filename = "krolik.jpg", 
		Directives = {}
	}
}
_M5x = Wherigo.ZMedia(_flZ)
_M5x.Id = "7444693b-7a49-42b1-9fb7-84efd8be1947"
_M5x.Name = "krolik_icon"
_M5x.Description = ""
_M5x.AltText = ""
_M5x.Resources = {
	{
		Type = "jpg", 
		Filename = "krolik_icon.jpg", 
		Directives = {}
	}
}
_1HfKF = Wherigo.ZMedia(_flZ)
_1HfKF.Id = "69a6fb0c-59b2-40c0-8b27-556b584806a7"
_1HfKF.Name = "babcia"
_1HfKF.Description = ""
_1HfKF.AltText = ""
_1HfKF.Resources = {
	{
		Type = "jpg", 
		Filename = "babcia.jpg", 
		Directives = {}
	}
}
_BFX_ = Wherigo.ZMedia(_flZ)
_BFX_.Id = "fa33b26e-8511-4d7b-8429-9da50e85771f"
_BFX_.Name = "babcia_icon"
_BFX_.Description = ""
_BFX_.AltText = ""
_BFX_.Resources = {
	{
		Type = "jpg", 
		Filename = "babcia_icon.jpg", 
		Directives = {}
	}
}
_2tk = Wherigo.ZMedia(_flZ)
_2tk.Id = "77457351-6896-4aa4-8bf0-7d3ae08dcdc3"
_2tk.Name = "spiaca"
_2tk.Description = "spiaca puma"
_2tk.AltText = ""
_2tk.Resources = {
	{
		Type = "jpg", 
		Filename = "spiaca_puma.jpg", 
		Directives = {}
	}
}
_fn0 = Wherigo.ZMedia(_flZ)
_fn0.Id = "8fb63703-b28b-4ca9-bc85-26a56486c142"
_fn0.Name = "spiaca_icon"
_fn0.Description = ""
_fn0.AltText = ""
_fn0.Resources = {
	{
		Type = "jpg", 
		Filename = "spiaca_puma_icon.jpg", 
		Directives = {}
	}
}
_HpkR = Wherigo.ZMedia(_flZ)
_HpkR.Id = "197a0c1d-7f3b-465f-b0d6-24c915ae8e4c"
_HpkR.Name = "puma_widzi_icon"
_HpkR.Description = ""
_HpkR.AltText = ""
_HpkR.Resources = {
	{
		Type = "jpg", 
		Filename = "puma_obserwuje_icon.jpg", 
		Directives = {}
	}
}
_ENuf = Wherigo.ZMedia(_flZ)
_ENuf.Id = "8074024f-1cde-4ae8-bcb3-b824fa64bb48"
_ENuf.Name = "slad_pumy_icon"
_ENuf.Description = ""
_ENuf.AltText = ""
_ENuf.Resources = {
	{
		Type = "jpg", 
		Filename = "slad_pumy_icon.jpg", 
		Directives = {}
	}
}
_U2RP = Wherigo.ZMedia(_flZ)
_U2RP.Id = "bb4ee60e-5bff-474f-9c8c-101f1a6c896c"
_U2RP.Name = "edzio_osp"
_U2RP.Description = ""
_U2RP.AltText = ""
_U2RP.Resources = {
	{
		Type = "jpg", 
		Filename = "osp_edzio.jpg", 
		Directives = {}
	}
}
_8Y9oR = Wherigo.ZMedia(_flZ)
_8Y9oR.Id = "3fb51bee-f8cc-47ed-a5d0-83b339579b3e"
_8Y9oR.Name = "kryjowka"
_8Y9oR.Description = ""
_8Y9oR.AltText = ""
_8Y9oR.Resources = {
	{
		Type = "jpg", 
		Filename = "kryjowka.jpg", 
		Directives = {}
	}
}
_NlzkX = Wherigo.ZMedia(_flZ)
_NlzkX.Id = "95bd36ad-a339-457a-8b7d-dfd19d0cddc5"
_NlzkX.Name = "kryjowka_icon"
_NlzkX.Description = ""
_NlzkX.AltText = ""
_NlzkX.Resources = {
	{
		Type = "jpg", 
		Filename = "kryjowka_icon.jpg", 
		Directives = {}
	}
}
_riB = Wherigo.ZMedia(_flZ)
_riB.Id = "1e90e50b-0944-43e7-bb60-9d1ef48eafcb"
_riB.Name = "andrzej_dom"
_riB.Description = ""
_riB.AltText = ""
_riB.Resources = {
	{
		Type = "jpg", 
		Filename = "dom_adrzeja.jpg", 
		Directives = {}
	}
}
_3NB = Wherigo.ZMedia(_flZ)
_3NB.Id = "af3fbb66-d4ea-4429-a678-528569e10585"
_3NB.Name = "andrzej_dom_icon"
_3NB.Description = ""
_3NB.AltText = ""
_3NB.Resources = {
	{
		Type = "jpg", 
		Filename = "dom_adrzeja_icon.jpg", 
		Directives = {}
	}
}
_SQ2Rg = Wherigo.ZMedia(_flZ)
_SQ2Rg.Id = "8be3dbe5-a2fa-4a89-819e-3e5223b1081d"
_SQ2Rg.Name = "gajowka"
_SQ2Rg.Description = ""
_SQ2Rg.AltText = ""
_SQ2Rg.Resources = {
	{
		Type = "jpg", 
		Filename = "gajowka.jpg", 
		Directives = {}
	}
}
_tw2dj = Wherigo.ZMedia(_flZ)
_tw2dj.Id = "0a9f3fdc-e4d1-4920-b87a-d5f538b47d65"
_tw2dj.Name = "gajowka_icon"
_tw2dj.Description = ""
_tw2dj.AltText = ""
_tw2dj.Resources = {
	{
		Type = "jpg", 
		Filename = "gajowka_icon.jpg", 
		Directives = {}
	}
}
_lAoB = Wherigo.ZMedia(_flZ)
_lAoB.Id = "e986d113-7333-4cc1-a491-8d8478400c05"
_lAoB.Name = "edzio_osp_icon"
_lAoB.Description = ""
_lAoB.AltText = ""
_lAoB.Resources = {
	{
		Type = "jpg", 
		Filename = "osp_edzio_icon.jpg", 
		Directives = {}
	}
}
_0sK = Wherigo.ZMedia(_flZ)
_0sK.Id = "4f361434-386e-4bb2-b02a-afb8f5433856"
_0sK.Name = "dab_icon"
_0sK.Description = ""
_0sK.AltText = ""
_0sK.Resources = {
	{
		Type = "jpg", 
		Filename = "stary_dab_icon.jpg", 
		Directives = {}
	}
}
_dWGMn = Wherigo.ZMedia(_flZ)
_dWGMn.Id = "15447fb7-5f7f-4115-877d-82ffba64e1e7"
_dWGMn.Name = "kosciol"
_dWGMn.Description = ""
_dWGMn.AltText = ""
_dWGMn.Resources = {
	{
		Type = "jpg", 
		Filename = "kosciol.jpg", 
		Directives = {}
	}
}
_mOw3 = Wherigo.ZMedia(_flZ)
_mOw3.Id = "a96294c7-8ae6-4e12-9966-af56f25aa4b4"
_mOw3.Name = "szkola"
_mOw3.Description = ""
_mOw3.AltText = ""
_mOw3.Resources = {
	{
		Type = "jpg", 
		Filename = "szkola.jpg", 
		Directives = {}
	}
}
_qZm = Wherigo.ZMedia(_flZ)
_qZm.Id = "a7f334a1-fd99-4e9c-bf29-9afd18425bf2"
_qZm.Name = "szkola_icon"
_qZm.Description = ""
_qZm.AltText = ""
_qZm.Resources = {
	{
		Type = "jpg", 
		Filename = "szkola_icon.jpg", 
		Directives = {}
	}
}
_9ri = Wherigo.ZMedia(_flZ)
_9ri.Id = "51fbba0b-79d9-470b-817e-b13e541cebd4"
_9ri.Name = "dab"
_9ri.Description = ""
_9ri.AltText = ""
_9ri.Resources = {
	{
		Type = "jpg", 
		Filename = "dab.jpg", 
		Directives = {}
	}
}
_Lrvwb = Wherigo.ZMedia(_flZ)
_Lrvwb.Id = "1079d2d2-eb6c-40dd-801a-db80eb3eda67"
_Lrvwb.Name = "Logo"
_Lrvwb.Description = ""
_Lrvwb.AltText = ""
_Lrvwb.Resources = {
	{
		Type = "jpg", 
		Filename = "logo_gry.jpg", 
		Directives = {}
	}
}
_f35_ = Wherigo.ZMedia(_flZ)
_f35_.Id = "2c3ed07a-f18e-468e-b6cb-9f22c53549cb"
_f35_.Name = "logo_icon"
_f35_.Description = ""
_f35_.AltText = ""
_f35_.Resources = {
	{
		Type = "jpg", 
		Filename = "logo_icon.jpg", 
		Directives = {}
	}
}
_5v3 = Wherigo.ZMedia(_flZ)
_5v3.Id = "05742fc1-daf7-4a13-91ef-0f7521713061"
_5v3.Name = "schowek"
_5v3.Description = ""
_5v3.AltText = ""
_5v3.Resources = {
	{
		Type = "jpg", 
		Filename = "skrysz2.jpg", 
		Directives = {}
	}
}
_O6vf5 = Wherigo.ZMedia(_flZ)
_O6vf5.Id = "697c668d-b9ce-4d36-9c7b-4e461dbf1b13"
_O6vf5.Name = "pole"
_O6vf5.Description = ""
_O6vf5.AltText = ""
_O6vf5.Resources = {
	{
		Type = "jpg", 
		Filename = "IMG_2806.jpg", 
		Directives = {}
	}
}
_gSEl = Wherigo.ZMedia(_flZ)
_gSEl.Id = "b9d242b8-823d-4188-a901-4da08d565255"
_gSEl.Name = "pole_icon"
_gSEl.Description = ""
_gSEl.AltText = ""
_gSEl.Resources = {
	{
		Type = "jpg", 
		Filename = "IMG_2806_icon.jpg", 
		Directives = {}
	}
}
_fxo9E = Wherigo.ZMedia(_flZ)
_fxo9E.Id = "1f595515-43ce-4b05-a418-2ab456439ec0"
_fxo9E.Name = "trop"
_fxo9E.Description = ""
_fxo9E.AltText = ""
_fxo9E.Resources = {
	{
		Type = "jpg", 
		Filename = "IMG_2807.jpg", 
		Directives = {}
	}
}
_2D_NT = Wherigo.ZMedia(_flZ)
_2D_NT.Id = "06cadb9e-b9ee-49ef-9088-20b9268da80a"
_2D_NT.Name = "trop_icon"
_2D_NT.Description = ""
_2D_NT.AltText = ""
_2D_NT.Resources = {
	{
		Type = "jpg", 
		Filename = "IMG_2807_icon.jpg", 
		Directives = {}
	}
}
_ElhF = Wherigo.ZMedia(_flZ)
_ElhF.Id = "4f385550-a362-4f27-bdc9-d128265e632e"
_ElhF.Name = "trop2"
_ElhF.Description = ""
_ElhF.AltText = ""
_ElhF.Resources = {
	{
		Type = "jpg", 
		Filename = "IMG_2808.jpg", 
		Directives = {}
	}
}
_Ol0 = Wherigo.ZMedia(_flZ)
_Ol0.Id = "7b8f0488-56e4-43ea-a306-5b919ec2c4b5"
_Ol0.Name = "trop2_icon"
_Ol0.Description = ""
_Ol0.AltText = ""
_Ol0.Resources = {
	{
		Type = "jpg", 
		Filename = "IMG_2808_icon.jpg", 
		Directives = {}
	}
}
_z2IxN = Wherigo.ZMedia(_flZ)
_z2IxN.Id = "63f52adc-31ec-4484-ab1e-6cdc3fdc644e"
_z2IxN.Name = "trop3"
_z2IxN.Description = ""
_z2IxN.AltText = ""
_z2IxN.Resources = {
	{
		Type = "jpg", 
		Filename = "IMG_2809.jpg", 
		Directives = {}
	}
}
_otE = Wherigo.ZMedia(_flZ)
_otE.Id = "fbd2c1fc-1f29-45b5-86e0-e53516c92de7"
_otE.Name = "trop3_icon"
_otE.Description = ""
_otE.AltText = ""
_otE.Resources = {
	{
		Type = "jpg", 
		Filename = "IMG_2809_icon.jpg", 
		Directives = {}
	}
}
_2kgv = Wherigo.ZMedia(_flZ)
_2kgv.Id = "a0a7bd21-22fa-44b9-b9c6-24340782601c"
_2kgv.Name = "za_woda"
_2kgv.Description = ""
_2kgv.AltText = ""
_2kgv.Resources = {
	{
		Type = "jpg", 
		Filename = "IMG_2811.jpg", 
		Directives = {}
	}
}
_N8Gud = Wherigo.ZMedia(_flZ)
_N8Gud.Id = "f37baeb7-922e-459c-95ae-93b30e8c91fb"
_N8Gud.Name = "za_woda_icon"
_N8Gud.Description = ""
_N8Gud.AltText = ""
_N8Gud.Resources = {
	{
		Type = "jpg", 
		Filename = "IMG_2811_icon.jpg", 
		Directives = {}
	}
}
-- Cartridge Info --
_flZ.Id="bdb18661-dde0-448b-8e59-0180fb9a443c"
_flZ.Name="Polowanie na pume"
_flZ.Description=[[Pewnego dnia w spokojne wsi Bazanowice, na poludniu Polski pojawila sie puma. Niewiadomo jak sie tu dostala, ale jest i straszy ludzi oraz pozera ich zwierzeta. Naszym celem jest znalesc ja.
[CZ]
Jednoho dne se v klidne obci Bazanowice, na jihu Polska, objevila puma . Neni znamo jak se sem dostal, ale desi lidi a pozira a jejich dobytek. Nasim cilem je najit ji.]]
_flZ.Visible=true
_flZ.Activity="Fiction"
_flZ.StartingLocationDescription=[[Cala gra przebiega we wsi Bazanowice.
[CZ]
Cela hra probiha v obci Bazanovice]]
_flZ.StartingLocation = ZonePoint(49.7385222407137,18.6994184553623,0)
_flZ.Version="1.5"
_flZ.Company="STB"
_flZ.Author="StachoB"
_flZ.BuilderVersion="URWIGO 1.14.4469.18959"
_flZ.CreateDate="09/06/2011 22:02:09"
_flZ.PublishDate="1/1/0001 12:00:00 AM"
_flZ.UpdateDate="10/08/2012 18:39:39"
_flZ.LastPlayedDate="1/1/0001 12:00:00 AM"
_flZ.TargetDevice="PocketPC"
_flZ.TargetDeviceVersion="0"
_flZ.StateId="1"
_flZ.CountryId="2"
_flZ.Complete=false
_flZ.UseLogging=true

_flZ.Media=_Lrvwb

_flZ.Icon=_f35_


-- Zones --
_3u7F2 = Wherigo.Zone(_flZ)
_3u7F2.Id = "ed687e03-e31c-4c66-99d2-43a937a20b2a"
_3u7F2.Name = "Tu to sie zaczelo"
_3u7F2.Description = [[Miejsce, gdzie wszystko sie zaczelo.
[CZ]
Misto, kde vsechno zacalo.]]
_3u7F2.Visible = true
_3u7F2.Media = _LuX
_3u7F2.Commands = {}
_3u7F2.DistanceRange = Distance(-1, "feet")
_3u7F2.ShowObjects = "OnEnter"
_3u7F2.ProximityRange = Distance(60, "meters")
_3u7F2.AllowSetPositionTo = false
_3u7F2.Active = false
_3u7F2.Points = {
	ZonePoint(49.738206751857, 18.7029080092907, 0), 
	ZonePoint(49.7379337309983, 18.7028583884239, 0), 
	ZonePoint(49.7379198632312, 18.7029267847538, 0), 
	ZonePoint(49.7383514956257, 18.7030179798603, 0), 
	ZonePoint(49.7383861647278, 18.7029334902763, 0), 
	ZonePoint(49.7383332943372, 18.7027913331985, 0)
}
_3u7F2.OriginalPoint = ZonePoint(49.7381885501295, 18.7029059976339, 0)
_3u7F2.DistanceRangeUOM = "Feet"
_3u7F2.ProximityRangeUOM = "Meters"
_3u7F2.OutOfRangeName = ""
_3u7F2.InRangeName = ""
_WbYdt = Wherigo.Zone(_flZ)
_WbYdt.Id = "6969d86e-77fa-4386-a899-b16f43a13602"
_WbYdt.Name = "Wujek Andrzej"
_WbYdt.Description = [[Tutaj spotkasz wujka Andrzeja.

]]
_WbYdt.Visible = true
_WbYdt.Media = _riB
_WbYdt.Icon = _3NB
_WbYdt.Commands = {}
_WbYdt.DistanceRange = Distance(-1, "feet")
_WbYdt.ShowObjects = "OnEnter"
_WbYdt.ProximityRange = Distance(60, "meters")
_WbYdt.AllowSetPositionTo = false
_WbYdt.Active = false
_WbYdt.Points = {
	ZonePoint(49.7378097876887, 18.7056760489941, 0), 
	ZonePoint(49.7377846522936, 18.7055017054081, 0), 
	ZonePoint(49.737718780162, 18.7051382660866, 0), 
	ZonePoint(49.7376633088239, 18.7051610648632, 0), 
	ZonePoint(49.7376676425245, 18.7056908011436, 0), 
	ZonePoint(49.7376113043868, 18.7058141827583, 0), 
	ZonePoint(49.7376823771035, 18.7057766318321, 0)
}
_WbYdt.OriginalPoint = ZonePoint(49.737705407569, 18.705536957298, 0)
_WbYdt.DistanceRangeUOM = "Feet"
_WbYdt.ProximityRangeUOM = "Meters"
_WbYdt.OutOfRangeName = ""
_WbYdt.InRangeName = ""
_dRG = Wherigo.Zone(_flZ)
_dRG.Id = "b975d19b-46db-4e48-ab03-95a739b17ef4"
_dRG.Name = "spotkanie"
_dRG.Description = "spotkanie z harcerzem"
_dRG.Visible = false
_dRG.Media = _gW59
_dRG.Commands = {}
_dRG.DistanceRange = Distance(20, "meters")
_dRG.ShowObjects = "OnEnter"
_dRG.ProximityRange = Distance(10, "meters")
_dRG.AllowSetPositionTo = false
_dRG.Active = false
_dRG.Points = {
	ZonePoint(49.73747869282, 18.7056666612625, 0), 
	ZonePoint(49.7376104376457, 18.7060207128525, 0), 
	ZonePoint(49.7369811795289, 18.7063881754875, 0), 
	ZonePoint(49.7367350212408, 18.7064605951309, 0), 
	ZonePoint(49.7368268973677, 18.7059885263443, 0), 
	ZonePoint(49.7370227836233, 18.7060180306435, 0)
}
_dRG.OriginalPoint = ZonePoint(49.7371091687044, 18.7060904502869, 0)
_dRG.DistanceRangeUOM = "Meters"
_dRG.ProximityRangeUOM = "Meters"
_dRG.OutOfRangeName = ""
_dRG.InRangeName = ""
_L2PMk = Wherigo.Zone(_flZ)
_L2PMk.Id = "0898977f-758b-45f9-96c5-cc1e8fc54c80"
_L2PMk.Name = "Oboz Harcerzy"
_L2PMk.Description = [[Harcerze posiadaja strzalki usypiajace.
[CZ]
Tabor Skautu, ma uspavaci sipky.]]
_L2PMk.Visible = true
_L2PMk.Media = _mHL
_L2PMk.Icon = _DLc2X
_L2PMk.Commands = {}
_L2PMk.DistanceRange = Distance(-1, "feet")
_L2PMk.ShowObjects = "OnEnter"
_L2PMk.ProximityRange = Distance(56, "meters")
_L2PMk.AllowSetPositionTo = false
_L2PMk.Active = false
_L2PMk.Points = {
	ZonePoint(49.7454035477272, 18.6952476203442, 0), 
	ZonePoint(49.7453099546325, 18.6952556669712, 0), 
	ZonePoint(49.7453168874605, 18.6962373554707, 0), 
	ZonePoint(49.7454226129652, 18.6962775886059, 0)
}
_L2PMk.OriginalPoint = ZonePoint(49.7453632506964, 18.695754557848, 0)
_L2PMk.DistanceRangeUOM = "Feet"
_L2PMk.ProximityRangeUOM = "Meters"
_L2PMk.OutOfRangeName = ""
_L2PMk.InRangeName = ""
_d3oy = Wherigo.Zone(_flZ)
_d3oy.Id = "e3961898-b65e-4206-9c1d-ee609fddaf6d"
_d3oy.Name = "Puma ucieka"
_d3oy.Description = "puma ucieka"
_d3oy.Visible = false
_d3oy.Media = _Jbi
_d3oy.Commands = {}
_d3oy.DistanceRange = Distance(-1, "feet")
_d3oy.ShowObjects = "OnEnter"
_d3oy.ProximityRange = Distance(60, "meters")
_d3oy.AllowSetPositionTo = false
_d3oy.Active = false
_d3oy.Points = {
	ZonePoint(49.741574749482, 18.7029321491718, 0), 
	ZonePoint(49.7416882831567, 18.7029093503952, 0), 
	ZonePoint(49.7417038831829, 18.7030300498009, 0), 
	ZonePoint(49.7415964162343, 18.7030890583992, 0)
}
_d3oy.OriginalPoint = ZonePoint(49.741640833014, 18.7029901519418, 0)
_d3oy.DistanceRangeUOM = "Feet"
_d3oy.ProximityRangeUOM = "Meters"
_d3oy.OutOfRangeName = ""
_d3oy.InRangeName = ""
_z3wi3 = Wherigo.Zone(_flZ)
_z3wi3.Id = "96f1b072-68be-4c68-860f-f664a19f7ffe"
_z3wi3.Name = "atak"
_z3wi3.Description = "atak na pume"
_z3wi3.Visible = false
_z3wi3.Media = _RYau4
_z3wi3.Commands = {}
_z3wi3.DistanceRange = Distance(-1, "feet")
_z3wi3.ShowObjects = "OnEnter"
_z3wi3.ProximityRange = Distance(46, "meters")
_z3wi3.AllowSetPositionTo = false
_z3wi3.Active = false
_z3wi3.Points = {
	ZonePoint(49.7386786842903, 18.7082254886627, 0), 
	ZonePoint(49.7382331871285, 18.7083837389946, 0), 
	ZonePoint(49.7380997105289, 18.7079760432243, 0), 
	ZonePoint(49.7384360015186, 18.7077735364437, 0)
}
_z3wi3.OriginalPoint = ZonePoint(49.7383618958666, 18.7080897018313, 0)
_z3wi3.DistanceRangeUOM = "Feet"
_z3wi3.ProximityRangeUOM = "Meters"
_z3wi3.OutOfRangeName = ""
_z3wi3.InRangeName = ""
__HHN3 = Wherigo.Zone(_flZ)
__HHN3.Id = "7858faa6-8b22-4770-a9eb-a3213edd38e0"
__HHN3.Name = "Trop"
__HHN3.Description = [[Slad jaki zostawila puma.

Stopa, kterou nechala puma.]]
__HHN3.Visible = true
__HHN3.Media = _8Drt
__HHN3.Icon = _ENuf
__HHN3.Commands = {}
__HHN3.DistanceRange = Distance(-1, "feet")
__HHN3.ShowObjects = "OnEnter"
__HHN3.ProximityRange = Distance(60, "meters")
__HHN3.AllowSetPositionTo = false
__HHN3.Active = false
__HHN3.Points = {
	ZonePoint(49.7422568142038, 18.7028141319752, 0), 
	ZonePoint(49.741960416227, 18.7028677761555, 0), 
	ZonePoint(49.741984682796, 18.7029442191124, 0), 
	ZonePoint(49.7422767473361, 18.7028905749321, 0)
}
__HHN3.OriginalPoint = ZonePoint(49.7421196651407, 18.7028791755438, 0)
__HHN3.DistanceRangeUOM = "Feet"
__HHN3.ProximityRangeUOM = "Meters"
__HHN3.OutOfRangeName = ""
__HHN3.InRangeName = ""
_rCrQG = Wherigo.Zone(_flZ)
_rCrQG.Id = "326c7411-504f-4764-9ed8-271f8148de04"
_rCrQG.Name = "Slad"
_rCrQG.Description = [[Jakis slad.

Najaka stopa.]]
_rCrQG.Visible = true
_rCrQG.Media = _J6N
_rCrQG.Commands = {}
_rCrQG.DistanceRange = Distance(-1, "feet")
_rCrQG.ShowObjects = "OnEnter"
_rCrQG.ProximityRange = Distance(60, "meters")
_rCrQG.AllowSetPositionTo = false
_rCrQG.Active = false
_rCrQG.Points = {
	ZonePoint(49.7383306941526, 18.7044462561607, 0), 
	ZonePoint(49.7383887649095, 18.7043027579784, 0), 
	ZonePoint(49.7383696969075, 18.7042316794395, 0), 
	ZonePoint(49.7382821573473, 18.7044140696526, 0), 
	ZonePoint(49.7381573481965, 18.7045173346996, 0), 
	ZonePoint(49.7381790164749, 18.7045481801033, 0), 
	ZonePoint(49.738258755656, 18.7045012414455, 0)
}
_rCrQG.OriginalPoint = ZonePoint(49.738280919092, 18.7044230742114, 0)
_rCrQG.DistanceRangeUOM = "Feet"
_rCrQG.ProximityRangeUOM = "Meters"
_rCrQG.OutOfRangeName = ""
_rCrQG.InRangeName = ""
_9cOm = Wherigo.Zone(_flZ)
_9cOm.Id = "1b9aa112-1e60-47ec-85fb-3707e1658c2b"
_9cOm.Name = "Kolejny trop pumy"
_9cOm.Description = [[Slad zostawiony przez ...

Stopa po nekom...]]
_9cOm.Visible = true
_9cOm.Media = _J6N
_9cOm.Commands = {}
_9cOm.DistanceRange = Distance(-1, "feet")
_9cOm.ShowObjects = "OnEnter"
_9cOm.ProximityRange = Distance(60, "meters")
_9cOm.AllowSetPositionTo = false
_9cOm.Active = false
_9cOm.Points = {
	ZonePoint(49.738725053896, 18.7097355723381, 0), 
	ZonePoint(49.7387588560107, 18.7096336483955, 0), 
	ZonePoint(49.7384373016082, 18.7087592482567, 0), 
	ZonePoint(49.7384737041004, 18.7089711427689, 0)
}
_9cOm.OriginalPoint = ZonePoint(49.7385987289038, 18.7092749029398, 0)
_9cOm.DistanceRangeUOM = "Feet"
_9cOm.ProximityRangeUOM = "Meters"
_9cOm.OutOfRangeName = ""
_9cOm.InRangeName = ""
_wPQBS = Wherigo.Zone(_flZ)
_wPQBS.Id = "8c3a75cf-4545-4bcc-b913-01e8a40636d1"
_wPQBS.Name = "Kryjowka pumy"
_wPQBS.Description = [[Tutaj ukrywa sie puma.

Zde ma ukrit puma.]]
_wPQBS.Visible = true
_wPQBS.Media = _8Y9oR
_wPQBS.Icon = _NlzkX
_wPQBS.Commands = {}
_wPQBS.DistanceRange = Distance(-1, "feet")
_wPQBS.ShowObjects = "OnEnter"
_wPQBS.ProximityRange = Distance(60, "meters")
_wPQBS.AllowSetPositionTo = false
_wPQBS.Active = false
_wPQBS.Points = {
	ZonePoint(49.749184384446, 18.6991623044014, 0), 
	ZonePoint(49.7490942647897, 18.6991623044014, 0), 
	ZonePoint(49.7490778006037, 18.6990201473236, 0), 
	ZonePoint(49.7491202608617, 18.6989383399487, 0), 
	ZonePoint(49.7491757191018, 18.6989691853523, 0), 
	ZonePoint(49.7491445238494, 18.6990255117416, 0)
}
_wPQBS.OriginalPoint = ZonePoint(49.7491328256087, 18.6990462988615, 0)
_wPQBS.DistanceRangeUOM = "Feet"
_wPQBS.ProximityRangeUOM = "Meters"
_wPQBS.OutOfRangeName = ""
_wPQBS.InRangeName = ""
_qdqD = Wherigo.Zone(_flZ)
_qdqD.Id = "638fbd24-4383-4552-a207-9699644f998c"
_qdqD.Name = "Sasiad Wujka"
_qdqD.Description = [[Tutaj znajdziesz Edka.
[CZ]
Tady najdesz Edka.]]
_qdqD.Visible = true
_qdqD.Media = _U2RP
_qdqD.Icon = _lAoB
_qdqD.Commands = {}
_qdqD.DistanceRange = Distance(-1, "feet")
_qdqD.ShowObjects = "OnEnter"
_qdqD.ProximityRange = Distance(60, "meters")
_qdqD.AllowSetPositionTo = false
_qdqD.Active = false
_qdqD.Points = {
	ZonePoint(49.7367740252784, 18.7087807059288, 0), 
	ZonePoint(49.736677815263, 18.708807528019, 0), 
	ZonePoint(49.7366136751466, 18.7087458372116, 0), 
	ZonePoint(49.7366275432871, 18.7084172666073, 0), 
	ZonePoint(49.7367653577173, 18.7084802985191, 0)
}
_qdqD.OriginalPoint = ZonePoint(49.7366916833385, 18.7086463272572, 0)
_qdqD.DistanceRangeUOM = "Feet"
_qdqD.ProximityRangeUOM = "Meters"
_qdqD.OutOfRangeName = ""
_qdqD.InRangeName = ""
_xjB = Wherigo.Zone(_flZ)
_xjB.Id = "27e8f79b-36a0-4bbd-913c-4898f9e78363"
_xjB.Name = "Bezpieczne"
_xjB.Description = [[Tutaj mozna sie schronic.

Tady muzes skryvat.]]
_xjB.Visible = true
_xjB.Commands = {}
_xjB.DistanceRange = Distance(-1, "feet")
_xjB.ShowObjects = "OnEnter"
_xjB.ProximityRange = Distance(60, "meters")
_xjB.AllowSetPositionTo = false
_xjB.Active = false
_xjB.Points = {
	ZonePoint(49.7478178405237, 18.7015870213509, 0), 
	ZonePoint(49.7477857778389, 18.7016098201275, 0), 
	ZonePoint(49.7477944434314, 18.7017425894737, 0), 
	ZonePoint(49.7478239064348, 18.7017318606377, 0)
}
_xjB.OriginalPoint = ZonePoint(49.7478054920572, 18.7016678228974, 0)
_xjB.DistanceRangeUOM = "Feet"
_xjB.ProximityRangeUOM = "Meters"
_xjB.OutOfRangeName = ""
_xjB.InRangeName = ""
_Bsdk_ = Wherigo.Zone(_flZ)
_Bsdk_.Id = "d2330817-fcff-48b8-a186-d2a132ace899"
_Bsdk_.Name = "Gajowka"
_Bsdk_.Description = [[Tutaj przyniesc pume.

Zde dones pumu.]]
_Bsdk_.Visible = false
_Bsdk_.Media = _SQ2Rg
_Bsdk_.Icon = _tw2dj
_Bsdk_.Commands = {}
_Bsdk_.DistanceRange = Distance(-1, "feet")
_Bsdk_.ShowObjects = "OnEnter"
_Bsdk_.ProximityRange = Distance(60, "meters")
_Bsdk_.AllowSetPositionTo = false
_Bsdk_.Active = false
_Bsdk_.Points = {
	ZonePoint(49.7495309969484, 18.7036764621735, 0), 
	ZonePoint(49.7493143644247, 18.7037006020546, 0), 
	ZonePoint(49.7493134978928, 18.7038615345955, 0), 
	ZonePoint(49.7493793542835, 18.7038481235504, 0), 
	ZonePoint(49.7494478101738, 18.7037716805935, 0)
}
_Bsdk_.OriginalPoint = ZonePoint(49.7493972047446, 18.7037716805935, 0)
_Bsdk_.DistanceRangeUOM = "Feet"
_Bsdk_.ProximityRangeUOM = "Meters"
_Bsdk_.OutOfRangeName = ""
_Bsdk_.InRangeName = ""
_Tfx = Wherigo.Zone(_flZ)
_Tfx.Id = "5516c920-ff16-4b0c-adac-90316d080c20"
_Tfx.Name = "Miejsce ukrycia"
_Tfx.Description = [[Miejsce ukrycia skarbu pumy.
[CZ]
Zde najdete poklad hlidany pumou.]]
_Tfx.Visible = true
_Tfx.Commands = {}
_Tfx.DistanceRange = Distance(-1, "feet")
_Tfx.ShowObjects = "OnEnter"
_Tfx.ProximityRange = Distance(52, "meters")
_Tfx.AllowSetPositionTo = false
_Tfx.Active = false
_Tfx.Points = {
	ZonePoint(49.7494267987708, 18.7003241545963, 0), 
	ZonePoint(49.7493999363328, 18.7003322012233, 0), 
	ZonePoint(49.749408601637, 18.7003764576721, 0), 
	ZonePoint(49.7494363306002, 18.700368411045, 0)
}
_Tfx.OriginalPoint = ZonePoint(49.7494179168352, 18.7003503061342, 0)
_Tfx.DistanceRangeUOM = "Feet"
_Tfx.ProximityRangeUOM = "Meters"
_Tfx.OutOfRangeName = ""
_Tfx.InRangeName = ""
_4ZI = Wherigo.Zone(_flZ)
_4ZI.Id = "e2bb0733-0d60-4d7b-9679-b9e390841398"
_4ZI.Name = "Za woda"
_4ZI.Description = [[Bezpieczne miejsce przed puma.

Zde se  zachranis pred pumou.]]
_4ZI.Visible = true
_4ZI.Media = _2kgv
_4ZI.Icon = _N8Gud
_4ZI.Commands = {}
_4ZI.DistanceRange = Distance(-1, "feet")
_4ZI.ShowObjects = "OnEnter"
_4ZI.ProximityRange = Distance(55, "meters")
_4ZI.AllowSetPositionTo = false
_4ZI.Active = false
_4ZI.Points = {
	ZonePoint(49.7401945574196, 18.7115742266178, 0), 
	ZonePoint(49.7401806902986, 18.7116949260235, 0), 
	ZonePoint(49.7401408223036, 18.7117069959641, 0), 
	ZonePoint(49.7400463523585, 18.7116158008575, 0), 
	ZonePoint(49.7400628196099, 18.7115406990051, 0), 
	ZonePoint(49.7401260884711, 18.7115594744682, 0), 
	ZonePoint(49.7401598896097, 18.7115366756916, 0)
}
_4ZI.OriginalPoint = ZonePoint(49.7401301742959, 18.7116041140897, 0)
_4ZI.DistanceRangeUOM = "Feet"
_4ZI.ProximityRangeUOM = "Meters"
_4ZI.OutOfRangeName = ""
_4ZI.InRangeName = ""
_rvl = Wherigo.Zone(_flZ)
_rvl.Id = "ba4d212d-ea5f-49e0-9482-a8479070f82c"
_rvl.Name = "Trop2"
_rvl.Description = ""
_rvl.Visible = true
_rvl.Media = _ElhF
_rvl.Icon = _Ol0
_rvl.Commands = {}
_rvl.DistanceRange = Distance(-1, "feet")
_rvl.ShowObjects = "OnEnter"
_rvl.ProximityRange = Distance(60, "meters")
_rvl.AllowSetPositionTo = false
_rvl.Active = false
_rvl.Points = {
	ZonePoint(49.7441820569817, 18.7028516829014, 0), 
	ZonePoint(49.74417252412, 18.7026706337929, 0), 
	ZonePoint(49.7441213932839, 18.7026853859425, 0), 
	ZonePoint(49.7440277977155, 18.7028302252293, 0)
}
_rvl.OriginalPoint = ZonePoint(49.7441259430253, 18.7027594819665, 0)
_rvl.DistanceRangeUOM = "Feet"
_rvl.ProximityRangeUOM = "Meters"
_rvl.OutOfRangeName = ""
_rvl.InRangeName = ""
_6aD = Wherigo.Zone(_flZ)
_6aD.Id = "e8229392-dc92-4136-b1fe-1a4170371161"
_6aD.Name = "Trop3"
_6aD.Description = ""
_6aD.Visible = true
_6aD.Media = _z2IxN
_6aD.Icon = _otE
_6aD.Commands = {}
_6aD.DistanceRange = Distance(-1, "feet")
_6aD.ShowObjects = "OnEnter"
_6aD.ProximityRange = Distance(60, "meters")
_6aD.AllowSetPositionTo = false
_6aD.Active = false
_6aD.Points = {
	ZonePoint(49.7452852564252, 18.6994171142578, 0), 
	ZonePoint(49.7452783235927, 18.6995244026184, 0), 
	ZonePoint(49.7452505922526, 18.6996947228909, 0), 
	ZonePoint(49.7452618581115, 18.6994962394238, 0), 
	ZonePoint(49.7452618581114, 18.6993661522865, 0), 
	ZonePoint(49.7452505922526, 18.6993031203747, 0), 
	ZonePoint(49.7453225203832, 18.6993031203747, 0), 
	ZonePoint(49.7452904560489, 18.6993661522865, 0)
}
_6aD.OriginalPoint = ZonePoint(49.7452751821473, 18.6994338780642, 0)
_6aD.DistanceRangeUOM = "Feet"
_6aD.ProximityRangeUOM = "Meters"
_6aD.OutOfRangeName = ""
_6aD.InRangeName = ""
_Erk = Wherigo.Zone(_flZ)
_Erk.Id = "8f554e77-cc7d-4787-a4f3-edfc8cee4a1b"
_Erk.Name = "Ucieczka pumy"
_Erk.Description = [[Tutaj ucieka puma.
[CZ]
Tady utika puma.]]
_Erk.Visible = false
_Erk.Media = _O6vf5
_Erk.Icon = _gSEl
_Erk.Commands = {}
_Erk.DistanceRange = Distance(-1, "feet")
_Erk.ShowObjects = "OnEnter"
_Erk.ProximityRange = Distance(60, "meters")
_Erk.AllowSetPositionTo = false
_Erk.Active = false
_Erk.Points = {
	ZonePoint(49.7418828497914, 18.7050658464432, 0), 
	ZonePoint(49.7418369165361, 18.7050966918468, 0), 
	ZonePoint(49.7418637831625, 18.705300539732, 0), 
	ZonePoint(49.7419131830494, 18.7052576243877, 0)
}
_Erk.OriginalPoint = ZonePoint(49.7418741831349, 18.7051801756024, 0)
_Erk.DistanceRangeUOM = "Feet"
_Erk.ProximityRangeUOM = "Meters"
_Erk.OutOfRangeName = ""
_Erk.InRangeName = ""
_KMt = Wherigo.Zone(_flZ)
_KMt.Id = "809ade82-c5f0-4eb7-93d6-f75ff06eaf1b"
_KMt.Name = "Stary Dab"
_KMt.Description = ""
_KMt.Visible = true
_KMt.Media = _9ri
_KMt.Icon = _0sK
_KMt.Commands = {}
_KMt.DistanceRange = Distance(-1, "feet")
_KMt.ShowObjects = "OnEnter"
_KMt.ProximityRange = Distance(60, "meters")
_KMt.AllowSetPositionTo = false
_KMt.Active = false
_KMt.Points = {
	ZonePoint(49.7492779700662, 18.7043014168739, 0), 
	ZonePoint(49.7492502410125, 18.7043040990829, 0), 
	ZonePoint(49.7492580398104, 18.704129755497, 0), 
	ZonePoint(49.7492875019247, 18.704135119915, 0)
}
_KMt.OriginalPoint = ZonePoint(49.7492684382035, 18.7042175978422, 0)
_KMt.DistanceRangeUOM = "Feet"
_KMt.ProximityRangeUOM = "Meters"
_KMt.OutOfRangeName = ""
_KMt.InRangeName = ""
_fip = Wherigo.Zone(_flZ)
_fip.Id = "15154038-2b91-407b-bf00-b3ec5f50ddb0"
_fip.Name = "Szkola"
_fip.Description = [[Znajdziesz informacje na temat pumy.
[CZ]
Tady najdes nejake informace o pume.]]
_fip.Visible = false
_fip.Media = _mOw3
_fip.Icon = _qZm
_fip.Commands = {}
_fip.DistanceRange = Distance(100, "meters")
_fip.ShowObjects = "OnProximity"
_fip.ProximityRange = Distance(60, "meters")
_fip.AllowSetPositionTo = false
_fip.Active = true
_fip.Points = {
	ZonePoint(49.7365105307284, 18.7063103914261, 0), 
	ZonePoint(49.7362765047634, 18.7064123153687, 0), 
	ZonePoint(49.7362886394708, 18.706471323967, 0), 
	ZonePoint(49.7365122642499, 18.7063667178154, 0)
}
_fip.OriginalPoint = ZonePoint(49.7363969848031, 18.7063901871443, 0)
_fip.DistanceRangeUOM = "Meters"
_fip.ProximityRangeUOM = "Meters"
_fip.OutOfRangeName = ""
_fip.InRangeName = ""
_gQ0E = Wherigo.Zone(_flZ)
_gQ0E.Id = "86836d3c-494c-4a0b-afe5-e2e9d88ee079"
_gQ0E.Name = "Parking"
_gQ0E.Description = [[Najlepiej bedzie jak tutaj zaparkujesz.
[CZ]
Nejlepsi bude, kdyz zaparkujes tady.]]
_gQ0E.Visible = true
_gQ0E.Commands = {}
_gQ0E.DistanceRange = Distance(-1, "feet")
_gQ0E.ShowObjects = "OnEnter"
_gQ0E.ProximityRange = Distance(60, "meters")
_gQ0E.AllowSetPositionTo = false
_gQ0E.Active = false
_gQ0E.Points = {
	ZonePoint(49.7386167136272, 18.6992990970612, 0), 
	ZonePoint(49.7384676370209, 18.6992964148521, 0), 
	ZonePoint(49.7384537694063, 18.6995378136635, 0), 
	ZonePoint(49.7386045795019, 18.6995485424995, 0)
}
_gQ0E.OriginalPoint = ZonePoint(49.7385356748891, 18.6994204670191, 0)
_gQ0E.DistanceRangeUOM = "Feet"
_gQ0E.ProximityRangeUOM = "Meters"
_gQ0E.OutOfRangeName = ""
_gQ0E.InRangeName = ""
_5OK = Wherigo.Zone(_flZ)
_5OK.Id = "b1efa224-9b4d-4608-92e7-66ca99e37e06"
_5OK.Name = "Stric Andrzej"
_5OK.Description = "Tady potkas strycka Andrzeje."
_5OK.Visible = true
_5OK.Media = _riB
_5OK.Icon = _3NB
_5OK.Commands = {}
_5OK.DistanceRange = Distance(-1, "feet")
_5OK.ShowObjects = "OnEnter"
_5OK.ProximityRange = Distance(60, "meters")
_5OK.AllowSetPositionTo = false
_5OK.Active = false
_5OK.Points = {
	ZonePoint(49.7378097876887, 18.7056760489941, 0), 
	ZonePoint(49.7377846522936, 18.7055017054081, 0), 
	ZonePoint(49.737718780162, 18.7051382660866, 0), 
	ZonePoint(49.7376633088239, 18.7051610648632, 0), 
	ZonePoint(49.7376676425245, 18.7056908011436, 0), 
	ZonePoint(49.7376113043868, 18.7058141827583, 0), 
	ZonePoint(49.7376823771035, 18.7057766318321, 0)
}
_5OK.OriginalPoint = ZonePoint(49.737705407569, 18.705536957298, 0)
_5OK.DistanceRangeUOM = "Feet"
_5OK.ProximityRangeUOM = "Meters"
_5OK.OutOfRangeName = ""
_5OK.InRangeName = ""
_r1I = Wherigo.Zone(_flZ)
_r1I.Id = "f24ca148-8c7c-411d-82a8-34ccb25feb17"
_r1I.Name = "Kiedys tu byla"
_r1I.Description = "Puma moze tu byla."
_r1I.Visible = false
_r1I.Commands = {}
_r1I.DistanceRange = Distance(-1, "feet")
_r1I.ShowObjects = "OnEnter"
_r1I.ProximityRange = Distance(60, "meters")
_r1I.AllowSetPositionTo = false
_r1I.Active = false
_r1I.Points = {
	ZonePoint(49.74473625968, 18.7028154730797, 0), 
	ZonePoint(49.7449477129896, 18.7028530240059, 0), 
	ZonePoint(49.7449338472271, 18.7029388546944, 0), 
	ZonePoint(49.7447189274007, 18.7029442191124, 0)
}
_r1I.OriginalPoint = ZonePoint(49.7448341868243, 18.7028878927231, 0)
_r1I.DistanceRangeUOM = "Feet"
_r1I.ProximityRangeUOM = "Meters"
_r1I.OutOfRangeName = ""
_r1I.InRangeName = ""
_V_i5j = Wherigo.Zone(_flZ)
_V_i5j.Id = "640dcd6b-f0d3-4b8c-a0a1-0a1d8df574d5"
_V_i5j.Name = "Juz widac"
_V_i5j.Description = "Tam w dali widac slady."
_V_i5j.Visible = false
_V_i5j.Commands = {}
_V_i5j.DistanceRange = Distance(-1, "feet")
_V_i5j.ShowObjects = "OnEnter"
_V_i5j.ProximityRange = Distance(60, "meters")
_V_i5j.AllowSetPositionTo = false
_V_i5j.Active = false
_V_i5j.Points = {
	ZonePoint(49.7446929289702, 18.7016071379185, 0), 
	ZonePoint(49.7447466590449, 18.7017787992954, 0), 
	ZonePoint(49.7449425133293, 18.7015427649021, 0), 
	ZonePoint(49.7448783841374, 18.7013603746891, 0), 
	ZonePoint(49.7447241270853, 18.7016017735004, 0)
}
_V_i5j.OriginalPoint = ZonePoint(49.7447969225134, 18.7015781700611, 0)
_V_i5j.DistanceRangeUOM = "Feet"
_V_i5j.ProximityRangeUOM = "Meters"
_V_i5j.OutOfRangeName = ""
_V_i5j.InRangeName = ""

-- Characters --
_BCp = Wherigo.ZCharacter(_flZ)
_BCp.Id = "9c01684d-3319-43d7-9e3e-8fea0ba71e3d"
_BCp.Name = "harcerz"
_BCp.Description = "spotkany harcerz"
_BCp.Visible = true
_BCp.Media = _gW59
_BCp.Icon = _nNVb
_BCp.Commands = {}
_BCp.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_BCp.Gender = "Male"
_BCp.Type = "NPC"
_XaTDg = Wherigo.ZCharacter{
	Cartridge = _flZ, 
	Container = _WbYdt
}
_XaTDg.Id = "02358d4a-6de8-48a0-ac17-8bb1e471fca3"
_XaTDg.Name = "Wujek Andrzej"
_XaTDg.Description = "Wujek Andzej poradzi Ci jak upolowac pume."
_XaTDg.Visible = true
_XaTDg.Media = _XNC
_XaTDg.Icon = _dZlH
_XaTDg.Commands = {}
_XaTDg.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_XaTDg.Gender = "Male"
_XaTDg.Type = "NPC"
_keVK9 = Wherigo.ZCharacter{
	Cartridge = _flZ, 
	Container = _L2PMk
}
_keVK9.Id = "b13eb43b-62a6-4fdb-950b-360f9cd4fbf2"
_keVK9.Name = "Zuch"
_keVK9.Description = "Opiekun harcerzy"
_keVK9.Visible = true
_keVK9.Media = _N5j8
_keVK9.Commands = {}
_keVK9.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_keVK9.Gender = "Male"
_keVK9.Type = "NPC"
_LwR = Wherigo.ZCharacter{
	Cartridge = _flZ, 
	Container = _wPQBS
}
_LwR.Id = "4af36b1c-c27c-4452-9809-fd9a840966b9"
_LwR.Name = "Puma"
_LwR.Description = "poszukiwana puma"
_LwR.Visible = false
_LwR.Media = _XRjne
_LwR.Commands = {}
_LwR.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_LwR.Gender = "It"
_LwR.Type = "NPC"
_aw4 = Wherigo.ZCharacter(_flZ)
_aw4.Id = "90dfeea8-4098-4f5f-9daa-c8fec244bc8b"
_aw4.Name = "Uciekajaca puma"
_aw4.Description = "Puma ucieka nam w sina dal."
_aw4.Visible = true
_aw4.Media = _Jbi
_aw4.Icon = _ibk_
_aw4.Commands = {}
_aw4.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_aw4.Gender = "Male"
_aw4.Type = "NPC"
_mCNI1 = Wherigo.ZCharacter{
	Cartridge = _flZ, 
	Container = _rCrQG
}
_mCNI1.Id = "90c7b667-f688-4fd8-a685-ef2d6e54f6ff"
_mCNI1.Name = "Slad"
_mCNI1.Description = "Ciekawy slad na ziemi"
_mCNI1.Visible = true
_mCNI1.Media = _J6N
_mCNI1.Commands = {}
_mCNI1.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_mCNI1.Gender = "Male"
_mCNI1.Type = "NPC"
_lu84 = Wherigo.ZCharacter{
	Cartridge = _flZ, 
	Container = _qdqD
}
_lu84.Id = "e85ce454-cfb3-4de3-9ab7-14cd384ace47"
_lu84.Name = "Sasiad"
_lu84.Description = [[Sasiad wujka Andrzeja, posiada pistolet na strzalki.
[CZ]
Strycka Andrzeja soused, ma zbran na sipky.]]
_lu84.Visible = true
_lu84.Media = _Vpq
_lu84.Icon = _Qlk
_lu84.Commands = {}
_lu84.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_lu84.Gender = "Male"
_lu84.Type = "NPC"
_i33mE = Wherigo.ZCharacter(_flZ)
_i33mE.Id = "704ddf14-00a1-4e6c-8f17-56666b528a35"
_i33mE.Name = "tropu"
_i33mE.Description = "Trop pumy"
_i33mE.Visible = true
_i33mE.Media = _8Drt
_i33mE.Commands = {}
_i33mE.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_i33mE.Gender = "It"
_i33mE.Type = "NPC"
_AHYi = Wherigo.ZCharacter(_flZ)
_AHYi.Id = "031b2251-bbc5-497f-84f4-60b362c5505c"
_AHYi.Name = "schwytana puma"
_AHYi.Description = ""
_AHYi.Visible = true
_AHYi.Commands = {}
_AHYi.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_AHYi.Gender = "Male"
_AHYi.Type = "NPC"
_e9U = Wherigo.ZCharacter{
	Cartridge = _flZ, 
	Container = _wPQBS
}
_e9U.Id = "3958bcb7-5b03-4d59-8286-f1ab905f54d9"
_e9U.Name = "spiaca puma"
_e9U.Description = "Puma, ktora spi."
_e9U.Visible = false
_e9U.Media = _2tk
_e9U.Icon = _fn0
_e9U.Commands = {}
_e9U.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_e9U.Gender = "Male"
_e9U.Type = "NPC"
_yWmj = Wherigo.ZCharacter{
	Cartridge = _flZ, 
	Container = _4ZI
}
_yWmj.Id = "0dc70f8e-46a0-42ff-8cb9-87452d63362c"
_yWmj.Name = "harcerka"
_yWmj.Description = ""
_yWmj.Visible = true
_yWmj.Media = _lytlT
_yWmj.Icon = _7w2n
_yWmj.Commands = {}
_yWmj.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_yWmj.Gender = "Female"
_yWmj.Type = "NPC"
_eKw = Wherigo.ZCharacter{
	Cartridge = _flZ, 
	Container = _KMt
}
_eKw.Id = "1e486448-0897-4796-a474-04e6e390a011"
_eKw.Name = "Stary Druid"
_eKw.Description = [[Stary druid, ktory potrafi leczyc zranione cialo.
[CZ]
Stary druid, ktery muze ulecit zranene telo.]]
_eKw.Visible = true
_eKw.Commands = {}
_eKw.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_eKw.Gender = "Male"
_eKw.Type = "NPC"
_uxkO = Wherigo.ZCharacter{
	Cartridge = _flZ, 
	Container = _5OK
}
_uxkO.Id = "5f582d26-689b-43ee-bce9-4396761cd606"
_uxkO.Name = "Stric Andrzej"
_uxkO.Description = "Stric vi jak upolovac pume."
_uxkO.Visible = true
_uxkO.Media = _XNC
_uxkO.Icon = _dZlH
_uxkO.Commands = {}
_uxkO.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_uxkO.Gender = "Male"
_uxkO.Type = "NPC"

-- Items --
_L2h3 = Wherigo.ZItem(_flZ)
_L2h3.Id = "0a8362e4-0130-4dcd-bee8-3ff039d3d5a8"
_L2h3.Name = "pistolet"
_L2h3.Description = [[pistolet na strzalki
[CZ]
sbran na sipky]]
_L2h3.Visible = false
_L2h3.Media = _tFbeX
_L2h3.Icon = _a6Yq
_L2h3.Commands = {}
_L2h3.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_L2h3.Locked = false
_L2h3.Opened = false
_1vTjn = Wherigo.ZItem(_flZ)
_1vTjn.Id = "2be5b459-207e-4c50-b540-35bcd8b94b24"
_1vTjn.Name = "strzalki"
_1vTjn.Description = "pociski usypiajace/uspavaci sipky"
_1vTjn.Visible = false
_1vTjn.Media = _iiEPM
_1vTjn.Icon = _aT9T
_1vTjn.Commands = {}
_1vTjn.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_1vTjn.Locked = false
_1vTjn.Opened = false
_K1eW = Wherigo.ZItem{
	Cartridge = _flZ, 
	Container = _wPQBS
}
_K1eW.Id = "5fe8187a-5959-4a85-8f86-644a7a7eaab5"
_K1eW.Name = "spiaca puma"
_K1eW.Description = [[Puma trafiona pociskiem usypiajacym
[CZ]
Spaci puma]]
_K1eW.Visible = false
_K1eW.Media = _2tk
_K1eW.Icon = _fn0
_K1eW.Commands = {}
_K1eW.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_K1eW.Locked = false
_K1eW.Opened = false
_xPYro = Wherigo.ZItem(_flZ)
_xPYro.Id = "c3bcf8c0-dd40-4655-a7ea-0349cb35af92"
_xPYro.Name = "haslo do gry"
_xPYro.Description = ""
_xPYro.Visible = true
_xPYro.Commands = {}
_xPYro.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_xPYro.Locked = false
_xPYro.Opened = false

-- Tasks --
_hXPT = Wherigo.ZTask(_flZ)
_hXPT.Id = "61b4170e-1bd7-462c-858b-a4b2c8bf0cf4"
_hXPT.Name = "Znalesc pume/Najdij pume"
_hXPT.Description = [[Naszym celem jest znalesc pume.
[CZ]
Nasim cilem je najit pumu.]]
_hXPT.Visible = true
_hXPT.Media = _XRjne
_hXPT.Active = true
_hXPT.Complete = false
_hXPT.CorrectState = "None"
_Fq3g = Wherigo.ZTask(_flZ)
_Fq3g.Id = "2ed88785-06b3-459a-9965-7c49cb607a2a"
_Fq3g.Name = "Pistolet / Zbran"
_Fq3g.Description = [[Zdobyc pistolet, aby moc zapolowac na pume.
[CZ]
Ziskejte zbran na pumu.]]
_Fq3g.Visible = true
_Fq3g.Media = _tFbeX
_Fq3g.Icon = _a6Yq
_Fq3g.Active = false
_Fq3g.Complete = false
_Fq3g.CorrectState = "None"
_Xdm = Wherigo.ZTask(_flZ)
_Xdm.Id = "cc149fd3-cb1a-42b8-9e15-7531e9049cb4"
_Xdm.Name = "Pociski / Sipky"
_Xdm.Description = [[Znalesc pociski usypiajace.
[CZ]
Najdi uspavaci sipky.]]
_Xdm.Visible = true
_Xdm.Media = _iiEPM
_Xdm.Icon = _aT9T
_Xdm.Active = false
_Xdm.Complete = false
_Xdm.CorrectState = "None"
_fnl = Wherigo.ZTask(_flZ)
_fnl.Id = "d18d35ad-5329-43d8-b2af-d0e6c8441730"
_fnl.Name = "poscig"
_fnl.Description = "gonimy pume"
_fnl.Visible = false
_fnl.Active = false
_fnl.Complete = false
_fnl.CorrectState = "None"
_nQM_O = Wherigo.ZTask(_flZ)
_nQM_O.Id = "acf54ba1-5b5b-4da7-bb64-21686e22fb0c"
_nQM_O.Name = "ucieczka"
_nQM_O.Description = "Uciekamy prze puma"
_nQM_O.Visible = true
_nQM_O.Active = false
_nQM_O.Complete = false
_nQM_O.CorrectState = "None"
_pFLN = Wherigo.ZTask(_flZ)
_pFLN.Id = "2e76f34f-ee4c-4edc-9cba-9171fd633aa6"
_pFLN.Name = "Przeniesc pume"
_pFLN.Description = [[Zanies spiaca pume do gajowki.
[CZ]
Zanes spici pumu do hajovny.]]
_pFLN.Visible = true
_pFLN.Active = false
_pFLN.Complete = false
_pFLN.CorrectState = "None"
_Swxqm = Wherigo.ZTask(_flZ)
_Swxqm.Id = "a02fe859-e91d-438b-85c9-18ec433b1f67"
_Swxqm.Name = "Znalesc skarb"
_Swxqm.Description = [[Znalesc skarb pilnowany przez pume.
[CZ]
Najdi poklad ktery hlidala puma.]]
_Swxqm.Visible = false
_Swxqm.Active = false
_Swxqm.Complete = false
_Swxqm.CorrectState = "None"
_vndr1 = Wherigo.ZTask(_flZ)
_vndr1.Id = "28037128-dbbb-4545-9aa4-631fe5f12813"
_vndr1.Name = "Uleczyc"
_vndr1.Description = "Jestes ranny, przed schwytaniem pumy odwiedz Druida."
_vndr1.Visible = false
_vndr1.Icon = _0sK
_vndr1.Active = false
_vndr1.Complete = false
_vndr1.CorrectState = "None"

-- Cartridge Variables --
_sgmY = 0
_4D5jE = false
_eIYij = true
_Ed6 = false
_5y8z = false
_aKVah = ""
_xnu4 = false
_1DNh = false
_YoCtS = false
_KmmK = false
_7Zy = "_3u7F2"
_pz_35 = "_BCp"
_jxr = "_L2h3"
_vDpTk = "_hXPT"
_BX6 = "_kEg"
_M_J = "_HzCz7"
_flZ.ZVariables = {
	_sgmY = 0, 
	_4D5jE = false, 
	_eIYij = true, 
	_Ed6 = false, 
	_5y8z = false, 
	_aKVah = "", 
	_xnu4 = false, 
	_1DNh = false, 
	_YoCtS = false, 
	_KmmK = false, 
	_7Zy = "_3u7F2", 
	_pz_35 = "_BCp", 
	_jxr = "_L2h3", 
	_vDpTk = "_hXPT", 
	_BX6 = "_kEg", 
	_M_J = "_HzCz7"
}

-- Timers --
_HzCz7 = Wherigo.ZTimer(_flZ)
_HzCz7.Id = "73046b27-772c-45d2-be8d-dd036281cf4e"
_HzCz7.Name = "uciekaj"
_HzCz7.Description = "ucieczka przed puma"
_HzCz7.Visible = true
_HzCz7.Duration = 170
_HzCz7.Type = "Countdown"
_lBE = Wherigo.ZTimer(_flZ)
_lBE.Id = "43133331-c121-4cf5-8472-9285d4cd8ccf"
_lBE.Name = "pogon"
_lBE.Description = "gonimy pume"
_lBE.Visible = true
_lBE.Duration = 110
_lBE.Type = "Countdown"
_oLP2l = Wherigo.ZTimer(_flZ)
_oLP2l.Id = "397ba1a5-ad9c-4cb3-856b-731ce293faa1"
_oLP2l.Name = "uciekamy"
_oLP2l.Description = "uciekamy z ataku"
_oLP2l.Visible = true
_oLP2l.Duration = 210
_oLP2l.Type = "Countdown"
_w7uE = Wherigo.ZTimer(_flZ)
_w7uE.Id = "cf6de41a-8a4b-48e0-b4ad-7b492011b9ec"
_w7uE.Name = "szukanie"
_w7uE.Description = "szukamy skrzynki"
_w7uE.Visible = true
_w7uE.Duration = 30
_w7uE.Type = "Countdown"

-- Inputs --
_kEg = Wherigo.ZInput(_flZ)
_kEg.Id = "9ac88aff-b410-4904-b1a0-e7dfd1a6a332"
_kEg.Name = "pytanko"
_kEg.Description = "pytanie Edzia"
_kEg.Visible = true
_kEg.Media = _LuX
_kEg.Choices = {
	"kuguar", 
	"jaguar", 
	"gepard", 
	"lew gorski"
}
_kEg.InputType = "MultipleChoice"
_kEg.Text = "Jak inaczej nazywana jest puma?"
_JXi = Wherigo.ZInput(_flZ)
_JXi.Id = "1f86d340-a30b-463a-85ff-d1fec51db2b6"
_JXi.Name = "pytanko2"
_JXi.Description = "pytanie drugie Edzia"
_JXi.Visible = true
_JXi.Media = _LuX
_JXi.InputType = "TrueFalse"
_JXi.Text = [[Czy puma pochodzi z Ameryki?
[CZ]
Puma puvodne pohazi z Ameryky?]]
_sHWs5 = Wherigo.ZInput(_flZ)
_sHWs5.Id = "875334b6-d680-46da-a54e-222e17579a42"
_sHWs5.Name = "pytanie cz"
_sHWs5.Description = "Pytanie Edzia po czesku"
_sHWs5.Visible = true
_sHWs5.Media = _LuX
_sHWs5.Choices = {
	"kuguar", 
	"jaguar", 
	"gepard", 
	"lev horsky"
}
_sHWs5.InputType = "MultipleChoice"
_sHWs5.Text = "Jak jinak nazvite Puma?"

-- WorksWithList for object commands --

-- functions --
function _flZ:OnStart()
	if (_G[_MdKK("\065\056\060")][_MdKK("\127\015\058\078\122\114\047\102")] == _MdKK("\062\095\056\054\002")) or (_G[_MdKK("\065\056\060")][_MdKK("\092\099\060\095\088\099\063\092")] == _MdKK("\092\099\079\077\078\114\115")) then
		for k, v in pairs(_G[_MdKK("\076\122\015\072")][_MdKK("\013\015\015\072\012\082\118\099\088\078\079")]) do
			v[_MdKK("\098\095\079\095\082\015\099")] = false
			v[_MdKK("\013\088\078\095\060\099")] = false
		end
		_G[_MdKK("\062\075\099\047\095\096\114")][_MdKK("\055\114\102\102\058\056\120")](_MdKK("\009\058\060\099\055\015\114\079\099"))
		return
	end
	_gQ0E.Active = true
	_gQ0E.Visible = true
end
function _flZ:OnRestore()
end
function _3u7F2:OnEnter()
	_7Zy = "_3u7F2"
	if _1DNh == true then
		_Urwigo.Dialog(false, {
			{
				Text = "Nevim jak do toho doslo, ale puma se zjevila tady.Bojim se vychazet z domu.", 
				Media = _1HfKF
			}, 
			{
				Text = [[Sezrala moje slepice, kraliky zabiji ...

Pomozte nam ji chytit.]], 
				Media = _hLsQx
			}, 
			{
				Text = [[Jediny, kdo vam muze pomoc chytit pumu je stryc Andrzej.
Pojdme ku nemu.]], 
				Media = _1HfKF
			}
		}, function(action)
			Wherigo.ShowScreen(Wherigo.MAINSCREEN)
		end)
		_5OK.Active = true
		_5OK.Visible = true
		_gQ0E.Active = false
		_gQ0E.Visible = false
	else
		_Urwigo.Dialog(false, {
			{
				Text = "Nie wiem jak to sie stalo, ze sie pojawila u nas, ale boje sie wyjsc z domu.", 
				Media = _1HfKF
			}, 
			{
				Text = [[Zjada moje kury, zabija kroliki...

Pomoz nam w zlapaniu jej.]], 
				Media = _hLsQx
			}, 
			{
				Text = [[Jedyna osoba, ktora moze Ci pomoc w schwytaniu pumy jest wujek Andrzej.
Chodzmy do niego.]], 
				Media = _1HfKF
			}
		}, function(action)
			Wherigo.ShowScreen(Wherigo.MAINSCREEN)
		end)
		_WbYdt.Active = true
		_WbYdt.Visible = true
		_gQ0E.Active = false
		_gQ0E.Visible = false
	end
end
function _3u7F2:OnExit()
	_7Zy = "_3u7F2"
	_3u7F2.Active = false
	_3u7F2.Visible = false
end
function _WbYdt:OnEnter()
	_7Zy = "_WbYdt"
	_Urwigo.Dialog(false, {
		{
			Text = "Juz widze wujka Andrzeja.", 
			Media = _XNC
		}, 
		{
			Text = "Aby upolowac Pume potrzebujesz pistoletu oraz pociskow do niego.", 
			Media = _XNC
		}, 
		{
			Text = "Pistoletu, akurat pozyczylem sasiadowi Edkowi. Idz do niego, a Ci go da.", 
			Media = _XNC
		}, 
		{
			Text = "Po pociski usypiajace idz do harcerzy", 
			Media = _iiEPM
		}
	}, function(action)
		_qdqD.Active = true
		_Fq3g.Visible = true
		_Fq3g.Active = true
		_qdqD.Visible = true
		_L2PMk.Active = true
		_L2PMk.Visible = true
		_Xdm.Visible = true
		_Xdm.Active = true
	end)
end
function _WbYdt:OnExit()
	_7Zy = "_WbYdt"
	if _1DNh == true then
		if (_Xdm.Active and _Fq3g.Active) == true then
			_WbYdt.Visible = false
			_WbYdt.Active = false
		elseif (_Xdm.Active or _Fq3g.Active) == false then
			_Urwigo.OldDialog{
				{
					Text = "Nemyslim si, ze vis vsechno."
				}
			}
		end
	else
		if (_Xdm.Active and _Fq3g.Active) == true then
			_WbYdt.Visible = false
			_WbYdt.Active = false
		elseif (_Xdm.Active or _Fq3g.Active) == false then
			if _1DNh == true then
				_Urwigo.OldDialog{
					{
						Text = "Asi nevis vsechno."
					}
				}
			else
				_Urwigo.OldDialog{
					{
						Text = "Chyba nie wiesz wszystkiego."
					}
				}
			end
		end
	end
end
function _dRG:OnEnter()
	_7Zy = "_dRG"
	if _1DNh == true then
		_Urwigo.Dialog(false, {
			{
				Text = "Co delate s touto zbrani?", 
				Media = _gW59
			}, 
			{
				Text = "Jste na lovu na pumu? V tom pripade, vam dam uspavaci sipky.", 
				Media = _gW59
			}, 
			{
				Text = "Prochazim se kolem a vsiml jsem si neceho ...", 
				Media = _gW59
			}
		}, function(action)
			_1vTjn:MoveTo(Player)
			_1vTjn.Visible = true
			_sgmY = _sgmY + 1
			_Xdm.Complete = true
			_rCrQG.Active = true
			_rCrQG.Visible = true
			_dRG.Visible = false
			Wherigo.ShowScreen(Wherigo.MAINSCREEN)
		end)
	else
		_Urwigo.Dialog(false, {
			{
				Text = "Co Pan robi z ta bronia?", 
				Media = _gW59
			}, 
			{
				Text = "Poluje Pan na Pume? W takim razie dam Panu strzalke usypiajaca.", 
				Media = _gW59
			}, 
			{
				Text = "Chodze po okolicy i cos zauwazylem...", 
				Media = _gW59
			}
		}, function(action)
			_1vTjn:MoveTo(Player)
			_1vTjn.Visible = true
			_sgmY = _sgmY + 1
			_Xdm.Complete = true
			_rCrQG.Active = true
			_rCrQG.Visible = true
			_dRG.Visible = false
			Wherigo.ShowScreen(Wherigo.MAINSCREEN)
		end)
	end
end
function _dRG:OnExit()
	_7Zy = "_dRG"
	_dRG.Active = false
	_dRG.Visible = false
	_d3oy.Active = true
	_rCrQG.Active = true
	_rCrQG.Visible = true
end
function _L2PMk:OnEnter()
	_7Zy = "_L2PMk"
	if _1DNh == true then
		_Urwigo.MessageBox{
			Text = "Dosahl ses do tabora skautu.", 
			Media = _mHL, 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.MessageBox{
						Text = "Jak ti muzeme pomoct?", 
						Media = _N5j8, 
						Buttons = {
							"Uspavaci sypky", 
							"Gde najdu pumu?"
						}, 
						Callback = function(action)
							if action ~= nil then
								if action == "Button1" then
									_Urwigo.MessageBox{
										Text = [[Chtel by jsi sipki? Tak musis odpovedet na otazku:
Kolik to je 2+2*2?]], 
										Media = _N5j8, 
										Buttons = {
											"6", 
											"8"
										}, 
										Callback = function(action)
											if action ~= nil then
												if action == "Button1" then
													_Urwigo.Dialog(false, {
														{
															Text = "Je to spravne"
														}
													}, function(action)
														_Xdm.Complete = true
														_1vTjn:MoveTo(Player)
														_1vTjn.Visible = true
														_sgmY = _sgmY + 3
														_Urwigo.MessageBox{
															Text = ("Mas ted ".._sgmY).." uspavacich sipek.", 
															Media = _iiEPM
														}
													end)
												elseif action == "Button2" then
													_Urwigo.OldDialog{
														{
															Text = "To neni spravne. Kde jsi chodil do skoly?", 
															Media = _N5j8
														}
													}
												end
											end
										end
									}
								elseif action == "Button2" then
									_Urwigo.MessageBox{
										Text = "Kde pobyva puma to nevim, ale urcite neni daleko. Nekdo videl nejake stopy...", 
										Media = _N5j8, 
										Callback = function(action)
											if action ~= nil then
												_6aD.Active = true
												_6aD.Visible = true
											end
										end
									}
								end
							end
						end
					}
				end
			end
		}
	else
		_Urwigo.MessageBox{
			Text = "Dotarles do obozu harcerzy", 
			Media = _mHL, 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.MessageBox{
						Text = "W czym mozemy Ci pomoc", 
						Media = _N5j8, 
						Buttons = {
							"Pociski usypiajace.", 
							"Gdzie jest puma?"
						}, 
						Callback = function(action)
							if action ~= nil then
								if action == "Button1" then
									_Urwigo.MessageBox{
										Text = [[Aby dostac strzalki usypiajace musisz odpowiedziec na pytanie:
Ile to jest 2+2*2?]], 
										Media = _N5j8, 
										Buttons = {
											"6", 
											"8"
										}, 
										Callback = function(action)
											if action ~= nil then
												if action == "Button1" then
													_1vTjn.Visible = true
													_1vTjn:MoveTo(Player)
													_sgmY = _sgmY + 3
													_Urwigo.MessageBox{
														Text = ("Posiadasz teraz ".._sgmY).." pociskow usypiajacych.", 
														Media = _iiEPM, 
														Callback = function(action)
															if action ~= nil then
																_Xdm.Complete = true
															end
														end
													}
												elseif action == "Button2" then
													_Urwigo.OldDialog{
														{
															Text = "Nie wiem gdzie chodziles do szkoly, ale to nie jest prawidlowa odpowiedz, sprobuj jeszcze raz.", 
															Media = _N5j8
														}
													}
												end
											end
										end
									}
								elseif action == "Button2" then
									_Urwigo.MessageBox{
										Text = "Gdzie przebywa puma tego nie wiemy, ale napewno jest niedaleko. Ktos widzial jakies slady...", 
										Media = _N5j8, 
										Callback = function(action)
											if action ~= nil then
												_6aD.Active = true
												_6aD.Visible = true
											end
										end
									}
								end
							end
						end
					}
				end
			end
		}
	end
end
function _L2PMk:OnExit()
	_7Zy = "_L2PMk"
	_d3oy.Active = true
end
function _d3oy:OnEnter()
	_7Zy = "_d3oy"
	if _1DNh == true then
		if _4D5jE == false then
			_Urwigo.MessageBox{
				Text = [[Tam v dalce vidim jak nam utika.

Jiste prcha do sveho doupete.

Honime ji?]], 
				Media = _Jbi, 
				Buttons = {
					"ANO", 
					"NE"
				}, 
				Callback = function(action)
					if action ~= nil then
						if action == "Button1" then
							_lBE:Start()
							_rCrQG.Active = false
							_z3wi3.Active = false
							_Erk.Active = true
							_Erk.Visible = true
							_4D5jE = true
							_rvl.Active = false
							_rvl.Visible = false
							Wherigo.ShowScreen(Wherigo.MAINSCREEN)
						elseif action == "Button2" then
							_Urwigo.MessageBox{
								Text = [[Je oproti nam prilis rychla, zjistim ukryt, a tam ji jiste chytim.

Pojdme po jejich stopach.]], 
								Media = _Jbi
							}
							_4D5jE = true
						end
					end
				end
			}
		elseif _4D5jE == true then
			_d3oy.Active = false
		end
	else
		if _4D5jE == false then
			_Urwigo.MessageBox{
				Text = [[Wlasnie widac jak w oddali nam ucieka.

Napewno ucieka do swojego legowiska.

Gonimy?]], 
				Media = _Jbi, 
				Buttons = {
					"Tak", 
					"Nie"
				}, 
				Callback = function(action)
					if action ~= nil then
						if action == "Button1" then
							_lBE:Start()
							_rCrQG.Active = false
							_z3wi3.Active = false
							_Erk.Active = true
							_Erk.Visible = true
							_4D5jE = true
							_rvl.Active = false
							_rvl.Visible = false
							Wherigo.ShowScreen(Wherigo.MAINSCREEN)
						elseif action == "Button2" then
							_Urwigo.MessageBox{
								Text = [[Jest za szybka dla nas, znajde kryjowke i tam ja zlapie.
Chodzmy dalej jej tropem.]], 
								Media = _Jbi, 
								Callback = function(action)
									if action ~= nil then
										_4D5jE = true
									end
								end
							}
						end
					end
				end
			}
		elseif _4D5jE == true then
			_d3oy.Active = false
		end
	end
end
function _d3oy:OnExit()
	_7Zy = "_d3oy"
	_d3oy.Active = false
	_4D5jE = true
end
function _z3wi3:OnEnter()
	_7Zy = "_z3wi3"
	if _1DNh == true then
		if _Ed6 == false then
			_Urwigo.MessageBox{
				Text = [[Puma najednou otoci k tobe zezadu.

RYCHLE dostat se ven!!]], 
				Media = _RYau4, 
				Callback = function(action)
					if action ~= nil then
						_oLP2l:Start()
						Wherigo.ShowScreen(Wherigo.MAINSCREEN)
					end
				end
			}
			_Ed6 = true
		elseif _Ed6 == true then
			_z3wi3.Active = false
		end
	else
		if _Ed6 == false then
			_Urwigo.MessageBox{
				Text = [[Idac tropem, nagle puma atakuje Cie od tylu.

Szybko UCIEKAJ!!!]], 
				Media = _RYau4, 
				Callback = function(action)
					if action ~= nil then
						_oLP2l:Start()
						Wherigo.ShowScreen(Wherigo.MAINSCREEN)
					end
				end
			}
			_Ed6 = true
		elseif _Ed6 == true then
			_z3wi3.Active = false
		end
	end
end
function _z3wi3:OnExit()
	_7Zy = "_z3wi3"
	_z3wi3.Active = false
	_9cOm.Active = false
	_9cOm.Visible = false
end
function _z3wi3:OnProximity()
	_7Zy = "_z3wi3"
	if _1DNh == true then
		if _5y8z == false then
			_Urwigo.MessageBox{
				Text = "Mas pocit, jako kdyby te nekdo pozoroval.", 
				Callback = function(action)
					if action ~= nil then
						_5y8z = true
					end
				end
			}
		else
		end
	else
		if _5y8z == false then
			_Urwigo.MessageBox{
				Text = "Czujesz, jak ktos cie obserwuje.", 
				Callback = function(action)
					if action ~= nil then
						_5y8z = true
					end
				end
			}
		else
		end
	end
end
function __HHN3:OnEnter()
	_7Zy = "__HHN3"
	if _1DNh == true then
		_Urwigo.MessageBox{
			Text = "Dale vidim dalsi stopy pumy.", 
			Media = _8Drt, 
			Callback = function(action)
				if action ~= nil then
					Wherigo.ShowScreen(Wherigo.MAINSCREEN)
					_rvl.Active = true
					_rvl.Visible = true
				end
			end
		}
	else
		_Urwigo.MessageBox{
			Text = "Widzac kolejny slad pumy.", 
			Media = _8Drt, 
			Callback = function(action)
				if action ~= nil then
					Wherigo.ShowScreen(Wherigo.MAINSCREEN)
					_rvl.Active = true
					_rvl.Visible = true
				end
			end
		}
	end
end
function __HHN3:OnExit()
	_7Zy = "__HHN3"
	__HHN3.Active = false
	__HHN3.Visible = false
end
function _rCrQG:OnEnter()
	_7Zy = "_rCrQG"
	if _1DNh == true then
		_Urwigo.MessageBox{
			Text = "Nejaka stopa...", 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.MessageBox{
						Text = "Je to stopa pumy?", 
						Media = _J6N, 
						Buttons = {
							"ANO", 
							"NE"
						}, 
						Callback = function(action)
							if action ~= nil then
								if action == "Button2" then
									_Urwigo.MessageBox{
										Text = "Tam jsou dalsi stopy."
									}
									__HHN3.Active = true
									__HHN3.Visible = true
									_mCNI1.Visible = false
								elseif action == "Button1" then
									_z3wi3.Active = true
									_z3wi3.Visible = false
									_9cOm.Active = true
									_9cOm.Visible = true
									_Urwigo.MessageBox{
										Text = "Tam jsou dalsi stopy.", 
										Callback = function(action)
											if action ~= nil then
												_mCNI1.Visible = false
											end
										end
									}
								end
							end
						end
					}
				end
			end
		}
	else
		_Urwigo.MessageBox{
			Text = "Jakies slady...", 
			Media = _J6N, 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.MessageBox{
						Text = "Czy to jest slad pumy?", 
						Media = _J6N, 
						Buttons = {
							"TAK", 
							"NIE"
						}, 
						Callback = function(action)
							if action ~= nil then
								if action == "Button2" then
									_Urwigo.MessageBox{
										Text = "Tam dalej sa kolejne tropy"
									}
									__HHN3.Active = true
									__HHN3.Visible = true
									_mCNI1.Visible = false
								elseif action == "Button1" then
									_z3wi3.Active = true
									_z3wi3.Visible = false
									_9cOm.Active = true
									_9cOm.Visible = true
									_Urwigo.MessageBox{
										Text = "Tam dalej sa kolejne slady", 
										Callback = function(action)
											if action ~= nil then
												_mCNI1.Visible = false
											end
										end
									}
								end
							end
						end
					}
				end
			end
		}
	end
end
function _rCrQG:OnExit()
	_7Zy = "_rCrQG"
	_rCrQG.Active = false
	_rCrQG.Visible = false
end
function _9cOm:OnEnter()
	_7Zy = "_9cOm"
	if _1DNh == true then
		_Urwigo.Dialog(false, {
			{
				Text = "Tato stopa nepatri pume, musime se vratit."
			}
		}, function(action)
			_rCrQG.Active = true
			_rCrQG.Visible = true
		end)
	else
		_Urwigo.Dialog(false, {
			{
				Text = "Ten trop nie nalezal do pumy, musimy sie wrocic."
			}
		}, function(action)
			_rCrQG.Active = true
			_rCrQG.Visible = true
		end)
	end
end
function _wPQBS:OnEnter()
	_7Zy = "_wPQBS"
	if _1DNh == true then
		if _xnu4 == false then
			_Urwigo.Dialog(false, {
				{
					Text = "Vidim pumu, musime strilet."
				}
			}, function(action)
				_LwR.Visible = true
				if _Fq3g.Complete == true then
					if _sgmY < 1 then
						_Urwigo.Dialog(false, {
							{
								Text = [[Nemas uspavaci sipky

UTIKEJ]]
							}
						}, function(action)
							_HzCz7:Start()
						end)
					elseif _sgmY > 0 then
						_6Kv()
					end
				elseif _Fq3g.Complete == false then
					_Urwigo.Dialog(false, {
						{
							Text = [[Nemas zbran, ze ktere muzes strilet.

UTIKEJ]]
						}
					}, function(action)
						_HzCz7:Start()
					end)
				end
			end)
		elseif _xnu4 == true then
			_Urwigo.Dialog(false, {
				{
					Text = "Dobyl jsi ukryt pumy, ale jsi zranen, a zranen nemuzes chytit pumu."
				}
			}, function(action)
				Wherigo.ShowScreen(Wherigo.MAINSCREEN)
			end)
		end
	else
		if _xnu4 == false then
			_Urwigo.Dialog(false, {
				{
					Text = "Juz widze pume, trzeba strzelac."
				}
			}, function(action)
				_LwR.Visible = true
				if _Fq3g.Complete == true then
					if _sgmY < 1 then
						_Urwigo.Dialog(false, {
							{
								Text = [[Nie masz pociskow usypiajacych

UCIEKAJ]]
							}
						}, function(action)
							_HzCz7:Start()
						end)
					elseif _sgmY > 0 then
						_6Kv()
					end
				elseif _Fq3g.Complete == false then
					_Urwigo.Dialog(false, {
						{
							Text = [[Nie masz pistoletu, z ktorego moglbys strzelac.

UCIEKAJ]]
						}
					}, function(action)
						_HzCz7:Start()
					end)
				end
			end)
		elseif _xnu4 == true then
			_Urwigo.Dialog(false, {
				{
					Text = "Dotarles do kryjowki pumy, lecz jestes ranny i z taka rana nie mozesz schwytac pumy."
				}
			}, function(action)
				Wherigo.ShowScreen(Wherigo.MAINSCREEN)
			end)
		end
	end
end
function _wPQBS:OnExit()
	_7Zy = "_wPQBS"
	if _pFLN.Active == true then
		_wPQBS.Active = false
		_wPQBS.Visible = false
		_L2PMk.Active = false
		_L2PMk.Visible = false
	end
end
function _qdqD:OnEnter()
	_7Zy = "_qdqD"
	if _1DNh == true then
		_Urwigo.Dialog(false, {
			{
				Text = "No a nasel jsem souseda Edka.", 
				Media = _Vpq
			}
		}, function(action)
			if _YoCtS == true then
				_Urwigo.MessageBox{
					Text = "Jdi najdriv do skoly a pak si promluvime.", 
					Media = _Vpq
				}
			else
				_Urwigo.MessageBox{
					Text = "Stryc Andrzej te poslal tebe pro zbran. Ale predtim se ujistime, co vis.", 
					Media = _Vpq, 
					Callback = function(action)
						if action ~= nil then
							_Urwigo.RunDialogs(function()
								Wherigo.GetInput(_sHWs5)
							end)
						end
					end
				}
			end
		end)
	else
		_Urwigo.Dialog(false, {
			{
				Text = "No i znalazlem sasiada Edka.", 
				Media = _Vpq
			}
		}, function(action)
			if _YoCtS == true then
				_Urwigo.MessageBox{
					Text = "Idz najpierw do szkoly, a potem porozmawiamy.", 
					Media = _Vpq
				}
			else
				_Urwigo.MessageBox{
					Text = "Przysyla Cie wujek Andrzej po pistolet. Ale najpierw upewnijmy sie, ze czy wiesz na co polujesz.", 
					Media = _Vpq, 
					Callback = function(action)
						if action ~= nil then
							_Urwigo.RunDialogs(function()
								Wherigo.GetInput(_kEg)
							end)
						end
					end
				}
			end
		end)
	end
end
function _qdqD:OnExit()
	_7Zy = "_qdqD"
	if _YoCtS == true then
		_fip.Visible = true
		_fip.Active = true
	else
		if _1DNh == true then
			_Urwigo.Dialog(false, {
				{
					Text = [[Pry jsou v okoli skauti, treba nektereho z nich potkas behem cesty potkas.
]]
				}, 
				{
					Text = "Jeden je udajne blizko kostela.", 
					Media = _dWGMn
				}
			}, function(action)
				if _Fq3g.Complete == true then
					_qdqD.Visible = false
					_qdqD.Active = false
					_dRG.Active = true
				end
			end)
		else
			_Urwigo.Dialog(false, {
				{
					Text = "Podobno po okolicy chodza harcerze, moze spotkasz jakiegos w trakcie wedrowki."
				}, 
				{
					Text = "Jeden podobno jest kolo kosciola.", 
					Media = _dWGMn
				}
			}, function(action)
				if _Fq3g.Complete == true then
					_qdqD.Visible = false
					_qdqD.Active = false
					_dRG.Active = true
				end
			end)
		end
	end
end
function _xjB:OnEnter()
	_7Zy = "_xjB"
	if _1DNh == true then
		_Urwigo.MessageBox{
			Text = "Podarilo se ti utec. Tady jsi v bezpeci.", 
			Callback = function(action)
				if action ~= nil then
					_HzCz7:Stop()
				end
			end
		}
	else
		_Urwigo.MessageBox{
			Text = "Dotarles do miejsca, gdzie puma Ci nie zagrozi.", 
			Callback = function(action)
				if action ~= nil then
					_HzCz7:Stop()
				end
			end
		}
	end
end
function _xjB:OnExit()
	_7Zy = "_xjB"
	_xjB.Active = false
	_xjB.Visible = false
end
function _Bsdk_:OnEnter()
	_7Zy = "_Bsdk_"
	if _1DNh == true then
		_Urwigo.Dialog(false, {
			{
				Text = "Dekuji ti za pomoc pri chyceni pumy."
			}, 
			{
				Text = "Tak premyslim, co tady ta puma delala? Nebo spise co hlidala."
			}
		}, function(action)
			_pFLN.Complete = true
			_K1eW.Visible = false
			_Tfx.Active = true
			_Tfx.Visible = true
			_Tfx.Active = true
			_Tfx.Visible = true
			_Swxqm.Active = true
			_Swxqm.Visible = true
			Wherigo.ShowScreen(Wherigo.MAINSCREEN)
		end)
	else
		_Urwigo.Dialog(false, {
			{
				Text = "Dziekuje Ci za pomoc w schwytaniu pumy."
			}, 
			{
				Text = "A swoja droga czego ona tutaj szukala, albo raczej pilnowala."
			}
		}, function(action)
			_pFLN.Complete = true
			_K1eW.Visible = false
			_Tfx.Active = true
			_Tfx.Visible = true
			_Tfx.Active = true
			_Tfx.Visible = true
			_Swxqm.Active = true
			_Swxqm.Visible = true
			Wherigo.ShowScreen(Wherigo.MAINSCREEN)
		end)
	end
end
function _Bsdk_:OnExit()
	_7Zy = "_Bsdk_"
	_Bsdk_.Active = false
	_Bsdk_.Visible = false
end
function _Tfx:OnEnter()
	_7Zy = "_Tfx"
	if _1DNh == true then
		_Urwigo.Dialog(false, {
			{
				Text = "Nekde tady je skrys."
			}
		}, function(action)
			_w7uE:Start()
		end)
	else
		_Urwigo.Dialog(false, {
			{
				Text = "Gdzies tutaj jest ukryte."
			}
		}, function(action)
			_w7uE:Start()
		end)
	end
end
function _Tfx:OnExit()
	_7Zy = "_Tfx"
	if _Swxqm.Complete == true then
		_Tfx.Active = false
		_Tfx.Visible = false
	end
end
function _4ZI:OnEnter()
	_7Zy = "_4ZI"
	if _1DNh == true then
		_Urwigo.Dialog(false, {
			{
				Text = "Podarilo se ti zderhnout pred pumou.", 
				Media = _7w2n
			}
		}, function(action)
			_oLP2l:Stop()
			_Urwigo.Dialog(false, {
				{
					Text = "Vim, kde najit tu spravnou stopu pumy, ktera by vedla k nalezeni pumy.", 
					Media = _lytlT
				}, 
				{
					Text = "Mate tu jeste uspavaci sipku.", 
					Media = _iiEPM
				}
			}, function(action)
				_rvl.Active = true
				_rvl.Visible = true
				_sgmY = _sgmY + 1
				_yWmj.Visible = false
			end)
		end)
	else
		_Urwigo.Dialog(false, {
			{
				Text = "Udalo Ci sie udziec przed puma.", 
				Media = _7w2n
			}
		}, function(action)
			_oLP2l:Stop()
			_Urwigo.Dialog(false, {
				{
					Text = "Wiem, gdzie jest wlasciwy trop do odnalezienia pumy.", 
					Media = _lytlT
				}, 
				{
					Text = "Masz tu jeszcze pocisk usypiajacy.", 
					Media = _iiEPM
				}
			}, function(action)
				_rvl.Active = true
				_rvl.Visible = true
				_sgmY = _sgmY + 1
				_yWmj.Visible = false
			end)
		end)
	end
end
function _4ZI:OnExit()
	_7Zy = "_4ZI"
	_4ZI.Active = false
	_4ZI.Visible = false
end
function _rvl:OnEnter()
	_7Zy = "_rvl"
	if _1DNh == true then
		_Urwigo.Dialog(false, {
			{
				Text = "Tady stopy se konci. Co ted?"
			}, 
			{
				Text = "Dale rovno?"
			}, 
			{
				Text = "Nebo vlevo - dolu cestou."
			}
		}, function(action)
			_r1I.Active = true
			_r1I.Visible = false
			_V_i5j.Active = true
			_V_i5j.Visible = false
		end)
	else
		_Urwigo.Dialog(false, {
			{
				Text = "Tutaj slad sie konczy. Dokad teraz?"
			}, 
			{
				Text = "Dalej prosto?"
			}, 
			{
				Text = "Czy moze w lewo (na dol)?"
			}
		}, function(action)
			_r1I.Active = true
			_r1I.Visible = false
			_V_i5j.Active = true
			_V_i5j.Visible = false
		end)
	end
end
function _rvl:OnExit()
	_7Zy = "_rvl"
	_rvl.Active = false
	_rvl.Visible = false
end
function _6aD:OnEnter()
	_7Zy = "_6aD"
	if _1DNh == true then
		_Urwigo.Dialog(false, {
			{
				Text = "Uz vim, kde je ukryt pumy."
			}
		}, function(action)
			_wPQBS.Active = true
			_wPQBS.Visible = true
		end)
	else
		_Urwigo.Dialog(false, {
			{
				Text = "Juz wiem, gdzie jest kryjowka."
			}
		}, function(action)
			_wPQBS.Active = true
			_wPQBS.Visible = true
		end)
	end
end
function _6aD:OnExit()
	_7Zy = "_6aD"
	_6aD.Active = false
	_6aD.Visible = false
end
function _Erk:OnEnter()
	_7Zy = "_Erk"
	_lBE:Stop()
end
function _Erk:OnExit()
	_7Zy = "_Erk"
	_Erk.Active = false
	_Erk.Visible = false
end
function _KMt:OnEnter()
	_7Zy = "_KMt"
	if _1DNh == true then
		_Urwigo.Dialog(false, {
			{
				Text = "Dobry den, myslivce. Vidim, ze jsi zranen. Muzu vas vylecit, ale to te bude stat hodne."
			}
		}, function(action)
			_Urwigo.MessageBox{
				Text = "Dej mi uspavaci sipku.", 
				Callback = function(action)
					if action ~= nil then
						if _sgmY == 0 then
							_Urwigo.OldDialog{
								{
									Text = "Nemas zadne sipky, vrat se, az nejake budes mit."
								}
							}
						else
							_sgmY = _sgmY + -1
							_xnu4 = false
							_Urwigo.Dialog(false, {
								{
									Text = "Jdi dal,  jsi zdravi, ja mam spoustu prace."
								}
							}, function(action)
								_vndr1.Active = false
								_vndr1.Visible = false
							end)
						end
						_wPQBS.Active = true
						_wPQBS.Visible = true
					end
				end
			}
		end)
	else
		_Urwigo.Dialog(false, {
			{
				Text = "Witam Cie lowco. Widze, iz jestes ranny. Moge Cie uleczyc, ale to bedzie Cie kosztowalo."
			}
		}, function(action)
			_wPQBS.Visible = true
			_Urwigo.MessageBox{
				Text = "Dasz mi pocisk usypiajacy. ", 
				Callback = function(action)
					if action ~= nil then
						if _sgmY == 0 then
							_Urwigo.OldDialog{
								{
									Text = "Niemasz zadnych strzalek, wroc jak bedziesz mial jakies."
								}
							}
						else
							_sgmY = _sgmY + -1
							_xnu4 = false
							_Urwigo.Dialog(false, {
								{
									Text = "Idz juz, zdrow juz jestes, a ja mam prace."
								}
							}, function(action)
								_vndr1.Active = false
								_vndr1.Visible = false
							end)
						end
					end
				end
			}
			_wPQBS.Active = true
		end)
	end
end
function _KMt:OnExit()
	_7Zy = "_KMt"
	if _xnu4 == true then
	else
		_KMt.Active = false
		_KMt.Visible = false
	end
end
function _fip:OnEnter()
	_7Zy = "_fip"
	if _1DNh == true then
		_Urwigo.Dialog(false, {
			{
				Text = "Puma je velka kockovita selma. Je to nejvetsi kockovita selma Severni Ameriky a nejvetsi zastupce malych kocek. Nekdy se ji rika kuguar."
			}, 
			{
				Text = [[Vyska v kohoutku: 61-76 cm
Delka tela: 95-243 cm
Delka ocasu: 53-82 cm
Hmotnost:
Samice v prumeru 35-50 kg
Samci v rumeru 60-75 kg.]]
			}, 
			{
				Text = "Takhle vypada stopa pumy.", 
				Media = _Rh64
			}
		}, function(action)
			_YoCtS = false
		end)
	else
		_Urwigo.Dialog(false, {
			{
				Text = "Puma to drapiezny ssak z rodziny kotowatych. Jest najwiekszym przedstawicielem malych kotow. Pochodzi z Ameryki. Nazywana takze kuguarem."
			}, 
			{
				Text = [[Wielkosc:
dlugosc ciala 100-200 cm
ogon o dlugosci  50-85 cm
wysokosc w klebie 52-78 cm
masa cia?a srednio samice 35-50 kg, samce 60-75 kg ]]
			}, 
			{
				Text = "Tak wyglada slad pumy.", 
				Media = _Rh64
			}
		}, function(action)
			_YoCtS = false
		end)
	end
end
function _fip:OnDistant()
	_7Zy = "_fip"
	if _KmmK == true then
		_fip.Visible = true
	else
		if _1DNh == true then
			_Urwigo.Dialog(false, {
				{
					Text = "Vidim skolu, mozna se dozvime neco zajimaveho."
				}
			}, function(action)
				_fip.Visible = true
				_KmmK = true
			end)
		else
			_Urwigo.Dialog(false, {
				{
					Text = "Widze szkole, moze dowiemy sie czegos ciekawego."
				}
			}, function(action)
				_fip.Visible = true
				_KmmK = true
			end)
		end
	end
end
function _gQ0E:OnEnter()
	_7Zy = "_gQ0E"
	if _Swxqm.Complete == false then
		_Urwigo.MessageBox{
			Text = [[Wybierz jezyk

Vyberte jazyk]], 
			Buttons = {
				"Polski", 
				"Cesky"
			}, 
			Callback = function(action)
				if action ~= nil then
					if action == "Button2" then
						_1DNh = true
						_Urwigo.Dialog(false, {
							{
								Text = "Nejlepsi bude,  kdyz tu nechas svoje auto."
							}
						}, function(action)
							_3u7F2.Visible = true
							_3u7F2.Active = true
						end)
					elseif action == "Button1" then
						_1DNh = false
						_Urwigo.Dialog(false, {
							{
								Text = "Najlepiej bedzie jak tutaj zostawisz swoj samochod."
							}
						}, function(action)
							_3u7F2.Visible = true
							_3u7F2.Active = true
						end)
					end
				end
			end
		}
	end
end
function _5OK:OnEnter()
	_7Zy = "_5OK"
	_Urwigo.Dialog(false, {
		{
			Text = "Vidim strycka Andrzeje.", 
			Media = _XNC
		}, 
		{
			Text = "Abys jsi mohl chytit pumu musis mit zbran a uspavaci sipky.", 
			Media = _XNC
		}, 
		{
			Text = "Zbran, jsem zrovna pujcil sousedovi Edkovi. Jdi k nemu, on ti da.", 
			Media = _XNC
		}, 
		{
			Text = "Uspavaci sipky jsou u skautou.", 
			Media = _iiEPM
		}
	}, function(action)
		_qdqD.Active = true
		_qdqD.Visible = true
		_Fq3g.Active = true
		_Fq3g.Visible = true
		_L2PMk.Active = true
		_L2PMk.Visible = true
		_Xdm.Visible = true
		_Xdm.Active = true
	end)
end
function _5OK:OnExit()
	_7Zy = "_5OK"
	if (_Xdm.Active and _Fq3g.Active) == true then
		_5OK.Visible = false
		_5OK.Active = false
	elseif (_Xdm.Active or _Fq3g.Active) == false then
		_Urwigo.OldDialog{
			{
				Text = "Nemyslim si, ze vis vsechno."
			}
		}
	end
end
function _r1I:OnEnter()
	_7Zy = "_r1I"
	_Urwigo.OldDialog{
		{
			Text = "Slady te z cala pewnoscia nie naleza do pumy. Trzeba szukac, gdzie indziej."
		}
	}
end
function _V_i5j:OnEnter()
	_7Zy = "_V_i5j"
	_Urwigo.MessageBox{
		Text = "Juz widze nastepny trop.", 
		Media = _8Drt, 
		Callback = function(action)
			if action ~= nil then
				_6aD.Active = true
				_6aD.Visible = true
			end
		end
	}
end
function _V_i5j:OnExit()
	_7Zy = "_V_i5j"
	_V_i5j.Active = false
end
function _vndr1:OnSetActive()
	if _xnu4 == true then
		_vndr1.Active = true
		_vndr1.Visible = true
	end
end
function _kEg:OnGetInput(input)
	if input == nil then
		input = ""
	end
	if _Urwigo.Hash(string.lower(input)) == 41441 then
		_Urwigo.OldDialog{
			{
				Text = "Dobrze, tutaj masz pistolet.", 
				Media = _tFbeX
			}
		}
		_L2h3:MoveTo(Player)
		_L2h3.Visible = true
		_Fq3g.Complete = true
		_lu84.Visible = false
	elseif _Urwigo.Hash(string.lower(input)) == 44942 then
		_Urwigo.MessageBox{
			Text = [[Masz jeszcze jedna szanse.

Czy puma pochodzi z Ameryki?]], 
			Media = _Vpq, 
			Buttons = {
				"Tak", 
				"Nie"
			}, 
			Callback = function(action)
				if action ~= nil then
					if action == "Button1" then
						_Urwigo.OldDialog{
							{
								Text = "Dobrze, tutaj masz pistolet.", 
								Media = _tFbeX
							}
						}
						_L2h3:MoveTo(Player)
						_L2h3.Visible = true
						_Fq3g.Complete = true
						_lu84.Visible = false
					elseif action == "Button2" then
						_Urwigo.Dialog(false, {
							{
								Text = "Idz sie uczyc. Bo inaczej ona zapoluje na Ciebie"
							}
						}, function(action)
							_YoCtS = true
						end)
					end
				end
			end
		}
	elseif _Urwigo.Hash(string.lower(input)) == 3479 then
		_Urwigo.MessageBox{
			Text = [[Masz jeszcze jedna szanse.

Czy puma pochodzi z Ameryki?]], 
			Media = _Vpq, 
			Buttons = {
				"Tak", 
				"Nie"
			}, 
			Callback = function(action)
				if action ~= nil then
					if action == "Button1" then
						_Urwigo.OldDialog{
							{
								Text = "Dobrze, tutaj masz pistolet.", 
								Media = _tFbeX
							}
						}
						_L2h3:MoveTo(Player)
						_L2h3.Visible = true
						_Fq3g.Complete = true
						_lu84.Visible = false
						_Fq3g.Visible = false
					elseif action == "Button2" then
						_Urwigo.Dialog(false, {
							{
								Text = "Idz sie uczyc, bo inaczej ona zapoluje na Ciebie."
							}
						}, function(action)
							_YoCtS = true
						end)
					end
				end
			end
		}
	elseif _Urwigo.Hash(string.lower(input)) == 11613 then
		_Urwigo.OldDialog{
			{
				Text = "Dobrze, tutaj masz pistolet.", 
				Media = _tFbeX
			}
		}
		_L2h3:MoveTo(Player)
		_L2h3.Visible = true
		_Fq3g.Complete = true
		_lu84.Visible = false
	end
end
function _JXi:OnGetInput(input)
	if input == nil then
		input = ""
	end
	if _1DNh == true then
		if input == true then
			_Urwigo.OldDialog{
				{
					Text = "Dobrze, tutaj masz pistolet.", 
					Media = _tFbeX
				}
			}
			_L2h3:MoveTo(Player)
			_L2h3.Visible = true
			_Fq3g.Complete = true
			_lu84.Visible = false
		elseif input == false then
			_Urwigo.OldDialog{
				{
					Text = "Idzie sie uczyc"
				}
			}
		end
	else
		if input == true then
			_Urwigo.OldDialog{
				{
					Text = "Dobrze, tutaj masz pistolet.", 
					Media = _tFbeX
				}
			}
			_L2h3:MoveTo(Player)
			_L2h3.Visible = true
			_Fq3g.Complete = true
			_lu84.Visible = false
		elseif input == false then
			_Urwigo.OldDialog{
				{
					Text = "Idzie sie uczyc"
				}
			}
		end
	end
end
function _sHWs5:OnGetInput(input)
	if input == nil then
		input = ""
	end
	if _Urwigo.Hash(string.lower(input)) == 41441 then
		_Urwigo.OldDialog{
			{
				Text = "Je to sparvne, tady mas zbran.", 
				Media = _tFbeX
			}
		}
		_L2h3:MoveTo(Player)
		_L2h3.Visible = true
		_Fq3g.Complete = true
		_lu84.Visible = false
	elseif _Urwigo.Hash(string.lower(input)) == 44942 then
		_Urwigo.MessageBox{
			Text = [[Tak to neni. Mas jeste jednu sanci.

Puma pohazi z Ameryky?]], 
			Media = _Vpq, 
			Buttons = {
				"ANO", 
				"NE"
			}, 
			Callback = function(action)
				if action ~= nil then
					if action == "Button1" then
						_Urwigo.OldDialog{
							{
								Text = "Je to sparvne, tady mas zbran.", 
								Media = _tFbeX
							}
						}
						_L2h3:MoveTo(Player)
						_L2h3.Visible = true
						_Fq3g.Complete = true
						_lu84.Visible = false
					elseif action == "Button2" then
						_Urwigo.Dialog(false, {
							{
								Text = "Jdi se ucit. V opacnem pripade puma bude puma lovit tebe."
							}
						}, function(action)
							_YoCtS = true
						end)
					end
				end
			end
		}
	elseif _Urwigo.Hash(string.lower(input)) == 3479 then
		_Urwigo.MessageBox{
			Text = [[Tak to neni. Mas jeste jednu sanci.

Puma puvodne pohazi z Ameryky?]], 
			Media = _Vpq, 
			Buttons = {
				"Ano", 
				"Ne"
			}, 
			Callback = function(action)
				if action ~= nil then
					if action == "Button1" then
						_Urwigo.OldDialog{
							{
								Text = "Je to sparvne, tady mas zbran.", 
								Media = _tFbeX
							}
						}
						_L2h3:MoveTo(Player)
						_L2h3.Visible = true
						_Fq3g.Complete = true
						_lu84.Visible = false
						_Fq3g.Visible = false
					elseif action == "Button2" then
						_Urwigo.Dialog(false, {
							{
								Text = "Jdi se ucit. V opacnem pripade puma bude puma lovit tebe."
							}
						}, function(action)
							_YoCtS = true
						end)
					end
				end
			end
		}
	elseif _Urwigo.Hash(string.lower(input)) == 14124 then
		_Urwigo.OldDialog{
			{
				Text = "Je to sparvne, tady mas zbran.", 
				Media = _tFbeX
			}
		}
		_L2h3:MoveTo(Player)
		_L2h3.Visible = true
		_Fq3g.Complete = true
		_lu84.Visible = false
	end
end
function _HzCz7:OnStart()
	if _1DNh == true then
		_Urwigo.MessageBox{
			Text = "Utikej do bezpeci.", 
			Callback = function(action)
				if action ~= nil then
					_xjB.Active = true
					_xjB.Visible = true
				end
			end
		}
	else
		_Urwigo.MessageBox{
			Text = "Uciekaj w bezpieczne miejsce", 
			Callback = function(action)
				if action ~= nil then
					_xjB.Active = true
					_xjB.Visible = true
				end
			end
		}
	end
end
function _HzCz7:OnTick()
	if _1DNh == true then
		_Urwigo.MessageBox{
			Text = [[Puma je velmi rychla. Nepodarilo se nam utect.
Zranila nas, ale vim o miste, kde muzeme se vylecit.]], 
			Callback = function(action)
				if action ~= nil then
					_xnu4 = true
					_wPQBS.Active = false
					_wPQBS.Visible = false
					_L2PMk.Active = true
					_L2PMk.Visible = true
					_xjB.Active = false
					_xjB.Visible = false
					_9cOm.Active = false
					_9cOm.Visible = false
					_rCrQG.Active = false
					_rCrQG.Visible = false
					_KMt.Active = true
					_KMt.Visible = true
					Wherigo.ShowScreen(Wherigo.MAINSCREEN)
				end
			end
		}
	else
		_Urwigo.MessageBox{
			Text = [[Puma jest bardzo szybka. Nieudalo nam sie uciec.
Zranila nas, lecz znam miejsce, gdzie mozemy sie uleczyc.]], 
			Callback = function(action)
				if action ~= nil then
					_xnu4 = true
					_wPQBS.Active = false
					_wPQBS.Visible = false
					_L2PMk.Active = true
					_L2PMk.Visible = true
					_xjB.Active = false
					_xjB.Visible = false
					_9cOm.Active = false
					_9cOm.Visible = false
					_rCrQG.Active = false
					_rCrQG.Visible = false
					_KMt.Active = true
					_KMt.Visible = true
					Wherigo.ShowScreen(Wherigo.MAINSCREEN)
				end
			end
		}
	end
end
function _lBE:OnStart()
	__HHN3.Active = false
	__HHN3.Visible = false
end
function _lBE:OnStop()
	if _1DNh == true then
		_Urwigo.Dialog(false, {
			{
				Text = [[Bohuzel se ti nepodarilo ji chytit, ale potkal si skauta.
]], 
				Media = _gW59
			}, 
			{
				Text = "Dal ti uspavaci sipku, a take ukazal misto, kde videl stopy pumy.", 
				Media = _iiEPM
			}
		}, function(action)
			_rvl.Active = true
			_rvl.Visible = true
			__HHN3.Active = false
			__HHN3.Visible = false
			_sgmY = _sgmY + 1
		end)
	else
		_Urwigo.Dialog(false, {
			{
				Text = "Niestety nie udalo Ci jej zlapac, ale spotkales harcerza, ktory podal miejsce, gdzie widzial slady pumy.", 
				Media = _gW59
			}, 
			{
				Text = "Dodatkowo dal Ci pocisk usypiajacy.", 
				Media = _iiEPM
			}
		}, function(action)
			_rvl.Active = true
			_rvl.Visible = true
			__HHN3.Active = false
			__HHN3.Visible = false
			_sgmY = _sgmY + 1
		end)
	end
end
function _lBE:OnTick()
	if _1DNh == true then
		_Urwigo.Dialog(false, {
			{
				Text = [[Bohuzel se ti nepodarilo ji chytit, ale potkal jsi skauta.
]]
			}, 
			{
				Text = "Nastesti jsi potkal skautku, ktera ti ukaza spravny smer hledani pumy.", 
				Media = _lytlT
			}
		}, function(action)
			_Erk.Visible = false
			_Erk.Active = false
			_rvl.Active = true
			_rvl.Visible = true
			__HHN3.Active = false
			__HHN3.Visible = false
		end)
	else
		_Urwigo.Dialog(false, {
			{
				Text = "Niestety nie udalo ci sie zlapac pumy, a w dodatku wyprowadzila Cie, gdzies w pole."
			}, 
			{
				Text = "Ale na szczescie spotkales harcerke, ktora wzkazala Ci wlasciwy kierunek poszukiwan.", 
				Media = _lytlT
			}
		}, function(action)
			_Erk.Visible = false
			_Erk.Active = false
			_rvl.Active = true
			_rvl.Visible = true
			__HHN3.Active = false
			__HHN3.Visible = false
		end)
	end
end
function _oLP2l:OnStart()
	_4ZI.Active = true
	_4ZI.Visible = true
end
function _oLP2l:OnTick()
	if _1DNh == true then
		_Urwigo.MessageBox{
			Text = [[Puma je velmi rychla. Nepodarilo se nam utect.
Zranila nas, ale vim, o miste, kde muzeme se vylecit.]], 
			Callback = function(action)
				if action ~= nil then
					_xnu4 = true
					_wPQBS.Active = false
					_wPQBS.Visible = false
					_L2PMk.Active = true
					_L2PMk.Visible = true
					_rvl.Active = true
					_rvl.Visible = true
					_9cOm.Active = false
					_9cOm.Visible = false
					_rCrQG.Active = false
					_rCrQG.Visible = false
					_KMt.Active = true
					_KMt.Visible = true
					_4ZI.Active = false
					_4ZI.Visible = false
					Wherigo.ShowScreen(Wherigo.MAINSCREEN)
				end
			end
		}
	else
		_Urwigo.MessageBox{
			Text = [[Puma jest bardzo szybka. Nieudalo nam sie uciec.
Zranila nas, lecz znam miejsce, gdzie mozemy sie uleczyc.]], 
			Callback = function(action)
				if action ~= nil then
					_xnu4 = true
					_wPQBS.Active = false
					_wPQBS.Visible = false
					_L2PMk.Active = true
					_L2PMk.Visible = true
					_rvl.Active = true
					_rvl.Visible = true
					_9cOm.Active = false
					_9cOm.Visible = false
					_rCrQG.Active = false
					_rCrQG.Visible = false
					_KMt.Active = true
					_KMt.Visible = true
					_4ZI.Active = false
					_4ZI.Visible = false
					Wherigo.ShowScreen(Wherigo.MAINSCREEN)
				end
			end
		}
	end
end
function _w7uE:OnTick()
	if _1DNh == true then
		_Urwigo.MessageBox{
			Text = "Znasel jsi uz neco?", 
			Buttons = {
				"ANO", 
				"NE"
			}, 
			Callback = function(action)
				if action ~= nil then
					if action == "Button2" then
						_Urwigo.Dialog(false, {
							{
								Text = [[Hledej dal.

Vysoko.]], 
								Media = _5v3
							}
						}, function(action)
							_w7uE:Start()
						end)
					elseif action == "Button1" then
						_Urwigo.Dialog(false, {
							{
								Text = "Blahopreju nasel jsi poklad."
							}, 
							{
								Text = ("Vas kod je:"..string.sub(Player.CompletionCode, 1, 15)).."Je take v Invertory."
							}, 
							{
								Text = "Nyni muzete pokracovat smerem k autu."
							}, 
							{
								Text = "Doufam, ze hra se ti libila a hralo se ti dobre a bez problemu."
							}
						}, function(action)
							_Swxqm.Complete = true
							_flZ.Complete = true
							_aKVah = string.sub(Player.CompletionCode, 1, 15)
							_L2h3.Visible = false
							_1vTjn.Visible = false
							_xPYro:MoveTo(Player)
							_gQ0E.Active = true
							_gQ0E.Visible = true
							Wherigo.ShowScreen(Wherigo.MAINSCREEN)
							_flZ:RequestSync()
						end)
					end
				end
			end
		}
	else
		_Urwigo.MessageBox{
			Text = "Znalazles juz cos?", 
			Buttons = {
				"TAK", 
				"NIE"
			}, 
			Callback = function(action)
				if action ~= nil then
					if action == "Button2" then
						_Urwigo.Dialog(false, {
							{
								Text = "Szukaj dalej wysoko.", 
								Media = _5v3
							}
						}, function(action)
							_w7uE:Start()
						end)
					elseif action == "Button1" then
						_Urwigo.Dialog(false, {
							{
								Text = "Gratulacje znalazles skarb"
							}, 
							{
								Text = ("Twoj kod to:"..string.sub(Player.CompletionCode, 1, 15)).."Do zobaczenia takze w Invertory"
							}, 
							{
								Text = "Mozesz teraz isc na po swoj samochod."
							}, 
							{
								Text = "Mam nadzieje, ze gra sie podobalo i przyjemnie sie gralo."
							}
						}, function(action)
							_Swxqm.Complete = true
							_flZ.Complete = true
							_aKVah = string.sub(Player.CompletionCode, 1, 15)
							_xPYro:MoveTo(Player)
							_L2h3.Visible = false
							_1vTjn.Visible = false
							_flZ:RequestSync()
							_gQ0E.Active = true
							_gQ0E.Visible = true
							Wherigo.ShowScreen(Wherigo.MAINSCREEN)
						end)
					end
				end
			end
		}
	end
end
function _1vTjn:OnClick()
	if _1DNh == true then
		_Urwigo.MessageBox{
			Text = ("Mas ted ".._sgmY).." uspavacich sipek."
		}
	else
		_Urwigo.MessageBox{
			Text = ("Posiadasz teraz ".._sgmY).." pociskow usypiajacych."
		}
	end
end
function _xPYro:OnClick()
	if _1DNh == true then
		_Urwigo.MessageBox{
			Text = "Klic do hry: ".._aKVah
		}
	else
		_Urwigo.MessageBox{
			Text = "Twoj kod to:  ".._aKVah
		}
	end
end

-- Urwigo functions --
function _6Kv()
	if _sgmY > 0 then
		if _1DNh == true then
			local _rndChoiceValue = math.random()
			if _rndChoiceValue < 0.75 then
				_Urwigo.MessageBox{
					Text = "Sipka nezasahla cil, rychle strilej znova.", 
					Callback = function(action)
						if action ~= nil then
							_sgmY = _sgmY + -1
							_6Kv()
						end
					end
				}
			else
				_Urwigo.MessageBox{
					Text = [[Podarilo se trefil ses.

Puma uz spi.]], 
					Callback = function(action)
						if action ~= nil then
							_sgmY = _sgmY + -1
							_Bsdk_.Active = true
							_Bsdk_.Visible = true
							_LwR.Visible = false
							_pFLN.Visible = true
							_pFLN.Active = true
							_K1eW.Visible = true
							_K1eW:MoveTo(Player)
							_hXPT.Complete = true
							_Urwigo.OldDialog{
								{
									Text = "Vzij spisi pume ke Gajowce."
								}
							}
						end
					end
				}
			end
		else
			local _rndChoiceValue = math.random()
			if _rndChoiceValue < 0.8 then
				_Urwigo.MessageBox{
					Text = "Chybiles, szybko strzelaj jeszcze raz", 
					Callback = function(action)
						if action ~= nil then
							_sgmY = _sgmY + -1
							_6Kv()
						end
					end
				}
			else
				_Urwigo.MessageBox{
					Text = [[Udalo sie, trafiles.

Puma juz smacznie spi.]], 
					Callback = function(action)
						if action ~= nil then
							_sgmY = _sgmY + -1
							_Bsdk_.Active = true
							_Bsdk_.Visible = true
							_LwR.Visible = false
							_pFLN.Visible = true
							_pFLN.Active = true
							_K1eW.Visible = true
							_K1eW:MoveTo(Player)
							_hXPT.Complete = true
							_Urwigo.OldDialog{
								{
									Text = "Zanies spiace pume do Gajowki."
								}
							}
						end
					end
				}
			end
		end
	elseif _sgmY < 1 then
		if _1DNh == true then
			_Urwigo.Dialog(false, {
				{
					Text = [[Nemas uspavaci sipky

UTIKEJ]]
				}
			}, function(action)
				_HzCz7:Start()
			end)
		else
			_Urwigo.Dialog(false, {
				{
					Text = [[Niemasz usypajacych strzalek

UCIEKAJ]]
				}
			}, function(action)
				_HzCz7:Start()
			end)
		end
	end
end

-- Begin user functions --
-- End user functions --
return _flZ
