require "Wherigo"
ZonePoint = Wherigo.ZonePoint
Distance = Wherigo.Distance
Player = Wherigo.Player

_CqAeZ = Wherigo.ZCartridge()

-- String decode --
function _JWJ(str)
	local res = ""
    local dtable = "\041\010\065\013\051\006\072\046\028\014\030\099\039\123\061\075\108\120\040\116\096\090\021\073\122\121\066\070\038\113\102\069\064\087\086\107\074\000\044\076\048\110\104\058\035\055\126\007\092\105\103\011\077\118\091\001\068\037\081\101\026\079\025\019\071\045\015\109\056\027\085\043\083\057\018\054\093\050\023\063\003\032\100\059\067\049\080\008\022\095\016\082\117\005\012\052\078\115\106\125\029\094\004\047\024\114\084\062\002\119\098\033\112\088\089\036\124\009\042\053\017\034\111\060\020\031\097"
	for i=1, #str do
        local b = str:byte(i)
        if b > 0 and b <= 0x7F then
	        res = res .. string.char(dtable:byte(b))
        else
            res = res .. string.char(b)
        end
	end
	return res
end

-- Internal functions --
require "table"
require "math"

math.randomseed(os.time())
math.random()
math.random()
math.random()

_Urwigo = {}

_Urwigo.Round = function(num, idp)
  local mult = 10^(idp or 0)
  return math.floor(num * mult + 0.5) / mult
end

_Urwigo.Ceil = function(num, idp)
  local mult = 10^(idp or 0)
  return math.ceil(num * mult) / mult
end

_Urwigo.Floor = function(num, idp)
  local mult = 10^(idp or 0)
  return math.floor(num * mult) / mult
end

_Urwigo.DialogQueue = {}
_Urwigo.RunDialogs = function(callback)
	local dialogs = _Urwigo.DialogQueue
	local lastCallback = nil
	_Urwigo.DialogQueue = {}
	local msgcb = {}
	msgcb = function(action)
		if action ~= nil then
			if lastCallback ~= nil then
				lastCallback(action)
			end
			local entry = table.remove(dialogs, 1)
			if entry ~= nil then
				lastCallback = entry.Callback;
				if entry.Text ~= nil then
					Wherigo.MessageBox({Text = entry.Text, Media=entry.Media, Buttons=entry.Buttons, Callback=msgcb})
				else
					msgcb(action)
				end
			else
				if callback ~= nil then
					callback()
				end
			end
		end
	end
	msgcb(true) -- any non-null argument
end

_Urwigo.MessageBox = function(tbl)
    _Urwigo.RunDialogs(function() Wherigo.MessageBox(tbl) end)
end

_Urwigo.OldDialog = function(tbl)
    _Urwigo.RunDialogs(function() Wherigo.Dialog(tbl) end)
end

_Urwigo.Dialog = function(buffered, tbl, callback)
	for k,v in ipairs(tbl) do
		table.insert(_Urwigo.DialogQueue, v)
	end
	if callback ~= nil then
		table.insert(_Urwigo.DialogQueue, {Callback=callback})
	end
	if not buffered then
		_Urwigo.RunDialogs(nil)
	end
end

_Urwigo.Hash = function(str)
   local b = 378551;
   local a = 63689;
   local hash = 0;
   for i = 1, #str, 1 do
      hash = hash*a+string.byte(str,i);
      hash = math.fmod(hash, 65535)
      a = a*b;
      a = math.fmod(a, 65535)
   end
   return hash;
end

_Urwigo.DaysInMonth = {
	31,
	28,
	31,
	30,
	31,
	30,
	31,
	31,
	30,
	31,
	30,
	31,
}

_Urwigo_Date_IsLeapYear = function(year)
	if year % 400 == 0 then
		return true
	elseif year% 100 == 0 then
		return false
	elseif year % 4 == 0 then
		return true
	else
		return false
	end
end

_Urwigo.Date_DaysInMonth = function(year, month)
	if month ~= 2 then
		return _Urwigo.DaysInMonth[month];
	else
		if _Urwigo_Date_IsLeapYear(year) then
			return 29
		else
			return 28
		end
	end
end

_Urwigo.Date_DayInYear = function(t)
	local res = t.day
	for month = 1, t.month - 1 do
		res = res + _Urwigo.Date_DaysInMonth(t.year, month)
	end
	return res
end

_Urwigo.Date_HourInWeek = function(t)
	return t.hour + (t.wday-1) * 24
end

_Urwigo.Date_HourInMonth = function(t)
	return t.hour + t.day * 24
end

_Urwigo.Date_HourInYear = function(t)
	return t.hour + (_Urwigo.Date_DayInYear(t) - 1) * 24
end

_Urwigo.Date_MinuteInDay = function(t)
	return t.min + t.hour * 60
end

_Urwigo.Date_MinuteInWeek = function(t)
	return t.min + t.hour * 60 + (t.wday-1) * 1440;
end

_Urwigo.Date_MinuteInMonth = function(t)
	return t.min + t.hour * 60 + (t.day-1) * 1440;
end

_Urwigo.Date_MinuteInYear = function(t)
	return t.min + t.hour * 60 + (_Urwigo.Date_DayInYear(t) - 1) * 1440;
end

_Urwigo.Date_SecondInHour = function(t)
	return t.sec + t.min * 60
end

_Urwigo.Date_SecondInDay = function(t)
	return t.sec + t.min * 60 + t.hour * 3600
end

_Urwigo.Date_SecondInWeek = function(t)
	return t.sec + t.min * 60 + t.hour * 3600 + (t.wday-1) * 86400
end

_Urwigo.Date_SecondInMonth = function(t)
	return t.sec + t.min * 60 + t.hour * 3600 + (t.day-1) * 86400
end

_Urwigo.Date_SecondInYear = function(t)
	return t.sec + t.min * 60 + t.hour * 3600 + (_Urwigo.Date_DayInYear(t)-1) * 86400
end


-- Media --
_SxkFp = Wherigo.ZMedia(_CqAeZ)
_SxkFp.Id = "ed9c6843-8903-4a01-884c-196d5385f080"
_SxkFp.Name = _JWJ("\065\123")
_SxkFp.Description = ""
_SxkFp.AltText = ""
_SxkFp.Resources = {
	{
		Type = "jpg", 
		Filename = "Go.jpg", 
		Directives = {}
	}
}
_lKGU = Wherigo.ZMedia(_CqAeZ)
_lKGU.Id = "a83e93e5-e684-419d-ad65-b8fe164ee3dc"
_lKGU.Name = _JWJ("\092\060\068\060\068\111\060\106")
_lKGU.Description = ""
_lKGU.AltText = ""
_lKGU.Resources = {
	{
		Type = "jpg", 
		Filename = "PeopleRemember.jpg", 
		Directives = {}
	}
}
_L96O = Wherigo.ZMedia(_CqAeZ)
_L96O.Id = "81be3a9e-a967-49bc-b47b-790dd2af7309"
_L96O.Name = _JWJ("\065\123\082\073\017\123\110")
_L96O.Description = ""
_L96O.AltText = ""
_L96O.Resources = {
	{
		Type = "jpg", 
		Filename = "PeopleGo1.jpg", 
		Directives = {}
	}
}
_Nw91 = Wherigo.ZMedia(_CqAeZ)
_Nw91.Id = "36c2c284-a956-48d1-b133-79c42a8fe572"
_Nw91.Name = _JWJ("\059\093\060\098\020\050\123\042")
_Nw91.Description = ""
_Nw91.AltText = ""
_Nw91.Resources = {
	{
		Type = "jpg", 
		Filename = "PeopleQuestion.jpg", 
		Directives = {}
	}
}
_DKm = Wherigo.ZMedia(_CqAeZ)
_DKm.Id = "27fb494c-8c8e-40c4-affc-fe1732d3ef54"
_DKm.Name = _JWJ("\085\043\127\017\036\082\027\123\127\106\083")
_DKm.Description = ""
_DKm.AltText = ""
_DKm.Resources = {
	{
		Type = "jpg", 
		Filename = "PeopleQuestion_b.jpg", 
		Directives = {}
	}
}
_Ovl = Wherigo.ZMedia(_CqAeZ)
_Ovl.Id = "3c834363-9300-4beb-b11a-136a55d7ad97"
_Ovl.Name = _JWJ("\073\127\026\082\034\043\127\020")
_Ovl.Description = ""
_Ovl.AltText = ""
_Ovl.Resources = {
	{
		Type = "jpg", 
		Filename = "PeopleWrong.jpg", 
		Directives = {}
	}
}
_UDf0N = Wherigo.ZMedia(_CqAeZ)
_UDf0N.Id = "33ef37bd-43f0-4acc-b9ee-2e1b314c9dc6"
_UDf0N.Name = _JWJ("\107\043\127\020\082\127\050\042\013\020\082\106\050\051\043\020")
_UDf0N.Description = ""
_UDf0N.AltText = ""
_UDf0N.Resources = {
	{
		Type = "jpg", 
		Filename = "PeopleStop.jpg", 
		Directives = {}
	}
}
_1bKt = Wherigo.ZMedia(_CqAeZ)
_1bKt.Id = "e60486c5-7801-4772-907c-6ee8e070ccdb"
_1bKt.Name = _JWJ("\085\123\123\106\083\050\042\127\020\060\082\097\093\068\111\060\106")
_1bKt.Description = ""
_1bKt.AltText = ""
_1bKt.Resources = {
	{
		Type = "jpg", 
		Filename = "Keyicoon.jpg", 
		Directives = {}
	}
}
_xm7 = Wherigo.ZMedia(_CqAeZ)
_xm7.Id = "64b69a1c-e767-4eaf-b9b2-be48166001ea"
_xm7.Name = _JWJ("\080\080\080\080\080")
_xm7.Description = ""
_xm7.AltText = ""
_xm7.Resources = {
	{
		Type = "jpg", 
		Filename = "Question.jpg", 
		Directives = {}
	}
}
_XD3g = Wherigo.ZMedia(_CqAeZ)
_XD3g.Id = "082406ac-acff-4c71-817b-6e6825624c25"
_XD3g.Name = _JWJ("\073\050\051\042\127\017")
_XD3g.Description = ""
_XD3g.AltText = ""
_XD3g.Resources = {
	{
		Type = "gif", 
		Filename = "signalstanding.gif", 
		Directives = {}
	}
}
_KOUV = Wherigo.ZMedia(_CqAeZ)
_KOUV.Id = "9a56784c-cc63-471b-970d-0e13d62be3ee"
_KOUV.Name = _JWJ("\027\127\025\123\123\036\127")
_KOUV.Description = ""
_KOUV.AltText = ""
_KOUV.Resources = {
	{
		Type = "jpg", 
		Filename = "Bazooka.jpg", 
		Directives = {}
	}
}
_GoX = Wherigo.ZMedia(_CqAeZ)
_GoX.Id = "7f94ecb2-b18d-440a-9530-ba5b312b8cb8"
_GoX.Name = _JWJ("\034\050\042\083\082\065\127\113")
_GoX.Description = ""
_GoX.AltText = ""
_GoX.Resources = {
	{
		Type = "JPG", 
		Filename = "001_1.JPG", 
		Directives = {}
	}
}
_vMta5 = Wherigo.ZMedia(_CqAeZ)
_vMta5.Id = "16ef1363-7ba9-4a8e-9fff-c05bc5780728"
_vMta5.Name = _JWJ("\087\127\106\036")
_vMta5.Description = ""
_vMta5.AltText = ""
_vMta5.Resources = {
	{
		Type = "JPG", 
		Filename = "008.JPG", 
		Directives = {}
	}
}
_qINuE = Wherigo.ZMedia(_CqAeZ)
_qINuE.Id = "8c96341b-73b7-4cf2-b328-b11ec46e83f9"
_qINuE.Name = _JWJ("\053\050\098\098\050\123\042\082\062\106\083\060\106\098")
_qINuE.Description = ""
_qINuE.AltText = ""
_qINuE.Resources = {
	{
		Type = "JPG", 
		Filename = "002_1.JPG", 
		Directives = {}
	}
}
-- Cartridge Info --
_CqAeZ.Id="7da658f8-767b-420d-b31d-0c37a33db0ab"
_CqAeZ.Name="Wind Gap Area 11-11-11 Tour"
_CqAeZ.Description=[[This "Wherigo" cartridge is designed to bring you to some of the memorials and the historic marker in Wind Gap, Pa. It is my first town tour in our area, if well received there will be more to follow. Unless you really want to walk the whole town I would suggest driving from zone to zone.  At each zone you will need to answer questions in order to unlock the next zone. There is nothing to hard but you may want to bring along some paper and something to do some simple math. Please be sure to park in a legal and safe spot and as with all urban caches be aware of traffic and your surroundings! This cartridge is related to geocache # GC27G2P and will lead you to a small size container in the woods that can hold small trade items.]]
_CqAeZ.Visible=true
_CqAeZ.Activity="Geocache"
_CqAeZ.StartingLocationDescription=[[]]
_CqAeZ.StartingLocation = ZonePoint(40.8499267118019,-75.291630456845,0)
_CqAeZ.Version=".9"
_CqAeZ.Company=""
_CqAeZ.Author="agility3d"
_CqAeZ.BuilderVersion="URWIGO 1.12.4281.38707"
_CqAeZ.CreateDate="09/19/2011 22:58:27"
_CqAeZ.PublishDate="1/1/0001 12:00:00 AM"
_CqAeZ.UpdateDate="11/14/2011 09:27:00"
_CqAeZ.LastPlayedDate="1/1/0001 12:00:00 AM"
_CqAeZ.TargetDevice="PocketPC"
_CqAeZ.TargetDeviceVersion="0"
_CqAeZ.StateId="1"
_CqAeZ.CountryId="2"
_CqAeZ.Complete=false
_CqAeZ.UseLogging=true

_CqAeZ.Media=_GoX


-- Zones --
_DccZC = Wherigo.Zone(_CqAeZ)
_DccZC.Id = "3c9785bc-0c39-45a7-9ea3-c477f3a28628"
_DccZC.Name = _JWJ("\022\123\042\060\082\086")
_DccZC.Description = _JWJ("\034\050\042\083\082\065\127\113\082\057\123\110\042\020\123\110\042\082\073\050\051\042\124\027\092\108")
_DccZC.Visible = false
_DccZC.Media = _SxkFp
_DccZC.Commands = {}
_DccZC.DistanceRange = Distance(-1, "feet")
_DccZC.ShowObjects = "OnEnter"
_DccZC.ProximityRange = Distance(60, "meters")
_DccZC.AllowSetPositionTo = false
_DccZC.Active = false
_DccZC.Points = {
	ZonePoint(40.850013446836, -75.2915359089772, 0), 
	ZonePoint(40.8500296779407, -75.2916539261738, 0), 
	ZonePoint(40.8498602655895, -75.2916901359955, 0), 
	ZonePoint(40.849849106677, -75.2915707776943, 0)
}
_DccZC.OriginalPoint = ZonePoint(40.8499381242608, -75.2916126872102, 0)
_DccZC.DistanceRangeUOM = "Feet"
_DccZC.ProximityRangeUOM = "Meters"
_DccZC.OutOfRangeName = ""
_DccZC.InRangeName = ""
_Hdz = Wherigo.Zone(_CqAeZ)
_Hdz.Id = "c7a36d17-0540-4aec-b351-cb2eb625f71e"
_Hdz.Name = _JWJ("\022\123\042\060\082\078")
_Hdz.Description = _JWJ("\085\050\106\012\017\060\082\034\123\106\017\083\082\034\127\106\082\053\060\068\123\106\127\050\017\124\027\092\108")
_Hdz.Visible = false
_Hdz.Media = _KOUV
_Hdz.Commands = {}
_Hdz.DistanceRange = Distance(-1, "feet")
_Hdz.ShowObjects = "OnEnter"
_Hdz.ProximityRange = Distance(60, "meters")
_Hdz.AllowSetPositionTo = false
_Hdz.Active = false
_Hdz.Points = {
	ZonePoint(40.8498085287976, -75.2902471075455, 0), 
	ZonePoint(40.8497699797889, -75.2899359712998, 0), 
	ZonePoint(40.8495995523232, -75.2900673995415, 0), 
	ZonePoint(40.8496178124298, -75.2902216265599, 0)
}
_Hdz.OriginalPoint = ZonePoint(40.8496989683349, -75.2901180262367, 0)
_Hdz.DistanceRangeUOM = "Feet"
_Hdz.ProximityRangeUOM = "Meters"
_Hdz.OutOfRangeName = ""
_Hdz.InRangeName = ""
_WoZgg = Wherigo.Zone(_CqAeZ)
_WoZgg.Id = "1f6e7bc8-f9bb-48c6-beb8-daf400ea05c3"
_WoZgg.Name = _JWJ("\022\123\042\060\082\005")
_WoZgg.Description = _JWJ("\073\093\017\017\050\054\127\042\013\098\082\053\127\106\012\043\082\024\042\083\050\127\042\082\024\042\031\123\124\027\092\108")
_WoZgg.Visible = false
_WoZgg.Media = _L96O
_WoZgg.Commands = {}
_WoZgg.DistanceRange = Distance(-1, "feet")
_WoZgg.ShowObjects = "OnEnter"
_WoZgg.ProximityRange = Distance(60, "meters")
_WoZgg.AllowSetPositionTo = false
_WoZgg.Active = false
_WoZgg.Points = {
	ZonePoint(40.8389738531468, -75.2963779668013, 0), 
	ZonePoint(40.8391706878084, -75.2962438563505, 0), 
	ZonePoint(40.8392325789988, -75.2964155177275, 0), 
	ZonePoint(40.839025598398, -75.2965388993422, 0)
}
_WoZgg.OriginalPoint = ZonePoint(40.839100679588, -75.2963940600554, 0)
_WoZgg.DistanceRangeUOM = "Feet"
_WoZgg.ProximityRangeUOM = "Meters"
_WoZgg.OutOfRangeName = ""
_WoZgg.InRangeName = ""
_u4hlc = Wherigo.Zone(_CqAeZ)
_u4hlc.Id = "626b6dd4-58fa-4028-bdc6-6bf44958388b"
_u4hlc.Name = _JWJ("\022\123\042\060\082\120")
_u4hlc.Description = _JWJ("\034\050\042\083\082\065\127\113\082\087\127\106\036\124\027\092\108")
_u4hlc.Visible = false
_u4hlc.Media = _1bKt
_u4hlc.Commands = {}
_u4hlc.DistanceRange = Distance(-1, "feet")
_u4hlc.ShowObjects = "OnEnter"
_u4hlc.ProximityRange = Distance(60, "meters")
_u4hlc.AllowSetPositionTo = false
_u4hlc.Active = false
_u4hlc.Points = {
	ZonePoint(40.8407154137659, -75.2922601054112, 0), 
	ZonePoint(40.8405977216266, -75.2919516513744, 0), 
	ZonePoint(40.8403846577395, -75.2920629630486, 0), 
	ZonePoint(40.8404942335384, -75.2924022624889, 0)
}
_u4hlc.OriginalPoint = ZonePoint(40.8405480066676, -75.2921692455808, 0)
_u4hlc.DistanceRangeUOM = "Feet"
_u4hlc.ProximityRangeUOM = "Meters"
_u4hlc.OutOfRangeName = ""
_u4hlc.InRangeName = ""
_oS1 = Wherigo.Zone(_CqAeZ)
_oS1.Id = "d8737546-687e-4eb9-97cb-2d8712e82fc7"
_oS1.Name = _JWJ("\022\123\042\060\082\076")
_oS1.Description = _JWJ("\034\127\106\082\053\060\068\123\106\127\050\017\082\127\020\082\035\028\034\124\027\092\108")
_oS1.Visible = false
_oS1.Media = _XD3g
_oS1.Commands = {}
_oS1.DistanceRange = Distance(-1, "feet")
_oS1.ShowObjects = "OnEnter"
_oS1.ProximityRange = Distance(60, "meters")
_oS1.AllowSetPositionTo = false
_oS1.Active = false
_oS1.Points = {
	ZonePoint(40.8520417969067, -75.2914815942445, 0), 
	ZonePoint(40.852049912211, -75.2913246850172, 0), 
	ZonePoint(40.8519180383912, -75.2913206617037, 0), 
	ZonePoint(40.8519109374858, -75.2914748887221, 0)
}
_oS1.OriginalPoint = ZonePoint(40.8519801712487, -75.2914004574219, 0)
_oS1.DistanceRangeUOM = "Feet"
_oS1.ProximityRangeUOM = "Meters"
_oS1.OutOfRangeName = ""
_oS1.InRangeName = ""
_tkqp = Wherigo.Zone(_CqAeZ)
_tkqp.Id = "f70c5a9e-b0cf-4ece-9eef-1302a448f8f4"
_tkqp.Name = _JWJ("\022\123\042\060\082\096")
_tkqp.Description = _JWJ("\085\043\093\106\012\043\082\053\060\068\123\106\050\127\017\124\027\092\108")
_tkqp.Visible = false
_tkqp.Media = _lKGU
_tkqp.Commands = {}
_tkqp.DistanceRange = Distance(-1, "feet")
_tkqp.ShowObjects = "OnEnter"
_tkqp.ProximityRange = Distance(60, "meters")
_tkqp.AllowSetPositionTo = false
_tkqp.Active = false
_tkqp.Points = {
	ZonePoint(40.8281984046913, -75.2780926375941, 0), 
	ZonePoint(40.8280898233478, -75.277780160244, 0), 
	ZonePoint(40.8278249653062, -75.2779893725472, 0), 
	ZonePoint(40.8278706305613, -75.2783756106453, 0)
}
_tkqp.OriginalPoint = ZonePoint(40.8279959559767, -75.2780594452577, 0)
_tkqp.DistanceRangeUOM = "Feet"
_tkqp.ProximityRangeUOM = "Meters"
_tkqp.OutOfRangeName = ""
_tkqp.InRangeName = ""

-- Characters --

-- Items --
_IMIhL = Wherigo.ZItem(_CqAeZ)
_IMIhL.Id = "9a32b938-bbd7-46f5-a1af-34c5a2eb319e"
_IMIhL.Name = _JWJ("\085\123\068\113\017\060\020\050\123\042\082\085\123\083\060")
_IMIhL.Description = _JWJ("\087\017\060\127\098\060\082\110\106\050\020\060\082\083\123\110\042\082\020\043\060\082\012\123\068\113\017\060\020\050\123\042\082\012\123\083\060\082\050\042\082\123\106\083\060\106\082\020\123\082\017\123\051\082\020\043\050\098\082\012\127\106\020\106\050\083\051\060\082\127\098\082\012\123\068\113\017\060\020\060\083\082\123\042\082\020\043\060\082\110\043\060\106\050\051\123\082\098\050\020\060\008\124\027\092\108")
_IMIhL.Visible = true
_IMIhL.Media = _1bKt
_IMIhL.Commands = {
	_8OESU = Wherigo.ZCommand{
		Text = _JWJ("\073\043\123\110\082\085\123\083\060"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _JWJ("\097\123\020\043\050\042\051\082\127\054\127\050\017\127\111\017\060")
	}, 
	_P2el = Wherigo.ZCommand{
		Text = _JWJ("\071\098\060\106\042\127\068\060"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _JWJ("\097\123\020\043\050\042\051\082\127\054\127\050\017\127\111\017\060")
	}
}
_IMIhL.Commands._8OESU.Custom = true
_IMIhL.Commands._8OESU.Id = "d70de248-f122-4e75-ae5e-ab5b1051832d"
_IMIhL.Commands._8OESU.WorksWithAll = true
_IMIhL.Commands._P2el.Custom = true
_IMIhL.Commands._P2el.Id = "e21dc344-0338-4fe5-8a29-2bc629f7d507"
_IMIhL.Commands._P2el.WorksWithAll = true
_IMIhL.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_IMIhL.Locked = false
_IMIhL.Opened = false
_QHnVm = Wherigo.ZItem(_CqAeZ)
_QHnVm.Id = "cf4883b3-c173-4873-b1ec-c8b169151095"
_QHnVm.Name = _JWJ("\028\050\042\127\017\082\053\050\098\098\050\123\042\082\062\106\083\060\106\098")
_QHnVm.Description = _JWJ("\115\123\093\106\082\031\050\042\127\017\082\068\050\098\098\050\123\042\082\083\060\020\127\050\017\098\082\031\123\106\082\020\043\060\082\113\043\026\098\050\012\127\017\082\012\127\012\043\060\082\127\042\083\082\020\043\060\082\012\123\068\113\017\060\020\050\123\042\082\123\031\082\020\043\050\098\082\127\098\098\050\051\042\068\060\042\020\008")
_QHnVm.Visible = true
_QHnVm.Media = _qINuE
_QHnVm.Commands = {
	_WzZ = Wherigo.ZCommand{
		Text = _JWJ("\087\050\012\036\082\071\113\082\053\050\098\098\050\123\042\082\062\106\083\060\106\098"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _JWJ("\097\123\020\043\050\042\051\082\127\054\127\050\017\127\111\017\060")
	}, 
	__fTx = Wherigo.ZCommand{
		Text = _JWJ("\092\060\127\083\082\053\050\098\098\050\123\042\082\062\106\083\060\106\098"), 
		CmdWith = false, 
		Enabled = false, 
		EmptyTargetListText = _JWJ("\097\123\020\043\050\042\051\082\127\054\127\050\017\127\111\017\060")
	}, 
	_j1oMr = Wherigo.ZCommand{
		Text = _JWJ("\053\050\098\098\123\042\082\062\106\083\060\106\098\082\007\050\042\020"), 
		CmdWith = false, 
		Enabled = false, 
		EmptyTargetListText = _JWJ("\097\123\020\043\050\042\051\082\127\054\127\050\017\127\111\017\060")
	}
}
_QHnVm.Commands._WzZ.Custom = true
_QHnVm.Commands._WzZ.Id = "d6bb51d7-36cb-4eb1-88f1-607a2a5246c3"
_QHnVm.Commands._WzZ.WorksWithAll = true
_QHnVm.Commands.__fTx.Custom = true
_QHnVm.Commands.__fTx.Id = "7842fe69-a6fa-4188-b678-8850f091528e"
_QHnVm.Commands.__fTx.WorksWithAll = true
_QHnVm.Commands._j1oMr.Custom = true
_QHnVm.Commands._j1oMr.Id = "5a87b087-918f-41c5-b91f-ef4271a3c3ca"
_QHnVm.Commands._j1oMr.WorksWithAll = true
_QHnVm.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_QHnVm.Locked = false
_QHnVm.Opened = false

-- Tasks --

-- Cartridge Variables --
_FbxoO = ""
_CqAeZ.ZVariables = {
	_FbxoO = ""
}

-- Timers --
_fS7 = Wherigo.ZTimer(_CqAeZ)
_fS7.Id = "73f2bc8d-b366-49b5-ad90-370e1a68268c"
_fS7.Name = _JWJ("\097\127\068\060")
_fS7.Description = ""
_fS7.Visible = true
_fS7.Duration = 60.0011055036453
_fS7.Type = "Countdown"

-- Inputs --
_sFK2 = Wherigo.ZInput(_CqAeZ)
_sFK2.Id = "f24690e5-1383-4e4a-bbaa-0d1994456d28"
_sFK2.Name = _JWJ("\025\123\042\060\082\086\082\030\093\060\098\020\050\123\042\082\086")
_sFK2.Description = ""
_sFK2.Visible = true
_sFK2.Media = _Nw91
_sFK2.Choices = {
	"1867", 
	"1872", 
	"1884", 
	"1893"
}
_sFK2.InputType = "MultipleChoice"
_sFK2.Text = _JWJ("\034\043\127\020\082\026\060\127\106\082\110\127\098\082\034\050\042\083\082\065\127\113\082\060\098\020\127\111\017\050\098\043\060\083\080")
_lGETc = Wherigo.ZInput(_CqAeZ)
_lGETc.Id = "751fcfab-448e-4e4f-9168-b8ca6d017550"
_lGETc.Name = _JWJ("\025\123\042\060\082\086\082\030\093\060\098\020\050\123\042\082\078")
_lGETc.Description = ""
_lGETc.Visible = true
_lGETc.Media = _DKm
_lGETc.InputType = "Text"
_lGETc.Text = _JWJ("\027\093\098\050\042\060\098\098\060\098\082\110\050\020\043\082\106\050\051\043\020\082\127\106\106\123\110\098\044\082\027\093\098\050\042\060\098\098\060\098\082\110\050\020\043\082\017\060\031\020\082\127\106\106\123\110\098\044\082\027\093\098\050\042\060\098\098\060\098\082\110\050\020\043\082\106\050\051\043\020\082\127\106\106\123\110\082\068\050\042\093\098\082\111\093\098\050\042\060\098\098\060\098\082\110\050\020\043\082\029\042\111\098\113\084\042\123\082\127\106\106\123\110\098\112")
_vtW = Wherigo.ZInput(_CqAeZ)
_vtW.Id = "fd2808b0-d56d-4671-a697-45c1cb798af1"
_vtW.Name = _JWJ("\025\123\042\060\082\078\082\030\093\060\098\020\050\123\042\082\086")
_vtW.Description = ""
_vtW.Visible = true
_vtW.Media = _XD3g
_vtW.Choices = {
	"For those who serve", 
	"Made supreme sacrifice", 
	"In loving memory", 
	"We will never forget"
}
_vtW.InputType = "MultipleChoice"
_vtW.Text = _JWJ("\034\043\127\020\082\050\098\082\110\106\050\020\020\060\042\082\127\017\123\042\051\082\020\043\060\082\031\106\123\042\020\082\060\083\051\060\082\123\031\082\020\043\060\082\111\060\042\012\043\080")
_Xw8IV = Wherigo.ZInput(_CqAeZ)
_Xw8IV.Id = "60f3f5d1-a51a-4b0c-8b96-de1b03525409"
_Xw8IV.Name = _JWJ("\025\123\042\060\082\005\082\030\093\060\098\020\050\123\042\082\086")
_Xw8IV.Description = ""
_Xw8IV.Visible = true
_Xw8IV.Media = _xm7
_Xw8IV.Choices = {
	"Phillipsburg", 
	"Easton", 
	"Allentown", 
	"Hellertown"
}
_Xw8IV.InputType = "MultipleChoice"
_Xw8IV.Text = _JWJ("\034\043\060\106\060\082\083\050\083\082\073\093\017\017\050\054\127\042\013\098\082\127\106\068\026\082\068\127\106\012\043\082\031\106\123\068\082\123\042\082\037\093\042\060\082\086\069\082\086\046\046\074\080")
_8zZ = Wherigo.ZInput(_CqAeZ)
_8zZ.Id = "1a3e3b17-9a8e-45f4-bbf5-3dbf670e2d85"
_8zZ.Name = _JWJ("\025\123\042\060\082\005\082\030\093\060\098\020\050\123\042\082\078")
_8zZ.Description = ""
_8zZ.Visible = true
_8zZ.Media = _Nw91
_8zZ.Choices = {
	"3", 
	"8", 
	"12", 
	"14"
}
_8zZ.InputType = "MultipleChoice"
_8zZ.Text = _JWJ("\007\123\110\082\068\127\042\026\082\068\050\017\060\098\082\083\050\083\082\020\043\060\026\082\020\106\127\054\060\017\082\123\042\082\037\093\042\060\082\086\069\082\086\046\046\074\080")
_D5Xl = Wherigo.ZInput(_CqAeZ)
_D5Xl.Id = "ffa36516-b8fc-4286-89fc-9305c3659ef8"
_D5Xl.Name = _JWJ("\025\123\042\060\082\005\082\030\093\060\098\020\050\123\042\082\005")
_D5Xl.Description = ""
_D5Xl.Visible = true
_D5Xl.Media = _DKm
_D5Xl.Choices = {
	"Local Rebels", 
	"Iroquois Indians", 
	"Apache Indians", 
	"French Army"
}
_D5Xl.InputType = "MultipleChoice"
_D5Xl.Text = _JWJ("\034\043\123\082\110\060\106\060\082\020\043\060\026\082\031\050\051\043\020\050\042\051\082\127\020\082\020\043\060\082\020\050\068\060\080")
_1GJZ = Wherigo.ZInput(_CqAeZ)
_1GJZ.Id = "3e3446f6-58b2-4c0b-aa8e-780b1f375e72"
_1GJZ.Name = _JWJ("\025\123\042\060\082\005\082\030\093\060\098\020\050\123\042\082\096")
_1GJZ.Description = ""
_1GJZ.Visible = true
_1GJZ.Media = _xm7
_1GJZ.Choices = {
	"Fort Muncy", 
	"Fort Wyoming", 
	"Fort Augusta", 
	"Fort Penn"
}
_1GJZ.InputType = "MultipleChoice"
_1GJZ.Text = _JWJ("\003\012\012\123\106\083\050\042\051\082\123\020\082\020\043\060\082\068\127\113\082\110\043\127\020\082\031\123\106\020\082\110\127\098\082\083\093\060\082\110\060\098\020\082\123\031\082\032\127\098\020\123\042\080")
_6pEo = Wherigo.ZInput(_CqAeZ)
_6pEo.Id = "fe4c794a-b937-4d5a-9dbe-0e043441fd8c"
_6pEo.Name = _JWJ("\025\123\042\060\082\005\082\030\093\060\098\020\050\123\042\082\120")
_6pEo.Description = ""
_6pEo.Visible = true
_6pEo.Media = _Nw91
_6pEo.Choices = {
	"Bulluck farm", 
	"Heller's Tavern", 
	"Lephed's Tavern", 
	"Vanderlip Farm"
}
_6pEo.InputType = "MultipleChoice"
_6pEo.Text = _JWJ("\034\043\127\020\082\110\127\098\082\020\043\060\082\042\127\068\060\082\123\031\082\020\043\060\082\113\017\127\012\060\082\020\043\060\026\082\029\042\111\098\113\084\098\020\127\026\060\083\080")
_n4ehU = Wherigo.ZInput(_CqAeZ)
_n4ehU.Id = "9f7fdfb0-7ace-41d0-a1d1-ac13b8107521"
_n4ehU.Name = _JWJ("\022\123\042\060\082\120\082\059\093\060\098\020\050\123\042\082\086")
_n4ehU.Description = _JWJ("\107\043\060\082\127\042\098\110\060\106\082\020\123\082\020\043\050\098\082\030\093\060\098\020\050\123\042\082\060\030\093\127\017\098\082\022\082\050\042\082\020\043\060\082\012\123\123\106\083\050\042\127\020\060\098\112\124\027\092\108")
_n4ehU.Visible = true
_n4ehU.Media = _XD3g
_n4ehU.Choices = {
	"1", 
	"3", 
	"5", 
	"7"
}
_n4ehU.InputType = "MultipleChoice"
_n4ehU.Text = _JWJ("\034\043\127\020\082\050\098\082\020\043\060\082\042\093\068\111\060\106\082\054\127\017\093\060\082\123\031\082\020\043\060\082\050\020\060\068\082\060\068\111\060\083\060\083\082\050\042\082\020\043\060\082\012\123\042\060\106\098\082\123\031\082\020\043\060\082\012\123\042\012\106\060\020\060\082\127\106\123\093\042\083\082\020\043\060\082\110\127\017\017\080")
_sGrTQ = Wherigo.ZInput(_CqAeZ)
_sGrTQ.Id = "0b39c518-2012-4273-a83d-f2d4e55d83ee"
_sGrTQ.Name = _JWJ("\022\123\042\060\082\120\082\059\093\060\098\020\050\123\042\082\078")
_sGrTQ.Description = _JWJ("\003\042\098\110\060\106\082\015\082\028\065")
_sGrTQ.Visible = true
_sGrTQ.Media = _DKm
_sGrTQ.Choices = {
	"11", 
	"15", 
	"17", 
	"19"
}
_sGrTQ.InputType = "MultipleChoice"
_sGrTQ.Text = _JWJ("\003\083\083\082\093\113\082\020\043\060\082\127\017\017\082\020\043\060\082\050\042\083\050\054\050\083\093\127\017\082\042\093\068\111\060\106\098\082\050\042\082\020\043\060\082\057\062\027\082\123\031\082\092\003\082\053\012\053\093\017\017\060\042\082\024\035\112")
_Q4jv = Wherigo.ZInput(_CqAeZ)
_Q4jv.Id = "fd9d59e9-86be-4713-808b-63d484e71dad"
_Q4jv.Name = _JWJ("\022\123\042\060\082\120\082\059\093\060\098\020\050\123\042\082\005")
_Q4jv.Description = _JWJ("\035\127\017\093\060\082\123\031\082\003\027\112\124\027\092\108")
_Q4jv.Visible = true
_Q4jv.Media = _xm7
_Q4jv.Choices = {
	"28", 
	"38", 
	"40", 
	"46"
}
_Q4jv.InputType = "MultipleChoice"
_Q4jv.Text = _JWJ("\107\050\042\026\082\027\106\123\123\036\082\028\127\106\068\082\017\127\106\051\060\106\082\042\093\068\111\060\106\082\068\050\042\093\098\082\020\043\060\082\098\068\127\017\017\060\106\082\042\093\068\111\060\106\082\113\017\093\098\082\020\043\060\082\054\127\017\093\060\082\123\031\082\122\022\122\082\020\043\127\020\082\026\123\093\082\043\127\054\060\082\127\017\106\060\127\083\026\082\031\123\093\042\083\080")
_Vos = Wherigo.ZInput(_CqAeZ)
_Vos.Id = "744d350e-4411-465d-a0a4-a114b6337f22"
_Vos.Name = _JWJ("\022\123\042\060\082\120\082\059\093\060\098\020\050\123\042\082\096")
_Vos.Description = _JWJ("\120\086\124\027\092\108\065\050\054\060\098\082\026\123\093\082\085\057\124\027\092\108")
_Vos.Visible = true
_Vos.Media = _DKm
_Vos.Choices = {
	"41", 
	"51", 
	"62", 
	"68"
}
_Vos.InputType = "MultipleChoice"
_Vos.Text = _JWJ("\107\043\060\082\127\051\060\082\123\031\082\034\050\042\083\082\065\127\113\082\050\042\082\020\043\060\082\026\060\127\106\082\123\042\082\020\043\060\082\106\050\051\043\020\082\098\050\083\060\082\123\031\082\034\024\042\083\082\065\127\113\082\123\042\082\020\043\060\082\031\106\123\042\020\082\123\031\082\110\127\017\017\082\068\050\042\093\098\082\020\043\060\082\127\051\060\082\123\031\082\003\093\042\020\082\029\042\111\098\113\084\037\060\127\042\042\050\060\082\034\127\017\020\060\106\098\082\050\042\082\086\074\096\120\008\082")
_Ttn = Wherigo.ZInput(_CqAeZ)
_Ttn.Id = "f5e373b9-8526-4665-b41a-eec09ab4eb3e"
_Ttn.Name = _JWJ("\022\123\042\060\082\120\082\059\093\060\098\020\050\123\042\082\120")
_Ttn.Description = _JWJ("\041\082\015\082\073")
_Ttn.Visible = true
_Ttn.Media = _xm7
_Ttn.Choices = {
	"0", 
	"38", 
	"75", 
	"128"
}
_Ttn.InputType = "MultipleChoice"
_Ttn.Text = _JWJ("\097\093\068\111\060\106\098\082\123\042\082\020\043\060\082\111\106\050\012\036\082\020\043\106\060\060\082\020\123\082\020\043\060\082\017\060\031\020\082\123\031\082\028\017\123\026\083\082\085\127\060\098\060\106\082\068\050\042\093\098\082\020\043\060\082\042\093\068\111\060\106\098\082\123\042\082\020\043\060\082\027\106\123\127\083\110\127\026\082\057\050\042\060\106\082\111\106\050\012\036\080")
_KWE = Wherigo.ZInput(_CqAeZ)
_KWE.Id = "58420e66-e60a-4f7b-800e-00837172c89e"
_KWE.Name = _JWJ("\022\123\042\060\082\120\082\059\093\060\098\020\050\123\042\082\076")
_KWE.Description = ""
_KWE.Visible = true
_KWE.Media = _DKm
_KWE.Choices = {
	"351", 
	"487", 
	"696", 
	"751"
}
_KWE.InputType = "MultipleChoice"
_KWE.Text = _JWJ("\028\106\123\068\082\020\043\060\082\003\106\106\093\017\017\050\127\082\040\127\068\111\060\106\020\082\111\106\050\012\036\082\083\050\054\050\083\060\082\020\043\060\082\057\127\026\082\042\093\068\111\060\106\082\111\026\082\086\041\008\082\027\060\082\012\127\106\060\031\093\017\082\043\060\106\060\082\026\123\093\082\110\050\017\017\082\042\123\110\082\111\060\082\017\123\123\036\050\042\051\082\127\020\082\123\020\043\060\106\082\111\106\050\012\036\098\112\082\029\042\111\098\113\084\053\093\017\020\050\113\017\060\082\020\043\127\020\082\111\026\082\020\043\060\082\068\123\042\020\043\082\123\042\082\020\043\060\082\057\127\017\060\082\007\123\093\012\036\082\111\106\050\012\036\008\082\003\083\083\082\020\043\060\082\127\042\098\110\060\106\082\020\123\082\020\043\060\082\113\123\098\020\082\042\093\068\111\060\106\082\123\042\082\020\043\060\082\034\050\042\083\082\065\127\113\082\003\068\060\106\050\012\127\042\082\040\060\051\050\123\042\082\111\106\050\012\036\082\020\123\082\051\060\020\082\020\043\050\098\082\020\043\106\060\060\082\083\050\051\050\020\082\042\093\068\111\060\106\112\082")
_YI4 = Wherigo.ZInput(_CqAeZ)
_YI4.Id = "9241cc73-c50c-4f65-b47d-19f20fb498cd"
_YI4.Name = _JWJ("\022\123\042\060\082\120\082\059\093\060\098\020\050\123\042\082\046")
_YI4.Description = ""
_YI4.Visible = true
_YI4.Media = _Nw91
_YI4.Choices = {
	"2", 
	"5", 
	"7", 
	"9"
}
_YI4.InputType = "MultipleChoice"
_YI4.Text = _JWJ("\003\083\083\082\020\043\060\082\020\110\123\082\026\060\127\106\082\042\093\068\111\060\106\098\082\123\042\082\107\123\068\082\027\106\123\110\042\013\098\082\111\050\106\012\036\008\082\003\083\083\082\020\043\060\082\042\093\068\111\060\106\098\082\123\031\082\003\017\082\085\127\017\127\111\106\060\098\060\013\098\082\071\073\097\082\003\053\045\008\082\073\093\111\098\020\106\127\012\020\082\020\043\060\082\098\060\012\123\042\083\082\031\106\123\068\082\020\043\060\082\031\050\106\098\020\008")
_OIC4r = Wherigo.ZInput(_CqAeZ)
_OIC4r.Id = "1fb5bd9e-f532-4100-ad52-2ab30dea4077"
_OIC4r.Name = _JWJ("\022\123\042\060\082\120\082\059\093\060\098\020\050\123\042\082\069")
_OIC4r.Description = ""
_OIC4r.Visible = true
_OIC4r.Media = _DKm
_OIC4r.Choices = {
	"1", 
	"2", 
	"3", 
	"4"
}
_OIC4r.InputType = "MultipleChoice"
_OIC4r.Text = _JWJ("\097\123\082\068\127\020\043\082\031\123\106\082\020\043\050\098\082\123\042\060\112\082\034\043\127\020\082\050\098\082\020\043\060\082\042\093\068\111\060\106\082\123\031\082\020\043\060\082\040\123\123\036\123\093\020\082\028\050\106\060\082\085\123\068\113\127\042\026\082\050\042\082\087\060\042\082\003\106\051\026\017\080")
_Uky = Wherigo.ZInput(_CqAeZ)
_Uky.Id = "eb7cb675-25f8-441f-8b50-f753c7b9d95c"
_Uky.Name = _JWJ("\022\123\042\060\082\120\082\059\093\060\098\020\050\123\042\082\074")
_Uky.Description = ""
_Uky.Visible = true
_Uky.Media = _xm7
_Uky.Choices = {
	"23", 
	"37", 
	"48", 
	"56"
}
_Uky.InputType = "MultipleChoice"
_Uky.Text = _JWJ("\115\123\093\082\043\127\054\060\082\110\123\106\036\060\083\082\054\060\106\026\082\043\127\106\083\082\043\060\106\060\082\098\123\082\020\043\050\098\082\029\042\111\098\113\084\123\042\060\082\110\050\017\017\082\111\060\082\127\017\068\123\098\020\082\127\098\082\060\127\098\026\082\127\098\082\020\043\060\082\017\127\098\020\008\082\107\043\060\082\068\123\020\043\060\106\098\082\123\031\082\110\043\127\020\082\107\106\123\123\113\082\045\082\043\127\054\060\082\127\082\111\106\050\012\036\082\043\060\106\060\080")
_D2A2 = Wherigo.ZInput(_CqAeZ)
_D2A2.Id = "129affcb-e8b0-4df2-b0e3-eeff86062ea8"
_D2A2.Name = _JWJ("\022\123\042\060\082\076\082\028\050\042\127\017\082\059\093\060\098\020\050\123\042")
_D2A2.Description = ""
_D2A2.Visible = true
_D2A2.Choices = {
	"Cold War", 
	"Civil War", 
	"Grenada", 
	"Iraq"
}
_D2A2.InputType = "MultipleChoice"
_D2A2.Text = _JWJ("\107\043\050\098\082\068\060\068\123\106\050\127\017\082\068\060\042\020\050\123\042\098\082\054\060\020\060\106\127\042\098\082\123\031\082\096\082\012\123\042\031\017\050\012\020\098\008\082\107\043\060\026\082\127\106\060\082\035\050\060\020\042\127\068\039\082\016\123\106\060\127\039\082\087\060\106\098\050\127\042\082\065\093\017\031\082\127\042\083\082\110\043\127\020\080")

-- WorksWithList for object commands --

-- functions --
function _CqAeZ:OnStart()
	if (_G[_JWJ("\032\042\054")][_JWJ("\057\060\054\050\012\060\024\057")] == _JWJ("\057\060\098\036\020\123\113")) or (_G[_JWJ("\032\042\054")][_JWJ("\087\017\127\020\031\123\106\068")] == _JWJ("\034\050\042\005\078")) then
		for k, v in pairs(_G[_JWJ("\090\085\030\003\060\022")][_JWJ("\003\017\017\022\062\111\099\060\012\020\098")]) do
			v[_JWJ("\035\050\098\050\111\017\060")] = false
			v[_JWJ("\003\012\020\050\054\060")] = false
		end
		_G[_JWJ("\034\043\060\106\050\051\123")][_JWJ("\085\123\068\068\127\042\083")](_JWJ("\073\127\054\060\085\017\123\098\060"))
		return
	end
	_fS7[_JWJ("\073\020\127\106\020")](_fS7)
	_Urwigo.MessageBox{
		Text = _JWJ("\034\060\017\012\123\068\060\082\020\123\082\020\043\060\082\122\034\050\042\083\082\065\127\113\082\086\086\066\086\086\066\086\086\082\034\043\060\106\050\051\123\082\107\123\093\106\122"), 
		Callback = function(action)
			if action ~= nil then
				_Urwigo.MessageBox{
					Text = _JWJ("\115\123\093\082\110\050\017\017\082\111\060\082\054\050\098\050\020\050\042\051\082\098\060\054\060\106\127\017\082\127\106\060\127\082\068\060\068\123\106\050\127\017\098\082\127\042\083\082\127\082\043\050\098\020\123\106\050\012\082\098\050\020\060\008\082\003\020\082\060\127\012\043\082\017\123\012\127\020\050\123\042\082\026\123\093\082\110\050\017\017\082\111\060\082\106\060\030\093\050\106\060\083\082\020\123\082\127\042\098\110\060\106\082\030\093\060\098\020\050\123\042\082\123\106\082\083\123\082\098\123\068\060\020\043\050\042\051\082\050\042\082\123\106\083\060\106\082\020\123\082\093\042\017\123\012\036\082\020\043\060\082\042\060\018\020\082\025\123\042\060\112"), 
					Callback = function(action)
						if action ~= nil then
							_Urwigo.MessageBox{
								Text = _JWJ("\085\123\068\113\017\060\020\050\042\051\082\020\043\060\082\012\127\106\020\106\050\083\051\060\082\110\050\017\017\082\051\050\054\060\082\026\123\093\082\020\043\060\082\012\123\123\106\083\050\042\127\020\060\098\082\031\123\106\082\020\043\060\082\113\043\026\098\050\012\127\017\082\012\127\012\043\060\082\012\123\042\020\127\050\042\060\106\082\031\123\106\082\065\085\005\046\065\087\078\082\123\031\082\020\043\060\082\098\127\068\060\082\042\127\068\060\112"), 
								Callback = function(action)
									if action ~= nil then
										_DccZC.Active = true
										_DccZC.Visible = true
									end
								end
							}
						end
					end
				}
			end
		end
	}
end
function _CqAeZ:OnRestore()
	_fS7[_JWJ("\073\020\127\106\020")](_fS7)
end
function _DccZC:OnEnter()
	_Urwigo.MessageBox{
		Text = _JWJ("\115\123\093\082\110\050\017\017\082\098\020\127\106\020\082\106\050\051\043\020\082\043\060\106\060\082\127\020\082\020\043\060\082\034\050\042\083\082\065\127\113\082\098\050\051\042\112\082"), 
		Callback = function(action)
			if action ~= nil then
				_Urwigo.MessageBox{
					Text = _JWJ("\073\123\082\017\060\020\013\098\082\051\060\020\082\106\050\051\043\020\082\020\123\082\020\043\060\082\030\093\060\098\020\050\123\042\098\112"), 
					Callback = function(action)
						if action ~= nil then
							_Urwigo.RunDialogs(function()
								Wherigo.GetInput(_sFK2)
							end)
							_CqAeZ:RequestSync()
						end
					end
				}
			end
		end
	}
end
function _Hdz:OnEnter()
	_Urwigo.MessageBox{
		Text = _JWJ("\034\060\017\012\123\068\060\082\020\123\082\020\043\060\082\098\060\012\123\042\083\082\098\020\127\051\060\082\123\031\082\123\093\106\082\051\127\068\060\008\082\107\043\050\098\082\050\098\082\020\043\060\082\034\123\106\017\083\082\034\127\106\082\068\060\068\123\106\050\127\017\008\082"), 
		Callback = function(action)
			if action ~= nil then
				_Urwigo.MessageBox{
					Text = _JWJ("\024\020\082\050\098\082\031\123\106\082\111\123\020\043\082\110\123\106\017\083\082\110\127\106\098\112\082\073\060\060\050\042\051\082\098\123\082\068\127\042\026\082\042\127\068\060\098\082\031\106\123\068\082\127\082\098\068\127\017\017\082\020\123\110\042\082\017\050\036\060\082\034\050\042\083\082\065\127\113\082\106\060\068\050\042\083\098\082\068\060\082\123\031\082\099\093\098\020\082\127\017\017\082\054\127\098\020\082\020\043\123\098\060\082\110\127\106\098\082\110\060\106\060\008\124\027\092\108"), 
					Callback = function(action)
						if action ~= nil then
							_Urwigo.MessageBox{
								Text = _JWJ("\115\123\093\082\110\050\017\017\082\111\060\082\110\123\106\036\050\042\051\082\020\123\082\051\060\020\082\020\043\060\082\031\123\017\017\123\110\050\042\051\082\050\042\031\123\106\068\127\020\050\123\042\112\082\115\062\093\082\068\127\026\082\110\127\042\020\082\020\123\082\110\106\050\020\060\082\020\043\050\098\082\083\123\110\042\082\031\123\106\082\031\093\020\093\106\060\082\093\098\060\008\082\097\082\003\057\082\027\057\008\085\027\085\082\034\082\057\028\027\082\032\028\008\028\065\032"), 
								Callback = function(action)
									if action ~= nil then
										_Urwigo.MessageBox{
											Text = _JWJ("\007\060\106\060\082\050\098\082\026\123\093\106\082\031\050\106\098\020\082\030\093\060\098\020\050\123\042\112"), 
											Callback = function(action)
												if action ~= nil then
													_Urwigo.RunDialogs(function()
														Wherigo.GetInput(_vtW)
													end)
													_CqAeZ:RequestSync()
												end
											end
										}
									end
								end
							}
						end
					end
				}
			end
		end
	}
end
function _WoZgg:OnEnter()
	_WoZgg.Visible = true
	_Urwigo.MessageBox{
		Text = _JWJ("\115\123\093\106\082\127\042\098\110\060\106\082\127\020\082\098\020\127\051\060\082\020\110\123\082\068\093\098\020\082\043\127\054\060\082\111\060\060\042\082\012\123\106\106\060\012\020\039\082\123\106\082\026\123\093\082\068\127\042\127\051\060\083\082\020\123\082\098\020\093\068\111\017\060\082\123\042\082\020\043\050\098\082\111\026\082\098\123\068\060\082\123\020\043\060\106\082\068\060\127\042\098"), 
		Callback = function(action)
			if action ~= nil then
				_Urwigo.MessageBox{
					Text = _JWJ("\007\060\106\060\082\050\098\082\026\123\093\106\082\031\050\106\098\020\082\098\020\127\051\060\082\020\043\106\060\060\082\030\093\060\098\020\050\123\042\112"), 
					Callback = function(action)
						if action ~= nil then
							_Urwigo.RunDialogs(function()
								Wherigo.GetInput(_Xw8IV)
							end)
							_CqAeZ:RequestSync()
						end
					end
				}
			end
		end
	}
end
function _u4hlc:OnEnter()
	_Urwigo.MessageBox{
		Text = _JWJ("\034\060\017\012\123\068\060\082\020\123\082\034\050\042\083\082\065\127\113\082\087\127\106\036\008\082\024\082\036\042\123\110\082\020\043\050\098\082\050\098\082\042\123\020\082\127\082\110\127\106\082\068\060\068\123\106\050\127\017\082\111\093\020\082\050\020\082\050\098\082\127\082\042\050\012\060\082\110\127\017\017\008\082\107\043\060\082\031\050\106\098\020\082\113\093\025\025\017\060\082\012\127\012\043\060\082\024\082\060\054\060\106\082\083\050\083\082\106\060\030\093\050\106\060\083\082\083\123\050\042\083\082\127\082\017\123\020\082\123\031\082\068\127\020\043\082\019\085\123\068\113\017\060\018\001\082\127\042\083\082\020\123\123\036\082\068\060\082\098\060\054\060\106\127\017\082\083\127\026\098\082\020\123\082\051\127\020\043\060\106\082\127\017\017\082\020\043\060\082\050\042\031\123\082\127\042\083\082\083\123\082\020\043\060\082\068\127\020\043\008\082\034\043\060\042\082\024\082\110\098\127\110\082\020\043\050\098\082\110\127\017\017\082\024\082\110\127\042\020\060\083\082\020\123\082\083\123\082\098\123\068\060\020\043\050\042\051\082\098\050\068\050\017\127\106\082\043\060\106\060\008\082"), 
		Callback = function(action)
			if action ~= nil then
				_Urwigo.MessageBox{
					Text = _JWJ("\024\082\113\106\123\068\050\098\060\082\026\123\093\106\082\068\127\020\043\082\110\050\017\017\082\042\123\020\082\111\060\082\020\043\127\020\082\043\127\106\083\082\127\042\083\082\026\123\093\106\082\127\042\098\110\060\106\098\082\110\050\017\017\082\111\060\082\068\093\017\020\050\113\017\060\082\012\043\123\050\012\060\082\098\123\082\060\054\060\042\082\050\031\082\026\123\093\082\098\020\106\093\051\051\017\060\082\110\050\020\043\082\127\042\082\127\042\098\110\060\106\082\026\123\093\082\012\127\042\082\031\050\051\093\106\060\082\050\020\082\123\093\020\082\050\042\082\127\082\031\060\110\082\051\093\060\098\098\060\098\008\082"), 
					Callback = function(action)
						if action ~= nil then
							_Urwigo.MessageBox{
								Text = _JWJ("\107\043\060\082\012\123\123\106\083\050\042\127\020\060\098\082\031\123\106\082\020\043\060\082\042\060\018\020\082\098\020\127\051\060\082\110\050\017\017\082\111\060\082\097\123\106\020\043\082\122\003\027\082\085\057\008\032\028\065\122\082\111\026\082\034\060\098\020\082\122\073\107\071\082\035\034\008\114\115\022\122\082\115\123\093\082\068\127\026\082\110\127\042\020\082\020\123\082\110\106\050\020\060\082\020\043\050\098\082\083\123\110\042\082\020\123\082\043\060\017\113\082\026\123\093\082\036\060\060\113\082\020\043\060\082\042\093\068\111\060\106\098\082\050\042\082\123\106\083\060\106\082\127\098\082\026\123\093\082\098\123\017\054\060\082\020\043\050\098\082\113\093\025\025\017\060\112"), 
								Callback = function(action)
									if action ~= nil then
										_Urwigo.RunDialogs(function()
											Wherigo.GetInput(_n4ehU)
										end)
										_CqAeZ:RequestSync()
									end
								end
							}
						end
					end
				}
			end
		end
	}
end
function _oS1:OnEnter()
	_oS1.Visible = true
	_Urwigo.MessageBox{
		Text = _JWJ("\007\060\026\082\026\123\093\082\068\127\083\060\082\050\020\008\082\024\082\043\123\113\060\082\020\043\060\082\017\127\098\020\082\098\020\127\051\060\082\110\127\098\082\042\123\020\082\020\123\123\082\043\127\106\083\082\123\106\082\020\127\036\060\082\026\123\093\082\020\123\082\029\042\111\098\113\084\017\123\042\051\082\020\123\082\012\123\068\113\017\060\020\060\008"), 
		Callback = function(action)
			if action ~= nil then
				_Urwigo.MessageBox{
					Text = _JWJ("\107\043\050\098\082\050\098\082\020\043\060\082\031\050\042\127\017\082\098\020\127\051\060\082\123\031\082\020\043\060\082\110\043\060\106\050\051\123\082\113\123\106\020\050\123\042\082\123\031\082\020\043\050\098\082\051\127\068\060\008"), 
					Callback = function(action)
						if action ~= nil then
							_Urwigo.MessageBox{
								Text = _JWJ("\115\123\093\082\123\042\017\026\082\043\127\054\060\082\123\042\060\082\030\093\060\098\020\050\123\042\082\020\123\082\127\042\098\110\060\106\082\127\042\083\082\020\043\060\042\082\026\123\093\082\110\050\017\017\082\111\060\082\051\050\054\060\042\082\020\043\060\082\012\123\123\106\083\050\042\127\020\060\098\082\031\123\106\082\020\043\060\082\113\043\026\098\050\012\127\017\082\012\127\012\043\060\082\017\123\012\127\020\050\123\042\008"), 
								Callback = function(action)
									if action ~= nil then
										_Urwigo.MessageBox{
											Text = _JWJ("\087\017\060\127\098\060\082\106\060\068\060\068\111\060\106\082\020\123\082\093\098\060\082\020\043\060\082\012\123\068\113\017\060\020\050\123\042\082\012\123\083\060\082\026\123\093\082\106\060\012\050\060\054\060\082\050\042\082\020\043\050\098\082\051\127\068\060\082\020\123\082\068\127\106\036\082\020\043\050\098\082\012\127\106\020\106\050\083\051\060\082\127\098\082\012\123\068\113\017\060\020\060\083\082\123\042\082\020\043\060\082\110\043\060\106\050\051\123\082\110\060\111\082\098\050\020\060\008\082\107\043\127\020\082\110\050\017\017\082\043\060\017\113\082\123\020\043\060\106\098\082\098\060\060\082\020\043\127\020\082\020\043\060\082\012\127\106\020\106\050\083\051\060\082\083\123\060\098\082\050\042\082\031\127\012\020\082\110\123\106\036\082\127\042\083\082\026\123\093\106\082\106\127\020\050\042\051\082\127\042\083\082\017\123\051\082\110\050\017\017\082\017\060\020\082\020\043\060\068\082\036\042\123\110\082\050\031\082\050\020\082\050\098\082\110\123\106\020\043\082\113\017\127\026\050\042\051\008"), 
											Callback = function(action)
												if action ~= nil then
													_Urwigo.MessageBox{
														Text = _JWJ("\007\060\106\060\082\050\098\082\026\123\093\106\082\017\127\098\020\082\030\093\060\098\020\050\123\042\112"), 
														Callback = function(action)
															if action ~= nil then
																_Urwigo.RunDialogs(function()
																	Wherigo.GetInput(_D2A2)
																end)
																_CqAeZ:RequestSync()
															end
														end
													}
												end
											end
										}
									end
								end
							}
						end
					end
				}
			end
		end
	}
end
function _tkqp:OnEnter()
	_Urwigo.MessageBox{
		Text = _JWJ("\107\043\060\106\060\082\127\106\060\082\042\123\082\030\093\060\098\020\050\123\042\098\082\020\123\082\127\042\098\110\060\106\082\043\060\106\060\008\082\107\043\050\098\082\030\093\050\012\036\082\083\060\020\123\093\106\082\110\127\098\082\050\042\012\017\093\083\060\083\082\099\093\098\020\082\020\123\082\106\060\068\050\042\083\082\026\123\093\082\020\043\127\020\082\020\043\060\106\060\082\127\106\060\082\068\127\042\026\082\098\068\127\017\017\082\113\106\050\054\127\020\060\082\068\060\068\123\106\050\127\017\098\082\123\093\020\082\020\043\060\106\060\082\020\123\082\098\093\113\113\123\106\020\082\123\093\106\082\020\106\123\123\113\098\039\082\113\123\017\050\012\060\068\127\042\082\031\050\106\060\031\050\051\043\020\060\106\098\082\127\042\083\082\123\020\043\060\106\082\113\093\111\017\050\012\082\098\060\106\054\050\012\060\082\051\106\123\093\113\098\008\124\027\092\108"), 
		Callback = function(action)
			if action ~= nil then
				_Urwigo.MessageBox{
					Text = _JWJ("\024\031\082\026\123\093\082\036\042\123\110\082\123\031\082\127\042\026\082\042\060\127\020\082\068\060\068\123\106\127\050\017\098\082\113\017\060\127\098\060\082\031\060\060\017\082\031\106\060\060\082\020\123\082\020\060\017\017\082\093\098\082\127\111\123\093\020\082\020\043\060\068\082\050\042\082\026\123\093\106\082\031\050\042\127\017\082\017\123\051\008\082\124\027\092\108"), 
					Callback = function(action)
						if action ~= nil then
							_Urwigo.MessageBox{
								Text = _JWJ("\024\082\043\123\113\060\082\026\123\093\082\060\042\099\123\026\060\083\082\020\043\050\098\082\017\050\020\020\017\060\082\083\060\020\123\093\106\039\082\020\043\060\082\042\060\018\020\082\098\020\127\051\060\082\050\098\082\020\043\060\082\043\127\106\083\060\098\020\008\082\053\127\036\060\082\098\093\106\060\082\026\123\093\082\020\127\036\060\082\042\123\020\060\098\082\020\043\060\106\060\082\098\123\082\026\123\093\082\012\127\042\082\083\060\012\050\113\043\060\106\082\020\043\060\082\012\123\123\106\083\050\042\127\020\060\098\082\127\031\020\060\106\082\127\017\017\082\026\123\093\106\082\110\123\106\036\008\124\027\092\108"), 
								Callback = function(action)
									if action ~= nil then
										_u4hlc.Active = true
										_u4hlc.Visible = true
										_tkqp.Active = false
										_tkqp.Visible = false
									end
								end
							}
							_CqAeZ:RequestSync()
						end
					end
				}
			end
		end
	}
end
function _sFK2:OnGetInput(input)
	if input == nil then
		input = ""
	end
	_FbxoO = input
	if _Urwigo.Hash(string.lower(input)) == 8886 then
		_Urwigo.MessageBox{
			Text = _JWJ("\107\043\127\020\082\050\098\082\012\123\106\106\060\012\020\112\082\034\050\042\083\082\065\127\113\082\110\127\098\082\060\098\020\111\017\050\098\043\060\083\082\050\042\082\086\069\074\005\112"), 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.MessageBox{
						Text = _JWJ("\107\043\127\020\082\110\127\098\082\127\082\113\106\060\020\020\026\082\060\127\098\026\082\030\093\060\098\020\050\123\042\039\082\111\093\020\082\024\082\113\106\123\068\050\098\060\082\020\043\060\026\082\110\050\017\017\082\051\060\020\082\127\082\017\050\020\020\017\060\082\043\127\106\083\060\106\112"), 
						Callback = function(action)
							if action ~= nil then
								_Urwigo.MessageBox{
									Text = _JWJ("\115\123\093\106\082\098\060\012\123\042\083\082\030\093\060\098\020\050\123\042\082\106\060\030\093\050\106\060\098\082\026\123\093\082\020\123\082\012\123\068\060\082\093\113\082\110\050\020\043\082\127\082\020\043\106\060\060\082\083\050\051\060\020\082\012\123\068\111\050\042\127\020\050\123\042\112"), 
									Callback = function(action)
										if action ~= nil then
											_Urwigo.RunDialogs(function()
												Wherigo.GetInput(_lGETc)
											end)
										end
									end
								}
							end
						end
					}
				end
			end
		}
	else
		_Urwigo.MessageBox{
			Text = _JWJ("\024\082\083\123\082\042\123\020\082\093\042\083\060\106\098\020\127\042\083\082\043\123\110\082\026\123\093\082\012\127\042\082\068\050\098\098\082\020\043\127\020\082\123\042\060\008\082\024\020\082\050\098\082\127\042\082\060\127\098\026\082\030\093\060\098\020\050\123\042\008\082\107\043\060\082\127\042\098\110\060\106\082\050\098\082\123\042\082\020\043\060\082\017\123\110\060\106\082\106\050\051\043\020\082\123\031\082\020\043\060\082\098\050\051\042\082\050\042\082\111\050\051\082\110\106\050\020\050\042\051\112\082"), 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.RunDialogs(function()
						Wherigo.GetInput(_sFK2)
					end)
				end
			end
		}
	end
	_CqAeZ:RequestSync()
end
function _lGETc:OnGetInput(input)
	if input == nil then
		input = ""
	end
	_FbxoO = input
	if Wherigo.NoCaseEquals(input, tostring(180)) then
		_Urwigo.MessageBox{
			Text = _JWJ("\107\043\127\020\013\098\082\106\050\051\043\020\082\050\020\082\050\098\082\086\069\041\082\127\042\083\082\026\123\093\082\043\127\054\060\082\093\042\017\123\012\036\060\083\082\020\043\060\082\042\060\018\020\082\025\123\042\060\112\082\065\017\127\083\082\020\123\082\098\060\060\082\026\123\093\082\031\050\051\093\106\060\083\082\020\043\050\098\082\123\042\060\082\123\093\020\008\112"), 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.MessageBox{
						Text = _JWJ("\024\082\110\123\093\017\083\082\098\093\051\051\060\098\020\082\083\106\050\054\050\042\051\082\020\123\082\068\123\098\020\082\025\123\042\060\098\039\082\111\093\020\082\020\043\050\098\082\123\042\060\082\050\098\082\042\123\020\082\106\060\127\017\082\031\127\106\082\127\110\127\026\112"), 
						Callback = function(action)
							if action ~= nil then
								_Urwigo.MessageBox{
									Text = _JWJ("\065\123\082\127\043\060\127\083\082\127\042\083\082\051\123\082\020\123\082\020\043\060\082\042\060\018\020\082\025\123\042\060\112")
								}
							end
						end
					}
					_Hdz.Active = true
					_Hdz.Visible = true
					_DccZC.Active = false
					_DccZC.Visible = false
				end
			end
		}
	elseif input ~= tostring(180) then
		_Urwigo.MessageBox{
			Text = _JWJ("\073\123\106\106\026\039\082\020\043\127\020\082\127\050\042\013\020\082\106\050\051\043\020\112\082\024\082\127\068\082\017\123\123\036\050\042\051\082\031\123\106\082\127\082\020\043\106\060\060\082\083\050\051\050\020\082\042\093\068\111\060\106\039\082\099\093\098\020\082\012\123\093\042\020\082\020\043\060\082\127\106\106\123\110\098\082\127\042\083\082\060\042\020\060\106\082\020\043\060\082\042\093\068\111\060\106\082\050\042\082\020\043\060\082\012\123\106\106\060\012\020\082\123\106\083\060\106\112"), 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.RunDialogs(function()
						Wherigo.GetInput(_lGETc)
					end)
				end
			end
		}
	end
	_CqAeZ:RequestSync()
end
function _vtW:OnGetInput(input)
	if input == nil then
		input = ""
	end
	_FbxoO = input
	if _Urwigo.Hash(string.lower(input)) == 28432 then
		_Urwigo.MessageBox{
			Text = _JWJ("\065\106\060\127\020\082\099\123\111\112\082\097\123\110\082\050\020\082\050\098\082\020\050\068\060\082\031\123\106\082\020\043\127\020\082\113\127\113\060\106\082\127\042\083\082\113\060\042\008\082\024\082\127\068\082\098\093\106\060\082\026\123\093\082\110\050\017\017\082\110\127\042\020\082\020\123\082\110\106\050\020\060\082\060\127\012\043\082\123\031\082\020\043\060\098\060\082\127\042\098\110\060\106\098\082\083\123\110\042\008\082"), 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.MessageBox{
						Text = _JWJ("\115\123\093\082\110\050\017\017\082\111\060\082\017\123\123\036\050\042\051\082\127\020\082\017\127\098\020\082\042\127\068\060\098\082\123\042\017\026\082\020\123\082\098\123\017\054\060\082\020\043\060\082\031\123\017\017\123\110\050\042\051\082\098\043\123\106\020\082\113\093\025\025\017\060\008"), 
						Callback = function(action)
							if action ~= nil then
								_CqAeZ:RequestSync()
								_Urwigo.MessageBox{
									Text = _JWJ("\003\015\082\042\093\068\111\060\106\082\123\031\082\034\034\086\082\034\050\017\017\050\127\068\098\082\031\127\068\050\017\026\082\068\060\068\111\060\106\098\112"), 
									Callback = function(action)
										if action ~= nil then
											_CqAeZ:RequestSync()
											_Urwigo.MessageBox{
												Text = _JWJ("\003\015\082\042\093\068\111\060\106\082\123\031\082\034\034\086\082\034\050\017\017\050\127\068\098\082\031\127\068\050\017\026\082\068\060\068\111\060\106\098\112\124\027\092\108\027\015\082\042\093\068\111\060\106\082\123\031\082\034\034\078\082\037\123\042\060\098\082\031\127\068\050\017\026\082\068\060\068\111\060\106\098\112"), 
												Callback = function(action)
													if action ~= nil then
														_Urwigo.MessageBox{
															Text = _JWJ("\003\015\082\042\093\068\111\060\106\082\123\031\082\034\034\086\082\034\050\017\017\050\127\068\098\082\031\127\068\050\017\026\082\068\060\068\111\060\106\098\112\124\027\092\108\027\015\082\042\093\068\111\060\106\082\123\031\082\034\034\078\082\037\123\042\060\098\082\031\127\068\050\017\026\082\068\060\068\111\060\106\098\112\124\027\092\108\085\015\082\042\093\068\111\060\106\082\123\031\082\034\034\086\082\073\068\050\012\036\017\060\026\082\031\127\068\050\017\026\082\068\060\068\111\060\106\098\112"), 
															Callback = function(action)
																if action ~= nil then
																	_Urwigo.MessageBox{
																		Text = _JWJ("\003\015\082\042\093\068\111\060\106\082\123\031\082\034\034\086\082\034\050\017\017\050\127\068\098\082\031\127\068\050\017\026\082\068\060\068\111\060\106\098\112\124\027\092\108\027\015\082\042\093\068\111\060\106\082\123\031\082\034\034\078\082\037\123\042\060\098\082\031\127\068\050\017\026\082\068\060\068\111\060\106\098\112\124\027\092\108\085\015\082\042\093\068\111\060\106\082\123\031\082\034\034\086\082\073\068\050\012\036\017\060\026\082\031\127\068\050\017\026\082\068\060\068\111\060\106\098\112\124\027\092\108\057\015\082\042\093\068\111\060\106\082\123\031\082\034\034\086\082\092\050\098\098\068\050\017\017\060\106\082\068\050\042\093\098\082\042\093\068\111\060\106\082\123\031\082\034\034\078\082\027\127\054\127\106\050\127\112"), 
																		Callback = function(action)
																			if action ~= nil then
																				_Urwigo.MessageBox{
																					Text = _JWJ("\003\015\082\042\093\068\111\060\106\082\123\031\082\034\034\086\082\034\050\017\017\050\127\068\098\082\031\127\068\050\017\026\082\068\060\068\111\060\106\098\112\124\027\092\108\027\015\082\042\093\068\111\060\106\082\123\031\082\034\034\078\082\037\123\042\060\098\082\031\127\068\050\017\026\082\068\060\068\111\060\106\098\112\124\027\092\108\085\015\082\042\093\068\111\060\106\082\123\031\082\034\034\086\082\073\068\050\012\036\017\060\026\082\031\127\068\050\017\026\082\068\060\068\111\060\106\098\112\124\027\092\108\057\015\082\042\093\068\111\060\106\082\123\031\082\034\034\086\082\092\050\098\098\068\050\017\017\060\106\082\068\050\042\093\098\082\042\093\068\111\060\106\082\123\031\082\034\034\078\082\027\127\054\127\106\050\127\112\124\027\092\108\032\015\082\042\093\068\111\060\106\082\123\031\082\034\034\086\082\016\106\123\068\060\106\112"), 
																					Callback = function(action)
																						if action ~= nil then
																							_CqAeZ:RequestSync()
																							_Urwigo.MessageBox{
																								Text = _JWJ("\003\015\082\042\093\068\111\060\106\082\123\031\082\034\034\086\082\034\050\017\017\050\127\068\098\082\031\127\068\050\017\026\082\068\060\068\111\060\106\098\112\124\027\092\108\027\015\082\042\093\068\111\060\106\082\123\031\082\034\034\078\082\037\123\042\060\098\082\031\127\068\050\017\026\082\068\060\068\111\060\106\098\112\124\027\092\108\085\015\082\042\093\068\111\060\106\082\123\031\082\034\034\086\082\073\068\050\012\036\017\060\026\082\031\127\068\050\017\026\082\068\060\068\111\060\106\098\112\124\027\092\108\057\015\082\042\093\068\111\060\106\082\123\031\082\034\034\086\082\092\050\098\098\068\050\017\017\060\106\082\068\050\042\093\098\082\042\093\068\111\060\106\082\123\031\082\034\034\086\082\027\127\054\127\106\050\127\112\124\027\092\108\032\015\082\042\093\068\111\060\106\082\123\031\082\034\034\086\082\016\106\123\068\060\106\112\124\027\092\108\028\015\082\042\093\068\111\060\106\082\123\031\082\034\034\078\082\027\093\098\043\082\113\017\093\098\082\034\034\086\082\007\127\043\042"), 
																								Callback = function(action)
																									if action ~= nil then
																										_Urwigo.MessageBox{
																											Text = _JWJ("\003\015\082\042\093\068\111\060\106\082\123\031\082\034\034\086\082\034\050\017\017\050\127\068\098\082\031\127\068\050\017\026\082\068\060\068\111\060\106\098\112\124\027\092\108\027\015\082\042\093\068\111\060\106\082\123\031\082\034\034\078\082\037\123\042\060\098\082\031\127\068\050\017\026\082\068\060\068\111\060\106\098\112\124\027\092\108\085\015\082\042\093\068\111\060\106\082\123\031\082\034\034\086\082\073\068\050\012\036\017\060\026\082\031\127\068\050\017\026\082\068\060\068\111\060\106\098\112\124\027\092\108\057\015\082\042\093\068\111\060\106\082\123\031\082\034\034\086\082\092\050\098\098\068\050\017\017\060\106\082\068\050\042\093\098\082\042\093\068\111\060\106\082\123\031\082\034\034\078\082\027\127\054\127\106\050\127\082\031\127\068\050\017\026\082\068\060\068\111\060\106\098\112\124\027\092\108\032\015\082\042\093\068\111\060\106\082\123\031\082\034\034\086\082\016\106\123\068\060\106\082\031\127\068\050\017\026\082\068\060\068\111\060\106\098\112\124\027\092\108\028\015\082\042\093\068\111\060\106\082\123\031\082\034\034\078\082\027\093\098\043\082\113\017\093\098\082\034\034\086\082\007\127\043\042\082\031\127\068\050\017\026\082\068\060\068\111\060\106\098\112\124\027\092\108\065\015\082\042\093\068\111\060\106\082\123\031\082\034\034\078\082\073\127\111\127\020\050\042\123\082\113\017\093\098\082\034\034\078\082\085\043\127\106\106\123\042\082\113\017\093\098\082\034\034\078\082\016\060\068\068\060\106\060\106\112"), 
																											Callback = function(action)
																												if action ~= nil then
																													_Urwigo.MessageBox{
																														Text = _JWJ("\107\043\060\082\042\060\018\020\082\098\020\127\051\060\082\050\098\082\127\020\082\029\042\111\098\113\084\097\082\003\057\082\027\057\008\085\027\085\082\034\082\057\028\027\082\032\028\008\028\065\032\124\027\092\108\115\123\093\082\110\050\017\017\082\042\060\060\083\082\020\123\082\127\083\083\082\050\020\082\127\098\082\127\082\110\127\026\082\113\123\050\042\020\082\127\042\083\082\068\123\054\060\082\123\042\082\020\123\082\020\043\127\020\082\017\123\012\127\020\050\123\042\008\082\107\043\060\082\051\127\068\060\082\110\050\017\017\082\042\123\020\082\098\043\123\110\082\026\123\093\082\110\043\060\106\060\082\050\020\082\050\098\082\093\042\020\050\017\082\026\123\093\082\127\106\106\050\054\060\112")
																													}
																													_WoZgg.Active = true
																													_Hdz.Active = false
																													_Hdz.Visible = false
																												end
																											end
																										}
																									end
																								end
																							}
																						end
																					end
																				}
																			end
																		end
																	}
																end
															end
														}
													end
												end
											}
										end
									end
								}
							end
						end
					}
				end
			end
		}
	else
		_Urwigo.MessageBox{
			Text = _JWJ("\003\106\060\082\026\123\093\082\098\020\127\042\083\050\042\051\082\050\042\082\031\106\123\042\020\082\123\031\082\020\043\060\082\034\123\106\017\083\082\034\127\106\082\068\060\068\123\106\050\127\017\080\082\107\043\127\020\082\050\098\082\042\123\020\082\020\043\060\082\127\042\098\110\060\106\082\024\082\098\127\110\112"), 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.RunDialogs(function()
						Wherigo.GetInput(_vtW)
					end)
				end
			end
		}
	end
	_CqAeZ:RequestSync()
end
function _Xw8IV:OnGetInput(input)
	if input == nil then
		input = ""
	end
	_FbxoO = input
	if _Urwigo.Hash(string.lower(input)) == 1571 then
		_Urwigo.MessageBox{
			Text = _JWJ("\035\060\106\026\082\051\123\123\083\112\082\040\060\020\013\098\082\036\060\060\113\082\051\123\050\042\051\112"), 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.RunDialogs(function()
						Wherigo.GetInput(_8zZ)
					end)
				end
			end
		}
	else
		_Urwigo.MessageBox{
			Text = _JWJ("\065\093\060\098\098\082\127\051\127\050\042\112"), 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.RunDialogs(function()
						Wherigo.GetInput(_Xw8IV)
					end)
				end
			end
		}
	end
	_CqAeZ:RequestSync()
end
function _8zZ:OnGetInput(input)
	if input == nil then
		input = ""
	end
	_FbxoO = input
	if _Urwigo.Hash(string.lower(input)) == 61116 then
		_Urwigo.MessageBox{
			Text = _JWJ("\115\123\093\082\051\123\020\082\029\042\111\098\113\084\020\043\127\020\082\106\050\051\043\020\112\082\097\060\018\020\082\030\093\060\098\020\050\123\042\082\113\017\060\127\098\060\112"), 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.RunDialogs(function()
						Wherigo.GetInput(_D5Xl)
					end)
				end
			end
		}
	else
		_Urwigo.MessageBox{
			Text = _JWJ("\027\060\082\051\017\127\083\082\020\043\050\098\082\050\098\082\042\123\020\082\007\123\113\060\082\012\060\068\060\020\060\106\026\082\123\106\082\026\123\093\082\110\123\093\017\083\082\111\060\082\083\123\050\042\051\082\098\123\068\060\082\068\123\106\060\082\110\127\017\036\050\042\051\112\082\065\123\082\123\042\082\051\093\060\098\098\082\127\051\127\050\042\008"), 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.RunDialogs(function()
						Wherigo.GetInput(_8zZ)
					end)
				end
			end
		}
	end
	_CqAeZ:RequestSync()
end
function _D5Xl:OnGetInput(input)
	if input == nil then
		input = ""
	end
	_FbxoO = input
	if _Urwigo.Hash(string.lower(input)) == 20085 then
		_Urwigo.MessageBox{
			Text = _JWJ("\115\123\093\082\127\106\060\082\123\042\082\127\082\106\123\017\017\082\042\123\110\039\082\113\106\060\020\020\026\082\098\123\123\042\082\026\123\093\082\110\050\017\017\082\111\060\082\123\042\082\020\123\082\020\043\060\082\042\060\018\020\082\098\020\127\051\060\008"), 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.RunDialogs(function()
						Wherigo.GetInput(_1GJZ)
					end)
				end
			end
		}
	else
		_Urwigo.MessageBox{
			Text = _JWJ("\115\123\093\082\127\106\060\082\106\060\127\017\017\026\082\098\020\106\093\051\051\017\050\042\051\082\043\060\106\060\008\082\107\106\026\082\127\051\127\050\042\112"), 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.RunDialogs(function()
						Wherigo.GetInput(_D5Xl)
					end)
				end
			end
		}
	end
	_CqAeZ:RequestSync()
end
function _1GJZ:OnGetInput(input)
	if input == nil then
		input = ""
	end
	_FbxoO = input
	if _Urwigo.Hash(string.lower(input)) == 8501 then
		_Urwigo.MessageBox{
			Text = _JWJ("\107\043\127\020\082\050\098\082\106\050\051\043\020\082\028\123\106\020\082\003\093\051\093\098\020\127\082\110\127\098\082\083\093\060\082\110\060\098\020\082\123\031\082\032\127\098\020\123\042\008\082"), 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.MessageBox{
						Text = _JWJ("\097\123\110\082\031\123\106\082\026\123\093\106\082\017\127\098\020\082\030\093\060\098\020\050\123\042\082\043\060\106\060\008"), 
						Callback = function(action)
							if action ~= nil then
								_Urwigo.RunDialogs(function()
									Wherigo.GetInput(_6pEo)
								end)
							end
						end
					}
				end
			end
		}
	else
		_Urwigo.MessageBox{
			Text = _JWJ("\107\043\127\020\082\050\098\082\042\123\020\082\110\043\127\020\082\024\082\127\068\082\017\123\123\036\050\042\051\082\031\123\106\008\082\024\020\082\050\098\082\020\043\060\082\098\123\093\020\043\060\106\042\082\068\123\098\020\082\031\123\106\020\082\123\042\082\020\043\060\082\068\127\113\008\082\107\106\026\082\127\051\127\050\042\112"), 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.RunDialogs(function()
						Wherigo.GetInput(_1GJZ)
					end)
				end
			end
		}
	end
	_CqAeZ:RequestSync()
end
function _6pEo:OnGetInput(input)
	if input == nil then
		input = ""
	end
	_FbxoO = input
	if _Urwigo.Hash(string.lower(input)) == 43916 then
		_Urwigo.MessageBox{
			Text = _JWJ("\107\043\127\020\082\050\098\082\106\050\051\043\020\082\020\043\060\026\082\098\020\127\026\060\083\082\042\060\127\106\082\007\060\017\017\060\106\013\098\082\107\127\054\060\106\042\008\082\003\017\017\082\020\043\060\082\123\020\043\060\106\082\113\017\127\012\060\098\082\127\017\098\123\082\060\018\098\050\098\020\060\083\082\127\020\082\020\043\050\098\082\020\050\068\060\008\082"), 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.MessageBox{
						Text = _JWJ("\115\123\093\082\012\127\042\082\042\123\110\082\051\123\082\020\123\082\020\043\060\082\031\123\093\106\020\043\082\098\020\127\051\060\082\123\031\082\020\043\050\098\082\051\127\068\060\039\082\050\020\082\050\098\082\127\082\030\093\050\012\036\082\123\042\060\008"), 
						Callback = function(action)
							if action ~= nil then
								_Urwigo.MessageBox{
									Text = _JWJ("\107\123\082\043\060\017\113\082\026\123\093\082\051\060\020\082\020\043\060\106\060\082\098\127\031\060\017\026\082\026\123\093\082\068\127\026\082\050\042\113\093\020\082\020\043\060\082\031\123\017\017\123\110\050\042\051\082\110\127\026\113\123\050\042\020\044\124\027\092\108\097\082\096\041\082\096\074\008\076\074\078\082\029\042\111\098\113\084\034\082\046\120\082\086\076\008\076\069\076")
								}
							end
						end
					}
					_WoZgg.Active = false
					_WoZgg.Visible = false
					_tkqp.Active = true
					_tkqp.Visible = true
				end
			end
		}
	else
		_Urwigo.MessageBox{
			Text = _JWJ("\034\106\123\042\051\082\110\106\123\042\051\082\110\106\123\042\051\008\082\107\106\026\082\127\051\127\050\042\112"), 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.RunDialogs(function()
						Wherigo.GetInput(_6pEo)
					end)
				end
			end
		}
	end
	_CqAeZ:RequestSync()
end
function _n4ehU:OnGetInput(input)
	if input == nil then
		input = ""
	end
	_FbxoO = input
	if Wherigo.NoCaseEquals(_FbxoO, _JWJ("\086")) then
		_Urwigo.MessageBox{
			Text = _JWJ("\107\043\127\020\082\050\098\082\106\050\051\043\020\082\127\082\113\060\042\042\026\082\050\098\082\098\020\050\017\017\082\110\123\106\020\043\082\062\097\032\082\012\060\042\020\039\082\099\093\098\020\082\012\127\042\042\123\020\082\111\093\026\082\068\093\012\043\082\110\050\020\043\082\050\020\008\082\073\123\082\026\123\093\082\042\123\110\082\043\127\054\060\082\026\123\093\106\082\031\050\106\098\020\082\113\127\106\020\082\123\031\082\020\043\060\082\042\060\018\020\082\012\123\123\106\083\050\042\127\020\060\112\082\022\015\086"), 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.MessageBox{
						Text = _JWJ("\032\127\012\043\082\012\123\106\106\060\012\020\082\127\042\098\110\060\106\082\110\050\017\017\082\051\050\054\060\082\026\123\093\082\127\042\123\020\043\060\106\082\113\127\106\020\082\123\031\082\020\043\060\082\012\123\123\106\083\050\042\127\020\060\082\098\060\020\082\031\123\106\082\020\043\060\082\042\060\018\020\082\098\020\127\051\060\008\082\027\060\082\098\093\106\060\082\020\123\082\110\106\050\020\060\082\020\043\060\068\082\083\123\110\042\082\127\098\082\026\123\093\082\051\123\008"), 
						Callback = function(action)
							if action ~= nil then
								_Urwigo.RunDialogs(function()
									Wherigo.GetInput(_sGrTQ)
								end)
							end
						end
					}
				end
			end
		}
	else
		_Urwigo.MessageBox{
			Text = _JWJ("\073\068\127\017\017\082\092\123\093\042\083\082\012\123\113\113\060\106\082\017\123\123\036\050\042\051\082\012\123\050\042\008\082\115\123\093\082\012\127\042\042\123\020\082\111\093\026\082\020\123\123\082\068\093\012\043\082\110\050\020\043\082\020\043\050\098\082\050\042\082\020\123\083\127\026\013\098\082\110\123\106\017\083\112"), 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.RunDialogs(function()
						Wherigo.GetInput(_n4ehU)
					end)
				end
			end
		}
	end
	_CqAeZ:RequestSync()
end
function _sGrTQ:OnGetInput(input)
	if input == nil then
		input = ""
	end
	_FbxoO = input
	if _Urwigo.Hash(string.lower(input)) == 61123 then
		_Urwigo.MessageBox{
			Text = _JWJ("\085\123\106\106\060\012\020\112\082\071\098\060\082\020\043\050\098\082\042\093\068\111\060\106\082\127\098\082\122\028\065\122\082\050\042\082\020\043\060\082\012\123\123\106\083\050\042\127\020\060\098\112\124\027\092\108"), 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.RunDialogs(function()
						Wherigo.GetInput(_Q4jv)
					end)
				end
			end
		}
	else
		_Urwigo.MessageBox{
			Text = _JWJ("\073\123\106\106\026\082\020\043\127\020\082\050\098\082\042\123\020\082\110\043\127\020\082\024\082\127\068\082\017\123\123\036\050\042\051\082\031\123\106\082\127\042\083\082\110\050\017\017\082\042\123\020\082\051\060\020\082\026\123\093\082\020\123\082\020\043\060\082\042\060\018\020\082\098\020\127\051\060\008\082\003\083\083\082\060\127\012\043\082\083\050\083\051\050\020\082\123\031\082\020\043\060\082\057\062\027\082\020\123\051\060\020\043\060\106\039\082\031\123\106\082\060\018\127\068\113\017\060\082\086\078\066\078\074\066\076\086\082\110\123\093\017\083\082\111\060\082\078\086\112"), 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.RunDialogs(function()
						Wherigo.GetInput(_sGrTQ)
					end)
				end
			end
		}
	end
	_CqAeZ:RequestSync()
end
function _Q4jv:OnGetInput(input)
	if input == nil then
		input = ""
	end
	_FbxoO = input
	if _Urwigo.Hash(string.lower(input)) == 44791 then
		_Urwigo.MessageBox{
			Text = _JWJ("\085\123\106\106\060\012\020\082\112\082\087\017\060\127\098\060\082\093\098\060\082\122\096\041\122\031\123\106\082\122\003\027\122"), 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.RunDialogs(function()
						Wherigo.GetInput(_Vos)
					end)
				end
			end
		}
	else
		_Urwigo.MessageBox{
			Text = _JWJ("\073\123\106\106\026\082\020\043\127\020\082\050\098\082\042\123\020\082\020\043\060\082\127\042\098\110\060\106\082\024\082\127\068\082\017\123\123\036\050\042\051\082\031\123\106\008"), 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.RunDialogs(function()
						Wherigo.GetInput(_Q4jv)
					end)
				end
			end
		}
	end
	_CqAeZ:RequestSync()
end
function _Vos:OnGetInput(input)
	if input == nil then
		input = ""
	end
	_FbxoO = input
	if _Urwigo.Hash(string.lower(input)) == 39351 then
		_Urwigo.MessageBox{
			Text = _JWJ("\085\123\106\106\060\012\020\082\093\098\060\082\020\043\060\098\060\082\042\093\068\111\060\106\098\082\031\123\106\082\122\085\057\122\112"), 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.RunDialogs(function()
						Wherigo.GetInput(_Ttn)
					end)
				end
			end
		}
	else
		_Urwigo.MessageBox{
			Text = _JWJ("\007\068\068\068\039\082\024\082\020\043\050\042\036\082\026\123\093\082\042\060\060\083\082\020\123\082\012\043\060\012\036\082\026\123\093\106\082\068\127\020\043\112\082\107\106\026\082\127\051\127\050\042\112"), 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.RunDialogs(function()
						Wherigo.GetInput(_Vos)
					end)
				end
			end
		}
	end
	_CqAeZ:RequestSync()
end
function _Ttn:OnGetInput(input)
	if input == nil then
		input = ""
	end
	_FbxoO = input
	if _Urwigo.Hash(string.lower(input)) == 48 then
		_Urwigo.MessageBox{
			Text = _JWJ("\035\060\106\026\082\051\123\123\083\112\082\024\082\020\043\123\093\051\043\020\082\024\082\068\050\051\043\020\082\020\106\050\113\082\026\123\093\082\093\113\082\123\042\082\020\043\127\020\082\123\042\060\008\082\107\043\050\098\082\050\098\082\122\073\122"), 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.RunDialogs(function()
						Wherigo.GetInput(_KWE)
					end)
				end
			end
		}
	else
		_Urwigo.MessageBox{
			Text = _JWJ("\053\127\036\050\042\051\082\098\093\106\060\082\026\123\093\082\127\106\060\082\036\060\026\050\042\051\082\050\042\082\127\082\042\093\068\111\060\106\082\127\042\083\082\042\123\020\082\127\082\017\060\020\020\060\106\112"), 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.RunDialogs(function()
						Wherigo.GetInput(_Ttn)
					end)
				end
			end
		}
	end
	_CqAeZ:RequestSync()
end
function _KWE:OnGetInput(input)
	if input == nil then
		input = ""
	end
	_FbxoO = input
	if _Urwigo.Hash(string.lower(input)) == 4816 then
		_Urwigo.MessageBox{
			Text = _JWJ("\034\123\110\039\082\054\060\106\026\082\051\123\123\083\039\082\026\123\093\082\127\106\060\082\051\060\020\020\050\042\051\082\012\017\123\098\060\106\082\020\123\082\043\127\054\050\042\051\082\020\043\060\082\031\093\017\017\082\098\060\020\082\123\031\082\012\123\123\106\083\050\042\127\020\060\098\008\082\046\120\086\082\050\098\082\122\107\071\035\122"), 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.RunDialogs(function()
						Wherigo.GetInput(_YI4)
					end)
				end
			end
		}
	else
		_Urwigo.MessageBox{
			Text = _JWJ("\024\082\036\042\123\110\082\020\043\050\098\082\123\042\060\082\050\098\082\043\127\106\083\060\106\008\082\107\043\060\082\083\127\026\082\050\098\082\005\041\082\050\031\082\020\043\127\020\082\043\060\017\113\098\008\082\107\106\026\082\127\051\127\050\042\112"), 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.RunDialogs(function()
						Wherigo.GetInput(_KWE)
					end)
				end
			end
		}
	end
	_CqAeZ:RequestSync()
end
function _YI4:OnGetInput(input)
	if input == nil then
		input = ""
	end
	_FbxoO = input
	if _Urwigo.Hash(string.lower(input)) == 55 then
		_Urwigo.MessageBox{
			Text = _JWJ("\035\060\106\026\082\042\050\012\060\112\082\071\098\060\082\020\043\050\098\082\042\093\068\111\060\106\082\031\123\106\082\122\034\122\112"), 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.MessageBox{
						Text = _JWJ("\062\042\017\026\082\127\082\031\060\110\082\068\123\106\060\082\030\093\060\098\020\050\123\042\082\127\042\083\082\026\123\093\082\110\050\017\017\082\111\060\082\123\042\082\026\123\093\106\082\110\127\026\008\082\057\123\042\013\020\082\051\050\054\060\082\093\113\082\042\123\110\112"), 
						Callback = function(action)
							if action ~= nil then
								_Urwigo.RunDialogs(function()
									Wherigo.GetInput(_OIC4r)
								end)
							end
						end
					}
				end
			end
		}
	else
		_Urwigo.MessageBox{
			Text = _JWJ("\073\123\106\106\026\082\020\043\127\020\082\050\098\082\042\123\020\082\110\043\127\020\082\024\082\127\068\082\017\123\123\036\050\042\051\082\031\123\106\082\043\060\106\060\008\082\107\043\050\098\082\042\093\068\111\060\106\082\050\098\082\012\123\042\098\050\083\060\106\060\083\082\017\093\012\036\026\082\111\026\082\098\123\068\060\008\082\107\106\026\082\127\051\127\050\042\112"), 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.RunDialogs(function()
						Wherigo.GetInput(_YI4)
					end)
				end
			end
		}
	end
	_CqAeZ:RequestSync()
end
function _OIC4r:OnGetInput(input)
	if input == nil then
		input = ""
	end
	_FbxoO = input
	if _Urwigo.Hash(string.lower(input)) == 49 then
		_Urwigo.MessageBox{
			Text = _JWJ("\065\106\060\127\020\112\082\071\098\060\082\020\043\050\098\082\031\123\106\082\032\082\127\042\083\082\026\123\093\082\042\123\110\082\043\127\054\060\082\127\017\017\082\020\043\060\082\042\093\068\111\060\106\098\082\031\123\106\082\020\043\060\082\042\123\106\020\043\082\012\123\123\106\083\050\127\042\020\060\098\082\123\031\082\020\043\060\082\042\060\018\020\082\098\020\127\051\060\008\082\029\042\111\098\113\084\062\042\060\082\017\127\098\020\082\030\093\060\098\020\050\123\042\082\127\042\083\082\026\123\093\082\110\050\017\017\082\111\060\082\123\042\082\026\123\093\106\082\110\127\026\082\020\123\082\020\043\060\082\017\127\098\020\082\098\020\127\051\060\082\123\031\082\020\043\060\082\110\043\060\106\050\051\123\082\113\123\106\020\050\123\042\082\123\031\082\020\043\050\098\082\012\127\012\043\060\112"), 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.MessageBox{
						Text = _JWJ("\024\082\106\060\127\017\017\026\082\043\123\113\060\082\026\123\093\082\127\106\060\082\060\042\099\123\026\050\042\051\082\020\043\050\098\082\127\083\054\060\042\020\093\106\060\082\127\042\083\082\110\050\017\017\082\012\123\042\020\050\042\093\060\082\020\123\082\083\123\082\123\020\043\060\106\082\034\043\060\106\050\051\123\013\098\082\050\042\082\020\043\060\082\031\093\020\093\106\060\008"), 
						Callback = function(action)
							if action ~= nil then
								_Urwigo.RunDialogs(function()
									Wherigo.GetInput(_Uky)
								end)
							end
						end
					}
				end
			end
		}
	else
		_Urwigo.MessageBox{
			Text = _JWJ("\073\127\026\082\034\043\127\020\112\082\107\043\050\098\082\050\098\082\127\082\042\093\068\111\060\106\082\020\043\127\020\082\127\017\017\082\012\123\017\017\060\051\060\082\031\123\123\020\111\127\017\017\082\020\060\127\068\098\082\110\127\042\020\082\020\123\082\012\017\127\050\068\082\020\123\082\111\060\112\082\065\123\020\082\050\020\082\042\123\110\080"), 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.RunDialogs(function()
						Wherigo.GetInput(_OIC4r)
					end)
				end
			end
		}
	end
	_CqAeZ:RequestSync()
end
function _Uky:OnGetInput(input)
	if input == nil then
		input = ""
	end
	_FbxoO = input
	if _Urwigo.Hash(string.lower(input)) == 44799 then
		_Urwigo.MessageBox{
			Text = _JWJ("\082\062\036\082\026\123\093\082\036\042\123\110\082\043\127\054\060\082\127\017\017\082\020\043\060\082\042\093\068\111\060\106\098\082\026\123\093\082\042\060\060\083\082\020\123\082\043\060\127\083\082\020\123\082\020\043\060\082\042\060\018\020\082\098\020\127\051\060\008\082\003\051\127\050\042\039\082\050\042\082\012\127\098\060\082\026\123\093\082\017\123\098\020\082\050\020\039\082\020\043\060\082\098\020\127\051\060\082\050\098\082\127\020\082\097\123\106\020\043\082\003\027\082\085\057\008\032\028\065\082\034\060\098\020\082\073\107\071\082\035\034\008\114\115\022\082\053\127\036\060\082\098\093\106\060\082\026\123\093\082\043\127\054\060\082\020\043\060\068\082\060\042\020\060\106\060\083\082\050\042\082\026\123\093\106\082\065\087\073\082\127\098\082\020\043\050\098\082\098\020\127\051\060\082\110\050\017\017\082\042\123\020\082\098\043\123\110\082\093\113\082\093\042\020\050\017\082\026\123\093\082\060\042\020\060\106\082\020\043\060\082\025\123\042\060\008")
		}
		_oS1.Active = true
		_u4hlc.Active = false
		_u4hlc.Visible = false
	else
		_Urwigo.MessageBox{
			Text = _JWJ("\115\123\093\082\068\093\098\020\082\111\060\082\051\060\020\020\050\042\051\082\020\050\106\060\083\082\012\127\093\098\060\082\020\043\127\020\082\050\098\082\042\123\020\082\020\043\060\082\042\093\068\111\060\106\082\024\082\106\060\127\083\008\082\024\020\082\050\098\082\020\110\123\082\017\060\098\098\082\020\043\127\042\082\120\041\082\050\031\082\020\043\127\020\082\043\060\017\113\098\112"), 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.RunDialogs(function()
						Wherigo.GetInput(_Uky)
					end)
				end
			end
		}
	end
	_CqAeZ:RequestSync()
end
function _D2A2:OnGetInput(input)
	if input == nil then
		input = ""
	end
	_FbxoO = input
	if _Urwigo.Hash(string.lower(input)) == 32714 then
		_QHnVm:MoveTo(_oS1)
		_Urwigo.MessageBox{
			Text = _JWJ("\065\106\060\127\020\082\026\123\093\082\043\127\054\060\082\083\123\042\060\082\098\123\082\110\060\017\017\112"), 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.MessageBox{
						Text = _JWJ("\115\123\093\082\068\127\026\082\042\123\110\082\113\050\012\036\082\093\113\082\026\123\093\106\082\053\050\098\098\050\123\042\082\062\106\083\060\106\098\112"), 
						Callback = function(action)
							if action ~= nil then
								_QHnVm.Visible = true
								_QHnVm.Commands._WzZ.Enabled = true
							end
						end
					}
				end
			end
		}
	else
		_Urwigo.MessageBox{
			Text = _JWJ("\073\123\106\106\026\039\082\051\123\123\083\082\051\093\060\098\098\082\111\093\020\082\042\123\020\082\012\123\106\106\060\012\020\112"), 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.RunDialogs(function()
						Wherigo.GetInput(_D2A2)
					end)
				end
			end
		}
	end
	_CqAeZ:RequestSync()
end
function _fS7:OnTick()
	if _G[_JWJ("\087\017\127\026\060\106")][_JWJ("\087\123\098\050\020\050\123\042\003\012\012\093\106\127\012\026")][_JWJ("\065\060\020\035\127\017\093\060")](_G[_JWJ("\087\017\127\026\060\106")][_JWJ("\087\123\098\050\020\050\123\042\003\012\012\093\106\127\012\026")], _JWJ("\068")) == 3 then
		for k, v in pairs(_G[_JWJ("\090\085\030\003\060\022")][_JWJ("\003\017\017\022\062\111\099\060\012\020\098")]) do
			v[_JWJ("\035\050\098\050\111\017\060")] = false
			v[_JWJ("\003\012\020\050\054\060")] = false
		end
		_G[_JWJ("\034\043\060\106\050\051\123")][_JWJ("\085\123\068\068\127\042\083")](_JWJ("\073\127\054\060\085\017\123\098\060"))
		return
	end
end
function _IMIhL:On_8OESU(target)
	_Urwigo.MessageBox{
		Text = string.sub(Player.CompletionCode, 1, 15)
	}
	_CqAeZ:RequestSync()
end
function _IMIhL:On_P2el(target)
	_Urwigo.MessageBox{
		Text = Player.Name
	}
	_CqAeZ:RequestSync()
end
function _QHnVm:On_WzZ(target)
	if (_G[_JWJ("\032\042\054")][_JWJ("\087\017\127\020\031\123\106\068")] == _JWJ("\034\050\042\005\078")) or (_G[_JWJ("\032\042\054")][_JWJ("\057\060\054\050\012\060\024\057")] == _JWJ("\057\060\098\036\020\123\113")) then
		_Urwigo.MessageBox{
			Text = _JWJ("\107\043\127\042\036\082\026\123\093\082\031\123\106\082\026\123\093\106\082\050\042\020\060\106\060\098\020\082\050\042\082\020\043\050\098\082\051\127\068\060\008\082\115\123\093\082\068\127\026\082\042\123\020\082\012\123\068\113\017\060\020\060\082\020\043\050\098\082\012\127\106\020\106\050\083\051\060\082\050\042\082\020\043\060\082\060\068\093\017\127\020\123\106\082\068\123\083\060\008\082\024\082\043\123\113\060\082\026\123\093\082\110\050\017\017\082\051\060\020\082\020\123\082\113\017\127\026\082\050\020\082\031\123\106\082\106\060\127\017\082\098\123\068\060\083\127\026\008\082")
		}
		_QHnVm.Commands._WzZ.Enabled = false
		_QHnVm.Commands.__fTx.Enabled = false
		Wherigo.Command "SaveClose"
	else
		_QHnVm:MoveTo(Player)
		_Urwigo.MessageBox{
			Text = _JWJ("\115\123\093\082\042\060\060\083\082\020\123\082\106\060\127\083\082\127\042\083\082\106\060\054\050\060\110\082\026\123\093\082\068\050\098\098\050\123\042\082\123\106\083\060\106\098\112\082"), 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.MessageBox{
						Text = _JWJ("\053\127\036\060\082\098\093\106\060\082\026\123\093\082\031\123\017\017\123\110\082\020\043\060\082\050\042\098\020\106\012\020\050\123\042\098\082\020\043\060\106\060\082\127\042\083\082\111\060\082\098\127\031\060\082\127\020\082\020\043\060\082\065\022\008")
					}
					_QHnVm.Commands.__fTx.Enabled = true
					_QHnVm.Commands.__fTx.Enabled = true
					_QHnVm.Commands._WzZ.Enabled = false
				end
			end
		}
	end
	_CqAeZ:RequestSync()
end
function _QHnVm:On__fTx(target)
	_Urwigo.MessageBox{
		Text = _JWJ("\073\123\082\042\123\110\082\026\123\093\106\082\098\012\123\093\020\050\042\051\082\123\031\082\020\043\060\082\127\106\060\127\082\050\098\082\083\123\042\060\082\127\042\083\082\050\020\082\050\098\082\020\050\068\060\082\031\123\106\082\026\123\093\106\082\123\110\042\082\068\050\098\098\050\123\042\008"), 
		Callback = function(action)
			if action ~= nil then
				_Urwigo.MessageBox{
					Text = _JWJ("\115\123\093\082\110\050\017\017\082\111\060\082\060\042\020\060\106\050\042\051\082\073\020\127\020\060\082\065\127\068\060\082\040\127\042\083\098\082\113\106\123\113\060\106\020\026\082\098\123\082\111\060\082\098\093\106\060\082\020\123\082\110\060\127\106\082\123\106\127\042\051\060\082\083\093\106\050\042\051\082\043\093\042\020\050\042\051\082\098\060\127\098\123\042\008\082\115\123\093\082\110\050\017\017\082\127\017\098\123\082\111\060\082\060\042\020\060\106\050\042\051\082\087\017\127\050\042\031\050\060\017\083\082\107\123\110\042\098\043\050\113\008\082"), 
					Callback = function(action)
						if action ~= nil then
							_Urwigo.MessageBox{
								Text = _JWJ("\027\060\017\050\060\054\060\082\050\020\082\123\106\082\042\123\020\082\113\060\123\113\017\060\082\083\123\082\017\050\054\060\082\110\127\026\082\111\127\012\036\082\043\060\106\060\082\127\042\083\082\042\060\060\083\082\127\012\012\060\098\098\082\020\123\082\020\043\060\050\106\082\043\123\068\060\098\039\082\098\123\082\113\017\060\127\098\060\082\093\098\060\082\020\043\060\082\098\068\127\017\017\082\113\093\017\017\082\123\031\031\082\127\082\098\043\123\106\020\082\043\050\036\060\082\111\060\031\123\106\060\082\026\123\093\082\106\060\127\012\043\082\020\043\060\082\065\022\082\123\106\082\113\127\106\036\082\123\031\031\082\020\123\082\020\043\060\082\098\050\083\060\082\111\026\082\020\043\060\082\113\123\110\060\106\082\017\050\042\060\082\020\123\110\060\106\082\068\093\012\043\082\012\017\123\098\060\106\082\020\123\082\020\043\060\082\065\022\008\082\057\062\082\097\062\107\082\027\040\062\085\016\082\107\007\032\082\092\062\003\057\112"), 
								Callback = function(action)
									if action ~= nil then
										_Urwigo.MessageBox{
											Text = _JWJ("\115\123\093\106\082\068\050\098\098\050\123\042\082\050\098\082\020\123\082\113\106\123\012\060\060\083\082\020\123\082\097\096\041\082\120\041\008\074\074\120\082\034\060\098\020\082\041\046\120\082\086\069\008\120\096\074"), 
											Callback = function(action)
												if action ~= nil then
													_Urwigo.MessageBox{
														Text = _JWJ("\107\043\060\106\060\082\026\123\093\082\110\050\017\017\082\111\060\082\017\123\123\036\050\042\051\082\031\123\106\082\127\082\012\127\068\123\013\083\082\017\123\012\036\082\042\082\017\123\012\036\082\012\123\042\020\127\050\042\060\106\112\082\028\050\042\083\082\050\020\082\127\042\083\082\098\050\051\042\082\020\043\060\082\017\123\051\008"), 
														Callback = function(action)
															if action ~= nil then
																_Urwigo.MessageBox{
																	Text = _JWJ("\027\060\082\098\093\106\060\082\020\123\082\106\060\020\093\106\042\082\050\020\082\098\127\031\060\017\026\082\020\123\082\050\020\013\098\082\043\123\068\060\008"), 
																	Callback = function(action)
																		if action ~= nil then
																			_Urwigo.MessageBox{
																				Text = _JWJ("\062\042\012\060\082\083\123\042\060\082\111\060\082\098\093\106\060\082\020\123\082\017\123\051\082\020\043\050\098\082\111\123\020\043\082\123\042\082\051\060\123\012\127\012\043\050\042\051\082\127\042\083\082\020\043\060\082\110\043\060\106\050\051\123\082\098\050\020\060\008\082\107\043\060\106\060\082\026\123\093\082\110\050\017\017\082\093\098\060\082\020\043\060\082\012\123\068\113\017\060\020\050\123\042\082\012\123\083\060\082\020\123\082\098\043\123\110\082\020\043\060\082\012\127\106\020\106\050\083\051\060\082\127\098\082\083\123\042\060\039\082\017\123\051\082\026\123\093\106\082\031\050\042\083\082\127\042\083\082\106\127\020\060\082\020\043\060\082\051\127\068\060\112"), 
																				Callback = function(action)
																					if action ~= nil then
																						_Urwigo.MessageBox{
																							Text = _JWJ("\107\043\127\042\036\098\082\127\042\083\082\051\060\020\082\051\123\050\042\051\082\020\123\082\096\041\082\120\041\008\074\074\120\082\041\046\120\082\086\069\008\120\096\074"), 
																							Callback = function(action)
																								if action ~= nil then
																									_QHnVm.Commands._j1oMr.Enabled = true
																									_IMIhL:MoveTo(Player)
																									_IMIhL.Visible = true
																									_CqAeZ.Complete = false
																									_CqAeZ:RequestSync()
																								end
																							end
																						}
																					end
																				end
																			}
																		end
																	end
																}
															end
														end
													}
												end
											end
										}
									end
								end
							}
						end
					end
				}
			end
		end
	}
end
function _QHnVm:On_j1oMr(target)
	_Urwigo.MessageBox{
		Text = _JWJ("\024\042\082\020\043\060\082\051\127\068\060\082\017\127\042\083\098\082\098\123\082\110\060\127\106\082\123\106\127\042\051\060\082\083\093\106\050\042\051\082\043\093\042\020\050\042\051\082\020\050\068\060\098\008\124\027\092\108\087\127\106\036\082\123\031\031\082\020\043\060\082\106\123\127\083\082\042\060\127\106\082\020\043\060\082\113\123\110\060\106\082\017\050\042\060\082\113\123\017\060\082\123\106\082\050\042\082\020\043\060\082\113\093\017\017\082\123\031\031\082\127\082\098\043\123\106\020\082\043\050\036\060\082\111\060\031\123\106\060\082\020\043\060\082\012\127\012\043\060\008\124\027\092\108\040\123\012\127\020\060\083\082\111\060\020\110\060\060\042\082\127\082\106\123\012\036\082\127\042\083\082\127\082\020\106\060\060\008")
	}
	_CqAeZ:RequestSync()
end

-- Begin user functions --
-- End Urwigo functions --
-- End user functions --
return _CqAeZ
