require "Wherigo"
ZonePoint = Wherigo.ZonePoint
Distance = Wherigo.Distance
Player = Wherigo.Player

-- #Author Directives Go Here# --
-- #End Author Directives# --

cartSnakes = Wherigo.ZCartridge()

-- MessageBox Callback Functions Table used by the Builder --
cartSnakes.MsgBoxCBFuncs = {}

zmediaForesterHouse = Wherigo.ZMedia(cartSnakes)
zmediaForesterHouse.Name="ForesterHouse"
zmediaForesterHouse.Description="A simple wooden and thatch construction, with outbuildings, a camp fire and lots of other wooden stuff. "
zmediaForesterHouse.AltText=""
zmediaForesterHouse.Id="bca301fa-95d4-46b7-9510-bada1ce36e08"
zmediaForesterHouse.Resources = {
{ Type = "jpg", Filename = "ForesterHouse_all.jpg", Directives = {},},
}
zmediaCartridgePicture = Wherigo.ZMedia(cartSnakes)
zmediaCartridgePicture.Name="CartridgePicture"
zmediaCartridgePicture.Description=""
zmediaCartridgePicture.AltText=""
zmediaCartridgePicture.Id="041fd04d-7edf-4adb-9d70-7ecc927dac69"
zmediaCartridgePicture.Resources = {
{ Type = "jpg", Filename = "Cartridge_all.jpg", Directives = {},},
}
zmediaForester = Wherigo.ZMedia(cartSnakes)
zmediaForester.Name="Forester"
zmediaForester.Description="A lonely looking forester."
zmediaForester.AltText=""
zmediaForester.Id="a764c856-c405-46c3-80ab-edad1aedfcac"
zmediaForester.Resources = {
{ Type = "jpg", Filename = "Forester_garmin.jpg", Directives = {},},
{ Type = "jpg", Filename = "Forester_ppc.jpg", Directives = {},},
}
zmediaSnakePic = Wherigo.ZMedia(cartSnakes)
zmediaSnakePic.Name="SnakePic"
zmediaSnakePic.Description="A green and yellow snake with some huge fangs.  Best avoid them if you can."
zmediaSnakePic.AltText=""
zmediaSnakePic.Id="1e2fb2ac-fa1c-4a69-9ea4-7e119f7735b4"
zmediaSnakePic.Resources = {
{ Type = "jpg", Filename = "Snake_garmin.jpg", Directives = {},},
{ Type = "jpg", Filename = "Snake_ppc.jpg", Directives = {},},
}
zmediaSnakeBite = Wherigo.ZMedia(cartSnakes)
zmediaSnakeBite.Name="SnakeBite"
zmediaSnakeBite.Description="You have just been bitten.  You feel the venom taking affect with in seconds and you collapse and fall to the ground."
zmediaSnakeBite.AltText=""
zmediaSnakeBite.Id="32c1634e-838d-4504-a663-b0ef8bb7cf99"
zmediaSnakeBite.Resources = {
{ Type = "jpg", Filename = "SnakeBite_garmin.jpg", Directives = {},},
{ Type = "jpg", Filename = "SnakeBite_ppc.jpg", Directives = {},},
}
zmediaForest = Wherigo.ZMedia(cartSnakes)
zmediaForest.Name="Forest"
zmediaForest.Description="Lots of trees"
zmediaForest.AltText=""
zmediaForest.Id="77147cdd-1e3b-4708-931e-3ac9741b911d"
zmediaForest.Resources = {
{ Type = "jpg", Filename = "Forest_all.jpg", Directives = {},},
}
zmediaicon = Wherigo.ZMedia(cartSnakes)
zmediaicon.Name="icon"
zmediaicon.Description=""
zmediaicon.AltText=""
zmediaicon.Id="a293d4e1-3cef-4930-a202-b4e4775410ab"
zmediaicon.Resources = {
{ Type = "jpg", Filename = "icon.jpg", Directives = {},},
}
zmediaPot = Wherigo.ZMedia(cartSnakes)
zmediaPot.Name="Pot"
zmediaPot.Description="A pot full of black stuff. "
zmediaPot.AltText=""
zmediaPot.Id="4bd24889-e52c-453a-aa17-c365dab36482"
zmediaPot.Resources = {
{ Type = "jpg", Filename = "pot_garmin.jpg", Directives = {},},
{ Type = "jpg", Filename = "pot_ppc.jpg", Directives = {},},
}
zmediaStickFire = Wherigo.ZMedia(cartSnakes)
zmediaStickFire.Name="StickFire"
zmediaStickFire.Description="A burning stick"
zmediaStickFire.AltText=""
zmediaStickFire.Id="d4be16fa-80b8-48eb-9774-7e923004380d"
zmediaStickFire.Resources = {
{ Type = "jpg", Filename = "StickFire_garmin.jpg", Directives = {},},
{ Type = "jpg", Filename = "StickFire_ppc.jpg", Directives = {},},
}
zmediaStick = Wherigo.ZMedia(cartSnakes)
zmediaStick.Name="Stick"
zmediaStick.Description="It reminds you of the joke what is brown and Sticky"
zmediaStick.AltText=""
zmediaStick.Id="334291e4-752f-4228-9caf-baee90410a49"
zmediaStick.Resources = {
{ Type = "jpg", Filename = "StickNormal_garmin.jpg", Directives = {},},
{ Type = "jpg", Filename = "StickNormal_ppc.jpg", Directives = {},},
}
zmediaStickTar = Wherigo.ZMedia(cartSnakes)
zmediaStickTar.Name="StickTar"
zmediaStickTar.Description="Horrible looking black stuff covers the end of the stick"
zmediaStickTar.AltText=""
zmediaStickTar.Id="2fade4f6-b1ba-40a6-89db-56404c8343c2"
zmediaStickTar.Resources = {
{ Type = "jpg", Filename = "StickTar_garmin.jpg", Directives = {},},
{ Type = "jpg", Filename = "StickTar_ppc.jpg", Directives = {},},
}
zmediaForestersHomeFire = Wherigo.ZMedia(cartSnakes)
zmediaForestersHomeFire.Name="ForestersHomeFire"
zmediaForestersHomeFire.Description=""
zmediaForestersHomeFire.AltText=""
zmediaForestersHomeFire.Id="86e95d74-c82f-4713-8d29-6d8392d569c7"
zmediaForestersHomeFire.Resources = {
{ Type = "jpg", Filename = "ForesterHomeFire_garmin.jpg", Directives = {},},
{ Type = "jpg", Filename = "ForesterHomeFire_ppc.jpg", Directives = {},},
}
zmediaForesterWalking = Wherigo.ZMedia(cartSnakes)
zmediaForesterWalking.Name="ForesterWalking"
zmediaForesterWalking.Description=""
zmediaForesterWalking.AltText=""
zmediaForesterWalking.Id="1ca5b173-1536-4ca9-8997-937b0da8d24d"
zmediaForesterWalking.Resources = {
{ Type = "jpg", Filename = "ForesterWalking_garmin.jpg", Directives = {},},
{ Type = "jpg", Filename = "ForesterWalking_ppc.jpg", Directives = {},},
}
zmediaForesterHappy = Wherigo.ZMedia(cartSnakes)
zmediaForesterHappy.Name="ForesterHappy"
zmediaForesterHappy.Description=""
zmediaForesterHappy.AltText=""
zmediaForesterHappy.Id="fad926e0-cac7-478c-a3ed-a575414d594d"
zmediaForesterHappy.Resources = {
{ Type = "jpg", Filename = "ForesterHappy_garmin.jpg", Directives = {},},
{ Type = "jpg", Filename = "ForesterHappy_ppc.jpg", Directives = {},},
}
zmediaForestSmoke = Wherigo.ZMedia(cartSnakes)
zmediaForestSmoke.Name="ForestSmoke"
zmediaForestSmoke.Description=""
zmediaForestSmoke.AltText=""
zmediaForestSmoke.Id="cfbf6e48-31b8-4351-92a6-e8f7076d39ed"
zmediaForestSmoke.Resources = {
{ Type = "jpg", Filename = "ForestSmoke_garmin.jpg", Directives = {},},
{ Type = "jpg", Filename = "ForestSmoke_ppc.jpg", Directives = {},},
}
zmediaAxe = Wherigo.ZMedia(cartSnakes)
zmediaAxe.Name="Axe"
zmediaAxe.Description="Yup, thats an axe alright. "
zmediaAxe.AltText=""
zmediaAxe.Id="1f76b5c2-87e3-465b-b494-62226387aebc"
zmediaAxe.Resources = {
{ Type = "jpg", Filename = "axe_garmin.jpg", Directives = {},},
{ Type = "jpg", Filename = "axe_ppc.jpg", Directives = {},},
}
zmediaLogs = Wherigo.ZMedia(cartSnakes)
zmediaLogs.Name="Logs"
zmediaLogs.Description="At some point, these will make a great campfire. You seem to have a mix of oak, ash and a bit of holly wood thrown in for good measure. "
zmediaLogs.AltText=""
zmediaLogs.Id="462d6fe5-f89a-476d-aafa-1ace194df31c"
zmediaLogs.Resources = {
{ Type = "jpg", Filename = "logs_garmin.jpg", Directives = {},},
{ Type = "jpg", Filename = "logs_ppc.jpg", Directives = {},},
}
zmediaCampfireUnlit = Wherigo.ZMedia(cartSnakes)
zmediaCampfireUnlit.Name="CampfireUnlit"
zmediaCampfireUnlit.Description=""
zmediaCampfireUnlit.AltText=""
zmediaCampfireUnlit.Id="bf914d2e-2d74-47fe-9910-47ebbffffe28"
zmediaCampfireUnlit.Resources = {
{ Type = "jpg", Filename = "CampfireUnLit_garmin.jpg", Directives = {},},
{ Type = "jpg", Filename = "CampfireUnLit_ppc.jpg", Directives = {},},
}
zmediaWoodpile = Wherigo.ZMedia(cartSnakes)
zmediaWoodpile.Name="Woodpile"
zmediaWoodpile.Description=""
zmediaWoodpile.AltText=""
zmediaWoodpile.Id="dc5d5d04-4f3b-44ed-9d61-50ac0912bda4"
zmediaWoodpile.Resources = {
{ Type = "jpg", Filename = "woodpile_garmin.jpg", Directives = {},},
{ Type = "jpg", Filename = "woodpile_ppc.jpg", Directives = {},},
}
zmediaGeocaching = Wherigo.ZMedia(cartSnakes)
zmediaGeocaching.Name="Geocaching"
zmediaGeocaching.Description=""
zmediaGeocaching.AltText=""
zmediaGeocaching.Id="4bcc6e5b-ab97-4f75-9f08-f2d2553b1794"
zmediaGeocaching.Resources = {
{ Type = "jpg", Filename = "Geocache_garmin.jpg", Directives = {},},
{ Type = "jpg", Filename = "Geocache_ppc.jpg", Directives = {},},
}
zmediaEaten = Wherigo.ZMedia(cartSnakes)
zmediaEaten.Name="Eaten"
zmediaEaten.Description=""
zmediaEaten.AltText=""
zmediaEaten.Id="2e9fa2c0-dbe6-4d6e-88cd-4acfd87a3af3"
zmediaEaten.Resources = {
{ Type = "jpg", Filename = "Eaten_garmin.jpg", Directives = {},},
{ Type = "jpg", Filename = "Eaten_ppc.jpg", Directives = {},},
}
zmediaAmmonite = Wherigo.ZMedia(cartSnakes)
zmediaAmmonite.Name="Ammonite"
zmediaAmmonite.Description=""
zmediaAmmonite.AltText=""
zmediaAmmonite.Id="878f89e9-4a37-4968-9b3d-e55472e5cd15"
zmediaAmmonite.Resources = {
{ Type = "jpg", Filename = "Ammonite_garmin.jpg", Directives = {},},
{ Type = "jpg", Filename = "Ammonite_ppc.jpg", Directives = {},},
}
zmediastart = Wherigo.ZMedia(cartSnakes)
zmediastart.Name="start"
zmediastart.Description=""
zmediastart.AltText=""
zmediastart.Id="74af4e1e-e164-4d1a-8476-4213a55b9e4d"
zmediastart.Resources = {
{ Type = "jpg", Filename = "Start_garmin.jpg", Directives = {},},
{ Type = "jpg", Filename = "Start_ppc.jpg", Directives = {},},
}
zmediaCampfireLit = Wherigo.ZMedia(cartSnakes)
zmediaCampfireLit.Name="CampfireLit"
zmediaCampfireLit.Description=""
zmediaCampfireLit.AltText=""
zmediaCampfireLit.Id="216c409d-950f-4567-9c5a-c319b7814402"
zmediaCampfireLit.Resources = {
{ Type = "jpg", Filename = "CampfireLit_garmin.jpg", Directives = {},},
{ Type = "jpg", Filename = "CampfireLit_ppc.jpg", Directives = {},},
}
zmediaBeep = Wherigo.ZMedia(cartSnakes)
zmediaBeep.Name="Beep"
zmediaBeep.Description=""
zmediaBeep.AltText=""
zmediaBeep.Id="b4bcd869-a44b-4bfa-abec-9485afd57afc"
zmediaBeep.Resources = {
{ Type = "fdl", Filename = "Beep.fdl", Directives = {},},
}
zmediaSammy = Wherigo.ZMedia(cartSnakes)
zmediaSammy.Name="Sammy"
zmediaSammy.Description="A friendly looking red and yellow snake"
zmediaSammy.AltText=""
zmediaSammy.Id="1ee4b4df-7364-4174-ada5-ef71a7daa765"
zmediaSammy.Resources = {
{ Type = "jpg", Filename = "SnakeFriendly_garmin.jpg", Directives = {},},
{ Type = "jpg", Filename = "SnakeFriendly_ppc.jpg", Directives = {},},
}
zmediaIconAmmonite = Wherigo.ZMedia(cartSnakes)
zmediaIconAmmonite.Name="IconAmmonite"
zmediaIconAmmonite.Description=""
zmediaIconAmmonite.AltText=""
zmediaIconAmmonite.Id="57c8f808-de0d-4cf1-b768-ab88e4c114c2"
zmediaIconAmmonite.Resources = {
{ Type = "jpg", Filename = "Ammonite_ico.jpg", Directives = {},},
}
zmediaIconAxe = Wherigo.ZMedia(cartSnakes)
zmediaIconAxe.Name="IconAxe"
zmediaIconAxe.Description=""
zmediaIconAxe.AltText=""
zmediaIconAxe.Id="638e7907-1ff4-411b-a35d-4f8fefc05304"
zmediaIconAxe.Resources = {
{ Type = "jpg", Filename = "axe_ico.jpg", Directives = {},},
}
zmediaIconCampfireLit = Wherigo.ZMedia(cartSnakes)
zmediaIconCampfireLit.Name="IconCampfireLit"
zmediaIconCampfireLit.Description=""
zmediaIconCampfireLit.AltText=""
zmediaIconCampfireLit.Id="520c0c8e-10b7-4ba5-8d09-490700394c4d"
zmediaIconCampfireLit.Resources = {
{ Type = "jpg", Filename = "CampfireLit_ico.jpg", Directives = {},},
}
zmediaIconCampfireUnlight = Wherigo.ZMedia(cartSnakes)
zmediaIconCampfireUnlight.Name="IconCampfireUnlight"
zmediaIconCampfireUnlight.Description=""
zmediaIconCampfireUnlight.AltText=""
zmediaIconCampfireUnlight.Id="c9beb122-060e-4006-822c-82ef535e5f12"
zmediaIconCampfireUnlight.Resources = {
{ Type = "jpg", Filename = "CampfireUnLit_ico.jpg", Directives = {},},
}
zmediaIconForester = Wherigo.ZMedia(cartSnakes)
zmediaIconForester.Name="IconForester"
zmediaIconForester.Description=""
zmediaIconForester.AltText=""
zmediaIconForester.Id="00d9d727-a154-41d5-a300-1c9dc40dd621"
zmediaIconForester.Resources = {
{ Type = "jpg", Filename = "ForesterHappy_ico.jpg", Directives = {},},
}
zmediaIconGeocache = Wherigo.ZMedia(cartSnakes)
zmediaIconGeocache.Name="IconGeocache"
zmediaIconGeocache.Description=""
zmediaIconGeocache.AltText=""
zmediaIconGeocache.Id="4ee7ff8f-fe52-4e18-8542-eda4fe549a29"
zmediaIconGeocache.Resources = {
{ Type = "jpg", Filename = "Geocache_ico.jpg", Directives = {},},
}
zmediaIconSnake = Wherigo.ZMedia(cartSnakes)
zmediaIconSnake.Name="IconSnake"
zmediaIconSnake.Description=""
zmediaIconSnake.AltText=""
zmediaIconSnake.Id="9652c188-dcba-4fe1-a196-f9ebe89cec88"
zmediaIconSnake.Resources = {
{ Type = "jpg", Filename = "Snake_ico.jpg", Directives = {},},
}
zmediaiconStick = Wherigo.ZMedia(cartSnakes)
zmediaiconStick.Name="iconStick"
zmediaiconStick.Description=""
zmediaiconStick.AltText=""
zmediaiconStick.Id="d78b3846-d688-4b86-8ccc-5c23fe868fb2"
zmediaiconStick.Resources = {
{ Type = "jpg", Filename = "StickNormal_ico.jpg", Directives = {},},
}
zmediaIconFriendlySnake = Wherigo.ZMedia(cartSnakes)
zmediaIconFriendlySnake.Name="IconFriendlySnake"
zmediaIconFriendlySnake.Description=""
zmediaIconFriendlySnake.AltText=""
zmediaIconFriendlySnake.Id="ab69c9e0-771d-4b8f-9911-91d04c5611ca"
zmediaIconFriendlySnake.Resources = {
{ Type = "jpg", Filename = "SnakeFriendly_ico.jpg", Directives = {},},
}
zmediaIconPot = Wherigo.ZMedia(cartSnakes)
zmediaIconPot.Name="IconPot"
zmediaIconPot.Description=""
zmediaIconPot.AltText=""
zmediaIconPot.Id="e20b87a2-0a70-4c1e-81c7-80afe69bd105"
zmediaIconPot.Resources = {
{ Type = "jpg", Filename = "pot_ico.jpg", Directives = {},},
}
zmediaIconLogs = Wherigo.ZMedia(cartSnakes)
zmediaIconLogs.Name="IconLogs"
zmediaIconLogs.Description=""
zmediaIconLogs.AltText=""
zmediaIconLogs.Id="7382eca1-f03f-4ecd-9b96-5f40511a3feb"
zmediaIconLogs.Resources = {
{ Type = "jpg", Filename = "logs_ico.jpg", Directives = {},},
}
zmediaIconForesterHouse = Wherigo.ZMedia(cartSnakes)
zmediaIconForesterHouse.Name="IconForesterHouse"
zmediaIconForesterHouse.Description=""
zmediaIconForesterHouse.AltText=""
zmediaIconForesterHouse.Id="579316f1-710e-4ecf-874c-fe2630a2054e"
zmediaIconForesterHouse.Resources = {
{ Type = "jpg", Filename = "ForesterHouse_ico.jpg", Directives = {},},
}
zmediaIconForesterHomeFire = Wherigo.ZMedia(cartSnakes)
zmediaIconForesterHomeFire.Name="IconForesterHomeFire"
zmediaIconForesterHomeFire.Description=""
zmediaIconForesterHomeFire.AltText=""
zmediaIconForesterHomeFire.Id="a7f860b5-ebfb-4e74-a6a2-b2aad27ac2d5"
zmediaIconForesterHomeFire.Resources = {
{ Type = "jpg", Filename = "ForesterHomeFire_ico.jpg", Directives = {},},
}
zmediaIconWoodpile = Wherigo.ZMedia(cartSnakes)
zmediaIconWoodpile.Name="IconWoodpile"
zmediaIconWoodpile.Description=""
zmediaIconWoodpile.AltText=""
zmediaIconWoodpile.Id="d115c149-a5eb-425c-b96f-6cdaed3aaf7d"
zmediaIconWoodpile.Resources = {
{ Type = "jpg", Filename = "woodpile_ico.jpg", Directives = {},},
}
-- Cartridge Info --
cartSnakes.Id="ea623ab7-e352-4983-a3e6-d61b0eab877a"
cartSnakes.Name="Snakes!!!"
cartSnakes.Description=[[Legend has it that St Keyna was a princess who came to a Saxon town as a Welsh Missionary and asked to be allowed to build a cell in the nearby woods. The local chief tried to discourage Keyna by telling her that the wood was infested with snakes, but Keyna would not be dissuaded. Some time later at her cell in the woods, Keyna showed the chief some ammonites and told him that they were the snakes he had warned her about. St Keyna had turned the serpents to stone and made the woods safe, hence Keynsham (Keyna's ham  (ham is an old english name for town)).

This Wherigo is an interpretation of the legend where you play the part of Keyna. All you need to do is go to the center of the woods and select a good place to build your cell (home).  As it happens, this is also where the geocache is located.

Sounds easy, it might be even easier than you think as the woods around Keynsham are not as large as they used to be.  The wood where this Wherigo is set was planted in 2000 and is only a small area, so things are a bit crammed into a small space.  The good news is you only need to get to less than 250m from the starting point.  The bad news is there are snakes. Lots of snakes.  They will bite if you get too close, or they get too close to you, and their bite is fatal.  

Any problems please report them and we will see if I can sort them out for you.

Have fun
ASnail & MyriadGreen

]]
cartSnakes.Visible=true
cartSnakes.Activity="Geocache"
cartSnakes.StartingLocationDescription=[[Start location is at the end of an alley leading from a road called "The Brambles".]]
cartSnakes.StartingLocation = ZonePoint(51.4057,-2.5078,0)
cartSnakes.Version="0.3"
cartSnakes.Company=""
cartSnakes.Author="A Snail & Myriad Green"
cartSnakes.BuilderVersion="2.0.5129.5086"
cartSnakes.CreateDate="1/31/2009 4:40:57 PM"
cartSnakes.PublishDate="1/1/0001 12:00:00 AM"
cartSnakes.UpdateDate="3/18/2009 5:59:05 PM"
cartSnakes.LastPlayedDate="1/1/0001 12:00:00 AM"
cartSnakes.TargetDevice="PocketPC"
cartSnakes.TargetDeviceVersion="0"
cartSnakes.StateId="1"
cartSnakes.CountryId="2"
cartSnakes.Complete=false
cartSnakes.UseLogging=false
cartSnakes.Media=zmediaCartridgePicture
cartSnakes.Icon=zmediaicon

-- Zones --
zoneMiddleoftheForest = Wherigo.Zone(cartSnakes)
zoneMiddleoftheForest.Id="8effc6ed-9cdb-411c-ab7c-5dc353aa8680"
zoneMiddleoftheForest.Name="Middle of the Forest"
zoneMiddleoftheForest.Description=[[You have been told there is a clearing in the middle of the forest.  This would be an ideal place to build a new cell (home).]]
zoneMiddleoftheForest.Visible=true
zoneMiddleoftheForest.DistanceRange = Distance(-1, "feet")
zoneMiddleoftheForest.ShowObjects="Always"
zoneMiddleoftheForest.ProximityRange = Distance(200, "meters")
zoneMiddleoftheForest.AllowSetPositionTo=false
zoneMiddleoftheForest.Active=false
zoneMiddleoftheForest.Points = {
  ZonePoint(51.40407,-2.51047,0),
  ZonePoint(51.40405,-2.51029,0),
  ZonePoint(51.40398,-2.51029,0),
  ZonePoint(51.40398,-2.51047,0)
}
zoneMiddleoftheForest.OriginalPoint = ZonePoint(51.404,-2.51039,0)
zoneMiddleoftheForest.DistanceRangeUOM = "Feet"
zoneMiddleoftheForest.ProximityRangeUOM = "Meters"
zoneMiddleoftheForest.OutOfRangeName = ""
zoneMiddleoftheForest.InRangeName = ""
zoneMiddleoftheForest.Media=zmediaForest

zoneForestersHome = Wherigo.Zone(cartSnakes)
zoneForestersHome.Id="51b741db-ac66-4955-bf12-97e15815139a"
zoneForestersHome.Name="Foresters Home"
zoneForestersHome.Description=[[]]
zoneForestersHome.Visible=false
zoneForestersHome.DistanceRange = Distance(1500, "feet")
zoneForestersHome.ShowObjects="OnEnter"
zoneForestersHome.ProximityRange = Distance(200, "feet")
zoneForestersHome.AllowSetPositionTo=false
zoneForestersHome.Active=true
zoneForestersHome.Points = {
  ZonePoint(51.40215,-2.50875,0),
  ZonePoint(51.40215,-2.50848,0),
  ZonePoint(51.40202,-2.50848,0),
  ZonePoint(51.402,-2.50877,0)
}
zoneForestersHome.OriginalPoint = ZonePoint(51.40208496,-2.508546,0)
zoneForestersHome.DistanceRangeUOM = "Feet"
zoneForestersHome.ProximityRangeUOM = "Feet"
zoneForestersHome.OutOfRangeName = ""
zoneForestersHome.InRangeName = ""
zoneForestersHome.Media=zmediaForesterHouse

zoneSmoke = Wherigo.Zone(cartSnakes)
zoneSmoke.Id="659e5841-a8f7-46e1-8ff6-ccbaecb1c74a"
zoneSmoke.Name="Smoke"
zoneSmoke.Description=[[A thin wispy plume of smoke rises up through the forest.]]
zoneSmoke.Visible=true
zoneSmoke.DistanceRange = Distance(1500, "feet")
zoneSmoke.ShowObjects="Never"
zoneSmoke.ProximityRange = Distance(200, "feet")
zoneSmoke.AllowSetPositionTo=false
zoneSmoke.Active=false
zoneSmoke.Points = {
  ZonePoint(51.4032,-2.50846,0),
  ZonePoint(51.4032,-2.50846,0),
  ZonePoint(51.4032,-2.50846,0),
  ZonePoint(51.4032,-2.50846,0)
}
zoneSmoke.OriginalPoint = ZonePoint(51.4032,-2.50846,0)
zoneSmoke.DistanceRangeUOM = "Feet"
zoneSmoke.ProximityRangeUOM = "Feet"
zoneSmoke.OutOfRangeName = ""
zoneSmoke.InRangeName = ""
zoneSmoke.Media=zmediaForestSmoke

zoneStart = Wherigo.Zone(cartSnakes)
zoneStart.Id="5aa6bd31-13bf-4c3d-aaa3-1bef0f901c14"
zoneStart.Name="Start"
zoneStart.Description=[[The starting location is next to a kissing gate at the end of a small alley leading from The Brambles road.  Parking space is probably available at the start of The Brambles Road.]]
zoneStart.Visible=true
zoneStart.DistanceRange = Distance(-1, "feet")
zoneStart.ShowObjects="OnEnter"
zoneStart.ProximityRange = Distance(-1, "feet")
zoneStart.AllowSetPositionTo=false
zoneStart.Active=true
zoneStart.Points = {
  ZonePoint(51.40475,-2.50843,0),
  ZonePoint(51.40475,-2.50815,0),
  ZonePoint(51.40463,-2.50815,0),
  ZonePoint(51.40463,-2.50843,0)
}
zoneStart.OriginalPoint = ZonePoint(51.40469,-2.508327,0)
zoneStart.DistanceRangeUOM = "Feet"
zoneStart.ProximityRangeUOM = "Feet"
zoneStart.OutOfRangeName = ""
zoneStart.InRangeName = ""
zoneStart.Media=zmediastart

zonePetZone = Wherigo.Zone(cartSnakes)
zonePetZone.Id="ea6df8b0-894f-4e47-9868-f3f2318f98c5"
zonePetZone.Name="PetZone"
zonePetZone.Description=[[]]
zonePetZone.Visible=false
zonePetZone.DistanceRange = Distance(-1, "feet")
zonePetZone.ShowObjects="Always"
zonePetZone.ProximityRange = Distance(-1, "feet")
zonePetZone.AllowSetPositionTo=false
zonePetZone.Active=false
zonePetZone.Points = {
  ZonePoint(51.00001,-2.00002,0),
  ZonePoint(51.00001,-1.99998,0),
  ZonePoint(50.99999,-1.99998,0),
  ZonePoint(50.99999,-2.00002,0)
}
zonePetZone.OriginalPoint = ZonePoint(51,-2,0)
zonePetZone.DistanceRangeUOM = "Feet"
zonePetZone.ProximityRangeUOM = "Feet"
zonePetZone.OutOfRangeName = ""
zonePetZone.InRangeName = ""

zonePetrifiedSnake = Wherigo.Zone(cartSnakes)
zonePetrifiedSnake.Id="662a11cb-deee-460d-8b5b-4f27712ba325"
zonePetrifiedSnake.Name="Petrified Snake"
zonePetrifiedSnake.Description=[[Quote from the Woodland Trust about this sculpture:  

"The first problem that we had was to find someone to make it. It was decided that the best material for a six foot ammonite would be concrete. This can be molded and would withstand both time and the elements. After approaching many concrete manufacturers, the ones that didn't stare in disbelief, suggested that if we could find somebody to make a mold, this could be cast with approximately two tons of concrete. Another quest then ensued to find how to make a mold. One of the numerous people approached was Carol Peace, and artist working from the Sculpture Shed in Bristol, who turned out to be ideal. Not only had she worked on this scale before, but also worked in concrete. Carol proposed to make a clay mold and then to cast the piece on-site, thus overcoming a rather large transport problem."]]
zonePetrifiedSnake.Visible=true
zonePetrifiedSnake.DistanceRange = Distance(-1, "feet")
zonePetrifiedSnake.ShowObjects="Always"
zonePetrifiedSnake.ProximityRange = Distance(-1, "feet")
zonePetrifiedSnake.AllowSetPositionTo=false
zonePetrifiedSnake.Active=false
zonePetrifiedSnake.Points = {
  ZonePoint(51.40342,-2.51056,0),
  ZonePoint(51.40342,-2.51044,0),
  ZonePoint(51.40335,-2.51044,0),
  ZonePoint(51.40335,-2.51056,0)
}
zonePetrifiedSnake.OriginalPoint = ZonePoint(51.40337004,-2.51055534,0)
zonePetrifiedSnake.DistanceRangeUOM = "Feet"
zonePetrifiedSnake.ProximityRangeUOM = "Feet"
zonePetrifiedSnake.OutOfRangeName = ""
zonePetrifiedSnake.InRangeName = ""
zonePetrifiedSnake.Media=zmediaAmmonite

-- Characters --
zcharacterSnake1 = Wherigo.ZCharacter{Cartridge=cartSnakes, Container=zoneMiddleoftheForest}
zcharacterSnake1.Id="a2e6ab2f-7fdb-4c39-852a-8c1965d7d5bd"
zcharacterSnake1.Name="Snake1"
zcharacterSnake1.Description=[[A green and yellow snake hisses at you.  Those fangs look dangourous, and the venom is probably worse.]]
zcharacterSnake1.Visible=true
zcharacterSnake1.Media=zmediaSnakePic
zcharacterSnake1.Icon=zmediaIconSnake
zcharacterSnake1.Gender="It"
zcharacterSnake1.Type="NPC"
zcharacterSnake1.ObjectLocation = ZonePoint(51.4040020410531,-2.51039000497201,360)

zcharacterSnake2 = Wherigo.ZCharacter{Cartridge=cartSnakes, Container=zoneMiddleoftheForest}
zcharacterSnake2.Id="898207c3-126b-47b2-a7a5-c3dd2089a786"
zcharacterSnake2.Name="Snake2"
zcharacterSnake2.Description=[[A green and yellow snake hisses at you.  Those fangs look dangourous, and the venom is probably worse.]]
zcharacterSnake2.Visible=true
zcharacterSnake2.Media=zmediaSnakePic
zcharacterSnake2.Icon=zmediaIconSnake
zcharacterSnake2.Gender="It"
zcharacterSnake2.Type="NPC"
zcharacterSnake2.ObjectLocation = ZonePoint(51.4040020410531,-2.51039000497201,360)

zcharacterForester = Wherigo.ZCharacter{Cartridge=cartSnakes, Container=zoneMiddleoftheForest}
zcharacterForester.Id="8d55c925-f0c8-46b1-8533-b35a5ec34080"
zcharacterForester.Name="Forester"
zcharacterForester.Description=[[A sad looking forester.]]
zcharacterForester.Visible=true
zcharacterForester.Media=zmediaForester
zcharacterForester.Icon=zmediaIconForester
zcharacterForester.Gender="Male"
zcharacterForester.Type="NPC"
zcharacterForester.ObjectLocation = ZonePoint(51.4031999,-2.50847777,360)
zcharacterForester.Commands = {
  Hello = Wherigo.ZCommand{Text="Hello", CmdWith=false, Enabled=true, EmptyTargetListText="Nothing available"},
  Nicefire = Wherigo.ZCommand{Text="Nice fire", CmdWith=false, Enabled=false, EmptyTargetListText="Nothing available"},
  Whatsinthepot = Wherigo.ZCommand{Text="Whats in the pot", CmdWith=false, Enabled=false, EmptyTargetListText="Nothing available"},
}
zcharacterForester.Commands.Hello.Custom = true
zcharacterForester.Commands.Hello.Id="9844ef23-9b5b-46f5-97b0-9080d3d1412a"
zcharacterForester.Commands.Hello.WorksWithAll = true
zcharacterForester.Commands.Nicefire.Custom = true
zcharacterForester.Commands.Nicefire.Id="3fee4c8f-58d3-43ff-9f2d-0637f560a697"
zcharacterForester.Commands.Nicefire.WorksWithAll = true
zcharacterForester.Commands.Whatsinthepot.Custom = true
zcharacterForester.Commands.Whatsinthepot.Id="f4117a03-04ba-41e2-9724-9179376a154b"
zcharacterForester.Commands.Whatsinthepot.WorksWithAll = true

zcharacterSnake3 = Wherigo.ZCharacter{Cartridge=cartSnakes, Container=zoneMiddleoftheForest}
zcharacterSnake3.Id="4c337ad1-ae92-40ba-807a-4a6ddb00e4c3"
zcharacterSnake3.Name="Snake3"
zcharacterSnake3.Description=[[A green and yellow snake hisses at you.  Those fangs look dangourous, and the venom is probably worse.]]
zcharacterSnake3.Visible=false
zcharacterSnake3.Media=zmediaSnakePic
zcharacterSnake3.Icon=zmediaIconSnake
zcharacterSnake3.Gender="It"
zcharacterSnake3.Type="NPC"
zcharacterSnake3.ObjectLocation = ZonePoint(51.4040300791295,-2.51038000259642,360)

zcharacterSnake4 = Wherigo.ZCharacter{Cartridge=cartSnakes, Container=zoneMiddleoftheForest}
zcharacterSnake4.Id="2afbc131-84a0-4b98-a7d7-f92ff6e4be2e"
zcharacterSnake4.Name="Snake4"
zcharacterSnake4.Description=[[A green and yellow snake hisses at you.  Those fangs look dangourous, and the venom is probably worse.]]
zcharacterSnake4.Visible=false
zcharacterSnake4.Media=zmediaSnakePic
zcharacterSnake4.Icon=zmediaIconSnake
zcharacterSnake4.Gender="It"
zcharacterSnake4.Type="NPC"
zcharacterSnake4.ObjectLocation = ZonePoint(51.40403,-2.51038,0)

zcharacterSammy = Wherigo.ZCharacter{Cartridge=cartSnakes, Container=zonePetZone}
zcharacterSammy.Id="4f8cba1b-3f3e-4701-b9cc-081c50c02134"
zcharacterSammy.Name="Sammy"
zcharacterSammy.Description=[[A friendly looking Red and Yellow Snake]]
zcharacterSammy.Visible=true
zcharacterSammy.Media=zmediaSammy
zcharacterSammy.Icon=zmediaIconFriendlySnake
zcharacterSammy.Gender="Male"
zcharacterSammy.Type="NPC"
zcharacterSammy.ObjectLocation = ZonePoint(51.0000010836824,-2.0000000019767,360)

zcharacterSnake5 = Wherigo.ZCharacter{Cartridge=cartSnakes, Container=zoneMiddleoftheForest}
zcharacterSnake5.Id="663efe01-c954-4e06-b610-ba03ff4d4735"
zcharacterSnake5.Name="Snake5"
zcharacterSnake5.Description=[[A green and yellow snake hisses at you.  Those fangs look dangourous, and the venom is probably worse.]]
zcharacterSnake5.Visible=false
zcharacterSnake5.Media=zmediaSnakePic
zcharacterSnake5.Icon=zmediaIconSnake
zcharacterSnake5.Gender="Male"
zcharacterSnake5.Type="NPC"
zcharacterSnake5.ObjectLocation = ZonePoint(51.4040300791295,-2.51038000259642,360)

-- Items --
zitemTablet = Wherigo.ZItem(cartSnakes)
zitemTablet.Id="a80aa805-a4f2-46a4-b1bd-dc28c978fe65"
zitemTablet.Name="Tablet"
zitemTablet.Description=[[A configuration tablet for this game]]
zitemTablet.Visible=true
zitemTablet.ObjectLocation = Wherigo.INVALID_ZONEPOINT
zitemTablet.Locked = false
zitemTablet.Opened = false
zitemTablet.Commands = {
  SetSnakespeedModfier = Wherigo.ZCommand{Text="Set Snake speed Modfier", CmdWith=false, Enabled=true, EmptyTargetListText="Nothing available"},
  SetMaxSnakes = Wherigo.ZCommand{Text="Set Max Snakes", CmdWith=false, Enabled=true, EmptyTargetListText="Nothing available"},
  PetModePlease = Wherigo.ZCommand{Text="Pet Mode Please", CmdWith=false, Enabled=true, EmptyTargetListText="Nothing available"},
  SetSnakeSpeed = Wherigo.ZCommand{Text="Set Snake Speed", CmdWith=false, Enabled=false, EmptyTargetListText="Nothing available"},
  SetVisibleDistance = Wherigo.ZCommand{Text="Set Visible Distance", CmdWith=false, Enabled=true, EmptyTargetListText="Nothing available"},
  SetTargetDistance = Wherigo.ZCommand{Text="Set Target Distance", CmdWith=false, Enabled=false, EmptyTargetListText="Nothing available"},
  SetWarningDistance = Wherigo.ZCommand{Text="Set Warning Distance", CmdWith=false, Enabled=true, EmptyTargetListText="Nothing available"},
}
zitemTablet.Commands.SetSnakespeedModfier.Custom = true
zitemTablet.Commands.SetSnakespeedModfier.Id="6fd2782e-5877-48e9-9865-2327f90d08c8"
zitemTablet.Commands.SetSnakespeedModfier.WorksWithAll = true
zitemTablet.Commands.SetMaxSnakes.Custom = true
zitemTablet.Commands.SetMaxSnakes.Id="2fa030c4-584b-4da9-9529-378300f0abe6"
zitemTablet.Commands.SetMaxSnakes.WorksWithAll = true
zitemTablet.Commands.PetModePlease.Custom = true
zitemTablet.Commands.PetModePlease.Id="6000e95d-0ecb-4c4d-8ba9-851ff0da7cea"
zitemTablet.Commands.PetModePlease.WorksWithAll = true
zitemTablet.Commands.SetSnakeSpeed.Custom = true
zitemTablet.Commands.SetSnakeSpeed.Id="5af95583-67a1-4460-8a2b-80b23bc1e95a"
zitemTablet.Commands.SetSnakeSpeed.WorksWithAll = true
zitemTablet.Commands.SetVisibleDistance.Custom = true
zitemTablet.Commands.SetVisibleDistance.Id="8fd54f96-d816-4c30-be9c-bdfd54ba5034"
zitemTablet.Commands.SetVisibleDistance.WorksWithAll = true
zitemTablet.Commands.SetTargetDistance.Custom = true
zitemTablet.Commands.SetTargetDistance.Id="734a9291-6eaa-49fd-96fd-c6abd01b7244"
zitemTablet.Commands.SetTargetDistance.WorksWithAll = true
zitemTablet.Commands.SetWarningDistance.Custom = true
zitemTablet.Commands.SetWarningDistance.Id="161e36f9-85a1-4a24-ac58-0f402a8f79f7"
zitemTablet.Commands.SetWarningDistance.WorksWithAll = true

zitemWoodPile = Wherigo.ZItem{Cartridge=cartSnakes, Container=zoneForestersHome}
zitemWoodPile.Id="251f7c38-58d9-457d-acc8-e20f3114defa"
zitemWoodPile.Name="Wood Pile"
zitemWoodPile.Description=[[It is a pile of wood. There seem to be all sorts of different types of logs here - oak, ash, holly and willow. There are some logs already cut into small, managable pieces. ]]
zitemWoodPile.Visible=true
zitemWoodPile.ObjectLocation = ZonePoint(51.40206,-2.50844,0)
zitemWoodPile.Media=zmediaWoodpile
zitemWoodPile.Icon=zmediaIconWoodpile
zitemWoodPile.Locked = false
zitemWoodPile.Opened = false
zitemWoodPile.Commands = {
  GetLogs = Wherigo.ZCommand{Text="Get Logs", CmdWith=false, Enabled=false, EmptyTargetListText="Nothing available"},
}
zitemWoodPile.Commands.GetLogs.Custom = true
zitemWoodPile.Commands.GetLogs.Id="c9935c68-6b39-439b-861f-af6ca937cfd3"
zitemWoodPile.Commands.GetLogs.WorksWithAll = true

zitemLogs = Wherigo.ZItem{Cartridge=cartSnakes, Container=zoneForestersHome}
zitemLogs.Id="4cc776eb-ac50-4f69-8d5b-f71a888a0826"
zitemLogs.Name="Logs"
zitemLogs.Description=[[Logs from the foresters woodpile]]
zitemLogs.Visible=false
zitemLogs.ObjectLocation = ZonePoint(51.4020533481787,-2.50844792013315,360)
zitemLogs.Media=zmediaLogs
zitemLogs.Icon=zmediaIconLogs
zitemLogs.Locked = false
zitemLogs.Opened = false
zitemLogs.Commands = {
  MakeCampfire = Wherigo.ZCommand{Text="Make Campfire", CmdWith=false, Enabled=false, EmptyTargetListText="Nothing available"},
}
zitemLogs.Commands.MakeCampfire.Custom = true
zitemLogs.Commands.MakeCampfire.Id="bc0c39be-c4d1-45b8-9013-014fb05d5ff7"
zitemLogs.Commands.MakeCampfire.WorksWithAll = true

zitemPotofBlackStuff = Wherigo.ZItem{Cartridge=cartSnakes, Container=zoneForestersHome}
zitemPotofBlackStuff.Id="b2016468-d003-4df6-94ee-14cd282d392f"
zitemPotofBlackStuff.Name="Pot of Black Stuff"
zitemPotofBlackStuff.Description=[[It is a dark viscous substance in an earthenware pot. 
 ]]
zitemPotofBlackStuff.Visible=true
zitemPotofBlackStuff.ObjectLocation = ZonePoint(51.40202,-2.50878,0)
zitemPotofBlackStuff.Media=zmediaPot
zitemPotofBlackStuff.Icon=zmediaIconPot
zitemPotofBlackStuff.Locked = false
zitemPotofBlackStuff.Opened = false
zitemPotofBlackStuff.Commands = {
  EatBlackStuff = Wherigo.ZCommand{Text="Eat Black Stuff", CmdWith=false, Enabled=true, EmptyTargetListText="Nothing available"},
  Putpotdown = Wherigo.ZCommand{Text="Put pot down", CmdWith=false, Enabled=false, EmptyTargetListText="Nothing available"},
  Examine = Wherigo.ZCommand{Text="Examine", CmdWith=false, Enabled=false, EmptyTargetListText="Nothing available"},
}
zitemPotofBlackStuff.Commands.EatBlackStuff.Custom = true
zitemPotofBlackStuff.Commands.EatBlackStuff.Id="303d8bdd-90f8-4fca-a5fa-112c82dfa1d5"
zitemPotofBlackStuff.Commands.EatBlackStuff.WorksWithAll = true
zitemPotofBlackStuff.Commands.Putpotdown.Custom = true
zitemPotofBlackStuff.Commands.Putpotdown.Id="cccb3599-b87a-4740-a101-8f6be599d8f2"
zitemPotofBlackStuff.Commands.Putpotdown.WorksWithAll = true
zitemPotofBlackStuff.Commands.Examine.Custom = true
zitemPotofBlackStuff.Commands.Examine.Id="6279e0b6-02b7-4d86-94c1-74f53ef5d3a3"
zitemPotofBlackStuff.Commands.Examine.WorksWithAll = true

zitemAsmalllogfire = Wherigo.ZItem{Cartridge=cartSnakes, Container=zoneForestersHome}
zitemAsmalllogfire.Id="b30dea0d-c7a1-4600-b62e-ead0cc8bdb2d"
zitemAsmalllogfire.Name="A small log fire"
zitemAsmalllogfire.Description=[[The fire burns merrily, cheering up this part of the forest no end. ]]
zitemAsmalllogfire.Visible=true
zitemAsmalllogfire.ObjectLocation = ZonePoint(51.40209,-2.50865,0)
zitemAsmalllogfire.Media=zmediaForestersHomeFire
zitemAsmalllogfire.Icon=zmediaIconForesterHomeFire
zitemAsmalllogfire.Locked = false
zitemAsmalllogfire.Opened = false

zitemForestersHouse = Wherigo.ZItem{Cartridge=cartSnakes, Container=zoneForestersHome}
zitemForestersHouse.Id="3f39efab-f154-4f38-9f13-3b4bc8f007ae"
zitemForestersHouse.Name="Foresters House"
zitemForestersHouse.Description=[[It looks simple, wooden and cosy, thatched with the reeds growing at the banks of the nearby River Chew. ]]
zitemForestersHouse.Visible=true
zitemForestersHouse.ObjectLocation = ZonePoint(51.40209,-2.50868,0)
zitemForestersHouse.Media=zmediaForesterHouse
zitemForestersHouse.Icon=zmediaIconForesterHouse
zitemForestersHouse.Locked = false
zitemForestersHouse.Opened = false

zitemAxe = Wherigo.ZItem{Cartridge=cartSnakes, Container=zoneForestersHome}
zitemAxe.Id="56bc3f83-adbf-4511-88e3-e22ba5e409cb"
zitemAxe.Name="Axe"
zitemAxe.Description=[[A small but sturdy axe. It looks sharp, but not the right kind of tool for gettng rid of the snakes. If you look closer, you notice a strange substance covering the metal. ]]
zitemAxe.Visible=true
zitemAxe.ObjectLocation = ZonePoint(51.402061605175,-2.50844792013315,360)
zitemAxe.Media=zmediaAxe
zitemAxe.Icon=zmediaIconAxe
zitemAxe.Locked = false
zitemAxe.Opened = false
zitemAxe.Commands = {
  TakeAxe = Wherigo.ZCommand{Text="Take Axe", CmdWith=false, Enabled=false, EmptyTargetListText="Nothing available"},
}
zitemAxe.Commands.TakeAxe.Custom = true
zitemAxe.Commands.TakeAxe.Id="071e8de4-e006-45f7-8554-ba46d89310fc"
zitemAxe.Commands.TakeAxe.WorksWithAll = true

zitemStick = Wherigo.ZItem{Cartridge=cartSnakes, Container=zoneForestersHome}
zitemStick.Id="5cfa0b84-463e-4b03-8f69-c966445ec87f"
zitemStick.Name="Stick"
zitemStick.Description=[[Looking at it, it reminds you of a joke you once heard:

Whats brown and sticky? A stick! ]]
zitemStick.Visible=true
zitemStick.ObjectLocation = ZonePoint(51.40216,-2.50853,0)
zitemStick.Media=zmediaStick
zitemStick.Icon=zmediaiconStick
zitemStick.Locked = false
zitemStick.Opened = false
zitemStick.Commands = {
  LightStick = Wherigo.ZCommand{Text="Light Stick", CmdWith=false, Enabled=false, EmptyTargetListText="Nothing available"},
  ThrowStick = Wherigo.ZCommand{Text="Throw Stick", CmdWith=false, Enabled=false, EmptyTargetListText="Nothing available"},
  PutStickInPot = Wherigo.ZCommand{Text="Put Stick In Pot", CmdWith=false, Enabled=false, EmptyTargetListText="Nothing available"},
}
zitemStick.Commands.LightStick.Custom = true
zitemStick.Commands.LightStick.Id="3a46772b-5088-4e4d-ad83-7ef990a91695"
zitemStick.Commands.LightStick.WorksWithAll = true
zitemStick.Commands.ThrowStick.Custom = true
zitemStick.Commands.ThrowStick.Id="68ce091b-7188-4187-b0c7-2f8a0efcff67"
zitemStick.Commands.ThrowStick.WorksWithAll = true
zitemStick.Commands.PutStickInPot.Custom = true
zitemStick.Commands.PutStickInPot.Id="d3ea3867-fed3-44ad-b4ae-ee983eeec48d"
zitemStick.Commands.PutStickInPot.WorksWithAll = true

zitemBoxofcurios = Wherigo.ZItem{Cartridge=cartSnakes, Container=zonePetrifiedSnake}
zitemBoxofcurios.Id="aaa5ff0b-be9d-4e90-b9bb-f44e9bc6e34b"
zitemBoxofcurios.Name="Box of curios"
zitemBoxofcurios.Description=[[The Geocache is a small sized cliplock box hidden under the north end of the little bridge, on a ledge.  Please put the box back safely so that it doesnt fall down.]]
zitemBoxofcurios.Visible=true
zitemBoxofcurios.ObjectLocation = ZonePoint(51.403405,-2.51102,360)
zitemBoxofcurios.Media=zmediaGeocaching
zitemBoxofcurios.Icon=zmediaIconGeocache
zitemBoxofcurios.Locked = false
zitemBoxofcurios.Opened = false

zitemCampfire = Wherigo.ZItem{Cartridge=cartSnakes, Container=zoneMiddleoftheForest}
zitemCampfire.Id="d32fa9df-bc27-4eba-a718-e2dafb8b3c61"
zitemCampfire.Name="Campfire"
zitemCampfire.Description=[[]]
zitemCampfire.Visible=false
zitemCampfire.ObjectLocation = ZonePoint(51.40401,-2.51041,0)
zitemCampfire.Media=zmediaCampfireUnlit
zitemCampfire.Icon=zmediaIconCampfireUnlight
zitemCampfire.Locked = false
zitemCampfire.Opened = false
zitemCampfire.Commands = {
  Lightfire = Wherigo.ZCommand{Text="Light fire", CmdWith=false, Enabled=false, EmptyTargetListText="Nothing available"},
  Seekdivinehelp = Wherigo.ZCommand{Text="Seek divine help", CmdWith=false, Enabled=false, EmptyTargetListText="Nothing available"},
}
zitemCampfire.Commands.Lightfire.Custom = true
zitemCampfire.Commands.Lightfire.Id="f5b5e9f8-73de-47ba-b92a-289205d7ca40"
zitemCampfire.Commands.Lightfire.WorksWithAll = true
zitemCampfire.Commands.Seekdivinehelp.Custom = true
zitemCampfire.Commands.Seekdivinehelp.Id="a552a371-4b35-4958-8e78-58426cc54642"
zitemCampfire.Commands.Seekdivinehelp.WorksWithAll = true

-- Tasks --

-- Cartridge Variables --
bBusy = true
iTimeTaken = 0
sInputValue = ""
bDevineIntervention = true
iSnakeSpeed = 5
sInput = "5"
iDistanceFromCenter = 1000
bPetActivated = true
iForesterActions = 0
iSnakeSpeedMod = 1
iVisibleDistance = 20
iBitDistance = 6
iSnakeNumbers = 2
iWarningDistance = 5
cartSnakes.ZVariables = {bBusy = true, iTimeTaken = 0, sInputValue = "", bDevineIntervention = true, iSnakeSpeed = 5, sInput = "5", iDistanceFromCenter = 1000, bPetActivated = true, iForesterActions = 0, iSnakeSpeedMod = 1, iVisibleDistance = 20, iBitDistance = 6, iSnakeNumbers = 2, iWarningDistance = 5}

-- Builder Variables (to be read by the builder only) --
buildervar = {}
buildervar.bBusy = {}
buildervar.bBusy.Id ="13b6ebdd-c00b-44de-a969-cd7ab60f9ca5"
buildervar.bBusy.Name = "bBusy"
buildervar.bBusy.Type = "Flag"
buildervar.bBusy.Data=[[True]]
buildervar.bBusy.Description=[[]]

buildervar.iTimeTaken = {}
buildervar.iTimeTaken.Id ="41f67546-00df-4bf6-8a96-0fd03259a30f"
buildervar.iTimeTaken.Name = "iTimeTaken"
buildervar.iTimeTaken.Type = "Number"
buildervar.iTimeTaken.Data=[[0]]
buildervar.iTimeTaken.Description=[[Time taken so far]]

buildervar.sInputValue = {}
buildervar.sInputValue.Id ="280fb175-770d-4290-83cb-d1903303cb82"
buildervar.sInputValue.Name = "sInputValue"
buildervar.sInputValue.Type = "String"
buildervar.sInputValue.Data=[[]]
buildervar.sInputValue.Description=[[]]

buildervar.bDevineIntervention = {}
buildervar.bDevineIntervention.Id ="78d9227c-a083-4936-a8c0-31a3f762578b"
buildervar.bDevineIntervention.Name = "bDevineIntervention"
buildervar.bDevineIntervention.Type = "Flag"
buildervar.bDevineIntervention.Data=[[True]]
buildervar.bDevineIntervention.Description=[[]]

buildervar.iSnakeSpeed = {}
buildervar.iSnakeSpeed.Id ="377f5dbb-e9d6-4684-8107-79c9829815fc"
buildervar.iSnakeSpeed.Name = "iSnakeSpeed"
buildervar.iSnakeSpeed.Type = "Number"
buildervar.iSnakeSpeed.Data=[[5]]
buildervar.iSnakeSpeed.Description=[[How fast the snake can travel]]

buildervar.sInput = {}
buildervar.sInput.Id ="05d4fecd-dd24-452e-879b-87e1c9946f4b"
buildervar.sInput.Name = "sInput"
buildervar.sInput.Type = "String"
buildervar.sInput.Data=[[5]]
buildervar.sInput.Description=[[]]

buildervar.iDistanceFromCenter = {}
buildervar.iDistanceFromCenter.Id ="bac275d8-d49d-4c3d-bd36-400b16c15150"
buildervar.iDistanceFromCenter.Name = "iDistanceFromCenter"
buildervar.iDistanceFromCenter.Type = "Number"
buildervar.iDistanceFromCenter.Data=[[1000]]
buildervar.iDistanceFromCenter.Description=[[How far the player is from the target area]]

buildervar.bPetActivated = {}
buildervar.bPetActivated.Id ="fe57cebe-7547-49ba-86e8-f77f74cbf0eb"
buildervar.bPetActivated.Name = "bPetActivated"
buildervar.bPetActivated.Type = "Flag"
buildervar.bPetActivated.Data=[[True]]
buildervar.bPetActivated.Description=[[]]

buildervar.iForesterActions = {}
buildervar.iForesterActions.Id ="3fe01fc6-24c3-4717-aa05-9ffb91fb3df3"
buildervar.iForesterActions.Name = "iForesterActions"
buildervar.iForesterActions.Type = "Number"
buildervar.iForesterActions.Data=[[0]]
buildervar.iForesterActions.Description=[[0 = Wait for player
1 = Walk to gap in hedge
2 = Walk South to home
3 = Get Small Stick off pile
4 = Go to tar
5 = Go to Fire
6 = Give stick to player
7 = Wish good luck
8 = Give logs
]]

buildervar.iSnakeSpeedMod = {}
buildervar.iSnakeSpeedMod.Id ="72697306-181b-406d-a358-31c8e599f9b7"
buildervar.iSnakeSpeedMod.Name = "iSnakeSpeedMod"
buildervar.iSnakeSpeedMod.Type = "Number"
buildervar.iSnakeSpeedMod.Data=[[1]]
buildervar.iSnakeSpeedMod.Description=[[Modification factor to snakes agressivness and speed]]

buildervar.iVisibleDistance = {}
buildervar.iVisibleDistance.Id ="1ee3c598-b17f-4ed5-97a2-8df302565fac"
buildervar.iVisibleDistance.Name = "iVisibleDistance"
buildervar.iVisibleDistance.Type = "Number"
buildervar.iVisibleDistance.Data=[[20]]
buildervar.iVisibleDistance.Description=[[How far away the player can see the snake]]

buildervar.iBitDistance = {}
buildervar.iBitDistance.Id ="360d580e-deaf-48a9-9246-fac579247edf"
buildervar.iBitDistance.Name = "iBitDistance"
buildervar.iBitDistance.Type = "Number"
buildervar.iBitDistance.Data=[[6]]
buildervar.iBitDistance.Description=[[How far away the snake can bite player]]

buildervar.iSnakeNumbers = {}
buildervar.iSnakeNumbers.Id ="7ea3fd0f-d14c-4d6e-8409-93fdd9f7784e"
buildervar.iSnakeNumbers.Name = "iSnakeNumbers"
buildervar.iSnakeNumbers.Type = "Number"
buildervar.iSnakeNumbers.Data=[[2]]
buildervar.iSnakeNumbers.Description=[[Maximum number of snakes]]

buildervar.iWarningDistance = {}
buildervar.iWarningDistance.Id ="f4fe84f9-acaa-4721-b2c5-b920f7c69f8b"
buildervar.iWarningDistance.Name = "iWarningDistance"
buildervar.iWarningDistance.Type = "Number"
buildervar.iWarningDistance.Data=[[5]]
buildervar.iWarningDistance.Description=[[]]


-- ZTimers --
ztimerPlotSnakes = Wherigo.ZTimer(cartSnakes)
ztimerPlotSnakes.Id="0f866a88-7bea-4e7b-aef7-32e61ab73156"
ztimerPlotSnakes.Name="PlotSnakes"
ztimerPlotSnakes.Description=[[]]
ztimerPlotSnakes.Visible=true
ztimerPlotSnakes.Duration=2
ztimerPlotSnakes.Type="Interval"

ztimerPlotForester = Wherigo.ZTimer(cartSnakes)
ztimerPlotForester.Id="1c0d009b-2892-4dd3-8bbc-168ee3a90729"
ztimerPlotForester.Name="PlotForester"
ztimerPlotForester.Description=[[]]
ztimerPlotForester.Visible=true
ztimerPlotForester.Duration=2
ztimerPlotForester.Type="Interval"

ztimerPlotPet = Wherigo.ZTimer(cartSnakes)
ztimerPlotPet.Id="3602d9fd-eef1-42f2-80d7-6c12b53a00a7"
ztimerPlotPet.Name="PlotPet"
ztimerPlotPet.Description=[[]]
ztimerPlotPet.Visible=true
ztimerPlotPet.Duration=2
ztimerPlotPet.Type="Interval"

-- Inputs --
zinputSnakeSpeed = Wherigo.ZInput(cartSnakes)
zinputSnakeSpeed.Id="9fb77d2f-864e-4f6a-bba2-83eb7254b2c8"
zinputSnakeSpeed.Name="SnakeSpeed"
zinputSnakeSpeed.Description=[[]]
zinputSnakeSpeed.Visible=true
zinputSnakeSpeed.InputType="Text"
zinputSnakeSpeed.InputVariableId="280fb175-770d-4290-83cb-d1903303cb82"
zinputSnakeSpeed.Text=[[How fast should the snake go?]]

zinputVisibleDistance = Wherigo.ZInput(cartSnakes)
zinputVisibleDistance.Id="6a7c3f38-4ee1-4a74-8254-b2e25aa15d73"
zinputVisibleDistance.Name="VisibleDistance"
zinputVisibleDistance.Description=[[]]
zinputVisibleDistance.Visible=true
zinputVisibleDistance.InputType="Text"
zinputVisibleDistance.InputVariableId="00000000-0000-0000-0000-000000000000"
zinputVisibleDistance.Text=[[How far away can the player see the snake?]]

zinputCenterDistance = Wherigo.ZInput(cartSnakes)
zinputCenterDistance.Id="b9bc1176-72fe-4a9e-ab6e-a1a95e62aa8c"
zinputCenterDistance.Name="CenterDistance"
zinputCenterDistance.Description=[[]]
zinputCenterDistance.Visible=true
zinputCenterDistance.InputType="Text"
zinputCenterDistance.InputVariableId="00000000-0000-0000-0000-000000000000"
zinputCenterDistance.Text=[[How far from the center are you?]]

zinputSnakeSpeedmodifier = Wherigo.ZInput(cartSnakes)
zinputSnakeSpeedmodifier.Id="671c31fd-c7e9-44dd-9662-97c49752f332"
zinputSnakeSpeedmodifier.Name="Snake Speed modifier"
zinputSnakeSpeedmodifier.Description=[[]]
zinputSnakeSpeedmodifier.Visible=true
zinputSnakeSpeedmodifier.InputType="Text"
zinputSnakeSpeedmodifier.InputVariableId="72697306-181b-406d-a358-31c8e599f9b7"
zinputSnakeSpeedmodifier.Text=[[Snake speed modifier]]

zinputNumberOfSnakes = Wherigo.ZInput(cartSnakes)
zinputNumberOfSnakes.Id="60a639d0-d80f-4dd8-a480-88f8d880d0da"
zinputNumberOfSnakes.Name="NumberOfSnakes"
zinputNumberOfSnakes.Description=[[How many snakes]]
zinputNumberOfSnakes.Visible=true
zinputNumberOfSnakes.InputType="Text"
zinputNumberOfSnakes.InputVariableId="7ea3fd0f-d14c-4d6e-8409-93fdd9f7784e"
zinputNumberOfSnakes.Text=[[How many snakes (1 to 5)]]

zinputWarningDistance = Wherigo.ZInput(cartSnakes)
zinputWarningDistance.Id="47b473a9-8722-4f8d-965b-42ad0246af49"
zinputWarningDistance.Name="WarningDistance"
zinputWarningDistance.Description=[[]]
zinputWarningDistance.Visible=true
zinputWarningDistance.InputType="Text"
zinputWarningDistance.InputVariableId="f4fe84f9-acaa-4721-b2c5-b920f7c69f8b"
zinputWarningDistance.Text=[[Warning for snake proximity distance]]

--
-- Events/Conditions/Actions --
--

-------------------------------------------------------------------------------
------Builder Generated functions, Do not Edit, this will be overwritten------
-------------------------------------------------------------------------------

function cartSnakes:OnStart()
-- #GroupDescription=Start Cartridge --
-- #Comment=Start Cartridge Comment --
zitemTablet:MoveTo(Player)
end

function zcharacterForester:OnHello()
-- #GroupDescription=Say hello --
-- #Comment=Say hello Comment --
Wherigo.MessageBox{Text=[[Hello to you

What brings you this way?]],Media=zmediaForester,Buttons={"Exploring Forest",},Callback=cartSnakes.MsgBoxCBFuncs.MsgBoxCB6}
zcharacterForester.Commands["Hello"].Enabled = false
end

function zcharacterForester:OnNicefire()
-- #GroupDescription=Nice fire --
-- #Comment=Nice fire Comment --
zcharacterForester.Commands["Nicefire"].Enabled = false
Wherigo.MessageBox{Text=[[Oh yes, it keeps the snakes away.

Thats right, I had something for you]],Media=zmediaForesterHappy,Buttons={"Some fire",},Callback=cartSnakes.MsgBoxCBFuncs.MsgBoxCB8}
zcharacterForester.Description = [[The forester is looking around for something.]]
end

function zitemStick:OnPutStickInPot()
-- #GroupDescription=put stick in pot of tar --
-- #Comment=put stick in pot of tar Comment --
zitemStick.Media = zmediaStickTar
Wherigo.MessageBox{Text=[[You put the end of the stick in the pot of black stuff and pull it out again.  
This smells awfull!!!  Perhaps the smell keeps the snakes away.]],Media=zmediaStickTar,}
zitemStick.Commands["PutStickInPot"].Enabled = false
zitemStick.Commands["LightStick"].Enabled = true
end

function zitemStick:OnLightStick()
-- #GroupDescription=light stick --
-- #Comment=light stick Comment --
zitemStick.Media = zmediaStickFire
zitemStick.Commands["LightStick"].Enabled = false
Wherigo.MessageBox{Text=[[You put the black sticky end of the stick into the fire and it bursts into life.
This should keep the snakes away.]],Media=zmediaStickFire,}
Wherigo.Dialog{{Text=[[You put the black sticky end of the stick into the fire and it bursts into life.
This should keep the snakes away.]],Media=zmediaStickFire},{Text=[[The Forester Smiles

If there is anything else you think you need, help yourself, but please leave my axe and I would appriciate the pot back.]],Media=zmediaForesterHappy},}
zitemPotofBlackStuff.Commands["Putpotdown"].Enabled = true
zitemAxe.Commands["TakeAxe"].Enabled = true
end

function zitemPotofBlackStuff:OnEatBlackStuff()
-- #GroupDescription=Yuck --
-- #Comment=Yuck Comment --
Wherigo.MessageBox{Text=[[YYYYuck!!!!

That has to be the worst tasting gravy or honey or what ever it is you have ever tasted. 
Try as you might, you just can not get rid of the taste out of your mouth.]],Media=zmediaPot,}
end

function zitemPotofBlackStuff:OnExamine()
-- #GroupDescription=examine black stuff --
-- #Comment=examine black stuff Comment --
Wherigo.MessageBox{Text=[[You have no idea what the black stuff is.  You take a sniff and its horrible.  You poke your finger into the pot and your finger comes out black and slimy.  

After much thought, you reckon this might be some sort of medicine or ointment that you spread on yourself to keep the snakes away.

You could always ask the forester.]],Media=zmediaPot,}
zcharacterForester.Commands["Whatsinthepot"].Enabled = true
end

function zcharacterForester:OnWhatsinthepot()
-- #GroupDescription=what in the pot --
-- #Comment=what in the pot Comment --
Wherigo.Dialog{{Text=[[I call it fire water.]],Media=zmediaPot},{Text=[[To make it I heat up rocks I collect from a couple of miles down the river Avon, the black ones that have strange leaf type markings in them.

As they heat up, this liquid bleads out of the rock and I collect it in a small pot.  I guess its like taking blood out of a stone, but its black blood.]],Media=zmediaPot},{Text=[[I use it for all sorts of things, like it stops my axe going rusty in the wet.  Its best use however is for burning.  Put some of that on the end of your stick and it will burn brightly.  Amazing really, I suppose its like carrying around distiled rock.]],Media=zmediaPot},}
zitemStick.Commands["PutStickInPot"].Enabled = true
end

function zitemStick:OnThrowStick()
-- #GroupDescription=Throw stick --
-- #Comment=Throw stick Comment --
Wherigo.Dialog{{Text=[[You throw the stick]],},{Text=[[No dogs appear to fetch the stick, so you wander over and pick it up.]],},}
end

function zitemAxe:OnTakeAxe()
-- #GroupDescription=take axe --
-- #Comment=take axe Comment --
zitemAxe:MoveTo(Player)
zcharacterForester.Media = zmediaForester
zcharacterForester.Name = [[Sad forester]]
zcharacterForester.Description = [[The forester feels betrayed by you taking the axe]]
zitemAxe.Commands["TakeAxe"].Enabled = false
end

function zitemWoodPile:OnGetLogs()
-- #GroupDescription=get logs --
-- #Comment=get logs Comment --
zitemLogs:MoveTo(Player)
Wherigo.MessageBox{Text=[[You pick up some logs, just enough to make a campfire should the need arise.]],Media=zmediaLogs,}
zitemLogs.Visible = true
end

function zoneStart:OnEnter()
-- #GroupDescription=Enter start zone --
-- #Comment=Enter start zone Comment --
Wherigo.PlayAudio(zmediaBeep)
bBusy = false
zitemTablet:MoveTo(Player)
Wherigo.Dialog{{Text=[[Welcome to Abbots Wood on the edges of Keynsham.  

Having read the Wherigo intro, you should know all you have to do - get to the center of this wood and while your at it you might as well find a way to turn the snakes into stone to be in keeping with the legend.

Good luck and dont let the snakes bite (its fatal).]],Media=zmediaForest},{Text=[[Oh and by the way, you do not need to leave the nature reserve area (forest and playing fields) or cross any fences.  You should be able to perform the whole game by walking along the paths, with the exception of getting the Geocache at the end.  

IF you have problems getting to the center (snakes are more aggressive there and may cause some people a bit of trouble), have a look around and see what or who you can find or use.  

Have fun]],},}
zoneStart.Active = false
zoneSmoke.Active = true
zoneForestersHome.Active = true
zoneMiddleoftheForest.Active = true
bDevineIntervention = false
ztimerPlotSnakes:Start()
ztimerPlotForester:Start()
end

function zitemLogs:OnMakeCampfire()
-- #GroupDescription=make camp fire --
-- #Comment=make camp fire Comment --
zitemCampfire.Visible = true
zitemLogs:MoveTo(nil)
zitemCampfire.Commands["Lightfire"].Enabled = true
end

function zoneMiddleoftheForest:OnEnter()
-- #GroupDescription=enter middle of forest --
-- #Comment=enter middle of forest Comment --
Wherigo.PlayAudio(zmediaBeep)
if zitemStick.Media == zmediaStickFire then
  bBusy = true
end
zitemLogs.Commands["MakeCampfire"].Enabled = true
Wherigo.MessageBox{Text=[[You have made it to the center, but you still have a snake problem.  Pehaps a campfire would keep the snakes at bay while you think.]],Media=zmediaForest,}

end

function zoneMiddleoftheForest:OnExit()
-- #GroupDescription=leave the middle --
-- #Comment=leave the middle Comment --
zitemLogs.Commands["MakeCampfire"].Enabled = false
bBusy = false
end

function zitemCampfire:OnLightfire()
-- #GroupDescription=light the fire --
-- #Comment=light the fire Comment --
zitemCampfire.Commands["Lightfire"].Enabled = false
zitemCampfire.Media = zmediaCampfireLit
zitemCampfire.Icon = zmediaIconCampfireLit
zitemCampfire.Commands["Seekdivinehelp"].Enabled = true
Wherigo.Dialog{{Text=[[You put the lit end of the stick in the middle of the campfire and with in seconds a bright fire starts to burn.]],Media=zmediaCampfireLit},{Text=[[As the fire burns brighter you see the snakes backing off, but you still have an uneasy feeling, a feeling of great evil may be to the South West.  ]],Media=zmediaCampfireLit},{Text=[[You are beginning to agree with the people who said its too dangerous to be here.  You would need a miracle to cleanse this place of the snakes and what evil lies beyond.]],Media=zmediaCampfireLit},{Text=[[You look at the campfire for insparation.]],Media=zmediaCampfireLit},}
end

function zitemCampfire:OnSeekdivinehelp()
-- #GroupDescription=you pray --
-- #Comment=you pray Comment --
zitemCampfire.Commands["Seekdivinehelp"].Enabled = false
zonePetrifiedSnake.Active = true
zoneMiddleoftheForest.Visible = false
ztimerPlotForester:Stop()
bDevineIntervention = true
Wherigo.Dialog{{Text=[[You sit down next to the campfire making sure you the snakes arnt going to sneek up to you]],Media=zmediaCampfireLit},{Text=[[As you seek divine wisdom, you feel a strong breeze sweep through the forest.  You open your eyes and at first glance you don't notice anything different, but the uneasy feeling you previously had has now gone to be replaced by a feeling of peace and joy.]],Media=zmediaForest},{Text=[[In light of your new found strength, you get up and look around.  To your supprise, the hissing snakes are no longer there, well, they are but they have been turned to stone.]],Media=zmediaAmmonite},{Text=[[This has truely been a miricle.  Not only that, but you now know exaclty where you must build your new home, next to the greatest evil of all, a huge snake to ensure it doesn't return to life.  There too your sure lies a box of interesting curios.]],Media=zmediaGeocaching},}
zcharacterSnake1.Media = zmediaAmmonite
zcharacterSnake1.Description = [[Petrified Snake]]
zcharacterSnake1.Icon = zmediaIconAmmonite
zcharacterSnake2.Media = zmediaAmmonite
zcharacterSnake2.Description = [[Petrified Snake]]
zcharacterSnake2.Icon = zmediaIconAmmonite
zcharacterSnake3.Media = zmediaAmmonite
zcharacterSnake3.Description = [[Petrified Snake]]
zcharacterSnake3.Icon = zmediaIconAmmonite
zcharacterSnake4.Media = zmediaAmmonite
zcharacterSnake4.Description = [[Petrified Snake]]
zcharacterSnake4.Icon = zmediaIconAmmonite
zcharacterSnake5.Media = zmediaAmmonite
zcharacterSnake5.Description = [[Petrified Snake]]
zcharacterSnake5.Icon = zmediaIconAmmonite
end

function zonePetrifiedSnake:OnEnter()
-- #GroupDescription=the end --
-- #Comment=the end Comment --
Wherigo.PlayAudio(zmediaBeep)
Wherigo.Dialog{{Text=[[Wherigo completed.

The cache is near by, just head to where the box of curios is.]],},{Text=[[We hope you enjoyed your little adventure.  

If you did, or even if you didn't, please log your visit and make any comments or suggestions.   If you found a bug or had problem, please can you send us the .log file so that we have more chance at working out what went wrong.

Happy Caching
A Snail and Myriadgreen]],},}
zcharacterSnake1.Media = zmediaAmmonite
end

function zitemPotofBlackStuff:OnPutpotdown()
-- #GroupDescription=put down pot --
-- #Comment=put down pot Comment --
zitemPotofBlackStuff:MoveTo(zoneForestersHome)
zitemPotofBlackStuff.Commands["Examine"].Enabled = false
zitemPotofBlackStuff.Commands["Putpotdown"].Enabled = false
end

function zoneForestersHome:OnExit()
-- #GroupDescription=leave home --
-- #Comment=leave home Comment --
zitemPotofBlackStuff.Commands["Putpotdown"].Enabled = false
end

function zoneMiddleoftheForest:OnProximity()
-- #GroupDescription=proximity --
-- #Comment=proximity Comment --
if   zoneStart.Active == false then
ztimerPlotSnakes:Start()
end
end

function zoneForestersHome:OnEnter()
-- #GroupDescription=enter foresters home --
-- #Comment=enter foresters home Comment --
Wherigo.PlayAudio(zmediaBeep)
end

function zitemTablet:OnPetModePlease()
-- #GroupDescription=Request pet --
-- #Comment=Request pet Comment --
zonePetZone.Active = true
bPetActivated = true
ztimerPlotPet:Start()
zoneStart.Active = false
zoneMiddleoftheForest.Active = false
zoneForestersHome.Active = false
zonePetrifiedSnake.Active = false
zoneSmoke.Active = false
end
------End Builder Generated functions, Do not Edit, this will be overwritten------
-------------------------------------------------------------------------------
------Builder Generated callbacks, Do not Edit, this will be overwritten------
-------------------------------------------------------------------------------
--#LASTCALLBACKKEY=13#--
cartSnakes.MsgBoxCBFuncs.MsgBoxCB1 = function(action)
if action ~= nil then
-- #GroupDescription=get the new snake speed --
-- #Comment=get the new snake speed Comment --
Wherigo.GetInput(zinputSnakeSpeed)
end
end

cartSnakes.MsgBoxCBFuncs.MsgBoxCB10 = function(action)
if action ~= nil then
-- #GroupDescription=get the new snake speed --
-- #Comment=get the new snake speed Comment --
Wherigo.MessageBox{Text=[[Looks like a stick.  You could probably hit a snake or two with it, but its a bit short.]],Media=zmediaStick,Buttons={"OK",},Callback=cartSnakes.MsgBoxCBFuncs.MsgBoxCB11}
end
end

cartSnakes.MsgBoxCBFuncs.MsgBoxCB11 = function(action)
if action ~= nil then
-- #GroupDescription=get the new snake speed --
-- #Comment=get the new snake speed Comment --
iForesterActions = 7
end
end

cartSnakes.MsgBoxCBFuncs.MsgBoxCB2 = function(action)
if action ~= nil then
-- #GroupDescription=get input --
-- #Comment=get input Comment --
Wherigo.GetInput(zinputVisibleDistance)
end
end

cartSnakes.MsgBoxCBFuncs.MsgBoxCB3 = function(action)
if action ~= nil then
-- #GroupDescription=get input --
-- #Comment=get input Comment --
Wherigo.GetInput(zinputCenterDistance)
end
end

cartSnakes.MsgBoxCBFuncs.MsgBoxCB4 = function(action)
if action ~= nil then
-- #GroupDescription=get input --
-- #Comment=get input Comment --
Wherigo.GetInput(zinputSnakeSpeedmodifier)
end
end

cartSnakes.MsgBoxCBFuncs.MsgBoxCB7 = function(action)
if action ~= nil then
-- #GroupDescription=get stick --
-- #Comment=get stick Comment --
iForesterActions = 4
zcharacterForester.Commands["Nicefire"].Enabled = false
end
end

cartSnakes.MsgBoxCBFuncs.MsgBoxCB8 = function(action)
if action ~= nil then
-- #GroupDescription=some fire --
-- #Comment=some fire Comment --
Wherigo.MessageBox{Text=[[Yes, well, no, well, sort of

Let me see...]],Media=zmediaForesterHappy,Callback=cartSnakes.MsgBoxCBFuncs.MsgBoxCB7}
end
end

cartSnakes.MsgBoxCBFuncs.MsgBoxCB9 = function(action)
if action ~= nil then
-- #GroupDescription=offer to help --
-- #Comment=offer to help Comment --
iForesterActions = 1
zcharacterForester.Description = [[The forester is heading off down a path.  You are not sure where he is going, so you better follow him.]]
zcharacterForester.Media = zmediaForesterWalking
zoneSmoke.Visible = false
end
end

cartSnakes.MsgBoxCBFuncs.MsgBoxCB5 = function(action)
if action ~= nil then
-- #GroupDescription=follow --
-- #Comment=follow Comment --
Wherigo.MessageBox{Text=[[Banish them!?!

That is indeed a noble cause, and a brave one if you ask me.  
Normally strangers make no end of trouble and I avoid them but for you I will make an exception.  Follow me, I have something for you that might help your cause.]],Media=zmediaForester,Callback=cartSnakes.MsgBoxCBFuncs.MsgBoxCB9}
end
end

cartSnakes.MsgBoxCBFuncs.MsgBoxCB6 = function(action)
if action ~= nil then
-- #GroupDescription=exploring forest --
-- #Comment=exploring forest Comment --
Wherigo.MessageBox{Text=[[Thats a dangerous thing to do these days.  The woods are full of snakes.  Even I dont go in to the centre any more.]],Media=zmediaForester,Buttons={"I will banish them",},Callback=cartSnakes.MsgBoxCBFuncs.MsgBoxCB5}
end
end

cartSnakes.MsgBoxCBFuncs.MsgBoxCB12 = function(action)
if action ~= nil then
-- #GroupDescription=get input --
-- #Comment=get input Comment --
Wherigo.GetInput(zinputNumberOfSnakes)
end
end

cartSnakes.MsgBoxCBFuncs.MsgBoxCB13 = function(action)
if action ~= nil then
-- #GroupDescription=get input --
-- #Comment=get input Comment --
Wherigo.GetInput(zinputWarningDistance)
end
end

------End Builder Generated callbacks, Do not Edit, this will be overwritten------
-- #Author Functions Go Here# --
function ztimerPlotSnakes:OnTick()
  if zoneMiddleoftheForest.Active == true then
    if bBusy == false then
      bBusy = true
      fHandleSnake(zcharacterSnake1, 1)
      if iSnakeNumbers > 1 then
        fHandleSnake(zcharacterSnake2, 0.5)
      end
      if iSnakeNumbers > 2 then
        fHandleSnake(zcharacterSnake3, 0.25)
      end
      if iSnakeNumbers > 3 then
        fHandleSnake(zcharacterSnake4, 0.7)
      end
      if iSnakeNumbers > 4 then
        fHandleSnake(zcharacterSnake5, 1.2)
      end
      bBusy = false
    end
  end
end


function zitemTablet:OnSetSnakeSpeed()
  -- #GroupDescription=How fast does the snake go --
  -- #Comment=How fast does the snake go Comment --
  Wherigo.MessageBox{Text=[[Current snake speed is: ]] .. iSnakeSpeed .. [[.]],Callback=cartSnakes.MsgBoxCBFuncs.MsgBoxCB1}
end


function zitemTablet:OnSetVisibleDistance()
  -- #GroupDescription=get new distance --
  -- #Comment=get new distance Comment --
  Wherigo.MessageBox{Text=[[The current viewing distance is:]] .. iVisibleDistance .. [[.]],Callback=cartSnakes.MsgBoxCBFuncs.MsgBoxCB2}
end

function zitemTablet:OnSetMaxSnakes()
  -- #GroupDescription=get new distance --
  -- #Comment=get new distance Comment --
  Wherigo.MessageBox{Text=[[The current number of snakes is:]] .. iSnakeNumbers .. [[.]],Callback=cartSnakes.MsgBoxCBFuncs.MsgBoxCB12}
end

function zitemTablet:OnSetTargetDistance()
  -- #GroupDescription=get distance to center --
  -- #Comment=get distance to center Comment --
  Wherigo.MessageBox{Text=[[Current distance to center is:]] .. iDistanceFromCenter .. [[.]],Callback=cartSnakes.MsgBoxCBFuncs.MsgBoxCB3}
end

function zitemTablet:OnSetSnakespeedModfier()
-- #GroupDescription=set snake speed modifier --
-- #Comment=set snake speed modifier Comment --
  Wherigo.MessageBox{Text=[[Current snake speed midifier is:]] .. iSnakeSpeedMod .. [[.]],Callback=cartSnakes.MsgBoxCBFuncs.MsgBoxCB4}
end

function zitemTablet:OnSetWarningDistance()
-- #GroupDescription=warning distance --
-- #Comment=warning distance Comment --
  Wherigo.MessageBox{Text=[[Current snake proximity warning is: ]] .. iWarningDistance .. [[m.]],Callback=cartSnakes.MsgBoxCBFuncs.MsgBoxCB13}
end


function zinputNumberOfSnakes:OnGetInput(input)
  -- #GroupDescription=get input --
  -- #Comment=get input Comment --
  if input ~= nil then 
    if input ~= "" then
      iSnakeNumbers = tonumber(input)
      Wherigo.MessageBox{Text="The number of snake is now " .. iSnakeNumbers .. "."}
      zcharacterSnake1.Visible=true
      if iSnakeNumbers > 1 then
        zcharacterSnake2.Visible=true
      else
        zcharacterSnake2.Visible=false
      end
      if iSnakeNumbers > 2 then
        zcharacterSnake3.Visible=true
      else
        zcharacterSnake3.Visible=false
      end
      if iSnakeNumbers > 3 then
        zcharacterSnake4.Visible=true
      else
        zcharacterSnake4.Visible=false
      end
      if iSnakeNumbers > 4 then
        zcharacterSnake5.Visible=true
      else
        zcharacterSnake5.Visible=false
      end
    end
  end
end

function zinputVisibleDistance:OnGetInput(input)
  -- #GroupDescription=get input --
  -- #Comment=get input Comment --
  if input ~= nil then 
    if input ~= "" then
      iVisibleDistance = tonumber(input)
      Wherigo.MessageBox{Text="The snake viewing distance is now " .. iVisibleDistance .. "."}
    end
  end
end

function zinputWarningDistance:OnGetInput(input)
  -- #GroupDescription=get input --
  -- #Comment=get input Comment --
  if input ~= nil then 
    if input ~= "" then
      iWarningDistance = tonumber(input)
      Wherigo.MessageBox{Text="The proximity warning is now set to " .. iWarningDistance .. "m."}
    end
  end
end

function zinputCenterDistance:OnGetInput(input)
  -- #GroupDescription=get input --
  -- #Comment=get input Comment --
  if input ~= nil then
    if input ~= "" then
      iDistanceFromCenter = tonumber(input)
      Wherigo.MessageBox{Text="The distance from center is now " .. iDistanceFromCenter .. "."}
    end
  end
end

function zinputSnakeSpeed:OnGetInput(input)
  if input ~= nil then
    if input ~= "" then
      iSnakeSpeed = tonumber(input)
      Wherigo.MessageBox{Text="The speed is now " .. iSnakeSpeed .. "."}
    end
  end
end

function zinputSnakeSpeedmodifier:OnGetInput(input)
  if input ~= nil then
    if input ~= "" then
      iSnakeSpeedMod = tonumber(input)
      Wherigo.MessageBox{Text="The modifier is now " .. iSnakeSpeedMod .. "."}
    end
  end
end


function fHandleSnake(snake, speedMult)
  iTimeTaken = iTimeTaken + 1
 
  -- work out how far away and which direction the player is from the snake
  local d2,b2 = Wherigo.VectorToPoint(snake.ObjectLocation,Player.ObjectLocation)
  
  -- work out how far away the player is from the center
  centerLocation = ZonePoint(51.404,-2.51039,0) -- this is where the player is trying to get to
  local d3,b3 = Wherigo.VectorToPoint(Player.ObjectLocation,centerLocation)
  
  -- work out how far away the player is from the Big snake
  bigSnakeLocation = ZonePoint(51.40337,-2.510559,0) -- this is where we dont want the player to get to
  local d4,b4 = Wherigo.VectorToPoint(bigSnakeLocation,Player.ObjectLocation)

  -- how far away from the various points of interest are we
  local distFromBigSnake = d4("m")
  local distFromCenter = d3("m")
  local distFromSnake = d2("m")

  -- check the player is not in the keep out section  
  if distFromBigSnake < 55  and bDevineIntervention == false then
    ztimerPlotForester:Stop()
    ztimerPlotSnakes:Stop()
    zoneStart.Active = false
    zoneSmoke.Active = false
    zoneForestersHome.Active = false
    zoneMiddleoftheForest.Active = false
    Wherigo.PlayAudio(zmediaBeep)
    Wherigo.MessageBox{Text=[[AAAAAAAARRRHHHHH!
A huge snake comes straight for you swallowing you in one go.

GAME OVER]],Media=zmediaEaten,}
  elseif distFromBigSnake < 70 and zitemStick.Media == zmediaStickFire  and bDevineIntervention == false then
    Wherigo.PlayAudio(zmediaBeep)
    Wherigo.MessageBox{Text=[[You have a very bad feeling about going any further this way. Out of the corner of your eye you think see something large and fast move through the trees.  Even your burning stick will not keep you safe.]],}
  elseif distFromBigSnake < 70 and bDevineIntervention == false then
    Wherigo.PlayAudio(zmediaBeep)
    Wherigo.MessageBox{Text=[[Your have a bad feeling about going any further this way. Out of the corner of your eye you think see something large and fast move through the trees.]],}
  end

  -- is snake visible
  if distFromCenter > 210 then
    -- player in safe area
    ztimerPlotSnakes:Stop()
    zcharacterSnake1.Visible=false
    zcharacterSnake2.Visible=false
    zcharacterSnake3.Visible=false
    zcharacterSnake4.Visible=false
    zcharacterSnake5.Visible=false
  else
    -- player in snake area
    if snake.Visible == false then
      snake.Visible=true
    end

    -- is the snake out of viewing range, if so, bring it into viewing range
    if distFromSnake > iVisibleDistance then
      local distSnake = Wherigo.Distance(iVisibleDistance, 'm')
      local bearing = math.random(0.000,360.000)
      local newOb = Wherigo.TranslatePoint(Player.ObjectLocation, distSnake, bearing)   -- new point for the snake
      snake.ObjectLocation.latitude = newOb.latitude
      snake.ObjectLocation.longitude = newOb.longitude
    else
      -- Find out how aggressive the snake will be
      if distFromCenter > 80 or bDevineIntervention == true then
        iSnakeSpeed = 0
      else
        iSnakeSpeed = ((80-distFromCenter )/2)*speedMult*iSnakeSpeedMod 
      end
      if distFromSnake < 10 and zitemStick.Media == zmediaStickFire and bDevineIntervention == false  then
        iSnakeSpeed = -2 
        distFromSnake = 10
      end
      
      if distFromSnake <= 5 and bDevineIntervention == false  then
        Wherigo.PlayAudio(zmediaBeep)
      end
      
      -- correct speed if its going faster than the remaining distance left to avoid over shoot
      if iSnakeSpeed > distFromSnake then
        iSnakeSpeed = distFromSnake
      end
    
      -- is the snake close enough to bite
      if distFromSnake < 1 and bDevineIntervention == false then
        ztimerPlotForester:Stop()
        ztimerPlotSnakes:Stop()
        zoneStart.Active = false
        zoneSmoke.Active = false
        zoneForestersHome.Active = false
        zoneMiddleoftheForest.Active = false
        Wherigo.PlayAudio(zmediaBeep)
        Wherigo.MessageBox{Text=[[AWWWWWW!
You just walked on a snake, or maybe the snake crept up on you.
You feel dizzy and collapse in a heap on the ground.

GAME OVER]],Media=zmediaSnakeBite,}
      end

      -- Move the snake closer to the player by snakespeed distance
      local distSnakeMoved = Wherigo.Distance(iSnakeSpeed, 'm')
      local newOp = Wherigo.TranslatePoint(snake.ObjectLocation, distSnakeMoved, b2)   -- new point for the snake
      snake.ObjectLocation.latitude = newOp.latitude
      snake.ObjectLocation.longitude = newOp.longitude
    end
  

    -- provide feedback about how far the snake is away from the player
    local message = tostring(d2('m'))
    message=string.sub (message, 0,5)
    snake.Name = [[Snake ]] .. message .. [[m away]]
  end
end

function ztimerPlotForester:OnTick()
  -- work out how far away and which direction the player is from the forester
  local d1,b1 = Wherigo.VectorToPoint(zcharacterForester.ObjectLocation,Player.ObjectLocation)
  local distFromForester = d1("m")
  
  if distFromForester > 30 and zcharacterForester.Visible == true then
    zcharacterForester.Visible=false
  elseif distFromForester <= 30 and zcharacterForester.Visible == false then
    zcharacterForester.Visible=true
  end
  
  if zcharacterForester.Visible == true then
    local destZonePoint = ZonePoint(51.4020905046621,-2.5085017290367,0)
    if iForesterActions == 0 then
      -- do nothing, players need to say hello
    elseif iForesterActions == 1 then
      -- forester heading for gap in hedge
      destZonePoint = ZonePoint(51.40311844,-2.5092745,0)
    elseif iForesterActions == 2 then
      -- forester heading for home
      destZonePoint = zitemForestersHouse.ObjectLocation
    elseif iForesterActions == 4 then
      -- forester head for stick
      destZonePoint = zitemStick.ObjectLocation
    elseif iForesterActions == 5 then
      -- forester heading for player
      destZonePoint = Player.ObjectLocation
    elseif iForesterActions == 6 then
      -- forester giving stick to player
      destZonePoint = Player.ObjectLocation
    elseif iForesterActions == 7 then
      -- forester head for pot
      destZonePoint = zitemPotofBlackStuff.ObjectLocation
    elseif iForesterActions == 8 then
      -- forester heading for player
      destZonePoint = Player.ObjectLocation
    elseif iForesterActions == 9 then
      -- forester giving pot to player
      destZonePoint = zitemForestersHouse.ObjectLocation
    end
    
    -- work out direction the forester needs to move and how fast
    local d2,b2 = Wherigo.VectorToPoint(zcharacterForester.ObjectLocation,destZonePoint)
    local distToTarget = d2("m")
    local iSpeed=2.5*iSnakeSpeedMod 
    
    -- correct the speed if the current speed is inappropreate
    if iForesterActions == 0 then
      iSpeed=0
    elseif distFromForester > 20 and iForesterActions <= 2 then
      iSpeed=0
    elseif distToTarget < iSpeed then
      iSpeed=distToTarget 
    end  
     
    if distToTarget <= 1 and iForesterActions == 1 then
      -- arrived at gap in hedge, no go home
      iForesterActions = 2
    elseif distToTarget <= 1 and iForesterActions == 2 then
      -- arrived at home, wait for player
      iForesterActions = 3
      Wherigo.MessageBox{Text=[[Welcome to my home]],Media=zmediaForesterHouse,	}
      zoneForestersHome.Visible=true
      zcharacterForester.Media = zmediaForesterHappy
      zcharacterForester.Commands["Nicefire"].Enabled = true
      zcharacterForester.Description = [[A forester is here watching you with interest.]]
      zitemWoodPile.Commands["GetLogs"].Enabled = true
      zitemStick.Commands["ThrowStick"].Enabled = true
      iSpeed = 0
    elseif distToTarget <= 1 and iForesterActions == 4 then
      -- got the stick, head to player
      iForesterActions = 5
    elseif distToTarget <= 1 and iForesterActions == 5 then
      --  got to player, wait for dialog to finish
      iForesterActions = 6
      Wherigo.MessageBox{Text=[[Here we go, you will be needing this]],Media=zmediaStick,Buttons={"Thanks",},Callback=cartSnakes.MsgBoxCBFuncs.MsgBoxCB10}
      zitemStick:MoveTo(Player)
      iSpeed=0
    elseif distToTarget <= 1 and iForesterActions == 7 then
      -- got the pot, take it to the player
      iForesterActions = 8
    elseif distToTarget <= 1 and iForesterActions == 8 then
      --  got to player, wait for dialog to finish
      iForesterActions = 9
      Wherigo.MessageBox{Text=[[You will also want this.  A smile moves across the foresters face.  You look suspiciously down at the pot of black stuff wondering if you are meant to eat it.]],Media=zmediaPot,}
      zcharacterForester.Description = [[A forester is here watching you with interest.]]
      iSpeed=0
      zitemPotofBlackStuff:MoveTo(Player)
      zitemPotofBlackStuff.Commands["Examine"].Enabled = true
      ztimerPlotForester:Stop()
    end

    -- Move the forester closer to the player by snakespeed distance
    if iSpeed > 0 then
      local distForesterMoved = Wherigo.Distance(iSpeed, 'm')
      local newLoc = Wherigo.TranslatePoint(zcharacterForester.ObjectLocation, distForesterMoved, b2)
      zcharacterForester.ObjectLocation.latitude = newLoc.latitude
      zcharacterForester.ObjectLocation.longitude = newLoc.longitude
    end
  end
end

function ztimerPlotPet:OnTick()
-- #GroupDescription=tick --
-- #Comment=tick Comment --
if bPetActivated==true then
  bPetActivated=false
  local dist = Wherigo.Distance(20, 'm')
  local newOp = Wherigo.TranslatePoint(Player.ObjectLocation, dist, 0)   
  zcharacterSammy.ObjectLocation.latitude = newOp.latitude
  zcharacterSammy.ObjectLocation.longitude = newOp.longitude
end

local d2,b2 = Wherigo.VectorToPoint(zcharacterSammy.ObjectLocation,Player.ObjectLocation)
local speed = (d2(m)/50) * iSnakeSpeedMod
if speed < 1 then
  speed=1
end
local dist = Wherigo.Distance(speed, 'm')
local newOp = Wherigo.TranslatePoint(zcharacterSammy.ObjectLocation, dist, b2)   
zcharacterSammy.ObjectLocation.latitude = newOp.latitude
zcharacterSammy.ObjectLocation.longitude = newOp.longitude
local message = tostring(d2('m'))
message=string.sub (message, 0,5)
zcharacterSammy.Name = [[Sammy ]] .. message .. [[m away]]
end
-- #End Author Functions# --
-- Nothing after this line --
return cartSnakes
