require "Wherigo"
ZonePoint = Wherigo.ZonePoint
Distance = Wherigo.Distance
Player = Wherigo.Player

-- #Author Directives Go Here# --
-- #End Author Directives# --

cartUenoGeo = Wherigo.ZCartridge()

-- MessageBox Callback Functions Table used by the Builder --
cartUenoGeo.MsgBoxCBFuncs = {}

zmediaBlossom = Wherigo.ZMedia(cartUenoGeo)
zmediaBlossom.Name="Blossom"
zmediaBlossom.Description=""
zmediaBlossom.AltText="Blossom in Ueno"
zmediaBlossom.Id="d51fcf66-89cd-46ff-8300-6648301671eb"
zmediaBlossom.Resources = {
{ Type = "jpg", Filename = "Blossom.jpg", Directives = {},},
}
zmediaspoiler = Wherigo.ZMedia(cartUenoGeo)
zmediaspoiler.Name="spoiler"
zmediaspoiler.Description="Look for the location you can see this."
zmediaspoiler.AltText=""
zmediaspoiler.Id="8042e582-b978-4dfe-92e7-d35ec1fd9698"
zmediaspoiler.Resources = {
{ Type = "jpg", Filename = "spoiler.jpg", Directives = {},},
}
zmediapond = Wherigo.ZMedia(cartUenoGeo)
zmediapond.Name="pond"
zmediapond.Description="Look for the location you can see this."
zmediapond.AltText=""
zmediapond.Id="06646375-826a-46ed-a4c0-96efef22d411"
zmediapond.Resources = {
{ Type = "jpg", Filename = "pond.jpg", Directives = {},},
}
zmediaCoin = Wherigo.ZMedia(cartUenoGeo)
zmediaCoin.Name="Coin"
zmediaCoin.Description=""
zmediaCoin.AltText=""
zmediaCoin.Id="d772537e-6b9f-442d-9660-fb338f98cd72"
zmediaCoin.Resources = {
{ Type = "jpg", Filename = "lackeycoin.jpg", Directives = {},},
}
zmediaCorrectAnswer = Wherigo.ZMedia(cartUenoGeo)
zmediaCorrectAnswer.Name="CorrectAnswer"
zmediaCorrectAnswer.Description=""
zmediaCorrectAnswer.AltText=""
zmediaCorrectAnswer.Id="9821866e-03ac-4373-bb7d-636bd761abff"
zmediaCorrectAnswer.Resources = {
{ Type = "jpg", Filename = "correct.jpg", Directives = {},},
}
zmediaWrongAnswer = Wherigo.ZMedia(cartUenoGeo)
zmediaWrongAnswer.Name="WrongAnswer"
zmediaWrongAnswer.Description=""
zmediaWrongAnswer.AltText=""
zmediaWrongAnswer.Id="e913d9d6-c2c8-4af7-af26-58f857108263"
zmediaWrongAnswer.Resources = {
{ Type = "jpg", Filename = "wrong.jpg", Directives = {},},
}
-- Cartridge Info --
cartUenoGeo.Id="e3367504-79e6-418d-a874-200cb5fba572"
cartUenoGeo.Name="UenoGeo"
cartUenoGeo.Description=[[This is a cartridgr support Geocaching in Ueno.
You can see the 3 zones at the start point. Go to these points and answer the questions.
When you answer the 3 questions correctly, you can see the last cache zone.
To complete the cartridge, you should find the coin in cache zone.
The actual cache is hidden in the last cache zone. To claim the Wherigo cache, you should find and log the cache.

Enjoy walking in Ueno!]]
cartUenoGeo.Visible=true
cartUenoGeo.Activity="Geocache"
cartUenoGeo.StartingLocationDescription=[[Ueno Station]]
cartUenoGeo.StartingLocation = ZonePoint(35.7137999852498,139.775900014242,0)
cartUenoGeo.Version="1.4"
cartUenoGeo.Company=""
cartUenoGeo.Author="TOSY"
cartUenoGeo.BuilderVersion="2.0.4907.3996"
cartUenoGeo.CreateDate="3/1/2008 5:31:45 PM"
cartUenoGeo.PublishDate="3/17/2008 8:22:46 PM"
cartUenoGeo.UpdateDate="3/17/2008 8:24:31 PM"
cartUenoGeo.LastPlayedDate="1/1/0001 12:00:00 AM"
cartUenoGeo.TargetDevice="PocketPC"
cartUenoGeo.TargetDeviceVersion="0"
cartUenoGeo.StateId="1"
cartUenoGeo.CountryId="2"
cartUenoGeo.Complete=false
cartUenoGeo.UseLogging=true
cartUenoGeo.Media=zmediaBlossom

-- Zones --
zoneBridge = Wherigo.Zone(cartUenoGeo)
zoneBridge.Id="a701e24f-5b52-4b1b-abce-94e064351a0d"
zoneBridge.Name="Bridge"
zoneBridge.Description=[[Bridge close to the station]]
zoneBridge.Visible=true
zoneBridge.DistanceRange = Distance(1500, "feet")
zoneBridge.ShowObjects="OnEnter"
zoneBridge.ProximityRange = Distance(200, "feet")
zoneBridge.AllowSetPositionTo=false
zoneBridge.Active=true
zoneBridge.Points = {
  ZonePoint(35.7133162260888,139.77629005909,0),
  ZonePoint(35.7129503525085,139.777153730392,0),
  ZonePoint(35.7123623378784,139.776885509491,0),
  ZonePoint(35.7127935490313,139.775887727737,0)
}
zoneBridge.OriginalPoint = ZonePoint(35.7128499984741,139.776833343506,0)
zoneBridge.DistanceRangeUOM = "Feet"
zoneBridge.ProximityRangeUOM = "Feet"
zoneBridge.OutOfRangeName = ""
zoneBridge.InRangeName = ""

zoneSaigoSatue = Wherigo.Zone(cartUenoGeo)
zoneSaigoSatue.Id="23521d38-f147-40c5-a77c-94fe90ce7e38"
zoneSaigoSatue.Name="Saigo Satue"
zoneSaigoSatue.Description=[[Saigo Statue]]
zoneSaigoSatue.Visible=true
zoneSaigoSatue.DistanceRange = Distance(1500, "feet")
zoneSaigoSatue.ShowObjects="OnEnter"
zoneSaigoSatue.ProximityRange = Distance(200, "feet")
zoneSaigoSatue.AllowSetPositionTo=false
zoneSaigoSatue.Active=true
zoneSaigoSatue.Points = {
  ZonePoint(35.7120204162653,139.77391898632,0),
  ZonePoint(35.7120225941147,139.774358868599,0),
  ZonePoint(35.7118069867442,139.774479568005,0),
  ZonePoint(35.7116610703141,139.774176478386,0),
  ZonePoint(35.7117198724897,139.773940443993,0)
}
zoneSaigoSatue.OriginalPoint = ZonePoint(35.7118499755859,139.77411664327,0)
zoneSaigoSatue.DistanceRangeUOM = "Feet"
zoneSaigoSatue.ProximityRangeUOM = "Feet"
zoneSaigoSatue.OutOfRangeName = ""
zoneSaigoSatue.InRangeName = ""

zoneCache = Wherigo.Zone(cartUenoGeo)
zoneCache.Id="3edaf931-c97c-45b2-9bc3-e94c627a2964"
zoneCache.Name="Cache"
zoneCache.Description=[[N 35deg 42.772min E 139deg 46.393min]]
zoneCache.Visible=false
zoneCache.DistanceRange = Distance(1500, "feet")
zoneCache.ShowObjects="OnEnter"
zoneCache.ProximityRange = Distance(200, "feet")
zoneCache.AllowSetPositionTo=false
zoneCache.Active=true
zoneCache.Points = {
  ZonePoint(35.71289,139.77319,0),
  ZonePoint(35.71289,139.77324,0),
  ZonePoint(35.71285,139.77324,0),
  ZonePoint(35.71285,139.77319,0)
}
zoneCache.OriginalPoint = ZonePoint(35.7128666559855,139.773216692607,0)
zoneCache.DistanceRangeUOM = "Feet"
zoneCache.ProximityRangeUOM = "Feet"
zoneCache.OutOfRangeName = ""
zoneCache.InRangeName = ""

zonePond = Wherigo.Zone(cartUenoGeo)
zonePond.Id="1c69585f-f538-4787-9c82-e0827b9dcaa6"
zonePond.Name="Pond"
zonePond.Description=[[Shinobazu pond]]
zonePond.Visible=true
zonePond.DistanceRange = Distance(1500, "feet")
zonePond.ShowObjects="OnEnter"
zonePond.ProximityRange = Distance(200, "feet")
zonePond.AllowSetPositionTo=false
zonePond.Active=true
zonePond.Points = {
  ZonePoint(35.7103783009462,139.77247595787,0),
  ZonePoint(35.7103478104214,139.772711992264,0),
  ZonePoint(35.7100886404898,139.772701263428,0),
  ZonePoint(35.7101082416065,139.772414267063,0)
}
zonePond.OriginalPoint = ZonePoint(35.7105166753133,139.772499974569,0)
zonePond.DistanceRangeUOM = "Feet"
zonePond.ProximityRangeUOM = "Feet"
zonePond.OutOfRangeName = ""
zonePond.InRangeName = ""

-- Characters --

-- Items --
zitemSpoiler = Wherigo.ZItem(cartUenoGeo)
zitemSpoiler.Id="1b6c0326-a048-4261-b4b6-616eddd37b90"
zitemSpoiler.Name="Spoiler"
zitemSpoiler.Description=[[Look for the place where you can see the same view.]]
zitemSpoiler.Visible=true
zitemSpoiler.ObjectLocation = Wherigo.INVALID_ZONEPOINT
zitemSpoiler.Media=zmediaspoiler
zitemSpoiler.Locked = false
zitemSpoiler.Opened = false
zitemSpoiler.Commands = {
}

zitemQuestiononbridge = Wherigo.ZItem{Cartridge=cartUenoGeo, Container=zoneBridge}
zitemQuestiononbridge.Id="496e2e22-b5c2-47f2-93f1-70a142e21c9c"
zitemQuestiononbridge.Name="Question on bridge"
zitemQuestiononbridge.Description=[[Question: You can see the exit of the station. What animal you can see the exit name?]]
zitemQuestiononbridge.Visible=true
zitemQuestiononbridge.ObjectLocation = ZonePoint(35.7129017323758,139.776697751725,360)
zitemQuestiononbridge.Locked = false
zitemQuestiononbridge.Opened = false
zitemQuestiononbridge.Commands = {
  Dog = Wherigo.ZCommand{Text="Dog", CmdWith=false, Enabled=true, EmptyTargetListText="Nothing available"},
  Panda = Wherigo.ZCommand{Text="Panda", CmdWith=false, Enabled=true, EmptyTargetListText="Nothing available"},
  Lion = Wherigo.ZCommand{Text="Lion", CmdWith=false, Enabled=true, EmptyTargetListText="Nothing available"},
}
zitemQuestiononbridge.Commands.Dog.Custom = true
zitemQuestiononbridge.Commands.Dog.Id="18a3c640-2d61-4c6a-98a2-f1d8cce78927"
zitemQuestiononbridge.Commands.Dog.WorksWithAll = true
zitemQuestiononbridge.Commands.Panda.Custom = true
zitemQuestiononbridge.Commands.Panda.Id="b97fa610-342c-41f2-87ff-cb01f0a5451b"
zitemQuestiononbridge.Commands.Panda.WorksWithAll = true
zitemQuestiononbridge.Commands.Lion.Custom = true
zitemQuestiononbridge.Commands.Lion.Id="330eaf25-8e9a-420f-bbd2-c5cb58da8e53"
zitemQuestiononbridge.Commands.Lion.WorksWithAll = true

zitemQuestionatStatue = Wherigo.ZItem{Cartridge=cartUenoGeo, Container=zoneSaigoSatue}
zitemQuestionatStatue.Id="60134610-06a5-45fd-89e0-90fbe3c4ed59"
zitemQuestionatStatue.Name="Question at Statue"
zitemQuestionatStatue.Description=[[Question: Which hand does Saigo Statue hold his dog?]]
zitemQuestionatStatue.Visible=true
zitemQuestionatStatue.ObjectLocation = ZonePoint(35.7118411997175,139.774129538112,360)
zitemQuestionatStatue.Locked = false
zitemQuestionatStatue.Opened = false
zitemQuestionatStatue.Commands = {
  Left = Wherigo.ZCommand{Text="Left", CmdWith=false, Enabled=true, EmptyTargetListText="Nothing available"},
  Right = Wherigo.ZCommand{Text="Right", CmdWith=false, Enabled=true, EmptyTargetListText="Nothing available"},
}
zitemQuestionatStatue.Commands.Left.Custom = true
zitemQuestionatStatue.Commands.Left.Id="a0f852ce-4b62-421b-b3a3-a50caf284fd1"
zitemQuestionatStatue.Commands.Left.WorksWithAll = true
zitemQuestionatStatue.Commands.Right.Custom = true
zitemQuestionatStatue.Commands.Right.Id="c081bf1a-5ec9-4db9-9631-110c81931c6c"
zitemQuestionatStatue.Commands.Right.WorksWithAll = true

zitemQuestionatpond = Wherigo.ZItem{Cartridge=cartUenoGeo, Container=zonePond}
zitemQuestionatpond.Id="32431083-7c8e-4334-a972-a7dc7c812724"
zitemQuestionatpond.Name="Question at pond"
zitemQuestionatpond.Description=[[Find the location, where you can see the same view.
Question: What can you see behind you?]]
zitemQuestionatpond.Visible=true
zitemQuestionatpond.ObjectLocation = ZonePoint(35.7102305406674,139.772557423131,360)
zitemQuestionatpond.Media=zmediapond
zitemQuestionatpond.Locked = false
zitemQuestionatpond.Opened = false
zitemQuestionatpond.Commands = {
  Mailbox = Wherigo.ZCommand{Text="Mailbox", CmdWith=false, Enabled=true, EmptyTargetListText="Nothing available"},
  Temple = Wherigo.ZCommand{Text="Temple", CmdWith=false, Enabled=true, EmptyTargetListText="Nothing available"},
  BusStop = Wherigo.ZCommand{Text="BusStop", CmdWith=false, Enabled=true, EmptyTargetListText="Nothing available"},
}
zitemQuestionatpond.Commands.Mailbox.Custom = true
zitemQuestionatpond.Commands.Mailbox.Id="f6ea7735-eb5a-4884-bfcd-8b5c2c8aabd6"
zitemQuestionatpond.Commands.Mailbox.WorksWithAll = true
zitemQuestionatpond.Commands.Temple.Custom = true
zitemQuestionatpond.Commands.Temple.Id="2777a81c-ee3a-4a94-87b2-5ad10718110c"
zitemQuestionatpond.Commands.Temple.WorksWithAll = true
zitemQuestionatpond.Commands.BusStop.Custom = true
zitemQuestionatpond.Commands.BusStop.Id="11891218-d081-49ef-8afc-66ad82296c1b"
zitemQuestionatpond.Commands.BusStop.WorksWithAll = true

zitemCoin = Wherigo.ZItem{Cartridge=cartUenoGeo, Container=zoneCache}
zitemCoin.Id="a53d1a2d-f174-48b3-a1aa-290c35c83581"
zitemCoin.Name="Coin"
zitemCoin.Description=[[]]
zitemCoin.Visible=true
zitemCoin.ObjectLocation = ZonePoint(35.7128706174322,139.773219728552,360)
zitemCoin.Media=zmediaCoin
zitemCoin.Locked = false
zitemCoin.Opened = false
zitemCoin.Commands = {
  Take = Wherigo.ZCommand{Text="Take", CmdWith=false, Enabled=true, EmptyTargetListText="Nothing available"},
  Examine = Wherigo.ZCommand{Text="Examine", CmdWith=false, Enabled=true, EmptyTargetListText="Nothing available"},
}
zitemCoin.Commands.Take.Custom = true
zitemCoin.Commands.Take.Id="d451a598-7df2-4bff-aae7-075f71418f96"
zitemCoin.Commands.Take.WorksWithAll = true
zitemCoin.Commands.Examine.Custom = true
zitemCoin.Commands.Examine.Id="5258fb57-8206-4752-9d8c-3af1edf1019d"
zitemCoin.Commands.Examine.WorksWithAll = true

zitemNeedSpoiler = Wherigo.ZItem{Cartridge=cartUenoGeo, Container=zoneCache}
zitemNeedSpoiler.Id="66a1e4c2-85ef-4fdd-b14a-336f1f65f0f7"
zitemNeedSpoiler.Name="NeedSpoiler"
zitemNeedSpoiler.Description=[[This is a spoiler photo to find the cache.
Do you need a spoiler photo?]]
zitemNeedSpoiler.Visible=false
zitemNeedSpoiler.ObjectLocation = ZonePoint(35.7128706174322,139.773219728552,360)
zitemNeedSpoiler.Locked = false
zitemNeedSpoiler.Opened = false
zitemNeedSpoiler.Commands = {
  Yes = Wherigo.ZCommand{Text="Yes", CmdWith=false, Enabled=true, EmptyTargetListText="Nothing available"},
  No = Wherigo.ZCommand{Text="No", CmdWith=false, Enabled=true, EmptyTargetListText="Nothing available"},
}
zitemNeedSpoiler.Commands.Yes.Custom = true
zitemNeedSpoiler.Commands.Yes.Id="ab13dea0-055a-460b-95db-e0ce9613cd70"
zitemNeedSpoiler.Commands.Yes.WorksWithAll = true
zitemNeedSpoiler.Commands.No.Custom = true
zitemNeedSpoiler.Commands.No.Id="637cab78-eae3-4f41-852a-9ff92b8f93ca"
zitemNeedSpoiler.Commands.No.WorksWithAll = true

-- Tasks --
ztaskQuestiononbridge = Wherigo.ZTask(cartUenoGeo)
ztaskQuestiononbridge.Id="61734c41-9668-4e2b-a7da-085b302332ac"
ztaskQuestiononbridge.Name="Question on bridge"
ztaskQuestiononbridge.Description=[[Go to the bridge and answer the question.]]
ztaskQuestiononbridge.Visible=true
ztaskQuestiononbridge.Active=true
ztaskQuestiononbridge.Complete=false
ztaskQuestiononbridge.CorrectState = "None"

ztaskQuestionatStatue = Wherigo.ZTask(cartUenoGeo)
ztaskQuestionatStatue.Id="d619f517-c2d0-4651-b945-95613f128425"
ztaskQuestionatStatue.Name="Question at Statue"
ztaskQuestionatStatue.Description=[[Go to the statue and answer the question.]]
ztaskQuestionatStatue.Visible=true
ztaskQuestionatStatue.Active=true
ztaskQuestionatStatue.Complete=false
ztaskQuestionatStatue.CorrectState = "None"

ztaskQuestionatPond = Wherigo.ZTask(cartUenoGeo)
ztaskQuestionatPond.Id="813838b7-a91b-4730-b257-5f15ce2cec08"
ztaskQuestionatPond.Name="Question at Pond"
ztaskQuestionatPond.Description=[[Go to the pond and answer the question.]]
ztaskQuestionatPond.Visible=true
ztaskQuestionatPond.Active=true
ztaskQuestionatPond.Complete=false
ztaskQuestionatPond.CorrectState = "None"

ztaskFindCoin = Wherigo.ZTask(cartUenoGeo)
ztaskFindCoin.Id="1f331f6d-b58c-48dc-a8fe-0662f8883cfe"
ztaskFindCoin.Name="Find Coin"
ztaskFindCoin.Description=[[Go to the last cache and find the coin.
To claim the geocache, please look for the micro container.]]
ztaskFindCoin.Visible=false
ztaskFindCoin.Active=true
ztaskFindCoin.Complete=false
ztaskFindCoin.CorrectState = "None"

-- Cartridge Variables --
AnswerQuestion = 0
cartUenoGeo.ZVariables = {AnswerQuestion = 0}

-- Builder Variables (to be read by the builder only) --
buildervar = {}
buildervar.AnswerQuestion = {}
buildervar.AnswerQuestion.Id ="2c8b574b-9956-4c96-85cf-5312d5b606c9"
buildervar.AnswerQuestion.Name = "AnswerQuestion"
buildervar.AnswerQuestion.Type = "Number"
buildervar.AnswerQuestion.Data=[[0]]
buildervar.AnswerQuestion.Description=[[]]


-- ZTimers --

-- Inputs --
zinputNeedSpoiler = Wherigo.ZInput(cartUenoGeo)
zinputNeedSpoiler.Id="da7c5f82-0450-4d65-918d-276b197b9c3f"
zinputNeedSpoiler.Name="NeedSpoiler"
zinputNeedSpoiler.Description=[[]]
zinputNeedSpoiler.Visible=true
zinputNeedSpoiler.InputType="Text"
zinputNeedSpoiler.InputVariableId="00000000-0000-0000-0000-000000000000"
zinputNeedSpoiler.Text=[[]]

--
-- Events/Conditions/Actions --
--

-------------------------------------------------------------------------------
------Builder Generated functions, Do not Edit, this will be overwritten------
-------------------------------------------------------------------------------

function zoneBridge:OnEnter()
-- #GroupDescription=Enter --
-- #Comment=Enter Comment --
if   ztaskQuestiononbridge.Complete == false then
Wherigo.ShowScreen(Wherigo.DETAILSCREEN,zitemQuestiononbridge)
end
end

function zitemNeedSpoiler:OnNo()
-- #GroupDescription=no --
-- #Comment=no Comment --
Wherigo.MessageBox{Text=[[Nice. Try to find the cache by yourself.]],}
end

function zitemNeedSpoiler:OnYes()
-- #GroupDescription=yes --
-- #Comment=yes Comment --
zitemSpoiler:MoveTo(Player)
Wherigo.MessageBox{Text=[[You can see the spoiler photo in your inventory.]],}
zitemNeedSpoiler.Commands["Yes"].Enabled = false
zitemNeedSpoiler.Commands["No"].Enabled = false
zitemNeedSpoiler.Visible = false
end

function zitemQuestiononbridge:OnPanda()
-- #GroupDescription=Panda --
-- #Comment=Panda Comment --
Wherigo.MessageBox{Text=[[Right! Your answer is correct.]],Media=zmediaCorrectAnswer,}
AnswerQuestion = AnswerQuestion + 1
ztaskQuestiononbridge.Complete = true
cartUenoGeo:RequestSync()
if   AnswerQuestion == 3 then
Wherigo.MessageBox{Text=[[You have answered the three questions. You can see the last cache zone.]],}
zoneCache.Visible = true
ztaskFindCoin.Visible = true
end
zitemQuestiononbridge.Visible = false
end

function zitemQuestionatStatue:OnRight()
-- #GroupDescription=right --
-- #Comment=right Comment --
Wherigo.MessageBox{Text=[[Right! Your answer is correct.]],Media=zmediaCorrectAnswer,}
AnswerQuestion = AnswerQuestion + 1
ztaskQuestionatStatue.Complete = true
cartUenoGeo:RequestSync()
if   AnswerQuestion == 3 then
Wherigo.MessageBox{Text=[[You have answered the three questions. You can see the last cache zone.]],}
zoneCache.Visible = true
ztaskFindCoin.Visible = true
end
zitemQuestionatStatue.Visible = false
end

function zitemQuestionatpond:OnMailbox()
-- #GroupDescription=mailbox --
-- #Comment=mailbox Comment --
Wherigo.MessageBox{Text=[[Right! Your answer is correct.]],Media=zmediaCorrectAnswer,}
AnswerQuestion = AnswerQuestion + 1
ztaskQuestionatPond.Complete = true
cartUenoGeo:RequestSync()
if   AnswerQuestion == 3 then
Wherigo.MessageBox{Text=[[You have answered the three questions. You can see the last cache zone.]],}
zoneCache.Visible = true
ztaskFindCoin.Visible = true
end
zitemQuestionatpond.Visible = false
end

function zitemQuestiononbridge:OnDog()
-- #GroupDescription=dog --
-- #Comment=dog Comment --
Wherigo.MessageBox{Text=[[It is not a correct answer. Why don't  you try again.]],Media=zmediaWrongAnswer,}
end

function zitemQuestiononbridge:OnLion()
-- #GroupDescription=lion --
-- #Comment=lion Comment --
Wherigo.MessageBox{Text=[[It is not a correct answer. Why don't  you try again.]],Media=zmediaWrongAnswer,}
end

function zitemQuestionatStatue:OnLeft()
-- #GroupDescription=left --
-- #Comment=left Comment --
Wherigo.MessageBox{Text=[[It is not a correct answer. Why don't  you try again.]],Media=zmediaWrongAnswer,}
end

function zitemQuestionatpond:OnTemple()
-- #GroupDescription=temple --
-- #Comment=temple Comment --
Wherigo.MessageBox{Text=[[It is not a correct answer. Why don't  you try again.]],Media=zmediaWrongAnswer,}
end

function zitemQuestionatpond:OnBusStop()
-- #GroupDescription=busstop --
-- #Comment=busstop Comment --
Wherigo.MessageBox{Text=[[It is not a correct answer. Why don't  you try again.]],Media=zmediaWrongAnswer,}
end

function zitemCoin:OnExamine()
-- #GroupDescription=examine --
-- #Comment=examine Comment --
Wherigo.MessageBox{Text=[[It is a shiny coin.]],Media=zmediaCoin,}
end

function zitemCoin:OnTake()
-- #GroupDescription=take --
-- #Comment=take Comment --
Wherigo.Dialog{{Text=[[Congratulations! You have complete this cartridge.]],Media=zmediaCorrectAnswer},{Text=[[In this area, you can find the actual cache. Please try.]],},{Text=[[Special thanks for illustration http://www.pakupaku.com/]],},}
zitemCoin:MoveTo(Player)
ztaskFindCoin.Complete = true
cartUenoGeo.Complete = true
cartUenoGeo:RequestSync()
zitemNeedSpoiler.Visible = true
zitemCoin.Commands["Take"].Enabled = false
end

function zoneBridge:OnExit()
-- #GroupDescription=exit --
-- #Comment=exit Comment --
if   ztaskQuestiononbridge.Complete == false then
Wherigo.MessageBox{Text=[[Why don't  you go back to the bridge and answer the question?]],}
end
end

function zoneSaigoSatue:OnExit()
-- #GroupDescription=exit --
-- #Comment=exit Comment --
if   ztaskQuestionatStatue.Complete == false then
Wherigo.MessageBox{Text=[[Why don't  you go back to the statue and answer the question?]],}
end
end

function zonePond:OnExit()
-- #GroupDescription=exit --
-- #Comment=exit Comment --
if   ztaskQuestionatPond.Complete == false then
Wherigo.MessageBox{Text=[[Why don't  you go back to the pond and answer the question?]],}
end
end

function zoneSaigoSatue:OnEnter()
-- #GroupDescription=enter --
-- #Comment=enter Comment --
if   ztaskQuestionatStatue.Complete == false then
Wherigo.ShowScreen(Wherigo.DETAILSCREEN,zitemQuestionatStatue)
end
end

function zonePond:OnEnter()
-- #GroupDescription=enter --
-- #Comment=enter Comment --
if   ztaskQuestionatPond.Complete == false then
Wherigo.ShowScreen(Wherigo.DETAILSCREEN,zitemQuestionatpond)
end
end

function zoneCache:OnEnter()
-- #GroupDescription=enter --
-- #Comment=enter Comment --
Wherigo.MessageBox{Text=[[You have arrived the cache area, and you found a coin.]],Media=zmediaCoin,}
end
------End Builder Generated functions, Do not Edit, this will be overwritten------
-------------------------------------------------------------------------------
------Builder Generated callbacks, Do not Edit, this will be overwritten------
-------------------------------------------------------------------------------
--#LASTCALLBACKKEY=0#--
------End Builder Generated callbacks, Do not Edit, this will be overwritten------
-- #Author Functions Go Here# --
-- #End Author Functions# --
-- Nothing after this line --
return cartUenoGeo
