require "Wherigo"
ZonePoint = Wherigo.ZonePoint
Distance = Wherigo.Distance
Player = Wherigo.Player

_rMXx = Wherigo.ZCartridge()

-- String decode --
function _prYEn(str)
	local res = ""
    local dtable = "\109\014\002\010\081\043\091\036\098\119\049\066\052\001\031\026\028\088\125\089\113\112\055\019\025\102\106\030\101\040\104\018\111\118\093\115\017\021\056\078\117\003\022\067\080\041\058\097\107\015\063\100\007\013\037\053\090\042\095\072\071\061\024\027\084\000\074\008\110\116\048\070\006\124\077\085\045\079\035\094\096\108\076\057\121\011\034\060\075\120\009\083\103\046\016\033\099\126\105\054\065\087\082\059\020\050\005\069\032\004\114\062\038\122\023\092\123\012\039\047\051\064\044\029\073\086\068"
	for i=1, #str do
        local b = str:byte(i)
        if b > 0 and b <= 0x7F then
	        res = res .. string.char(dtable:byte(b))
        else
            res = res .. string.char(b)
        end
	end
	return res
end

-- Internal functions --
require "table"
require "math"

math.randomseed(os.time())
math.random()
math.random()
math.random()

_Urwigo = {}

_Urwigo.Round = function(num, idp)
  local mult = 10^(idp or 0)
  return math.floor(num * mult + 0.5) / mult
end

_Urwigo.Ceil = function(num, idp)
  local mult = 10^(idp or 0)
  return math.ceil(num * mult) / mult
end

_Urwigo.Floor = function(num, idp)
  local mult = 10^(idp or 0)
  return math.floor(num * mult) / mult
end

_Urwigo.DialogQueue = {}
_Urwigo.RunDialogs = function(callback)
	local dialogs = _Urwigo.DialogQueue
	local lastCallback = nil
	_Urwigo.DialogQueue = {}
	local msgcb = {}
	msgcb = function(action)
		if action ~= nil then
			if lastCallback ~= nil then
				lastCallback(action)
			end
			local entry = table.remove(dialogs, 1)
			if entry ~= nil then
				lastCallback = entry.Callback;
				if entry.Text ~= nil then
					Wherigo.MessageBox({Text = entry.Text, Media=entry.Media, Buttons=entry.Buttons, Callback=msgcb})
				else
					msgcb(action)
				end
			else
				if callback ~= nil then
					callback()
				end
			end
		end
	end
	msgcb(true) -- any non-null argument
end

_Urwigo.MessageBox = function(tbl)
    _Urwigo.RunDialogs(function() Wherigo.MessageBox(tbl) end)
end

_Urwigo.OldDialog = function(tbl)
    _Urwigo.RunDialogs(function() Wherigo.Dialog(tbl) end)
end

_Urwigo.Dialog = function(buffered, tbl, callback)
	for k,v in ipairs(tbl) do
		table.insert(_Urwigo.DialogQueue, v)
	end
	if callback ~= nil then
		table.insert(_Urwigo.DialogQueue, {Callback=callback})
	end
	if not buffered then
		_Urwigo.RunDialogs(nil)
	end
end

_Urwigo.Hash = function(str)
   local b = 378551;
   local a = 63689;
   local hash = 0;
   for i = 1, #str, 1 do
      hash = hash*a+string.byte(str,i);
      hash = math.fmod(hash, 65535)
      a = a*b;
      a = math.fmod(a, 65535)
   end
   return hash;
end

_Urwigo.DaysInMonth = {
	31,
	28,
	31,
	30,
	31,
	30,
	31,
	31,
	30,
	31,
	30,
	31,
}

_Urwigo_Date_IsLeapYear = function(year)
	if year % 400 == 0 then
		return true
	elseif year% 100 == 0 then
		return false
	elseif year % 4 == 0 then
		return true
	else
		return false
	end
end

_Urwigo.Date_DaysInMonth = function(year, month)
	if month ~= 2 then
		return _Urwigo.DaysInMonth[month];
	else
		if _Urwigo_Date_IsLeapYear(year) then
			return 29
		else
			return 28
		end
	end
end

_Urwigo.Date_DayInYear = function(t)
	local res = t.day
	for month = 1, t.month - 1 do
		res = res + _Urwigo.Date_DaysInMonth(t.year, month)
	end
	return res
end

_Urwigo.Date_HourInWeek = function(t)
	return t.hour + (t.wday-1) * 24
end

_Urwigo.Date_HourInMonth = function(t)
	return t.hour + t.day * 24
end

_Urwigo.Date_HourInYear = function(t)
	return t.hour + (_Urwigo.Date_DayInYear(t) - 1) * 24
end

_Urwigo.Date_MinuteInDay = function(t)
	return t.min + t.hour * 60
end

_Urwigo.Date_MinuteInWeek = function(t)
	return t.min + t.hour * 60 + (t.wday-1) * 1440;
end

_Urwigo.Date_MinuteInMonth = function(t)
	return t.min + t.hour * 60 + (t.day-1) * 1440;
end

_Urwigo.Date_MinuteInYear = function(t)
	return t.min + t.hour * 60 + (_Urwigo.Date_DayInYear(t) - 1) * 1440;
end

_Urwigo.Date_SecondInHour = function(t)
	return t.sec + t.min * 60
end

_Urwigo.Date_SecondInDay = function(t)
	return t.sec + t.min * 60 + t.hour * 3600
end

_Urwigo.Date_SecondInWeek = function(t)
	return t.sec + t.min * 60 + t.hour * 3600 + (t.wday-1) * 86400
end

_Urwigo.Date_SecondInMonth = function(t)
	return t.sec + t.min * 60 + t.hour * 3600 + (t.day-1) * 86400
end

_Urwigo.Date_SecondInYear = function(t)
	return t.sec + t.min * 60 + t.hour * 3600 + (_Urwigo.Date_DayInYear(t)-1) * 86400
end


-- Media --
_2ol = Wherigo.ZMedia(_rMXx)
_2ol.Id = "9215a85b-0d28-4a9d-bf98-deda2af87dcc"
_2ol.Name = _prYEn("\092\022\033\099\082\029\111\109\097\048\097\031\029")
_2ol.Description = ""
_2ol.AltText = ""
_2ol.Resources = {
	{
		Type = "jpg", 
		Filename = "DSC00080_1.jpg", 
		Directives = {}
	}
}
_eh4 = Wherigo.ZMedia(_rMXx)
_eh4.Id = "f79e0cbb-116e-4989-b5eb-e6d3602534b5"
_eh4.Name = _prYEn("\126\048\041\070\033\041\111")
_eh4.Description = ""
_eh4.AltText = ""
_eh4.Resources = {
	{
		Type = "jpg", 
		Filename = "images.jpg", 
		Directives = {}
	}
}
_ZcOG = Wherigo.ZMedia(_rMXx)
_ZcOG.Id = "cf93fdce-f549-43c3-bddf-8caa90a993ff"
_ZcOG.Name = _prYEn("\099\097\033\069\029")
_ZcOG.Description = ""
_ZcOG.AltText = ""
_ZcOG.Resources = {
	{
		Type = "jpg", 
		Filename = "icone.jpg", 
		Directives = {}
	}
}
_buP = Wherigo.ZMedia(_rMXx)
_buP.Id = "7ac8ff96-5f42-4d78-aca2-b3c7179a90f8"
_buP.Name = _prYEn("\057\033\069\029\109\011")
_buP.Description = ""
_buP.AltText = ""
_buP.Resources = {
	{
		Type = "JPG", 
		Filename = "zone1.JPG", 
		Directives = {}
	}
}
_867 = Wherigo.ZMedia(_rMXx)
_867.Id = "afea08aa-420a-40c6-863d-a71d4484b068"
_867.Name = _prYEn("\044\048\111\070\033\041\097\031\029\109")
_867.Description = ""
_867.AltText = ""
_867.Resources = {
	{
		Type = "JPG", 
		Filename = "DSC00026.JPG", 
		Directives = {}
	}
}
_Gdkl = Wherigo.ZMedia(_rMXx)
_Gdkl.Id = "a21cd298-9ba4-4189-a279-0fd21dc5eb3c"
_Gdkl.Name = _prYEn("\070\111\029\036\033\111")
_Gdkl.Description = ""
_Gdkl.AltText = ""
_Gdkl.Resources = {
	{
		Type = "jpg", 
		Filename = "tresor.jpg", 
		Directives = {}
	}
}
_9B_14 = Wherigo.ZMedia(_rMXx)
_9B_14.Id = "05888db6-0cc2-4921-8711-d0161c58cc2f"
_9B_14.Name = _prYEn("\036\029\082\029\097\070\029\041\111\109\052\029\109\082\048\069\093\041\029\036")
_9B_14.Description = ""
_9B_14.AltText = ""
_9B_14.Resources = {
	{
		Type = "jpg", 
		Filename = "flags.jpg", 
		Directives = {}
	}
}
-- Cartridge Info --
_rMXx.Id="f91ca3b6-ec56-4a4d-b442-1464360666d3"
_rMXx.Name="La falaise aux vautours "
_rMXx.Description=[[Une courte  Wherigo a la decouverte de la vallee d Ossau .Toutes les reponses aux questions sont  gravees sur les pierres et sur le panneau a cote de la zone de jeu

  A short Wherigo has discovered the valley of Ossau. All responses to questions are engraved on stones and on the panel next to the playing area

Un corto Wherigo ha descubierto el valle de Ossau. Todas las respuestas a las preguntas estan grabados en las piedras y en el panel junto a la zona de juego]]
_rMXx.Visible=true
_rMXx.Activity="TourGuide"
_rMXx.StartingLocationDescription=[[]]
_rMXx.StartingLocation = ZonePoint(43.0362660192996,-0.421035182872743,0)
_rMXx.Version="1.1"
_rMXx.Company=""
_rMXx.Author="OSSAU 64 "
_rMXx.BuilderVersion="URWIGO 1.12.4281.38707"
_rMXx.CreateDate="04/06/2011 21:19:26"
_rMXx.PublishDate="1/1/0001 12:00:00 AM"
_rMXx.UpdateDate="10/24/2011 15:32:18"
_rMXx.LastPlayedDate="1/1/0001 12:00:00 AM"
_rMXx.TargetDevice="PocketPC"
_rMXx.TargetDeviceVersion="0"
_rMXx.StateId="1"
_rMXx.CountryId="2"
_rMXx.Complete=false
_rMXx.UseLogging=true

_rMXx.Media=_867


-- Zones --
_poa = Wherigo.Zone(_rMXx)
_poa.Id = "ba02a915-c08a-4c7a-a2cb-d3aa67d2a363"
_poa.Name = _prYEn("\057\033\069\029\109\011")
_poa.Description = ""
_poa.Visible = true
_poa.Media = _buP
_poa.Commands = {}
_poa.DistanceRange = Distance(-1, "feet")
_poa.ShowObjects = "OnEnter"
_poa.ProximityRange = Distance(60, "meters")
_poa.AllowSetPositionTo = false
_poa.Active = false
_poa.Points = {
	ZonePoint(43.0361787776442, -0.421446901956529, 0), 
	ZonePoint(43.0363709051707, -0.421449584165543, 0), 
	ZonePoint(43.0364983363616, -0.421556872526139, 0), 
	ZonePoint(43.036543427335, -0.421605152288407, 0), 
	ZonePoint(43.0364767711017, -0.421886784234971, 0), 
	ZonePoint(43.0362552366299, -0.421766084829301, 0), 
	ZonePoint(43.0361336864028, -0.421690982976884, 0), 
	ZonePoint(43.0360395828359, -0.421607834497422, 0), 
	ZonePoint(43.0359552816014, -0.421527368226975, 0), 
	ZonePoint(43.0359160716854, -0.421382528940171, 0), 
	ZonePoint(43.0358866642319, -0.421243054071397, 0), 
	ZonePoint(43.035939597638, -0.421141130128831, 0), 
	ZonePoint(43.0360533062818, -0.420993608633012, 0), 
	ZonePoint(43.0361003580727, -0.420931917825669, 0), 
	ZonePoint(43.0361591727607, -0.421149176755875, 0), 
	ZonePoint(43.0361983825214, -0.421240371862382, 0), 
	ZonePoint(43.0362866043913, -0.421315473714799, 0), 
	ZonePoint(43.0363473793834, -0.421382528940171, 0), 
	ZonePoint(43.0363689446888, -0.421438855329484, 0)
}
_poa.OriginalPoint = ZonePoint(43.0361951835126, -0.421408221679156, 0)
_poa.DistanceRangeUOM = "Feet"
_poa.ProximityRangeUOM = "Meters"
_poa.OutOfRangeName = ""
_poa.InRangeName = ""
_TaJ7 = Wherigo.Zone(_rMXx)
_TaJ7.Id = "e4822461-3f84-4729-b20d-7ec89b4c61a3"
_TaJ7.Name = _prYEn("\044\048\097\031\029")
_TaJ7.Description = ""
_TaJ7.Visible = true
_TaJ7.Media = _Gdkl
_TaJ7.Commands = {}
_TaJ7.DistanceRange = Distance(-1, "feet")
_TaJ7.ShowObjects = "OnEnter"
_TaJ7.ProximityRange = Distance(60, "meters")
_TaJ7.AllowSetPositionTo = false
_TaJ7.Active = false
_TaJ7.Points = {
	ZonePoint(43.0359160716854, -0.420698565641374, 0), 
	ZonePoint(43.0359160716854, -0.420720023313493, 0), 
	ZonePoint(43.0359101901958, -0.420757574239701, 0), 
	ZonePoint(43.035870980251, -0.420741480985612, 0), 
	ZonePoint(43.0358650987571, -0.420698565641374, 0), 
	ZonePoint(43.0358925457237, -0.42066906134221, 0), 
	ZonePoint(43.0359376371423, -0.420639557043046, 0), 
	ZonePoint(43.0359886100103, -0.420682472387284, 0)
}
_TaJ7.OriginalPoint = ZonePoint(43.0359121506814, -0.420700912574262, 0)
_TaJ7.DistanceRangeUOM = "Feet"
_TaJ7.ProximityRangeUOM = "Meters"
_TaJ7.OutOfRangeName = ""
_TaJ7.InRangeName = ""

-- Characters --

-- Items --
_v8ZM = Wherigo.ZItem(_rMXx)
_v8ZM.Id = "af749fe4-0d94-4f34-b124-31a87aa3c20d"
_v8ZM.Name = _prYEn("\092\022\033\099\082\029\111\109\097\048\097\031\029\109")
_v8ZM.Description = ""
_v8ZM.Visible = true
_v8ZM.Media = _2ol
_v8ZM.Commands = {}
_v8ZM.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_v8ZM.Locked = false
_v8ZM.Opened = false
_QD5_o = Wherigo.ZItem(_rMXx)
_QD5_o.Id = "1df89ce3-d29a-47f1-b392-21c6aacb011c"
_QD5_o.Name = _prYEn("\036\029\082\029\097\070\029\041\111\109\052\029\109\082\048\069\093\041\029")
_QD5_o.Description = ""
_QD5_o.Visible = true
_QD5_o.Media = _9B_14
_QD5_o.Commands = {
	_3CMv = Wherigo.ZCommand{
		Text = _prYEn("\072\111\048\069\097\048\099\036"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _prYEn("\040\033\070\031\099\069\093\109\048\034\048\099\082\048\009\082\029")
	}, 
	_bfg = Wherigo.ZCommand{
		Text = _prYEn("\108\036\022\048\093\069\033\082"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _prYEn("\040\033\070\031\099\069\093\109\048\034\048\099\082\048\009\082\029")
	}, 
	_BK0 = Wherigo.ZCommand{
		Text = _prYEn("\101\069\093\082\048\099\036"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _prYEn("\040\033\070\031\099\069\093\109\048\034\048\099\082\048\009\082\029")
	}
}
_QD5_o.Commands._3CMv.Custom = true
_QD5_o.Commands._3CMv.Id = "72c52356-16f9-40b8-a276-0366f0e4e307"
_QD5_o.Commands._3CMv.WorksWithAll = true
_QD5_o.Commands._bfg.Custom = true
_QD5_o.Commands._bfg.Id = "e70eda52-d8be-4c4d-8c4a-6055cdd89254"
_QD5_o.Commands._bfg.WorksWithAll = true
_QD5_o.Commands._BK0.Custom = true
_QD5_o.Commands._BK0.Id = "229e30ed-0a0f-48ad-94a5-0a15bacc038f"
_QD5_o.Commands._BK0.WorksWithAll = true
_QD5_o.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_QD5_o.Locked = false
_QD5_o.Opened = false

-- Tasks --

-- Cartridge Variables --
_Gr5 = ""
_68c = ""
__JiK = ""
_JAs = ""
_I_Ln = ""
_XNQ = ""
_S6D = ""
_6V9Pf = ""
_WC_d = ""
_rMXx.ZVariables = {
	_Gr5 = "", 
	_68c = "", 
	__JiK = "", 
	_JAs = "", 
	_I_Ln = "", 
	_XNQ = "", 
	_S6D = "", 
	_6V9Pf = "", 
	_WC_d = ""
}

-- Timers --

-- Inputs --
_s35 = Wherigo.ZInput(_rMXx)
_s35.Id = "bf626c0e-7d4c-46be-ba6d-55dd3b0b59ef"
_s35.Name = _prYEn("\005\057\011")
_s35.Description = ""
_s35.Visible = true
_s35.Media = _ZcOG
_s35.InputType = "Text"
_s35.Text = _prYEn("\125\082\109\085\109\048\109\013\071\109\034\048\082\082\029\029\036\109\052\048\069\036\109\082\029\036\109\045\085\111\029\069\029\029\036\109\088\012\103\112\125\097\099\109\034\033\041\036\109\029\070\029\036\109\052\048\069\036\109\082\048\109\034\048\082\082\029\029\109\113\069\009\036\022\104\052\109\094\094\094\088\012\103\112")
_V7CP = Wherigo.ZInput(_rMXx)
_V7CP.Id = "324ba115-e425-44d5-8bfa-2f1534b916c7"
_V7CP.Name = _prYEn("\005\057\106")
_V7CP.Description = ""
_V7CP.Visible = true
_V7CP.Media = _ZcOG
_V7CP.InputType = "Text"
_V7CP.Text = _prYEn("\083\048\109\026\048\082\048\099\036\029\109\033\041\109\069\099\097\031\029\069\070\109\082\029\036\109\034\048\041\070\033\041\111\036\109\036\109\048\022\022\029\082\082\029\109\082\029\109\045\029\069\029\109\052\029\109\012\029\033\069\109\113\069\009\036\022\104\088\012\103\112\108\082\082\029\109\029\036\070\109\031\048\041\070\029\109\052\029\109\097\033\001\009\099\029\069\109\052\029\109\001\029\070\111\029\036\109\051\088\012\103\112")
_Q5Ky8 = Wherigo.ZInput(_rMXx)
_Q5Ky8.Id = "1082859b-92e1-45d9-97a4-703d2eeb904a"
_Q5Ky8.Name = _prYEn("\005\057\121")
_Q5Ky8.Description = ""
_Q5Ky8.Visible = true
_Q5Ky8.Media = _ZcOG
_Q5Ky8.Choices = {
	"8", 
	"10", 
	"12"
}
_Q5Ky8.InputType = "MultipleChoice"
_Q5Ky8.Text = _prYEn("\108\069\109\011\084\023\013\109\097\033\001\009\099\029\069\109\111\029\036\070\048\099\070\109\099\082\109\052\029\109\097\033\041\022\082\029\036\109\052\029\109\034\048\041\070\033\041\111\036\109\026\048\041\034\029\036\109\051")
_Erv = Wherigo.ZInput(_rMXx)
_Erv.Id = "a856d405-18fb-4cac-9473-b14876027f8a"
_Erv.Name = _prYEn("\005\057\013")
_Erv.Description = ""
_Erv.Visible = true
_Erv.Media = _ZcOG
_Erv.Choices = {
	"1972", 
	"1973", 
	"1974", 
	"1975"
}
_Erv.InputType = "MultipleChoice"
_Erv.Text = _prYEn("\108\069\109\021\041\029\082\082\029\109\048\069\069\029\029\109\048\109\029\070\029\109\097\111\029\029\109\082\048\109\111\029\036\029\111\034\029\109\052\119\078\036\036\048\041\109\051")
_ph6oO = Wherigo.ZInput(_rMXx)
_ph6oO.Id = "39f6b136-db83-42f9-adb1-a40b1de75972"
_ph6oO.Name = _prYEn("\005\057\056")
_ph6oO.Description = ""
_ph6oO.Visible = true
_ph6oO.Media = _ZcOG
_ph6oO.InputType = "Text"
_ph6oO.Text = _prYEn("\044\033\001\001\029\069\070\109\036\109\048\022\029\082\082\029\109\082\029\109\097\033\041\036\099\069\109\052\109\101\001\029\111\099\021\041\029\109\052\041\109\036\041\052\109\051")
_MKE8 = Wherigo.ZInput(_rMXx)
_MKE8.Id = "6ecd5ea7-453a-4e08-95ce-7ab9dd702fc9"
_MKE8.Name = _prYEn("\005\057\100")
_MKE8.Description = ""
_MKE8.Visible = true
_MKE8.Media = _ZcOG
_MKE8.InputType = "Text"
_MKE8.Text = _prYEn("\044\033\001\009\099\029\069\109\026\048\041\070\109\099\082\109\052\029\109\082\099\070\111\029\036\109\052\029\109\082\048\099\070\109\052\029\109\009\111\029\009\099\036\109\022\033\041\111\109\026\048\099\111\029\109\041\069\109\026\111\033\001\048\093\029\109\051")
_cJ8y = Wherigo.ZInput(_rMXx)
_cJ8y.Id = "cd92dcc8-75ac-4d31-bdc6-5c8a331778b1"
_cJ8y.Name = _prYEn("\005\057\023")
_cJ8y.Description = ""
_cJ8y.Visible = true
_cJ8y.Media = _ZcOG
_cJ8y.Choices = {
	"122", 
	"123", 
	"124", 
	"125"
}
_cJ8y.InputType = "MultipleChoice"
_cJ8y.Text = _prYEn("\044\033\001\009\099\029\069\109\085\109\048\109\070\109\099\082\109\052\029\109\097\033\041\022\082\029\036\109\069\099\097\031\029\041\111\036\109\029\069\109\106\071\071\013\109\051")
_z5i6t = Wherigo.ZInput(_rMXx)
_z5i6t.Id = "08b32606-b81d-4f00-91b2-06dc116db7e3"
_z5i6t.Name = _prYEn("\078\076\125\109\120\040\078\040")
_z5i6t.Description = ""
_z5i6t.Visible = true
_z5i6t.Media = _ZcOG
_z5i6t.Choices = {
	"OUI", 
	"NON"
}
_z5i6t.InputType = "MultipleChoice"
_z5i6t.Text = _prYEn("\101\082\033\111\036\109\033\041\099\109\033\041\109\069\033\069\109\051")
_qPg = Wherigo.ZInput(_rMXx)
_qPg.Id = "09077e6d-0fa2-446d-92ac-dae6df9a13a3"
_qPg.Name = _prYEn("\078\076\125\109\120\040\078\040\109\101")
_qPg.Description = ""
_qPg.Visible = true
_qPg.Media = _ZcOG
_qPg.Choices = {
	"YES", 
	"NO"
}
_qPg.InputType = "MultipleChoice"
_qPg.Text = _prYEn("\092\033\109\020\108\092\109\033\111\109\040\078\109\051")
_kKS = Wherigo.ZInput(_rMXx)
_kKS.Id = "3c408775-861d-41a1-88fd-0e1e01fcbefc"
_kKS.Name = _prYEn("\078\076\125\109\120\040\078\040\109\108")
_kKS.Description = ""
_kKS.Visible = true
_kKS.Media = _ZcOG
_kKS.Choices = {
	"SI", 
	"NO"
}
_kKS.InputType = "MultipleChoice"
_kKS.Text = _prYEn("\101\036\099\109\021\041\029\109\092\125\109\033\109\040\078\109\051")
_aFhuZ = Wherigo.ZInput(_rMXx)
_aFhuZ.Id = "e92bf0eb-5ac4-4ddd-aa33-72c7a7fe9edc"
_aFhuZ.Name = _prYEn("\005\057\011\109\101")
_aFhuZ.Description = ""
_aFhuZ.Visible = true
_aFhuZ.Media = _ZcOG
_aFhuZ.InputType = "Text"
_aFhuZ.Text = _prYEn("\065\031\029\111\029\109\048\111\029\109\013\071\109\034\048\082\082\029\085\036\109\099\069\109\070\031\029\109\045\085\111\029\069\029\029\036\088\012\103\112\020\033\041\109\048\111\029\109\031\029\111\029\109\099\069\109\070\031\029\109\034\048\082\082\029\085\109\033\026\109\094\094\094")
_yNp = Wherigo.ZInput(_rMXx)
_yNp.Id = "e86b7a3b-4f56-4679-bfe3-01a362776329"
_yNp.Name = _prYEn("\005\057\011\109\108")
_yNp.Description = ""
_yNp.Visible = true
_yNp.Media = _ZcOG
_yNp.InputType = "Text"
_yNp.Text = _prYEn("\060\048\085\109\013\071\109\034\048\082\082\029\036\109\029\069\109\029\082\109\045\099\111\099\069\029\033\088\012\103\112\076\036\070\029\052\109\029\036\070\048\109\048\021\041\099\109\029\069\109\029\082\109\034\048\082\082\029\109\052\029\109\094\094\094")
_jw0 = Wherigo.ZInput(_rMXx)
_jw0.Id = "5a6205d6-2e2f-4d97-97fe-19212f196777"
_jw0.Name = _prYEn("\005\057\106\109\108")
_jw0.Description = ""
_jw0.Visible = true
_jw0.Media = _ZcOG
_jw0.InputType = "Text"
_jw0.Text = _prYEn("\108\082\109\048\097\048\069\070\099\082\048\052\033\109\033\109\069\099\052\033\109\052\029\109\009\041\099\070\111\029\036\109\036\029\109\082\082\048\001\048\109\045\029\069\029\109\012\029\033\069\088\012\103\112\101\036\099\109\029\036\109\097\033\001\033\109\001\041\097\031\033\036\109\001\029\070\111\033\036\109\052\029\109\048\082\070\041\111\048\051")
_rNvO_ = Wherigo.ZInput(_rMXx)
_rNvO_.Id = "9e01688e-7489-4721-8247-70d6c8589ee9"
_rNvO_.Name = _prYEn("\005\057\106\109\101")
_rNvO_.Description = ""
_rNvO_.Visible = true
_rNvO_.Media = _ZcOG
_rNvO_.InputType = "Text"
_rNvO_.Text = _prYEn("\065\031\029\109\097\082\099\026\026\109\033\111\109\069\029\036\070\109\033\026\109\034\041\082\070\041\111\029\036\109\099\036\109\097\048\082\082\029\052\109\045\029\069\029\109\012\029\033\069\088\012\103\112\125\070\109\099\036\109\031\033\010\109\001\048\069\085\109\001\029\070\029\111\036\109\031\099\093\031\051")
_1Ki = Wherigo.ZInput(_rMXx)
_1Ki.Id = "9c18fc7b-136e-4b27-8bd3-f9ed12dad6bf"
_1Ki.Name = _prYEn("\005\057\121\109\101")
_1Ki.Description = ""
_1Ki.Visible = true
_1Ki.Media = _ZcOG
_1Ki.Choices = {
	"8", 
	"10", 
	"12"
}
_1Ki.InputType = "MultipleChoice"
_1Ki.Text = _prYEn("\125\069\109\011\084\023\013\109\111\029\001\048\099\069\029\052\109\048\009\033\041\070\109\031\033\010\109\097\033\041\022\082\029\036\109\034\041\082\070\041\111\029\036\051")
_w_3p = Wherigo.ZInput(_rMXx)
_w_3p.Id = "d072b042-c638-4f84-9dbe-adb412abb3c3"
_w_3p.Name = _prYEn("\005\057\121\109\108")
_w_3p.Description = ""
_w_3p.Visible = true
_w_3p.Media = _ZcOG
_w_3p.Choices = {
	"8", 
	"10", 
	"12"
}
_w_3p.InputType = "MultipleChoice"
_w_3p.Text = _prYEn("\108\069\109\011\084\023\013\109\036\029\109\001\048\069\070\041\034\033\109\048\022\111\033\090\099\001\048\052\048\001\029\069\070\029\109\048\109\082\048\036\109\022\048\111\029\027\048\036\109\097\033\001\033\109\082\033\036\109\009\041\099\070\111\029\036\051")
_Nmc = Wherigo.ZInput(_rMXx)
_Nmc.Id = "b61683de-6352-4f67-b877-52cbb050c77d"
_Nmc.Name = _prYEn("\005\057\013\109\108")
_Nmc.Description = ""
_Nmc.Visible = true
_Nmc.Media = _ZcOG
_Nmc.Choices = {
	"1972", 
	"1973", 
	"1974", 
	"1975"
}
_Nmc.InputType = "MultipleChoice"
_Nmc.Text = _prYEn("\051\108\069\109\021\041\029\109\048\069\033\109\036\029\109\097\111\029\033\109\082\048\109\111\029\036\029\111\034\048\109\052\029\109\078\036\036\048\041\051")
_O7b6p = Wherigo.ZInput(_rMXx)
_O7b6p.Id = "3cb4695b-be67-4b50-8f6a-0f0d25907667"
_O7b6p.Name = _prYEn("\005\057\013\109\101")
_O7b6p.Description = ""
_O7b6p.Visible = true
_O7b6p.Media = _ZcOG
_O7b6p.Choices = {
	"1972", 
	"1973", 
	"1974", 
	"1975"
}
_O7b6p.InputType = "MultipleChoice"
_O7b6p.Text = _prYEn("\102\031\048\070\109\085\029\048\111\109\010\048\036\109\097\111\029\048\070\029\052\109\070\031\029\109\111\029\036\029\111\034\048\070\099\033\069\109\078\036\036\048\041\051")
_tIX = Wherigo.ZInput(_rMXx)
_tIX.Id = "c6c5f338-e1b3-4d6f-bdf7-af7a6484a40b"
_tIX.Name = _prYEn("\005\057\056\109\101")
_tIX.Description = ""
_tIX.Visible = true
_tIX.Media = _ZcOG
_tIX.InputType = "Text"
_tIX.Text = _prYEn("\060\033\010\109\036\109\097\048\082\082\119\052\109\070\031\029\109\097\033\041\036\099\069\109\033\026\109\092\033\041\070\031\109\101\001\029\111\099\097\048\051")
_cW9q = Wherigo.ZInput(_rMXx)
_cW9q.Id = "037533fe-273b-412a-929d-c0ad7d44ce6e"
_cW9q.Name = _prYEn("\005\057\056\109\108")
_cW9q.Description = ""
_cW9q.Visible = true
_cW9q.Media = _ZcOG
_cW9q.InputType = "Text"
_cW9q.Text = _prYEn("\051\044\033\001\033\109\036\109\097\048\082\082\119\052\109\029\082\109\022\111\099\001\033\109\052\029\109\101\001\029\111\099\097\048\109\052\029\082\109\092\041\111\051")
_yDQH = Wherigo.ZInput(_rMXx)
_yDQH.Id = "f2fbef9a-a204-4296-87ae-c7996ae9a31e"
_yDQH.Name = _prYEn("\005\057\100\109\108")
_yDQH.Description = ""
_yDQH.Visible = true
_yDQH.Media = _ZcOG
_yDQH.InputType = "Text"
_yDQH.Text = _prYEn("\051\044\041\048\069\070\033\109\070\099\029\001\022\033\109\052\029\109\082\099\070\111\033\036\109\052\029\109\082\029\097\031\029\109\052\029\109\033\034\029\027\048\109\022\048\111\048\109\029\082\109\021\041\029\036\033\051")
_RaAw = Wherigo.ZInput(_rMXx)
_RaAw.Id = "e72aa143-5de2-4466-9b69-98b479c5219f"
_RaAw.Name = _prYEn("\005\057\100\109\101")
_RaAw.Description = ""
_RaAw.Visible = true
_RaAw.Media = _ZcOG
_RaAw.InputType = "Text"
_RaAw.Text = _prYEn("\060\033\010\109\082\033\069\093\109\052\033\029\036\109\099\070\109\082\099\070\029\111\036\109\033\026\109\036\031\029\029\022\109\001\099\082\049\109\026\033\111\109\097\031\029\029\036\029\051")
_9ZniF = Wherigo.ZInput(_rMXx)
_9ZniF.Id = "2ec7cb07-1fc3-4e0e-a628-30440f4dc461"
_9ZniF.Name = _prYEn("\005\057\023\109\101")
_9ZniF.Description = ""
_9ZniF.Visible = true
_9ZniF.Media = _ZcOG
_9ZniF.Choices = {
	"122", 
	"123", 
	"124", 
	"125"
}
_9ZniF.InputType = "MultipleChoice"
_9ZniF.Text = _prYEn("\060\033\010\109\001\048\069\085\109\031\048\036\109\031\029\109\052\033\029\036\109\033\026\109\009\111\029\029\052\099\069\093\109\022\048\099\111\036\109\099\069\109\106\071\071\013\051")
_5gEv = Wherigo.ZInput(_rMXx)
_5gEv.Id = "3824b4ee-7aa1-4215-9e37-087e3ca6ab98"
_5gEv.Name = _prYEn("\005\057\023\109\108")
_5gEv.Description = ""
_5gEv.Visible = true
_5gEv.Media = _ZcOG
_5gEv.Choices = {
	"122", 
	"123", 
	"124", 
	"125"
}
_5gEv.InputType = "MultipleChoice"
_5gEv.Text = _prYEn("\051\044\041\048\069\070\033\036\109\036\029\109\082\033\109\031\048\097\029\109\052\029\109\022\048\111\029\027\048\036\109\111\029\022\111\033\052\041\097\070\033\111\048\036\109\029\069\109\106\071\071\013\051")

-- WorksWithList for object commands --

-- functions --
function _rMXx:OnStart()
	_QD5_o:MoveTo(Player)
	Wherigo.ShowScreen(Wherigo.DETAILSCREEN, _QD5_o)
end
function _rMXx:OnRestore()
end
function _poa:OnEnter()
	if Wherigo.NoCaseEquals(_WC_d, _prYEn("\011")) then
		_Urwigo.RunDialogs(function()
			Wherigo.GetInput(_s35)
		end)
	elseif Wherigo.NoCaseEquals(_WC_d, _prYEn("\106")) then
		_Urwigo.RunDialogs(function()
			Wherigo.GetInput(_yNp)
		end)
	elseif Wherigo.NoCaseEquals(_WC_d, _prYEn("\121")) then
		_Urwigo.RunDialogs(function()
			Wherigo.GetInput(_aFhuZ)
		end)
	end
end
function _TaJ7:OnEnter()
	if Wherigo.NoCaseEquals(_WC_d, _prYEn("\011")) then
		_v8ZM:MoveTo(Player)
		_QD5_o:MoveTo(Player)
		_rMXx.Complete = true
		_Urwigo.Dialog(false, {
			{
				Text = _prYEn("\041\069\029\109\022\031\033\070\033\109\036\022\033\099\082\029\111\109\036\029\109\070\111\033\041\034\029\109\052\048\069\036\109\034\033\070\111\029\109\099\069\034\029\069\070\048\099\111\029\109"), 
				Media = _ZcOG
			}
		}, function(action)
			_poa.Active = true
			_poa.Visible = true
			_rMXx:RequestSync()
		end)
	elseif Wherigo.NoCaseEquals(_WC_d, _prYEn("\106")) then
		_v8ZM:MoveTo(Player)
		_QD5_o:MoveTo(Player)
		_rMXx.Complete = true
		_Urwigo.Dialog(false, {
			{
				Text = _prYEn("\036\022\033\099\082\029\111\109\026\033\070\033\109\029\036\070\048\109\029\069\109\070\041\109\099\069\034\029\069\070\048\111\099\033"), 
				Media = _ZcOG
			}
		}, function(action)
			_poa.Active = true
			_poa.Visible = true
			_rMXx:RequestSync()
		end)
	elseif Wherigo.NoCaseEquals(_WC_d, _prYEn("\121")) then
		_v8ZM:MoveTo(Player)
		_QD5_o:MoveTo(Player)
		_rMXx.Complete = true
		_Urwigo.Dialog(false, {
			{
				Text = _prYEn("\022\031\033\070\033\109\036\022\033\099\082\029\111\109\099\036\109\099\069\109\085\033\041\111\109\099\069\034\029\069\070\033\111\085"), 
				Media = _ZcOG
			}
		}, function(action)
			_poa.Active = true
			_poa.Visible = true
			_rMXx:RequestSync()
		end)
	end
end
function _TaJ7:OnExit()
	if Wherigo.NoCaseEquals(_WC_d, _prYEn("\011")) then
		_Urwigo.MessageBox{
			Text = _prYEn("\067\029\109\034\033\041\036\109\111\029\001\029\111\097\099\029\109\052\029\109\001\109\048\034\033\099\111\109\113\069\009\036\022\104\036\041\099\034\099\109\070\033\041\070\109\048\041\109\082\033\069\093\109\052\029\109\097\029\070\070\029\109\010\031\029\111\099\093\033\109\029\070\109\027\029\109\034\033\041\036\109\052\099\036\109\048\109\041\069\029\109\022\111\033\097\031\048\099\069\029\109\026\033\099\109"), 
			Media = _ZcOG, 
			Callback = function(action)
				if action ~= nil then
					Wherigo.Command "SaveClose"
				end
			end
		}
	elseif Wherigo.NoCaseEquals(_WC_d, _prYEn("\106")) then
		_Urwigo.MessageBox{
			Text = _prYEn("\061\111\048\097\099\048\036\109\022\033\111\109\036\029\093\041\099\111\001\029\109\029\069\109\029\036\070\029\109\102\031\029\111\099\093\033\109\085\109\082\029\109\052\099\093\033\109\048\109\041\069\048\109\026\029\109\026\041\070\041\111\033"), 
			Media = _ZcOG, 
			Callback = function(action)
				if action ~= nil then
					Wherigo.Command "SaveClose"
				end
			end
		}
	elseif Wherigo.NoCaseEquals(_WC_d, _prYEn("\121")) then
		_Urwigo.MessageBox{
			Text = _prYEn("\065\031\048\069\049\109\085\033\041\109\026\033\111\109\026\033\082\082\033\010\099\069\093\109\001\029\109\070\031\111\033\041\093\031\033\041\070\109\070\031\099\036\109\102\031\029\111\099\093\033\109\048\069\052\109\125\109\070\029\082\082\109\085\033\041\109\048\070\109\048\109\026\041\070\041\111\029\109\026\048\099\070\031"), 
			Media = _ZcOG, 
			Callback = function(action)
				if action ~= nil then
					Wherigo.Command "SaveClose"
				end
			end
		}
	end
end
function _s35:OnGetInput(input)
	if input == nil then
		input = ""
	end
	_68c = input
	_Urwigo.RunDialogs(function()
		Wherigo.GetInput(_V7CP)
	end)
	_rMXx:RequestSync()
end
function _V7CP:OnGetInput(input)
	input = tonumber(input)
	if input == nil then
		return
	end
	__JiK = tostring(input)
	_Urwigo.RunDialogs(function()
		Wherigo.GetInput(_Q5Ky8)
	end)
	_rMXx:RequestSync()
end
function _Q5Ky8:OnGetInput(input)
	if input == nil then
		input = ""
	end
	_JAs = input
	_Urwigo.RunDialogs(function()
		Wherigo.GetInput(_Erv)
	end)
	_rMXx:RequestSync()
end
function _Erv:OnGetInput(input)
	if input == nil then
		input = ""
	end
	_I_Ln = input
	_Urwigo.RunDialogs(function()
		Wherigo.GetInput(_ph6oO)
	end)
	_rMXx:RequestSync()
end
function _ph6oO:OnGetInput(input)
	if input == nil then
		input = ""
	end
	_XNQ = input
	_Urwigo.RunDialogs(function()
		Wherigo.GetInput(_MKE8)
	end)
	_rMXx:RequestSync()
end
function _MKE8:OnGetInput(input)
	input = tonumber(input)
	if input == nil then
		return
	end
	_S6D = tostring(input)
	_Urwigo.RunDialogs(function()
		Wherigo.GetInput(_cJ8y)
	end)
	_rMXx:RequestSync()
end
function _cJ8y:OnGetInput(input)
	if input == nil then
		input = ""
	end
	_6V9Pf = input
	if (((((Wherigo.NoCaseEquals(_68c, _prYEn("\033\036\036\048\041")) and Wherigo.NoCaseEquals(__JiK, _prYEn("\011\071\071\071"))) and Wherigo.NoCaseEquals(_JAs, _prYEn("\011\071"))) and Wherigo.NoCaseEquals(_I_Ln, _prYEn("\011\084\023\013"))) and Wherigo.NoCaseEquals(_XNQ, _prYEn("\097\033\069\052\033\111"))) and Wherigo.NoCaseEquals(_S6D, _prYEn("\013\071"))) and Wherigo.NoCaseEquals(_6V9Pf, _prYEn("\011\106\121")) then
		_Urwigo.Dialog(false, {
			{
				Text = _prYEn("\012\111\048\034\033\109\034\033\041\036\109\048\034\029\114\109\009\099\029\069\109\111\029\022\033\069\052\041\109\048\109\070\033\041\070\029\036\109\082\029\036\109\021\041\029\036\070\099\033\069\036\109\029\070\109\001\048\099\069\070\029\069\048\069\070\109\034\033\041\036\109\022\033\041\034\029\114\109\048\082\082\029\111\109\097\031\029\111\097\031\029\111\109\113\069\009\036\022\104\082\048\109\097\048\097\031\029"), 
				Media = _ZcOG
			}
		}, function(action)
			_poa.Active = false
			_poa.Visible = false
			_TaJ7.Active = true
			_TaJ7.Visible = true
		end)
		_rMXx:RequestSync()
	else
		_Urwigo.MessageBox{
			Text = _prYEn("\127\033\001\001\048\093\029\109\034\033\041\036\109\048\034\029\114\109\048\041\109\001\033\099\069\036\109\041\069\029\109\111\029\022\033\069\036\029\109\052\029\109\026\048\041\036\036\029\109\094\101\082\082\029\114\109\033\069\109\111\029\097\033\001\001\029\069\097\029"), 
			Media = _ZcOG, 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.RunDialogs(function()
						Wherigo.GetInput(_s35)
					end)
				end
			end
		}
	end
end
function _z5i6t:OnGetInput(input)
	if input == nil then
		input = ""
	end
	_Gr5 = input
	if Wherigo.NoCaseEquals(_Gr5, _prYEn("\078\076\125")) then
		_Urwigo.Dialog(false, {
			{
				Text = _prYEn("\065\111\029\036\109\009\033\069\109\097\031\033\099\090\109\088\012\103\112\101\082\082\029\114\109\029\069\109\048\034\048\069\070\109"), 
				Media = _ZcOG
			}
		}, function(action)
			_poa.Active = true
			_poa.Visible = true
			_QD5_o.Visible = false
			_rMXx:RequestSync()
		end)
	else
		_Urwigo.Dialog(false, {
			{
				Text = _prYEn("\127\033\001\001\048\093\029\109\096\096\109\048\109\041\069\029\109\048\041\070\111\029\109\026\033\099\109"), 
				Media = _ZcOG
			}
		}, function(action)
			Wherigo.Command "SaveClose"
		end)
	end
end
function _qPg:OnGetInput(input)
	if input == nil then
		input = ""
	end
	_Gr5 = input
	if Wherigo.NoCaseEquals(_Gr5, _prYEn("\020\108\092")) then
		_Urwigo.Dialog(false, {
			{
				Text = _prYEn("\126\029\111\085\109\093\033\033\052\109\097\031\033\099\097\029\088\012\103\112\061\033\109\048\031\029\048\052"), 
				Media = _ZcOG
			}
		}, function(action)
			_poa.Active = true
			_poa.Visible = true
			_QD5_o.Visible = false
			_rMXx:RequestSync()
		end)
	else
		_Urwigo.Dialog(false, {
			{
				Text = _prYEn("\065\033\033\109\009\048\052\096\109\070\033\109\048\069\033\070\031\029\111\109\026\048\099\070\031"), 
				Media = _ZcOG
			}
		}, function(action)
			Wherigo.Command "SaveClose"
		end)
	end
end
function _kKS:OnGetInput(input)
	if input == nil then
		input = ""
	end
	_Gr5 = input
	if Wherigo.NoCaseEquals(_Gr5, _prYEn("\092\125")) then
		_Urwigo.Dialog(false, {
			{
				Text = _prYEn("\075\041\085\109\009\041\029\069\048\109\033\022\097\099\033\069\088\012\103\112\126\048\085\048\109\022\033\111\109\052\029\082\048\069\070\029"), 
				Media = _ZcOG
			}
		}, function(action)
			_poa.Active = true
			_poa.Visible = true
			_QD5_o.Visible = false
			_rMXx:RequestSync()
		end)
	else
		_Urwigo.Dialog(false, {
			{
				Text = _prYEn("\051\005\041\029\109\082\048\036\070\099\001\048\096\109\048\109\033\070\111\033\123\109\026\029"), 
				Media = _ZcOG
			}
		}, function(action)
			Wherigo.Command "SaveClose"
		end)
	end
end
function _aFhuZ:OnGetInput(input)
	if input == nil then
		input = ""
	end
	_68c = input
	_Urwigo.RunDialogs(function()
		Wherigo.GetInput(_rNvO_)
	end)
	_rMXx:RequestSync()
end
function _yNp:OnGetInput(input)
	if input == nil then
		input = ""
	end
	_68c = input
	_Urwigo.RunDialogs(function()
		Wherigo.GetInput(_jw0)
	end)
	_rMXx:RequestSync()
end
function _jw0:OnGetInput(input)
	input = tonumber(input)
	if input == nil then
		return
	end
	__JiK = tostring(input)
	_Urwigo.RunDialogs(function()
		Wherigo.GetInput(_w_3p)
	end)
	_rMXx:RequestSync()
end
function _rNvO_:OnGetInput(input)
	if input == nil then
		input = ""
	end
	__JiK = input
	_Urwigo.RunDialogs(function()
		Wherigo.GetInput(_1Ki)
	end)
	_rMXx:RequestSync()
end
function _1Ki:OnGetInput(input)
	if input == nil then
		input = ""
	end
	_JAs = input
	_Urwigo.RunDialogs(function()
		Wherigo.GetInput(_O7b6p)
	end)
	_rMXx:RequestSync()
end
function _w_3p:OnGetInput(input)
	if input == nil then
		input = ""
	end
	_JAs = input
	_Urwigo.RunDialogs(function()
		Wherigo.GetInput(_Nmc)
	end)
	_rMXx:RequestSync()
end
function _Nmc:OnGetInput(input)
	if input == nil then
		input = ""
	end
	_I_Ln = input
	_Urwigo.RunDialogs(function()
		Wherigo.GetInput(_cW9q)
	end)
	_rMXx:RequestSync()
end
function _O7b6p:OnGetInput(input)
	if input == nil then
		input = ""
	end
	_I_Ln = input
	_Urwigo.RunDialogs(function()
		Wherigo.GetInput(_tIX)
	end)
	_rMXx:RequestSync()
end
function _tIX:OnGetInput(input)
	if input == nil then
		input = ""
	end
	_XNQ = input
	_Urwigo.RunDialogs(function()
		Wherigo.GetInput(_RaAw)
	end)
	_rMXx:RequestSync()
end
function _cW9q:OnGetInput(input)
	if input == nil then
		input = ""
	end
	_XNQ = input
	_Urwigo.RunDialogs(function()
		Wherigo.GetInput(_yDQH)
	end)
	_rMXx:RequestSync()
end
function _yDQH:OnGetInput(input)
	input = tonumber(input)
	if input == nil then
		return
	end
	_S6D = tostring(input)
	_Urwigo.RunDialogs(function()
		Wherigo.GetInput(_5gEv)
	end)
	_rMXx:RequestSync()
end
function _RaAw:OnGetInput(input)
	input = tonumber(input)
	if input == nil then
		return
	end
	_S6D = tostring(input)
	_Urwigo.RunDialogs(function()
		Wherigo.GetInput(_9ZniF)
	end)
	_rMXx:RequestSync()
end
function _9ZniF:OnGetInput(input)
	if input == nil then
		input = ""
	end
	_6V9Pf = input
	if (((((Wherigo.NoCaseEquals(_68c, _prYEn("\033\036\036\048\041")) and Wherigo.NoCaseEquals(__JiK, _prYEn("\011\071\071\071"))) and Wherigo.NoCaseEquals(_JAs, _prYEn("\011\071"))) and Wherigo.NoCaseEquals(_I_Ln, _prYEn("\011\084\023\013"))) and Wherigo.NoCaseEquals(_XNQ, _prYEn("\097\033\069\052\033\111"))) and Wherigo.NoCaseEquals(_S6D, _prYEn("\013\071"))) and Wherigo.NoCaseEquals(_6V9Pf, _prYEn("\011\106\121")) then
		_Urwigo.Dialog(false, {
			{
				Text = _prYEn("\044\033\069\093\111\048\070\041\082\048\070\099\033\069\036\109\085\033\041\109\031\048\034\029\109\048\069\036\010\029\111\029\052\109\048\082\082\109\070\031\029\109\021\041\029\036\070\099\033\069\036\109\048\069\052\109\069\033\010\109\085\033\041\109\097\048\069\109\093\033\109\026\033\111\109\070\031\029\109\097\048\097\031\029"), 
				Media = _ZcOG
			}
		}, function(action)
			_poa.Active = false
			_poa.Visible = false
			_TaJ7.Active = true
			_TaJ7.Visible = true
		end)
		_rMXx:RequestSync()
	else
		_Urwigo.MessageBox{
			Text = _prYEn("\065\033\033\109\009\048\052\109\085\033\041\109\031\048\034\029\109\048\070\109\082\029\048\036\070\109\033\069\029\109\048\069\036\010\029\111\109\010\111\033\069\093\094\109\061\033\109\070\031\029\111\029\109\048\093\048\099\069"), 
			Media = _ZcOG, 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.RunDialogs(function()
						Wherigo.GetInput(_aFhuZ)
					end)
				end
			end
		}
	end
end
function _5gEv:OnGetInput(input)
	if input == nil then
		input = ""
	end
	_6V9Pf = input
	if (((((Wherigo.NoCaseEquals(_68c, _prYEn("\033\036\036\048\041")) and Wherigo.NoCaseEquals(__JiK, _prYEn("\011\071\071\071"))) and Wherigo.NoCaseEquals(_JAs, _prYEn("\011\071"))) and Wherigo.NoCaseEquals(_I_Ln, _prYEn("\011\084\023\013"))) and Wherigo.NoCaseEquals(_XNQ, _prYEn("\097\033\069\052\033\111"))) and Wherigo.NoCaseEquals(_S6D, _prYEn("\013\071"))) and Wherigo.NoCaseEquals(_6V9Pf, _prYEn("\011\106\121")) then
		_Urwigo.Dialog(false, {
			{
				Text = _prYEn("\072\029\082\099\097\099\070\048\097\099\033\069\029\036\109\021\041\029\109\031\048\085\048\109\097\033\069\070\029\036\070\048\052\033\109\070\033\052\048\036\109\082\048\036\109\022\111\029\093\041\069\070\048\036\109\085\109\048\031\033\111\048\109\041\036\070\029\052\109\022\041\029\052\029\109\099\111\109\022\048\111\048\109\082\048\109\097\048\097\031\029"), 
				Media = _ZcOG
			}
		}, function(action)
			_TaJ7.Active = true
			_TaJ7.Visible = true
			_poa.Active = false
			_poa.Visible = false
		end)
		_rMXx:RequestSync()
	else
		_Urwigo.MessageBox{
			Text = _prYEn("\083\048\036\070\099\001\048\109\021\041\029\109\070\099\029\069\029\069\109\048\082\109\001\029\069\033\036\109\041\069\048\109\111\029\036\022\041\029\036\070\048\109\029\021\041\099\034\033\097\048\052\048\094\109\125\111\109\048\082\082\099\109\052\029\109\069\041\029\034\033"), 
			Media = _ZcOG, 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.RunDialogs(function()
						Wherigo.GetInput(_yNp)
					end)
				end
			end
		}
	end
end
function _QD5_o:On_3CMv(target)
	local _Urwigo_Date = os.date "*t"
	_WC_d = _prYEn("\011")
	_Urwigo.Dialog(false, {
		{
			Text = (((((((((_prYEn("\012\033\069\027\033\041\111\109\123\069\033\041\036\109\036\033\001\001\029\036\109\082\029\109").._Urwigo_Date.day).._prYEn("\109\120\109\113\069\009\036\022\104")).._Urwigo_Date.month).._prYEn("\109\120\109\113\069\009\036\022\104")).._Urwigo_Date.year).._prYEn("\109\029\070\109\099\082\109\029\036\070\109\113\069\009\036\022\104")).._Urwigo_Date.hour).._prYEn("\109\113\069\009\036\022\104\029\070\109\113\069\009\036\022\104")).._Urwigo_Date.min).._prYEn("\109\113\069\009\036\022\104\001\099\069\041\070\029\036\109"), 
			Media = _ZcOG
		}, 
		{
			Text = _prYEn("\092\099\109\034\033\041\036\109\048\034\029\114\109\041\069\029\109\052\029\001\099\077\031\029\041\111\029\109\022\033\041\111\109\026\048\099\111\029\109\097\029\070\070\029\109\010\031\029\111\099\093\033\109\113\069\009\036\022\104\097\082\099\021\041\029\114\109\036\041\111\109\033\041\099\109\088\012\103\112\092\099\069\033\069\109\097\082\099\021\041\029\114\109\036\041\111\109\113\069\009\036\022\104\069\033\069\109\113\069\009\036\022\104\113\069\009\036\022\104\088\012\103\112"), 
			Media = _ZcOG
		}
	}, function(action)
		_Urwigo.RunDialogs(function()
			Wherigo.GetInput(_z5i6t)
		end)
	end)
	_QD5_o.Visible = false
end
function _QD5_o:On_bfg(target)
	local _Urwigo_Date = os.date "*t"
	_WC_d = _prYEn("\106")
	_Urwigo.Dialog(false, {
		{
			Text = (((((((((_prYEn("\060\033\082\048\123\109\036\033\001\033\036\109\082\033\036\109\113\069\009\036\022\104").._Urwigo_Date.day).._prYEn("\109\120\109\113\069\009\036\022\104")).._Urwigo_Date.month).._prYEn("\109\120\109\113\069\009\036\022\104")).._Urwigo_Date.year).._prYEn("\085\109\029\036\109")).._Urwigo_Date.hour).._prYEn("\109\085\109")).._Urwigo_Date.min).._prYEn("\109\113\069\009\036\022\104\001\099\069\041\070\033\036"), 
			Media = _ZcOG
		}, 
		{
			Text = _prYEn("\092\099\109\041\036\070\029\052\109\070\099\029\069\029\109\001\029\052\099\048\109\031\033\111\048\109\022\048\111\048\109\031\048\097\029\111\109\029\036\070\033\109\102\031\029\111\099\093\033\109\097\082\099\097\109\029\069\109\113\069\009\036\022\104\092\099\109\088\012\103\112\127\029\109\082\033\109\097\033\069\070\111\048\111\099\033\109\031\048\093\048\109\097\082\099\097\109\029\069\109\113\069\009\036\022\104\040\033\094\088\012\103\112"), 
			Media = _ZcOG
		}
	}, function(action)
		_Urwigo.RunDialogs(function()
			Wherigo.GetInput(_kKS)
		end)
	end)
	_QD5_o.Visible = false
end
function _QD5_o:On_BK0(target)
	local _Urwigo_Date = os.date "*t"
	_WC_d = _prYEn("\121")
	_Urwigo.Dialog(false, {
		{
			Text = (((((((((_prYEn("\060\029\082\082\033\123\109\010\029\109\048\111\029\109\070\031\029\109\113\069\009\036\022\104\113\069\009\036\022\104").._Urwigo_Date.day).._prYEn("\109\113\069\009\036\022\104\113\069\009\036\022\104\113\069\009\036\022\104\120\109\113\069\009\036\022\104\113\069\009\036\022\104\113\069\009\036\022\104")).._Urwigo_Date.month).._prYEn("\109\113\069\009\036\022\104\120\109\113\069\009\036\022\104\113\069\009\036\022\104\113\069\009\036\022\104")).._Urwigo_Date.year).._prYEn("\109\113\069\009\036\022\104\048\069\052\109\099\070\109\099\036\109\113\069\009\036\022\104")).._Urwigo_Date.hour).._prYEn("\109\113\069\009\036\022\104\031\033\041\111\109\048\069\052\109\113\069\009\036\022\104")).._Urwigo_Date.min).._prYEn("\109\113\069\009\036\022\104\001\099\069\041\070\029\036\109"), 
			Media = _ZcOG
		}, 
		{
			Text = _prYEn("\125\026\109\085\033\041\109\031\048\034\029\109\031\048\082\026\109\048\069\109\031\033\041\111\109\070\033\109\052\033\109\070\031\099\036\109\102\031\029\111\099\093\033\109\097\082\099\097\049\109\113\069\009\036\022\104\020\108\092\088\012\103\112\078\070\031\029\111\010\099\036\029\109\097\082\099\097\049\109\113\069\009\036\022\104\040\078"), 
			Media = _ZcOG
		}
	}, function(action)
		_Urwigo.RunDialogs(function()
			Wherigo.GetInput(_qPg)
		end)
	end)
	_QD5_o.Visible = false
end

-- Begin user functions --
-- End Urwigo functions --
-- End user functions --
return _rMXx
