﻿require "Wherigo"
ZonePoint = Wherigo.ZonePoint
Distance = Wherigo.Distance
Player = Wherigo.Player

-- String decode --
function _WFe8l(str)
	local res = ""
    local dtable = "\081\086\055\084\119\096\064\034\028\005\046\108\049\065\115\101\060\104\017\026\021\067\030\110\091\075\032\111\057\099\041\092\031\124\007\056\059\078\023\035\072\071\082\070\025\015\052\013\009\000\048\016\073\019\051\029\106\122\024\120\058\063\018\061\022\068\118\116\066\087\113\001\100\079\080\003\006\083\044\076\094\117\103\121\014\112\012\011\114\074\054\109\098\089\027\102\107\045\125\033\085\040\090\020\088\069\095\123\008\036\038\042\077\047\126\093\002\043\050\010\097\062\037\039\105\004\053"
	for i=1, #str do
        local b = str:byte(i)
        if b > 0 and b <= 0x7F then
	        res = res .. string.char(dtable:byte(b))
        else
            res = res .. string.char(b)
        end
	end
	return res
end

-- Internal functions --
require "table"
require "math"

math.randomseed(os.time())
math.random()
math.random()
math.random()

_Urwigo = {}

_Urwigo.InlineRequireLoaded = {}
_Urwigo.InlineRequireRes = {}
_Urwigo.InlineRequire = function(moduleName)
  local res
  if _Urwigo.InlineRequireLoaded[moduleName] == nil then
    res = _Urwigo.InlineModuleFunc[moduleName]()
    _Urwigo.InlineRequireLoaded[moduleName] = 1
    _Urwigo.InlineRequireRes[moduleName] = res
  else
    res = _Urwigo.InlineRequireRes[moduleName]
  end
  return res
end

_Urwigo.Round = function(num, idp)
  local mult = 10^(idp or 0)
  return math.floor(num * mult + 0.5) / mult
end

_Urwigo.Ceil = function(num, idp)
  local mult = 10^(idp or 0)
  return math.ceil(num * mult) / mult
end

_Urwigo.Floor = function(num, idp)
  local mult = 10^(idp or 0)
  return math.floor(num * mult) / mult
end

_Urwigo.DialogQueue = {}
_Urwigo.RunDialogs = function(callback)
	local dialogs = _Urwigo.DialogQueue
	local lastCallback = nil
	_Urwigo.DialogQueue = {}
	local msgcb = {}
	msgcb = function(action)
		if action ~= nil then
			if lastCallback ~= nil then
				lastCallback(action)
			end
			local entry = table.remove(dialogs, 1)
			if entry ~= nil then
				lastCallback = entry.Callback;
				if entry.Text ~= nil then
					Wherigo.MessageBox({Text = entry.Text, Media=entry.Media, Buttons=entry.Buttons, Callback=msgcb})
				else
					msgcb(action)
				end
			else
				if callback ~= nil then
					callback()
				end
			end
		end
	end
	msgcb(true) -- any non-null argument
end

_Urwigo.MessageBox = function(tbl)
    _Urwigo.RunDialogs(function() Wherigo.MessageBox(tbl) end)
end

_Urwigo.OldDialog = function(tbl)
    _Urwigo.RunDialogs(function() Wherigo.Dialog(tbl) end)
end

_Urwigo.Dialog = function(buffered, tbl, callback)
	for k,v in ipairs(tbl) do
		table.insert(_Urwigo.DialogQueue, v)
	end
	if callback ~= nil then
		table.insert(_Urwigo.DialogQueue, {Callback=callback})
	end
	if not buffered then
		_Urwigo.RunDialogs(nil)
	end
end

_Urwigo.Hash = function(str)
   local b = 378551;
   local a = 63689;
   local hash = 0;
   for i = 1, #str, 1 do
      hash = hash*a+string.byte(str,i);
      hash = math.fmod(hash, 65535)
      a = a*b;
      a = math.fmod(a, 65535)
   end
   return hash;
end

_Urwigo.DaysInMonth = {
	31,
	28,
	31,
	30,
	31,
	30,
	31,
	31,
	30,
	31,
	30,
	31,
}

_Urwigo_Date_IsLeapYear = function(year)
	if year % 400 == 0 then
		return true
	elseif year% 100 == 0 then
		return false
	elseif year % 4 == 0 then
		return true
	else
		return false
	end
end

_Urwigo.Date_DaysInMonth = function(year, month)
	if month ~= 2 then
		return _Urwigo.DaysInMonth[month];
	else
		if _Urwigo_Date_IsLeapYear(year) then
			return 29
		else
			return 28
		end
	end
end

_Urwigo.Date_DayInYear = function(t)
	local res = t.day
	for month = 1, t.month - 1 do
		res = res + _Urwigo.Date_DaysInMonth(t.year, month)
	end
	return res
end

_Urwigo.Date_HourInWeek = function(t)
	return t.hour + (t.wday-1) * 24
end

_Urwigo.Date_HourInMonth = function(t)
	return t.hour + t.day * 24
end

_Urwigo.Date_HourInYear = function(t)
	return t.hour + (_Urwigo.Date_DayInYear(t) - 1) * 24
end

_Urwigo.Date_MinuteInDay = function(t)
	return t.min + t.hour * 60
end

_Urwigo.Date_MinuteInWeek = function(t)
	return t.min + t.hour * 60 + (t.wday-1) * 1440;
end

_Urwigo.Date_MinuteInMonth = function(t)
	return t.min + t.hour * 60 + (t.day-1) * 1440;
end

_Urwigo.Date_MinuteInYear = function(t)
	return t.min + t.hour * 60 + (_Urwigo.Date_DayInYear(t) - 1) * 1440;
end

_Urwigo.Date_SecondInHour = function(t)
	return t.sec + t.min * 60
end

_Urwigo.Date_SecondInDay = function(t)
	return t.sec + t.min * 60 + t.hour * 3600
end

_Urwigo.Date_SecondInWeek = function(t)
	return t.sec + t.min * 60 + t.hour * 3600 + (t.wday-1) * 86400
end

_Urwigo.Date_SecondInMonth = function(t)
	return t.sec + t.min * 60 + t.hour * 3600 + (t.day-1) * 86400
end

_Urwigo.Date_SecondInYear = function(t)
	return t.sec + t.min * 60 + t.hour * 3600 + (_Urwigo.Date_DayInYear(t)-1) * 86400
end


-- Inlined modules --
_Urwigo.InlineModuleFunc = {}

_Vk6j1 = Wherigo.ZCartridge()

-- Media --
-- Cartridge Info --
_Vk6j1.Id="2e9c4166-33a1-4fa6-aab6-162d4fe4bfe2"
_Vk6j1.Name="Custom input test"
_Vk6j1.Description=[[This cartridge was setup to show how you can create custom answers for an input. Question 1 uses player.name. Question 2 is setup using a custom variable.]]
_Vk6j1.Visible=true
_Vk6j1.Activity="TourGuide"
_Vk6j1.StartingLocationDescription=[[]]
_Vk6j1.StartingLocation = ZonePoint(38.6557165285521,-90.5758659882383,0)
_Vk6j1.Version=""
_Vk6j1.Company=""
_Vk6j1.Author=""
_Vk6j1.BuilderVersion="URWIGO 1.22.5798.37755"
_Vk6j1.CreateDate="07/12/2021 10:14:29"
_Vk6j1.PublishDate="1/1/0001 12:00:00 AM"
_Vk6j1.UpdateDate="07/13/2021 20:12:51"
_Vk6j1.LastPlayedDate="1/1/0001 12:00:00 AM"
_Vk6j1.TargetDevice="PocketPC"
_Vk6j1.TargetDeviceVersion="0"
_Vk6j1.StateId="1"
_Vk6j1.CountryId="2"
_Vk6j1.Complete=false
_Vk6j1.UseLogging=true


-- Zones --

-- Characters --

-- Items --

-- Tasks --

-- Cartridge Variables --
Var_name = _WFe8l("\018\016\012\012\028\027\005\028\089\012\073")
var2 = _WFe8l("\066\028\024")
_UbGuT = _WFe8l("\073\082\092\092\084")
_r8lX = _WFe8l("\073\082\092\092\084")
_BOWx = _WFe8l("\073\082\092\092\084")
_NshjZ = _WFe8l("\073\082\092\092\084")
_7xV = _WFe8l("\058\125\024\086\082\068\016\060\121\092\086\012\016\001\082\016\015\068\125\028\024")
_izC2k = _WFe8l("\073\082\092\092\084")
_Vk6j1.ZVariables = {
	Var_name = _WFe8l("\018\016\012\012\028\027\005\028\089\012\073"), 
	var2 = _WFe8l("\066\028\024"), 
	_UbGuT = _WFe8l("\073\082\092\092\084"), 
	_r8lX = _WFe8l("\073\082\092\092\084"), 
	_BOWx = _WFe8l("\073\082\092\092\084"), 
	_NshjZ = _WFe8l("\073\082\092\092\084"), 
	_7xV = _WFe8l("\058\125\024\086\082\068\016\060\121\092\086\012\016\001\082\016\015\068\125\028\024"), 
	_izC2k = _WFe8l("\073\082\092\092\084")
}

-- Timers --

-- Inputs --
zinputexampleQuestion = Wherigo.ZInput(_Vk6j1)
zinputexampleQuestion.Id = "23400bd7-b96e-403c-9b22-ee53f1e0d16a"
zinputexampleQuestion.Name = _WFe8l("\106\060\121\092\086\012\016\027\001\082\016\015\068\125\028\024")
zinputexampleQuestion.Description = ""
zinputexampleQuestion.Visible = true
zinputexampleQuestion.Choices = {}
zinputexampleQuestion.InputType = "MultipleChoice"
zinputexampleQuestion.Text = _WFe8l("\070\018\121\068\027\125\015\027\084\028\082\089\027\024\121\092\016\062")
zinputexampleQuestion2 = Wherigo.ZInput(_Vk6j1)
zinputexampleQuestion2.Id = "88c12816-86f0-4405-9f5a-b4ee30294c2c"
zinputexampleQuestion2.Name = _WFe8l("\106\060\121\092\086\012\016\027\001\082\016\015\068\125\028\024\119")
zinputexampleQuestion2.Description = ""
zinputexampleQuestion2.Visible = true
zinputexampleQuestion2.Choices = {}
zinputexampleQuestion2.InputType = "MultipleChoice"
zinputexampleQuestion2.Text = _WFe8l("\070\018\121\068\027\125\015\027\092\084\027\024\121\092\016\062")

-- WorksWithList for object commands --

-- functions --
function _Vk6j1:OnStart()
	_Urwigo.MessageBox{
		Text = _WFe8l("\004\018\125\015\027\030\121\089\068\089\125\073\083\016\027\005\121\015\027\015\016\068\082\086\027\068\028\027\015\018\028\005\027\018\028\005\027\084\028\082\027\030\121\024\027\030\089\016\121\068\016\027\030\082\015\068\028\092\027\121\024\015\005\016\089\015\027\096\028\089\027\121\024\027\125\024\086\082\068\011\027\001\082\016\015\068\125\028\024\027\013\027\082\015\016\015\027\086\012\121\084\016\089\011\024\121\092\016\011\027\001\082\016\015\068\125\028\024\027\119\027\125\015\027\015\016\068\082\086\027\082\015\125\024\083\027\121\027\030\082\015\068\028\092\027\067\121\089\125\121\093\012\016\011"), 
		Buttons = {
			_WFe8l("\001\082\016\015\068\125\028\024\027\013"), 
			_WFe8l("\001\082\016\015\068\125\028\024\027\119")
		}, 
		Callback = function(action)
			if action ~= nil then
				if action == "Button1" then
					zinputexampleQuestion.Choices =  {                      
					    "Alice",                                            
					    "Bob",                                              
					    "Charlie",                                          
					    ("Or, maybe " .. Player.Name) .. "?"    
					}   
					_Urwigo.RunDialogs(function()
						Wherigo.GetInput(zinputexampleQuestion)
					end)
				elseif action == "Button2" then
					zinputexampleQuestion2.Choices =  {                      
					    "Alice",                                            
					    (Var_name),
					      (var2),                                      
					    ("Or, maybe " .. Player.Name) .. "?"    
					}   
					_Urwigo.RunDialogs(function()
						Wherigo.GetInput(zinputexampleQuestion2)
					end)
				end
			end
		end
	}
end
function _Vk6j1:OnRestore()
end
function zinputexampleQuestion:OnGetInput(input)
	if input == nil then
		input = ""
	end
end
function zinputexampleQuestion2:OnGetInput(input)
	if input == nil then
		input = ""
	end
end

-- Urwigo functions --

-- Begin user functions --
-- End user functions --
return _Vk6j1
