﻿require "Wherigo"
ZonePoint = Wherigo.ZonePoint
Distance = Wherigo.Distance
Player = Wherigo.Player

-- String decode --
function _4ObC(str)
	local res = ""
    local dtable = "\029\109\017\114\005\100\060\026\010\062\103\031\096\053\099\098\083\087\047\123\122\090\073\093\077\078\016\057\079\069\082\027\126\081\117\118\097\019\018\107\101\012\105\011\055\023\059\104\110\108\007\112\067\039\008\043\054\089\072\063\094\071\113\061\002\124\076\106\001\046\074\035\013\050\068\009\065\121\025\021\034\085\102\088\086\084\115\038\006\091\120\075\052\036\095\033\049\044\041\020\000\125\022\014\064\015\119\066\004\040\116\045\048\080\056\030\024\003\051\032\042\070\092\058\037\028\111"
	for i=1, #str do
        local b = str:byte(i)
        if b > 0 and b <= 0x7F then
	        res = res .. string.char(dtable:byte(b))
        else
            res = res .. string.char(b)
        end
	end
	return res
end

-- Internal functions --
require "table"
require "math"

math.randomseed(os.time())
math.random()
math.random()
math.random()

_Urwigo = {}

_Urwigo.InlineRequireLoaded = {}
_Urwigo.InlineRequireRes = {}
_Urwigo.InlineRequire = function(moduleName)
  local res
  if _Urwigo.InlineRequireLoaded[moduleName] == nil then
    res = _Urwigo.InlineModuleFunc[moduleName]()
    _Urwigo.InlineRequireLoaded[moduleName] = 1
    _Urwigo.InlineRequireRes[moduleName] = res
  else
    res = _Urwigo.InlineRequireRes[moduleName]
  end
  return res
end

_Urwigo.Round = function(num, idp)
  local mult = 10^(idp or 0)
  return math.floor(num * mult + 0.5) / mult
end

_Urwigo.Ceil = function(num, idp)
  local mult = 10^(idp or 0)
  return math.ceil(num * mult) / mult
end

_Urwigo.Floor = function(num, idp)
  local mult = 10^(idp or 0)
  return math.floor(num * mult) / mult
end

_Urwigo.DialogQueue = {}
_Urwigo.RunDialogs = function(callback)
	local dialogs = _Urwigo.DialogQueue
	local lastCallback = nil
	_Urwigo.DialogQueue = {}
	local msgcb = {}
	msgcb = function(action)
		if action ~= nil then
			if lastCallback ~= nil then
				lastCallback(action)
			end
			local entry = table.remove(dialogs, 1)
			if entry ~= nil then
				lastCallback = entry.Callback;
				if entry.Text ~= nil then
					Wherigo.MessageBox({Text = entry.Text, Media=entry.Media, Buttons=entry.Buttons, Callback=msgcb})
				else
					msgcb(action)
				end
			else
				if callback ~= nil then
					callback()
				end
			end
		end
	end
	msgcb(true) -- any non-null argument
end

_Urwigo.MessageBox = function(tbl)
    _Urwigo.RunDialogs(function() Wherigo.MessageBox(tbl) end)
end

_Urwigo.OldDialog = function(tbl)
    _Urwigo.RunDialogs(function() Wherigo.Dialog(tbl) end)
end

_Urwigo.Dialog = function(buffered, tbl, callback)
	for k,v in ipairs(tbl) do
		table.insert(_Urwigo.DialogQueue, v)
	end
	if callback ~= nil then
		table.insert(_Urwigo.DialogQueue, {Callback=callback})
	end
	if not buffered then
		_Urwigo.RunDialogs(nil)
	end
end

_Urwigo.Hash = function(str)
   local b = 378551;
   local a = 63689;
   local hash = 0;
   for i = 1, #str, 1 do
      hash = hash*a+string.byte(str,i);
      hash = math.fmod(hash, 65535)
      a = a*b;
      a = math.fmod(a, 65535)
   end
   return hash;
end

_Urwigo.DaysInMonth = {
	31,
	28,
	31,
	30,
	31,
	30,
	31,
	31,
	30,
	31,
	30,
	31,
}

_Urwigo_Date_IsLeapYear = function(year)
	if year % 400 == 0 then
		return true
	elseif year% 100 == 0 then
		return false
	elseif year % 4 == 0 then
		return true
	else
		return false
	end
end

_Urwigo.Date_DaysInMonth = function(year, month)
	if month ~= 2 then
		return _Urwigo.DaysInMonth[month];
	else
		if _Urwigo_Date_IsLeapYear(year) then
			return 29
		else
			return 28
		end
	end
end

_Urwigo.Date_DayInYear = function(t)
	local res = t.day
	for month = 1, t.month - 1 do
		res = res + _Urwigo.Date_DaysInMonth(t.year, month)
	end
	return res
end

_Urwigo.Date_HourInWeek = function(t)
	return t.hour + (t.wday-1) * 24
end

_Urwigo.Date_HourInMonth = function(t)
	return t.hour + t.day * 24
end

_Urwigo.Date_HourInYear = function(t)
	return t.hour + (_Urwigo.Date_DayInYear(t) - 1) * 24
end

_Urwigo.Date_MinuteInDay = function(t)
	return t.min + t.hour * 60
end

_Urwigo.Date_MinuteInWeek = function(t)
	return t.min + t.hour * 60 + (t.wday-1) * 1440;
end

_Urwigo.Date_MinuteInMonth = function(t)
	return t.min + t.hour * 60 + (t.day-1) * 1440;
end

_Urwigo.Date_MinuteInYear = function(t)
	return t.min + t.hour * 60 + (_Urwigo.Date_DayInYear(t) - 1) * 1440;
end

_Urwigo.Date_SecondInHour = function(t)
	return t.sec + t.min * 60
end

_Urwigo.Date_SecondInDay = function(t)
	return t.sec + t.min * 60 + t.hour * 3600
end

_Urwigo.Date_SecondInWeek = function(t)
	return t.sec + t.min * 60 + t.hour * 3600 + (t.wday-1) * 86400
end

_Urwigo.Date_SecondInMonth = function(t)
	return t.sec + t.min * 60 + t.hour * 3600 + (t.day-1) * 86400
end

_Urwigo.Date_SecondInYear = function(t)
	return t.sec + t.min * 60 + t.hour * 3600 + (_Urwigo.Date_DayInYear(t)-1) * 86400
end


-- Inlined modules --
_Urwigo.InlineModuleFunc = {}

cartMaxlamenace = Wherigo.ZCartridge()

-- Media --
zmediaDbarquement = Wherigo.ZMedia(cartMaxlamenace)
zmediaDbarquement.Id = "fa773374-5894-4a83-ad16-879841ff7b47"
zmediaDbarquement.Name = _4ObC("\075\195\169\016\037\004\063\035\041\002\041\049\111")
zmediaDbarquement.Description = _4ObC("\002\041\006\043\037")
zmediaDbarquement.AltText = ""
zmediaDbarquement.Resources = {
	{
		Type = "jpg", 
		Filename = "66cad272-47bb-44e7-aed1-181d6dcc231f.jpg", 
		Directives = {}
	}
}
zmediapasserllle = Wherigo.ZMedia(cartMaxlamenace)
zmediapasserllle.Id = "c14034a0-2f42-4f01-b220-f052b54cfea3"
zmediapasserllle.Name = _4ObC("\052\037\087\087\041\004\041\050\050\041")
zmediapasserllle.Description = _4ObC("\002\041\006\043\037")
zmediapasserllle.AltText = ""
zmediapasserllle.Resources = {
	{
		Type = "jpg", 
		Filename = "IMG_20140605_213414.jpg", 
		Directives = {}
	}
}
zmediabataille = Wherigo.ZMedia(cartMaxlamenace)
zmediabataille.Id = "bb3f7023-273d-4c38-b557-3d3ac1ff1e3b"
zmediabataille.Name = _4ObC("\016\037\111\037\043\050\050\041")
zmediabataille.Description = _4ObC("\002\041\006\043\037")
zmediabataille.AltText = ""
zmediabataille.Resources = {
	{
		Type = "jpg", 
		Filename = "6119dfc4-4f10-4543-ab68-ca3ce69da7ef.jpg", 
		Directives = {}
	}
}
zmedialabelle = Wherigo.ZMedia(cartMaxlamenace)
zmedialabelle.Id = "566f527b-ab73-4f75-9e95-6a8032d1eae8"
zmedialabelle.Name = _4ObC("\050\037\120\016\041\050\050\041")
zmedialabelle.Description = _4ObC("\002\041\006\043\037")
zmedialabelle.AltText = ""
zmedialabelle.Resources = {
	{
		Type = "jpg", 
		Filename = "c053b4c8-685c-4c8c-a136-ab218f0a7991.jpg", 
		Directives = {}
	}
}
zmediaFeudartifice = Wherigo.ZMedia(cartMaxlamenace)
zmediaFeudartifice.Id = "2c0beccc-eccd-491b-b101-05b924350985"
zmediaFeudartifice.Name = _4ObC("\122\041\035\120\006\054\037\004\111\043\083\043\015\041")
zmediaFeudartifice.Description = _4ObC("\002\041\006\043\037")
zmediaFeudartifice.AltText = ""
zmediaFeudartifice.Resources = {
	{
		Type = "jpg", 
		Filename = "eb640685-507c-4647-9332-706ea93c46ca.jpg", 
		Directives = {}
	}
}
zmediaentete = Wherigo.ZMedia(cartMaxlamenace)
zmediaentete.Id = "33a75ca3-6b70-4d31-aeca-c73c2f68485e"
zmediaentete.Name = _4ObC("\041\049\111\041\111\041")
zmediaentete.Description = _4ObC("\002\041\006\043\037")
zmediaentete.AltText = ""
zmediaentete.Resources = {
	{
		Type = "jpg", 
		Filename = "poster-pirate.jpg", 
		Directives = {}
	}
}
zmediaepee = Wherigo.ZMedia(cartMaxlamenace)
zmediaepee.Id = "48943f92-5baf-44a5-bdaf-08de5e90bdb6"
zmediaepee.Name = _4ObC("\041\052\041\041")
zmediaepee.Description = _4ObC("\002\041\006\043\037")
zmediaepee.AltText = ""
zmediaepee.Resources = {
	{
		Type = "jpg", 
		Filename = "af218dd3-f831-443f-8831-ce398f93b42f.jpg", 
		Directives = {}
	}
}
zmediapirateenfete = Wherigo.ZMedia(cartMaxlamenace)
zmediapirateenfete.Id = "6069f5b3-f324-4afd-9ae3-8a0d83e4d5b0"
zmediapirateenfete.Name = _4ObC("\052\043\004\037\111\041\120\041\049\120\083\041\111\041")
zmediapirateenfete.Description = _4ObC("\002\041\006\043\037")
zmediapirateenfete.AltText = ""
zmediapirateenfete.Resources = {
	{
		Type = "jpg", 
		Filename = "pirates.jpg", 
		Directives = {}
	}
}
zmediatrsor = Wherigo.ZMedia(cartMaxlamenace)
zmediatrsor.Id = "ed58a94e-bd13-4698-b11e-7984d54abb5d"
zmediatrsor.Name = _4ObC("\111\004\195\169\087\127\004")
zmediatrsor.Description = _4ObC("\002\041\006\043\037")
zmediatrsor.AltText = ""
zmediatrsor.Resources = {
	{
		Type = "jpg", 
		Filename = "tresor.jpg", 
		Directives = {}
	}
}
_tgN = Wherigo.ZMedia(cartMaxlamenace)
_tgN.Id = "7835324f-5bd1-4569-91b7-cd9c389cc0d9"
_tgN.Name = _4ObC("\050\037\120\062\050\127\043\004\041\120\041\111\120\050\037\120\004\041\015\127\049\049\037\043\087\087\037\049\015\041")
_tgN.Description = _4ObC("\002\041\006\043\037")
_tgN.AltText = ""
_tgN.Resources = {
	{
		Type = "jpg", 
		Filename = "coueron.jpg", 
		Directives = {}
	}
}
_0KBRw = Wherigo.ZMedia(cartMaxlamenace)
_0KBRw.Id = "70d31e83-c939-4b82-a982-eb7651046add"
_0KBRw.Name = _4ObC("\025\037\091\120\050\041\120\059\195\169\004\127\087")
_0KBRw.Description = _4ObC("\002\041\006\043\037")
_0KBRw.AltText = ""
_0KBRw.Resources = {
	{
		Type = "png", 
		Filename = "characters_jack.png", 
		Directives = {}
	}
}
_u8Hg = Wherigo.ZMedia(cartMaxlamenace)
_u8Hg.Id = "f65ef39b-a811-47f9-9dae-b8ea5f0fc0ba"
_u8Hg.Name = _4ObC("\052\043\004\037\111\041\087\074")
_u8Hg.Description = _4ObC("\002\041\006\043\037\007\108\031\010")
_u8Hg.AltText = ""
_u8Hg.Resources = {
	{
		Type = "mp3", 
		Filename = "15-Pirates_des_Caraibes-He_s_A_Pirate.mp3", 
		Directives = {}
	}
}
_cTK = Wherigo.ZMedia(cartMaxlamenace)
_cTK.Id = "afe29e2b-2899-40cc-9722-a76e4e456616"
_cTK.Name = _4ObC("\114\043\004\037\111\041\097")
_cTK.Description = _4ObC("\002\041\006\043\037")
_cTK.AltText = ""
_cTK.Resources = {
	{
		Type = "mp3", 
		Filename = "Z-Pirates_des_caraibes-Bande_originale.mp3", 
		Directives = {}
	}
}
_LqF = Wherigo.ZMedia(cartMaxlamenace)
_LqF.Id = "04a720ba-57d8-4494-bf9d-91123031f961"
_LqF.Name = _4ObC("\114\043\004\037\111\041\087")
_LqF.Description = ""
_LqF.AltText = ""
_LqF.Resources = {
	{
		Type = "mp3", 
		Filename = "10ToThePiratesCave.mp3", 
		Directives = {}
	}
}
_Qd0b = Wherigo.ZMedia(cartMaxlamenace)
_Qd0b.Id = "5224fc2e-c675-47ea-b5eb-bebc10f11c15"
_Qd0b.Name = _4ObC("\122\041\035\091\120\006\054\037\004\111\043\015\041")
_Qd0b.Description = ""
_Qd0b.AltText = ""
_Qd0b.Resources = {
	{
		Type = "mp3", 
		Filename = "3553.mp3", 
		Directives = {}
	}
}
-- Cartridge Info --
cartMaxlamenace.Id="f86ddf18-d257-4a8f-b77f-c06cd770a3ab"
cartMaxlamenace.Name="Max la menace"
cartMaxlamenace.Description=[[Courte histoire de Pirates]]
cartMaxlamenace.Visible=true
cartMaxlamenace.Activity="Fiction"
cartMaxlamenace.StartingLocationDescription=[[Une grande aire de jeu pour tous]]
cartMaxlamenace.StartingLocation = ZonePoint(47.20941666667,-1.730825,0)
cartMaxlamenace.Version="1.00"
cartMaxlamenace.Company=""
cartMaxlamenace.Author="MAXANAIS44"
cartMaxlamenace.BuilderVersion="URWIGO 1.20.5218.24064"
cartMaxlamenace.CreateDate="06/05/2014 09:45:40"
cartMaxlamenace.PublishDate="1/1/0001 12:00:00 AM"
cartMaxlamenace.UpdateDate="06/18/2014 13:59:59"
cartMaxlamenace.LastPlayedDate="1/1/0001 12:00:00 AM"
cartMaxlamenace.TargetDevice="PocketPC"
cartMaxlamenace.TargetDeviceVersion="0"
cartMaxlamenace.StateId="1"
cartMaxlamenace.CountryId="2"
cartMaxlamenace.Complete=false
cartMaxlamenace.UseLogging=true

cartMaxlamenace.Media=zmediaentete


-- Zones --
zone1lePort = Wherigo.Zone(cartMaxlamenace)
zone1lePort.Id = "d0a44ea1-581e-4e3e-90db-27702d9df85f"
zone1lePort.Name = _4ObC("\097\112\120\050\041\120\114\127\004\111")
zone1lePort.Description = _4ObC("\114\043\004\037\111\041\096\096\007\108\031\010\086\035\120\037\004\004\043\036\041\087\120\087\035\004\120\049\127\111\004\041\120\043\050\041")
zone1lePort.Visible = true
zone1lePort.Media = zmediaDbarquement
zone1lePort.Commands = {
	SAMBA = Wherigo.ZCommand{
		Text = _4ObC("\077\082\075\023\029"), 
		CmdWith = true, 
		Enabled = false, 
		EmptyTargetListText = _4ObC("\026\127\111\048\043\049\011\120\037\036\037\043\050\037\016\050\041")
	}
}
zone1lePort.Commands.SAMBA.Custom = true
zone1lePort.Commands.SAMBA.Id = "8ffe10b5-3fc0-467d-afa4-e36715fa2264"
zone1lePort.Commands.SAMBA.WorksWithAll = false
zone1lePort.Commands.SAMBA.WorksWithListIds = {
	"d0a44ea1-581e-4e3e-90db-27702d9df85f"
}
zone1lePort.DistanceRange = Distance(-1, "feet")
zone1lePort.ShowObjects = "OnEnter"
zone1lePort.ProximityRange = Distance(3, "meters")
zone1lePort.AllowSetPositionTo = false
zone1lePort.Active = true
zone1lePort.Points = {
	ZonePoint(47.2095013181576, -1.73132766749382, 0), 
	ZonePoint(47.2095773338891, -1.73125688037396, 0), 
	ZonePoint(47.2095373339323, -1.73123542270184, 0), 
	ZonePoint(47.2094825768073, -1.7312887754631, 0)
}
zone1lePort.OriginalPoint = ZonePoint(47.2095, -1.73124166666667, 0)
zone1lePort.DistanceRangeUOM = "Feet"
zone1lePort.ProximityRangeUOM = "Meters"
zone1lePort.OutOfRangeName = ""
zone1lePort.InRangeName = ""
zone2lapasserelle = Wherigo.Zone(cartMaxlamenace)
zone2lapasserelle.Id = "3395fd4d-28e0-4c82-86e5-2f037dba8b47"
zone2lapasserelle.Name = _4ObC("\074\112\120\050\037\120\052\037\087\087\041\004\041\050\050\041")
zone2lapasserelle.Description = _4ObC("\053\041\120\052\127\049\111\120\049\054\037\120\004\043\041\049\120\006\054\041\091\015\041\052\111\043\127\049")
zone2lapasserelle.Visible = true
zone2lapasserelle.Media = zmediapasserllle
zone2lapasserelle.Commands = {}
zone2lapasserelle.DistanceRange = Distance(-1, "feet")
zone2lapasserelle.ShowObjects = "OnEnter"
zone2lapasserelle.ProximityRange = Distance(3, "meters")
zone2lapasserelle.AllowSetPositionTo = false
zone2lapasserelle.Active = true
zone2lapasserelle.Points = {
	ZonePoint(47.2095733497129, -1.7315706416988, 0), 
	ZonePoint(47.2095346976567, -1.73153326562408, 0), 
	ZonePoint(47.2094992368561, -1.73158489814762, 0), 
	ZonePoint(47.2094470565007, -1.73164909631248, 0), 
	ZonePoint(47.2094764168298, -1.73169046640396, 0), 
	ZonePoint(47.2095292413576, -1.73163011670113, 0)
}
zone2lapasserelle.OriginalPoint = ZonePoint(47.2094305555556, -1.73167222222222, 0)
zone2lapasserelle.DistanceRangeUOM = "Feet"
zone2lapasserelle.ProximityRangeUOM = "Meters"
zone2lapasserelle.OutOfRangeName = ""
zone2lapasserelle.InRangeName = ""
zone3labataille = Wherigo.Zone(cartMaxlamenace)
zone3labataille.Id = "dae24c66-9f96-41b3-8c70-5fde33874d7a"
zone3labataille.Name = _4ObC("\119\112\120\050\037\120\016\037\111\037\043\050\050\041")
zone3labataille.Description = _4ObC("\059\037\050\111\041\112\050\037\120\111\127\043\120\050\041\120\002\127\049\087\111\004\041\096\096\096\096")
zone3labataille.Visible = true
zone3labataille.Media = zmediaepee
zone3labataille.Commands = {}
zone3labataille.DistanceRange = Distance(-1, "feet")
zone3labataille.ShowObjects = "OnEnter"
zone3labataille.ProximityRange = Distance(3, "meters")
zone3labataille.AllowSetPositionTo = false
zone3labataille.Active = true
zone3labataille.Points = {
	ZonePoint(47.2085558443566, -1.73103332519531, 0), 
	ZonePoint(47.2085667959775, -1.73093676567078, 0), 
	ZonePoint(47.2084611449523, -1.73081606626511, 0), 
	ZonePoint(47.2083600032249, -1.73080064356327, 0), 
	ZonePoint(47.2083007353715, -1.73098638653755, 0), 
	ZonePoint(47.2084385974502, -1.7309682816267, 0), 
	ZonePoint(47.2084437511658, -1.73103667795658, 0)
}
zone3labataille.OriginalPoint = ZonePoint(47.2083861111111, -1.73101666666667, 0)
zone3labataille.DistanceRangeUOM = "Feet"
zone3labataille.ProximityRangeUOM = "Meters"
zone3labataille.OutOfRangeName = ""
zone3labataille.InRangeName = ""
zone4lamour = Wherigo.Zone(cartMaxlamenace)
zone4lamour.Id = "089e1a49-6409-4c08-b557-2519f0f2adb9"
zone4lamour.Name = _4ObC("\093\112\120\050\054\037\002\127\035\004")
zone4lamour.Description = _4ObC("\082\049\041\120\037\052\052\037\004\043\111\043\127\049\060\060\060")
zone4lamour.Visible = true
zone4lamour.Media = zmediabataille
zone4lamour.Commands = {}
zone4lamour.DistanceRange = Distance(-1, "feet")
zone4lamour.ShowObjects = "OnEnter"
zone4lamour.ProximityRange = Distance(3, "meters")
zone4lamour.AllowSetPositionTo = false
zone4lamour.Active = true
zone4lamour.Points = {
	ZonePoint(47.2087095748544, -1.73060029141902, 0), 
	ZonePoint(47.2086715663804, -1.73041014599801, 0), 
	ZonePoint(47.2086022694506, -1.73049262392522, 0), 
	ZonePoint(47.2086183747606, -1.73057346932887, 0)
}
zone4lamour.OriginalPoint = ZonePoint(47.2086277777778, -1.73052777777778, 0)
zone4lamour.DistanceRangeUOM = "Feet"
zone4lamour.ProximityRangeUOM = "Meters"
zone4lamour.OutOfRangeName = ""
zone4lamour.InRangeName = ""
zone5leroidumonde = Wherigo.Zone(cartMaxlamenace)
zone5leroidumonde.Id = "a462c9dd-77cb-4455-b11b-679e8b999033"
zone5leroidumonde.Name = _4ObC("\014\112\120\050\041\120\004\127\043\120\006\035\120\002\127\049\006\041")
zone5leroidumonde.Description = _4ObC("\085\127\035\087\120\015\127\049\111\041\002\052\050\041\021\120\050\041\120\016\127\035\111\120\006\041\120\050\054\043\050\041\070\070\070\070")
zone5leroidumonde.Visible = true
zone5leroidumonde.Media = zmediapirateenfete
zone5leroidumonde.Commands = {}
zone5leroidumonde.DistanceRange = Distance(-1, "feet")
zone5leroidumonde.ShowObjects = "OnEnter"
zone5leroidumonde.ProximityRange = Distance(3, "meters")
zone5leroidumonde.AllowSetPositionTo = false
zone5leroidumonde.Active = true
zone5leroidumonde.Points = {
	ZonePoint(47.2085870275465, -1.72979967915057, 0), 
	ZonePoint(47.208563191672, -1.7297394460154, 0), 
	ZonePoint(47.2085515664518, -1.7297394460154, 0), 
	ZonePoint(47.2085470569599, -1.72981443130016, 0)
}
zone5leroidumonde.OriginalPoint = ZonePoint(47.2085305555556, -1.72973333333333, 0)
zone5leroidumonde.DistanceRangeUOM = "Feet"
zone5leroidumonde.ProximityRangeUOM = "Meters"
zone5leroidumonde.OutOfRangeName = ""
zone5leroidumonde.InRangeName = ""
zone7Letresor = Wherigo.Zone(cartMaxlamenace)
zone7Letresor.Id = "6c89db1c-5db6-4d75-a6ff-8f26b919ede0"
zone7Letresor.Name = _4ObC("\045\112\120\067\041\120\111\004\041\087\127\004")
zone7Letresor.Description = _4ObC("\030\111\041\087\112\036\127\035\087\120\035\049\120\052\043\004\037\111\041\120\015\127\002\016\050\195\169\060\120\088\049\016\087\052\047\088\049\016\087\052\047\088\049\016\087\052\047\088\049\016\087\052\047\088\049\016\087\052\047\088\049\016\087\052\047\088\049\016\087\052\047")
zone7Letresor.Visible = true
zone7Letresor.Media = zmediatrsor
zone7Letresor.Commands = {}
zone7Letresor.DistanceRange = Distance(-1, "feet")
zone7Letresor.ShowObjects = "OnEnter"
zone7Letresor.ProximityRange = Distance(3, "meters")
zone7Letresor.AllowSetPositionTo = false
zone7Letresor.Active = true
zone7Letresor.Points = {
	ZonePoint(47.2094087755895, -1.73160597681999, 0), 
	ZonePoint(47.2093984683452, -1.73160061240196, 0), 
	ZonePoint(47.2093907379108, -1.73159256577492, 0), 
	ZonePoint(47.2093598161617, -1.73155836760998, 0), 
	ZonePoint(47.2093282501909, -1.73157647252083, 0), 
	ZonePoint(47.2093720560229, -1.73162676393986, 0), 
	ZonePoint(47.2094068429813, -1.73163883388042, 0), 
	ZonePoint(47.2094235922495, -1.73162274062634, 0), 
	ZonePoint(47.2094235922495, -1.73161201179028, 0)
}
zone7Letresor.OriginalPoint = ZonePoint(47.209425, -1.73164444444, 0)
zone7Letresor.DistanceRangeUOM = "Feet"
zone7Letresor.ProximityRangeUOM = "Meters"
zone7Letresor.OutOfRangeName = ""
zone7Letresor.InRangeName = ""
zone6laGloire = Wherigo.Zone(cartMaxlamenace)
zone6laGloire.Id = "61b30640-0da2-40cc-a641-9459aacc5800"
zone6laGloire.Name = _4ObC("\057\112\120\050\037\120\062\050\127\043\004\041")
zone6laGloire.Description = _4ObC("\067\037\120\011\050\127\043\004\041")
zone6laGloire.Visible = true
zone6laGloire.Media = _0KBRw
zone6laGloire.Commands = {
	_Yc5P = Wherigo.ZCommand{
		Text = _4ObC("\025\041\087\087\037\011\041"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _4ObC("\067\041\120\111\004\195\169\087\127\004\120\006\041\036\004\037\043\111\120\111\127\035\068\127\035\004\087\120\087\041\120\111\004\127\035\036\041\004\120\043\015\043\120\124\007\108\031\010\026\120\093\045\194\176\097\074\054\119\093\070\074\028\007\108\031\010\029\120\113\113\097\194\176\093\119\054\014\119\070\014\113\007\108\031\010")
	}
}
zone6laGloire.Commands._Yc5P.Custom = true
zone6laGloire.Commands._Yc5P.Id = "cd323d25-de4b-4df1-aaf8-c30d37b44453"
zone6laGloire.Commands._Yc5P.WorksWithAll = true
zone6laGloire.DistanceRange = Distance(-1, "feet")
zone6laGloire.ShowObjects = "OnEnter"
zone6laGloire.ProximityRange = Distance(3, "meters")
zone6laGloire.AllowSetPositionTo = false
zone6laGloire.Active = true
zone6laGloire.Points = {
	ZonePoint(47.2089786524895, -1.73109329447743, 0), 
	ZonePoint(47.2089464420836, -1.73103793005941, 0), 
	ZonePoint(47.2089235283822, -1.73104597668646, 0), 
	ZonePoint(47.2089563830103, -1.73110670552251, 0)
}
zone6laGloire.OriginalPoint = ZonePoint(47.208925, -1.731075, 0)
zone6laGloire.DistanceRangeUOM = "Feet"
zone6laGloire.ProximityRangeUOM = "Meters"
zone6laGloire.OutOfRangeName = ""
zone6laGloire.InRangeName = ""

-- Characters --

-- Items --

-- Tasks --

-- Cartridge Variables --
Answer = ""
_3y3 = _4ObC("\021\127\049\041\097\050\041\114\127\004\111")
_mYt_ = _4ObC("\006\035\002\002\078")
_Iw_ = _4ObC("\006\035\002\002\078")
_uim = _4ObC("\006\035\002\002\078")
_6BiZ9 = _4ObC("\006\035\002\002\078")
_K9N_J = _4ObC("\006\035\002\002\078")
cartMaxlamenace.ZVariables = {
	Answer = "", 
	_3y3 = _4ObC("\021\127\049\041\097\050\041\114\127\004\111"), 
	_mYt_ = _4ObC("\006\035\002\002\078"), 
	_Iw_ = _4ObC("\006\035\002\002\078"), 
	_uim = _4ObC("\006\035\002\002\078"), 
	_6BiZ9 = _4ObC("\006\035\002\002\078"), 
	_K9N_J = _4ObC("\006\035\002\002\078")
}

-- Timers --

-- Inputs --

-- WorksWithList for object commands --

-- functions --
function cartMaxlamenace:OnStart()
	if (_G[_4ObC("\030\049\036")][_4ObC("\075\041\036\043\015\041\023\075")] == _4ObC("\075\041\087\040\111\127\052")) or (_G[_4ObC("\030\049\036")][_4ObC("\114\050\037\111\083\127\004\002")] == _4ObC("\018\043\049\119\074")) then
		for k, v in pairs(_G[_4ObC("\015\037\004\111\025\037\091\050\037\002\041\049\037\015\041")][_4ObC("\077\050\050\022\029\016\068\041\015\111\087")]) do
			v[_4ObC("\085\043\087\043\016\050\041")] = false
			v[_4ObC("\077\015\111\043\036\041")] = false
		end
		_G[_4ObC("\018\048\041\004\043\011\127")][_4ObC("\053\127\002\002\037\049\006")](_4ObC("\017\037\036\041\053\050\127\087\041"))
		return
	end
end
function cartMaxlamenace:OnRestore()
end
function zone1lePort:OnSAMBA(target)
	_3y3 = _4ObC("\021\127\049\041\097\050\041\114\127\004\111")
end
function zone1lePort:OnEnter()
	_3y3 = _4ObC("\021\127\049\041\097\050\041\114\127\004\111")
	zone1lePort.Active = false
	Wherigo.PlayAudio(_cTK)
	_Urwigo.MessageBox{
		Text = _4ObC("\030\087\111\112\015\041\120\035\049\041\120\036\043\087\043\111\041\120\006\041\120\015\127\035\004\111\127\043\087\043\041\007\108\031\010\127\035\120\016\043\041\049\120\111\041\120\052\004\195\169\052\037\004\041\087\120\111\035\120\195\160\120\006\195\169\036\037\087\111\041\004\120\049\127\111\004\041\120\043\050\041\060\007\108\031\010"), 
		Media = zmediaDbarquement, 
		Buttons = {
			_4ObC("\029\092")
		}
	}
end
function zone1lePort:OnExit()
	_3y3 = _4ObC("\021\127\049\041\097\050\041\114\127\004\111")
	zone1lePort.Active = false
	_Urwigo.MessageBox{
		Text = _4ObC("\075\043\004\043\011\041\120\111\127\043\120\036\041\004\087\120\050\037\120\052\037\087\087\041\004\041\050\050\041"), 
		Buttons = {
			_4ObC("\029\092")
		}
	}
	Wherigo.Command "StopSound"
end
function zone2lapasserelle:OnEnter()
	_3y3 = _4ObC("\021\127\049\041\074\050\037\052\037\087\087\041\004\041\050\050\041")
	_Urwigo.MessageBox{
		Text = _4ObC("\108\043\041\049\096\096\096\120\017\043\120\111\035\120\036\041\035\091\120\195\170\111\004\041\120\037\052\052\004\041\015\043\195\169\120\006\041\087\120\011\041\049\087\120\006\054\043\015\043\120\111\035\120\006\041\036\004\037\087\120\002\127\049\111\004\041\004\120\111\037\120\036\037\043\050\050\037\049\015\041\120\041\111\120\015\127\002\016\037\111\111\004\041\120\035\049\120\002\127\049\087\111\004\041\120\087\041\004\037\087\112\111\035\120\111\195\169\002\195\169\004\037\043\004\041\060"), 
		Media = zmediapasserllle
	}
end
function zone2lapasserelle:OnExit()
	_3y3 = _4ObC("\021\127\049\041\074\050\037\052\037\087\087\041\004\041\050\050\041")
	zone2lapasserelle.Active = false
	Wherigo.PlayAudio(_LqF)
	_Urwigo.MessageBox{
		Text = _4ObC("\052\127\035\004\120\050\037\120\016\037\111\037\043\050\050\041\070\070\070\015\054\041\087\111\120\036\041\004\087\120\050\041\120\083\127\049\006\120\006\041\120\050\054\043\050\041\120\041\111\120\016\127\049\120\015\127\035\004\037\011\041")
	}
end
function zone3labataille:OnEnter()
	_3y3 = _4ObC("\021\127\049\041\119\050\037\016\037\111\037\043\050\050\041")
	zone3labataille.Active = false
	_Urwigo.MessageBox{
		Text = _4ObC("\017\043\120\111\035\120\049\041\120\111\041\120\016\127\035\011\041\087\120\052\037\087\120\006\041\120\002\127\049\120\015\048\041\002\043\049\120\050\041\120\002\127\049\087\111\004\041\070\070\070\071\041\120\036\037\043\087\120\002\054\127\015\015\035\052\041\004\120\006\041\120\111\127\049\120\002\037\111\004\043\015\035\050\041"), 
		Media = zmediaepee
	}
end
function zone3labataille:OnExit()
	_3y3 = _4ObC("\021\127\049\041\119\050\037\016\037\111\037\043\050\050\041")
	zone3labataille.Active = false
	_Urwigo.MessageBox{
		Text = _4ObC("\108\004\037\036\127\096\096\120\050\041\120\002\127\049\087\111\004\041\120\087\054\041\049\120\036\037\098\120\111\035\120\052\041\035\091\120\052\127\035\004\087\035\043\036\004\041\120\111\127\049\120\037\036\041\049\111\035\004\041\070\070\070\070\120\088\049\016\087\052\047\088\049\016\087\052\047\088\049\016\087\052\047\088\049\016\087\052\047\088\049\016\087\052\047\088\049\016\087\052\047\088\049\016\087\052\047\088\049\016\087\052\047\088\049\016\087\052\047\088\049\016\087\052\047\088\049\016\087\052\047\088\049\016\087\052\047\088\049\016\087\052\047\088\049\016\087\052\047\088\049\016\087\052\047\088\049\016\087\052\047\088\049\016\087\052\047\088\049\016\087\052\047\088\049\016\087\052\047\088\049\016\087\052\047\088\049\016\087\052\047\088\049\016\087\052\047\088\049\016\087\052\047\088\049\016\087\052\047\088\049\016\087\052\047\088\049\016\087\052\047\088\049\016\087\052\047\088\049\016\087\052\047\088\049\016\087\052\047\088\049\016\087\052\047\088\049\016\087\052\047\088\049\016\087\052\047\088\049\016\087\052\047\088\049\016\087\052\047\088\049\016\087\052\047\088\049\016\087\052\047\088\049\016\087\052\047\088\049\016\087\052\047\088\049\016\087\052\047\088\049\016\087\052\047\088\049\016\087\052\047\088\049\016\087\052\047\088\049\016\087\052\047\088\049\016\087\052\047\088\049\016\087\052\047\088\049\016\087\052\047\088\049\016\087\052\047\088\049\016\087\052\047\088\049\016\087\052\047\088\049\016\087\052\047\088\049\016\087\052\047\088\049\016\087\052\047\088\049\016\087\052\047\088\049\016\087\052\047\088\049\016\087\052\047\088\049\016\087\052\047\088\049\016\087\052\047\088\049\016\087\052\047\088\049\016\087\052\047\088\049\016\087\052\047\088\049\016\087\052\047\088\049\016\087\052\047\088\049\016\087\052\047\088\049\016\087\052\047\025\037\043\087\120\063\035\041\050\050\041\120\041\087\111\120\015\041\111\111\041\120\037\052\052\037\004\043\111\043\127\049\060\070\070\070"), 
		Media = zmediabataille
	}
end
function zone4lamour:OnEnter()
	_3y3 = _4ObC("\021\127\049\041\093\050\037\002\127\035\004")
	zone4lamour.Active = false
	_Urwigo.MessageBox{
		Text = _4ObC("\108\127\049\068\127\035\004\007\108\031\010\077\049\037\043\087\120\050\037\120\052\004\043\049\015\041\087\087\041\120\006\041\120\053\127\035\041\004\127\049\007\108\031\010\071\041\120\036\127\035\087\120\006\127\043\087\120\035\049\041\120\083\043\195\168\004\041\120\015\048\037\049\006\041\050\050\041\096\096\096"), 
		Media = zmedialabelle, 
		Buttons = {
			_4ObC("\029\092")
		}
	}
end
function zone4lamour:OnExit()
	_3y3 = _4ObC("\021\127\049\041\093\050\037\002\127\035\004")
	zone4lamour.Active = false
	_Urwigo.MessageBox{
		Text = _4ObC("\085\127\035\087\120\002\054\037\036\041\021\120\006\195\169\050\043\036\004\195\169\120\006\041\087\120\011\004\043\083\083\041\087\120\006\041\120\015\041\111\120\037\083\083\004\041\035\091\120\002\127\049\087\111\004\041\007\108\031\010\071\041\120\087\035\043\087\120\087\037\120\052\004\043\087\127\049\049\043\195\168\004\041\098\120\043\050\120\002\041\120\004\041\111\043\041\049\111\120\087\035\004\120\015\041\111\111\041\120\043\050\041\007\108\031\010\041\111\120\052\050\035\087\120\052\041\004\087\127\049\049\041\120\127\087\041\120\036\041\049\043\004\120\087\054\037\036\041\049\111\035\004\041\004\120\043\015\043\112\016\037\087"), 
		Media = zmedialabelle
	}
end
function zone5leroidumonde:OnEnter()
	_3y3 = _4ObC("\021\127\049\041\014\050\041\004\127\043\006\035\002\127\049\006\041")
	zone5leroidumonde.Active = false
	Wherigo.PlayAudio(_Qd0b)
	_Urwigo.MessageBox{
		Text = _4ObC("\086\127\035\087\120\050\041\087\120\036\043\050\050\037\011\041\127\043\087\120\087\127\049\111\120\004\195\169\035\049\043\087\120\052\127\035\004\120\015\041\050\041\016\004\041\004\120\036\127\111\004\041\120\036\043\015\111\127\043\004\041\120\087\035\004\120\050\041\120\006\004\037\011\127\049\120\041\111\120\036\127\111\004\041\120\004\041\049\015\127\049\111\004\041\120\037\036\041\015\120\050\037\120\052\004\043\049\015\041\087\087\041\120\077\049\037\195\175\087\007\108\031\010\085\127\035\087\120\037\036\041\021\120\004\041\049\006\041\021\112\036\127\035\087\120\037\036\041\015\120\050\037\120\011\050\127\043\004\041\120\041\111\120\050\037\120\004\041\015\127\049\049\037\043\087\087\037\049\015\041\120\006\041\087\120\048\037\016\043\111\037\049\111\087\120\006\041\120\050\054\043\050\041\070\070\070\007\108\031\010"), 
		Media = zmediaFeudartifice
	}
end
function zone5leroidumonde:OnExit()
	_3y3 = _4ObC("\021\127\049\041\014\050\041\004\127\043\006\035\002\127\049\006\041")
	zone5leroidumonde.Active = false
	_Urwigo.MessageBox{
		Text = _4ObC("\050\037\120\087\035\043\111\041\120\006\041\120\050\054\037\036\041\049\111\035\004\041\007\108\031\010\041\049\120\006\043\004\041\015\111\043\127\049\120\006\041\120\067\037\120\011\050\127\043\004\041"), 
		Media = _0KBRw
	}
end
function zone7Letresor:OnEnter()
	_3y3 = _4ObC("\021\127\049\041\045\067\041\111\004\041\087\127\004")
	zone7Letresor.Active = false
	_Urwigo.MessageBox{
		Text = _4ObC("\085\127\035\087\120\041\111\041\087\120\052\037\087\120\050\127\043\049\120\006\041\120\111\004\127\035\036\041\004\120\050\041\120\111\004\195\169\087\127\004\120\006\041\087\120\052\043\004\037\111\041\087\120\007\108\031\010\002\041\120\087\041\002\016\050\041\112\111\112\043\050\120\060\120\088\049\016\087\052\047\088\049\016\087\052\047\088\049\016\087\052\047\088\049\016\087\052\047\088\049\016\087\052\047\088\049\016\087\052\047\088\049\016\087\052\047\088\049\016\087\052\047\088\049\016\087\052\047\088\049\016\087\052\047\088\049\016\087\052\047\088\049\016\087\052\047\088\049\016\087\052\047\088\049\016\087\052\047\088\049\016\087\052\047\088\049\016\087\052\047\088\049\016\087\052\047\088\049\016\087\052\047\088\049\016\087\052\047\088\049\016\087\052\047\088\049\016\087\052\047\088\049\016\087\052\047\088\049\016\087\052\047\088\049\016\087\052\047\088\049\016\087\052\047\088\049\016\087\052\047\088\049\016\087\052\047\088\049\016\087\052\047\088\049\016\087\052\047\088\049\016\087\052\047\088\049\016\087\052\047\088\049\016\087\052\047\088\049\016\087\052\047\088\049\016\087\052\047\088\049\016\087\052\047\088\049\016\087\052\047\088\049\016\087\052\047\088\049\016\087\052\047\088\049\016\087\052\047\088\049\016\087\052\047\088\049\016\087\052\047\088\049\016\087\052\047\007\108\031\010\015\048\041\004\015\048\041\021\120\016\043\041\049\120\043\050\120\087\041\120\002\041\004\043\111\041\070\070\070\007\108\031\010\023\050\120\036\127\035\087\120\050\043\036\004\041\004\037\120\050\041\120\015\127\006\041\120\006\054\037\015\048\195\169\036\041\002\041\049\111\120\195\160\120\195\169\015\004\043\004\041\120\006\037\049\087\120\036\127\111\004\041\120\050\127\011\120\007\108\031\010\087\035\004\120\050\041\120\087\043\111\041\120\043\049\111\041\004\049\041\111\120\031\077\026\062\030\031\122\029\084\070\049\041\111\120\036\043\037\120\062\030\029\053\077\053\059\023\026\062\070\015\127\002\007\108\031\010\025\077\084\120\050\037\120\002\041\049\037\015\041\120\087\041\120\015\048\037\004\011\041\120\006\041\120\036\037\050\043\006\041\004\120\036\127\111\004\041\120\006\195\169\015\127\035\036\041\004\111\041\120"), 
		Media = zmediatrsor, 
		Buttons = {
			_4ObC("\029\092")
		}
	}
end
function zone6laGloire:On_Yc5P(target)
	_3y3 = _4ObC("\021\127\049\041\057\050\037\062\050\127\043\004\041")
end
function zone6laGloire:OnEnter()
	_3y3 = _4ObC("\021\127\049\041\057\050\037\062\050\127\043\004\041")
	Wherigo.PlayAudio(_u8Hg)
	zone6laGloire.Active = false
	_Urwigo.MessageBox{
		Text = _4ObC("\030\049\120\004\127\035\111\041\120\052\127\035\004\120\050\041\120\111\004\195\169\087\127\004\120\006\041\120\050\054\043\050\041\120\124\007\108\031\010\026\120\093\045\194\176\120\097\074\120\119\093\070\074\028\007\108\031\010\029\120\113\113\097\194\176\120\093\119\120\014\119\070\014\113"), 
		Media = _0KBRw
	}
end

-- Urwigo functions --

-- Begin user functions --
-----------------------------------------------------------------------------------------------
-- URWIGO: Following code is imported from the Wherigo Builder cartridge.
-- It is only neccessary if the cartridge uses Author functions that use message box callbacks.
-- Otherwise it can be removed.
cartMaxlamenace.MsgBoxCBFuncs = {}
-------------------------------------------------------------------------------
--#LASTCALLBACKKEY=0#--

-----------------------------------------------------------------------------------------------
-- URWIGO: Here follow imported Author functions


-- End user functions --
return cartMaxlamenace
