require "Wherigo"
ZonePoint = Wherigo.ZonePoint
Distance = Wherigo.Distance
Player = Wherigo.Player

-- String decode --
function _hbQ(str)
	local res = ""
    local dtable = "\025\021\082\048\029\085\027\097\012\103\028\070\078\063\119\016\032\111\112\049\003\000\126\015\017\020\042\110\067\053\084\104\041\118\101\123\076\046\045\009\096\120\116\099\113\030\100\014\091\079\115\001\026\047\037\095\031\098\125\065\124\109\052\043\062\022\002\007\004\087\008\069\102\038\057\089\083\055\086\019\036\035\088\074\105\058\044\010\039\061\121\075\122\023\040\090\068\081\024\080\072\054\106\034\056\059\051\060\064\107\092\033\114\093\066\117\005\018\013\006\073\050\071\108\094\011\077"
	for i=1, #str do
        local b = str:byte(i)
        if b > 0 and b <= 0x7F then
	        res = res .. string.char(dtable:byte(b))
        else
            res = res .. string.char(b)
        end
	end
	return res
end

-- Internal functions --
require "table"
require "math"

math.randomseed(os.time())
math.random()
math.random()
math.random()

_Urwigo = {}

_Urwigo.InlineRequireLoaded = {}
_Urwigo.InlineRequireRes = {}
_Urwigo.InlineRequire = function(moduleName)
  local res
  if _Urwigo.InlineRequireLoaded[moduleName] == nil then
    res = _Urwigo.InlineModuleFunc[moduleName]()
    _Urwigo.InlineRequireLoaded[moduleName] = 1
    _Urwigo.InlineRequireRes[moduleName] = res
  else
    res = _Urwigo.InlineRequireRes[moduleName]
  end
  return res
end

_Urwigo.Round = function(num, idp)
  local mult = 10^(idp or 0)
  return math.floor(num * mult + 0.5) / mult
end

_Urwigo.Ceil = function(num, idp)
  local mult = 10^(idp or 0)
  return math.ceil(num * mult) / mult
end

_Urwigo.Floor = function(num, idp)
  local mult = 10^(idp or 0)
  return math.floor(num * mult) / mult
end

_Urwigo.DialogQueue = {}
_Urwigo.RunDialogs = function(callback)
	local dialogs = _Urwigo.DialogQueue
	local lastCallback = nil
	_Urwigo.DialogQueue = {}
	local msgcb = {}
	msgcb = function(action)
		if action ~= nil then
			if lastCallback ~= nil then
				lastCallback(action)
			end
			local entry = table.remove(dialogs, 1)
			if entry ~= nil then
				lastCallback = entry.Callback;
				if entry.Text ~= nil then
					Wherigo.MessageBox({Text = entry.Text, Media=entry.Media, Buttons=entry.Buttons, Callback=msgcb})
				else
					msgcb(action)
				end
			else
				if callback ~= nil then
					callback()
				end
			end
		end
	end
	msgcb(true) -- any non-null argument
end

_Urwigo.MessageBox = function(tbl)
    _Urwigo.RunDialogs(function() Wherigo.MessageBox(tbl) end)
end

_Urwigo.OldDialog = function(tbl)
    _Urwigo.RunDialogs(function() Wherigo.Dialog(tbl) end)
end

_Urwigo.Dialog = function(buffered, tbl, callback)
	for k,v in ipairs(tbl) do
		table.insert(_Urwigo.DialogQueue, v)
	end
	if callback ~= nil then
		table.insert(_Urwigo.DialogQueue, {Callback=callback})
	end
	if not buffered then
		_Urwigo.RunDialogs(nil)
	end
end

_Urwigo.Hash = function(str)
   local b = 378551;
   local a = 63689;
   local hash = 0;
   for i = 1, #str, 1 do
      hash = hash*a+string.byte(str,i);
      hash = math.fmod(hash, 65535)
      a = a*b;
      a = math.fmod(a, 65535)
   end
   return hash;
end

_Urwigo.DaysInMonth = {
	31,
	28,
	31,
	30,
	31,
	30,
	31,
	31,
	30,
	31,
	30,
	31,
}

_Urwigo_Date_IsLeapYear = function(year)
	if year % 400 == 0 then
		return true
	elseif year% 100 == 0 then
		return false
	elseif year % 4 == 0 then
		return true
	else
		return false
	end
end

_Urwigo.Date_DaysInMonth = function(year, month)
	if month ~= 2 then
		return _Urwigo.DaysInMonth[month];
	else
		if _Urwigo_Date_IsLeapYear(year) then
			return 29
		else
			return 28
		end
	end
end

_Urwigo.Date_DayInYear = function(t)
	local res = t.day
	for month = 1, t.month - 1 do
		res = res + _Urwigo.Date_DaysInMonth(t.year, month)
	end
	return res
end

_Urwigo.Date_HourInWeek = function(t)
	return t.hour + (t.wday-1) * 24
end

_Urwigo.Date_HourInMonth = function(t)
	return t.hour + t.day * 24
end

_Urwigo.Date_HourInYear = function(t)
	return t.hour + (_Urwigo.Date_DayInYear(t) - 1) * 24
end

_Urwigo.Date_MinuteInDay = function(t)
	return t.min + t.hour * 60
end

_Urwigo.Date_MinuteInWeek = function(t)
	return t.min + t.hour * 60 + (t.wday-1) * 1440;
end

_Urwigo.Date_MinuteInMonth = function(t)
	return t.min + t.hour * 60 + (t.day-1) * 1440;
end

_Urwigo.Date_MinuteInYear = function(t)
	return t.min + t.hour * 60 + (_Urwigo.Date_DayInYear(t) - 1) * 1440;
end

_Urwigo.Date_SecondInHour = function(t)
	return t.sec + t.min * 60
end

_Urwigo.Date_SecondInDay = function(t)
	return t.sec + t.min * 60 + t.hour * 3600
end

_Urwigo.Date_SecondInWeek = function(t)
	return t.sec + t.min * 60 + t.hour * 3600 + (t.wday-1) * 86400
end

_Urwigo.Date_SecondInMonth = function(t)
	return t.sec + t.min * 60 + t.hour * 3600 + (t.day-1) * 86400
end

_Urwigo.Date_SecondInYear = function(t)
	return t.sec + t.min * 60 + t.hour * 3600 + (_Urwigo.Date_DayInYear(t)-1) * 86400
end


-- Inlined modules --
_Urwigo.InlineModuleFunc = {}

_rcZu = Wherigo.ZCartridge()

-- Media --
_UJI = Wherigo.ZMedia(_rcZu)
_UJI.Id = "9643492b-8a95-4659-8f20-1e46356542b1"
_UJI.Name = _hbQ("\077\035\028\043\085\028\035\124\124\035\051\017\047\035\017\124\089\060\085\113")
_UJI.Description = _hbQ("\031\018\116\043\035\017\124\089\035\045\116\085\019\035\017\047\035\051\017\077\035\028\043\085\028\035\124\124\035\051\017\047\035\017\124\089\008\085\113")
_UJI.AltText = ""
_UJI.Resources = {
	{
		Type = "JPG", 
		Filename = "Thunderbirds.JPG", 
		Directives = {}
	}
}
_ilg0K = Wherigo.ZMedia(_rcZu)
_ilg0K.Id = "80aaffe6-25b0-4bf1-ad39-51bc3385eca1"
_ilg0K.Name = _hbQ("\121\003\017\037\018\010\018\017\121\044\018\028")
_ilg0K.Description = _hbQ("\037\035\017\124\018\010\018\017\047\035\017\124\089\121\028\043\035\113\028\008\043\085\018\028\008\124\017\003\035\051\044\116\035\038")
_ilg0K.AltText = ""
_ilg0K.Resources = {
	{
		Type = "JPG", 
		Filename = "IR_Logo.JPG", 
		Directives = {}
	}
}
_s4ewr = Wherigo.ZMedia(_rcZu)
_s4ewr.Id = "6034f08c-978f-453b-83d6-c12c7c456370"
_s4ewr.Name = _hbQ("\123\018\113\047\018\028\017\031\113\008\044\091")
_s4ewr.Description = _hbQ("\100\085\124\018\043\035\017\035\043\017\008\045\116\008\028\008\116\043\035\017\047\035\017\031\032\116\028\047\035\113\058\085\113\047\017\063\038")
_s4ewr.AltText = ""
_s4ewr.Resources = {
	{
		Type = "JPG", 
		Filename = "TB4_Gordon.JPG", 
		Directives = {}
	}
}
_JIJy = Wherigo.ZMedia(_rcZu)
_JIJy.Id = "4c2edccd-28c3-439c-80ed-33945130b469"
_JIJy.Name = _hbQ("\079\085\113\010\085\124\017\031\113\008\044\091")
_JIJy.Description = _hbQ("\100\085\124\018\043\035\017\047\035\017\031\032\116\028\047\035\113\058\085\113\047\017\122")
_JIJy.AltText = ""
_JIJy.Resources = {
	{
		Type = "JPG", 
		Filename = "TB2_Virgil.JPG", 
		Directives = {}
	}
}
_qz74 = Wherigo.ZMedia(_rcZu)
_qz74.Id = "8627a816-1afd-4668-9e05-6b5ba3112ae4"
_qz74.Name = _hbQ("\060\124\008\028\017\031\113\008\044\091")
_qz74.Description = _hbQ("\100\085\124\018\043\035\017\035\043\017\008\051\043\113\018\028\008\116\043\035\017\047\035\017\031\032\116\028\047\035\113\058\085\113\047\017\107\038")
_qz74.AltText = ""
_qz74.Resources = {
	{
		Type = "JPG", 
		Filename = "TB3_Alan.JPG", 
		Directives = {}
	}
}
_oxPVF = Wherigo.ZMedia(_rcZu)
_oxPVF.Id = "d311bf7d-e6c6-47ab-9e1c-96c460302a96"
_oxPVF.Name = _hbQ("\084\018\032\028\017\031\113\008\044\091")
_oxPVF.Description = _hbQ("\060\051\043\113\018\028\008\116\043\035\017\047\035\017\124\008\017\077\043\008\043\085\018\028\017\018\113\058\085\124\008\124\035\017\031\032\116\028\047\035\113\058\085\113\047\017\030\038")
_oxPVF.AltText = ""
_oxPVF.Resources = {
	{
		Type = "JPG", 
		Filename = "TB5_John.JPG", 
		Directives = {}
	}
}
_3h4R = Wherigo.ZMedia(_rcZu)
_3h4R.Id = "41ac86a7-c889-48fb-b9b9-31eca8c03206"
_3h4R.Name = _hbQ("\077\044\018\043\043\017\031\113\008\044\091")
_3h4R.Description = _hbQ("\100\085\124\018\043\035\017\047\035\017\031\032\116\028\047\035\113\058\085\113\047\017\020\038")
_3h4R.AltText = ""
_3h4R.Resources = {
	{
		Type = "JPG", 
		Filename = "TB1_Scott.JPG", 
		Directives = {}
	}
}
_aJI = Wherigo.ZMedia(_rcZu)
_aJI.Id = "8519e279-b602-4eed-b683-ef07e9c7585c"
_aJI.Name = _hbQ("\084\035\073\073\017\031\113\008\044\091")
_aJI.Description = _hbQ("\100\035\113\035\017\047\035\051\017\077\035\028\043\085\028\035\124\124\035\051\017\047\035\017\124\089\008\085\113\017\035\043\017\044\018\062\062\008\028\047\008\043\017\047\035\017\124\008\017\058\008\051\035\017\047\035\017\124\008\017\077\035\044\116\113\085\043\035\017\121\028\043\035\113\028\008\043\085\018\028\008\124\035\038")
_aJI.AltText = ""
_aJI.Resources = {
	{
		Type = "JPG", 
		Filename = "Jeff_Pere.JPG", 
		Directives = {}
	}
}
_nRB2 = Wherigo.ZMedia(_rcZu)
_nRB2.Id = "6c0de43d-3c08-4e2b-a9b8-8eda853dd72a"
_nRB2.Name = _hbQ("\037\008\047\091\017\100\035\028\035\124\018\019\035")
_nRB2.Description = _hbQ("\037\008\047\091\017\100\035\028\035\124\018\019\035\017\029\113\035\085\010\032\043\018\028\039\070\008\113\047\017\035\051\043\017\008\010\035\028\043\039\051\035\044\113\035\043\017\047\035\017\124\089\018\113\010\008\028\085\051\008\043\085\018\028\087\017\034\085\034\008\028\043\017\008\017\037\018\028\047\113\035\051\087\017\035\043\017\045\116\085\017\019\018\051\051\035\047\035\017\116\028\035\017\003\018\124\124\051\039\003\018\091\044\035\017\012\060\115\017\020\038\017\072\124\124\035\017\035\051\043\017\116\028\035\017\008\062\085\035\017\047\035\051\017\031\113\008\044\091\017\035\043\017\043\018\116\103\018\116\113\051\017\019\113\035\043\035\017\008\017\019\018\113\043\035\113\017\008\051\051\085\051\043\008\028\044\035\017\008\017\124\089\018\113\010\008\028\085\051\008\043\085\018\028\038")
_nRB2.AltText = ""
_nRB2.Resources = {
	{
		Type = "JPG", 
		Filename = "LadyPenelope.JPG", 
		Directives = {}
	}
}
_9tf = Wherigo.ZMedia(_rcZu)
_9tf.Id = "ba96a41f-6a60-4454-ae7e-030f225b9abf"
_9tf.Name = _hbQ("\012\060\115\017\020")
_9tf.Description = _hbQ("\012\060\115\017\020\017\035\051\043\017\116\028\035\017\003\018\124\124\051\017\003\018\091\044\035\017\113\018\051\035\017\035\045\116\085\019\035\035\017\047\089\116\028\035\017\044\008\124\008\028\047\113\035\017\018\058\124\085\045\116\035\087\017\008\017\102\017\113\018\116\035\051\017\062\018\043\113\085\044\035\051\017\047\018\028\043\017\063\017\047\085\113\035\044\043\085\018\028\028\035\124\124\035\051\017\008\017\124\089\008\034\008\028\043\017\035\043\017\051\116\113\062\018\028\043\035\035\017\047\089\116\028\017\043\018\085\043\017\035\028\017\058\116\124\124\035\038\017\077\018\028\017\044\032\008\116\073\073\035\116\113\087\017\100\008\113\110\035\113\087\017\124\008\017\019\085\124\018\043\035\017\051\116\113\017\116\028\017\051\085\035\010\035\017\044\035\028\043\113\008\124\017\008\034\008\028\043\087\017\035\043\017\116\028\035\017\058\008\028\045\116\035\043\043\035\017\035\051\043\017\019\113\035\051\035\028\043\035\017\019\018\116\113\017\008\044\044\116\035\085\124\124\085\113\017\124\035\051\017\019\008\051\051\008\010\035\113\051\017\008\017\124\089\008\113\113\085\035\113\035\038\017\072\124\124\035\017\035\051\043\017\043\113\116\073\073\035\035\017\047\035\017\010\008\047\010\035\043\051\086\108\115\003\065\037\008\028\044\035\039\062\085\051\051\085\124\035\051\087\017\062\085\043\113\008\085\124\124\035\116\051\035\051\087\017\113\008\047\008\113\051\087\017\035\124\124\035\017\035\051\043\017\008\062\019\032\085\058\085\035\017\035\043\017\035\124\124\035\017\034\018\124\035\017\008\116\051\051\085\017\019\008\113\073\018\085\051\038")
_9tf.AltText = ""
_9tf.Resources = {
	{
		Type = "JPG", 
		Filename = "FAB_1.JPG", 
		Directives = {}
	}
}
_DrWx0 = Wherigo.ZMedia(_rcZu)
_DrWx0.Id = "c0462bcd-ec63-4a3c-88c5-1537e94f9b19"
_DrWx0.Name = _hbQ("\031\032\116\028\047\035\113\058\085\113\047\017\020")
_DrWx0.Description = _hbQ("\077\019\035\044\085\073\085\044\008\043\085\018\028\051\017\047\035\017\031\032\116\028\047\035\113\058\085\113\047\017\020\086\108\115\003\065\037\018\028\010\116\035\116\113\086\017\074\028\058\051\019\106\107\030\017\062\035\043\113\035\051\106\108\115\003\065\079\085\043\035\051\051\035\086\017\074\028\058\051\019\106\127\008\044\032\017\020\075\087\078\017\095\122\063\087\004\004\004\017\110\062\054\032\033\106\108\115\003\065\100\113\018\019\116\124\051\085\018\028\086\017\003\035\008\044\043\035\116\113\017\008\017\073\116\051\085\018\028\017\028\116\044\124\035\008\085\113\035\038\108\115\003\065\115\085\035\028\017\045\116\089\085\124\017\051\089\035\028\034\018\124\035\017\008\017\124\008\017\034\035\113\043\085\044\008\124\035\087\017\085\124\017\019\035\116\043\017\051\035\017\019\018\051\035\113\017\008\116\051\051\085\017\008\017\124\089\032\018\113\085\093\018\028\043\008\124\035\017\008\034\035\044\017\047\035\051\017\113\035\043\113\018\039\073\116\051\035\035\051\017\095\079\031\050\037\033\038")
_DrWx0.AltText = ""
_DrWx0.Resources = {
	{
		Type = "JPG", 
		Filename = "Thunderbird_1.JPG", 
		Directives = {}
	}
}
_jM5n = Wherigo.ZMedia(_rcZu)
_jM5n.Id = "9a7028f2-9a22-4dad-a22a-dbc80bfc6ed6"
_jM5n.Name = _hbQ("\031\032\116\028\047\035\113\058\085\113\047\017\122")
_jM5n.Description = _hbQ("\077\019\035\044\085\073\085\044\008\043\085\018\028\051\017\047\035\017\031\032\116\028\047\035\113\058\085\113\047\017\122\086\108\115\003\065\037\018\028\010\116\035\116\113\086\017\078\102\017\062\035\043\113\035\051\106\108\115\003\065\072\028\034\035\113\010\116\113\035\017\043\018\043\008\124\035\086\017\030\030\017\062\035\043\113\035\051\106\108\115\003\065\101\008\116\043\035\116\113\086\017\020\105\017\062\035\043\113\035\051\038\108\115\003\065\079\085\043\035\051\051\035\017\047\035\017\044\113\018\085\051\085\035\113\035\086\017\074\028\058\051\019\106\107\087\122\004\004\017\110\062\054\032\106\108\115\003\065\079\085\043\035\051\051\035\017\062\008\042\085\062\008\124\035\086\017\074\028\058\051\019\106\075\087\078\004\004\017\110\062\054\032\106\108\115\003\065\100\113\018\019\116\124\051\085\018\028\086\017\074\028\058\051\019\106\003\035\008\044\043\035\116\113\017\008\017\073\116\051\085\018\028\017\028\116\044\124\035\008\085\113\035\038\108\115\003\065\121\124\017\019\035\116\043\017\051\035\017\113\035\028\047\113\035\017\028\089\085\062\019\018\113\043\035\017\018\116\017\047\008\028\051\017\124\035\017\062\018\028\047\035\017\051\008\028\051\017\113\035\073\008\085\113\035\017\124\035\017\019\124\035\085\028\038\017\121\124\017\008\113\113\085\034\035\017\028\018\113\062\008\124\035\062\035\028\043\017\051\116\113\017\116\028\017\124\085\035\116\017\047\035\017\051\085\028\085\051\043\113\035\017\085\062\062\035\047\085\008\043\035\062\035\028\043\017\008\019\113\035\051\017\031\115\020\038")
_jM5n.AltText = ""
_jM5n.Resources = {
	{
		Type = "JPG", 
		Filename = "Thunderbird_2.JPG", 
		Directives = {}
	}
}
_Tt1yP = Wherigo.ZMedia(_rcZu)
_Tt1yP.Id = "b3a826c8-bfc7-4add-abcb-6b6860118b6e"
_Tt1yP.Name = _hbQ("\031\032\116\028\047\035\113\058\085\113\047\017\107")
_Tt1yP.Description = _hbQ("\077\019\035\044\085\073\085\044\008\043\085\018\028\051\017\047\035\017\031\032\116\028\047\035\113\058\085\113\047\017\107\086\108\115\003\065\037\018\028\010\116\035\116\113\086\017\105\078\017\062\035\043\113\035\051\106\108\115\003\065\037\008\113\010\035\116\113\086\017\078\017\062\035\043\113\035\051\106\108\115\003\065\072\028\034\035\113\010\116\113\035\086\017\122\063\017\062\035\043\113\035\051\106\108\115\003\065\100\113\018\019\116\124\051\085\018\028\017\047\035\044\018\124\124\008\010\035\086\017\074\028\058\051\019\106\062\018\043\035\116\113\017\008\017\044\008\113\058\116\113\008\028\043\017\044\032\085\062\085\045\116\035\106\108\115\003\065\100\113\018\019\116\124\051\085\018\028\017\047\008\028\051\017\124\089\035\051\019\008\044\035\086\017\074\028\058\051\019\106\072\124\035\044\043\113\085\045\116\035\017\121\018\028\038")
_Tt1yP.AltText = ""
_Tt1yP.Resources = {
	{
		Type = "JPG", 
		Filename = "Thunderbird_3.JPG", 
		Directives = {}
	}
}
_9EL = Wherigo.ZMedia(_rcZu)
_9EL.Id = "fed0cef4-0db0-405a-b961-3222bb79b0b4"
_9EL.Name = _hbQ("\031\032\116\028\047\035\113\058\085\113\047\017\063")
_9EL.Description = _hbQ("\077\019\035\044\085\073\085\044\008\043\085\018\028\051\017\047\035\017\031\032\116\028\047\035\113\058\085\113\047\017\063\086\108\115\003\065\037\018\028\010\116\035\116\113\086\017\075\017\062\035\043\113\035\051\106\108\115\003\065\037\008\113\010\035\116\113\086\017\107\017\062\035\043\113\035\051\106\108\115\003\065\029\035\017\051\116\058\062\035\113\051\085\058\124\035\017\035\051\043\017\043\113\008\028\051\019\018\113\043\035\017\047\008\028\051\017\116\028\017\044\008\085\051\051\018\028\017\019\008\113\017\031\032\116\028\047\035\113\058\085\113\047\017\122\038\017\100\008\113\062\085\017\124\035\051\017\062\116\124\043\085\019\124\035\051\017\018\116\043\085\124\051\087\017\085\124\017\019\018\051\051\035\047\035\017\116\028\017\124\008\051\035\113\087\017\047\035\051\017\043\018\113\019\085\124\124\035\051\087\017\047\035\051\017\019\124\008\045\116\035\051\017\035\124\035\044\043\113\018\039\062\008\010\028\035\043\085\045\116\035\051\017\035\043\017\116\028\017\058\035\124\085\035\113\017\019\018\116\113\017\051\035\017\073\113\008\091\035\113\017\116\028\017\044\032\035\062\085\028\017\124\018\113\051\045\116\035\017\028\035\044\035\051\051\008\085\113\035\038")
_9EL.AltText = ""
_9EL.Resources = {
	{
		Type = "JPG", 
		Filename = "Thunderbird_4.JPG", 
		Directives = {}
	}
}
_I_a1 = Wherigo.ZMedia(_rcZu)
_I_a1.Id = "a8514d29-aa5d-41ad-b419-23c2b84fe927"
_I_a1.Name = _hbQ("\031\032\116\028\047\035\113\058\085\113\047\017\030")
_I_a1.Description = _hbQ("\077\019\035\044\085\073\085\044\008\043\085\018\028\051\017\047\035\017\031\032\116\028\047\035\113\058\085\113\047\017\030\086\108\115\003\065\037\018\028\010\116\035\116\113\086\017\020\122\122\017\062\035\043\113\035\051\106\108\115\003\065\037\008\113\010\035\116\113\086\017\074\028\058\051\019\106\075\004\017\062\035\043\113\035\051\106\108\115\003\065\101\008\116\043\035\116\113\086\017\074\028\058\051\019\106\105\107\017\062\035\043\113\035\051\106\108\115\003\065\060\124\043\085\043\116\047\035\017\010\035\018\051\043\008\043\085\018\028\028\008\085\113\035\086\017\074\028\058\051\019\106\107\102\087\004\004\004\017\110\062\017\008\116\017\047\035\051\051\116\051\017\047\035\017\124\089\018\044\035\008\028\017\100\008\044\085\073\085\045\116\035\038\108\115\003\065\031\032\116\028\047\035\113\058\085\113\047\017\030\017\035\051\043\017\044\018\062\019\124\035\043\035\062\035\028\043\017\035\045\116\085\019\035\017\019\018\116\113\017\035\043\113\035\017\018\019\035\113\035\017\019\008\113\017\116\028\035\017\051\035\116\124\035\017\019\035\113\051\018\028\028\035\038\017\084\018\032\028\017\031\113\008\044\091\017\035\043\017\051\018\028\017\073\113\035\113\035\017\060\124\008\028\017\051\035\017\113\035\124\008\085\035\028\043\017\124\035\017\019\018\051\043\035\017\051\116\113\017\116\028\035\017\058\008\051\035\017\062\035\028\051\116\035\124\124\035\038")
_I_a1.AltText = ""
_I_a1.Resources = {
	{
		Type = "JPG", 
		Filename = "Thunderbird_5.JPG", 
		Directives = {}
	}
}
_K9f = Wherigo.ZMedia(_rcZu)
_K9f.Id = "043c19a4-34cf-4b4d-b30a-a5b0c2a29734"
_K9f.Name = _hbQ("\097\035\019\008\113\043")
_K9f.Description = _hbQ("\097\035\019\008\113\043\017\047\035\017\124\008\017\019\113\035\062\085\035\113\035\017\093\018\028\035")
_K9f.AltText = ""
_K9f.Resources = {
	{
		Type = "jpg", 
		Filename = "Depart250.jpg", 
		Directives = {}
	}
}
_96r7 = Wherigo.ZMedia(_rcZu)
_96r7.Id = "3f0fd92f-97b0-4a3b-84d3-a5af373d3721"
_96r7.Name = _hbQ("\097\008\028\008\043\085\051\091")
_96r7.Description = _hbQ("\060\034\008\043\008\113\017\047\116\017\044\018\028\044\035\019\043\035\116\113\038")
_96r7.AltText = ""
_96r7.Resources = {
	{
		Type = "jpg", 
		Filename = "Danatisy.jpg", 
		Directives = {}
	}
}
_o3E = Wherigo.ZMedia(_rcZu)
_o3E.Id = "fb26eaf1-32bb-4344-ada6-7283e2443196"
_o3E.Name = _hbQ("\077\018\028\017\072\042\019\124\018\051\085\018\028")
_o3E.Description = _hbQ("\077\018\028\017\047\089\035\042\019\124\018\051\085\018\028")
_o3E.AltText = ""
_o3E.Resources = {
	{
		Type = "wav", 
		Filename = "bomb.wav", 
		Directives = {}
	}
}
_zHB = Wherigo.ZMedia(_rcZu)
_zHB.Id = "bd6f5cbd-760f-4fcf-a937-255124d201f8"
_zHB.Name = _hbQ("\072\042\019\124\018\051\085\018\028\017\121\062\008\010\035")
_zHB.Description = _hbQ("\121\062\008\010\035\017\047\035\017\124\089\035\042\019\124\018\051\085\018\028")
_zHB.AltText = ""
_zHB.Resources = {
	{
		Type = "JPG", 
		Filename = "Explosion.JPG", 
		Directives = {}
	}
}
_vLZ = Wherigo.ZMedia(_rcZu)
_vLZ.Id = "82badc17-d842-417c-9f9f-c134b22fbf51"
_vLZ.Name = _hbQ("\121\003\017\037\018\010\018")
_vLZ.Description = _hbQ("\037\018\010\018\017\121\003\017\122\030\004")
_vLZ.AltText = ""
_vLZ.Resources = {
	{
		Type = "jpg", 
		Filename = "IR_250.jpg", 
		Directives = {}
	}
}
_2dln_ = Wherigo.ZMedia(_rcZu)
_2dln_.Id = "9b2fdf92-3809-4b82-8143-ff218b35e565"
_2dln_.Name = _hbQ("\050\028\047\035\051\017\003\008\047\085\018")
_2dln_.Description = ""
_2dln_.AltText = ""
_2dln_.Resources = {
	{
		Type = "JPG", 
		Filename = "RadioWaves2.JPG", 
		Directives = {}
	}
}
_Fn7rW = Wherigo.ZMedia(_rcZu)
_Fn7rW.Id = "43d54fd3-4b9c-47fe-a236-b1390abd5f6f"
_Fn7rW.Name = _hbQ("\077\018\028\017\003\035\043\113\018\017\073\116\051\035\035")
_Fn7rW.Description = _hbQ("\077\018\028\017\047\035\017\113\035\043\113\018\039\073\116\051\035\035\038")
_Fn7rW.AltText = ""
_Fn7rW.Resources = {
	{
		Type = "wav", 
		Filename = "fusee.wav", 
		Directives = {}
	}
}
_15mH = Wherigo.ZMedia(_rcZu)
_15mH.Id = "ea537720-2ec1-4113-a3d0-82e992843eb6"
_15mH.Name = _hbQ("\012\085\113\035\073\124\091")
_15mH.Description = _hbQ("\012\085\113\035\073\124\091\017\035\051\043\017\116\028\017\034\035\032\085\044\116\124\035\017\113\035\051\085\051\043\008\028\043\017\008\116\042\017\073\124\008\062\062\035\051\017\035\043\017\085\124\017\035\051\043\017\116\043\085\124\085\051\035\017\019\018\116\113\017\035\043\035\085\028\047\113\035\017\124\035\051\017\085\028\044\035\028\047\085\035\051\017\085\062\019\018\113\043\008\028\043\051\017\035\043\017\035\042\035\044\116\043\035\113\017\047\035\051\017\047\035\062\018\124\085\043\085\018\028\051\038\017\121\124\017\035\051\043\017\043\113\008\028\051\019\018\113\043\035\017\047\008\028\051\017\124\035\017\029\008\085\051\051\018\028\017\107\017\047\035\017\031\032\116\028\047\035\113\058\085\113\047\017\122\038")
_15mH.AltText = ""
_15mH.Resources = {
	{
		Type = "JPG", 
		Filename = "Firefly.JPG", 
		Directives = {}
	}
}
_pcB = Wherigo.ZMedia(_rcZu)
_pcB.Id = "c20c89fb-89e3-423f-a2f5-7a900d28b24b"
_pcB.Name = _hbQ("\100\050\097\017\107")
_pcB.Description = _hbQ("\029\008\085\051\051\018\028\017\028\116\062\035\113\018\017\107\017\044\018\028\043\035\028\008\028\043\017\124\035\017\012\085\113\035\073\124\091\038")
_pcB.AltText = ""
_pcB.Resources = {
	{
		Type = "JPG", 
		Filename = "POD_3.JPG", 
		Directives = {}
	}
}
_JjYI = Wherigo.ZMedia(_rcZu)
_JjYI.Id = "6e979979-d248-4e88-b8b0-13989910192b"
_JjYI.Name = _hbQ("\031\032\116\028\047\035\113\058\085\113\047\017\122\017\037\008\028\047\085\028\010")
_JjYI.Description = _hbQ("\031\032\116\028\047\035\113\058\085\113\047\017\122\017\035\028\017\008\043\043\035\113\113\085\051\051\008\010\035\038")
_JjYI.AltText = ""
_JjYI.Resources = {
	{
		Type = "jpg", 
		Filename = "Thunderbird_2_Ldng.jpg", 
		Directives = {}
	}
}
_eddAO = Wherigo.ZMedia(_rcZu)
_eddAO.Id = "75bce4c9-a27c-4147-8432-be3806f97aba"
_eddAO.Name = _hbQ("\115\113\008\085\028\051")
_eddAO.Description = _hbQ("\115\113\008\085\028\051\017\035\051\043\017\124\089\085\028\010\035\028\085\035\116\113\017\043\018\116\043\035\017\044\008\043\035\010\018\113\085\035\017\019\018\116\113\017\113\035\028\047\113\035\017\043\018\116\051\017\124\035\051\017\008\019\019\008\113\035\085\124\051\017\035\043\017\008\044\044\035\051\051\018\085\113\035\051\017\116\043\085\124\035\051\017\008\017\124\089\018\113\010\008\028\085\051\008\043\085\018\028\038")
_eddAO.AltText = ""
_eddAO.Resources = {
	{
		Type = "JPG", 
		Filename = "Brains.JPG", 
		Directives = {}
	}
}
_apU6 = Wherigo.ZMedia(_rcZu)
_apU6.Id = "1c4cc011-918a-43db-bffc-fee12870468f"
_apU6.Name = _hbQ("\029\113\018\085\042\017\003\018\116\010\035")
_apU6.Description = ""
_apU6.AltText = ""
_apU6.Resources = {
	{
		Type = "JPG", 
		Filename = "CroixRouge.JPG", 
		Directives = {}
	}
}
_A9fXS = Wherigo.ZMedia(_rcZu)
_A9fXS.Id = "0275a861-eee1-408f-a908-a64d33159e07"
_A9fXS.Name = _hbQ("\123\035\018\044\008\044\032\035")
_A9fXS.Description = ""
_A9fXS.AltText = ""
_A9fXS.Resources = {
	{
		Type = "jpg", 
		Filename = "Cache.jpg", 
		Directives = {}
	}
}
_8f7s = Wherigo.ZMedia(_rcZu)
_8f7s.Id = "93c0a75b-0100-4ab0-bcc7-086d806b9c9c"
_8f7s.Name = _hbQ("\013\085\043\113\018\010\124\091\044\035\113\085\028\035")
_8f7s.Description = _hbQ("\037\089\035\042\019\124\018\051\085\113\017\028\035\044\035\051\051\008\085\113\035\017\008\017\019\113\018\047\116\085\113\035\017\124\089\035\042\019\124\018\051\085\018\028\017\034\018\116\124\116\035\017\019\018\116\113\017\062\008\085\043\113\085\051\035\113\017\124\089\085\028\044\035\028\047\085\035\038")
_8f7s.AltText = ""
_8f7s.Resources = {
	{
		Type = "JPG", 
		Filename = "Nitro.JPG", 
		Directives = {}
	}
}
_v54g = Wherigo.ZMedia(_rcZu)
_v54g.Id = "9dac69a2-55a2-4e01-a8b1-8f96c22341fa"
_v54g.Name = _hbQ("\060\124\018\091\051\085\116\051\017\100\008\113\110\035\113")
_v54g.Description = _hbQ("\060\124\018\091\051\085\116\051\017\100\008\113\110\035\113\017\047\085\043\017\037\008\017\012\018\116\085\028\035\017\086\108\115\003\065\031\113\116\008\028\047\017\113\035\019\035\028\043\085\087\017\044\032\008\116\073\073\035\116\113\017\047\035\017\124\008\017\003\018\124\124\051\039\003\018\091\044\035\017\113\018\051\035\017\008\017\051\085\042\017\113\018\116\035\051\017\047\035\017\037\008\047\091\017\100\035\028\035\124\018\019\035\017\012\060\115\017\020\038")
_v54g.AltText = ""
_v54g.Resources = {
	{
		Type = "JPG", 
		Filename = "Parker.JPG", 
		Directives = {}
	}
}
_xGr5 = Wherigo.ZMedia(_rcZu)
_xGr5.Id = "18c9f24f-bae2-4f3c-b036-32d6d01d0ab9"
_xGr5.Name = _hbQ("\029\018\047\035\017\006\028\124\018\044\110")
_xGr5.Description = ""
_xGr5.AltText = ""
_xGr5.Resources = {
	{
		Type = "JPG", 
		Filename = "Unlock.JPG", 
		Directives = {}
	}
}
_QlWB = Wherigo.ZMedia(_rcZu)
_QlWB.Id = "ed3cba79-bbba-4b5d-8da6-178ee6af342d"
_QlWB.Name = _hbQ("\077\018\028\017\100\018\116\035\043\043\035\100\018\116\035\043\043\035")
_QlWB.Description = ""
_QlWB.AltText = ""
_QlWB.Resources = {
	{
		Type = "wav", 
		Filename = "PouetPouet.wav", 
		Directives = {}
	}, 
	{
		Type = "fdl", 
		Filename = "Puette.fdl", 
		Directives = {}
	}
}
_FOw = Wherigo.ZMedia(_rcZu)
_FOw.Id = "5dd01bf6-5704-4f23-94fb-1dad18c76db5"
_FOw.Name = _hbQ("\077\018\028\017\031\008\047\008\062")
_FOw.Description = ""
_FOw.AltText = ""
_FOw.Resources = {
	{
		Type = "wav", 
		Filename = "TaDa.wav", 
		Directives = {}
	}, 
	{
		Type = "fdl", 
		Filename = "Hourra.fdl", 
		Directives = {}
	}
}
_LjrO = Wherigo.ZMedia(_rcZu)
_LjrO.Id = "629d5d3c-ae79-4393-a91f-e3f796c821a2"
_LjrO.Name = _hbQ("\098\116\035\051\043\085\018\028")
_LjrO.Description = _hbQ("\121\062\008\010\035\017\019\018\116\113\017\019\018\051\035\113\017\116\028\035\017\045\116\035\051\043\085\018\028\038")
_LjrO.AltText = ""
_LjrO.Resources = {
	{
		Type = "jpg", 
		Filename = "pointd_interrogation.jpg", 
		Directives = {}
	}
}
_r8PPn = Wherigo.ZMedia(_rcZu)
_r8PPn.Id = "f0e02b8e-adff-4e61-82e2-b0b459920a83"
_r8PPn.Name = _hbQ("\115\018\028\028\035\017\113\035\019\018\028\051\035")
_r8PPn.Description = _hbQ("\121\062\008\010\035\017\019\018\116\113\017\116\028\035\017\058\018\028\028\035\017\113\035\019\018\028\051\035\038")
_r8PPn.AltText = ""
_r8PPn.Resources = {
	{
		Type = "jpg", 
		Filename = "GoodAnswer_250.jpg", 
		Directives = {}
	}
}
_SMG = Wherigo.ZMedia(_rcZu)
_SMG.Id = "731eafec-2137-4d58-ae1e-435bdab2d10c"
_SMG.Name = _hbQ("\127\008\116\034\008\085\051\035\017\113\035\019\018\028\051\035")
_SMG.Description = _hbQ("\121\062\008\010\035\017\124\018\051\045\116\035\017\124\008\017\113\035\019\018\028\051\035\017\035\051\043\017\062\008\116\034\008\085\051\035\038")
_SMG.AltText = ""
_SMG.Resources = {
	{
		Type = "jpg", 
		Filename = "WrongAnswer_250.jpg", 
		Directives = {}
	}
}
_TkIH = Wherigo.ZMedia(_rcZu)
_TkIH.Id = "8eb50912-c361-4ca5-993f-e0078055fb23"
_TkIH.Name = _hbQ("\060\058\113\085")
_TkIH.Description = _hbQ("\072\028\047\113\018\085\043\017\019\018\116\113\017\051\089\008\058\113\085\043\035\113\017\047\035\051\017\035\042\019\124\018\051\085\018\028\051\038")
_TkIH.AltText = ""
_TkIH.Resources = {
	{
		Type = "JPG", 
		Filename = "Abri.JPG", 
		Directives = {}
	}
}
_NUCaG = Wherigo.ZMedia(_rcZu)
_NUCaG.Id = "2b6d7d3a-39e7-4268-ae10-81982efb1aed"
_NUCaG.Name = _hbQ("\084\018\116\035\116\113")
_NUCaG.Description = _hbQ("\079\018\116\051\087\017\124\035\017\103\018\116\035\116\113\017\047\035\017\044\035\017\103\035\116\017\070\032\035\113\085\010\018\038")
_NUCaG.AltText = ""
_NUCaG.Resources = {
	{
		Type = "JPG", 
		Filename = "Joueur.JPG", 
		Directives = {}
	}
}
_XuwI2 = Wherigo.ZMedia(_rcZu)
_XuwI2.Id = "9bb7deec-1b80-43a0-92f3-ca014eb6afe7"
_XuwI2.Name = _hbQ("\031\115\020\056\121\044\018\028")
_XuwI2.Description = ""
_XuwI2.AltText = ""
_XuwI2.Resources = {
	{
		Type = "jpg", 
		Filename = "Thunderbird_1_Icon.jpg", 
		Directives = {}
	}
}
_UyS = Wherigo.ZMedia(_rcZu)
_UyS.Id = "3a0b88e1-251e-4904-a502-b7059c25b2ed"
_UyS.Name = _hbQ("\031\115\122\056\121\044\018\028")
_UyS.Description = ""
_UyS.AltText = ""
_UyS.Resources = {
	{
		Type = "jpg", 
		Filename = "Thunderbird_2_Icon.jpg", 
		Directives = {}
	}
}
_dqd1 = Wherigo.ZMedia(_rcZu)
_dqd1.Id = "66f196a7-bc10-4506-afe3-5883a96fe2f5"
_dqd1.Name = _hbQ("\123\035\018\044\008\044\032\035\056\121\044\018\028")
_dqd1.Description = ""
_dqd1.AltText = ""
_dqd1.Resources = {
	{
		Type = "jpg", 
		Filename = "Cache_Icon.jpg", 
		Directives = {}
	}
}
_T2eR = Wherigo.ZMedia(_rcZu)
_T2eR.Id = "4324292c-a960-4b98-bfea-cda29b0e66ba"
_T2eR.Name = _hbQ("\077\044\018\043\043\056\121\044\018\028")
_T2eR.Description = ""
_T2eR.AltText = ""
_T2eR.Resources = {
	{
		Type = "jpg", 
		Filename = "TB1_Scott_Icon.jpg", 
		Directives = {}
	}
}
_ePnS_ = Wherigo.ZMedia(_rcZu)
_ePnS_.Id = "93f478b4-daea-4e88-88f5-0cd75a82a05d"
_ePnS_.Name = _hbQ("\079\085\113\010\085\124\056\121\044\018\028")
_ePnS_.Description = ""
_ePnS_.AltText = ""
_ePnS_.Resources = {
	{
		Type = "jpg", 
		Filename = "TB2_Virgil_Icon.jpg", 
		Directives = {}
	}
}
_gF73S = Wherigo.ZMedia(_rcZu)
_gF73S.Id = "b52f4cc5-91f7-4d87-a980-4f1839f8173f"
_gF73S.Name = _hbQ("\084\018\032\028\056\121\044\018\028")
_gF73S.Description = ""
_gF73S.AltText = ""
_gF73S.Resources = {
	{
		Type = "jpg", 
		Filename = "TB5_John_Icon.jpg", 
		Directives = {}
	}
}
_heE = Wherigo.ZMedia(_rcZu)
_heE.Id = "06330a85-e89e-4c81-97b0-d0b419033938"
_heE.Name = _hbQ("\097\035\019\008\113\043\056\121\044\018\028")
_heE.Description = ""
_heE.AltText = ""
_heE.Resources = {
	{
		Type = "jpg", 
		Filename = "Depart_Icon.jpg", 
		Directives = {}
	}
}
_shx5 = Wherigo.ZMedia(_rcZu)
_shx5.Id = "b9717a6e-709f-4f24-a4d2-4fc9e63b1bc8"
_shx5.Name = _hbQ("\013\085\043\113\018\056\121\044\018\028")
_shx5.Description = ""
_shx5.AltText = ""
_shx5.Resources = {
	{
		Type = "jpg", 
		Filename = "Nitro_Icon.jpg", 
		Directives = {}
	}
}
_nZlP5 = Wherigo.ZMedia(_rcZu)
_nZlP5.Id = "2f9a56a4-23ce-4a41-9d73-d1921d713b7e"
_nZlP5.Name = _hbQ("\029\124\035\073\056\121\044\018\028")
_nZlP5.Description = ""
_nZlP5.AltText = ""
_nZlP5.Resources = {
	{
		Type = "jpg", 
		Filename = "Unlock_Icon.jpg", 
		Directives = {}
	}
}
_Sp54 = Wherigo.ZMedia(_rcZu)
_Sp54.Id = "154b494d-3387-4382-9964-cc47dd1bee71"
_Sp54.Name = _hbQ("\029\113\018\085\042\003\018\116\010\035\056\121\044\018\028")
_Sp54.Description = ""
_Sp54.AltText = ""
_Sp54.Resources = {
	{
		Type = "jpg", 
		Filename = "CroixRouge_Icon.jpg", 
		Directives = {}
	}
}
_t2Rh = Wherigo.ZMedia(_rcZu)
_t2Rh.Id = "aabe25ba-2012-487e-92ad-ea002d43a5d7"
_t2Rh.Name = _hbQ("\031\032\116\028\047\035\113\058\085\113\047\051\056\121\044\018\028")
_t2Rh.Description = ""
_t2Rh.AltText = ""
_t2Rh.Resources = {
	{
		Type = "jpg", 
		Filename = "Thunderbirds_Icon.jpg", 
		Directives = {}
	}
}
_PJ4 = Wherigo.ZMedia(_rcZu)
_PJ4.Id = "f97ddbbb-418b-4860-ab85-e1d18263a1ed"
_PJ4.Name = _hbQ("\050\028\047\035\051\003\008\047\085\018\056\121\044\018\028")
_PJ4.Description = ""
_PJ4.AltText = ""
_PJ4.Resources = {
	{
		Type = "jpg", 
		Filename = "RadioWaves_Icon.jpg", 
		Directives = {}
	}
}
_oD1 = Wherigo.ZMedia(_rcZu)
_oD1.Id = "06db28e7-7de5-474c-b2cb-920cf98fd402"
_oD1.Name = _hbQ("\012\085\113\035\073\124\091\056\121\044\018\028")
_oD1.Description = ""
_oD1.AltText = ""
_oD1.Resources = {
	{
		Type = "jpg", 
		Filename = "Firefly_Icon.jpg", 
		Directives = {}
	}
}
_Wj_v = Wherigo.ZMedia(_rcZu)
_Wj_v.Id = "6c134066-19cd-45e8-b9df-0f1406e54869"
_Wj_v.Name = _hbQ("\060\058\113\085\056\121\044\018\028")
_Wj_v.Description = ""
_Wj_v.AltText = ""
_Wj_v.Resources = {
	{
		Type = "jpg", 
		Filename = "Abri_Icon.jpg", 
		Directives = {}
	}
}
_BURYS = Wherigo.ZMedia(_rcZu)
_BURYS.Id = "5bd7a539-92ca-4bc2-8b41-3bb5c5f1eac1"
_BURYS.Name = _hbQ("\115\113\008\085\028\051\056\121\044\018\028")
_BURYS.Description = ""
_BURYS.AltText = ""
_BURYS.Resources = {
	{
		Type = "jpg", 
		Filename = "Brains_Icon.jpg", 
		Directives = {}
	}
}
_2ccgD = Wherigo.ZMedia(_rcZu)
_2ccgD.Id = "04950081-6740-4919-bda6-a93b5a1d11e2"
_2ccgD.Name = _hbQ("\072\042\019\124\018\051\085\018\028\056\121\044\018\028")
_2ccgD.Description = ""
_2ccgD.AltText = ""
_2ccgD.Resources = {
	{
		Type = "jpg", 
		Filename = "Explosion_Icon.jpg", 
		Directives = {}
	}
}
Exclamation = Wherigo.ZMedia(_rcZu)
Exclamation.Id = "0eff4494-38b6-40a8-b4d8-974bc8172239"
Exclamation.Name = _hbQ("\072\042\044\124\008\062\008\043\085\018\028")
Exclamation.Description = ""
Exclamation.AltText = ""
Exclamation.Resources = {
	{
		Type = "jpg", 
		Filename = "Exclamation.jpg", 
		Directives = {}
	}
}
_qb0u = Wherigo.ZMedia(_rcZu)
_qb0u.Id = "70e6a6b8-3cb4-4b26-9c6d-ab2c40b05be0"
_qb0u.Name = _hbQ("\012\085\028\008\124\035\017\031\032\116\028\047\035\113\058\085\113\047\051\017\098\116\035\058\035\044")
_qb0u.Description = _hbQ("\121\062\008\010\035\017\104\077\019\018\085\124\035\113\104\017\047\035\017\124\008\017\073\085\028\008\124\035\038")
_qb0u.AltText = ""
_qb0u.Resources = {
	{
		Type = "JPG", 
		Filename = "FinaleThunderbirdsQC.JPG", 
		Directives = {}
	}
}
-- Cartridge Info --
_rcZu.Id="9d6b6da2-1bfb-48da-8dd9-543191e02302"
_rcZu.Name="Les Sentinelles de l'air (Thunderbirds)"
_rcZu.Description=[[Une serie televisee que certains se rappellent avec nostalgie. ]]
_rcZu.Visible=true
_rcZu.Activity="Fiction"
_rcZu.StartingLocationDescription=[[En tant que Joueur, vous serez appele a venir en aide aux victimes d'une explosion dans la region de Quebec (Histoire fictive). 
La cartouche debute sur le stationnement du Parc des Moulins a Charlesbourg.]]
_rcZu.StartingLocation = ZonePoint(46.8910428150327,-71.2999850942941,0)
_rcZu.Version="1.4"
_rcZu.Company=""
_rcZu.Author="Danatisy"
_rcZu.BuilderVersion="URWIGO 1.22.5798.37755"
_rcZu.CreateDate="10/29/2018 17:02:27"
_rcZu.PublishDate="1/1/0001 12:00:00 AM"
_rcZu.UpdateDate="04/29/2019 18:27:58"
_rcZu.LastPlayedDate="1/1/0001 12:00:00 AM"
_rcZu.TargetDevice="PocketPC"
_rcZu.TargetDeviceVersion="0"
_rcZu.StateId="1"
_rcZu.CountryId="2"
_rcZu.Complete=false
_rcZu.UseLogging=true

_rcZu.Media=_UJI

_rcZu.Icon=_ilg0K


-- Zones --
Depart = Wherigo.Zone(_rcZu)
Depart.Id = "09b5d8a9-cdac-43c8-a039-4708d13ba943"
Depart.Name = _hbQ("\004\020\039\097\035\019\008\113\043")
Depart.Description = _hbQ("\100\113\035\062\085\035\113\035\017\093\018\028\035\017\018\116\017\044\018\062\062\035\028\044\035\017\124\089\008\034\035\028\043\116\113\035\038\038\038")
Depart.Visible = false
Depart.Media = _K9f
Depart.Icon = _heE
Depart.Commands = {}
Depart.DistanceRange = Distance(-1, "feet")
Depart.ShowObjects = "OnEnter"
Depart.ProximityRange = Distance(60, "meters")
Depart.AllowSetPositionTo = false
Depart.Active = false
Depart.Points = {
	ZonePoint(46.8905387589524, -71.3005139441901, 0), 
	ZonePoint(46.8904426191839, -71.3006495190116, 0), 
	ZonePoint(46.8903703122496, -71.300551852563, 0), 
	ZonePoint(46.8904732105499, -71.3004195959139, 0)
}
Depart.OriginalPoint = ZonePoint(46.8904562252339, -71.3005337279197, 0)
Depart.DistanceRangeUOM = "Feet"
Depart.ProximityRangeUOM = "Meters"
Depart.OutOfRangeName = ""
Depart.InRangeName = ""
ZoneTB1 = Wherigo.Zone(_rcZu)
ZoneTB1.Id = "b2f8a411-1fd3-4828-9f78-19c313c85fc0"
ZoneTB1.Name = _hbQ("\004\107\039\060\043\043\035\113\113\085\051\051\008\010\035\017\031\115\020")
ZoneTB1.Description = _hbQ("\096\018\028\035\017\047\089\008\043\043\035\113\113\085\051\008\010\035\017\047\035\017\031\032\116\028\047\035\113\058\085\113\047\017\020\038")
ZoneTB1.Visible = false
ZoneTB1.Media = _DrWx0
ZoneTB1.Icon = _XuwI2
ZoneTB1.Commands = {}
ZoneTB1.DistanceRange = Distance(-1, "feet")
ZoneTB1.ShowObjects = "OnEnter"
ZoneTB1.ProximityRange = Distance(60, "meters")
ZoneTB1.AllowSetPositionTo = false
ZoneTB1.Active = false
ZoneTB1.Points = {
	ZonePoint(46.8897670044951, -71.299020008841, 0), 
	ZonePoint(46.8898605711653, -71.2986950668543, 0), 
	ZonePoint(46.8896937059724, -71.2986047245239, 0), 
	ZonePoint(46.8895878956274, -71.2989027901466, 0)
}
ZoneTB1.OriginalPoint = ZonePoint(46.8897272943151, -71.2988056475915, 0)
ZoneTB1.DistanceRangeUOM = "Feet"
ZoneTB1.ProximityRangeUOM = "Meters"
ZoneTB1.OutOfRangeName = ""
ZoneTB1.InRangeName = ""
AireComm = Wherigo.Zone(_rcZu)
AireComm.Id = "faea0cf5-8cc9-4282-9364-82a2fa97eb1e"
AireComm.Name = _hbQ("\004\122\039\060\085\113\035\017\047\035\017\044\018\062\062\116\028\085\044\008\043\085\018\028\051")
AireComm.Description = _hbQ("\060\085\113\035\017\047\035\017\044\018\062\062\116\028\085\044\008\043\085\018\028\051\038\038\038")
AireComm.Visible = false
AireComm.Media = _2dln_
AireComm.Icon = _PJ4
AireComm.Commands = {}
AireComm.DistanceRange = Distance(-1, "feet")
AireComm.ShowObjects = "OnEnter"
AireComm.ProximityRange = Distance(60, "meters")
AireComm.AllowSetPositionTo = false
AireComm.Active = false
AireComm.Points = {
	ZonePoint(46.8905623976943, -71.3005119094724, 0), 
	ZonePoint(46.8904759915822, -71.3003687279718, 0), 
	ZonePoint(46.8905524699168, -71.3003259989006, 0), 
	ZonePoint(46.8906359007028, -71.3004541861144, 0)
}
AireComm.OriginalPoint = ZonePoint(46.890556689974, -71.3004152056148, 0)
AireComm.DistanceRangeUOM = "Feet"
AireComm.ProximityRangeUOM = "Meters"
AireComm.OutOfRangeName = ""
AireComm.InRangeName = ""
ZoneTB2 = Wherigo.Zone(_rcZu)
ZoneTB2.Id = "5aa44da4-68ef-41ec-a358-4e0ce8248722"
ZoneTB2.Name = _hbQ("\004\063\039\060\043\043\035\113\113\085\051\051\008\010\035\017\031\115\122")
ZoneTB2.Description = _hbQ("\096\018\028\035\017\047\089\008\043\043\035\113\113\085\051\051\008\010\035\017\047\035\017\031\032\116\028\047\035\113\058\085\113\047\017\122\038")
ZoneTB2.Visible = false
ZoneTB2.Media = _jM5n
ZoneTB2.Icon = _UyS
ZoneTB2.Commands = {}
ZoneTB2.DistanceRange = Distance(-1, "feet")
ZoneTB2.ShowObjects = "OnEnter"
ZoneTB2.ProximityRange = Distance(60, "meters")
ZoneTB2.AllowSetPositionTo = false
ZoneTB2.Active = false
ZoneTB2.Points = {
	ZonePoint(46.8893246833223, -71.2989587916822, 0), 
	ZonePoint(46.8894561937146, -71.2986123834044, 0), 
	ZonePoint(46.8893155887789, -71.2985182622972, 0), 
	ZonePoint(46.8891866030789, -71.2988713445364, 0)
}
ZoneTB2.OriginalPoint = ZonePoint(46.8893207672237, -71.2987401954801, 0)
ZoneTB2.DistanceRangeUOM = "Feet"
ZoneTB2.ProximityRangeUOM = "Meters"
ZoneTB2.OutOfRangeName = ""
ZoneTB2.InRangeName = ""
Firefly = Wherigo.Zone(_rcZu)
Firefly.Id = "070ef0cc-4b48-41cb-b8df-68e2408623e4"
Firefly.Name = _hbQ("\004\030\039\012\085\113\035\073\124\091")
Firefly.Description = _hbQ("\060\085\113\035\017\047\035\017\073\035\116\017\045\116\035\017\012\085\113\035\073\124\091\017\047\018\085\043\017\062\008\085\043\113\085\051\035\113\038")
Firefly.Visible = false
Firefly.Media = _15mH
Firefly.Icon = _oD1
Firefly.Commands = {}
Firefly.DistanceRange = Distance(-1, "feet")
Firefly.ShowObjects = "OnEnter"
Firefly.ProximityRange = Distance(60, "meters")
Firefly.AllowSetPositionTo = false
Firefly.Active = false
Firefly.Points = {
	ZonePoint(46.8891659732288, -71.2996193096722, 0), 
	ZonePoint(46.8893772205366, -71.299612389033, 0), 
	ZonePoint(46.8893868044339, -71.2994300814386, 0), 
	ZonePoint(46.889156790427, -71.2994254068849, 0)
}
Firefly.OriginalPoint = ZonePoint(46.8892716971566, -71.2995217967572, 0)
Firefly.DistanceRangeUOM = "Feet"
Firefly.ProximityRangeUOM = "Meters"
Firefly.OutOfRangeName = ""
Firefly.InRangeName = ""
ZVictimes = Wherigo.Zone(_rcZu)
ZVictimes.Id = "0bd30b46-5958-47d6-9619-c7f938e1a557"
ZVictimes.Name = _hbQ("\004\078\039\096\018\028\035\017\047\035\051\017\034\085\044\043\085\062\035\051")
ZVictimes.Description = _hbQ("\096\018\028\035\017\018\116\017\051\035\017\043\113\018\116\034\035\028\043\017\124\035\051\017\019\113\035\051\116\062\035\035\051\017\034\085\044\043\085\062\035\051\038")
ZVictimes.Visible = false
ZVictimes.Media = _apU6
ZVictimes.Icon = _Sp54
ZVictimes.Commands = {}
ZVictimes.DistanceRange = Distance(-1, "feet")
ZVictimes.ShowObjects = "OnEnter"
ZVictimes.ProximityRange = Distance(60, "meters")
ZVictimes.AllowSetPositionTo = false
ZVictimes.Active = false
ZVictimes.Points = {
	ZonePoint(46.8882336045097, -71.2996678895815, 0), 
	ZonePoint(46.8880514315785, -71.2994534542072, 0), 
	ZonePoint(46.8882175563281, -71.2992057028609, 0), 
	ZonePoint(46.8884028487111, -71.2994020341164, 0)
}
ZVictimes.OriginalPoint = ZonePoint(46.8882263602819, -71.2994322701915, 0)
ZVictimes.DistanceRangeUOM = "Feet"
ZVictimes.ProximityRangeUOM = "Meters"
ZVictimes.OutOfRangeName = ""
ZVictimes.InRangeName = ""
_qywFO = Wherigo.Zone(_rcZu)
_qywFO.Id = "eab68234-053c-4572-a72a-b756f8978db8"
_qywFO.Name = _hbQ("\020\004\031\039\096\018\028\035\017\047\035\017\123\035\018\044\008\044\032\035")
_qywFO.Description = _hbQ("\037\035\017\124\085\035\116\017\019\032\091\051\085\045\116\035\017\018\116\017\051\035\017\043\113\018\116\034\035\017\124\008\017\010\035\018\044\008\044\032\035\038")
_qywFO.Visible = false
_qywFO.Media = _A9fXS
_qywFO.Icon = _dqd1
_qywFO.Commands = {}
_qywFO.DistanceRange = Distance(-1, "feet")
_qywFO.ShowObjects = "OnEnter"
_qywFO.ProximityRange = Distance(60, "meters")
_qywFO.AllowSetPositionTo = false
_qywFO.Active = false
_qywFO.Points = {
	ZonePoint(46.8891586629391, -71.3001258210074, 0), 
	ZonePoint(46.8891965677962, -71.3000626492762, 0), 
	ZonePoint(46.8891567323708, -71.3000103688858, 0), 
	ZonePoint(46.889114975856, -71.3000815254929, 0)
}
_qywFO.OriginalPoint = ZonePoint(46.8891567347405, -71.3000700911656, 0)
_qywFO.DistanceRangeUOM = "Feet"
_qywFO.ProximityRangeUOM = "Meters"
_qywFO.OutOfRangeName = ""
_qywFO.InRangeName = ""
TB2 = Wherigo.Zone(_rcZu)
TB2.Id = "5ac7b9f2-1e18-4137-bc9a-c0d801113a9e"
TB2.Name = _hbQ("\004\105\039\031\032\116\028\047\035\113\058\085\113\047\017\122")
TB2.Description = _hbQ("\031\032\116\028\047\035\113\058\085\113\047\017\122")
TB2.Visible = false
TB2.Media = _jM5n
TB2.Icon = _UyS
TB2.Commands = {}
TB2.DistanceRange = Distance(-1, "feet")
TB2.ShowObjects = "OnEnter"
TB2.ProximityRange = Distance(60, "meters")
TB2.AllowSetPositionTo = false
TB2.Active = false
TB2.Points = {
	ZonePoint(46.888721669408, -71.3003485599795, 0), 
	ZonePoint(46.8885561936474, -71.2996310872478, 0), 
	ZonePoint(46.888757458211, -71.2997058801071, 0), 
	ZonePoint(46.8888309355619, -71.2999910278829, 0)
}
TB2.OriginalPoint = ZonePoint(46.8887165642071, -71.2999191388043, 0)
TB2.DistanceRangeUOM = "Feet"
TB2.ProximityRangeUOM = "Meters"
TB2.OutOfRangeName = ""
TB2.InRangeName = ""
ZFinale = Wherigo.Zone(_rcZu)
ZFinale.Id = "f38ee3ff-6096-40cd-9718-e85902841297"
ZFinale.Name = _hbQ("\004\075\039\096\018\028\035\017\012\085\028\008\124\035")
ZFinale.Description = _hbQ("\096\018\028\035\017\047\035\017\043\113\008\028\051\085\043\085\018\028\017\035\028\043\113\035\017\124\089\008\034\035\028\043\116\113\035\017\035\043\017\124\008\017\047\035\044\018\116\034\035\113\043\035\017\047\089\116\028\035\017\010\035\018\044\008\044\032\035\038")
ZFinale.Visible = false
ZFinale.Media = _UJI
ZFinale.Icon = _t2Rh
ZFinale.Commands = {}
ZFinale.DistanceRange = Distance(-1, "feet")
ZFinale.ShowObjects = "OnEnter"
ZFinale.ProximityRange = Distance(60, "meters")
ZFinale.AllowSetPositionTo = false
ZFinale.Active = false
ZFinale.Points = {
	ZonePoint(46.8889508242207, -71.2995641110072, 0), 
	ZonePoint(46.8890027347192, -71.2997420971852, 0), 
	ZonePoint(46.8891387257185, -71.2996292378633, 0), 
	ZonePoint(46.8891201762271, -71.2994348780816, 0)
}
ZFinale.OriginalPoint = ZonePoint(46.8890531152214, -71.2995925810343, 0)
ZFinale.DistanceRangeUOM = "Feet"
ZFinale.ProximityRangeUOM = "Meters"
ZFinale.OutOfRangeName = ""
ZFinale.InRangeName = ""
ZAbri = Wherigo.Zone(_rcZu)
ZAbri.Id = "4c87ad96-c849-4309-ad4c-a62aadad93bd"
ZAbri.Name = _hbQ("\004\102\039\096\018\028\035\017\060\058\113\085\043\035\035")
ZAbri.Description = _hbQ("\060\058\113\085\017\047\035\017\019\113\018\043\035\044\043\085\018\028\038")
ZAbri.Visible = false
ZAbri.Media = _TkIH
ZAbri.Icon = _Wj_v
ZAbri.Commands = {}
ZAbri.DistanceRange = Distance(-1, "feet")
ZAbri.ShowObjects = "OnEnter"
ZAbri.ProximityRange = Distance(60, "meters")
ZAbri.AllowSetPositionTo = false
ZAbri.Active = false
ZAbri.Points = {
	ZonePoint(46.8884494283249, -71.2984252071408, 0), 
	ZonePoint(46.8885434149195, -71.2982100229223, 0), 
	ZonePoint(46.8886584233614, -71.2981118572946, 0), 
	ZonePoint(46.8888149622333, -71.2982193720297, 0), 
	ZonePoint(46.8887734315567, -71.2984577742686, 0), 
	ZonePoint(46.8886105032072, -71.2985980108796, 0)
}
ZAbri.OriginalPoint = ZonePoint(46.8886416939338, -71.2983370407559, 0)
ZAbri.DistanceRangeUOM = "Feet"
ZAbri.ProximityRangeUOM = "Meters"
ZAbri.OutOfRangeName = ""
ZAbri.InRangeName = ""
_ERUV = Wherigo.Zone(_rcZu)
_ERUV.Id = "4ac13fc2-328d-43b6-a3a8-6371a78b32b1"
_ERUV.Name = _hbQ("\020\004\012\039\096\018\028\035\017\047\035\017\123\035\018\044\008\044\032\035")
_ERUV.Description = _hbQ("\072\028\047\018\085\043\017\018\116\017\035\051\043\017\047\085\051\051\085\062\116\124\035\035\017\124\008\017\123\035\018\044\008\044\032\035\038")
_ERUV.Visible = false
_ERUV.Media = _A9fXS
_ERUV.Icon = _dqd1
_ERUV.Commands = {}
_ERUV.DistanceRange = Distance(-1, "feet")
_ERUV.ShowObjects = "OnEnter"
_ERUV.ProximityRange = Distance(60, "meters")
_ERUV.AllowSetPositionTo = false
_ERUV.Active = false
_ERUV.Points = {
	ZonePoint(46.8891833134064, -71.2989817776324, 0), 
	ZonePoint(46.8891086265466, -71.2989186104268, 0), 
	ZonePoint(46.8891746234075, -71.2987767248537, 0), 
	ZonePoint(46.8892561074447, -71.2988224265471, 0)
}
_ERUV.OriginalPoint = ZonePoint(46.8891806677013, -71.298874884865, 0)
_ERUV.DistanceRangeUOM = "Feet"
_ERUV.ProximityRangeUOM = "Meters"
_ERUV.OutOfRangeName = ""
_ERUV.InRangeName = ""

-- Characters --
Scott = Wherigo.ZCharacter(_rcZu)
Scott.Id = "0579bd25-01ae-443e-86a5-0962a02c1880"
Scott.Name = _hbQ("\077\044\018\043\043\017\031\113\008\044\091")
Scott.Description = _hbQ("\077\044\018\043\043\017\031\113\008\044\091\017\035\051\043\017\124\035\017\019\085\124\018\043\035\017\047\035\017\031\032\116\028\047\035\113\058\085\113\047\017\020\038")
Scott.Visible = true
Scott.Media = _3h4R
Scott.Icon = _T2eR
Scott.Commands = {}
Scott.ObjectLocation = Wherigo.INVALID_ZONEPOINT
Scott.Gender = "Male"
Scott.Type = "NPC"
Virgil = Wherigo.ZCharacter(_rcZu)
Virgil.Id = "6fc25342-15aa-4ab0-8a47-3cbbe67c1866"
Virgil.Name = _hbQ("\079\085\113\010\085\124\017\031\113\008\044\091")
Virgil.Description = _hbQ("\079\085\113\010\085\124\017\035\051\043\017\019\085\124\018\043\035\017\047\035\017\031\032\116\028\047\035\113\058\085\113\047\017\122\038")
Virgil.Visible = true
Virgil.Media = _JIJy
Virgil.Icon = _ePnS_
Virgil.Commands = {}
Virgil.ObjectLocation = Wherigo.INVALID_ZONEPOINT
Virgil.Gender = "Male"
Virgil.Type = "NPC"
John = Wherigo.ZCharacter(_rcZu)
John.Id = "7d3242a5-fd6b-4228-ae03-12d9c428bf37"
John.Name = _hbQ("\084\018\032\028\017\031\113\008\044\091")
John.Description = _hbQ("\084\018\032\028\017\031\113\008\044\091\017\035\051\043\017\008\051\043\113\018\028\008\116\043\035\017\047\008\028\051\017\031\032\116\028\047\035\113\058\085\113\047\017\030\038")
John.Visible = true
John.Media = _oxPVF
John.Icon = _gF73S
John.Commands = {}
John.ObjectLocation = Wherigo.INVALID_ZONEPOINT
John.Gender = "Male"
John.Type = "NPC"
Jeff = Wherigo.ZCharacter(_rcZu)
Jeff.Id = "5b58bef8-6d18-41c5-bacd-f45619f36e0c"
Jeff.Name = _hbQ("\084\035\073\073\017\031\113\008\044\091")
Jeff.Description = _hbQ("\084\035\073\073\017\031\113\008\044\091\017\035\051\043\017\124\035\017\019\035\113\035\017\047\035\017\124\008\017\073\008\062\085\124\124\035\017\035\043\017\044\018\062\062\008\028\047\035\017\124\008\017\058\008\051\035\038")
Jeff.Visible = true
Jeff.Media = _aJI
Jeff.Commands = {}
Jeff.ObjectLocation = Wherigo.INVALID_ZONEPOINT
Jeff.Gender = "Male"
Jeff.Type = "NPC"
LPenelope = Wherigo.ZCharacter(_rcZu)
LPenelope.Id = "1eaf8329-ce34-49a3-a70b-b52490584d38"
LPenelope.Name = _hbQ("\037\008\047\091\017\100\035\028\035\124\018\019\035")
LPenelope.Description = _hbQ("\037\008\047\091\017\100\035\028\035\124\018\019\035\017\035\051\043\017\116\028\035\017\008\062\085\035\017\047\035\017\124\008\017\073\008\062\085\124\124\035\017\031\113\008\044\091\017\035\043\017\043\018\116\103\018\116\113\051\017\019\113\035\043\035\017\008\017\047\018\028\028\035\113\017\047\116\017\051\116\019\019\018\113\043\017\008\017\124\089\018\113\010\008\028\085\051\008\043\085\018\028\038")
LPenelope.Visible = false
LPenelope.Media = _nRB2
LPenelope.Commands = {}
LPenelope.ObjectLocation = Wherigo.INVALID_ZONEPOINT
LPenelope.Gender = "Female"
LPenelope.Type = "NPC"
Brains = Wherigo.ZCharacter(_rcZu)
Brains.Id = "0dea02a7-dd72-410c-8bc6-0c7509ca2fdf"
Brains.Name = _hbQ("\115\113\008\085\028\051")
Brains.Description = _hbQ("\115\113\008\085\028\051\017\035\051\043\017\124\089\085\028\010\035\028\085\035\116\113\017\043\018\116\043\035\051\017\044\008\043\035\010\018\113\085\035\051\017\019\018\116\113\017\113\035\028\047\113\035\017\043\018\116\051\017\124\035\051\017\008\019\019\008\113\035\085\124\051\017\035\043\017\008\044\044\035\051\051\018\085\113\035\051\017\116\043\085\124\035\051\017\008\017\124\089\018\113\010\008\028\085\051\008\043\085\018\028\038")
Brains.Visible = true
Brains.Media = _eddAO
Brains.Icon = _BURYS
Brains.Commands = {}
Brains.ObjectLocation = Wherigo.INVALID_ZONEPOINT
Brains.Gender = "Male"
Brains.Type = "NPC"

-- Items --
Geocache = Wherigo.ZItem(_rcZu)
Geocache.Id = "b2f5cef7-9409-4c70-8e5a-67aa1fc43a6a"
Geocache.Name = _hbQ("\123\035\018\044\008\044\032\035")
Geocache.Description = _hbQ("\006\028\035\017\010\035\018\044\008\044\032\035\017\008\017\043\113\018\116\034\035\113\038\038\038")
Geocache.Visible = false
Geocache.Media = _A9fXS
Geocache.Icon = _dqd1
Geocache.Commands = {
	_G5VFx = Wherigo.ZCommand{
		Text = _hbQ("\029\008\044\032\035\017\043\113\018\116\034\035\035"), 
		CmdWith = false, 
		Enabled = false, 
		EmptyTargetListText = _hbQ("\013\018\043\032\085\028\010\017\008\034\008\085\124\008\058\124\035")
	}, 
	_CjR = Wherigo.ZCommand{
		Text = _hbQ("\029\008\044\032\035\017\085\028\043\113\018\116\034\008\058\124\035"), 
		CmdWith = false, 
		Enabled = false, 
		EmptyTargetListText = _hbQ("\013\018\043\032\085\028\010\017\008\034\008\085\124\008\058\124\035")
	}, 
	_j1re = Wherigo.ZCommand{
		Text = _hbQ("\060\058\008\028\047\018\028\028\035\113"), 
		CmdWith = false, 
		Enabled = false, 
		EmptyTargetListText = _hbQ("\013\018\043\032\085\028\010\017\008\034\008\085\124\008\058\124\035")
	}
}
Geocache.Commands._G5VFx.Custom = true
Geocache.Commands._G5VFx.Id = "66dd62e7-5a88-4d1b-bc75-0d01fcf76d8a"
Geocache.Commands._G5VFx.WorksWithAll = true
Geocache.Commands._CjR.Custom = true
Geocache.Commands._CjR.Id = "ca0ab7de-52c0-4efb-80e9-e451c908c3d7"
Geocache.Commands._CjR.WorksWithAll = true
Geocache.Commands._j1re.Custom = true
Geocache.Commands._j1re.Id = "1089ca16-9e20-40ff-9b06-e3bc9ed8372a"
Geocache.Commands._j1re.WorksWithAll = true
Geocache.ObjectLocation = Wherigo.INVALID_ZONEPOINT
Geocache.Locked = false
Geocache.Opened = false
PatNitro = Wherigo.ZItem(_rcZu)
PatNitro.Id = "f1634542-81e5-4f48-aac6-e80c4c8c60fd"
PatNitro.Name = _hbQ("\100\008\043\035\017\047\035\017\013\085\043\113\018\010\124\091\044\035\113\085\028\035")
PatNitro.Description = _hbQ("\037\089\035\042\019\124\018\051\085\073\017\028\035\044\035\051\051\008\085\113\035\017\019\018\116\113\017\019\113\018\034\018\045\116\035\113\017\116\028\035\017\035\042\019\124\018\051\085\018\028\017\008\073\085\028\017\047\035\017\062\008\043\113\085\051\035\113\017\124\089\085\028\044\035\028\047\085\035\038\017\079\018\116\051\017\047\035\034\113\035\093\017\124\035\017\019\113\035\028\047\113\035\017\035\043\017\124\089\085\028\051\043\008\124\124\035\113\038")
PatNitro.Visible = false
PatNitro.Media = _8f7s
PatNitro.Icon = _shx5
PatNitro.Commands = {
	_CAY0 = Wherigo.ZCommand{
		Text = _hbQ("\100\113\035\028\047\113\035"), 
		CmdWith = false, 
		Enabled = false, 
		EmptyTargetListText = _hbQ("\029\018\062\062\008\028\047\035\017\019\018\116\113\017\062\035\043\043\113\035\017\035\028\017\019\124\008\044\035\017\124\089\035\042\019\124\018\051\085\073\038")
	}, 
	_3vY4 = Wherigo.ZCommand{
		Text = _hbQ("\121\028\051\043\008\124\124\035\113"), 
		CmdWith = false, 
		Enabled = false, 
		EmptyTargetListText = _hbQ("\013\018\043\032\085\028\010\017\008\034\008\085\124\008\058\124\035")
	}
}
PatNitro.Commands._CAY0.Custom = true
PatNitro.Commands._CAY0.Id = "97439251-9398-4fa9-bae7-b31dc85af0d8"
PatNitro.Commands._CAY0.WorksWithAll = true
PatNitro.Commands._3vY4.Custom = true
PatNitro.Commands._3vY4.Id = "5109190b-fc19-474d-ae61-a074d9bba1c1"
PatNitro.Commands._3vY4.WorksWithAll = true
PatNitro.ObjectLocation = Wherigo.INVALID_ZONEPOINT
PatNitro.Locked = false
PatNitro.Opened = false
_0EYl = Wherigo.ZItem(_rcZu)
_0EYl.Id = "8314029f-1ae7-4e4d-b1b3-771ed2122d92"
_0EYl.Name = _hbQ("\029\124\035\073\017\047\035\017\047\035\058\124\018\045\116\008\010\035")
_0EYl.Description = _hbQ("\079\018\043\113\035\017\044\018\047\035\017\047\035\017\047\035\058\124\018\045\116\008\010\035\086\108\115\003\065")
_0EYl.Visible = false
_0EYl.Media = _xGr5
_0EYl.Icon = _nZlP5
_0EYl.Commands = {}
_0EYl.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_0EYl.Locked = false
_0EYl.Opened = false
FausseCache = Wherigo.ZItem(_rcZu)
FausseCache.Id = "9f227d97-eb17-4066-b630-b22bc6ab9eb2"
FausseCache.Name = _hbQ("\123\035\018\044\008\044\032\035\017\095\072\127\033")
FausseCache.Description = _hbQ("\006\028\035\017\010\035\018\044\008\044\032\035\017\008\017\043\113\018\116\034\035\113\038\038\038")
FausseCache.Visible = false
FausseCache.Media = _A9fXS
FausseCache.Icon = _dqd1
FausseCache.Commands = {
	_g9g = Wherigo.ZCommand{
		Text = _hbQ("\031\113\018\116\034\035\035"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _hbQ("\013\018\043\032\085\028\010\017\008\034\008\085\124\008\058\124\035")
	}, 
	_Gjw9b = Wherigo.ZCommand{
		Text = _hbQ("\121\028\043\113\018\116\034\008\058\124\035"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _hbQ("\013\018\043\032\085\028\010\017\008\034\008\085\124\008\058\124\035")
	}, 
	_J1N = Wherigo.ZCommand{
		Text = _hbQ("\060\058\008\028\047\018\028"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _hbQ("\013\018\043\032\085\028\010\017\008\034\008\085\124\008\058\124\035")
	}
}
FausseCache.Commands._g9g.Custom = true
FausseCache.Commands._g9g.Id = "966fe44b-a847-4fe1-88ed-dcdb879b37a5"
FausseCache.Commands._g9g.WorksWithAll = true
FausseCache.Commands._Gjw9b.Custom = true
FausseCache.Commands._Gjw9b.Id = "d83fd633-a973-4ba2-8c1c-67f9c46277bc"
FausseCache.Commands._Gjw9b.WorksWithAll = true
FausseCache.Commands._J1N.Custom = true
FausseCache.Commands._J1N.Id = "4313e8ce-c850-4883-b579-46aba3e4c57c"
FausseCache.Commands._J1N.WorksWithAll = true
FausseCache.ObjectLocation = Wherigo.INVALID_ZONEPOINT
FausseCache.Locked = false
FausseCache.Opened = false

-- Tasks --
_hIfB = Wherigo.ZTask(_rcZu)
_hIfB.Id = "64938e49-0231-4218-9885-6c492a2e4a8e"
_hIfB.Name = _hbQ("\060\019\019\035\124\035\113\017\124\008\017\077\035\044\116\113\085\043\035\017\121\028\043\035\113\028\008\043\085\018\028\008\124\035")
_hIfB.Description = _hbQ("\031\008\044\032\035\017\044\018\062\019\124\035\043\035\035\017\045\116\008\028\047\017\124\008\017\077\121\017\035\051\043\017\008\019\019\035\124\035\035\038")
_hIfB.Visible = true
_hIfB.Media = _vLZ
_hIfB.Icon = _ilg0K
_hIfB.Active = true
_hIfB.Complete = false
_hIfB.CorrectState = "None"
_ge5 = Wherigo.ZTask(_rcZu)
_ge5.Id = "4b3dc41d-00a9-48ac-8d35-11fe28aef3b6"
_ge5.Name = _hbQ("\100\018\113\043\035\113\017\008\051\051\085\051\043\008\028\044\035\017\008\116\042\017\034\085\044\043\085\062\035\051")
_ge5.Description = _hbQ("\079\018\116\051\017\047\035\034\113\035\093\017\019\018\113\043\035\113\017\008\051\051\085\051\043\008\028\044\035\017\008\116\042\017\034\085\044\043\085\062\035\051\017\008\034\035\044\017\124\035\051\017\062\035\062\058\113\035\051\017\047\035\017\124\008\017\077\035\044\116\113\085\043\035\017\121\028\043\035\113\028\008\043\085\018\028\008\124\035\038")
_ge5.Visible = true
_ge5.Media = _apU6
_ge5.Icon = _Sp54
_ge5.Active = true
_ge5.Complete = false
_ge5.CorrectState = "None"
_thlf3 = Wherigo.ZTask(_rcZu)
_thlf3.Id = "47d4b1cd-a37f-4cf2-a6a6-6fc2a9e72e57"
_thlf3.Name = _hbQ("\003\035\044\035\034\018\085\113\017\124\008\017\077\035\044\116\113\085\043\035\017\121\028\043\035\113\028\008\043\085\018\028\008\124\035\038")
_thlf3.Description = _hbQ("\121\124\017\073\008\116\043\017\035\043\113\035\017\019\113\035\051\035\028\043\017\124\018\113\051\017\047\035\051\017\008\043\043\035\113\113\085\051\051\008\010\035\051\017\047\035\051\017\008\019\019\008\113\035\085\124\051\017\047\035\017\124\008\017\077\035\044\116\113\085\043\035\017\121\028\043\035\113\028\008\043\085\018\028\008\124\035\038")
_thlf3.Visible = true
_thlf3.Media = _UJI
_thlf3.Icon = _t2Rh
_thlf3.Active = true
_thlf3.Complete = false
_thlf3.CorrectState = "None"
_yVP0D = Wherigo.ZTask(_rcZu)
_yVP0D.Id = "731f9f11-db2b-4ba9-b7a5-c59819a102e6"
_yVP0D.Name = _hbQ("\127\008\085\043\113\085\051\035\113\017\124\089\085\028\044\035\028\047\085\035")
_yVP0D.Description = _hbQ("\031\008\044\032\035\017\008\017\008\044\044\018\062\019\124\085\113\017\019\018\116\113\017\062\008\085\043\113\085\051\035\113\017\124\089\035\042\019\124\018\051\085\018\028\038")
_yVP0D.Visible = true
_yVP0D.Media = _zHB
_yVP0D.Icon = _2ccgD
_yVP0D.Active = true
_yVP0D.Complete = false
_yVP0D.CorrectState = "None"
_lUAJ = Wherigo.ZTask(_rcZu)
_lUAJ.Id = "865f68da-4fc6-4307-9e81-050bb9bbf7c9"
_lUAJ.Name = _hbQ("\031\113\018\116\034\035\113\017\124\008\017\123\035\018\044\008\044\032\035")
_lUAJ.Description = _hbQ("\079\018\116\051\017\047\035\034\035\093\017\043\113\018\116\034\035\113\017\124\008\017\010\035\018\044\008\044\032\035\017\035\043\017\051\085\010\028\035\113\017\124\035\017\044\008\113\028\035\043\017\047\035\017\034\085\051\085\043\035\038")
_lUAJ.Visible = true
_lUAJ.Media = _A9fXS
_lUAJ.Icon = _dqd1
_lUAJ.Active = true
_lUAJ.Complete = false
_lUAJ.CorrectState = "None"
_gCW9 = Wherigo.ZTask(_rcZu)
_gCW9.Id = "2ffcf015-c78c-4734-8579-55c31438991c"
_gCW9.Name = _hbQ("\121\028\051\043\008\124\124\035\113\017\124\008\017\013\085\043\113\018")
_gCW9.Description = _hbQ("\031\008\044\032\035\017\019\018\116\113\017\085\028\051\043\008\124\124\035\113\017\124\008\017\013\085\043\113\018\017\008\017\124\089\008\034\008\028\043\017\047\116\017\019\008\113\035\039\073\035\116\017\047\035\017\012\085\113\035\073\124\091\038")
_gCW9.Visible = true
_gCW9.Media = _8f7s
_gCW9.Icon = _shx5
_gCW9.Active = true
_gCW9.Complete = false
_gCW9.CorrectState = "None"
_bSvWd = Wherigo.ZTask(_rcZu)
_bSvWd.Id = "51516ac6-7a78-41df-9f36-006974c8ff5b"
_bSvWd.Name = _hbQ("\100\113\035\028\047\113\035\017\124\008\017\013\085\043\113\018")
_bSvWd.Description = _hbQ("\029\018\062\062\008\028\047\035\017\019\018\116\113\017\019\113\035\028\047\113\035\017\124\008\017\013\085\043\113\018\010\124\091\044\035\113\085\028\035\038")
_bSvWd.Visible = true
_bSvWd.Media = _8f7s
_bSvWd.Icon = _shx5
_bSvWd.Active = true
_bSvWd.Complete = false
_bSvWd.CorrectState = "None"

-- Cartridge Variables --
_dVejn = _hbQ("\078")
_XUv = _hbQ("\012\018\116\085\028\035")
Env_Platform_2 = ""
Env_Platform_1 = ""
_EdN = _hbQ("\097\035\019\008\113\043")
_53k = _hbQ("\077\044\018\043\043")
_7ZQ = _hbQ("\123\035\018\044\008\044\032\035")
_KaMhY = _hbQ("\056\032\121\073\115")
_gDUg = _hbQ("\056\012\077\030\030\116")
_08Q = _hbQ("\056\091\127\091")
_rcZu.ZVariables = {
	_dVejn = _hbQ("\078"), 
	_XUv = _hbQ("\012\018\116\085\028\035"), 
	Env_Platform_2 = "", 
	Env_Platform_1 = "", 
	_EdN = _hbQ("\097\035\019\008\113\043"), 
	_53k = _hbQ("\077\044\018\043\043"), 
	_7ZQ = _hbQ("\123\035\018\044\008\044\032\035"), 
	_KaMhY = _hbQ("\056\032\121\073\115"), 
	_gDUg = _hbQ("\056\012\077\030\030\116"), 
	_08Q = _hbQ("\056\091\127\091")
}

-- Timers --
_yMy = Wherigo.ZTimer(_rcZu)
_yMy.Id = "c6247fc2-a664-4f59-96af-ae9fa22b1706"
_yMy.Name = _hbQ("\029\032\018\113\018")
_yMy.Description = ""
_yMy.Visible = true
_yMy.Duration = 2
_yMy.Type = "Countdown"

-- Inputs --
_FS55u = Wherigo.ZInput(_rcZu)
_FS55u.Id = "79574b5f-3ed0-48cb-b272-748cb4445c97"
_FS55u.Name = _hbQ("\098\116\035\051\043\085\018\028")
_FS55u.Description = _hbQ("\098\116\035\051\043\085\018\028\017\008\017\113\035\019\018\028\047\113\035\038\038\038")
_FS55u.Visible = true
_FS55u.Media = _LjrO
_FS55u.Choices = {
	"La Belette", 
	"La Fripouille", 
	"La Fouine", 
	"Baxter"
}
_FS55u.InputType = "MultipleChoice"
_FS55u.Text = _hbQ("\098\116\035\124\017\008\116\043\113\035\017\028\018\062\017\047\018\028\028\035\039\043\039\018\028\017\008\017\060\124\018\091\051\085\116\051\017\100\008\113\110\035\113\087\017\124\035\017\044\032\008\116\073\073\035\116\113\017\047\035\017\100\035\028\035\124\018\019\035\014")

-- WorksWithList for object commands --

-- functions --
function _rcZu:OnStart()
	if (_G[_hbQ("\072\028\034")][_hbQ("\100\124\008\043\073\018\113\062")] == _hbQ("\070\085\028\107\122")) or (_G[_hbQ("\072\028\034")][_hbQ("\097\035\034\085\044\035\121\097")] == _hbQ("\097\035\051\110\043\018\019")) then
		for k, v in pairs(_G[_hbQ("\056\113\044\096\116")][_hbQ("\060\124\124\096\050\058\103\035\044\043\051")]) do
			v[_hbQ("\079\085\051\085\058\124\035")] = false
			v[_hbQ("\060\044\043\085\034\035")] = false
		end
		_Urwigo.MessageBox{
			Text = tostring(_hbQ("\100\018\116\113\017\113\035\028\047\113\035\017\103\116\051\043\085\044\035\017\008\017\043\018\116\051\017\035\043\017\008\017\043\018\116\043\035\051\087\017\044\035\043\043\035\017\044\008\113\043\018\116\044\032\035\017\070\032\035\113\085\010\018\017\028\035\017\019\035\116\043\017\035\043\113\035\017\103\018\116\035\035\017\008\116\043\113\035\062\035\028\043\017\045\116\035\017\051\116\113\017\124\035\017\043\035\113\113\008\085\028\038")), 
			Callback = function(action)
				if action ~= nil then
					_G[_hbQ("\070\032\035\113\085\010\018")][_hbQ("\029\018\062\062\008\028\047")](_hbQ("\077\008\034\035\029\124\018\051\035"))
				end
			end
		}
		return
	end
	_Urwigo.Dialog(false, {
		{
			Text = (_hbQ("\115\018\028\103\018\116\113\017")..Player.Name).._hbQ("\112\108\115\003\065\084\035\017\051\116\085\051\017\097\008\028\008\043\085\051\091\087\017\124\035\017\044\018\028\044\035\019\043\035\116\113\017\047\035\017\044\035\017\103\035\116\017\070\032\035\113\085\010\018\038\017\074\028\058\051\019\106\084\089\035\051\019\035\113\035\017\045\116\035\017\034\018\116\051\017\034\018\116\051\017\008\062\116\051\035\113\035\093\017\047\116\113\008\028\043\017\044\035\017\019\008\113\044\018\116\113\051\017\045\116\085\017\019\113\035\028\047\113\008\017\035\028\034\085\113\018\028\017\116\028\035\017\032\035\116\113\035\038\017\121\124\017\034\018\116\051\017\008\062\035\028\035\113\008\017\008\017\019\008\113\043\085\044\085\019\035\113\017\008\017\116\028\035\017\085\062\019\018\113\043\008\028\043\035\017\018\019\035\113\008\043\085\018\028\038\038\038"), 
			Media = _96r7
		}, 
		{
			Text = _hbQ("\072\028\017\122\004\102\030\087\017\084\035\073\073\017\031\113\008\044\091\087\017\008\028\044\085\035\028\017\008\051\043\113\018\028\008\116\043\035\017\047\035\034\035\028\116\017\113\085\044\032\085\051\051\085\062\035\017\035\043\017\008\010\035\017\047\035\017\020\004\075\017\008\028\051\087\017\035\051\043\017\008\017\124\008\017\043\035\043\035\017\047\089\116\028\035\017\062\091\051\043\035\113\085\035\116\051\035\017\018\113\010\008\028\085\051\008\043\085\018\028\087\017\008\019\019\035\124\035\035\017\124\008\017\077\035\044\116\113\085\043\035\017\121\028\043\035\113\028\008\043\085\018\028\008\124\035\017\095\121\028\043\035\113\028\008\043\085\018\028\008\124\017\003\035\051\044\116\035\033\017\047\018\028\043\017\124\008\017\062\085\051\051\085\018\028\017\035\051\043\017\047\089\085\028\043\035\113\034\035\028\085\113\017\051\116\113\017\124\035\051\017\051\085\043\035\051\017\047\035\017\051\085\028\085\051\043\113\035\051\017\062\008\103\035\116\113\051\087\017\018\116\017\047\008\028\051\017\124\035\051\017\044\008\051\017\047\089\035\042\043\113\035\062\035\017\116\113\010\035\028\044\035\087\017\062\008\085\051\017\051\035\116\124\035\062\035\028\043\017\051\085\017\047\035\051\017\034\085\035\051\017\032\116\062\008\085\028\035\051\017\051\018\028\043\017\035\028\017\103\035\116\038"), 
			Media = _aJI
		}, 
		{
			Text = _hbQ("\121\124\017\034\085\043\017\051\116\113\017\116\028\035\017\121\124\035\017\047\116\017\100\008\044\085\073\085\045\116\035\087\017\035\028\043\018\116\113\035\017\047\035\017\051\035\051\017\044\085\028\045\017\073\085\124\051\017\035\043\017\047\035\017\045\116\035\124\045\116\035\051\017\019\035\113\051\018\028\028\035\051\017\047\035\017\044\018\028\073\085\008\028\044\035\087\017\043\018\116\103\018\116\113\051\017\019\113\035\043\051\017\008\017\051\008\116\034\035\113\017\124\035\017\062\018\028\047\035\017\008\017\058\018\113\047\017\047\035\017\124\035\116\113\051\017\035\028\010\085\028\051\017\073\116\043\116\113\085\051\043\035\051\087\017\124\035\051\017\031\032\116\028\047\035\113\058\085\113\047\051\038\038\038")
		}, 
		{
			Text = _hbQ("\037\018\113\051\045\116\035\017\051\116\113\034\085\035\028\043\017\116\028\017\047\008\028\010\035\113\087\017\085\124\017\051\116\073\073\085\043\017\047\035\017\124\008\028\044\035\113\017\116\028\017\051\085\010\028\008\124\017\113\008\047\085\018\017\045\116\085\017\035\051\043\017\085\028\043\035\113\044\035\019\043\035\017\019\008\113\017\116\028\017\047\035\051\017\073\085\124\051\017\031\113\008\044\091\087\017\084\018\032\028\087\017\008\051\051\116\113\008\028\043\017\124\008\017\034\035\085\124\124\035\017\008\017\058\018\113\047\017\047\035\017\124\008\017\077\043\008\043\085\018\028\017\018\113\058\085\043\008\124\035\017\031\032\116\028\047\035\113\058\085\113\047\017\030\038\038\038"), 
			Media = _oxPVF
		}, 
		{
			Text = _I_a1.Description, 
			Media = _I_a1
		}, 
		{
			Text = _hbQ("\121\124\017\008\034\035\113\043\085\043\017\008\116\051\051\085\043\018\043\017\051\018\028\017\019\035\113\035\017\045\116\085\017\035\028\034\018\085\035\017\051\018\028\017\073\085\124\051\017\008\085\028\035\087\017\077\044\018\043\043\087\017\008\017\058\018\113\047\017\047\035\017\124\089\008\034\085\018\028\039\073\116\051\035\035\017\031\032\116\028\047\035\113\058\085\113\047\017\020\017\095\031\115\020\033\017\019\018\116\113\017\085\028\051\043\008\124\124\035\113\017\116\028\035\017\058\008\051\035\017\113\008\047\085\018\017\035\043\017\008\085\028\051\085\017\044\018\062\062\116\028\085\045\116\035\113\017\008\034\035\044\017\051\035\051\017\073\113\035\113\035\051\017\018\116\017\008\034\035\044\017\124\008\017\115\008\051\035\038\038\038"), 
			Media = _3h4R
		}, 
		{
			Text = _DrWx0.Description, 
			Media = _DrWx0
		}, 
		{
			Text = _hbQ("\072\028\017\073\018\028\044\043\085\018\028\017\047\035\017\044\035\017\045\116\035\017\044\035\017\047\035\113\028\085\035\113\017\008\017\051\085\010\028\008\124\035\087\017\124\089\008\034\085\018\028\039\044\008\113\010\018\017\031\032\116\028\047\035\113\058\085\113\047\017\122\017\095\031\115\122\033\087\017\019\085\124\018\043\035\017\019\008\113\017\079\085\113\010\085\124\087\017\035\062\019\018\113\043\035\017\124\035\017\062\008\043\035\113\085\035\124\017\047\035\017\051\035\044\018\116\113\051\017\008\047\035\045\116\008\043\017\051\043\018\044\110\035\017\047\008\028\051\017\047\035\051\017\044\018\028\043\035\028\035\116\113\051\017\008\047\008\019\043\035\051\038\038\038"), 
			Media = _JIJy
		}, 
		{
			Text = _jM5n.Description, 
			Media = _jM5n
		}, 
		{
			Text = _hbQ("\072\028\017\073\018\028\044\043\085\018\028\017\047\035\051\017\058\035\051\018\085\028\051\087\017\124\035\017\051\116\058\062\035\113\051\085\058\124\035\017\047\035\017\019\018\044\032\035\017\031\032\116\028\047\035\113\058\085\113\047\017\063\087\017\019\085\124\018\043\035\017\019\008\113\017\124\089\008\045\116\008\028\008\116\043\035\017\123\018\113\047\018\028\017\019\035\116\043\017\085\028\043\035\113\034\035\028\085\113\038\017\029\035\043\017\008\019\019\008\113\035\085\124\017\028\035\017\051\035\113\008\017\019\008\051\017\028\035\044\035\051\051\008\085\113\035\017\008\116\103\018\116\113\047\089\032\116\085\038\038\038"), 
			Media = _s4ewr
		}, 
		{
			Text = _9EL.Description, 
			Media = _9EL
		}, 
		{
			Text = _hbQ("\072\028\073\085\028\087\017\060\124\008\028\087\017\124\035\017\058\035\028\103\008\062\085\028\087\017\019\085\124\018\043\035\017\008\017\124\089\018\044\044\008\051\085\018\028\017\124\008\017\073\116\051\035\035\017\031\032\116\028\047\035\113\058\085\113\047\017\107\017\051\035\113\034\008\028\043\017\008\116\042\017\113\008\113\035\051\017\085\028\043\035\113\034\035\028\043\085\018\028\051\017\051\019\008\043\085\008\124\035\051\087\017\018\116\017\008\017\035\062\062\035\028\035\113\017\045\116\035\124\045\116\089\116\028\017\008\017\058\018\113\047\017\047\035\017\031\032\116\028\047\035\113\058\085\113\047\017\030\038\017\029\035\043\017\008\019\019\008\113\035\085\124\017\028\035\017\051\035\113\008\017\019\008\051\017\116\043\085\124\085\051\035\017\008\116\103\018\116\113\047\089\032\116\085\038\038\038"), 
			Media = _qz74
		}, 
		{
			Text = _Tt1yP.Description, 
			Media = _Tt1yP
		}, 
		{
			Text = _hbQ("\077\085\017\034\018\116\051\017\124\035\017\034\018\116\124\035\093\017\058\085\035\028\087\017\113\035\028\047\018\028\051\039\028\018\116\051\017\008\017\124\008\017\019\113\035\062\085\035\113\035\017\035\043\008\019\035\017\047\035\017\044\035\017\103\035\116\038\038\038"), 
			Media = _96r7
		}, 
		{
			Text = _hbQ("\084\035\017\051\116\085\051\017\085\062\019\008\043\085\035\028\043\017\047\035\017\103\018\116\035\113\038\038\038"), 
			Media = _NUCaG, 
			Buttons = {
				_hbQ("\097\035\019\008\113\043\038\038\038")
			}
		}
	}, function(action)
		Wherigo.ShowScreen(Wherigo.DETAILSCREEN, Depart)
		_rcZu:RequestSync()
	end)
	Depart.Visible = true
	Depart.Active = true
	John:MoveTo(Depart)
end
function _rcZu:OnRestore()
	_Urwigo.Dialog(false, {
		{
			Text = _hbQ("\079\018\043\113\035\017\008\019\019\008\113\035\085\124\017\035\043\054\018\116\017\034\018\043\113\035\017\008\019\019\124\085\044\008\043\085\018\028\017\008\017\073\035\113\062\035\017\124\035\017\103\035\116\017\019\113\035\044\035\047\035\062\062\035\028\043\038\017\100\008\051\017\047\035\017\051\018\116\044\085\051\087\017\113\035\019\113\035\028\018\028\051\017\124\035\017\103\035\116\017\047\089\018\116\017\018\028\017\124\089\008\017\124\008\085\051\051\035\038\038\038"), 
			Media = Exclamation, 
			Buttons = {
				_hbQ("\003\035\019\113\035\028\047\113\035\038\038\038")
			}
		}
	}, function(action)
		Wherigo.ShowScreen(Wherigo.MAINSCREEN)
	end)
end
function Depart:OnEnter()
	_EdN = _hbQ("\097\035\019\008\113\043")
	--[[Placer le son Explosion ci-dessous.]]
	Wherigo.PlayAudio(_o3E)
	_Urwigo.Dialog(false, {
		{
			Text = _hbQ("\050\032\112\017\127\008\085\051\017\045\116\089\035\051\043\039\044\035\017\045\116\035\017\044\089\035\051\043\017\045\116\035\017\044\035\043\043\035\017\035\042\019\124\018\051\085\018\028\014"), 
			Media = _zHB
		}, 
		{
			Text = _hbQ("\037\089\035\042\019\124\018\051\085\018\028\017\008\017\035\116\017\124\085\035\116\017\047\008\028\051\017\116\028\017\051\035\044\043\035\116\113\017\043\113\035\051\017\032\008\058\085\043\035\038\017\121\124\017\091\017\008\017\008\051\051\116\113\035\062\035\028\043\017\047\035\051\017\034\085\044\043\085\062\035\051\038\017\074\028\058\051\019\106\006\028\035\017\035\042\019\124\018\051\085\018\028\017\047\035\017\044\035\043\017\008\062\019\124\035\116\113\017\028\035\017\019\035\116\043\017\019\008\051\017\035\043\113\035\017\010\035\113\035\035\017\019\008\113\017\124\035\051\017\008\116\043\018\113\085\051\035\051\017\044\085\034\085\124\035\051\017\035\043\054\018\116\017\062\085\124\085\043\008\085\113\035\051\017\047\008\028\051\017\116\028\017\124\008\019\051\017\047\035\017\043\035\062\019\051\017\008\116\051\051\085\017\044\018\116\113\043\038\038\038"), 
			Media = _zHB
		}, 
		{
			Text = _hbQ("\084\035\017\028\035\017\044\018\028\028\008\085\051\017\045\116\089\116\028\035\017\051\035\116\124\035\017\018\113\010\008\028\085\051\008\043\085\018\028\017\045\116\085\017\019\018\116\113\113\008\085\043\017\085\028\043\035\113\034\035\028\085\113\038\038\038"), 
			Media = _NUCaG
		}, 
		{
			Text = _hbQ("\029\089\035\051\043\017\124\008\017\077\035\044\116\113\085\043\035\017\121\028\043\035\113\028\008\043\085\018\028\008\124\035\038\038\038"), 
			Media = _vLZ
		}, 
		{
			Text = (_hbQ("\060\124\124\018\017\060\124\124\018\087\017\085\044\085\017")..Player.Name).._hbQ("\087\017\103\089\008\019\019\035\124\124\035\017\124\008\017\077\035\044\116\113\085\043\035\017\121\028\043\035\113\028\008\043\085\018\028\008\124\035\038\038\038\017\072\051\043\039\044\035\017\045\116\035\017\034\018\116\051\017\062\035\017\113\035\044\035\034\035\093\014"), 
			Media = _NUCaG
		}, 
		{
			Text = (_hbQ("\084\035\017\113\035\019\035\043\035\038\038\038\017\121\044\085\017")..Player.Name).._hbQ("\087\017\103\089\008\019\019\035\124\124\035\017\124\008\017\077\035\044\116\113\085\043\035\017\121\028\043\035\113\028\008\043\085\018\028\008\124\035\038\038\038\017\072\051\043\039\044\035\017\045\116\035\017\034\018\116\051\017\062\035\017\113\035\044\035\034\035\093\014"), 
			Media = _NUCaG
		}, 
		{
			Text = (_hbQ("\121\044\085\017\124\008\017\077\035\044\116\113\085\043\035\017\121\028\043\035\113\028\008\043\085\018\028\008\124\035\038\017\084\035\017\034\018\116\051\017\113\035\044\018\085\051\017")..Player.Name).._hbQ("\038\017\127\018\028\017\028\018\062\017\035\051\043\017\084\018\032\028\017\031\113\008\044\091\017\047\035\017\124\008\017\077\043\008\043\085\018\028\017\018\113\058\085\043\008\124\035\017\031\032\116\028\047\035\113\058\085\113\047\017\030\038\017\098\116\035\124\017\035\051\043\017\124\035\017\019\113\018\058\124\035\062\035\014"), 
			Media = _oxPVF
		}, 
		{
			Text = _hbQ("\084\035\017\034\018\116\051\017\035\028\043\035\028\047\017\084\018\032\028\038\017\079\018\085\044\085\017\124\035\017\019\113\018\058\124\035\062\035\086\017\074\028\058\051\019\106\085\124\017\091\017\008\017\035\116\017\116\028\035\017\035\028\018\113\062\035\017\047\035\073\124\008\010\113\008\043\085\018\028\017\008\116\017\100\008\113\044\017\047\035\051\017\127\018\116\124\085\028\051\017\008\017\029\032\008\113\124\035\051\058\018\116\113\010\017\047\008\028\051\017\124\008\017\113\035\010\085\018\028\017\047\035\017\098\116\035\058\035\044\038\017\037\035\051\017\008\116\043\018\113\085\043\035\051\017\044\085\034\085\124\035\051\017\035\043\017\062\085\124\085\043\008\085\113\035\051\017\028\035\017\019\018\116\113\018\028\043\017\019\008\051\017\085\028\043\035\113\034\035\028\085\113\017\008\017\043\035\062\019\051\017\019\018\116\113\017\051\008\116\034\035\113\017\124\035\051\017\034\085\044\043\085\062\035\051\038\038\038"), 
			Media = _NUCaG
		}, 
		{
			Text = _hbQ("\037\035\017\113\035\044\035\019\043\085\018\028\017\028\089\035\051\043\017\019\008\051\017\043\113\035\051\017\058\018\028\028\035\038\017\074\028\058\051\019\106\084\035\017\034\018\116\051\017\051\116\010\010\035\113\035\017\047\035\017\034\018\116\051\017\047\035\019\124\008\044\035\113\017\034\035\113\051\017\116\028\017\035\028\047\113\018\085\043\017\019\124\116\051\017\035\124\018\085\010\028\035\017\047\035\017\124\008\017\047\035\073\124\008\010\113\008\043\085\018\028\017\019\018\116\113\017\008\062\035\124\085\018\113\035\113\017\124\008\017\044\018\062\062\116\028\085\044\008\043\085\018\028\038\038\038"), 
			Media = _oxPVF
		}, 
		{
			Text = _hbQ("\100\008\113\073\008\085\043\017\084\018\032\028\038\017\084\035\017\062\035\017\113\035\028\047\051\017\034\035\113\051\017\116\028\017\035\028\047\113\018\085\043\017\019\124\116\051\017\008\017\124\089\035\044\008\113\043\038\038\038"), 
			Media = _NUCaG
		}, 
		{
			Text = _hbQ("\115\085\035\028\017\113\035\044\116\038\017\084\089\008\043\043\035\028\047\017\034\018\043\113\035\017\008\019\019\035\124\038\038\038"), 
			Media = _oxPVF, 
			Buttons = {
				_hbQ("\029\018\062\062\116\028\085\044\008\043\085\018\028\051\038\038\038")
			}
		}
	}, function(action)
		Wherigo.ShowScreen(Wherigo.DETAILSCREEN, AireComm)
	end)
	AireComm.Active = true
	AireComm.Visible = true
	_hIfB.Complete = true
end
function Depart:OnExit()
	_EdN = _hbQ("\097\035\019\008\113\043")
	Depart.Active = false
	Depart.Visible = false
	John:MoveTo(AireComm)
	_rcZu:RequestSync()
end
function ZoneTB1:OnEnter()
	_EdN = _hbQ("\096\018\028\035\031\115\020")
	--[[Placer le son Retro-Fusee ci-dessous.]]
	Wherigo.PlayAudio(_Fn7rW)
	_Urwigo.Dialog(false, {
		{
			Text = _hbQ("\107\004\017\062\085\028\116\043\035\051\017\019\124\116\051\017\043\008\113\047\038\038\038"), 
			Media = _DrWx0
		}, 
		{
			Text = _hbQ("\121\044\085\017\077\044\018\043\043\017\031\113\008\044\091\017\008\017\058\018\113\047\017\047\035\017\031\032\116\028\047\035\113\058\085\113\047\017\020\038\017\074\028\058\051\019\106\079\035\116\085\124\124\035\093\017\047\035\010\008\010\035\113\017\124\089\008\085\113\035\017\047\089\008\043\043\035\113\113\085\051\051\008\010\035\038\038\038"), 
			Media = _DrWx0
		}, 
		{
			Text = (_hbQ("\115\085\035\028\017\113\035\044\116\017\077\044\018\043\043\038\017\084\035\017\051\116\085\051\017")..Player.Name).._hbQ("\038\017\029\089\035\051\043\017\062\018\085\017\045\116\085\017\008\085\017\044\018\062\062\116\028\085\045\116\035\017\008\034\035\044\017\124\008\017\077\035\044\116\113\085\043\035\017\121\028\043\035\113\028\008\043\085\018\028\008\124\035\017\019\018\116\113\017\116\028\035\017\085\028\043\035\113\034\035\028\043\085\018\028\017\113\008\019\085\047\035\038\017\084\089\035\043\008\085\051\017\124\018\085\028\017\047\035\017\062\089\085\062\008\010\085\028\035\113\017\045\116\035\017\044\035\124\008\017\124\035\017\051\035\113\008\085\043\017\008\116\043\008\028\043\038\038\038"), 
			Media = _NUCaG
		}, 
		{
			Text = (_hbQ("\127\035\113\044\085\017")..Player.Name).._hbQ("\112\017\074\028\058\051\019\106\084\089\008\085\017\035\073\073\035\044\043\085\034\035\062\035\028\043\017\035\043\035\017\008\034\085\051\035\017\045\116\035\017\034\018\116\051\017\008\034\085\035\093\017\008\019\019\035\124\035\017\019\018\116\113\017\047\035\017\124\089\008\085\047\035\038\017\084\089\008\085\017\047\035\103\008\017\035\042\008\062\085\028\035\017\124\035\051\017\124\085\035\116\042\017\047\008\028\051\017\062\018\028\017\008\019\019\113\018\044\032\035\017\035\043\017\031\032\116\028\047\035\113\058\085\113\047\017\122\017\035\051\043\017\047\035\103\008\017\035\028\017\113\018\116\043\035\017\035\043\017\047\035\034\113\008\085\043\017\008\034\018\085\113\017\124\035\017\062\008\043\035\113\085\035\124\017\028\035\044\035\051\051\008\085\113\035\017\019\018\116\113\017\034\035\028\085\113\017\008\017\058\018\116\043\017\047\035\017\044\035\043\017\085\028\044\035\028\047\085\035\017\044\113\035\035\017\019\008\113\017\124\089\035\042\019\124\018\051\085\018\028\038\038\038"), 
			Media = _3h4R
		}, 
		{
			Text = _hbQ("\127\035\051\017\085\028\051\043\113\116\062\035\028\043\051\017\008\017\058\018\113\047\017\047\035\043\035\044\043\035\028\043\017\047\035\051\017\019\035\113\051\018\028\028\035\051\017\035\028\017\047\008\028\010\035\113\017\035\043\017\028\018\116\051\017\008\124\124\018\028\051\017\124\035\051\017\051\035\044\018\116\113\085\113\038\017\077\018\091\035\093\017\044\035\019\035\028\047\008\028\043\017\113\008\051\051\116\113\035\087\017\044\035\051\017\019\035\113\051\018\028\028\035\051\017\051\018\028\043\017\035\028\044\018\113\035\017\034\085\034\008\028\043\035\051\087\017\062\008\085\051\017\085\124\017\073\008\116\043\017\073\008\085\113\035\017\034\085\043\035\038\038\038"), 
			Media = _3h4R
		}, 
		{
			Text = _hbQ("\031\032\116\028\047\035\113\058\085\113\047\017\030\017\008\017\031\032\116\028\047\035\113\058\085\113\047\017\020\038\038\038\017\072\051\043\039\044\035\017\045\116\035\017\043\116\017\062\035\017\113\035\044\018\085\051\017\077\044\018\043\043\014"), 
			Media = _oxPVF
		}, 
		{
			Text = _hbQ("\084\035\017\043\035\017\113\035\044\018\085\051\017\084\018\032\028\038\017\074\028\058\051\019\106\084\035\017\043\089\035\044\018\116\043\035\038\038\038"), 
			Media = _3h4R
		}, 
		{
			Text = _hbQ("\127\035\051\017\085\028\051\043\113\116\062\035\028\043\051\017\085\028\047\085\045\116\035\028\043\017\045\116\035\017\124\089\035\042\019\124\018\051\085\018\028\017\019\113\018\034\085\035\028\043\017\047\089\116\028\035\017\028\008\019\019\035\017\047\035\017\010\008\093\017\051\018\116\043\035\113\113\008\085\028\035\038\017\074\028\058\051\019\106\121\124\017\091\017\008\034\008\085\043\017\116\028\035\017\073\008\085\124\124\035\017\045\116\085\017\124\008\085\051\051\008\085\043\017\035\044\032\008\019\019\035\113\017\124\035\017\010\008\093\017\035\043\017\124\008\017\028\008\019\019\035\017\008\017\035\042\019\124\018\051\035\038\038\038"), 
			Media = _oxPVF
		}, 
		{
			Text = _hbQ("\029\089\035\051\043\017\044\035\017\045\116\085\017\035\042\019\124\085\045\116\035\017\124\089\085\062\019\018\113\043\008\028\044\035\017\047\035\017\124\089\035\042\019\124\018\051\085\018\028\038\017\076\039\008\039\043\039\085\124\017\008\116\043\113\035\017\044\032\018\051\035\017\045\116\035\017\028\018\116\051\017\047\035\034\113\085\018\028\051\017\044\018\028\028\008\085\043\113\035\014"), 
			Media = _3h4R
		}, 
		{
			Text = _hbQ("\050\116\085\017\077\044\018\043\043\038\017\074\028\058\051\019\106\121\124\017\008\017\116\028\035\017\047\035\116\042\085\035\062\035\017\028\008\019\019\035\017\019\113\035\051\017\047\035\017\124\008\017\028\008\019\019\035\017\045\116\085\017\008\017\035\044\032\008\019\019\035\017\051\018\028\017\010\008\093\038\017\074\028\058\051\019\106\037\008\017\044\032\008\124\035\116\113\017\035\051\043\017\085\028\043\035\028\051\035\017\035\043\017\124\035\017\113\085\051\045\116\035\017\047\089\035\042\019\124\018\051\085\018\028\017\047\035\017\044\035\043\043\035\017\122\035\017\028\008\019\019\035\017\035\051\043\017\085\062\062\085\028\035\028\043\035\038\017\074\028\058\051\019\106\031\032\116\028\047\035\113\058\085\113\047\017\122\017\008\017\019\113\085\051\017\124\035\017\029\008\085\051\051\018\028\017\028\116\062\035\113\018\017\107\017\045\116\085\017\044\018\028\043\085\035\028\043\017\124\089\035\028\010\085\028\017\012\085\113\035\073\124\091\038\038\038"), 
			Media = _oxPVF
		}, 
		{
			Text = _hbQ("\031\032\116\028\047\035\113\058\085\113\047\017\122\017\035\051\043\017\051\116\113\017\124\035\017\019\018\085\028\043\017\047\089\008\113\113\085\034\035\113\038\017\060\124\124\018\028\051\017\008\017\051\008\017\113\035\028\044\018\028\043\113\035\038\038\038"), 
			Media = _3h4R, 
			Buttons = {
				_hbQ("\060\043\043\035\113\113\085\051\051\008\010\035\017\031\115\122\038\038\038")
			}
		}
	}, function(action)
		Wherigo.ShowScreen(Wherigo.DETAILSCREEN, ZoneTB2)
	end)
	ZoneTB2.Active = true
	ZoneTB2.Visible = true
end
function ZoneTB1:OnExit()
	_EdN = _hbQ("\096\018\028\035\031\115\020")
	ZoneTB1.Active = false
	ZoneTB1.Visible = false
	Virgil:MoveTo(ZoneTB2)
	Scott:MoveTo(ZoneTB2)
	Brains:MoveTo(ZoneTB2)
	_rcZu:RequestSync()
end
function AireComm:OnEnter()
	_EdN = _hbQ("\060\085\113\035\029\018\062\062")
	ZoneTB1.Visible = true
	ZoneTB1.Active = true
	_Urwigo.Dialog(false, {
		{
			Text = _hbQ("\060\124\124\018\017\084\018\032\028\038\017\084\035\017\062\035\017\043\113\018\116\034\035\017\062\008\085\028\043\035\028\008\028\043\017\047\008\028\051\017\116\028\035\017\093\018\028\035\017\047\035\010\008\010\035\035\017\019\018\116\113\017\062\085\035\116\042\017\044\018\062\062\116\028\085\045\116\035\113\038\017\072\051\043\039\044\035\017\045\116\035\017\034\018\116\051\017\062\089\035\028\043\035\028\047\035\093\017\062\085\035\116\042\014"), 
			Media = _NUCaG
		}, 
		{
			Text = (_hbQ("\060\073\073\085\113\062\008\043\085\073\017")..Player.Name).._hbQ("\038\017\072\028\043\113\035\043\035\062\019\051\087\017\103\089\008\085\017\019\116\017\035\042\008\062\085\028\035\113\017\124\089\035\043\008\043\017\047\035\051\017\124\085\035\116\042\017\008\017\019\008\113\043\085\113\017\047\035\051\017\085\028\051\043\113\116\062\035\028\043\051\017\047\035\017\031\032\116\028\047\035\113\058\085\113\047\017\030\038\017\029\008\017\051\035\062\058\124\035\017\035\028\017\035\073\073\035\043\017\043\113\035\051\017\051\035\113\085\035\116\042\038\017\084\035\017\044\018\062\062\116\028\085\045\116\035\017\085\062\062\035\047\085\008\043\035\062\035\028\043\017\008\034\035\044\017\124\008\017\115\008\051\035\017\035\043\017\047\035\062\008\028\047\035\113\017\031\032\116\028\047\035\113\058\085\113\047\017\020\017\019\018\116\113\017\116\028\035\017\085\028\043\035\113\034\035\028\043\085\018\028\017\113\008\019\085\047\035\038\038\038"), 
			Media = _oxPVF
		}, 
		{
			Text = _hbQ("\031\032\116\028\047\035\113\058\085\113\047\017\030\017\008\019\019\035\124\124\035\017\124\008\017\115\008\051\035\017\047\035\017\124\008\017\077\035\044\116\113\085\043\035\017\121\028\043\035\113\028\008\043\085\018\028\008\124\035\038\017\003\035\019\018\028\047\035\093\038\038\038"), 
			Media = _oxPVF
		}, 
		{
			Text = _hbQ("\031\032\116\028\047\035\113\058\085\113\047\017\030\087\017\085\044\085\017\124\008\017\115\008\051\035\038\017\098\116\035\017\044\035\017\019\008\051\051\035\039\043\039\085\124\017\084\018\032\028\014"), 
			Media = _aJI
		}, 
		{
			Text = _hbQ("\121\124\017\091\017\008\017\035\116\017\116\028\035\017\085\062\019\018\113\043\008\028\043\035\017\035\042\019\124\018\051\085\018\028\017\047\008\028\051\017\124\008\017\113\035\010\085\018\028\017\047\035\017\098\116\035\058\035\044\038\017\121\124\017\073\008\116\043\017\035\028\034\018\091\035\113\017\031\032\116\028\047\035\113\058\085\113\047\017\020\017\051\116\113\017\124\035\051\017\124\085\035\116\042\017\019\018\116\113\017\103\116\010\035\113\017\047\116\017\062\008\043\035\113\085\035\124\017\028\035\044\008\051\051\008\085\113\035\017\035\043\017\035\043\008\058\124\085\113\017\116\028\035\017\044\018\062\062\116\028\085\044\008\043\085\018\028\038\038\038"), 
			Media = _oxPVF
		}, 
		{
			Text = _hbQ("\012\038\060\038\115\038\017\084\018\032\028\038\017\074\028\058\051\019\106\084\089\035\028\034\018\085\035\017\085\062\062\035\047\085\008\043\035\062\035\028\043\017\031\032\116\028\047\035\113\058\085\113\047\017\020\017\051\116\113\017\124\035\051\017\124\085\035\116\042\038\038\038"), 
			Media = _aJI
		}, 
		{
			Text = (_hbQ("\031\032\116\028\047\035\113\058\085\113\047\017\030\017\008\017")..Player.Name).._hbQ("\038\017\013\018\116\051\017\035\028\034\018\091\018\028\051\017\031\032\116\028\047\035\113\058\085\113\047\017\020\017\051\116\113\017\124\035\051\017\124\085\035\116\042\038\017\079\035\116\085\124\124\035\093\017\034\018\116\051\017\047\085\113\085\010\035\113\017\034\035\113\051\017\051\008\017\093\018\028\035\017\047\089\008\043\043\035\113\113\085\051\051\008\010\035\017\019\018\116\113\017\124\008\017\113\035\028\044\018\028\043\113\035\038\017\084\089\008\085\017\008\103\018\116\043\035\017\044\035\043\043\035\017\096\018\028\035\017\047\008\028\051\017\034\018\043\113\035\017\008\019\019\008\113\035\085\124\038\038\038"), 
			Media = _oxPVF
		}, 
		{
			Text = _hbQ("\097\089\008\044\044\018\113\047\017\084\018\032\028\038\017\084\035\017\062\035\017\047\085\113\085\010\035\017\034\035\113\051\017\124\008\017\096\018\028\035\017\047\089\008\043\043\035\113\113\085\051\008\010\035\017\031\115\020\038\038\038"), 
			Media = _NUCaG, 
			Buttons = {
				_hbQ("\060\043\043\035\113\113\085\051\051\008\010\035\017\031\115\020\038\038\038")
			}
		}
	}, function(action)
		Wherigo.ShowScreen(Wherigo.DETAILSCREEN, ZoneTB1)
	end)
end
function AireComm:OnExit()
	_EdN = _hbQ("\060\085\113\035\029\018\062\062")
	AireComm.Active = false
	AireComm.Visible = false
	Scott.Visible = true
	Virgil.Visible = true
	Scott:MoveTo(ZoneTB1)
	Virgil:MoveTo(ZoneTB1)
	_rcZu:RequestSync()
end
function ZoneTB2:OnEnter()
	_EdN = _hbQ("\096\018\028\035\031\115\122")
	--[[Placer le son Retro-fusee ci-dessous.]]
	Wherigo.PlayAudio(_Fn7rW)
	_thlf3.Complete = true
	Firefly.Active = true
	Firefly.Visible = true
	PatNitro.Visible = true
	PatNitro.Commands._CAY0.Enabled = true
	PatNitro.Commands._3vY4.Enabled = true
	PatNitro:MoveTo(Player)
	_Urwigo.Dialog(false, {
		{
			Text = (((_hbQ("\121\044\085\017\079\085\113\010\085\124\017\031\113\008\044\091\017\008\017\058\018\113\047\017\047\035\017\031\032\116\028\047\035\113\058\085\113\047\017\122\038\017\084\089\008\019\019\035\124\124\035\017")..Player.Name).._hbQ("\017\035\043\017"))..Scott.Name).._hbQ("\038\038\038"), 
			Media = _JjYI
		}, 
		{
			Text = (((_hbQ("\121\044\085\017")..Player.Name).._hbQ("\017\035\043\017"))..Scott.Name).._hbQ("\038\017\050\028\017\034\018\116\051\017\035\044\018\116\043\035\017\079\085\113\010\085\124\038\038\038"), 
			Media = _NUCaG
		}, 
		{
			Text = _hbQ("\084\035\017\034\008\085\051\017\085\062\062\035\047\085\008\043\035\062\035\028\043\017\047\035\010\008\010\035\113\017\124\035\017\029\008\085\051\051\018\028\017\028\116\062\035\113\018\017\107\017\019\018\116\113\017\051\018\113\043\085\113\017\012\085\113\035\073\124\091\017\045\116\085\017\047\035\034\113\008\017\062\008\085\043\113\085\051\035\113\017\124\089\085\028\044\035\028\047\085\035\038\038\038"), 
			Media = _pcB
		}, 
		{
			Text = _hbQ("\115\113\008\085\028\051\017\019\113\035\028\047\113\008\017\124\035\017\113\035\124\008\085\051\017\019\018\116\113\017\124\035\051\017\044\018\062\062\116\028\085\044\008\043\085\018\028\051\038\017\121\124\017\051\089\035\051\043\017\124\116\085\039\062\035\062\035\017\019\113\018\019\018\051\035\017\019\018\116\113\017\008\051\051\085\051\043\035\113\017\124\089\018\019\035\113\008\043\085\018\028\038\017\074\028\058\051\019\106\084\035\017\019\008\051\051\035\017\124\035\017\113\008\124\008\085\051\017\008\017\115\113\008\085\028\051\017\019\018\116\113\017\124\008\017\051\116\085\043\035\017\047\035\051\017\018\019\035\113\008\043\085\018\028\051\038\038\038"), 
			Media = _JIJy
		}, 
		{
			Text = _hbQ("\031\032\116\028\047\035\113\058\085\113\047\017\122\017\008\017\115\113\008\085\028\051\087\017\072\051\043\039\044\035\017\045\116\035\017\043\116\017\062\035\017\113\035\044\018\085\051\017\115\113\008\085\028\051\014"), 
			Media = _JIJy
		}, 
		{
			Text = _hbQ("\121\044\085\017\115\113\008\085\028\051\038\017\084\035\017\043\035\017\113\035\044\018\085\051\017\058\085\035\028\017\079\085\113\010\085\124\038\017\084\035\017\034\018\085\051\017\045\116\035\017\043\116\017\008\051\017\047\035\010\008\010\035\017\124\035\017\044\008\085\051\051\018\028\038\017\084\035\017\044\018\062\062\008\028\047\035\017\124\089\018\116\034\035\113\043\116\113\035\017\047\035\017\124\008\017\019\018\113\043\035\017\047\116\017\029\008\085\051\051\018\028\017\107\017\019\018\116\113\017\051\018\113\043\085\113\017\012\085\113\035\073\124\091\038\038\038"), 
			Media = _eddAO
		}, 
		{
			Text = _15mH.Description, 
			Media = _15mH
		}, 
		{
			Text = (((_hbQ("\121\044\085\017\115\113\008\085\028\051\087\017\103\089\008\019\019\035\124\124\035\017")..Scott.Name).._hbQ("\017\035\043\017"))..Player.Name).._hbQ("\038\017\084\035\017\028\035\017\019\018\116\113\113\008\085\017\019\008\051\017\051\018\113\043\085\113\017\047\035\017\124\089\035\028\010\085\028\017\012\085\113\035\073\124\091\017\047\116\113\008\028\043\017\124\089\018\019\035\113\008\043\085\018\028\038\017\072\051\043\039\044\035\017\045\116\035\017\034\018\116\051\017\008\124\124\035\093\017\062\089\008\051\051\085\051\043\035\113\014"), 
			Media = _eddAO
		}, 
		{
			Text = (((_hbQ("\121\044\085\017")..Scott.Name).._hbQ("\017\035\043\017"))..Player.Name).._hbQ("\038\017\050\028\017\008\043\043\035\028\047\017\034\018\051\017\085\028\051\043\113\116\044\043\085\018\028\051\017\115\113\008\085\028\051\038\038\038")
		}, 
		{
			Text = _hbQ("\072\042\044\035\124\124\035\028\043\112\017\084\089\008\116\113\008\085\017\058\035\051\018\085\028\017\047\116\017\062\008\042\085\062\116\062\017\047\089\008\085\047\035\038\017\084\035\017\051\018\113\051\017\012\085\113\035\073\124\091\017\047\116\017\029\008\085\051\051\018\028\017\013\116\062\035\113\018\017\107\038\038\038"), 
			Media = _eddAO
		}, 
		{
			Text = _hbQ("\060\034\035\044\017\012\085\113\035\073\124\091\087\017\028\018\116\051\017\008\124\124\018\028\051\017\019\113\018\034\018\045\116\035\113\017\116\028\035\017\043\113\035\051\017\010\113\008\028\047\035\017\035\042\019\124\018\051\085\018\028\017\008\017\124\008\017\100\008\043\035\017\047\035\017\013\085\043\113\018\010\124\091\044\035\113\085\028\035\017\044\035\017\045\116\085\017\073\035\113\008\017\035\028\017\051\018\113\043\035\017\045\116\035\017\124\035\017\073\035\116\017\028\089\008\116\113\008\017\019\124\116\051\017\124\089\018\042\091\010\035\028\035\017\028\035\044\035\051\051\008\085\113\035\017\008\017\051\008\017\044\018\062\058\116\051\043\085\018\028\038\038\038\038"), 
			Media = _eddAO
		}, 
		{
			Text = _hbQ("\037\018\113\051\045\116\035\017\124\035\017\062\018\062\035\028\043\017\047\035\017\019\113\018\034\018\045\116\035\113\017\124\089\035\042\019\124\018\051\085\018\028\017\051\035\113\008\017\034\035\028\116\087\017\103\035\017\034\008\085\051\017\034\018\116\051\017\008\034\035\113\043\085\113\038\017\121\124\017\051\035\113\008\017\008\124\018\113\051\017\043\035\062\019\051\017\047\035\017\034\018\116\051\017\047\085\113\085\010\035\113\017\034\035\113\051\017\124\008\017\093\018\028\035\017\047\035\017\051\085\028\085\051\043\113\035\051\017\019\018\116\113\017\019\018\113\043\035\113\017\051\035\044\018\116\113\051\017\008\116\042\017\034\085\044\043\085\062\035\051\038\038\038"), 
			Media = _eddAO
		}, 
		{
			Text = (((_hbQ("\097\089\008\044\044\018\113\047\017")..Brains.Name).._hbQ("\017\035\043\017"))..Player.Name).._hbQ("\038\108\115\003\065\121\044\085\017\079\085\113\010\085\124\038\017\084\035\017\047\035\062\035\116\113\035\017\008\017\058\018\113\047\017\047\035\017\031\032\116\028\047\035\113\058\085\113\047\017\122\017\035\043\017\103\089\008\043\043\035\028\047\051\017\034\018\043\113\035\017\062\035\051\051\008\010\035\038\038\038"), 
			Media = _JIJy, 
			Buttons = {
				_hbQ("\077\018\113\043\085\035\017\012\085\113\035\073\124\091\038\038\038")
			}
		}
	}, function(action)
		Wherigo.ShowScreen(Wherigo.DETAILSCREEN, Firefly)
	end)
end
function ZoneTB2:OnExit()
	_EdN = _hbQ("\096\018\028\035\031\115\122")
	ZoneTB2.Active = false
	ZoneTB2.Visible = false
	Brains:MoveTo(Firefly)
	Scott:MoveTo(Firefly)
	_rcZu:RequestSync()
end
function Firefly:OnEnter()
	_EdN = _hbQ("\012\085\113\035\073\124\091")
	PatNitro.Visible = true
	PatNitro.Commands._CAY0.Enabled = true
	PatNitro:MoveTo(Player)
	_Urwigo.Dialog(false, {
		{
			Text = _hbQ("\079\018\116\051\017\043\113\018\116\034\035\113\035\093\017\047\008\028\051\017\034\018\043\113\035\017\085\028\034\035\028\043\008\085\113\035\017\124\008\017\100\008\043\035\017\047\035\017\013\085\043\113\018\010\124\091\044\035\113\085\028\035\017\028\035\044\035\051\051\008\085\113\035\017\008\017\124\089\018\019\035\113\008\043\085\018\028\038\017\121\124\017\073\008\116\047\113\008\017\100\113\035\028\047\113\035\017\072\031\017\124\028\051\043\008\124\124\035\113\017\035\028\017\008\034\008\028\043\017\047\116\017\019\008\113\035\039\073\035\116\017\047\035\017\124\089\035\028\010\085\028\038\038\038"), 
			Media = _eddAO, 
			Buttons = {
				_hbQ("\100\113\035\028\047\113\035\017\013\085\043\113\018\038\038\038")
			}
		}
	}, function(action)
		Wherigo.ShowScreen(Wherigo.DETAILSCREEN, PatNitro)
	end)
end
function Firefly:OnExit()
	_EdN = _hbQ("\012\085\113\035\073\124\091")
	PatNitro.Visible = false
	Firefly.Active = false
	Firefly.Visible = false
	ZAbri.Active = true
	ZAbri.Visible = true
	--[[Script Move Player to Zone Abritee supprime. Ce script causait un LUA Error dans Webwigo.]]
	Scott:MoveTo(ZAbri)
	_Urwigo.Dialog(false, {
		{
			Text = _hbQ("\084\035\017\034\008\085\051\017\008\034\008\028\044\035\113\017\012\085\113\035\073\124\091\017\124\035\017\019\124\116\051\017\019\018\051\051\085\058\124\035\017\047\116\017\044\035\028\043\113\035\017\047\035\017\124\089\085\028\044\035\028\047\085\035\017\019\018\116\113\017\008\034\018\085\113\017\124\035\017\062\008\042\085\062\116\028\017\047\089\035\073\073\085\044\008\044\085\043\035\038\038\038"), 
			Media = _eddAO
		}, 
		{
			Text = _hbQ("\037\089\035\042\019\124\018\051\085\018\028\017\047\035\017\124\008\017\028\008\019\019\035\017\047\035\017\010\008\093\017\008\017\044\113\035\035\017\116\028\017\044\113\008\043\035\113\035\038\017\121\124\017\062\035\017\073\008\116\043\017\073\113\008\091\035\113\017\116\028\017\044\032\035\062\085\028\017\008\017\043\113\008\034\035\113\051\017\124\035\051\017\047\035\058\113\085\051\038\017\012\085\113\035\073\124\091\017\008\017\035\043\035\017\044\018\028\044\116\017\019\018\116\113\017\044\035\017\010\035\028\113\035\017\047\035\017\043\035\113\113\008\085\028\087\017\062\008\085\051\017\085\124\017\062\035\017\073\008\116\047\113\008\017\019\124\116\051\017\047\035\017\043\035\062\019\051\038\038\038"), 
			Media = _eddAO
		}, 
		{
			Text = _hbQ("\084\035\017\051\116\085\051\017\062\008\085\028\043\035\028\008\028\043\017\008\116\017\044\035\028\043\113\035\017\047\116\017\044\113\008\043\035\113\035\017\018\116\017\124\035\017\010\008\093\017\051\089\035\044\032\008\019\019\008\085\043\038\038\038"), 
			Media = _eddAO
		}, 
		{
			Text = _hbQ("\100\008\113\073\008\085\043\112\017\074\028\058\051\019\106\072\124\018\085\010\028\035\093\039\034\018\116\051\017\019\124\116\051\017\124\018\085\028\017\034\035\113\051\017\124\008\017\096\018\028\035\017\060\058\113\085\043\035\035\038\017\097\035\051\017\045\116\035\017\034\018\116\051\017\091\017\051\035\113\035\093\087\017\103\035\017\034\008\085\051\017\019\113\018\034\018\045\116\035\113\017\124\089\035\042\019\124\018\051\085\018\028\038\038\038"), 
			Media = _eddAO, 
			Buttons = {
				_hbQ("\096\018\028\035\017\060\058\113\085\043\035\035\038\038\038")
			}
		}
	}, function(action)
		Wherigo.ShowScreen(Wherigo.DETAILSCREEN, ZAbri)
	end)
end
function ZVictimes:OnEnter()
	_EdN = _hbQ("\096\079\085\044\043\085\062\035\051")
	_ge5.Complete = true
	LPenelope:MoveTo(ZVictimes)
	LPenelope.Visible = true
	Firefly.Active = false
	Firefly.Visible = false
	TB2.Active = true
	TB2.Visible = true
	_Urwigo.Dialog(false, {
		{
			Text = Player.Name.._hbQ("\112\017\084\035\017\044\018\062\019\113\035\028\047\051\017\019\018\116\113\045\116\018\085\017\124\035\051\017\034\085\044\043\085\062\035\051\017\051\018\028\043\017\051\008\116\034\035\051\038\017\029\035\043\017\035\028\047\113\018\085\043\017\035\051\043\017\073\018\113\043\035\062\035\028\043\017\008\058\113\085\043\035\038\017\029\089\035\051\043\017\116\028\035\017\044\032\008\028\044\035\017\045\116\089\035\124\124\035\051\017\008\085\035\028\043\017\035\043\035\017\085\044\085\017\019\035\028\047\008\028\043\017\124\008\017\047\035\073\124\008\010\113\008\043\085\018\028\038\038\038"), 
			Media = _3h4R
		}, 
		{
			Text = _hbQ("\050\116\085\017\077\044\018\043\043\112\017\074\028\058\051\019\106\029\089\035\051\043\017\043\018\116\043\017\008\017\073\008\085\043\017\103\116\051\043\035\038\017\003\035\051\043\035\017\008\017\051\008\034\018\085\113\017\047\008\028\051\017\045\116\035\124\017\035\043\008\043\017\085\124\051\017\051\018\028\043\038\017\060\124\124\018\028\051\017\034\018\085\113\017\047\035\017\019\124\116\051\017\019\113\035\051\017\047\008\028\051\017\045\116\035\124\017\035\043\008\043\017\085\124\051\017\051\018\028\043\038\038\038"), 
			Media = _NUCaG
		}, 
		{
			Text = _hbQ("\127\008\017\019\008\113\018\124\035\087\017\062\008\085\051\017\044\089\035\051\043\017\124\008\017\034\018\085\043\116\113\035\017\047\035\017\037\008\047\091\017\100\035\028\035\124\018\019\035\112"), 
			Media = _9tf
		}, 
		{
			Text = _nRB2.Description, 
			Media = _nRB2
		}, 
		{
			Text = _9tf.Description, 
			Media = _9tf
		}, 
		{
			Text = _v54g.Description, 
			Media = _v54g
		}, 
		{
			Text = _hbQ("\037\008\047\091\017\100\035\028\035\124\018\019\035\017\035\043\017\100\008\113\110\035\113\017\051\018\028\043\017\047\035\051\017\008\062\085\051\017\047\035\017\028\018\043\113\035\017\018\113\010\008\028\085\051\008\043\085\018\028\038\017\121\124\051\017\051\018\028\043\017\051\018\116\034\035\028\043\017\019\113\035\051\035\028\043\051\017\008\116\042\017\124\085\035\116\042\017\047\035\017\051\085\028\085\051\043\113\035\051\017\019\018\116\113\017\028\018\116\051\017\047\018\028\028\035\113\017\047\116\017\051\116\019\019\018\113\043\038\017\029\018\062\062\035\017\034\018\116\051\017\035\043\035\051\017\008\034\035\044\017\028\018\116\051\087\017\124\035\116\113\017\019\113\035\051\035\028\044\035\017\028\035\017\051\035\113\008\017\019\008\051\017\028\035\044\035\051\051\008\085\113\035\038\038\038"), 
			Media = _3h4R
		}, 
		{
			Text = _hbQ("\031\018\116\043\035\051\017\124\035\051\017\019\035\113\051\018\028\028\035\051\017\019\113\035\051\035\028\043\035\051\017\051\018\028\043\017\085\028\047\035\062\028\035\051\038\017\037\035\051\017\035\043\008\010\035\051\017\051\116\019\035\113\085\035\116\113\051\017\051\035\062\058\124\035\028\043\017\043\018\116\051\017\034\085\047\035\051\038\017\013\018\116\051\017\019\018\116\034\018\028\051\017\047\018\028\044\017\047\085\113\035\017\104\097\035\034\018\085\113\017\060\044\044\018\062\019\124\085\112\104"), 
			Media = _3h4R
		}, 
		{
			Text = _hbQ("\077\044\018\043\043\017\008\019\019\035\124\124\035\017\115\113\008\085\028\051\038\017\072\051\043\039\044\035\017\045\116\035\017\043\116\017\062\035\017\113\035\044\018\085\051\017\115\113\008\085\028\051\014"), 
			Media = _3h4R
		}, 
		{
			Text = _hbQ("\060\073\073\085\113\062\008\043\085\073\017\077\044\018\043\043\038\017\072\051\043\039\044\035\017\045\116\035\017\034\018\116\051\017\008\034\035\093\017\019\018\113\043\035\017\051\035\044\018\116\113\051\017\008\116\042\017\034\085\044\043\085\062\035\051\014"), 
			Media = _eddAO
		}, 
		{
			Text = _hbQ("\031\018\116\043\035\051\017\124\035\051\017\019\035\113\051\018\028\028\035\051\017\045\116\085\017\035\043\008\085\035\028\043\017\019\113\035\051\017\047\035\051\017\124\085\035\116\042\017\051\018\028\043\017\085\028\047\035\062\028\035\051\038\038\038"), 
			Media = _3h4R
		}, 
		{
			Text = _hbQ("\127\035\113\044\085\017\077\044\018\043\043\112\017\029\089\035\051\043\017\116\028\035\017\035\042\044\035\124\124\035\028\043\035\017\028\018\116\034\035\124\124\035\038\017\100\035\028\047\008\028\043\017\045\116\035\017\034\018\116\051\017\043\035\113\062\085\028\035\093\017\047\089\035\042\019\124\018\113\035\113\017\124\035\051\017\124\085\035\116\042\087\017\103\035\017\062\089\008\051\051\116\113\035\017\045\116\089\008\116\044\116\028\035\017\073\008\085\124\124\035\017\028\035\017\124\008\085\051\051\035\017\035\044\032\008\019\019\035\113\017\124\035\051\017\010\008\093\017\047\035\017\124\008\017\122\035\017\028\008\019\019\035\038\017\121\124\017\113\035\051\043\035\113\008\017\008\116\042\017\008\116\043\018\113\085\043\035\051\017\044\085\034\085\124\035\051\017\047\035\017\113\035\062\019\124\085\113\017\124\035\017\044\113\008\043\035\113\035\017\047\035\017\124\089\035\042\019\124\018\051\085\018\028\038\038\038"), 
			Media = _eddAO
		}, 
		{
			Text = _hbQ("\100\008\113\073\008\085\043\017\115\113\008\085\028\051\038\017\050\028\017\051\089\008\051\051\116\113\035\017\045\116\035\017\019\035\113\051\018\028\028\035\017\028\089\008\017\058\035\051\018\085\028\017\047\089\008\116\044\116\028\035\017\008\116\043\113\035\017\008\051\051\085\051\043\008\028\044\035\038\017\097\035\051\017\045\116\035\017\044\089\035\051\043\017\073\008\085\043\087\017\028\018\116\051\017\113\035\043\018\116\113\028\018\028\051\017\034\035\113\051\017\031\032\116\028\047\035\113\058\085\113\047\017\122\038\038\038"), 
			Media = _3h4R
		}, 
		{
			Text = _hbQ("\077\044\018\043\043\017\008\019\019\035\124\124\035\017\079\085\113\010\085\124\038\017\072\051\043\039\044\035\017\045\116\035\017\043\116\017\062\089\035\028\043\035\028\047\051\014"), 
			Media = _3h4R
		}, 
		{
			Text = _hbQ("\121\044\085\017\079\085\113\010\085\124\038\017\029\018\062\062\035\028\043\017\035\051\043\039\044\035\017\045\116\035\017\044\089\035\051\043\017\047\035\017\034\018\043\113\035\017\044\018\043\035\014"), 
			Media = _JIJy
		}, 
		{
			Text = (_hbQ("\031\018\116\043\017\035\051\043\017\018\110\017\085\044\085\038\017")..Player.Name).._hbQ("\017\035\043\017\062\018\085\087\017\018\028\017\051\089\035\051\043\017\008\051\051\116\113\035\051\017\045\116\035\017\019\035\113\051\018\028\028\035\017\028\089\008\017\058\035\051\018\085\028\017\047\089\008\051\051\085\051\043\008\028\044\035\017\051\116\019\019\124\035\062\035\028\043\008\085\113\035\038\017\121\124\051\017\019\035\116\034\035\028\043\017\043\018\116\051\017\113\035\019\008\113\043\085\113\017\043\113\008\028\045\116\085\124\124\035\038\038\038"), 
			Media = _3h4R
		}, 
		{
			Text = _hbQ("\115\113\008\085\028\051\087\017\124\116\085\087\017\051\089\008\051\051\116\113\035\017\045\116\089\008\116\044\116\028\035\017\008\116\043\113\035\017\073\008\085\124\124\035\017\028\035\017\124\008\085\051\051\035\017\035\044\032\008\019\019\035\113\017\047\035\017\010\008\093\017\047\035\017\124\008\017\122\035\017\028\008\019\019\035\038\017\097\035\051\017\045\116\089\085\124\017\008\017\043\035\113\062\085\028\035\087\017\085\124\017\113\035\043\018\116\113\028\035\017\034\035\113\051\017\031\032\116\028\047\035\113\058\085\113\047\017\122\038\038\038"), 
			Media = _3h4R
		}, 
		{
			Text = _hbQ("\012\038\060\038\115\038\017\077\044\018\043\043\038\017\084\035\017\034\008\085\051\017\008\043\043\035\028\047\113\035\017\115\113\008\085\028\051\017\035\043\017\051\018\028\017\012\085\113\035\073\124\091\038\017\060\116\051\051\085\043\018\043\017\008\113\113\085\034\035\017\035\043\017\012\085\113\035\073\124\091\017\113\035\062\085\051\017\047\008\028\051\017\124\035\017\029\008\085\051\051\018\028\017\028\116\062\035\113\018\017\107\087\017\103\089\085\113\008\085\017\113\035\103\018\085\028\047\113\035\017\124\035\017\084\018\116\035\116\113\017\019\113\035\051\017\047\035\017\124\008\017\096\018\028\035\017\047\035\051\017\034\085\044\043\085\062\035\051\017\008\034\035\044\017\031\032\116\028\047\035\113\058\085\113\047\017\122\038\038\038"), 
			Media = _JIJy
		}, 
		{
			Text = _hbQ("\003\035\103\018\085\010\028\018\028\051\017\031\032\116\028\047\035\113\058\085\113\047\017\122\017\051\085\017\034\018\116\051\017\124\035\017\034\018\116\124\035\093\017\058\085\035\028\038\038\038"), 
			Media = _3h4R
		}, 
		{
			Text = _hbQ("\115\018\028\028\035\017\085\047\035\035\017\077\044\018\043\043\038\017\060\124\124\018\028\051\039\091\038\038\038"), 
			Media = _NUCaG
		}, 
		{
			Text = _hbQ("\077\116\113\034\035\085\124\124\035\093\017\034\018\043\113\035\017\035\044\113\008\028\017\044\032\035\062\085\028\017\073\008\085\051\008\028\043\038\017\079\018\116\051\017\008\116\113\035\093\017\116\028\035\017\045\116\035\051\043\085\018\028\017\043\035\051\043\038\038\038"), 
			Media = _LjrO, 
			Buttons = {
				_hbQ("\031\032\116\028\047\035\113\058\085\113\047\017\122\038\038\038")
			}
		}
	}, function(action)
		Wherigo.ShowScreen(Wherigo.DETAILSCREEN, TB2)
	end)
end
function ZVictimes:OnExit()
	_EdN = _hbQ("\096\079\085\044\043\085\062\035\051")
	ZVictimes.Active = false
	ZVictimes.Visible = false
	Scott:MoveTo(TB2)
	Virgil:MoveTo(TB2)
	Brains:MoveTo(TB2)
	_Urwigo.MessageBox{
		Text = _hbQ("\079\018\116\051\017\034\018\116\051\017\051\018\116\034\035\028\035\093\017\045\116\035\017\028\018\116\051\017\008\034\018\028\051\017\034\116\017\037\008\047\091\017\100\035\028\035\124\018\019\035\017\035\043\017\051\018\028\017\044\032\008\116\073\073\035\116\113\014"), 
		Media = _96r7, 
		Buttons = {
			_hbQ("\098\116\035\051\043\085\018\028\038\038\038")
		}, 
		Callback = function(action)
			if action ~= nil then
				_Urwigo.RunDialogs(function()
					Wherigo.GetInput(_FS55u)
				end)
			end
		end
	}
	_rcZu:RequestSync()
end
function _qywFO:OnEnter()
	_EdN = _hbQ("\056\045\091\015\012\050")
	Geocache:MoveTo(Player)
	_Urwigo.Dialog(false, {
		{
			Text = _hbQ("\079\018\116\051\017\035\043\035\051\017\043\018\116\043\017\019\113\035\051\017\047\035\017\124\008\017\010\035\018\044\008\044\032\035\038\017\050\028\017\044\032\035\113\044\032\035\017\116\028\017\044\018\028\043\035\028\008\028\043\017\127\085\044\113\018\017\035\028\017\032\008\116\043\017\047\089\116\028\017\019\018\043\035\008\116\017\047\035\017\124\008\017\044\124\018\043\116\113\035\017\095\034\018\085\113\017\124\089\085\062\008\010\035\033\038\017\006\028\017\008\043\043\113\085\058\116\043\017\101\085\034\035\113\028\008\124\017\035\042\085\051\043\035\038\038\038"), 
			Media = _qb0u, 
			Buttons = {
				_hbQ("\029\008\044\032\035\017\043\113\018\116\034\035\035\014\014\014")
			}
		}
	}, function(action)
		Wherigo.ShowScreen(Wherigo.DETAILSCREEN, Geocache)
	end)
end
function TB2:OnEnter()
	_EdN = _hbQ("\031\115\122")
	ZFinale.Visible = true
	ZFinale.Active = true
	_Urwigo.Dialog(false, {
		{
			Text = (_hbQ("\121\044\085\017")..Player.Name).._hbQ("\038\017\084\089\008\019\019\035\124\124\035\017\079\085\113\010\085\124\038\017\003\035\019\018\028\047\035\093\038\038\038"), 
			Media = _NUCaG
		}, 
		{
			Text = (_hbQ("\121\044\085\017\079\085\113\010\085\124\038\017\084\035\017\034\018\116\051\017\035\044\018\116\043\035\017")..Player.Name).._hbQ("\038\038\038"), 
			Media = _JIJy
		}, 
		{
			Text = _hbQ("\031\018\116\043\035\051\017\124\035\051\017\019\035\113\051\018\028\028\035\051\017\051\018\028\043\017\085\028\047\035\062\028\035\051\017\035\043\017\028\018\116\051\017\008\034\018\028\051\017\085\028\051\019\035\044\043\035\017\124\035\051\017\124\085\035\116\042\038\017\079\018\043\113\035\017\085\028\043\035\113\034\035\028\043\085\018\028\017\113\008\019\085\047\035\017\008\017\019\035\113\062\085\017\047\089\035\034\085\043\035\113\017\124\035\017\019\085\113\035\038\038\038"), 
			Media = _NUCaG
		}, 
		{
			Text = _hbQ("\084\089\008\085\062\035\113\008\085\051\017\045\116\035\017\034\018\116\051\017\073\008\051\051\085\035\093\017\019\008\113\043\017\047\035\017\028\018\051\017\113\035\062\035\113\044\085\035\062\035\028\043\051\017\008\017\124\008\017\058\008\051\035\017\047\035\017\124\008\017\077\035\044\116\113\085\043\035\017\121\028\043\035\113\028\008\043\085\018\028\008\124\035\038\038\038"), 
			Media = _NUCaG
		}, 
		{
			Text = _hbQ("\115\085\035\028\017\113\035\044\116\038\017\013\018\116\051\017\028\089\008\034\018\028\051\017\073\008\085\043\017\045\116\035\017\028\018\043\113\035\017\047\035\034\018\085\113\017\047\035\017\051\116\019\019\018\113\043\017\044\085\034\085\124\038\017\029\089\035\051\043\017\028\018\043\113\035\017\062\085\051\051\085\018\028\038\038\038"), 
			Media = _JIJy
		}, 
		{
			Text = _hbQ("\012\085\113\035\073\124\091\017\035\051\043\017\113\035\034\035\028\116\017\047\008\028\051\017\124\035\017\029\008\085\051\051\018\028\017\013\116\062\035\113\018\017\107\017\008\034\035\044\017\115\113\008\085\028\051\017\008\017\051\018\028\017\058\018\113\047\038\017\013\018\116\051\017\047\035\034\018\028\051\017\085\062\062\035\047\085\008\043\035\062\035\028\043\017\113\035\019\008\113\043\085\113\017\019\018\116\113\017\035\043\113\035\017\047\085\051\019\018\028\085\058\124\035\051\017\008\017\047\089\008\116\043\113\035\051\017\062\085\051\051\085\018\028\051\038\038\038"), 
			Media = _JIJy
		}, 
		{
			Text = (_hbQ("\127\035\113\044\085\017")..Player.Name).._hbQ("\017\019\018\116\113\017\034\018\043\113\035\017\010\035\028\035\113\035\116\042\017\051\116\019\019\018\113\043\038\017\029\035\043\043\035\017\062\085\051\051\085\018\028\017\028\089\008\116\113\008\085\043\017\019\008\051\017\113\035\116\051\051\085\035\017\051\008\028\051\017\034\018\116\051\038\038\038"), 
			Media = _JIJy
		}, 
		{
			Text = _hbQ("\079\035\116\085\124\035\093\017\034\018\116\051\017\113\035\028\047\113\035\017\008\017\124\008\017\096\018\028\035\017\012\085\028\008\124\035\017\019\018\116\113\017\047\035\010\008\010\035\113\017\124\089\008\085\113\035\017\047\089\035\028\034\018\124\038\017\037\035\051\017\044\018\018\113\047\018\028\028\035\035\051\017\051\018\028\043\017\047\008\028\051\017\034\018\043\113\035\017\008\019\019\008\113\035\085\124\038\038\038"), 
			Media = _JIJy
		}, 
		{
			Text = _hbQ("\079\085\113\010\085\124\017\008\017\077\044\018\043\043\038\017\072\051\043\039\044\035\017\045\116\035\017\043\116\017\062\035\017\113\035\044\018\085\051\014"), 
			Media = _JIJy
		}, 
		{
			Text = _hbQ("\084\035\017\043\035\017\113\035\044\018\085\051\017\058\085\035\028\017\079\085\113\010\085\124\038\017\100\116\085\051\045\116\035\017\124\008\017\062\085\051\051\085\018\028\017\035\051\043\017\043\035\113\062\085\028\035\035\087\017\043\116\017\019\035\116\042\017\113\035\010\008\010\028\035\113\017\124\008\017\115\008\051\035\038\017\084\035\017\113\035\019\008\113\043\085\113\008\085\017\008\116\051\051\085\043\018\043\017\035\043\017\019\113\035\034\085\035\028\047\113\008\085\017\084\018\032\028\017\035\043\017\124\008\017\115\008\051\035\017\047\035\017\124\008\017\073\085\028\017\047\035\017\124\008\017\062\085\051\051\085\018\028\038\017\079\035\116\085\124\124\035\093\017\047\035\010\008\010\035\113\017\124\008\017\093\018\028\035\017\047\089\035\028\034\018\124\038\038\038"), 
			Media = _3h4R, 
			Buttons = {
				_hbQ("\096\018\028\035\017\012\085\028\008\124\035\038\038\038")
			}
		}
	}, function(action)
		Wherigo.ShowScreen(Wherigo.DETAILSCREEN, ZFinale)
	end)
end
function TB2:OnExit()
	_EdN = _hbQ("\031\115\122")
	--[[Placer le son Retro-fusee ci-dessous.]]
	Wherigo.PlayAudio(_Fn7rW)
	TB2.Active = false
	TB2.Visible = false
	Player:MoveTo(ZFinale)
	_Urwigo.Dialog(false, {
		{
			Text = _hbQ("\121\044\085\017\077\044\018\043\043\038\017\084\089\008\019\019\035\124\124\035\017\031\032\116\028\047\035\113\058\085\113\047\017\030\038\017\072\051\043\039\044\035\017\045\116\035\017\043\116\017\062\035\017\113\035\044\018\085\051\017\084\018\032\028\014"), 
			Media = _3h4R
		}, 
		{
			Text = _hbQ("\121\044\085\017\031\032\116\028\047\035\113\058\085\113\047\017\030\038\017\084\035\017\043\089\035\044\018\116\043\035\017\077\044\018\043\043\038\038\038"), 
			Media = _oxPVF
		}, 
		{
			Text = _hbQ("\079\085\113\010\085\124\017\035\051\043\017\019\113\035\051\035\028\043\035\062\035\028\043\017\035\028\017\113\018\116\043\035\017\034\035\113\051\017\124\008\017\115\008\051\035\017\035\043\017\103\035\017\062\089\008\019\019\113\035\043\035\017\008\017\073\008\085\113\035\017\047\035\017\062\035\062\035\038\017\072\051\043\039\044\035\017\045\116\035\017\043\116\017\019\035\116\042\017\008\028\028\018\028\044\035\113\017\028\018\043\113\035\017\113\035\043\018\116\113\014"), 
			Media = _3h4R
		}, 
		{
			Text = _hbQ("\115\085\035\028\017\113\035\044\116\017\077\044\018\043\043\038\017\084\035\017\019\113\035\034\085\035\028\051\017\124\008\017\115\008\051\035\017\085\062\062\035\047\085\008\043\035\062\035\028\043\038\038\038"), 
			Media = _oxPVF
		}, 
		{
			Text = _hbQ("\031\032\116\028\047\035\113\058\085\113\047\017\030\017\008\017\124\008\017\115\008\051\035\038\017\072\051\043\039\044\035\017\045\116\035\017\034\018\116\051\017\062\035\017\113\035\044\035\034\035\093\014"), 
			Media = _oxPVF
		}, 
		{
			Text = _hbQ("\115\008\051\035\017\047\035\017\124\008\017\077\035\044\116\113\085\043\035\017\121\028\043\035\113\028\008\043\085\018\028\008\124\035\017\008\017\031\032\116\028\047\035\113\058\085\113\047\017\030\038\017\029\018\062\062\035\028\043\017\035\051\043\039\044\035\017\045\116\035\017\124\035\017\043\018\116\043\017\051\089\035\051\043\017\019\008\051\051\035\017\084\018\032\028\014"), 
			Media = _aJI
		}, 
		{
			Text = (_hbQ("\031\018\116\043\017\035\051\043\017\113\035\028\043\113\035\017\047\008\028\051\017\124\089\018\113\047\113\035\038\017\037\035\051\017\034\085\044\043\085\062\035\051\017\018\028\043\017\035\043\035\017\051\035\044\018\116\113\116\035\051\017\035\043\017")..Player.Name).._hbQ("\017\051\089\018\044\044\116\019\035\017\047\035\017\047\035\062\008\028\047\035\113\017\008\116\042\017\008\116\043\018\113\085\043\035\051\017\044\085\034\085\124\035\051\017\047\089\008\044\032\035\034\035\113\017\124\035\017\043\113\008\034\008\085\124\038\038\038"), 
			Media = _oxPVF
		}, 
		{
			Text = _hbQ("\072\042\044\035\124\124\035\028\043\035\051\017\028\018\116\034\035\124\124\035\051\038\017\029\089\035\051\043\017\043\018\116\103\018\116\113\051\017\116\028\017\019\124\008\085\051\085\113\017\047\035\017\034\018\085\113\017\045\116\035\017\028\018\043\113\035\017\062\085\051\051\085\018\028\017\035\051\043\017\008\044\044\018\062\019\124\085\035\038\017\115\035\008\116\017\043\113\008\034\008\085\124\017\124\035\051\017\010\008\113\044\018\028\051\038\038\038"), 
			Media = _aJI
		}
	}, function(action)
		_Urwigo.Dialog(false, {
			{
				Text = _hbQ("\079\018\085\124\008\017\045\116\085\017\062\035\043\017\073\085\028\017\008\017\124\008\017\062\085\051\051\085\018\028\017\047\035\017\051\008\116\034\035\043\008\010\035\017\035\028\017\044\018\062\019\008\010\028\085\035\017\047\035\051\017\034\008\124\035\116\113\035\116\042\017\062\035\062\058\113\035\051\017\047\035\017\124\008\017\077\035\044\116\113\085\043\035\017\121\028\043\035\113\028\008\043\085\018\028\008\124\035\038\038\038"), 
				Media = _96r7
			}, 
			{
				Text = _hbQ("\031\018\116\043\017\044\035\124\008\017\035\051\043\017\058\085\035\028\017\051\116\113\017\116\028\035\017\032\085\051\043\018\085\113\035\017\047\035\017\073\085\044\043\085\018\028\017\035\043\017\019\113\035\043\035\042\043\035\017\008\017\044\032\035\113\044\032\035\113\017\035\043\017\043\113\018\116\034\035\113\017\116\028\035\017\010\035\018\044\008\044\032\035\038\017\127\008\085\051\017\008\034\008\028\043\087\017\113\035\028\047\018\028\051\039\028\018\116\051\017\008\017\124\008\038\038\038"), 
				Media = _96r7
			}, 
			{
				Text = _hbQ("\096\018\028\035\017\012\085\028\008\124\035\038\038"), 
				Media = _96r7, 
				Buttons = {
					_hbQ("\096\018\028\035\017\012\085\028\008\124\035\038\038\038")
				}
			}
		}, function(action)
			Wherigo.ShowScreen(Wherigo.DETAILSCREEN, ZFinale)
			_rcZu:RequestSync()
		end)
	end)
end
function ZFinale:OnEnter()
	_EdN = _hbQ("\096\012\085\028\008\124\035")
	Env_Platform_1 = Env.Platform
	Env_Platform_2 = tostring(string.lower(string.sub(Env_Platform_1, 1, 4)))
	if (((Wherigo.NoCaseEquals(Env_Platform_2, _hbQ("\034\035\028\047")) or Wherigo.NoCaseEquals(Env_Platform_2, _hbQ("\085\019\032\018"))) or Wherigo.NoCaseEquals(Env_Platform_2, _hbQ("\008\028\047\113"))) or Wherigo.NoCaseEquals(Env_Platform_2, _hbQ("\062\085\047\019"))) or Wherigo.NoCaseEquals(Env_Platform_2, _hbQ("\015\073\038\019")) then
		_qywFO.Active = true
		_qywFO.Visible = true
		Geocache.Visible = true
		Geocache:MoveTo(Player)
		Geocache.Commands._G5VFx.Enabled = true
		Geocache.Commands._CjR.Enabled = true
		Geocache.Commands._j1re.Enabled = true
		_Urwigo.Dialog(false, {
			{
				Text = _hbQ("\084\089\008\085\017\019\124\008\044\035\017\124\089\085\043\035\062\017\123\035\018\044\008\044\032\035\017\047\008\028\051\017\124\089\121\028\034\035\028\043\008\085\113\035\017\047\035\017\034\018\043\113\035\017\008\019\019\008\113\035\085\124\038\017\037\018\113\051\045\116\035\017\034\018\116\051\017\124\089\035\042\008\062\085\028\035\113\035\093\087\017\034\018\116\051\017\008\116\113\035\093\017\107\017\018\019\043\085\018\028\051\038\038\038"), 
				Media = _96r7
			}, 
			{
				Text = _hbQ("\079\018\116\051\017\019\018\116\034\035\093\017\062\008\085\028\043\035\028\008\028\043\017\034\018\116\051\017\113\035\028\047\113\035\017\008\017\124\008\017\010\035\018\044\008\044\032\035\038\038\038"), 
				Media = _96r7
			}, 
			{
				Text = (_hbQ("\037\008\017\047\085\051\043\008\028\044\035\017\019\018\116\113\017\034\018\116\051\017\113\035\028\047\113\035\017\008\017\124\008\017\010\035\018\044\008\044\032\035\017\035\051\043\017\047\035\017")..Wherigo.VectorToPoint(Player.ObjectLocation, _qywFO.OriginalPoint):GetValue "m").._hbQ("\017\062\035\043\113\035\051\038"), 
				Media = Exclamation
			}, 
			{
				Text = _hbQ("\072\042\044\035\124\124\035\028\043\112\017\084\089\008\043\043\035\028\047\008\085\051\017\044\035\043\017\035\034\035\028\035\062\035\028\043\017\008\034\035\044\017\085\062\019\008\043\085\035\028\044\035\038\038\038"), 
				Media = _NUCaG, 
				Buttons = {
					_hbQ("\096\018\028\035\017\123\035\018\044\008\044\032\035\038\038\038")
				}
			}
		}, function(action)
			Wherigo.ShowScreen(Wherigo.DETAILSCREEN, _qywFO)
		end)
	else
		_ERUV.Active = true
		_ERUV.Visible = true
		FausseCache.Visible = true
		FausseCache:MoveTo(Player)
		FausseCache.Commands._g9g.Enabled = true
		FausseCache.Commands._Gjw9b.Enabled = true
		FausseCache.Commands._J1N.Enabled = true
		_Urwigo.Dialog(false, {
			{
				Text = _hbQ("\084\089\008\085\017\019\124\008\044\035\017\124\089\085\043\035\062\017\123\035\018\044\008\044\032\035\017\047\008\028\051\017\124\089\121\028\034\035\028\043\008\085\113\035\017\047\035\017\034\018\043\113\035\017\008\019\019\008\113\035\085\124\038\017\037\018\113\051\045\116\035\017\034\018\116\051\017\124\089\035\042\008\062\085\028\035\113\035\093\087\017\034\018\116\051\017\008\116\113\035\093\017\107\017\018\019\043\085\018\028\051\038\038\038"), 
				Media = _96r7
			}, 
			{
				Text = _hbQ("\079\018\116\051\017\019\018\116\034\035\093\017\062\008\085\028\043\035\028\008\028\043\017\034\018\116\051\017\113\035\028\047\113\035\017\008\017\124\008\017\010\035\018\044\008\044\032\035\038\038\038"), 
				Media = _96r7
			}, 
			{
				Text = (_hbQ("\037\008\017\047\085\051\043\008\028\044\035\017\019\018\116\113\017\034\018\116\051\017\113\035\028\047\113\035\017\008\017\124\008\017\010\035\018\044\008\044\032\035\017\035\051\043\017\047\035\017")..Wherigo.VectorToPoint(Player.ObjectLocation, _ERUV.OriginalPoint):GetValue "m").._hbQ("\017\062\035\043\113\035\051\038"), 
				Media = Exclamation
			}, 
			{
				Text = _hbQ("\072\042\044\035\124\124\035\028\043\112\017\084\089\008\043\043\035\028\047\008\085\051\017\044\035\043\017\035\034\035\028\035\062\035\028\043\017\008\034\035\044\017\085\062\019\008\043\085\035\028\044\035\038\038\038"), 
				Media = _NUCaG, 
				Buttons = {
					_hbQ("\096\018\028\035\017\123\035\018\044\008\044\032\035\038\038\038")
				}
			}
		}, function(action)
			Wherigo.ShowScreen(Wherigo.DETAILSCREEN, _ERUV)
		end)
	end
end
function ZFinale:OnExit()
	_EdN = _hbQ("\096\012\085\028\008\124\035")
	ZFinale.Active = false
	ZFinale.Visible = false
	_rcZu:RequestSync()
end
function ZAbri:OnEnter()
	_EdN = _hbQ("\096\060\058\113\085")
	--[[Placer le son Explosion ci-dessous.]]
	Wherigo.PlayAudio(_o3E)
	_yVP0D.Complete = true
	ZVictimes.Active = true
	ZVictimes.Visible = true
	_Urwigo.Dialog(false, {
		{
			Text = _hbQ("\079\018\085\124\008\112\017\037\089\085\028\044\035\028\047\085\035\017\035\051\043\017\062\008\085\043\113\085\051\035\038\017\084\035\017\034\008\085\051\017\047\035\062\035\116\113\035\113\017\035\028\017\019\124\008\044\035\017\019\018\116\113\017\051\116\113\034\035\085\124\124\035\113\038\038\038"), 
			Media = _zHB
		}, 
		{
			Text = _hbQ("\079\035\116\085\124\124\035\093\017\062\008\085\028\043\035\028\008\028\043\017\034\018\116\051\017\047\085\113\085\010\035\113\017\034\035\113\051\017\124\008\017\096\018\028\035\017\018\116\017\051\035\017\043\113\018\116\034\035\028\043\017\124\035\051\017\034\085\044\043\085\062\035\051\038\017\084\035\017\034\018\116\051\017\008\085\017\035\028\034\018\091\035\017\124\035\051\017\044\018\018\113\047\018\028\028\035\035\051\017\047\008\028\051\017\034\018\043\113\035\017\008\019\019\124\085\044\008\043\085\018\028\038\038\038"), 
			Media = _eddAO, 
			Buttons = {
				_hbQ("\096\018\028\035\017\047\035\051\017\034\085\044\043\085\062\035\051\038\038\038")
			}
		}
	}, function(action)
		Wherigo.ShowScreen(Wherigo.DETAILSCREEN, ZVictimes)
	end)
end
function ZAbri:OnExit()
	_EdN = _hbQ("\096\060\058\113\085")
	ZAbri.Active = false
	ZAbri.Visible = false
	_rcZu:RequestSync()
end
function _ERUV:OnEnter()
	_EdN = _hbQ("\056\072\003\006\079")
	_Urwigo.Dialog(false, {
		{
			Text = _hbQ("\079\018\116\051\017\035\043\035\051\017\043\018\116\043\017\019\113\035\051\017\047\035\017\124\008\017\010\035\018\044\008\044\032\035\038\017\050\028\017\044\032\035\113\044\032\035\017\116\028\017\044\018\028\043\035\028\008\028\043\017\127\085\044\113\018\038\017\006\028\017\008\043\043\113\085\058\116\043\017\101\085\034\035\113\028\008\124\017\035\042\085\051\043\035\038\038\038"), 
			Media = _A9fXS, 
			Buttons = {
				_hbQ("\029\008\044\032\035\017\043\113\018\116\034\035\035\014\014\014")
			}
		}
	}, function(action)
		Wherigo.ShowScreen(Wherigo.DETAILSCREEN, FausseCache)
	end)
end
function _FS55u:OnGetInput(input)
	if input == nil then
		input = ""
	end
	_XUv = input
	if Wherigo.NoCaseEquals(_XUv, _hbQ("\037\008\017\012\018\116\085\028\035")) then
		--[[Inserer le son Tadam ci-dessous.]]
		Wherigo.PlayAudio(_FOw)
		_Urwigo.MessageBox{
			Text = _hbQ("\115\018\028\028\035\017\113\035\019\018\028\051\035\112\017\029\018\028\043\085\028\116\018\028\051\017\028\018\043\113\035\017\032\085\051\043\018\085\113\035\038\038\038"), 
			Media = _r8PPn, 
			Buttons = {
				_hbQ("\031\032\116\028\047\035\113\058\085\113\047\017\122\038\038\038")
			}, 
			Callback = function(action)
				if action ~= nil then
					Wherigo.ShowScreen(Wherigo.DETAILSCREEN, TB2)
				end
			end
		}
	else
		--[[Inserer le son PouettePouette ci-dessous.]]
		Wherigo.PlayAudio(_QlWB)
		_Urwigo.MessageBox{
			Text = _hbQ("\101\116\062\062\038\038\038\017\029\035\017\028\089\035\051\043\017\019\008\051\017\124\008\017\058\018\028\028\035\017\113\035\019\018\028\051\035\038\017\074\028\058\051\019\106\072\051\051\008\091\035\093\017\008\017\028\018\116\034\035\008\116\038\038\038"), 
			Media = _SMG, 
			Buttons = {
				_hbQ("\003\035\044\018\062\062\035\028\044\035\113\038\038\038")
			}, 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.RunDialogs(function()
						Wherigo.GetInput(_FS55u)
					end)
				end
			end
		}
	end
end
function Geocache:On_G5VFx(target)
	if _G[_EdN] == _qywFO then
		--[[Placer le son Tadam ci-dessous.]]
		Wherigo.PlayAudio(_FOw)
		_Urwigo.Dialog(false, {
			{
				Text = _hbQ("\079\018\116\051\017\008\034\035\093\017\043\113\018\116\034\035\017\116\028\017\044\018\028\043\035\028\008\028\043\017\047\035\017\043\008\085\124\124\035\017\127\085\044\113\018\017\019\113\035\051\017\047\116\017\019\018\043\035\008\116\017\047\035\017\124\008\017\044\124\018\043\116\113\035\014"), 
				Media = _qb0u
			}, 
			{
				Text = _hbQ("\012\035\124\085\044\085\043\008\043\085\018\028\051\112\112\112"), 
				Media = _r8PPn
			}, 
			{
				Text = _hbQ("\079\018\085\044\085\017\034\018\043\113\035\017\044\124\035\073\017\047\035\017\047\035\058\124\018\045\116\008\010\035\038\017\079\018\116\051\017\028\089\008\034\035\093\017\019\008\051\017\008\017\124\035\017\019\113\035\028\047\113\035\017\035\028\017\028\018\043\035\038\017\121\124\017\047\035\062\035\116\113\035\113\008\017\047\008\028\051\017\124\008\017\077\035\044\043\085\018\028\017\104\121\028\034\035\028\043\008\085\113\035\104\017\047\116\017\103\035\116\038\017\037\035\017\034\018\085\044\085\086\017\108\115\003\065\017")..string.sub(Player.CompletionCode, 1, 15), 
				Media = _xGr5
			}, 
			{
				Text = _hbQ("\029\035\017\044\018\047\035\017\034\018\116\051\017\019\035\113\062\035\043\043\113\008\017\047\089\018\058\043\035\028\085\113\017\116\028\017\077\043\008\043\116\043\017\104\029\018\062\019\124\035\043\035\047\104\017\047\008\028\051\017\070\032\035\113\085\010\018\038\044\018\062\017\051\085\017\034\018\116\051\017\124\035\017\047\035\051\085\113\035\093\038\038\038"), 
				Media = _xGr5
			}, 
			{
				Text = _hbQ("\037\035\017\077\043\008\043\116\043\017\104\029\018\062\019\124\035\043\035\047\104\017\019\035\116\043\017\008\116\051\051\085\017\035\043\113\035\017\018\058\043\035\028\116\017\035\028\017\043\035\124\035\034\035\113\051\008\028\043\017\124\035\017\073\085\044\032\085\035\113\017\027\038\123\070\077\017\047\008\028\051\017\070\032\035\113\085\010\018\038\044\018\062\038\017\029\035\017\073\085\044\032\085\035\113\017\008\017\035\043\035\017\008\116\043\018\062\008\043\085\045\116\035\062\035\028\043\017\010\035\028\035\113\035\017\047\008\028\051\017\034\018\043\113\035\017\113\035\019\035\113\043\018\085\113\035\017\070\032\035\113\085\010\018\111\077\008\034\035\051\017\047\035\017\034\018\043\113\035\017\123\100\077\087\017\124\035\017\044\008\051\017\035\044\032\035\008\028\043\038\038\038"), 
				Media = _96r7
			}, 
			{
				Text = _hbQ("\127\035\113\044\085\017\047\089\008\034\018\085\113\017\103\018\116\035\017\044\035\043\043\035\017\070\032\035\113\085\010\018\038\017\084\089\035\051\019\035\113\035\017\045\116\035\017\034\018\116\051\017\008\034\035\093\017\008\019\019\113\035\044\085\035\112"), 
				Media = _96r7, 
				Buttons = {
					_hbQ("\072\044\113\008\028\017\019\113\085\028\044\085\019\008\124\038\038\038")
				}
			}
		}, function(action)
			_0EYl.Visible = true
			_0EYl.Description = _0EYl.Description..string.sub(Player.CompletionCode, 1, 15)
			_0EYl:MoveTo(Player)
			_lUAJ.Complete = true
			_rcZu.Complete = true
			Wherigo.ShowScreen(Wherigo.MAINSCREEN)
			_rcZu:RequestSync()
		end)
	else
		--[[Placer le son PouettePouette ci-dessous.]]
		Wherigo.PlayAudio(_QlWB)
		_Urwigo.MessageBox{
			Text = _hbQ("\121\124\017\028\089\091\017\008\017\113\085\035\028\017\008\017\043\113\018\116\034\035\113\017\085\044\085\038\017\079\018\116\051\017\047\035\034\035\093\017\035\043\113\035\017\047\008\028\051\017\096\018\028\035\017\047\035\017\123\035\018\044\008\044\032\035\017\019\018\116\113\017\116\043\085\124\085\051\035\113\017\044\035\043\017\121\043\035\062\038"), 
			Media = _SMG, 
			Buttons = {
				_hbQ("\003\035\043\018\116\113\038\038\038")
			}, 
			Callback = function(action)
				if action ~= nil then
					Wherigo.ShowScreen(Wherigo.MAINSCREEN)
				end
			end
		}
	end
end
function Geocache:On_CjR(target)
	if _G[_EdN] == _qywFO then
		--[[Inserer Son PouettePouette ci-dessous.]]
		Wherigo.PlayAudio(_QlWB)
		_Urwigo.MessageBox{
			Text = _hbQ("\101\116\062\062\038\038\038\017\044\089\035\051\043\017\035\062\058\035\043\008\028\043\038\017\074\028\058\051\019\106\037\035\051\017\035\073\073\018\113\043\051\017\051\018\028\043\017\051\018\116\034\035\028\043\017\113\035\044\018\062\019\035\028\051\035\051\038\017\029\032\035\113\044\032\035\093\017\008\017\028\018\116\034\035\008\116\017\051\085\017\034\018\116\051\017\124\035\017\034\018\116\124\035\093\038\017\003\035\010\008\113\047\035\093\017\124\008\017\044\124\018\043\116\113\035\087\017\124\035\017\044\018\028\043\035\028\008\028\043\017\035\051\043\017\019\113\035\051\017\047\035\017\124\008\017\043\035\043\035\017\047\089\116\028\017\019\018\043\035\008\116\038\017\077\085\028\018\028\087\017\044\032\018\085\051\085\051\051\035\093\017\124\089\018\019\043\085\018\028\017\060\058\008\028\047\018\028\028\035\113\038\038\038"), 
			Media = _SMG, 
			Buttons = {
				_hbQ("\029\032\035\113\044\032\035\113\038\038\038")
			}, 
			Callback = function(action)
				if action ~= nil then
					Wherigo.ShowScreen(Wherigo.DETAILSCREEN, Geocache)
				end
			end
		}
	else
		_Urwigo.MessageBox{
			Text = _hbQ("\079\018\116\051\017\028\035\017\019\018\116\034\035\093\017\019\008\051\017\019\113\035\043\035\028\047\113\035\017\045\116\035\017\124\008\017\010\035\018\044\008\044\032\035\017\035\051\043\017\085\028\043\113\018\116\034\008\058\124\035\017\051\008\028\051\017\124\089\008\034\018\085\113\017\044\032\035\113\044\032\035\035\038\017\079\018\116\051\017\047\035\034\035\093\017\035\043\113\035\017\047\008\028\051\017\124\008\017\096\018\028\035\017\047\035\017\123\035\018\044\008\044\032\035\017\019\018\116\113\017\116\043\085\124\085\051\035\113\017\044\035\043\017\018\019\043\085\018\028\038\038\038"), 
			Media = _SMG, 
			Callback = function(action)
				if action ~= nil then
					Wherigo.ShowScreen(Wherigo.MAINSCREEN)
				end
			end
		}
	end
end
function Geocache:On_j1re(target)
	if _G[_EdN] == _qywFO then
		_Urwigo.Dialog(false, {
			{
				Text = _hbQ("\097\035\051\018\124\035\017\045\116\035\017\034\018\116\051\017\028\089\008\091\035\093\017\019\008\051\017\043\113\018\116\034\035\017\124\008\017\010\035\018\044\008\044\032\035\038\017\006\028\035\017\051\008\116\034\035\010\008\113\047\035\017\008\116\043\018\062\008\043\085\045\116\035\062\035\028\043\017\051\035\113\008\017\073\008\085\043\035\017\124\018\113\051\045\116\035\017\034\018\116\051\017\045\116\085\043\043\035\113\035\093\017\124\035\017\103\035\116\038\017\079\018\116\051\017\019\018\116\113\113\035\093\017\113\035\034\035\028\085\113\017\019\124\116\051\017\043\008\113\047\017\051\085\017\034\018\116\051\017\124\035\017\047\035\051\085\113\035\093\038\038\038"), 
				Media = _96r7, 
				Buttons = {
					_hbQ("\060\116\017\113\035\034\018\085\113\038\038\038")
				}
			}
		}, function(action)
			Wherigo.ShowScreen(Wherigo.MAINSCREEN)
			_rcZu:RequestSync()
		end)
	else
		_Urwigo.MessageBox{
			Text = _hbQ("\079\018\116\051\017\028\035\017\019\018\116\034\035\093\017\019\008\051\017\008\058\008\028\047\018\028\028\035\113\017\051\008\028\051\017\008\034\018\085\113\017\044\032\035\113\044\032\035\038\108\115\003\065\079\018\116\051\017\047\035\034\035\093\017\008\116\051\051\085\017\035\043\113\035\017\047\008\028\051\017\124\008\017\096\018\028\035\017\047\035\017\124\008\017\123\035\018\044\008\044\032\035\017\019\018\116\113\017\044\032\018\085\051\085\113\017\044\035\043\043\035\017\018\019\043\085\018\028\038\038\038"), 
			Media = _SMG, 
			Callback = function(action)
				if action ~= nil then
					Wherigo.ShowScreen(Wherigo.MAINSCREEN)
				end
			end
		}
	end
end
function PatNitro:On_CAY0(target)
	if _G[_EdN] == Firefly then
		_Urwigo.MessageBox{
			Text = _hbQ("\012\035\124\085\044\085\043\008\043\085\018\028\051\112\017\074\028\058\051\019\106\079\018\116\051\017\008\034\035\093\017\124\008\017\100\008\043\035\017\047\035\017\013\085\043\113\018\017\035\028\017\062\008\085\028\051\038\017\060\124\124\035\093\017\062\008\085\028\043\035\028\008\028\043\017\124\089\085\028\051\043\008\124\124\035\113\017\008\017\124\089\008\034\008\028\043\017\047\116\017\019\008\113\035\039\073\035\116\017\047\035\017\012\085\113\035\073\124\091\038\017\079\018\116\051\017\091\017\043\113\018\116\034\035\113\035\093\017\116\028\017\047\085\051\019\018\051\085\043\085\073\017\047\035\017\043\035\124\035\039\047\035\043\018\028\008\043\085\018\028\017\045\116\085\017\035\051\043\017\043\113\035\051\017\113\035\044\018\028\028\008\085\051\051\008\058\124\035\038\038\038"), 
			Media = _r8PPn, 
			Buttons = {
				_hbQ("\121\028\051\043\008\124\124\035\113\017\013\085\043\113\018\038\038\038")
			}, 
			Callback = function(action)
				if action ~= nil then
					PatNitro.Commands._CAY0.Enabled = false
					PatNitro.Commands._3vY4.Enabled = true
					_bSvWd.Complete = true
					Wherigo.ShowScreen(Wherigo.DETAILSCREEN, PatNitro)
				end
			end
		}
	else
		_Urwigo.MessageBox{
			Text = _hbQ("\079\018\116\051\017\028\089\035\043\035\051\017\019\008\051\017\047\008\028\051\017\124\008\017\058\018\028\028\035\017\093\018\028\035\038\017\079\018\116\051\017\047\035\034\035\093\017\035\043\113\035\017\047\008\028\051\017\124\008\017\093\018\028\035\017\012\085\113\035\073\124\091\017\019\018\116\113\017\116\043\085\124\085\051\035\113\017\044\035\043\017\121\043\035\062\038"), 
			Media = _SMG, 
			Buttons = {
				_hbQ("\003\035\043\018\116\113\038\038\038")
			}, 
			Callback = function(action)
				if action ~= nil then
					Wherigo.ShowScreen(Wherigo.MAINSCREEN)
				end
			end
		}
	end
end
function PatNitro:On_3vY4(target)
	if _bSvWd.Complete == true then
		_Urwigo.MessageBox{
			Text = _hbQ("\012\035\124\085\044\085\043\008\043\085\018\028\051\112\017\037\008\017\013\085\043\113\018\017\035\051\043\017\035\028\017\019\124\008\044\035\038\017\097\085\113\085\010\035\093\039\034\018\116\051\017\032\018\113\051\017\047\035\017\124\008\017\093\018\028\035\017\012\085\113\035\073\124\091\017\035\043\017\051\116\113\034\035\085\124\124\035\093\017\062\035\051\017\085\028\051\043\113\116\044\043\085\018\028\051\017\008\017\124\089\035\044\113\008\028\017\047\035\017\034\018\043\113\035\017\008\019\019\008\113\035\085\124\038\017\037\008\017\047\085\113\035\044\043\085\018\028\017\045\116\035\017\034\018\116\051\017\019\113\035\028\047\113\035\093\017\028\089\035\051\043\017\019\008\051\017\085\062\019\018\113\043\008\028\043\035\038\017\060\034\008\028\044\035\093\017\018\116\017\113\035\044\116\124\035\093\017\051\116\113\017\124\035\017\051\035\028\043\085\035\113\038\038\038"), 
			Media = _r8PPn, 
			Buttons = {
				_hbQ("\077\018\113\043\085\035\017\047\035\017\096\018\028\035\038\038\038")
			}, 
			Callback = function(action)
				if action ~= nil then
					_gCW9.Complete = true
					PatNitro.Commands._3vY4.Enabled = false
					Wherigo.ShowScreen(Wherigo.MAINSCREEN)
				end
			end
		}
	else
		_Urwigo.MessageBox{
			Text = _hbQ("\101\116\062\062\038\017\079\018\116\051\017\047\035\034\035\093\017\035\043\113\035\017\047\008\028\051\017\124\008\017\096\018\028\035\017\012\085\113\035\073\124\091\017\072\031\017\008\034\018\085\113\017\019\113\085\051\017\124\008\017\013\085\043\113\018\017\008\034\008\028\043\017\047\035\017\124\089\085\028\051\043\008\124\124\035\113\038\017\060\124\124\035\093\017\034\035\113\051\017\124\008\017\096\018\028\035\017\012\085\113\035\073\124\091\038\038\038"), 
			Media = _SMG, 
			Callback = function(action)
				if action ~= nil then
					Wherigo.ShowScreen(Wherigo.DETAILSCREEN, PatNitro)
				end
			end
		}
	end
end
function FausseCache:On_g9g(target)
	if _G[_EdN] == _ERUV then
		--[[Placer le son Tadam ci-dessous.]]
		Wherigo.PlayAudio(_FOw)
		_Urwigo.Dialog(false, {
			{
				Text = _hbQ("\079\018\116\051\017\008\034\035\093\017\043\113\018\116\034\035\017\116\028\017\044\018\028\043\035\028\008\028\043\017\047\035\017\043\008\085\124\124\035\017\127\085\044\113\018\014"), 
				Media = _96r7
			}, 
			{
				Text = _hbQ("\012\035\124\085\044\085\043\008\043\085\018\028\051\112\112\112"), 
				Media = _r8PPn
			}, 
			{
				Text = _hbQ("\079\018\085\044\085\017\034\018\043\113\035\017\044\124\035\073\017\047\035\017\047\035\058\124\018\045\116\008\010\035\038\017\079\018\116\051\017\028\089\008\034\035\093\017\019\008\051\017\008\017\124\035\017\019\113\035\028\047\113\035\017\035\028\017\028\018\043\035\038\017\121\124\017\047\035\062\035\116\113\035\113\008\017\047\008\028\051\017\124\008\017\077\035\044\043\085\018\028\017\104\121\028\034\035\028\043\008\085\113\035\104\017\047\116\017\103\035\116\038\017\037\035\017\034\018\085\044\085\086\017\108\115\003\065\017")..string.sub(Player.CompletionCode, 1, 15), 
				Media = _xGr5
			}, 
			{
				Text = _hbQ("\029\035\017\044\018\047\035\017\034\018\116\051\017\019\035\113\062\035\043\043\113\008\017\047\089\018\058\043\035\028\085\113\017\116\028\017\077\043\008\043\116\043\017\104\029\018\062\019\124\035\043\035\047\104\017\047\008\028\051\017\070\032\035\113\085\010\018\038\044\018\062\017\051\085\017\034\018\116\051\017\124\035\017\047\035\051\085\113\035\093\038\038\038"), 
				Media = _xGr5
			}, 
			{
				Text = _hbQ("\037\035\017\077\043\008\043\116\043\017\104\029\018\062\019\124\035\043\035\047\104\017\019\035\116\043\017\008\116\051\051\085\017\035\043\113\035\017\018\058\043\035\028\116\017\035\028\017\043\035\124\035\034\035\113\051\008\028\043\017\124\035\017\073\085\044\032\085\035\113\017\027\038\123\070\077\017\047\008\028\051\017\070\032\035\113\085\010\018\038\044\018\062\038\017\029\035\017\073\085\044\032\085\035\113\017\008\017\035\043\035\017\008\116\043\018\062\008\043\085\045\116\035\062\035\028\043\017\010\035\028\035\113\035\017\047\008\028\051\017\034\018\043\113\035\017\113\035\019\035\113\043\018\085\113\035\017\070\032\035\113\085\010\018\111\077\008\034\035\051\017\047\035\017\034\018\043\113\035\017\123\100\077\087\017\124\035\017\044\008\051\017\035\044\032\035\008\028\043\038\038\038"), 
				Media = _96r7
			}, 
			{
				Text = _hbQ("\127\035\113\044\085\017\047\089\008\034\018\085\113\017\103\018\116\035\017\044\035\043\043\035\017\070\032\035\113\085\010\018\038\017\084\089\035\051\019\035\113\035\017\045\116\035\017\034\018\116\051\017\008\034\035\093\017\008\019\019\113\035\044\085\035\112"), 
				Media = _96r7, 
				Buttons = {
					_hbQ("\072\044\113\008\028\017\019\113\085\028\044\085\019\008\124\038\038\038")
				}
			}
		}, function(action)
			_0EYl.Visible = true
			_lUAJ.Complete = true
			_0EYl.Visible = true
			_0EYl:MoveTo(Player)
			_rcZu.Complete = true
			Wherigo.ShowScreen(Wherigo.MAINSCREEN)
			_rcZu:RequestSync()
		end)
	else
		--[[Placer le son PouettePouette ci-dessous.]]
		Wherigo.PlayAudio(_QlWB)
		_Urwigo.MessageBox{
			Text = _hbQ("\121\124\017\028\089\091\017\008\017\113\085\035\028\017\008\017\043\113\018\116\034\035\113\017\085\044\085\038\017\079\018\116\051\017\047\035\034\035\093\017\035\043\113\035\017\047\008\028\051\017\096\018\028\035\017\047\035\017\123\035\018\044\008\044\032\035\017\019\018\116\113\017\116\043\085\124\085\051\035\113\017\044\035\043\017\121\043\035\062\038"), 
			Media = _SMG, 
			Buttons = {
				_hbQ("\003\035\043\018\116\113\038\038\038")
			}, 
			Callback = function(action)
				if action ~= nil then
					Wherigo.ShowScreen(Wherigo.MAINSCREEN)
				end
			end
		}
	end
end
function FausseCache:On_Gjw9b(target)
	if _G[_EdN] == _ERUV then
		--[[Inserer Son PouettePouette ci-dessous.]]
		Wherigo.PlayAudio(_QlWB)
		_Urwigo.MessageBox{
			Text = _hbQ("\101\116\062\062\038\038\038\017\044\089\035\051\043\017\035\062\058\035\043\008\028\043\038\017\074\028\058\051\019\106\037\035\051\017\035\073\073\018\113\043\051\017\051\018\028\043\017\051\018\116\034\035\028\043\017\113\035\044\018\062\019\035\028\051\035\051\038\017\029\032\035\113\044\032\035\093\017\008\017\028\018\116\034\035\008\116\017\051\085\017\034\018\116\051\017\124\035\017\034\018\116\124\035\093\038\017\077\085\028\018\028\087\017\044\032\018\085\051\085\051\051\035\093\017\124\089\018\019\043\085\018\028\017\060\058\008\028\047\018\028\028\035\113\038\038\038"), 
			Media = _SMG, 
			Buttons = {
				_hbQ("\029\032\035\113\044\032\035\113\038\038\038")
			}, 
			Callback = function(action)
				if action ~= nil then
					Wherigo.ShowScreen(Wherigo.DETAILSCREEN, FausseCache)
				end
			end
		}
	else
		_Urwigo.MessageBox{
			Text = _hbQ("\079\018\116\051\017\028\035\017\019\018\116\034\035\093\017\019\008\051\017\019\113\035\043\035\028\047\113\035\017\045\116\035\017\124\008\017\010\035\018\044\008\044\032\035\017\035\051\043\017\085\028\043\113\018\116\034\008\058\124\035\017\051\008\028\051\017\124\089\008\034\018\085\113\017\044\032\035\113\044\032\035\035\038\017\079\018\116\051\017\047\035\034\035\093\017\035\043\113\035\017\047\008\028\051\017\124\008\017\096\018\028\035\017\047\035\017\123\035\018\044\008\044\032\035\017\019\018\116\113\017\116\043\085\124\085\051\035\113\017\044\035\043\017\018\019\043\085\018\028\038\038\038"), 
			Media = _SMG, 
			Callback = function(action)
				if action ~= nil then
					Wherigo.ShowScreen(Wherigo.MAINSCREEN)
				end
			end
		}
	end
end
function FausseCache:On_J1N(target)
	if _G[_EdN] == _ERUV then
		_Urwigo.Dialog(false, {
			{
				Text = _hbQ("\097\035\051\018\124\035\017\045\116\035\017\034\018\116\051\017\028\089\008\091\035\093\017\019\008\051\017\043\113\018\116\034\035\017\124\008\017\010\035\018\044\008\044\032\035\038\017\006\028\035\017\051\008\116\034\035\010\008\113\047\035\017\008\116\043\018\062\008\043\085\045\116\035\062\035\028\043\017\051\035\113\008\017\073\008\085\043\035\017\124\018\113\051\045\116\035\017\034\018\116\051\017\045\116\085\043\043\035\113\035\093\017\124\035\017\103\035\116\038\017\079\018\116\051\017\019\018\116\113\113\035\093\017\113\035\034\035\028\085\113\017\019\124\116\051\017\043\008\113\047\017\051\085\017\034\018\116\051\017\124\035\017\047\035\051\085\113\035\093\038\038\038"), 
				Media = _96r7, 
				Buttons = {
					_hbQ("\060\116\017\113\035\034\018\085\113\038\038\038")
				}
			}
		}, function(action)
			Wherigo.ShowScreen(Wherigo.MAINSCREEN)
			_rcZu:RequestSync()
		end)
	else
		_Urwigo.MessageBox{
			Text = _hbQ("\079\018\116\051\017\028\035\017\019\018\116\034\035\093\017\019\008\051\017\008\058\008\028\047\018\028\028\035\113\017\051\008\028\051\017\008\034\018\085\113\017\044\032\035\113\044\032\035\038\108\115\003\065\079\018\116\051\017\047\035\034\035\093\017\008\116\051\051\085\017\035\043\113\035\017\047\008\028\051\017\124\008\017\096\018\028\035\017\047\035\017\124\008\017\123\035\018\044\008\044\032\035\017\019\018\116\113\017\044\032\018\085\051\085\113\017\044\035\043\043\035\017\018\019\043\085\018\028\038\038\038"), 
			Media = _SMG, 
			Callback = function(action)
				if action ~= nil then
					Wherigo.ShowScreen(Wherigo.MAINSCREEN)
				end
			end
		}
	end
end

-- Urwigo functions --
function EM_Block()
	Env_Platform_1 = Env.Platform
	Env_Platform_2 = tostring(string.lower(string.sub(Env_Platform_1, 1, 4)))
	if (((Wherigo.NoCaseEquals(Env_Platform_2, _hbQ("\034\035\028\047")) or Wherigo.NoCaseEquals(Env_Platform_2, _hbQ("\085\019\032\018"))) or Wherigo.NoCaseEquals(Env_Platform_2, _hbQ("\008\028\047\113"))) or Wherigo.NoCaseEquals(Env_Platform_2, _hbQ("\062\085\047\019"))) or Wherigo.NoCaseEquals(Env_Platform_2, _hbQ("\015\073\038\019")) then
		_qywFO.Active = true
		_qywFO.Visible = true
		Geocache:MoveTo(Player)
		Geocache.Visible = true
		Geocache.Commands._CjR.Enabled = true
		Geocache.Commands._G5VFx.Enabled = true
		Geocache.Commands._j1re.Enabled = true
		_Urwigo.Dialog(false, {
			{
				Text = _hbQ("\084\089\008\085\017\019\124\008\044\035\017\124\089\085\043\035\062\017\123\035\018\044\008\044\032\035\017\047\008\028\051\017\124\089\121\028\034\035\028\043\008\085\113\035\017\047\035\017\034\018\043\113\035\017\008\019\019\008\113\035\085\124\038\017\037\018\113\051\045\116\035\017\034\018\116\051\017\124\089\035\042\008\062\085\028\035\113\035\093\087\017\034\018\116\051\017\008\116\113\035\093\017\107\017\018\019\043\085\018\028\051\038\038\038"), 
				Media = _96r7
			}, 
			{
				Text = _hbQ("\079\018\116\051\017\019\018\116\034\035\093\017\062\008\085\028\043\035\028\008\028\043\017\034\018\116\051\017\113\035\028\047\113\035\017\008\017\124\008\017\010\035\018\044\008\044\032\035\038\038\038"), 
				Media = _96r7
			}, 
			{
				Text = _hbQ("\072\042\044\035\124\124\035\028\043\112\017\084\089\008\043\043\035\028\047\008\085\051\017\044\035\043\017\035\034\035\028\035\062\035\028\043\017\008\034\035\044\017\085\062\019\008\043\085\035\028\044\035\038\038\038"), 
				Media = _NUCaG, 
				Buttons = {
					_hbQ("\096\018\028\035\017\123\035\018\044\008\044\032\035\038\038\038")
				}
			}
		}, function(action)
			Wherigo.ShowScreen(Wherigo.DETAILSCREEN, _qywFO)
		end)
	else
		_ERUV.Active = true
		_ERUV.Visible = true
		Geocache.Visible = true
		ZFinale.Active = false
		Geocache:MoveTo(Player)
		_Urwigo.Dialog(false, {
			{
				Text = _hbQ("\084\089\008\085\017\019\124\008\044\035\017\124\089\085\043\035\062\017\123\035\018\044\008\044\032\035\017\047\008\028\051\017\124\089\121\028\034\035\028\043\008\085\113\035\017\047\035\017\034\018\043\113\035\017\008\019\019\008\113\035\085\124\038\017\037\018\113\051\045\116\035\017\034\018\116\051\017\124\089\035\042\008\062\085\028\035\113\035\093\087\017\034\018\116\051\017\008\116\113\035\093\017\107\017\018\019\043\085\018\028\051\038\038\038"), 
				Media = _96r7
			}, 
			{
				Text = _hbQ("\079\018\116\051\017\019\018\116\034\035\093\017\062\008\085\028\043\035\028\008\028\043\017\034\018\116\051\017\113\035\028\047\113\035\017\008\017\124\008\017\010\035\018\044\008\044\032\035\038\038\038"), 
				Media = _96r7
			}, 
			{
				Text = _hbQ("\072\042\044\035\124\124\035\028\043\112\017\084\089\008\043\043\035\028\047\008\085\051\017\044\035\043\017\035\034\035\028\035\062\035\028\043\017\008\034\035\044\017\085\062\019\008\043\085\035\028\044\035\038\038\038"), 
				Media = _NUCaG, 
				Buttons = {
					_hbQ("\096\018\028\035\017\123\035\018\044\008\044\032\035\038\038\038")
				}
			}
		}, function(action)
			Wherigo.ShowScreen(Wherigo.DETAILSCREEN, _ERUV)
		end)
	end
end

-- Begin user functions --
-- End user functions --
return _rcZu
