require "Wherigo"
function WWB_latin1_string (s, latin1_is_win1252)
if (WWB_utf8_extensions == nil) then
WWB_utf8_extensions = {
[0xC487] = "c";
[0xC48D] = "c";
[0xC48F] = "d";
[0xC49B] = "e";
[0xC4BA] = "l";
[0xC4BE] = "l";
[0xC584] = "n";
[0xC588] = "n";
[0xC593] = "o";
[0xC595] = "r";
[0xC599] = "r";
[0xC59B] = "s";
[0xC5A1] = "s";
[0xC5A5] = "t";
[0xC5AF] = "u";
[0xC5BA] = "z";
[0xC5BE] = "z";
[0xC486] = "C";
[0xC48C] = "C";
[0xC48E] = "D";
[0xC49A] = "E";
[0xC4B9] = "L";
[0xC4BD] = "L";
[0xC583] = "N";
[0xC587] = "N";
[0xC592] = "O";
[0xC594] = "R";
[0xC598] = "R";
[0xC59A] = "S";
[0xC5A0] = "S";
[0xC5A4] = "T";
[0xC5AE] = "U";
[0xC5B8] = "Y";
[0xC5B9] = "Z";
[0xC5BD] = "Z";
[0xE282AC] = string.char(164)
}
if (latin1_is_win1252) then
local i
local r
for i, r in pairs({
[0xE282AC] = string.char(128);
[0xE2809A] = string.char(130);
[0xC692] = string.char(131);
[0xE2809E] = string.char(132);
[0xE280A6] = string.char(133);
[0xE280A0] = string.char(134);
[0xE280A1] = string.char(135);
[0xCB86] = string.char(136);
[0xE280B0] = string.char(137);
[0xC5A0] = string.char(138);
[0xE280B9] = string.char(139);
[0xC592] = string.char(140);
[0xC5BD] = string.char(142);
[0xE28098] = string.char(145);
[0xE28099] = string.char(146);
[0xE2809C] = string.char(147);
[0xE2809D] = string.char(148);
[0xE280A2] = string.char(149);
[0xE28093] = string.char(150);
[0xE28094] = string.char(151);
[0xCB9C] = string.char(152);
[0xE284A2] = string.char(153);
[0xC5A1] = string.char(154);
[0xE280BA] = string.char(155);
[0xC593] = string.char(156);
[0xC5BE] = string.char(158);
[0xC5B8] = string.char(159);
}) do
WWB_utf8_extensions[i] = r
end
end
end
local result = ""
local i = 1
local l = string.len(s)
while (i <= l) do
local c = string.byte(s, i)
local x = '?'
if ((c == 194) or (c == 195)) then
i = i + 1
if (i <= l) then
local n = string.byte(s, i)
if (c == 195) then
n = n + 64
end
x = string.char(n)
end
elseif ((c >= 196) and (c <= 223)) then
i = i + 1
if (i <= l) then
local index = c * 256 + string.byte(s, i)
local e = WWB_utf8_extensions[index]
if (e ~= nil) then
x = e
end
end
elseif ((c >= 224) and (c <= 255)) then
i = i + 2
if (i <= l) then
local index = (c * 256 + string.byte(s, i - 1)) * 256 + string.byte(s, i)
local e = WWB_utf8_extensions[index]
if (e ~= nil) then
x = e
end
end
else
x = string.char(c)
end
result = result .. x
i = i + 1
end
return result
end
function WWB_multiplatform_string (s, latin1_devices)
if (WWB_device == nil) then
WWB_device = ""
end
if (WWB_device == "") then
local platform = "*"
if (Env and Env.Platform) then
platform = Env.Platform
end
local deviceId = "*"
if (Env and Env.DeviceID) then
deviceId = Env.DeviceID
end
WWB_localize_latin1_buttons = false
local latin1_is_win1252 = false
WWB_strings_unicode = (string.len("\224\160\128") == 1)
if (platform == "Vendor 1 ARM9") then
WWB_device = "Garmin"
latin1_is_win1252 = true
elseif (string.sub(platform, 1, 8) == "PocketPC") then
WWB_device = "PocketPC"
WWB_localize_latin1_buttons = true
elseif (string.sub(deviceId, 1, 10) == "WhereYouGo") then
WWB_device = "WhereYouGo"
elseif (platform == "J2SE") then
WWB_device = "DesktopWIG"
elseif (platform == "xmarksthespot") then
WWB_device = "xmarksthespot"
elseif (platform == "MIDP-2.0/CLDC-1.1") then
WWB_device = "OpenWIG"
elseif (string.sub(deviceId, 1, 6) == "iPhone") then
WWB_device = "iPhone"
WWB_strings_unicode = false
elseif (deviceId == "Desktop") then
WWB_device = "Emulator"
WWB_localize_latin1_buttons = true
else
WWB_device = "?"
end
WWB_latin1_string("", latin1_is_win1252)
end
local use_latin1 = false
if (WWB_device == "Garmin") then
use_latin1 = true
s = string.gsub(s, "\038amp;\038amp;", "\038amp;")
elseif (    (WWB_device == "WhereYouGo")
or (WWB_device == "OpenWIG")
or (WWB_device == "DesktopWIG")
) then
s = string.gsub(s, "\038amp;\038amp;", "\038")
s = string.gsub(s, "\060BR\062\010", "\010")
elseif (WWB_device == "iPhone") then
s = string.gsub(s, "\038amp;\038amp;", "\038amp;")
end
if (latin1_devices and latin1_devices[WWB_device]) then
use_latin1 = true
end
if (use_latin1) then
s = WWB_latin1_string(s)
end
return s
end
ZonePoint = Wherigo.ZonePoint
Distance = Wherigo.Distance
Player = Wherigo.Player

-- #Author Directives Go Here# --
-- #End Author Directives# --

cartSeoulZoo = Wherigo.ZCartridge()
WWB_current_cartridge = cartSeoulZoo
-- MessageBox Callback Functions Table used by the Builder --
cartSeoulZoo.MsgBoxCBFuncs = {}

zmediaBell = Wherigo.ZMedia(cartSeoulZoo)
zmediaBell.Id = "0ce5e738488f02eb53bfe1edd29efbbc"
zmediaBell.Name = "Bell"
zmediaBell.AltText = ""
zmediaBell.Resources = {
  { Type = "jpg", Filename = "Bell.jpg", Directives = {},}
}
zmediaCorrectAnswer = Wherigo.ZMedia(cartSeoulZoo)
zmediaCorrectAnswer.Id = "d319b2983fa39e44339b0127412f7148"
zmediaCorrectAnswer.Name = "CorrectAnswer"
zmediaCorrectAnswer.AltText = ""
zmediaCorrectAnswer.Resources = {
  { Type = "jpg", Filename = "correct.jpg", Directives = {},}
}
zmediaSeoulZoo = Wherigo.ZMedia(cartSeoulZoo)
zmediaSeoulZoo.Id = "560f1c58c738b328c67f1ff4a3dc08ad"
zmediaSeoulZoo.Name = "Seoul Zoo"
zmediaSeoulZoo.AltText = "Front of Seoul Zoo"
zmediaSeoulZoo.Resources = {
  { Type = "jpg", Filename = "Seoul Zoo.jpg", Directives = {},}
}
zmediaSpoiler = Wherigo.ZMedia(cartSeoulZoo)
zmediaSpoiler.Id = "c924f2193e630dcdca839c0d11c18141"
zmediaSpoiler.Name = "Spoiler"
zmediaSpoiler.AltText = ""
zmediaSpoiler.Resources = {
  { Type = "jpg", Filename = "Spoiler.jpg", Directives = {},}
}
zmediaWrongAnswer = Wherigo.ZMedia(cartSeoulZoo)
zmediaWrongAnswer.Id = "5ca54c843897c879f887d66180585373"
zmediaWrongAnswer.Name = "WrongAnswer"
zmediaWrongAnswer.AltText = ""
zmediaWrongAnswer.Resources = {
  { Type = "jpg", Filename = "wrong.jpg", Directives = {},}
}
-- Cartridge Info --
cartSeoulZoo.Id = "1f3aba78e4a66db70e6771b6eb6f4ee8"
cartSeoulZoo.Name = "Seoul Zoo"
cartSeoulZoo.Activity = "Geocache"
cartSeoulZoo.Version = "1.0"
cartSeoulZoo.Company = "Daegu"
cartSeoulZoo.Author = "Jiho Kim"
cartSeoulZoo.TargetDevice = "Garmin"
cartSeoulZoo.TargetDeviceVersion = "0"
cartSeoulZoo.BuilderVersion = "WWB v0.3.2012.11.18.182506"
cartSeoulZoo.StateId = "1"
cartSeoulZoo.CountryId = "2"
cartSeoulZoo.Description = [[This is a cartridgr support Geocaching in Seoul Zoo. You can see the 3 zones at the start point. Go to these points and answer the questions. When you answer the 3 questions correctly, you can see the last cache zone. To complete the cartridge, you should find the cache zone. The actual cache is hidden in the last cache zone. To claim the Wherigo cache, you should find and log the cache. Enjoy walking in Seoul Zool! ]]
cartSeoulZoo.StartingLocationDescription = [[Front of the Seoul Zoo]]
cartSeoulZoo.Visible = true
cartSeoulZoo.Complete = false
cartSeoulZoo.UseLogging = true
cartSeoulZoo.CreateDate = "11/26/2012 12:54:01 AM"
cartSeoulZoo.PublishDate = "1/1/2001 12:00:00 AM"
cartSeoulZoo.UpdateDate = "11/26/2012 02:59:41 AM"
cartSeoulZoo.LastPlayedDate = "1/1/2001 12:00:00 AM"
cartSeoulZoo.Media = zmediaSeoulZoo
cartSeoulZoo.StartingLocation = ZonePoint(37.4288,127.015916666667,0)

-- Zones --
zoneCache = Wherigo.Zone(cartSeoulZoo)
zoneCache.Id = "c1df5516876b5064191b8929889af932"
zoneCache.Name = "Cache"
zoneCache.DistanceRangeUOM = "Meters"
zoneCache.ProximityRangeUOM = "Meters"
zoneCache.ShowObjects = "OnEnter"
zoneCache.OutOfRangeName = ""
zoneCache.InRangeName = ""
zoneCache.Description = "N 37deg 25.220min   E 127deg 01.442min"
zoneCache.Visible = false
zoneCache.AllowSetPositionTo = false
zoneCache.Active = true
zoneCache.DistanceRange = Distance(1500, "meters")
zoneCache.ProximityRange = Distance(200, "meters")
zoneCache.Points = {
  ZonePoint(37.420348520829,127.02398130117,0)
, ZonePoint(37.420352781243,127.02405471221,0)
, ZonePoint(37.420278697913,127.02406812325,0)
, ZonePoint(37.420272307285,127.02399739443,0)
}
zoneCache.OriginalPoint = ZonePoint(37.42032,127.02401666559,0)

zoneStage01 = Wherigo.Zone(cartSeoulZoo)
zoneStage01.Id = "42fd3501b5acee9c57645624059a8eb1"
zoneStage01.Name = "Stage01"
zoneStage01.DistanceRangeUOM = "Feet"
zoneStage01.ProximityRangeUOM = "Feet"
zoneStage01.ShowObjects = "OnEnter"
zoneStage01.OutOfRangeName = ""
zoneStage01.InRangeName = ""
zoneStage01.Description = "In the Seoul Zoo"
zoneStage01.Visible = true
zoneStage01.AllowSetPositionTo = false
zoneStage01.Active = true
zoneStage01.DistanceRange = Distance(1500, "feet")
zoneStage01.ProximityRange = Distance(200, "feet")
zoneStage01.Points = {
  ZonePoint(37.427219820168,127.01715739534,0)
, ZonePoint(37.427085629318,127.01737547136,0)
, ZonePoint(37.426906569778,127.01753372167,0)
, ZonePoint(37.426800068678,127.01739074749,0)
, ZonePoint(37.426967344354,127.01721413028,0)
, ZonePoint(37.427099405401,127.01703978672,0)
}
zoneStage01.OriginalPoint = ZonePoint(37.42706,127.01730666648,0)

zoneStage02 = Wherigo.Zone(cartSeoulZoo)
zoneStage02.Id = "34f47e3a4844608e6759fdc1aa861727"
zoneStage02.Name = "Stage02"
zoneStage02.DistanceRangeUOM = "Feet"
zoneStage02.ProximityRangeUOM = "Feet"
zoneStage02.ShowObjects = "OnEnter"
zoneStage02.OutOfRangeName = ""
zoneStage02.InRangeName = ""
zoneStage02.Description = "In the Seoul Zoo"
zoneStage02.Visible = true
zoneStage02.AllowSetPositionTo = false
zoneStage02.Active = true
zoneStage02.DistanceRange = Distance(1500, "feet")
zoneStage02.ProximityRange = Distance(200, "feet")
zoneStage02.Points = {
  ZonePoint(37.426470829706,127.01908325519,0)
, ZonePoint(37.42635154777,127.01953468338,0)
, ZonePoint(37.426174618946,127.01945958153,0)
, ZonePoint(37.426293901165,127.01901619998,0)
}
zoneStage02.OriginalPoint = ZonePoint(37.42636,127.01925666622,0)

zoneStage03 = Wherigo.Zone(cartSeoulZoo)
zoneStage03.Id = "f18d0a33eed3364e6128a6dd6bc72466"
zoneStage03.Name = "Stage03"
zoneStage03.DistanceRangeUOM = "Meters"
zoneStage03.ProximityRangeUOM = "Feet"
zoneStage03.ShowObjects = "OnEnter"
zoneStage03.OutOfRangeName = ""
zoneStage03.InRangeName = ""
zoneStage03.Description = "In the Seoul Zoo"
zoneStage03.Visible = true
zoneStage03.AllowSetPositionTo = false
zoneStage03.Active = true
zoneStage03.DistanceRange = Distance(1500, "meters")
zoneStage03.ProximityRange = Distance(200, "feet")
zoneStage03.Points = {
  ZonePoint(37.420970947239,127.02370905584,0)
, ZonePoint(37.42070893349,127.02375547051,0)
, ZonePoint(37.420463844289,127.02387080548,0)
, ZonePoint(37.420410589176,127.02367418712,0)
, ZonePoint(37.420707810308,127.02351098096,0)
, ZonePoint(37.420957042924,127.0234948877,0)
}
zoneStage03.OriginalPoint = ZonePoint(37.42076,127.02368666563,0)

-- Characters --
-- Items --
zitemBell = Wherigo.ZItem{Cartridge=cartSeoulZoo, Container=zoneCache}
zitemBell.Id = "39df795e61c1b883294f73d187cd50ad"
zitemBell.Name = "Bell"
zitemBell.Description = ""
zitemBell.Visible = true
zitemBell.Locked = false
zitemBell.Opened = false
zitemBell.ObjectLocation = ZonePoint(37.42031,127.02402666558,0)
zitemBell.Media = zmediaBell
zitemBell.Commands = {
  Examine = Wherigo.ZCommand{Text="Examine", EmptyTargetListText="Nothing available", CmdWith=false, Enabled=true}
, Take = Wherigo.ZCommand{Text="Take", EmptyTargetListText="Nothing available", CmdWith=false, Enabled=true}
}
zitemBell.Commands.Examine.Id = "85d52c3f68cbeaffdddc399ea29fc052"
zitemBell.Commands.Examine.Custom = true
zitemBell.Commands.Examine.WorksWithAll = true
zitemBell.Commands.Take.Id = "e42bf4820feda727a7969faa75d4652c"
zitemBell.Commands.Take.Custom = true
zitemBell.Commands.Take.WorksWithAll = true

zitemNeedSpoiler = Wherigo.ZItem{Cartridge=cartSeoulZoo, Container=zoneCache}
zitemNeedSpoiler.Id = "b90abc024cbd9864c39a6f98c022aa53"
zitemNeedSpoiler.Name = "NeedSpoiler"
zitemNeedSpoiler.Description = "This is a spoiler photo to find the cache.\060BR\062\010Do you need a spoiler photo?"
zitemNeedSpoiler.Visible = false
zitemNeedSpoiler.Locked = false
zitemNeedSpoiler.Opened = false
zitemNeedSpoiler.ObjectLocation = ZonePoint(37.42032,127.02401666559,0)
zitemNeedSpoiler.Commands = {
  No = Wherigo.ZCommand{Text="No", EmptyTargetListText="Nothing available", CmdWith=false, Enabled=true}
, Yes = Wherigo.ZCommand{Text="Yes", EmptyTargetListText="Nothing available", CmdWith=false, Enabled=true}
}
zitemNeedSpoiler.Commands.No.Id = "9a7e4b963bb9f99af4a7ae16d1cafab7"
zitemNeedSpoiler.Commands.No.Custom = true
zitemNeedSpoiler.Commands.No.WorksWithAll = true
zitemNeedSpoiler.Commands.Yes.Id = "488f83497cffe1068d9e55d865c5f017"
zitemNeedSpoiler.Commands.Yes.Custom = true
zitemNeedSpoiler.Commands.Yes.WorksWithAll = true

zitemQuestionatStage01 = Wherigo.ZItem{Cartridge=cartSeoulZoo, Container=zoneStage01}
zitemQuestionatStage01.Id = "1217c1740f0fcacaeaa5d3fcb68deb08"
zitemQuestionatStage01.Name = "Question at Stage01"
zitemQuestionatStage01.Description = "Find the Stage01 where you can see the herbivore. Question: What animals do you see here?"
zitemQuestionatStage01.Visible = true
zitemQuestionatStage01.Locked = false
zitemQuestionatStage01.Opened = false
zitemQuestionatStage01.ObjectLocation = ZonePoint(37.42701,127.01727666649,0)
zitemQuestionatStage01.Commands = {
  Dear = Wherigo.ZCommand{Text="Dear", EmptyTargetListText="Nothing available", CmdWith=false, Enabled=true}
, Giraffe = Wherigo.ZCommand{Text="Giraffe", EmptyTargetListText="Nothing available", CmdWith=false, Enabled=true}
, Zebra = Wherigo.ZCommand{Text="Zebra", EmptyTargetListText="Nothing available", CmdWith=false, Enabled=true}
}
zitemQuestionatStage01.Commands.Dear.Id = "cb221dc4c6f6ea4754b7703c9538727a"
zitemQuestionatStage01.Commands.Dear.Custom = true
zitemQuestionatStage01.Commands.Dear.WorksWithAll = true
zitemQuestionatStage01.Commands.Giraffe.Id = "68db09cd67ad22cb897e61c68d635fc1"
zitemQuestionatStage01.Commands.Giraffe.Custom = true
zitemQuestionatStage01.Commands.Giraffe.WorksWithAll = true
zitemQuestionatStage01.Commands.Zebra.Id = "b24f4c201f3a42dfad83bdccd3c13c7e"
zitemQuestionatStage01.Commands.Zebra.Custom = true
zitemQuestionatStage01.Commands.Zebra.WorksWithAll = true

zitemQuestionatStage02 = Wherigo.ZItem{Cartridge=cartSeoulZoo, Container=zoneStage02}
zitemQuestionatStage02.Id = "4263d07eca9eff8fb5758340014c81e4"
zitemQuestionatStage02.Name = "Question at Stage02"
zitemQuestionatStage02.Description = "Find the Stage02 where you can see the herbivore. Question: What animals do you see here?"
zitemQuestionatStage02.Visible = true
zitemQuestionatStage02.Locked = false
zitemQuestionatStage02.Opened = false
zitemQuestionatStage02.ObjectLocation = ZonePoint(37.42636,127.01925666622,0)
zitemQuestionatStage02.Commands = {
  Buffalo = Wherigo.ZCommand{Text="Buffalo", EmptyTargetListText="Nothing available", CmdWith=false, Enabled=true}
, Hippopotamus = Wherigo.ZCommand{Text="Hippopotamus", EmptyTargetListText="Nothing available", CmdWith=false, Enabled=true}
, Rhinoceros = Wherigo.ZCommand{Text="Rhinoceros", EmptyTargetListText="Nothing available", CmdWith=false, Enabled=true}
}
zitemQuestionatStage02.Commands.Buffalo.Id = "354c56f349aadba883aa243c33c17c5a"
zitemQuestionatStage02.Commands.Buffalo.Custom = true
zitemQuestionatStage02.Commands.Buffalo.WorksWithAll = true
zitemQuestionatStage02.Commands.Hippopotamus.Id = "4230864792479d808968c076d1b1166a"
zitemQuestionatStage02.Commands.Hippopotamus.Custom = true
zitemQuestionatStage02.Commands.Hippopotamus.WorksWithAll = true
zitemQuestionatStage02.Commands.Rhinoceros.Id = "e817f1faa8e51385f3ff421c87c736f3"
zitemQuestionatStage02.Commands.Rhinoceros.Custom = true
zitemQuestionatStage02.Commands.Rhinoceros.WorksWithAll = true

zitemQuestionatStage03 = Wherigo.ZItem{Cartridge=cartSeoulZoo, Container=zoneStage03}
zitemQuestionatStage03.Id = "5bf7c9435eee40a692054a003c433e4e"
zitemQuestionatStage03.Name = "Question at Stage03"
zitemQuestionatStage03.Description = "Find the Stage03 where you can see the carnivore. Question: What animals do you see here?"
zitemQuestionatStage03.Visible = true
zitemQuestionatStage03.Locked = false
zitemQuestionatStage03.Opened = false
zitemQuestionatStage03.ObjectLocation = ZonePoint(37.42076,127.02368666563,0)
zitemQuestionatStage03.Commands = {
  Bear = Wherigo.ZCommand{Text="Bear", EmptyTargetListText="Nothing available", CmdWith=false, Enabled=true}
, Lion = Wherigo.ZCommand{Text="Lion", EmptyTargetListText="Nothing available", CmdWith=false, Enabled=true}
, Tiger = Wherigo.ZCommand{Text="Tiger", EmptyTargetListText="Nothing available", CmdWith=false, Enabled=true}
}
zitemQuestionatStage03.Commands.Bear.Id = "22c25d2d3f1bdf89c3cfb86ab347d334"
zitemQuestionatStage03.Commands.Bear.Custom = true
zitemQuestionatStage03.Commands.Bear.WorksWithAll = true
zitemQuestionatStage03.Commands.Lion.Id = "b2b12d23d767b6fc5b56f2a15de1a2cf"
zitemQuestionatStage03.Commands.Lion.Custom = true
zitemQuestionatStage03.Commands.Lion.WorksWithAll = true
zitemQuestionatStage03.Commands.Tiger.Id = "2abe92fbf14e71aec4d7d015d589008b"
zitemQuestionatStage03.Commands.Tiger.Custom = true
zitemQuestionatStage03.Commands.Tiger.WorksWithAll = true

zitemSpoiler = Wherigo.ZItem(cartSeoulZoo)
zitemSpoiler.Id = "4b888651f59592b1c201c71688b3052f"
zitemSpoiler.Name = "Spoiler"
zitemSpoiler.Description = "Look for the place where you can see the same view."
zitemSpoiler.Visible = true
zitemSpoiler.Locked = false
zitemSpoiler.Opened = false
zitemSpoiler.ObjectLocation = ZonePoint(-80.999991171829,-80.999983676596,0)
zitemSpoiler.Media = zmediaSpoiler

-- Tasks --
ztaskFindBell = Wherigo.ZTask(cartSeoulZoo)
ztaskFindBell.Id = "9b8aca685850db77d423164666325f7d"
ztaskFindBell.Name = "Find Bell"
ztaskFindBell.CorrectState = "None"
ztaskFindBell.Description = "Go to the last cache and take the Bell.\060BR\062\010To claim the geocache, please look for the micro container."
ztaskFindBell.Visible = false
ztaskFindBell.Active = true
ztaskFindBell.Complete = false
ztaskFindBell.Media = zmediaBell

ztaskQuestionatStage01 = Wherigo.ZTask(cartSeoulZoo)
ztaskQuestionatStage01.Id = "aa2048714e75cacae564588fa37e1c1e"
ztaskQuestionatStage01.Name = "Question at Stage01"
ztaskQuestionatStage01.CorrectState = "None"
ztaskQuestionatStage01.Description = "Go to the Stage01 and answer the question."
ztaskQuestionatStage01.Visible = true
ztaskQuestionatStage01.Active = true
ztaskQuestionatStage01.Complete = false

ztaskQuestionatStage02 = Wherigo.ZTask(cartSeoulZoo)
ztaskQuestionatStage02.Id = "0846b224088e742938e1a54e1b521ccc"
ztaskQuestionatStage02.Name = "Question at Stage02"
ztaskQuestionatStage02.CorrectState = "None"
ztaskQuestionatStage02.Description = "Go to the Stage02 and answer the question."
ztaskQuestionatStage02.Visible = true
ztaskQuestionatStage02.Active = true
ztaskQuestionatStage02.Complete = false

ztaskQuestionatStage03 = Wherigo.ZTask(cartSeoulZoo)
ztaskQuestionatStage03.Id = "36d7613a042ac5431a3bddd8c6a9de9e"
ztaskQuestionatStage03.Name = "Question at Stage03"
ztaskQuestionatStage03.CorrectState = "None"
ztaskQuestionatStage03.Description = "Go to the Stage03 and answer the question."
ztaskQuestionatStage03.Visible = true
ztaskQuestionatStage03.Active = true
ztaskQuestionatStage03.Complete = false

-- Cartridge Variables --
WWB_device = ""
var_AnswerQuestion = 0
cartSeoulZoo.ZVariables = {WWB_device = "", var_AnswerQuestion = 0}

-- Builder Variables (to be read by the builder only) --
buildervar = {}
buildervar.var_AnswerQuestion = {}
buildervar.var_AnswerQuestion.Id = "ae264482847c52b40b112c7b57d58c09"
buildervar.var_AnswerQuestion.Name = "AnswerQuestion"
buildervar.var_AnswerQuestion.Type = "Number"
buildervar.var_AnswerQuestion.Data = "0"

-- ZTimers --
-- Inputs --
zinputNeedSpoiler = Wherigo.ZInput(cartSeoulZoo)
zinputNeedSpoiler.Id = "ef7c0cd43e774e6b96a50b7ebf46f81b"
zinputNeedSpoiler.Name = "NeedSpoiler"
zinputNeedSpoiler.InputType = "Text"
zinputNeedSpoiler.Text = ""
zinputNeedSpoiler.Visible = true
zinputNeedSpoiler.InputVariableId = ""

--
-- Events/Conditions/Actions --
--
-------------------------------------------------------------------------------
------Builder Generated functions, Do not Edit, this will be overwritten------
-------------------------------------------------------------------------------
function cartSeoulZoo:OnStart()
-- #GroupDescription=Script --
-- #Comment=Script Comment --
Player.CompletionCode15 = Player.CompletionCode:sub(1, 15)
end

function zoneCache:OnEnter()
-- #GroupDescription=Script --
-- #Comment=Script Comment --
Wherigo.MessageBox{Text="You have arrived the cache area."}
end

function zoneStage01:OnEnter()
-- #GroupDescription=Script --
-- #Comment=Script Comment --
if (ztaskQuestionatStage01.Complete == false) then
 Wherigo.ShowScreen(Wherigo.DETAILSCREEN, zitemQuestionatStage01)
end
end

function zoneStage01:OnExit()
-- #GroupDescription=Script --
-- #Comment=Script Comment --
if (ztaskQuestionatStage01.Complete == false) then
 Wherigo.MessageBox{Text="Why don't  you go back to the Stage01 and answer the question?", Media=zmediaWrongAnswer}
end
end

function zoneStage02:OnEnter()
-- #GroupDescription=Script --
-- #Comment=Script Comment --
if (ztaskQuestionatStage02.Complete == false) then
 Wherigo.ShowScreen(Wherigo.DETAILSCREEN, zitemQuestionatStage02)
end
end

function zoneStage02:OnExit()
-- #GroupDescription=Script --
-- #Comment=Script Comment --
if (ztaskQuestionatStage02.Complete == false) then
 Wherigo.MessageBox{Text="Why don't  you go back to the Stage02 and answer the question?", Media=zmediaWrongAnswer}
end
end

function zoneStage03:OnEnter()
-- #GroupDescription=Script --
-- #Comment=Script Comment --
if (ztaskQuestionatStage03.Complete == false) then
 Wherigo.ShowScreen(Wherigo.DETAILSCREEN, zitemQuestionatStage03)
end
end

function zoneStage03:OnExit()
-- #GroupDescription=Script --
-- #Comment=Script Comment --
if (ztaskQuestionatStage03.Complete == false) then
 Wherigo.MessageBox{Text="Why don't  you go back to the Stage03 and answer the question?", Media=zmediaWrongAnswer}
end
end

function zitemBell:OnExamine()
-- #GroupDescription=Script --
-- #Comment=Script Comment --
Wherigo.MessageBox{Text="Nice. Try to find the cache by yourself."}
end

function zitemBell:OnTake()
-- #GroupDescription=Script --
-- #Comment=Script Comment --
Wherigo.Dialog{{Text="Congratulations! You have complete this cartridge.", Media=zmediaCorrectAnswer}, {Text="In this area, you can find the actual cache. Please try."}}
zitemBell:MoveTo(Player)
ztaskFindBell.Complete = true
cartSeoulZoo.Complete = true
cartSeoulZoo:RequestSync()
zitemNeedSpoiler.Visible = true
zitemBell.Commands["Take"].Enabled = false
end

function zitemNeedSpoiler:OnNo()
-- #GroupDescription=Script --
-- #Comment=Script Comment --
Wherigo.MessageBox{Text="Nice. Try to find the cache by yourself.", Callback=cartSeoulZoo.MsgBoxCBFuncs.MsgBoxCB5}
end

function zitemNeedSpoiler:OnYes()
-- #GroupDescription=Script --
-- #Comment=Script Comment --
zitemSpoiler:MoveTo(Player)
Wherigo.MessageBox{Text="You can see the spoiler photo in your inventory."}
zitemNeedSpoiler.Commands["Yes"].Enabled = false
zitemNeedSpoiler.Commands["No"].Enabled = false
zitemNeedSpoiler.Visible = false
end

function zitemQuestionatStage01:OnDear()
-- #GroupDescription=Script --
-- #Comment=Script Comment --
Wherigo.MessageBox{Text="It is not a correct answer. Why don't  you try again.", Media=zmediaWrongAnswer}
end

function zitemQuestionatStage01:OnGiraffe()
-- #GroupDescription=Script --
-- #Comment=Script Comment --
Wherigo.MessageBox{Text="Right! Your answer is correct.", Media=zmediaCorrectAnswer}
var_AnswerQuestion = var_AnswerQuestion + 1
ztaskQuestionatStage01.Complete = true
cartSeoulZoo:RequestSync()
zoneStage01.Visible = false
if (var_AnswerQuestion == 3) then
 Wherigo.MessageBox{Text="You have answered the three questions. You can see the last cache zone."}
 zoneCache.Visible = true
 ztaskFindBell.Visible = true
end
zitemQuestionatStage01.Visible = false
end

function zitemQuestionatStage01:OnZebra()
-- #GroupDescription=Script --
-- #Comment=Script Comment --
Wherigo.MessageBox{Text="It is not a correct answer. Why don't  you try again.", Media=zmediaWrongAnswer, Callback=cartSeoulZoo.MsgBoxCBFuncs.MsgBoxCB7}
end

function zitemQuestionatStage02:OnBuffalo()
-- #GroupDescription=Script --
-- #Comment=Script Comment --
Wherigo.MessageBox{Text="It is not a correct answer. Why don't  you try again.", Media=zmediaWrongAnswer, Callback=cartSeoulZoo.MsgBoxCBFuncs.MsgBoxCB7}
end

function zitemQuestionatStage02:OnHippopotamus()
-- #GroupDescription=Script --
-- #Comment=Script Comment --
Wherigo.MessageBox{Text="Right! Your answer is correct.", Media=zmediaCorrectAnswer, Callback=cartSeoulZoo.MsgBoxCBFuncs.MsgBoxCB8}
var_AnswerQuestion = var_AnswerQuestion + 1
ztaskQuestionatStage02.Complete = true
cartSeoulZoo:RequestSync()
zoneStage02.Visible = false
if (var_AnswerQuestion == 3) then
 Wherigo.MessageBox{Text="You have answered the three questions. You can see the last cache zone.", Callback=cartSeoulZoo.MsgBoxCBFuncs.MsgBoxCB9}
 zoneCache.Visible = true
 ztaskFindBell.Visible = true
end
zitemQuestionatStage02.Visible = false
end

function zitemQuestionatStage02:OnRhinoceros()
-- #GroupDescription=Script --
-- #Comment=Script Comment --
Wherigo.MessageBox{Text="It is not a correct answer. Why don't  you try again.", Media=zmediaWrongAnswer, Callback=cartSeoulZoo.MsgBoxCBFuncs.MsgBoxCB7}
end

function zitemQuestionatStage03:OnBear()
-- #GroupDescription=Script --
-- #Comment=Script Comment --
Wherigo.MessageBox{Text="Right! Your answer is correct.", Media=zmediaCorrectAnswer, Callback=cartSeoulZoo.MsgBoxCBFuncs.MsgBoxCB8}
var_AnswerQuestion = var_AnswerQuestion + 1
ztaskQuestionatStage03.Complete = true
cartSeoulZoo:RequestSync()
zoneStage03.Visible = false
if (var_AnswerQuestion == 3) then
 Wherigo.MessageBox{Text="You have answered the three questions. You can see the last cache zone.", Callback=cartSeoulZoo.MsgBoxCBFuncs.MsgBoxCB9}
 zoneCache.Visible = true
 ztaskFindBell.Visible = true
end
zitemQuestionatStage03.Visible = false
end

function zitemQuestionatStage03:OnLion()
-- #GroupDescription=Script --
-- #Comment=Script Comment --
Wherigo.MessageBox{Text="It is not a correct answer. Why don't  you try again.", Media=zmediaWrongAnswer, Callback=cartSeoulZoo.MsgBoxCBFuncs.MsgBoxCB7}
end

function zitemQuestionatStage03:OnTiger()
-- #GroupDescription=Script --
-- #Comment=Script Comment --
Wherigo.MessageBox{Text="It is not a correct answer. Why don't  you try again.", Media=zmediaWrongAnswer, Callback=cartSeoulZoo.MsgBoxCBFuncs.MsgBoxCB7}
end

------End Builder Generated functions, Do not Edit, this will be overwritten------
-------------------------------------------------------------------------------
------Builder Generated callbacks, Do not Edit, this will be overwritten------
-------------------------------------------------------------------------------
--#LASTCALLBACKKEY=0#--
------End Builder Generated callbacks, Do not Edit, this will be overwritten------
-- #Author Functions Go Here# --
-- #End Author Functions# --
-- Nothing after this line --
return cartSeoulZoo
