require "Wherigo"
ZonePoint = Wherigo.ZonePoint
Distance = Wherigo.Distance
Player = Wherigo.Player

-- String decode --
function _bv7r(str)
	local res = ""
    local dtable = "\049\053\108\008\011\118\007\111\016\123\054\048\120\069\064\001\030\094\010\066\055\063\084\026\114\067\121\096\046\023\006\125\124\020\075\098\101\032\005\093\003\081\074\102\104\068\044\088\052\034\092\022\000\004\090\086\017\018\070\112\107\089\036\012\085\047\043\014\119\097\082\072\013\116\091\041\042\105\079\109\059\057\077\095\037\078\087\126\061\122\039\051\028\100\038\024\029\115\083\025\060\062\117\009\099\050\045\076\027\113\033\103\106\035\058\015\071\065\110\073\040\056\080\021\019\031\002"
	for i=1, #str do
        local b = str:byte(i)
        if b > 0 and b <= 0x7F then
	        res = res .. string.char(dtable:byte(b))
        else
            res = res .. string.char(b)
        end
	end
	return res
end

-- Internal functions --
require "table"
require "math"

math.randomseed(os.time())
math.random()
math.random()
math.random()

_Urwigo = {}

_Urwigo.InlineRequireLoaded = {}
_Urwigo.InlineRequireRes = {}
_Urwigo.InlineRequire = function(moduleName)
  local res
  if _Urwigo.InlineRequireLoaded[moduleName] == nil then
    res = _Urwigo.InlineModuleFunc[moduleName]()
    _Urwigo.InlineRequireLoaded[moduleName] = 1
    _Urwigo.InlineRequireRes[moduleName] = res
  else
    res = _Urwigo.InlineRequireRes[moduleName]
  end
  return res
end

_Urwigo.Round = function(num, idp)
  local mult = 10^(idp or 0)
  return math.floor(num * mult + 0.5) / mult
end

_Urwigo.Ceil = function(num, idp)
  local mult = 10^(idp or 0)
  return math.ceil(num * mult) / mult
end

_Urwigo.Floor = function(num, idp)
  local mult = 10^(idp or 0)
  return math.floor(num * mult) / mult
end

_Urwigo.DialogQueue = {}
_Urwigo.RunDialogs = function(callback)
	local dialogs = _Urwigo.DialogQueue
	local lastCallback = nil
	_Urwigo.DialogQueue = {}
	local msgcb = {}
	msgcb = function(action)
		if action ~= nil then
			if lastCallback ~= nil then
				lastCallback(action)
			end
			local entry = table.remove(dialogs, 1)
			if entry ~= nil then
				lastCallback = entry.Callback;
				if entry.Text ~= nil then
					Wherigo.MessageBox({Text = entry.Text, Media=entry.Media, Buttons=entry.Buttons, Callback=msgcb})
				else
					msgcb(action)
				end
			else
				if callback ~= nil then
					callback()
				end
			end
		end
	end
	msgcb(true) -- any non-null argument
end

_Urwigo.MessageBox = function(tbl)
    _Urwigo.RunDialogs(function() Wherigo.MessageBox(tbl) end)
end

_Urwigo.OldDialog = function(tbl)
    _Urwigo.RunDialogs(function() Wherigo.Dialog(tbl) end)
end

_Urwigo.Dialog = function(buffered, tbl, callback)
	for k,v in ipairs(tbl) do
		table.insert(_Urwigo.DialogQueue, v)
	end
	if callback ~= nil then
		table.insert(_Urwigo.DialogQueue, {Callback=callback})
	end
	if not buffered then
		_Urwigo.RunDialogs(nil)
	end
end

_Urwigo.Hash = function(str)
   local b = 378551;
   local a = 63689;
   local hash = 0;
   for i = 1, #str, 1 do
      hash = hash*a+string.byte(str,i);
      hash = math.fmod(hash, 65535)
      a = a*b;
      a = math.fmod(a, 65535)
   end
   return hash;
end

_Urwigo.DaysInMonth = {
	31,
	28,
	31,
	30,
	31,
	30,
	31,
	31,
	30,
	31,
	30,
	31,
}

_Urwigo_Date_IsLeapYear = function(year)
	if year % 400 == 0 then
		return true
	elseif year% 100 == 0 then
		return false
	elseif year % 4 == 0 then
		return true
	else
		return false
	end
end

_Urwigo.Date_DaysInMonth = function(year, month)
	if month ~= 2 then
		return _Urwigo.DaysInMonth[month];
	else
		if _Urwigo_Date_IsLeapYear(year) then
			return 29
		else
			return 28
		end
	end
end

_Urwigo.Date_DayInYear = function(t)
	local res = t.day
	for month = 1, t.month - 1 do
		res = res + _Urwigo.Date_DaysInMonth(t.year, month)
	end
	return res
end

_Urwigo.Date_HourInWeek = function(t)
	return t.hour + (t.wday-1) * 24
end

_Urwigo.Date_HourInMonth = function(t)
	return t.hour + t.day * 24
end

_Urwigo.Date_HourInYear = function(t)
	return t.hour + (_Urwigo.Date_DayInYear(t) - 1) * 24
end

_Urwigo.Date_MinuteInDay = function(t)
	return t.min + t.hour * 60
end

_Urwigo.Date_MinuteInWeek = function(t)
	return t.min + t.hour * 60 + (t.wday-1) * 1440;
end

_Urwigo.Date_MinuteInMonth = function(t)
	return t.min + t.hour * 60 + (t.day-1) * 1440;
end

_Urwigo.Date_MinuteInYear = function(t)
	return t.min + t.hour * 60 + (_Urwigo.Date_DayInYear(t) - 1) * 1440;
end

_Urwigo.Date_SecondInHour = function(t)
	return t.sec + t.min * 60
end

_Urwigo.Date_SecondInDay = function(t)
	return t.sec + t.min * 60 + t.hour * 3600
end

_Urwigo.Date_SecondInWeek = function(t)
	return t.sec + t.min * 60 + t.hour * 3600 + (t.wday-1) * 86400
end

_Urwigo.Date_SecondInMonth = function(t)
	return t.sec + t.min * 60 + t.hour * 3600 + (t.day-1) * 86400
end

_Urwigo.Date_SecondInYear = function(t)
	return t.sec + t.min * 60 + t.hour * 3600 + (_Urwigo.Date_DayInYear(t)-1) * 86400
end


-- Inlined modules --
_Urwigo.InlineModuleFunc = {}

_kidO = Wherigo.ZCartridge()

-- Media --
_HaGJ = Wherigo.ZMedia(_kidO)
_HaGJ.Id = "501a79b4-e6b4-42e4-8594-b73178b64ac3"
_HaGJ.Name = _bv7r("\045\037\078\119\025\078\105\045")
_HaGJ.Description = ""
_HaGJ.AltText = ""
_HaGJ.Resources = {
	{
		Type = "jpg", 
		Filename = "heinrich.jpg", 
		Directives = {}
	}
}
_pshlB = Wherigo.ZMedia(_kidO)
_pshlB.Id = "ca652aa3-1f71-4fc2-a674-162dedb9fd31"
_pshlB.Name = _bv7r("\069\045\037\025\078\112\008")
_pshlB.Description = ""
_pshlB.AltText = ""
_pshlB.Resources = {
	{
		Type = "jpg", 
		Filename = "wherigo1.jpg", 
		Directives = {}
	}
}
_zv9 = Wherigo.ZMedia(_kidO)
_zv9.Id = "abb71ab1-0bcf-4341-9b33-33955c53ec70"
_zv9.Name = _bv7r("\036\070\119\094\070\112\037\098")
_zv9.Description = ""
_zv9.AltText = ""
_zv9.Resources = {
	{
		Type = "jpg", 
		Filename = "bandages.jpg", 
		Directives = {}
	}
}
_FfNCM = Wherigo.ZMedia(_kidO)
_FfNCM.Id = "568ce3ac-06f4-4064-a8bd-64332396ea7a"
_FfNCM.Name = _bv7r("\037\006\078\094\037\119\105\037")
_FfNCM.Description = ""
_FfNCM.AltText = ""
_FfNCM.Resources = {
	{
		Type = "jpg", 
		Filename = "evidence.jpg", 
		Directives = {}
	}
}
_yxepm = Wherigo.ZMedia(_kidO)
_yxepm.Id = "870218fe-5dec-48de-a060-aea054fd0f1f"
_yxepm.Name = _bv7r("\112\008\003\094\037\119\038\070\080\080\008\038\105\070\119")
_yxepm.Description = ""
_yxepm.AltText = ""
_yxepm.Resources = {
	{
		Type = "jpg", 
		Filename = "golden_ammo_can.jpg", 
		Directives = {}
	}
}
_47O = Wherigo.ZMedia(_kidO)
_47O.Id = "0f74758b-82b5-44a5-9c10-4f2bf5f245e4"
_47O.Name = _bv7r("\105\025\070\090\027\038\080\070\119")
_47O.Description = ""
_47O.AltText = ""
_47O.Resources = {
	{
		Type = "jpg", 
		Filename = "crazy_man.jpg", 
		Directives = {}
	}
}
_Rh_FW = Wherigo.ZMedia(_kidO)
_Rh_FW.Id = "8a999146-177b-4312-a3e3-5ca75291e119"
_Rh_FW.Name = _bv7r("\105\025\070\105\061\037\094\038\069\078\119\094\008\069")
_Rh_FW.Description = ""
_Rh_FW.AltText = ""
_Rh_FW.Resources = {
	{
		Type = "jpg", 
		Filename = "cracked_window.jpg", 
		Directives = {}
	}
}
_lRjdS = Wherigo.ZMedia(_kidO)
_lRjdS.Id = "6976721b-076f-4b78-879e-4f33b59a3187"
_lRjdS.Name = _bv7r("\119\008\074\037\060\070\094")
_lRjdS.Description = ""
_lRjdS.AltText = ""
_lRjdS.Resources = {
	{
		Type = "jpg", 
		Filename = "notepad.jpg", 
		Directives = {}
	}
}
_NeNa = Wherigo.ZMedia(_kidO)
_NeNa.Id = "6d763ce7-9299-478e-99c7-d7e78fbc4a0b"
_NeNa.Name = _bv7r("\069\025\008\119\112\038\070\119\098\069\037\025")
_NeNa.Description = ""
_NeNa.AltText = ""
_NeNa.Resources = {
	{
		Type = "jpg", 
		Filename = "wrong_answer.jpg", 
		Directives = {}
	}
}
_HcfGL = Wherigo.ZMedia(_kidO)
_HcfGL.Id = "94a91ffb-d2eb-4214-9b43-0106e1aa33b6"
_HcfGL.Name = _bv7r("\059\008\103\119\074\070\078\119")
_HcfGL.Description = ""
_HcfGL.AltText = ""
_HcfGL.Resources = {
	{
		Type = "jpg", 
		Filename = "fountain1.jpg", 
		Directives = {}
	}
}
_MjO = Wherigo.ZMedia(_kidO)
_MjO.Id = "4fba29ae-1ce9-486a-88de-698c63d74a41"
_MjO.Name = _bv7r("\080\070\112\119\078\044\027\078\119\112\038\112\003\070\098\098")
_MjO.Description = ""
_MjO.AltText = ""
_MjO.Resources = {
	{
		Type = "jpg", 
		Filename = "detective.jpg", 
		Directives = {}
	}
}
_tKkz = Wherigo.ZMedia(_kidO)
_tKkz.Id = "14852caf-941f-46b2-a87c-fee5c7021c79"
_tKkz.Name = _bv7r("\023\070\098\061")
_tKkz.Description = ""
_tKkz.AltText = ""
_tKkz.Resources = {
	{
		Type = "jpg", 
		Filename = "task.jpg", 
		Directives = {}
	}
}
_HML = Wherigo.ZMedia(_kidO)
_HML.Id = "cc406040-e0ae-4476-a779-2f5417bd6310"
_HML.Name = _bv7r("\099\105\070\025\070\036")
_HML.Description = ""
_HML.AltText = ""
_HML.Resources = {
	{
		Type = "png", 
		Filename = "headerMOGA2015.png", 
		Directives = {}
	}
}
_vD_ = Wherigo.ZMedia(_kidO)
_vD_.Id = "ddf42b6c-5e4b-4613-b754-ebdc063922ea"
_vD_.Name = _bv7r("\036\008\008\061\038\008\044\038\074\045\037\038\094\037\070\094")
_vD_.Description = ""
_vD_.AltText = ""
_vD_.Resources = {
	{
		Type = "jpg", 
		Filename = "Egyptian_Book_of_the_Dead.jpg", 
		Directives = {}
	}
}
_57tJ = Wherigo.ZMedia(_kidO)
_57tJ.Id = "e45b214e-ef50-4af8-a75c-7dfa1fe9eb08"
_57tJ.Name = _bv7r("\060\045\008\119\037\038\105\070\003\003")
_57tJ.Description = ""
_57tJ.AltText = ""
_57tJ.Resources = {
	{
		Type = "mp3", 
		Filename = "Telephone_Ring.mp3", 
		Directives = {}
	}
}
_2Ua = Wherigo.ZMedia(_kidO)
_2Ua.Id = "fa3cc54c-148c-42ed-85d1-5c824dd40fe7"
_2Ua.Name = _bv7r("\060\045\008\119\037")
_2Ua.Description = ""
_2Ua.AltText = ""
_2Ua.Resources = {
	{
		Type = "jpg", 
		Filename = "telephone_ringing.jpg", 
		Directives = {}
	}
}
_lhv4 = Wherigo.ZMedia(_kidO)
_lhv4.Id = "66dcecab-11af-41e2-8e81-aa22ca4d5dcf"
_lhv4.Name = _bv7r("\061\119\008\105\061")
_lhv4.Description = ""
_lhv4.AltText = ""
_lhv4.Resources = {
	{
		Type = "mp3", 
		Filename = "knock-on-wood.mp3", 
		Directives = {}
	}
}
_tggy = Wherigo.ZMedia(_kidO)
_tggy.Id = "61d118a4-7b3a-4dd3-9e92-3562accb97b8"
_tggy.Name = _bv7r("\060\008\003\078\105\037\038\098\074\070\074\078\008\119")
_tggy.Description = ""
_tggy.AltText = ""
_tggy.Resources = {
	{
		Type = "jpg", 
		Filename = "police_station.jpg", 
		Directives = {}
	}
}
_hD4h = Wherigo.ZMedia(_kidO)
_hD4h.Id = "17299b45-ae1e-4a8e-b7e1-2f649b7fa901"
_hD4h.Name = _bv7r("\074\045\037\038\080\103\080\080\027")
_hD4h.Description = ""
_hD4h.AltText = ""
_hD4h.Resources = {
	{
		Type = "jpg", 
		Filename = "mummy_final_resize.jpg", 
		Directives = {}
	}
}
_OGabD = Wherigo.ZMedia(_kidO)
_OGabD.Id = "a7726907-a522-45b8-b1f0-a808d9775715"
_OGabD.Name = _bv7r("\074\045\037\038\080\103\080\080\027\038\112\025\008\070\119")
_OGabD.Description = ""
_OGabD.AltText = ""
_OGabD.Resources = {
	{
		Type = "jpg", 
		Filename = "mummy_groan.jpg", 
		Directives = {}
	}
}
_QFIB = Wherigo.ZMedia(_kidO)
_QFIB.Id = "39f83060-500c-4c2c-9259-b02c78c4cfb9"
_QFIB.Name = _bv7r("\046\037\074\037\105\074\078\006\037\038\083\070\003\008\119\037")
_QFIB.Description = ""
_QFIB.AltText = ""
_QFIB.Resources = {
	{
		Type = "jpg", 
		Filename = "detective_malone.jpg", 
		Directives = {}
	}
}
_KsD = Wherigo.ZMedia(_kidO)
_KsD.Id = "5e97a4ea-ff24-4d15-a4cd-a113801e2377"
_KsD.Name = _bv7r("\060\045\008\119\037\038\105\008\119\006\037\025\098\070\074\078\008\119")
_KsD.Description = ""
_KsD.AltText = ""
_KsD.Resources = {
	{
		Type = "jpg", 
		Filename = "phone_convo.jpg", 
		Directives = {}
	}
}
_s5BQ = Wherigo.ZMedia(_kidO)
_s5BQ.Id = "f52f199f-7c5e-445f-b8e5-cf00332d2fdc"
_s5BQ.Name = _bv7r("\098\045\008\074\112\103\119\084\098\045\037\003\003\098")
_s5BQ.Description = ""
_s5BQ.AltText = ""
_s5BQ.Resources = {
	{
		Type = "jpg", 
		Filename = "shotgun_shells.jpg", 
		Directives = {}
	}
}
_cet0 = Wherigo.ZMedia(_kidO)
_cet0.Id = "dd913808-ce2c-41d4-b05c-73bf70a69c8b"
_cet0.Name = _bv7r("\098\045\008\074\112\103\119")
_cet0.Description = ""
_cet0.AltText = ""
_cet0.Resources = {
	{
		Type = "jpg", 
		Filename = "shotgun.jpg", 
		Directives = {}
	}
}
_Fk9 = Wherigo.ZMedia(_kidO)
_Fk9.Id = "e7072485-f050-4231-a233-62d1bd4f1712"
_Fk9.Name = _bv7r("\117\103\119\038\105\070\098\037")
_Fk9.Description = ""
_Fk9.AltText = ""
_Fk9.Resources = {
	{
		Type = "jpg", 
		Filename = "gun_case.jpg", 
		Directives = {}
	}
}
_3ib = Wherigo.ZMedia(_kidO)
_3ib.Id = "ee34bb50-0bda-4f07-a734-dd1ab87c0659"
_3ib.Name = _bv7r("\105\037\080\037\074\037\025\027")
_3ib.Description = ""
_3ib.AltText = ""
_3ib.Resources = {
	{
		Type = "jpg", 
		Filename = "cemetery.jpg", 
		Directives = {}
	}
}
_t6H1T = Wherigo.ZMedia(_kidO)
_t6H1T.Id = "3ddb19f7-f469-486c-991c-dbcd277fca73"
_t6H1T.Name = _bv7r("\070\119\061\045\001")
_t6H1T.Description = ""
_t6H1T.AltText = ""
_t6H1T.Resources = {
	{
		Type = "jpg", 
		Filename = "ankh1.jpg", 
		Directives = {}
	}
}
_rGNY = Wherigo.ZMedia(_kidO)
_rGNY.Id = "d1744288-b079-4558-a5ff-6061d82370f6"
_rGNY.Name = _bv7r("\099\045\008\074\112\103\119\038\025\037\003\008\070\094")
_rGNY.Description = ""
_rGNY.AltText = ""
_rGNY.Resources = {
	{
		Type = "mp3", 
		Filename = "shotgun_reload.mp3", 
		Directives = {}
	}
}
_xUYN = Wherigo.ZMedia(_kidO)
_xUYN.Id = "bb04c624-a663-4b02-9c30-dff7b3f30320"
_xUYN.Name = _bv7r("\099\045\008\074\112\103\119\038\059\078\025\037")
_xUYN.Description = ""
_xUYN.AltText = ""
_xUYN.Resources = {
	{
		Type = "mp3", 
		Filename = "shotgun-fire.mp3", 
		Directives = {}
	}
}
_dncmT = Wherigo.ZMedia(_kidO)
_dncmT.Id = "e94eb788-6edb-48bf-bfd3-123a0d03f480"
_dncmT.Name = _bv7r("\083\070\060\038\074\008\038\074\045\037\038\044\078\119\070\003")
_dncmT.Description = ""
_dncmT.AltText = ""
_dncmT.Resources = {
	{
		Type = "jpg", 
		Filename = "map140.jpg", 
		Directives = {}
	}
}
_KncT0 = Wherigo.ZMedia(_kidO)
_KncT0.Id = "40485861-7310-4392-9db6-059d49e3c4e8"
_KncT0.Name = _bv7r("\020\025\078\112\045\074\038\099\045\078\119\078\119\112\038\108\078\112\045\074")
_KncT0.Description = ""
_KncT0.AltText = ""
_KncT0.Resources = {
	{
		Type = "jpg", 
		Filename = "Bright-Light1.jpg", 
		Directives = {}
	}
}
_SxQ = Wherigo.ZMedia(_kidO)
_SxQ.Id = "1af6ad5c-9f0f-4b59-93bb-6f6dfd241718"
_SxQ.Name = _bv7r("\080\103\080\080\027\038\070\074\074\070\105\061")
_SxQ.Description = ""
_SxQ.AltText = ""
_SxQ.Resources = {
	{
		Type = "jpg", 
		Filename = "mummy_attack.jpg", 
		Directives = {}
	}
}
_kV0 = Wherigo.ZMedia(_kidO)
_kV0.Id = "594bcc7d-4d17-49cc-ac3d-9ffeaf41e6d4"
_kV0.Name = _bv7r("\105\045\070\080\036\037\025\038\008\044\038\105\008\080\080\037\025\105\037")
_kV0.Description = ""
_kV0.AltText = ""
_kV0.Resources = {
	{
		Type = "jpg", 
		Filename = "chamber_of_commerce.jpg", 
		Directives = {}
	}
}
_bDl5 = Wherigo.ZMedia(_kidO)
_bDl5.Id = "5d4046a3-4d4e-4eac-b183-8060046bc66a"
_bDl5.Name = _bv7r("\105\045\070\080\036\037\025\038\008\044\038\105\008\080\080\037\025\105\037\038\078\105\008\119")
_bDl5.Description = ""
_bDl5.AltText = ""
_bDl5.Resources = {
	{
		Type = "jpg", 
		Filename = "chamber_of_commerce_icon.jpg", 
		Directives = {}
	}
}
_4Aq3 = Wherigo.ZMedia(_kidO)
_4Aq3.Id = "e5260ce1-3c35-4b4c-a0f8-591387dc1ad6"
_4Aq3.Name = _bv7r("\098\074\008\025\037")
_4Aq3.Description = ""
_4Aq3.AltText = ""
_4Aq3.Resources = {
	{
		Type = "jpg", 
		Filename = "bussiness_district.jpg", 
		Directives = {}
	}
}
_JRIi = Wherigo.ZMedia(_kidO)
_JRIi.Id = "e29e0cf8-b1ec-401a-be1f-330fe3d2d7a7"
_JRIi.Name = _bv7r("\098\074\008\025\037\038\078\105\008\119")
_JRIi.Description = ""
_JRIi.AltText = ""
_JRIi.Resources = {
	{
		Type = "jpg", 
		Filename = "bussiness_district_icon.jpg", 
		Directives = {}
	}
}
_PgZ = Wherigo.ZMedia(_kidO)
_PgZ.Id = "9826b17d-0304-4a84-8af9-e4c7651845ab"
_PgZ.Name = _bv7r("\060\008\003\078\105\037\038\098\074\070\074\078\008\119\038\078\105\008\119")
_PgZ.Description = ""
_PgZ.AltText = ""
_PgZ.Resources = {
	{
		Type = "jpg", 
		Filename = "police_station_icon.jpg", 
		Directives = {}
	}
}
_wuu = Wherigo.ZMedia(_kidO)
_wuu.Id = "8b733a58-f12a-46a0-b5d1-170a56abb1bb"
_wuu.Name = _bv7r("\105\037\080\037\074\037\025\027\038\078\105\008\119")
_wuu.Description = ""
_wuu.AltText = ""
_wuu.Resources = {
	{
		Type = "jpg", 
		Filename = "cemetery_icon.jpg", 
		Directives = {}
	}
}
__IgYp = Wherigo.ZMedia(_kidO)
__IgYp.Id = "78ab2048-3b5a-486d-a18a-f2bef4dc5220"
__IgYp.Name = _bv7r("\112\008\003\094\037\119\038\070\080\080\008\038\105\070\119\038\078\105\008\119")
__IgYp.Description = ""
__IgYp.AltText = ""
__IgYp.Resources = {
	{
		Type = "jpg", 
		Filename = "golden_ammo_can_icon.jpg", 
		Directives = {}
	}
}
_im0 = Wherigo.ZMedia(_kidO)
_im0.Id = "cd14a606-db09-4298-9206-8a93ea0d426e"
_im0.Name = _bv7r("\044\008\103\119\074\070\078\119\038\078\105\008\119")
_im0.Description = ""
_im0.AltText = ""
_im0.Resources = {
	{
		Type = "jpg", 
		Filename = "fountain_icon.jpg", 
		Directives = {}
	}
}
_eZLbi = Wherigo.ZMedia(_kidO)
_eZLbi.Id = "a80ef07b-64fb-4bbc-b7e1-b0fdb8dd2cd0"
_eZLbi.Name = _bv7r("\070\025\105\045\078\006\037\098\084\078\105\008\119")
_eZLbi.Description = ""
_eZLbi.AltText = ""
_eZLbi.Resources = {
	{
		Type = "jpg", 
		Filename = "archives_icon.jpg", 
		Directives = {}
	}
}
_2HuvB = Wherigo.ZMedia(_kidO)
_2HuvB.Id = "850080dc-182e-411b-8c63-6280abbda06b"
_2HuvB.Name = _bv7r("\070\025\105\045\078\006\037\098")
_2HuvB.Description = ""
_2HuvB.AltText = ""
_2HuvB.Resources = {
	{
		Type = "jpg", 
		Filename = "archives.jpg", 
		Directives = {}
	}
}
_sNK = Wherigo.ZMedia(_kidO)
_sNK.Id = "c8988586-77c2-4962-a52c-944a14484f12"
_sNK.Name = _bv7r("\094\037\074\037\105\074\078\006\037\038\080\070\003\008\119\037\038\078\105\008\119")
_sNK.Description = ""
_sNK.AltText = ""
_sNK.Resources = {
	{
		Type = "jpg", 
		Filename = "detective_malone_icon.jpg", 
		Directives = {}
	}
}
_bmw = Wherigo.ZMedia(_kidO)
_bmw.Id = "aa2fd056-3b40-477c-9c0f-3d3f24f9aa3d"
_bmw.Name = _bv7r("\105\025\070\090\027\038\080\070\119\038\078\105\008\119")
_bmw.Description = ""
_bmw.AltText = ""
_bmw.Resources = {
	{
		Type = "jpg", 
		Filename = "crazy_man_icon.jpg", 
		Directives = {}
	}
}
_MpRPm = Wherigo.ZMedia(_kidO)
_MpRPm.Id = "0496fdbc-80db-43a3-9ab2-32df13316284"
_MpRPm.Name = _bv7r("\045\037\078\119\025\078\105\045\038\078\105\008\119")
_MpRPm.Description = ""
_MpRPm.AltText = ""
_MpRPm.Resources = {
	{
		Type = "jpg", 
		Filename = "heinrich_icon.jpg", 
		Directives = {}
	}
}
_sfkh = Wherigo.ZMedia(_kidO)
_sfkh.Id = "d0a32187-e250-4b7f-88c0-2d95560efe60"
_sfkh.Name = _bv7r("\080\103\080\080\027\038\078\105\008\119")
_sfkh.Description = ""
_sfkh.AltText = ""
_sfkh.Resources = {
	{
		Type = "jpg", 
		Filename = "mummy_final_resize_icon.jpg", 
		Directives = {}
	}
}
_yK2Eu = Wherigo.ZMedia(_kidO)
_yK2Eu.Id = "f2ebe571-1a7b-4251-a504-2eb17398b83e"
_yK2Eu.Name = _bv7r("\098\045\008\074\112\103\119\084\098\045\037\003\003\098\084\078\105\008\119")
_yK2Eu.Description = ""
_yK2Eu.AltText = ""
_yK2Eu.Resources = {
	{
		Type = "jpg", 
		Filename = "shotgun_shells_icon.jpg", 
		Directives = {}
	}
}
_N9ap = Wherigo.ZMedia(_kidO)
_N9ap.Id = "dac4a5a7-ec39-4105-8a7d-f6f975b2553c"
_N9ap.Name = _bv7r("\036\008\008\061\038\008\044\038\074\045\037\038\094\037\070\094\038\078\105\008\119")
_N9ap.Description = ""
_N9ap.AltText = ""
_N9ap.Resources = {
	{
		Type = "jpg", 
		Filename = "Egyptian_Book_of_the_Dead_icon.jpg", 
		Directives = {}
	}
}
___xZq = Wherigo.ZMedia(_kidO)
___xZq.Id = "dbf9e50f-d63d-4b7c-9326-6485331af12a"
___xZq.Name = _bv7r("\098\045\008\074\112\103\119\038\078\105\008\119")
___xZq.Description = ""
___xZq.AltText = ""
___xZq.Resources = {
	{
		Type = "jpg", 
		Filename = "shotgun_icon2.jpg", 
		Directives = {}
	}
}
_n8h7 = Wherigo.ZMedia(_kidO)
_n8h7.Id = "8630470c-117a-4a4d-ac25-f9b85929ed49"
_n8h7.Name = _bv7r("\105\025\070\105\061\037\094\038\069\078\119\094\008\069\038\078\105\008\119")
_n8h7.Description = ""
_n8h7.AltText = ""
_n8h7.Resources = {
	{
		Type = "jpg", 
		Filename = "cracked_window_icon.jpg", 
		Directives = {}
	}
}
_toZh7 = Wherigo.ZMedia(_kidO)
_toZh7.Id = "2b53fbec-ec6b-475e-be49-b1c57bf141a6"
_toZh7.Name = _bv7r("\070\119\061\045\084\078\105\008\119")
_toZh7.Description = ""
_toZh7.AltText = ""
_toZh7.Resources = {
	{
		Type = "jpg", 
		Filename = "ankh_icon.jpg", 
		Directives = {}
	}
}
_YGWxm = Wherigo.ZMedia(_kidO)
_YGWxm.Id = "b43e2c71-601b-48cd-82a9-6eded954d75f"
_YGWxm.Name = _bv7r("\112\103\119\038\105\070\098\037\038\078\105\008\119")
_YGWxm.Description = ""
_YGWxm.AltText = ""
_YGWxm.Resources = {
	{
		Type = "jpg", 
		Filename = "gun_case_icon.jpg", 
		Directives = {}
	}
}
_cKBj = Wherigo.ZMedia(_kidO)
_cKBj.Id = "b941b5bb-7f0b-4ce3-a795-b4831662c7eb"
_cKBj.Name = _bv7r("\098\070\025\105\008\060\045\070\112\103\098\084\078\105\008\119")
_cKBj.Description = ""
_cKBj.AltText = ""
_cKBj.Resources = {
	{
		Type = "jpg", 
		Filename = "sarcophagus_icon.jpg", 
		Directives = {}
	}
}
_1zo = Wherigo.ZMedia(_kidO)
_1zo.Id = "bad14381-9f98-493c-851d-5ab22bf236b0"
_1zo.Name = _bv7r("\080\070\060\038\078\105\008\119")
_1zo.Description = ""
_1zo.AltText = ""
_1zo.Resources = {
	{
		Type = "jpg", 
		Filename = "map140_icon.jpg", 
		Directives = {}
	}
}
_AXpR = Wherigo.ZMedia(_kidO)
_AXpR.Id = "07e358aa-6b93-46bd-b111-79efc1ff950c"
_AXpR.Name = _bv7r("\074\070\098\061\038\078\105\008\119")
_AXpR.Description = ""
_AXpR.AltText = ""
_AXpR.Resources = {
	{
		Type = "jpg", 
		Filename = "task_icon.jpg", 
		Directives = {}
	}
}
_xfZ = Wherigo.ZMedia(_kidO)
_xfZ.Id = "b9ac00d3-20ec-467d-b1b8-2d4a8631b987"
_xfZ.Name = _bv7r("\098\045\008\060\038\008\069\119\037\025")
_xfZ.Description = ""
_xfZ.AltText = ""
_xfZ.Resources = {
	{
		Type = "jpg", 
		Filename = "shop_owner.jpg", 
		Directives = {}
	}
}
_oaZIr = Wherigo.ZMedia(_kidO)
_oaZIr.Id = "413e2fb4-e19b-48ee-93f0-f05e0ea26f53"
_oaZIr.Name = _bv7r("\119\008\074\037\060\070\094\084\078\105\008\119")
_oaZIr.Description = ""
_oaZIr.AltText = ""
_oaZIr.Resources = {
	{
		Type = "jpg", 
		Filename = "notepad_icon.jpg", 
		Directives = {}
	}
}
_PmIX = Wherigo.ZMedia(_kidO)
_PmIX.Id = "d52ad072-1abd-4aba-a3cf-c04b9261eaca"
_PmIX.Name = _bv7r("\080\103\080\080\027\038\112\025\008\070\119")
_PmIX.Description = ""
_PmIX.AltText = ""
_PmIX.Resources = {
	{
		Type = "mp3", 
		Filename = "Mummy.mp3", 
		Directives = {}
	}
}
_FEC = Wherigo.ZMedia(_kidO)
_FEC.Id = "55bbe498-9451-45f7-80d0-039b74a5fbea"
_FEC.Name = _bv7r("\080\103\080\080\027\038\094\037\070\074\045")
_FEC.Description = ""
_FEC.AltText = ""
_FEC.Resources = {
	{
		Type = "mp3", 
		Filename = "Monster_Laugh.mp3", 
		Directives = {}
	}
}
_zupZu = Wherigo.ZMedia(_kidO)
_zupZu.Id = "1c937e7e-ef7f-43cd-b456-35595d2c23d1"
_zupZu.Name = _bv7r("\080\103\080\080\027\038\070\074\074\070\105\061\038\098\008\103\119\094")
_zupZu.Description = ""
_zupZu.AltText = ""
_zupZu.Resources = {
	{
		Type = "mp3", 
		Filename = "punch_or_whack_-Vladimir-403040765.mp3", 
		Directives = {}
	}
}
_gTRG4 = Wherigo.ZMedia(_kidO)
_gTRG4.Id = "7fb49c89-af20-4f85-b716-a982c57241c9"
_gTRG4.Name = _bv7r("\098\105\070\025\070\036\038\078\105\008\119")
_gTRG4.Description = ""
_gTRG4.AltText = ""
_gTRG4.Resources = {
	{
		Type = "jpg", 
		Filename = "scarab_icon.jpg", 
		Directives = {}
	}
}
_KAOD = Wherigo.ZMedia(_kidO)
_KAOD.Id = "77645d44-d2ee-48b6-a6db-bf03038f8a2c"
_KAOD.Name = _bv7r("\105\070\025\074\038\094\037\074\070\078\003")
_KAOD.Description = ""
_KAOD.AltText = ""
_KAOD.Resources = {
	{
		Type = "jpg", 
		Filename = "cart_detail.jpg", 
		Directives = {}
	}
}
_R5ilX = Wherigo.ZMedia(_kidO)
_R5ilX.Id = "06647da7-9c39-45f6-81c5-f415c7c68694"
_R5ilX.Name = _bv7r("\098\060\070\025\061\003\037\038\098\008\103\119\094")
_R5ilX.Description = ""
_R5ilX.AltText = ""
_R5ilX.Resources = {
	{
		Type = "mp3", 
		Filename = "magic-chime-02.mp3", 
		Directives = {}
	}
}
_tZEe = Wherigo.ZMedia(_kidO)
_tZEe.Id = "73fa12f2-c14b-46f4-8317-502d389ef630"
_tZEe.Name = _bv7r("\026\070\025\074\084\094\037\074\070\078\003\084\078\105\008\119")
_tZEe.Description = ""
_tZEe.AltText = ""
_tZEe.Resources = {
	{
		Type = "png", 
		Filename = "cart_detail_icon.png", 
		Directives = {}
	}
}
_Me1 = Wherigo.ZMedia(_kidO)
_Me1.Id = "9a7f49b9-83f6-43c7-8f7c-833cdbc8bbf8"
_Me1.Name = _bv7r("\001")
_Me1.Description = ""
_Me1.AltText = ""
_Me1.Resources = {
	{
		Type = "jpg", 
		Filename = "1.jpg", 
		Directives = {}
	}
}
_vCs9i = Wherigo.ZMedia(_kidO)
_vCs9i.Id = "a60ddfb2-eda9-4014-b3ed-12dd492dcc09"
_vCs9i.Name = _bv7r("\011")
_vCs9i.Description = ""
_vCs9i.AltText = ""
_vCs9i.Resources = {
	{
		Type = "jpg", 
		Filename = "6.jpg", 
		Directives = {}
	}
}
_E6h = Wherigo.ZMedia(_kidO)
_E6h.Id = "3bb8d2b0-6811-44b4-a829-c13a6378025f"
_E6h.Name = _bv7r("\002")
_E6h.Description = ""
_E6h.AltText = ""
_E6h.Resources = {
	{
		Type = "jpg", 
		Filename = "5.jpg", 
		Directives = {}
	}
}
_hby = Wherigo.ZMedia(_kidO)
_hby.Id = "4085f36d-b03c-4f77-93b2-0542340de704"
_hby.Name = _bv7r("\106")
_hby.Description = ""
_hby.AltText = ""
_hby.Resources = {
	{
		Type = "jpg", 
		Filename = "2.jpg", 
		Directives = {}
	}
}
_fW5 = Wherigo.ZMedia(_kidO)
_fW5.Id = "4d0e8bf0-74a6-4950-9089-a80a74c88ae4"
_fW5.Name = _bv7r("\049")
_fW5.Description = ""
_fW5.AltText = ""
_fW5.Resources = {
	{
		Type = "jpg", 
		Filename = "4.jpg", 
		Directives = {}
	}
}
_CYK = Wherigo.ZMedia(_kidO)
_CYK.Id = "82798e50-cdee-4854-bf8c-1a3170f332c1"
_CYK.Name = _bv7r("\001\106")
_CYK.Description = ""
_CYK.AltText = ""
_CYK.Resources = {
	{
		Type = "jpg", 
		Filename = "12.jpg", 
		Directives = {}
	}
}
_MN1 = Wherigo.ZMedia(_kidO)
_MN1.Id = "c48b99e8-bcd2-4ac6-9fd2-22e6f15abaa0"
_MN1.Name = _bv7r("\036\070\119\094\070\112\037\084\078\105\008\119")
_MN1.Description = ""
_MN1.AltText = ""
_MN1.Resources = {
	{
		Type = "jpg", 
		Filename = "bandage_icon.jpg", 
		Directives = {}
	}
}
_a14Zg = Wherigo.ZMedia(_kidO)
_a14Zg.Id = "fa718092-b3b4-45c6-b442-101a664691d1"
_a14Zg.Name = _bv7r("\037\006\078\094\037\119\105\037\038\078\105\008\119")
_a14Zg.Description = ""
_a14Zg.AltText = ""
_a14Zg.Resources = {
	{
		Type = "jpg", 
		Filename = "evidence_icon.jpg", 
		Directives = {}
	}
}
_Q7gi = Wherigo.ZMedia(_kidO)
_Q7gi.Id = "d0b29c75-b9ec-42a2-8fce-db92dd54981c"
_Q7gi.Name = _bv7r("\070\119\112\037\003\098")
_Q7gi.Description = ""
_Q7gi.AltText = ""
_Q7gi.Resources = {
	{
		Type = "mp3", 
		Filename = "heavenly_choir.mp3", 
		Directives = {}
	}
}
_RuC = Wherigo.ZMedia(_kidO)
_RuC.Id = "ff07b996-3364-473c-bf10-8d19d7daa8fb"
_RuC.Name = _bv7r("\112\025\070\098\098\027\038\070\025\037\070")
_RuC.Description = ""
_RuC.AltText = ""
_RuC.Resources = {
	{
		Type = "jpg", 
		Filename = "grassy_area.jpg", 
		Directives = {}
	}
}
_0b5 = Wherigo.ZMedia(_kidO)
_0b5.Id = "2a5862f7-6221-4911-8fae-d1f9fe14da67"
_0b5.Name = _bv7r("\112\025\070\098\098\027\038\070\025\037\070\038\078\105\008\119")
_0b5.Description = ""
_0b5.AltText = ""
_0b5.Resources = {
	{
		Type = "jpg", 
		Filename = "grassy_area_icon.jpg", 
		Directives = {}
	}
}
_E6Nz = Wherigo.ZMedia(_kidO)
_E6Nz.Id = "d7a02e51-926c-43fc-beae-1c567a38dcc2"
_E6Nz.Name = _bv7r("\105\025\008\098\098\045\070\078\025\098")
_E6Nz.Description = ""
_E6Nz.AltText = ""
_E6Nz.Resources = {
	{
		Type = "jpg", 
		Filename = "resize_crosshairs.jpg", 
		Directives = {}
	}
}
_ysM = Wherigo.ZMedia(_kidO)
_ysM.Id = "6f3939b9-ce4c-4856-8c7a-53f94b67b78d"
_ysM.Name = _bv7r("\098\070\025\105\008\060\045\070\112\103\098")
_ysM.Description = ""
_ysM.AltText = ""
_ysM.Resources = {
	{
		Type = "jpg", 
		Filename = "sarcophagus.jpg", 
		Directives = {}
	}
}
-- Cartridge Info --
_kidO.Id="5fcb45d2-8955-4d75-99bf-caef4072ee2b"
_kidO.Name="The Curse of the Pharaoh"
_kidO.Description=[[]]
_kidO.Visible=true
_kidO.Activity="Fiction"
_kidO.StartingLocationDescription=[[Move to the archives building, your adventure begins there.]]
_kidO.StartingLocation = ZonePoint(37.3831938462118,-89.6667008748341,0)
_kidO.Version=""
_kidO.Company=""
_kidO.Author="Forest-Ghost"
_kidO.BuilderVersion="URWIGO 1.21.5528.18461"
_kidO.CreateDate="03/02/2015 23:22:32"
_kidO.PublishDate="1/1/0001 12:00:00 AM"
_kidO.UpdateDate="09/23/2015 11:35:18"
_kidO.LastPlayedDate="1/1/0001 12:00:00 AM"
_kidO.TargetDevice="PocketPC"
_kidO.TargetDeviceVersion="0"
_kidO.StateId="1"
_kidO.CountryId="2"
_kidO.Complete=false
_kidO.UseLogging=true

_kidO.Media=_KAOD

_kidO.Icon=_tZEe


-- Zones --
_xb1 = Wherigo.Zone(_kidO)
_xb1.Id = "5c564d65-0acf-4610-a1d7-c95119d2acd2"
_xb1.Name = _bv7r("\118\025\105\045\078\006\037\098")
_xb1.Description = ""
_xb1.Visible = true
_xb1.Media = _2HuvB
_xb1.Icon = _eZLbi
_xb1.Commands = {}
_xb1.DistanceRange = Distance(-1, "feet")
_xb1.ShowObjects = "OnEnter"
_xb1.ProximityRange = Distance(8, "meters")
_xb1.AllowSetPositionTo = false
_xb1.Active = true
_xb1.Points = {
	ZonePoint(37.383549240971, -89.6669064436503, 0), 
	ZonePoint(37.3835133285298, -89.666527803756, 0), 
	ZonePoint(37.3832258505974, -89.6665765622498, 0), 
	ZonePoint(37.3832588100205, -89.666954794484, 0)
}
_xb1.OriginalPoint = ZonePoint(37.3833868075297, -89.6667414010351, 0)
_xb1.DistanceRangeUOM = "Feet"
_xb1.ProximityRangeUOM = "Meters"
_xb1.OutOfRangeName = ""
_xb1.InRangeName = ""
_hmqPc = Wherigo.Zone(_kidO)
_hmqPc.Id = "82d8da21-2aac-486e-bba8-29493d998f9f"
_hmqPc.Name = _bv7r("\026\045\070\080\036\037\025\038\008\044\038\026\008\080\080\037\025\105\037")
_hmqPc.Description = ""
_hmqPc.Visible = true
_hmqPc.Media = _kV0
_hmqPc.Icon = _bDl5
_hmqPc.Commands = {}
_hmqPc.DistanceRange = Distance(-1, "feet")
_hmqPc.ShowObjects = "OnProximity"
_hmqPc.ProximityRange = Distance(8, "meters")
_hmqPc.AllowSetPositionTo = false
_hmqPc.Active = false
_hmqPc.Points = {
	ZonePoint(37.3822731421092, -89.6667121387665, 0), 
	ZonePoint(37.3822638904461, -89.6665553852838, 0), 
	ZonePoint(37.3823834557339, -89.6665459975522, 0), 
	ZonePoint(37.3823931530884, -89.6667029067797, 0)
}
_hmqPc.OriginalPoint = ZonePoint(37.3823284103444, -89.6666291070956, 0)
_hmqPc.DistanceRangeUOM = "Feet"
_hmqPc.ProximityRangeUOM = "Meters"
_hmqPc.OutOfRangeName = ""
_hmqPc.InRangeName = ""
_lEv = Wherigo.Zone(_kidO)
_lEv.Id = "c64fdf4c-1ed6-476e-bab6-57857fdadfa4"
_lEv.Name = _bv7r("\123\008\003\078\105\037\038\099\074\070\074\078\008\119")
_lEv.Description = ""
_lEv.Visible = true
_lEv.Media = _tggy
_lEv.Icon = _PgZ
_lEv.Commands = {}
_lEv.DistanceRange = Distance(-1, "feet")
_lEv.ShowObjects = "OnProximity"
_lEv.ProximityRange = Distance(8, "meters")
_lEv.AllowSetPositionTo = false
_lEv.Active = false
_lEv.Points = {
	ZonePoint(37.3841276978846, -89.6685532461041, 0), 
	ZonePoint(37.3842674055066, -89.6685289380494, 0), 
	ZonePoint(37.3842496570718, -89.6683515630538, 0), 
	ZonePoint(37.3841119470267, -89.6683693741964, 0)
}
_lEv.OriginalPoint = ZonePoint(37.3841891768724, -89.6684507803509, 0)
_lEv.DistanceRangeUOM = "Feet"
_lEv.ProximityRangeUOM = "Meters"
_lEv.OutOfRangeName = ""
_lEv.InRangeName = ""
_f9Om = Wherigo.Zone(_kidO)
_f9Om.Id = "02346ae9-6463-41b8-903e-e6b35fbe059d"
_f9Om.Name = _bv7r("\026\008\103\025\074\045\008\103\098\037\038\059\008\103\119\074\070\078\119")
_f9Om.Description = ""
_f9Om.Visible = true
_f9Om.Media = _HcfGL
_f9Om.Icon = _im0
_f9Om.Commands = {}
_f9Om.DistanceRange = Distance(-1, "feet")
_f9Om.ShowObjects = "OnProximity"
_f9Om.ProximityRange = Distance(8, "meters")
_f9Om.AllowSetPositionTo = false
_f9Om.Active = false
_f9Om.Points = {
	ZonePoint(37.3826577488001, -89.6677485917391, 0), 
	ZonePoint(37.3827641662553, -89.6677321821646, 0), 
	ZonePoint(37.3827527260422, -89.6675738596712, 0), 
	ZonePoint(37.3826459938133, -89.667585208771, 0)
}
_f9Om.OriginalPoint = ZonePoint(37.3827051587277, -89.6676599605865, 0)
_f9Om.DistanceRangeUOM = "Feet"
_f9Om.ProximityRangeUOM = "Meters"
_f9Om.OutOfRangeName = ""
_f9Om.InRangeName = ""
_aLLsT = Wherigo.Zone(_kidO)
_aLLsT.Id = "3c7097cd-c430-4754-ba8a-36bbfd851102"
_aLLsT.Name = _bv7r("\020\103\098\078\119\037\098\098\038\046\078\098\074\025\078\105\074")
_aLLsT.Description = ""
_aLLsT.Visible = true
_aLLsT.Media = _4Aq3
_aLLsT.Icon = _JRIi
_aLLsT.Commands = {}
_aLLsT.DistanceRange = Distance(-1, "feet")
_aLLsT.ShowObjects = "OnProximity"
_aLLsT.ProximityRange = Distance(9, "meters")
_aLLsT.AllowSetPositionTo = false
_aLLsT.Active = false
_aLLsT.Points = {
	ZonePoint(37.3819995743028, -89.6678687455155, 0), 
	ZonePoint(37.3819829402929, -89.6677147162209, 0), 
	ZonePoint(37.3820955117369, -89.6676957900597, 0), 
	ZonePoint(37.3821152328037, -89.6678483441394, 0)
}
_aLLsT.OriginalPoint = ZonePoint(37.3820483147841, -89.6677818989839, 0)
_aLLsT.DistanceRangeUOM = "Feet"
_aLLsT.ProximityRangeUOM = "Meters"
_aLLsT.OutOfRangeName = ""
_aLLsT.InRangeName = ""
_wbxAK = Wherigo.Zone(_kidO)
_wbxAK.Id = "375444bc-52cf-4fcc-b2ab-9d43c8884205"
_wbxAK.Name = _bv7r("\026\037\080\037\074\037\025\027")
_wbxAK.Description = ""
_wbxAK.Visible = true
_wbxAK.Media = _3ib
_wbxAK.Icon = _wuu
_wbxAK.Commands = {}
_wbxAK.DistanceRange = Distance(-1, "feet")
_wbxAK.ShowObjects = "OnEnter"
_wbxAK.ProximityRange = Distance(8, "meters")
_wbxAK.AllowSetPositionTo = false
_wbxAK.Active = false
_wbxAK.Points = {
	ZonePoint(37.3795535082121, -89.6688958285173, 0), 
	ZonePoint(37.3795418489258, -89.6686992554543, 0), 
	ZonePoint(37.3796788602714, -89.6686877751605, 0), 
	ZonePoint(37.3796924959311, -89.6688796021297, 0)
}
_wbxAK.OriginalPoint = ZonePoint(37.3796166783351, -89.6687906153155, 0)
_wbxAK.DistanceRangeUOM = "Feet"
_wbxAK.ProximityRangeUOM = "Meters"
_wbxAK.OutOfRangeName = ""
_wbxAK.InRangeName = ""
_ZbOI = Wherigo.Zone(_kidO)
_ZbOI.Id = "c6d2f583-8c10-4e72-b3d6-3382d6e08b50"
_ZbOI.Name = _bv7r("\023\045\037\038\083\078\098\098\078\119\112\038\118\025\074\078\044\070\105\074\098")
_ZbOI.Description = ""
_ZbOI.Visible = true
_ZbOI.Media = _yxepm
_ZbOI.Icon = __IgYp
_ZbOI.Commands = {}
_ZbOI.DistanceRange = Distance(-1, "feet")
_ZbOI.ShowObjects = "OnProximity"
_ZbOI.ProximityRange = Distance(8, "meters")
_ZbOI.AllowSetPositionTo = false
_ZbOI.Active = false
_ZbOI.Points = {
	ZonePoint(37.3695412715596, -89.671184033691, 0), 
	ZonePoint(37.3694586175747, -89.6710452592884, 0), 
	ZonePoint(37.3695662861017, -89.6709162853665, 0), 
	ZonePoint(37.3696373128259, -89.6710573132474, 0)
}
_ZbOI.OriginalPoint = ZonePoint(37.3695508720155, -89.6710507228983, 0)
_ZbOI.DistanceRangeUOM = "Feet"
_ZbOI.ProximityRangeUOM = "Meters"
_ZbOI.OutOfRangeName = ""
_ZbOI.InRangeName = ""
_sCK = Wherigo.Zone(_kidO)
_sCK.Id = "5bae8ffc-8646-49ff-bc41-28ee23f90704"
_sCK.Name = _bv7r("\117\025\070\098\098\027\038\118\025\037\070")
_sCK.Description = ""
_sCK.Visible = true
_sCK.Media = _RuC
_sCK.Icon = _0b5
_sCK.Commands = {}
_sCK.DistanceRange = Distance(-1, "feet")
_sCK.ShowObjects = "OnProximity"
_sCK.ProximityRange = Distance(8, "meters")
_sCK.AllowSetPositionTo = false
_sCK.Active = false
_sCK.Points = {
	ZonePoint(37.3833057114415, -89.6673777947876, 0), 
	ZonePoint(37.3832862104041, -89.6671797136519, 0), 
	ZonePoint(37.3834196272362, -89.6671563784334, 0), 
	ZonePoint(37.3834379560476, -89.6673494974825, 0)
}
_sCK.OriginalPoint = ZonePoint(37.3833623762823, -89.6672658460889, 0)
_sCK.DistanceRangeUOM = "Feet"
_sCK.ProximityRangeUOM = "Meters"
_sCK.OutOfRangeName = ""
_sCK.InRangeName = ""

-- Characters --
_lI8 = Wherigo.ZCharacter{
	Cartridge = _kidO, 
	Container = _xb1
}
_lI8.Id = "d97502b2-fe25-4e1d-8463-1b73ec7e2f3b"
_lI8.Name = _bv7r("\046\025\029\038\072\037\078\119\025\078\105\045")
_lI8.Description = ""
_lI8.Visible = true
_lI8.Media = _HaGJ
_lI8.Icon = _MpRPm
_lI8.Commands = {
	_SkiBI = Wherigo.ZCommand{
		Text = _bv7r("\023\070\003\061"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _bv7r("\086\008\074\045\078\119\112\038\070\006\070\078\003\070\036\003\037")
	}, 
	_PlsM = Wherigo.ZCommand{
		Text = _bv7r("\023\070\003\061"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _bv7r("\086\008\074\045\078\119\112\038\070\006\070\078\003\070\036\003\037")
	}, 
	_XThS = Wherigo.ZCommand{
		Text = _bv7r("\071\037\074\103\025\119\038\074\045\037\038\026\003\103\037\098"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _bv7r("\086\008\074\045\078\119\112\038\070\006\070\078\003\070\036\003\037")
	}, 
	_l5oD3 = Wherigo.ZCommand{
		Text = _bv7r("\023\070\003\061"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _bv7r("\086\008\074\045\078\119\112\038\070\006\070\078\003\070\036\003\037")
	}, 
	_DR6_ = Wherigo.ZCommand{
		Text = _bv7r("\023\070\003\061"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _bv7r("\086\008\074\045\078\119\112\038\070\006\070\078\003\070\036\003\037")
	}, 
	_lN4Z = Wherigo.ZCommand{
		Text = _bv7r("\023\070\003\061"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _bv7r("\086\008\074\045\078\119\112\038\070\006\070\078\003\070\036\003\037")
	}
}
_lI8.Commands._SkiBI.Custom = true
_lI8.Commands._SkiBI.Id = "6d0d4141-2573-4a77-a1ca-f2dce558ea3a"
_lI8.Commands._SkiBI.WorksWithAll = true
_lI8.Commands._PlsM.Custom = true
_lI8.Commands._PlsM.Id = "f036d254-8606-4ec4-8774-f3a14886dc71"
_lI8.Commands._PlsM.WorksWithAll = true
_lI8.Commands._XThS.Custom = true
_lI8.Commands._XThS.Id = "47c3e649-fe80-4854-8273-15a3b7936759"
_lI8.Commands._XThS.WorksWithAll = true
_lI8.Commands._l5oD3.Custom = true
_lI8.Commands._l5oD3.Id = "90353501-9ef1-4316-9938-64e23a4e2dcf"
_lI8.Commands._l5oD3.WorksWithAll = true
_lI8.Commands._DR6_.Custom = true
_lI8.Commands._DR6_.Id = "797459eb-a71a-4918-b4ca-be904b48957f"
_lI8.Commands._DR6_.WorksWithAll = true
_lI8.Commands._lN4Z.Custom = true
_lI8.Commands._lN4Z.Id = "5825ac59-3602-4ed8-b267-f7546e1de6a8"
_lI8.Commands._lN4Z.WorksWithAll = true
_lI8.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_lI8.Gender = "Male"
_lI8.Type = "NPC"
_OKa = Wherigo.ZCharacter{
	Cartridge = _kidO, 
	Container = _lEv
}
_OKa.Id = "fcb5f070-ade0-4298-8853-c0fc9802c1cc"
_OKa.Name = _bv7r("\046\037\074\037\105\074\078\006\037\038\083\070\003\008\119\037")
_OKa.Description = ""
_OKa.Visible = true
_OKa.Media = _QFIB
_OKa.Icon = _sNK
_OKa.Commands = {
	_nK106 = Wherigo.ZCommand{
		Text = _bv7r("\023\070\003\061"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _bv7r("\086\008\074\045\078\119\112\038\070\006\070\078\003\070\036\003\037")
	}, 
	_HAn = Wherigo.ZCommand{
		Text = _bv7r("\023\070\003\061"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _bv7r("\086\008\074\045\078\119\112\038\070\006\070\078\003\070\036\003\037")
	}
}
_OKa.Commands._nK106.Custom = true
_OKa.Commands._nK106.Id = "fc630655-97c2-40fd-b038-fa2c692c33f8"
_OKa.Commands._nK106.WorksWithAll = true
_OKa.Commands._HAn.Custom = true
_OKa.Commands._HAn.Id = "3cb639d2-8651-4778-aa17-e5b7670e68dc"
_OKa.Commands._HAn.WorksWithAll = true
_OKa.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_OKa.Gender = "Male"
_OKa.Type = "NPC"
_wlUY7 = Wherigo.ZCharacter{
	Cartridge = _kidO, 
	Container = _hmqPc
}
_wlUY7.Id = "ec674cce-822d-433b-87e5-601eec5779aa"
_wlUY7.Name = _bv7r("\014\027\037\038\087\078\074\119\037\098\098")
_wlUY7.Description = _bv7r("\118\119\038\037\027\037\038\069\078\074\119\037\098\098\038\069\045\008\038\070\060\060\037\070\025\098\038\074\008\038\036\037\038\078\119\038\070\038\060\070\119\078\105\029")
_wlUY7.Visible = true
_wlUY7.Media = _47O
_wlUY7.Icon = _bmw
_wlUY7.Commands = {
	_uE2 = Wherigo.ZCommand{
		Text = _bv7r("\023\070\003\061"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _bv7r("\086\008\074\045\078\119\112\038\070\006\070\078\003\070\036\003\037")
	}
}
_wlUY7.Commands._uE2.Custom = true
_wlUY7.Commands._uE2.Id = "d26e0a21-6320-4e57-bd8e-f4cbc35e6049"
_wlUY7.Commands._uE2.WorksWithAll = true
_wlUY7.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_wlUY7.Gender = "Male"
_wlUY7.Type = "NPC"
_SBHI = Wherigo.ZCharacter(_kidO)
_SBHI.Id = "ddc239d2-51b9-4484-867a-4d9251005238"
_SBHI.Name = _bv7r("\023\045\037\038\083\103\080\080\027")
_SBHI.Description = ""
_SBHI.Visible = true
_SBHI.Media = _hD4h
_SBHI.Icon = _sfkh
_SBHI.Commands = {}
_SBHI.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_SBHI.Gender = "Male"
_SBHI.Type = "NPC"

-- Items --
_DJAXy = Wherigo.ZItem(_kidO)
_DJAXy.Id = "3ee9092a-e385-4209-8da3-ee11c813f943"
_DJAXy.Name = _bv7r("\099\070\025\105\008\060\045\070\112\103\098")
_DJAXy.Description = ""
_DJAXy.Visible = true
_DJAXy.Media = _ysM
_DJAXy.Icon = _cKBj
_DJAXy.Commands = {
	_ig7 = Wherigo.ZCommand{
		Text = _bv7r("\014\013\070\080\078\119\037"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _bv7r("\086\008\074\045\078\119\112\038\070\006\070\078\003\070\036\003\037")
	}, 
	_MepI = Wherigo.ZCommand{
		Text = _bv7r("\014\013\070\080\078\119\037\038\118\112\070\078\119"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _bv7r("\086\008\074\045\078\119\112\038\070\006\070\078\003\070\036\003\037")
	}, 
	_1dEi = Wherigo.ZCommand{
		Text = _bv7r("\035\119\008\105\061\038\008\119\038\099\070\025\105\008\060\045\070\112\103\098"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _bv7r("\086\008\074\045\078\119\112\038\070\006\070\078\003\070\036\003\037")
	}, 
	_EBZ8 = Wherigo.ZCommand{
		Text = _bv7r("\108\037\070\006\037\038\099\070\025\105\008\060\045\070\112\103\098"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _bv7r("\086\008\074\045\078\119\112\038\070\006\070\078\003\070\036\003\037")
	}
}
_DJAXy.Commands._ig7.Custom = true
_DJAXy.Commands._ig7.Id = "c2da17e8-9486-4e0f-ae44-c84817c363cb"
_DJAXy.Commands._ig7.WorksWithAll = true
_DJAXy.Commands._MepI.Custom = true
_DJAXy.Commands._MepI.Id = "250ca87f-8474-47c6-8da7-6472b9f0b6b2"
_DJAXy.Commands._MepI.WorksWithAll = true
_DJAXy.Commands._1dEi.Custom = true
_DJAXy.Commands._1dEi.Id = "a6f5ad67-95c2-42ec-8152-a64a727b14ff"
_DJAXy.Commands._1dEi.WorksWithAll = true
_DJAXy.Commands._EBZ8.Custom = true
_DJAXy.Commands._EBZ8.Id = "1a2eb17c-be83-40b1-88cc-fde1c39e38eb"
_DJAXy.Commands._EBZ8.WorksWithAll = true
_DJAXy.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_DJAXy.Locked = false
_DJAXy.Opened = false
_TkUP = Wherigo.ZItem(_kidO)
_TkUP.Id = "48764809-7f21-42c9-ac77-4f4c27ef5ddc"
_TkUP.Name = _bv7r("\020\070\119\094\070\112\037\098")
_TkUP.Description = _bv7r("\099\008\080\037\038\036\070\119\094\070\112\037\098\038\074\045\070\074\038\027\008\103\038\044\008\103\119\094\038\003\070\027\078\119\112\038\119\037\070\025\038\074\045\037\038\044\008\103\119\074\070\078\119\029")
_TkUP.Visible = true
_TkUP.Media = _zv9
_TkUP.Icon = _MN1
_TkUP.Commands = {}
_TkUP.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_TkUP.Locked = false
_TkUP.Opened = false
_Xcr = Wherigo.ZItem(_kidO)
_Xcr.Id = "0f21f9a3-477a-4726-b9fc-4493129ad4d7"
_Xcr.Name = _bv7r("\123\003\070\027\037\025\038\026\008\080\060\003\037\074\078\008\119\038\026\008\094\037")
_Xcr.Description = ""
_Xcr.Visible = true
_Xcr.Media = _pshlB
_Xcr.Commands = {}
_Xcr.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_Xcr.Locked = false
_Xcr.Opened = false
_BQh = Wherigo.ZItem{
	Cartridge = _kidO, 
	Container = _aLLsT
}
_BQh.Id = "c0775b43-eb58-4fee-a3a0-ce6872e2209a"
_BQh.Name = _bv7r("\026\025\070\105\061\037\094\038\087\078\119\094\008\069")
_BQh.Description = ""
_BQh.Visible = true
_BQh.Media = _Rh_FW
_BQh.Icon = _n8h7
_BQh.Commands = {
	_1Ooe = Wherigo.ZCommand{
		Text = _bv7r("\014\013\070\080\078\119\037"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _bv7r("\086\008\074\045\078\119\112\038\070\006\070\078\003\070\036\003\037")
	}
}
_BQh.Commands._1Ooe.Custom = true
_BQh.Commands._1Ooe.Id = "ebb28377-8015-4ea6-a75e-00322a125e15"
_BQh.Commands._1Ooe.WorksWithAll = true
_BQh.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_BQh.Locked = false
_BQh.Opened = false
_quoe8 = Wherigo.ZItem(_kidO)
_quoe8.Id = "413429c4-e401-4753-a856-9680029f5f03"
_quoe8.Name = _bv7r("\014\006\078\094\037\119\105\037\038\020\008\013")
_quoe8.Description = _bv7r("\059\078\003\003\037\094\038\069\078\074\045\038\037\006\078\094\037\119\105\037\038\074\045\070\074\038\027\008\103\038\044\008\103\119\094\038\070\074\038\074\045\037\038\105\025\078\080\037\038\098\105\037\119\037\098\029")
_quoe8.Visible = true
_quoe8.Media = _FfNCM
_quoe8.Icon = _a14Zg
_quoe8.Commands = {}
_quoe8.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_quoe8.Locked = false
_quoe8.Opened = false
_FP9 = Wherigo.ZItem(_kidO)
_FP9.Id = "2f3c7f24-5564-42b6-bc3a-48d8caa1da0d"
_FP9.Name = _bv7r("\059\008\103\119\074\070\078\119")
_FP9.Description = ""
_FP9.Visible = true
_FP9.Media = _HcfGL
_FP9.Commands = {
	_6tcV = Wherigo.ZCommand{
		Text = _bv7r("\014\013\070\080\078\119\037"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _bv7r("\086\008\074\045\078\119\112\038\070\006\070\078\003\070\036\003\037")
	}
}
_FP9.Commands._6tcV.Custom = true
_FP9.Commands._6tcV.Id = "b7a67945-c04f-4488-83c1-b1e066a666d9"
_FP9.Commands._6tcV.WorksWithAll = true
_FP9.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_FP9.Locked = false
_FP9.Opened = false
_rP9z = Wherigo.ZItem(_kidO)
_rP9z.Id = "f4fd25b8-6738-4ae7-ab3c-cc0cda8848db"
_rP9z.Name = _bv7r("\014\112\027\060\074\078\070\119\038\020\008\008\061\038\008\044\038\074\045\037\038\046\037\070\094")
_rP9z.Description = ""
_rP9z.Visible = true
_rP9z.Media = _vD_
_rP9z.Icon = _N9ap
_rP9z.Commands = {
	_1WJX = Wherigo.ZCommand{
		Text = _bv7r("\071\037\070\094"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _bv7r("\086\008\074\045\078\119\112\038\070\006\070\078\003\070\036\003\037")
	}
}
_rP9z.Commands._1WJX.Custom = true
_rP9z.Commands._1WJX.Id = "0d768034-eae4-4eb5-8405-e500ff058b4b"
_rP9z.Commands._1WJX.WorksWithAll = true
_rP9z.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_rP9z.Locked = false
_rP9z.Opened = false
_g8T = Wherigo.ZItem(_kidO)
_g8T.Id = "0514ed6f-2187-4f18-a6d9-2113e2523d24"
_g8T.Name = _bv7r("\099\045\008\074\112\103\119")
_g8T.Description = ""
_g8T.Visible = true
_g8T.Media = _cet0
_g8T.Icon = ___xZq
_g8T.Commands = {
	_OFAz = Wherigo.ZCommand{
		Text = _bv7r("\059\078\025\037\038\117\103\119"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _bv7r("\086\008\074\045\078\119\112\038\070\006\070\078\003\070\036\003\037")
	}, 
	_INsP = Wherigo.ZCommand{
		Text = _bv7r("\059\078\025\037\038\117\103\119\038\070\074\038\083\103\080\080\027"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _bv7r("\086\008\074\045\078\119\112\038\070\006\070\078\003\070\036\003\037")
	}, 
	_FjB = Wherigo.ZCommand{
		Text = _bv7r("\071\037\003\008\070\094"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _bv7r("\086\008\074\045\078\119\112\038\070\006\070\078\003\070\036\003\037")
	}
}
_g8T.Commands._OFAz.Custom = true
_g8T.Commands._OFAz.Id = "647e1ad7-3871-424f-aad4-09ccd3faae5e"
_g8T.Commands._OFAz.WorksWithAll = true
_g8T.Commands._INsP.Custom = true
_g8T.Commands._INsP.Id = "1e7b9339-ec67-4202-9d8e-fb613dde418f"
_g8T.Commands._INsP.WorksWithAll = true
_g8T.Commands._FjB.Custom = true
_g8T.Commands._FjB.Id = "5893cdd0-2eb7-4a6d-9431-e37b8bbb5888"
_g8T.Commands._FjB.WorksWithAll = true
_g8T.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_g8T.Locked = false
_g8T.Opened = false
_Px4z7 = Wherigo.ZItem(_kidO)
_Px4z7.Id = "79e166b6-5b44-447c-9134-67db2d828830"
_Px4z7.Name = _bv7r("\117\103\119\038\026\070\098\037")
_Px4z7.Description = ""
_Px4z7.Visible = true
_Px4z7.Media = _Fk9
_Px4z7.Icon = _YGWxm
_Px4z7.Commands = {
	_wkQZ = Wherigo.ZCommand{
		Text = _bv7r("\014\013\070\080\078\119\037"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _bv7r("\086\008\074\045\078\119\112\038\070\006\070\078\003\070\036\003\037")
	}, 
	_0FVB = Wherigo.ZCommand{
		Text = _bv7r("\023\070\061\037\038\117\103\119"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _bv7r("\086\008\074\045\078\119\112\038\070\006\070\078\003\070\036\003\037")
	}
}
_Px4z7.Commands._wkQZ.Custom = true
_Px4z7.Commands._wkQZ.Id = "6ba5d06f-298f-470f-a60f-195d747e4909"
_Px4z7.Commands._wkQZ.WorksWithAll = true
_Px4z7.Commands._0FVB.Custom = true
_Px4z7.Commands._0FVB.Id = "fc503578-8c56-4ee7-ab6d-49e9bac0d6b2"
_Px4z7.Commands._0FVB.WorksWithAll = true
_Px4z7.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_Px4z7.Locked = false
_Px4z7.Opened = false
_2sX = Wherigo.ZItem(_kidO)
_2sX.Id = "d2ed7845-1be9-4088-8d39-f3791cd2336c"
_2sX.Name = _bv7r("\099\045\037\003\003\098")
_2sX.Description = ""
_2sX.Visible = true
_2sX.Media = _s5BQ
_2sX.Icon = _yK2Eu
_2sX.Commands = {
	_t4F = Wherigo.ZCommand{
		Text = _bv7r("\071\037\003\008\070\094"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _bv7r("\086\008\074\045\078\119\112\038\070\006\070\078\003\070\036\003\037")
	}
}
_2sX.Commands._t4F.Custom = true
_2sX.Commands._t4F.Id = "47615186-b021-4b62-ab8f-e3c810e641e0"
_2sX.Commands._t4F.WorksWithAll = true
_2sX.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_2sX.Locked = false
_2sX.Opened = false
_zm20a = Wherigo.ZItem{
	Cartridge = _kidO, 
	Container = _sCK
}
_zm20a.Id = "7cf7f0ec-2792-4c07-a8f8-33323f2a3f00"
_zm20a.Name = _bv7r("\118\119\061\045\038\023\070\003\078\098\080\070\119")
_zm20a.Description = ""
_zm20a.Visible = true
_zm20a.Media = _t6H1T
_zm20a.Icon = _toZh7
_zm20a.Commands = {
	_6sz96 = Wherigo.ZCommand{
		Text = _bv7r("\123\078\105\061\038\065\060"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _bv7r("\086\008\074\045\078\119\112\038\070\006\070\078\003\070\036\003\037")
	}, 
	_lRae = Wherigo.ZCommand{
		Text = _bv7r("\065\098\037"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _bv7r("\086\008\074\045\078\119\112\038\070\006\070\078\003\070\036\003\037")
	}, 
	_E1L = Wherigo.ZCommand{
		Text = _bv7r("\065\098\037\038\008\119\038\083\103\080\080\027"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _bv7r("\086\008\074\045\078\119\112\038\070\006\070\078\003\070\036\003\037")
	}
}
_zm20a.Commands._6sz96.Custom = true
_zm20a.Commands._6sz96.Id = "388b256d-c863-4412-87d5-5d3bcf723459"
_zm20a.Commands._6sz96.WorksWithAll = true
_zm20a.Commands._lRae.Custom = true
_zm20a.Commands._lRae.Id = "c493747f-9284-40f8-b2ee-53edd804c579"
_zm20a.Commands._lRae.WorksWithAll = true
_zm20a.Commands._E1L.Custom = true
_zm20a.Commands._E1L.Id = "a1eb0adb-885b-4f00-bb03-48be24e01523"
_zm20a.Commands._E1L.WorksWithAll = true
_zm20a.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_zm20a.Locked = false
_zm20a.Opened = false
_Od32O = Wherigo.ZItem(_kidO)
_Od32O.Id = "53d8e8e4-e6a7-4072-97d6-b3e4633cff1e"
_Od32O.Name = _bv7r("\083\070\060")
_Od32O.Description = _bv7r("\023\045\037\038\080\078\098\098\078\119\112\038\070\025\074\078\044\070\105\074\098\038\070\025\037\038\003\008\105\070\074\037\094\038\070\074\038\086\038\092\021\038\106\106\029\001\021\092\038\087\038\012\122\082\038\049\012\029\106\011\106\029")
_Od32O.Visible = true
_Od32O.Media = _dncmT
_Od32O.Icon = _1zo
_Od32O.Commands = {}
_Od32O.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_Od32O.Locked = false
_Od32O.Opened = false
_nxmF = Wherigo.ZItem(_kidO)
_nxmF.Id = "aa377787-dffd-465b-8d7c-a276f758d098"
_nxmF.Name = _bv7r("\105\045\037\070\074")
_nxmF.Description = ""
_nxmF.Visible = true
_nxmF.Commands = {
	_40_UY = Wherigo.ZCommand{
		Text = _bv7r("\105\045\037\070\074"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _bv7r("\086\008\074\045\078\119\112\038\070\006\070\078\003\070\036\003\037")
	}
}
_nxmF.Commands._40_UY.Custom = true
_nxmF.Commands._40_UY.Id = "1b1e8a9a-123a-46d7-87a8-b081cd54625d"
_nxmF.Commands._40_UY.WorksWithAll = true
_nxmF.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_nxmF.Locked = false
_nxmF.Opened = false
_j76v = Wherigo.ZItem{
	Cartridge = _kidO, 
	Container = Player
}
_j76v.Id = "ca4cffcc-3488-4142-b9c0-a1e871bdb3f3"
_j76v.Name = _bv7r("\086\008\074\037\060\070\094")
_j76v.Description = _bv7r("\118\038\119\008\074\037\060\070\094\038\044\008\025\038\074\070\061\078\119\112\038\119\008\074\037\098\029")
_j76v.Visible = true
_j76v.Media = _lRjdS
_j76v.Icon = _oaZIr
_j76v.Commands = {
	_I1b1 = Wherigo.ZCommand{
		Text = _bv7r("\014\013\070\080\078\119\037"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _bv7r("\086\008\074\045\078\119\112\038\070\006\070\078\003\070\036\003\037")
	}, 
	_rSk = Wherigo.ZCommand{
		Text = _bv7r("\087\025\078\074\037\038\086\008\074\037"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _bv7r("\086\008\074\045\078\119\112\038\070\006\070\078\003\070\036\003\037")
	}
}
_j76v.Commands._I1b1.Custom = true
_j76v.Commands._I1b1.Id = "3d336525-9e83-409b-9010-1e76e149bea0"
_j76v.Commands._I1b1.WorksWithAll = true
_j76v.Commands._rSk.Custom = true
_j76v.Commands._rSk.Id = "21d9ff63-d9c0-4794-92dc-030ae742b948"
_j76v.Commands._rSk.WorksWithAll = true
_j76v.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_j76v.Locked = false
_j76v.Opened = false

-- Tasks --
_d5hWj = Wherigo.ZTask(_kidO)
_d5hWj.Id = "5018201b-9318-4fc0-9745-0bda83998144"
_d5hWj.Name = _bv7r("\023\070\003\061\038\074\008\038\046\025\029\038\072\037\078\119\025\078\105\045")
_d5hWj.Description = _bv7r("\099\008\080\037\074\045\078\119\112\038\045\070\098\038\045\070\060\060\037\119\037\094\038\074\008\038\046\025\029\038\072\037\078\119\025\078\105\045\091\098\038\037\013\045\078\036\078\074\029\038\072\037\070\094\038\074\008\038\074\045\037\038\070\025\105\045\078\006\037\098\038\074\008\038\044\078\119\094\038\008\103\074\038\069\045\070\074\038\045\070\060\060\037\119\037\094\029")
_d5hWj.Visible = true
_d5hWj.Media = _tKkz
_d5hWj.Icon = _AXpR
_d5hWj.Active = false
_d5hWj.Complete = false
_d5hWj.CorrectState = "None"
_iwwR6 = Wherigo.ZTask(_kidO)
_iwwR6.Id = "538db3ef-365c-4ce4-af8d-e69f1e3e9275"
_iwwR6.Name = _bv7r("\120\119\006\037\098\074\078\112\070\074\037\038\074\045\037\038\105\003\103\037\098")
_iwwR6.Description = _bv7r("\117\008\038\074\008\038\074\045\037\038\003\008\105\070\074\078\008\119\098\038\074\045\070\074\038\046\025\029\038\072\037\078\119\025\078\105\045\038\045\070\098\038\080\070\025\061\037\094\038\008\119\038\027\008\103\025\038\080\070\060\029\038\062\008\103\038\069\078\003\003\038\119\037\037\094\038\074\008\038\037\013\070\080\078\119\037\038\070\038\060\003\070\110\103\037\047\038\078\119\074\037\025\006\078\037\069\038\070\119\038\037\027\037\069\078\074\119\037\098\098\038\070\119\094\038\078\119\006\037\098\074\078\112\070\074\037\038\070\038\105\025\078\080\037\038\098\105\037\119\037\029")
_iwwR6.Visible = true
_iwwR6.Media = _tKkz
_iwwR6.Icon = _AXpR
_iwwR6.Active = false
_iwwR6.Complete = false
_iwwR6.CorrectState = "None"
_CjI = Wherigo.ZTask(_kidO)
_CjI.Id = "1834a6bb-a762-41ec-810b-c8e06df7e770"
_CjI.Name = _bv7r("\059\078\119\094\038\074\045\037\038\083\078\098\098\078\119\112\038\118\119\061\045\038\023\070\003\078\098\080\070\119")
_CjI.Description = _bv7r("\023\045\037\038\118\119\061\045\038\098\027\080\036\008\003\038\069\045\078\105\045\038\069\070\098\038\008\119\038\074\008\060\038\008\044\038\074\045\037\038\098\070\025\105\008\060\045\008\112\103\098\038\078\098\038\080\078\098\098\078\119\112\029\038\059\078\119\094\038\008\103\074\038\069\045\070\074\038\045\070\060\060\037\119\037\094\038\074\008\038\078\074\029")
_CjI.Visible = true
_CjI.Media = _tKkz
_CjI.Icon = _AXpR
_CjI.Active = false
_CjI.Complete = false
_CjI.CorrectState = "None"
_Rrr = Wherigo.ZTask(_kidO)
_Rrr.Id = "49701bb9-56ad-4c57-b5ee-518479c83608"
_Rrr.Name = _bv7r("\120\119\006\037\098\074\078\112\070\074\037\038\074\045\037\038\099\070\025\105\008\060\045\070\112\103\098")
_Rrr.Description = _bv7r("\026\003\008\098\037\003\027\038\037\013\070\080\078\119\037\038\074\045\037\038\037\080\060\074\027\038\098\070\025\105\008\060\045\070\112\103\098\038\078\119\038\074\045\037\038\050\078\074\037\080\098\050\038\080\037\119\103\038\044\008\025\038\070\119\027\038\037\013\074\025\070\038\105\003\103\037\098\029")
_Rrr.Visible = true
_Rrr.Media = _tKkz
_Rrr.Icon = _AXpR
_Rrr.Active = false
_Rrr.Complete = false
_Rrr.CorrectState = "None"
_u5RCe = Wherigo.ZTask(_kidO)
_u5RCe.Id = "47bb467e-f2c9-40b5-b59e-ea8108ae92f4"
_u5RCe.Name = _bv7r("\023\070\061\037\038\094\008\069\119\038\074\045\037\038\083\103\080\080\027")
_u5RCe.Description = _bv7r("\023\045\037\038\080\103\080\080\027\038\045\070\098\038\070\060\060\037\070\025\037\094\038\078\119\038\074\045\037\038\105\037\080\037\074\037\025\027\029\038\062\008\103\038\069\078\003\003\038\119\037\037\094\038\074\008\038\044\078\119\094\038\070\038\069\070\027\038\074\008\038\074\070\061\037\038\045\078\080\038\094\008\069\119\029\038\099\060\037\070\061\038\074\008\038\046\037\074\037\105\074\078\006\037\038\083\070\003\008\119\037\038\008\025\038\046\025\029\038\072\037\078\119\025\078\105\045\038\044\008\025\038\098\008\080\037\038\078\094\037\070\098\038\008\119\038\045\008\069\038\074\008\038\074\070\061\037\038\045\078\080\038\094\008\069\119\029")
_u5RCe.Visible = true
_u5RCe.Media = _tKkz
_u5RCe.Icon = _AXpR
_u5RCe.Active = false
_u5RCe.Complete = false
_u5RCe.CorrectState = "None"
_bZZo = Wherigo.ZTask(_kidO)
_bZZo.Id = "ee408b63-420c-4c93-89b4-3940199c1b23"
_bZZo.Name = _bv7r("\059\078\119\094\038\074\045\037\038\083\078\098\098\078\119\112\038\118\025\074\078\044\070\105\074\098")
_bZZo.Description = _bv7r("\120\074\038\078\098\038\025\103\080\008\025\037\094\038\074\045\070\074\038\074\045\037\038\080\103\080\080\027\038\045\070\094\038\070\038\105\008\003\003\037\105\074\078\008\119\038\008\044\038\025\070\025\037\038\070\025\074\078\044\070\105\074\098\029\038\059\078\119\094\038\074\045\037\038\080\078\098\098\078\119\112\038\070\025\074\078\044\070\105\074\098\029\038")
_bZZo.Visible = true
_bZZo.Media = _tKkz
_bZZo.Icon = _AXpR
_bZZo.Active = false
_bZZo.Complete = false
_bZZo.CorrectState = "None"
_PcPS0 = Wherigo.ZTask(_kidO)
_PcPS0.Id = "96a59ec6-653f-46d5-a6f9-37af7cf37d1b"
_PcPS0.Name = _bv7r("\071\037\074\103\025\119\038\074\045\037\038\026\003\103\037\098")
_PcPS0.Description = _bv7r("\071\037\074\103\025\119\038\074\008\038\046\025\029\038\072\037\078\119\025\078\105\045\038\074\008\038\025\037\060\008\025\074\038\027\008\103\025\038\044\078\119\094\078\119\112\098\029")
_PcPS0.Visible = true
_PcPS0.Media = _tKkz
_PcPS0.Icon = _AXpR
_PcPS0.Active = false
_PcPS0.Complete = false
_PcPS0.CorrectState = "None"

-- Cartridge Variables --
_oKZpY = ""
_nAxf = ""
_ENDaA = ""
_FknQ = ""
_N8tIi = 0
_pkXBJ = ""
_DRDB = ""
_tEbR = 0
_vvmV = 3
_oJjIW = 6
_G83 = 8
_pCBkn = ""
_q7r = _bv7r("\084\013\036\001")
_t9c = _bv7r("\084\003\120\122")
_2UOan = _bv7r("\084\046\043\118\048\027")
_9vx2 = _bv7r("\084\094\002\045\087\113")
_MO5 = _bv7r("\084\113\122\065\083\014")
_3c2 = _bv7r("\084\078\044\118\011")
_kidO.ZVariables = {
	_oKZpY = "", 
	_nAxf = "", 
	_ENDaA = "", 
	_FknQ = "", 
	_N8tIi = 0, 
	_pkXBJ = "", 
	_DRDB = "", 
	_tEbR = 0, 
	_vvmV = 3, 
	_oJjIW = 6, 
	_G83 = 8, 
	_pCBkn = "", 
	_q7r = _bv7r("\084\013\036\001"), 
	_t9c = _bv7r("\084\003\120\122"), 
	_2UOan = _bv7r("\084\046\043\118\048\027"), 
	_9vx2 = _bv7r("\084\094\002\045\087\113"), 
	_MO5 = _bv7r("\084\113\122\065\083\014"), 
	_3c2 = _bv7r("\084\078\044\118\011")
}

-- Timers --
_ifA6 = Wherigo.ZTimer(_kidO)
_ifA6.Id = "0a3a60ec-6bc6-47db-8bdb-3e2694592b2a"
_ifA6.Name = _bv7r("\118\119\061\045\038\023\078\080\037\025")
_ifA6.Description = ""
_ifA6.Visible = true
_ifA6.Duration = 3
_ifA6.Type = "Countdown"
_MrGlR = Wherigo.ZTimer(_kidO)
_MrGlR.Id = "0a2ce036-1e78-4d49-9438-1a4665b720f5"
_MrGlR.Name = _bv7r("\083\103\080\080\027\038\087\070\003\061\078\119\112")
_MrGlR.Description = ""
_MrGlR.Visible = true
_MrGlR.Duration = 8
_MrGlR.Type = "Countdown"
_IGU = Wherigo.ZTimer(_kidO)
_IGU.Id = "e0958ab4-49b3-4a22-a54a-68944e3a1a2d"
_IGU.Name = _bv7r("\083\103\080\080\027\038\118\074\074\070\105\061")
_IGU.Description = ""
_IGU.Visible = true
_IGU.Duration = 16
_IGU.Type = "Countdown"

-- Inputs --
_j8UME = Wherigo.ZInput(_kidO)
_j8UME.Id = "597ff265-d39b-4fb4-86d8-1d4d0d27380a"
_j8UME.Name = _bv7r("\087\078\003\003\038\027\008\103\038\045\037\003\060\038\080\037\038\078\119\006\037\098\074\078\112\070\074\037\038\080\027\038\080\078\098\098\078\119\112\038\037\013\045\078\036\078\074\022")
_j8UME.Description = ""
_j8UME.Visible = true
_j8UME.Media = _HaGJ
_j8UME.Choices = {
	"Yes", 
	"No"
}
_j8UME.InputType = "MultipleChoice"
_j8UME.Text = _bv7r("\087\078\003\003\038\027\008\103\038\045\037\003\060\038\080\037\038\078\119\006\037\098\074\078\112\070\074\037\038\080\027\038\080\078\098\098\078\119\112\038\037\013\045\078\036\078\074\022")
__6f = Wherigo.ZInput(_kidO)
__6f.Id = "8af95840-db61-4e73-86b2-642456aba7d3"
__6f.Name = _bv7r("\059\008\103\119\074\070\078\119\038\123\003\070\110\103\037")
__6f.Description = ""
__6f.Visible = true
__6f.Media = _HcfGL
__6f.InputType = "Text"
__6f.Text = _bv7r("\062\008\103\038\098\037\037\038\098\105\025\070\074\105\045\038\080\070\025\061\098\038\119\037\070\025\038\074\045\037\038\069\008\025\094\038\078\119\038\074\045\037\038\105\037\119\074\037\025\038\008\044\038\074\045\037\038\060\003\070\110\103\037\029\038\087\045\070\074\038\078\098\038\074\045\078\098\038\069\008\025\094\022")
_jLPw = Wherigo.ZInput(_kidO)
_jLPw.Id = "dcf278c3-4c8a-434d-8909-706e9cce1261"
_jLPw.Name = _bv7r("\080\078\098\098\078\119\112\038\070\025\074\078\044\070\105\074\098\038\120\119\060\103\074")
_jLPw.Description = ""
_jLPw.Visible = true
_jLPw.Media = _yxepm
_jLPw.Choices = {
	"Yes", 
	"No", 
	"Need Hint"
}
_jLPw.InputType = "MultipleChoice"
_jLPw.Text = _bv7r("\046\078\094\038\027\008\103\038\044\078\119\094\038\074\045\037\038\080\078\098\098\078\119\112\038\070\025\074\078\044\070\105\074\098")
_ieJ = Wherigo.ZInput(_kidO)
_ieJ.Id = "3e0f89e7-896a-474a-99f9-617606223d9a"
_ieJ.Name = _bv7r("\120\119\094\078\070\119\038\099\074\070\074\103\037\038\120\119\060\103\074")
_ieJ.Description = ""
_ieJ.Visible = true
_ieJ.Media = _47O
_ieJ.InputType = "Text"
_ieJ.Text = _bv7r("\087\045\070\074\038\078\098\038\074\045\037\038\044\078\025\098\074\038\094\070\074\037\038\027\008\103\038\098\037\037\038\080\070\025\061\037\094\038\119\037\070\025\038\074\045\037\038\074\008\060\038\008\044\038\074\045\037\038\060\003\070\110\103\037\022")
_IS_R = Wherigo.ZInput(_kidO)
_IS_R.Id = "6f8bb145-c351-4042-978b-6e92bff3d534"
_IS_R.Name = _bv7r("\117\008\038\069\078\074\045\038\074\045\037\038\094\037\074\037\105\074\078\006\037\038\083\070\003\008\119\037\022")
_IS_R.Description = ""
_IS_R.Visible = true
_IS_R.Media = _QFIB
_IS_R.Choices = {
	"Yes", 
	"No"
}
_IS_R.InputType = "MultipleChoice"
_IS_R.Text = _bv7r("\087\037\038\070\025\037\038\112\008\078\119\112\038\074\008\038\094\025\078\006\037\038\074\008\038\074\045\037\038\105\037\080\037\074\037\025\027\038\119\008\069\038\074\008\038\078\119\006\037\098\074\078\112\070\074\037\029\038\087\078\003\003\038\027\008\103\038\105\008\080\037\038\069\078\074\045\038\103\098\022")
_HfHIB = Wherigo.ZInput(_kidO)
_HfHIB.Id = "7d750471-d6bb-46a3-803f-21f40652a3cc"
_HfHIB.Name = _bv7r("\098\070\025\105\008\060\045\070\112\103\098")
_HfHIB.Description = ""
_HfHIB.Visible = true
_HfHIB.Media = _ysM
_HfHIB.Choices = {
	"Examine Again", 
	"Leave"
}
_HfHIB.InputType = "MultipleChoice"
_HfHIB.Text = ""
_oUfC = Wherigo.ZInput(_kidO)
_oUfC.Id = "6def10c0-950f-414f-95de-8b4186309a0e"
_oUfC.Name = _bv7r("\087\025\078\074\037\038\086\008\074\037")
_oUfC.Description = ""
_oUfC.Visible = true
_oUfC.InputType = "Text"
_oUfC.Text = _bv7r("\087\025\078\074\037\038\070\038\119\008\074\037\038\045\037\025\037\115")

-- WorksWithList for object commands --

-- functions --
function _kidO:OnStart()
	_N8tIi = 0
	_lI8.Commands._PlsM.Enabled = false
	_lI8.Commands._XThS.Enabled = false
	_g8T.Commands._INsP.Enabled = false
	_d5hWj.Active = true
	_lI8.Commands._lN4Z.Enabled = false
	_lI8.Commands._DR6_.Enabled = false
	_lI8.Commands._XThS.Enabled = false
	_zm20a.Commands._E1L.Enabled = false
	_zm20a.Commands._lRae.Enabled = false
	_OKa.Commands._HAn.Enabled = false
	_lI8.Commands._l5oD3.Enabled = false
	_vvmV = 3
	_2sX.Description = (_bv7r("\062\008\103\038\105\103\025\025\037\119\074\003\027\038\045\070\006\037\038").._vvmV).._bv7r("\038\036\008\013\037\121\098\076\038\008\044\038\098\045\037\003\003\098\029")
	_Urwigo.MessageBox{
		Text = _bv7r("\023\045\037\038\026\103\025\098\037\038\008\044\038\074\045\037\038\123\045\070\025\070\008\045\115\038\078\119\038\074\045\078\098\038\069\045\037\025\078\112\008\038\027\008\103\038\069\078\003\003\038\119\037\037\094\038\074\008\038\098\008\003\006\037\038\074\045\037\038\080\027\098\074\037\025\027\038\008\044\038\074\045\037\038\060\045\070\025\070\008\045\038\070\119\094\038\045\037\003\060\038\074\045\037\038\060\025\008\044\037\098\098\008\025\038\112\037\074\038\036\070\105\061\038\045\078\098\038\080\078\098\098\078\119\112\038\037\013\045\078\036\078\074\029\038"), 
		Media = _HML, 
		Callback = function(action)
			if action ~= nil then
				_Urwigo.MessageBox{
					Text = _bv7r("\120\044\038\027\008\103\038\112\037\074\038\098\074\103\105\061\038\070\003\008\119\112\038\074\045\037\038\069\070\027\038\105\045\037\105\061\038\074\045\037\038\050\074\070\098\061\098\050\038\080\037\119\103\038\044\008\025\038\045\078\119\074\098\029\038"), 
					Media = _tKkz, 
					Callback = function(action)
						if action ~= nil then
							_Urwigo.MessageBox{
								Text = _bv7r("\023\045\037\025\037\038\070\025\037\038\070\038\006\070\025\078\037\074\027\038\008\044\038\078\074\037\080\098\047\038\105\045\070\025\070\105\074\037\025\098\038\070\119\094\038\003\008\105\070\074\078\008\119\098\038\074\045\070\074\038\027\008\103\038\069\078\003\003\038\119\037\037\094\038\074\008\038\078\119\074\037\025\070\105\074\038\069\078\074\045\038\070\003\008\119\112\038\074\045\037\038\069\070\027\029\038\083\070\061\037\038\098\103\025\037\038\074\008\038\098\037\070\025\105\045\038\037\070\105\045\038\070\025\037\070\038\074\045\008\025\008\103\112\045\003\027\029"), 
								Media = _MjO, 
								Callback = function(action)
									if action ~= nil then
										_Urwigo.MessageBox{
											Text = _bv7r("\123\025\008\105\037\037\094\038\074\008\038\074\045\037\038\070\025\105\045\078\006\037\098\038\036\103\078\003\094\078\119\112\038\119\008\069\038\074\008\038\098\060\037\070\061\038\069\078\074\045\038\046\025\029\038\072\037\078\119\025\078\105\045\029\038\072\037\038\078\098\038\069\070\078\074\078\119\112\038\074\045\037\025\037\038\069\078\074\045\038\070\038\080\078\098\098\078\008\119\038\044\008\025\038\027\008\103\029\038"), 
											Media = _2HuvB, 
											Callback = function(action)
												if action ~= nil then
													Wherigo.ShowScreen(Wherigo.MAINSCREEN)
												end
											end
										}
									end
								end
							}
						end
					end
				}
			end
		end
	}
end
function _kidO:OnRestore()
end
function _xb1:OnEnter()
	_q7r = _bv7r("\084\013\036\001")
	_Urwigo.MessageBox{
		Text = _bv7r("\023\045\078\098\038\078\098\038\074\045\037\038\118\025\105\045\078\006\037\098\038\036\103\078\003\094\078\119\112\038\069\045\037\025\037\038\046\025\029\038\072\037\078\119\025\078\105\045\038\094\008\037\098\038\045\078\098\038\025\037\098\037\070\025\105\045\029\038\099\060\037\070\061\038\074\008\038\045\078\080\038\069\045\037\119\038\027\008\103\038\112\037\074\038\070\038\105\045\070\119\105\037\029"), 
		Media = _2HuvB, 
		Callback = function(action)
			if action ~= nil then
				Wherigo.ShowScreen(Wherigo.MAINSCREEN)
			end
		end
	}
end
function _xb1:OnExit()
	_q7r = _bv7r("\084\013\036\001")
	if _tEbR == 1 then
		_sCK.Active = true
		_Urwigo.MessageBox{
			Text = _bv7r("\118\098\038\027\008\103\038\003\037\070\006\037\038\074\045\037\038\070\025\105\045\078\006\037\098\038\036\103\078\003\094\078\119\112\038\027\008\103\038\119\008\074\078\105\037\038\098\008\080\037\038\098\105\025\070\060\037\038\080\070\025\061\098\038\008\119\038\074\045\037\038\098\078\094\037\069\070\003\061\038\074\008\038\074\045\037\038\069\037\098\074\029"), 
			Media = _MjO, 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.MessageBox{
						Text = _bv7r("\062\008\103\038\098\045\008\103\003\094\038\078\119\006\037\098\074\078\112\070\074\037\038\074\045\037\038\070\025\037\070\029\038\120\074\038\070\060\060\037\070\025\098\038\098\008\080\037\074\045\078\119\112\038\069\070\098\038\094\025\070\112\112\037\094\038\074\045\025\008\103\112\045\038\074\045\037\038\112\025\070\098\098\029"), 
						Media = _MjO
					}
				end
			end
		}
	end
end
function _xb1:OnProximity()
	_q7r = _bv7r("\084\013\036\001")
	_Urwigo.GlobalZoneProximity()
end
function _xb1:OnSetActive()
	_q7r = _bv7r("\084\013\036\001")
	_Urwigo.GlobalZoneActiveChanged()
end
function _hmqPc:OnProximity()
	_q7r = _bv7r("\084\045\080\110\123\105")
	_Urwigo.GlobalZoneProximity()
	_Urwigo.MessageBox{
		Text = _bv7r("\118\098\038\027\008\103\038\119\037\070\025\038\074\045\037\038\105\045\070\080\036\037\025\038\008\044\038\105\008\080\080\037\025\105\037\038\027\008\103\038\098\037\037\038\070\038\105\025\070\090\037\094\038\037\027\037\069\078\074\119\037\098\098\038\098\074\070\119\094\078\119\112\038\119\037\070\025\036\027\029"), 
		Media = _kV0, 
		Callback = function(action)
			if action ~= nil then
				Wherigo.ShowScreen(Wherigo.MAINSCREEN)
			end
		end
	}
end
function _hmqPc:OnSetActive()
	_q7r = _bv7r("\084\045\080\110\123\105")
	_Urwigo.GlobalZoneActiveChanged()
end
function _lEv:OnProximity()
	_q7r = _bv7r("\084\003\014\006")
	_Urwigo.GlobalZoneProximity()
	_Urwigo.MessageBox{
		Text = _bv7r("\118\098\038\027\008\103\038\037\119\074\037\025\038\074\045\037\038\060\008\003\078\105\037\038\098\074\070\074\078\008\119\038\027\008\103\038\098\037\037\038\098\037\006\037\025\070\003\038\008\044\044\078\105\037\025\098\038\025\103\119\119\078\119\112\038\070\025\008\103\119\094\038\105\025\070\090\078\003\027\029\038\046\037\074\037\105\074\078\006\037\038\083\070\003\008\119\037\091\098\038\008\044\044\078\105\037\038\078\098\038\003\008\105\070\074\037\094\038\078\119\038\074\045\037\038\036\070\105\061\029\038\062\008\103\038\098\045\008\103\003\094\038\098\060\037\070\061\038\074\008\038\045\078\080\029"), 
		Media = _tggy, 
		Callback = function(action)
			if action ~= nil then
				Wherigo.ShowScreen(Wherigo.MAINSCREEN)
			end
		end
	}
end
function _lEv:OnSetActive()
	_q7r = _bv7r("\084\003\014\006")
	_Urwigo.GlobalZoneActiveChanged()
end
function _f9Om:OnProximity()
	_q7r = _bv7r("\084\044\082\079\080")
	_Urwigo.GlobalZoneProximity()
	_Urwigo.MessageBox{
		Text = _bv7r("\118\098\038\027\008\103\038\119\037\070\025\038\074\045\037\038\044\008\103\119\074\070\078\119\038\027\008\103\038\119\008\074\078\105\037\038\098\105\025\070\074\105\045\038\080\070\025\061\098\038\008\119\038\074\045\037\038\060\003\070\110\103\037\038\078\119\038\044\025\008\119\074\038\008\044\038\074\045\037\038\044\008\103\119\074\070\078\119\029\038\023\045\037\025\037\038\070\025\037\038\098\037\006\037\025\070\003\038\036\070\119\094\070\112\037\098\038\003\070\027\078\119\112\038\119\037\070\025\036\027\029"), 
		Media = _HcfGL, 
		Callback = function(action)
			if action ~= nil then
				_Urwigo.RunDialogs(function()
					Wherigo.GetInput(__6f)
				end)
			end
		end
	}
end
function _f9Om:OnSetActive()
	_q7r = _bv7r("\084\044\082\079\080")
	_Urwigo.GlobalZoneActiveChanged()
end
function _aLLsT:OnProximity()
	_q7r = _bv7r("\084\070\108\108\098\023")
	_Urwigo.GlobalZoneProximity()
	_Urwigo.MessageBox{
		Text = _bv7r("\118\098\038\027\008\103\038\069\070\003\061\038\103\060\038\074\008\038\074\045\037\038\036\103\098\078\119\037\098\098\038\094\078\098\105\025\078\105\074\029\038\118\038\098\074\008\025\037\038\008\069\119\037\025\038\105\008\080\037\098\038\008\103\074\038\074\008\038\112\025\037\037\074\038\027\008\103\029"), 
		Media = _4Aq3, 
		Callback = function(action)
			if action ~= nil then
				_Urwigo.MessageBox{
					Text = _bv7r("\099\008\080\037\074\045\078\119\112\038\070\074\074\070\105\061\037\094\038\080\027\038\036\103\078\003\094\078\119\112\111\038\108\008\008\061\038\080\027\038\069\078\119\094\008\069\038\078\098\038\036\025\008\061\037\119\029"), 
					Media = _xfZ, 
					Callback = function(action)
						if action ~= nil then
							_Urwigo.MessageBox{
								Text = _bv7r("\062\008\103\038\098\045\008\103\003\094\038\078\119\006\037\098\074\078\112\070\074\037\038\074\045\037\038\036\025\008\061\037\119\038\069\078\119\094\008\069\038\074\008\038\044\078\119\094\038\008\103\074\038\069\045\070\074\038\045\070\060\060\037\119\037\094\029"), 
								Media = _MjO, 
								Callback = function(action)
									if action ~= nil then
										Wherigo.ShowScreen(Wherigo.MAINSCREEN)
									end
								end
							}
						end
					end
				}
			end
		end
	}
end
function _aLLsT:OnSetActive()
	_q7r = _bv7r("\084\070\108\108\098\023")
	_Urwigo.GlobalZoneActiveChanged()
end
function _wbxAK:OnEnter()
	_q7r = _bv7r("\084\069\036\013\118\035")
	_OKa.Commands._HAn.Enabled = true
	_lI8.Commands._DR6_.Enabled = false
	_lI8.Commands._lN4Z.Enabled = true
	_Urwigo.MessageBox{
		Text = _bv7r("\065\060\008\119\038\037\119\074\037\025\078\119\112\038\074\045\037\038\105\037\080\037\074\037\025\027\038\027\008\103\038\098\037\037\038\074\045\037\038\070\025\037\070\038\078\119\038\094\078\098\070\025\025\070\027\029\038\117\025\070\006\037\098\074\008\119\037\098\038\045\070\006\037\038\036\037\037\119\038\098\080\070\098\045\037\094\038\070\119\094\038\074\045\037\038\112\025\008\103\119\094\038\078\098\038\074\008\025\119\038\103\060\038\037\006\037\025\027\069\045\037\025\037\029"), 
		Media = _3ib, 
		Callback = function(action)
			if action ~= nil then
				Wherigo.PlayAudio(_PmIX)
				_Urwigo.MessageBox{
					Text = _bv7r("\059\025\008\080\038\070\105\025\008\098\098\038\074\045\037\038\044\078\037\003\094\038\027\008\103\038\098\037\037\038\070\038\069\070\003\061\078\119\112\038\105\008\025\060\098\037\038\105\008\006\037\025\037\094\038\078\119\038\036\070\119\094\070\112\037\098\029\038\120\074\038\078\098\038\074\045\037\038\083\103\080\080\027\111"), 
					Media = _hD4h, 
					Callback = function(action)
						if action ~= nil then
							_MrGlR:Start()
						end
					end
				}
			end
		end
	}
end
function _wbxAK:OnExit()
	_q7r = _bv7r("\084\069\036\013\118\035")
	Wherigo.Command "StopSound"
	_MrGlR:Stop()
	_IGU:Stop()
	_kidO:RequestSync()
end
function _wbxAK:OnProximity()
	_q7r = _bv7r("\084\069\036\013\118\035")
	_Urwigo.GlobalZoneProximity()
end
function _wbxAK:OnSetActive()
	_q7r = _bv7r("\084\069\036\013\118\035")
	_Urwigo.GlobalZoneActiveChanged()
end
function _ZbOI:OnProximity()
	_q7r = _bv7r("\084\055\036\079\120")
	_Urwigo.GlobalZoneProximity()
	_Urwigo.MessageBox{
		Text = _bv7r("\062\008\103\038\070\025\037\038\112\037\074\074\078\119\112\038\006\037\025\027\038\105\003\008\098\037\038\074\008\038\074\045\037\038\080\078\098\098\078\119\112\038\070\025\074\078\044\070\105\074\098\029"), 
		Media = _yxepm, 
		Callback = function(action)
			if action ~= nil then
				_Urwigo.RunDialogs(function()
					Wherigo.GetInput(_jLPw)
				end)
			end
		end
	}
end
function _ZbOI:OnSetActive()
	_q7r = _bv7r("\084\055\036\079\120")
	_Urwigo.GlobalZoneActiveChanged()
end
function _sCK:OnProximity()
	_q7r = _bv7r("\084\098\026\035")
	_Urwigo.GlobalZoneProximity()
	_Urwigo.MessageBox{
		Text = _bv7r("\062\008\103\038\119\008\074\078\105\037\038\098\008\080\037\074\045\078\119\112\038\078\119\038\074\045\037\038\112\025\070\098\098\029"), 
		Media = _MjO, 
		Callback = function(action)
			if action ~= nil then
				Wherigo.ShowScreen(Wherigo.MAINSCREEN)
			end
		end
	}
end
function _sCK:OnSetActive()
	_q7r = _bv7r("\084\098\026\035")
	_Urwigo.GlobalZoneActiveChanged()
end
function _j8UME:OnGetInput(input)
	if input == nil then
		input = ""
	end
	_oKZpY = input
	if Wherigo.NoCaseEquals(_oKZpY, _bv7r("\062\037\098")) then
		_Urwigo.MessageBox{
			Text = _bv7r("\014\013\105\037\003\003\037\119\074\111\038\120\038\070\080\038\112\003\070\094\038\027\008\103\038\070\025\037\038\069\078\003\003\078\119\112\038\074\008\038\045\037\003\060\029"), 
			Media = _HaGJ, 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.MessageBox{
						Text = _bv7r("\023\045\037\025\037\038\070\025\037\038\098\037\006\037\025\070\003\038\003\037\070\094\098\038\027\008\103\038\098\045\008\103\003\094\038\044\008\003\003\008\069\029\038\120\038\069\078\003\003\038\080\070\025\061\038\074\045\037\038\003\008\105\070\074\078\008\119\098\038\008\119\038\027\008\103\025\038\080\070\060\029"), 
						Media = _HaGJ, 
						Callback = function(action)
							if action ~= nil then
								_Urwigo.MessageBox{
									Text = _bv7r("\020\037\044\008\025\037\038\027\008\103\038\003\037\070\006\037\038\027\008\103\038\098\045\008\103\003\094\038\074\070\061\037\038\070\038\003\008\008\061\038\070\074\038\074\045\037\038\037\080\060\074\027\038\098\070\025\105\008\060\045\070\112\103\098\029\038\087\037\038\070\003\098\008\038\045\070\006\037\038\070\038\025\070\025\037\038\105\008\060\027\038\008\044\038\074\045\037\038\014\112\027\060\074\078\070\119\038\020\008\008\061\038\008\044\038\074\045\037\038\046\037\070\094\029\038"), 
									Media = _HaGJ, 
									Callback = function(action)
										if action ~= nil then
											_Urwigo.MessageBox{
												Text = _bv7r("\023\045\037\038\098\070\025\105\008\060\045\070\112\103\098\038\070\119\094\038\036\008\008\061\038\008\044\038\074\045\037\038\094\037\070\094\038\070\025\037\038\119\008\069\038\070\006\070\078\003\070\036\003\037\038\078\119\038\074\045\037\038\078\074\037\080\098\038\080\037\119\103\029"), 
												Media = _MjO, 
												Callback = function(action)
													if action ~= nil then
														_f9Om.Active = true
														_aLLsT.Active = true
														_hmqPc.Active = true
														Wherigo.ShowScreen(Wherigo.MAINSCREEN)
													end
												end
											}
										end
									end
								}
							end
						end
					}
				end
			end
		}
		_DJAXy:MoveTo(_xb1)
		_rP9z:MoveTo(_xb1)
		_lI8.Commands._SkiBI.Enabled = false
		_d5hWj.Complete = true
		_Rrr.Active = true
		_iwwR6.Active = true
		_DJAXy.Commands._MepI.Enabled = false
		_lI8.Commands._PlsM.Enabled = false
		_lI8.Commands._l5oD3.Enabled = true
		_lI8.Description = _bv7r("\046\025\029\038\072\037\078\119\025\078\105\045\038\070\060\060\037\070\025\098\038\074\008\038\036\037\038\069\070\078\074\078\119\112\038\070\025\008\103\119\094\038\119\037\025\006\008\103\098\003\027\029\038\071\037\074\103\025\119\038\074\008\038\045\078\080\038\070\044\074\037\025\038\027\008\103\038\045\070\006\037\038\078\119\006\037\098\074\078\112\070\074\037\094\038\074\045\037\038\105\003\103\037\098\029")
	elseif Wherigo.NoCaseEquals(_oKZpY, _bv7r("\086\008")) then
		_Urwigo.MessageBox{
			Text = _bv7r("\023\045\070\074\038\078\098\038\074\008\008\038\036\070\094\029\038\120\044\038\027\008\103\038\105\045\070\119\112\037\038\027\008\103\025\038\080\078\119\094\047\038\060\003\037\070\098\037\038\003\037\074\038\080\037\038\061\119\008\069\029"), 
			Media = _HaGJ, 
			Callback = function(action)
				if action ~= nil then
					_lI8.Commands._PlsM.Enabled = true
					_lI8.Commands._SkiBI.Enabled = false
					Wherigo.ShowScreen(Wherigo.MAINSCREEN)
				end
			end
		}
	end
end
function __6f:OnGetInput(input)
	if input == nil then
		input = ""
	end
	_nAxf = input
	if Wherigo.NoCaseEquals(_nAxf, _bv7r("\006\037\074\037\025\070\119\098")) then
		_Urwigo.MessageBox{
			Text = _bv7r("\023\045\070\074\038\078\098\038\105\008\025\025\037\105\074\111"), 
			Media = _HcfGL, 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.MessageBox{
						Text = _bv7r("\062\008\103\038\080\070\061\037\038\119\008\074\037\038\008\044\038\074\045\037\038\080\070\025\061\078\119\112\098\038\008\119\038\074\045\037\038\060\003\070\110\103\037\038\070\119\094\038\060\078\105\061\038\103\060\038\098\008\080\037\038\008\044\038\074\045\037\038\036\070\119\094\070\112\037\098\038\119\037\070\025\036\027\038\074\008\038\061\037\037\060\038\070\098\038\037\006\078\094\037\119\105\037\029"), 
						Media = _lRjdS, 
						Callback = function(action)
							if action ~= nil then
								_TkUP:MoveTo(Player)
								_f9Om.Active = false
								_N8tIi = 0
								if _hmqPc.Active == false then
									_N8tIi = _N8tIi + 1
								end
								if _f9Om.Active == false then
									_N8tIi = _N8tIi + 1
								end
								if _aLLsT.Active == false then
									_N8tIi = _N8tIi + 1
								end
								if _N8tIi >= 3 then
									_iwwR6.Complete = true
									_lI8.Commands._XThS.Enabled = true
									_lI8.Commands._l5oD3.Enabled = false
									_lI8.Description = _bv7r("\046\025\029\038\072\037\078\119\025\078\105\045\038\078\098\038\069\070\078\074\078\119\112\038\070\025\008\103\119\094\038\070\119\013\078\008\103\098\003\027\029\038")
									Wherigo.PlayAudio(_R5ilX)
									_Urwigo.MessageBox{
										Text = _bv7r("\117\008\008\094\038\113\008\036\111\038\062\008\103\038\045\070\006\037\038\044\008\003\003\008\069\037\094\038\070\003\003\038\008\044\038\074\045\037\038\123\025\008\044\037\098\098\008\025\091\098\038\003\037\070\094\098\029\038\062\008\103\038\098\045\008\103\003\094\038\045\037\070\094\038\036\070\105\061\038\074\008\038\074\070\003\061\038\074\008\038\046\025\029\038\072\037\078\119\025\078\105\045\029"), 
										Media = _HML, 
										Callback = function(action)
											if action ~= nil then
												_Urwigo.MessageBox{
													Text = _bv7r("\086\037\069\038\023\070\098\061\115\038\025\037\074\103\025\119\038\074\045\037\038\105\003\103\037\098\038\074\008\038\046\025\029\038\072\037\078\119\025\078\105\045\029"), 
													Media = _tKkz, 
													Callback = function(action)
														if action ~= nil then
															_PcPS0.Active = true
															Wherigo.ShowScreen(Wherigo.MAINSCREEN)
															Wherigo.Command "StopSound"
															_kidO:RequestSync()
														end
													end
												}
											end
										end
									}
								end
							end
						end
					}
				end
			end
		}
	else
		_Urwigo.MessageBox{
			Text = _bv7r("\023\045\070\074\038\078\098\038\119\008\074\038\105\008\025\025\037\105\074\029\038\108\008\008\061\038\044\008\025\038\074\045\037\038\069\008\025\094\038\078\119\038\074\045\037\038\080\078\094\094\003\037\038\008\044\038\074\045\037\038\060\003\070\110\103\037\029"), 
			Media = _NeNa, 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.RunDialogs(function()
						Wherigo.GetInput(__6f)
					end)
				end
			end
		}
	end
end
function _jLPw:OnGetInput(input)
	if input == nil then
		input = ""
	end
	_ENDaA = input
	if Wherigo.NoCaseEquals(_ENDaA, _bv7r("\062\037\098")) then
		_Urwigo.MessageBox{
			Text = _bv7r("\118\069\037\098\008\080\037\111\038\026\008\119\112\025\070\074\103\003\070\074\078\008\119\098\038\008\119\038\044\078\119\094\078\119\112\038\074\045\037\038\070\025\074\078\044\070\105\074\098\038\070\119\094\038\105\008\080\060\003\037\074\078\119\112\038\074\045\078\098\038\069\045\037\025\078\112\008\111\038\046\025\029\038\072\037\078\119\025\078\105\045\038\069\078\003\003\038\036\037\038\006\037\025\027\038\045\070\060\060\027\038\069\078\074\045\038\027\008\103\029\038\023\045\078\098\038\069\045\037\025\078\112\008\038\069\070\098\038\105\025\037\070\074\037\094\038\036\027\038\059\008\025\037\098\074\107\117\045\008\098\074\029"), 
			Media = _HML, 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.MessageBox{
						Text = (_bv7r("\062\008\103\025\038\060\003\070\027\037\025\038\105\008\080\060\003\037\074\078\008\119\038\105\008\094\037\038\078\098\038")..string.sub(Player.CompletionCode, 1, 15)).._bv7r("\038\062\008\103\038\105\070\119\038\070\003\098\008\038\044\078\119\094\038\027\008\103\025\038\060\003\070\027\037\025\038\105\008\080\060\003\037\074\078\008\119\038\105\008\094\037\038\078\119\038\027\008\103\025\038\078\119\006\037\119\074\008\025\027\029\038\083\070\061\037\038\098\103\025\037\038\074\008\038\003\008\112\038\027\008\103\025\038\037\013\060\037\025\078\037\119\105\037\038\008\119\038\069\045\037\025\078\112\008\029\105\008\080\029"), 
						Media = _pshlB, 
						Callback = function(action)
							if action ~= nil then
								_Urwigo.MessageBox{
									Text = _bv7r("\023\008\038\044\078\119\094\038\008\103\074\038\080\008\025\037\038\070\036\008\103\074\038\069\045\037\025\078\112\008\098\038\060\003\037\070\098\037\038\006\078\098\078\074\038\069\045\037\025\078\112\008\044\008\103\119\094\070\074\078\008\119\029\105\008\080\029\038\023\045\070\119\061\098\038\044\008\025\038\060\003\070\027\078\119\112\029"), 
									Media = _pshlB
								}
							end
						end
					}
					_kidO.Complete = true
					_bZZo.Complete = true
					_Xcr.Description = string.sub(Player.CompletionCode, 1, 15)
					_Xcr:MoveTo(Player)
				end
			end
		}
	elseif Wherigo.NoCaseEquals(_ENDaA, _bv7r("\086\008")) then
		_Urwigo.MessageBox{
			Text = _bv7r("\120\038\070\080\038\098\008\025\025\027\038\074\045\070\074\038\027\008\103\038\094\078\094\119\091\074\038\044\078\119\094\038\078\074\029\038\062\008\103\038\070\025\037\038\078\119\038\074\045\037\038\105\008\025\025\037\105\074\038\003\008\105\070\074\078\008\119\029\038\120\044\038\027\008\103\038\074\045\078\119\061\038\074\045\037\038\105\070\105\045\037\038\078\098\038\080\078\098\098\078\119\112\038\060\003\037\070\098\037\038\105\008\119\074\070\105\074\038\074\045\037\038\026\079\029"), 
			Media = _yxepm, 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.RunDialogs(function()
						Wherigo.GetInput(_jLPw)
					end)
				end
			end
		}
	else
		_Urwigo.MessageBox{
			Text = _bv7r("\117\008\038\036\037\119\037\070\074\045\038\074\008\038\074\045\037\038\080\103\080\080\078\037\098\091\038\003\070\078\025\029\038\023\045\037\038\105\008\008\025\094\078\119\070\074\037\098\038\070\025\037\115\038\086\038\092\021\038\106\106\029\001\021\092\038\087\038\012\122\082\038\049\012\029\106\011\106\029"), 
			Media = _yxepm, 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.RunDialogs(function()
						Wherigo.GetInput(_jLPw)
					end)
				end
			end
		}
	end
end
function _ieJ:OnGetInput(input)
	if input == nil then
		input = ""
	end
	_FknQ = input
	if Wherigo.NoCaseEquals(_FknQ, _bv7r("\106\012\012\012")) then
		_Urwigo.MessageBox{
			Text = _bv7r("\062\037\098\111\038\023\045\008\098\037\038\069\037\025\037\038\074\045\037\038\119\103\080\036\037\025\098\038\074\045\070\074\038\069\037\025\037\038\112\003\008\069\078\119\112\029\038\087\045\037\119\038\120\038\074\103\025\119\037\094\038\070\025\008\103\119\094\038\074\045\037\025\037\038\069\070\098\038\119\008\074\045\078\119\112\038\074\045\037\025\037\038\037\013\105\037\060\074\038\070\038\105\008\103\060\003\037\038\036\070\119\094\070\112\037\098\038\008\119\038\074\045\037\038\112\025\008\103\119\094\029\038"), 
			Media = _47O, 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.MessageBox{
						Text = _bv7r("\062\008\103\038\080\070\061\037\038\119\008\074\037\038\008\044\038\074\045\037\038\037\027\037\038\069\078\074\119\037\098\098\091\038\098\074\008\025\027\029"), 
						Media = _lRjdS, 
						Callback = function(action)
							if action ~= nil then
								_hmqPc.Active = false
								_N8tIi = 0
								if _hmqPc.Active == false then
									_N8tIi = _N8tIi + 1
								end
								if _f9Om.Active == false then
									_N8tIi = _N8tIi + 1
								end
								if _aLLsT.Active == false then
									_N8tIi = _N8tIi + 1
								end
								if _N8tIi >= 3 then
									_lI8.Commands._XThS.Enabled = true
									_lI8.Commands._l5oD3.Enabled = false
									_iwwR6.Complete = true
									_lI8.Description = _bv7r("\046\025\029\038\072\037\078\119\025\078\105\045\038\078\098\038\069\070\078\074\078\119\112\038\070\025\008\103\119\094\038\070\119\013\078\008\103\098\003\027\029\038")
									Wherigo.PlayAudio(_R5ilX)
									_Urwigo.MessageBox{
										Text = _bv7r("\117\008\008\094\038\113\008\036\111\038\062\008\103\038\045\070\006\037\038\044\008\003\003\008\069\037\094\038\070\003\003\038\008\044\038\074\045\037\038\123\025\008\044\037\098\098\008\025\091\098\038\003\037\070\094\098\029\038\062\008\103\038\098\045\008\103\003\094\038\045\037\070\094\038\036\070\105\061\038\074\008\038\074\070\003\061\038\074\008\038\046\025\029\038\072\037\078\119\025\078\105\045\029"), 
										Media = _HML, 
										Callback = function(action)
											if action ~= nil then
												_Urwigo.MessageBox{
													Text = _bv7r("\086\037\069\038\023\070\098\061\115\038\025\037\074\103\025\119\038\074\045\037\038\105\003\103\037\098\038\074\008\038\046\025\029\038\072\037\078\119\025\078\105\045\029"), 
													Media = _tKkz, 
													Callback = function(action)
														if action ~= nil then
															_PcPS0.Active = true
															Wherigo.ShowScreen(Wherigo.MAINSCREEN)
															Wherigo.Command "StopSound"
															_kidO:RequestSync()
														end
													end
												}
											end
										end
									}
								end
							end
						end
					}
				end
			end
		}
	else
		_Urwigo.MessageBox{
			Text = _bv7r("\086\008\047\038\074\045\008\098\037\038\070\025\037\119\091\074\038\074\045\037\038\119\103\080\036\037\025\098\038\074\045\070\074\038\069\037\025\037\038\112\003\008\069\078\119\112\029\038\108\008\008\061\038\044\008\025\038\074\045\037\038\044\008\103\025\038\094\078\112\078\074\038\027\037\070\025\038\119\037\070\025\038\074\045\037\038\074\008\060\038\008\044\038\074\045\037\038\060\003\070\110\103\037\029\038"), 
			Media = _NeNa, 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.RunDialogs(function()
						Wherigo.GetInput(_ieJ)
					end)
				end
			end
		}
	end
end
function _IS_R:OnGetInput(input)
	if input == nil then
		input = ""
	end
	_pkXBJ = input
	if Wherigo.NoCaseEquals(_pkXBJ, _bv7r("\062\037\098")) then
		_Urwigo.MessageBox{
			Text = _bv7r("\120\038\070\080\038\112\003\070\094\038\074\008\038\045\037\070\025\038\078\074\029\038\087\037\038\105\008\103\003\094\038\103\098\037\038\027\008\103\025\038\045\037\003\060\029\038"), 
			Media = _QFIB, 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.MessageBox{
						Text = _bv7r("\062\008\103\038\080\070\027\038\119\037\037\094\038\070\038\069\037\070\060\008\119\038\074\008\038\060\025\008\074\037\105\074\038\027\008\103\025\098\037\003\044\029\038\023\070\061\037\038\074\045\078\098\038\098\045\008\074\112\103\119\038\070\119\094\038\080\037\037\074\038\103\098\038\008\006\037\025\038\070\074\038\074\045\037\038\105\037\080\037\074\037\025\027\029"), 
						Media = _QFIB, 
						Callback = function(action)
							if action ~= nil then
								Wherigo.PlayAudio(_rGNY)
								_Urwigo.MessageBox{
									Text = _bv7r("\046\037\074\037\105\074\078\006\037\038\083\070\003\008\119\037\038\045\070\119\094\098\038\027\008\103\038\070\038\098\045\008\074\112\103\119\038\070\119\094\038\098\037\006\037\025\070\003\038\036\008\013\037\098\038\008\044\038\098\045\037\003\003\098\029"), 
									Media = _cet0, 
									Callback = function(action)
										if action ~= nil then
											_lEv.Active = false
											_OKa:MoveTo(_wbxAK)
											_lI8:MoveTo(_wbxAK)
											_wbxAK.Active = true
											_g8T:MoveTo(Player)
											_2sX:MoveTo(Player)
											_u5RCe.Active = true
											_OKa.Commands._nK106.Enabled = false
											_OKa.Description = _bv7r("\023\045\037\038\094\037\074\037\105\074\078\006\037\038\070\060\060\037\070\025\098\038\074\008\038\036\037\038\006\037\025\027\038\044\025\078\112\045\074\037\119\037\094\029")
											_lI8.Description = _bv7r("\046\025\029\038\072\037\078\119\025\078\105\045\038\070\060\060\037\070\025\098\038\074\008\038\036\037\038\006\037\025\027\038\044\025\078\112\045\074\037\119\037\094\029")
											Wherigo.Command "StopSound"
											Wherigo.ShowScreen(Wherigo.MAINSCREEN)
											_kidO:RequestSync()
										end
									end
								}
							end
						end
					}
				end
			end
		}
	else
		_Urwigo.MessageBox{
			Text = _bv7r("\079\061\070\027\047\038\027\008\103\038\105\070\119\038\044\078\119\094\038\103\098\038\070\074\038\074\045\037\038\105\037\080\037\074\037\025\027\038\078\044\038\027\008\103\038\105\045\070\119\112\037\038\027\008\103\025\038\080\078\119\094\029"), 
			Media = _QFIB, 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.MessageBox{
						Text = _bv7r("\023\045\037\038\060\025\008\044\037\098\098\008\025\038\070\119\094\038\095\119\036\098\060\081\094\037\074\037\105\074\078\006\037\038\083\070\003\008\119\037\038\003\037\070\006\037\038\044\008\025\038\074\045\037\038\105\037\080\037\074\037\025\027\029\038\062\008\103\038\044\078\119\094\038\027\008\103\025\098\037\003\044\038\070\003\008\119\037\038\070\074\038\074\045\037\038\060\008\003\078\105\037\038\098\074\070\074\078\008\119\029"), 
						Media = _tggy, 
						Callback = function(action)
							if action ~= nil then
								_Px4z7:MoveTo(_lEv)
								_OKa:MoveTo(_wbxAK)
								_lI8:MoveTo(_wbxAK)
								_OKa.Commands._nK106.Enabled = false
								_lI8.Commands._lN4Z.Enabled = true
								_wbxAK.Active = true
								_lI8.Commands._l5oD3.Enabled = false
								_u5RCe.Active = true
								_OKa.Description = _bv7r("\023\045\037\038\094\037\074\037\105\074\078\006\037\038\070\060\060\037\070\025\098\038\074\008\038\036\037\038\006\037\025\027\038\044\025\078\112\045\074\037\119\037\094\029")
								_lI8.Description = _bv7r("\046\025\029\038\072\037\078\119\025\078\105\045\038\070\060\060\037\070\025\098\038\074\008\038\036\037\038\006\037\025\027\038\044\025\078\112\045\074\037\119\037\094\029")
								Wherigo.ShowScreen(Wherigo.MAINSCREEN)
								_kidO:RequestSync()
							end
						end
					}
				end
			end
		}
	end
end
function _HfHIB:OnGetInput(input)
	if input == nil then
		input = ""
	end
	_DRDB = input
	if Wherigo.NoCaseEquals(_DRDB, _bv7r("\014\013\070\080\078\119\037\038\118\112\070\078\119")) then
		_Urwigo.MessageBox{
			Text = _bv7r("\065\060\008\119\038\105\003\008\098\037\025\038\078\119\098\060\037\105\074\078\008\119\038\027\008\103\038\119\008\074\078\105\037\038\074\045\070\074\038\098\008\080\037\074\045\078\119\112\038\045\070\098\038\036\025\008\061\037\119\038\008\044\044\038\044\025\008\080\038\074\045\037\038\074\008\060\038\008\044\038\074\045\037\038\098\070\025\105\008\060\045\008\112\103\098\029"), 
			Media = _ysM, 
			Callback = function(action)
				if action ~= nil then
					Wherigo.PlayAudio(_R5ilX)
					_Urwigo.MessageBox{
						Text = _bv7r("\120\074\038\003\008\008\061\098\038\003\078\061\037\038\074\045\037\038\070\119\061\045\038\098\027\080\036\008\003\038\069\045\078\105\045\038\069\070\098\038\008\119\038\074\008\060\038\008\044\038\074\045\037\038\098\070\025\105\008\060\045\008\112\103\098\038\078\098\038\080\078\098\098\078\119\112\111\038"), 
						Media = _HML, 
						Callback = function(action)
							if action ~= nil then
								_Urwigo.MessageBox{
									Text = _bv7r("\062\008\103\038\098\045\008\103\003\094\038\078\119\006\037\098\074\078\112\070\074\037\038\074\045\037\038\080\078\098\098\078\119\112\038\070\119\061\045\038\098\027\080\036\008\003\029\038\120\074\038\080\070\027\038\036\037\038\098\008\080\037\038\069\045\037\025\037\038\119\037\070\025\036\027\029\038"), 
									Media = _HML, 
									Callback = function(action)
										if action ~= nil then
											_Urwigo.MessageBox{
												Text = _bv7r("\118\038\119\037\069\038\074\070\098\061\038\078\098\038\070\006\070\078\003\070\036\003\037\038\078\119\038\074\045\037\038\050\074\070\098\061\098\050\038\080\037\119\103\029"), 
												Media = _tKkz, 
												Callback = function(action)
													if action ~= nil then
														Wherigo.Command "StopSound"
														_tEbR = _tEbR + 1
														_DJAXy.Commands._MepI.Enabled = false
														_Rrr.Complete = true
														_CjI.Active = true
														Wherigo.ShowScreen(Wherigo.MAINSCREEN)
													end
												end
											}
										end
									end
								}
							end
						end
					}
				end
			end
		}
	else
		Wherigo.ShowScreen(Wherigo.MAINSCREEN)
	end
end
function _oUfC:OnGetInput(input)
	if input == nil then
		input = ""
	end
	_pCBkn = input
	_j76v.Description = _pCBkn
end
function _ifA6:OnStart()
	_IGU:Stop()
	Wherigo.PlayAudio(_Q7gi)
	_Urwigo.MessageBox{
		Text = "", 
		Media = _KncT0
	}
end
function _ifA6:OnTick()
	_Urwigo.MessageBox{
		Text = _bv7r("\023\045\037\038\080\103\080\080\027\038\105\008\069\037\025\098\038\036\037\044\008\025\037\038\074\045\037\038\003\078\112\045\074\029"), 
		Media = _KncT0, 
		Callback = function(action)
			if action ~= nil then
				_ifA6:Stop()
				Wherigo.PlayAudio(_FEC)
				_Urwigo.MessageBox{
					Text = _bv7r("\062\008\103\038\119\008\069\038\045\070\006\037\038\074\045\037\038\080\103\080\080\027\038\103\119\094\037\025\038\027\008\103\025\038\105\008\119\074\025\008\003\111"), 
					Media = _OGabD, 
					Callback = function(action)
						if action ~= nil then
							_u5RCe.Complete = true
							_VMB()
							Wherigo.Command "StopSound"
						end
					end
				}
			end
		end
	}
end
function _MrGlR:OnStart()
	_Urwigo.MessageBox{
		Text = _bv7r("\023\045\037\038\080\103\080\080\027\038\078\098\038\069\070\003\061\078\119\112\038\074\008\069\070\025\094\098\038\027\008\103\029"), 
		Media = _hD4h, 
		Callback = function(action)
			if action ~= nil then
				Wherigo.Command "StopSound"
				Wherigo.ShowScreen(Wherigo.MAINSCREEN)
			end
		end
	}
end
function _MrGlR:OnTick()
	Wherigo.PlayAudio(_PmIX)
	_MrGlR:Stop()
	_Urwigo.MessageBox{
		Text = _bv7r("\023\045\037\038\080\103\080\080\027\038\080\008\006\037\098\038\078\119\074\008\038\074\045\037\038\070\025\037\070\029\038\072\037\038\037\027\037\098\038\074\045\037\038\094\037\074\037\105\074\078\006\037\038\070\119\094\038\046\025\029\038\072\037\078\119\025\078\105\045\029"), 
		Media = _hD4h, 
		Callback = function(action)
			if action ~= nil then
				_zm20a.Commands._E1L.Enabled = true
				_zm20a.Commands._lRae.Enabled = false
				_g8T.Commands._OFAz.Enabled = false
				_g8T.Commands._INsP.Enabled = true
				_SBHI:MoveTo(_wbxAK)
				Wherigo.Command "StopSound"
				Wherigo.PlayAudio(_zupZu)
				_Urwigo.MessageBox{
					Text = _bv7r("\023\045\037\038\080\103\080\080\027\038\070\074\074\070\105\061\098\111"), 
					Media = _SxQ, 
					Callback = function(action)
						if action ~= nil then
							Wherigo.Command "StopSound"
							_IGU:Start()
						end
					end
				}
			end
		end
	}
end
function _IGU:OnTick()
	_Urwigo.MessageBox{
		Text = _bv7r("\023\045\037\038\080\103\080\080\027\038\070\074\074\070\105\061\098\111"), 
		Media = _SxQ, 
		Callback = function(action)
			if action ~= nil then
				local _rndChoiceValue = math.random()
				if _rndChoiceValue < 0.333333333333333 then
					_IGU:Stop()
					Wherigo.PlayAudio(_zupZu)
					_Urwigo.MessageBox{
						Text = _bv7r("\023\045\037\038\080\103\080\080\027\038\098\069\078\119\112\098\038\070\119\094\038\045\078\074\098\038\046\037\074\037\105\074\078\006\037\038\083\070\003\008\119\037\038\069\078\074\045\038\070\038\105\025\103\098\045\078\119\112\038\036\003\008\069\029"), 
						Media = _SxQ, 
						Callback = function(action)
							if action ~= nil then
								_IGU:Start()
								Wherigo.Command "StopSound"
								Wherigo.ShowScreen(Wherigo.MAINSCREEN)
							end
						end
					}
				elseif _rndChoiceValue < 0.666666666666667 then
					_IGU:Stop()
					Wherigo.PlayAudio(_zupZu)
					_Urwigo.MessageBox{
						Text = _bv7r("\023\045\037\038\080\103\080\080\027\038\098\069\078\119\112\098\038\070\119\094\038\045\078\074\098\038\046\025\029\038\072\037\078\119\025\078\105\045\038\069\078\074\045\038\070\038\105\025\103\098\045\078\119\112\038\036\003\008\069\029"), 
						Media = _SxQ, 
						Callback = function(action)
							if action ~= nil then
								_IGU:Start()
								Wherigo.Command "StopSound"
								Wherigo.ShowScreen(Wherigo.MAINSCREEN)
							end
						end
					}
				else
					_IGU:Stop()
					Wherigo.PlayAudio(_zupZu)
					_Urwigo.MessageBox{
						Text = _bv7r("\023\045\037\038\080\103\080\080\027\038\098\069\078\119\112\098\038\070\074\038\027\008\103\038\036\103\074\038\027\008\103\038\070\025\037\038\070\036\003\037\038\074\008\038\112\025\070\105\037\044\103\003\003\027\038\094\008\094\112\037\038\045\078\080\029"), 
						Media = _SxQ, 
						Callback = function(action)
							if action ~= nil then
								_IGU:Start()
								Wherigo.Command "StopSound"
								Wherigo.ShowScreen(Wherigo.MAINSCREEN)
							end
						end
					}
				end
			end
		end
	}
end
function _lI8:On_SkiBI(target)
	_Urwigo.MessageBox{
		Text = _bv7r("\072\037\003\003\008\047\038\080\027\038\119\070\080\037\038\078\098\038\095\119\036\098\060\081\046\025\029\038\072\037\078\119\025\078\105\045\038\020\025\103\112\098\105\045\029\038\120\038\045\070\006\037\038\036\037\037\119\038\098\074\103\094\027\078\119\112\038\074\045\037\038\070\119\105\078\037\119\074\038\014\112\027\060\074\078\070\119\038\123\045\070\025\008\070\045\038\118\061\045\037\119\070\074\037\119\029"), 
		Media = _HaGJ, 
		Callback = function(action)
			if action ~= nil then
				_Urwigo.MessageBox{
					Text = _bv7r("\023\045\037\038\080\008\025\119\078\119\112\038\070\044\074\037\025\038\074\045\037\038\037\013\045\078\036\078\074\038\070\025\025\078\006\037\094\038\120\038\105\070\080\037\038\078\119\074\008\038\037\013\070\080\078\119\037\038\118\061\045\037\119\070\074\037\119\091\098\038\098\070\025\105\008\060\045\070\112\103\098\038\070\119\094\038\074\045\037\038\105\008\119\074\037\119\074\098\038\070\003\008\119\112\038\069\078\074\045\038\098\037\006\037\025\070\003\038\070\025\074\078\044\070\105\074\098\038\069\037\025\037\038\080\078\098\098\078\119\112\029"), 
					Media = _HaGJ, 
					Callback = function(action)
						if action ~= nil then
							_Urwigo.MessageBox{
								Text = _bv7r("\120\038\105\008\119\074\070\105\074\037\094\038\074\045\037\038\070\103\074\045\008\025\078\074\078\037\098\038\036\103\074\038\119\008\038\008\119\037\038\045\070\098\038\036\037\037\119\038\070\036\003\037\038\074\008\038\105\008\080\037\038\103\060\038\069\078\074\045\038\070\038\098\008\003\103\074\078\008\119\029"), 
								Media = _HaGJ, 
								Callback = function(action)
									if action ~= nil then
										_Urwigo.RunDialogs(function()
											Wherigo.GetInput(_j8UME)
										end)
									end
								end
							}
						end
					end
				}
			end
		end
	}
end
function _lI8:On_PlsM(target)
	_Urwigo.MessageBox{
		Text = _bv7r("\118\045\045\047\038\027\008\103\038\045\070\006\037\038\025\037\074\103\025\119\037\094\029"), 
		Media = _HaGJ, 
		Callback = function(action)
			if action ~= nil then
				_Urwigo.RunDialogs(function()
					Wherigo.GetInput(_j8UME)
				end)
			end
		end
	}
end
function _lI8:On_XThS(target)
	_Urwigo.MessageBox{
		Text = _bv7r("\014\013\105\037\003\003\037\119\074\111\038\027\008\103\038\045\070\006\037\038\044\008\103\119\094\038\070\003\003\038\008\044\038\074\045\037\038\105\003\103\037\098\029\038"), 
		Media = _HaGJ, 
		Callback = function(action)
			if action ~= nil then
				_PcPS0.Complete = true
				_TkUP:MoveTo(_lI8)
				_quoe8:MoveTo(_lI8)
				_Urwigo.MessageBox{
					Text = _bv7r("\120\038\069\078\003\003\038\074\070\061\037\038\070\119\027\038\037\006\078\094\037\119\105\037\038\074\045\070\074\038\027\008\103\038\045\070\006\037\038\044\008\103\119\094\029"), 
					Media = _HaGJ, 
					Callback = function(action)
						if action ~= nil then
							_Urwigo.MessageBox{
								Text = _bv7r("\020\037\044\008\025\037\038\069\037\038\105\008\119\074\078\119\103\037\038\074\045\008\103\112\045\047\038\120\038\045\070\006\037\038\070\038\105\008\119\044\037\098\098\078\008\119\115\038\120\038\045\070\006\037\038\119\008\074\038\036\037\037\119\038\105\008\080\060\003\037\074\037\003\027\038\103\060\044\025\008\119\074\038\069\078\074\045\038\027\008\103\029\038\023\045\037\025\037\038\078\098\038\080\008\025\037\038\074\008\038\074\045\078\098\038\105\070\098\037\038\074\045\037\119\038\120\038\045\070\006\037\038\098\045\070\025\037\094\029"), 
								Media = _HaGJ, 
								Callback = function(action)
									if action ~= nil then
										_Urwigo.MessageBox{
											Text = _bv7r("\108\037\074\038\080\037\038\074\037\003\003\038\027\008\103\038\070\038\098\074\008\025\027\029\029\029"), 
											Media = _HaGJ, 
											Callback = function(action)
												if action ~= nil then
													_wFx()
													_lI8.Commands._XThS.Enabled = false
												end
											end
										}
									end
								end
							}
						end
					end
				}
			end
		end
	}
end
function _lI8:On_l5oD3(target)
	_Urwigo.MessageBox{
		Text = _bv7r("\120\038\098\037\037\038\074\045\070\074\038\027\008\103\038\045\070\006\037\038\119\008\074\038\044\008\103\119\094\038\070\003\003\038\008\044\038\074\045\037\038\105\003\103\037\098\038\027\037\074\029\038\123\003\037\070\098\037\038\025\037\074\103\025\119\038\045\037\025\037\038\069\045\037\119\038\027\008\103\038\045\070\006\037\038\094\008\119\037\038\098\008\029"), 
		Media = _HaGJ, 
		Callback = function(action)
			if action ~= nil then
				Wherigo.ShowScreen(Wherigo.MAINSCREEN)
			end
		end
	}
end
function _lI8:On_DR6_(target)
	_Urwigo.MessageBox{
		Text = _bv7r("\120\038\070\080\038\112\003\070\094\038\027\008\103\038\080\070\094\037\038\078\074\029\038\099\060\037\070\061\038\074\008\038\094\037\074\037\105\074\078\006\037\038\083\070\003\008\119\037\038\074\008\038\044\078\119\094\038\008\103\074\038\008\103\025\038\119\037\013\074\038\080\008\006\037\029"), 
		Media = _HaGJ, 
		Callback = function(action)
			if action ~= nil then
				Wherigo.ShowScreen(Wherigo.MAINSCREEN)
			end
		end
	}
end
function _lI8:On_lN4Z(target)
	_Urwigo.MessageBox{
		Text = _bv7r("\072\037\003\060\111\111\111\111\038\120\074\098\038\074\045\037\038\080\103\080\080\027\111\038\120\091\006\037\038\045\037\070\025\094\038\074\045\070\074\038\070\038\105\037\025\074\070\078\119\038\070\119\061\045\038\074\070\003\078\098\080\070\119\038\045\070\098\038\060\008\069\037\025\038\008\006\037\025\038\074\045\037\038\080\103\080\080\027\029"), 
		Media = _HaGJ, 
		Callback = function(action)
			if action ~= nil then
				Wherigo.ShowScreen(Wherigo.MAINSCREEN)
			end
		end
	}
end
function _OKa:On_nK106(target)
	_Urwigo.MessageBox{
		Text = _bv7r("\072\078\047\038\120\038\070\080\038\094\037\074\037\105\074\078\006\037\038\083\070\003\008\119\037\029\038\120\038\070\080\038\078\119\038\105\045\070\025\112\037\038\008\044\038\074\045\078\098\038\105\070\098\037\029"), 
		Media = _QFIB, 
		Callback = function(action)
			if action ~= nil then
				_Urwigo.MessageBox{
					Text = _bv7r("\014\006\037\025\038\098\078\119\105\037\038\120\038\112\008\074\038\060\103\074\038\008\119\038\074\045\078\098\038\105\070\098\037\038\074\045\078\119\112\098\038\045\070\006\037\038\119\008\074\038\036\037\037\119\038\025\078\112\045\074\038\078\119\038\074\008\069\119\029\038"), 
					Media = _QFIB, 
					Callback = function(action)
						if action ~= nil then
							_Urwigo.MessageBox{
								Text = _bv7r("\120\038\045\070\006\037\038\036\037\037\119\038\112\037\074\074\078\119\112\038\070\003\003\038\061\078\119\094\098\038\008\044\038\105\070\003\003\098\115\038\105\008\080\060\003\070\078\119\074\098\047\038\094\078\098\074\103\025\036\070\119\105\037\098\047\038\070\119\094\038\098\078\112\045\074\078\119\112\098\038\008\044\038\070\119\038\103\119\107\119\070\074\103\025\070\003\038\061\078\119\094\029"), 
								Media = _QFIB, 
								Callback = function(action)
									if action ~= nil then
										_Urwigo.MessageBox{
											Text = _bv7r("\023\045\037\038\060\025\008\044\037\098\098\008\025\038\098\060\037\070\061\098\038\103\060\047\038\120\038\025\037\070\003\003\027\038\070\080\038\098\008\025\025\027\038\044\008\025\038\037\006\037\025\027\074\045\078\119\112\038\094\037\074\037\105\074\078\006\037\038\083\070\003\008\119\037\029\038\120\038\036\003\070\080\037\038\080\027\098\037\003\044\038\044\008\025\038\069\045\070\074\038\045\070\098\038\045\070\060\060\037\119\037\094\029\038"), 
											Media = _HaGJ, 
											Callback = function(action)
												if action ~= nil then
													_Urwigo.MessageBox{
														Text = _bv7r("\120\038\070\060\060\025\037\105\078\070\074\037\038\074\045\070\074\038\036\103\074\038\103\119\044\008\025\074\103\119\070\074\037\003\027\038\074\045\037\025\037\038\078\098\038\119\008\074\045\078\119\112\038\069\037\038\105\070\119\038\094\008\038\119\008\069\029\038\023\045\078\098\038\080\008\025\119\078\119\112\038\120\038\112\008\074\038\070\038\105\070\003\003\038\044\025\008\080\038\074\045\037\038\112\025\008\103\119\094\098\038\061\037\037\060\037\025\038\070\074\038\074\045\037\038\105\037\080\037\074\037\025\027\038\069\045\008\038\025\037\060\008\025\074\037\094\038\074\045\070\074\038\070\038\060\037\025\098\008\119\038\069\070\098\038\070\074\074\070\105\061\037\094\029"), 
														Media = _QFIB, 
														Callback = function(action)
															if action ~= nil then
																_Urwigo.MessageBox{
																	Text = _bv7r("\087\045\037\119\038\074\045\037\038\006\078\105\074\078\080\038\069\070\098\038\070\098\061\037\094\038\069\045\008\038\074\045\037\078\025\038\070\074\074\070\105\061\037\025\038\069\070\098\047\038\074\045\037\038\008\119\003\027\038\074\045\078\119\112\038\074\045\037\027\038\105\008\103\003\094\038\098\074\070\074\037\038\069\070\098\047\038\050\083\065\083\083\062\111\111\111\050"), 
																	Media = _QFIB, 
																	Callback = function(action)
																		if action ~= nil then
																			_Urwigo.RunDialogs(function()
																				Wherigo.GetInput(_IS_R)
																			end)
																		end
																	end
																}
															end
														end
													}
												end
											end
										}
									end
								end
							}
						end
					end
				}
			end
		end
	}
end
function _OKa:On_HAn(target)
	_Urwigo.MessageBox{
		Text = _bv7r("\023\045\037\038\080\103\080\080\027\038\078\098\038\098\008\038\044\025\078\112\045\074\037\119\078\119\112\111\038\065\098\037\038\070\038\098\045\008\074\112\103\119\038\074\008\038\074\070\061\037\038\045\078\080\038\094\008\069\119\111\111\111"), 
		Media = _QFIB
	}
end
function _wlUY7:On_uE2(target)
	_Urwigo.MessageBox{
		Text = _bv7r("\062\008\103\038\037\013\060\003\070\078\119\038\074\008\038\074\045\037\038\069\078\074\119\037\098\098\038\074\045\070\074\038\027\008\103\038\070\025\037\038\078\119\006\037\098\074\078\112\070\074\078\119\112\038\074\045\037\038\105\070\098\037\038\070\119\094\038\070\098\061\038\045\078\080\038\069\045\070\074\038\045\070\060\060\037\119\037\094\029"), 
		Media = _MjO, 
		Callback = function(action)
			if action ~= nil then
				_Urwigo.MessageBox{
					Text = _bv7r("\023\045\037\038\037\027\037\038\069\078\074\119\037\098\098\038\113\103\080\060\098\038\103\060\038\119\037\025\006\008\103\098\003\027\029\038\120\038\069\070\098\038\045\037\025\037\038\070\119\094\038\120\038\045\037\070\025\094\038\078\074\111\111\111\111\111"), 
					Media = _47O, 
					Callback = function(action)
						if action ~= nil then
							_Urwigo.MessageBox{
								Text = _bv7r("\120\038\069\070\098\038\074\070\061\078\119\112\038\070\038\003\008\008\061\038\070\074\038\074\045\078\098\038\036\037\070\103\074\078\044\103\003\038\098\074\070\074\103\037\038\069\045\037\119\038\120\038\045\037\070\025\094\038\070\038\094\037\037\060\038\112\025\008\070\119\038\036\037\045\078\119\094\038\080\037\029\038\118\003\003\038\008\044\038\070\038\098\103\094\094\037\119\038\074\045\037\038\094\070\074\037\038\008\119\038\074\045\078\098\038\098\074\070\074\103\037\038\098\074\070\025\074\098\038\112\003\008\069\078\119\112\038\025\037\094\029"), 
								Media = _47O, 
								Callback = function(action)
									if action ~= nil then
										_Urwigo.MessageBox{
											Text = _bv7r("\120\038\074\103\025\119\037\094\038\070\025\008\103\119\094\038\074\008\038\098\037\037\038\069\045\070\074\038\069\070\098\038\080\070\061\078\119\112\038\074\045\037\038\098\008\103\119\094\038\036\103\074\038\069\045\070\074\037\006\037\025\038\078\074\038\069\070\098\038\094\078\098\070\060\060\037\070\025\037\094\029"), 
											Media = _47O, 
											Callback = function(action)
												if action ~= nil then
													_Urwigo.RunDialogs(function()
														Wherigo.GetInput(_ieJ)
													end)
												end
											end
										}
									end
								end
							}
						end
					end
				}
			end
		end
	}
end
function _DJAXy:On_ig7(target)
	_Urwigo.MessageBox{
		Text = _bv7r("\065\060\008\119\038\037\013\070\080\078\119\078\119\112\038\074\045\037\038\098\070\025\105\008\060\045\070\112\103\098\038\027\008\103\038\098\037\037\038\098\008\080\037\038\098\105\025\070\074\105\045\038\080\070\025\061\098\038\008\119\038\074\045\037\038\098\103\025\044\070\105\037\038\036\103\074\038\119\008\074\038\080\103\105\045\038\037\003\098\037\029"), 
		Media = _ysM, 
		Callback = function(action)
			if action ~= nil then
				_Urwigo.RunDialogs(function()
					Wherigo.GetInput(_HfHIB)
				end)
				_DJAXy.Commands._ig7.Enabled = false
				_DJAXy.Commands._MepI.Enabled = true
			end
		end
	}
end
function _DJAXy:On_MepI(target)
	_Urwigo.MessageBox{
		Text = _bv7r("\065\060\008\119\038\105\003\008\098\037\025\038\078\119\098\060\037\105\074\078\008\119\038\027\008\103\038\119\008\074\078\105\037\038\074\045\070\074\038\098\008\080\037\074\045\078\119\112\038\045\070\098\038\036\025\008\061\037\119\038\008\044\044\038\044\025\008\080\038\074\045\037\038\074\008\060\038\008\044\038\074\045\037\038\098\070\025\105\008\060\045\008\112\103\098\029"), 
		Media = _ysM, 
		Callback = function(action)
			if action ~= nil then
				Wherigo.PlayAudio(_R5ilX)
				_Urwigo.MessageBox{
					Text = _bv7r("\120\074\038\003\008\008\061\098\038\003\078\061\037\038\074\045\037\038\070\119\061\045\038\098\027\080\036\008\003\038\069\045\078\105\045\038\069\070\098\038\008\119\038\074\008\060\038\008\044\038\074\045\037\038\098\070\025\105\008\060\045\008\112\103\098\038\078\098\038\080\078\098\098\078\119\112\111\038"), 
					Media = _HML, 
					Callback = function(action)
						if action ~= nil then
							_Urwigo.MessageBox{
								Text = _bv7r("\062\008\103\038\098\045\008\103\003\094\038\078\119\006\037\098\074\078\112\070\074\037\038\074\045\037\038\080\078\098\098\078\119\112\038\070\119\061\045\038\098\027\080\036\008\003\029\038\120\074\038\080\070\027\038\036\037\038\098\008\080\037\038\069\045\037\025\037\038\119\037\070\025\036\027\029\038"), 
								Media = _HML, 
								Callback = function(action)
									if action ~= nil then
										_Urwigo.MessageBox{
											Text = _bv7r("\118\038\119\037\069\038\074\070\098\061\038\078\098\038\070\006\070\078\003\070\036\003\037\038\078\119\038\074\045\037\038\050\074\070\098\061\098\050\038\080\037\119\103\029"), 
											Media = _tKkz, 
											Callback = function(action)
												if action ~= nil then
													Wherigo.Command "StopSound"
													_DJAXy.Commands._MepI.Enabled = false
													_Rrr.Complete = true
													_CjI.Active = true
													_tEbR = _tEbR + 1
													Wherigo.ShowScreen(Wherigo.MAINSCREEN)
												end
											end
										}
									end
								end
							}
						end
					end
				}
			end
		end
	}
end
function _DJAXy:On_1dEi(target)
	Wherigo.PlayAudio(_lhv4)
	_Urwigo.MessageBox{
		Text = _bv7r("\062\008\103\038\074\025\027\038\061\119\008\105\061\078\119\112\038\008\119\038\074\045\037\038\098\070\025\105\008\060\045\070\112\103\098\038\036\103\074\038\119\008\074\038\080\103\105\045\038\045\070\060\060\037\119\098\029"), 
		Media = _ysM, 
		Callback = function(action)
			if action ~= nil then
				Wherigo.Command "StopSound"
			end
		end
	}
end
function _DJAXy:On_EBZ8(target)
	Wherigo.ShowScreen(Wherigo.MAINSCREEN)
end
function _BQh:On_1Ooe(target)
	_Urwigo.MessageBox{
		Text = _bv7r("\108\008\008\061\078\119\112\038\105\003\008\098\037\003\027\038\070\074\038\074\045\037\038\105\025\070\105\061\037\094\038\069\078\119\094\008\069\038\027\008\103\038\098\037\037\038\098\008\080\037\038\008\003\094\038\044\078\036\037\025\038\105\070\103\112\045\074\038\078\119\038\074\045\037\038\036\025\008\061\037\119\038\112\003\070\098\098\029\038"), 
		Media = _Rh_FW, 
		Callback = function(action)
			if action ~= nil then
				_Urwigo.MessageBox{
					Text = _bv7r("\062\008\103\038\070\003\098\008\038\119\008\074\078\105\037\038\070\038\098\080\070\003\003\038\105\045\103\119\061\038\008\044\038\025\008\074\074\037\119\038\044\003\037\098\045\029\038"), 
					Media = _Rh_FW, 
					Callback = function(action)
						if action ~= nil then
							_Urwigo.MessageBox{
								Text = _bv7r("\062\008\103\038\074\070\061\037\038\036\008\074\045\038\078\074\037\080\098\038\070\119\094\038\094\037\060\008\098\078\074\038\074\045\037\080\038\078\119\038\074\045\037\038\037\006\078\094\037\119\105\037\038\036\008\013\029"), 
								Media = _FfNCM, 
								Callback = function(action)
									if action ~= nil then
										_aLLsT.Active = false
										_quoe8:MoveTo(Player)
										_N8tIi = 0
										if _hmqPc.Active == false then
											_N8tIi = _N8tIi + 1
										end
										if _f9Om.Active == false then
											_N8tIi = _N8tIi + 1
										end
										if _aLLsT.Active == false then
											_N8tIi = _N8tIi + 1
										end
										if _N8tIi >= 3 then
											_lI8.Commands._XThS.Enabled = true
											_iwwR6.Complete = true
											_lI8.Commands._l5oD3.Enabled = false
											_lI8.Description = _bv7r("\046\025\029\038\072\037\078\119\025\078\105\045\038\078\098\038\069\070\078\074\078\119\112\038\070\025\008\103\119\094\038\070\119\013\078\008\103\098\003\027\029\038")
											Wherigo.PlayAudio(_R5ilX)
											_Urwigo.MessageBox{
												Text = _bv7r("\117\008\008\094\038\113\008\036\111\038\062\008\103\038\045\070\006\037\038\044\008\003\003\008\069\037\094\038\070\003\003\038\008\044\038\074\045\037\038\123\025\008\044\037\098\098\008\025\091\098\038\003\037\070\094\098\029\038\062\008\103\038\098\045\008\103\003\094\038\045\037\070\094\038\036\070\105\061\038\074\008\038\074\070\003\061\038\074\008\038\046\025\029\038\072\037\078\119\025\078\105\045\029"), 
												Media = _HML, 
												Callback = function(action)
													if action ~= nil then
														_Urwigo.MessageBox{
															Text = _bv7r("\086\037\069\038\023\070\098\061\115\038\025\037\074\103\025\119\038\074\045\037\038\105\003\103\037\098\038\074\008\038\046\025\029\038\072\037\078\119\025\078\105\045\029"), 
															Media = _tKkz, 
															Callback = function(action)
																if action ~= nil then
																	_PcPS0.Active = true
																	Wherigo.ShowScreen(Wherigo.MAINSCREEN)
																	Wherigo.Command "StopSound"
																	_kidO:RequestSync()
																end
															end
														}
													end
												end
											}
										end
									end
								end
							}
						end
					end
				}
			end
		end
	}
end
function _FP9:On_6tcV(target)
	_Urwigo.MessageBox{
		Text = _bv7r("\065\060\008\119\038\105\003\008\098\037\025\038\078\119\098\060\037\105\074\078\008\119\038\078\074\038\070\060\060\037\070\025\098\038\074\045\070\074\038\098\008\080\037\074\045\078\119\112\038\069\070\098\038\074\025\027\078\119\112\038\074\008\038\105\003\070\069\038\070\074\038\074\045\037\038\044\008\103\119\074\070\078\119\029\038\023\045\037\025\037\038\070\025\037\038\098\105\025\070\074\105\045\038\080\070\025\061\098\038\008\119\038\074\045\037\038\060\003\070\110\103\037\038\070\119\094\038\098\037\006\037\025\070\003\038\036\070\119\094\070\112\037\098\038\003\070\027\078\119\112\038\119\037\070\025\036\027\029\038\095\119\036\098\060\081"), 
		Media = _HcfGL, 
		Callback = function(action)
			if action ~= nil then
				_Urwigo.RunDialogs(function()
					Wherigo.GetInput(__6f)
				end)
			end
		end
	}
end
function _rP9z:On_1WJX(target)
	_Urwigo.MessageBox{
		Text = _bv7r("\062\008\103\038\008\060\037\119\038\103\060\038\074\045\037\038\070\119\105\078\037\119\074\038\074\008\080\037\038\070\119\094\038\074\025\027\038\025\037\070\094\078\119\112\038\074\045\025\008\103\112\045\038\098\037\006\037\025\070\003\038\060\070\112\037\098\029"), 
		Media = _vD_, 
		Callback = function(action)
			if action ~= nil then
				_Urwigo.MessageBox{
					Text = _bv7r("\062\008\103\038\070\025\037\038\119\008\074\038\070\036\003\037\038\074\008\038\103\119\094\037\025\098\074\070\119\094\038\074\045\037\038\036\008\008\061\038\098\078\119\105\037\038\078\074\038\078\098\038\069\025\078\074\074\037\119\038\078\119\038\014\112\027\060\074\078\070\119\038\045\078\037\025\008\112\003\027\060\045\078\105\098\029"), 
					Media = _vD_, 
					Callback = function(action)
						if action ~= nil then
							_Urwigo.MessageBox{
								Text = _bv7r("\020\037\044\008\025\037\038\027\008\103\038\105\003\008\098\037\038\078\074\047\038\027\008\103\038\119\008\074\078\105\037\038\070\119\038\078\080\070\112\037\038\008\044\038\070\038\060\025\078\037\098\074\038\045\008\003\094\078\119\112\038\103\060\038\070\119\038\070\119\061\045\038\074\070\003\078\098\080\070\119\038\008\006\037\025\038\070\038\080\103\080\080\027\029\038\120\119\038\074\045\037\038\078\080\070\112\037\038\003\078\112\045\074\038\078\098\038\105\008\080\078\119\112\038\008\103\074\038\044\025\008\080\038\074\045\037\038\074\070\003\078\098\080\070\119\038\070\119\094\038\078\074\038\070\060\060\037\070\025\098\038\074\045\037\038\080\103\080\080\027\038\078\098\038\103\119\094\037\025\038\074\045\037\038\105\008\119\074\025\008\003\038\008\044\038\074\045\037\038\060\025\078\037\098\074\029"), 
								Media = _vD_, 
								Callback = function(action)
									if action ~= nil then
										_Urwigo.MessageBox{
											Text = _bv7r("\062\008\103\038\105\003\008\098\037\038\074\045\037\038\036\008\008\061\029"), 
											Media = _vD_, 
											Callback = function(action)
												if action ~= nil then
													Wherigo.ShowScreen(Wherigo.MAINSCREEN)
												end
											end
										}
									end
								end
							}
						end
					end
				}
			end
		end
	}
end
function _g8T:On_OFAz(target)
	_BS4DT()
end
function _g8T:On_INsP(target)
	_WRc()
end
function _g8T:On_FjB(target)
	_0ERvV()
end
function _Px4z7:On_wkQZ(target)
	_Urwigo.MessageBox{
		Text = _bv7r("\062\008\103\038\098\037\037\038\098\037\006\037\025\070\003\038\098\045\008\074\038\112\103\119\098\038\003\070\027\078\119\112\038\078\119\038\074\045\037\038\105\070\098\037\038\070\003\008\119\112\038\069\078\074\045\038\098\008\080\037\038\036\008\013\037\098\038\008\044\038\070\080\080\103\119\078\074\078\008\119\029"), 
		Media = _Fk9
	}
end
function _Px4z7:On_0FVB(target)
	_Urwigo.MessageBox{
		Text = _bv7r("\087\045\078\003\037\038\119\008\038\008\119\037\038\078\098\038\003\008\008\061\078\119\112\038\027\008\103\038\074\070\061\037\038\008\119\037\038\008\044\038\074\045\037\038\098\045\008\074\112\103\119\098\038\044\025\008\080\038\074\045\037\038\105\070\098\037\038\070\003\008\119\112\038\069\078\074\045\038\098\037\006\037\025\070\003\038\036\008\013\037\098\038\008\044\038\070\080\080\103\119\078\074\078\008\119\029"), 
		Media = _cet0, 
		Callback = function(action)
			if action ~= nil then
				_g8T:MoveTo(Player)
				_2sX:MoveTo(Player)
				_Px4z7.Commands._0FVB.Enabled = false
				Wherigo.ShowScreen(Wherigo.MAINSCREEN)
			end
		end
	}
end
function _2sX:On_t4F(target)
	_0ERvV()
end
function _zm20a:On_6sz96(target)
	Wherigo.PlayAudio(_R5ilX)
	_Urwigo.MessageBox{
		Text = _bv7r("\062\008\103\038\060\078\105\061\038\103\060\038\074\045\037\038\118\119\061\045\029"), 
		Media = _t6H1T, 
		Callback = function(action)
			if action ~= nil then
				_CjI.Complete = true
				_zm20a:MoveTo(Player)
				_Urwigo.MessageBox{
					Text = _bv7r("\062\008\103\038\045\070\006\037\038\044\008\103\119\094\038\074\045\037\038\118\119\061\045\038\008\044\038\118\061\045\037\119\070\074\037\119\111\038\023\045\078\098\038\074\070\003\078\098\080\070\119\038\069\070\098\038\060\003\070\105\037\094\038\008\119\038\074\008\060\038\008\044\038\074\045\037\038\098\070\025\105\008\060\045\070\112\103\098\038\008\044\038\118\061\045\037\119\070\074\037\119\038\070\119\094\038\069\070\098\038\098\070\078\094\038\074\008\038\045\008\003\094\038\098\060\037\105\078\070\003\038\060\008\069\037\025\098\038\008\006\037\025\038\045\078\080\029"), 
					Media = _HaGJ, 
					Callback = function(action)
						if action ~= nil then
							_Urwigo.MessageBox{
								Text = _bv7r("\123\003\037\070\098\037\038\036\037\038\006\037\025\027\038\105\070\025\037\044\103\003\038\069\078\074\045\038\078\074\029"), 
								Media = _HaGJ, 
								Callback = function(action)
									if action ~= nil then
										Wherigo.Command "StopSound"
										_sCK.Name = _bv7r("\023\045\037\038\118\119\061\045\038\008\044\038\118\061\045\037\119\070\074\037\119")
										_zm20a.Commands._6sz96.Enabled = false
										_zm20a.Commands._lRae.Enabled = true
										_sCK.Active = false
										_tEbR = 0
										Wherigo.ShowScreen(Wherigo.MAINSCREEN)
									end
								end
							}
						end
					end
				}
			end
		end
	}
end
function _zm20a:On_lRae(target)
	_Urwigo.MessageBox{
		Text = _bv7r("\062\008\103\038\074\025\027\038\045\008\003\094\078\119\112\038\074\045\037\038\118\119\061\045\038\103\060\038\036\103\074\038\119\008\074\038\080\103\105\045\038\045\070\060\060\037\119\098\029"), 
		Media = _t6H1T, 
		Callback = function(action)
			if action ~= nil then
				Wherigo.ShowScreen(Wherigo.MAINSCREEN)
			end
		end
	}
end
function _zm20a:On_E1L(target)
	_IGU:Stop()
	_Urwigo.MessageBox{
		Text = _bv7r("\062\008\103\038\045\008\003\094\038\074\045\037\038\118\119\061\045\038\008\044\038\118\061\045\037\119\070\074\037\119\038\045\078\112\045\038\078\119\038\074\045\037\038\070\078\025\029\038\118\038\036\025\078\112\045\074\038\003\078\112\045\074\038\037\080\078\074\098\038\044\008\025\074\045\038\044\025\008\080\038\074\045\037\038\118\119\061\045\029"), 
		Media = _t6H1T, 
		Callback = function(action)
			if action ~= nil then
				_ifA6:Start()
			end
		end
	}
end
function _nxmF:On_40_UY(target)
	_2sX:MoveTo(Player)
	_g8T:MoveTo(Player)
	_lEv.Active = true
	_wbxAK.Active = true
end
function _j76v:On_I1b1(target)
	_Urwigo.MessageBox{
		Text = _bv7r("\120\074\038\078\098\038\027\008\103\025\038\074\025\103\098\074\037\094\038\119\008\074\037\060\070\094\038\070\119\094\038\060\037\119\105\078\003\029"), 
		Media = _lRjdS
	}
end
function _j76v:On_rSk(target)
	_Urwigo.RunDialogs(function()
		Wherigo.GetInput(_oUfC)
	end)
end
function _Urwigo.GlobalZoneProximity()
	_kidO:RequestSync()
end
function _Urwigo.GlobalZoneActiveChanged()
	_kidO:RequestSync()
end

-- Urwigo functions --
function _PTBDD()
	Wherigo.PlayAudio(_57tJ)
	_Urwigo.MessageBox{
		Text = _bv7r("\023\045\037\038\060\045\008\119\037\038\025\078\119\112\098\038\070\119\094\038\074\045\037\038\060\025\008\044\037\098\098\008\025\038\060\078\105\061\098\038\103\060\038\074\045\037\038\060\045\008\119\037\029\038\062\008\103\038\045\037\070\025\038\008\006\037\025\038\074\045\037\038\025\037\105\037\078\006\037\025\115"), 
		Media = _2Ua, 
		Callback = function(action)
			if action ~= nil then
				_Urwigo.MessageBox{
					Text = _bv7r("\072\037\003\003\008\038\046\025\029\038\072\037\078\119\025\078\105\045\047\038\074\045\078\098\038\078\098\038\094\037\074\037\105\074\078\006\037\038\083\070\003\008\119\037\029\038\099\008\080\037\074\045\078\119\112\038\045\070\098\038\045\070\060\060\037\119\037\094\047\038\105\008\080\037\038\074\008\038\074\045\037\038\060\008\003\078\105\037\038\098\074\070\074\078\008\119\038\025\078\112\045\074\038\070\069\070\027\111"), 
					Media = _KsD, 
					Callback = function(action)
						if action ~= nil then
							_Urwigo.MessageBox{
								Text = _bv7r("\123\025\008\044\037\098\098\008\025\038\072\037\078\119\025\078\105\045\115\038\120\038\103\119\094\037\098\074\070\119\094\047\038\120\038\069\078\003\003\038\094\025\078\006\037\038\074\008\038\074\045\037\038\060\008\003\078\105\037\038\098\074\070\074\078\008\119\038\119\008\069\029"), 
								Media = _KsD, 
								Callback = function(action)
									if action ~= nil then
										_Urwigo.MessageBox{
											Text = _bv7r("\108\037\074\098\038\045\037\070\094\038\074\008\038\074\045\037\038\060\008\003\078\105\037\038\098\074\070\074\078\008\119\029\038\083\037\037\074\038\080\037\038\008\006\037\025\038\074\045\037\025\037\029\038\120\074\038\069\078\003\003\038\036\037\038\110\103\078\105\061\037\025\038\078\044\038\027\008\103\038\094\025\078\006\037\038\044\025\008\080\038\074\045\078\098\038\060\008\078\119\074\038\008\119\029\038"), 
											Media = _HaGJ, 
											Callback = function(action)
												if action ~= nil then
													Wherigo.Command "StopSound"
													_lEv.Active = true
													_lI8.Commands._DR6_.Enabled = true
													_lI8.Description = _bv7r("\046\025\029\038\072\037\078\119\025\078\105\045\038\078\098\038\069\070\078\074\078\119\112\038\078\119\038\074\045\037\038\060\008\003\078\105\037\038\098\074\070\074\078\008\119\029")
													_lI8:MoveTo(_lEv)
													Wherigo.ShowScreen(Wherigo.MAINSCREEN)
												end
											end
										}
									end
								end
							}
						end
					end
				}
			end
		end
	}
end
function _wFx()
	_Urwigo.MessageBox{
		Text = _bv7r("\023\045\008\103\098\070\119\094\098\038\008\044\038\027\037\070\025\098\038\070\112\008\047\038\035\078\119\112\038\118\080\037\119\045\008\074\037\060\038\120\056\038\025\037\078\112\119\037\094\038\070\098\038\060\045\070\025\070\008\045\038\008\006\037\025\038\070\003\003\038\008\044\038\014\112\027\060\074\029\038"), 
		Media = _E6h, 
		Callback = function(action)
			if action ~= nil then
				_Urwigo.MessageBox{
					Text = _bv7r("\118\080\037\119\045\008\074\037\060\038\069\070\098\038\070\119\038\037\013\074\025\037\080\037\003\027\038\060\008\069\037\025\044\103\003\038\025\103\003\037\025\038\070\119\094\038\045\037\038\094\037\044\078\037\094\038\074\045\037\038\070\119\105\078\037\119\074\038\074\025\070\094\078\074\078\008\119\098\038\036\027\038\037\098\074\070\036\003\078\098\045\078\119\112\038\070\038\119\037\069\038\025\037\003\078\112\078\008\119\038\074\045\070\074\038\036\037\003\078\037\006\037\094\038\078\119\038\008\119\037\038\112\008\094\081\038\074\045\037\038\098\103\119\038\112\008\094\038\118\074\037\119\029\038"), 
					Media = _hby, 
					Callback = function(action)
						if action ~= nil then
							_Urwigo.MessageBox{
								Text = _bv7r("\118\080\037\119\045\008\074\037\060\038\120\056\038\105\045\070\119\112\037\094\038\045\078\098\038\119\070\080\037\038\074\008\038\118\061\045\037\119\070\074\037\119\038\070\119\094\038\060\025\008\105\003\070\078\080\037\094\038\045\078\080\098\037\003\044\038\070\098\038\074\045\037\038\094\078\006\078\119\037\038\025\103\003\037\025\038\008\006\037\025\038\070\003\003\038\008\044\038\014\112\027\060\074\029"), 
								Media = _Me1, 
								Callback = function(action)
									if action ~= nil then
										_Urwigo.MessageBox{
											Text = _bv7r("\118\061\045\037\119\070\074\037\119\038\037\025\037\105\074\037\094\038\080\070\119\027\038\112\025\037\070\074\038\069\008\025\061\098\038\078\119\038\045\078\098\038\008\069\119\038\045\008\119\008\025\047\038\036\103\074\038\070\098\038\045\078\098\038\060\008\069\037\025\038\112\025\037\069\038\098\008\038\070\003\098\008\038\112\025\037\069\038\094\078\098\003\008\027\070\003\074\027\038\070\080\008\119\112\038\045\078\098\038\044\008\003\003\008\069\037\025\098\029\038"), 
											Media = _fW5, 
											Callback = function(action)
												if action ~= nil then
													_Urwigo.MessageBox{
														Text = _bv7r("\072\078\098\038\044\008\003\003\008\069\037\025\098\038\060\003\008\074\074\037\094\038\074\008\038\061\078\003\003\038\045\078\080\038\070\119\094\038\008\119\037\038\119\078\112\045\074\047\038\103\119\094\037\025\038\074\045\037\038\003\078\112\045\074\038\008\044\038\070\038\044\103\003\003\038\080\008\008\119\047\038\118\061\045\037\119\070\074\037\119\038\069\070\098\038\105\070\060\074\103\025\037\094\038\070\119\094\038\074\070\061\037\119\038\074\008\038\074\045\037\038\014\112\027\060\074\078\070\119\038\026\078\074\027\038\008\044\038\074\045\037\038\046\037\070\094\115\038\072\070\080\103\119\070\060\074\025\070\047\038\069\045\037\025\037\038\045\037\038\069\070\098\038\074\008\038\036\037\038\080\103\080\080\078\044\078\037\094\038\070\003\078\006\037\029"), 
														Media = _CYK, 
														Callback = function(action)
															if action ~= nil then
																_Urwigo.MessageBox{
																	Text = _bv7r("\118\044\074\037\025\038\118\061\045\037\119\070\074\037\119\098\038\044\008\003\003\008\069\037\025\098\038\080\103\080\080\078\044\078\037\094\038\045\078\080\047\038\070\038\105\103\025\098\037\038\069\070\098\038\060\003\070\105\037\094\038\103\060\008\119\038\045\078\098\038\074\008\080\036\038\074\045\070\074\038\078\044\038\037\006\037\025\038\074\045\037\038\098\103\119\038\112\008\094\038\069\070\098\038\074\008\038\098\037\037\038\074\045\037\038\003\078\112\045\074\038\008\044\038\074\045\037\038\044\103\003\003\038\080\008\008\119\047\038\045\037\038\069\008\103\003\094\038\008\119\105\037\038\070\112\070\078\119\038\025\078\098\037\038\074\008\038\069\070\003\061\038\074\045\037\038\037\070\025\074\045\038\070\098\038\070\038\003\078\006\078\119\112\038\094\037\070\094\029\038"), 
																	Media = _vCs9i, 
																	Callback = function(action)
																		if action ~= nil then
																			_Urwigo.MessageBox{
																				Text = _bv7r("\023\045\070\074\038\078\098\038\074\045\037\038\037\119\094\038\008\044\038\045\078\098\074\008\025\027\038\003\037\098\098\008\119\047\038\036\103\074\038\120\038\070\080\038\070\044\025\070\078\094\038\119\008\074\038\008\044\038\074\045\037\038\098\074\008\025\027\029\038\062\008\103\038\098\037\037\038\074\045\025\037\037\038\119\078\112\045\074\098\038\070\112\008\038\069\045\037\119\038\074\045\037\038\098\070\025\105\008\060\045\070\112\103\098\038\069\070\098\038\094\037\003\078\006\037\025\037\094\047\038\078\074\038\069\070\098\038\103\119\094\037\025\038\074\045\037\038\003\078\112\045\074\038\008\044\038\070\038\044\103\003\003\038\080\008\008\119\029\038"), 
																				Media = _HaGJ, 
																				Callback = function(action)
																					if action ~= nil then
																						_Urwigo.MessageBox{
																							Text = _bv7r("\023\045\037\038\119\037\013\074\038\080\008\025\119\078\119\112\038\069\045\037\119\038\120\038\069\037\119\074\038\074\008\038\105\045\037\105\061\038\074\045\037\038\037\013\045\078\036\078\074\047\038\074\045\037\038\098\070\025\105\008\060\045\070\112\103\098\038\069\070\098\038\037\080\060\074\027\029\038\120\038\044\037\070\025\038\074\045\037\038\069\008\025\098\074\115\038\074\045\037\038\080\103\080\080\027\038\045\070\098\038\025\078\098\037\119\111"), 
																							Media = _HaGJ, 
																							Callback = function(action)
																								if action ~= nil then
																									_PTBDD()
																								end
																							end
																						}
																					end
																				end
																			}
																		end
																	end
																}
															end
														end
													}
												end
											end
										}
									end
								end
							}
						end
					end
				}
			end
		end
	}
end
function _WRc()
	if _oJjIW > 0 then
		local _rndChoiceValue = math.random()
		if _rndChoiceValue < 0.25 then
			_oJjIW = _oJjIW - 1
			Wherigo.PlayAudio(_xUYN)
			_Urwigo.MessageBox{
				Text = (_bv7r("\062\008\103\038\098\045\008\008\074\038\070\074\038\074\045\037\038\080\103\080\080\027\038\070\119\094\038\045\078\074\038\045\078\080\038\094\037\070\094\038\008\119\029\038\072\037\038\098\074\070\112\112\037\025\098\038\074\008\038\074\045\037\038\098\078\094\037\029\038\062\008\103\025\038\105\103\025\025\037\119\074\038\070\080\080\008\038\078\098\038").._oJjIW).._bv7r("\038\029"), 
				Media = _cet0, 
				Callback = function(action)
					if action ~= nil then
						Wherigo.Command "StopSound"
						_G83 = _G83 - 1
						if _G83 == 0 then
							_IGU:Stop()
							_Urwigo.MessageBox{
								Text = _bv7r("\087\008\069\111\111\111\038\062\008\103\038\074\008\008\061\038\094\008\069\119\038\074\045\037\038\080\103\080\080\027\029\038\087\045\008\038\069\008\103\003\094\038\045\070\006\037\038\061\119\008\069\119\038\078\074\038\069\070\098\038\060\008\098\098\078\036\003\037\038\103\098\078\119\112\038\070\038\098\045\008\074\112\103\119\022"), 
								Media = _E6Nz, 
								Callback = function(action)
									if action ~= nil then
										Wherigo.PlayAudio(_FEC)
										_u5RCe.Complete = true
										_Urwigo.MessageBox{
											Text = _bv7r("\023\045\037\038\080\103\080\080\027\038\044\070\003\003\098\038\074\008\038\074\045\037\038\112\025\008\103\119\094\038\094\037\044\037\070\074\037\094\029"), 
											Media = _OGabD, 
											Callback = function(action)
												if action ~= nil then
													_VMB()
												end
											end
										}
									end
								end
							}
						else
						end
					end
				end
			}
			_g8T.Description = (_bv7r("\062\008\103\025\038\105\103\025\025\037\119\074\038\070\080\080\008\038\078\098\038").._oJjIW).._bv7r("\038\029")
		elseif _rndChoiceValue < 0.5 then
			_oJjIW = _oJjIW - 1
			Wherigo.PlayAudio(_xUYN)
			_Urwigo.MessageBox{
				Text = (_bv7r("\062\008\103\038\098\045\008\008\074\038\070\074\038\074\045\037\038\080\103\080\080\027\038\036\103\074\038\008\119\003\027\038\060\070\025\074\078\070\003\003\027\038\045\078\074\038\045\078\080\029\038\072\037\038\098\074\070\112\112\037\025\098\038\074\008\038\074\045\037\038\098\078\094\037\029\038\062\008\103\025\038\105\103\025\025\037\119\074\038\070\080\080\008\038\078\098\038").._oJjIW).._bv7r("\038\029"), 
				Media = _cet0, 
				Callback = function(action)
					if action ~= nil then
						Wherigo.Command "StopSound"
						_G83 = _G83 - 1
						if _G83 == 0 then
							_IGU:Stop()
							_Urwigo.MessageBox{
								Text = _bv7r("\087\008\069\111\111\111\038\062\008\103\038\074\008\008\061\038\094\008\069\119\038\074\045\037\038\080\103\080\080\027\029\038\087\045\008\038\069\008\103\003\094\038\045\070\006\037\038\061\119\008\069\119\038\078\074\038\069\070\098\038\060\008\098\098\078\036\003\037\038\103\098\078\119\112\038\070\038\098\045\008\074\112\103\119\022"), 
								Media = _E6Nz, 
								Callback = function(action)
									if action ~= nil then
										Wherigo.PlayAudio(_FEC)
										_u5RCe.Complete = true
										_Urwigo.MessageBox{
											Text = _bv7r("\023\045\037\038\080\103\080\080\027\038\044\070\003\003\098\038\074\008\038\074\045\037\038\112\025\008\103\119\094\038\094\037\044\037\070\074\037\094\029"), 
											Media = _OGabD, 
											Callback = function(action)
												if action ~= nil then
													_VMB()
												end
											end
										}
									end
								end
							}
						else
						end
					end
				end
			}
			_g8T.Description = (_bv7r("\062\008\103\025\038\105\103\025\025\037\119\074\038\070\080\080\008\038\078\098\038").._oJjIW).._bv7r("\038\029")
		elseif _rndChoiceValue < 0.75 then
			_oJjIW = _oJjIW - 1
			Wherigo.PlayAudio(_xUYN)
			_Urwigo.MessageBox{
				Text = _bv7r("\062\008\103\038\098\045\008\008\074\038\074\045\037\038\080\103\080\080\027\038\070\119\094\038\105\008\080\060\003\037\074\037\003\027\038\080\078\098\098\038\045\078\080\029"), 
				Media = _cet0, 
				Callback = function(action)
					if action ~= nil then
						Wherigo.Command "StopSound"
					end
				end
			}
			_g8T.Description = (_bv7r("\062\008\103\025\038\105\103\025\025\037\119\074\038\070\080\080\008\038\078\098\038").._oJjIW).._bv7r("\038\029")
		else
			_oJjIW = _oJjIW - 1
			Wherigo.PlayAudio(_xUYN)
			_Urwigo.MessageBox{
				Text = _bv7r("\062\008\103\038\098\045\008\008\074\038\074\045\037\038\080\103\080\080\027\038\036\103\074\038\070\105\105\078\094\037\119\074\003\027\038\045\078\074\038\008\119\037\038\008\044\038\074\045\037\038\112\025\070\006\037\098\074\008\119\037\098\038\078\119\098\074\037\070\094\029"), 
				Media = _cet0, 
				Callback = function(action)
					if action ~= nil then
						Wherigo.Command "StopSound"
					end
				end
			}
			_g8T.Description = (_bv7r("\062\008\103\025\038\105\103\025\025\037\119\074\038\070\080\080\008\038\078\098\038").._oJjIW).._bv7r("\038\029")
		end
	elseif _oJjIW == 0 then
		_Urwigo.MessageBox{
			Text = _bv7r("\062\008\103\038\070\025\037\038\070\003\003\038\008\103\074\038\008\044\038\070\080\080\008\038\070\119\094\038\069\078\003\003\038\119\037\037\094\038\074\008\038\025\037\003\008\070\094\029"), 
			Media = _cet0
		}
	end
end
function _BS4DT()
	if _oJjIW > 0 then
		_oJjIW = _oJjIW - 1
		Wherigo.PlayAudio(_xUYN)
		if true then
			_g8T.Description = (_bv7r("\062\008\103\025\038\105\103\025\025\037\119\074\038\070\080\080\008\038\078\098\038").._oJjIW).._bv7r("\038\029")
			_Urwigo.MessageBox{
				Text = (_bv7r("\062\008\103\038\044\078\025\037\038\008\044\044\038\070\038\025\008\103\119\094\038\078\119\074\008\038\074\045\037\038\070\078\025\029\038\062\008\103\025\038\105\103\025\025\037\119\074\038\070\080\080\008\038\078\098\038").._oJjIW).._bv7r("\038\029"), 
				Media = _cet0, 
				Callback = function(action)
					if action ~= nil then
						Wherigo.Command "StopSound"
					end
				end
			}
		end
	elseif _oJjIW == 0 then
		_Urwigo.MessageBox{
			Text = _bv7r("\062\008\103\038\070\025\037\038\070\003\003\038\008\103\074\038\008\044\038\070\080\080\008\038\070\119\094\038\069\078\003\003\038\119\037\037\094\038\074\008\038\025\037\003\008\070\094\029"), 
			Media = _cet0
		}
	end
end
function _VMB()
	Wherigo.PlayAudio(_R5ilX)
	_Urwigo.MessageBox{
		Text = _bv7r("\046\025\029\038\072\037\078\119\025\078\105\045\038\070\119\094\038\046\037\074\037\105\074\078\006\037\038\083\070\003\008\119\037\038\113\103\080\060\038\103\060\038\078\119\038\074\045\037\038\070\078\025\038\069\078\074\045\038\113\008\027\111"), 
		Media = _HML, 
		Callback = function(action)
			if action ~= nil then
				_Urwigo.MessageBox{
					Text = _bv7r("\087\008\069\111\038\120\038\094\078\094\119\091\074\038\074\045\078\119\061\038\078\074\038\069\070\098\038\060\008\098\098\078\036\003\037\029"), 
					Media = _QFIB, 
					Callback = function(action)
						if action ~= nil then
							_Urwigo.MessageBox{
								Text = _bv7r("\120\038\105\070\119\091\074\038\036\037\003\078\037\006\037\038\027\008\103\038\094\078\094\038\078\074\111"), 
								Media = _HaGJ, 
								Callback = function(action)
									if action ~= nil then
										_Urwigo.MessageBox{
											Text = _bv7r("\120\038\105\070\119\038\045\070\119\094\003\037\038\074\045\037\038\098\078\074\103\070\074\078\008\119\038\044\025\008\080\038\045\037\025\037\029\038\120\038\069\078\003\003\038\036\037\038\025\037\074\103\025\119\078\119\112\038\074\045\037\038\080\103\080\080\027\038\074\008\038\045\078\098\038\044\078\119\070\003\038\025\037\098\074\078\119\112\038\060\003\070\105\037\029"), 
											Media = _HaGJ, 
											Callback = function(action)
												if action ~= nil then
													_Urwigo.MessageBox{
														Text = _bv7r("\023\045\070\119\061\038\027\008\103\038\098\008\038\080\103\105\045\038\044\008\025\038\070\003\003\038\008\044\038\027\008\103\025\038\045\037\003\060\029\038\065\119\044\008\025\074\103\119\070\074\037\003\027\038\078\074\038\003\008\008\061\098\038\003\078\061\037\038\074\045\037\038\070\025\074\078\044\070\105\074\098\038\044\025\008\080\038\074\045\037\038\037\013\045\078\036\078\074\038\070\025\037\038\098\074\078\003\003\038\080\078\098\098\078\119\112\038\074\045\008\103\112\045\029"), 
														Media = _HaGJ, 
														Callback = function(action)
															if action ~= nil then
																_Urwigo.MessageBox{
																	Text = _bv7r("\046\025\029\038\072\037\078\119\025\078\105\045\038\025\037\070\105\045\037\098\038\008\006\037\025\038\074\008\038\037\013\070\080\078\119\037\038\074\045\037\038\080\103\080\080\027\038\070\119\094\038\060\103\003\003\098\038\070\038\060\070\060\027\025\103\098\038\098\105\025\008\003\003\038\044\025\008\080\038\103\119\094\037\025\119\037\070\074\045\038\074\045\037\038\080\103\080\080\078\037\098\038\036\070\119\094\070\112\037\098\029"), 
																	Media = _MjO, 
																	Callback = function(action)
																		if action ~= nil then
																			_Urwigo.MessageBox{
																				Text = _bv7r("\120\074\091\098\038\070\038\080\070\060\038\074\008\038\074\045\037\038\080\078\098\098\078\119\112\038\070\025\074\078\044\070\105\074\098\111"), 
																				Media = _dncmT, 
																				Callback = function(action)
																					if action ~= nil then
																						_Od32O:MoveTo(Player)
																						_bZZo.Active = true
																						_ZbOI.Active = false
																						_g8T.Commands._INsP.Enabled = false
																						_g8T.Commands._OFAz.Enabled = true
																						_lI8:MoveTo(_xb1)
																						_lI8.Commands._lN4Z.Enabled = false
																						_Urwigo.MessageBox{
																							Text = _bv7r("\123\037\025\045\070\060\098\038\027\008\103\038\105\070\119\038\103\098\037\038\074\045\078\098\038\080\070\060\038\074\008\038\044\078\119\094\038\074\045\037\038\074\045\037\038\080\078\098\098\078\119\112\038\070\025\074\078\044\070\105\074\098\029\038\120\038\069\078\003\003\038\036\037\038\045\037\070\094\078\119\112\038\036\070\105\061\038\074\008\038\074\045\037\038\070\025\105\045\078\006\037\098\038\119\008\069\029\038\023\045\070\119\061\098\038\070\112\070\078\119\038\044\008\025\038\070\003\003\038\008\044\038\027\008\103\025\038\045\037\003\060\029"), 
																							Media = _HaGJ, 
																							Callback = function(action)
																								if action ~= nil then
																									_lI8.Commands._DR6_.Enabled = false
																									_lI8.Description = _bv7r("\046\025\029\038\072\037\078\119\025\078\105\045\038\078\098\038\008\006\037\025\113\008\027\037\094\038\027\008\103\038\044\008\103\119\094\038\045\078\098\038\080\078\098\098\078\119\112\038\037\013\045\078\036\078\074\029")
																									_ZbOI.Active = true
																									_wbxAK.Active = false
																									Wherigo.ShowScreen(Wherigo.MAINSCREEN)
																								end
																							end
																						}
																					end
																				end
																			}
																		end
																	end
																}
															end
														end
													}
												end
											end
										}
									end
								end
							}
						end
					end
				}
			end
		end
	}
end
function _0ERvV()
	if _vvmV > 0 then
		_oJjIW = 6
		_vvmV = _vvmV - 1
		_2sX.Description = (_bv7r("\062\008\103\038\105\103\025\025\037\119\074\003\027\038\045\070\006\037\038").._vvmV).._bv7r("\038\036\008\013\037\121\098\076\038\008\044\038\098\045\037\003\003\098\029")
		_g8T.Description = (_bv7r("\062\008\103\025\038\105\103\025\025\037\119\074\038\070\080\080\008\038\078\098\038").._oJjIW).._bv7r("\038\029")
		Wherigo.PlayAudio(_rGNY)
		_Urwigo.MessageBox{
			Text = (_bv7r("\062\008\103\038\025\037\003\008\070\094\038\027\008\103\025\038\112\103\119\029\038\062\008\103\038\045\070\006\037\038").._vvmV).._bv7r("\038\036\008\013\037\121\098\076\038\008\044\038\098\045\037\003\003\098\038\003\037\044\074\029"), 
			Media = _s5BQ, 
			Callback = function(action)
				if action ~= nil then
					Wherigo.Command "StopSound"
				end
			end
		}
	else
		_Urwigo.MessageBox{
			Text = _bv7r("\062\008\103\038\070\025\037\038\105\008\080\060\003\037\074\037\003\027\038\008\103\074\038\008\044\038\070\080\080\008\029"), 
			Media = _s5BQ, 
			Callback = function(action)
				if action ~= nil then
					Wherigo.ShowScreen(Wherigo.MAINSCREEN)
				end
			end
		}
	end
end

-- Begin user functions --
-- End user functions --
return _kidO
