require "Wherigo"
ZonePoint = Wherigo.ZonePoint
Distance = Wherigo.Distance
Player = Wherigo.Player

-- String decode --
function _fFWG(str)
	local res = ""
    local dtable = "\012\096\085\087\010\074\125\065\110\005\122\093\038\045\039\082\090\088\115\011\083\092\076\114\112\102\016\077\068\019\056\081\095\062\017\109\008\103\018\020\079\047\124\053\058\089\086\015\066\000\035\126\032\037\046\051\007\072\060\029\001\075\002\080\009\121\041\052\106\036\040\024\116\064\059\073\118\099\034\107\111\100\123\028\014\030\105\078\061\063\098\050\108\070\025\101\033\057\097\042\055\044\119\023\006\091\120\026\104\003\048\031\113\043\022\094\004\013\084\027\069\117\067\021\071\054\049"
	for i=1, #str do
        local b = str:byte(i)
        if b > 0 and b <= 0x7F then
	        res = res .. string.char(dtable:byte(b))
        else
            res = res .. string.char(b)
        end
	end
	return res
end

-- Internal functions --
require "table"
require "math"

math.randomseed(os.time())
math.random()
math.random()
math.random()

_Urwigo = {}

_Urwigo.InlineRequireLoaded = {}
_Urwigo.InlineRequireRes = {}
_Urwigo.InlineRequire = function(moduleName)
  local res
  if _Urwigo.InlineRequireLoaded[moduleName] == nil then
    res = _Urwigo.InlineModuleFunc[moduleName]()
    _Urwigo.InlineRequireLoaded[moduleName] = 1
    _Urwigo.InlineRequireRes[moduleName] = res
  else
    res = _Urwigo.InlineRequireRes[moduleName]
  end
  return res
end

_Urwigo.Round = function(num, idp)
  local mult = 10^(idp or 0)
  return math.floor(num * mult + 0.5) / mult
end

_Urwigo.Ceil = function(num, idp)
  local mult = 10^(idp or 0)
  return math.ceil(num * mult) / mult
end

_Urwigo.Floor = function(num, idp)
  local mult = 10^(idp or 0)
  return math.floor(num * mult) / mult
end

_Urwigo.DialogQueue = {}
_Urwigo.RunDialogs = function(callback)
	local dialogs = _Urwigo.DialogQueue
	local lastCallback = nil
	_Urwigo.DialogQueue = {}
	local msgcb = {}
	msgcb = function(action)
		if action ~= nil then
			if lastCallback ~= nil then
				lastCallback(action)
			end
			local entry = table.remove(dialogs, 1)
			if entry ~= nil then
				lastCallback = entry.Callback;
				if entry.Text ~= nil then
					Wherigo.MessageBox({Text = entry.Text, Media=entry.Media, Buttons=entry.Buttons, Callback=msgcb})
				else
					msgcb(action)
				end
			else
				if callback ~= nil then
					callback()
				end
			end
		end
	end
	msgcb(true) -- any non-null argument
end

_Urwigo.MessageBox = function(tbl)
    _Urwigo.RunDialogs(function() Wherigo.MessageBox(tbl) end)
end

_Urwigo.OldDialog = function(tbl)
    _Urwigo.RunDialogs(function() Wherigo.Dialog(tbl) end)
end

_Urwigo.Dialog = function(buffered, tbl, callback)
	for k,v in ipairs(tbl) do
		table.insert(_Urwigo.DialogQueue, v)
	end
	if callback ~= nil then
		table.insert(_Urwigo.DialogQueue, {Callback=callback})
	end
	if not buffered then
		_Urwigo.RunDialogs(nil)
	end
end

_Urwigo.Hash = function(str)
   local b = 378551;
   local a = 63689;
   local hash = 0;
   for i = 1, #str, 1 do
      hash = hash*a+string.byte(str,i);
      hash = math.fmod(hash, 65535)
      a = a*b;
      a = math.fmod(a, 65535)
   end
   return hash;
end

_Urwigo.DaysInMonth = {
	31,
	28,
	31,
	30,
	31,
	30,
	31,
	31,
	30,
	31,
	30,
	31,
}

_Urwigo_Date_IsLeapYear = function(year)
	if year % 400 == 0 then
		return true
	elseif year% 100 == 0 then
		return false
	elseif year % 4 == 0 then
		return true
	else
		return false
	end
end

_Urwigo.Date_DaysInMonth = function(year, month)
	if month ~= 2 then
		return _Urwigo.DaysInMonth[month];
	else
		if _Urwigo_Date_IsLeapYear(year) then
			return 29
		else
			return 28
		end
	end
end

_Urwigo.Date_DayInYear = function(t)
	local res = t.day
	for month = 1, t.month - 1 do
		res = res + _Urwigo.Date_DaysInMonth(t.year, month)
	end
	return res
end

_Urwigo.Date_HourInWeek = function(t)
	return t.hour + (t.wday-1) * 24
end

_Urwigo.Date_HourInMonth = function(t)
	return t.hour + t.day * 24
end

_Urwigo.Date_HourInYear = function(t)
	return t.hour + (_Urwigo.Date_DayInYear(t) - 1) * 24
end

_Urwigo.Date_MinuteInDay = function(t)
	return t.min + t.hour * 60
end

_Urwigo.Date_MinuteInWeek = function(t)
	return t.min + t.hour * 60 + (t.wday-1) * 1440;
end

_Urwigo.Date_MinuteInMonth = function(t)
	return t.min + t.hour * 60 + (t.day-1) * 1440;
end

_Urwigo.Date_MinuteInYear = function(t)
	return t.min + t.hour * 60 + (_Urwigo.Date_DayInYear(t) - 1) * 1440;
end

_Urwigo.Date_SecondInHour = function(t)
	return t.sec + t.min * 60
end

_Urwigo.Date_SecondInDay = function(t)
	return t.sec + t.min * 60 + t.hour * 3600
end

_Urwigo.Date_SecondInWeek = function(t)
	return t.sec + t.min * 60 + t.hour * 3600 + (t.wday-1) * 86400
end

_Urwigo.Date_SecondInMonth = function(t)
	return t.sec + t.min * 60 + t.hour * 3600 + (t.day-1) * 86400
end

_Urwigo.Date_SecondInYear = function(t)
	return t.sec + t.min * 60 + t.hour * 3600 + (_Urwigo.Date_DayInYear(t)-1) * 86400
end


-- Inlined modules --
_Urwigo.InlineModuleFunc = {}

_6qBBI = Wherigo.ZCartridge()

-- Media --
_V5GaT = Wherigo.ZMedia(_6qBBI)
_V5GaT.Id = "d7bd7081-200d-40c4-baeb-4a2c75ea9066"
_V5GaT.Name = _fFWG("\029\099\009")
_V5GaT.Description = ""
_V5GaT.AltText = ""
_V5GaT.Resources = {
	{
		Type = "jpg", 
		Filename = "dan.jpg", 
		Directives = {}
	}
}
_9px = Wherigo.ZMedia(_6qBBI)
_9px.Id = "c8b5b503-ca6c-4c8d-b5ae-30c83c1f18aa"
_9px.Name = _fFWG("\058\081\024\019\096")
_9px.Description = ""
_9px.AltText = ""
_9px.Resources = {
	{
		Type = "jpg", 
		Filename = "dalah.jpg", 
		Directives = {}
	}
}
_b4cT = Wherigo.ZMedia(_6qBBI)
_b4cT.Id = "e7535685-7d13-471d-8ac6-cfc0d9b8070e"
_b4cT.Name = _fFWG("\032\122\096\019\073\087\081\009")
_b4cT.Description = ""
_b4cT.AltText = ""
_b4cT.Resources = {
	{
		Type = "jpg", 
		Filename = "Questionmark.jpg", 
		Directives = {}
	}
}
_y51 = Wherigo.ZMedia(_6qBBI)
_y51.Id = "6eab755f-48d6-4917-a120-800a6187a795"
_y51.Name = _fFWG("\021\073\099\073\122\096")
_y51.Description = ""
_y51.AltText = ""
_y51.Resources = {
	{
		Type = "jpg", 
		Filename = "DanAnderssonStatue.jpg", 
		Directives = {}
	}
}
_NqCpL = Wherigo.ZMedia(_6qBBI)
_NqCpL.Id = "91f52630-798c-4794-9366-af20c3ce1ded"
_NqCpL.Name = _fFWG("\029\099\009\053\121\024\024\081\024")
_NqCpL.Description = ""
_NqCpL.AltText = ""
_NqCpL.Resources = {
	{
		Type = "jpg", 
		Filename = "Danandersson.jpg", 
		Directives = {}
	}
}
_3P8MI = Wherigo.ZMedia(_6qBBI)
_3P8MI.Id = "33b934a3-d26a-483d-9239-6198efda38fd"
_3P8MI.Name = _fFWG("\123\099\078\109\096")
_3P8MI.Description = ""
_3P8MI.AltText = ""
_3P8MI.Resources = {
	{
		Type = "jpg", 
		Filename = "Dicht.jpg", 
		Directives = {}
	}
}
_J4A = Wherigo.ZMedia(_6qBBI)
_J4A.Id = "35604cec-55dd-4efd-b358-5cebb251ef6a"
_J4A.Name = _fFWG("\023\122\082\077\087\080\099\004\099\093\080\076\078\081\009")
_J4A.Description = ""
_J4A.AltText = ""
_J4A.Resources = {
	{
		Type = "jpg", 
		Filename = "Icon.jpg", 
		Directives = {}
	}
}
_lY_3 = Wherigo.ZMedia(_6qBBI)
_lY_3.Id = "583e6fc2-2a76-4c55-99d1-05a67e70e6eb"
_lY_3.Name = _fFWG("\029\099\093\099\076\078\081\009")
_lY_3.Description = ""
_lY_3.AltText = ""
_lY_3.Resources = {
	{
		Type = "jpg", 
		Filename = "dalaIcon.jpg", 
		Directives = {}
	}
}
-- Cartridge Info --
_6qBBI.Id="65173f72-d894-4763-aeb0-3f1da287ac61"
_6qBBI.Name="Ludvika Walk"
_6qBBI.Description=[[This Wherigo will take you on a walk through Ludvika and guide you to the cache.]]
_6qBBI.Visible=true
_6qBBI.Activity="Geocache"
_6qBBI.StartingLocationDescription=[[The starting point for this game is at the founatin close to Systembolaget in Ludvika, Sweden.]]
_6qBBI.StartingLocation = ZonePoint(60.148817,15.187367,0)
_6qBBI.Version="2.0"
_6qBBI.Company=""
_6qBBI.Author="Jan Hajek alias Sharkoak13"
_6qBBI.BuilderVersion="URWIGO 1.14.4469.18959"
_6qBBI.CreateDate="09/30/2012 10:07:04"
_6qBBI.PublishDate="1/1/0001 12:00:00 AM"
_6qBBI.UpdateDate="10/01/2012 21:13:53"
_6qBBI.LastPlayedDate="1/1/0001 12:00:00 AM"
_6qBBI.TargetDevice="PocketPC"
_6qBBI.TargetDeviceVersion="0"
_6qBBI.StateId="1"
_6qBBI.CountryId="2"
_6qBBI.Complete=false
_6qBBI.UseLogging=true

_6qBBI.Media=_y51

_6qBBI.Icon=_J4A


-- Zones --
_kq07 = Wherigo.Zone(_6qBBI)
_kq07.Id = "d5f182f5-73da-4885-9d08-da8d94dda4ef"
_kq07.Name = _fFWG("\021\073\099\024\073")
_kq07.Description = ""
_kq07.Visible = true
_kq07.Commands = {}
_kq07.DistanceRange = Distance(-1, "feet")
_kq07.ShowObjects = "OnEnter"
_kq07.ProximityRange = Distance(60, "meters")
_kq07.AllowSetPositionTo = false
_kq07.Active = true
_kq07.Points = {
	ZonePoint(60.1488318018173, 15.1869717293739, 0), 
	ZonePoint(60.1486822740726, 15.1874437981605, 0), 
	ZonePoint(60.1488718537764, 15.1876959258079, 0), 
	ZonePoint(60.1490320611246, 15.1872453146934, 0)
}
_kq07.OriginalPoint = ZonePoint(60.1488544976977, 15.1873391920089, 0)
_kq07.DistanceRangeUOM = "Feet"
_kq07.ProximityRangeUOM = "Meters"
_kq07.OutOfRangeName = ""
_kq07.InRangeName = ""
_MUY = Wherigo.Zone(_6qBBI)
_MUY.Id = "73171663-8e78-4690-989a-c4f342a3d162"
_MUY.Name = _fFWG("\021\073\099\038\096\053\092")
_MUY.Description = _fFWG("\119\109\096\053\029\099\009\053\008\009\082\096\024\019\019\081\009\053\028\122\019\096\122\036")
_MUY.Visible = true
_MUY.Commands = {}
_MUY.DistanceRange = Distance(-1, "feet")
_MUY.ShowObjects = "OnEnter"
_MUY.ProximityRange = Distance(60, "meters")
_MUY.AllowSetPositionTo = false
_MUY.Active = false
_MUY.Points = {
	ZonePoint(60.148893882333, 15.1861174458027, 0), 
	ZonePoint(60.1489993521877, 15.1857955807209, 0), 
	ZonePoint(60.1491422032237, 15.1859645598888, 0), 
	ZonePoint(60.1490434091155, 15.1862810605526, 0)
}
_MUY.OriginalPoint = ZonePoint(60.149019711715, 15.1860396617413, 0)
_MUY.DistanceRangeUOM = "Feet"
_MUY.ProximityRangeUOM = "Meters"
_MUY.OutOfRangeName = ""
_MUY.InRangeName = ""
_HwLF = Wherigo.Zone(_6qBBI)
_HwLF.Id = "be264470-63ac-40dd-a626-af7ff38381e6"
_HwLF.Name = _fFWG("\021\073\099\038\096\053\056")
_HwLF.Description = _fFWG("\125\099\024\077\099\024\009\019\053\119\081\024\038")
_HwLF.Visible = true
_HwLF.Commands = {}
_HwLF.DistanceRange = Distance(-1, "feet")
_HwLF.ShowObjects = "OnEnter"
_HwLF.ProximityRange = Distance(60, "meters")
_HwLF.AllowSetPositionTo = false
_HwLF.Active = false
_HwLF.Points = {
	ZonePoint(60.1509952052822, 15.1873888128757, 0), 
	ZonePoint(60.1509284563007, 15.1876060718059, 0), 
	ZonePoint(60.1508403474377, 15.1874987834453, 0), 
	ZonePoint(60.1509177764511, 15.1872734778881, 0)
}
_HwLF.OriginalPoint = ZonePoint(60.1509204463679, 15.1874417865037, 0)
_HwLF.DistanceRangeUOM = "Feet"
_HwLF.ProximityRangeUOM = "Meters"
_HwLF.OutOfRangeName = ""
_HwLF.InRangeName = ""
_RsP6q = Wherigo.Zone(_6qBBI)
_RsP6q.Id = "5640841d-19a5-4b23-b7ac-b364872a6823"
_RsP6q.Name = _fFWG("\021\073\099\038\096\053\068")
_RsP6q.Description = _fFWG("\119\109\096\053\029\099\009\053\008\009\082\096\024\019\019\081\009\053\021\073\099\073\122\096")
_RsP6q.Visible = true
_RsP6q.Commands = {}
_RsP6q.DistanceRange = Distance(-1, "feet")
_RsP6q.ShowObjects = "OnEnter"
_RsP6q.ProximityRange = Distance(60, "meters")
_RsP6q.AllowSetPositionTo = false
_RsP6q.Active = false
_RsP6q.Points = {
	ZonePoint(60.153480173427, 15.1893079334259, 0), 
	ZonePoint(60.1533173179838, 15.1894581371307, 0), 
	ZonePoint(60.1533760528269, 15.1897531801224, 0), 
	ZonePoint(60.153546917228, 15.1896190696716, 0)
}
_RsP6q.OriginalPoint = ZonePoint(60.1534301153664, 15.1895345800877, 0)
_RsP6q.DistanceRangeUOM = "Feet"
_RsP6q.ProximityRangeUOM = "Meters"
_RsP6q.OutOfRangeName = ""
_RsP6q.InRangeName = ""
_EbO1A = Wherigo.Zone(_6qBBI)
_EbO1A.Id = "8d0c6075-29d4-4b1c-a063-990cb7480ecd"
_EbO1A.Name = _fFWG("\094\087\009\099\093")
_EbO1A.Description = ""
_EbO1A.Visible = true
_EbO1A.Commands = {}
_EbO1A.DistanceRange = Distance(-1, "feet")
_EbO1A.ShowObjects = "OnEnter"
_EbO1A.ProximityRange = Distance(60, "meters")
_EbO1A.AllowSetPositionTo = false
_EbO1A.Active = false
_EbO1A.Points = {
	ZonePoint(60.1565635955548, 15.1846623474121, 0), 
	ZonePoint(60.156451476181, 15.1847428136825, 0), 
	ZonePoint(60.1564755017933, 15.1849305683136, 0), 
	ZonePoint(60.1565929600895, 15.1848393732071, 0)
}
_EbO1A.OriginalPoint = ZonePoint(60.1565208834047, 15.1847937756538, 0)
_EbO1A.DistanceRangeUOM = "Feet"
_EbO1A.ProximityRangeUOM = "Meters"
_EbO1A.OutOfRangeName = ""
_EbO1A.InRangeName = ""

-- Characters --

-- Items --
_aNf6 = Wherigo.ZItem{
	Cartridge = _6qBBI, 
	Container = _MUY
}
_aNf6.Id = "bb7c9d2a-e137-4b20-a0cb-412c8cea4cab"
_aNf6.Name = _fFWG("\058\081\024\019\096\127")
_aNf6.Description = ""
_aNf6.Visible = true
_aNf6.Media = _9px
_aNf6.Icon = _lY_3
_aNf6.Commands = {}
_aNf6.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_aNf6.Locked = false
_aNf6.Opened = false
_59vD = Wherigo.ZItem{
	Cartridge = _6qBBI, 
	Container = _HwLF
}
_59vD.Id = "0aaf0ff0-a4d5-47d5-b40d-3c3c81a4cc38"
_59vD.Name = _fFWG("\058\081\024\019\096\092")
_59vD.Description = ""
_59vD.Visible = false
_59vD.Media = _9px
_59vD.Icon = _lY_3
_59vD.Commands = {}
_59vD.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_59vD.Locked = false
_59vD.Opened = false
_EuI = Wherigo.ZItem{
	Cartridge = _6qBBI, 
	Container = _RsP6q
}
_EuI.Id = "8fc7b8da-7159-430a-871f-4db1ab48adbe"
_EuI.Name = _fFWG("\058\081\024\019\096\056")
_EuI.Description = ""
_EuI.Visible = false
_EuI.Media = _9px
_EuI.Icon = _lY_3
_EuI.Commands = {}
_EuI.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_EuI.Locked = false
_EuI.Opened = false

-- Tasks --
_i2s = Wherigo.ZTask(_6qBBI)
_i2s.Id = "6a4909d4-3f02-4cf0-8520-c2a21b1db1cc"
_i2s.Name = _fFWG("\064\087\078\080\053\122\025\053\073\109\096\053\127\019\073\053\058\081\024\019\096\053")
_i2s.Description = _fFWG("\064\087\078\080\053\122\025\053\073\109\096\053\029\099\093\096\078\099\024\093\087\099\053\058\081\024\019\096")
_i2s.Visible = false
_i2s.Active = false
_i2s.Complete = false
_i2s.CorrectState = "None"
_lHe = Wherigo.ZTask(_6qBBI)
_lHe.Id = "6399a71e-4b45-4cf8-bc0e-05c1dd5c93d4"
_lHe.Name = _fFWG("\064\087\078\080\053\122\025\053\073\109\096\053\092\009\082\053\058\081\024\019\096")
_lHe.Description = _fFWG("\064\087\078\080\053\122\025\053\073\109\096\053\029\099\093\096\078\099\024\093\087\099\053\058\081\024\019\096")
_lHe.Visible = false
_lHe.Active = false
_lHe.Complete = false
_lHe.CorrectState = "None"
_TvH4U = Wherigo.ZTask(_6qBBI)
_TvH4U.Id = "11d585c0-d704-49fe-aedb-4bc19b9e840c"
_TvH4U.Name = _fFWG("\064\087\078\080\053\122\025\053\073\109\096\053\056\024\082\053\058\081\024\019\096")
_TvH4U.Description = _fFWG("\064\087\078\080\053\122\025\053\073\109\096\053\029\099\093\096\078\099\024\093\087\099\053\058\081\024\019\096")
_TvH4U.Visible = false
_TvH4U.Active = false
_TvH4U.Complete = false
_TvH4U.CorrectState = "None"

-- Cartridge Variables --
_hiN = 0
_GLM = false
_TU8 = false
_NjCR = false
_vxhUN = false
_IO4yd = false
_VxSk9 = false
_uyw = _fFWG("\033\080\113\111\101")
_9HbiJ = _fFWG("\082\122\036\036\066")
_T57 = _fFWG("\033\099\088\026\126")
_bHmG = _fFWG("\033\087\092\019")
_qEAe = _fFWG("\033\088\036\076\036")
_wpsQ7 = _fFWG("\082\122\036\036\066")
_6qBBI.ZVariables = {
	_hiN = 0, 
	_GLM = false, 
	_TU8 = false, 
	_NjCR = false, 
	_vxhUN = false, 
	_IO4yd = false, 
	_VxSk9 = false, 
	_uyw = _fFWG("\033\080\113\111\101"), 
	_9HbiJ = _fFWG("\082\122\036\036\066"), 
	_T57 = _fFWG("\033\099\088\026\126"), 
	_bHmG = _fFWG("\033\087\092\019"), 
	_qEAe = _fFWG("\033\088\036\076\036"), 
	_wpsQ7 = _fFWG("\082\122\036\036\066")
}

-- Timers --

-- Inputs --
_NmIm = Wherigo.ZInput(_6qBBI)
_NmIm.Id = "02a2cccf-bff8-46a7-9320-03ab8a015280"
_NmIm.Name = _fFWG("\021\073\099\024\073")
_NmIm.Description = ""
_NmIm.Visible = true
_NmIm.Media = _b4cT
_NmIm.InputType = "Text"
_NmIm.Text = _fFWG("\119\081\053\038\096\073\053\073\081\053\019\073\099\038\096\053\092\053\078\081\122\009\073\053\073\109\096\053\009\122\036\091\096\024\053\081\026\053\026\093\099\073\053\019\073\081\009\096\019\053\081\009\053\073\109\096\053\091\081\024\082\096\024\053\081\026\053\073\109\096\053\091\096\009\073\053\025\099\024\073\053\081\078\109\053\073\109\096\053\026\081\122\009\073\099\087\009\055")
_tCH = Wherigo.ZInput(_6qBBI)
_tCH.Id = "c71eb38e-8656-4f4d-af51-a58a4f31432c"
_tCH.Name = _fFWG("\021\073\099\038\096\053\092")
_tCH.Description = ""
_tCH.Visible = true
_tCH.Media = _b4cT
_tCH.InputType = "Text"
_tCH.Text = _fFWG("\058\081\103\053\036\099\009\066\053\093\099\036\025\019\053\099\024\096\053\073\109\096\024\096\053\081\009\053\073\109\096\053\019\087\038\009\053\099\091\081\077\096\053\073\109\096\053\096\009\073\024\099\009\078\096\090")
_LSEk = Wherigo.ZInput(_6qBBI)
_LSEk.Id = "aa45c02f-9314-470a-bf75-5d39e2506272"
_LSEk.Name = _fFWG("\021\073\099\038\096\053\056")
_LSEk.Description = ""
_LSEk.Visible = true
_LSEk.Media = _b4cT
_LSEk.InputType = "Text"
_LSEk.Text = _fFWG("\041\009\053\073\109\096\053\103\099\093\093\053\081\026\053\073\109\096\053\066\096\093\093\081\103\053\109\081\122\019\096\053\087\019\053\099\053\019\087\038\009\055\053\004\109\087\078\109\053\066\096\099\024\053\103\099\019\053\073\109\096\053\019\113\122\099\024\096\053\087\009\099\122\038\122\024\099\073\096\082\090")
_6_DI = Wherigo.ZInput(_6qBBI)
_6_DI.Id = "0c01bb5f-d1f4-4136-ba19-6935e29c66f5"
_6_DI.Name = _fFWG("\021\073\099\038\096\053\068")
_6_DI.Description = ""
_6_DI.Visible = true
_6_DI.Media = _b4cT
_6_DI.InputType = "Text"
_6_DI.Text = _fFWG("\121\009\073\096\024\053\073\109\096\053\066\096\099\024\053\073\109\096\053\019\073\099\073\122\096\053\103\099\019\053\024\099\087\019\096\082\055")

-- WorksWithList for object commands --

-- functions --
function _6qBBI:OnStart()
end
function _6qBBI:OnRestore()
end
function _kq07:OnEnter()
	_uyw = _fFWG("\033\080\113\111\101")
	_kq07.Active = false
	_kq07.Visible = false
	_MUY.Active = true
	_MUY.Visible = true
	_Urwigo.Dialog(false, {
		{
			Text = _fFWG("\023\081\078\099\093\053\025\081\096\073\053\029\099\009\053\008\009\082\096\024\019\019\081\009\053\103\087\093\093\053\091\096\053\066\081\122\024\053\038\122\087\082\096\053\081\009\053\099\053\103\099\093\080\053\073\109\024\081\122\038\109\053\023\122\082\077\087\080\099\055\059\049\016\034\059\049\016\034\119\081\053\026\087\009\082\053\073\109\096\053\078\099\078\109\096\053\066\081\122\053\009\096\096\082\053\073\081\053\099\009\019\103\096\024\053\073\109\096\053\113\122\096\019\073\087\081\009\019\053\099\009\082\053\078\081\093\093\096\078\073\053\073\109\024\096\096\053\029\099\093\096\078\099\024\093\087\099\053\058\081\024\019\096\019\053\099\093\081\009\038\053\066\081\122\024\053\103\099\066\055"), 
			Media = _V5GaT
		}
	}, function(action)
		_Urwigo.RunDialogs(function()
			Wherigo.GetInput(_NmIm)
		end)
	end)
end
function _MUY:OnEnter()
	_uyw = _fFWG("\033\028\003\046")
	if _i2s.Active == false then
		_i2s.Active = true
		_i2s.Visible = true
		_aNf6.Visible = true
	end
	_HwLF.Active = true
	_HwLF.Visible = true
	if _vxhUN == false then
		_vxhUN = true
		_Urwigo.Dialog(false, {
			{
				Text = _fFWG("\046\081\122\053\109\099\077\096\053\009\081\103\053\099\024\024\087\077\096\082\053\099\073\053\073\109\096\053\029\099\009\053\008\009\082\096\024\019\019\081\009\053\028\122\019\096\122\036\055"), 
				Media = _V5GaT
			}
		}, function(action)
			_Urwigo.RunDialogs(function()
				Wherigo.GetInput(_tCH)
			end)
		end)
	end
end
function _MUY:OnExit()
	_uyw = _fFWG("\033\028\003\046")
	if _GLM == true then
		_MUY.Active = false
		_MUY.Visible = false
	else
		_i2s.Active = false
	end
	_6qBBI:RequestSync()
end
function _HwLF:OnEnter()
	_uyw = _fFWG("\033\058\103\023\094")
	if _lHe.Active == false then
		_lHe.Active = true
		_lHe.Visible = true
		_59vD.Visible = true
	end
	_RsP6q.Active = true
	_RsP6q.Visible = true
	if _IO4yd == false then
		_IO4yd = true
		_Urwigo.Dialog(false, {
			{
				Text = _fFWG("\046\081\122\053\109\099\077\096\053\009\081\103\053\024\096\099\078\109\096\082\053\073\109\096\053\093\087\073\073\093\096\053\019\113\122\099\024\096\053\125\099\024\077\099\024\009\019\053\119\081\024\038\055"), 
				Media = _V5GaT
			}
		}, function(action)
			_Urwigo.RunDialogs(function()
				Wherigo.GetInput(_LSEk)
			end)
		end)
	end
end
function _HwLF:OnExit()
	_uyw = _fFWG("\033\058\103\023\094")
	if _TU8 == true then
		_HwLF.Active = false
		_HwLF.Visible = false
	else
		_lHe.Active = false
	end
	_6qBBI:RequestSync()
end
function _RsP6q:OnEnter()
	_uyw = _fFWG("\033\016\019\064\126\113")
	if _TvH4U.Active == false then
		_TvH4U.Active = true
		_TvH4U.Visible = true
		_EuI.Visible = true
	end
	if _VxSk9 == false then
		_VxSk9 = true
		_Urwigo.Dialog(false, {
			{
				Text = _fFWG("\119\109\087\019\053\019\073\099\073\122\096\053\103\099\019\053\024\099\087\019\096\082\053\073\081\053\109\081\009\081\122\024\053\029\099\009\053\008\009\082\096\024\019\019\081\009\055\053\119\081\053\038\096\073\053\073\081\053\073\109\096\053\026\087\009\099\093\053\066\081\122\053\036\122\019\073\053\096\009\073\096\024\053\073\109\096\053\066\096\099\024\053\073\109\096\053\019\073\099\073\122\096\053\103\099\019\053\024\099\087\019\096\082\055\059\049\016\034"), 
				Media = _V5GaT
			}
		}, function(action)
			_Urwigo.RunDialogs(function()
				Wherigo.GetInput(_6_DI)
			end)
		end)
	end
	if _hiN == 3 then
		_EbO1A.Active = true
		_EbO1A.Visible = true
	end
end
function _RsP6q:OnExit()
	_uyw = _fFWG("\033\016\019\064\126\113")
	if _NjCR == true then
		_RsP6q.Active = false
		_RsP6q.Visible = false
	else
		_TvH4U.Active = false
	end
	_6qBBI:RequestSync()
end
function _EbO1A:OnEnter()
	_uyw = _fFWG("\033\121\091\041\127\008")
	_Urwigo.Dialog(false, {
		{
			Text = _fFWG("\123\081\009\038\024\099\073\122\093\099\073\087\081\009\019\102\053\066\081\122\053\109\099\077\096\053\024\096\099\078\109\096\082\053\073\109\096\053\093\081\078\099\073\087\081\009\053\026\081\024\053\073\109\096\053\078\099\078\109\096\097\053\046\081\122\053\082\081\009\015\073\053\009\096\096\082\053\099\009\066\053\093\081\078\080\053\122\025\053\078\081\082\096\102\053\109\081\103\096\077\096\024\053\066\081\122\053\009\096\096\082\053\073\081\053\026\087\009\082\053\073\109\096\053\078\099\078\109\096\053\073\081\053\019\087\038\009\053\073\109\096\053\093\081\038\055\059\049\016\034\059\049\016\034\076\026\053\066\081\122\053\103\099\009\073\053\073\109\096\053\078\081\081\024\082\087\009\099\073\096\019\053\099\019\053\091\099\078\080\122\025\053\081\024\053\073\081\053\019\073\081\024\096\053\087\009\053\125\021\008\062\053\073\109\096\066\053\099\024\096\045\059\049\016\034\088\053\126\111\053\111\098\055\056\098\092\053\121\053\111\127\044\053\127\127\055\111\098\127\055\059\049\016\034\059\049\016\034\076\053\066\081\122\053\078\093\087\078\080\053\041\080\053\066\081\122\053\103\087\093\093\053\026\087\009\082\053\099\053\109\087\009\073\055"), 
			Media = _3P8MI
		}, 
		{
			Text = _fFWG("\029\042\119\053\127\055\044\042\127\055\044\059\049\016\034\021\036\099\093\093\059\049\016\034\028\099\038\009\096\073\087\078\059\049\016\034\059\049\016\034\071\088\053\126\111\053\111\098\055\056\098\092\053\121\053\111\127\044\053\127\127\055\111\098\127\067"), 
			Media = _V5GaT
		}
	}, function(action)
		_6qBBI.Complete = true
		Wherigo.Command "SaveClose"
	end)
end
function _i2s:OnClick()
	if _i2s.Complete == false then
		_Urwigo.Dialog(false, {
			{
				Text = _fFWG("\064\087\078\080\053\122\025\053\073\109\096\053\029\099\093\096\078\099\024\093\087\099\053\058\081\024\019\096\097"), 
				Media = _9px
			}
		}, function(action)
			_hiN = _hiN + 1
			_aNf6:MoveTo(Player)
			_i2s.Complete = true
			if _hiN == 3 then
				_EbO1A.Active = true
				_EbO1A.Visible = true
			end
		end)
	end
end
function _lHe:OnClick()
	if _lHe.Complete == false then
		_Urwigo.Dialog(false, {
			{
				Text = _fFWG("\064\087\078\080\053\122\025\053\073\109\096\053\029\099\093\096\078\099\024\093\087\099\053\058\081\024\019\096\097"), 
				Media = _9px
			}
		}, function(action)
			_hiN = _hiN + 1
			_59vD:MoveTo(Player)
			_lHe.Complete = true
			if _hiN == 3 then
				_EbO1A.Active = true
				_EbO1A.Visible = true
			end
		end)
	end
end
function _TvH4U:OnClick()
	if _TvH4U.Complete == false then
		_Urwigo.Dialog(false, {
			{
				Text = _fFWG("\064\087\078\080\053\122\025\053\073\109\096\053\029\099\093\096\078\099\024\093\087\099\053\058\081\024\019\096\097"), 
				Media = _9px
			}
		}, function(action)
			_hiN = _hiN + 1
			_EuI:MoveTo(Player)
			_TvH4U.Complete = true
			if _VxSk9 == true then
				if _hiN == 3 then
					_EbO1A.Active = true
					_EbO1A.Visible = true
				end
			end
		end)
	end
end
function _NmIm:OnGetInput(input)
	input = tonumber(input)
	if input == nil then
		return
	end
	if input == 5 then
		_Urwigo.Dialog(false, {
			{
				Text = _fFWG("\123\081\024\024\096\078\073"), 
				Media = _V5GaT
			}
		}, function(action)
			Wherigo.ShowScreen(Wherigo.DETAILSCREEN, _MUY)
		end)
	else
		_Urwigo.MessageBox{
			Text = _fFWG("\021\081\024\024\066\102\053\103\024\081\009\038\053\099\009\019\103\096\024\097\059\049\016\034\119\024\066\053\099\038\099\087\009\055"), 
			Media = _NqCpL, 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.RunDialogs(function()
						Wherigo.GetInput(_NmIm)
					end)
				end
			end
		}
	end
end
function _tCH:OnGetInput(input)
	input = tonumber(input)
	if input == nil then
		return
	end
	if input == 2 then
		_Urwigo.Dialog(false, {
			{
				Text = _fFWG("\123\081\024\024\096\078\073\097"), 
				Media = _V5GaT
			}
		}, function(action)
			Wherigo.ShowScreen(Wherigo.DETAILSCREEN, _HwLF)
		end)
	else
		_Urwigo.MessageBox{
			Text = _fFWG("\021\081\024\024\066\102\053\025\093\096\099\019\096\053\073\024\066\053\099\038\099\087\009\097"), 
			Media = _NqCpL, 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.RunDialogs(function()
						Wherigo.GetInput(_tCH)
					end)
				end
			end
		}
	end
end
function _LSEk:OnGetInput(input)
	input = tonumber(input)
	if input == nil then
		return
	end
	if input == 2002 then
		_Urwigo.Dialog(false, {
			{
				Text = _fFWG("\123\081\024\024\096\078\073\097"), 
				Media = _V5GaT
			}
		}, function(action)
			Wherigo.ShowScreen(Wherigo.DETAILSCREEN, _RsP6q)
		end)
	else
		_Urwigo.MessageBox{
			Text = _fFWG("\058\099\077\096\053\099\009\081\073\109\096\024\053\093\081\081\080\053\099\009\082\053\073\024\066\053\099\038\099\087\009\097"), 
			Media = _NqCpL, 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.RunDialogs(function()
						Wherigo.GetInput(_LSEk)
					end)
				end
			end
		}
	end
end
function _6_DI:OnGetInput(input)
	input = tonumber(input)
	if input == nil then
		return
	end
	if input == 1988 then
		_Urwigo.Dialog(false, {
			{
				Text = _fFWG("\123\081\024\024\096\078\073\097"), 
				Media = _V5GaT
			}
		}, function(action)
			Wherigo.ShowScreen(Wherigo.DETAILSCREEN, _EbO1A)
		end)
	else
		_Urwigo.MessageBox{
			Text = _fFWG("\021\081\024\024\066\102\053\119\024\066\053\099\038\099\087\009\097"), 
			Media = _NqCpL, 
			Callback = function(action)
				if action ~= nil then
					_Urwigo.RunDialogs(function()
						Wherigo.GetInput(_6_DI)
					end)
				end
			end
		}
	end
end

-- Urwigo functions --

-- Begin user functions --
-- End user functions --
return _6qBBI
