﻿require "Wherigo"
ZonePoint = Wherigo.ZonePoint
Distance = Wherigo.Distance
Player = Wherigo.Player

-- String decode --
function _MtNtL(str)
	local res = ""
    local dtable = "\068\065\084\040\115\041\126\071\058\072\049\056\087\076\083\086\042\110\102\018\054\051\123\022\011\033\025\064\032\124\118\121\091\108\026\030\019\057\009\104\119\069\070\060\085\122\099\013\037\075\021\045\010\055\097\029\080\005\120\043\036\014\090\006\059\004\113\016\117\031\052\038\053\035\001\062\096\008\109\101\028\002\044\027\023\063\012\048\114\003\047\098\079\088\093\095\017\061\100\111\082\073\116\007\067\107\105\050\015\081\089\106\112\103\039\046\066\074\094\092\078\020\125\077\024\000\034"
	for i=1, #str do
        local b = str:byte(i)
        if b > 0 and b <= 0x7F then
	        res = res .. string.char(dtable:byte(b))
        else
            res = res .. string.char(b)
        end
	end
	return res
end

-- Internal functions --
require "table"
require "math"

math.randomseed(os.time())
math.random()
math.random()
math.random()

_Urwigo = {}

_Urwigo.InlineRequireLoaded = {}
_Urwigo.InlineRequireRes = {}
_Urwigo.InlineRequire = function(moduleName)
  local res
  if _Urwigo.InlineRequireLoaded[moduleName] == nil then
    res = _Urwigo.InlineModuleFunc[moduleName]()
    _Urwigo.InlineRequireLoaded[moduleName] = 1
    _Urwigo.InlineRequireRes[moduleName] = res
  else
    res = _Urwigo.InlineRequireRes[moduleName]
  end
  return res
end

_Urwigo.Round = function(num, idp)
  local mult = 10^(idp or 0)
  return math.floor(num * mult + 0.5) / mult
end

_Urwigo.Ceil = function(num, idp)
  local mult = 10^(idp or 0)
  return math.ceil(num * mult) / mult
end

_Urwigo.Floor = function(num, idp)
  local mult = 10^(idp or 0)
  return math.floor(num * mult) / mult
end

_Urwigo.DialogQueue = {}
_Urwigo.RunDialogs = function(callback)
	local dialogs = _Urwigo.DialogQueue
	local lastCallback = nil
	_Urwigo.DialogQueue = {}
	local msgcb = {}
	msgcb = function(action)
		if action ~= nil then
			if lastCallback ~= nil then
				lastCallback(action)
			end
			local entry = table.remove(dialogs, 1)
			if entry ~= nil then
				lastCallback = entry.Callback;
				if entry.Text ~= nil then
					Wherigo.MessageBox({Text = entry.Text, Media=entry.Media, Buttons=entry.Buttons, Callback=msgcb})
				else
					msgcb(action)
				end
			else
				if callback ~= nil then
					callback()
				end
			end
		end
	end
	msgcb(true) -- any non-null argument
end

_Urwigo.MessageBox = function(tbl)
    _Urwigo.RunDialogs(function() Wherigo.MessageBox(tbl) end)
end

_Urwigo.OldDialog = function(tbl)
    _Urwigo.RunDialogs(function() Wherigo.Dialog(tbl) end)
end

_Urwigo.Dialog = function(buffered, tbl, callback)
	for k,v in ipairs(tbl) do
		table.insert(_Urwigo.DialogQueue, v)
	end
	if callback ~= nil then
		table.insert(_Urwigo.DialogQueue, {Callback=callback})
	end
	if not buffered then
		_Urwigo.RunDialogs(nil)
	end
end

_Urwigo.Hash = function(str)
   local b = 378551;
   local a = 63689;
   local hash = 0;
   for i = 1, #str, 1 do
      hash = hash*a+string.byte(str,i);
      hash = math.fmod(hash, 65535)
      a = a*b;
      a = math.fmod(a, 65535)
   end
   return hash;
end

_Urwigo.DaysInMonth = {
	31,
	28,
	31,
	30,
	31,
	30,
	31,
	31,
	30,
	31,
	30,
	31,
}

_Urwigo_Date_IsLeapYear = function(year)
	if year % 400 == 0 then
		return true
	elseif year% 100 == 0 then
		return false
	elseif year % 4 == 0 then
		return true
	else
		return false
	end
end

_Urwigo.Date_DaysInMonth = function(year, month)
	if month ~= 2 then
		return _Urwigo.DaysInMonth[month];
	else
		if _Urwigo_Date_IsLeapYear(year) then
			return 29
		else
			return 28
		end
	end
end

_Urwigo.Date_DayInYear = function(t)
	local res = t.day
	for month = 1, t.month - 1 do
		res = res + _Urwigo.Date_DaysInMonth(t.year, month)
	end
	return res
end

_Urwigo.Date_HourInWeek = function(t)
	return t.hour + (t.wday-1) * 24
end

_Urwigo.Date_HourInMonth = function(t)
	return t.hour + t.day * 24
end

_Urwigo.Date_HourInYear = function(t)
	return t.hour + (_Urwigo.Date_DayInYear(t) - 1) * 24
end

_Urwigo.Date_MinuteInDay = function(t)
	return t.min + t.hour * 60
end

_Urwigo.Date_MinuteInWeek = function(t)
	return t.min + t.hour * 60 + (t.wday-1) * 1440;
end

_Urwigo.Date_MinuteInMonth = function(t)
	return t.min + t.hour * 60 + (t.day-1) * 1440;
end

_Urwigo.Date_MinuteInYear = function(t)
	return t.min + t.hour * 60 + (_Urwigo.Date_DayInYear(t) - 1) * 1440;
end

_Urwigo.Date_SecondInHour = function(t)
	return t.sec + t.min * 60
end

_Urwigo.Date_SecondInDay = function(t)
	return t.sec + t.min * 60 + t.hour * 3600
end

_Urwigo.Date_SecondInWeek = function(t)
	return t.sec + t.min * 60 + t.hour * 3600 + (t.wday-1) * 86400
end

_Urwigo.Date_SecondInMonth = function(t)
	return t.sec + t.min * 60 + t.hour * 3600 + (t.day-1) * 86400
end

_Urwigo.Date_SecondInYear = function(t)
	return t.sec + t.min * 60 + t.hour * 3600 + (_Urwigo.Date_DayInYear(t)-1) * 86400
end


-- Inlined modules --
_Urwigo.InlineModuleFunc = {}

_V02gO = Wherigo.ZCartridge()

-- Media --
_k2va = Wherigo.ZMedia(_V02gO)
_k2va.Id = "bd7d073e-d55f-49d6-b4e2-aa1b1db25261"
_k2va.Name = _MtNtL("\121\015\008\050\055\089\103\080")
_k2va.Description = ""
_k2va.AltText = ""
_k2va.Resources = {
	{
		Type = "jpg", 
		Filename = "Bodentypen-NSG-Eldena.jpg", 
		Directives = {}
	}
}
_ixVA = Wherigo.ZMedia(_V02gO)
_ixVA.Id = "b3c8272f-a741-4844-b828-5ba1dc959a62"
_ixVA.Name = _MtNtL("\117\100\099\080\018\040\100\089\107\046\100\018\103")
_ixVA.Description = ""
_ixVA.AltText = ""
_ixVA.Resources = {
	{
		Type = "png", 
		Filename = "800px-Soil_profile.png", 
		Directives = {}
	}
}
_d4u = Wherigo.ZMedia(_V02gO)
_d4u.Id = "de9dd729-6b24-433f-bb91-d57200b6a25b"
_d4u.Name = _MtNtL("\080\069\034\080")
_d4u.Description = ""
_d4u.AltText = ""
_d4u.Resources = {
	{
		Type = "jpg", 
		Filename = "nsg.jpg", 
		Directives = {}
	}
}
_USs = Wherigo.ZMedia(_V02gO)
_USs.Id = "6c947173-b634-4481-8c1e-0fc3aae1246c"
_USs.Name = _MtNtL("\107\047\100\096\080\069\034\080")
_USs.Description = ""
_USs.AltText = ""
_USs.Resources = {
	{
		Type = "png", 
		Filename = "ico_nsg.png", 
		Directives = {}
	}
}
_Im_CQ = Wherigo.ZMedia(_V02gO)
_Im_CQ.Id = "dfaea0da-b0ee-4607-bb2a-643260e1b79e"
_Im_CQ.Name = _MtNtL("\107\047\100\096\034\107\103\080\089\055\103\069\089")
_Im_CQ.Description = ""
_Im_CQ.AltText = ""
_Im_CQ.Resources = {
	{
		Type = "png", 
		Filename = "ico_literatur.png", 
		Directives = {}
	}
}
_hALJ = Wherigo.ZMedia(_V02gO)
_hALJ.Id = "26b9201a-96d8-4016-a11f-6d6e60f49eaa"
_hALJ.Name = _MtNtL("\107\047\100\096\005\100\034")
_hALJ.Description = ""
_hALJ.AltText = ""
_hALJ.Resources = {
	{
		Type = "png", 
		Filename = "ico_fons.png", 
		Directives = {}
	}
}
_YOSO = Wherigo.ZMedia(_V02gO)
_YOSO.Id = "09c1b620-b04a-42a7-b15e-4b500ee41059"
_YOSO.Name = _MtNtL("\005\100\034")
_YOSO.Description = ""
_YOSO.AltText = ""
_YOSO.Resources = {
	{
		Type = "jpg", 
		Filename = "fons.jpg", 
		Directives = {}
	}
}
_jXC = Wherigo.ZMedia(_V02gO)
_jXC.Id = "684371b5-4fef-44bb-9e8d-4864dd83e7ac"
_jXC.Name = _MtNtL("\107\047\100\096\113\055\113\080\089")
_jXC.Description = ""
_jXC.AltText = ""
_jXC.Resources = {
	{
		Type = "png", 
		Filename = "ico_antworten.png", 
		Directives = {}
	}
}
-- Cartridge Info --
_V02gO.Id="c6304d5e-850d-4f0f-902d-2b945b3ed6e3"
_V02gO.Name="Die Böden eines Waldes"
_V02gO.Description=[[]]
_V02gO.Visible=true
_V02gO.Activity="TourGuide"
_V02gO.StartingLocationDescription=[[]]
_V02gO.StartingLocation = ZonePoint(54.0739667,13.4610667,0)
_V02gO.Version=""
_V02gO.Company=""
_V02gO.Author="SastR'e.O"
_V02gO.BuilderVersion="URWIGO 1.22.5798.37755"
_V02gO.CreateDate="04/03/2019 21:24:55"
_V02gO.PublishDate="1/1/0001 12:00:00 AM"
_V02gO.UpdateDate="04/05/2019 17:43:19"
_V02gO.LastPlayedDate="1/1/0001 12:00:00 AM"
_V02gO.TargetDevice="PocketPC"
_V02gO.TargetDeviceVersion="0"
_V02gO.StateId="1"
_V02gO.CountryId="2"
_V02gO.Complete=false
_V02gO.UseLogging=true


-- Zones --
_XQGvw = Wherigo.Zone(_V02gO)
_XQGvw.Id = "4f5fa61f-5aec-491a-a077-4e323868e1c5"
_XQGvw.Name = _MtNtL("\121\015\008\029\042\034\099\080\018\055")
_XQGvw.Description = _MtNtL("\001\055\005\029\121\055\103\069\089\005\047\040\069\103\046\114\080\092\107\080\103\029\042\034\099\080\018\055\029\004\121\015\008\029\042\034\099\080\018\055\006\029\107\005\103\029\080\107\018\029\055\034\005\029\121\055\103\069\089\005\047\040\069\103\046\114\080\092\107\080\103\029\055\069\005\114\080\041\107\080\005\080\018\080\089\029\014\055\069\092\041\055\034\099\029\107\079\029\015\195\188\099\100\005\103\080\018\029\099\080\089\029\010\055\018\005\080\005\103\055\099\103\029\008\089\080\107\019\005\041\055\034\099\029\107\018\029\124\080\047\106\034\080\018\092\069\089\114\052\016\100\089\113\100\079\079\080\089\018\083\029\099\107\080\029\080\107\018\029\008\080\092\107\080\103\029\031\100\018\029\071\088\054\083\011\029\040\055\029\069\079\019\055\005\005\103\116\029\001\107\080\005\080\005\029\013\055\034\099\114\080\092\107\080\103\029\005\103\080\040\103\029\055\034\005\029\121\055\103\069\089\005\047\040\069\103\046\029\005\080\107\103\029\011\038\021\011\116\044\117\101\076\001\080\089\029\114\089\195\182\195\159\103\080\029\003\080\107\034\029\099\080\005\029\121\015\008\029\042\034\099\080\018\055\029\041\107\089\099\029\031\100\018\029\018\055\103\069\089\018\055\040\080\018\029\042\005\047\040\080\018\052\117\069\047\040\080\018\041\055\034\099\092\080\005\103\195\164\018\099\080\018\029\080\107\018\114\080\018\100\079\079\080\018\083\029\099\107\080\029\103\080\107\034\041\080\107\005\080\029\079\080\040\089\080\089\080\029\040\069\018\099\080\089\103\029\118\055\040\089\080\029\055\034\103\029\005\107\018\099\116\029\013\107\089\029\019\107\018\099\080\018\029\055\092\080\089\029\055\069\047\040\029\117\080\089\114\052\002\040\100\089\018\083\029\015\103\107\080\034\052\042\107\047\040\080\083\029\010\055\107\018\092\069\047\040\080\083\029\016\100\114\080\034\052\050\107\089\005\047\040\080\083\029\117\080\089\114\052\045\034\079\080\029\069\018\099\029\015\113\107\103\046\052\002\040\100\089\018\083\029\069\116\055\116\044\117\101\076\045\018\103\080\089\029\099\080\018\029\124\107\103\092\080\041\100\040\018\080\089\018\029\099\080\005\029\013\055\034\099\080\005\029\041\107\089\029\106\195\182\018\018\080\018\009\029\010\107\089\005\047\040\080\083\029\043\195\188\047\040\005\080\083\029\013\055\034\099\079\195\164\069\005\080\083\029\015\113\080\047\040\103\080\083\029\101\100\103\079\107\034\055\018\029\069\018\099\029\031\107\080\034\029\079\080\040\089\029\019\107\018\099\080\018\116")
_XQGvw.Visible = false
_XQGvw.Commands = {}
_XQGvw.DistanceRange = Distance(0, "meters")
_XQGvw.ShowObjects = "OnEnter"
_XQGvw.ProximityRange = Distance(60, "meters")
_XQGvw.AllowSetPositionTo = false
_XQGvw.Active = true
_XQGvw.Points = {
	ZonePoint(54.0833465464072, 13.4444711634283, 0), 
	ZonePoint(54.0824291312182, 13.4451671468074, 0), 
	ZonePoint(54.0824099181179, 13.4457239335106, 0), 
	ZonePoint(54.0834137907018, 13.4464362929692, 0), 
	ZonePoint(54.0832648924743, 13.4476317467732, 0), 
	ZonePoint(54.082986307259, 13.4491629102071, 0), 
	ZonePoint(54.0827029169316, 13.4504975606869, 0), 
	ZonePoint(54.0831256001004, 13.4505712530447, 0), 
	ZonePoint(54.0830343393261, 13.4521515447171, 0), 
	ZonePoint(54.0829478815653, 13.45305222909, 0), 
	ZonePoint(54.0827461460897, 13.4537400244293, 0), 
	ZonePoint(54.0820304575635, 13.4536908961908, 0), 
	ZonePoint(54.0817758808166, 13.4531095453683, 0), 
	ZonePoint(54.0806903096149, 13.4528065878973, 0), 
	ZonePoint(54.080257994594, 13.4529867247719, 0), 
	ZonePoint(54.0798160679184, 13.4537891526678, 0), 
	ZonePoint(54.0793501183928, 13.4551483672668, 0), 
	ZonePoint(54.0792156165259, 13.4564502655876, 0), 
	ZonePoint(54.0795134415023, 13.4576784715507, 0), 
	ZonePoint(54.07999860342, 13.4578913605843, 0), 
	ZonePoint(54.080555812091, 13.4591031904678, 0), 
	ZonePoint(54.0812042782806, 13.4588084210366, 0), 
	ZonePoint(54.0815453193965, 13.458996745951, 0), 
	ZonePoint(54.0817662741164, 13.4597172934493, 0), 
	ZonePoint(54.0821457370862, 13.4594470881374, 0), 
	ZonePoint(54.0823090491951, 13.4599219944431, 0), 
	ZonePoint(54.082304245907, 13.4604705931066, 0), 
	ZonePoint(54.0820784907369, 13.460920935293, 0), 
	ZonePoint(54.0813579872995, 13.4609454994123, 0), 
	ZonePoint(54.0805894365128, 13.461518662195, 0), 
	ZonePoint(54.0790667032363, 13.4618379957454, 0), 
	ZonePoint(54.0784470260683, 13.4617888675069, 0), 
	ZonePoint(54.0766263706378, 13.4613303372807, 0), 
	ZonePoint(54.0765447034834, 13.4629925093506, 0), 
	ZonePoint(54.0765398995281, 13.4641879631546, 0), 
	ZonePoint(54.0764198004657, 13.4649494508517, 0), 
	ZonePoint(54.0759970490021, 13.4657109385488, 0), 
	ZonePoint(54.0758048878227, 13.4660630242582, 0), 
	ZonePoint(54.0755935094979, 13.4671356574659, 0), 
	ZonePoint(54.0755262525325, 13.4677743245667, 0), 
	ZonePoint(54.0760883252507, 13.468396615588, 0), 
	ZonePoint(54.0767945083911, 13.4688551458142, 0), 
	ZonePoint(54.0776399907706, 13.468961590331, 0), 
	ZonePoint(54.0784182036492, 13.4686013165818, 0), 
	ZonePoint(54.0789081820507, 13.4684784959855, 0), 
	ZonePoint(54.0800802637792, 13.4686995730588, 0), 
	ZonePoint(54.0806182574241, 13.469190855444, 0), 
	ZonePoint(54.0814156280347, 13.4700178474591, 0), 
	ZonePoint(54.0817614707654, 13.4709430959513, 0), 
	ZonePoint(54.082092900678, 13.4717782760062, 0), 
	ZonePoint(54.0821025073027, 13.4725888919418, 0), 
	ZonePoint(54.0819824243345, 13.4741364314552, 0), 
	ZonePoint(54.0817710774668, 13.4747259703174, 0), 
	ZonePoint(54.0813147566955, 13.4750616799473, 0), 
	ZonePoint(54.0803204403753, 13.4760524327574, 0), 
	ZonePoint(54.0797776392894, 13.4768548606533, 0), 
	ZonePoint(54.0794317800279, 13.4775590320721, 0), 
	ZonePoint(54.0795566739826, 13.4785743490014, 0), 
	ZonePoint(54.078994648227, 13.4800727602763, 0), 
	ZonePoint(54.0776976366693, 13.480416657946, 0), 
	ZonePoint(54.0760835212427, 13.4802283330316, 0), 
	ZonePoint(54.0758961644938, 13.4800318200776, 0), 
	ZonePoint(54.0749353473664, 13.4801055124353, 0), 
	ZonePoint(54.0740753971789, 13.4803511536279, 0), 
	ZonePoint(54.0736862518543, 13.4802610851906, 0), 
	ZonePoint(54.0734364282419, 13.480048196157, 0), 
	ZonePoint(54.0728214714066, 13.4799663157594, 0), 
	ZonePoint(54.0725812514187, 13.4800727602762, 0), 
	ZonePoint(54.0721200251458, 13.4798598712426, 0), 
	ZonePoint(54.0718317561232, 13.4796551702487, 0), 
	ZonePoint(54.0712840394661, 13.4797534267258, 0), 
	ZonePoint(54.0706354182906, 13.4803347775482, 0), 
	ZonePoint(54.0701741704011, 13.4804575981446, 0), 
	ZonePoint(54.0699483492534, 13.4804330340253, 0), 
	ZonePoint(54.0693717790501, 13.4805886067805, 0), 
	ZonePoint(54.0688432493304, 13.4804985383433, 0), 
	ZonePoint(54.0685645673148, 13.4807196154166, 0), 
	ZonePoint(54.0680168075573, 13.4812436499608, 0), 
	ZonePoint(54.0674978705953, 13.481137205444, 0), 
	ZonePoint(54.0672191795502, 13.480768743655, 0), 
	ZonePoint(54.0663734849296, 13.4792621443404, 0), 
	ZonePoint(54.0658160858767, 13.4789182466707, 0), 
	ZonePoint(54.0656430984425, 13.4783287078084, 0), 
	ZonePoint(54.0646484067114, 13.4778456134629, 0), 
	ZonePoint(54.0639227952991, 13.4777637330654, 0), 
	ZonePoint(54.0633509469091, 13.4781813230928, 0), 
	ZonePoint(54.0621687815767, 13.4790001270682, 0), 
	ZonePoint(54.0619299151891, 13.4792100768974, 0), 
	ZonePoint(54.0615180481154, 13.4725027832684, 0), 
	ZonePoint(54.0616015670185, 13.4718857286085, 0), 
	ZonePoint(54.0618899070673, 13.4711406169029, 0), 
	ZonePoint(54.0615775385912, 13.4696667697472, 0), 
	ZonePoint(54.0612363334173, 13.4665471266011, 0), 
	ZonePoint(54.0609576003501, 13.4639433299595, 0), 
	ZonePoint(54.0610729383979, 13.4618390037427, 0), 
	ZonePoint(54.0613324478344, 13.4610038236879, 0), 
	ZonePoint(54.0619716030504, 13.4607254303363, 0), 
	ZonePoint(54.06113541304, 13.4596855492876, 0), 
	ZonePoint(54.0631345519725, 13.4555751533313, 0), 
	ZonePoint(54.0645713736442, 13.4525701427417, 0), 
	ZonePoint(54.0649269673206, 13.4508588424332, 0), 
	ZonePoint(54.0650855418974, 13.4497452690267, 0), 
	ZonePoint(54.0650086573297, 13.4494996278341, 0), 
	ZonePoint(54.0652248948134, 13.4490820378067, 0), 
	ZonePoint(54.065955288656, 13.4486562597395, 0), 
	ZonePoint(54.0661858095979, 13.4480737811574, 0), 
	ZonePoint(54.0662578849072, 13.447557948493, 0), 
	ZonePoint(54.066373205142, 13.4472795626106, 0), 
	ZonePoint(54.0669449965758, 13.4471567453095, 0), 
	ZonePoint(54.0672765359019, 13.4467637299461, 0), 
	ZonePoint(54.067608072581, 13.4464771562437, 0), 
	ZonePoint(54.0680549221776, 13.4463543389426, 0), 
	ZonePoint(54.0683576240111, 13.446280648562, 0), 
	ZonePoint(54.068415281253, 13.4466572882852, 0), 
	ZonePoint(54.0685882524983, 13.4467801055863, 0), 
	ZonePoint(54.0689053645767, 13.4466818517455, 0), 
	ZonePoint(54.0688909504438, 13.4458221306381, 0), 
	ZonePoint(54.0692176695595, 13.4457484402575, 0), 
	ZonePoint(54.0695203629166, 13.4460186383199, 0), 
	ZonePoint(54.0696020416985, 13.4464198415034, 0), 
	ZonePoint(54.0699527781705, 13.4475988875935, 0), 
	ZonePoint(54.0701497658486, 13.4482047862787, 0), 
	ZonePoint(54.0718073080732, 13.4490808830263, 0), 
	ZonePoint(54.0724126548237, 13.4504810002584, 0), 
	ZonePoint(54.0727633675538, 13.4512342797049, 0), 
	ZonePoint(54.0723982419084, 13.4527244629578, 0), 
	ZonePoint(54.0720283087035, 13.4537233770064, 0), 
	ZonePoint(54.071446978436, 13.4544029660722, 0), 
	ZonePoint(54.071216365827, 13.4549106109166, 0), 
	ZonePoint(54.0717640686818, 13.4558440224047, 0), 
	ZonePoint(54.0725952179844, 13.4567283069723, 0), 
	ZonePoint(54.0732149658836, 13.4571540736159, 0), 
	ZonePoint(54.0751942538063, 13.4559832153459, 0), 
	ZonePoint(54.0758812176023, 13.4536333109857, 0), 
	ZonePoint(54.0751606259161, 13.4522659450339, 0), 
	ZonePoint(54.0755065114865, 13.4517664880096, 0), 
	ZonePoint(54.0755929824288, 13.4503499951375, 0), 
	ZonePoint(54.075525727267, 13.4495230253104, 0), 
	ZonePoint(54.0752278816693, 13.4495148374903, 0), 
	ZonePoint(54.074949249982, 13.4498669137533, 0), 
	ZonePoint(54.0745889476137, 13.4496376547913, 0), 
	ZonePoint(54.0744063932202, 13.4488761875249, 0), 
	ZonePoint(54.0740412820248, 13.446796481227, 0), 
	ZonePoint(54.0738395086708, 13.4460186383204, 0), 
	ZonePoint(54.0736617551417, 13.4444957037873, 0), 
	ZonePoint(54.0728930824703, 13.4445038916074, 0), 
	ZonePoint(54.0721243955669, 13.4444711403271, 0), 
	ZonePoint(54.071619937052, 13.4442418813652, 0), 
	ZonePoint(54.0712692146629, 13.4436605461402, 0), 
	ZonePoint(54.0709713385263, 13.4426616320916, 0), 
	ZonePoint(54.0708464220911, 13.4421130481469, 0), 
	ZonePoint(54.071591110666, 13.4405082354131, 0), 
	ZonePoint(54.0727441504944, 13.4393210015029, 0), 
	ZonePoint(54.0731573153063, 13.4392718745825, 0), 
	ZonePoint(54.0737482299265, 13.4396485143058, 0), 
	ZonePoint(54.0743343320543, 13.4402789764512, 0), 
	ZonePoint(54.0747186568264, 13.4412205757593, 0), 
	ZonePoint(54.074992486056, 13.441998418666, 0), 
	ZonePoint(54.0755785706174, 13.4441108762443, 0), 
	ZonePoint(54.076736303508, 13.4450688511925, 0), 
	ZonePoint(54.0774568678429, 13.4460432017809, 0), 
	ZonePoint(54.078090954111, 13.4470339280095, 0), 
	ZonePoint(54.07850886931, 13.4476807657951, 0), 
	ZonePoint(54.0793302765764, 13.4476480145148, 0), 
	ZonePoint(54.0796425031448, 13.4472877504318, 0), 
	ZonePoint(54.0796376996769, 13.4449705973519, 0), 
	ZonePoint(54.0797385723856, 13.4431938403966, 0), 
	ZonePoint(54.0798730689493, 13.4429318301544, 0), 
	ZonePoint(54.0804398711076, 13.443111962196, 0), 
	ZonePoint(54.0814101415815, 13.4436196070403, 0), 
	ZonePoint(54.0819240875439, 13.4437751756218, 0), 
	ZonePoint(54.0823419641493, 13.4437178608812, 0), 
	ZonePoint(54.082889520229, 13.4436523583207, 0), 
	ZonePoint(54.0832545536021, 13.4439716833034, 0), 
	ZonePoint(54.0833794327031, 13.4442582570059, 0)
}
_XQGvw.OriginalPoint = ZonePoint(54.0742062434436, 13.4587003542151, 0)
_XQGvw.DistanceRangeUOM = "Meters"
_XQGvw.ProximityRangeUOM = "Meters"
_XQGvw.OutOfRangeName = ""
_XQGvw.InRangeName = ""
_pV0K = Wherigo.Zone(_V02gO)
_pV0K.Id = "3369e93f-fc50-4650-82b0-835314cdc058"
_pV0K.Name = _MtNtL("\101\080\040\092\089\069\047\040")
_pV0K.Description = ""
_pV0K.Visible = false
_pV0K.Commands = {}
_pV0K.DistanceRange = Distance(-1, "feet")
_pV0K.ShowObjects = "OnEnter"
_pV0K.ProximityRange = Distance(60, "meters")
_pV0K.AllowSetPositionTo = false
_pV0K.Active = true
_pV0K.Points = {
	ZonePoint(54.0708444555304, 13.4421093894085, 0), 
	ZonePoint(54.0709788589396, 13.4427065583315, 0), 
	ZonePoint(54.0712668647798, 13.4436554842914, 0), 
	ZonePoint(54.0716220692313, 13.4442281120258, 0), 
	ZonePoint(54.0721212703509, 13.4444735239119, 0), 
	ZonePoint(54.0736620359531, 13.4444980651005, 0), 
	ZonePoint(54.0738396283129, 13.4459950776062, 0), 
	ZonePoint(54.0740508182384, 13.4468212976229, 0), 
	ZonePoint(54.0745883877464, 13.4496353539177, 0), 
	ZonePoint(54.0749579627452, 13.4498644050115, 0), 
	ZonePoint(54.075226742496, 13.4495208283708, 0), 
	ZonePoint(54.0755291176355, 13.449529008767, 0), 
	ZonePoint(54.0756011113917, 13.4503552287838, 0), 
	ZonePoint(54.0755099192794, 13.4517622569312, 0), 
	ZonePoint(54.0751643473518, 13.4522612610997, 0), 
	ZonePoint(54.0758794860743, 13.453627387266, 0), 
	ZonePoint(54.0751931451223, 13.455975160977, 0), 
	ZonePoint(54.0732156518022, 13.4571613184268, 0), 
	ZonePoint(54.0717660701702, 13.455852455034, 0), 
	ZonePoint(54.0712236640311, 13.4549117094703, 0), 
	ZonePoint(54.0714396673249, 13.4544045249056, 0), 
	ZonePoint(54.0720204706084, 13.4537337324167, 0), 
	ZonePoint(54.0723900684676, 13.4527520848721, 0), 
	ZonePoint(54.0727596630366, 13.4512305311779, 0), 
	ZonePoint(54.0717996703174, 13.4490709065796, 0), 
	ZonePoint(54.0701484309155, 13.448211964978, 0), 
	ZonePoint(54.0695195986448, 13.446019618795, 0), 
	ZonePoint(54.0692267803682, 13.4457578461164, 0), 
	ZonePoint(54.0689051579142, 13.4457987480974, 0), 
	ZonePoint(54.0691257236655, 13.4445395758706, 0), 
	ZonePoint(54.0692911472101, 13.4441824971794, 0), 
	ZonePoint(54.0696550766883, 13.4435998951042, 0), 
	ZonePoint(54.0702285348474, 13.4420024378012, 0), 
	ZonePoint(54.0703510505859, 13.4419551504445, 0)
}
_pV0K.OriginalPoint = ZonePoint(54.072326548464, 13.448476570491, 0)
_pV0K.DistanceRangeUOM = "Feet"
_pV0K.ProximityRangeUOM = "Meters"
_pV0K.OutOfRangeName = ""
_pV0K.InRangeName = ""
_dR3 = Wherigo.Zone(_V02gO)
_dR3.Id = "8554125d-2b94-425e-929c-85c56cd8f113"
_dR3.Name = _MtNtL("\015\103\055\103\107\100\018\029\011")
_dR3.Description = _MtNtL("\121\029\073\071\029\088\071\116\071\022\012\029\042\029\088\011\022\029\108\054\116\021\021\071")
_dR3.Visible = true
_dR3.Commands = {}
_dR3.DistanceRange = Distance(-1, "feet")
_dR3.ShowObjects = "OnEnter"
_dR3.ProximityRange = Distance(60, "meters")
_dR3.AllowSetPositionTo = false
_dR3.Active = true
_dR3.Points = {
	ZonePoint(54.0741156956448, 13.4604721283175, 0), 
	ZonePoint(54.0741156956448, 13.461339238468, 0), 
	ZonePoint(54.073626124812, 13.461339238468, 0), 
	ZonePoint(54.073626124812, 13.4604721283175, 0)
}
_dR3.OriginalPoint = ZonePoint(54.0738709102284, 13.4609056833927, 0)
_dR3.DistanceRangeUOM = "Feet"
_dR3.ProximityRangeUOM = "Meters"
_dR3.OutOfRangeName = ""
_dR3.InRangeName = ""
_BJTl = Wherigo.Zone(_V02gO)
_BJTl.Id = "41fa0ed3-5445-4c15-8300-e6e034be8eb3"
_BJTl.Name = _MtNtL("\015\103\055\103\107\100\018\029\108")
_BJTl.Description = _MtNtL("\121\029\073\071\029\088\071\116\022\054\011\029\042\029\088\011\022\029\108\054\116\012\071\021")
_BJTl.Visible = true
_BJTl.Commands = {}
_BJTl.DistanceRange = Distance(-1, "feet")
_BJTl.ShowObjects = "OnEnter"
_BJTl.ProximityRange = Distance(60, "meters")
_BJTl.AllowSetPositionTo = false
_BJTl.Active = true
_BJTl.Points = {
	ZonePoint(54.0729973538029, 13.4637115209551, 0), 
	ZonePoint(54.0724885702909, 13.4637115209551, 0), 
	ZonePoint(54.0724885702909, 13.4646113522433, 0), 
	ZonePoint(54.0729973538029, 13.4646113522433, 0)
}
_BJTl.OriginalPoint = ZonePoint(54.0727429620469, 13.4641614365992, 0)
_BJTl.DistanceRangeUOM = "Feet"
_BJTl.ProximityRangeUOM = "Meters"
_BJTl.OutOfRangeName = ""
_BJTl.InRangeName = ""
_5dIYl = Wherigo.Zone(_V02gO)
_5dIYl.Id = "8c94db1c-d11d-481e-b46f-4c44860bfa12"
_5dIYl.Name = _MtNtL("\015\103\055\103\107\100\018\029\022")
_5dIYl.Description = _MtNtL("\121\029\073\071\029\088\071\116\071\071\022\029\042\029\088\011\022\029\108\012\116\022\022\012")
_5dIYl.Visible = true
_5dIYl.Commands = {}
_5dIYl.DistanceRange = Distance(-1, "feet")
_5dIYl.ShowObjects = "OnEnter"
_5dIYl.ProximityRange = Distance(60, "meters")
_5dIYl.AllowSetPositionTo = false
_5dIYl.Active = true
_5dIYl.Points = {
	ZonePoint(54.0742622707441, 13.4718030024982, 0), 
	ZonePoint(54.0736965311578, 13.4718030024982, 0), 
	ZonePoint(54.0736965311578, 13.472855429758, 0), 
	ZonePoint(54.0742622707441, 13.472855429758, 0)
}
_5dIYl.OriginalPoint = ZonePoint(54.0739794009509, 13.4723292161281, 0)
_5dIYl.DistanceRangeUOM = "Feet"
_5dIYl.ProximityRangeUOM = "Meters"
_5dIYl.OutOfRangeName = ""
_5dIYl.InRangeName = ""
_Mvof = Wherigo.Zone(_V02gO)
_Mvof.Id = "23e1c7f6-2223-4de4-9ce0-17d18b62a40f"
_Mvof.Name = _MtNtL("\015\103\055\103\107\100\018\029\071")
_Mvof.Description = _MtNtL("\121\029\073\071\029\088\071\116\022\038\021\029\042\029\088\011\022\029\108\054\116\071\071\054")
_Mvof.Visible = true
_Mvof.Commands = {}
_Mvof.DistanceRange = Distance(-1, "feet")
_Mvof.ShowObjects = "OnEnter"
_Mvof.ProximityRange = Distance(60, "meters")
_Mvof.AllowSetPositionTo = false
_Mvof.Active = true
_Mvof.Points = {
	ZonePoint(54.0734317566633, 13.456912325393, 0), 
	ZonePoint(54.0734317566633, 13.4574846409638, 0), 
	ZonePoint(54.0730623695568, 13.4574846409638, 0), 
	ZonePoint(54.0730623695568, 13.456912325393, 0)
}
_Mvof.OriginalPoint = ZonePoint(54.07324706311, 13.4571984831784, 0)
_Mvof.DistanceRangeUOM = "Feet"
_Mvof.ProximityRangeUOM = "Meters"
_Mvof.OutOfRangeName = ""
_Mvof.InRangeName = ""
_8pwl4 = Wherigo.Zone(_V02gO)
_8pwl4.Id = "d22cd22e-1da3-4e63-9908-1a48715a587b"
_8pwl4.Name = _MtNtL("\015\103\055\103\107\100\018\029\073")
_8pwl4.Description = _MtNtL("\121\029\073\071\029\088\022\116\021\054\088\029\042\029\088\011\022\029\108\054\116\038\022\021")
_8pwl4.Visible = true
_8pwl4.Commands = {}
_8pwl4.DistanceRange = Distance(-1, "feet")
_8pwl4.ShowObjects = "OnEnter"
_8pwl4.ProximityRange = Distance(60, "meters")
_8pwl4.AllowSetPositionTo = false
_8pwl4.Active = true
_8pwl4.Points = {
	ZonePoint(54.0615913955894, 13.4649182184423, 0), 
	ZonePoint(54.061126730301, 13.4649182184423, 0), 
	ZonePoint(54.061126730301, 13.4657915405557, 0), 
	ZonePoint(54.0615913955894, 13.4657915405557, 0)
}
_8pwl4.OriginalPoint = ZonePoint(54.0613590629452, 13.465354879499, 0)
_8pwl4.DistanceRangeUOM = "Feet"
_8pwl4.ProximityRangeUOM = "Meters"
_8pwl4.OutOfRangeName = ""
_8pwl4.InRangeName = ""
_Ofulx = Wherigo.Zone(_V02gO)
_Ofulx.Id = "458d0aec-7aa5-471f-b4c0-aa2a93ddaa19"
_Ofulx.Name = _MtNtL("\106\100\034\034\069\031\107\088\011")
_Ofulx.Description = ""
_Ofulx.Visible = false
_Ofulx.Commands = {}
_Ofulx.DistanceRange = Distance(30, "meters")
_Ofulx.ShowObjects = "OnEnter"
_Ofulx.ProximityRange = Distance(60, "meters")
_Ofulx.AllowSetPositionTo = false
_Ofulx.Active = true
_Ofulx.Points = {
	ZonePoint(54.0617047070988, 13.4716198243904, 0), 
	ZonePoint(54.0618867390094, 13.4711382729447, 0), 
	ZonePoint(54.0615753681512, 13.4696609710519, 0), 
	ZonePoint(54.0609574098423, 13.4639639725925, 0), 
	ZonePoint(54.0610349832761, 13.4625708583774, 0), 
	ZonePoint(54.0615879388687, 13.4614962025384, 0), 
	ZonePoint(54.063106643245, 13.460896167443, 0), 
	ZonePoint(54.0641520958682, 13.4605586477019, 0), 
	ZonePoint(54.0647353369477, 13.4611961849907, 0), 
	ZonePoint(54.0650171786798, 13.461947108792, 0), 
	ZonePoint(54.0655040669209, 13.4645862456959, 0), 
	ZonePoint(54.0665461804898, 13.4668199476327, 0), 
	ZonePoint(54.0669643134029, 13.4670824525274, 0), 
	ZonePoint(54.0669643134029, 13.467701214065, 0), 
	ZonePoint(54.066964295201, 13.4682074218099, 0), 
	ZonePoint(54.0669973358514, 13.4689011950849, 0), 
	ZonePoint(54.0671844302045, 13.4695385725652, 0), 
	ZonePoint(54.0671803672949, 13.4705348528848, 0), 
	ZonePoint(54.0671693699757, 13.4713406506416, 0), 
	ZonePoint(54.0669824267596, 13.4720714727493, 0), 
	ZonePoint(54.0666525168322, 13.4733644845351, 0), 
	ZonePoint(54.0663445985352, 13.4740390993799, 0), 
	ZonePoint(54.066069669555, 13.4740765779824, 0), 
	ZonePoint(54.0658827168087, 13.4740203600786, 0), 
	ZonePoint(54.0658277305467, 13.4738891849699, 0), 
	ZonePoint(54.0658057360215, 13.4736455740538, 0), 
	ZonePoint(54.0658057360215, 13.472352562268, 0), 
	ZonePoint(54.0658167332856, 13.4710970290846, 0), 
	ZonePoint(54.0658607223127, 13.4699164531063, 0), 
	ZonePoint(54.0658607223127, 13.4695604063826, 0), 
	ZonePoint(54.0657507496576, 13.4688483129354, 0), 
	ZonePoint(54.0656077847706, 13.4685297448142, 0), 
	ZonePoint(54.0654318273109, 13.468286133898, 0), 
	ZonePoint(54.0653108561249, 13.4681362194881, 0), 
	ZonePoint(54.0652778639221, 13.467667736957, 0), 
	ZonePoint(54.0652668665154, 13.466899425606, 0), 
	ZonePoint(54.0652668665154, 13.4664496823761, 0), 
	ZonePoint(54.0648599604181, 13.4655876745189, 0), 
	ZonePoint(54.0647719801972, 13.4648193631679, 0), 
	ZonePoint(54.0647279900168, 13.4638823981057, 0), 
	ZonePoint(54.0645740240186, 13.4633576976709, 0), 
	ZonePoint(54.0642880856504, 13.463057868851, 0), 
	ZonePoint(54.0640791294439, 13.4626081256211, 0), 
	ZonePoint(54.0638993019318, 13.4621255428526, 0), 
	ZonePoint(54.0636243464651, 13.4618069628002, 0), 
	ZonePoint(54.063415379093, 13.4617882227971, 0), 
	ZonePoint(54.0631954123022, 13.4618631828094, 0), 
	ZonePoint(54.0631404204224, 13.4619568828249, 0), 
	ZonePoint(54.0631624171831, 13.4623691628927, 0), 
	ZonePoint(54.063184413932, 13.4627814429605, 0), 
	ZonePoint(54.0632614024617, 13.4631937230283, 0), 
	ZonePoint(54.0634043807811, 13.463587263093, 0), 
	ZonePoint(54.0635702627564, 13.4637819407708, 0), 
	ZonePoint(54.0637473915478, 13.4639369249144, 0), 
	ZonePoint(54.0638335620374, 13.4642305790787, 0), 
	ZonePoint(54.0638814344544, 13.4646384320847, 0), 
	ZonePoint(54.0638814344544, 13.4650462850907, 0), 
	ZonePoint(54.0638335620374, 13.4655601798782, 0), 
	ZonePoint(54.0637617533085, 13.4658293628622, 0), 
	ZonePoint(54.0635846245795, 13.466155645267, 0), 
	ZonePoint(54.0633883459164, 13.4662861582288, 0), 
	ZonePoint(54.0632686633494, 13.4663595717699, 0), 
	ZonePoint(54.0631011071763, 13.4664003570705, 0), 
	ZonePoint(54.0629526997156, 13.4662127446878, 0), 
	ZonePoint(54.0629239756296, 13.4657885775615, 0), 
	ZonePoint(54.0629096135792, 13.4653562533752, 0), 
	ZonePoint(54.0629191882801, 13.4647363168061, 0), 
	ZonePoint(54.0629526997156, 13.4643937202811, 0), 
	ZonePoint(54.062904826228, 13.4640919090567, 0), 
	ZonePoint(54.0626798200973, 13.4634719724876, 0), 
	ZonePoint(54.0624643875533, 13.4629662347602, 0), 
	ZonePoint(54.0621962921601, 13.462680737656, 0), 
	ZonePoint(54.0620813936047, 13.4625175964536, 0), 
	ZonePoint(54.0617558459716, 13.4626644235357, 0), 
	ZonePoint(54.0616026462025, 13.4629336065197, 0), 
	ZonePoint(54.0615643461719, 13.4636840560507, 0), 
	ZonePoint(54.0615547711587, 13.4642713643793, 0), 
	ZonePoint(54.0615978587006, 13.4648260444674, 0), 
	ZonePoint(54.0616840336502, 13.4653154680746, 0), 
	ZonePoint(54.0618132957393, 13.4658130487419, 0), 
	ZonePoint(54.0619042577091, 13.4663106294092, 0), 
	ZonePoint(54.0620861810509, 13.4668897806777, 0), 
	ZonePoint(54.0622585287449, 13.4676239160884, 0), 
	ZonePoint(54.0623638520261, 13.4681051828266, 0), 
	ZonePoint(54.0624213009759, 13.4686027636945, 0), 
	ZonePoint(54.0624500254211, 13.469132972816, 0), 
	ZonePoint(54.0624978994522, 13.4696550248741, 0), 
	ZonePoint(54.0625122616507, 13.4699649932836, 0), 
	ZonePoint(54.062521836447, 13.4704054747076, 0), 
	ZonePoint(54.0624691750402, 13.4708296420048, 0), 
	ZonePoint(54.0623303401019, 13.471253809302, 0), 
	ZonePoint(54.0621771423901, 13.4715719347749, 0), 
	ZonePoint(54.0620766060846, 13.4717432331065, 0), 
	ZonePoint(54.0619760695358, 13.4718084896137, 0), 
	ZonePoint(54.0619425572988, 13.4718248037405, 0)
}
_Ofulx.OriginalPoint = ZonePoint(54.0638109653849, 13.4666638831707, 0)
_Ofulx.DistanceRangeUOM = "Meters"
_Ofulx.ProximityRangeUOM = "Meters"
_Ofulx.OutOfRangeName = ""
_Ofulx.InRangeName = ""
_aFHh = Wherigo.Zone(_V02gO)
_aFHh.Id = "1d0fa0a1-9ff5-4eaf-84bf-6e1cc604e0cc"
_aFHh.Name = _MtNtL("\106\100\034\034\069\031\107\088\108")
_aFHh.Description = ""
_aFHh.Visible = false
_aFHh.Commands = {}
_aFHh.DistanceRange = Distance(30, "meters")
_aFHh.ShowObjects = "OnEnter"
_aFHh.ProximityRange = Distance(60, "meters")
_aFHh.AllowSetPositionTo = false
_aFHh.Active = true
_aFHh.Points = {
	ZonePoint(54.0616596807263, 13.4747354663202, 0), 
	ZonePoint(54.0619665602832, 13.4749315430959, 0), 
	ZonePoint(54.0623405666775, 13.475282847319, 0), 
	ZonePoint(54.0625083889649, 13.4756178118109, 0), 
	ZonePoint(54.0624748245617, 13.4760017954966, 0), 
	ZonePoint(54.0624076956739, 13.4763122503915, 0), 
	ZonePoint(54.0623165920097, 13.4765655162267, 0), 
	ZonePoint(54.0622734375727, 13.4768759711216, 0), 
	ZonePoint(54.0622158982536, 13.4772599548073, 0), 
	ZonePoint(54.0622686426325, 13.4777909960748, 0), 
	ZonePoint(54.0623597464018, 13.4782403386858, 0), 
	ZonePoint(54.0624700296447, 13.4787877196846, 0), 
	ZonePoint(54.0621487689473, 13.4790083060573, 0), 
	ZonePoint(54.0619329954421, 13.4792125526986, 0)
}
_aFHh.OriginalPoint = ZonePoint(54.0622388448423, 13.4769016478422, 0)
_aFHh.DistanceRangeUOM = "Meters"
_aFHh.ProximityRangeUOM = "Meters"
_aFHh.OutOfRangeName = ""
_aFHh.InRangeName = ""
_jmQAM = Wherigo.Zone(_V02gO)
_jmQAM.Id = "f83ff40d-a9ef-4ad4-8a0b-530b86cf760e"
_jmQAM.Name = _MtNtL("\106\100\034\034\069\031\107\088\022")
_jmQAM.Description = ""
_jmQAM.Visible = false
_jmQAM.Commands = {}
_jmQAM.DistanceRange = Distance(30, "meters")
_jmQAM.ShowObjects = "OnEnter"
_jmQAM.ProximityRange = Distance(60, "meters")
_jmQAM.AllowSetPositionTo = false
_jmQAM.Active = true
_jmQAM.Points = {
	ZonePoint(54.0650864538752, 13.4780640015227, 0), 
	ZonePoint(54.0648991961902, 13.4769753750191, 0), 
	ZonePoint(54.0648220898391, 13.4762809063875, 0), 
	ZonePoint(54.0647670137865, 13.475548898911, 0), 
	ZonePoint(54.0644806171351, 13.4751547410391, 0), 
	ZonePoint(54.0642603106747, 13.4746855054772, 0), 
	ZonePoint(54.0641721877633, 13.4743288864502, 0), 
	ZonePoint(54.064205233877, 13.4738596508883, 0), 
	ZonePoint(54.0639628950994, 13.4734279541714, 0), 
	ZonePoint(54.0636654773941, 13.4729587186095, 0), 
	ZonePoint(54.0636434463682, 13.4726959466948, 0), 
	ZonePoint(54.0637095394107, 13.4722079417105, 0), 
	ZonePoint(54.0637976633038, 13.4717011673037, 0), 
	ZonePoint(54.0637536013807, 13.4712131623193, 0), 
	ZonePoint(54.0636544618826, 13.4707814656024, 0), 
	ZonePoint(54.0637205549076, 13.4703685383079, 0), 
	ZonePoint(54.0637425858926, 13.4701245358158, 0), 
	ZonePoint(54.0637866478274, 13.4696365308314, 0), 
	ZonePoint(54.0639304905352, 13.4694404540561, 0), 
	ZonePoint(54.0641989955903, 13.4695221527126, 0), 
	ZonePoint(54.0643716050661, 13.4697427390853, 0), 
	ZonePoint(54.0645106510666, 13.4700286843831, 0), 
	ZonePoint(54.0646113392591, 13.4703963283375, 0), 
	ZonePoint(54.0646353126022, 13.4707966517546, 0), 
	ZonePoint(54.0646065445888, 13.4709600490677, 0), 
	ZonePoint(54.064549008502, 13.471164295709, 0), 
	ZonePoint(54.0645298297887, 13.4715074300665, 0), 
	ZonePoint(54.0645681872065, 13.4717770356331, 0), 
	ZonePoint(54.0644866776514, 13.4722999070349, 0), 
	ZonePoint(54.064457909535, 13.4726103619298, 0), 
	ZonePoint(54.0646496966015, 13.4730433648094, 0), 
	ZonePoint(54.064875045273, 13.4739828993596, 0), 
	ZonePoint(54.0651099819476, 13.4740891076131, 0), 
	ZonePoint(54.0651339550029, 13.4739338801657, 0), 
	ZonePoint(54.0650092949641, 13.4736969540617, 0), 
	ZonePoint(54.0649373755406, 13.4733701594355, 0), 
	ZonePoint(54.0648942238268, 13.4729943456154, 0), 
	ZonePoint(54.0647983309689, 13.4727165701832, 0), 
	ZonePoint(54.0647791523708, 13.4723979454227, 0), 
	ZonePoint(54.0647887416709, 13.4719894521399, 0), 
	ZonePoint(54.0647935363202, 13.4716463177825, 0), 
	ZonePoint(54.0647983309689, 13.4714420711411, 0), 
	ZonePoint(54.0648366881386, 13.4711397861119, 0), 
	ZonePoint(54.0648654559927, 13.4707312928292, 0), 
	ZonePoint(54.0648606613517, 13.4703391392778, 0), 
	ZonePoint(54.0648606613517, 13.4701594022334, 0), 
	ZonePoint(54.0647839470211, 13.4697754185476, 0), 
	ZonePoint(54.0647072325488, 13.4695793417719, 0), 
	ZonePoint(54.0644866776515, 13.4690891498326, 0), 
	ZonePoint(54.06434283687, 13.4688603935943, 0), 
	ZonePoint(54.0641078958555, 13.4687378456095, 0), 
	ZonePoint(54.0639640537621, 13.4687215058782, 0), 
	ZonePoint(54.0637866478274, 13.4687378456095, 0), 
	ZonePoint(54.0635373192869, 13.4689992813104, 0), 
	ZonePoint(54.0634414232958, 13.4691871882204, 0), 
	ZonePoint(54.0633263478142, 13.469456793787, 0), 
	ZonePoint(54.0631825030139, 13.4700205145172, 0), 
	ZonePoint(54.0631105804269, 13.4703636488746, 0), 
	ZonePoint(54.0631057855833, 13.4707884818887, 0), 
	ZonePoint(54.0630722216629, 13.4712133149026, 0), 
	ZonePoint(54.0630961958945, 13.4719649425428, 0), 
	ZonePoint(54.0630530422676, 13.4725204934073, 0), 
	ZonePoint(54.063024273158, 13.4728554578991, 0), 
	ZonePoint(54.0631105804269, 13.4732476114505, 0), 
	ZonePoint(54.0632400409938, 13.4736397650019, 0), 
	ZonePoint(54.0633023737154, 13.4739992390906, 0), 
	ZonePoint(54.0633311426323, 13.4744976008955, 0), 
	ZonePoint(54.0633455270833, 13.4748080557903, 0), 
	ZonePoint(54.0633838855949, 13.4753309271922, 0), 
	ZonePoint(54.0634941661183, 13.4757475903406, 0), 
	ZonePoint(54.0635469088738, 13.476090724698, 0), 
	ZonePoint(54.0637003419635, 13.4763685001303, 0), 
	ZonePoint(54.0638106216466, 13.4766054262343, 0), 
	ZonePoint(54.0638106216466, 13.4770465989796, 0), 
	ZonePoint(54.0638010321206, 13.4773733936057, 0), 
	ZonePoint(54.0637818530619, 13.4778799252763, 0), 
	ZonePoint(54.0639154856091, 13.4777630486013, 0), 
	ZonePoint(54.0646538706002, 13.4778529171232, 0)
}
_jmQAM.OriginalPoint = ZonePoint(54.0641273730297, 13.4725263544566, 0)
_jmQAM.DistanceRangeUOM = "Meters"
_jmQAM.ProximityRangeUOM = "Meters"
_jmQAM.OutOfRangeName = ""
_jmQAM.InRangeName = ""
_cUiT = Wherigo.Zone(_V02gO)
_cUiT.Id = "c782b3a6-3d7b-4fa6-b540-e4579d9027b9"
_cUiT.Name = _MtNtL("\114\034\080\032\088\011")
_cUiT.Description = ""
_cUiT.Visible = false
_cUiT.Commands = {}
_cUiT.DistanceRange = Distance(-1, "feet")
_cUiT.ShowObjects = "OnEnter"
_cUiT.ProximityRange = Distance(60, "meters")
_cUiT.AllowSetPositionTo = false
_cUiT.Active = true
_cUiT.Points = {
	ZonePoint(54.0651045666749, 13.474078439191, 0), 
	ZonePoint(54.0651764858088, 13.4742500063697, 0), 
	ZonePoint(54.0652148426292, 13.4744869324737, 0), 
	ZonePoint(54.0652148426292, 13.4747810476373, 0), 
	ZonePoint(54.0651333343434, 13.4751078422634, 0), 
	ZonePoint(54.0650278527949, 13.4753937875613, 0), 
	ZonePoint(54.0648983978009, 13.4755408451431, 0), 
	ZonePoint(54.0647662347449, 13.4755419027276, 0), 
	ZonePoint(54.0644875233207, 13.4751533053168, 0), 
	ZonePoint(54.0642634138916, 13.4746876229745, 0), 
	ZonePoint(54.0641744013215, 13.4743235351606, 0), 
	ZonePoint(54.0642127590675, 13.4738496829527, 0), 
	ZonePoint(54.0636711232936, 13.4729558227702, 0), 
	ZonePoint(54.0636481657527, 13.4726962245083, 0), 
	ZonePoint(54.0638026071468, 13.4716969490071, 0), 
	ZonePoint(54.063758779242, 13.4712097577486, 0), 
	ZonePoint(54.0636606880493, 13.4707794647391, 0), 
	ZonePoint(54.0637253865215, 13.4703598401515, 0), 
	ZonePoint(54.063790084893, 13.469637943615, 0), 
	ZonePoint(54.0639299165127, 13.4694459120241, 0), 
	ZonePoint(54.0641991432308, 13.4695241471167, 0), 
	ZonePoint(54.0643723657004, 13.4697446278323, 0), 
	ZonePoint(54.0645080213467, 13.4700255629376, 0), 
	ZonePoint(54.0646040235364, 13.4703882892761, 0), 
	ZonePoint(54.0646290675494, 13.470797245442, 0), 
	ZonePoint(54.0645998495328, 13.4709750524707, 0), 
	ZonePoint(54.0645435004427, 13.47115641564, 0), 
	ZonePoint(54.0645247173957, 13.471497805135, 0), 
	ZonePoint(54.064564370485, 13.4717751840998, 0), 
	ZonePoint(54.0644850642685, 13.4722837122018, 0), 
	ZonePoint(54.0644537591414, 13.4726179894157, 0), 
	ZonePoint(54.0646457635497, 13.4730482824252, 0), 
	ZonePoint(54.0648732458845, 13.4739906596772, 0)
}
_cUiT.OriginalPoint = ZonePoint(54.0644443726819, 13.4725394496365, 0)
_cUiT.DistanceRangeUOM = "Feet"
_cUiT.ProximityRangeUOM = "Meters"
_cUiT.OutOfRangeName = ""
_cUiT.InRangeName = ""
_UU6 = Wherigo.Zone(_V02gO)
_UU6.Id = "392813f7-3248-452e-ba65-7112ccf88e0a"
_UU6.Name = _MtNtL("\114\034\080\032\088\108")
_UU6.Description = ""
_UU6.Visible = false
_UU6.Commands = {}
_UU6.DistanceRange = Distance(-1, "feet")
_UU6.ShowObjects = "OnEnter"
_UU6.ProximityRange = Distance(60, "meters")
_UU6.AllowSetPositionTo = false
_UU6.Active = true
_UU6.Points = {
	ZonePoint(54.0619424369809, 13.4718217338595, 0), 
	ZonePoint(54.0619280557551, 13.4731939171962, 0), 
	ZonePoint(54.0619664056796, 13.4749173141252, 0), 
	ZonePoint(54.0616601172022, 13.4747293631397, 0), 
	ZonePoint(54.0615182273983, 13.4725037934509, 0), 
	ZonePoint(54.0616016920475, 13.4718851846237, 0), 
	ZonePoint(54.0617060226232, 13.4716220981109, 0)
}
_UU6.OriginalPoint = ZonePoint(54.0617604225267, 13.4729533435009, 0)
_UU6.DistanceRangeUOM = "Feet"
_UU6.ProximityRangeUOM = "Meters"
_UU6.OutOfRangeName = ""
_UU6.InRangeName = ""
_5TiY = Wherigo.Zone(_V02gO)
_5TiY.Id = "01001cf6-8e4b-4e3f-a61e-cbee7ead766c"
_5TiY.Name = _MtNtL("\113\005\080\069\099\100\088\011")
_5TiY.Description = ""
_5TiY.Visible = false
_5TiY.Commands = {}
_5TiY.DistanceRange = Distance(-1, "feet")
_5TiY.ShowObjects = "OnEnter"
_5TiY.ProximityRange = Distance(60, "meters")
_5TiY.AllowSetPositionTo = false
_5TiY.Active = true
_5TiY.Points = {
	ZonePoint(54.066455828012, 13.4793407881701, 0), 
	ZonePoint(54.0663359531101, 13.4787361510163, 0), 
	ZonePoint(54.0664606230009, 13.4783848078053, 0), 
	ZonePoint(54.0666476271353, 13.4780988307731, 0), 
	ZonePoint(54.0668825798541, 13.4776085844322, 0), 
	ZonePoint(54.0671894548725, 13.4770039472783, 0), 
	ZonePoint(54.0674244045256, 13.4766199209779, 0), 
	ZonePoint(54.0674483789052, 13.476293090084, 0), 
	ZonePoint(54.0672853528506, 13.4758355268325, 0), 
	ZonePoint(54.0673524813036, 13.4752717435404, 0), 
	ZonePoint(54.0675490711486, 13.4748550341507, 0), 
	ZonePoint(54.0677984032719, 13.474511861712, 0), 
	ZonePoint(54.0681292455089, 13.474160518501, 0), 
	ZonePoint(54.0684888536462, 13.4736702721601, 0), 
	ZonePoint(54.0687621537478, 13.4731636842745, 0), 
	ZonePoint(54.0688820216459, 13.4725590471206, 0), 
	ZonePoint(54.0689012004774, 13.4719135561051, 0), 
	ZonePoint(54.0688772269366, 13.4714233097642, 0), 
	ZonePoint(54.068709411763, 13.4712680650896, 0), 
	ZonePoint(54.0685703643911, 13.4714314805366, 0), 
	ZonePoint(54.0683689846132, 13.4717011160241, 0), 
	ZonePoint(54.0681617648191, 13.4722616128925, 0), 
	ZonePoint(54.0678202816823, 13.473012473113, 0), 
	ZonePoint(54.0674677800149, 13.4736694758058, 0), 
	ZonePoint(54.0670932437145, 13.4743452500042, 0), 
	ZonePoint(54.0669330679896, 13.4742414597418, 0), 
	ZonePoint(54.0668083997886, 13.4740617029327, 0), 
	ZonePoint(54.0670001972835, 13.4735387735024, 0), 
	ZonePoint(54.0671824040831, 13.4732119426084, 0), 
	ZonePoint(54.0674413281598, 13.4723703530566, 0), 
	ZonePoint(54.0676427124366, 13.4716431543176, 0), 
	ZonePoint(54.067834506078, 13.471161078749, 0), 
	ZonePoint(54.0678536853934, 13.4704665630994, 0), 
	ZonePoint(54.0679304025665, 13.4699518044414, 0), 
	ZonePoint(54.0680262988335, 13.4689631409873, 0), 
	ZonePoint(54.0679639662851, 13.4685872854592, 0), 
	ZonePoint(54.0679304025665, 13.4681705760695, 0), 
	ZonePoint(54.0679783507277, 13.467713012818, 0), 
	ZonePoint(54.0678365914347, 13.4671556385181, 0), 
	ZonePoint(54.0676162783298, 13.4667238938914, 0), 
	ZonePoint(54.0673298695459, 13.4663860067922, 0), 
	ZonePoint(54.0669663478599, 13.4656726895828, 0), 
	ZonePoint(54.0668011096779, 13.4648092003293, 0), 
	ZonePoint(54.0667019664531, 13.4638518535482, 0), 
	ZonePoint(54.0667129823787, 13.4630822218223, 0), 
	ZonePoint(54.0667570460517, 13.4621811895577, 0), 
	ZonePoint(54.0664375833631, 13.4613740148207, 0), 
	ZonePoint(54.0661621825211, 13.4608671841719, 0), 
	ZonePoint(54.0657215373749, 13.4602101814791, 0), 
	ZonePoint(54.06456482162, 13.460135095457, 0), 
	ZonePoint(54.063968500588, 13.4603236914098, 0), 
	ZonePoint(54.0637575078908, 13.4604135698976, 0), 
	ZonePoint(54.0634793795177, 13.4604299114423, 0), 
	ZonePoint(54.0630382065535, 13.4607567423362, 0), 
	ZonePoint(54.0628799585875, 13.4607567423362, 0), 
	ZonePoint(54.0625778471597, 13.4608384500596, 0), 
	ZonePoint(54.0622085968747, 13.4609773531895, 0), 
	ZonePoint(54.061743432752, 13.4611897932706, 0), 
	ZonePoint(54.061628339794, 13.4612633302217, 0), 
	ZonePoint(54.0615899754038, 13.4614757703028, 0), 
	ZonePoint(54.0632472715349, 13.4608420327586, 0), 
	ZonePoint(54.0641531505132, 13.4605503968694, 0), 
	ZonePoint(54.0647375780776, 13.4611870166764, 0), 
	ZonePoint(54.065021439927, 13.4619338890758, 0), 
	ZonePoint(54.0655077575566, 13.4645728382203, 0), 
	ZonePoint(54.0665534255321, 13.4668170119537, 0), 
	ZonePoint(54.0669729376185, 13.467080195561, 0), 
	ZonePoint(54.0669666762752, 13.4681933910897, 0), 
	ZonePoint(54.0670021572079, 13.4688975850663, 0), 
	ZonePoint(54.067192084038, 13.4695342048733, 0), 
	ZonePoint(54.0671733001045, 13.4713338117023, 0), 
	ZonePoint(54.0666556950384, 13.4733752629273, 0), 
	ZonePoint(54.0663467986184, 13.4740438915515, 0), 
	ZonePoint(54.066073381627, 13.4740865699743, 0), 
	ZonePoint(54.0658813625111, 13.4740296654106, 0), 
	ZonePoint(54.0658250089064, 13.4738945170717, 0), 
	ZonePoint(54.0658020500085, 13.4736526726756, 0), 
	ZonePoint(54.0658020500085, 13.4722762935397, 0), 
	ZonePoint(54.0658124858728, 13.4711595414758, 0), 
	ZonePoint(54.0658584036444, 13.4699147541435, 0), 
	ZonePoint(54.0658584036444, 13.4695555440848, 0), 
	ZonePoint(54.0657477834721, 13.4688513501082, 0), 
	ZonePoint(54.0656037680893, 13.4685277054018, 0), 
	ZonePoint(54.0653094742322, 13.4681435995964, 0), 
	ZonePoint(54.0652739918532, 13.4676670238749, 0), 
	ZonePoint(54.0652614686534, 13.4664471322892, 0), 
	ZonePoint(54.0648544626035, 13.4655900072976, 0), 
	ZonePoint(54.0647667992399, 13.4648111260811, 0), 
	ZonePoint(54.064725054716, 13.4638793138494, 0), 
	ZonePoint(54.0645726868477, 13.4633600597051, 0), 
	ZonePoint(54.0642825601828, 13.4630648672805, 0), 
	ZonePoint(54.0638964172332, 13.4621259419785, 0), 
	ZonePoint(54.0636271586734, 13.4618129668778, 0), 
	ZonePoint(54.0634079934407, 13.4617987407368, 0), 
	ZonePoint(54.0631992635723, 13.4618698714415, 0), 
	ZonePoint(54.0631533428605, 13.4619516717519, 0), 
	ZonePoint(54.0631909143557, 13.4627767879265, 0), 
	ZonePoint(54.0632702318452, 13.4631857894786, 0), 
	ZonePoint(54.063410080734, 13.4635805648897, 0), 
	ZonePoint(54.0635708020097, 13.4637726177924, 0), 
	ZonePoint(54.0637544827061, 13.4639255488075, 0), 
	ZonePoint(54.0638379736631, 13.4642100716263, 0), 
	ZonePoint(54.0638880681568, 13.464629742784, 0), 
	ZonePoint(54.063883893618, 13.4650565270123, 0), 
	ZonePoint(54.0638379736631, 13.4655615550157, 0), 
	ZonePoint(54.0637649190849, 13.4658354082288, 0), 
	ZonePoint(54.0635895875728, 13.4661661660056, 0), 
	ZonePoint(54.0632744064458, 13.4663617754436, 0), 
	ZonePoint(54.0631032474806, 13.4664044538664, 0), 
	ZonePoint(54.0629504075574, 13.4662137418374, 0), 
	ZonePoint(54.0629222422731, 13.4657911182152, 0), 
	ZonePoint(54.0629086139029, 13.4653746868805, 0), 
	ZonePoint(54.0629167909255, 13.46473068898, 0), 
	ZonePoint(54.0629513161146, 13.464393209311, 0), 
	ZonePoint(54.0629031625535, 13.464092883367, 0), 
	ZonePoint(54.0626778394881, 13.4634721065447, 0), 
	ZonePoint(54.0624634180165, 13.462967435113, 0), 
	ZonePoint(54.0621944810465, 13.4626841379597, 0), 
	ZonePoint(54.0620809091679, 13.4625215904127, 0), 
	ZonePoint(54.0617565461726, 13.4626655610972, 0), 
	ZonePoint(54.0616048124733, 13.4629349256036, 0), 
	ZonePoint(54.0615666518149, 13.4636718078167, 0), 
	ZonePoint(54.0615575659387, 13.4642693635609, 0), 
	ZonePoint(54.0616011781264, 13.4648235732926, 0), 
	ZonePoint(54.0616865851945, 13.4653127640055, 0), 
	ZonePoint(54.0618174212136, 13.4658081470058, 0), 
	ZonePoint(54.0619073707377, 13.46630662615, 0), 
	ZonePoint(54.0620899949297, 13.4668871531035, 0), 
	ZonePoint(54.0623671097072, 13.4681008414544, 0), 
	ZonePoint(54.0624243495784, 13.4686024167423, 0), 
	ZonePoint(54.0624516066322, 13.4691148285333, 0), 
	ZonePoint(54.0625006692839, 13.4696489133306, 0), 
	ZonePoint(54.0625242920215, 13.470405920478, 0), 
	ZonePoint(54.0624725036946, 13.4708300921721, 0), 
	ZonePoint(54.0623316754617, 13.4712573600099, 0), 
	ZonePoint(54.0621808524375, 13.471568522457, 0), 
	ZonePoint(54.0620790920154, 13.4717450026509, 0), 
	ZonePoint(54.0619446225038, 13.4718270504603, 0), 
	ZonePoint(54.0619309938128, 13.4731909017832, 0), 
	ZonePoint(54.0619700627151, 13.4749262903564, 0), 
	ZonePoint(54.062339852598, 13.4752792507442, 0), 
	ZonePoint(54.0625124806544, 13.4756167304132, 0), 
	ZonePoint(54.0624788636681, 13.4760022003103, 0), 
	ZonePoint(54.0624098124758, 13.4763102666137, 0), 
	ZonePoint(54.0623189554688, 13.4765641504014, 0), 
	ZonePoint(54.0622181039584, 13.4772592346738, 0), 
	ZonePoint(54.0622698926024, 13.4777902233274, 0), 
	ZonePoint(54.0624743208301, 13.4787856335437, 0), 
	ZonePoint(54.0637799120426, 13.4778614346337, 0), 
	ZonePoint(54.0638085230281, 13.4770480585368, 0), 
	ZonePoint(54.0638103401051, 13.4766068580521, 0), 
	ZonePoint(54.0637013153494, 13.4763715511269, 0), 
	ZonePoint(54.0635459545782, 13.4760944462611, 0), 
	ZonePoint(54.06349325898, 13.4757507743046, 0), 
	ZonePoint(54.0633805992008, 13.4753327948981, 0), 
	ZonePoint(54.0633415316254, 13.4747692967351, 0), 
	ZonePoint(54.0633015554636, 13.4740045492283, 0), 
	ZonePoint(54.0632397740471, 13.473646944625, 0), 
	ZonePoint(54.0631098510624, 13.4732552824403, 0), 
	ZonePoint(54.0630226298097, 13.4728527837525, 0), 
	ZonePoint(54.0630944056456, 13.4719703827831, 0), 
	ZonePoint(54.0630707832323, 13.4712118275638, 0), 
	ZonePoint(54.0631043997395, 13.4707953962291, 0), 
	ZonePoint(54.0631080339549, 13.4703603880319, 0), 
	ZonePoint(54.0631807181954, 13.4700244564347, 0), 
	ZonePoint(54.0633251777457, 13.4694532179124, 0), 
	ZonePoint(54.0635368691351, 13.4689949886371, 0), 
	ZonePoint(54.0637858095601, 13.4687349125618, 0), 
	ZonePoint(54.0639602486768, 13.4687163356993, 0), 
	ZonePoint(54.0641101567073, 13.4687349125619, 0), 
	ZonePoint(54.0643463743239, 13.4688556621682, 0), 
	ZonePoint(54.0644908298197, 13.4690925171652, 0), 
	ZonePoint(54.0647879159582, 13.4697721207189, 0), 
	ZonePoint(54.0648651398357, 13.4701544944723, 0), 
	ZonePoint(54.0648705909275, 13.4707334733539, 0), 
	ZonePoint(54.0648387928819, 13.4711483566168, 0), 
	ZonePoint(54.0648024522285, 13.4714409422014, 0), 
	ZonePoint(54.0647815563383, 13.4723976506208, 0), 
	ZonePoint(54.064800635195, 13.4727150053555, 0), 
	ZonePoint(54.0648978463759, 13.4729874660057, 0), 
	ZonePoint(54.0649387295149, 13.4733574551841, 0), 
	ZonePoint(54.0650132275757, 13.4736933867812, 0), 
	ZonePoint(54.0651395105687, 13.4739271456345, 0), 
	ZonePoint(54.0651140722989, 13.4740912412533, 0), 
	ZonePoint(54.0651803934698, 13.4742491445847, 0), 
	ZonePoint(54.0652185508078, 13.474482903438, 0), 
	ZonePoint(54.0652176423002, 13.4747801332382, 0), 
	ZonePoint(54.0651358765312, 13.4751129686917, 0), 
	ZonePoint(54.0650313978142, 13.4753978139169, 0), 
	ZonePoint(54.0649005719198, 13.4755433326732, 0), 
	ZonePoint(54.0647724711655, 13.4755495249607, 0), 
	ZonePoint(54.0648260736569, 13.4762724745269, 0), 
	ZonePoint(54.0649014804344, 13.4769660107274, 0), 
	ZonePoint(54.065087725503, 13.4780527571845, 0), 
	ZonePoint(54.0656437302023, 13.478322121691, 0), 
	ZonePoint(54.0658190700096, 13.4789134851477, 0), 
	ZonePoint(54.0663768818819, 13.4792556090323, 0), 
	ZonePoint(54.0664377501507, 13.4793701663511, 0)
}
_5TiY.OriginalPoint = ZonePoint(54.0647645316035, 13.4696432793013, 0)
_5TiY.DistanceRangeUOM = "Feet"
_5TiY.ProximityRangeUOM = "Meters"
_5TiY.OutOfRangeName = ""
_5TiY.InRangeName = ""

-- Characters --
_QQV = Wherigo.ZCharacter{
	Cartridge = _V02gO, 
	Container = _XQGvw
}
_QQV.Id = "a93701c2-f9bf-4341-9446-c3c617600b4f"
_QQV.Name = _MtNtL("\042\069\034\080")
_QQV.Description = _MtNtL("\102\047\040\029\040\080\034\019\080\029\099\107\089\029\079\107\103\029\099\080\079\029\042\055\089\103\040\047\055\047\040\080\116\029\013\055\005\029\041\107\034\034\005\103\029\099\069\029\041\107\005\005\080\018\086")
_QQV.Visible = true
_QQV.Media = _d4u
_QQV.Icon = _USs
_QQV.Commands = {
	_N3TGM = Wherigo.ZCommand{
		Text = _MtNtL("\013\055\005\029\107\005\103\029\099\080\089\029\117\100\099\080\018\086"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _MtNtL("\121\100\103\040\107\018\114\029\055\031\055\107\034\055\092\034\080")
	}, 
	_tOF1 = Wherigo.ZCommand{
		Text = _MtNtL("\117\100\099\080\018\040\100\089\107\046\100\018\103\080"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _MtNtL("\121\100\103\040\107\018\114\029\055\031\055\107\034\055\092\034\080")
	}, 
	_bAB = Wherigo.ZCommand{
		Text = _MtNtL("\013\080\034\047\040\080\018\029\117\100\099\080\018\103\032\113\029\019\107\018\099\080\029\107\047\040\029\040\107\080\089\086"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _MtNtL("\121\100\103\040\107\018\114\029\055\031\055\107\034\055\092\034\080")
	}, 
	_RuCU = Wherigo.ZCommand{
		Text = _MtNtL("\016\080\089\103\080\107\034\069\018\114\029\099\080\089\029\117\195\182\099\080\018"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _MtNtL("\121\100\103\040\107\018\114\029\055\031\055\107\034\055\092\034\080")
	}
}
_QQV.Commands._N3TGM.Custom = true
_QQV.Commands._N3TGM.Id = "2cd75a08-90a3-4190-b689-d29dac5ba74b"
_QQV.Commands._N3TGM.WorksWithAll = true
_QQV.Commands._tOF1.Custom = true
_QQV.Commands._tOF1.Id = "52145344-0ff5-4ef2-8a38-ec6874994faa"
_QQV.Commands._tOF1.WorksWithAll = true
_QQV.Commands._bAB.Custom = true
_QQV.Commands._bAB.Id = "a1ea9e47-451a-43ff-baca-bf22514de661"
_QQV.Commands._bAB.WorksWithAll = true
_QQV.Commands._RuCU.Custom = true
_QQV.Commands._RuCU.Id = "782b014b-5d38-4185-9818-0094048000fd"
_QQV.Commands._RuCU.WorksWithAll = true
_QQV.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_QQV.Gender = "It"
_QQV.Type = "NPC"

-- Items --
_EwKr2 = Wherigo.ZItem{
	Cartridge = _V02gO, 
	Container = Player
}
_EwKr2.Id = "b4f5a8ea-c55c-4c00-8c38-7c1d74699ba0"
_EwKr2.Name = _MtNtL("\014\107\103\080\089\055\103\069\089")
_EwKr2.Description = _MtNtL("\011\116\029\050\013\002\015\121\102\093\013\015\050\102\083\029\118\029\004\108\088\088\011\006\029\001\107\080\029\117\195\182\099\080\018\029\107\079\029\121\055\103\069\089\005\047\040\069\103\046\114\080\092\107\080\103\029\042\034\099\080\018\055\029\004\016\100\089\113\100\079\079\080\089\018\006\083\029\008\089\080\107\019\005\041\055\034\099\080\089\029\008\080\100\114\089\055\019\107\005\047\040\080\029\002\089\092\080\107\103\080\018\083\029\108\022\083\029\011\073\073\052\011\012\073\044\117\101\076\044\117\101\076\108\116\029\117\100\099\080\018\034\080\040\089\113\019\055\099\029\042\034\099\080\018\055\029\004\040\103\103\113\005\009\091\091\114\080\100\116\069\018\107\052\114\089\080\107\019\005\041\055\034\099\116\099\080\006\029\033\088\012\116\011\088\116\108\088\011\012\095\044\117\101\076\044\117\101\076\022\116\029\102\018\019\100\103\055\019\080\034\044\117\101\076\044\117\101\076\071\116\029\117\100\099\080\018\103\032\113\080\018\029\004\040\103\103\113\005\009\091\091\041\041\041\116\092\100\099\080\018\103\032\113\080\018\116\099\080\091\006\029\033\088\054\116\011\088\116\108\088\011\012\095\044\117\101\076\044\117\101\076\073\116\029\117\100\099\080\018\041\080\034\103\080\018\029\004\040\103\103\113\005\009\091\091\041\041\041\116\092\100\099\080\018\041\080\034\103\080\018\116\099\080\091\006\029\033\088\012\116\011\088\116\108\088\011\012\095\044\117\101\076\044\117\101\076\021\116\029\013\107\106\107\113\080\099\107\055\029\004\040\103\103\113\005\009\091\091\099\080\116\041\107\106\107\113\080\099\107\055\116\100\089\114\091\041\107\106\107\091\117\100\099\080\018\096\004\117\100\099\080\018\106\069\018\099\080\006\006\029\004\040\103\103\113\005\009\091\091\099\080\116\041\107\106\107\113\080\099\107\055\116\100\089\114\091\041\107\106\107\091\117\100\099\080\018\040\100\089\107\046\100\018\103\006\029\033\088\012\116\011\088\116\108\088\011\012\095\044\117\101\076")
_EwKr2.Visible = true
_EwKr2.Icon = _Im_CQ
_EwKr2.Commands = {}
_EwKr2.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_EwKr2.Locked = false
_EwKr2.Opened = false
_swUX = Wherigo.ZItem(_V02gO)
_swUX.Id = "c15121cb-3b54-4fc8-8cae-5bfaeecd2e17"
_swUX.Name = _MtNtL("\117\100\099\080\018\113\089\100\019\107\034")
_swUX.Description = _MtNtL("\010\107\080\089\029\114\107\092\103\029\080\005\029\080\107\018\080\029\043\089\055\114\080\029\046\069\029\099\107\080\005\080\079\029\117\100\099\080\018\113\089\100\019\107\034")
_swUX.Visible = true
_swUX.Icon = _hALJ
_swUX.Commands = {
	_ECV = Wherigo.ZCommand{
		Text = _MtNtL("\043\089\055\114\080\029\011"), 
		CmdWith = false, 
		Enabled = false, 
		EmptyTargetListText = _MtNtL("\121\100\103\040\107\018\114\029\055\031\055\107\034\055\092\034\080")
	}, 
	_UZHiM = Wherigo.ZCommand{
		Text = _MtNtL("\043\089\055\114\080\029\108"), 
		CmdWith = false, 
		Enabled = false, 
		EmptyTargetListText = _MtNtL("\121\100\103\040\107\018\114\029\055\031\055\107\034\055\092\034\080")
	}, 
	_Ho6T = Wherigo.ZCommand{
		Text = _MtNtL("\043\089\055\114\080\029\022"), 
		CmdWith = false, 
		Enabled = false, 
		EmptyTargetListText = _MtNtL("\121\100\103\040\107\018\114\029\055\031\055\107\034\055\092\034\080")
	}, 
	_EsXh = Wherigo.ZCommand{
		Text = _MtNtL("\043\089\055\114\080\029\071"), 
		CmdWith = false, 
		Enabled = false, 
		EmptyTargetListText = _MtNtL("\121\100\103\040\107\018\114\029\055\031\055\107\034\055\092\034\080")
	}, 
	_o7Y = Wherigo.ZCommand{
		Text = _MtNtL("\043\089\055\114\080\029\073"), 
		CmdWith = false, 
		Enabled = false, 
		EmptyTargetListText = _MtNtL("\121\100\103\040\107\018\114\029\055\031\055\107\034\055\092\034\080")
	}
}
_swUX.Commands._ECV.Custom = true
_swUX.Commands._ECV.Id = "5a309649-a78f-409c-a7b3-60fbe26efa25"
_swUX.Commands._ECV.WorksWithAll = true
_swUX.Commands._UZHiM.Custom = true
_swUX.Commands._UZHiM.Id = "83e56d2b-1a0d-416b-a582-dca0bd1e4ef5"
_swUX.Commands._UZHiM.WorksWithAll = true
_swUX.Commands._Ho6T.Custom = true
_swUX.Commands._Ho6T.Id = "0895391c-f229-4a19-a371-17eaf1254f27"
_swUX.Commands._Ho6T.WorksWithAll = true
_swUX.Commands._EsXh.Custom = true
_swUX.Commands._EsXh.Id = "94727014-3777-4e80-b4cd-8d649332112c"
_swUX.Commands._EsXh.WorksWithAll = true
_swUX.Commands._o7Y.Custom = true
_swUX.Commands._o7Y.Id = "96394b92-2725-4ddf-8a53-9ea4f4351b06"
_swUX.Commands._o7Y.WorksWithAll = true
_swUX.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_swUX.Locked = false
_swUX.Opened = false
_rrCP = Wherigo.ZItem{
	Cartridge = _V02gO, 
	Container = Player
}
_rrCP.Id = "4420d896-5736-495b-a172-199a12eb2577"
_rrCP.Name = _MtNtL("\002\018\103\041\100\089\103\080\018")
_rrCP.Description = _MtNtL("\001\069\029\040\055\005\103\029\019\100\034\114\080\018\099\080\005\029\114\080\055\018\103\041\100\089\103\080\103\009\044\117\101\076\043\089\055\114\080\029\011\055\009\044\117\101\076\043\089\055\114\080\029\011\092\009\044\117\101\076\043\089\055\114\080\029\108\009\044\117\101\076\043\089\055\114\080\029\022\009\044\117\101\076\043\089\055\114\080\029\071\009\044\117\101\076\043\089\055\114\080\029\073\055\009\044\117\101\076\043\089\055\114\080\029\073\092\009")
_rrCP.Visible = true
_rrCP.Icon = _jXC
_rrCP.Commands = {}
_rrCP.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_rrCP.Locked = false
_rrCP.Opened = false
_o86 = Wherigo.ZItem(_V02gO)
_o86.Id = "b34add9f-09b9-462f-84e3-657a94f7053c"
_o86.Name = _MtNtL("\105\100\079\113\034\080\103\107\100\018\029\105\100\099\080")
_o86.Description = _MtNtL("\011\108\022")
_o86.Visible = true
_o86.Icon = _jXC
_o86.Commands = {}
_o86.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_o86.Locked = false
_o86.Opened = false

-- Tasks --
_TSKPO = Wherigo.ZTask(_V02gO)
_TSKPO.Id = "fd909bb3-75b9-48d8-ac0e-087ea00b8a0b"
_TSKPO.Name = _MtNtL("\043\089\055\114\080\029\011")
_TSKPO.Description = _MtNtL("\008\080\040\029\046\069\029\015\103\055\103\107\100\018\029\011\116")
_TSKPO.Visible = true
_TSKPO.Active = true
_TSKPO.Complete = false
_TSKPO.CorrectState = "None"
_3Yti = Wherigo.ZTask(_V02gO)
_3Yti.Id = "ad8feca7-d6e4-4893-bd87-0edafc8a8513"
_3Yti.Name = _MtNtL("\043\089\055\114\080\029\108")
_3Yti.Description = _MtNtL("\008\080\040\029\046\069\029\015\103\055\103\107\100\018\029\108\116")
_3Yti.Visible = true
_3Yti.Active = true
_3Yti.Complete = false
_3Yti.CorrectState = "None"
_8hPJ = Wherigo.ZTask(_V02gO)
_8hPJ.Id = "7e8813ee-75f9-435f-9ebe-1b118ef9e4a5"
_8hPJ.Name = _MtNtL("\043\089\055\114\080\029\022")
_8hPJ.Description = _MtNtL("\008\080\040\029\046\069\029\015\103\055\103\107\100\018\029\022\116")
_8hPJ.Visible = true
_8hPJ.Active = true
_8hPJ.Complete = false
_8hPJ.CorrectState = "None"
_daJM = Wherigo.ZTask(_V02gO)
_daJM.Id = "b2d58d7e-d0e1-47f1-9c50-667accbaf779"
_daJM.Name = _MtNtL("\043\089\055\114\080\029\071")
_daJM.Description = _MtNtL("\008\080\040\029\046\069\029\015\103\055\103\107\100\018\029\071\116")
_daJM.Visible = true
_daJM.Active = true
_daJM.Complete = false
_daJM.CorrectState = "None"
_4IOtG = Wherigo.ZTask(_V02gO)
_4IOtG.Id = "fea421c8-e58f-465d-a704-8af4267fbfa4"
_4IOtG.Name = _MtNtL("\043\089\055\114\080\029\073")
_4IOtG.Description = _MtNtL("\008\080\040\029\046\069\029\015\103\055\103\107\100\018\029\073\116")
_4IOtG.Visible = true
_4IOtG.Active = true
_4IOtG.Complete = false
_4IOtG.CorrectState = "None"

-- Cartridge Variables --
_x3ex = _MtNtL("\010\107\080\089\029\019\107\018\099\080\005\103\029\099\069\029\008\034\080\032\080\116\044\117\101\076\008\034\080\032\080\029\005\107\018\099\029\031\100\079\029\008\089\069\018\099\041\055\005\005\080\089\029\092\080\080\107\018\019\034\069\005\005\103\080\029\117\195\182\099\080\018\029\069\018\099\029\099\055\040\080\089\029\107\018\029\121\107\080\099\080\089\069\018\114\080\018\029\069\018\099\029\015\080\018\106\080\018\029\040\195\164\069\019\107\114\029\055\018\046\069\103\089\080\019\019\080\018\116\029\001\055\005\029\040\100\047\040\055\018\005\103\080\040\080\018\099\080\029\069\018\099\029\092\080\041\080\114\034\107\047\040\080\029\008\089\069\018\099\041\055\005\005\080\089\029\034\195\182\005\103\029\107\018\029\005\080\107\018\080\079\029\103\107\080\019\080\089\080\018\029\113\080\089\079\055\018\080\018\103\080\018\029\013\107\089\106\069\018\114\005\092\080\089\080\107\047\040\029\031\080\089\005\047\040\107\080\099\080\018\080\029\117\100\099\080\018\113\055\089\103\107\106\080\034\116\033\108\095\044\117\101\076\001\107\080\029\069\018\103\080\089\005\047\040\107\080\099\034\107\047\040\080\018\029\117\100\099\080\018\103\032\113\080\018\029\099\080\089\029\008\034\080\032\080\029\041\080\089\099\080\018\029\055\069\019\029\008\089\069\018\099\029\099\080\005\029\010\069\079\069\005\114\080\040\055\034\103\080\005\029\107\079\029\093\092\080\089\092\100\099\080\018\029\069\018\099\029\099\080\089\029\010\195\182\040\080\029\099\080\005\029\008\089\069\018\099\041\055\005\005\080\089\005\113\107\080\114\080\034\005\029\092\080\005\103\107\079\079\103\116\033\021\095\044\117\101\076\008\034\080\032\080\029\040\055\092\080\018\029\107\099\080\055\034\103\032\113\107\005\047\040\029\099\107\080\029\010\100\089\107\046\100\018\103\107\080\089\069\018\114\029\002\091\008\100\091\008\089\009\044\117\101\076\044\117\101\076\052\002\040\009\029\010\069\079\100\005\080\089\029\093\092\080\089\092\100\099\080\018\083\029\100\019\103\029\100\092\080\089\040\055\034\092\029\099\080\005\029\008\089\069\018\099\041\055\005\005\080\089\080\107\018\019\034\069\005\005\080\005\044\117\101\076\052\008\100\009\029\093\059\107\099\055\103\107\100\018\005\040\100\089\107\046\100\018\103\116\029\015\055\069\080\089\005\103\100\019\019\055\089\079\080\029\015\047\040\107\047\040\103\029\041\100\029\031\100\089\029\055\034\034\080\079\029\042\107\005\080\018\029\107\018\029\089\080\099\069\046\107\080\089\103\080\029\043\100\089\079\029\079\100\092\107\034\107\005\107\080\089\103\029\005\107\018\099\116\029\008\089\069\018\099\041\055\005\005\080\089\029\005\103\080\107\114\103\029\069\018\099\029\005\107\018\106\103\029\107\079\029\118\055\040\089\080\005\031\080\089\034\055\069\019\029\055\092\040\195\164\018\114\107\114\029\031\100\018\029\043\055\106\103\100\089\080\018\029\041\107\080\029\121\107\080\099\080\089\005\047\040\034\055\114\083\029\015\047\040\018\080\080\005\047\040\079\080\034\046\080\029\100\099\080\089\029\057\019\034\055\018\046\080\018\031\080\089\092\089\055\069\047\040\083\029\069\018\099\029\099\089\107\018\114\103\029\018\069\089\029\099\069\089\047\040\029\031\100\089\195\188\092\080\089\114\080\040\080\018\099\080\029\195\132\018\099\080\089\069\018\114\080\018\029\099\080\005\029\008\089\069\018\099\041\055\005\005\080\089\005\113\107\080\114\080\034\005\029\100\099\080\089\029\050\055\113\107\034\034\055\089\106\089\195\164\019\103\080\029\080\107\018\116\044\117\101\076\052\008\089\009\029\101\080\099\069\106\103\107\100\018\005\040\100\089\107\046\100\018\103\116\029\102\018\029\099\107\080\005\080\089\029\015\047\040\107\047\040\103\029\040\080\089\089\005\047\040\080\018\029\005\055\069\080\089\005\103\100\019\019\019\089\080\107\080\083\029\055\018\055\080\089\100\092\080\018\029\117\080\099\107\018\114\069\018\114\080\018\116\029\001\107\080\029\080\089\040\195\164\034\103\029\114\080\041\195\182\040\018\034\107\047\040\029\080\107\018\080\029\092\034\195\164\069\034\107\047\040\052\114\089\055\069\080\029\043\055\089\092\080\029\069\018\099\029\005\103\195\164\018\099\107\114\029\107\079\029\008\089\069\018\099\041\055\005\005\080\089\092\080\089\080\107\047\040\116")
_MGma = _MtNtL("\010\107\080\089\029\019\107\018\099\080\005\103\029\099\069\029\057\005\080\069\099\100\114\034\080\032\116\044\117\101\076\001\055\005\029\041\107\047\040\103\107\114\005\103\080\029\045\018\103\080\089\005\047\040\107\080\099\029\046\041\107\005\047\040\080\018\029\008\034\080\032\080\029\069\018\099\029\057\005\080\069\099\100\114\034\080\032\080\029\107\005\103\083\029\099\055\005\029\057\005\080\069\099\100\114\034\080\032\080\029\018\107\047\040\103\029\079\107\103\029\099\080\018\029\043\195\188\195\159\080\018\029\107\079\029\008\089\069\018\099\041\055\005\005\080\089\029\005\103\080\040\103\083\029\055\092\080\089\029\055\069\019\029\080\107\018\080\089\029\103\100\018\107\114\080\018\029\015\047\040\107\047\040\103\083\029\099\107\080\029\099\055\005\029\013\055\005\005\080\089\029\092\080\107\029\040\100\040\080\018\029\121\107\080\099\080\089\005\047\040\034\195\164\114\080\018\029\005\103\055\069\103\116\029\045\018\103\080\089\029\015\055\069\080\089\005\103\100\019\019\079\055\018\114\080\034\029\005\107\018\099\029\099\107\080\029\114\034\080\107\047\040\080\018\029\057\089\100\046\080\005\005\080\029\041\107\080\029\092\080\107\079\029\008\034\080\032\029\046\069\029\092\080\100\092\055\047\040\103\080\018\116\033\073\095\044\117\101\076\057\005\080\069\099\100\114\034\080\032\080\029\040\055\092\080\018\029\080\107\018\080\029\010\100\089\107\046\100\018\103\107\080\089\069\018\114\029\002\040\091\015\041\091\015\099\009\044\117\101\076\044\117\101\076\052\002\040\009\029\010\069\079\100\005\080\089\029\093\092\080\089\092\100\099\080\018\083\029\100\019\103\029\100\092\080\089\040\055\034\092\029\099\080\005\029\008\089\069\018\099\041\055\005\005\080\089\080\107\018\019\034\069\005\005\080\005\116\044\117\101\076\052\015\041\009\029\015\103\055\069\041\055\005\005\080\089\034\080\107\103\080\018\099\080\029\015\047\040\107\047\040\103\029\107\079\029\045\018\103\080\089\092\100\099\080\018\029\031\100\079\029\046\080\107\103\041\080\107\005\080\029\055\069\019\103\089\080\103\080\018\099\080\018\029\015\103\055\069\041\055\005\005\080\089\029\114\080\113\089\195\164\114\103\029\004\050\080\018\018\046\080\107\047\040\080\018\029\099\080\005\029\057\005\080\069\099\100\114\034\080\032\006\116\029\001\055\089\107\018\029\106\195\182\018\018\080\018\029\106\034\080\107\018\080\029\005\047\040\041\055\089\046\092\089\055\069\018\080\029\124\055\018\114\055\018\052\050\018\195\182\034\034\047\040\080\018\029\080\107\018\114\080\034\055\114\080\089\103\029\005\080\107\018\116\044\117\101\076\052\015\099\009\029\001\107\047\040\103\080\083\029\041\055\005\005\080\089\005\103\055\069\080\018\099\080\083\029\103\100\018\089\080\107\047\040\080\029\069\018\099\029\079\080\107\005\103\029\092\034\055\069\114\089\055\069\029\092\107\005\029\089\100\005\103\092\089\055\069\018\029\079\055\089\079\100\089\107\080\089\103\080\029\045\018\103\080\089\092\100\099\080\018\029\010\100\089\107\046\100\018\103\116")
_ZOmpn = _MtNtL("\010\107\080\089\029\019\107\018\099\080\005\103\029\099\069\029\117\089\055\069\018\080\089\099\080\018\116\044\117\101\076\117\089\055\069\080\089\099\080\018\029\005\107\018\099\029\080\107\018\029\117\100\099\080\018\103\032\113\029\099\080\005\029\114\080\079\195\164\195\159\107\114\103\029\040\069\079\107\099\080\018\029\050\034\107\079\055\005\116\029\001\055\005\029\002\069\005\114\055\018\114\005\079\055\103\080\089\107\055\034\029\099\080\089\029\117\100\099\080\018\092\107\034\099\069\018\114\029\107\005\103\029\080\107\018\029\005\047\040\041\055\047\040\029\005\047\040\034\069\019\019\107\114\080\089\029\015\055\018\099\116\029\001\107\080\029\117\089\055\069\018\080\089\099\080\018\029\107\079\029\121\015\008\029\042\034\099\080\018\055\029\080\018\103\005\103\055\018\099\080\018\029\069\018\103\080\089\029\117\080\099\107\018\114\069\018\114\080\018\029\005\047\040\041\055\047\040\019\034\107\080\195\159\080\018\099\080\018\029\092\107\005\029\005\103\080\040\080\018\099\080\018\029\013\055\005\005\080\089\005\029\046\041\107\005\047\040\080\018\029\018\107\080\099\080\089\103\055\069\080\018\099\080\018\029\003\100\103\080\107\005\092\034\195\182\047\106\080\018\029\099\080\089\029\034\080\103\046\103\080\018\029\114\089\100\195\159\080\018\029\005\106\055\018\099\107\018\055\031\107\005\047\040\080\018\029\016\080\089\114\034\080\103\005\047\040\080\089\069\018\114\116\033\108\095\044\117\101\076\117\089\055\069\018\080\089\099\080\018\029\040\055\092\080\018\029\080\107\018\080\029\103\032\113\107\005\047\040\080\029\010\100\089\107\046\100\018\103\107\080\089\069\018\114\029\002\040\091\117\031\091\105\033\073\095\009\044\117\101\076\044\117\101\076\052\002\040\009\029\010\069\079\100\005\080\089\029\093\092\080\089\092\100\099\080\018\116\029\010\069\079\069\005\005\047\040\107\047\040\103\029\079\107\103\029\041\080\018\107\114\080\089\029\055\034\005\029\022\088\049\029\100\089\114\055\018\107\005\047\040\080\089\029\015\069\092\005\103\055\018\046\116\044\117\101\076\052\117\031\009\029\124\107\018\080\089\055\034\107\005\047\040\080\089\029\016\080\089\041\107\103\103\080\089\069\018\114\005\040\100\089\107\046\100\018\103\083\029\099\080\089\029\099\069\089\047\040\029\099\107\080\005\080\089\029\016\080\089\041\107\103\103\080\089\069\018\114\029\004\063\080\089\106\034\080\107\018\080\089\069\018\114\083\029\014\195\182\005\069\018\114\029\100\099\080\089\029\063\080\089\019\055\034\034\029\031\100\018\029\008\080\005\103\080\107\018\080\018\029\069\018\099\029\124\107\018\080\089\055\034\080\018\029\055\018\029\099\080\089\029\042\089\099\100\092\080\089\019\034\195\164\047\040\080\029\107\018\029\002\092\040\195\164\018\114\107\114\106\080\107\103\029\031\100\018\029\106\034\107\079\055\103\107\005\047\040\080\018\029\117\080\099\107\018\114\069\018\114\080\018\006\029\031\080\089\092\089\055\069\018\103\029\069\018\099\029\031\080\089\034\080\040\079\103\029\107\005\103\116\044\117\101\076\052\105\009\029\045\018\103\080\089\114\089\069\018\099\116\029\002\069\005\114\055\018\114\005\114\080\005\103\080\107\018\083\029\055\069\005\029\099\080\079\029\117\100\099\080\018\029\080\018\103\005\103\080\040\103\116")
_XqFjM = _MtNtL("\010\107\080\089\029\019\107\018\099\080\005\103\029\099\069\029\121\107\080\099\080\089\079\100\100\089\080\116\044\117\101\076\042\107\018\029\124\100\100\089\092\100\099\080\018\029\107\005\103\029\080\107\018\029\041\055\005\005\080\089\114\080\005\195\164\103\103\107\114\103\080\089\029\117\100\099\080\018\083\029\099\080\089\029\055\069\005\029\079\195\164\047\040\103\107\114\080\018\029\003\100\089\019\005\047\040\107\047\040\103\080\018\029\004\100\089\114\055\018\107\005\047\040\080\005\029\015\080\099\107\079\080\018\103\006\029\092\080\005\103\080\040\103\116\029\001\107\080\029\003\100\089\019\055\069\019\034\055\114\080\029\079\069\005\005\029\079\107\018\099\080\005\103\080\018\005\029\022\088\029\047\079\029\079\195\164\047\040\103\107\114\029\005\080\107\018\116\029\124\100\100\089\080\029\041\080\089\099\080\018\029\103\089\055\099\107\103\107\100\018\080\034\034\029\018\055\047\040\029\099\080\089\029\013\055\005\005\080\089\031\080\089\005\100\089\114\069\018\114\029\107\018\029\010\100\047\040\079\100\100\089\080\029\069\018\099\029\121\107\080\099\080\089\079\100\100\089\080\029\069\018\103\080\089\005\047\040\107\080\099\080\018\083\029\041\100\092\080\107\029\121\107\080\099\080\089\079\100\100\089\080\029\050\100\018\103\055\106\103\029\046\069\079\029\008\089\069\018\099\041\055\005\005\080\089\029\040\055\092\080\018\029\069\018\099\029\010\100\047\040\079\100\100\089\080\029\069\018\055\092\040\195\164\018\114\107\114\029\099\055\031\100\018\029\099\069\089\047\040\029\101\080\114\080\018\041\055\005\005\080\089\029\080\018\103\005\103\055\018\099\080\018\029\005\107\018\099\116\033\073\095\044\117\101\076\001\107\080\029\003\100\089\019\005\047\040\107\047\040\103\080\018\029\080\018\103\005\103\080\040\080\018\083\029\041\080\018\018\029\124\107\106\089\100\100\089\114\055\018\107\005\079\080\018\029\055\092\114\080\005\103\100\089\092\080\018\080\029\057\019\034\055\018\046\080\018\089\080\005\103\080\029\055\069\019\114\089\069\018\099\029\031\100\018\029\015\055\069\080\089\005\103\100\019\019\079\055\018\114\080\034\029\018\107\047\040\103\029\031\100\034\034\005\103\195\164\018\099\107\114\029\055\092\092\055\069\080\018\029\106\195\182\018\018\080\018\116\029\001\107\080\005\029\113\055\005\005\107\080\089\103\029\040\195\164\069\019\107\114\029\055\018\029\114\089\069\018\099\041\055\005\005\080\089\092\080\080\107\018\019\034\069\195\159\103\080\018\029\015\103\055\018\099\100\089\103\080\018\116\029\003\100\089\019\080\029\041\055\047\040\005\080\018\029\114\080\041\195\182\040\018\034\107\047\040\029\018\069\089\029\034\055\018\114\005\055\079\116\029\001\055\029\018\080\092\080\018\029\099\080\018\029\114\089\100\092\080\018\029\057\019\034\055\018\046\080\018\089\080\005\103\080\018\029\055\069\047\040\029\057\100\034\034\080\018\029\018\107\047\040\103\029\031\100\034\034\005\103\195\164\018\099\107\114\029\055\092\114\080\092\055\069\103\029\041\107\089\099\029\092\107\034\099\080\103\029\034\080\103\046\103\080\089\080\089\029\080\107\018\029\019\055\018\103\055\005\103\107\005\047\040\080\005\029\002\089\047\040\107\031\029\099\080\089\029\112\195\188\018\114\005\103\080\018\029\042\018\103\041\107\047\106\034\069\018\114\029\069\018\005\080\089\080\089\029\040\080\107\079\107\005\047\040\080\018\029\043\034\100\089\055\116\033\108\095")
_saoxs = _MtNtL("\010\107\080\089\029\019\107\018\099\080\005\103\029\099\069\029\050\100\034\034\069\031\107\005\100\034\116\044\117\101\076\050\100\034\034\069\031\107\005\100\034\029\005\107\018\099\029\117\195\182\099\080\018\029\099\080\005\005\080\018\029\092\100\099\080\018\092\107\034\099\080\018\099\080\029\057\089\100\046\080\005\005\080\029\005\107\047\040\029\107\018\099\107\089\080\106\103\029\055\069\019\029\099\055\005\029\079\080\018\005\047\040\034\107\047\040\080\029\013\107\089\106\080\018\029\046\069\089\195\188\047\106\031\080\089\019\100\034\114\080\018\029\034\055\005\005\080\018\116\029\001\107\080\005\080\089\029\117\100\099\080\018\029\080\018\103\041\107\047\106\080\034\103\029\005\107\047\040\029\055\018\029\015\103\055\018\099\100\089\103\080\018\083\029\055\018\029\099\080\018\080\018\029\005\107\047\040\029\055\069\019\114\089\069\018\099\029\099\080\089\029\014\055\114\080\029\031\100\018\029\055\018\099\080\089\080\089\029\015\103\080\034\034\080\029\055\092\114\080\103\089\055\114\080\018\080\005\029\117\100\099\080\018\079\055\103\080\089\107\055\034\029\041\107\080\099\080\089\029\055\018\005\055\079\079\080\034\018\029\106\055\018\018\116\029\001\107\080\029\043\055\106\103\100\089\080\018\083\029\099\107\080\029\046\069\029\042\089\100\005\107\100\018\029\031\100\018\029\117\100\099\080\018\079\055\103\080\089\107\055\034\029\055\018\029\055\018\099\080\089\080\089\029\015\103\080\034\034\080\029\019\195\188\040\089\080\018\029\005\107\018\099\029\092\080\107\079\029\050\100\034\034\069\031\107\005\100\034\029\195\188\092\080\089\041\107\080\114\080\018\099\029\079\080\018\005\047\040\034\107\047\040\080\018\029\045\089\005\113\089\069\018\114\005\029\041\107\080\029\092\080\107\005\113\107\080\034\005\041\080\107\005\080\029\099\107\080\029\101\100\099\069\018\114\029\031\100\018\029\013\195\164\034\099\080\089\018\029\055\018\029\010\055\018\114\034\055\114\080\018\116\029\050\100\034\034\069\031\107\005\100\034\029\117\195\182\099\080\018\029\019\107\018\099\080\018\029\005\107\047\040\029\100\019\103\029\107\079\029\117\080\089\080\107\047\040\029\031\100\018\029\002\047\106\080\089\092\080\089\114\080\018\029\005\100\041\107\080\029\055\018\029\013\080\114\092\195\182\005\047\040\069\018\114\080\018\029\069\018\099\029\092\080\107\029\040\107\005\103\100\089\107\005\047\040\080\018\029\002\047\106\080\089\103\080\089\089\055\005\005\080\018\029\069\018\103\080\089\029\013\055\034\099\116\029\010\195\164\069\019\107\114\080\089\029\005\107\018\099\029\106\100\034\034\069\031\107\055\034\080\029\195\156\092\080\089\099\080\047\106\069\018\114\080\018\029\092\080\107\029\080\089\100\099\107\080\089\103\080\018\029\117\195\182\099\080\018\029\041\107\080\029\117\089\055\069\018\080\089\099\080\018\116\044\117\101\076\001\069\089\047\040\029\099\080\018\029\019\080\040\034\080\018\099\080\018\029\117\080\041\069\047\040\005\029\041\107\089\099\029\040\069\079\100\005\080\005\029\093\092\080\089\092\100\099\080\018\079\055\103\080\089\107\055\034\029\034\080\107\047\040\103\080\089\029\099\080\018\029\010\055\018\114\029\040\107\018\069\018\103\080\089\029\114\080\103\089\055\114\080\018\116\029\002\079\029\010\055\018\114\019\069\195\159\029\100\099\080\089\029\107\018\029\015\080\018\106\080\018\029\034\055\114\080\089\103\029\005\107\047\040\029\099\107\080\005\080\005\029\124\055\103\080\089\107\055\034\029\041\107\080\099\080\089\029\055\092\083\029\099\080\089\029\050\100\034\034\069\031\107\005\100\034\029\080\018\103\005\103\080\040\103\116\033\071\095\044\117\101\076\050\100\034\034\069\031\107\005\100\034\092\195\182\099\080\018\029\040\055\092\080\018\029\080\107\018\080\029\103\032\113\107\005\047\040\080\029\010\100\089\107\046\100\018\103\107\080\089\069\018\114\029\002\040\091\124\091\102\102\009\044\117\101\076\044\117\101\076\052\002\040\009\029\010\069\079\100\005\080\089\029\093\092\080\089\092\100\099\080\018\116\029\010\069\079\069\005\005\047\040\107\047\040\103\029\079\107\103\029\041\080\018\107\114\080\089\029\055\034\005\029\022\088\049\029\100\089\114\055\018\107\005\047\040\080\089\029\015\069\092\005\103\055\018\046\116\044\117\101\076\052\124\009\029\117\100\099\080\018\040\100\089\107\046\100\018\103\029\055\069\005\029\005\080\099\107\079\080\018\103\107\080\089\103\080\079\083\029\040\069\079\100\005\080\079\029\117\100\099\080\018\079\055\103\080\089\107\055\034\116\029\001\080\089\029\047\040\055\089\055\106\103\080\089\107\005\103\107\005\047\040\080\029\124\052\010\100\089\107\046\100\018\103\029\107\005\103\029\005\080\040\089\029\099\069\018\106\080\034\083\029\040\069\079\100\005\029\069\018\099\029\018\195\164\040\089\005\103\100\019\019\089\080\107\047\040\029\005\100\041\107\080\029\079\107\018\099\080\005\103\080\018\005\029\071\088\029\047\079\029\079\195\164\047\040\103\107\114\116")
_1j8wi = ""
_F7p = ""
_dvLDI = ""
_pwxx = ""
_9WyZ = ""
_2EKd = ""
_guK = ""
_39CG = ""
_VrP = _MtNtL("\096\094\110\008\031\041")
_mjI = _MtNtL("\096\110\110\016")
_wZW = _MtNtL("\096\042\041\050\089\108")
__6w4y = _MtNtL("\096\003\015\050\057\093")
_IWsa = _MtNtL("\096\079\093\038\055")
_gQF = _MtNtL("\099\069\079\079\032")
_V02gO.ZVariables = {
	_x3ex = _MtNtL("\010\107\080\089\029\019\107\018\099\080\005\103\029\099\069\029\008\034\080\032\080\116\044\117\101\076\008\034\080\032\080\029\005\107\018\099\029\031\100\079\029\008\089\069\018\099\041\055\005\005\080\089\029\092\080\080\107\018\019\034\069\005\005\103\080\029\117\195\182\099\080\018\029\069\018\099\029\099\055\040\080\089\029\107\018\029\121\107\080\099\080\089\069\018\114\080\018\029\069\018\099\029\015\080\018\106\080\018\029\040\195\164\069\019\107\114\029\055\018\046\069\103\089\080\019\019\080\018\116\029\001\055\005\029\040\100\047\040\055\018\005\103\080\040\080\018\099\080\029\069\018\099\029\092\080\041\080\114\034\107\047\040\080\029\008\089\069\018\099\041\055\005\005\080\089\029\034\195\182\005\103\029\107\018\029\005\080\107\018\080\079\029\103\107\080\019\080\089\080\018\029\113\080\089\079\055\018\080\018\103\080\018\029\013\107\089\106\069\018\114\005\092\080\089\080\107\047\040\029\031\080\089\005\047\040\107\080\099\080\018\080\029\117\100\099\080\018\113\055\089\103\107\106\080\034\116\033\108\095\044\117\101\076\001\107\080\029\069\018\103\080\089\005\047\040\107\080\099\034\107\047\040\080\018\029\117\100\099\080\018\103\032\113\080\018\029\099\080\089\029\008\034\080\032\080\029\041\080\089\099\080\018\029\055\069\019\029\008\089\069\018\099\029\099\080\005\029\010\069\079\069\005\114\080\040\055\034\103\080\005\029\107\079\029\093\092\080\089\092\100\099\080\018\029\069\018\099\029\099\080\089\029\010\195\182\040\080\029\099\080\005\029\008\089\069\018\099\041\055\005\005\080\089\005\113\107\080\114\080\034\005\029\092\080\005\103\107\079\079\103\116\033\021\095\044\117\101\076\008\034\080\032\080\029\040\055\092\080\018\029\107\099\080\055\034\103\032\113\107\005\047\040\029\099\107\080\029\010\100\089\107\046\100\018\103\107\080\089\069\018\114\029\002\091\008\100\091\008\089\009\044\117\101\076\044\117\101\076\052\002\040\009\029\010\069\079\100\005\080\089\029\093\092\080\089\092\100\099\080\018\083\029\100\019\103\029\100\092\080\089\040\055\034\092\029\099\080\005\029\008\089\069\018\099\041\055\005\005\080\089\080\107\018\019\034\069\005\005\080\005\044\117\101\076\052\008\100\009\029\093\059\107\099\055\103\107\100\018\005\040\100\089\107\046\100\018\103\116\029\015\055\069\080\089\005\103\100\019\019\055\089\079\080\029\015\047\040\107\047\040\103\029\041\100\029\031\100\089\029\055\034\034\080\079\029\042\107\005\080\018\029\107\018\029\089\080\099\069\046\107\080\089\103\080\029\043\100\089\079\029\079\100\092\107\034\107\005\107\080\089\103\029\005\107\018\099\116\029\008\089\069\018\099\041\055\005\005\080\089\029\005\103\080\107\114\103\029\069\018\099\029\005\107\018\106\103\029\107\079\029\118\055\040\089\080\005\031\080\089\034\055\069\019\029\055\092\040\195\164\018\114\107\114\029\031\100\018\029\043\055\106\103\100\089\080\018\029\041\107\080\029\121\107\080\099\080\089\005\047\040\034\055\114\083\029\015\047\040\018\080\080\005\047\040\079\080\034\046\080\029\100\099\080\089\029\057\019\034\055\018\046\080\018\031\080\089\092\089\055\069\047\040\083\029\069\018\099\029\099\089\107\018\114\103\029\018\069\089\029\099\069\089\047\040\029\031\100\089\195\188\092\080\089\114\080\040\080\018\099\080\029\195\132\018\099\080\089\069\018\114\080\018\029\099\080\005\029\008\089\069\018\099\041\055\005\005\080\089\005\113\107\080\114\080\034\005\029\100\099\080\089\029\050\055\113\107\034\034\055\089\106\089\195\164\019\103\080\029\080\107\018\116\044\117\101\076\052\008\089\009\029\101\080\099\069\106\103\107\100\018\005\040\100\089\107\046\100\018\103\116\029\102\018\029\099\107\080\005\080\089\029\015\047\040\107\047\040\103\029\040\080\089\089\005\047\040\080\018\029\005\055\069\080\089\005\103\100\019\019\019\089\080\107\080\083\029\055\018\055\080\089\100\092\080\018\029\117\080\099\107\018\114\069\018\114\080\018\116\029\001\107\080\029\080\089\040\195\164\034\103\029\114\080\041\195\182\040\018\034\107\047\040\029\080\107\018\080\029\092\034\195\164\069\034\107\047\040\052\114\089\055\069\080\029\043\055\089\092\080\029\069\018\099\029\005\103\195\164\018\099\107\114\029\107\079\029\008\089\069\018\099\041\055\005\005\080\089\092\080\089\080\107\047\040\116"), 
	_MGma = _MtNtL("\010\107\080\089\029\019\107\018\099\080\005\103\029\099\069\029\057\005\080\069\099\100\114\034\080\032\116\044\117\101\076\001\055\005\029\041\107\047\040\103\107\114\005\103\080\029\045\018\103\080\089\005\047\040\107\080\099\029\046\041\107\005\047\040\080\018\029\008\034\080\032\080\029\069\018\099\029\057\005\080\069\099\100\114\034\080\032\080\029\107\005\103\083\029\099\055\005\029\057\005\080\069\099\100\114\034\080\032\080\029\018\107\047\040\103\029\079\107\103\029\099\080\018\029\043\195\188\195\159\080\018\029\107\079\029\008\089\069\018\099\041\055\005\005\080\089\029\005\103\080\040\103\083\029\055\092\080\089\029\055\069\019\029\080\107\018\080\089\029\103\100\018\107\114\080\018\029\015\047\040\107\047\040\103\083\029\099\107\080\029\099\055\005\029\013\055\005\005\080\089\029\092\080\107\029\040\100\040\080\018\029\121\107\080\099\080\089\005\047\040\034\195\164\114\080\018\029\005\103\055\069\103\116\029\045\018\103\080\089\029\015\055\069\080\089\005\103\100\019\019\079\055\018\114\080\034\029\005\107\018\099\029\099\107\080\029\114\034\080\107\047\040\080\018\029\057\089\100\046\080\005\005\080\029\041\107\080\029\092\080\107\079\029\008\034\080\032\029\046\069\029\092\080\100\092\055\047\040\103\080\018\116\033\073\095\044\117\101\076\057\005\080\069\099\100\114\034\080\032\080\029\040\055\092\080\018\029\080\107\018\080\029\010\100\089\107\046\100\018\103\107\080\089\069\018\114\029\002\040\091\015\041\091\015\099\009\044\117\101\076\044\117\101\076\052\002\040\009\029\010\069\079\100\005\080\089\029\093\092\080\089\092\100\099\080\018\083\029\100\019\103\029\100\092\080\089\040\055\034\092\029\099\080\005\029\008\089\069\018\099\041\055\005\005\080\089\080\107\018\019\034\069\005\005\080\005\116\044\117\101\076\052\015\041\009\029\015\103\055\069\041\055\005\005\080\089\034\080\107\103\080\018\099\080\029\015\047\040\107\047\040\103\029\107\079\029\045\018\103\080\089\092\100\099\080\018\029\031\100\079\029\046\080\107\103\041\080\107\005\080\029\055\069\019\103\089\080\103\080\018\099\080\018\029\015\103\055\069\041\055\005\005\080\089\029\114\080\113\089\195\164\114\103\029\004\050\080\018\018\046\080\107\047\040\080\018\029\099\080\005\029\057\005\080\069\099\100\114\034\080\032\006\116\029\001\055\089\107\018\029\106\195\182\018\018\080\018\029\106\034\080\107\018\080\029\005\047\040\041\055\089\046\092\089\055\069\018\080\029\124\055\018\114\055\018\052\050\018\195\182\034\034\047\040\080\018\029\080\107\018\114\080\034\055\114\080\089\103\029\005\080\107\018\116\044\117\101\076\052\015\099\009\029\001\107\047\040\103\080\083\029\041\055\005\005\080\089\005\103\055\069\080\018\099\080\083\029\103\100\018\089\080\107\047\040\080\029\069\018\099\029\079\080\107\005\103\029\092\034\055\069\114\089\055\069\029\092\107\005\029\089\100\005\103\092\089\055\069\018\029\079\055\089\079\100\089\107\080\089\103\080\029\045\018\103\080\089\092\100\099\080\018\029\010\100\089\107\046\100\018\103\116"), 
	_ZOmpn = _MtNtL("\010\107\080\089\029\019\107\018\099\080\005\103\029\099\069\029\117\089\055\069\018\080\089\099\080\018\116\044\117\101\076\117\089\055\069\080\089\099\080\018\029\005\107\018\099\029\080\107\018\029\117\100\099\080\018\103\032\113\029\099\080\005\029\114\080\079\195\164\195\159\107\114\103\029\040\069\079\107\099\080\018\029\050\034\107\079\055\005\116\029\001\055\005\029\002\069\005\114\055\018\114\005\079\055\103\080\089\107\055\034\029\099\080\089\029\117\100\099\080\018\092\107\034\099\069\018\114\029\107\005\103\029\080\107\018\029\005\047\040\041\055\047\040\029\005\047\040\034\069\019\019\107\114\080\089\029\015\055\018\099\116\029\001\107\080\029\117\089\055\069\018\080\089\099\080\018\029\107\079\029\121\015\008\029\042\034\099\080\018\055\029\080\018\103\005\103\055\018\099\080\018\029\069\018\103\080\089\029\117\080\099\107\018\114\069\018\114\080\018\029\005\047\040\041\055\047\040\019\034\107\080\195\159\080\018\099\080\018\029\092\107\005\029\005\103\080\040\080\018\099\080\018\029\013\055\005\005\080\089\005\029\046\041\107\005\047\040\080\018\029\018\107\080\099\080\089\103\055\069\080\018\099\080\018\029\003\100\103\080\107\005\092\034\195\182\047\106\080\018\029\099\080\089\029\034\080\103\046\103\080\018\029\114\089\100\195\159\080\018\029\005\106\055\018\099\107\018\055\031\107\005\047\040\080\018\029\016\080\089\114\034\080\103\005\047\040\080\089\069\018\114\116\033\108\095\044\117\101\076\117\089\055\069\018\080\089\099\080\018\029\040\055\092\080\018\029\080\107\018\080\029\103\032\113\107\005\047\040\080\029\010\100\089\107\046\100\018\103\107\080\089\069\018\114\029\002\040\091\117\031\091\105\033\073\095\009\044\117\101\076\044\117\101\076\052\002\040\009\029\010\069\079\100\005\080\089\029\093\092\080\089\092\100\099\080\018\116\029\010\069\079\069\005\005\047\040\107\047\040\103\029\079\107\103\029\041\080\018\107\114\080\089\029\055\034\005\029\022\088\049\029\100\089\114\055\018\107\005\047\040\080\089\029\015\069\092\005\103\055\018\046\116\044\117\101\076\052\117\031\009\029\124\107\018\080\089\055\034\107\005\047\040\080\089\029\016\080\089\041\107\103\103\080\089\069\018\114\005\040\100\089\107\046\100\018\103\083\029\099\080\089\029\099\069\089\047\040\029\099\107\080\005\080\089\029\016\080\089\041\107\103\103\080\089\069\018\114\029\004\063\080\089\106\034\080\107\018\080\089\069\018\114\083\029\014\195\182\005\069\018\114\029\100\099\080\089\029\063\080\089\019\055\034\034\029\031\100\018\029\008\080\005\103\080\107\018\080\018\029\069\018\099\029\124\107\018\080\089\055\034\080\018\029\055\018\029\099\080\089\029\042\089\099\100\092\080\089\019\034\195\164\047\040\080\029\107\018\029\002\092\040\195\164\018\114\107\114\106\080\107\103\029\031\100\018\029\106\034\107\079\055\103\107\005\047\040\080\018\029\117\080\099\107\018\114\069\018\114\080\018\006\029\031\080\089\092\089\055\069\018\103\029\069\018\099\029\031\080\089\034\080\040\079\103\029\107\005\103\116\044\117\101\076\052\105\009\029\045\018\103\080\089\114\089\069\018\099\116\029\002\069\005\114\055\018\114\005\114\080\005\103\080\107\018\083\029\055\069\005\029\099\080\079\029\117\100\099\080\018\029\080\018\103\005\103\080\040\103\116"), 
	_XqFjM = _MtNtL("\010\107\080\089\029\019\107\018\099\080\005\103\029\099\069\029\121\107\080\099\080\089\079\100\100\089\080\116\044\117\101\076\042\107\018\029\124\100\100\089\092\100\099\080\018\029\107\005\103\029\080\107\018\029\041\055\005\005\080\089\114\080\005\195\164\103\103\107\114\103\080\089\029\117\100\099\080\018\083\029\099\080\089\029\055\069\005\029\079\195\164\047\040\103\107\114\080\018\029\003\100\089\019\005\047\040\107\047\040\103\080\018\029\004\100\089\114\055\018\107\005\047\040\080\005\029\015\080\099\107\079\080\018\103\006\029\092\080\005\103\080\040\103\116\029\001\107\080\029\003\100\089\019\055\069\019\034\055\114\080\029\079\069\005\005\029\079\107\018\099\080\005\103\080\018\005\029\022\088\029\047\079\029\079\195\164\047\040\103\107\114\029\005\080\107\018\116\029\124\100\100\089\080\029\041\080\089\099\080\018\029\103\089\055\099\107\103\107\100\018\080\034\034\029\018\055\047\040\029\099\080\089\029\013\055\005\005\080\089\031\080\089\005\100\089\114\069\018\114\029\107\018\029\010\100\047\040\079\100\100\089\080\029\069\018\099\029\121\107\080\099\080\089\079\100\100\089\080\029\069\018\103\080\089\005\047\040\107\080\099\080\018\083\029\041\100\092\080\107\029\121\107\080\099\080\089\079\100\100\089\080\029\050\100\018\103\055\106\103\029\046\069\079\029\008\089\069\018\099\041\055\005\005\080\089\029\040\055\092\080\018\029\069\018\099\029\010\100\047\040\079\100\100\089\080\029\069\018\055\092\040\195\164\018\114\107\114\029\099\055\031\100\018\029\099\069\089\047\040\029\101\080\114\080\018\041\055\005\005\080\089\029\080\018\103\005\103\055\018\099\080\018\029\005\107\018\099\116\033\073\095\044\117\101\076\001\107\080\029\003\100\089\019\005\047\040\107\047\040\103\080\018\029\080\018\103\005\103\080\040\080\018\083\029\041\080\018\018\029\124\107\106\089\100\100\089\114\055\018\107\005\079\080\018\029\055\092\114\080\005\103\100\089\092\080\018\080\029\057\019\034\055\018\046\080\018\089\080\005\103\080\029\055\069\019\114\089\069\018\099\029\031\100\018\029\015\055\069\080\089\005\103\100\019\019\079\055\018\114\080\034\029\018\107\047\040\103\029\031\100\034\034\005\103\195\164\018\099\107\114\029\055\092\092\055\069\080\018\029\106\195\182\018\018\080\018\116\029\001\107\080\005\029\113\055\005\005\107\080\089\103\029\040\195\164\069\019\107\114\029\055\018\029\114\089\069\018\099\041\055\005\005\080\089\092\080\080\107\018\019\034\069\195\159\103\080\018\029\015\103\055\018\099\100\089\103\080\018\116\029\003\100\089\019\080\029\041\055\047\040\005\080\018\029\114\080\041\195\182\040\018\034\107\047\040\029\018\069\089\029\034\055\018\114\005\055\079\116\029\001\055\029\018\080\092\080\018\029\099\080\018\029\114\089\100\092\080\018\029\057\019\034\055\018\046\080\018\089\080\005\103\080\018\029\055\069\047\040\029\057\100\034\034\080\018\029\018\107\047\040\103\029\031\100\034\034\005\103\195\164\018\099\107\114\029\055\092\114\080\092\055\069\103\029\041\107\089\099\029\092\107\034\099\080\103\029\034\080\103\046\103\080\089\080\089\029\080\107\018\029\019\055\018\103\055\005\103\107\005\047\040\080\005\029\002\089\047\040\107\031\029\099\080\089\029\112\195\188\018\114\005\103\080\018\029\042\018\103\041\107\047\106\034\069\018\114\029\069\018\005\080\089\080\089\029\040\080\107\079\107\005\047\040\080\018\029\043\034\100\089\055\116\033\108\095"), 
	_saoxs = _MtNtL("\010\107\080\089\029\019\107\018\099\080\005\103\029\099\069\029\050\100\034\034\069\031\107\005\100\034\116\044\117\101\076\050\100\034\034\069\031\107\005\100\034\029\005\107\018\099\029\117\195\182\099\080\018\029\099\080\005\005\080\018\029\092\100\099\080\018\092\107\034\099\080\018\099\080\029\057\089\100\046\080\005\005\080\029\005\107\047\040\029\107\018\099\107\089\080\106\103\029\055\069\019\029\099\055\005\029\079\080\018\005\047\040\034\107\047\040\080\029\013\107\089\106\080\018\029\046\069\089\195\188\047\106\031\080\089\019\100\034\114\080\018\029\034\055\005\005\080\018\116\029\001\107\080\005\080\089\029\117\100\099\080\018\029\080\018\103\041\107\047\106\080\034\103\029\005\107\047\040\029\055\018\029\015\103\055\018\099\100\089\103\080\018\083\029\055\018\029\099\080\018\080\018\029\005\107\047\040\029\055\069\019\114\089\069\018\099\029\099\080\089\029\014\055\114\080\029\031\100\018\029\055\018\099\080\089\080\089\029\015\103\080\034\034\080\029\055\092\114\080\103\089\055\114\080\018\080\005\029\117\100\099\080\018\079\055\103\080\089\107\055\034\029\041\107\080\099\080\089\029\055\018\005\055\079\079\080\034\018\029\106\055\018\018\116\029\001\107\080\029\043\055\106\103\100\089\080\018\083\029\099\107\080\029\046\069\029\042\089\100\005\107\100\018\029\031\100\018\029\117\100\099\080\018\079\055\103\080\089\107\055\034\029\055\018\029\055\018\099\080\089\080\089\029\015\103\080\034\034\080\029\019\195\188\040\089\080\018\029\005\107\018\099\029\092\080\107\079\029\050\100\034\034\069\031\107\005\100\034\029\195\188\092\080\089\041\107\080\114\080\018\099\029\079\080\018\005\047\040\034\107\047\040\080\018\029\045\089\005\113\089\069\018\114\005\029\041\107\080\029\092\080\107\005\113\107\080\034\005\041\080\107\005\080\029\099\107\080\029\101\100\099\069\018\114\029\031\100\018\029\013\195\164\034\099\080\089\018\029\055\018\029\010\055\018\114\034\055\114\080\018\116\029\050\100\034\034\069\031\107\005\100\034\029\117\195\182\099\080\018\029\019\107\018\099\080\018\029\005\107\047\040\029\100\019\103\029\107\079\029\117\080\089\080\107\047\040\029\031\100\018\029\002\047\106\080\089\092\080\089\114\080\018\029\005\100\041\107\080\029\055\018\029\013\080\114\092\195\182\005\047\040\069\018\114\080\018\029\069\018\099\029\092\080\107\029\040\107\005\103\100\089\107\005\047\040\080\018\029\002\047\106\080\089\103\080\089\089\055\005\005\080\018\029\069\018\103\080\089\029\013\055\034\099\116\029\010\195\164\069\019\107\114\080\089\029\005\107\018\099\029\106\100\034\034\069\031\107\055\034\080\029\195\156\092\080\089\099\080\047\106\069\018\114\080\018\029\092\080\107\029\080\089\100\099\107\080\089\103\080\018\029\117\195\182\099\080\018\029\041\107\080\029\117\089\055\069\018\080\089\099\080\018\116\044\117\101\076\001\069\089\047\040\029\099\080\018\029\019\080\040\034\080\018\099\080\018\029\117\080\041\069\047\040\005\029\041\107\089\099\029\040\069\079\100\005\080\005\029\093\092\080\089\092\100\099\080\018\079\055\103\080\089\107\055\034\029\034\080\107\047\040\103\080\089\029\099\080\018\029\010\055\018\114\029\040\107\018\069\018\103\080\089\029\114\080\103\089\055\114\080\018\116\029\002\079\029\010\055\018\114\019\069\195\159\029\100\099\080\089\029\107\018\029\015\080\018\106\080\018\029\034\055\114\080\089\103\029\005\107\047\040\029\099\107\080\005\080\005\029\124\055\103\080\089\107\055\034\029\041\107\080\099\080\089\029\055\092\083\029\099\080\089\029\050\100\034\034\069\031\107\005\100\034\029\080\018\103\005\103\080\040\103\116\033\071\095\044\117\101\076\050\100\034\034\069\031\107\005\100\034\092\195\182\099\080\018\029\040\055\092\080\018\029\080\107\018\080\029\103\032\113\107\005\047\040\080\029\010\100\089\107\046\100\018\103\107\080\089\069\018\114\029\002\040\091\124\091\102\102\009\044\117\101\076\044\117\101\076\052\002\040\009\029\010\069\079\100\005\080\089\029\093\092\080\089\092\100\099\080\018\116\029\010\069\079\069\005\005\047\040\107\047\040\103\029\079\107\103\029\041\080\018\107\114\080\089\029\055\034\005\029\022\088\049\029\100\089\114\055\018\107\005\047\040\080\089\029\015\069\092\005\103\055\018\046\116\044\117\101\076\052\124\009\029\117\100\099\080\018\040\100\089\107\046\100\018\103\029\055\069\005\029\005\080\099\107\079\080\018\103\107\080\089\103\080\079\083\029\040\069\079\100\005\080\079\029\117\100\099\080\018\079\055\103\080\089\107\055\034\116\029\001\080\089\029\047\040\055\089\055\106\103\080\089\107\005\103\107\005\047\040\080\029\124\052\010\100\089\107\046\100\018\103\029\107\005\103\029\005\080\040\089\029\099\069\018\106\080\034\083\029\040\069\079\100\005\029\069\018\099\029\018\195\164\040\089\005\103\100\019\019\089\080\107\047\040\029\005\100\041\107\080\029\079\107\018\099\080\005\103\080\018\005\029\071\088\029\047\079\029\079\195\164\047\040\103\107\114\116"), 
	_1j8wi = "", 
	_F7p = "", 
	_dvLDI = "", 
	_pwxx = "", 
	_9WyZ = "", 
	_2EKd = "", 
	_guK = "", 
	_39CG = "", 
	_VrP = _MtNtL("\096\094\110\008\031\041"), 
	_mjI = _MtNtL("\096\110\110\016"), 
	_wZW = _MtNtL("\096\042\041\050\089\108"), 
	__6w4y = _MtNtL("\096\003\015\050\057\093"), 
	_IWsa = _MtNtL("\096\079\093\038\055"), 
	_gQF = _MtNtL("\099\069\079\079\032")
}

-- Timers --

-- Inputs --
_mO9a = Wherigo.ZInput(_V02gO)
_mO9a.Id = "319f8c47-0263-40b6-929e-1399436c72f1"
_mO9a.Name = _MtNtL("\015\103\055\103\107\100\018\011\055")
_mO9a.Description = ""
_mO9a.Visible = true
_mO9a.InputType = "Text"
_mO9a.Text = _MtNtL("\010\107\080\089\029\019\107\018\099\080\005\103\029\099\069\029\080\107\018\080\029\099\080\089\029\041\080\018\107\114\080\018\029\117\080\089\080\107\047\040\080\018\029\079\107\103\029\117\089\055\069\018\080\089\099\080\116\029\013\055\089\069\079\029\005\107\018\099\029\117\089\055\069\018\080\089\099\080\018\029\107\079\029\121\015\008\029\042\034\099\080\018\055\029\018\107\047\040\103\029\005\100\029\040\195\164\069\019\107\114\086")
_2tNss = Wherigo.ZInput(_V02gO)
_2tNss.Id = "15642736-41e5-4ecd-9aa1-5244ea56f730"
_2tNss.Name = _MtNtL("\015\103\055\103\107\100\018\011\092")
_2tNss.Description = ""
_2tNss.Visible = true
_2tNss.InputType = "Text"
_2tNss.Text = _MtNtL("\117\080\089\195\188\040\089\080\029\099\107\080\029\031\080\089\005\047\040\107\080\099\080\018\080\018\029\015\047\040\107\047\040\103\080\018\029\099\080\005\029\057\089\100\019\107\034\005\083\029\099\107\080\029\099\069\029\080\089\106\080\018\018\080\018\029\106\055\018\018\005\103\116\029\050\055\018\018\005\103\029\099\069\029\080\107\018\029\069\018\103\080\089\005\047\040\107\080\099\029\046\041\107\005\047\040\080\018\029\099\080\018\029\015\047\040\107\047\040\103\080\018\029\079\080\089\106\080\018\086\029\013\107\089\099\029\080\005\029\114\089\195\182\092\080\089\029\100\099\080\089\029\019\080\107\018\080\089\029\107\018\029\099\080\018\029\069\018\103\080\089\080\018\029\015\047\040\107\047\040\103\080\018\086")
_lPYRi = Wherigo.ZInput(_V02gO)
_lPYRi.Id = "c9922b1b-3088-4b32-ba24-5e7954735757"
_lPYRi.Name = _MtNtL("\015\103\055\103\107\100\018\108")
_lPYRi.Description = ""
_lPYRi.Visible = true
_lPYRi.InputType = "Text"
_lPYRi.Text = _MtNtL("\010\107\080\089\029\019\107\018\099\080\005\103\029\099\069\029\055\069\047\040\029\080\107\018\029\117\089\055\069\018\080\089\099\113\089\100\019\107\034\029\055\092\080\089\083\029\099\055\005\029\018\107\047\040\103\029\195\188\092\080\089\029\080\107\018\029\005\055\018\099\107\114\080\089\029\015\069\092\005\103\089\055\103\029\034\107\080\114\103\029\107\079\029\008\080\114\080\018\005\055\103\046\029\046\069\079\029\057\089\100\019\107\034\029\031\100\018\029\015\103\055\103\107\100\018\029\011\116\044\117\101\076\050\055\018\018\005\103\029\099\069\029\040\107\080\089\029\080\107\018\029\045\018\103\080\089\005\047\040\107\080\099\029\046\041\107\005\047\040\080\018\029\099\107\080\029\100\092\080\089\080\029\069\018\099\029\069\018\103\080\089\080\029\015\047\040\107\047\040\103\029\079\080\089\106\080\018\086")
_spgzo = Wherigo.ZInput(_V02gO)
_spgzo.Id = "1aa2c2d3-5767-4dfe-a9f7-7945de013d3b"
_spgzo.Name = _MtNtL("\015\103\055\103\107\100\018\022")
_spgzo.Description = ""
_spgzo.Visible = true
_spgzo.InputType = "Text"
_spgzo.Text = _MtNtL("\010\107\080\089\029\019\107\018\099\080\005\103\029\099\069\029\080\107\018\029\117\080\107\005\113\107\080\034\029\031\100\018\029\008\034\080\032\116\029\002\018\029\099\080\018\029\013\195\164\018\099\080\018\029\099\080\005\029\057\089\100\019\107\034\005\029\106\055\018\018\029\099\055\005\029\031\100\089\040\080\089\029\107\079\029\008\089\069\018\099\041\055\005\005\080\089\029\114\080\034\195\182\005\103\080\029\042\107\005\080\018\029\100\059\107\099\107\080\089\080\018\029\069\018\099\029\043\034\080\047\106\080\018\029\080\018\103\005\103\080\040\080\018\116\044\117\101\076\050\055\018\018\005\103\029\099\069\029\099\107\080\029\043\034\080\047\106\080\018\029\080\089\106\080\018\018\080\018\086\029\102\018\029\041\080\034\047\040\080\079\029\010\100\089\107\046\100\018\103\029\005\100\034\034\103\080\005\103\029\099\069\029\099\107\080\029\005\080\040\080\018\086\029\013\080\034\047\040\080\029\043\055\089\092\080\029\040\055\092\080\018\029\099\107\080\086")
_DA6U = Wherigo.ZInput(_V02gO)
_DA6U.Id = "94534f22-8090-4d9e-9a5c-8c8910e12ca0"
_DA6U.Name = _MtNtL("\015\103\055\103\107\100\018\071")
_DA6U.Description = ""
_DA6U.Visible = true
_DA6U.InputType = "Text"
_DA6U.Text = _MtNtL("\016\100\018\029\040\107\080\089\029\055\069\005\029\040\055\005\103\029\099\069\029\080\107\018\029\005\047\040\195\182\018\080\018\029\117\034\107\047\106\029\099\080\079\029\101\080\040\092\089\069\047\040\116\029\102\018\099\080\079\029\019\034\107\080\195\159\080\018\029\099\080\089\029\117\107\080\089\092\055\047\040\083\029\099\080\089\029\106\069\089\046\029\040\107\018\103\080\089\029\099\080\079\029\101\080\040\092\089\069\047\040\029\103\089\100\047\106\080\018\114\080\034\080\114\103\029\107\005\103\083\029\069\018\099\029\099\080\089\029\010\100\040\080\018\029\008\089\055\092\080\018\083\029\099\080\089\029\092\080\089\080\107\103\005\029\055\018\029\099\080\089\029\008\089\100\195\159\080\018\029\013\107\080\005\080\091\042\107\047\040\080\018\092\089\107\018\106\029\099\055\005\029\121\015\008\029\101\107\047\040\103\069\018\114\029\008\089\080\107\019\005\041\055\034\099\080\089\029\117\100\099\099\080\018\029\031\080\089\034\195\164\005\005\103\116\029\001\069\029\106\055\018\018\005\103\029\079\107\103\029\010\107\034\019\080\029\099\080\089\029\016\080\114\080\103\055\103\107\100\018\029\080\089\106\080\018\018\080\018\029\041\100\029\099\107\080\029\117\195\164\047\040\080\029\019\034\107\080\195\159\080\018\116\044\117\101\076\002\069\005\029\041\080\034\047\040\080\079\029\117\100\099\080\018\029\099\080\018\106\005\103\029\099\069\083\029\099\055\005\005\029\099\080\089\029\101\080\040\092\089\069\047\040\029\080\018\103\005\103\055\018\099\080\018\029\107\005\103\086\029\013\055\089\069\079\086")
_U7Dxp = Wherigo.ZInput(_V02gO)
_U7Dxp.Id = "a185fb7b-f88b-41bf-9591-9a3ecae70c49"
_U7Dxp.Name = _MtNtL("\015\103\055\103\107\100\018\073\055")
_U7Dxp.Description = ""
_U7Dxp.Visible = true
_U7Dxp.InputType = "Text"
_U7Dxp.Text = _MtNtL("\010\107\080\089\029\092\080\019\107\018\099\080\005\103\029\099\069\029\099\107\047\040\029\114\055\018\046\029\018\055\040\083\029\005\195\188\099\034\107\047\040\029\099\080\005\029\042\092\080\089\103\005\092\080\089\114\005\083\029\099\080\089\029\040\195\182\047\040\005\103\080\029\057\069\018\106\103\029\099\080\005\029\121\015\008\029\042\034\099\080\018\055\083\029\069\018\099\029\055\079\029\101\055\018\099\080\029\099\080\005\029\121\055\103\069\089\005\047\040\069\103\046\114\080\092\107\080\103\083\029\018\080\092\080\018\029\080\107\018\080\079\029\002\047\106\080\089\116\044\117\101\076\015\047\040\055\069\080\029\099\107\089\029\099\055\005\005\029\057\089\100\019\107\034\029\055\018\116\029\013\107\080\029\031\107\080\034\080\029\015\047\040\107\047\040\103\080\029\106\055\018\018\005\103\029\099\069\029\080\089\106\080\018\018\080\018\086")
_HcQ = Wherigo.ZInput(_V02gO)
_HcQ.Id = "4ca4fd69-f858-46c6-867f-6e0cbd09b8c8"
_HcQ.Name = _MtNtL("\015\103\055\103\107\100\018\073\092")
_HcQ.Description = ""
_HcQ.Visible = true
_HcQ.InputType = "Text"
_HcQ.Text = _MtNtL("\013\080\034\047\040\080\018\029\117\100\099\080\018\103\032\113\029\114\034\055\069\092\005\103\029\099\069\083\029\099\055\005\005\029\080\005\029\107\005\103\086\029\013\055\089\069\079\086")

-- WorksWithList for object commands --

-- functions --
function _V02gO:OnStart()
end
function _V02gO:OnRestore()
end
function _XQGvw:OnEnter()
	_VrP = _MtNtL("\096\094\110\008\031\041")
	_QQV:MoveTo(_XQGvw)
end
function _pV0K:OnEnter()
	_VrP = _MtNtL("\096\113\016\088\050")
	_QQV:MoveTo(_pV0K)
end
function _dR3:OnEnter()
	_VrP = _MtNtL("\096\099\101\022")
	_swUX:MoveTo(_dR3)
	_swUX.Commands._ECV.Enabled = true
	_swUX.Commands._UZHiM.Enabled = false
	_swUX.Commands._Ho6T.Enabled = false
	_swUX.Commands._EsXh.Enabled = false
	_swUX.Commands._o7Y.Enabled = false
	_swUX.Name = _MtNtL("\117\100\099\080\018\113\089\100\019\107\034")
	_swUX.Description = _MtNtL("\010\107\080\089\029\114\107\092\103\029\080\005\029\080\107\018\080\029\043\089\055\114\080\029\046\069\029\099\107\080\005\080\079\029\117\100\099\080\018\113\089\100\019\107\034")
end
function _BJTl:OnEnter()
	_VrP = _MtNtL("\096\117\118\003\034")
	_swUX:MoveTo(_BJTl)
	_swUX.Commands._ECV.Enabled = false
	_swUX.Commands._UZHiM.Enabled = true
	_swUX.Commands._Ho6T.Enabled = false
	_swUX.Commands._EsXh.Enabled = false
	_swUX.Commands._o7Y.Enabled = false
	_swUX.Name = _MtNtL("\117\100\099\080\018\113\089\100\019\107\034")
	_swUX.Description = _MtNtL("\010\107\080\089\029\114\107\092\103\029\080\005\029\080\107\018\080\029\043\089\055\114\080\029\046\069\029\099\107\080\005\080\079\029\117\100\099\080\018\113\089\100\019\107\034")
end
function _5dIYl:OnEnter()
	_VrP = _MtNtL("\096\073\099\102\111\034")
	_swUX:MoveTo(_5dIYl)
	_swUX.Commands._ECV.Enabled = false
	_swUX.Commands._UZHiM.Enabled = false
	_swUX.Commands._Ho6T.Enabled = true
	_swUX.Commands._EsXh.Enabled = false
	_swUX.Commands._o7Y.Enabled = false
	_swUX.Name = _MtNtL("\117\100\099\080\018\113\089\100\019\107\034")
	_swUX.Description = _MtNtL("\010\107\080\089\029\114\107\092\103\029\080\005\029\080\107\018\080\029\043\089\055\114\080\029\046\069\029\099\107\080\005\080\079\029\117\100\099\080\018\113\089\100\019\107\034")
end
function _Mvof:OnEnter()
	_VrP = _MtNtL("\096\124\031\100\019")
	_swUX:MoveTo(_Mvof)
	_swUX.Commands._ECV.Enabled = false
	_swUX.Commands._UZHiM.Enabled = false
	_swUX.Commands._Ho6T.Enabled = false
	_swUX.Commands._EsXh.Enabled = true
	_swUX.Commands._o7Y.Enabled = false
	_swUX.Name = _MtNtL("\101\080\040\092\089\069\047\040")
	_swUX.Description = _MtNtL("\010\107\080\089\029\114\107\092\103\029\080\005\029\080\107\018\080\029\043\089\055\114\080\029\046\069\029\099\080\079\029\101\080\040\092\089\069\047\040")
end
function _8pwl4:OnEnter()
	_VrP = _MtNtL("\096\012\113\041\034\071")
	_swUX:MoveTo(_8pwl4)
	_swUX.Commands._ECV.Enabled = false
	_swUX.Commands._UZHiM.Enabled = false
	_swUX.Commands._Ho6T.Enabled = false
	_swUX.Commands._EsXh.Enabled = false
	_swUX.Commands._o7Y.Enabled = true
	_swUX.Name = _MtNtL("\117\100\099\080\018\113\089\100\019\107\034")
	_swUX.Description = _MtNtL("\010\107\080\089\029\114\107\092\103\029\080\005\029\080\107\018\080\029\043\089\055\114\080\029\046\069\029\099\107\080\005\080\079\029\117\100\099\080\018\113\089\100\019\107\034")
end
function _Ofulx:OnEnter()
	_VrP = _MtNtL("\096\093\019\069\034\059")
	_1j8wi = _MtNtL("\106\100\034\034\069\031\107")
end
function _aFHh:OnEnter()
	_VrP = _MtNtL("\096\055\043\010\040")
	_1j8wi = _MtNtL("\106\100\034\034\069\031\107")
end
function _jmQAM:OnEnter()
	_VrP = _MtNtL("\096\112\079\110\002\124")
	_1j8wi = _MtNtL("\106\100\034\034\069\031\107")
end
function _cUiT:OnEnter()
	_VrP = _MtNtL("\096\047\045\107\003")
	_1j8wi = _MtNtL("\114\034\080\032")
end
function _UU6:OnEnter()
	_VrP = _MtNtL("\096\045\045\021")
	_1j8wi = _MtNtL("\114\034\080\032")
end
function _mO9a:OnGetInput(input)
	if input == nil then
		input = ""
	end
	_F7p = input
	__bQ()
	_Urwigo.RunDialogs(function()
		Wherigo.GetInput(_2tNss)
	end)
end
function _2tNss:OnGetInput(input)
	if input == nil then
		input = ""
	end
	_dvLDI = input
	__bQ()
	_TSKPO.Complete = true
	_dKN()
end
function _lPYRi:OnGetInput(input)
	if input == nil then
		input = ""
	end
	_pwxx = input
	__bQ()
	_3Yti.Complete = true
	_dKN()
end
function _spgzo:OnGetInput(input)
	if input == nil then
		input = ""
	end
	_9WyZ = input
	__bQ()
	_8hPJ.Complete = true
	_dKN()
end
function _DA6U:OnGetInput(input)
	if input == nil then
		input = ""
	end
	_2EKd = input
	__bQ()
	_daJM.Complete = true
	_dKN()
end
function _U7Dxp:OnGetInput(input)
	if input == nil then
		input = ""
	end
	_guK = input
	__bQ()
	_Urwigo.RunDialogs(function()
		Wherigo.GetInput(_HcQ)
	end)
end
function _HcQ:OnGetInput(input)
	if input == nil then
		input = ""
	end
	_39CG = input
	__bQ()
	_4IOtG.Complete = true
	_dKN()
end
function _QQV:On_N3TGM(target)
	_Urwigo.MessageBox{
		Text = _MtNtL("\001\080\089\029\117\100\099\080\018\029\107\005\103\029\099\080\089\029\100\092\080\089\005\103\080\029\003\080\107\034\029\099\080\089\029\042\089\099\106\089\069\005\103\080\116\029\001\107\080\029\117\195\182\099\080\018\029\005\107\018\099\029\099\055\005\029\042\089\114\080\092\018\107\005\029\099\080\005\029\063\069\005\055\079\079\080\018\041\107\089\106\080\018\005\029\031\100\018\029\114\080\100\034\100\114\107\005\047\040\080\079\029\015\069\092\005\103\089\055\103\083\029\101\080\034\107\080\019\083\029\050\034\107\079\055\083\029\117\100\099\080\018\041\055\005\005\080\089\083\029\003\107\080\089\052\029\069\018\099\029\057\019\034\055\018\046\080\018\041\080\034\103\083\029\079\080\018\005\047\040\034\107\047\040\080\089\029\003\195\164\103\107\114\106\080\107\103\029\069\018\099\029\031\080\089\019\195\188\114\092\055\089\080\089\029\063\080\107\103\116\029\001\107\080\005\080\029\043\055\106\103\100\089\080\018\029\041\080\047\040\005\080\034\018\029\031\100\018\029\093\089\103\029\046\069\029\093\089\103\116\029\001\080\005\040\055\034\092\029\114\107\092\103\029\080\005\029\107\079\029\121\015\008\029\042\034\099\080\018\055\029\055\069\047\040\029\031\107\080\034\080\029\031\080\089\005\047\040\107\080\099\080\018\055\089\103\107\114\080\018\029\117\195\182\099\080\018\116\033\022\095\044\117\101\076\013\107\047\040\103\107\114\005\103\080\018\029\042\089\106\080\018\018\069\018\114\005\079\080\089\106\079\055\034\029\099\080\089\029\117\100\099\080\018\029\107\005\103\029\099\107\080\029\002\069\005\092\107\034\099\069\018\114\029\069\018\099\029\002\092\019\100\034\114\080\029\069\018\103\080\089\005\047\040\107\080\099\034\107\047\040\029\114\080\019\195\164\089\092\103\080\089\029\117\100\099\080\018\040\100\089\107\046\100\018\103\080\083\029\099\107\080\029\031\100\018\029\100\092\080\018\029\018\055\047\040\029\069\018\103\080\018\029\099\055\005\029\117\100\099\080\018\113\089\100\019\107\034\029\092\107\034\099\080\018\116\029\117\100\099\080\018\113\089\100\019\107\034\080\029\079\107\103\029\114\034\080\107\047\040\080\018\029\100\099\080\089\029\195\164\040\018\034\107\047\040\080\018\029\124\080\089\106\079\055\034\080\029\041\080\089\099\080\018\029\107\018\029\117\100\099\080\018\103\032\113\080\018\029\046\069\005\055\079\079\080\018\114\080\019\055\005\005\103\083\029\099\107\080\029\092\080\005\103\107\079\079\103\080\029\041\107\005\005\080\018\005\047\040\055\019\103\034\107\047\040\080\029\117\080\046\080\107\047\040\018\069\018\114\080\018\029\103\089\055\114\080\018\116")
	}
end
function _QQV:On_tOF1(target)
	_Urwigo.OldDialog{
		{
			Text = _MtNtL("\117\100\099\080\018\040\100\089\107\046\100\018\103\080\029\005\107\018\099\029\117\080\089\080\107\047\040\080\029\107\018\018\080\089\040\055\034\092\029\099\080\005\029\117\100\099\080\018\005\083\029\099\107\080\029\080\107\018\040\080\107\103\034\107\047\040\029\195\164\040\018\034\107\047\040\080\029\124\080\089\106\079\055\034\080\029\069\018\099\029\042\107\114\080\018\005\047\040\055\019\103\080\018\029\092\080\005\107\103\046\080\018\029\069\018\099\029\005\107\047\040\029\031\100\018\029\099\055\089\195\188\092\080\089\034\107\080\114\080\018\099\080\018\029\100\099\080\089\029\099\055\089\069\018\103\080\089\019\100\034\114\080\018\099\080\018\029\117\080\089\080\107\047\040\080\018\029\069\018\103\080\089\005\047\040\080\107\099\080\018\116")
		}, 
		{
			Text = _MtNtL("\001\107\080\029\117\100\099\080\018\040\100\089\107\046\100\018\103\080\029\034\055\005\005\080\018\029\005\107\047\040\083\029\107\079\029\117\100\099\080\018\113\089\100\019\107\034\029\031\100\018\029\100\092\080\018\029\018\055\047\040\029\069\018\103\080\018\083\029\114\089\100\092\029\041\107\080\029\019\100\034\114\103\029\080\107\018\103\080\107\034\080\018\009\033\021\095\044\117\101\076\029\072\018\092\005\113\065\072\018\092\005\113\065\072\018\092\005\113\065\093\052\010\100\089\107\046\100\018\103\080\009\029\100\089\114\055\018\107\005\047\040\080\029\002\069\019\034\055\114\080\116\044\117\101\076\029\072\018\092\005\113\065\072\018\092\005\113\065\072\018\092\005\113\065\002\052\010\100\089\107\046\100\018\103\080\009\029\079\107\018\080\089\055\034\107\005\047\040\080\089\029\093\092\080\089\092\100\099\080\018\116\044\117\101\076\029\072\018\092\005\113\065\072\018\092\005\113\065\072\018\092\005\113\065\117\052\010\100\089\107\046\100\018\103\080\009\029\079\107\018\080\089\055\034\107\005\047\040\080\089\029\045\018\103\080\089\092\100\099\080\018\116\044\117\101\076\029\072\018\092\005\113\065\072\018\092\005\113\065\072\018\092\005\113\065\105\052\010\100\089\107\046\100\018\103\080\009\029\079\107\018\080\089\055\034\107\005\047\040\080\089\029\045\018\103\080\089\114\089\069\018\099\116\044\117\101\076"), 
			Media = _ixVA
		}, 
		{
			Text = _MtNtL("\002\069\195\159\080\089\099\080\079\029\114\107\092\103\029\080\005\029\041\080\107\103\080\089\080\029\031\100\089\055\018\114\080\005\103\080\034\034\103\080\029\117\069\047\040\005\103\055\092\080\018\029\046\069\089\029\050\080\018\018\046\080\107\047\040\018\069\018\114\029\092\080\005\100\018\099\080\089\080\089\029\057\089\100\046\080\005\005\080\029\069\018\099\029\042\107\114\080\018\005\047\040\055\019\103\080\018\083\029\099\107\080\029\018\107\047\040\103\029\099\069\089\047\040\029\099\107\080\029\117\100\099\080\018\092\107\034\099\069\018\114\029\080\018\103\005\103\055\018\099\080\018\029\005\107\018\099\083\029\069\018\099\029\079\107\103\029\089\195\182\079\107\005\047\040\080\029\063\055\040\034\080\018\029\041\107\089\099\029\080\107\018\029\046\041\080\107\103\080\029\015\047\040\107\047\040\103\029\092\080\046\080\107\047\040\018\080\103\116\029\001\107\080\029\005\080\040\080\018\029\041\080\089\099\080\018\029\041\107\089\029\019\195\188\089\029\112\080\099\080\018\029\117\100\099\080\018\103\032\113\029\114\080\018\055\069\080\089\029\055\018\005\080\040\080\018\116")
		}
	}
end
function _QQV:On_bAB(target)
	if Wherigo.NoCaseEquals(_1j8wi, _MtNtL("\114\034\080\032")) then
		_Urwigo.MessageBox{
			Text = _x3ex
		}
	elseif Wherigo.NoCaseEquals(_1j8wi, _MtNtL("\113\005\080\069\099\100")) then
		_Urwigo.MessageBox{
			Text = _MGma
		}
	elseif Wherigo.NoCaseEquals(_1j8wi, _MtNtL("\092\089\055\069\018")) then
		_Urwigo.MessageBox{
			Text = _ZOmpn
		}
	elseif Wherigo.NoCaseEquals(_1j8wi, _MtNtL("\079\100\100\089")) then
		_Urwigo.MessageBox{
			Text = _XqFjM
		}
	elseif Wherigo.NoCaseEquals(_1j8wi, _MtNtL("\106\100\034\034\069\031\107")) then
		_Urwigo.MessageBox{
			Text = _saoxs
		}
	end
end
function _QQV:On_RuCU(target)
	_Urwigo.OldDialog{
		{
			Text = _MtNtL("\102\079\029\121\015\008\029\042\034\099\080\018\055\029\099\100\079\107\018\107\080\089\080\018\029\018\195\164\005\005\080\114\080\113\089\195\164\114\103\080\029\117\195\182\099\080\018\083\029\041\100\092\080\107\029\008\089\069\018\099\041\055\005\005\080\089\029\031\080\089\005\047\040\107\080\099\080\018\080\029\003\032\113\080\018\029\031\100\018\029\121\107\080\099\080\089\079\100\100\089\092\195\182\099\080\018\029\069\018\099\029\008\034\080\032\080\018\029\069\018\099\029\015\103\055\069\041\195\164\005\005\080\089\029\057\005\080\069\099\100\114\034\080\032\080\029\113\089\195\164\114\080\018\116\029\001\107\080\029\016\080\089\103\080\107\034\069\018\114\029\099\080\089\029\117\195\182\099\080\018\029\040\195\164\018\114\080\018\029\031\100\018\029\099\080\089\029\002\069\005\113\089\195\164\114\069\018\114\029\031\100\018\029\013\055\005\005\080\089\083\029\015\069\092\005\103\089\055\103\029\069\018\099\029\101\080\034\107\080\019\029\055\092\116\029\001\055\092\080\107\029\005\113\107\080\034\103\029\092\080\005\100\018\099\080\089\005\029\099\055\005\029\117\100\099\080\018\041\055\005\005\080\089\083\029\099\080\089\080\018\029\042\089\005\047\040\080\107\018\069\018\114\005\019\100\089\079\029\031\100\018\029\015\069\092\005\103\089\055\103\029\069\018\099\029\101\080\034\107\080\019\029\114\080\005\103\080\069\080\089\103\029\041\107\089\099\083\029\080\107\018\080\029\041\080\005\080\018\103\034\107\047\040\080\029\101\100\034\034\080\116\029\117\195\182\099\080\018\029\100\040\018\080\029\010\032\099\089\100\079\100\089\113\040\107\080\079\080\089\106\079\055\034\080\029\005\107\018\099\029\055\069\019\029\106\034\080\107\018\080\029\002\089\080\055\034\080\029\092\080\114\089\080\018\046\103\116"), 
			Media = _k2va
		}, 
		{
			Text = _MtNtL("\102\018\029\099\080\018\029\015\080\018\106\080\018\029\069\018\099\029\121\107\080\099\080\089\069\018\114\080\018\083\029\079\107\103\029\114\055\018\046\112\195\164\040\089\107\114\029\040\100\040\080\079\029\008\089\069\018\099\041\055\005\005\080\089\005\103\055\018\099\083\029\040\055\092\080\018\029\005\107\047\040\029\121\107\080\099\080\089\079\100\100\089\080\029\114\080\092\107\034\099\080\103\116\029\001\107\080\029\101\080\040\092\089\069\047\040\052\003\100\089\019\080\029\005\107\018\099\029\031\080\089\092\089\080\107\103\080\103\029\031\100\018\029\079\107\018\080\089\055\034\107\005\047\040\080\018\029\055\018\103\040\089\100\113\100\114\080\018\029\055\069\019\114\080\092\089\055\047\040\103\080\018\029\117\100\099\080\018\079\055\103\080\089\107\055\034\107\080\018\029\092\080\099\080\047\106\103\116\029\001\107\080\029\055\018\114\089\080\018\046\080\018\099\080\018\029\117\080\089\080\107\047\040\080\029\099\080\089\029\015\080\018\106\080\018\029\041\080\089\099\080\018\029\031\100\018\029\008\034\080\032\080\018\029\055\069\019\029\005\055\018\099\107\114\080\018\029\100\099\080\089\029\034\080\040\079\107\114\080\018\029\015\069\092\005\103\089\055\103\080\018\029\080\107\018\114\080\018\100\079\079\080\018\116"), 
			Media = _k2va
		}, 
		{
			Text = _MtNtL("\102\018\029\099\080\018\029\103\107\080\019\005\103\080\018\029\117\080\089\080\107\047\040\080\018\029\099\100\079\107\018\107\080\089\080\018\029\008\089\069\018\099\041\055\005\005\080\089\092\195\182\099\080\018\116\029\008\034\080\032\029\069\018\099\029\057\005\080\069\099\100\114\034\080\032\080\083\029\099\107\080\029\099\069\089\047\040\029\099\107\080\029\195\156\092\080\089\034\055\114\080\089\069\018\114\029\031\100\018\029\114\089\069\018\099\052\029\069\018\099\029\005\103\055\069\041\055\005\005\080\089\092\080\080\107\018\019\034\069\005\005\103\080\018\029\117\080\089\080\107\047\040\080\018\029\080\018\103\005\103\080\040\080\018\029\019\107\018\099\080\018\029\040\107\080\089\029\019\034\195\164\047\040\080\018\040\055\019\103\080\029\016\080\089\092\089\080\107\103\069\018\114\116"), 
			Media = _k2va
		}, 
		{
			Text = _MtNtL("\117\089\055\069\018\080\089\099\080\018\029\092\107\034\099\080\018\029\005\107\047\040\029\107\018\029\015\103\055\018\099\100\089\103\080\018\029\019\089\080\107\029\031\100\018\029\008\089\069\018\099\041\055\005\005\080\089\029\041\100\029\099\080\089\029\100\092\080\089\019\034\195\164\047\040\080\018\018\055\040\080\029\010\055\069\113\103\031\080\089\041\107\103\103\080\089\069\018\114\005\092\080\089\080\107\047\040\029\107\018\029\043\100\089\079\029\080\107\018\080\089\029\092\089\055\069\080\018\029\043\195\164\089\092\069\018\114\029\046\069\079\029\016\100\089\005\047\040\080\107\018\029\106\100\079\079\080\018\029\106\055\018\018\116\029\001\080\005\040\055\034\092\029\018\080\040\079\080\018\029\117\089\055\069\018\080\089\099\080\018\029\080\107\018\029\114\080\089\107\018\114\080\018\029\002\018\103\080\107\034\029\099\080\005\029\121\015\008\029\042\034\099\080\018\055\029\080\107\018\116"), 
			Media = _k2va
		}, 
		{
			Text = _MtNtL("\001\107\080\029\121\069\103\046\069\018\114\029\099\080\089\029\014\055\018\099\005\047\040\055\019\103\029\099\069\089\047\040\029\099\080\018\029\124\080\018\005\047\040\080\018\029\019\195\188\040\089\103\080\029\046\069\089\029\041\080\107\103\080\089\080\018\029\001\107\019\019\080\089\080\018\046\107\080\089\069\018\114\029\099\080\089\029\117\100\099\080\018\099\080\047\106\080\116\029\042\005\029\092\107\034\099\080\103\080\018\029\005\107\047\040\029\042\089\100\005\107\100\018\005\052\029\069\018\099\029\002\106\106\069\079\069\034\055\103\107\100\018\005\113\089\100\019\107\034\080\116\029\043\089\195\188\040\080\089\080\029\002\047\106\080\089\018\069\103\046\069\018\114\029\041\107\089\099\029\195\188\092\080\089\029\050\100\034\034\069\031\107\055\034\092\195\182\099\080\018\029\005\107\047\040\103\092\055\089\116"), 
			Media = _k2va
		}
	}
end
function _swUX:On_ECV(target)
	_Urwigo.RunDialogs(function()
		Wherigo.GetInput(_mO9a)
	end)
end
function _swUX:On_UZHiM(target)
	_Urwigo.RunDialogs(function()
		Wherigo.GetInput(_lPYRi)
	end)
end
function _swUX:On_Ho6T(target)
	_Urwigo.RunDialogs(function()
		Wherigo.GetInput(_spgzo)
	end)
end
function _swUX:On_EsXh(target)
	_Urwigo.RunDialogs(function()
		Wherigo.GetInput(_DA6U)
	end)
end
function _swUX:On_o7Y(target)
	_Urwigo.RunDialogs(function()
		Wherigo.GetInput(_U7Dxp)
	end)
end

-- Urwigo functions --
function __bQ()
	_rrCP.Description = ((((((((((((_MtNtL("\001\069\029\040\055\005\103\029\019\100\034\114\080\018\099\080\005\029\114\080\055\018\103\041\100\089\103\080\103\009\044\117\101\076\043\089\055\114\080\029\011\055\009\029").._F7p).._MtNtL("\044\117\101\076\043\089\055\114\080\029\011\092\009\029")).._dvLDI).._MtNtL("\044\117\101\076\043\089\055\114\080\029\108\009\029")).._pwxx).._MtNtL("\044\117\101\076\043\089\055\114\080\029\022\009\029")).._9WyZ).._MtNtL("\044\117\101\076\043\089\055\114\080\029\071\009\029")).._2EKd).._MtNtL("\044\117\101\076\043\089\055\114\080\029\073\055\009\029")).._guK).._MtNtL("\044\117\101\076\043\089\055\114\080\029\073\092\009\029")).._39CG
end
function _dKN()
	if _TSKPO.Complete == true then
		if _3Yti.Complete == true then
			if _8hPJ.Complete == true then
				if _daJM.Complete == true then
					if _4IOtG.Complete == true then
						_V02gO.Complete = true
						_Urwigo.Dialog(false, {
							{
								Text = _MtNtL("\001\069\029\040\055\005\103\029\055\034\034\080\029\099\107\080\029\043\089\055\114\080\018\029\114\080\055\018\103\041\100\089\103\080\103\026\044\117\101\076\042\005\029\107\005\103\029\106\080\107\018\080\029\014\100\114\092\080\099\107\018\114\069\018\114\029\055\092\080\089\029\041\080\018\018\029\099\069\029\080\005\029\079\195\182\047\040\103\080\005\103\083\029\099\069\029\106\055\018\018\005\103\029\055\069\047\040\029\114\080\089\018\080\029\080\107\018\029\043\100\103\100\029\031\100\079\029\099\080\079\029\093\089\103\029\107\079\029\121\015\008\083\029\099\080\089\029\099\069\029\055\079\029\034\107\080\092\005\103\080\018\029\040\055\103\103\080\005\103\116\029\042\005\029\114\107\092\103\029\031\107\080\034\080\029\005\047\040\195\182\018\080\029\042\047\106\080\018\029\040\107\080\089\026\044\117\101\076\124\107\103\029\002\092\005\080\018\099\069\018\114\029\099\080\089\029\002\018\103\041\100\089\103\080\018\029\055\018\029\079\107\047\040\029\040\055\005\103\029\099\069\029\014\100\114\019\089\080\107\114\055\092\080\116\029\001\069\029\092\089\055\069\047\040\005\103\029\121\102\105\010\003\029\055\018\029\079\080\107\018\080\089\029\002\018\103\041\100\089\103\091\117\080\005\103\195\164\103\107\114\069\018\114\029\041\055\089\103\080\018\116\029\102\047\040\029\079\080\034\099\080\029\079\107\047\040\029\041\080\018\018\029\041\055\005\029\019\055\034\005\047\040\029\005\080\107\018\029\005\100\034\034\103\080\116"), 
								Media = _d4u
							}, 
							{
								Text = _MtNtL("\010\107\080\089\029\040\055\005\103\029\099\069\029\055\069\047\040\029\099\080\018\029\105\100\079\113\034\080\103\107\100\018\029\105\100\099\080\009\029")..string.sub(Player.CompletionCode, 1, 15)
							}
						}, function(action)
							_o86.Description = string.sub(Player.CompletionCode, 1, 15)
							_o86:MoveTo(Player)
						end)
					end
				end
			end
		end
	end
end

-- Begin user functions --
-- End user functions --
return _V02gO
