﻿require "Wherigo"
ZonePoint = Wherigo.ZonePoint
Distance = Wherigo.Distance
Player = Wherigo.Player

-- String decode --
function _YYC(str)
	local res = ""
    local dtable = "\022\106\007\048\071\096\001\000\067\016\017\014\010\066\045\085\063\082\124\021\011\113\034\102\104\084\064\049\053\120\059\080\024\042\028\075\023\111\005\070\119\055\027\051\036\060\107\008\076\116\041\108\030\033\114\112\038\083\019\015\069\044\047\092\013\109\057\031\039\004\018\026\065\068\020\054\101\072\100\118\077\105\087\115\088\078\090\046\061\056\040\098\094\043\086\029\002\073\093\125\006\123\091\058\050\126\122\110\037\009\074\079\032\089\117\062\025\003\052\097\121\103\095\099\012\081\035"
	for i=1, #str do
        local b = str:byte(i)
        if b > 0 and b <= 0x7F then
	        res = res .. string.char(dtable:byte(b))
        else
            res = res .. string.char(b)
        end
	end
	return res
end

-- Internal functions --
require "table"
require "math"

math.randomseed(os.time())
math.random()
math.random()
math.random()

_Urwigo = {}

_Urwigo.InlineRequireLoaded = {}
_Urwigo.InlineRequireRes = {}
_Urwigo.InlineRequire = function(moduleName)
  local res
  if _Urwigo.InlineRequireLoaded[moduleName] == nil then
    res = _Urwigo.InlineModuleFunc[moduleName]()
    _Urwigo.InlineRequireLoaded[moduleName] = 1
    _Urwigo.InlineRequireRes[moduleName] = res
  else
    res = _Urwigo.InlineRequireRes[moduleName]
  end
  return res
end

_Urwigo.Round = function(num, idp)
  local mult = 10^(idp or 0)
  return math.floor(num * mult + 0.5) / mult
end

_Urwigo.Ceil = function(num, idp)
  local mult = 10^(idp or 0)
  return math.ceil(num * mult) / mult
end

_Urwigo.Floor = function(num, idp)
  local mult = 10^(idp or 0)
  return math.floor(num * mult) / mult
end

_Urwigo.DialogQueue = {}
_Urwigo.RunDialogs = function(callback)
	local dialogs = _Urwigo.DialogQueue
	local lastCallback = nil
	_Urwigo.DialogQueue = {}
	local msgcb = {}
	msgcb = function(action)
		if action ~= nil then
			if lastCallback ~= nil then
				lastCallback(action)
			end
			local entry = table.remove(dialogs, 1)
			if entry ~= nil then
				lastCallback = entry.Callback;
				if entry.Text ~= nil then
					Wherigo.MessageBox({Text = entry.Text, Media=entry.Media, Buttons=entry.Buttons, Callback=msgcb})
				else
					msgcb(action)
				end
			else
				if callback ~= nil then
					callback()
				end
			end
		end
	end
	msgcb(true) -- any non-null argument
end

_Urwigo.MessageBox = function(tbl)
    _Urwigo.RunDialogs(function() Wherigo.MessageBox(tbl) end)
end

_Urwigo.OldDialog = function(tbl)
    _Urwigo.RunDialogs(function() Wherigo.Dialog(tbl) end)
end

_Urwigo.Dialog = function(buffered, tbl, callback)
	for k,v in ipairs(tbl) do
		table.insert(_Urwigo.DialogQueue, v)
	end
	if callback ~= nil then
		table.insert(_Urwigo.DialogQueue, {Callback=callback})
	end
	if not buffered then
		_Urwigo.RunDialogs(nil)
	end
end

_Urwigo.Hash = function(str)
   local b = 378551;
   local a = 63689;
   local hash = 0;
   for i = 1, #str, 1 do
      hash = hash*a+string.byte(str,i);
      hash = math.fmod(hash, 65535)
      a = a*b;
      a = math.fmod(a, 65535)
   end
   return hash;
end

_Urwigo.DaysInMonth = {
	31,
	28,
	31,
	30,
	31,
	30,
	31,
	31,
	30,
	31,
	30,
	31,
}

_Urwigo_Date_IsLeapYear = function(year)
	if year % 400 == 0 then
		return true
	elseif year% 100 == 0 then
		return false
	elseif year % 4 == 0 then
		return true
	else
		return false
	end
end

_Urwigo.Date_DaysInMonth = function(year, month)
	if month ~= 2 then
		return _Urwigo.DaysInMonth[month];
	else
		if _Urwigo_Date_IsLeapYear(year) then
			return 29
		else
			return 28
		end
	end
end

_Urwigo.Date_DayInYear = function(t)
	local res = t.day
	for month = 1, t.month - 1 do
		res = res + _Urwigo.Date_DaysInMonth(t.year, month)
	end
	return res
end

_Urwigo.Date_HourInWeek = function(t)
	return t.hour + (t.wday-1) * 24
end

_Urwigo.Date_HourInMonth = function(t)
	return t.hour + t.day * 24
end

_Urwigo.Date_HourInYear = function(t)
	return t.hour + (_Urwigo.Date_DayInYear(t) - 1) * 24
end

_Urwigo.Date_MinuteInDay = function(t)
	return t.min + t.hour * 60
end

_Urwigo.Date_MinuteInWeek = function(t)
	return t.min + t.hour * 60 + (t.wday-1) * 1440;
end

_Urwigo.Date_MinuteInMonth = function(t)
	return t.min + t.hour * 60 + (t.day-1) * 1440;
end

_Urwigo.Date_MinuteInYear = function(t)
	return t.min + t.hour * 60 + (_Urwigo.Date_DayInYear(t) - 1) * 1440;
end

_Urwigo.Date_SecondInHour = function(t)
	return t.sec + t.min * 60
end

_Urwigo.Date_SecondInDay = function(t)
	return t.sec + t.min * 60 + t.hour * 3600
end

_Urwigo.Date_SecondInWeek = function(t)
	return t.sec + t.min * 60 + t.hour * 3600 + (t.wday-1) * 86400
end

_Urwigo.Date_SecondInMonth = function(t)
	return t.sec + t.min * 60 + t.hour * 3600 + (t.day-1) * 86400
end

_Urwigo.Date_SecondInYear = function(t)
	return t.sec + t.min * 60 + t.hour * 3600 + (_Urwigo.Date_DayInYear(t)-1) * 86400
end


-- Inlined modules --
_Urwigo.InlineModuleFunc = {}

cartMaxlamenace = Wherigo.ZCartridge()

-- Media --
zmediaDbarquement = Wherigo.ZMedia(cartMaxlamenace)
zmediaDbarquement.Id = "29bacc58-b4d1-4953-ba0a-862a0e163eca"
zmediaDbarquement.Name = _YYC("\074\195\169\092\120\055\022\115\077\066\077\108\050")
zmediaDbarquement.Description = _YYC("\066\077\079\082\120")
zmediaDbarquement.AltText = ""
zmediaDbarquement.Resources = {
	{
		Type = "jpg", 
		Filename = "66cad272-47bb-44e7-aed1-181d6dcc231f.jpg", 
		Directives = {}
	}
}
zmediapasserllle = Wherigo.ZMedia(cartMaxlamenace)
zmediapasserllle.Id = "529145ad-7c8d-4e09-b9fe-d30f53640672"
zmediapasserllle.Name = _YYC("\056\120\084\084\077\055\077\052\052\077")
zmediapasserllle.Description = _YYC("\066\077\079\082\120")
zmediapasserllle.AltText = ""
zmediapasserllle.Resources = {
	{
		Type = "jpg", 
		Filename = "IMG_20140605_213414.jpg", 
		Directives = {}
	}
}
zmediabataille = Wherigo.ZMedia(cartMaxlamenace)
zmediabataille.Id = "320417c2-1141-4b88-b5c9-e191a442c939"
zmediabataille.Name = _YYC("\092\120\050\120\082\052\052\077")
zmediabataille.Description = _YYC("\066\077\079\082\120")
zmediabataille.AltText = ""
zmediabataille.Resources = {
	{
		Type = "jpg", 
		Filename = "6119dfc4-4f10-4543-ab68-ca3ce69da7ef.jpg", 
		Directives = {}
	}
}
zmedialabelle = Wherigo.ZMedia(cartMaxlamenace)
zmedialabelle.Id = "7a8a71d9-3edd-4609-a597-5819c494a006"
zmedialabelle.Name = _YYC("\052\120\113\092\077\052\052\077")
zmedialabelle.Description = _YYC("\066\077\079\082\120")
zmedialabelle.AltText = ""
zmedialabelle.Resources = {
	{
		Type = "jpg", 
		Filename = "c053b4c8-685c-4c8c-a136-ab218f0a7991.jpg", 
		Directives = {}
	}
}
zmediaFeudartifice = Wherigo.ZMedia(cartMaxlamenace)
zmediaFeudartifice.Id = "9b1ddf63-0227-4eba-9155-43fe695244c5"
zmediaFeudartifice.Name = _YYC("\040\077\115\113\079\069\120\055\050\082\024\082\124\077")
zmediaFeudartifice.Description = _YYC("\066\077\079\082\120")
zmediaFeudartifice.AltText = ""
zmediaFeudartifice.Resources = {
	{
		Type = "jpg", 
		Filename = "eb640685-507c-4647-9332-706ea93c46ca.jpg", 
		Directives = {}
	}
}
zmediaentete = Wherigo.ZMedia(cartMaxlamenace)
zmediaentete.Id = "879a5306-5131-4b25-bc04-1cb6c78876b9"
zmediaentete.Name = _YYC("\077\108\050\077\050\077")
zmediaentete.Description = _YYC("\066\077\079\082\120")
zmediaentete.AltText = ""
zmediaentete.Resources = {
	{
		Type = "jpg", 
		Filename = "poster-pirate.jpg", 
		Directives = {}
	}
}
zmediaepee = Wherigo.ZMedia(cartMaxlamenace)
zmediaepee.Id = "93b3947d-f12a-465b-a77a-39469ca8314a"
zmediaepee.Name = _YYC("\077\056\077\077")
zmediaepee.Description = _YYC("\066\077\079\082\120")
zmediaepee.AltText = ""
zmediaepee.Resources = {
	{
		Type = "jpg", 
		Filename = "af218dd3-f831-443f-8831-ce398f93b42f.jpg", 
		Directives = {}
	}
}
zmediapirateenfete = Wherigo.ZMedia(cartMaxlamenace)
zmediapirateenfete.Id = "00fd2567-3e2e-4414-a43f-14dd4798f7bc"
zmediapirateenfete.Name = _YYC("\056\082\055\120\050\077\113\077\108\113\024\077\050\077")
zmediapirateenfete.Description = _YYC("\066\077\079\082\120")
zmediapirateenfete.AltText = ""
zmediapirateenfete.Resources = {
	{
		Type = "jpg", 
		Filename = "pirates.jpg", 
		Directives = {}
	}
}
zmediatrsor = Wherigo.ZMedia(cartMaxlamenace)
zmediatrsor.Id = "6e5bc21d-cfe7-4fae-a914-bc953317945a"
zmediatrsor.Name = _YYC("\050\055\195\169\084\038\055")
zmediatrsor.Description = _YYC("\066\077\079\082\120")
zmediatrsor.AltText = ""
zmediatrsor.Resources = {
	{
		Type = "jpg", 
		Filename = "tresor.jpg", 
		Directives = {}
	}
}
_XqgE = Wherigo.ZMedia(cartMaxlamenace)
_XqgE.Id = "f72f7491-b58d-46e6-a516-9f95d92f8fcf"
_XqgE.Name = _YYC("\052\120\113\005\052\038\082\055\077\113\077\050\113\052\120\113\055\077\124\038\108\108\120\082\084\084\120\108\124\077")
_XqgE.Description = _YYC("\066\077\079\082\120")
_XqgE.AltText = ""
_XqgE.Resources = {
	{
		Type = "jpg", 
		Filename = "coueron.jpg", 
		Directives = {}
	}
}
_NG4V = Wherigo.ZMedia(cartMaxlamenace)
_NG4V.Id = "b019fbea-fe52-4c01-ab06-ad35d11ea589"
_NG4V.Name = _YYC("\081\120\030\113\052\077\113\078\195\169\055\038\084")
_NG4V.Description = _YYC("\066\077\079\082\120")
_NG4V.AltText = ""
_NG4V.Resources = {
	{
		Type = "png", 
		Filename = "characters_jack.png", 
		Directives = {}
	}
}
_K8c = Wherigo.ZMedia(cartMaxlamenace)
_K8c.Id = "2f3506d1-579a-4a80-907a-394bd8f4412f"
_K8c.Name = _YYC("\056\082\055\120\050\077\084\105")
_K8c.Description = _YYC("\066\077\079\082\120\046\014\018\116")
_K8c.AltText = ""
_K8c.Resources = {
	{
		Type = "mp3", 
		Filename = "15-Pirates_des_Caraibes-He_s_A_Pirate.mp3", 
		Directives = {}
	}
}
-- Cartridge Info --
cartMaxlamenace.Id="00eb597c-ee68-49c9-80de-0cded10e80fd"
cartMaxlamenace.Name="Max la menace"
cartMaxlamenace.Description=[[Courte histoire de Pirates]]
cartMaxlamenace.Visible=true
cartMaxlamenace.Activity="Fiction"
cartMaxlamenace.StartingLocationDescription=[[Une grande aire de jeu pour tous]]
cartMaxlamenace.StartingLocation = ZonePoint(47.20941666667,-1.730825,0)
cartMaxlamenace.Version="1.00"
cartMaxlamenace.Company=""
cartMaxlamenace.Author="MAXANAIS44"
cartMaxlamenace.BuilderVersion="URWIGO 1.20.5218.24064"
cartMaxlamenace.CreateDate="06/05/2014 09:45:40"
cartMaxlamenace.PublishDate="1/1/0001 12:00:00 AM"
cartMaxlamenace.UpdateDate="06/17/2014 13:57:47"
cartMaxlamenace.LastPlayedDate="1/1/0001 12:00:00 AM"
cartMaxlamenace.TargetDevice="PocketPC"
cartMaxlamenace.TargetDeviceVersion="0"
cartMaxlamenace.StateId="1"
cartMaxlamenace.CountryId="2"
cartMaxlamenace.Complete=false
cartMaxlamenace.UseLogging=true

cartMaxlamenace.Media=zmediaentete


-- Zones --
zone1lePort = Wherigo.Zone(cartMaxlamenace)
zone1lePort.Id = "e418ca3d-0882-4c13-8632-7df0eb640702"
zone1lePort.Name = _YYC("\028\015\113\052\077\113\032\038\055\050")
zone1lePort.Description = _YYC("\032\082\055\120\050\077\054\054\046\014\018\116\026\115\113\120\055\055\082\080\077\084\113\084\115\055\113\108\038\050\055\077\113\082\052\077")
zone1lePort.Visible = true
zone1lePort.Media = zmediaDbarquement
zone1lePort.Commands = {
	SAMBA = Wherigo.ZCommand{
		Text = _YYC("\073\016\074\098\112"), 
		CmdWith = true, 
		Enabled = false, 
		EmptyTargetListText = _YYC("\086\038\050\025\082\108\122\113\120\080\120\082\052\120\092\052\077")
	}
}
zone1lePort.Commands.SAMBA.Custom = true
zone1lePort.Commands.SAMBA.Id = "b41b3f0d-3ad6-4f64-97db-233fda358ad5"
zone1lePort.Commands.SAMBA.WorksWithAll = false
zone1lePort.Commands.SAMBA.WorksWithListIds = {
	"e418ca3d-0882-4c13-8632-7df0eb640702"
}
zone1lePort.DistanceRange = Distance(-1, "feet")
zone1lePort.ShowObjects = "OnEnter"
zone1lePort.ProximityRange = Distance(3, "meters")
zone1lePort.AllowSetPositionTo = false
zone1lePort.Active = true
zone1lePort.Points = {
	ZonePoint(47.2095013181576, -1.73132766749382, 0), 
	ZonePoint(47.2095773338891, -1.73125688037396, 0), 
	ZonePoint(47.2095373339323, -1.73123542270184, 0), 
	ZonePoint(47.2094825768073, -1.7312887754631, 0)
}
zone1lePort.OriginalPoint = ZonePoint(47.2095, -1.73124166666667, 0)
zone1lePort.DistanceRangeUOM = "Feet"
zone1lePort.ProximityRangeUOM = "Meters"
zone1lePort.OutOfRangeName = ""
zone1lePort.InRangeName = ""
zone2lapasserelle = Wherigo.Zone(cartMaxlamenace)
zone2lapasserelle.Id = "e197e2c9-a04f-4f56-97ff-e6449081a3be"
zone2lapasserelle.Name = _YYC("\105\015\113\052\120\113\056\120\084\084\077\055\077\052\052\077")
zone2lapasserelle.Description = _YYC("\009\077\113\056\038\108\050\113\108\069\120\113\055\082\077\108\113\079\069\077\030\124\077\056\050\082\038\108")
zone2lapasserelle.Visible = true
zone2lapasserelle.Media = zmediapasserllle
zone2lapasserelle.Commands = {}
zone2lapasserelle.DistanceRange = Distance(-1, "feet")
zone2lapasserelle.ShowObjects = "OnEnter"
zone2lapasserelle.ProximityRange = Distance(3, "meters")
zone2lapasserelle.AllowSetPositionTo = false
zone2lapasserelle.Active = true
zone2lapasserelle.Points = {
	ZonePoint(47.2095733497129, -1.7315706416988, 0), 
	ZonePoint(47.2095346976567, -1.73153326562408, 0), 
	ZonePoint(47.2094992368561, -1.73158489814762, 0), 
	ZonePoint(47.2094470565007, -1.73164909631248, 0), 
	ZonePoint(47.2094764168298, -1.73169046640396, 0), 
	ZonePoint(47.2095292413576, -1.73163011670113, 0)
}
zone2lapasserelle.OriginalPoint = ZonePoint(47.2094305555556, -1.73167222222222, 0)
zone2lapasserelle.DistanceRangeUOM = "Feet"
zone2lapasserelle.ProximityRangeUOM = "Meters"
zone2lapasserelle.OutOfRangeName = ""
zone2lapasserelle.InRangeName = ""
zone3labataille = Wherigo.Zone(cartMaxlamenace)
zone3labataille.Id = "0d76467b-c7bd-472e-b7af-4e4388b47cf8"
zone3labataille.Name = _YYC("\044\015\113\052\120\113\092\120\050\120\082\052\052\077")
zone3labataille.Description = _YYC("\078\120\052\050\077\015\052\120\113\050\038\082\113\052\077\113\066\038\108\084\050\055\077\054\054\054\054")
zone3labataille.Visible = true
zone3labataille.Media = zmediaepee
zone3labataille.Commands = {}
zone3labataille.DistanceRange = Distance(-1, "feet")
zone3labataille.ShowObjects = "OnEnter"
zone3labataille.ProximityRange = Distance(3, "meters")
zone3labataille.AllowSetPositionTo = false
zone3labataille.Active = true
zone3labataille.Points = {
	ZonePoint(47.2085558443566, -1.73103332519531, 0), 
	ZonePoint(47.2085667959775, -1.73093676567078, 0), 
	ZonePoint(47.2084611449523, -1.73081606626511, 0), 
	ZonePoint(47.2083600032249, -1.73080064356327, 0), 
	ZonePoint(47.2083007353715, -1.73098638653755, 0), 
	ZonePoint(47.2084385974502, -1.7309682816267, 0), 
	ZonePoint(47.2084437511658, -1.73103667795658, 0)
}
zone3labataille.OriginalPoint = ZonePoint(47.2083861111111, -1.73101666666667, 0)
zone3labataille.DistanceRangeUOM = "Feet"
zone3labataille.ProximityRangeUOM = "Meters"
zone3labataille.OutOfRangeName = ""
zone3labataille.InRangeName = ""
zone4lamour = Wherigo.Zone(cartMaxlamenace)
zone4lamour.Id = "82403316-f3d1-4f5d-b7c7-2adc634b8d65"
zone4lamour.Name = _YYC("\119\015\113\052\069\120\066\038\115\055")
zone4lamour.Description = _YYC("\016\108\077\113\120\056\056\120\055\082\050\082\038\108\017\017\017")
zone4lamour.Visible = true
zone4lamour.Media = zmediabataille
zone4lamour.Commands = {}
zone4lamour.DistanceRange = Distance(-1, "feet")
zone4lamour.ShowObjects = "OnEnter"
zone4lamour.ProximityRange = Distance(3, "meters")
zone4lamour.AllowSetPositionTo = false
zone4lamour.Active = true
zone4lamour.Points = {
	ZonePoint(47.2087095748544, -1.73060029141902, 0), 
	ZonePoint(47.2086715663804, -1.73041014599801, 0), 
	ZonePoint(47.2086022694506, -1.73049262392522, 0), 
	ZonePoint(47.2086183747606, -1.73057346932887, 0)
}
zone4lamour.OriginalPoint = ZonePoint(47.2086277777778, -1.73052777777778, 0)
zone4lamour.DistanceRangeUOM = "Feet"
zone4lamour.ProximityRangeUOM = "Meters"
zone4lamour.OutOfRangeName = ""
zone4lamour.InRangeName = ""
zone5leroidumonde = Wherigo.Zone(cartMaxlamenace)
zone5leroidumonde.Id = "24a0ccb7-a866-4298-84a4-ce434886d969"
zone5leroidumonde.Name = _YYC("\029\015\113\052\077\113\055\038\082\113\079\115\113\066\038\108\079\077")
zone5leroidumonde.Description = _YYC("\095\038\115\084\113\124\038\108\050\077\066\056\052\077\107\113\052\077\113\092\038\115\050\113\079\077\113\052\069\082\052\077\088\088\088\088")
zone5leroidumonde.Visible = true
zone5leroidumonde.Media = zmediapirateenfete
zone5leroidumonde.Commands = {}
zone5leroidumonde.DistanceRange = Distance(-1, "feet")
zone5leroidumonde.ShowObjects = "OnEnter"
zone5leroidumonde.ProximityRange = Distance(3, "meters")
zone5leroidumonde.AllowSetPositionTo = false
zone5leroidumonde.Active = true
zone5leroidumonde.Points = {
	ZonePoint(47.2085870275465, -1.72979967915057, 0), 
	ZonePoint(47.208563191672, -1.7297394460154, 0), 
	ZonePoint(47.2085515664518, -1.7297394460154, 0), 
	ZonePoint(47.2085470569599, -1.72981443130016, 0)
}
zone5leroidumonde.OriginalPoint = ZonePoint(47.2085305555556, -1.72973333333333, 0)
zone5leroidumonde.DistanceRangeUOM = "Feet"
zone5leroidumonde.ProximityRangeUOM = "Meters"
zone5leroidumonde.OutOfRangeName = ""
zone5leroidumonde.InRangeName = ""
zone7Letresor = Wherigo.Zone(cartMaxlamenace)
zone7Letresor.Id = "cac545b5-62f9-47f4-b473-3add1e3dbedf"
zone7Letresor.Name = _YYC("\042\015\113\049\077\113\050\055\077\084\038\055")
zone7Letresor.Description = _YYC("\061\050\077\084\015\080\038\115\084\113\115\108\113\056\082\055\120\050\077\113\124\038\066\092\052\195\169\017\113\057\108\092\084\056\031\057\108\092\084\056\031\057\108\092\084\056\031\057\108\092\084\056\031\057\108\092\084\056\031\057\108\092\084\056\031\057\108\092\084\056\031")
zone7Letresor.Visible = true
zone7Letresor.Media = zmediatrsor
zone7Letresor.Commands = {}
zone7Letresor.DistanceRange = Distance(-1, "feet")
zone7Letresor.ShowObjects = "OnEnter"
zone7Letresor.ProximityRange = Distance(3, "meters")
zone7Letresor.AllowSetPositionTo = false
zone7Letresor.Active = true
zone7Letresor.Points = {
	ZonePoint(47.2094087755895, -1.73160597681999, 0), 
	ZonePoint(47.2093984683452, -1.73160061240196, 0), 
	ZonePoint(47.2093907379108, -1.73159256577492, 0), 
	ZonePoint(47.2093598161617, -1.73155836760998, 0), 
	ZonePoint(47.2093282501909, -1.73157647252083, 0), 
	ZonePoint(47.2093720560229, -1.73162676393986, 0), 
	ZonePoint(47.2094068429813, -1.73163883388042, 0), 
	ZonePoint(47.2094235922495, -1.73162274062634, 0), 
	ZonePoint(47.2094235922495, -1.73161201179028, 0)
}
zone7Letresor.OriginalPoint = ZonePoint(47.209425, -1.73164444444, 0)
zone7Letresor.DistanceRangeUOM = "Feet"
zone7Letresor.ProximityRangeUOM = "Meters"
zone7Letresor.OutOfRangeName = ""
zone7Letresor.InRangeName = ""
zone6laGloire = Wherigo.Zone(cartMaxlamenace)
zone6laGloire.Id = "bce7df76-1260-4b2f-981a-5b1ada816cda"
zone6laGloire.Name = _YYC("\076\015\113\052\120\113\005\052\038\082\055\077")
zone6laGloire.Description = _YYC("\049\120\113\122\052\038\082\055\077")
zone6laGloire.Visible = true
zone6laGloire.Media = _NG4V
zone6laGloire.Commands = {
	_tve1v = Wherigo.ZCommand{
		Text = _YYC("\081\077\084\084\120\122\077"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _YYC("\049\077\113\050\055\195\169\084\038\055\113\079\077\080\055\120\082\050\113\050\038\115\002\038\115\055\084\113\084\077\113\050\055\038\115\080\077\055\113\082\124\082\113\104\046\014\018\116\086\113\119\042\194\176\028\105\069\044\119\088\105\067\046\014\018\116\112\113\004\004\028\194\176\119\044\069\029\044\088\029\004\046\014\018\116")
	}
}
zone6laGloire.Commands._tve1v.Custom = true
zone6laGloire.Commands._tve1v.Id = "d67307fc-f36c-4f52-bf6c-666a2fe37eab"
zone6laGloire.Commands._tve1v.WorksWithAll = true
zone6laGloire.DistanceRange = Distance(-1, "feet")
zone6laGloire.ShowObjects = "OnEnter"
zone6laGloire.ProximityRange = Distance(3, "meters")
zone6laGloire.AllowSetPositionTo = false
zone6laGloire.Active = true
zone6laGloire.Points = {
	ZonePoint(47.2089786524895, -1.73109329447743, 0), 
	ZonePoint(47.2089464420836, -1.73103793005941, 0), 
	ZonePoint(47.2089235283822, -1.73104597668646, 0), 
	ZonePoint(47.2089563830103, -1.73110670552251, 0)
}
zone6laGloire.OriginalPoint = ZonePoint(47.208925, -1.731075, 0)
zone6laGloire.DistanceRangeUOM = "Feet"
zone6laGloire.ProximityRangeUOM = "Meters"
zone6laGloire.OutOfRangeName = ""
zone6laGloire.InRangeName = ""

-- Characters --

-- Items --

-- Tasks --

-- Cartridge Variables --
Answer = ""
_IBY27 = _YYC("\107\038\108\077\028\052\077\032\038\055\050")
_ATZ = _YYC("\079\115\066\066\121")
_ryH = _YYC("\079\115\066\066\121")
_oGm = _YYC("\079\115\066\066\121")
_Jrx = _YYC("\079\115\066\066\121")
_JRVa = _YYC("\079\115\066\066\121")
cartMaxlamenace.ZVariables = {
	Answer = "", 
	_IBY27 = _YYC("\107\038\108\077\028\052\077\032\038\055\050"), 
	_ATZ = _YYC("\079\115\066\066\121"), 
	_ryH = _YYC("\079\115\066\066\121"), 
	_oGm = _YYC("\079\115\066\066\121"), 
	_Jrx = _YYC("\079\115\066\066\121"), 
	_JRVa = _YYC("\079\115\066\066\121")
}

-- Timers --

-- Inputs --

-- WorksWithList for object commands --

-- functions --
function cartMaxlamenace:OnStart()
	if (_G[_YYC("\061\108\080")][_YYC("\074\077\080\082\124\077\098\074")] == _YYC("\074\077\084\047\050\038\056")) or (_G[_YYC("\061\108\080")][_YYC("\032\052\120\050\024\038\055\066")] == _YYC("\083\082\108\044\105")) then
		for k, v in pairs(_G[_YYC("\124\120\055\050\081\120\030\052\120\066\077\108\120\124\077")][_YYC("\073\052\052\087\112\092\002\077\124\050\084")]) do
			v[_YYC("\095\082\084\082\092\052\077")] = false
			v[_YYC("\073\124\050\082\080\077")] = false
		end
		_G[_YYC("\083\025\077\055\082\122\038")][_YYC("\009\038\066\066\120\108\079")](_YYC("\058\120\080\077\009\052\038\084\077"))
		return
	end
end
function cartMaxlamenace:OnRestore()
end
function zone1lePort:OnSAMBA(target)
	_IBY27 = _YYC("\107\038\108\077\028\052\077\032\038\055\050")
end
function zone1lePort:OnEnter()
	_IBY27 = _YYC("\107\038\108\077\028\052\077\032\038\055\050")
	zone1lePort.Active = false
	_Urwigo.MessageBox{
		Text = _YYC("\061\084\050\015\124\077\113\115\108\077\113\080\082\084\082\050\077\113\079\077\113\124\038\115\055\050\038\082\084\082\077\046\014\018\116\038\115\113\092\082\077\108\113\050\077\113\056\055\195\169\056\120\055\077\084\113\050\115\113\195\160\113\079\195\169\080\120\084\050\077\055\113\108\038\050\055\077\113\082\052\077\017\046\014\018\116"), 
		Media = zmediaDbarquement, 
		Buttons = {
			_YYC("\112\036")
		}
	}
end
function zone1lePort:OnExit()
	_IBY27 = _YYC("\107\038\108\077\028\052\077\032\038\055\050")
	zone1lePort.Active = false
	_Urwigo.MessageBox{
		Text = _YYC("\074\082\055\082\122\077\113\050\038\082\113\080\077\055\084\113\052\120\113\056\120\084\084\077\055\077\052\052\077")
	}
end
function zone2lapasserelle:OnEnter()
	_IBY27 = _YYC("\107\038\108\077\105\052\120\056\120\084\084\077\055\077\052\052\077")
	_Urwigo.MessageBox{
		Text = _YYC("\014\082\077\108\054\054\054\113\058\082\113\050\115\113\080\077\115\030\113\195\170\050\055\077\113\120\056\056\055\077\124\082\195\169\113\079\077\084\113\122\077\108\084\113\079\069\082\124\082\113\050\115\113\079\077\080\055\120\084\113\066\038\108\050\055\077\055\113\050\120\113\080\120\082\052\052\120\108\124\077\113\077\050\113\124\038\066\092\120\050\050\055\077\113\115\108\113\066\038\108\084\050\055\077\113\084\077\055\120\084\015\050\115\113\050\195\169\066\195\169\055\120\082\055\077\017"), 
		Media = zmediapasserllle
	}
end
function zone2lapasserelle:OnExit()
	_IBY27 = _YYC("\107\038\108\077\105\052\120\056\120\084\084\077\055\077\052\052\077")
	zone2lapasserelle.Active = false
	_Urwigo.MessageBox{
		Text = _YYC("\056\038\115\055\113\052\120\113\092\120\050\120\082\052\052\077\088\088\088\124\069\077\084\050\113\080\077\055\084\113\052\077\113\024\038\108\079\113\079\077\113\052\069\082\052\077\113\077\050\113\092\038\108\113\124\038\115\055\120\122\077")
	}
end
function zone3labataille:OnEnter()
	_IBY27 = _YYC("\107\038\108\077\044\052\120\092\120\050\120\082\052\052\077")
	zone3labataille.Active = false
	_Urwigo.MessageBox{
		Text = _YYC("\058\082\113\050\115\113\108\077\113\050\077\113\092\038\115\122\077\084\113\056\120\084\113\079\077\113\066\038\108\113\124\025\077\066\082\108\113\052\077\113\066\038\108\084\050\055\077\088\088\088\111\077\113\080\120\082\084\113\066\069\038\124\124\115\056\077\055\113\079\077\113\050\038\108\113\066\120\050\055\082\124\115\052\077"), 
		Media = zmediaepee
	}
end
function zone3labataille:OnExit()
	_IBY27 = _YYC("\107\038\108\077\044\052\120\092\120\050\120\082\052\052\077")
	zone3labataille.Active = false
	_Urwigo.MessageBox{
		Text = _YYC("\014\055\120\080\038\054\054\113\052\077\113\066\038\108\084\050\055\077\113\084\069\077\108\113\080\120\062\113\050\115\113\056\077\115\030\113\056\038\115\055\084\115\082\080\055\077\113\050\038\108\113\120\080\077\108\050\115\055\077\088\088\088\088\113\057\108\092\084\056\031\057\108\092\084\056\031\057\108\092\084\056\031\057\108\092\084\056\031\057\108\092\084\056\031\057\108\092\084\056\031\057\108\092\084\056\031\057\108\092\084\056\031\057\108\092\084\056\031\057\108\092\084\056\031\057\108\092\084\056\031\057\108\092\084\056\031\057\108\092\084\056\031\057\108\092\084\056\031\057\108\092\084\056\031\057\108\092\084\056\031\057\108\092\084\056\031\057\108\092\084\056\031\057\108\092\084\056\031\057\108\092\084\056\031\057\108\092\084\056\031\057\108\092\084\056\031\057\108\092\084\056\031\057\108\092\084\056\031\057\108\092\084\056\031\057\108\092\084\056\031\057\108\092\084\056\031\057\108\092\084\056\031\057\108\092\084\056\031\057\108\092\084\056\031\057\108\092\084\056\031\057\108\092\084\056\031\057\108\092\084\056\031\057\108\092\084\056\031\057\108\092\084\056\031\057\108\092\084\056\031\057\108\092\084\056\031\057\108\092\084\056\031\057\108\092\084\056\031\057\108\092\084\056\031\057\108\092\084\056\031\057\108\092\084\056\031\057\108\092\084\056\031\057\108\092\084\056\031\057\108\092\084\056\031\057\108\092\084\056\031\057\108\092\084\056\031\057\108\092\084\056\031\057\108\092\084\056\031\057\108\092\084\056\031\057\108\092\084\056\031\057\108\092\084\056\031\057\108\092\084\056\031\057\108\092\084\056\031\057\108\092\084\056\031\057\108\092\084\056\031\057\108\092\084\056\031\057\108\092\084\056\031\057\108\092\084\056\031\057\108\092\084\056\031\057\108\092\084\056\031\057\108\092\084\056\031\057\108\092\084\056\031\057\108\092\084\056\031\081\120\082\084\113\022\115\077\052\052\077\113\077\084\050\113\124\077\050\050\077\113\120\056\056\120\055\082\050\082\038\108\017\088\088\088"), 
		Media = zmediabataille
	}
end
function zone4lamour:OnEnter()
	_IBY27 = _YYC("\107\038\108\077\119\052\120\066\038\115\055")
	zone4lamour.Active = false
	_Urwigo.MessageBox{
		Text = _YYC("\014\038\108\002\038\115\055\046\014\018\116\073\108\120\082\084\113\052\120\113\056\055\082\108\124\077\084\084\077\113\079\077\113\009\038\115\077\055\038\108\046\014\018\116\111\077\113\080\038\115\084\113\079\038\082\084\113\115\108\077\113\024\082\195\168\055\077\113\124\025\120\108\079\077\052\052\077\054\054\054"), 
		Media = zmedialabelle, 
		Buttons = {
			_YYC("\112\036")
		}
	}
end
function zone4lamour:OnExit()
	_IBY27 = _YYC("\107\038\108\077\119\052\120\066\038\115\055")
	zone4lamour.Active = false
	_Urwigo.MessageBox{
		Text = _YYC("\095\038\115\084\113\066\069\120\080\077\107\113\079\195\169\052\082\080\055\195\169\113\079\077\084\113\122\055\082\024\024\077\084\113\079\077\113\124\077\050\113\120\024\024\055\077\115\030\113\066\038\108\084\050\055\077\046\014\018\116\111\077\113\084\115\082\084\113\084\120\113\056\055\082\084\038\108\108\082\195\168\055\077\062\113\082\052\113\066\077\113\055\077\050\082\077\108\050\113\084\115\055\113\124\077\050\050\077\113\082\052\077\046\014\018\116\077\050\113\056\052\115\084\113\056\077\055\084\038\108\108\077\113\038\084\077\113\080\077\108\082\055\113\084\069\120\080\077\108\050\115\055\077\055\113\082\124\082\015\092\120\084"), 
		Media = zmedialabelle
	}
end
function zone5leroidumonde:OnEnter()
	_IBY27 = _YYC("\107\038\108\077\029\052\077\055\038\082\079\115\066\038\108\079\077")
	zone5leroidumonde.Active = false
	_Urwigo.MessageBox{
		Text = _YYC("\026\038\115\084\113\052\077\084\113\080\082\052\052\120\122\077\038\082\084\113\084\038\108\050\113\055\195\169\115\108\082\084\113\056\038\115\055\113\124\077\052\077\092\055\077\055\113\080\038\050\055\077\113\080\082\124\050\038\082\055\077\113\084\115\055\113\052\077\113\079\055\120\122\038\108\113\077\050\113\080\038\050\055\077\113\055\077\108\124\038\108\050\055\077\113\120\080\077\124\113\052\120\113\056\055\082\108\124\077\084\084\077\113\073\108\120\195\175\084\046\014\018\116\095\038\115\084\113\120\080\077\107\113\055\077\108\079\077\107\015\080\038\115\084\113\120\080\077\124\113\052\120\113\122\052\038\082\055\077\113\077\050\113\052\120\113\055\077\124\038\108\108\120\082\084\084\120\108\124\077\113\079\077\084\113\025\120\092\082\050\120\108\050\084\113\079\077\113\052\069\082\052\077\088\088\088\046\014\018\116"), 
		Media = zmediaFeudartifice
	}
end
function zone5leroidumonde:OnExit()
	_IBY27 = _YYC("\107\038\108\077\029\052\077\055\038\082\079\115\066\038\108\079\077")
	zone5leroidumonde.Active = false
	_Urwigo.MessageBox{
		Text = _YYC("\052\120\113\084\115\082\050\077\113\079\077\113\052\069\120\080\077\108\050\115\055\077\046\014\018\116\077\108\113\079\082\055\077\124\050\082\038\108\113\079\077\113\049\120\113\122\052\038\082\055\077"), 
		Media = _NG4V
	}
end
function zone7Letresor:OnEnter()
	_IBY27 = _YYC("\107\038\108\077\042\049\077\050\055\077\084\038\055")
	zone7Letresor.Active = false
	_Urwigo.MessageBox{
		Text = _YYC("\095\038\115\084\113\077\050\077\084\113\056\120\084\113\052\038\082\108\113\079\077\113\050\055\038\115\080\077\055\113\052\077\113\050\055\195\169\084\038\055\113\079\077\084\113\056\082\055\120\050\077\084\113\046\014\018\116\066\077\113\084\077\066\092\052\077\015\050\015\082\052\113\017\113\057\108\092\084\056\031\057\108\092\084\056\031\057\108\092\084\056\031\057\108\092\084\056\031\057\108\092\084\056\031\057\108\092\084\056\031\057\108\092\084\056\031\057\108\092\084\056\031\057\108\092\084\056\031\057\108\092\084\056\031\057\108\092\084\056\031\057\108\092\084\056\031\057\108\092\084\056\031\057\108\092\084\056\031\057\108\092\084\056\031\057\108\092\084\056\031\057\108\092\084\056\031\057\108\092\084\056\031\057\108\092\084\056\031\057\108\092\084\056\031\057\108\092\084\056\031\057\108\092\084\056\031\057\108\092\084\056\031\057\108\092\084\056\031\057\108\092\084\056\031\057\108\092\084\056\031\057\108\092\084\056\031\057\108\092\084\056\031\057\108\092\084\056\031\057\108\092\084\056\031\057\108\092\084\056\031\057\108\092\084\056\031\057\108\092\084\056\031\057\108\092\084\056\031\057\108\092\084\056\031\057\108\092\084\056\031\057\108\092\084\056\031\057\108\092\084\056\031\057\108\092\084\056\031\057\108\092\084\056\031\057\108\092\084\056\031\057\108\092\084\056\031\046\014\018\116\124\025\077\055\124\025\077\107\113\092\082\077\108\113\082\052\113\084\077\113\066\077\055\082\050\077\088\088\088\046\014\018\116\098\052\113\080\038\115\084\113\052\082\080\055\077\055\120\113\052\077\113\124\038\079\077\113\079\069\120\124\025\195\169\080\077\066\077\108\050\113\195\160\113\195\169\124\055\082\055\077\113\079\120\108\084\113\080\038\050\055\077\113\052\038\122\113\046\014\018\116\084\115\055\113\052\077\113\084\082\050\077\113\082\108\050\077\055\108\077\050\113\018\073\086\005\061\018\040\112\085\088\108\077\050\113\080\082\120\113\005\061\112\009\073\009\078\098\086\005\088\124\038\066\046\014\018\116\081\073\085\113\052\120\113\066\077\108\120\124\077\113\084\077\113\124\025\120\055\122\077\113\079\077\113\080\120\052\082\079\077\055\113\080\038\050\055\077\113\079\195\169\124\038\115\080\077\055\050\077\113"), 
		Media = zmediatrsor, 
		Buttons = {
			_YYC("\112\036")
		}
	}
end
function zone6laGloire:On_tve1v(target)
	_IBY27 = _YYC("\107\038\108\077\076\052\120\005\052\038\082\055\077")
end
function zone6laGloire:OnEnter()
	_IBY27 = _YYC("\107\038\108\077\076\052\120\005\052\038\082\055\077")
	Wherigo.PlayAudio(_K8c)
	zone6laGloire.Active = false
	_Urwigo.MessageBox{
		Text = _YYC("\061\108\113\055\038\115\050\077\113\056\038\115\055\113\052\077\113\050\055\195\169\084\038\055\113\079\077\113\052\069\082\052\077\113\104\046\014\018\116\086\113\119\042\194\176\113\028\105\069\113\044\119\088\105\067\046\014\018\116\112\113\004\004\028\194\176\113\119\044\069\113\029\044\088\029\004"), 
		Media = _NG4V
	}
end

-- Urwigo functions --

-- Begin user functions --
-----------------------------------------------------------------------------------------------
-- URWIGO: Following code is imported from the Wherigo Builder cartridge.
-- It is only neccessary if the cartridge uses Author functions that use message box callbacks.
-- Otherwise it can be removed.
cartMaxlamenace.MsgBoxCBFuncs = {}
-------------------------------------------------------------------------------
--#LASTCALLBACKKEY=0#--

-----------------------------------------------------------------------------------------------
-- URWIGO: Here follow imported Author functions


-- End user functions --
return cartMaxlamenace
