require "Wherigo"
ZonePoint = Wherigo.ZonePoint
Distance = Wherigo.Distance
Player = Wherigo.Player

-- String decode --
function _TQt(str)
	local res = ""
    local dtable = "\114\023\004\030\013\095\089\021\109\036\096\009\049\000\107\100\069\010\086\039\028\097\108\085\113\020\063\041\115\112\126\082\081\059\075\090\066\001\026\092\062\093\044\057\008\120\068\087\101\077\019\123\074\079\045\122\048\035\002\088\054\104\084\025\007\078\067\053\071\047\037\110\111\018\118\098\102\099\031\029\027\032\072\094\034\121\070\080\012\117\005\052\065\046\050\043\064\024\014\116\011\091\058\076\042\006\125\056\060\022\119\055\073\017\124\106\061\016\040\103\003\033\015\051\038\083\105"
	for i=1, #str do
        local b = str:byte(i)
        if b > 0 and b <= 0x7F then
	        res = res .. string.char(dtable:byte(b))
        else
            res = res .. string.char(b)
        end
	end
	return res
end

-- Internal functions --
require "table"
require "math"

math.randomseed(os.time())
math.random()
math.random()
math.random()

_Urwigo = {}

_Urwigo.InlineRequireLoaded = {}
_Urwigo.InlineRequireRes = {}
_Urwigo.InlineRequire = function(moduleName)
  local res
  if _Urwigo.InlineRequireLoaded[moduleName] == nil then
    res = _Urwigo.InlineModuleFunc[moduleName]()
    _Urwigo.InlineRequireLoaded[moduleName] = 1
    _Urwigo.InlineRequireRes[moduleName] = res
  else
    res = _Urwigo.InlineRequireRes[moduleName]
  end
  return res
end

_Urwigo.Round = function(num, idp)
  local mult = 10^(idp or 0)
  return math.floor(num * mult + 0.5) / mult
end

_Urwigo.Ceil = function(num, idp)
  local mult = 10^(idp or 0)
  return math.ceil(num * mult) / mult
end

_Urwigo.Floor = function(num, idp)
  local mult = 10^(idp or 0)
  return math.floor(num * mult) / mult
end

_Urwigo.DialogQueue = {}
_Urwigo.RunDialogs = function(callback)
	local dialogs = _Urwigo.DialogQueue
	local lastCallback = nil
	_Urwigo.DialogQueue = {}
	local msgcb = {}
	msgcb = function(action)
		if action ~= nil then
			if lastCallback ~= nil then
				lastCallback(action)
			end
			local entry = table.remove(dialogs, 1)
			if entry ~= nil then
				lastCallback = entry.Callback;
				if entry.Text ~= nil then
					Wherigo.MessageBox({Text = entry.Text, Media=entry.Media, Buttons=entry.Buttons, Callback=msgcb})
				else
					msgcb(action)
				end
			else
				if callback ~= nil then
					callback()
				end
			end
		end
	end
	msgcb(true) -- any non-null argument
end

_Urwigo.MessageBox = function(tbl)
    _Urwigo.RunDialogs(function() Wherigo.MessageBox(tbl) end)
end

_Urwigo.OldDialog = function(tbl)
    _Urwigo.RunDialogs(function() Wherigo.Dialog(tbl) end)
end

_Urwigo.Dialog = function(buffered, tbl, callback)
	for k,v in ipairs(tbl) do
		table.insert(_Urwigo.DialogQueue, v)
	end
	if callback ~= nil then
		table.insert(_Urwigo.DialogQueue, {Callback=callback})
	end
	if not buffered then
		_Urwigo.RunDialogs(nil)
	end
end

_Urwigo.Hash = function(str)
   local b = 378551;
   local a = 63689;
   local hash = 0;
   for i = 1, #str, 1 do
      hash = hash*a+string.byte(str,i);
      hash = math.fmod(hash, 65535)
      a = a*b;
      a = math.fmod(a, 65535)
   end
   return hash;
end

_Urwigo.DaysInMonth = {
	31,
	28,
	31,
	30,
	31,
	30,
	31,
	31,
	30,
	31,
	30,
	31,
}

_Urwigo_Date_IsLeapYear = function(year)
	if year % 400 == 0 then
		return true
	elseif year% 100 == 0 then
		return false
	elseif year % 4 == 0 then
		return true
	else
		return false
	end
end

_Urwigo.Date_DaysInMonth = function(year, month)
	if month ~= 2 then
		return _Urwigo.DaysInMonth[month];
	else
		if _Urwigo_Date_IsLeapYear(year) then
			return 29
		else
			return 28
		end
	end
end

_Urwigo.Date_DayInYear = function(t)
	local res = t.day
	for month = 1, t.month - 1 do
		res = res + _Urwigo.Date_DaysInMonth(t.year, month)
	end
	return res
end

_Urwigo.Date_HourInWeek = function(t)
	return t.hour + (t.wday-1) * 24
end

_Urwigo.Date_HourInMonth = function(t)
	return t.hour + t.day * 24
end

_Urwigo.Date_HourInYear = function(t)
	return t.hour + (_Urwigo.Date_DayInYear(t) - 1) * 24
end

_Urwigo.Date_MinuteInDay = function(t)
	return t.min + t.hour * 60
end

_Urwigo.Date_MinuteInWeek = function(t)
	return t.min + t.hour * 60 + (t.wday-1) * 1440;
end

_Urwigo.Date_MinuteInMonth = function(t)
	return t.min + t.hour * 60 + (t.day-1) * 1440;
end

_Urwigo.Date_MinuteInYear = function(t)
	return t.min + t.hour * 60 + (_Urwigo.Date_DayInYear(t) - 1) * 1440;
end

_Urwigo.Date_SecondInHour = function(t)
	return t.sec + t.min * 60
end

_Urwigo.Date_SecondInDay = function(t)
	return t.sec + t.min * 60 + t.hour * 3600
end

_Urwigo.Date_SecondInWeek = function(t)
	return t.sec + t.min * 60 + t.hour * 3600 + (t.wday-1) * 86400
end

_Urwigo.Date_SecondInMonth = function(t)
	return t.sec + t.min * 60 + t.hour * 3600 + (t.day-1) * 86400
end

_Urwigo.Date_SecondInYear = function(t)
	return t.sec + t.min * 60 + t.hour * 3600 + (_Urwigo.Date_DayInYear(t)-1) * 86400
end


-- Inlined modules --
_Urwigo.InlineModuleFunc = {}

_pISt2 = Wherigo.ZCartridge()

-- Media --
_3V7M = Wherigo.ZMedia(_pISt2)
_3V7M.Id = "4e49454b-bb99-4616-ac5c-2b1631cee14f"
_3V7M.Name = _TQt("\127\078\073\072\082\087\127\001\049\029\100\073\072\049\029")
_3V7M.Description = ""
_3V7M.AltText = ""
_3V7M.Resources = {
	{
		Type = "jpg", 
		Filename = "iconFirestones.jpg", 
		Directives = {}
	}
}
__Kf = Wherigo.ZMedia(_pISt2)
__Kf.Id = "6266c995-e662-43ea-8c18-22295cff2b64"
__Kf.Name = _TQt("\127\078\073\072\082\087\073\001\009\073\029")
__Kf.Description = ""
__Kf.AltText = ""
__Kf.Resources = {
	{
		Type = "jpg", 
		Filename = "iconFormos.jpg", 
		Directives = {}
	}
}
_oeM = Wherigo.ZMedia(_pISt2)
_oeM.Id = "b84e3327-2a87-4702-b530-9fcf57847609"
_oeM.Name = _TQt("\127\078\073\072\082\083\073\023\073\078\001\073\072")
_oeM.Description = ""
_oeM.AltText = ""
_oeM.Resources = {
	{
		Type = "jpg", 
		Filename = "iconHolocron.jpg", 
		Directives = {}
	}
}
_8fmSi = Wherigo.ZMedia(_pISt2)
_8fmSi.Id = "bb74ac13-7d32-44d9-9e53-a91ecfc99a2d"
_8fmSi.Name = _TQt("\127\078\073\072\082\113\009\030\049\001\127\022\023")
_8fmSi.Description = ""
_8fmSi.AltText = ""
_8fmSi.Resources = {
	{
		Type = "jpg", 
		Filename = "iconImperial.jpg", 
		Directives = {}
	}
}
_EJL = Wherigo.ZMedia(_pISt2)
_EJL.Id = "ad1534ed-2dc0-4190-86fb-4d9e4f82573d"
_EJL.Name = _TQt("\127\078\073\072\082\035\049\029\029\049\023")
_EJL.Description = ""
_EJL.AltText = ""
_EJL.Resources = {
	{
		Type = "jpg", 
		Filename = "iconKessel.jpg", 
		Directives = {}
	}
}
_luw = Wherigo.ZMedia(_pISt2)
_luw.Id = "4451fbcb-143b-4073-a49c-a3b17eac097c"
_luw.Name = _TQt("\127\078\073\072\082\032\022\072\016\073\072")
_luw.Description = ""
_luw.AltText = ""
_luw.Resources = {
	{
		Type = "jpg", 
		Filename = "iconRandon.jpg", 
		Directives = {}
	}
}
_IjD = Wherigo.ZMedia(_pISt2)
_IjD.Id = "15b7cdb9-bfaf-41e4-8edc-57a3c8437822"
_IjD.Name = _TQt("\127\078\073\072\082\032\127\073\072")
_IjD.Description = ""
_IjD.AltText = ""
_IjD.Resources = {
	{
		Type = "jpg", 
		Filename = "iconRion.jpg", 
		Directives = {}
	}
}
_aoC = Wherigo.ZMedia(_pISt2)
_aoC.Id = "e2c40ab3-30c5-439d-8bfc-5da93787db1e"
_aoC.Name = _TQt("\127\078\073\072\082\063\062\049\001\009\022\023\082\047\049\100\073\072\022\100\073\001\029")
_aoC.Description = ""
_aoC.AltText = ""
_aoC.Resources = {
	{
		Type = "jpg", 
		Filename = "iconThermDets.jpg", 
		Directives = {}
	}
}
_rlyi5 = Wherigo.ZMedia(_pISt2)
_rlyi5.Id = "7a44930e-e8f4-41ec-8b70-b2c085354679"
_rlyi5.Name = _TQt("\016\127\022\023\073\120\082\083\086\030\049\001\029\030\022\078\049")
_rlyi5.Description = ""
_rlyi5.AltText = ""
_rlyi5.Resources = {
	{
		Type = "jpg", 
		Filename = "imgHyperspace.jpg", 
		Directives = {}
	}
}
_op3fh = Wherigo.ZMedia(_pISt2)
_op3fh.Id = "900bce1e-037e-4474-9dae-88647821c186"
_op3fh.Name = _TQt("\127\078\073\072\082\024\023\009\022\100\001\022")
_op3fh.Description = ""
_op3fh.AltText = ""
_op3fh.Resources = {
	{
		Type = "jpg", 
		Filename = "iconUlmatra.jpg", 
		Directives = {}
	}
}
_wYd2K = Wherigo.ZMedia(_pISt2)
_wYd2K.Id = "a27bac19-c6d4-45e9-883e-3e6049a376da"
_wYd2K.Name = _TQt("\127\100\049\009\082\087\127\001\049\029\100\073\072\049\029\082\037\127\120")
_wYd2K.Description = ""
_wYd2K.AltText = ""
_wYd2K.Resources = {
	{
		Type = "jpg", 
		Filename = "itemFirestonesBig.jpg", 
		Directives = {}
	}
}
_xcq = Wherigo.ZMedia(_pISt2)
_xcq.Id = "8957797c-242e-4344-94b4-20a2e314133b"
_xcq.Name = _TQt("\127\100\049\009\082\087\127\001\049\029\100\073\072\049\029\082\126\009\022\023\023")
_xcq.Description = ""
_xcq.AltText = ""
_xcq.Resources = {
	{
		Type = "jpg", 
		Filename = "itemFirestonesSmall.jpg", 
		Directives = {}
	}
}
_Ur01 = Wherigo.ZMedia(_pISt2)
_Ur01.Id = "60de7f58-8c8f-4ead-bbf5-2112089e6008"
_Ur01.Name = _TQt("\127\100\049\009\082\083\073\023\073\078\001\073\072\082\037\127\120")
_Ur01.Description = ""
_Ur01.AltText = ""
_Ur01.Resources = {
	{
		Type = "jpg", 
		Filename = "itemHolocronBig.jpg", 
		Directives = {}
	}
}
_7W_ = Wherigo.ZMedia(_pISt2)
_7W_.Id = "5e376139-3b65-4c5f-82f6-18461f672b36"
_7W_.Name = _TQt("\127\100\049\009\082\083\073\023\073\078\001\073\072\082\126\009\022\023\023")
_7W_.Description = ""
_7W_.AltText = ""
_7W_.Resources = {
	{
		Type = "jpg", 
		Filename = "itemHolocronSmall.jpg", 
		Directives = {}
	}
}
_xEj = Wherigo.ZMedia(_pISt2)
_xEj.Id = "1e2736cc-d26a-40cf-921d-a133121fbff1"
_xEj.Name = _TQt("\127\100\049\009\082\083\073\023\073\078\001\073\072\082\093\078\100\127\075\049\082\037\127\120")
_xEj.Description = ""
_xEj.AltText = ""
_xEj.Resources = {
	{
		Type = "jpg", 
		Filename = "itemHolocronActiveBig.jpg", 
		Directives = {}
	}
}
_ataoH = Wherigo.ZMedia(_pISt2)
_ataoH.Id = "ebfce3de-e038-4e29-8a54-53fae6bb20bb"
_ataoH.Name = _TQt("\127\100\049\009\082\063\062\049\001\009\022\023\082\047\049\100\073\072\022\100\073\001\029\082\037\127\120")
_ataoH.Description = ""
_ataoH.AltText = ""
_ataoH.Resources = {
	{
		Type = "jpg", 
		Filename = "itemThermDetsBig.jpg", 
		Directives = {}
	}
}
_wAfm = Wherigo.ZMedia(_pISt2)
_wAfm.Id = "42ad66f0-4ef6-4c9f-8821-b3db7f74df58"
_wAfm.Name = _TQt("\127\100\049\009\082\063\062\049\001\009\022\023\082\047\049\100\073\072\022\100\073\001\029\082\126\009\022\023\023")
_wAfm.Description = ""
_wAfm.AltText = ""
_wAfm.Resources = {
	{
		Type = "jpg", 
		Filename = "itemThermDetsSmall.jpg", 
		Directives = {}
	}
}
_YVgN = Wherigo.ZMedia(_pISt2)
_YVgN.Id = "5174b767-eb04-4db7-b879-e13ee63e1037"
_YVgN.Name = _TQt("\056\073\072\049\082\067\073\001\075\049\100\100\049\082\037\127\120")
_YVgN.Description = ""
_YVgN.AltText = ""
_YVgN.Resources = {
	{
		Type = "jpg", 
		Filename = "zoneCorvetteBig.jpg", 
		Directives = {}
	}
}
_13zH = Wherigo.ZMedia(_pISt2)
_13zH.Id = "19049c2f-69b5-47f5-8de3-192041b28d1e"
_13zH.Name = _TQt("\056\073\072\049\082\067\073\001\075\049\100\100\049\082\126\009\022\023\023")
_13zH.Description = ""
_13zH.AltText = ""
_13zH.Resources = {
	{
		Type = "jpg", 
		Filename = "zoneCorvetteSmall.jpg", 
		Directives = {}
	}
}
_Bgke7 = Wherigo.ZMedia(_pISt2)
_Bgke7.Id = "899eb141-3420-46e0-8691-3f2d1b1423ae"
_Bgke7.Name = _TQt("\056\073\072\049\082\047\001\049\022\016\072\022\090\120\062\100\082\126\009\022\023\023")
_Bgke7.Description = ""
_Bgke7.AltText = ""
_Bgke7.Resources = {
	{
		Type = "jpg", 
		Filename = "zoneDreadnaughtSmall.jpg", 
		Directives = {}
	}
}
_D3c = Wherigo.ZMedia(_pISt2)
_D3c.Id = "e6a5e875-2e4f-433d-95d4-f7ce255cd419"
_D3c.Name = _TQt("\056\073\072\049\082\047\001\049\022\016\072\022\090\120\062\100\082\037\127\120")
_D3c.Description = ""
_D3c.AltText = ""
_D3c.Resources = {
	{
		Type = "jpg", 
		Filename = "zoneDreadnaughtBig.jpg", 
		Directives = {}
	}
}
_rm_cH = Wherigo.ZMedia(_pISt2)
_rm_cH.Id = "a2978b70-78e6-4d43-b3b0-49a1b0832636"
_rm_cH.Name = _TQt("\056\073\072\049\082\087\073\001\009\073\029\082\037\127\120")
_rm_cH.Description = ""
_rm_cH.AltText = ""
_rm_cH.Resources = {
	{
		Type = "jpg", 
		Filename = "zoneFormosBig.jpg", 
		Directives = {}
	}
}
_81S5 = Wherigo.ZMedia(_pISt2)
_81S5.Id = "73cb6506-0967-4877-843a-0e67e575ad9f"
_81S5.Name = _TQt("\056\073\072\049\082\087\073\001\009\073\029\082\126\009\022\023\023")
_81S5.Description = ""
_81S5.AltText = ""
_81S5.Resources = {
	{
		Type = "jpg", 
		Filename = "zoneFormosSmall.jpg", 
		Directives = {}
	}
}
_Oex = Wherigo.ZMedia(_pISt2)
_Oex.Id = "0a1d4c44-079c-4566-ab68-38dc904b8dd7"
_Oex.Name = _TQt("\056\073\072\049\082\087\001\127\120\022\100\049\082\037\127\120")
_Oex.Description = ""
_Oex.AltText = ""
_Oex.Resources = {
	{
		Type = "jpg", 
		Filename = "zoneFrigateBig.jpg", 
		Directives = {}
	}
}
_r1j = Wherigo.ZMedia(_pISt2)
_r1j.Id = "3a0fe508-b28b-4d13-9a2c-2d3b02684d40"
_r1j.Name = _TQt("\056\073\072\049\082\087\001\127\120\022\100\049\082\126\009\022\023\023")
_r1j.Description = ""
_r1j.AltText = ""
_r1j.Resources = {
	{
		Type = "jpg", 
		Filename = "zoneFrigateSmall.jpg", 
		Directives = {}
	}
}
_oFeN = Wherigo.ZMedia(_pISt2)
_oFeN.Id = "8e858f87-15a3-49d9-949d-d6125fd9a420"
_oFeN.Name = _TQt("\056\073\072\049\082\113\072\100\049\001\016\127\078\100\073\001\082\037\127\120")
_oFeN.Description = ""
_oFeN.AltText = ""
_oFeN.Resources = {
	{
		Type = "jpg", 
		Filename = "zoneInterdictorBig.jpg", 
		Directives = {}
	}
}
_Jn2 = Wherigo.ZMedia(_pISt2)
_Jn2.Id = "f3c8e49c-3c01-4884-b7a1-8226fd8b455b"
_Jn2.Name = _TQt("\056\073\072\049\082\113\072\100\049\001\016\127\078\100\073\001\082\126\009\022\023\023")
_Jn2.Description = ""
_Jn2.AltText = ""
_Jn2.Resources = {
	{
		Type = "jpg", 
		Filename = "zoneInterdictorSmall.jpg", 
		Directives = {}
	}
}
_Lc5 = Wherigo.ZMedia(_pISt2)
_Lc5.Id = "ddbc72aa-98b9-4b01-a1dd-233a43cc39c7"
_Lc5.Name = _TQt("\056\073\072\049\082\035\049\029\029\049\023\082\037\127\120")
_Lc5.Description = ""
_Lc5.AltText = ""
_Lc5.Resources = {
	{
		Type = "jpg", 
		Filename = "zoneKesselBig.jpg", 
		Directives = {}
	}
}
_dCuL = Wherigo.ZMedia(_pISt2)
_dCuL.Id = "8489877e-daaf-46f7-9b22-eeb2a8f0d425"
_dCuL.Name = _TQt("\056\073\072\049\082\035\049\029\029\049\023\082\126\009\022\023\023")
_dCuL.Description = ""
_dCuL.AltText = ""
_dCuL.Resources = {
	{
		Type = "jpg", 
		Filename = "zoneKesselSmall.jpg", 
		Directives = {}
	}
}
_dff4b = Wherigo.ZMedia(_pISt2)
_dff4b.Id = "6fa12cbf-661c-40bd-902b-9b045efbd104"
_dff4b.Name = _TQt("\056\073\072\049\082\032\022\072\016\073\072\082\037\127\120")
_dff4b.Description = ""
_dff4b.AltText = ""
_dff4b.Resources = {
	{
		Type = "jpg", 
		Filename = "zoneRandonBig.jpg", 
		Directives = {}
	}
}
_NWXbX = Wherigo.ZMedia(_pISt2)
_NWXbX.Id = "cf0c2b56-3560-4451-b653-72359db38f68"
_NWXbX.Name = _TQt("\056\073\072\049\082\032\022\072\016\073\072\082\126\009\022\023\023")
_NWXbX.Description = ""
_NWXbX.AltText = ""
_NWXbX.Resources = {
	{
		Type = "jpg", 
		Filename = "zoneRandonSmall.jpg", 
		Directives = {}
	}
}
_OCt = Wherigo.ZMedia(_pISt2)
_OCt.Id = "1a26284c-5117-47c6-a5af-f030fd5cd8f1"
_OCt.Name = _TQt("\056\073\072\049\082\032\127\073\072\082\037\127\120")
_OCt.Description = ""
_OCt.AltText = ""
_OCt.Resources = {
	{
		Type = "jpg", 
		Filename = "zoneRionBig.jpg", 
		Directives = {}
	}
}
_YpmK = Wherigo.ZMedia(_pISt2)
_YpmK.Id = "3c40735a-fdb1-4a9a-91ac-bd53cf8701d8"
_YpmK.Name = _TQt("\056\073\072\049\082\032\127\073\072\082\126\009\022\023\023")
_YpmK.Description = ""
_YpmK.AltText = ""
_YpmK.Resources = {
	{
		Type = "jpg", 
		Filename = "zoneRionSmall.jpg", 
		Directives = {}
	}
}
_EuSXo = Wherigo.ZMedia(_pISt2)
_EuSXo.Id = "4052f689-19d4-4b8e-94fa-6dc77650db2d"
_EuSXo.Name = _TQt("\056\073\072\049\082\126\100\022\001\047\049\029\100\073\086\049\001\082\037\127\120")
_EuSXo.Description = ""
_EuSXo.AltText = ""
_EuSXo.Resources = {
	{
		Type = "jpg", 
		Filename = "zoneStarDestoyerBig.jpg", 
		Directives = {}
	}
}
_aFLN = Wherigo.ZMedia(_pISt2)
_aFLN.Id = "5a8818de-7a6b-4731-9e58-3606fc6927e8"
_aFLN.Name = _TQt("\056\073\072\049\082\126\100\022\001\047\049\029\100\073\086\049\001\082\126\009\022\023\023")
_aFLN.Description = ""
_aFLN.AltText = ""
_aFLN.Resources = {
	{
		Type = "jpg", 
		Filename = "zoneStarDestoyerSmall.jpg", 
		Directives = {}
	}
}
_BGX = Wherigo.ZMedia(_pISt2)
_BGX.Id = "2417cb7f-2c81-460f-9e78-8eade448acd0"
_BGX.Name = _TQt("\056\073\072\049\082\063\113\017\082\087\127\120\062\100\049\001\082\037\127\120")
_BGX.Description = ""
_BGX.AltText = ""
_BGX.Resources = {
	{
		Type = "jpg", 
		Filename = "zoneTIEFighterBig.jpg", 
		Directives = {}
	}
}
_qvD = Wherigo.ZMedia(_pISt2)
_qvD.Id = "038407f6-282a-4085-8f38-18c2c7b77d2f"
_qvD.Name = _TQt("\056\073\072\049\082\063\113\017\082\087\127\120\062\100\049\001\082\126\009\022\023\023")
_qvD.Description = ""
_qvD.AltText = ""
_qvD.Resources = {
	{
		Type = "jpg", 
		Filename = "zoneTIEFighterSmall.jpg", 
		Directives = {}
	}
}
__oWl = Wherigo.ZMedia(_pISt2)
__oWl.Id = "4dcded31-cf89-4bee-9a80-4256dc135e1a"
__oWl.Name = _TQt("\056\073\072\049\082\024\023\009\022\100\001\022\082\037\127\120")
__oWl.Description = ""
__oWl.AltText = ""
__oWl.Resources = {
	{
		Type = "jpg", 
		Filename = "zoneUlmatraBig.jpg", 
		Directives = {}
	}
}
_i9L = Wherigo.ZMedia(_pISt2)
_i9L.Id = "c4a276ec-4a0c-4672-acf4-0352df74fc33"
_i9L.Name = _TQt("\056\073\072\049\082\024\023\009\022\100\001\022\082\126\009\022\023\023")
_i9L.Description = ""
_i9L.AltText = ""
_i9L.Resources = {
	{
		Type = "jpg", 
		Filename = "zoneUlmatraSmall.jpg", 
		Directives = {}
	}
}
_bpni = Wherigo.ZMedia(_pISt2)
_bpni.Id = "f641b714-ca00-4671-a884-7467bbf99d9c"
_bpni.Name = _TQt("\056\073\072\049\082\126\127\035\023\022\022\100\022\067\023\090\029\100\049\001\082\037\127\120")
_bpni.Description = ""
_bpni.AltText = ""
_bpni.Resources = {
	{
		Type = "jpg", 
		Filename = "zoneSiKlaataClusterBig.jpg", 
		Directives = {}
	}
}
_XJV = Wherigo.ZMedia(_pISt2)
_XJV.Id = "869e108b-bca3-4b47-a4ee-b68dc617b91d"
_XJV.Name = _TQt("\056\073\072\049\082\126\127\035\023\022\022\100\022\067\023\090\029\100\049\001\082\126\009\022\023\023")
_XJV.Description = ""
_XJV.AltText = ""
_XJV.Resources = {
	{
		Type = "jpg", 
		Filename = "zoneSiKlaataClusterSmall.jpg", 
		Directives = {}
	}
}
_gXcN = Wherigo.ZMedia(_pISt2)
_gXcN.Id = "9f60d430-631e-416b-902a-a7b8e37ddae7"
_gXcN.Name = _TQt("\056\073\072\049\082\088\022\076\073\023\126\023\049\062\049\086\001\073\072\082\037\127\120")
_gXcN.Description = ""
_gXcN.AltText = ""
_gXcN.Resources = {
	{
		Type = "jpg", 
		Filename = "zonePabolSleheyronBig.jpg", 
		Directives = {}
	}
}
_mzV = Wherigo.ZMedia(_pISt2)
_mzV.Id = "2d5c15d9-9705-4e9e-8abd-be6e0ff045a0"
_mzV.Name = _TQt("\056\073\072\049\082\088\022\076\073\023\126\023\049\062\049\086\001\073\072\082\126\009\022\023\023")
_mzV.Description = ""
_mzV.AltText = ""
_mzV.Resources = {
	{
		Type = "jpg", 
		Filename = "zonePabolSleheyronSmall.jpg", 
		Directives = {}
	}
}
_iPpq = Wherigo.ZMedia(_pISt2)
_iPpq.Id = "b072023b-43b1-4318-ae97-41124c41a08c"
_iPpq.Name = _TQt("\127\078\073\072\082\088\022\076\073\023\126\023\049\062\049\086\001\073\072")
_iPpq.Description = ""
_iPpq.AltText = ""
_iPpq.Resources = {
	{
		Type = "jpg", 
		Filename = "iconPabolSleheyron.jpg", 
		Directives = {}
	}
}
_W1LV = Wherigo.ZMedia(_pISt2)
_W1LV.Id = "461a5592-7b03-405a-bd5f-b1198dc4527a"
_W1LV.Name = _TQt("\127\078\073\072\082\126\127\035\023\022\022\100\022\067\023\090\029\100\049\001")
_W1LV.Description = ""
_W1LV.AltText = ""
_W1LV.Resources = {
	{
		Type = "jpg", 
		Filename = "iconSiKlaataCluster.jpg", 
		Directives = {}
	}
}
_jOOre = Wherigo.ZMedia(_pISt2)
_jOOre.Id = "5d687dbb-b81c-4d27-895b-722c22ca351d"
_jOOre.Name = _TQt("\127\078\073\072\082\035\049\029\029\049\023\082\032\090\072")
_jOOre.Description = ""
_jOOre.AltText = ""
_jOOre.Resources = {
	{
		Type = "jpg", 
		Filename = "iconKesselRun.jpg", 
		Directives = {}
	}
}
_Evz6 = Wherigo.ZMedia(_pISt2)
_Evz6.Id = "b5d7f254-2aaf-4db6-97e2-69cb3b04c101"
_Evz6.Name = _TQt("\078\022\001\100\082\035\049\029\029\049\023\082\032\090\072\082\037\127\120")
_Evz6.Description = ""
_Evz6.AltText = ""
_Evz6.Resources = {
	{
		Type = "jpg", 
		Filename = "imgKesselRun.jpg", 
		Directives = {}
	}
}
_Tnu4 = Wherigo.ZMedia(_pISt2)
_Tnu4.Id = "822aec7b-6c0d-4e28-a16c-fa7783a661f4"
_Tnu4.Name = _TQt("\078\022\001\100\082\035\049\029\029\049\023\082\032\090\072\082\126\009\022\023\023")
_Tnu4.Description = ""
_Tnu4.AltText = ""
_Tnu4.Resources = {
	{
		Type = "jpg", 
		Filename = "imgKesselRun_Small.jpg", 
		Directives = {}
	}
}
_Quw = Wherigo.ZMedia(_pISt2)
_Quw.Id = "9b152d4b-c0bc-4c25-bca6-ae92e30f8453"
_Quw.Name = _TQt("\078\062\022\001\082\047\001\073\127\016\082\093\032\055\069\057")
_Quw.Description = ""
_Quw.AltText = ""
_Quw.Resources = {
	{
		Type = "jpg", 
		Filename = "charDroid_AR-G0.jpg", 
		Directives = {}
	}
}
_JXtHZ = Wherigo.ZMedia(_pISt2)
_JXtHZ.Id = "7d3ea356-fe3c-4be8-bf91-21fef728ff6f"
_JXtHZ.Name = _TQt("\078\062\022\001\082\126\009\090\120\120\023\049\001\082\126\127\072\120\049")
_JXtHZ.Description = ""
_JXtHZ.AltText = ""
_JXtHZ.Resources = {
	{
		Type = "jpg", 
		Filename = "charSmuggler_Singe.jpg", 
		Directives = {}
	}
}
_vVXBt = Wherigo.ZMedia(_pISt2)
_vVXBt.Id = "ff771f9b-f7d7-41e2-b277-ccfb222e8cc8"
_vVXBt.Name = _TQt("\078\062\022\001\082\126\009\090\120\120\023\049\001\082\069\001\022\072\016\022\001\022\015")
_vVXBt.Description = ""
_vVXBt.AltText = ""
_vVXBt.Resources = {
	{
		Type = "jpg", 
		Filename = "charSmuggler_Grandarak.jpg", 
		Directives = {}
	}
}
_c3MT = Wherigo.ZMedia(_pISt2)
_c3MT.Id = "1d41f992-2fba-41d7-adfe-55521e7910f7"
_c3MT.Name = _TQt("\127\100\049\009\082\069\023\127\100\100\049\001\029\100\127\009\082\037\127\120")
_c3MT.Description = ""
_c3MT.AltText = ""
_c3MT.Resources = {
	{
		Type = "jpg", 
		Filename = "itemGlitterstimBig.jpg", 
		Directives = {}
	}
}
_F0mX = Wherigo.ZMedia(_pISt2)
_F0mX.Id = "4c9c71ca-03f6-447b-860b-bca4e862c53e"
_F0mX.Name = _TQt("\127\100\049\009\082\069\023\127\100\100\049\001\029\100\127\009\082\126\009\022\023\023")
_F0mX.Description = ""
_F0mX.AltText = ""
_F0mX.Resources = {
	{
		Type = "jpg", 
		Filename = "itemGlitterstimSmall.jpg", 
		Directives = {}
	}
}
__1lzC = Wherigo.ZMedia(_pISt2)
__1lzC.Id = "c062a66e-7bc8-49c8-a10a-9f719785e06e"
__1lzC.Name = _TQt("\127\078\073\072\082\069\023\127\100\100\049\001\029\100\127\009")
__1lzC.Description = ""
__1lzC.AltText = ""
__1lzC.Resources = {
	{
		Type = "jpg", 
		Filename = "iconGlitterstim.jpg", 
		Directives = {}
	}
}
_yngFo = Wherigo.ZMedia(_pISt2)
_yngFo.Id = "00a9976c-b54b-43db-9b8b-1164c49eef79"
_yngFo.Name = _TQt("\078\062\022\001\082\047\001\073\127\016\082\124\047\055\092\060")
_yngFo.Description = ""
_yngFo.AltText = ""
_yngFo.Resources = {
	{
		Type = "jpg", 
		Filename = "charDroid_3D-4X.jpg", 
		Directives = {}
	}
}
_ixvgD = Wherigo.ZMedia(_pISt2)
_ixvgD.Id = "0e42399f-5376-4e44-88d9-903b5d754a06"
_ixvgD.Name = _TQt("\078\062\022\001\082\047\001\073\127\016\082\032\068\055\069\108")
_ixvgD.Description = ""
_ixvgD.AltText = ""
_ixvgD.Resources = {
	{
		Type = "jpg", 
		Filename = "charDroid_R5-G8.jpg", 
		Directives = {}
	}
}
_fTI = Wherigo.ZMedia(_pISt2)
_fTI.Id = "9f58ded0-f134-400f-ab97-2d8a9414c4b0"
_fTI.Name = _TQt("\016\127\022\023\073\120\082\126\100\022\001\082\087\127\049\023\016")
_fTI.Description = ""
_fTI.AltText = ""
_fTI.Resources = {
	{
		Type = "jpg", 
		Filename = "imgStarField.jpg", 
		Directives = {}
	}
}
_M_RwS = Wherigo.ZMedia(_pISt2)
_M_RwS.Id = "33a7e2de-35d8-4fa0-a4a3-829a92ff1e55"
_M_RwS.Name = _TQt("\078\062\022\001\082\047\001\073\127\016\082\032\092\055\093\095")
_M_RwS.Description = ""
_M_RwS.AltText = ""
_M_RwS.Resources = {
	{
		Type = "jpg", 
		Filename = "charDroid_R4-A22.jpg", 
		Directives = {}
	}
}
_Xkw = Wherigo.ZMedia(_pISt2)
_Xkw.Id = "71cd52fc-1bb3-45ed-be2d-cfe458992b90"
_Xkw.Name = _TQt("\127\100\049\009\082\083\073\023\073\078\001\073\072\082\093\078\100\127\075\049\082\126\009\022\023\023")
_Xkw.Description = ""
_Xkw.AltText = ""
_Xkw.Resources = {
	{
		Type = "jpg", 
		Filename = "itemHolocronActiveSmall.jpg", 
		Directives = {}
	}
}
_mSX = Wherigo.ZMedia(_pISt2)
_mSX.Id = "51576c8b-6ad8-4e4e-86c1-793bf06b1dc5"
_mSX.Name = _TQt("\016\127\022\023\073\120\082\083\086\030\049\001\029\030\022\078\049\082\083\090\001\001\086")
_mSX.Description = ""
_mSX.AltText = ""
_mSX.Resources = {
	{
		Type = "jpg", 
		Filename = "imgHyperspaceHurry.jpg", 
		Directives = {}
	}
}
-- Cartridge Info --
_pISt2.Id="59615a44-ebd5-46a5-bf07-895f00f0ba92"
_pISt2.Name="Kessel Run"
_pISt2.Description=[[]]
_pISt2.Visible=true
_pISt2.Activity="Geocache"
_pISt2.StartingLocationDescription=[[]]
_pISt2.StartingLocation = ZonePoint(40.2862734643962,-75.1381728798151,0)
_pISt2.Version=""
_pISt2.Company=""
_pISt2.Author=""
_pISt2.BuilderVersion="URWIGO 1.14.4469.18959"
_pISt2.CreateDate="07/10/2012 21:49:01"
_pISt2.PublishDate="1/1/0001 12:00:00 AM"
_pISt2.UpdateDate="07/27/2012 00:49:43"
_pISt2.LastPlayedDate="1/1/0001 12:00:00 AM"
_pISt2.TargetDevice="PocketPC"
_pISt2.TargetDeviceVersion="0"
_pISt2.StateId="1"
_pISt2.CountryId="2"
_pISt2.Complete=false
_pISt2.UseLogging=true

_pISt2.Media=_Evz6

_pISt2.Icon=_jOOre


-- Zones --
_wzEz = Wherigo.Zone(_pISt2)
_wzEz.Id = "78b67cf5-8349-4dca-85b1-ca605f445d86"
_wzEz.Name = _TQt("\126\100\022\001\082\047\049\029\100\001\073\086\049\001")
_wzEz.Description = _TQt("\126\100\022\001\082\047\049\029\100\001\073\086\049\001\029\082\022\001\049\082\029\073\009\049\082\073\077\082\100\062\049\082\023\022\001\120\049\029\100\082\022\072\016\082\009\073\029\100\082\030\073\111\049\001\077\090\023\082\111\022\001\029\062\127\030\029\082\111\062\127\078\062\082\078\022\072\082\078\022\001\001\086\082\090\030\082\100\073\082\013\057\043\057\057\057\082\100\001\073\073\030\029\082\022\072\016\082\029\049\075\049\001\022\023\082\111\127\072\120\029\082\073\077\082\029\100\022\001\077\127\120\062\100\049\001\029\094")
_wzEz.Visible = false
_wzEz.Media = _EuSXo
_wzEz.Icon = _8fmSi
_wzEz.Commands = {}
_wzEz.DistanceRange = Distance(-1, "feet")
_wzEz.ShowObjects = "OnEnter"
_wzEz.ProximityRange = Distance(60, "meters")
_wzEz.AllowSetPositionTo = false
_wzEz.Active = false
_wzEz.Points = {
	ZonePoint(40.2865108059453, -75.137258246541, 0), 
	ZonePoint(40.2867235942117, -75.1372676342726, 0), 
	ZonePoint(40.286716433079, -75.1374057680369, 0), 
	ZonePoint(40.2865844634979, -75.1374030858279, 0), 
	ZonePoint(40.2865680951598, -75.1377826184034, 0), 
	ZonePoint(40.2864862534099, -75.1377759128809, 0)
}
_wzEz.OriginalPoint = ZonePoint(40.2865982742173, -75.1374822109938, 0)
_wzEz.DistanceRangeUOM = "Feet"
_wzEz.ProximityRangeUOM = "Meters"
_wzEz.OutOfRangeName = ""
_wzEz.InRangeName = ""
_KvYl = Wherigo.Zone(_pISt2)
_KvYl.Id = "e231a16b-e2ae-473b-9cb7-0e192be4cc18"
_KvYl.Name = _TQt("\047\001\049\022\016\072\073\090\120\062\100")
_KvYl.Description = _TQt("\063\062\049\082\047\001\049\022\016\072\022\090\120\062\100\043\082\073\001\082\126\100\022\001\082\047\001\049\022\016\072\022\090\120\062\100\043\082\127\029\082\073\072\049\082\073\077\082\100\062\049\082\023\022\001\120\049\029\100\082\022\072\016\082\029\100\001\073\072\120\049\029\100\082\076\022\100\100\023\049\029\062\127\030\029\082\127\072\082\100\062\049\082\029\100\022\001\077\023\049\049\100\029\082\073\077\082\001\049\120\127\073\072\022\023\082\022\072\016\082\120\022\023\022\078\100\127\078\082\120\073\075\049\001\072\009\049\072\100\029\094")
_KvYl.Visible = false
_KvYl.Media = _D3c
_KvYl.Icon = _8fmSi
_KvYl.Commands = {}
_KvYl.DistanceRange = Distance(-1, "feet")
_KvYl.ShowObjects = "OnEnter"
_KvYl.ProximityRange = Distance(60, "meters")
_KvYl.AllowSetPositionTo = false
_KvYl.Active = false
_KvYl.Points = {
	ZonePoint(40.2868172003765, -75.1375740766526, 0), 
	ZonePoint(40.2869102949035, -75.1375780999661, 0), 
	ZonePoint(40.2869062028391, -75.1378007233144, 0), 
	ZonePoint(40.2865675836493, -75.1377806067467, 0), 
	ZonePoint(40.2865716757343, -75.137641131878, 0), 
	ZonePoint(40.2868172003765, -75.137654542923, 0)
}
_KvYl.OriginalPoint = ZonePoint(40.2867650263132, -75.1376715302468, 0)
_KvYl.DistanceRangeUOM = "Feet"
_KvYl.ProximityRangeUOM = "Meters"
_KvYl.OutOfRangeName = ""
_KvYl.InRangeName = ""
_Toy = Wherigo.Zone(_pISt2)
_Toy.Id = "58eb429c-9175-4e20-a388-64d87b989192"
_Toy.Name = _TQt("\067\073\001\075\049\100\100\049")
_Toy.Description = _TQt("\063\062\049\082\067\032\044\057\082\078\073\001\075\049\100\100\049\043\082\078\073\009\009\073\072\023\086\082\001\049\077\049\001\001\049\016\082\100\073\082\022\029\082\100\062\049\082\067\073\001\049\023\023\127\022\072\082\078\073\001\075\049\100\100\049\043\082\127\029\082\022\082\029\009\022\023\023\043\082\009\090\023\100\127\055\030\090\001\030\073\029\049\082\078\022\030\127\100\022\023\082\029\062\127\030\082\001\049\023\049\120\022\100\049\016\082\030\001\127\009\022\001\127\023\086\082\100\073\082\016\127\030\023\073\009\022\100\127\078\082\022\072\016\082\049\029\078\073\001\100\082\016\090\100\086\082\127\072\082\100\062\049\082\069\022\023\022\078\100\127\078\082\017\009\030\127\001\049\094")
_Toy.Visible = false
_Toy.Media = _YVgN
_Toy.Icon = _8fmSi
_Toy.Commands = {}
_Toy.DistanceRange = Distance(-1, "feet")
_Toy.ShowObjects = "OnEnter"
_Toy.ProximityRange = Distance(60, "meters")
_Toy.AllowSetPositionTo = false
_Toy.Active = false
_Toy.Points = {
	ZonePoint(40.2867118294935, -75.1374050974846, 0), 
	ZonePoint(40.2867189906266, -75.1372723281384, 0), 
	ZonePoint(40.2869164329997, -75.1372803747655, 0), 
	ZonePoint(40.2869082488713, -75.1375834643841, 0), 
	ZonePoint(40.286816177359, -75.1375754177571, 0), 
	ZonePoint(40.2868192464114, -75.1374104619027, 0)
}
_Toy.OriginalPoint = ZonePoint(40.2868151542936, -75.1374211907387, 0)
_Toy.DistanceRangeUOM = "Feet"
_Toy.ProximityRangeUOM = "Meters"
_Toy.OutOfRangeName = ""
_Toy.InRangeName = ""
_cZge = Wherigo.Zone(_pISt2)
_cZge.Id = "ec0585b2-c213-4701-9732-328cb263931b"
_cZge.Name = _TQt("\024\023\009\022\100\001\022")
_cZge.Description = _TQt("\024\023\009\022\100\001\022\082\127\029\082\022\082\030\023\022\072\049\100\082\023\073\078\022\100\049\016\082\111\127\100\062\127\072\082\100\062\049\082\024\023\009\022\100\001\022\082\029\086\029\100\049\009\082\073\077\082\100\062\049\082\083\090\100\100\082\126\030\022\078\049\043\082\022\082\100\001\022\016\049\082\111\073\001\023\016\082\073\072\082\100\062\049\082\088\022\076\073\023\082\126\023\049\062\049\086\001\073\072\094")
_cZge.Visible = false
_cZge.Media = __oWl
_cZge.Icon = _op3fh
_cZge.Commands = {}
_cZge.DistanceRange = Distance(-1, "feet")
_cZge.ShowObjects = "OnEnter"
_cZge.ProximityRange = Distance(60, "meters")
_cZge.AllowSetPositionTo = false
_cZge.Active = false
_cZge.Points = {
	ZonePoint(40.2871302430019, -75.1362866163254, 0), 
	ZonePoint(40.2871302430021, -75.1364421844482, 0), 
	ZonePoint(40.2872847177502, -75.1364462077618, 0), 
	ZonePoint(40.2872867637709, -75.1362946629525, 0)
}
_cZge.OriginalPoint = ZonePoint(40.2872079918813, -75.136367417872, 0)
_cZge.DistanceRangeUOM = "Feet"
_cZge.ProximityRangeUOM = "Meters"
_cZge.OutOfRangeName = ""
_cZge.InRangeName = ""
_bol = Wherigo.Zone(_pISt2)
_bol.Id = "16ac0d22-d936-4bde-8cf4-da3ad2937fde"
_bol.Name = _TQt("\032\127\073\072")
_bol.Description = _TQt("\032\127\073\072\082\127\029\082\022\082\030\023\022\072\049\100\082\073\072\082\100\062\049\082\035\049\029\029\049\023\082\032\090\072\082\073\077\082\100\062\049\082\054\090\100\049\001\082\032\127\009\082\063\049\001\001\127\100\073\001\127\049\029\094\082\032\127\073\072\082\090\029\049\016\082\100\073\082\076\049\082\015\072\073\111\072\082\022\029\082\022\082\100\001\073\030\127\078\022\023\082\030\022\001\022\016\127\029\049\082\022\072\016\082\111\022\029\082\073\072\078\049\082\100\062\049\082\023\073\078\022\100\127\073\072\082\073\077\082\063\022\072\022\020\029\082\032\049\029\073\001\100\094")
_bol.Visible = false
_bol.Media = _OCt
_bol.Icon = _IjD
_bol.Commands = {}
_bol.DistanceRange = Distance(-1, "feet")
_bol.ShowObjects = "OnEnter"
_bol.ProximityRange = Distance(60, "meters")
_bol.AllowSetPositionTo = false
_bol.Active = false
_bol.Points = {
	ZonePoint(40.2866274303701, -75.1374486833811, 0), 
	ZonePoint(40.2866233382885, -75.1375894993544, 0), 
	ZonePoint(40.2867808832495, -75.1375988870859, 0), 
	ZonePoint(40.2867859983394, -75.1374620944262, 0)
}
_bol.OriginalPoint = ZonePoint(40.2867044125619, -75.1375247910619, 0)
_bol.DistanceRangeUOM = "Feet"
_bol.ProximityRangeUOM = "Meters"
_bol.OutOfRangeName = ""
_bol.InRangeName = ""
_fnoA7 = Wherigo.Zone(_pISt2)
_fnoA7.Id = "fd4ff24a-261b-4a42-980e-489a3d5dc5fe"
_fnoA7.Name = _TQt("\113\072\100\049\001\016\127\078\100\073\001")
_fnoA7.Description = _TQt("\063\062\049\082\113\009\009\073\076\127\023\127\056\049\001\082\092\013\108\082\078\001\090\127\029\049\001\043\082\022\023\029\073\082\015\072\073\111\072\082\022\029\082\125\072\076\029\030\034\100\062\049\082\113\072\100\049\001\016\127\078\100\073\001\043\082\127\029\082\049\025\090\127\030\030\049\016\082\111\127\100\062\082\120\001\022\075\127\100\086\082\111\049\023\023\082\030\001\073\116\049\078\100\073\001\029\082\016\049\029\127\120\072\049\016\082\100\073\082\030\090\023\023\082\029\062\127\030\029\082\077\001\073\009\082\062\086\030\049\001\029\030\022\078\049\082\022\072\016\082\030\001\049\075\049\072\100\082\100\062\049\009\082\009\022\015\127\072\120\082\100\062\049\082\116\090\009\030\082\100\073\082\023\127\120\062\100\029\030\049\049\016\094")
_fnoA7.Visible = false
_fnoA7.Media = _oFeN
_fnoA7.Icon = _8fmSi
_fnoA7.Commands = {}
_fnoA7.DistanceRange = Distance(-1, "feet")
_fnoA7.ShowObjects = "OnEnter"
_fnoA7.ProximityRange = Distance(60, "meters")
_fnoA7.AllowSetPositionTo = false
_fnoA7.Active = false
_fnoA7.Points = {
	ZonePoint(40.2873333107306, -75.1364951580764, 0), 
	ZonePoint(40.2869957166952, -75.1364897936583, 0), 
	ZonePoint(40.2869926476508, -75.1366051286459, 0), 
	ZonePoint(40.2874284505631, -75.1366011053324, 0), 
	ZonePoint(40.2874304965796, -75.1363825052978, 0), 
	ZonePoint(40.2873353567499, -75.1363838464022, 0)
}
_fnoA7.OriginalPoint = ZonePoint(40.2872526631615, -75.1364929229022, 0)
_fnoA7.DistanceRangeUOM = "Feet"
_fnoA7.ProximityRangeUOM = "Meters"
_fnoA7.OutOfRangeName = ""
_fnoA7.InRangeName = ""
_eKB = Wherigo.Zone(_pISt2)
_eKB.Id = "7674c852-9afe-4c33-b068-3ca1cefc5ecf"
_eKB.Name = _TQt("\063\113\017\082\087\127\120\062\100\049\001\082\087\023\049\049\100")
_eKB.Description = _TQt("\063\062\049\082\063\113\017\070\023\072\082\029\100\022\001\077\127\120\062\100\049\001\082\073\001\082\063\113\017\082\087\127\120\062\100\049\001\043\082\111\022\029\082\100\062\049\082\029\100\022\072\016\022\001\016\082\113\009\030\049\001\127\022\023\082\029\100\022\001\077\127\120\062\100\049\001\082\029\049\049\072\082\127\072\082\009\022\029\029\127\075\049\082\072\090\009\076\049\001\029\082\100\062\001\073\090\120\062\073\090\100\082\100\062\049\082\120\022\023\022\046\086\094\082\067\073\023\023\073\025\090\127\022\023\023\086\043\082\113\009\030\049\001\127\022\023\082\030\127\023\073\100\029\082\001\049\077\049\001\082\100\073\082\100\062\049\082\078\001\022\077\100\029\082\022\029\082\085\049\086\049\076\022\023\023\029\094\085")
_eKB.Visible = false
_eKB.Media = _BGX
_eKB.Icon = _8fmSi
_eKB.Commands = {}
_eKB.DistanceRange = Distance(-1, "feet")
_eKB.ShowObjects = "OnEnter"
_eKB.ProximityRange = Distance(60, "meters")
_eKB.AllowSetPositionTo = false
_eKB.Active = false
_eKB.Points = {
	ZonePoint(40.2870857419362, -75.1364897936583, 0), 
	ZonePoint(40.287087787963, -75.1362323015928, 0), 
	ZonePoint(40.2872156645156, -75.1362363249065, 0), 
	ZonePoint(40.2872156645156, -75.1361156255007, 0), 
	ZonePoint(40.2870008317689, -75.1361062377691, 0), 
	ZonePoint(40.2869977627248, -75.1364871114493, 0)
}
_eKB.OriginalPoint = ZonePoint(40.2871005755707, -75.1362778991461, 0)
_eKB.DistanceRangeUOM = "Feet"
_eKB.ProximityRangeUOM = "Meters"
_eKB.OutOfRangeName = ""
_eKB.InRangeName = ""
_3VeQ = Wherigo.Zone(_pISt2)
_3VeQ.Id = "8c98b47b-11b9-4ed1-8633-c17384c7bd05"
_3VeQ.Name = _TQt("\113\009\030\049\001\127\022\023\082\087\001\127\120\022\100\049")
_3VeQ.Description = _TQt("\063\062\049\082\066\049\076\090\023\073\072\082\037\055\095\082\087\001\127\120\022\100\049\020\029\082\077\073\001\111\022\001\016\082\030\073\016\082\090\029\049\029\082\125\072\076\029\030\034\022\072\082\127\072\075\049\001\100\049\016\055\019\082\029\062\022\030\049\082\100\073\082\022\023\023\073\111\082\120\001\049\022\100\049\001\082\029\090\001\077\022\078\049\082\022\001\049\022\082\100\073\082\009\073\090\072\100\082\111\049\022\030\073\072\001\086\082\022\072\016\082\127\029\082\022\001\009\049\016\082\111\127\100\062\082\022\082\078\073\072\078\090\029\029\127\073\072\082\009\127\029\029\127\023\049\082\023\022\090\072\078\062\049\001\094")
_3VeQ.Visible = false
_3VeQ.Media = _Oex
_3VeQ.Icon = _8fmSi
_3VeQ.Commands = {}
_3VeQ.DistanceRange = Distance(-1, "feet")
_3VeQ.ShowObjects = "OnEnter"
_3VeQ.ProximityRange = Distance(60, "meters")
_3VeQ.AllowSetPositionTo = false
_3VeQ.Active = false
_3VeQ.Points = {
	ZonePoint(40.2874304965796, -75.1361263543367, 0), 
	ZonePoint(40.2872161760214, -75.1361169666052, 0), 
	ZonePoint(40.2872146415042, -75.1362349838019, 0), 
	ZonePoint(40.2873363797595, -75.1362416893245, 0), 
	ZonePoint(40.2873363797595, -75.1363811641932, 0), 
	ZonePoint(40.2874335656042, -75.1363838464023, 0)
}
_3VeQ.OriginalPoint = ZonePoint(40.2873279398714, -75.1362475007773, 0)
_3VeQ.DistanceRangeUOM = "Feet"
_3VeQ.ProximityRangeUOM = "Meters"
_3VeQ.OutOfRangeName = ""
_3VeQ.InRangeName = ""
_v0OYZ = Wherigo.Zone(_pISt2)
_v0OYZ.Id = "e05b4f59-8ec2-463b-887c-26390f21733d"
_v0OYZ.Name = _TQt("\087\073\001\009\073\029")
_v0OYZ.Description = _TQt("\087\073\001\009\073\029\082\127\029\082\022\082\029\009\090\120\120\023\127\072\120\082\062\022\075\049\072\082\023\073\078\022\100\049\016\082\072\049\022\001\082\035\049\029\029\049\023\082\022\072\016\082\127\100\029\082\127\072\077\022\009\073\090\029\082\029\030\127\078\049\082\009\127\072\049\029\094\082\113\100\082\062\022\029\082\022\082\029\030\022\078\049\030\073\001\100\043\082\076\090\100\082\073\090\100\029\127\016\049\082\100\062\049\082\029\009\090\120\120\023\127\072\120\082\022\029\030\049\078\100\043\082\062\022\029\082\023\127\100\100\023\049\082\100\073\082\073\077\077\049\001\082\075\127\029\127\100\073\001\029\094")
_v0OYZ.Visible = true
_v0OYZ.Media = _rm_cH
_v0OYZ.Icon = __Kf
_v0OYZ.Commands = {}
_v0OYZ.DistanceRange = Distance(-1, "feet")
_v0OYZ.ShowObjects = "OnEnter"
_v0OYZ.ProximityRange = Distance(60, "meters")
_v0OYZ.AllowSetPositionTo = false
_v0OYZ.Active = true
_v0OYZ.Points = {
	ZonePoint(40.2860949461769, -75.1372320950032, 0), 
	ZonePoint(40.2861542817991, -75.1369209587575, 0), 
	ZonePoint(40.2863711632849, -75.1369920372964, 0), 
	ZonePoint(40.2863123393658, -75.1372957974673, 0)
}
_v0OYZ.OriginalPoint = ZonePoint(40.2862331826567, -75.1371102221311, 0)
_v0OYZ.DistanceRangeUOM = "Feet"
_v0OYZ.ProximityRangeUOM = "Meters"
_v0OYZ.OutOfRangeName = ""
_v0OYZ.InRangeName = ""
_OEVB = Wherigo.Zone(_pISt2)
_OEVB.Id = "7d733cdc-4ce5-418e-b56c-e7406d784676"
_OEVB.Name = _TQt("\088\022\076\073\023\082\126\023\049\062\049\086\001\073\072")
_OEVB.Description = _TQt("\063\062\049\082\088\022\076\073\023\082\126\023\049\062\049\086\001\073\072\082\127\029\082\022\082\062\086\030\049\001\029\030\022\078\049\082\001\073\090\100\049\082\076\049\100\111\049\049\072\082\087\073\001\009\073\029\082\022\072\016\082\032\022\072\016\073\072\094")
_OEVB.Visible = false
_OEVB.Media = _gXcN
_OEVB.Icon = _iPpq
_OEVB.Commands = {}
_OEVB.DistanceRange = Distance(-1, "feet")
_OEVB.ShowObjects = "OnEnter"
_OEVB.ProximityRange = Distance(60, "meters")
_OEVB.AllowSetPositionTo = false
_OEVB.Active = false
_OEVB.Points = {
	ZonePoint(40.2867067144019, -75.1359915733338, 0), 
	ZonePoint(40.2869276861786, -75.13602912426, 0), 
	ZonePoint(40.287009527394, -75.1357716321946, 0), 
	ZonePoint(40.2866821619377, -75.1357126235962, 0)
}
_OEVB.OriginalPoint = ZonePoint(40.2868315224781, -75.1358762383462, 0)
_OEVB.DistanceRangeUOM = "Feet"
_OEVB.ProximityRangeUOM = "Meters"
_OEVB.OutOfRangeName = ""
_OEVB.InRangeName = ""
_Hdh = Wherigo.Zone(_pISt2)
_Hdh.Id = "3cd0f8b1-c19d-46c2-90d1-eaff5be684ce"
_Hdh.Name = _TQt("\032\022\072\016\073\072")
_Hdh.Description = _TQt("\032\022\072\016\073\072\082\127\029\082\022\082\023\022\001\120\049\082\076\090\029\127\072\049\029\029\082\111\073\001\023\016\082\111\127\100\062\082\078\001\073\111\016\049\016\082\076\022\056\022\022\001\029\082\022\072\016\082\049\023\049\120\022\072\100\082\078\073\001\030\073\001\022\100\049\082\100\073\111\049\001\029\094\082\113\100\082\029\127\100\029\082\022\100\082\100\062\049\082\127\072\100\049\001\029\049\078\100\127\073\072\082\073\077\082\029\049\075\049\001\022\023\082\009\022\116\073\001\082\100\001\022\016\049\082\001\073\090\100\049\029\094")
_Hdh.Visible = false
_Hdh.Media = _dff4b
_Hdh.Icon = _luw
_Hdh.Commands = {}
_Hdh.DistanceRange = Distance(-1, "feet")
_Hdh.ShowObjects = "OnEnter"
_Hdh.ProximityRange = Distance(60, "meters")
_Hdh.AllowSetPositionTo = false
_Hdh.Active = false
_Hdh.Points = {
	ZonePoint(40.2877747379637, -75.1368498802186, 0), 
	ZonePoint(40.2875476309179, -75.1371529698372, 0), 
	ZonePoint(40.2877865024971, -75.1375251263381, 0), 
	ZonePoint(40.2877767839696, -75.1375257968904, 0), 
	ZonePoint(40.2880182122373, -75.1372173428536, 0)
}
_Hdh.OriginalPoint = ZonePoint(40.2877807735171, -75.1372542232276, 0)
_Hdh.DistanceRangeUOM = "Feet"
_Hdh.ProximityRangeUOM = "Meters"
_Hdh.OutOfRangeName = ""
_Hdh.InRangeName = ""
_WpkR = Wherigo.Zone(_pISt2)
_WpkR.Id = "a56266b8-b685-461f-be16-ad0c82e6d98c"
_WpkR.Name = _TQt("\126\127\020\035\023\022\022\100\022\082\067\023\090\029\100\049\001")
_WpkR.Description = _TQt("\063\062\049\082\126\127\020\035\023\022\022\100\022\082\067\023\090\029\100\049\001\082\127\029\082\022\072\082\022\001\049\022\082\127\072\082\083\090\100\100\082\126\030\022\078\049\043\082\072\049\022\001\082\100\062\049\082\063\127\073\072\082\083\049\120\049\009\073\072\086\082\022\072\016\082\100\062\049\082\126\127\029\022\001\082\032\090\072\094\082\113\100\082\078\073\072\100\022\127\072\029\082\100\062\049\082\035\127\072\100\022\072\082\029\086\029\100\049\009\082\022\072\016\082\029\049\075\049\001\022\023\082\111\073\001\023\016\029\094\082\066\073\072\055\083\090\100\100\082\022\078\078\049\029\029\082\100\073\082\100\062\049\082\067\023\090\029\100\049\001\082\127\029\082\062\049\022\075\127\023\086\082\001\049\029\100\001\127\078\100\049\016\094")
_WpkR.Visible = false
_WpkR.Media = _bpni
_WpkR.Icon = _W1LV
_WpkR.Commands = {}
_WpkR.DistanceRange = Distance(-1, "feet")
_WpkR.ShowObjects = "OnEnter"
_WpkR.ProximityRange = Distance(60, "meters")
_WpkR.AllowSetPositionTo = false
_WpkR.Active = false
_WpkR.Points = {
	ZonePoint(40.286622826779, -75.1390761137009, 0), 
	ZonePoint(40.2864448209904, -75.138907134533, 0), 
	ZonePoint(40.286661701544, -75.1386228203774, 0), 
	ZonePoint(40.28682538452, -75.1388159394265, 0)
}
_WpkR.OriginalPoint = ZonePoint(40.2866386834583, -75.1388555020094, 0)
_WpkR.DistanceRangeUOM = "Feet"
_WpkR.ProximityRangeUOM = "Meters"
_WpkR.OutOfRangeName = ""
_WpkR.InRangeName = ""
_mjjz = Wherigo.Zone(_pISt2)
_mjjz.Id = "a07d3c68-ff05-46aa-89da-d5d4adef442b"
_mjjz.Name = _TQt("\035\049\029\029\049\023")
_mjjz.Description = _TQt("\035\049\029\029\049\023\082\127\029\082\022\082\030\001\127\029\073\072\082\111\073\001\023\016\043\082\022\072\016\082\127\029\082\062\073\009\049\082\100\073\082\100\062\049\082\120\022\023\022\046\086\020\029\082\023\022\001\120\049\029\100\082\069\023\127\100\100\049\001\029\100\127\009\082\029\030\127\078\049\082\009\127\072\127\072\120\082\073\030\049\001\022\100\127\073\072\094\082\063\062\127\029\082\009\127\029\055\029\062\022\030\049\072\043\082\022\029\100\049\001\073\127\016\055\029\062\022\030\049\016\082\030\023\022\072\049\100\082\062\022\029\082\022\082\076\022\001\001\049\072\043\082\001\073\078\015\086\082\023\022\072\016\029\078\022\030\049\094")
_mjjz.Visible = false
_mjjz.Media = _Lc5
_mjjz.Icon = _EJL
_mjjz.Commands = {}
_mjjz.DistanceRange = Distance(-1, "feet")
_mjjz.ShowObjects = "OnEnter"
_mjjz.ProximityRange = Distance(60, "meters")
_mjjz.AllowSetPositionTo = false
_mjjz.Active = false
_mjjz.Points = {
	ZonePoint(40.2870310106968, -75.1412527263166, 0), 
	ZonePoint(40.2868796044184, -75.1414753496648, 0), 
	ZonePoint(40.2866647706035, -75.1412393152715, 0), 
	ZonePoint(40.2868489139152, -75.1410113275052, 0)
}
_mjjz.OriginalPoint = ZonePoint(40.2868560749085, -75.1412446796895, 0)
_mjjz.DistanceRangeUOM = "Feet"
_mjjz.ProximityRangeUOM = "Meters"
_mjjz.OutOfRangeName = ""
_mjjz.InRangeName = ""

-- Characters --

-- Items --
_hRrO = Wherigo.ZItem{
	Cartridge = _pISt2, 
	Container = _bol
}
_hRrO.Id = "9efbf9d4-dbf0-4b7a-829a-750d9e3ba408"
_hRrO.Name = _TQt("\063\062\049\001\009\022\023\082\047\049\100\073\072\022\100\073\001\029")
_hRrO.Description = _TQt("\093\082\100\062\049\001\009\022\023\082\016\049\100\073\072\022\100\073\001\082\127\029\082\022\082\062\127\120\062\023\086\082\090\072\029\100\022\076\023\049\082\120\001\049\072\022\016\049\055\023\127\015\049\082\111\049\022\030\073\072\082\030\073\030\090\023\022\001\082\022\009\073\072\120\082\009\127\023\127\100\022\001\086\082\030\049\001\029\073\072\072\049\023\043\082\078\001\127\009\127\072\022\023\029\043\082\076\073\090\072\100\086\082\062\090\072\100\049\001\029\043\082\022\072\016\082\009\049\001\078\049\072\022\001\127\049\029\094")
_hRrO.Visible = true
_hRrO.Media = _ataoH
_hRrO.Icon = _aoC
_hRrO.Commands = {}
_hRrO.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_hRrO.Locked = false
_hRrO.Opened = false
_L0jA = Wherigo.ZItem{
	Cartridge = _pISt2, 
	Container = _cZge
}
_L0jA.Id = "37e3f736-a868-46a1-be3a-a433522c7c5e"
_L0jA.Name = _TQt("\032\022\100\062\022\023\022\086\022\072\082\087\127\001\049\029\100\073\072\049\029")
_L0jA.Description = _TQt("\032\022\100\062\022\023\022\086\022\072\082\077\127\001\049\029\100\073\072\049\029\082\022\001\049\082\029\127\009\127\023\022\001\082\100\073\082\100\062\049\082\078\001\086\029\100\022\023\029\082\100\062\022\100\082\053\049\016\127\082\090\029\049\082\127\072\082\023\127\120\062\100\029\022\076\049\001\029\034\082\062\073\111\049\075\049\001\043\082\100\062\049\086\082\022\001\049\082\072\073\100\082\029\100\022\076\023\049\082\049\072\073\090\120\062\082\100\073\082\076\049\082\090\029\049\016\082\022\029\082\029\090\078\062\094\109\037\032\041\048\062\049\072\082\100\111\073\082\073\001\082\009\073\001\049\082\077\127\001\049\029\100\073\072\049\029\082\022\001\049\082\127\072\082\078\023\073\029\049\082\030\001\073\046\127\009\127\100\086\043\082\100\062\049\082\078\001\086\029\100\022\023\029\082\111\127\023\023\082\075\127\076\001\022\100\049\043\082\078\001\049\022\100\127\072\120\082\062\049\022\100\043\082\111\062\127\078\062\082\120\127\075\049\029\082\100\062\049\082\029\100\073\072\049\029\082\100\062\049\127\001\082\072\022\009\049\094")
_L0jA.Visible = true
_L0jA.Media = _wYd2K
_L0jA.Icon = _3V7M
_L0jA.Commands = {}
_L0jA.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_L0jA.Locked = false
_L0jA.Opened = false
_vxBxs = Wherigo.ZItem(_pISt2)
_vxBxs.Id = "7bff44ee-4963-4599-8f97-663a79ee0e23"
_vxBxs.Name = _TQt("\083\073\023\073\078\001\073\072")
_vxBxs.Description = _TQt("\093\082\062\073\023\073\078\001\073\072\043\082\029\062\073\001\100\082\077\073\001\082\062\073\023\073\120\001\022\030\062\127\078\082\078\062\001\073\072\127\078\023\049\043\082\127\029\082\022\072\082\073\001\120\022\072\127\078\082\078\001\086\029\100\022\023\055\023\022\100\100\127\078\049\082\016\049\075\127\078\049\082\111\062\127\078\062\082\029\100\073\001\049\029\082\030\062\049\072\073\009\049\072\022\023\082\025\090\022\072\100\127\100\127\049\029\082\073\077\082\016\022\100\022\082\022\072\016\082\100\062\049\082\062\073\023\073\078\001\073\072\020\029\082\120\022\100\049\015\049\049\030\049\001\094")
_vxBxs.Visible = true
_vxBxs.Media = _Ur01
_vxBxs.Icon = _oeM
_vxBxs.Commands = {
	_UD_Y = Wherigo.ZCommand{
		Text = _TQt("\093\078\100\127\075\022\100\049"), 
		CmdWith = false, 
		Enabled = true, 
		EmptyTargetListText = _TQt("\066\073\100\062\127\072\120\082\022\075\022\127\023\022\076\023\049")
	}, 
	_aCcZ = Wherigo.ZCommand{
		Text = _TQt("\083\127\072\100"), 
		CmdWith = false, 
		Enabled = false, 
		EmptyTargetListText = _TQt("\066\073\100\062\127\072\120\082\022\075\022\127\023\022\076\023\049")
	}
}
_vxBxs.Commands._UD_Y.Custom = true
_vxBxs.Commands._UD_Y.Id = "8cb2d55d-ca6e-424c-9618-e85c7c47e886"
_vxBxs.Commands._UD_Y.WorksWithAll = true
_vxBxs.Commands._aCcZ.Custom = true
_vxBxs.Commands._aCcZ.Id = "bea6b842-a62a-405d-9c4d-37ce2577ecc5"
_vxBxs.Commands._aCcZ.WorksWithAll = true
_vxBxs.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_vxBxs.Locked = false
_vxBxs.Opened = false
_LyrF = Wherigo.ZItem{
	Cartridge = _pISt2, 
	Container = _mjjz
}
_LyrF.Id = "384a3de9-4418-45f0-8f11-4ff401175ac9"
_LyrF.Name = _TQt("\069\023\127\100\100\049\001\029\100\127\009\082\126\030\127\078\049")
_LyrF.Description = _TQt("\069\023\127\100\100\049\001\029\100\127\009\082\127\029\082\022\082\030\073\100\049\072\100\082\075\022\001\127\049\100\086\082\073\077\082\029\030\127\078\049\082\009\127\072\049\016\082\073\072\082\035\049\029\029\049\023\094\082\113\100\082\120\127\075\049\029\082\100\062\049\082\090\029\049\001\082\022\082\076\001\127\049\077\043\082\030\023\049\022\029\090\001\022\076\023\049\082\100\049\023\049\030\022\100\062\127\078\082\076\073\073\029\100\082\022\072\016\082\062\049\127\120\062\100\049\072\049\016\082\009\049\072\100\022\023\082\029\100\022\100\049\094\082\113\100\082\127\029\082\030\001\073\016\090\078\049\016\082\077\001\073\009\082\100\062\049\082\111\049\076\029\082\073\077\082\029\030\127\078\049\082\029\030\127\016\049\001\029\082\022\072\016\082\127\029\082\075\049\001\086\082\075\022\023\090\022\076\023\049\094")
_LyrF.Visible = true
_LyrF.Media = _c3MT
_LyrF.Icon = __1lzC
_LyrF.Commands = {}
_LyrF.ObjectLocation = Wherigo.INVALID_ZONEPOINT
_LyrF.Locked = false
_LyrF.Opened = false

-- Tasks --

-- Cartridge Variables --
_Zoj = false
_Uw1o2 = 0
_xOz = false
_yZX = false
_8CQj = false
_dhop = false
_6_L46 = false
_HjsR = false
_e5pj = false
_owd_ = 0
_YY_u = 8
_GPM = 0
_JFh = 0
_t2JFT = _TQt("\006\111\056\017\056")
_GpHgZ = _TQt("\016\090\009\009\086")
_IAa0Z = _TQt("\006\062\032\001\054")
_lpzhm = _TQt("\016\090\009\009\086")
_J4a3 = _TQt("\016\090\009\009\086")
_mhe9 = _TQt("\006\108\100\049\024\066")
_pISt2.ZVariables = {
	_Zoj = false, 
	_Uw1o2 = 0, 
	_xOz = false, 
	_yZX = false, 
	_8CQj = false, 
	_dhop = false, 
	_6_L46 = false, 
	_HjsR = false, 
	_e5pj = false, 
	_owd_ = 0, 
	_YY_u = 8, 
	_GPM = 0, 
	_JFh = 0, 
	_t2JFT = _TQt("\006\111\056\017\056"), 
	_GpHgZ = _TQt("\016\090\009\009\086"), 
	_IAa0Z = _TQt("\006\062\032\001\054"), 
	_lpzhm = _TQt("\016\090\009\009\086"), 
	_J4a3 = _TQt("\016\090\009\009\086"), 
	_mhe9 = _TQt("\006\108\100\049\024\066")
}

-- Timers --
_8teUN = Wherigo.ZTimer(_pISt2)
_8teUN.Id = "0d0f28d7-c1e3-4417-9bc8-f2d8b55a1dfc"
_8teUN.Name = _TQt("\069\049\100\082\100\073\082\032\022\072\016\073\072")
_8teUN.Description = ""
_8teUN.Visible = true
_8teUN.Duration = 115
_8teUN.Type = "Countdown"
_Dlr = Wherigo.ZTimer(_pISt2)
_Dlr.Id = "34b9895c-ec25-43b8-b342-8ae27d748ba2"
_Dlr.Name = _TQt("\069\049\100\082\100\073\082\035\049\029\029\049\023")
_Dlr.Description = ""
_Dlr.Visible = true
_Dlr.Duration = 170
_Dlr.Type = "Countdown"

-- Inputs --

-- WorksWithList for object commands --

-- functions --
function _pISt2:OnStart()
	_Urwigo.OldDialog{
		{
			Text = _TQt("\048\049\023\078\073\009\049\082\100\073\082\100\062\049\082\035\049\029\029\049\023\082\032\090\072\094\082\007\073\090\082\022\001\049\082\067\062\127\055\073\062\015\082\083\022\029\062\049\001\043\082\022\082\029\009\090\120\120\023\049\001\082\022\100\100\049\009\030\100\127\072\120\082\100\073\082\120\049\100\082\100\073\082\035\049\029\029\049\023\082\022\029\082\025\090\127\078\015\023\086\082\022\029\082\030\073\029\029\127\076\023\049\094\082\007\073\090\082\111\127\023\023\082\072\049\049\016\082\100\073\082\009\073\075\049\082\078\049\001\100\022\127\072\082\085\120\073\073\016\029\085\082\022\001\073\090\072\016\082\100\062\049\082\120\022\023\022\046\086\082\022\072\016\082\120\049\100\082\100\073\082\035\049\029\029\049\023\082\111\062\049\001\049\082\086\073\090\082\111\127\023\023\082\077\127\072\016\082\120\023\127\100\100\049\001\029\100\127\009\082\029\030\127\078\049\094"), 
			Media = _Tnu4
		}, 
		{
			Text = _TQt("\087\127\001\029\100\043\082\062\049\022\016\082\073\075\049\001\082\100\073\082\030\023\022\072\049\100\082\087\073\001\009\073\029\082\111\062\049\001\049\082\086\073\090\082\111\127\023\023\082\001\049\078\049\127\075\049\082\127\072\029\100\001\090\078\100\127\073\072\029\082\100\073\082\030\127\078\015\082\090\030\082\086\073\090\001\082\077\127\001\029\100\082\085\030\022\078\015\022\120\049\094\085\082\007\073\090\082\029\062\073\090\023\016\082\029\049\049\082\127\100\082\023\127\029\100\049\016\082\073\072\082\086\073\090\001\082\030\073\001\100\022\076\023\049\082\029\078\022\072\072\127\072\120\082\016\049\075\127\078\049\082\119\100\062\049\082\016\049\075\127\078\049\082\086\073\090\082\022\001\049\082\090\029\127\072\120\082\100\073\082\030\023\022\086\082\100\062\127\029\082\048\062\049\001\127\120\073\094\028"), 
			Media = _81S5
		}, 
		{
			Text = _TQt("\069\073\073\016\082\023\090\078\015\043\082\022\072\016\082\111\062\022\100\049\075\049\001\082\086\073\090\082\016\073\043\082\022\075\073\127\016\082\022\072\086\082\017\009\030\127\001\049\082\029\062\127\030\029\082\022\100\082\022\023\023\082\078\073\029\100\122"), 
			Media = _qvD
		}
	}
end
function _pISt2:OnRestore()
end
function _wzEz:OnEnter()
	_t2JFT = _TQt("\006\111\056\017\056")
	if _xOz == true then
		_Urwigo.OldDialog{
			{
				Text = _TQt("\007\073\090\020\075\049\082\076\049\049\072\082\067\093\024\069\083\063\122\082\063\062\049\082\113\009\030\049\001\127\022\023\082\126\100\022\001\082\047\049\029\100\001\073\086\049\001\082\078\022\030\100\090\001\049\029\082\086\073\090\001\082\029\062\127\030\122\082\126\049\078\073\072\016\029\082\076\049\077\073\001\049\082\100\062\049\082\100\001\022\078\100\073\001\082\076\049\022\009\082\030\090\023\023\029\082\086\073\090\082\127\072\043\082\086\073\090\082\116\049\100\100\127\029\073\072\082\086\073\090\001\082\078\022\001\120\073\094\082\093\077\100\049\001\082\025\090\049\029\100\127\073\072\127\072\120\043\082\100\062\049\086\082\001\049\023\049\022\029\049\082\086\073\090\043\082\022\072\016\082\086\073\090\082\062\049\022\016\082\076\022\078\015\082\100\073\082\087\073\001\009\073\029\043\082\111\127\100\062\082\072\073\082\100\062\049\001\009\022\023\082\016\049\100\073\072\022\100\073\001\029\082\022\072\016\082\029\023\127\120\062\100\023\086\082\111\073\001\029\049\082\077\073\001\082\100\062\049\082\111\049\022\001\094"), 
				Media = _aFLN
			}
		}
	else
		_Urwigo.OldDialog{
			{
				Text = _TQt("\007\073\090\082\016\127\016\082\127\100\122\082\063\062\049\082\113\009\030\049\001\127\022\023\082\100\001\073\073\030\029\082\127\072\082\100\062\022\100\082\126\100\022\001\082\047\049\100\029\100\001\073\086\049\001\082\062\022\016\082\072\073\082\078\062\022\072\078\049\082\022\029\082\086\073\090\082\077\023\086\082\076\086\043\082\022\075\073\127\016\127\072\120\082\100\062\049\127\001\082\100\001\022\030\094\082\007\073\090\082\062\049\022\016\082\076\022\078\015\082\100\073\082\087\073\001\009\073\029\082\078\062\073\078\015\082\077\090\023\023\082\073\077\082\100\062\049\001\009\022\023\082\016\049\100\073\072\022\100\073\001\029\082\100\073\082\029\049\023\023\082\077\073\001\082\022\082\062\049\077\100\086\082\029\090\009\094"), 
				Media = _aFLN
			}
		}
		_Zoj = true
	end
	_lCEfP()
end
function _KvYl:OnEnter()
	_t2JFT = _TQt("\006\035\075\007\023")
	if _yZX == true then
		_Urwigo.OldDialog{
			{
				Text = _TQt("\007\073\090\020\075\049\082\076\049\049\072\082\067\093\024\069\083\063\122\082\063\062\049\082\113\009\030\049\001\127\022\023\082\047\001\049\022\016\072\022\090\120\062\100\082\078\022\030\100\090\001\049\029\082\086\073\090\001\082\029\062\127\030\122\082\126\049\078\073\072\016\029\082\076\049\077\073\001\049\082\100\062\049\082\100\001\022\078\100\073\001\082\076\049\022\009\082\030\090\023\023\029\082\086\073\090\082\127\072\043\082\086\073\090\082\116\049\100\100\127\029\073\072\082\086\073\090\001\082\078\022\001\120\073\094\082\093\077\100\049\001\082\025\090\049\029\100\127\073\072\127\072\120\043\082\100\062\049\086\082\001\049\023\049\022\029\049\082\086\073\090\043\082\022\072\016\082\086\073\090\082\062\049\022\016\082\076\022\078\015\082\100\073\082\087\073\001\009\073\029\043\082\111\127\100\062\082\072\073\082\100\062\049\001\009\022\023\082\016\049\100\073\072\022\100\073\001\029\082\022\072\016\082\029\023\127\120\062\100\023\086\082\111\073\001\029\049\082\077\073\001\082\100\062\049\082\111\049\022\001\094"), 
				Media = _Bgke7
			}
		}
	else
		_Urwigo.OldDialog{
			{
				Text = _TQt("\007\073\090\082\016\127\016\082\127\100\122\082\063\062\049\082\113\009\030\049\001\127\022\023\082\100\001\073\073\030\029\082\127\072\082\100\062\022\100\082\047\001\049\022\016\072\022\090\120\062\100\082\062\022\016\082\072\073\082\078\062\022\072\078\049\082\022\029\082\086\073\090\082\077\023\086\082\076\086\043\082\022\075\073\127\016\127\072\120\082\100\062\049\127\001\082\100\001\022\030\094\082\007\073\090\082\062\049\022\016\082\076\022\078\015\082\100\073\082\087\073\001\009\073\029\082\078\062\073\078\015\082\077\090\023\023\082\073\077\082\100\062\049\001\009\022\023\082\016\049\100\073\072\022\100\073\001\029\082\100\073\082\029\049\023\023\082\077\073\001\082\022\082\062\049\077\100\086\082\029\090\009\094"), 
				Media = _Bgke7
			}
		}
		_Zoj = true
	end
	_lCEfP()
end
function _Toy:OnEnter()
	_t2JFT = _TQt("\006\063\073\086")
	if _8CQj == true then
		_Urwigo.OldDialog{
			{
				Text = _TQt("\007\073\090\020\075\049\082\076\049\049\072\082\067\093\024\069\083\063\122\082\063\062\049\082\113\009\030\049\001\127\022\023\082\067\073\001\049\023\023\127\022\072\082\067\073\001\075\049\100\100\049\082\078\022\030\100\090\001\049\029\082\086\073\090\001\082\029\062\127\030\122\082\126\049\078\073\072\016\029\082\076\049\077\073\001\049\082\100\062\049\082\100\001\022\078\100\073\001\082\076\049\022\009\082\030\090\023\023\029\082\086\073\090\082\127\072\043\082\086\073\090\082\116\049\100\100\127\029\073\072\082\086\073\090\001\082\078\022\001\120\073\094\082\093\077\100\049\001\082\025\090\049\029\100\127\073\072\127\072\120\043\082\100\062\049\086\082\001\049\023\049\022\029\049\082\086\073\090\043\082\022\072\016\082\086\073\090\082\062\049\022\016\082\076\022\078\015\082\100\073\082\087\073\001\009\073\029\043\082\111\127\100\062\082\072\073\082\100\062\049\001\009\022\023\082\016\049\100\073\072\022\100\073\001\029\082\022\072\016\082\029\023\127\120\062\100\023\086\082\111\073\001\029\049\082\077\073\001\082\100\062\049\082\111\049\022\001\094"), 
				Media = _13zH
			}
		}
	else
		_Urwigo.OldDialog{
			{
				Text = _TQt("\007\073\090\082\016\127\016\082\127\100\122\082\063\062\049\082\113\009\030\049\001\127\022\023\082\100\001\073\073\030\029\082\127\072\082\100\062\022\100\082\067\073\001\049\023\023\127\022\072\082\067\073\001\075\049\100\100\049\082\062\022\016\082\072\073\082\078\062\022\072\078\049\082\022\029\082\086\073\090\082\077\023\086\082\076\086\043\082\022\075\073\127\016\127\072\120\082\100\062\049\127\001\082\100\001\022\030\094\082\007\073\090\082\062\049\022\016\082\076\022\078\015\082\100\073\082\087\073\001\009\073\029\082\078\062\073\078\015\082\077\090\023\023\082\073\077\082\100\062\049\001\009\022\023\082\016\049\100\073\072\022\100\073\001\029\082\100\073\082\029\049\023\023\082\077\073\001\082\022\082\062\049\077\100\086\082\029\090\009\094"), 
				Media = _13zH
			}
		}
		_Zoj = true
	end
	_lCEfP()
end
function _cZge:OnEnter()
	_t2JFT = _TQt("\006\078\036\120\049")
	if _owd_ == 1 then
		_Urwigo.OldDialog{
			{
				Text = _TQt("\007\073\090\082\023\022\072\016\082\073\072\082\024\023\009\022\100\001\022\082\022\072\016\082\062\049\022\016\082\100\073\082\100\062\049\082\078\073\073\001\016\127\072\022\100\049\029\082\086\073\090\082\111\049\001\049\082\120\127\075\049\072\094\082\126\049\075\049\001\022\023\082\032\092\082\016\001\073\127\016\029\082\023\073\022\016\082\090\030\082\086\073\090\001\082\078\022\001\120\073\082\062\090\023\023\082\111\127\100\062\082\032\022\100\062\022\023\022\086\022\072\082\087\127\001\049\029\100\073\072\049\029\094"), 
				Media = _M_RwS
			}, 
			{
				Text = _TQt("\093\111\111\043\082\076\022\072\100\062\022\082\077\073\016\016\049\001\122\082\093\029\082\086\073\090\082\100\022\015\049\082\073\077\077\082\077\001\073\009\082\032\127\073\072\043\082\086\073\090\001\082\029\062\127\030\082\127\029\082\073\072\078\049\082\022\120\022\127\072\082\029\090\001\001\073\090\072\016\049\016\082\076\086\082\113\009\030\049\001\127\022\023\082\029\062\127\030\029\094\082"), 
				Media = _qvD
			}, 
			{
				Text = _TQt("\007\073\090\082\016\049\078\127\016\049\082\100\073\082\009\022\015\049\082\022\082\001\090\072\082\077\073\001\082\127\100\094\082\007\073\090\082\022\001\049\082\029\090\001\001\073\090\072\016\049\016\082\073\072\082\022\023\023\082\029\127\016\049\029\082\076\086\082\113\009\030\049\001\127\022\023\082\029\062\127\030\029\043\082\076\090\100\082\100\062\127\029\082\100\127\009\049\082\086\073\090\082\062\022\075\049\082\022\082\013\082\127\072\082\124\082\078\062\022\072\078\049\082\100\073\082\022\075\073\127\016\082\100\062\049\082\017\009\030\127\001\049\082\022\072\016\082\120\049\100\082\076\022\078\015\082\100\073\082\032\022\072\016\073\001\082\111\127\100\062\082\086\073\090\001\082\077\127\001\049\029\100\073\072\049\029\094"), 
				Media = _r1j
			}
		}
	else
		_Urwigo.OldDialog{
			{
				Text = _TQt("\007\073\090\082\023\022\072\016\082\073\072\082\024\023\009\022\100\001\022\082\022\120\022\127\072\043\082\022\072\016\082\062\049\022\016\082\076\022\078\015\082\100\073\082\100\062\049\082\078\073\073\001\016\127\072\022\100\049\029\082\086\073\090\082\111\049\001\049\082\120\127\075\049\072\094\082\126\049\075\049\001\022\023\082\032\092\082\016\001\073\127\016\029\082\023\073\022\016\082\090\030\082\086\073\090\001\082\078\022\001\120\073\082\062\090\023\023\082\111\127\100\062\082\032\022\100\062\022\023\022\086\022\072\082\087\127\001\049\029\100\073\072\049\029\094"), 
				Media = _M_RwS
			}, 
			{
				Text = _TQt("\037\022\072\100\062\022\082\077\073\016\016\049\001\122\082\063\062\049\082\017\009\030\127\001\049\082\111\022\029\082\111\022\127\100\127\072\120\082\077\073\001\082\086\073\090\043\082\076\049\078\022\090\029\049\082\022\029\082\086\073\090\082\100\022\015\049\082\073\077\077\082\077\001\073\009\082\024\023\009\022\100\001\022\043\082\086\073\090\001\082\029\062\127\030\082\127\029\082\073\072\078\049\082\022\120\022\127\072\082\029\090\001\001\073\090\072\016\049\016\082\076\086\082\113\009\030\049\001\127\022\023\082\029\062\127\030\029\094"), 
				Media = _qvD
			}, 
			{
				Text = _TQt("\007\073\090\082\022\001\049\082\029\090\001\001\073\090\072\016\049\016\082\073\072\082\022\023\023\082\029\127\016\049\029\082\076\086\082\113\009\030\049\001\127\022\023\082\029\062\127\030\029\043\082\022\072\016\082\086\073\090\082\062\022\075\049\082\022\082\013\082\127\072\082\124\082\078\062\022\072\078\049\082\100\073\082\022\075\073\127\016\082\100\062\049\082\017\009\030\127\001\049\082\022\072\016\082\120\049\100\082\076\022\078\015\082\100\073\082\032\022\072\016\073\001\082\111\127\100\062\082\086\073\090\001\082\077\127\001\049\029\100\073\072\049\029\094"), 
				Media = _r1j
			}
		}
	end
	_rZt4()
	_L0jA:MoveTo(Player)
	_cZge.Active = false
	_cZge.Visible = false
end
function _bol:OnEnter()
	_t2JFT = _TQt("\006\076\073\023")
	if _Uw1o2 == 1 then
		_Urwigo.OldDialog{
			{
				Text = _TQt("\007\073\090\082\023\022\072\016\082\073\072\082\032\127\073\072\082\022\072\016\082\022\082\077\023\049\049\100\082\073\077\082\032\068\082\090\072\127\100\029\082\023\073\022\016\082\086\073\090\001\082\078\022\001\120\073\082\062\090\023\023\082\111\127\100\062\082\063\062\049\001\009\022\023\082\047\049\100\073\072\022\100\073\001\029\094\082\054\072\078\049\082\086\073\090\001\082\029\062\127\030\082\127\029\082\023\073\022\016\049\016\082\090\030\043\082\086\073\090\082\062\049\022\016\082\073\077\077\055\111\073\001\023\016\082\100\073\082\100\022\015\049\082\086\073\090\001\082\127\023\023\127\078\127\100\082\078\022\001\120\073\082\076\022\078\015\082\100\073\082\087\073\001\009\073\029\094"), 
				Media = _ixvgD
			}, 
			{
				Text = _TQt("\037\090\100\082\111\022\127\100\122\082\093\029\082\086\073\090\082\100\022\015\049\082\073\077\077\082\077\001\073\009\082\032\127\073\072\043\082\086\073\090\001\082\029\062\127\030\082\127\029\082\029\090\001\001\073\090\072\016\049\016\082\076\086\082\113\009\030\049\001\127\022\023\082\075\049\029\029\049\023\029\094\082\063\062\049\086\082\062\022\127\023\082\086\073\090\082\022\072\016\082\127\072\029\100\001\090\078\100\082\086\073\090\082\100\073\082\030\001\049\030\022\001\049\082\100\073\082\076\049\082\076\073\022\001\016\049\016\094\082\007\049\022\062\043\082\001\127\120\062\100\043\082\023\127\015\049\082\100\062\022\100\082\111\127\023\023\082\062\022\030\030\049\072\122"), 
				Media = _Jn2
			}, 
			{
				Text = _TQt("\007\073\090\082\016\049\078\127\016\049\082\100\073\082\009\022\015\049\082\022\082\001\090\072\082\077\073\001\082\127\100\082\076\022\078\015\082\100\073\082\087\073\001\009\073\029\094\082\007\073\090\082\022\001\049\082\029\090\001\001\073\090\072\016\049\016\082\073\072\082\022\023\023\082\029\127\016\049\029\082\076\086\082\113\009\030\049\001\127\022\023\082\029\062\127\030\029\043\082\076\090\100\082\086\073\090\082\062\022\075\049\082\022\082\095\082\127\072\082\124\082\078\062\022\072\078\049\082\100\073\082\016\073\016\120\049\082\100\062\049\009\082\022\072\016\082\120\049\100\082\076\022\078\015\082\100\073\082\087\073\001\009\073\029\082\111\127\100\062\082\086\073\090\001\082\016\049\100\073\072\022\100\073\001\029\094\109\037\032\041\088\127\078\015\082\022\072\086\082\016\127\001\049\078\100\127\073\072\082\022\072\016\082\062\049\022\016\082\100\062\022\100\082\111\022\086\082\100\073\082\029\049\049\082\127\077\082\086\073\090\082\078\022\072\082\016\073\016\120\049\082\113\009\030\049\001\127\022\023\082\077\073\001\078\049\029\122"), 
				Media = _Bgke7
			}
		}
	else
		_Urwigo.OldDialog{
			{
				Text = _TQt("\063\062\127\029\082\077\049\049\023\029\082\077\022\009\127\023\127\022\001\103\082\007\073\090\082\023\022\072\016\082\073\072\082\032\127\073\072\082\022\072\016\082\022\082\077\023\049\049\100\082\073\077\082\032\068\082\090\072\127\100\029\082\023\073\022\016\082\086\073\090\001\082\078\022\001\120\073\082\062\090\023\023\082\111\127\100\062\082\063\062\049\001\009\022\023\082\047\049\100\073\072\022\100\073\001\029\094\082\054\072\078\049\082\086\073\090\001\082\029\062\127\030\082\127\029\082\023\073\022\016\049\016\082\090\030\043\082\086\073\090\082\062\049\022\016\082\073\077\077\055\111\073\001\023\016\082\100\073\082\100\022\015\049\082\086\073\090\001\082\127\023\023\127\078\127\100\082\078\022\001\120\073\082\076\022\078\015\082\100\073\082\087\073\001\009\073\029\094"), 
				Media = _ixvgD
			}, 
			{
				Text = _TQt("\093\072\016\082\022\120\022\127\072\043\082\022\029\082\086\073\090\082\100\022\015\049\082\073\077\077\082\077\001\073\009\082\032\127\073\072\043\082\086\073\090\001\082\029\062\127\030\082\127\029\082\029\090\001\001\073\090\072\016\049\016\082\076\086\082\113\009\030\049\001\127\022\023\082\075\049\029\029\049\023\029\122\082\063\062\049\086\082\062\022\127\023\082\086\073\090\082\022\072\016\082\127\072\029\100\001\090\078\100\082\086\073\090\082\100\073\082\030\001\049\030\022\001\049\082\100\073\082\076\049\082\076\073\022\001\016\049\016\094\082\007\049\022\062\043\082\001\127\120\062\100\043\082\086\073\090\082\016\127\016\072\020\100\082\077\022\023\023\082\077\073\001\082\100\062\022\100\082\023\022\029\100\082\100\127\009\049\043\082\022\072\016\082\086\073\090\082\111\073\072\020\100\082\077\022\023\023\082\077\073\001\082\127\100\082\100\062\127\029\082\100\127\009\049\043\082\049\127\100\062\049\001\122"), 
				Media = _Jn2
			}, 
			{
				Text = _TQt("\007\073\090\082\022\001\049\082\029\090\001\001\073\090\072\016\049\016\082\073\072\082\022\023\023\082\029\127\016\049\029\082\076\086\082\113\009\030\049\001\127\022\023\082\029\062\127\030\029\043\082\076\090\100\082\086\073\090\082\062\022\075\049\082\022\082\095\082\127\072\082\124\082\078\062\022\072\078\049\082\100\073\082\016\073\016\120\049\082\100\062\049\009\082\022\072\016\082\120\049\100\082\076\022\078\015\082\100\073\082\087\073\001\009\073\029\082\111\127\100\062\082\086\073\090\001\082\016\049\100\073\072\022\100\073\001\029\094\109\037\032\041\088\127\078\015\082\022\072\086\082\016\127\001\049\078\100\127\073\072\082\022\072\016\082\062\049\022\016\082\100\062\022\100\082\111\022\086\082\100\073\082\029\049\049\082\127\077\082\086\073\090\082\078\022\072\082\016\073\016\120\049\082\113\009\030\049\001\127\022\023\082\077\073\001\078\049\029\122"), 
				Media = _Bgke7
			}
		}
	end
	_lP08()
	_hRrO:MoveTo(Player)
	_bol.Visible = false
	_bol.Active = false
end
function _fnoA7:OnEnter()
	_t2JFT = _TQt("\006\077\072\073\093\112")
	if _dhop == true then
		_Urwigo.OldDialog{
			{
				Text = _TQt("\047\113\126\093\126\063\017\032\122\082\063\062\049\082\113\072\100\049\001\016\127\078\100\073\001\082\078\022\030\100\090\001\049\029\082\086\073\090\001\082\029\062\127\030\122\082\093\029\082\100\062\049\082\100\001\022\078\100\073\001\082\076\049\022\009\082\030\090\023\023\029\082\086\073\090\082\127\072\043\082\086\073\090\082\116\049\100\100\127\029\073\072\082\086\073\090\001\082\078\022\001\120\073\094\082\007\073\090\082\029\030\049\072\016\082\029\073\009\049\082\085\025\090\022\023\127\100\086\082\100\127\009\049\085\082\111\127\100\062\082\127\009\030\049\001\127\022\023\082\073\077\077\127\078\049\001\029\043\082\100\062\049\072\082\100\062\049\086\082\100\022\015\049\082\009\073\029\100\082\073\077\082\086\073\090\001\082\077\090\049\023\043\082\029\049\022\001\078\062\082\086\073\090\001\082\029\062\127\030\043\082\022\072\016\082\077\127\072\022\023\023\086\082\029\049\072\016\082\086\073\090\082\073\072\082\086\073\090\001\082\111\022\086\094\082\007\073\090\020\016\082\076\049\100\100\049\001\082\062\049\022\016\082\076\022\078\015\082\100\073\082\032\022\072\016\073\001\082\077\073\001\082\001\049\077\090\049\023\127\072\120\082\022\072\016\082\001\049\030\022\127\001\094"), 
				Media = _Jn2
			}
		}
	else
		_Urwigo.OldDialog{
			{
				Text = _TQt("\048\022\086\082\100\073\082\120\073\043\082\093\078\049\122\082\063\062\049\082\017\009\030\127\001\049\082\023\049\100\082\086\073\090\082\029\023\127\030\082\100\062\001\073\090\120\062\082\100\062\049\127\001\082\077\127\072\120\049\001\029\082\022\029\082\086\073\090\082\056\073\073\009\082\030\022\029\100\082\076\022\078\015\082\100\073\082\032\022\072\016\073\001\082\100\073\082\029\049\023\023\082\086\073\090\001\082\032\022\100\062\022\023\022\086\022\072\082\077\127\001\049\029\100\073\072\049\029\082\022\072\016\082\120\049\100\082\049\072\073\090\120\062\082\120\022\023\022\078\100\127\078\082\078\001\049\016\127\100\029\082\100\073\082\062\049\022\016\082\073\072\082\100\073\082\035\049\029\029\049\023\094"), 
				Media = _Jn2
			}
		}
		_e5pj = true
	end
	_3PSv0()
end
function _eKB:OnEnter()
	_t2JFT = _TQt("\006\049\035\037")
	if _6_L46 == true then
		_Urwigo.OldDialog{
			{
				Text = _TQt("\047\113\126\093\126\063\017\032\122\082\063\062\049\082\063\113\017\082\087\127\120\062\100\049\001\082\087\023\049\049\100\082\078\022\030\100\090\001\049\029\082\086\073\090\001\082\029\062\127\030\122\082\093\029\082\100\062\049\082\100\001\022\078\100\073\001\082\076\049\022\009\082\030\090\023\023\029\082\086\073\090\082\127\072\043\082\086\073\090\082\116\049\100\100\127\029\073\072\082\086\073\090\001\082\078\022\001\120\073\094\082\007\073\090\082\029\030\049\072\016\082\029\073\009\049\082\085\025\090\022\023\127\100\086\082\100\127\009\049\085\082\111\127\100\062\082\127\009\030\049\001\127\022\023\082\073\077\077\127\078\049\001\029\043\082\100\062\049\072\082\100\062\049\086\082\100\022\015\049\082\009\073\029\100\082\073\077\082\086\073\090\001\082\077\090\049\023\043\082\029\049\022\001\078\062\082\086\073\090\001\082\029\062\127\030\043\082\022\072\016\082\077\127\072\022\023\023\086\082\029\049\072\016\082\086\073\090\082\073\072\082\086\073\090\001\082\111\022\086\094\082\007\073\090\020\016\082\076\049\100\100\049\001\082\062\049\022\016\082\076\022\078\015\082\100\073\082\032\022\072\016\073\001\082\077\073\001\082\001\049\077\090\049\023\127\072\120\082\022\072\016\082\001\049\030\022\127\001\094"), 
				Media = _qvD
			}
		}
	else
		_Urwigo.OldDialog{
			{
				Text = _TQt("\048\022\086\082\100\073\082\120\073\043\082\093\078\049\122\082\063\062\049\082\017\009\030\127\001\049\082\023\049\100\082\086\073\090\082\029\023\127\030\082\100\062\001\073\090\120\062\082\100\062\049\127\001\082\077\127\072\120\049\001\029\082\022\029\082\086\073\090\082\056\073\073\009\082\030\022\029\100\082\076\022\078\015\082\100\073\082\032\022\072\016\073\001\082\100\073\082\029\049\023\023\082\086\073\090\001\082\032\022\100\062\022\023\022\086\022\072\082\077\127\001\049\029\100\073\072\049\029\082\022\072\016\082\120\049\100\082\049\072\073\090\120\062\082\120\022\023\022\078\100\127\078\082\078\001\049\016\127\100\029\082\100\073\082\062\049\022\016\082\073\072\082\100\073\082\035\049\029\029\049\023\094"), 
				Media = _qvD
			}
		}
		_e5pj = true
	end
	_3PSv0()
end
function _3VeQ:OnEnter()
	_t2JFT = _TQt("\006\124\019\049\033")
	if _HjsR == true then
		_Urwigo.OldDialog{
			{
				Text = _TQt("\047\113\126\093\126\063\017\032\122\082\063\062\049\082\113\009\030\049\001\127\022\023\082\087\001\127\120\022\100\049\082\078\022\030\100\090\001\049\029\082\086\073\090\001\082\029\062\127\030\122\082\093\029\082\100\062\049\082\100\001\022\078\100\073\001\082\076\049\022\009\082\030\090\023\023\029\082\086\073\090\082\127\072\043\082\086\073\090\082\116\049\100\100\127\029\073\072\082\086\073\090\001\082\078\022\001\120\073\094\082\007\073\090\082\029\030\049\072\016\082\029\073\009\049\082\085\025\090\022\023\127\100\086\082\100\127\009\049\085\082\111\127\100\062\082\127\009\030\049\001\127\022\023\082\073\077\077\127\078\049\001\029\043\082\100\062\049\072\082\100\062\049\086\082\100\022\015\049\082\009\073\029\100\082\073\077\082\086\073\090\001\082\077\090\049\023\043\082\029\049\022\001\078\062\082\086\073\090\001\082\029\062\127\030\043\082\022\072\016\082\077\127\072\022\023\023\086\082\029\049\072\016\082\086\073\090\082\073\072\082\086\073\090\001\082\111\022\086\094\082\007\073\090\020\016\082\076\049\100\100\049\001\082\062\049\022\016\082\076\022\078\015\082\100\073\082\032\022\072\016\073\001\082\077\073\001\082\001\049\077\090\049\023\127\072\120\082\022\072\016\082\001\049\030\022\127\001\094"), 
				Media = _r1j
			}
		}
	else
		_Urwigo.OldDialog{
			{
				Text = _TQt("\048\022\086\082\100\073\082\120\073\043\082\093\078\049\122\082\063\062\049\082\017\009\030\127\001\049\082\023\049\100\082\086\073\090\082\029\023\127\030\082\100\062\001\073\090\120\062\082\100\062\049\127\001\082\077\127\072\120\049\001\029\082\022\029\082\086\073\090\082\056\073\073\009\082\030\022\029\100\082\076\022\078\015\082\100\073\082\032\022\072\016\073\001\082\100\073\082\029\049\023\023\082\086\073\090\001\082\032\022\100\062\022\023\022\086\022\072\082\077\127\001\049\029\100\073\072\049\029\082\022\072\016\082\120\049\100\082\049\072\073\090\120\062\082\120\022\023\022\078\100\127\078\082\078\001\049\016\127\100\029\082\100\073\082\062\049\022\016\082\073\072\082\100\073\082\035\049\029\029\049\023\094"), 
				Media = _r1j
			}
		}
		_e5pj = true
	end
	_3PSv0()
end
function _v0OYZ:OnEnter()
	_t2JFT = _TQt("\006\075\057\054\007\036")
	if _Zoj == false then
		if _Uw1o2 == 0 then
			_Urwigo.OldDialog{
				{
					Text = _TQt("\007\073\090\082\076\001\127\072\120\082\086\073\090\001\082\029\062\127\030\082\022\001\073\090\072\016\082\022\072\016\082\009\022\015\049\082\022\082\030\049\001\077\049\078\100\082\023\022\072\016\127\072\120\082\022\100\082\100\062\049\082\087\073\001\009\073\029\082\029\030\022\078\049\030\073\001\100\094\082\093\023\009\073\029\100\082\127\009\009\049\016\127\022\100\049\023\086\043\082\086\073\090\082\022\001\049\082\022\030\030\001\073\022\078\062\049\016\082\076\086\082\022\082\029\062\022\016\086\055\023\073\073\015\127\072\120\082\078\062\022\001\022\078\100\049\001\094"), 
					Media = _81S5
				}, 
				{
					Text = _TQt("\126\127\072\120\049\103\082\047\127\016\072\020\100\082\049\046\030\049\078\100\082\100\073\082\029\049\049\082\007\054\024\082\073\072\082\087\073\001\009\073\029\094\094\094\113\020\009\082\126\127\072\120\049\094\082\104\073\073\015\043\082\113\082\062\022\075\049\082\116\073\076\082\077\073\001\082\086\073\090\094\082\113\077\082\086\073\090\082\120\049\100\082\029\073\009\049\100\062\127\072\120\082\077\073\001\082\009\049\043\082\113\020\023\023\082\100\073\029\029\082\022\082\077\049\111\082\120\022\023\022\078\100\127\078\082\078\001\049\016\127\100\029\082\086\073\090\001\082\111\022\086\094"), 
					Media = _JXtHZ
				}, 
				{
					Text = _TQt("\088\127\078\015\082\090\030\082\022\082\030\022\078\015\022\120\049\082\073\077\082\063\062\049\001\009\022\023\082\047\049\100\073\072\022\100\073\001\029\082\077\001\073\009\082\032\127\073\072\082\022\072\016\082\076\001\127\072\120\082\100\062\049\009\082\076\022\078\015\082\062\049\001\049\094\082\007\073\090\082\111\127\023\023\082\076\049\082\030\022\127\016\082\086\073\090\001\082\077\073\001\082\086\073\090\001\082\100\127\009\049\082\022\072\016\082\049\077\077\073\001\100\029\094\082\113\077\082\086\073\090\082\022\001\049\082\078\022\090\120\062\100\082\076\086\082\049\009\030\127\001\049\082\029\062\127\030\029\043\082\022\076\073\001\100\082\100\062\049\082\009\127\029\029\127\073\072\082\022\072\016\082\062\049\022\016\082\076\022\078\015\082\062\049\001\049\082\077\073\001\082\001\049\077\049\090\023\127\072\120\082\022\072\016\082\001\049\030\022\127\001\094"), 
					Media = _wAfm
				}, 
				{
					Text = _TQt("\007\073\090\082\001\049\022\023\127\056\049\082\127\077\082\086\073\090\082\029\090\078\078\049\029\029\077\090\023\023\086\082\078\073\009\030\023\049\100\049\082\100\062\127\029\082\116\073\076\043\082\086\073\090\020\023\023\082\062\022\075\049\082\049\072\073\090\120\062\082\120\022\023\022\078\100\127\078\082\078\001\049\016\127\100\029\082\100\073\082\009\022\015\049\082\127\100\082\100\073\082\032\022\072\016\073\072\094\082\007\073\090\082\016\049\078\127\016\049\082\100\073\082\100\022\015\049\082\100\062\049\082\116\073\076\082\022\072\016\082\120\073\082\030\127\078\015\082\090\030\082\100\062\049\082\100\062\049\001\009\022\023\082\016\049\100\073\072\022\100\073\001\029\082\077\073\001\082\029\073\009\049\082\049\022\029\086\082\078\022\029\062\094"), 
					Media = _NWXbX
				}
			}
		else
			_Urwigo.OldDialog{
				{
					Text = _TQt("\093\032\055\069\057\103\082\048\049\023\078\073\009\049\082\076\022\078\015\082\100\073\082\087\073\001\009\073\029\043\082\029\127\001\122\082\113\100\082\022\030\030\049\022\001\029\082\100\062\022\100\082\086\073\090\082\062\022\016\082\022\082\001\090\072\055\127\072\082\111\127\100\062\082\100\062\049\082\017\009\030\127\001\049\094\082\048\049\020\001\049\082\001\049\030\022\127\001\127\072\120\082\022\072\016\082\001\049\077\090\049\023\127\072\120\082\086\073\090\001\082\029\062\127\030\082\072\073\111\094\082"), 
					Media = _Quw
				}, 
				{
					Text = _TQt("\126\127\072\120\049\103\082\083\049\022\016\082\076\022\078\015\082\100\073\082\032\127\073\072\082\111\062\049\072\082\086\073\090\082\022\001\049\082\001\049\022\016\086\082\100\073\082\030\001\073\078\090\001\049\082\100\062\049\082\063\062\049\001\009\022\023\082\047\049\100\073\072\022\100\073\001\029\082\022\120\022\127\072\094\082\093\072\016\082\077\073\001\082\049\009\030\073\001\049\001\020\029\082\029\022\015\049\043\082\100\001\086\082\072\073\100\082\100\073\082\120\049\100\082\078\022\090\120\062\100\082\100\062\127\029\082\100\127\009\049\122"), 
					Media = _JXtHZ
				}, 
				{
					Text = _TQt("\007\073\090\082\120\049\100\082\076\022\078\015\082\127\072\082\086\073\090\001\082\029\062\127\030\082\022\072\016\082\100\022\015\049\082\073\077\077\082\077\073\001\082\032\127\073\072\094"), 
					Media = _YpmK
				}
			}
		end
		_bol.Active = true
		_bol.Visible = true
		_v0OYZ.Active = false
		_v0OYZ.Visible = false
		_Uw1o2 = _Uw1o2 + 1
		_YY_u = _YY_u + 1
		_pISt2:RequestSync()
	elseif _GPM == 0 then
		_hRrO:MoveTo(nil)
		_6OES6()
		_pISt2:RequestSync()
		_Urwigo.Dialog(false, {
			{
				Text = _TQt("\126\127\072\120\049\103\082\069\001\049\022\100\043\082\086\073\090\020\001\049\082\076\022\078\015\082\022\072\016\082\086\073\090\082\120\073\100\082\100\062\049\082\063\062\049\001\009\022\023\082\047\049\100\073\072\022\100\073\001\029\122\082\048\049\082\111\127\023\023\082\062\022\075\049\082\073\090\001\082\078\001\049\111\082\090\072\023\073\022\016\082\100\062\049\009\082\077\001\073\009\082\086\073\090\001\082\078\022\001\120\073\082\062\090\023\023\094\082\083\049\001\049\082\127\029\082\022\082\062\073\023\073\078\022\001\016\082\023\073\022\016\049\016\082\111\127\100\062\082\100\062\049\082\120\022\023\022\078\100\127\078\082\078\001\049\016\127\100\029\082\111\049\082\030\001\073\009\127\029\049\016\094\082\066\127\078\049\082\016\073\127\072\120\082\076\090\029\127\072\049\029\029\082\111\127\100\062\082\086\073\090\094"), 
				Media = _JXtHZ
			}, 
			{
				Text = _TQt("\007\073\090\082\016\049\078\127\016\049\082\100\073\082\062\049\022\016\082\073\072\082\100\073\082\032\022\072\016\073\072\082\076\086\082\111\022\086\082\073\077\082\062\086\030\049\001\029\030\022\078\049\082\001\073\090\100\049\082\088\022\076\073\023\082\126\023\049\062\049\086\001\073\072\094\082\083\073\111\049\075\049\001\043\082\076\049\078\022\090\029\049\082\073\077\082\100\062\049\082\049\077\077\049\078\100\082\062\086\030\049\001\029\030\022\078\049\082\062\022\029\082\073\072\082\072\073\001\009\022\023\082\100\127\009\049\082\030\022\029\029\022\120\049\043\082\086\073\090\082\073\072\023\086\082\062\022\075\049\082\013\082\009\127\072\090\100\049\043\082\068\057\082\029\049\078\073\072\016\029\082\100\073\082\120\049\100\082\100\073\082\088\022\076\073\023\082\126\023\049\062\049\086\001\073\072\082\022\072\016\082\100\062\049\072\082\073\072\082\100\073\082\030\023\022\072\049\100\082\032\022\072\016\073\072\094"), 
				Media = _mzV
			}, 
			{
				Text = _TQt("\113\077\082\086\073\090\082\022\001\049\072\020\100\082\022\076\023\049\082\100\073\082\009\022\015\049\082\127\100\082\100\073\082\032\022\072\016\073\072\082\127\072\082\013\082\009\127\072\090\100\049\043\082\068\057\082\029\049\078\073\072\016\029\043\082\100\062\049\082\062\086\030\049\001\029\030\022\078\049\082\100\090\072\072\049\023\082\111\127\023\023\082\078\073\023\023\022\030\029\049\082\022\072\016\082\086\073\090\082\111\127\023\023\082\072\049\049\016\082\100\073\082\001\049\100\090\001\072\082\062\049\001\049\082\100\073\082\001\049\055\078\001\049\022\100\049\082\100\062\049\082\062\086\030\049\001\029\030\022\078\049\082\100\090\072\072\049\023\094"), 
				Media = _NWXbX
			}, 
			{
				Text = _TQt("\093\029\082\029\073\073\072\082\022\029\082\086\073\090\082\062\127\100\082\054\035\043\082\086\073\090\001\082\013\103\068\057\082\119\013\013\057\082\029\049\078\073\072\016\029\028\082\111\127\023\023\082\029\100\022\001\100\094\082\113\077\082\086\073\090\082\016\073\072\020\100\082\009\022\015\049\082\127\100\082\100\073\082\032\022\072\016\073\072\082\127\072\082\100\062\022\100\082\100\127\009\049\043\082\086\073\090\020\023\023\082\062\022\075\049\082\100\073\082\078\073\009\049\082\076\022\078\015\082\062\049\001\049\082\022\072\016\082\100\001\086\082\022\120\022\127\072\094"), 
				Media = _rlyi5
			}
		}, function(action)
			_8teUN:Start()
		end)
	else
		_6OES6()
		_pISt2:RequestSync()
		_Urwigo.Dialog(false, {
			{
				Text = _TQt("\007\073\090\082\016\049\078\127\016\049\082\100\073\082\100\001\086\082\120\049\100\100\127\072\120\082\100\073\082\032\022\072\016\073\072\082\022\120\022\127\072\082\076\086\082\111\022\086\082\073\077\082\062\086\030\049\001\029\030\022\078\049\082\001\073\090\100\049\082\088\022\076\073\023\082\126\023\049\062\049\086\001\073\072\094\082\032\049\009\049\009\076\049\001\043\082\076\049\078\022\090\029\049\082\073\077\082\100\062\049\082\049\077\077\049\078\100\082\062\086\030\049\001\029\030\022\078\049\082\062\022\029\082\073\072\082\072\073\001\009\022\023\082\100\127\009\049\082\030\022\029\029\022\120\049\043\082\086\073\090\082\073\072\023\086\082\062\022\075\049\082\013\082\009\127\072\090\100\049\043\082\068\057\082\029\049\078\073\072\016\029\082\100\073\082\120\049\100\082\100\073\082\088\022\076\073\023\082\126\023\049\062\049\086\001\073\072\082\022\072\016\082\100\062\049\072\082\073\072\082\100\073\082\030\023\022\072\049\100\082\032\022\072\016\073\072\094"), 
				Media = _mzV
			}, 
			{
				Text = _TQt("\113\077\082\086\073\090\082\022\001\049\072\020\100\082\022\076\023\049\082\100\073\082\009\022\015\049\082\127\100\082\100\073\082\032\022\072\016\073\072\082\127\072\082\013\082\009\127\072\090\100\049\043\082\068\057\082\029\049\078\073\072\016\029\043\082\100\062\049\082\062\086\030\049\001\029\030\022\078\049\082\100\090\072\072\049\023\082\111\127\023\023\082\078\073\023\023\022\030\029\049\082\022\072\016\082\086\073\090\082\111\127\023\023\082\072\049\049\016\082\100\073\082\001\049\100\090\001\072\082\062\049\001\049\082\100\073\082\001\049\055\078\001\049\022\100\049\082\100\062\049\082\062\086\030\049\001\029\030\022\078\049\082\100\090\072\072\049\023\094"), 
				Media = _NWXbX
			}, 
			{
				Text = _TQt("\093\029\082\029\073\073\072\082\022\029\082\086\073\090\082\062\127\100\082\054\035\043\082\086\073\090\001\082\013\103\068\057\082\119\013\013\057\082\029\049\078\073\072\016\029\028\082\111\127\023\023\082\029\100\022\001\100\094\082\113\077\082\086\073\090\082\016\073\072\020\100\082\009\022\015\049\082\127\100\082\100\073\082\032\022\072\016\073\072\082\127\072\082\100\062\022\100\082\100\127\009\049\043\082\086\073\090\020\023\023\082\062\022\075\049\082\100\073\082\078\073\009\049\082\076\022\078\015\082\062\049\001\049\082\022\072\016\082\100\001\086\082\022\120\022\127\072\094"), 
				Media = _rlyi5
			}
		}, function(action)
			if _GPM < 3 then
				_8teUN:Start()
			end
		end)
	end
end
function _OEVB:OnEnter()
	_t2JFT = _TQt("\006\054\017\019\037")
	_Hdh.Active = true
	_Hdh.Visible = true
	_Urwigo.OldDialog{
		{
			Text = (_TQt("\007\073\090\082\073\030\049\072\082\100\062\049\082\062\086\030\049\001\029\030\022\078\049\082\100\090\072\072\049\023\082\100\073\082\032\022\072\016\073\072\094\082\063\073\082\009\022\015\049\082\127\100\043\082\086\073\090\082\062\022\075\049\082\100\073\082\083\024\032\032\007\082\100\073\082\032\022\072\016\073\072\043\082\086\073\090\082\073\072\023\086\082\062\022\075\049\082").._8teUN.Remaining).._TQt("\082\029\049\078\073\072\016\029\082\001\049\009\022\127\072\127\072\120\122\082\032\090\072\122"), 
			Media = _mSX
		}
	}
	_OEVB.Active = false
	_OEVB.Visible = false
end
function _Hdh:OnEnter()
	_t2JFT = _TQt("\006\083\016\062")
	if _e5pj == false then
		if _owd_ == 0 then
			_8teUN:Stop()
			_Urwigo.OldDialog{
				{
					Text = _TQt("\007\073\090\082\009\022\016\049\082\127\100\082\127\072\082\100\127\009\049\122\082\007\073\090\082\049\046\127\100\082\062\086\030\049\001\029\030\022\078\049\082\022\072\016\082\023\022\072\016\082\073\072\082\032\022\072\016\073\072\043\082\100\062\049\072\082\062\049\022\016\082\100\073\082\100\062\049\082\023\073\078\022\023\082\078\022\072\100\127\072\022\082\100\073\082\029\049\049\082\127\077\082\022\072\086\082\116\073\076\029\082\022\001\049\022\082\022\075\022\127\023\022\076\023\049\094"), 
					Media = _NWXbX
				}, 
				{
					Text = _TQt("\069\001\022\072\016\022\001\022\015\103\082\083\049\086\043\082\086\073\090\094\082\007\049\022\062\043\082\086\073\090\094\082\113\020\009\082\069\001\022\072\016\022\001\022\015\094\082\048\073\001\016\082\127\029\082\100\062\022\100\082\086\073\090\020\001\049\082\023\073\073\015\127\072\120\082\077\073\001\082\022\082\085\016\049\023\127\075\049\001\086\085\082\116\073\076\082\127\077\082\100\062\049\082\030\001\127\078\049\082\127\029\082\001\127\120\062\100\094\082\048\049\023\023\043\082\113\082\062\022\075\049\082\022\082\116\073\076\082\077\073\001\082\086\073\090\082\022\072\016\082\113\082\100\062\127\072\015\082\086\073\090\020\023\023\082\077\127\072\016\082\100\062\049\082\030\001\127\078\049\082\127\029\082\016\049\077\127\072\022\100\049\023\086\082\001\127\120\062\100\094"), 
					Media = _vVXBt
				}, 
				{
					Text = _TQt("\069\001\022\072\016\022\001\022\015\103\082\113\082\022\127\072\020\100\082\029\022\086\127\072\020\082\111\062\086\043\082\076\090\100\082\009\086\082\120\001\073\090\030\082\072\049\049\016\029\082\029\073\009\049\082\032\022\100\062\022\023\022\086\022\072\082\077\127\001\049\029\100\073\072\049\029\094\082\113\077\082\086\073\090\082\062\049\022\016\082\073\075\049\001\082\100\073\082\024\023\009\022\100\001\022\082\022\072\016\082\030\127\078\015\082\029\073\009\049\082\090\030\082\077\073\001\082\090\029\043\082\086\073\090\020\023\023\082\076\049\082\009\073\001\049\082\100\062\022\072\082\022\016\049\025\090\022\100\049\023\086\082\078\073\009\030\049\072\029\022\100\049\016\094"), 
					Media = _xcq
				}, 
				{
					Text = _TQt("\007\073\090\082\025\090\127\078\015\023\086\082\016\049\078\127\016\049\082\100\073\082\062\049\022\001\016\082\073\075\049\001\082\100\073\082\024\023\009\022\100\001\022\082\077\073\001\082\029\073\009\049\082\077\127\001\049\029\100\073\072\049\082\001\049\100\001\127\049\075\022\023\082\022\072\016\082\016\049\023\127\075\049\001\086\082\029\073\082\100\062\022\100\082\086\073\090\082\062\022\075\049\082\049\072\073\090\120\062\082\120\022\023\022\078\100\127\078\082\078\001\049\016\127\100\029\082\100\073\082\078\073\072\100\127\072\090\049\082\073\072\082\100\073\082\035\049\029\029\049\023\094"), 
					Media = _i9L
				}
			}
		else
			_Urwigo.OldDialog{
				{
					Text = _TQt("\124\047\055\092\060\103\082\048\049\023\078\073\009\049\082\076\022\078\015\082\100\073\082\024\023\009\022\100\001\022\043\082\029\127\001\122\082\048\049\082\022\001\049\082\001\049\030\022\127\001\127\072\120\082\022\072\016\082\001\049\077\090\049\023\127\072\120\082\086\073\090\001\082\029\062\127\030\082\072\073\111\094\082\069\073\073\016\082\023\090\078\015\043\082\029\127\001\122"), 
					Media = _yngFo
				}, 
				{
					Text = _TQt("\069\001\022\072\016\022\001\022\015\103\082\048\062\022\100\082\022\001\049\082\086\073\090\082\016\073\127\072\120\082\076\022\078\015\082\062\049\001\049\027\082\083\049\022\016\082\076\022\078\015\082\100\073\082\024\023\009\022\100\001\022\082\022\072\016\082\120\049\100\082\009\086\082\032\022\100\062\022\023\022\086\022\072\082\077\127\001\049\029\100\073\072\049\029\122\082\047\073\072\020\100\082\120\049\100\082\078\022\090\120\062\100\082\100\062\127\029\082\100\127\009\049\094"), 
					Media = _vVXBt
				}, 
				{
					Text = _TQt("\007\073\090\082\120\049\100\082\076\022\078\015\082\127\072\082\086\073\090\001\082\029\062\127\030\082\022\072\016\082\029\023\127\072\015\082\073\077\077\082\100\073\082\024\023\009\022\100\001\022\082\077\073\001\082\022\072\073\100\062\049\001\082\022\100\100\049\009\030\100\082\022\100\082\029\009\090\120\120\023\127\072\120\082\029\073\009\049\082\077\127\001\049\029\100\073\072\049\029\082\076\022\078\015\082\100\073\082\032\022\072\016\073\072\094"), 
					Media = _i9L
				}
			}
		end
		_Hdh.Active = false
		_Hdh.Visible = false
		_cZge.Active = true
		_cZge.Visible = true
		_owd_ = _owd_ + 1
		_YY_u = _YY_u + 1
		_pISt2:RequestSync()
	elseif _JFh == 0 then
		_L0jA:MoveTo(nil)
		_haW()
		_Urwigo.Dialog(false, {
			{
				Text = _TQt("\069\001\022\072\016\022\001\022\015\103\082\087\127\072\022\023\023\086\043\082\086\073\090\020\001\049\082\076\022\078\015\082\111\127\100\062\082\009\086\082\077\127\001\049\029\100\073\072\049\029\122\082\050\086\082\078\001\049\111\082\111\127\023\023\082\090\072\023\073\022\016\082\100\062\049\009\082\077\001\073\009\082\086\073\090\001\082\078\022\001\120\073\082\062\090\023\023\094\082\083\049\001\049\020\029\082\022\082\062\073\023\073\078\022\001\016\082\111\127\100\062\082\086\073\090\001\082\120\022\023\022\078\100\127\078\082\078\001\049\016\127\100\029\094\082\063\062\022\072\015\029\094"), 
				Media = _vVXBt
			}, 
			{
				Text = _TQt("\007\073\090\082\022\001\049\082\077\127\072\022\023\023\086\082\001\049\022\016\086\082\100\073\082\062\049\022\016\082\100\073\082\035\049\029\029\049\023\082\076\086\082\073\030\049\072\127\072\120\082\022\082\062\086\030\049\001\029\030\022\078\049\082\001\073\090\100\049\082\100\062\073\090\120\062\082\100\062\049\082\126\127\020\035\023\022\022\100\022\082\067\023\090\029\100\049\001\094\082\037\049\078\022\090\029\049\082\073\077\082\100\062\049\082\062\086\030\049\001\029\030\022\078\049\082\049\077\077\049\078\100\043\082\086\073\090\082\073\072\023\086\082\062\022\075\049\082\095\082\009\127\072\090\100\049\029\043\082\068\057\082\029\049\078\073\072\016\029\082\100\073\082\120\049\100\082\100\073\082\126\127\020\035\023\022\022\100\022\082\067\023\090\029\100\049\001\082\022\072\016\082\100\062\049\072\082\073\072\082\100\073\082\035\049\029\029\049\023\094"), 
				Media = _XJV
			}, 
			{
				Text = _TQt("\113\077\082\086\073\090\082\016\073\072\020\100\082\100\073\082\009\022\015\049\082\127\100\082\100\073\082\035\049\029\029\049\023\082\127\072\082\095\082\009\127\072\090\100\049\029\043\082\068\057\082\029\049\078\073\072\016\029\043\082\100\062\049\082\062\086\030\049\001\029\030\022\078\049\082\100\090\072\072\049\023\082\111\127\023\023\082\078\073\023\023\022\030\029\049\082\022\072\016\082\086\073\090\082\111\127\023\023\082\072\049\049\016\082\100\073\082\001\049\100\090\001\072\082\062\049\001\049\082\100\073\082\001\049\055\078\001\049\022\100\049\082\100\062\049\082\062\086\030\049\001\029\030\022\078\049\082\100\090\072\072\049\023\094"), 
				Media = _dCuL
			}, 
			{
				Text = _TQt("\093\029\082\029\073\073\072\082\022\029\082\086\073\090\082\062\127\100\082\054\035\043\082\086\073\090\001\082\095\103\068\057\082\119\013\112\057\082\029\049\078\073\072\016\029\028\082\111\127\023\023\082\029\100\022\001\100\094\082\113\077\082\086\073\090\082\016\073\072\020\100\082\009\022\015\049\082\127\100\082\100\073\082\035\049\029\029\049\023\082\127\072\082\100\062\022\100\082\100\127\009\049\043\082\086\073\090\020\023\023\082\062\022\075\049\082\100\073\082\078\073\009\049\082\076\022\078\015\082\062\049\001\049\082\022\072\016\082\100\001\086\082\022\120\022\127\072\094"), 
				Media = _rlyi5
			}
		}, function(action)
			_Dlr:Start()
		end)
	else
		_haW()
		_Urwigo.Dialog(false, {
			{
				Text = _TQt("\007\073\090\082\022\001\049\082\001\049\022\016\086\082\100\073\082\100\001\086\082\022\120\022\127\072\082\120\049\100\100\127\072\120\082\100\073\082\035\049\029\029\049\023\082\076\086\082\073\030\049\072\127\072\120\082\022\082\062\086\030\049\001\029\030\022\078\049\082\001\073\090\100\049\082\100\062\073\090\120\062\082\100\062\049\082\126\127\020\035\023\022\022\100\022\082\067\023\090\029\100\049\001\094\082\037\049\078\022\090\029\049\082\073\077\082\100\062\049\082\062\086\030\049\001\029\030\022\078\049\082\049\077\077\049\078\100\043\082\086\073\090\082\073\072\023\086\082\062\022\075\049\082\095\082\009\127\072\090\100\049\029\043\082\068\057\082\029\049\078\073\072\016\029\082\100\073\082\120\049\100\082\100\073\082\126\127\020\035\023\022\022\100\022\082\067\023\090\029\100\049\001\082\022\072\016\082\100\062\049\072\082\073\072\082\100\073\082\035\049\029\029\049\023\094"), 
				Media = _XJV
			}, 
			{
				Text = _TQt("\113\077\082\086\073\090\082\016\073\072\020\100\082\100\073\082\009\022\015\049\082\127\100\082\100\073\082\035\049\029\029\049\023\082\127\072\082\095\082\009\127\072\090\100\049\029\043\082\068\057\082\029\049\078\073\072\016\029\043\082\100\062\049\082\062\086\030\049\001\029\030\022\078\049\082\100\090\072\072\049\023\082\111\127\023\023\082\078\073\023\023\022\030\029\049\082\022\072\016\082\086\073\090\082\111\127\023\023\082\072\049\049\016\082\100\073\082\001\049\100\090\001\072\082\062\049\001\049\082\100\073\082\001\049\055\078\001\049\022\100\049\082\100\062\049\082\062\086\030\049\001\029\030\022\078\049\082\100\090\072\072\049\023\094"), 
				Media = _dCuL
			}, 
			{
				Text = _TQt("\093\029\082\029\073\073\072\082\022\029\082\086\073\090\082\062\127\100\082\054\035\043\082\086\073\090\001\082\095\103\068\057\082\119\013\112\057\082\029\049\078\073\072\016\029\028\082\111\127\023\023\082\029\100\022\001\100\094\082\113\077\082\086\073\090\082\016\073\072\020\100\082\009\022\015\049\082\127\100\082\100\073\082\035\049\029\029\049\023\082\127\072\082\100\062\022\100\082\100\127\009\049\043\082\086\073\090\020\023\023\082\062\022\075\049\082\100\073\082\078\073\009\049\082\076\022\078\015\082\062\049\001\049\082\022\072\016\082\100\001\086\082\022\120\022\127\072\094"), 
				Media = _rlyi5
			}
		}, function(action)
			if _JFh < 3 then
				_Dlr:Start()
			end
		end)
	end
end
function _WpkR:OnEnter()
	_t2JFT = _TQt("\006\048\030\015\032")
	_mjjz.Active = true
	_mjjz.Visible = true
	_Urwigo.OldDialog{
		{
			Text = (_TQt("\007\073\090\082\049\072\100\049\001\082\100\062\049\082\062\086\030\049\001\029\030\022\078\049\082\100\090\072\072\049\023\082\100\073\082\035\049\029\029\049\023\094\082\007\073\090\082\009\090\029\100\082\083\024\032\032\007\082\100\073\082\120\049\100\082\100\073\082\035\049\029\029\049\023\043\082\086\073\090\082\073\072\023\086\082\062\022\075\049\082").._Dlr.Remaining).._TQt("\082\029\049\078\073\072\016\029\082\001\049\009\022\127\072\127\072\120\122\082\032\090\072\122"), 
			Media = _mSX
		}
	}
	_WpkR.Active = false
	_WpkR.Visible = false
end
function _mjjz:OnEnter()
	_t2JFT = _TQt("\006\009\116\116\056")
	_Dlr:Stop()
	_Urwigo.OldDialog{
		{
			Text = _TQt("\007\073\090\082\009\022\016\049\082\127\100\082\100\073\082\035\049\029\029\049\023\122\082\007\073\090\082\078\022\072\020\100\082\076\049\023\127\049\075\049\082\086\073\090\082\077\127\072\022\023\023\086\082\022\001\001\127\075\049\016\122\082\054\072\023\086\082\073\072\049\082\100\062\127\072\120\082\023\049\077\100\082\100\073\082\016\073\043\082\072\073\111\094\094\094"), 
			Media = _dCuL
		}, 
		{
			Text = _TQt("\069\073\082\077\127\072\016\082\100\062\049\082\120\023\127\100\100\049\001\029\100\127\009\082\029\030\127\078\049\082\119\120\049\073\078\022\078\062\049\028\082\022\100\082\109\037\032\041\066\092\057\082\013\112\094\095\057\061\082\048\057\112\068\082\057\108\094\092\112\061\094"), 
			Media = _F0mX
		}, 
		{
			Text = (_TQt("\007\073\090\082\078\073\009\030\023\049\100\049\016\082\100\062\049\082\035\049\029\029\049\023\082\032\090\072\082\127\072\082").._YY_u).._TQt("\082\030\022\001\029\049\078\029\122\082\088\023\049\022\029\049\082\127\072\078\023\090\016\049\082\062\073\111\082\009\022\072\086\082\030\022\001\029\049\078\029\082\127\100\082\100\073\073\015\082\086\073\090\082\127\072\082\086\073\090\001\082\077\073\090\072\016\082\023\073\120\094\082\109\037\032\041\007\073\090\082\078\022\072\082\077\127\072\016\082\086\073\090\001\082\078\073\009\030\023\049\100\127\073\072\082\078\073\016\049\043\082\100\062\049\082\078\073\073\001\016\127\072\022\100\049\029\043\082\022\072\016\082\022\082\062\127\072\100\082\076\086\082\022\078\100\127\075\022\100\127\072\120\082\100\062\049\082\062\073\023\073\078\001\073\072\082\086\073\090\082\111\127\023\023\082\072\073\111\082\077\127\072\016\082\127\072\082\086\073\090\001\082\127\072\075\049\072\100\073\001\086\094"), 
			Media = _XJV
		}, 
		{
			Text = _TQt("\063\062\022\072\015\029\082\077\073\001\082\030\023\022\086\127\072\120\082\063\062\049\082\035\049\029\029\049\023\082\032\090\072\094\082\048\049\082\062\073\030\049\082\086\073\090\082\062\022\016\082\077\090\072\122\082\017\072\116\073\086\082\100\062\049\082\001\049\029\100\082\073\077\082\100\062\049\082\126\088\093\067\017\082\095\057\108\013\082\029\049\001\127\049\029\082\022\072\016\082\078\062\049\078\015\082\090\029\082\073\090\100\082\073\072\023\127\072\049\082\022\100\082\126\030\022\078\049\067\022\078\062\127\072\120\094\073\001\120\094\109\037\032\041\082\125\072\076\029\030\034\125\072\076\029\030\034\125\072\076\029\030\034\055\055\063\062\049\082\126\030\022\078\049\082\067\001\049\111"), 
			Media = _Tnu4
		}
	}
	_pISt2.Complete = true
	_vxBxs:MoveTo(Player)
	_LyrF:MoveTo(Player)
	_mjjz.Active = false
	_mjjz.Visible = false
	_pISt2:RequestSync()
end
function _8teUN:OnTick()
	_Urwigo.OldDialog{
		{
			Text = _TQt("\054\062\082\072\073\122\082\007\073\090\001\082\100\127\009\049\082\111\127\072\016\073\111\082\062\022\029\082\049\046\030\127\001\049\016\082\022\072\016\082\086\073\090\001\082\062\086\030\049\001\029\030\022\078\049\082\100\090\072\072\049\023\082\062\022\029\082\078\073\023\023\022\030\029\049\016\122\082\007\073\090\020\023\023\082\072\049\049\016\082\100\073\082\001\049\100\090\001\072\082\100\073\082\030\023\022\072\049\100\082\087\073\001\009\073\029\082\100\073\082\001\049\022\100\100\049\009\030\100\082\022\082\062\086\030\049\001\029\030\022\078\049\082\030\022\029\029\022\120\049\094"), 
			Media = _fTI
		}
	}
	_v0OYZ.Active = true
	_v0OYZ.Visible = true
	_OEVB.Active = false
	_OEVB.Visible = false
	_Hdh.Active = false
	_Hdh.Visible = false
	_pISt2:RequestSync()
end
function _Dlr:OnTick()
	_Urwigo.OldDialog{
		{
			Text = _TQt("\037\086\082\100\062\049\082\126\022\001\023\022\078\078\020\029\082\100\073\073\100\062\122\082\007\073\090\001\082\100\127\009\049\082\111\127\072\016\073\111\082\049\046\030\127\001\049\016\082\022\072\016\082\086\073\090\001\082\062\086\030\049\001\029\030\022\078\049\082\100\090\072\072\049\023\082\078\073\023\023\022\030\029\049\016\122\082\032\049\100\090\001\072\082\100\073\082\032\022\072\016\073\072\082\100\073\082\001\049\073\030\049\072\082\022\082\062\086\030\049\001\029\030\022\078\049\082\100\090\072\072\049\023\082\022\072\016\082\100\001\086\082\022\120\022\127\072\094"), 
			Media = _fTI
		}
	}
	_Hdh.Active = true
	_Hdh.Visible = true
	_WpkR.Active = false
	_WpkR.Visible = false
	_mjjz.Active = false
	_mjjz.Visible = false
	_pISt2:RequestSync()
end
function _vxBxs:On_UD_Y(target)
	_Urwigo.Dialog(false, {
		{
			Text = _TQt("\007\073\090\082\022\078\100\127\075\022\100\049\082\100\062\049\082\062\073\023\073\078\001\073\072\082\022\072\016\082\100\062\049\082\120\022\100\049\015\049\049\030\049\001\082\077\023\022\001\049\029\082\100\073\082\023\127\077\049\122"), 
			Media = _Xkw
		}, 
		{
			Text = (((_TQt("\069\022\100\049\015\049\049\030\049\001\103\082\067\073\072\120\001\022\100\090\023\022\100\127\073\072\029\082\073\072\082\078\073\009\030\023\049\100\127\072\120\082\100\062\127\029\082\048\062\049\001\127\120\073\082\078\022\001\100\001\127\016\120\049\094\082\007\073\090\001\082\078\073\009\030\023\049\100\127\073\072\082\127\072\077\073\001\009\022\100\127\073\072\082\127\029\082\076\049\023\073\111\103\109\037\032\041\109\037\032\041\069\023\127\100\100\049\001\029\100\127\009\082\029\030\127\078\049\082\119\120\049\073\078\022\078\062\049\028\103\082\066\092\057\082\013\112\094\095\057\061\082\048\057\112\068\082\057\108\094\092\112\061\109\037\032\041\067\073\009\030\023\049\100\127\073\072\082\067\073\016\049\103\082")..string.sub(Player.CompletionCode, 1, 15)).._TQt("\109\037\032\041\007\073\090\082\078\073\009\030\023\049\100\049\016\082\127\072\103\082")).._YY_u).._TQt("\082\030\022\001\029\049\078\029\109\037\032\041\109\037\032\041\024\029\049\082\100\062\127\029\082\127\072\077\073\001\009\022\100\127\073\072\082\100\073\082\001\049\078\073\001\016\082\086\073\090\001\082\022\016\075\049\072\100\090\001\049\122"), 
			Media = _Xkw
		}, 
		{
			Text = _TQt("\063\062\049\082\062\073\023\073\078\001\073\072\082\120\022\100\049\015\049\049\030\049\001\082\016\127\029\022\030\030\049\022\001\029\082\076\022\078\015\082\127\072\100\073\082\100\062\049\082\062\073\023\073\078\001\073\072\082\022\029\082\100\062\049\082\016\049\075\127\078\049\082\029\062\090\100\029\082\073\077\077\094"), 
			Media = _7W_
		}
	}, function(action)
		if _vxBxs.Commands._aCcZ.Enabled == false then
			_vxBxs.Commands._aCcZ.Enabled = true
			_Urwigo.OldDialog{
				{
					Text = _TQt("\007\073\090\082\078\022\072\082\072\073\111\082\022\029\015\082\100\062\049\082\120\022\100\049\015\049\049\030\049\001\082\077\073\001\082\022\082\062\127\072\100\094"), 
					Media = _7W_
				}
			}
		end
	end)
end
function _vxBxs:On_aCcZ(target)
	_Urwigo.OldDialog{
		{
			Text = _TQt("\007\073\090\082\022\078\100\127\075\022\100\049\082\100\062\049\082\062\073\023\073\078\001\073\072\082\022\072\016\082\100\062\049\082\120\022\100\049\015\049\049\030\049\001\082\077\023\022\001\049\029\082\100\073\082\023\127\077\049\122"), 
			Media = _Xkw
		}, 
		{
			Text = _TQt("\007\073\090\082\022\029\015\082\100\062\049\082\120\022\100\049\015\049\049\030\049\001\082\077\073\001\082\022\082\062\127\072\100\094\082\093\077\100\049\001\082\078\073\072\029\127\016\049\001\127\072\120\082\086\073\090\001\082\001\049\025\090\049\029\100\043\082\100\062\049\082\120\022\100\049\015\049\049\030\049\001\082\029\022\086\029\043\082\085\007\073\090\082\111\127\023\023\082\077\127\072\016\082\100\062\049\082\078\022\078\062\049\082\127\072\082\022\082\029\100\073\072\049\082\120\049\073\030\127\023\049\094\085"), 
			Media = _Xkw
		}, 
		{
			Text = _TQt("\063\062\049\082\062\073\023\073\078\001\073\072\082\120\022\100\049\015\049\049\030\049\001\082\016\127\029\022\030\030\049\022\001\029\082\076\022\078\015\082\127\072\100\073\082\100\062\049\082\062\073\023\073\078\001\073\072\082\022\029\082\100\062\049\082\016\049\075\127\078\049\082\029\062\090\100\029\082\073\077\077\094"), 
			Media = _7W_
		}
	}
end

-- Urwigo functions --
function _lP08()
	if _Uw1o2 > 3 then
		--[[If player has been caught 3 times, give them a pass]]
		_xOz = false
		_yZX = false
		_8CQj = false
	else
		local _rndChoiceValue = math.random()
		if _rndChoiceValue < 0.333333333333333 then
			_xOz = true
			_yZX = false
			_8CQj = false
		elseif _rndChoiceValue < 0.666666666666667 then
			_xOz = false
			_yZX = true
			_8CQj = false
		else
			_xOz = false
			_yZX = false
			_8CQj = true
		end
	end
	_wzEz.Active = true
	_wzEz.Visible = true
	_KvYl.Active = true
	_KvYl.Visible = true
	_Toy.Active = true
	_Toy.Visible = true
	_pISt2:RequestSync()
end
function _lCEfP()
	_wzEz.Active = false
	_wzEz.Visible = false
	_KvYl.Active = false
	_KvYl.Visible = false
	_Toy.Active = false
	_Toy.Visible = false
	_v0OYZ.Active = true
	_v0OYZ.Visible = true
	_hRrO:MoveTo(nil)
	_pISt2:RequestSync()
end
function _rZt4()
	if _owd_ > 3 then
		--[[If player has been caught 3 times, give them a pass]]
		_HjsR = false
		_6_L46 = false
		_dhop = false
	else
		local _rndChoiceValue = math.random()
		if _rndChoiceValue < 0.333333333333333 then
			_HjsR = true
			_6_L46 = true
			_dhop = false
		elseif _rndChoiceValue < 0.666666666666667 then
			_HjsR = true
			_6_L46 = false
			_dhop = true
		else
			_HjsR = false
			_6_L46 = true
			_dhop = true
		end
	end
	_3VeQ.Active = true
	_3VeQ.Visible = true
	_fnoA7.Active = true
	_fnoA7.Visible = true
	_eKB.Active = true
	_eKB.Visible = true
	_pISt2:RequestSync()
end
function _3PSv0()
	_3VeQ.Active = false
	_3VeQ.Visible = false
	_fnoA7.Active = false
	_fnoA7.Visible = false
	_eKB.Active = false
	_eKB.Visible = false
	_Hdh.Active = true
	_Hdh.Visible = true
	_L0jA:MoveTo(nil)
	_pISt2:RequestSync()
end
function _6OES6()
	_pISt2:RequestSync()
	_YY_u = _YY_u + 1
	_GPM = _GPM + 1
	_v0OYZ.Visible = false
	_v0OYZ.Active = false
	_OEVB.Visible = true
	_OEVB.Active = true
end
function _haW()
	_pISt2:RequestSync()
	_YY_u = _YY_u + 1
	_JFh = _JFh + 1
	_WpkR.Visible = true
	_WpkR.Active = true
	_Hdh.Active = false
	_Hdh.Visible = false
end

-- Begin user functions --
-- End user functions --
return _pISt2
